## buildah-copy "1" "March 2017" "buildah"

## NAME
buildah copy - Copies the contents of a file, URL, or directory into a container's working directory.

## SYNOPSIS
**buildah** **copy** containerID **SRC** [[...] **DEST**]

## DESCRIPTION
Copies the contents of a file, URL, or a directory to a container's working
directory or a specified location in the container.  If a local directory is
specified as a source, its *contents* are copied to the destination.

## OPTIONS

**--chown** *owner*:*group*

Sets the user and group ownership of the destination content.

## EXAMPLE

buildah copy containerID '/myapp/app.conf' '/myapp/app.conf'

buildah copy --chown myuser:mygroup containerID '/myapp/app.conf' '/myapp/app.conf'

buildah copy containerID '/home/myuser/myproject.go'

buildah copy containerID '/home/myuser/myfiles.tar' '/tmp'

buildah copy containerID '/tmp/workingdir' '/tmp/workingdir'

buildah copy containerID 'https://github.com/projectatomic/buildah' '/tmp'

buildah copy containerID 'passwd' 'certs.d' /etc

## SEE ALSO
buildah(1)
