/* Mapping tables for TRANSSIBERIAN handling.
   Copyright (C) 1997, 1998, 1999, 2000 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Ulrich Drepper <drepper@cygnus.com>, 1997.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. 
   by: Salvador Sabanal, LinuxLab SAP AG <salvador.sabanal@sap.com>
   Date: Nov. 19, 1999
 */

#include <stdint.h>
#include <wchar.h>

static const uint16_t to_ucs4_single[256] =
{
  [   0] = 0x0000, [   1] = 0x0001, [   2] = 0x0002, [   3] = 0x0003,
  [   4] = 0x0004, [   5] = 0x0005, [   6] = 0x0006, [   7] = 0x0007,
  [   8] = 0x0008, [   9] = 0x0009, [  10] = 0x000A, [  11] = 0x000B,
  [  12] = 0x000C, [  13] = 0x000D, [  14] = 0x000E, [  15] = 0x000F,
  [  16] = 0x0010, [  17] = 0x0011, [  18] = 0x0012, [  19] = 0x0013,
  [  20] = 0x0014, [  21] = 0x0015, [  22] = 0x0016, [  23] = 0x0017,
  [  24] = 0x0018, [  25] = 0x0019, [  26] = 0x001A, [  27] = 0x001B,
  [  28] = 0x001C, [  29] = 0x001D, [  30] = 0x001E, [  31] = 0x001F,
  [  32] = 0x0020, [  33] = 0x0021, [  34] = 0x0022, [  35] = 0x0023,
  [  36] = 0x0024, [  37] = 0x0025, [  38] = 0x0026, [  39] = 0x0027,
  [  40] = 0x0028, [  41] = 0x0029, [  42] = 0x002A, [  43] = 0x002B,
  [  44] = 0x002C, [  45] = 0x002D, [  46] = 0x002E, [  47] = 0x002F,
  [  48] = 0x0030, [  49] = 0x0031, [  50] = 0x0032, [  51] = 0x0033,
  [  52] = 0x0034, [  53] = 0x0035, [  54] = 0x0036, [  55] = 0x0037,
  [  56] = 0x0038, [  57] = 0x0039, [  58] = 0x003A, [  59] = 0x003B,
  [  60] = 0x003C, [  61] = 0x003D, [  62] = 0x003E, [  63] = 0x003F,
  [  64] = 0x0040, [  65] = 0x0041, [  66] = 0x0042, [  67] = 0x0043,
  [  68] = 0x0044, [  69] = 0x0045, [  70] = 0x0046, [  71] = 0x0047,
  [  72] = 0x0048, [  73] = 0x0049, [  74] = 0x004A, [  75] = 0x004B,
  [  76] = 0x004C, [  77] = 0x004D, [  78] = 0x004E, [  79] = 0x004F,
  [  80] = 0x0050, [  81] = 0x0051, [  82] = 0x0052, [  83] = 0x0053,
  [  84] = 0x0054, [  85] = 0x0055, [  86] = 0x0056, [  87] = 0x0057,
  [  88] = 0x0058, [  89] = 0x0059, [  90] = 0x005A, [  91] = 0x005B,
  [  92] = 0x005C, [  93] = 0x005D, [  94] = 0x005E, [  95] = 0x005F,
  [  96] = 0x0060, [  97] = 0x0061, [  98] = 0x0062, [  99] = 0x0063,
  [ 100] = 0x0064, [ 101] = 0x0065, [ 102] = 0x0066, [ 103] = 0x0067,
  [ 104] = 0x0068, [ 105] = 0x0069, [ 106] = 0x006A, [ 107] = 0x006B,
  [ 108] = 0x006C, [ 109] = 0x006D, [ 110] = 0x006E, [ 111] = 0x006F,
  [ 112] = 0x0070, [ 113] = 0x0071, [ 114] = 0x0072, [ 115] = 0x0073,
  [ 116] = 0x0074, [ 117] = 0x0075, [ 118] = 0x0076, [ 119] = 0x0077,
  [ 120] = 0x0078, [ 121] = 0x0079, [ 122] = 0x007A, [ 123] = 0x007B,
  [ 124] = 0x007C, [ 125] = 0x007D, [ 126] = 0x007E, [ 127] = 0x007F,
  [ 160] = 0x00A0, [ 161] = 0x00A1, [ 162] = 0x00A2, [ 163] = 0x00A3,
  [ 164] = 0x00A4, [ 165] = 0x00A5, [ 166] = 0x00A6, [ 167] = 0x00A7,
  [ 168] = 0x00A8, [ 169] = 0x00A9, [ 170] = 0x00AA, [ 171] = 0x00AB,
  [ 172] = 0x00AC, [ 173] = 0x00AD, [ 174] = 0x00AE, [ 175] = 0x00AF,
  [ 176] = 0x00B0, [ 177] = 0x00B1, [ 178] = 0x00B2, [ 179] = 0x00B3,
  [ 180] = 0x00B4, [ 181] = 0x00B5, [ 182] = 0x00B6, [ 183] = 0x00B7,
  [ 184] = 0x00B8, [ 185] = 0x00B9, [ 186] = 0x00BA, [ 187] = 0x00BB,
  [ 188] = 0x00BC, [ 189] = 0x00BD, [ 190] = 0x00BE, [ 191] = 0x00BF,
  [ 192] = 0x00C0, [ 193] = 0x00C1, [ 194] = 0x00C2, [ 195] = 0x00C3,
  [ 196] = 0x00C4, [ 197] = 0x00C5, [ 198] = 0x00C6, [ 199] = 0x00C7,
  [ 200] = 0x00C8, [ 201] = 0x00C9, [ 202] = 0x00CA, [ 203] = 0x00CB,
  [ 204] = 0x00CC, [ 205] = 0x00CD, [ 206] = 0x00CE, [ 207] = 0x00CF,
  [ 208] = 0x00D0, [ 209] = 0x00D1, [ 210] = 0x00D2, [ 211] = 0x00D3,
  [ 212] = 0x00D4, [ 213] = 0x00D5, [ 214] = 0x00D6, [ 215] = 0x00D7,
  [ 216] = 0x00D8, [ 217] = 0x00D9, [ 218] = 0x00DA, [ 219] = 0x00DB,
  [ 220] = 0x00DC, [ 221] = 0x00DD, [ 222] = 0x00DE, [ 223] = 0x00DF,
  [ 224] = 0x00E0, [ 225] = 0x00E1, [ 226] = 0x00E2, [ 227] = 0x00E3,
  [ 228] = 0x00E4, [ 229] = 0x00E5, [ 230] = 0x00E6, [ 231] = 0x00E7,
  [ 232] = 0x00E8, [ 233] = 0x00E9, [ 234] = 0x00EA, [ 235] = 0x00EB,
  [ 236] = 0x00EC, [ 237] = 0x00ED, [ 238] = 0x00EE, [ 239] = 0x00EF,
  [ 240] = 0x00F0, [ 241] = 0x00F1, [ 242] = 0x00F2, [ 243] = 0x00F3,
  [ 244] = 0x00F4, [ 245] = 0x00F5, [ 246] = 0x00F6, [ 247] = 0x00F7,
  [ 248] = 0x00F8, [ 249] = 0x00F9, [ 250] = 0x00FA, [ 251] = 0x00FB,
  [ 252] = 0x00FC, [ 253] = 0x00FD, [ 254] = 0x00FE, [ 255] = 0x00FF
};

static const uint16_t to_ucs4_double[7871] =
{
  [   0] = 0x8140, [   1] = 0x8141, [   2] = 0x8142, [   3] = 0x8143,
  [   4] = 0x8144, [   5] = 0x8145, [   6] = 0x8146, [   7] = 0x8147,
  [   8] = 0x8148, [   9] = 0x8149, [  10] = 0x814A, [  11] = 0x814B,
  [  12] = 0x814C, [  13] = 0x814D, [  14] = 0x814E, [  15] = 0x814F,
  [  16] = 0x8150, [  17] = 0x8151, [  18] = 0x8152, [  19] = 0x8153,
  [  20] = 0x8154, [  21] = 0x8155, [  22] = 0x8156, [  23] = 0x8157,
  [  24] = 0x8158, [  25] = 0x8159, [  26] = 0x815A, [  27] = 0x815B,
  [  28] = 0x815C, [  29] = 0x815D, [  30] = 0x815E, [  31] = 0x815F,
  [  32] = 0x8160, [  33] = 0x8161, [  34] = 0x8162, [  35] = 0x8163,
  [  36] = 0x8164, [  37] = 0x8165, [  38] = 0x8166, [  39] = 0x8167,
  [  40] = 0x8168, [  41] = 0x8169, [  42] = 0x816A, [  43] = 0x816B,
  [  44] = 0x816C, [  45] = 0x816D, [  46] = 0x816E, [  47] = 0x816F,
  [  48] = 0x8170, [  49] = 0x8171, [  50] = 0x8172, [  51] = 0x8173,
  [  52] = 0x8174, [  53] = 0x8175, [  54] = 0x8176, [  55] = 0x8177,
  [  56] = 0x8178, [  57] = 0x8179, [  58] = 0x817A, [  59] = 0x817B,
  [  60] = 0x817C, [  61] = 0x817D, [  62] = 0x817E, [  64] = 0x8180,
  [  65] = 0x8181, [  66] = 0x8182, [  67] = 0x8183, [  68] = 0x8184,
  [  69] = 0x8185, [  70] = 0x8186, [  71] = 0x8187, [  72] = 0x8188,
  [  73] = 0x8189, [  74] = 0x818A, [  75] = 0x818B, [  76] = 0x818C,
  [  77] = 0x818D, [  78] = 0x818E, [  79] = 0x818F, [  80] = 0x8190,
  [  81] = 0x8191, [  82] = 0x8192, [  83] = 0x8193, [  84] = 0x8194,
  [  85] = 0x8195, [  86] = 0x8196, [  87] = 0x8197, [  88] = 0x8198,
  [  89] = 0x8199, [  90] = 0x819A, [  91] = 0x819B, [  92] = 0x819C,
  [  93] = 0x819D, [  94] = 0x819E, [  95] = 0x819F, [  96] = 0x81A0,
  [  97] = 0x81A1, [  98] = 0x81A2, [  99] = 0x81A3, [ 100] = 0x81A4,
  [ 101] = 0x81A5, [ 102] = 0x81A6, [ 103] = 0x81A7, [ 104] = 0x81A8,
  [ 105] = 0x81A9, [ 106] = 0x81AA, [ 107] = 0x81AB, [ 108] = 0x81AC,
  [ 109] = 0x81AD, [ 110] = 0x81AE, [ 111] = 0x81AF, [ 112] = 0x81B0,
  [ 113] = 0x81B1, [ 114] = 0x81B2, [ 115] = 0x81B3, [ 116] = 0x81B4,
  [ 117] = 0x81B5, [ 118] = 0x81B6, [ 119] = 0x81B7, [ 120] = 0x81B8,
  [ 121] = 0x81B9, [ 122] = 0x81BA, [ 123] = 0x81BB, [ 124] = 0x81BC,
  [ 125] = 0x81BD, [ 126] = 0x81BE, [ 127] = 0x81BF, [ 128] = 0x81C0,
  [ 129] = 0x81C1, [ 130] = 0x81C2, [ 131] = 0x81C3, [ 132] = 0x81C4,
  [ 133] = 0x81C5, [ 134] = 0x81C6, [ 135] = 0x81C7, [ 136] = 0x81C8,
  [ 137] = 0x81C9, [ 138] = 0x81CA, [ 139] = 0x81CB, [ 140] = 0x81CC,
  [ 141] = 0x81CD, [ 142] = 0x81CE, [ 143] = 0x81CF, [ 144] = 0x81D0,
  [ 145] = 0x81D1, [ 146] = 0x81D2, [ 147] = 0x81D3, [ 148] = 0x81D4,
  [ 149] = 0x81D5, [ 150] = 0x81D6, [ 151] = 0x81D7, [ 152] = 0x81D8,
  [ 153] = 0x81D9, [ 154] = 0x81DA, [ 155] = 0x81DB, [ 156] = 0x81DC,
  [ 157] = 0x81DD, [ 158] = 0x81DE, [ 159] = 0x81DF, [ 160] = 0x81E0,
  [ 161] = 0x81E1, [ 162] = 0x81E2, [ 163] = 0x81E3, [ 164] = 0x81E4,
  [ 165] = 0x81E5, [ 166] = 0x81E6, [ 167] = 0x81E7, [ 168] = 0x81E8,
  [ 169] = 0x81E9, [ 170] = 0x81EA, [ 171] = 0x81EB, [ 172] = 0x81EC,
  [ 173] = 0x81ED, [ 174] = 0x81EE, [ 175] = 0x81EF, [ 176] = 0x81F0,
  [ 177] = 0x81F1, [ 178] = 0x81F2, [ 179] = 0x81F3, [ 180] = 0x81F4,
  [ 181] = 0x81F5, [ 182] = 0x81F6, [ 183] = 0x81F7, [ 184] = 0x81F8,
  [ 185] = 0x81F9, [ 186] = 0x81FA, [ 187] = 0x81FB, [ 188] = 0x81FC,
  [ 189] = 0x81FD, [ 190] = 0x81FE, [ 256] = 0x8240, [ 257] = 0x8241,
  [ 258] = 0x8242, [ 259] = 0x8243, [ 260] = 0x8244, [ 261] = 0x8245,
  [ 262] = 0x8246, [ 263] = 0x8247, [ 264] = 0x8248, [ 265] = 0x8249,
  [ 266] = 0x824A, [ 267] = 0x824B, [ 268] = 0x824C, [ 269] = 0x824D,
  [ 270] = 0x824E, [ 271] = 0x824F, [ 272] = 0x8250, [ 273] = 0x8251,
  [ 274] = 0x8252, [ 275] = 0x8253, [ 276] = 0x8254, [ 277] = 0x8255,
  [ 278] = 0x8256, [ 279] = 0x8257, [ 280] = 0x8258, [ 281] = 0x8259,
  [ 282] = 0x825A, [ 283] = 0x825B, [ 284] = 0x825C, [ 285] = 0x825D,
  [ 286] = 0x825E, [ 287] = 0x825F, [ 288] = 0x8260, [ 289] = 0x8261,
  [ 290] = 0x8262, [ 291] = 0x8263, [ 292] = 0x8264, [ 293] = 0x8265,
  [ 294] = 0x8266, [ 295] = 0x8267, [ 296] = 0x8268, [ 297] = 0x8269,
  [ 298] = 0x826A, [ 299] = 0x826B, [ 300] = 0x826C, [ 301] = 0x826D,
  [ 302] = 0x826E, [ 303] = 0x826F, [ 304] = 0x8270, [ 305] = 0x8271,
  [ 306] = 0x8272, [ 307] = 0x8273, [ 308] = 0x8274, [ 309] = 0x8275,
  [ 310] = 0x8276, [ 311] = 0x8277, [ 312] = 0x8278, [ 313] = 0x8279,
  [ 314] = 0x827A, [ 315] = 0x827B, [ 316] = 0x827C, [ 317] = 0x827D,
  [ 318] = 0x827E, [ 320] = 0x8280, [ 321] = 0x8281, [ 322] = 0x8282,
  [ 323] = 0x8283, [ 324] = 0x8284, [ 325] = 0x8285, [ 326] = 0x8286,
  [ 327] = 0x8287, [ 328] = 0x8288, [ 329] = 0x8289, [ 330] = 0x828A,
  [ 331] = 0x828B, [ 332] = 0x828C, [ 333] = 0x828D, [ 334] = 0x828E,
  [ 335] = 0x828F, [ 336] = 0x8290, [ 337] = 0x8291, [ 338] = 0x8292,
  [ 339] = 0x8293, [ 340] = 0x8294, [ 341] = 0x8295, [ 342] = 0x8296,
  [ 343] = 0x8297, [ 344] = 0x8298, [ 345] = 0x8299, [ 346] = 0x829A,
  [ 347] = 0x829B, [ 348] = 0x829C, [ 349] = 0x829D, [ 350] = 0x829E,
  [ 351] = 0x829F, [ 352] = 0x82A0, [ 353] = 0x82A1, [ 354] = 0x82A2,
  [ 355] = 0x82A3, [ 356] = 0x82A4, [ 357] = 0x82A5, [ 358] = 0x82A6,
  [ 359] = 0x82A7, [ 360] = 0x82A8, [ 361] = 0x82A9, [ 362] = 0x82AA,
  [ 363] = 0x82AB, [ 364] = 0x82AC, [ 365] = 0x82AD, [ 366] = 0x82AE,
  [ 367] = 0x82AF, [ 368] = 0x82B0, [ 369] = 0x82B1, [ 370] = 0x82B2,
  [ 371] = 0x82B3, [ 372] = 0x82B4, [ 373] = 0x82B5, [ 374] = 0x82B6,
  [ 375] = 0x82B7, [ 376] = 0x82B8, [ 377] = 0x82B9, [ 378] = 0x82BA,
  [ 379] = 0x82BB, [ 380] = 0x82BC, [ 381] = 0x82BD, [ 382] = 0x82BE,
  [ 383] = 0x82BF, [ 384] = 0x82C0, [ 385] = 0x82C1, [ 386] = 0x82C2,
  [ 387] = 0x82C3, [ 388] = 0x82C4, [ 389] = 0x82C5, [ 390] = 0x82C6,
  [ 391] = 0x82C7, [ 392] = 0x82C8, [ 393] = 0x82C9, [ 394] = 0x82CA,
  [ 395] = 0x82CB, [ 396] = 0x82CC, [ 397] = 0x82CD, [ 398] = 0x82CE,
  [ 399] = 0x82CF, [ 400] = 0x82D0, [ 401] = 0x82D1, [ 402] = 0x82D2,
  [ 403] = 0x82D3, [ 404] = 0x82D4, [ 405] = 0x82D5, [ 406] = 0x82D6,
  [ 407] = 0x82D7, [ 408] = 0x82D8, [ 409] = 0x82D9, [ 410] = 0x82DA,
  [ 411] = 0x82DB, [ 412] = 0x82DC, [ 413] = 0x82DD, [ 414] = 0x82DE,
  [ 415] = 0x82DF, [ 416] = 0x82E0, [ 417] = 0x82E1, [ 418] = 0x82E2,
  [ 419] = 0x82E3, [ 420] = 0x82E4, [ 421] = 0x82E5, [ 422] = 0x82E6,
  [ 423] = 0x82E7, [ 424] = 0x82E8, [ 425] = 0x82E9, [ 426] = 0x82EA,
  [ 427] = 0x82EB, [ 428] = 0x82EC, [ 429] = 0x82ED, [ 430] = 0x82EE,
  [ 431] = 0x82EF, [ 432] = 0x82F0, [ 433] = 0x82F1, [ 434] = 0x82F2,
  [ 435] = 0x82F3, [ 436] = 0x82F4, [ 437] = 0x82F5, [ 438] = 0x82F6,
  [ 439] = 0x82F7, [ 440] = 0x82F8, [ 441] = 0x82F9, [ 442] = 0x82FA,
  [ 443] = 0x82FB, [ 444] = 0x82FC, [ 445] = 0x82FD, [ 446] = 0x82FE,
  [ 512] = 0x8340, [ 513] = 0x8341, [ 514] = 0x8342, [ 515] = 0x8343,
  [ 516] = 0x8344, [ 517] = 0x8345, [ 518] = 0x8346, [ 519] = 0x8347,
  [ 520] = 0x8348, [ 521] = 0x8349, [ 522] = 0x834A, [ 523] = 0x834B,
  [ 524] = 0x834C, [ 525] = 0x834D, [ 526] = 0x834E, [ 527] = 0x834F,
  [ 528] = 0x8350, [ 529] = 0x8351, [ 530] = 0x8352, [ 531] = 0x8353,
  [ 532] = 0x8354, [ 533] = 0x8355, [ 534] = 0x8356, [ 535] = 0x8357,
  [ 536] = 0x8358, [ 537] = 0x8359, [ 538] = 0x835A, [ 539] = 0x835B,
  [ 540] = 0x835C, [ 541] = 0x835D, [ 542] = 0x835E, [ 543] = 0x835F,
  [ 544] = 0x8360, [ 545] = 0x8361, [ 546] = 0x8362, [ 547] = 0x8363,
  [ 548] = 0x8364, [ 549] = 0x8365, [ 550] = 0x8366, [ 551] = 0x8367,
  [ 552] = 0x8368, [ 553] = 0x8369, [ 554] = 0x836A, [ 555] = 0x836B,
  [ 556] = 0x836C, [ 557] = 0x836D, [ 558] = 0x836E, [ 559] = 0x836F,
  [ 560] = 0x8370, [ 561] = 0x8371, [ 562] = 0x8372, [ 563] = 0x8373,
  [ 564] = 0x8374, [ 565] = 0x8375, [ 566] = 0x8376, [ 567] = 0x8377,
  [ 568] = 0x8378, [ 569] = 0x8379, [ 570] = 0x837A, [ 571] = 0x837B,
  [ 572] = 0x837C, [ 573] = 0x837D, [ 574] = 0x837E, [ 576] = 0x8380,
  [ 577] = 0x8381, [ 578] = 0x8382, [ 579] = 0x8383, [ 580] = 0x8384,
  [ 581] = 0x8385, [ 582] = 0x8386, [ 583] = 0x8387, [ 584] = 0x8388,
  [ 585] = 0x8389, [ 586] = 0x838A, [ 587] = 0x838B, [ 588] = 0x838C,
  [ 589] = 0x838D, [ 590] = 0x838E, [ 591] = 0x838F, [ 592] = 0x8390,
  [ 593] = 0x8391, [ 594] = 0x8392, [ 595] = 0x8393, [ 596] = 0x8394,
  [ 597] = 0x8395, [ 598] = 0x8396, [ 599] = 0x8397, [ 600] = 0x8398,
  [ 601] = 0x8399, [ 602] = 0x839A, [ 603] = 0x839B, [ 604] = 0x839C,
  [ 605] = 0x839D, [ 606] = 0x839E, [ 607] = 0x839F, [ 608] = 0x83A0,
  [ 609] = 0x83A1, [ 610] = 0x83A2, [ 611] = 0x83A3, [ 612] = 0x83A4,
  [ 613] = 0x83A5, [ 614] = 0x83A6, [ 615] = 0x83A7, [ 616] = 0x83A8,
  [ 617] = 0x83A9, [ 618] = 0x83AA, [ 619] = 0x83AB, [ 620] = 0x83AC,
  [ 621] = 0x83AD, [ 622] = 0x83AE, [ 623] = 0x83AF, [ 624] = 0x83B0,
  [ 625] = 0x83B1, [ 626] = 0x83B2, [ 627] = 0x83B3, [ 628] = 0x83B4,
  [ 629] = 0x83B5, [ 630] = 0x83B6, [ 631] = 0x83B7, [ 632] = 0x83B8,
  [ 633] = 0x83B9, [ 634] = 0x83BA, [ 635] = 0x83BB, [ 636] = 0x83BC,
  [ 637] = 0x83BD, [ 638] = 0x83BE, [ 639] = 0x83BF, [ 640] = 0x83C0,
  [ 641] = 0x83C1, [ 642] = 0x83C2, [ 643] = 0x83C3, [ 644] = 0x83C4,
  [ 645] = 0x83C5, [ 646] = 0x83C6, [ 647] = 0x83C7, [ 648] = 0x83C8,
  [ 649] = 0x83C9, [ 650] = 0x83CA, [ 651] = 0x83CB, [ 652] = 0x83CC,
  [ 653] = 0x83CD, [ 654] = 0x83CE, [ 655] = 0x83CF, [ 656] = 0x83D0,
  [ 657] = 0x83D1, [ 658] = 0x83D2, [ 659] = 0x83D3, [ 660] = 0x83D4,
  [ 661] = 0x83D5, [ 662] = 0x83D6, [ 663] = 0x83D7, [ 664] = 0x83D8,
  [ 665] = 0x83D9, [ 666] = 0x83DA, [ 667] = 0x83DB, [ 668] = 0x83DC,
  [ 669] = 0x83DD, [ 670] = 0x83DE, [ 671] = 0x83DF, [ 672] = 0x83E0,
  [ 673] = 0x83E1, [ 674] = 0x83E2, [ 675] = 0x83E3, [ 676] = 0x83E4,
  [ 677] = 0x83E5, [ 678] = 0x83E6, [ 679] = 0x83E7, [ 680] = 0x83E8,
  [ 681] = 0x83E9, [ 682] = 0x83EA, [ 683] = 0x83EB, [ 684] = 0x83EC,
  [ 685] = 0x83ED, [ 686] = 0x83EE, [ 687] = 0x83EF, [ 688] = 0x83F0,
  [ 689] = 0x83F1, [ 690] = 0x83F2, [ 691] = 0x83F3, [ 692] = 0x83F4,
  [ 693] = 0x83F5, [ 694] = 0x83F6, [ 695] = 0x83F7, [ 696] = 0x83F8,
  [ 697] = 0x83F9, [ 698] = 0x83FA, [ 699] = 0x83FB, [ 700] = 0x83FC,
  [ 701] = 0x83FD, [ 702] = 0x83FE, [ 768] = 0x8440, [ 769] = 0x8441,
  [ 770] = 0x8442, [ 771] = 0x8443, [ 772] = 0x8444, [ 773] = 0x8445,
  [ 774] = 0x8446, [ 775] = 0x8447, [ 776] = 0x8448, [ 777] = 0x8449,
  [ 778] = 0x844A, [ 779] = 0x844B, [ 780] = 0x844C, [ 781] = 0x844D,
  [ 782] = 0x844E, [ 783] = 0x844F, [ 784] = 0x8450, [ 785] = 0x8451,
  [ 786] = 0x8452, [ 787] = 0x8453, [ 788] = 0x8454, [ 789] = 0x8455,
  [ 790] = 0x8456, [ 791] = 0x8457, [ 792] = 0x8458, [ 793] = 0x8459,
  [ 794] = 0x845A, [ 795] = 0x845B, [ 796] = 0x845C, [ 797] = 0x845D,
  [ 798] = 0x845E, [ 799] = 0x845F, [ 800] = 0x8460, [ 801] = 0x8461,
  [ 802] = 0x8462, [ 803] = 0x8463, [ 804] = 0x8464, [ 805] = 0x8465,
  [ 806] = 0x8466, [ 807] = 0x8467, [ 808] = 0x8468, [ 809] = 0x8469,
  [ 810] = 0x846A, [ 811] = 0x846B, [ 812] = 0x846C, [ 813] = 0x846D,
  [ 814] = 0x846E, [ 815] = 0x846F, [ 816] = 0x8470, [ 817] = 0x8471,
  [ 818] = 0x8472, [ 819] = 0x8473, [ 820] = 0x8474, [ 821] = 0x8475,
  [ 822] = 0x8476, [ 823] = 0x8477, [ 824] = 0x8478, [ 825] = 0x8479,
  [ 826] = 0x847A, [ 827] = 0x847B, [ 828] = 0x847C, [ 829] = 0x847D,
  [ 830] = 0x847E, [ 832] = 0x8480, [ 833] = 0x8481, [ 834] = 0x8482,
  [ 835] = 0x8483, [ 836] = 0x8484, [ 837] = 0x8485, [ 838] = 0x8486,
  [ 839] = 0x8487, [ 840] = 0x8488, [ 841] = 0x8489, [ 842] = 0x848A,
  [ 843] = 0x848B, [ 844] = 0x848C, [ 845] = 0x848D, [ 846] = 0x848E,
  [ 847] = 0x848F, [ 848] = 0x8490, [ 849] = 0x8491, [ 850] = 0x8492,
  [ 851] = 0x8493, [ 852] = 0x8494, [ 853] = 0x8495, [ 854] = 0x8496,
  [ 855] = 0x8497, [ 856] = 0x8498, [ 857] = 0x8499, [ 858] = 0x849A,
  [ 859] = 0x849B, [ 860] = 0x849C, [ 861] = 0x849D, [ 862] = 0x849E,
  [ 863] = 0x849F, [ 864] = 0x84A0, [ 865] = 0x84A1, [ 866] = 0x84A2,
  [ 867] = 0x84A3, [ 868] = 0x84A4, [ 869] = 0x84A5, [ 870] = 0x84A6,
  [ 871] = 0x84A7, [ 872] = 0x84A8, [ 873] = 0x84A9, [ 874] = 0x84AA,
  [ 875] = 0x84AB, [ 876] = 0x84AC, [ 877] = 0x84AD, [ 878] = 0x84AE,
  [ 879] = 0x84AF, [ 880] = 0x84B0, [ 881] = 0x84B1, [ 882] = 0x84B2,
  [ 883] = 0x84B3, [ 884] = 0x84B4, [ 885] = 0x84B5, [ 886] = 0x84B6,
  [ 887] = 0x84B7, [ 888] = 0x84B8, [ 889] = 0x84B9, [ 890] = 0x84BA,
  [ 891] = 0x84BB, [ 892] = 0x84BC, [ 893] = 0x84BD, [ 894] = 0x84BE,
  [ 895] = 0x84BF, [ 896] = 0x84C0, [ 897] = 0x84C1, [ 898] = 0x84C2,
  [ 899] = 0x84C3, [ 900] = 0x84C4, [ 901] = 0x84C5, [ 902] = 0x84C6,
  [ 903] = 0x84C7, [ 904] = 0x84C8, [ 905] = 0x84C9, [ 906] = 0x84CA,
  [ 907] = 0x84CB, [ 908] = 0x84CC, [ 909] = 0x84CD, [ 910] = 0x84CE,
  [ 911] = 0x84CF, [ 912] = 0x84D0, [ 913] = 0x84D1, [ 914] = 0x84D2,
  [ 915] = 0x84D3, [ 916] = 0x84D4, [ 917] = 0x84D5, [ 918] = 0x84D6,
  [ 919] = 0x84D7, [ 920] = 0x84D8, [ 921] = 0x84D9, [ 922] = 0x84DA,
  [ 923] = 0x84DB, [ 924] = 0x84DC, [ 925] = 0x84DD, [ 926] = 0x84DE,
  [ 927] = 0x84DF, [ 928] = 0x84E0, [ 929] = 0x84E1, [ 930] = 0x84E2,
  [ 931] = 0x84E3, [ 932] = 0x84E4, [ 933] = 0x84E5, [ 934] = 0x84E6,
  [ 935] = 0x84E7, [ 936] = 0x84E8, [ 937] = 0x84E9, [ 938] = 0x84EA,
  [ 939] = 0x84EB, [ 940] = 0x84EC, [ 941] = 0x84ED, [ 942] = 0x84EE,
  [ 943] = 0x84EF, [ 944] = 0x84F0, [ 945] = 0x84F1, [ 946] = 0x84F2,
  [ 947] = 0x84F3, [ 948] = 0x84F4, [ 949] = 0x84F5, [ 950] = 0x84F6,
  [ 951] = 0x84F7, [ 952] = 0x84F8, [ 953] = 0x84F9, [ 954] = 0x84FA,
  [ 955] = 0x84FB, [ 956] = 0x84FC, [ 957] = 0x84FD, [ 958] = 0x84FE,
  [1024] = 0x8540, [1025] = 0x8541, [1026] = 0x8542, [1027] = 0x8543,
  [1028] = 0x8544, [1029] = 0x8545, [1030] = 0x8546, [1031] = 0x8547,
  [1032] = 0x8548, [1033] = 0x8549, [1034] = 0x854A, [1035] = 0x854B,
  [1036] = 0x854C, [1037] = 0x854D, [1038] = 0x854E, [1039] = 0x854F,
  [1040] = 0x8550, [1041] = 0x8551, [1042] = 0x8552, [1043] = 0x8553,
  [1044] = 0x8554, [1045] = 0x8555, [1046] = 0x8556, [1047] = 0x8557,
  [1048] = 0x8558, [1049] = 0x8559, [1050] = 0x855A, [1051] = 0x855B,
  [1052] = 0x855C, [1053] = 0x855D, [1054] = 0x855E, [1055] = 0x855F,
  [1056] = 0x8560, [1057] = 0x8561, [1058] = 0x8562, [1059] = 0x8563,
  [1060] = 0x8564, [1061] = 0x8565, [1062] = 0x8566, [1063] = 0x8567,
  [1064] = 0x8568, [1065] = 0x8569, [1066] = 0x856A, [1067] = 0x856B,
  [1068] = 0x856C, [1069] = 0x856D, [1070] = 0x856E, [1071] = 0x856F,
  [1072] = 0x8570, [1073] = 0x8571, [1074] = 0x8572, [1075] = 0x8573,
  [1076] = 0x8574, [1077] = 0x8575, [1078] = 0x8576, [1079] = 0x8577,
  [1080] = 0x8578, [1081] = 0x8579, [1082] = 0x857A, [1083] = 0x857B,
  [1084] = 0x857C, [1085] = 0x857D, [1086] = 0x857E, [1088] = 0x8580,
  [1089] = 0x8581, [1090] = 0x8582, [1091] = 0x8583, [1092] = 0x8584,
  [1093] = 0x8585, [1094] = 0x8586, [1095] = 0x8587, [1096] = 0x8588,
  [1097] = 0x8589, [1098] = 0x858A, [1099] = 0x858B, [1100] = 0x858C,
  [1101] = 0x858D, [1102] = 0x858E, [1103] = 0x858F, [1104] = 0x8590,
  [1105] = 0x8591, [1106] = 0x8592, [1107] = 0x8593, [1108] = 0x8594,
  [1109] = 0x8595, [1110] = 0x8596, [1111] = 0x8597, [1112] = 0x8598,
  [1113] = 0x8599, [1114] = 0x859A, [1115] = 0x859B, [1116] = 0x859C,
  [1117] = 0x859D, [1118] = 0x859E, [1119] = 0x859F, [1120] = 0x85A0,
  [1121] = 0x85A1, [1122] = 0x85A2, [1123] = 0x85A3, [1124] = 0x85A4,
  [1125] = 0x85A5, [1126] = 0x85A6, [1127] = 0x85A7, [1128] = 0x85A8,
  [1129] = 0x85A9, [1130] = 0x85AA, [1131] = 0x85AB, [1132] = 0x85AC,
  [1133] = 0x85AD, [1134] = 0x85AE, [1135] = 0x85AF, [1136] = 0x85B0,
  [1137] = 0x85B1, [1138] = 0x85B2, [1139] = 0x85B3, [1140] = 0x85B4,
  [1141] = 0x85B5, [1142] = 0x85B6, [1143] = 0x85B7, [1144] = 0x85B8,
  [1145] = 0x85B9, [1146] = 0x85BA, [1147] = 0x85BB, [1148] = 0x85BC,
  [1149] = 0x85BD, [1150] = 0x85BE, [1151] = 0x85BF, [1152] = 0x85C0,
  [1153] = 0x85C1, [1154] = 0x85C2, [1155] = 0x85C3, [1156] = 0x85C4,
  [1157] = 0x85C5, [1158] = 0x85C6, [1159] = 0x85C7, [1160] = 0x85C8,
  [1161] = 0x85C9, [1162] = 0x85CA, [1163] = 0x85CB, [1164] = 0x85CC,
  [1165] = 0x85CD, [1166] = 0x85CE, [1167] = 0x85CF, [1168] = 0x85D0,
  [1169] = 0x85D1, [1170] = 0x85D2, [1171] = 0x85D3, [1172] = 0x85D4,
  [1173] = 0x85D5, [1174] = 0x85D6, [1175] = 0x85D7, [1176] = 0x85D8,
  [1177] = 0x85D9, [1178] = 0x85DA, [1179] = 0x85DB, [1180] = 0x85DC,
  [1181] = 0x85DD, [1182] = 0x85DE, [1183] = 0x85DF, [1184] = 0x85E0,
  [1185] = 0x85E1, [1186] = 0x85E2, [1187] = 0x85E3, [1188] = 0x85E4,
  [1189] = 0x85E5, [1190] = 0x85E6, [1191] = 0x85E7, [1192] = 0x85E8,
  [1193] = 0x85E9, [1194] = 0x85EA, [1195] = 0x85EB, [1196] = 0x85EC,
  [1197] = 0x85ED, [1198] = 0x85EE, [1199] = 0x85EF, [1200] = 0x85F0,
  [1201] = 0x85F1, [1202] = 0x85F2, [1203] = 0x85F3, [1204] = 0x85F4,
  [1205] = 0x85F5, [1206] = 0x85F6, [1207] = 0x85F7, [1208] = 0x85F8,
  [1209] = 0x85F9, [1210] = 0x85FA, [1211] = 0x85FB, [1212] = 0x85FC,
  [1213] = 0x85FD, [1214] = 0x85FE, [1280] = 0x8640, [1281] = 0x8641,
  [1282] = 0x8642, [1283] = 0x8643, [1284] = 0x8644, [1285] = 0x8645,
  [1286] = 0x8646, [1287] = 0x8647, [1288] = 0x8648, [1289] = 0x8649,
  [1290] = 0x864A, [1291] = 0x864B, [1292] = 0x864C, [1293] = 0x864D,
  [1294] = 0x864E, [1295] = 0x864F, [1296] = 0x8650, [1297] = 0x8651,
  [1298] = 0x8652, [1299] = 0x8653, [1300] = 0x8654, [1301] = 0x8655,
  [1302] = 0x8656, [1303] = 0x8657, [1304] = 0x8658, [1305] = 0x8659,
  [1306] = 0x865A, [1307] = 0x865B, [1308] = 0x865C, [1309] = 0x865D,
  [1310] = 0x865E, [1311] = 0x865F, [1312] = 0x8660, [1313] = 0x8661,
  [1314] = 0x8662, [1315] = 0x8663, [1316] = 0x8664, [1317] = 0x8665,
  [1318] = 0x8666, [1319] = 0x8667, [1320] = 0x8668, [1321] = 0x8669,
  [1322] = 0x866A, [1323] = 0x866B, [1324] = 0x866C, [1325] = 0x866D,
  [1326] = 0x866E, [1327] = 0x866F, [1328] = 0x8670, [1329] = 0x8671,
  [1330] = 0x8672, [1331] = 0x8673, [1332] = 0x8674, [1333] = 0x8675,
  [1334] = 0x8676, [1335] = 0x8677, [1336] = 0x8678, [1337] = 0x8679,
  [1338] = 0x867A, [1339] = 0x867B, [1340] = 0x867C, [1341] = 0x867D,
  [1342] = 0x867E, [1344] = 0x8680, [1345] = 0x8681, [1346] = 0x8682,
  [1347] = 0x8683, [1348] = 0x8684, [1349] = 0x8685, [1350] = 0x8686,
  [1351] = 0x8687, [1352] = 0x8688, [1353] = 0x8689, [1354] = 0x868A,
  [1355] = 0x868B, [1356] = 0x868C, [1357] = 0x868D, [1358] = 0x868E,
  [1359] = 0x868F, [1360] = 0x8690, [1361] = 0x8691, [1362] = 0x8692,
  [1363] = 0x8693, [1364] = 0x8694, [1365] = 0x8695, [1366] = 0x8696,
  [1367] = 0x8697, [1368] = 0x8698, [1369] = 0x8699, [1370] = 0x869A,
  [1371] = 0x869B, [1372] = 0x869C, [1373] = 0x869D, [1374] = 0x869E,
  [1375] = 0x869F, [1376] = 0x86A0, [1377] = 0x86A1, [1378] = 0x86A2,
  [1379] = 0x86A3, [1380] = 0x86A4, [1381] = 0x86A5, [1382] = 0x86A6,
  [1383] = 0x86A7, [1384] = 0x86A8, [1385] = 0x86A9, [1386] = 0x86AA,
  [1387] = 0x86AB, [1388] = 0x86AC, [1389] = 0x86AD, [1390] = 0x86AE,
  [1391] = 0x86AF, [1392] = 0x86B0, [1393] = 0x86B1, [1394] = 0x86B2,
  [1395] = 0x86B3, [1396] = 0x86B4, [1397] = 0x86B5, [1398] = 0x86B6,
  [1399] = 0x86B7, [1400] = 0x86B8, [1401] = 0x86B9, [1402] = 0x86BA,
  [1403] = 0x86BB, [1404] = 0x86BC, [1405] = 0x86BD, [1406] = 0x86BE,
  [1407] = 0x86BF, [1408] = 0x86C0, [1409] = 0x86C1, [1410] = 0x86C2,
  [1411] = 0x86C3, [1412] = 0x86C4, [1413] = 0x86C5, [1414] = 0x86C6,
  [1415] = 0x86C7, [1416] = 0x86C8, [1417] = 0x86C9, [1418] = 0x86CA,
  [1419] = 0x86CB, [1420] = 0x86CC, [1421] = 0x86CD, [1422] = 0x86CE,
  [1423] = 0x86CF, [1424] = 0x86D0, [1425] = 0x86D1, [1426] = 0x86D2,
  [1427] = 0x86D3, [1428] = 0x86D4, [1429] = 0x86D5, [1430] = 0x86D6,
  [1431] = 0x86D7, [1432] = 0x86D8, [1433] = 0x86D9, [1434] = 0x86DA,
  [1435] = 0x86DB, [1436] = 0x86DC, [1437] = 0x86DD, [1438] = 0x86DE,
  [1439] = 0x86DF, [1440] = 0x86E0, [1441] = 0x86E1, [1442] = 0x86E2,
  [1443] = 0x86E3, [1444] = 0x86E4, [1445] = 0x86E5, [1446] = 0x86E6,
  [1447] = 0x86E7, [1448] = 0x86E8, [1449] = 0x86E9, [1450] = 0x86EA,
  [1451] = 0x86EB, [1452] = 0x86EC, [1453] = 0x86ED, [1454] = 0x86EE,
  [1455] = 0x86EF, [1456] = 0x86F0, [1457] = 0x86F1, [1458] = 0x86F2,
  [1459] = 0x86F3, [1460] = 0x86F4, [1461] = 0x86F5, [1462] = 0x86F6,
  [1463] = 0x86F7, [1464] = 0x86F8, [1465] = 0x86F9, [1466] = 0x86FA,
  [1467] = 0x86FB, [1468] = 0x86FC, [1469] = 0x86FD, [1470] = 0x86FE,
  [1536] = 0x8740, [1537] = 0x8741, [1538] = 0x8742, [1539] = 0x8743,
  [1540] = 0x8744, [1541] = 0x8745, [1542] = 0x8746, [1543] = 0x8747,
  [1544] = 0x8748, [1545] = 0x8749, [1546] = 0x874A, [1547] = 0x874B,
  [1548] = 0x874C, [1549] = 0x874D, [1550] = 0x874E, [1551] = 0x874F,
  [1552] = 0x8750, [1553] = 0x8751, [1554] = 0x8752, [1555] = 0x8753,
  [1556] = 0x8754, [1557] = 0x8755, [1558] = 0x8756, [1559] = 0x8757,
  [1560] = 0x8758, [1561] = 0x8759, [1562] = 0x875A, [1563] = 0x875B,
  [1564] = 0x875C, [1565] = 0x875D, [1566] = 0x875E, [1567] = 0x875F,
  [1568] = 0x8760, [1569] = 0x8761, [1570] = 0x8762, [1571] = 0x8763,
  [1572] = 0x8764, [1573] = 0x8765, [1574] = 0x8766, [1575] = 0x8767,
  [1576] = 0x8768, [1577] = 0x8769, [1578] = 0x876A, [1579] = 0x876B,
  [1580] = 0x876C, [1581] = 0x876D, [1582] = 0x876E, [1583] = 0x876F,
  [1584] = 0x8770, [1585] = 0x8771, [1586] = 0x8772, [1587] = 0x8773,
  [1588] = 0x8774, [1589] = 0x8775, [1590] = 0x8776, [1591] = 0x8777,
  [1592] = 0x8778, [1593] = 0x8779, [1594] = 0x877A, [1595] = 0x877B,
  [1596] = 0x877C, [1597] = 0x877D, [1598] = 0x877E, [1600] = 0x8780,
  [1601] = 0x8781, [1602] = 0x8782, [1603] = 0x8783, [1604] = 0x8784,
  [1605] = 0x8785, [1606] = 0x8786, [1607] = 0x8787, [1608] = 0x8788,
  [1609] = 0x8789, [1610] = 0x878A, [1611] = 0x878B, [1612] = 0x878C,
  [1613] = 0x878D, [1614] = 0x878E, [1615] = 0x878F, [1616] = 0x8790,
  [1617] = 0x8791, [1618] = 0x8792, [1619] = 0x8793, [1620] = 0x8794,
  [1621] = 0x8795, [1622] = 0x8796, [1623] = 0x8797, [1624] = 0x8798,
  [1625] = 0x8799, [1626] = 0x879A, [1627] = 0x879B, [1628] = 0x879C,
  [1629] = 0x879D, [1630] = 0x879E, [1631] = 0x879F, [1632] = 0x87A0,
  [1633] = 0x87A1, [1634] = 0x87A2, [1635] = 0x87A3, [1636] = 0x87A4,
  [1637] = 0x87A5, [1638] = 0x87A6, [1639] = 0x87A7, [1640] = 0x87A8,
  [1641] = 0x87A9, [1642] = 0x87AA, [1643] = 0x87AB, [1644] = 0x87AC,
  [1645] = 0x87AD, [1646] = 0x87AE, [1647] = 0x87AF, [1648] = 0x87B0,
  [1649] = 0x87B1, [1650] = 0x87B2, [1651] = 0x87B3, [1652] = 0x87B4,
  [1653] = 0x87B5, [1654] = 0x87B6, [1655] = 0x87B7, [1656] = 0x87B8,
  [1657] = 0x87B9, [1658] = 0x87BA, [1659] = 0x87BB, [1660] = 0x87BC,
  [1661] = 0x87BD, [1662] = 0x87BE, [1663] = 0x87BF, [1664] = 0x87C0,
  [1665] = 0x87C1, [1666] = 0x87C2, [1667] = 0x87C3, [1668] = 0x87C4,
  [1669] = 0x87C5, [1670] = 0x87C6, [1671] = 0x87C7, [1672] = 0x87C8,
  [1673] = 0x87C9, [1674] = 0x87CA, [1675] = 0x87CB, [1676] = 0x87CC,
  [1677] = 0x87CD, [1678] = 0x87CE, [1679] = 0x87CF, [1680] = 0x87D0,
  [1681] = 0x87D1, [1682] = 0x87D2, [1683] = 0x87D3, [1684] = 0x87D4,
  [1685] = 0x87D5, [1686] = 0x87D6, [1687] = 0x87D7, [1688] = 0x87D8,
  [1689] = 0x87D9, [1690] = 0x87DA, [1691] = 0x87DB, [1692] = 0x87DC,
  [1693] = 0x87DD, [1694] = 0x87DE, [1695] = 0x87DF, [1696] = 0x87E0,
  [1697] = 0x87E1, [1698] = 0x87E2, [1699] = 0x87E3, [1700] = 0x87E4,
  [1701] = 0x87E5, [1702] = 0x87E6, [1703] = 0x87E7, [1704] = 0x87E8,
  [1705] = 0x87E9, [1706] = 0x87EA, [1707] = 0x87EB, [1708] = 0x87EC,
  [1709] = 0x87ED, [1710] = 0x87EE, [1711] = 0x87EF, [1712] = 0x87F0,
  [1713] = 0x87F1, [1714] = 0x87F2, [1715] = 0x87F3, [1716] = 0x87F4,
  [1717] = 0x87F5, [1718] = 0x87F6, [1719] = 0x87F7, [1720] = 0x87F8,
  [1721] = 0x87F9, [1722] = 0x87FA, [1723] = 0x87FB, [1724] = 0x87FC,
  [1725] = 0x87FD, [1726] = 0x87FE, [1792] = 0x8840, [1793] = 0x8841,
  [1794] = 0x8842, [1795] = 0x8843, [1796] = 0x8844, [1797] = 0x8845,
  [1798] = 0x8846, [1799] = 0x8847, [1800] = 0x8848, [1801] = 0x8849,
  [1802] = 0x884A, [1803] = 0x884B, [1804] = 0x884C, [1805] = 0x884D,
  [1806] = 0x884E, [1807] = 0x884F, [1808] = 0x8850, [1809] = 0x8851,
  [1810] = 0x8852, [1811] = 0x8853, [1812] = 0x8854, [1813] = 0x8855,
  [1814] = 0x8856, [1815] = 0x8857, [1816] = 0x8858, [1817] = 0x8859,
  [1818] = 0x885A, [1819] = 0x885B, [1820] = 0x885C, [1821] = 0x885D,
  [1822] = 0x885E, [1823] = 0x885F, [1824] = 0x8860, [1825] = 0x8861,
  [1826] = 0x8862, [1827] = 0x8863, [1828] = 0x8864, [1829] = 0x8865,
  [1830] = 0x8866, [1831] = 0x8867, [1832] = 0x8868, [1833] = 0x8869,
  [1834] = 0x886A, [1835] = 0x886B, [1836] = 0x886C, [1837] = 0x886D,
  [1838] = 0x886E, [1839] = 0x886F, [1840] = 0x8870, [1841] = 0x8871,
  [1842] = 0x8872, [1843] = 0x8873, [1844] = 0x8874, [1845] = 0x8875,
  [1846] = 0x8876, [1847] = 0x8877, [1848] = 0x8878, [1849] = 0x8879,
  [1850] = 0x887A, [1851] = 0x887B, [1852] = 0x887C, [1853] = 0x887D,
  [1854] = 0x887E, [1856] = 0x8880, [1857] = 0x8881, [1858] = 0x8882,
  [1859] = 0x8883, [1860] = 0x8884, [1861] = 0x8885, [1862] = 0x8886,
  [1863] = 0x8887, [1864] = 0x8888, [1865] = 0x8889, [1866] = 0x888A,
  [1867] = 0x888B, [1868] = 0x888C, [1869] = 0x888D, [1870] = 0x888E,
  [1871] = 0x888F, [1872] = 0x8890, [1873] = 0x8891, [1874] = 0x8892,
  [1875] = 0x8893, [1876] = 0x8894, [1877] = 0x8895, [1878] = 0x8896,
  [1879] = 0x8897, [1880] = 0x8898, [1881] = 0x8899, [1882] = 0x889A,
  [1883] = 0x889B, [1884] = 0x889C, [1885] = 0x889D, [1886] = 0x889E,
  [1887] = 0x889F, [1888] = 0x88A0, [1889] = 0x88A1, [1890] = 0x88A2,
  [1891] = 0x88A3, [1892] = 0x88A4, [1893] = 0x88A5, [1894] = 0x88A6,
  [1895] = 0x88A7, [1896] = 0x88A8, [1897] = 0x88A9, [1898] = 0x88AA,
  [1899] = 0x88AB, [1900] = 0x88AC, [1901] = 0x88AD, [1902] = 0x88AE,
  [1903] = 0x88AF, [1904] = 0x88B0, [1905] = 0x88B1, [1906] = 0x88B2,
  [1907] = 0x88B3, [1908] = 0x88B4, [1909] = 0x88B5, [1910] = 0x88B6,
  [1911] = 0x88B7, [1912] = 0x88B8, [1913] = 0x88B9, [1914] = 0x88BA,
  [1915] = 0x88BB, [1916] = 0x88BC, [1917] = 0x88BD, [1918] = 0x88BE,
  [1919] = 0x88BF, [1920] = 0x88C0, [1921] = 0x88C1, [1922] = 0x88C2,
  [1923] = 0x88C3, [1924] = 0x88C4, [1925] = 0x88C5, [1926] = 0x88C6,
  [1927] = 0x88C7, [1928] = 0x88C8, [1929] = 0x88C9, [1930] = 0x88CA,
  [1931] = 0x88CB, [1932] = 0x88CC, [1933] = 0x88CD, [1934] = 0x88CE,
  [1935] = 0x88CF, [1936] = 0x88D0, [1937] = 0x88D1, [1938] = 0x88D2,
  [1939] = 0x88D3, [1940] = 0x88D4, [1941] = 0x88D5, [1942] = 0x88D6,
  [1943] = 0x88D7, [1944] = 0x88D8, [1945] = 0x88D9, [1946] = 0x88DA,
  [1947] = 0x88DB, [1948] = 0x88DC, [1949] = 0x88DD, [1950] = 0x88DE,
  [1951] = 0x88DF, [1952] = 0x88E0, [1953] = 0x88E1, [1954] = 0x88E2,
  [1955] = 0x88E3, [1956] = 0x88E4, [1957] = 0x88E5, [1958] = 0x88E6,
  [1959] = 0x88E7, [1960] = 0x88E8, [1961] = 0x88E9, [1962] = 0x88EA,
  [1963] = 0x88EB, [1964] = 0x88EC, [1965] = 0x88ED, [1966] = 0x88EE,
  [1967] = 0x88EF, [1968] = 0x88F0, [1969] = 0x88F1, [1970] = 0x88F2,
  [1971] = 0x88F3, [1972] = 0x88F4, [1973] = 0x88F5, [1974] = 0x88F6,
  [1975] = 0x88F7, [1976] = 0x88F8, [1977] = 0x88F9, [1978] = 0x88FA,
  [1979] = 0x88FB, [1980] = 0x88FC, [1981] = 0x88FD, [1982] = 0x88FE,
  [2048] = 0x8940, [2049] = 0x8941, [2050] = 0x8942, [2051] = 0x8943,
  [2052] = 0x8944, [2053] = 0x8945, [2054] = 0x8946, [2055] = 0x8947,
  [2056] = 0x8948, [2057] = 0x8949, [2058] = 0x894A, [2059] = 0x894B,
  [2060] = 0x894C, [2061] = 0x894D, [2062] = 0x894E, [2063] = 0x894F,
  [2064] = 0x8950, [2065] = 0x8951, [2066] = 0x8952, [2067] = 0x8953,
  [2068] = 0x8954, [2069] = 0x8955, [2070] = 0x8956, [2071] = 0x8957,
  [2072] = 0x8958, [2073] = 0x8959, [2074] = 0x895A, [2075] = 0x895B,
  [2076] = 0x895C, [2077] = 0x895D, [2078] = 0x895E, [2079] = 0x895F,
  [2080] = 0x8960, [2081] = 0x8961, [2082] = 0x8962, [2083] = 0x8963,
  [2084] = 0x8964, [2085] = 0x8965, [2086] = 0x8966, [2087] = 0x8967,
  [2088] = 0x8968, [2089] = 0x8969, [2090] = 0x896A, [2091] = 0x896B,
  [2092] = 0x896C, [2093] = 0x896D, [2094] = 0x896E, [2095] = 0x896F,
  [2096] = 0x8970, [2097] = 0x8971, [2098] = 0x8972, [2099] = 0x8973,
  [2100] = 0x8974, [2101] = 0x8975, [2102] = 0x8976, [2103] = 0x8977,
  [2104] = 0x8978, [2105] = 0x8979, [2106] = 0x897A, [2107] = 0x897B,
  [2108] = 0x897C, [2109] = 0x897D, [2110] = 0x897E, [2112] = 0x8980,
  [2113] = 0x8981, [2114] = 0x8982, [2115] = 0x8983, [2116] = 0x8984,
  [2117] = 0x8985, [2118] = 0x8986, [2119] = 0x8987, [2120] = 0x8988,
  [2121] = 0x8989, [2122] = 0x898A, [2123] = 0x898B, [2124] = 0x898C,
  [2125] = 0x898D, [2126] = 0x898E, [2127] = 0x898F, [2128] = 0x8990,
  [2129] = 0x8991, [2130] = 0x8992, [2131] = 0x8993, [2132] = 0x8994,
  [2133] = 0x8995, [2134] = 0x8996, [2135] = 0x8997, [2136] = 0x8998,
  [2137] = 0x8999, [2138] = 0x899A, [2139] = 0x899B, [2140] = 0x899C,
  [2141] = 0x899D, [2142] = 0x899E, [2143] = 0x899F, [2144] = 0x89A0,
  [2145] = 0x89A1, [2146] = 0x89A2, [2147] = 0x89A3, [2148] = 0x89A4,
  [2149] = 0x89A5, [2150] = 0x89A6, [2151] = 0x89A7, [2152] = 0x89A8,
  [2153] = 0x89A9, [2154] = 0x89AA, [2155] = 0x89AB, [2156] = 0x89AC,
  [2157] = 0x89AD, [2158] = 0x89AE, [2159] = 0x89AF, [2160] = 0x89B0,
  [2161] = 0x89B1, [2162] = 0x89B2, [2163] = 0x89B3, [2164] = 0x89B4,
  [2165] = 0x89B5, [2166] = 0x89B6, [2167] = 0x89B7, [2168] = 0x89B8,
  [2169] = 0x89B9, [2170] = 0x89BA, [2171] = 0x89BB, [2172] = 0x89BC,
  [2173] = 0x89BD, [2174] = 0x89BE, [2175] = 0x89BF, [2176] = 0x89C0,
  [2177] = 0x89C1, [2178] = 0x89C2, [2179] = 0x89C3, [2180] = 0x89C4,
  [2181] = 0x89C5, [2182] = 0x89C6, [2183] = 0x89C7, [2184] = 0x89C8,
  [2185] = 0x89C9, [2186] = 0x89CA, [2187] = 0x89CB, [2188] = 0x89CC,
  [2189] = 0x89CD, [2190] = 0x89CE, [2191] = 0x89CF, [2192] = 0x89D0,
  [2193] = 0x89D1, [2194] = 0x89D2, [2195] = 0x89D3, [2196] = 0x89D4,
  [2197] = 0x89D5, [2198] = 0x89D6, [2199] = 0x89D7, [2200] = 0x89D8,
  [2201] = 0x89D9, [2202] = 0x89DA, [2203] = 0x89DB, [2204] = 0x89DC,
  [2205] = 0x89DD, [2206] = 0x89DE, [2207] = 0x89DF, [2208] = 0x89E0,
  [2209] = 0x89E1, [2210] = 0x89E2, [2211] = 0x89E3, [2212] = 0x89E4,
  [2213] = 0x89E5, [2214] = 0x89E6, [2215] = 0x89E7, [2216] = 0x89E8,
  [2217] = 0x89E9, [2218] = 0x89EA, [2219] = 0x89EB, [2220] = 0x89EC,
  [2221] = 0x89ED, [2222] = 0x89EE, [2223] = 0x89EF, [2224] = 0x89F0,
  [2225] = 0x89F1, [2226] = 0x89F2, [2227] = 0x89F3, [2228] = 0x89F4,
  [2229] = 0x89F5, [2230] = 0x89F6, [2231] = 0x89F7, [2232] = 0x89F8,
  [2233] = 0x89F9, [2234] = 0x89FA, [2235] = 0x89FB, [2236] = 0x89FC,
  [2237] = 0x89FD, [2238] = 0x89FE, [2304] = 0x8A40, [2305] = 0x8A41,
  [2306] = 0x8A42, [2307] = 0x8A43, [2308] = 0x8A44, [2309] = 0x8A45,
  [2310] = 0x8A46, [2311] = 0x8A47, [2312] = 0x8A48, [2313] = 0x8A49,
  [2314] = 0x8A4A, [2315] = 0x8A4B, [2316] = 0x8A4C, [2317] = 0x8A4D,
  [2318] = 0x8A4E, [2319] = 0x8A4F, [2320] = 0x8A50, [2321] = 0x8A51,
  [2322] = 0x8A52, [2323] = 0x8A53, [2324] = 0x8A54, [2325] = 0x8A55,
  [2326] = 0x8A56, [2327] = 0x8A57, [2328] = 0x8A58, [2329] = 0x8A59,
  [2330] = 0x8A5A, [2331] = 0x8A5B, [2332] = 0x8A5C, [2333] = 0x8A5D,
  [2334] = 0x8A5E, [2335] = 0x8A5F, [2336] = 0x8A60, [2337] = 0x8A61,
  [2338] = 0x8A62, [2339] = 0x8A63, [2340] = 0x8A64, [2341] = 0x8A65,
  [2342] = 0x8A66, [2343] = 0x8A67, [2344] = 0x8A68, [2345] = 0x8A69,
  [2346] = 0x8A6A, [2347] = 0x8A6B, [2348] = 0x8A6C, [2349] = 0x8A6D,
  [2350] = 0x8A6E, [2351] = 0x8A6F, [2352] = 0x8A70, [2353] = 0x8A71,
  [2354] = 0x8A72, [2355] = 0x8A73, [2356] = 0x8A74, [2357] = 0x8A75,
  [2358] = 0x8A76, [2359] = 0x8A77, [2360] = 0x8A78, [2361] = 0x8A79,
  [2362] = 0x8A7A, [2363] = 0x8A7B, [2364] = 0x8A7C, [2365] = 0x8A7D,
  [2366] = 0x8A7E, [2368] = 0x8A80, [2369] = 0x8A81, [2370] = 0x8A82,
  [2371] = 0x8A83, [2372] = 0x8A84, [2373] = 0x8A85, [2374] = 0x8A86,
  [2375] = 0x8A87, [2376] = 0x8A88, [2377] = 0x8A89, [2378] = 0x8A8A,
  [2379] = 0x8A8B, [2380] = 0x8A8C, [2381] = 0x8A8D, [2382] = 0x8A8E,
  [2383] = 0x8A8F, [2384] = 0x8A90, [2385] = 0x8A91, [2386] = 0x8A92,
  [2387] = 0x8A93, [2388] = 0x8A94, [2389] = 0x8A95, [2390] = 0x8A96,
  [2391] = 0x8A97, [2392] = 0x8A98, [2393] = 0x8A99, [2394] = 0x8A9A,
  [2395] = 0x8A9B, [2396] = 0x8A9C, [2397] = 0x8A9D, [2398] = 0x8A9E,
  [2399] = 0x8A9F, [2400] = 0x8AA0, [2401] = 0x8AA1, [2402] = 0x8AA2,
  [2403] = 0x8AA3, [2404] = 0x8AA4, [2405] = 0x8AA5, [2406] = 0x8AA6,
  [2407] = 0x8AA7, [2408] = 0x8AA8, [2409] = 0x8AA9, [2410] = 0x8AAA,
  [2411] = 0x8AAB, [2412] = 0x8AAC, [2413] = 0x8AAD, [2414] = 0x8AAE,
  [2415] = 0x8AAF, [2416] = 0x8AB0, [2417] = 0x8AB1, [2418] = 0x8AB2,
  [2419] = 0x8AB3, [2420] = 0x8AB4, [2421] = 0x8AB5, [2422] = 0x8AB6,
  [2423] = 0x8AB7, [2424] = 0x8AB8, [2425] = 0x8AB9, [2426] = 0x8ABA,
  [2427] = 0x8ABB, [2428] = 0x8ABC, [2429] = 0x8ABD, [2430] = 0x8ABE,
  [2431] = 0x8ABF, [2432] = 0x8AC0, [2433] = 0x8AC1, [2434] = 0x8AC2,
  [2435] = 0x8AC3, [2436] = 0x8AC4, [2437] = 0x8AC5, [2438] = 0x8AC6,
  [2439] = 0x8AC7, [2440] = 0x8AC8, [2441] = 0x8AC9, [2442] = 0x8ACA,
  [2443] = 0x8ACB, [2444] = 0x8ACC, [2445] = 0x8ACD, [2446] = 0x8ACE,
  [2447] = 0x8ACF, [2448] = 0x8AD0, [2449] = 0x8AD1, [2450] = 0x8AD2,
  [2451] = 0x8AD3, [2452] = 0x8AD4, [2453] = 0x8AD5, [2454] = 0x8AD6,
  [2455] = 0x8AD7, [2456] = 0x8AD8, [2457] = 0x8AD9, [2458] = 0x8ADA,
  [2459] = 0x8ADB, [2460] = 0x8ADC, [2461] = 0x8ADD, [2462] = 0x8ADE,
  [2463] = 0x8ADF, [2464] = 0x8AE0, [2465] = 0x8AE1, [2466] = 0x8AE2,
  [2467] = 0x8AE3, [2468] = 0x8AE4, [2469] = 0x8AE5, [2470] = 0x8AE6,
  [2471] = 0x8AE7, [2472] = 0x8AE8, [2473] = 0x8AE9, [2474] = 0x8AEA,
  [2475] = 0x8AEB, [2476] = 0x8AEC, [2477] = 0x8AED, [2478] = 0x8AEE,
  [2479] = 0x8AEF, [2480] = 0x8AF0, [2481] = 0x8AF1, [2482] = 0x8AF2,
  [2483] = 0x8AF3, [2484] = 0x8AF4, [2485] = 0x8AF5, [2486] = 0x8AF6,
  [2487] = 0x8AF7, [2488] = 0x8AF8, [2489] = 0x8AF9, [2490] = 0x8AFA,
  [2491] = 0x8AFB, [2492] = 0x8AFC, [2493] = 0x8AFD, [2494] = 0x8AFE,
  [2560] = 0x8B40, [2561] = 0x8B41, [2562] = 0x8B42, [2563] = 0x8B43,
  [2564] = 0x8B44, [2565] = 0x8B45, [2566] = 0x8B46, [2567] = 0x8B47,
  [2568] = 0x8B48, [2569] = 0x8B49, [2570] = 0x8B4A, [2571] = 0x8B4B,
  [2572] = 0x8B4C, [2573] = 0x8B4D, [2574] = 0x8B4E, [2575] = 0x8B4F,
  [2576] = 0x8B50, [2577] = 0x8B51, [2578] = 0x8B52, [2579] = 0x8B53,
  [2580] = 0x8B54, [2581] = 0x8B55, [2582] = 0x8B56, [2583] = 0x8B57,
  [2584] = 0x8B58, [2585] = 0x8B59, [2586] = 0x8B5A, [2587] = 0x8B5B,
  [2588] = 0x8B5C, [2589] = 0x8B5D, [2590] = 0x8B5E, [2591] = 0x8B5F,
  [2592] = 0x8B60, [2593] = 0x8B61, [2594] = 0x8B62, [2595] = 0x8B63,
  [2596] = 0x8B64, [2597] = 0x8B65, [2598] = 0x8B66, [2599] = 0x8B67,
  [2600] = 0x8B68, [2601] = 0x8B69, [2602] = 0x8B6A, [2603] = 0x8B6B,
  [2604] = 0x8B6C, [2605] = 0x8B6D, [2606] = 0x8B6E, [2607] = 0x8B6F,
  [2608] = 0x8B70, [2609] = 0x8B71, [2610] = 0x8B72, [2611] = 0x8B73,
  [2612] = 0x8B74, [2613] = 0x8B75, [2614] = 0x8B76, [2615] = 0x8B77,
  [2616] = 0x8B78, [2617] = 0x8B79, [2618] = 0x8B7A, [2619] = 0x8B7B,
  [2620] = 0x8B7C, [2621] = 0x8B7D, [2622] = 0x8B7E, [2624] = 0x8B80,
  [2625] = 0x8B81, [2626] = 0x8B82, [2627] = 0x8B83, [2628] = 0x8B84,
  [2629] = 0x8B85, [2630] = 0x8B86, [2631] = 0x8B87, [2632] = 0x8B88,
  [2633] = 0x8B89, [2634] = 0x8B8A, [2635] = 0x8B8B, [2636] = 0x8B8C,
  [2637] = 0x8B8D, [2638] = 0x8B8E, [2639] = 0x8B8F, [2640] = 0x8B90,
  [2641] = 0x8B91, [2642] = 0x8B92, [2643] = 0x8B93, [2644] = 0x8B94,
  [2645] = 0x8B95, [2646] = 0x8B96, [2647] = 0x8B97, [2648] = 0x8B98,
  [2649] = 0x8B99, [2650] = 0x8B9A, [2651] = 0x8B9B, [2652] = 0x8B9C,
  [2653] = 0x8B9D, [2654] = 0x8B9E, [2655] = 0x8B9F, [2656] = 0x8BA0,
  [2657] = 0x8BA1, [2658] = 0x8BA2, [2659] = 0x8BA3, [2660] = 0x8BA4,
  [2661] = 0x8BA5, [2662] = 0x8BA6, [2663] = 0x8BA7, [2664] = 0x8BA8,
  [2665] = 0x8BA9, [2666] = 0x8BAA, [2667] = 0x8BAB, [2668] = 0x8BAC,
  [2669] = 0x8BAD, [2670] = 0x8BAE, [2671] = 0x8BAF, [2672] = 0x8BB0,
  [2673] = 0x8BB1, [2674] = 0x8BB2, [2675] = 0x8BB3, [2676] = 0x8BB4,
  [2677] = 0x8BB5, [2678] = 0x8BB6, [2679] = 0x8BB7, [2680] = 0x8BB8,
  [2681] = 0x8BB9, [2682] = 0x8BBA, [2683] = 0x8BBB, [2684] = 0x8BBC,
  [2685] = 0x8BBD, [2686] = 0x8BBE, [2687] = 0x8BBF, [2688] = 0x8BC0,
  [2689] = 0x8BC1, [2690] = 0x8BC2, [2691] = 0x8BC3, [2692] = 0x8BC4,
  [2693] = 0x8BC5, [2694] = 0x8BC6, [2695] = 0x8BC7, [2696] = 0x8BC8,
  [2697] = 0x8BC9, [2698] = 0x8BCA, [2699] = 0x8BCB, [2700] = 0x8BCC,
  [2701] = 0x8BCD, [2702] = 0x8BCE, [2703] = 0x8BCF, [2704] = 0x8BD0,
  [2705] = 0x8BD1, [2706] = 0x8BD2, [2707] = 0x8BD3, [2708] = 0x8BD4,
  [2709] = 0x8BD5, [2710] = 0x8BD6, [2711] = 0x8BD7, [2712] = 0x8BD8,
  [2713] = 0x8BD9, [2714] = 0x8BDA, [2715] = 0x8BDB, [2716] = 0x8BDC,
  [2717] = 0x8BDD, [2718] = 0x8BDE, [2719] = 0x8BDF, [2720] = 0x8BE0,
  [2721] = 0x8BE1, [2722] = 0x8BE2, [2723] = 0x8BE3, [2724] = 0x8BE4,
  [2725] = 0x8BE5, [2726] = 0x8BE6, [2727] = 0x8BE7, [2728] = 0x8BE8,
  [2729] = 0x8BE9, [2730] = 0x8BEA, [2731] = 0x8BEB, [2732] = 0x8BEC,
  [2733] = 0x8BED, [2734] = 0x8BEE, [2735] = 0x8BEF, [2736] = 0x8BF0,
  [2737] = 0x8BF1, [2738] = 0x8BF2, [2739] = 0x8BF3, [2740] = 0x8BF4,
  [2741] = 0x8BF5, [2742] = 0x8BF6, [2743] = 0x8BF7, [2744] = 0x8BF8,
  [2745] = 0x8BF9, [2746] = 0x8BFA, [2747] = 0x8BFB, [2748] = 0x8BFC,
  [2749] = 0x8BFD, [2750] = 0x8BFE, [2816] = 0x8C40, [2817] = 0x8C41,
  [2818] = 0x8C42, [2819] = 0x8C43, [2820] = 0x8C44, [2821] = 0x8C45,
  [2822] = 0x8C46, [2823] = 0x8C47, [2824] = 0x8C48, [2825] = 0x8C49,
  [2826] = 0x8C4A, [2827] = 0x8C4B, [2828] = 0x8C4C, [2829] = 0x8C4D,
  [2830] = 0x8C4E, [2831] = 0x8C4F, [2832] = 0x8C50, [2833] = 0x8C51,
  [2834] = 0x8C52, [2835] = 0x8C53, [2836] = 0x8C54, [2837] = 0x8C55,
  [2838] = 0x8C56, [2839] = 0x8C57, [2840] = 0x8C58, [2841] = 0x8C59,
  [2842] = 0x8C5A, [2843] = 0x8C5B, [2844] = 0x8C5C, [2845] = 0x8C5D,
  [2846] = 0x8C5E, [2847] = 0x8C5F, [2848] = 0x8C60, [2849] = 0x8C61,
  [2850] = 0x8C62, [2851] = 0x8C63, [2852] = 0x8C64, [2853] = 0x8C65,
  [2854] = 0x8C66, [2855] = 0x8C67, [2856] = 0x8C68, [2857] = 0x8C69,
  [2858] = 0x8C6A, [2859] = 0x8C6B, [2860] = 0x8C6C, [2861] = 0x8C6D,
  [2862] = 0x8C6E, [2863] = 0x8C6F, [2864] = 0x8C70, [2865] = 0x8C71,
  [2866] = 0x8C72, [2867] = 0x8C73, [2868] = 0x8C74, [2869] = 0x8C75,
  [2870] = 0x8C76, [2871] = 0x8C77, [2872] = 0x8C78, [2873] = 0x8C79,
  [2874] = 0x8C7A, [2875] = 0x8C7B, [2876] = 0x8C7C, [2877] = 0x8C7D,
  [2878] = 0x8C7E, [2880] = 0x8C80, [2881] = 0x8C81, [2882] = 0x8C82,
  [2883] = 0x8C83, [2884] = 0x8C84, [2885] = 0x8C85, [2886] = 0x8C86,
  [2887] = 0x8C87, [2888] = 0x8C88, [2889] = 0x8C89, [2890] = 0x8C8A,
  [2891] = 0x8C8B, [2892] = 0x8C8C, [2893] = 0x8C8D, [2894] = 0x8C8E,
  [2895] = 0x8C8F, [2896] = 0x8C90, [2897] = 0x8C91, [2898] = 0x8C92,
  [2899] = 0x8C93, [2900] = 0x8C94, [2901] = 0x8C95, [2902] = 0x8C96,
  [2903] = 0x8C97, [2904] = 0x8C98, [2905] = 0x8C99, [2906] = 0x8C9A,
  [2907] = 0x8C9B, [2908] = 0x8C9C, [2909] = 0x8C9D, [2910] = 0x8C9E,
  [2911] = 0x8C9F, [2912] = 0x8CA0, [2913] = 0x8CA1, [2914] = 0x8CA2,
  [2915] = 0x8CA3, [2916] = 0x8CA4, [2917] = 0x8CA5, [2918] = 0x8CA6,
  [2919] = 0x8CA7, [2920] = 0x8CA8, [2921] = 0x8CA9, [2922] = 0x8CAA,
  [2923] = 0x8CAB, [2924] = 0x8CAC, [2925] = 0x8CAD, [2926] = 0x8CAE,
  [2927] = 0x8CAF, [2928] = 0x8CB0, [2929] = 0x8CB1, [2930] = 0x8CB2,
  [2931] = 0x8CB3, [2932] = 0x8CB4, [2933] = 0x8CB5, [2934] = 0x8CB6,
  [2935] = 0x8CB7, [2936] = 0x8CB8, [2937] = 0x8CB9, [2938] = 0x8CBA,
  [2939] = 0x8CBB, [2940] = 0x8CBC, [2941] = 0x8CBD, [2942] = 0x8CBE,
  [2943] = 0x8CBF, [2944] = 0x8CC0, [2945] = 0x8CC1, [2946] = 0x8CC2,
  [2947] = 0x8CC3, [2948] = 0x8CC4, [2949] = 0x8CC5, [2950] = 0x8CC6,
  [2951] = 0x8CC7, [2952] = 0x8CC8, [2953] = 0x8CC9, [2954] = 0x8CCA,
  [2955] = 0x8CCB, [2956] = 0x8CCC, [2957] = 0x8CCD, [2958] = 0x8CCE,
  [2959] = 0x8CCF, [2960] = 0x8CD0, [2961] = 0x8CD1, [2962] = 0x8CD2,
  [2963] = 0x8CD3, [2964] = 0x8CD4, [2965] = 0x8CD5, [2966] = 0x8CD6,
  [2967] = 0x8CD7, [2968] = 0x8CD8, [2969] = 0x8CD9, [2970] = 0x8CDA,
  [2971] = 0x8CDB, [2972] = 0x8CDC, [2973] = 0x8CDD, [2974] = 0x8CDE,
  [2975] = 0x8CDF, [2976] = 0x8CE0, [2977] = 0x8CE1, [2978] = 0x8CE2,
  [2979] = 0x8CE3, [2980] = 0x8CE4, [2981] = 0x8CE5, [2982] = 0x8CE6,
  [2983] = 0x8CE7, [2984] = 0x8CE8, [2985] = 0x8CE9, [2986] = 0x8CEA,
  [2987] = 0x8CEB, [2988] = 0x8CEC, [2989] = 0x8CED, [2990] = 0x8CEE,
  [2991] = 0x8CEF, [2992] = 0x8CF0, [2993] = 0x8CF1, [2994] = 0x8CF2,
  [2995] = 0x8CF3, [2996] = 0x8CF4, [2997] = 0x8CF5, [2998] = 0x8CF6,
  [2999] = 0x8CF7, [3000] = 0x8CF8, [3001] = 0x8CF9, [3002] = 0x8CFA,
  [3003] = 0x8CFB, [3004] = 0x8CFC, [3005] = 0x8CFD, [3006] = 0x8CFE,
  [3072] = 0x8D40, [3073] = 0x8D41, [3074] = 0x8D42, [3075] = 0x8D43,
  [3076] = 0x8D44, [3077] = 0x8D45, [3078] = 0x8D46, [3079] = 0x8D47,
  [3080] = 0x8D48, [3081] = 0x8D49, [3082] = 0x8D4A, [3083] = 0x8D4B,
  [3084] = 0x8D4C, [3085] = 0x8D4D, [3086] = 0x8D4E, [3087] = 0x8D4F,
  [3088] = 0x8D50, [3089] = 0x8D51, [3090] = 0x8D52, [3091] = 0x8D53,
  [3092] = 0x8D54, [3093] = 0x8D55, [3094] = 0x8D56, [3095] = 0x8D57,
  [3096] = 0x8D58, [3097] = 0x8D59, [3098] = 0x8D5A, [3099] = 0x8D5B,
  [3100] = 0x8D5C, [3101] = 0x8D5D, [3102] = 0x8D5E, [3103] = 0x8D5F,
  [3104] = 0x8D60, [3105] = 0x8D61, [3106] = 0x8D62, [3107] = 0x8D63,
  [3108] = 0x8D64, [3109] = 0x8D65, [3110] = 0x8D66, [3111] = 0x8D67,
  [3112] = 0x8D68, [3113] = 0x8D69, [3114] = 0x8D6A, [3115] = 0x8D6B,
  [3116] = 0x8D6C, [3117] = 0x8D6D, [3118] = 0x8D6E, [3119] = 0x8D6F,
  [3120] = 0x8D70, [3121] = 0x8D71, [3122] = 0x8D72, [3123] = 0x8D73,
  [3124] = 0x8D74, [3125] = 0x8D75, [3126] = 0x8D76, [3127] = 0x8D77,
  [3128] = 0x8D78, [3129] = 0x8D79, [3130] = 0x8D7A, [3131] = 0x8D7B,
  [3132] = 0x8D7C, [3133] = 0x8D7D, [3134] = 0x8D7E, [3136] = 0x8D80,
  [3137] = 0x8D81, [3138] = 0x8D82, [3139] = 0x8D83, [3140] = 0x8D84,
  [3141] = 0x8D85, [3142] = 0x8D86, [3143] = 0x8D87, [3144] = 0x8D88,
  [3145] = 0x8D89, [3146] = 0x8D8A, [3147] = 0x8D8B, [3148] = 0x8D8C,
  [3149] = 0x8D8D, [3150] = 0x8D8E, [3151] = 0x8D8F, [3152] = 0x8D90,
  [3153] = 0x8D91, [3154] = 0x8D92, [3155] = 0x8D93, [3156] = 0x8D94,
  [3157] = 0x8D95, [3158] = 0x8D96, [3159] = 0x8D97, [3160] = 0x8D98,
  [3161] = 0x8D99, [3162] = 0x8D9A, [3163] = 0x8D9B, [3164] = 0x8D9C,
  [3165] = 0x8D9D, [3166] = 0x8D9E, [3167] = 0x8D9F, [3168] = 0x8DA0,
  [3169] = 0x8DA1, [3170] = 0x8DA2, [3171] = 0x8DA3, [3172] = 0x8DA4,
  [3173] = 0x8DA5, [3174] = 0x8DA6, [3175] = 0x8DA7, [3176] = 0x8DA8,
  [3177] = 0x8DA9, [3178] = 0x8DAA, [3179] = 0x8DAB, [3180] = 0x8DAC,
  [3181] = 0x8DAD, [3182] = 0x8DAE, [3183] = 0x8DAF, [3184] = 0x8DB0,
  [3185] = 0x8DB1, [3186] = 0x8DB2, [3187] = 0x8DB3, [3188] = 0x8DB4,
  [3189] = 0x8DB5, [3190] = 0x8DB6, [3191] = 0x8DB7, [3192] = 0x8DB8,
  [3193] = 0x8DB9, [3194] = 0x8DBA, [3195] = 0x8DBB, [3196] = 0x8DBC,
  [3197] = 0x8DBD, [3198] = 0x8DBE, [3199] = 0x8DBF, [3200] = 0x8DC0,
  [3201] = 0x8DC1, [3202] = 0x8DC2, [3203] = 0x8DC3, [3204] = 0x8DC4,
  [3205] = 0x8DC5, [3206] = 0x8DC6, [3207] = 0x8DC7, [3208] = 0x8DC8,
  [3209] = 0x8DC9, [3210] = 0x8DCA, [3211] = 0x8DCB, [3212] = 0x8DCC,
  [3213] = 0x8DCD, [3214] = 0x8DCE, [3215] = 0x8DCF, [3216] = 0x8DD0,
  [3217] = 0x8DD1, [3218] = 0x8DD2, [3219] = 0x8DD3, [3220] = 0x8DD4,
  [3221] = 0x8DD5, [3222] = 0x8DD6, [3223] = 0x8DD7, [3224] = 0x8DD8,
  [3225] = 0x8DD9, [3226] = 0x8DDA, [3227] = 0x8DDB, [3228] = 0x8DDC,
  [3229] = 0x8DDD, [3230] = 0x8DDE, [3231] = 0x8DDF, [3232] = 0x8DE0,
  [3233] = 0x8DE1, [3234] = 0x8DE2, [3235] = 0x8DE3, [3236] = 0x8DE4,
  [3237] = 0x8DE5, [3238] = 0x8DE6, [3239] = 0x8DE7, [3240] = 0x8DE8,
  [3241] = 0x8DE9, [3242] = 0x8DEA, [3243] = 0x8DEB, [3244] = 0x8DEC,
  [3245] = 0x8DED, [3246] = 0x8DEE, [3247] = 0x8DEF, [3248] = 0x8DF0,
  [3249] = 0x8DF1, [3250] = 0x8DF2, [3251] = 0x8DF3, [3252] = 0x8DF4,
  [3253] = 0x8DF5, [3254] = 0x8DF6, [3255] = 0x8DF7, [3256] = 0x8DF8,
  [3257] = 0x8DF9, [3258] = 0x8DFA, [3259] = 0x8DFB, [3260] = 0x8DFC,
  [3261] = 0x8DFD, [3262] = 0x8DFE, [3328] = 0x8E40, [3329] = 0x8E41,
  [3330] = 0x8E42, [3331] = 0x8E43, [3332] = 0x8E44, [3333] = 0x8E45,
  [3334] = 0x8E46, [3335] = 0x8E47, [3336] = 0x8E48, [3337] = 0x8E49,
  [3338] = 0x8E4A, [3339] = 0x8E4B, [3340] = 0x8E4C, [3341] = 0x8E4D,
  [3342] = 0x8E4E, [3343] = 0x8E4F, [3344] = 0x8E50, [3345] = 0x8E51,
  [3346] = 0x8E52, [3347] = 0x8E53, [3348] = 0x8E54, [3349] = 0x8E55,
  [3350] = 0x8E56, [3351] = 0x8E57, [3352] = 0x8E58, [3353] = 0x8E59,
  [3354] = 0x8E5A, [3355] = 0x8E5B, [3356] = 0x8E5C, [3357] = 0x8E5D,
  [3358] = 0x8E5E, [3359] = 0x8E5F, [3360] = 0x8E60, [3361] = 0x8E61,
  [3362] = 0x8E62, [3363] = 0x8E63, [3364] = 0x8E64, [3365] = 0x8E65,
  [3366] = 0x8E66, [3367] = 0x8E67, [3368] = 0x8E68, [3369] = 0x8E69,
  [3370] = 0x8E6A, [3371] = 0x8E6B, [3372] = 0x8E6C, [3373] = 0x8E6D,
  [3374] = 0x8E6E, [3375] = 0x8E6F, [3376] = 0x8E70, [3377] = 0x8E71,
  [3378] = 0x8E72, [3379] = 0x8E73, [3380] = 0x8E74, [3381] = 0x8E75,
  [3382] = 0x8E76, [3383] = 0x8E77, [3384] = 0x8E78, [3385] = 0x8E79,
  [3386] = 0x8E7A, [3387] = 0x8E7B, [3388] = 0x8E7C, [3389] = 0x8E7D,
  [3390] = 0x8E7E, [3392] = 0x8E80, [3393] = 0x8E81, [3394] = 0x8E82,
  [3395] = 0x8E83, [3396] = 0x8E84, [3397] = 0x8E85, [3398] = 0x8E86,
  [3399] = 0x8E87, [3400] = 0x8E88, [3401] = 0x8E89, [3402] = 0x8E8A,
  [3403] = 0x8E8B, [3404] = 0x8E8C, [3405] = 0x8E8D, [3406] = 0x8E8E,
  [3407] = 0x8E8F, [3408] = 0x8E90, [3409] = 0x8E91, [3410] = 0x8E92,
  [3411] = 0x8E93, [3412] = 0x8E94, [3413] = 0x8E95, [3414] = 0x8E96,
  [3415] = 0x8E97, [3416] = 0x8E98, [3417] = 0x8E99, [3418] = 0x8E9A,
  [3419] = 0x8E9B, [3420] = 0x8E9C, [3421] = 0x8E9D, [3422] = 0x8E9E,
  [3423] = 0x8E9F, [3424] = 0x8EA0, [3425] = 0x8EA1, [3426] = 0x8EA2,
  [3427] = 0x8EA3, [3428] = 0x8EA4, [3429] = 0x8EA5, [3430] = 0x8EA6,
  [3431] = 0x8EA7, [3432] = 0x8EA8, [3433] = 0x8EA9, [3434] = 0x8EAA,
  [3435] = 0x8EAB, [3436] = 0x8EAC, [3437] = 0x8EAD, [3438] = 0x8EAE,
  [3439] = 0x8EAF, [3440] = 0x8EB0, [3441] = 0x8EB1, [3442] = 0x8EB2,
  [3443] = 0x8EB3, [3444] = 0x8EB4, [3445] = 0x8EB5, [3446] = 0x8EB6,
  [3447] = 0x8EB7, [3448] = 0x8EB8, [3449] = 0x8EB9, [3450] = 0x8EBA,
  [3451] = 0x8EBB, [3452] = 0x8EBC, [3453] = 0x8EBD, [3454] = 0x8EBE,
  [3455] = 0x8EBF, [3456] = 0x8EC0, [3457] = 0x8EC1, [3458] = 0x8EC2,
  [3459] = 0x8EC3, [3460] = 0x8EC4, [3461] = 0x8EC5, [3462] = 0x8EC6,
  [3463] = 0x8EC7, [3464] = 0x8EC8, [3465] = 0x8EC9, [3466] = 0x8ECA,
  [3467] = 0x8ECB, [3468] = 0x8ECC, [3469] = 0x8ECD, [3470] = 0x8ECE,
  [3471] = 0x8ECF, [3472] = 0x8ED0, [3473] = 0x8ED1, [3474] = 0x8ED2,
  [3475] = 0x8ED3, [3476] = 0x8ED4, [3477] = 0x8ED5, [3478] = 0x8ED6,
  [3479] = 0x8ED7, [3480] = 0x8ED8, [3481] = 0x8ED9, [3482] = 0x8EDA,
  [3483] = 0x8EDB, [3484] = 0x8EDC, [3485] = 0x8EDD, [3486] = 0x8EDE,
  [3487] = 0x8EDF, [3488] = 0x8EE0, [3489] = 0x8EE1, [3490] = 0x8EE2,
  [3491] = 0x8EE3, [3492] = 0x8EE4, [3493] = 0x8EE5, [3494] = 0x8EE6,
  [3495] = 0x8EE7, [3496] = 0x8EE8, [3497] = 0x8EE9, [3498] = 0x8EEA,
  [3499] = 0x8EEB, [3500] = 0x8EEC, [3501] = 0x8EED, [3502] = 0x8EEE,
  [3503] = 0x8EEF, [3504] = 0x8EF0, [3505] = 0x8EF1, [3506] = 0x8EF2,
  [3507] = 0x8EF3, [3508] = 0x8EF4, [3509] = 0x8EF5, [3510] = 0x8EF6,
  [3511] = 0x8EF7, [3512] = 0x8EF8, [3513] = 0x8EF9, [3514] = 0x8EFA,
  [3515] = 0x8EFB, [3516] = 0x8EFC, [3517] = 0x8EFD, [3518] = 0x8EFE,
  [3584] = 0x8F40, [3585] = 0x8F41, [3586] = 0x8F42, [3587] = 0x8F43,
  [3588] = 0x8F44, [3589] = 0x8F45, [3590] = 0x8F46, [3591] = 0x8F47,
  [3592] = 0x8F48, [3593] = 0x8F49, [3594] = 0x8F4A, [3595] = 0x8F4B,
  [3596] = 0x8F4C, [3597] = 0x8F4D, [3598] = 0x8F4E, [3599] = 0x8F4F,
  [3600] = 0x8F50, [3601] = 0x8F51, [3602] = 0x8F52, [3603] = 0x8F53,
  [3604] = 0x8F54, [3605] = 0x8F55, [3606] = 0x8F56, [3607] = 0x8F57,
  [3608] = 0x8F58, [3609] = 0x8F59, [3610] = 0x8F5A, [3611] = 0x8F5B,
  [3612] = 0x8F5C, [3613] = 0x8F5D, [3614] = 0x8F5E, [3615] = 0x8F5F,
  [3616] = 0x8F60, [3617] = 0x8F61, [3618] = 0x8F62, [3619] = 0x8F63,
  [3620] = 0x8F64, [3621] = 0x8F65, [3622] = 0x8F66, [3623] = 0x8F67,
  [3624] = 0x8F68, [3625] = 0x8F69, [3626] = 0x8F6A, [3627] = 0x8F6B,
  [3628] = 0x8F6C, [3629] = 0x8F6D, [3630] = 0x8F6E, [3631] = 0x8F6F,
  [3632] = 0x8F70, [3633] = 0x8F71, [3634] = 0x8F72, [3635] = 0x8F73,
  [3636] = 0x8F74, [3637] = 0x8F75, [3638] = 0x8F76, [3639] = 0x8F77,
  [3640] = 0x8F78, [3641] = 0x8F79, [3642] = 0x8F7A, [3643] = 0x8F7B,
  [3644] = 0x8F7C, [3645] = 0x8F7D, [3646] = 0x8F7E, [3648] = 0x8F80,
  [3649] = 0x8F81, [3650] = 0x8F82, [3651] = 0x8F83, [3652] = 0x8F84,
  [3653] = 0x8F85, [3654] = 0x8F86, [3655] = 0x8F87, [3656] = 0x8F88,
  [3657] = 0x8F89, [3658] = 0x8F8A, [3659] = 0x8F8B, [3660] = 0x8F8C,
  [3661] = 0x8F8D, [3662] = 0x8F8E, [3663] = 0x8F8F, [3664] = 0x8F90,
  [3665] = 0x8F91, [3666] = 0x8F92, [3667] = 0x8F93, [3668] = 0x8F94,
  [3669] = 0x8F95, [3670] = 0x8F96, [3671] = 0x8F97, [3672] = 0x8F98,
  [3673] = 0x8F99, [3674] = 0x8F9A, [3675] = 0x8F9B, [3676] = 0x8F9C,
  [3677] = 0x8F9D, [3678] = 0x8F9E, [3679] = 0x8F9F, [3680] = 0x8FA0,
  [3681] = 0x8FA1, [3682] = 0x8FA2, [3683] = 0x8FA3, [3684] = 0x8FA4,
  [3685] = 0x8FA5, [3686] = 0x8FA6, [3687] = 0x8FA7, [3688] = 0x8FA8,
  [3689] = 0x8FA9, [3690] = 0x8FAA, [3691] = 0x8FAB, [3692] = 0x8FAC,
  [3693] = 0x8FAD, [3694] = 0x8FAE, [3695] = 0x8FAF, [3696] = 0x8FB0,
  [3697] = 0x8FB1, [3698] = 0x8FB2, [3699] = 0x8FB3, [3700] = 0x8FB4,
  [3701] = 0x8FB5, [3702] = 0x8FB6, [3703] = 0x8FB7, [3704] = 0x8FB8,
  [3705] = 0x8FB9, [3706] = 0x8FBA, [3707] = 0x8FBB, [3708] = 0x8FBC,
  [3709] = 0x8FBD, [3710] = 0x8FBE, [3711] = 0x8FBF, [3712] = 0x8FC0,
  [3713] = 0x8FC1, [3714] = 0x8FC2, [3715] = 0x8FC3, [3716] = 0x8FC4,
  [3717] = 0x8FC5, [3718] = 0x8FC6, [3719] = 0x8FC7, [3720] = 0x8FC8,
  [3721] = 0x8FC9, [3722] = 0x8FCA, [3723] = 0x8FCB, [3724] = 0x8FCC,
  [3725] = 0x8FCD, [3726] = 0x8FCE, [3727] = 0x8FCF, [3728] = 0x8FD0,
  [3729] = 0x8FD1, [3730] = 0x8FD2, [3731] = 0x8FD3, [3732] = 0x8FD4,
  [3733] = 0x8FD5, [3734] = 0x8FD6, [3735] = 0x8FD7, [3736] = 0x8FD8,
  [3737] = 0x8FD9, [3738] = 0x8FDA, [3739] = 0x8FDB, [3740] = 0x8FDC,
  [3741] = 0x8FDD, [3742] = 0x8FDE, [3743] = 0x8FDF, [3744] = 0x8FE0,
  [3745] = 0x8FE1, [3746] = 0x8FE2, [3747] = 0x8FE3, [3748] = 0x8FE4,
  [3749] = 0x8FE5, [3750] = 0x8FE6, [3751] = 0x8FE7, [3752] = 0x8FE8,
  [3753] = 0x8FE9, [3754] = 0x8FEA, [3755] = 0x8FEB, [3756] = 0x8FEC,
  [3757] = 0x8FED, [3758] = 0x8FEE, [3759] = 0x8FEF, [3760] = 0x8FF0,
  [3761] = 0x8FF1, [3762] = 0x8FF2, [3763] = 0x8FF3, [3764] = 0x8FF4,
  [3765] = 0x8FF5, [3766] = 0x8FF6, [3767] = 0x8FF7, [3768] = 0x8FF8,
  [3769] = 0x8FF9, [3770] = 0x8FFA, [3771] = 0x8FFB, [3772] = 0x8FFC,
  [3773] = 0x8FFD, [3774] = 0x8FFE, [3840] = 0x9040, [3841] = 0x9041,
  [3842] = 0x9042, [3843] = 0x9043, [3844] = 0x9044, [3845] = 0x9045,
  [3846] = 0x9046, [3847] = 0x9047, [3848] = 0x9048, [3849] = 0x9049,
  [3850] = 0x904A, [3851] = 0x904B, [3852] = 0x904C, [3853] = 0x904D,
  [3854] = 0x904E, [3855] = 0x904F, [3856] = 0x9050, [3857] = 0x9051,
  [3858] = 0x9052, [3859] = 0x9053, [3860] = 0x9054, [3861] = 0x9055,
  [3862] = 0x9056, [3863] = 0x9057, [3864] = 0x9058, [3865] = 0x9059,
  [3866] = 0x905A, [3867] = 0x905B, [3868] = 0x905C, [3869] = 0x905D,
  [3870] = 0x905E, [3871] = 0x905F, [3872] = 0x9060, [3873] = 0x9061,
  [3874] = 0x9062, [3875] = 0x9063, [3876] = 0x9064, [3877] = 0x9065,
  [3878] = 0x9066, [3879] = 0x9067, [3880] = 0x9068, [3881] = 0x9069,
  [3882] = 0x906A, [3883] = 0x906B, [3884] = 0x906C, [3885] = 0x906D,
  [3886] = 0x906E, [3887] = 0x906F, [3888] = 0x9070, [3889] = 0x9071,
  [3890] = 0x9072, [3891] = 0x9073, [3892] = 0x9074, [3893] = 0x9075,
  [3894] = 0x9076, [3895] = 0x9077, [3896] = 0x9078, [3897] = 0x9079,
  [3898] = 0x907A, [3899] = 0x907B, [3900] = 0x907C, [3901] = 0x907D,
  [3902] = 0x907E, [3904] = 0x9080, [3905] = 0x9081, [3906] = 0x9082,
  [3907] = 0x9083, [3908] = 0x9084, [3909] = 0x9085, [3910] = 0x9086,
  [3911] = 0x9087, [3912] = 0x9088, [3913] = 0x9089, [3914] = 0x908A,
  [3915] = 0x908B, [3916] = 0x908C, [3917] = 0x908D, [3918] = 0x908E,
  [3919] = 0x908F, [3920] = 0x9090, [3921] = 0x9091, [3922] = 0x9092,
  [3923] = 0x9093, [3924] = 0x9094, [3925] = 0x9095, [3926] = 0x9096,
  [3927] = 0x9097, [3928] = 0x9098, [3929] = 0x9099, [3930] = 0x909A,
  [3931] = 0x909B, [3932] = 0x909C, [3933] = 0x909D, [3934] = 0x909E,
  [3935] = 0x909F, [3936] = 0x90A0, [3937] = 0x90A1, [3938] = 0x90A2,
  [3939] = 0x90A3, [3940] = 0x90A4, [3941] = 0x90A5, [3942] = 0x90A6,
  [3943] = 0x90A7, [3944] = 0x90A8, [3945] = 0x90A9, [3946] = 0x90AA,
  [3947] = 0x90AB, [3948] = 0x90AC, [3949] = 0x90AD, [3950] = 0x90AE,
  [3951] = 0x90AF, [3952] = 0x90B0, [3953] = 0x90B1, [3954] = 0x90B2,
  [3955] = 0x90B3, [3956] = 0x90B4, [3957] = 0x90B5, [3958] = 0x90B6,
  [3959] = 0x90B7, [3960] = 0x90B8, [3961] = 0x90B9, [3962] = 0x90BA,
  [3963] = 0x90BB, [3964] = 0x90BC, [3965] = 0x90BD, [3966] = 0x90BE,
  [3967] = 0x90BF, [3968] = 0x90C0, [3969] = 0x90C1, [3970] = 0x90C2,
  [3971] = 0x90C3, [3972] = 0x90C4, [3973] = 0x90C5, [3974] = 0x90C6,
  [3975] = 0x90C7, [3976] = 0x90C8, [3977] = 0x90C9, [3978] = 0x90CA,
  [3979] = 0x90CB, [3980] = 0x90CC, [3981] = 0x90CD, [3982] = 0x90CE,
  [3983] = 0x90CF, [3984] = 0x90D0, [3985] = 0x90D1, [3986] = 0x90D2,
  [3987] = 0x90D3, [3988] = 0x90D4, [3989] = 0x90D5, [3990] = 0x90D6,
  [3991] = 0x90D7, [3992] = 0x90D8, [3993] = 0x90D9, [3994] = 0x90DA,
  [3995] = 0x90DB, [3996] = 0x90DC, [3997] = 0x90DD, [3998] = 0x90DE,
  [3999] = 0x90DF, [4000] = 0x90E0, [4001] = 0x90E1, [4002] = 0x90E2,
  [4003] = 0x90E3, [4004] = 0x90E4, [4005] = 0x90E5, [4006] = 0x90E6,
  [4007] = 0x90E7, [4008] = 0x90E8, [4009] = 0x90E9, [4010] = 0x90EA,
  [4011] = 0x90EB, [4012] = 0x90EC, [4013] = 0x90ED, [4014] = 0x90EE,
  [4015] = 0x90EF, [4016] = 0x90F0, [4017] = 0x90F1, [4018] = 0x90F2,
  [4019] = 0x90F3, [4020] = 0x90F4, [4021] = 0x90F5, [4022] = 0x90F6,
  [4023] = 0x90F7, [4024] = 0x90F8, [4025] = 0x90F9, [4026] = 0x90FA,
  [4027] = 0x90FB, [4028] = 0x90FC, [4029] = 0x90FD, [4030] = 0x90FE,
  [4096] = 0x9140, [4097] = 0x9141, [4098] = 0x9142, [4099] = 0x9143,
  [4100] = 0x9144, [4101] = 0x9145, [4102] = 0x9146, [4103] = 0x9147,
  [4104] = 0x9148, [4105] = 0x9149, [4106] = 0x914A, [4107] = 0x914B,
  [4108] = 0x914C, [4109] = 0x914D, [4110] = 0x914E, [4111] = 0x914F,
  [4112] = 0x9150, [4113] = 0x9151, [4114] = 0x9152, [4115] = 0x9153,
  [4116] = 0x9154, [4117] = 0x9155, [4118] = 0x9156, [4119] = 0x9157,
  [4120] = 0x9158, [4121] = 0x9159, [4122] = 0x915A, [4123] = 0x915B,
  [4124] = 0x915C, [4125] = 0x915D, [4126] = 0x915E, [4127] = 0x915F,
  [4128] = 0x9160, [4129] = 0x9161, [4130] = 0x9162, [4131] = 0x9163,
  [4132] = 0x9164, [4133] = 0x9165, [4134] = 0x9166, [4135] = 0x9167,
  [4136] = 0x9168, [4137] = 0x9169, [4138] = 0x916A, [4139] = 0x916B,
  [4140] = 0x916C, [4141] = 0x916D, [4142] = 0x916E, [4143] = 0x916F,
  [4144] = 0x9170, [4145] = 0x9171, [4146] = 0x9172, [4147] = 0x9173,
  [4148] = 0x9174, [4149] = 0x9175, [4150] = 0x9176, [4151] = 0x9177,
  [4152] = 0x9178, [4153] = 0x9179, [4154] = 0x917A, [4155] = 0x917B,
  [4156] = 0x917C, [4157] = 0x917D, [4158] = 0x917E, [4160] = 0x9180,
  [4161] = 0x9181, [4162] = 0x9182, [4163] = 0x9183, [4164] = 0x9184,
  [4165] = 0x9185, [4166] = 0x9186, [4167] = 0x9187, [4168] = 0x9188,
  [4169] = 0x9189, [4170] = 0x918A, [4171] = 0x918B, [4172] = 0x918C,
  [4173] = 0x918D, [4174] = 0x918E, [4175] = 0x918F, [4176] = 0x9190,
  [4177] = 0x9191, [4178] = 0x9192, [4179] = 0x9193, [4180] = 0x9194,
  [4181] = 0x9195, [4182] = 0x9196, [4183] = 0x9197, [4184] = 0x9198,
  [4185] = 0x9199, [4186] = 0x919A, [4187] = 0x919B, [4188] = 0x919C,
  [4189] = 0x919D, [4190] = 0x919E, [4191] = 0x919F, [4192] = 0x91A0,
  [4193] = 0x91A1, [4194] = 0x91A2, [4195] = 0x91A3, [4196] = 0x91A4,
  [4197] = 0x91A5, [4198] = 0x91A6, [4199] = 0x91A7, [4200] = 0x91A8,
  [4201] = 0x91A9, [4202] = 0x91AA, [4203] = 0x91AB, [4204] = 0x91AC,
  [4205] = 0x91AD, [4206] = 0x91AE, [4207] = 0x91AF, [4208] = 0x91B0,
  [4209] = 0x91B1, [4210] = 0x91B2, [4211] = 0x91B3, [4212] = 0x91B4,
  [4213] = 0x91B5, [4214] = 0x91B6, [4215] = 0x91B7, [4216] = 0x91B8,
  [4217] = 0x91B9, [4218] = 0x91BA, [4219] = 0x91BB, [4220] = 0x91BC,
  [4221] = 0x91BD, [4222] = 0x91BE, [4223] = 0x91BF, [4224] = 0x91C0,
  [4225] = 0x91C1, [4226] = 0x91C2, [4227] = 0x91C3, [4228] = 0x91C4,
  [4229] = 0x91C5, [4230] = 0x91C6, [4231] = 0x91C7, [4232] = 0x91C8,
  [4233] = 0x91C9, [4234] = 0x91CA, [4235] = 0x91CB, [4236] = 0x91CC,
  [4237] = 0x91CD, [4238] = 0x91CE, [4239] = 0x91CF, [4240] = 0x91D0,
  [4241] = 0x91D1, [4242] = 0x91D2, [4243] = 0x91D3, [4244] = 0x91D4,
  [4245] = 0x91D5, [4246] = 0x91D6, [4247] = 0x91D7, [4248] = 0x91D8,
  [4249] = 0x91D9, [4250] = 0x91DA, [4251] = 0x91DB, [4252] = 0x91DC,
  [4253] = 0x91DD, [4254] = 0x91DE, [4255] = 0x91DF, [4256] = 0x91E0,
  [4257] = 0x91E1, [4258] = 0x91E2, [4259] = 0x91E3, [4260] = 0x91E4,
  [4261] = 0x91E5, [4262] = 0x91E6, [4263] = 0x91E7, [4264] = 0x91E8,
  [4265] = 0x91E9, [4266] = 0x91EA, [4267] = 0x91EB, [4268] = 0x91EC,
  [4269] = 0x91ED, [4270] = 0x91EE, [4271] = 0x91EF, [4272] = 0x91F0,
  [4273] = 0x91F1, [4274] = 0x91F2, [4275] = 0x91F3, [4276] = 0x91F4,
  [4277] = 0x91F5, [4278] = 0x91F6, [4279] = 0x91F7, [4280] = 0x91F8,
  [4281] = 0x91F9, [4282] = 0x91FA, [4283] = 0x91FB, [4284] = 0x91FC,
  [4285] = 0x91FD, [4286] = 0x91FE, [4352] = 0x9240, [4353] = 0x9241,
  [4354] = 0x9242, [4355] = 0x9243, [4356] = 0x9244, [4357] = 0x9245,
  [4358] = 0x9246, [4359] = 0x9247, [4360] = 0x9248, [4361] = 0x9249,
  [4362] = 0x924A, [4363] = 0x924B, [4364] = 0x924C, [4365] = 0x924D,
  [4366] = 0x924E, [4367] = 0x924F, [4368] = 0x9250, [4369] = 0x9251,
  [4370] = 0x9252, [4371] = 0x9253, [4372] = 0x9254, [4373] = 0x9255,
  [4374] = 0x9256, [4375] = 0x9257, [4376] = 0x9258, [4377] = 0x9259,
  [4378] = 0x925A, [4379] = 0x925B, [4380] = 0x925C, [4381] = 0x925D,
  [4382] = 0x925E, [4383] = 0x925F, [4384] = 0x9260, [4385] = 0x9261,
  [4386] = 0x9262, [4387] = 0x9263, [4388] = 0x9264, [4389] = 0x9265,
  [4390] = 0x9266, [4391] = 0x9267, [4392] = 0x9268, [4393] = 0x9269,
  [4394] = 0x926A, [4395] = 0x926B, [4396] = 0x926C, [4397] = 0x926D,
  [4398] = 0x926E, [4399] = 0x926F, [4400] = 0x9270, [4401] = 0x9271,
  [4402] = 0x9272, [4403] = 0x9273, [4404] = 0x9274, [4405] = 0x9275,
  [4406] = 0x9276, [4407] = 0x9277, [4408] = 0x9278, [4409] = 0x9279,
  [4410] = 0x927A, [4411] = 0x927B, [4412] = 0x927C, [4413] = 0x927D,
  [4414] = 0x927E, [4416] = 0x9280, [4417] = 0x9281, [4418] = 0x9282,
  [4419] = 0x9283, [4420] = 0x9284, [4421] = 0x9285, [4422] = 0x9286,
  [4423] = 0x9287, [4424] = 0x9288, [4425] = 0x9289, [4426] = 0x928A,
  [4427] = 0x928B, [4428] = 0x928C, [4429] = 0x928D, [4430] = 0x928E,
  [4431] = 0x928F, [4432] = 0x9290, [4433] = 0x9291, [4434] = 0x9292,
  [4435] = 0x9293, [4436] = 0x9294, [4437] = 0x9295, [4438] = 0x9296,
  [4439] = 0x9297, [4440] = 0x9298, [4441] = 0x9299, [4442] = 0x929A,
  [4443] = 0x929B, [4444] = 0x929C, [4445] = 0x929D, [4446] = 0x929E,
  [4447] = 0x929F, [4448] = 0x92A0, [4449] = 0x92A1, [4450] = 0x92A2,
  [4451] = 0x92A3, [4452] = 0x92A4, [4453] = 0x92A5, [4454] = 0x92A6,
  [4455] = 0x92A7, [4456] = 0x92A8, [4457] = 0x92A9, [4458] = 0x92AA,
  [4459] = 0x92AB, [4460] = 0x92AC, [4461] = 0x92AD, [4462] = 0x92AE,
  [4463] = 0x92AF, [4464] = 0x92B0, [4465] = 0x92B1, [4466] = 0x92B2,
  [4467] = 0x92B3, [4468] = 0x92B4, [4469] = 0x92B5, [4470] = 0x92B6,
  [4471] = 0x92B7, [4472] = 0x92B8, [4473] = 0x92B9, [4474] = 0x92BA,
  [4475] = 0x92BB, [4476] = 0x92BC, [4477] = 0x92BD, [4478] = 0x92BE,
  [4479] = 0x92BF, [4480] = 0x92C0, [4481] = 0x92C1, [4482] = 0x92C2,
  [4483] = 0x92C3, [4484] = 0x92C4, [4485] = 0x92C5, [4486] = 0x92C6,
  [4487] = 0x92C7, [4488] = 0x92C8, [4489] = 0x92C9, [4490] = 0x92CA,
  [4491] = 0x92CB, [4492] = 0x92CC, [4493] = 0x92CD, [4494] = 0x92CE,
  [4495] = 0x92CF, [4496] = 0x92D0, [4497] = 0x92D1, [4498] = 0x92D2,
  [4499] = 0x92D3, [4500] = 0x92D4, [4501] = 0x92D5, [4502] = 0x92D6,
  [4503] = 0x92D7, [4504] = 0x92D8, [4505] = 0x92D9, [4506] = 0x92DA,
  [4507] = 0x92DB, [4508] = 0x92DC, [4509] = 0x92DD, [4510] = 0x92DE,
  [4511] = 0x92DF, [4512] = 0x92E0, [4513] = 0x92E1, [4514] = 0x92E2,
  [4515] = 0x92E3, [4516] = 0x92E4, [4517] = 0x92E5, [4518] = 0x92E6,
  [4519] = 0x92E7, [4520] = 0x92E8, [4521] = 0x92E9, [4522] = 0x92EA,
  [4523] = 0x92EB, [4524] = 0x92EC, [4525] = 0x92ED, [4526] = 0x92EE,
  [4527] = 0x92EF, [4528] = 0x92F0, [4529] = 0x92F1, [4530] = 0x92F2,
  [4531] = 0x92F3, [4532] = 0x92F4, [4533] = 0x92F5, [4534] = 0x92F6,
  [4535] = 0x92F7, [4536] = 0x92F8, [4537] = 0x92F9, [4538] = 0x92FA,
  [4539] = 0x92FB, [4540] = 0x92FC, [4541] = 0x92FD, [4542] = 0x92FE,
  [4608] = 0x9340, [4609] = 0x9341, [4610] = 0x9342, [4611] = 0x9343,
  [4612] = 0x9344, [4613] = 0x9345, [4614] = 0x9346, [4615] = 0x9347,
  [4616] = 0x9348, [4617] = 0x9349, [4618] = 0x934A, [4619] = 0x934B,
  [4620] = 0x934C, [4621] = 0x934D, [4622] = 0x934E, [4623] = 0x934F,
  [4624] = 0x9350, [4625] = 0x9351, [4626] = 0x9352, [4627] = 0x9353,
  [4628] = 0x9354, [4629] = 0x9355, [4630] = 0x9356, [4631] = 0x9357,
  [4632] = 0x9358, [4633] = 0x9359, [4634] = 0x935A, [4635] = 0x935B,
  [4636] = 0x935C, [4637] = 0x935D, [4638] = 0x935E, [4639] = 0x935F,
  [4640] = 0x9360, [4641] = 0x9361, [4642] = 0x9362, [4643] = 0x9363,
  [4644] = 0x9364, [4645] = 0x9365, [4646] = 0x9366, [4647] = 0x9367,
  [4648] = 0x9368, [4649] = 0x9369, [4650] = 0x936A, [4651] = 0x936B,
  [4652] = 0x936C, [4653] = 0x936D, [4654] = 0x936E, [4655] = 0x936F,
  [4656] = 0x9370, [4657] = 0x9371, [4658] = 0x9372, [4659] = 0x9373,
  [4660] = 0x9374, [4661] = 0x9375, [4662] = 0x9376, [4663] = 0x9377,
  [4664] = 0x9378, [4665] = 0x9379, [4666] = 0x937A, [4667] = 0x937B,
  [4668] = 0x937C, [4669] = 0x937D, [4670] = 0x937E, [4672] = 0x9380,
  [4673] = 0x9381, [4674] = 0x9382, [4675] = 0x9383, [4676] = 0x9384,
  [4677] = 0x9385, [4678] = 0x9386, [4679] = 0x9387, [4680] = 0x9388,
  [4681] = 0x9389, [4682] = 0x938A, [4683] = 0x938B, [4684] = 0x938C,
  [4685] = 0x938D, [4686] = 0x938E, [4687] = 0x938F, [4688] = 0x9390,
  [4689] = 0x9391, [4690] = 0x9392, [4691] = 0x9393, [4692] = 0x9394,
  [4693] = 0x9395, [4694] = 0x9396, [4695] = 0x9397, [4696] = 0x9398,
  [4697] = 0x9399, [4698] = 0x939A, [4699] = 0x939B, [4700] = 0x939C,
  [4701] = 0x939D, [4702] = 0x939E, [4703] = 0x939F, [4704] = 0x93A0,
  [4705] = 0x93A1, [4706] = 0x93A2, [4707] = 0x93A3, [4708] = 0x93A4,
  [4709] = 0x93A5, [4710] = 0x93A6, [4711] = 0x93A7, [4712] = 0x93A8,
  [4713] = 0x93A9, [4714] = 0x93AA, [4715] = 0x93AB, [4716] = 0x93AC,
  [4717] = 0x93AD, [4718] = 0x93AE, [4719] = 0x93AF, [4720] = 0x93B0,
  [4721] = 0x93B1, [4722] = 0x93B2, [4723] = 0x93B3, [4724] = 0x93B4,
  [4725] = 0x93B5, [4726] = 0x93B6, [4727] = 0x93B7, [4728] = 0x93B8,
  [4729] = 0x93B9, [4730] = 0x93BA, [4731] = 0x93BB, [4732] = 0x93BC,
  [4733] = 0x93BD, [4734] = 0x93BE, [4735] = 0x93BF, [4736] = 0x93C0,
  [4737] = 0x93C1, [4738] = 0x93C2, [4739] = 0x93C3, [4740] = 0x93C4,
  [4741] = 0x93C5, [4742] = 0x93C6, [4743] = 0x93C7, [4744] = 0x93C8,
  [4745] = 0x93C9, [4746] = 0x93CA, [4747] = 0x93CB, [4748] = 0x93CC,
  [4749] = 0x93CD, [4750] = 0x93CE, [4751] = 0x93CF, [4752] = 0x93D0,
  [4753] = 0x93D1, [4754] = 0x93D2, [4755] = 0x93D3, [4756] = 0x93D4,
  [4757] = 0x93D5, [4758] = 0x93D6, [4759] = 0x93D7, [4760] = 0x93D8,
  [4761] = 0x93D9, [4762] = 0x93DA, [4763] = 0x93DB, [4764] = 0x93DC,
  [4765] = 0x93DD, [4766] = 0x93DE, [4767] = 0x93DF, [4768] = 0x93E0,
  [4769] = 0x93E1, [4770] = 0x93E2, [4771] = 0x93E3, [4772] = 0x93E4,
  [4773] = 0x93E5, [4774] = 0x93E6, [4775] = 0x93E7, [4776] = 0x93E8,
  [4777] = 0x93E9, [4778] = 0x93EA, [4779] = 0x93EB, [4780] = 0x93EC,
  [4781] = 0x93ED, [4782] = 0x93EE, [4783] = 0x93EF, [4784] = 0x93F0,
  [4785] = 0x93F1, [4786] = 0x93F2, [4787] = 0x93F3, [4788] = 0x93F4,
  [4789] = 0x93F5, [4790] = 0x93F6, [4791] = 0x93F7, [4792] = 0x93F8,
  [4793] = 0x93F9, [4794] = 0x93FA, [4795] = 0x93FB, [4796] = 0x93FC,
  [4797] = 0x93FD, [4798] = 0x93FE, [4864] = 0x9440, [4865] = 0x9441,
  [4866] = 0x9442, [4867] = 0x9443, [4868] = 0x9444, [4869] = 0x9445,
  [4870] = 0x9446, [4871] = 0x9447, [4872] = 0x9448, [4873] = 0x9449,
  [4874] = 0x944A, [4875] = 0x944B, [4876] = 0x944C, [4877] = 0x944D,
  [4878] = 0x944E, [4879] = 0x944F, [4880] = 0x9450, [4881] = 0x9451,
  [4882] = 0x9452, [4883] = 0x9453, [4884] = 0x9454, [4885] = 0x9455,
  [4886] = 0x9456, [4887] = 0x9457, [4888] = 0x9458, [4889] = 0x9459,
  [4890] = 0x945A, [4891] = 0x945B, [4892] = 0x945C, [4893] = 0x945D,
  [4894] = 0x945E, [4895] = 0x945F, [4896] = 0x9460, [4897] = 0x9461,
  [4898] = 0x9462, [4899] = 0x9463, [4900] = 0x9464, [4901] = 0x9465,
  [4902] = 0x9466, [4903] = 0x9467, [4904] = 0x9468, [4905] = 0x9469,
  [4906] = 0x946A, [4907] = 0x946B, [4908] = 0x946C, [4909] = 0x946D,
  [4910] = 0x946E, [4911] = 0x946F, [4912] = 0x9470, [4913] = 0x9471,
  [4914] = 0x9472, [4915] = 0x9473, [4916] = 0x9474, [4917] = 0x9475,
  [4918] = 0x9476, [4919] = 0x9477, [4920] = 0x9478, [4921] = 0x9479,
  [4922] = 0x947A, [4923] = 0x947B, [4924] = 0x947C, [4925] = 0x947D,
  [4926] = 0x947E, [4928] = 0x9480, [4929] = 0x9481, [4930] = 0x9482,
  [4931] = 0x9483, [4932] = 0x9484, [4933] = 0x9485, [4934] = 0x9486,
  [4935] = 0x9487, [4936] = 0x9488, [4937] = 0x9489, [4938] = 0x948A,
  [4939] = 0x948B, [4940] = 0x948C, [4941] = 0x948D, [4942] = 0x948E,
  [4943] = 0x948F, [4944] = 0x9490, [4945] = 0x9491, [4946] = 0x9492,
  [4947] = 0x9493, [4948] = 0x9494, [4949] = 0x9495, [4950] = 0x9496,
  [4951] = 0x9497, [4952] = 0x9498, [4953] = 0x9499, [4954] = 0x949A,
  [4955] = 0x949B, [4956] = 0x949C, [4957] = 0x949D, [4958] = 0x949E,
  [4959] = 0x949F, [4960] = 0x94A0, [4961] = 0x94A1, [4962] = 0x94A2,
  [4963] = 0x94A3, [4964] = 0x94A4, [4965] = 0x94A5, [4966] = 0x94A6,
  [4967] = 0x94A7, [4968] = 0x94A8, [4969] = 0x94A9, [4970] = 0x94AA,
  [4971] = 0x94AB, [4972] = 0x94AC, [4973] = 0x94AD, [4974] = 0x94AE,
  [4975] = 0x94AF, [4976] = 0x94B0, [4977] = 0x94B1, [4978] = 0x94B2,
  [4979] = 0x94B3, [4980] = 0x94B4, [4981] = 0x94B5, [4982] = 0x94B6,
  [4983] = 0x94B7, [4984] = 0x94B8, [4985] = 0x94B9, [4986] = 0x94BA,
  [4987] = 0x94BB, [4988] = 0x94BC, [4989] = 0x94BD, [4990] = 0x94BE,
  [4991] = 0x94BF, [4992] = 0x94C0, [4993] = 0x94C1, [4994] = 0x94C2,
  [4995] = 0x94C3, [4996] = 0x94C4, [4997] = 0x94C5, [4998] = 0x94C6,
  [4999] = 0x94C7, [5000] = 0x94C8, [5001] = 0x94C9, [5002] = 0x94CA,
  [5003] = 0x94CB, [5004] = 0x94CC, [5005] = 0x94CD, [5006] = 0x94CE,
  [5007] = 0x94CF, [5008] = 0x94D0, [5009] = 0x94D1, [5010] = 0x94D2,
  [5011] = 0x94D3, [5012] = 0x94D4, [5013] = 0x94D5, [5014] = 0x94D6,
  [5015] = 0x94D7, [5016] = 0x94D8, [5017] = 0x94D9, [5018] = 0x94DA,
  [5019] = 0x94DB, [5020] = 0x94DC, [5021] = 0x94DD, [5022] = 0x94DE,
  [5023] = 0x94DF, [5024] = 0x94E0, [5025] = 0x94E1, [5026] = 0x94E2,
  [5027] = 0x94E3, [5028] = 0x94E4, [5029] = 0x94E5, [5030] = 0x94E6,
  [5031] = 0x94E7, [5032] = 0x94E8, [5033] = 0x94E9, [5034] = 0x94EA,
  [5035] = 0x94EB, [5036] = 0x94EC, [5037] = 0x94ED, [5038] = 0x94EE,
  [5039] = 0x94EF, [5040] = 0x94F0, [5041] = 0x94F1, [5042] = 0x94F2,
  [5043] = 0x94F3, [5044] = 0x94F4, [5045] = 0x94F5, [5046] = 0x94F6,
  [5047] = 0x94F7, [5048] = 0x94F8, [5049] = 0x94F9, [5050] = 0x94FA,
  [5051] = 0x94FB, [5052] = 0x94FC, [5053] = 0x94FD, [5054] = 0x94FE,
  [5120] = 0x9540, [5121] = 0x9541, [5122] = 0x9542, [5123] = 0x9543,
  [5124] = 0x9544, [5125] = 0x9545, [5126] = 0x9546, [5127] = 0x9547,
  [5128] = 0x9548, [5129] = 0x9549, [5130] = 0x954A, [5131] = 0x954B,
  [5132] = 0x954C, [5133] = 0x954D, [5134] = 0x954E, [5135] = 0x954F,
  [5136] = 0x9550, [5137] = 0x9551, [5138] = 0x9552, [5139] = 0x9553,
  [5140] = 0x9554, [5141] = 0x9555, [5142] = 0x9556, [5143] = 0x9557,
  [5144] = 0x9558, [5145] = 0x9559, [5146] = 0x955A, [5147] = 0x955B,
  [5148] = 0x955C, [5149] = 0x955D, [5150] = 0x955E, [5151] = 0x955F,
  [5152] = 0x9560, [5153] = 0x9561, [5154] = 0x9562, [5155] = 0x9563,
  [5156] = 0x9564, [5157] = 0x9565, [5158] = 0x9566, [5159] = 0x9567,
  [5160] = 0x9568, [5161] = 0x9569, [5162] = 0x956A, [5163] = 0x956B,
  [5164] = 0x956C, [5165] = 0x956D, [5166] = 0x956E, [5167] = 0x956F,
  [5168] = 0x9570, [5169] = 0x9571, [5170] = 0x9572, [5171] = 0x9573,
  [5172] = 0x9574, [5173] = 0x9575, [5174] = 0x9576, [5175] = 0x9577,
  [5176] = 0x9578, [5177] = 0x9579, [5178] = 0x957A, [5179] = 0x957B,
  [5180] = 0x957C, [5181] = 0x957D, [5182] = 0x957E, [5184] = 0x9580,
  [5185] = 0x9581, [5186] = 0x9582, [5187] = 0x9583, [5188] = 0x9584,
  [5189] = 0x9585, [5190] = 0x9586, [5191] = 0x9587, [5192] = 0x9588,
  [5193] = 0x9589, [5194] = 0x958A, [5195] = 0x958B, [5196] = 0x958C,
  [5197] = 0x958D, [5198] = 0x958E, [5199] = 0x958F, [5200] = 0x9590,
  [5201] = 0x9591, [5202] = 0x9592, [5203] = 0x9593, [5204] = 0x9594,
  [5205] = 0x9595, [5206] = 0x9596, [5207] = 0x9597, [5208] = 0x9598,
  [5209] = 0x9599, [5210] = 0x959A, [5211] = 0x959B, [5212] = 0x959C,
  [5213] = 0x959D, [5214] = 0x959E, [5215] = 0x959F, [5216] = 0x95A0,
  [5217] = 0x95A1, [5218] = 0x95A2, [5219] = 0x95A3, [5220] = 0x95A4,
  [5221] = 0x95A5, [5222] = 0x95A6, [5223] = 0x95A7, [5224] = 0x95A8,
  [5225] = 0x95A9, [5226] = 0x95AA, [5227] = 0x95AB, [5228] = 0x95AC,
  [5229] = 0x95AD, [5230] = 0x95AE, [5231] = 0x95AF, [5232] = 0x95B0,
  [5233] = 0x95B1, [5234] = 0x95B2, [5235] = 0x95B3, [5236] = 0x95B4,
  [5237] = 0x95B5, [5238] = 0x95B6, [5239] = 0x95B7, [5240] = 0x95B8,
  [5241] = 0x95B9, [5242] = 0x95BA, [5243] = 0x95BB, [5244] = 0x95BC,
  [5245] = 0x95BD, [5246] = 0x95BE, [5247] = 0x95BF, [5248] = 0x95C0,
  [5249] = 0x95C1, [5250] = 0x95C2, [5251] = 0x95C3, [5252] = 0x95C4,
  [5253] = 0x95C5, [5254] = 0x95C6, [5255] = 0x95C7, [5256] = 0x95C8,
  [5257] = 0x95C9, [5258] = 0x95CA, [5259] = 0x95CB, [5260] = 0x95CC,
  [5261] = 0x95CD, [5262] = 0x95CE, [5263] = 0x95CF, [5264] = 0x95D0,
  [5265] = 0x95D1, [5266] = 0x95D2, [5267] = 0x95D3, [5268] = 0x95D4,
  [5269] = 0x95D5, [5270] = 0x95D6, [5271] = 0x95D7, [5272] = 0x95D8,
  [5273] = 0x95D9, [5274] = 0x95DA, [5275] = 0x95DB, [5276] = 0x95DC,
  [5277] = 0x95DD, [5278] = 0x95DE, [5279] = 0x95DF, [5280] = 0x95E0,
  [5281] = 0x95E1, [5282] = 0x95E2, [5283] = 0x95E3, [5284] = 0x95E4,
  [5285] = 0x95E5, [5286] = 0x95E6, [5287] = 0x95E7, [5288] = 0x95E8,
  [5289] = 0x95E9, [5290] = 0x95EA, [5291] = 0x95EB, [5292] = 0x95EC,
  [5293] = 0x95ED, [5294] = 0x95EE, [5295] = 0x95EF, [5296] = 0x95F0,
  [5297] = 0x95F1, [5298] = 0x95F2, [5299] = 0x95F3, [5300] = 0x95F4,
  [5301] = 0x95F5, [5302] = 0x95F6, [5303] = 0x95F7, [5304] = 0x95F8,
  [5305] = 0x95F9, [5306] = 0x95FA, [5307] = 0x95FB, [5308] = 0x95FC,
  [5309] = 0x95FD, [5310] = 0x95FE, [5376] = 0x9640, [5377] = 0x9641,
  [5378] = 0x9642, [5379] = 0x9643, [5380] = 0x9644, [5381] = 0x9645,
  [5382] = 0x9646, [5383] = 0x9647, [5384] = 0x9648, [5385] = 0x9649,
  [5386] = 0x964A, [5387] = 0x964B, [5388] = 0x964C, [5389] = 0x964D,
  [5390] = 0x964E, [5391] = 0x964F, [5392] = 0x9650, [5393] = 0x9651,
  [5394] = 0x9652, [5395] = 0x9653, [5396] = 0x9654, [5397] = 0x9655,
  [5398] = 0x9656, [5399] = 0x9657, [5400] = 0x9658, [5401] = 0x9659,
  [5402] = 0x965A, [5403] = 0x965B, [5404] = 0x965C, [5405] = 0x965D,
  [5406] = 0x965E, [5407] = 0x965F, [5408] = 0x9660, [5409] = 0x9661,
  [5410] = 0x9662, [5411] = 0x9663, [5412] = 0x9664, [5413] = 0x9665,
  [5414] = 0x9666, [5415] = 0x9667, [5416] = 0x9668, [5417] = 0x9669,
  [5418] = 0x966A, [5419] = 0x966B, [5420] = 0x966C, [5421] = 0x966D,
  [5422] = 0x966E, [5423] = 0x966F, [5424] = 0x9670, [5425] = 0x9671,
  [5426] = 0x9672, [5427] = 0x9673, [5428] = 0x9674, [5429] = 0x9675,
  [5430] = 0x9676, [5431] = 0x9677, [5432] = 0x9678, [5433] = 0x9679,
  [5434] = 0x967A, [5435] = 0x967B, [5436] = 0x967C, [5437] = 0x967D,
  [5438] = 0x967E, [5440] = 0x9680, [5441] = 0x9681, [5442] = 0x9682,
  [5443] = 0x9683, [5444] = 0x9684, [5445] = 0x9685, [5446] = 0x9686,
  [5447] = 0x9687, [5448] = 0x9688, [5449] = 0x9689, [5450] = 0x968A,
  [5451] = 0x968B, [5452] = 0x968C, [5453] = 0x968D, [5454] = 0x968E,
  [5455] = 0x968F, [5456] = 0x9690, [5457] = 0x9691, [5458] = 0x9692,
  [5459] = 0x9693, [5460] = 0x9694, [5461] = 0x9695, [5462] = 0x9696,
  [5463] = 0x9697, [5464] = 0x9698, [5465] = 0x9699, [5466] = 0x969A,
  [5467] = 0x969B, [5468] = 0x969C, [5469] = 0x969D, [5470] = 0x969E,
  [5471] = 0x969F, [5472] = 0x96A0, [5473] = 0x96A1, [5474] = 0x96A2,
  [5475] = 0x96A3, [5476] = 0x96A4, [5477] = 0x96A5, [5478] = 0x96A6,
  [5479] = 0x96A7, [5480] = 0x96A8, [5481] = 0x96A9, [5482] = 0x96AA,
  [5483] = 0x96AB, [5484] = 0x96AC, [5485] = 0x96AD, [5486] = 0x96AE,
  [5487] = 0x96AF, [5488] = 0x96B0, [5489] = 0x96B1, [5490] = 0x96B2,
  [5491] = 0x96B3, [5492] = 0x96B4, [5493] = 0x96B5, [5494] = 0x96B6,
  [5495] = 0x96B7, [5496] = 0x96B8, [5497] = 0x96B9, [5498] = 0x96BA,
  [5499] = 0x96BB, [5500] = 0x96BC, [5501] = 0x96BD, [5502] = 0x96BE,
  [5503] = 0x96BF, [5504] = 0x96C0, [5505] = 0x96C1, [5506] = 0x96C2,
  [5507] = 0x96C3, [5508] = 0x96C4, [5509] = 0x96C5, [5510] = 0x96C6,
  [5511] = 0x96C7, [5512] = 0x96C8, [5513] = 0x96C9, [5514] = 0x96CA,
  [5515] = 0x96CB, [5516] = 0x96CC, [5517] = 0x96CD, [5518] = 0x96CE,
  [5519] = 0x96CF, [5520] = 0x96D0, [5521] = 0x96D1, [5522] = 0x96D2,
  [5523] = 0x96D3, [5524] = 0x96D4, [5525] = 0x96D5, [5526] = 0x96D6,
  [5527] = 0x96D7, [5528] = 0x96D8, [5529] = 0x96D9, [5530] = 0x96DA,
  [5531] = 0x96DB, [5532] = 0x96DC, [5533] = 0x96DD, [5534] = 0x96DE,
  [5535] = 0x96DF, [5536] = 0x96E0, [5537] = 0x96E1, [5538] = 0x96E2,
  [5539] = 0x96E3, [5540] = 0x96E4, [5541] = 0x96E5, [5542] = 0x96E6,
  [5543] = 0x96E7, [5544] = 0x96E8, [5545] = 0x96E9, [5546] = 0x96EA,
  [5547] = 0x96EB, [5548] = 0x96EC, [5549] = 0x96ED, [5550] = 0x96EE,
  [5551] = 0x96EF, [5552] = 0x96F0, [5553] = 0x96F1, [5554] = 0x96F2,
  [5555] = 0x96F3, [5556] = 0x96F4, [5557] = 0x96F5, [5558] = 0x96F6,
  [5559] = 0x96F7, [5560] = 0x96F8, [5561] = 0x96F9, [5562] = 0x96FA,
  [5563] = 0x96FB, [5564] = 0x96FC, [5565] = 0x96FD, [5566] = 0x96FE,
  [5632] = 0x9740, [5633] = 0x9741, [5634] = 0x9742, [5635] = 0x9743,
  [5636] = 0x9744, [5637] = 0x9745, [5638] = 0x9746, [5639] = 0x9747,
  [5640] = 0x9748, [5641] = 0x9749, [5642] = 0x974A, [5643] = 0x974B,
  [5644] = 0x974C, [5645] = 0x974D, [5646] = 0x974E, [5647] = 0x974F,
  [5648] = 0x9750, [5649] = 0x9751, [5650] = 0x9752, [5651] = 0x9753,
  [5652] = 0x9754, [5653] = 0x9755, [5654] = 0x9756, [5655] = 0x9757,
  [5656] = 0x9758, [5657] = 0x9759, [5658] = 0x975A, [5659] = 0x975B,
  [5660] = 0x975C, [5661] = 0x975D, [5662] = 0x975E, [5663] = 0x975F,
  [5664] = 0x9760, [5665] = 0x9761, [5666] = 0x9762, [5667] = 0x9763,
  [5668] = 0x9764, [5669] = 0x9765, [5670] = 0x9766, [5671] = 0x9767,
  [5672] = 0x9768, [5673] = 0x9769, [5674] = 0x976A, [5675] = 0x976B,
  [5676] = 0x976C, [5677] = 0x976D, [5678] = 0x976E, [5679] = 0x976F,
  [5680] = 0x9770, [5681] = 0x9771, [5682] = 0x9772, [5683] = 0x9773,
  [5684] = 0x9774, [5685] = 0x9775, [5686] = 0x9776, [5687] = 0x9777,
  [5688] = 0x9778, [5689] = 0x9779, [5690] = 0x977A, [5691] = 0x977B,
  [5692] = 0x977C, [5693] = 0x977D, [5694] = 0x977E, [5696] = 0x9780,
  [5697] = 0x9781, [5698] = 0x9782, [5699] = 0x9783, [5700] = 0x9784,
  [5701] = 0x9785, [5702] = 0x9786, [5703] = 0x9787, [5704] = 0x9788,
  [5705] = 0x9789, [5706] = 0x978A, [5707] = 0x978B, [5708] = 0x978C,
  [5709] = 0x978D, [5710] = 0x978E, [5711] = 0x978F, [5712] = 0x9790,
  [5713] = 0x9791, [5714] = 0x9792, [5715] = 0x9793, [5716] = 0x9794,
  [5717] = 0x9795, [5718] = 0x9796, [5719] = 0x9797, [5720] = 0x9798,
  [5721] = 0x9799, [5722] = 0x979A, [5723] = 0x979B, [5724] = 0x979C,
  [5725] = 0x979D, [5726] = 0x979E, [5727] = 0x979F, [5728] = 0x97A0,
  [5729] = 0x97A1, [5730] = 0x97A2, [5731] = 0x97A3, [5732] = 0x97A4,
  [5733] = 0x97A5, [5734] = 0x97A6, [5735] = 0x97A7, [5736] = 0x97A8,
  [5737] = 0x97A9, [5738] = 0x97AA, [5739] = 0x97AB, [5740] = 0x97AC,
  [5741] = 0x97AD, [5742] = 0x97AE, [5743] = 0x97AF, [5744] = 0x97B0,
  [5745] = 0x97B1, [5746] = 0x97B2, [5747] = 0x97B3, [5748] = 0x97B4,
  [5749] = 0x97B5, [5750] = 0x97B6, [5751] = 0x97B7, [5752] = 0x97B8,
  [5753] = 0x97B9, [5754] = 0x97BA, [5755] = 0x97BB, [5756] = 0x97BC,
  [5757] = 0x97BD, [5758] = 0x97BE, [5759] = 0x97BF, [5760] = 0x97C0,
  [5761] = 0x97C1, [5762] = 0x97C2, [5763] = 0x97C3, [5764] = 0x97C4,
  [5765] = 0x97C5, [5766] = 0x97C6, [5767] = 0x97C7, [5768] = 0x97C8,
  [5769] = 0x97C9, [5770] = 0x97CA, [5771] = 0x97CB, [5772] = 0x97CC,
  [5773] = 0x97CD, [5774] = 0x97CE, [5775] = 0x97CF, [5776] = 0x97D0,
  [5777] = 0x97D1, [5778] = 0x97D2, [5779] = 0x97D3, [5780] = 0x97D4,
  [5781] = 0x97D5, [5782] = 0x97D6, [5783] = 0x97D7, [5784] = 0x97D8,
  [5785] = 0x97D9, [5786] = 0x97DA, [5787] = 0x97DB, [5788] = 0x97DC,
  [5789] = 0x97DD, [5790] = 0x97DE, [5791] = 0x97DF, [5792] = 0x97E0,
  [5793] = 0x97E1, [5794] = 0x97E2, [5795] = 0x97E3, [5796] = 0x97E4,
  [5797] = 0x97E5, [5798] = 0x97E6, [5799] = 0x97E7, [5800] = 0x97E8,
  [5801] = 0x97E9, [5802] = 0x97EA, [5803] = 0x97EB, [5804] = 0x97EC,
  [5805] = 0x97ED, [5806] = 0x97EE, [5807] = 0x97EF, [5808] = 0x97F0,
  [5809] = 0x97F1, [5810] = 0x97F2, [5811] = 0x97F3, [5812] = 0x97F4,
  [5813] = 0x97F5, [5814] = 0x97F6, [5815] = 0x97F7, [5816] = 0x97F8,
  [5817] = 0x97F9, [5818] = 0x97FA, [5819] = 0x97FB, [5820] = 0x97FC,
  [5821] = 0x97FD, [5822] = 0x97FE, [5888] = 0x9840, [5889] = 0x9841,
  [5890] = 0x9842, [5891] = 0x9843, [5892] = 0x9844, [5893] = 0x9845,
  [5894] = 0x9846, [5895] = 0x9847, [5896] = 0x9848, [5897] = 0x9849,
  [5898] = 0x984A, [5899] = 0x984B, [5900] = 0x984C, [5901] = 0x984D,
  [5902] = 0x984E, [5903] = 0x984F, [5904] = 0x9850, [5905] = 0x9851,
  [5906] = 0x9852, [5907] = 0x9853, [5908] = 0x9854, [5909] = 0x9855,
  [5910] = 0x9856, [5911] = 0x9857, [5912] = 0x9858, [5913] = 0x9859,
  [5914] = 0x985A, [5915] = 0x985B, [5916] = 0x985C, [5917] = 0x985D,
  [5918] = 0x985E, [5919] = 0x985F, [5920] = 0x9860, [5921] = 0x9861,
  [5922] = 0x9862, [5923] = 0x9863, [5924] = 0x9864, [5925] = 0x9865,
  [5926] = 0x9866, [5927] = 0x9867, [5928] = 0x9868, [5929] = 0x9869,
  [5930] = 0x986A, [5931] = 0x986B, [5932] = 0x986C, [5933] = 0x986D,
  [5934] = 0x986E, [5935] = 0x986F, [5936] = 0x9870, [5937] = 0x9871,
  [5938] = 0x9872, [5939] = 0x9873, [5940] = 0x9874, [5941] = 0x9875,
  [5942] = 0x9876, [5943] = 0x9877, [5944] = 0x9878, [5945] = 0x9879,
  [5946] = 0x987A, [5947] = 0x987B, [5948] = 0x987C, [5949] = 0x987D,
  [5950] = 0x987E, [5952] = 0x9880, [5953] = 0x9881, [5954] = 0x9882,
  [5955] = 0x9883, [5956] = 0x9884, [5957] = 0x9885, [5958] = 0x9886,
  [5959] = 0x9887, [5960] = 0x9888, [5961] = 0x9889, [5962] = 0x988A,
  [5963] = 0x988B, [5964] = 0x988C, [5965] = 0x988D, [5966] = 0x988E,
  [5967] = 0x988F, [5968] = 0x9890, [5969] = 0x9891, [5970] = 0x9892,
  [5971] = 0x9893, [5972] = 0x9894, [5973] = 0x9895, [5974] = 0x9896,
  [5975] = 0x9897, [5976] = 0x9898, [5977] = 0x9899, [5978] = 0x989A,
  [5979] = 0x989B, [5980] = 0x989C, [5981] = 0x989D, [5982] = 0x989E,
  [5983] = 0x989F, [5984] = 0x98A0, [5985] = 0x98A1, [5986] = 0x98A2,
  [5987] = 0x98A3, [5988] = 0x98A4, [5989] = 0x98A5, [5990] = 0x98A6,
  [5991] = 0x98A7, [5992] = 0x98A8, [5993] = 0x98A9, [5994] = 0x98AA,
  [5995] = 0x98AB, [5996] = 0x98AC, [5997] = 0x98AD, [5998] = 0x98AE,
  [5999] = 0x98AF, [6000] = 0x98B0, [6001] = 0x98B1, [6002] = 0x98B2,
  [6003] = 0x98B3, [6004] = 0x98B4, [6005] = 0x98B5, [6006] = 0x98B6,
  [6007] = 0x98B7, [6008] = 0x98B8, [6009] = 0x98B9, [6010] = 0x98BA,
  [6011] = 0x98BB, [6012] = 0x98BC, [6013] = 0x98BD, [6014] = 0x98BE,
  [6015] = 0x98BF, [6016] = 0x98C0, [6017] = 0x98C1, [6018] = 0x98C2,
  [6019] = 0x98C3, [6020] = 0x98C4, [6021] = 0x98C5, [6022] = 0x98C6,
  [6023] = 0x98C7, [6024] = 0x98C8, [6025] = 0x98C9, [6026] = 0x98CA,
  [6027] = 0x98CB, [6028] = 0x98CC, [6029] = 0x98CD, [6030] = 0x98CE,
  [6031] = 0x98CF, [6032] = 0x98D0, [6033] = 0x98D1, [6034] = 0x98D2,
  [6035] = 0x98D3, [6036] = 0x98D4, [6037] = 0x98D5, [6038] = 0x98D6,
  [6039] = 0x98D7, [6040] = 0x98D8, [6041] = 0x98D9, [6042] = 0x98DA,
  [6043] = 0x98DB, [6044] = 0x98DC, [6045] = 0x98DD, [6046] = 0x98DE,
  [6047] = 0x98DF, [6048] = 0x98E0, [6049] = 0x98E1, [6050] = 0x98E2,
  [6051] = 0x98E3, [6052] = 0x98E4, [6053] = 0x98E5, [6054] = 0x98E6,
  [6055] = 0x98E7, [6056] = 0x98E8, [6057] = 0x98E9, [6058] = 0x98EA,
  [6059] = 0x98EB, [6060] = 0x98EC, [6061] = 0x98ED, [6062] = 0x98EE,
  [6063] = 0x98EF, [6064] = 0x98F0, [6065] = 0x98F1, [6066] = 0x98F2,
  [6067] = 0x98F3, [6068] = 0x98F4, [6069] = 0x98F5, [6070] = 0x98F6,
  [6071] = 0x98F7, [6072] = 0x98F8, [6073] = 0x98F9, [6074] = 0x98FA,
  [6075] = 0x98FB, [6076] = 0x98FC, [6077] = 0x98FD, [6078] = 0x98FE,
  [6144] = 0x9940, [6145] = 0x9941, [6146] = 0x9942, [6147] = 0x9943,
  [6148] = 0x9944, [6149] = 0x9945, [6150] = 0x9946, [6151] = 0x9947,
  [6152] = 0x9948, [6153] = 0x9949, [6154] = 0x994A, [6155] = 0x994B,
  [6156] = 0x994C, [6157] = 0x994D, [6158] = 0x994E, [6159] = 0x994F,
  [6160] = 0x9950, [6161] = 0x9951, [6162] = 0x9952, [6163] = 0x9953,
  [6164] = 0x9954, [6165] = 0x9955, [6166] = 0x9956, [6167] = 0x9957,
  [6168] = 0x9958, [6169] = 0x9959, [6170] = 0x995A, [6171] = 0x995B,
  [6172] = 0x995C, [6173] = 0x995D, [6174] = 0x995E, [6175] = 0x995F,
  [6176] = 0x9960, [6177] = 0x9961, [6178] = 0x9962, [6179] = 0x9963,
  [6180] = 0x9964, [6181] = 0x9965, [6182] = 0x9966, [6183] = 0x9967,
  [6184] = 0x9968, [6185] = 0x9969, [6186] = 0x996A, [6187] = 0x996B,
  [6188] = 0x996C, [6189] = 0x996D, [6190] = 0x996E, [6191] = 0x996F,
  [6192] = 0x9970, [6193] = 0x9971, [6194] = 0x9972, [6195] = 0x9973,
  [6196] = 0x9974, [6197] = 0x9975, [6198] = 0x9976, [6199] = 0x9977,
  [6200] = 0x9978, [6201] = 0x9979, [6202] = 0x997A, [6203] = 0x997B,
  [6204] = 0x997C, [6205] = 0x997D, [6206] = 0x997E, [6208] = 0x9980,
  [6209] = 0x9981, [6210] = 0x9982, [6211] = 0x9983, [6212] = 0x9984,
  [6213] = 0x9985, [6214] = 0x9986, [6215] = 0x9987, [6216] = 0x9988,
  [6217] = 0x9989, [6218] = 0x998A, [6219] = 0x998B, [6220] = 0x998C,
  [6221] = 0x998D, [6222] = 0x998E, [6223] = 0x998F, [6224] = 0x9990,
  [6225] = 0x9991, [6226] = 0x9992, [6227] = 0x9993, [6228] = 0x9994,
  [6229] = 0x9995, [6230] = 0x9996, [6231] = 0x9997, [6232] = 0x9998,
  [6233] = 0x9999, [6234] = 0x999A, [6235] = 0x999B, [6236] = 0x999C,
  [6237] = 0x999D, [6238] = 0x999E, [6239] = 0x999F, [6240] = 0x99A0,
  [6241] = 0x99A1, [6242] = 0x99A2, [6243] = 0x99A3, [6244] = 0x99A4,
  [6245] = 0x99A5, [6246] = 0x99A6, [6247] = 0x99A7, [6248] = 0x99A8,
  [6249] = 0x99A9, [6250] = 0x99AA, [6251] = 0x99AB, [6252] = 0x99AC,
  [6253] = 0x99AD, [6254] = 0x99AE, [6255] = 0x99AF, [6256] = 0x99B0,
  [6257] = 0x99B1, [6258] = 0x99B2, [6259] = 0x99B3, [6260] = 0x99B4,
  [6261] = 0x99B5, [6262] = 0x99B6, [6263] = 0x99B7, [6264] = 0x99B8,
  [6265] = 0x99B9, [6266] = 0x99BA, [6267] = 0x99BB, [6268] = 0x99BC,
  [6269] = 0x99BD, [6270] = 0x99BE, [6271] = 0x99BF, [6272] = 0x99C0,
  [6273] = 0x99C1, [6274] = 0x99C2, [6275] = 0x99C3, [6276] = 0x99C4,
  [6277] = 0x99C5, [6278] = 0x99C6, [6279] = 0x99C7, [6280] = 0x99C8,
  [6281] = 0x99C9, [6282] = 0x99CA, [6283] = 0x99CB, [6284] = 0x99CC,
  [6285] = 0x99CD, [6286] = 0x99CE, [6287] = 0x99CF, [6288] = 0x99D0,
  [6289] = 0x99D1, [6290] = 0x99D2, [6291] = 0x99D3, [6292] = 0x99D4,
  [6293] = 0x99D5, [6294] = 0x99D6, [6295] = 0x99D7, [6296] = 0x99D8,
  [6297] = 0x99D9, [6298] = 0x99DA, [6299] = 0x99DB, [6300] = 0x99DC,
  [6301] = 0x99DD, [6302] = 0x99DE, [6303] = 0x99DF, [6304] = 0x99E0,
  [6305] = 0x99E1, [6306] = 0x99E2, [6307] = 0x99E3, [6308] = 0x99E4,
  [6309] = 0x99E5, [6310] = 0x99E6, [6311] = 0x99E7, [6312] = 0x99E8,
  [6313] = 0x99E9, [6314] = 0x99EA, [6315] = 0x99EB, [6316] = 0x99EC,
  [6317] = 0x99ED, [6318] = 0x99EE, [6319] = 0x99EF, [6320] = 0x99F0,
  [6321] = 0x99F1, [6322] = 0x99F2, [6323] = 0x99F3, [6324] = 0x99F4,
  [6325] = 0x99F5, [6326] = 0x99F6, [6327] = 0x99F7, [6328] = 0x99F8,
  [6329] = 0x99F9, [6330] = 0x99FA, [6331] = 0x99FB, [6332] = 0x99FC,
  [6333] = 0x99FD, [6334] = 0x99FE, [6400] = 0x9A40, [6401] = 0x9A41,
  [6402] = 0x9A42, [6403] = 0x9A43, [6404] = 0x9A44, [6405] = 0x9A45,
  [6406] = 0x9A46, [6407] = 0x9A47, [6408] = 0x9A48, [6409] = 0x9A49,
  [6410] = 0x9A4A, [6411] = 0x9A4B, [6412] = 0x9A4C, [6413] = 0x9A4D,
  [6414] = 0x9A4E, [6415] = 0x9A4F, [6416] = 0x9A50, [6417] = 0x9A51,
  [6418] = 0x9A52, [6419] = 0x9A53, [6420] = 0x9A54, [6421] = 0x9A55,
  [6422] = 0x9A56, [6423] = 0x9A57, [6424] = 0x9A58, [6425] = 0x9A59,
  [6426] = 0x9A5A, [6427] = 0x9A5B, [6428] = 0x9A5C, [6429] = 0x9A5D,
  [6430] = 0x9A5E, [6431] = 0x9A5F, [6432] = 0x9A60, [6433] = 0x9A61,
  [6434] = 0x9A62, [6435] = 0x9A63, [6436] = 0x9A64, [6437] = 0x9A65,
  [6438] = 0x9A66, [6439] = 0x9A67, [6440] = 0x9A68, [6441] = 0x9A69,
  [6442] = 0x9A6A, [6443] = 0x9A6B, [6444] = 0x9A6C, [6445] = 0x9A6D,
  [6446] = 0x9A6E, [6447] = 0x9A6F, [6448] = 0x9A70, [6449] = 0x9A71,
  [6450] = 0x9A72, [6451] = 0x9A73, [6452] = 0x9A74, [6453] = 0x9A75,
  [6454] = 0x9A76, [6455] = 0x9A77, [6456] = 0x9A78, [6457] = 0x9A79,
  [6458] = 0x9A7A, [6459] = 0x9A7B, [6460] = 0x9A7C, [6461] = 0x9A7D,
  [6462] = 0x9A7E, [6464] = 0x9A80, [6465] = 0x9A81, [6466] = 0x9A82,
  [6467] = 0x9A83, [6468] = 0x9A84, [6469] = 0x9A85, [6470] = 0x9A86,
  [6471] = 0x9A87, [6472] = 0x9A88, [6473] = 0x9A89, [6474] = 0x9A8A,
  [6475] = 0x9A8B, [6476] = 0x9A8C, [6477] = 0x9A8D, [6478] = 0x9A8E,
  [6479] = 0x9A8F, [6480] = 0x9A90, [6481] = 0x9A91, [6482] = 0x9A92,
  [6483] = 0x9A93, [6484] = 0x9A94, [6485] = 0x9A95, [6486] = 0x9A96,
  [6487] = 0x9A97, [6488] = 0x9A98, [6489] = 0x9A99, [6490] = 0x9A9A,
  [6491] = 0x9A9B, [6492] = 0x9A9C, [6493] = 0x9A9D, [6494] = 0x9A9E,
  [6495] = 0x9A9F, [6496] = 0x9AA0, [6497] = 0x9AA1, [6498] = 0x9AA2,
  [6499] = 0x9AA3, [6500] = 0x9AA4, [6501] = 0x9AA5, [6502] = 0x9AA6,
  [6503] = 0x9AA7, [6504] = 0x9AA8, [6505] = 0x9AA9, [6506] = 0x9AAA,
  [6507] = 0x9AAB, [6508] = 0x9AAC, [6509] = 0x9AAD, [6510] = 0x9AAE,
  [6511] = 0x9AAF, [6512] = 0x9AB0, [6513] = 0x9AB1, [6514] = 0x9AB2,
  [6515] = 0x9AB3, [6516] = 0x9AB4, [6517] = 0x9AB5, [6518] = 0x9AB6,
  [6519] = 0x9AB7, [6520] = 0x9AB8, [6521] = 0x9AB9, [6522] = 0x9ABA,
  [6523] = 0x9ABB, [6524] = 0x9ABC, [6525] = 0x9ABD, [6526] = 0x9ABE,
  [6527] = 0x9ABF, [6528] = 0x9AC0, [6529] = 0x9AC1, [6530] = 0x9AC2,
  [6531] = 0x9AC3, [6532] = 0x9AC4, [6533] = 0x9AC5, [6534] = 0x9AC6,
  [6535] = 0x9AC7, [6536] = 0x9AC8, [6537] = 0x9AC9, [6538] = 0x9ACA,
  [6539] = 0x9ACB, [6540] = 0x9ACC, [6541] = 0x9ACD, [6542] = 0x9ACE,
  [6543] = 0x9ACF, [6544] = 0x9AD0, [6545] = 0x9AD1, [6546] = 0x9AD2,
  [6547] = 0x9AD3, [6548] = 0x9AD4, [6549] = 0x9AD5, [6550] = 0x9AD6,
  [6551] = 0x9AD7, [6552] = 0x9AD8, [6553] = 0x9AD9, [6554] = 0x9ADA,
  [6555] = 0x9ADB, [6556] = 0x9ADC, [6557] = 0x9ADD, [6558] = 0x9ADE,
  [6559] = 0x9ADF, [6560] = 0x9AE0, [6561] = 0x9AE1, [6562] = 0x9AE2,
  [6563] = 0x9AE3, [6564] = 0x9AE4, [6565] = 0x9AE5, [6566] = 0x9AE6,
  [6567] = 0x9AE7, [6568] = 0x9AE8, [6569] = 0x9AE9, [6570] = 0x9AEA,
  [6571] = 0x9AEB, [6572] = 0x9AEC, [6573] = 0x9AED, [6574] = 0x9AEE,
  [6575] = 0x9AEF, [6576] = 0x9AF0, [6577] = 0x9AF1, [6578] = 0x9AF2,
  [6579] = 0x9AF3, [6580] = 0x9AF4, [6581] = 0x9AF5, [6582] = 0x9AF6,
  [6583] = 0x9AF7, [6584] = 0x9AF8, [6585] = 0x9AF9, [6586] = 0x9AFA,
  [6587] = 0x9AFB, [6588] = 0x9AFC, [6589] = 0x9AFD, [6590] = 0x9AFE,
  [6656] = 0x9B40, [6657] = 0x9B41, [6658] = 0x9B42, [6659] = 0x9B43,
  [6660] = 0x9B44, [6661] = 0x9B45, [6662] = 0x9B46, [6663] = 0x9B47,
  [6664] = 0x9B48, [6665] = 0x9B49, [6666] = 0x9B4A, [6667] = 0x9B4B,
  [6668] = 0x9B4C, [6669] = 0x9B4D, [6670] = 0x9B4E, [6671] = 0x9B4F,
  [6672] = 0x9B50, [6673] = 0x9B51, [6674] = 0x9B52, [6675] = 0x9B53,
  [6676] = 0x9B54, [6677] = 0x9B55, [6678] = 0x9B56, [6679] = 0x9B57,
  [6680] = 0x9B58, [6681] = 0x9B59, [6682] = 0x9B5A, [6683] = 0x9B5B,
  [6684] = 0x9B5C, [6685] = 0x9B5D, [6686] = 0x9B5E, [6687] = 0x9B5F,
  [6688] = 0x9B60, [6689] = 0x9B61, [6690] = 0x9B62, [6691] = 0x9B63,
  [6692] = 0x9B64, [6693] = 0x9B65, [6694] = 0x9B66, [6695] = 0x9B67,
  [6696] = 0x9B68, [6697] = 0x9B69, [6698] = 0x9B6A, [6699] = 0x9B6B,
  [6700] = 0x9B6C, [6701] = 0x9B6D, [6702] = 0x9B6E, [6703] = 0x9B6F,
  [6704] = 0x9B70, [6705] = 0x9B71, [6706] = 0x9B72, [6707] = 0x9B73,
  [6708] = 0x9B74, [6709] = 0x9B75, [6710] = 0x9B76, [6711] = 0x9B77,
  [6712] = 0x9B78, [6713] = 0x9B79, [6714] = 0x9B7A, [6715] = 0x9B7B,
  [6716] = 0x9B7C, [6717] = 0x9B7D, [6718] = 0x9B7E, [6720] = 0x9B80,
  [6721] = 0x9B81, [6722] = 0x9B82, [6723] = 0x9B83, [6724] = 0x9B84,
  [6725] = 0x9B85, [6726] = 0x9B86, [6727] = 0x9B87, [6728] = 0x9B88,
  [6729] = 0x9B89, [6730] = 0x9B8A, [6731] = 0x9B8B, [6732] = 0x9B8C,
  [6733] = 0x9B8D, [6734] = 0x9B8E, [6735] = 0x9B8F, [6736] = 0x9B90,
  [6737] = 0x9B91, [6738] = 0x9B92, [6739] = 0x9B93, [6740] = 0x9B94,
  [6741] = 0x9B95, [6742] = 0x9B96, [6743] = 0x9B97, [6744] = 0x9B98,
  [6745] = 0x9B99, [6746] = 0x9B9A, [6747] = 0x9B9B, [6748] = 0x9B9C,
  [6749] = 0x9B9D, [6750] = 0x9B9E, [6751] = 0x9B9F, [6752] = 0x9BA0,
  [6753] = 0x9BA1, [6754] = 0x9BA2, [6755] = 0x9BA3, [6756] = 0x9BA4,
  [6757] = 0x9BA5, [6758] = 0x9BA6, [6759] = 0x9BA7, [6760] = 0x9BA8,
  [6761] = 0x9BA9, [6762] = 0x9BAA, [6763] = 0x9BAB, [6764] = 0x9BAC,
  [6765] = 0x9BAD, [6766] = 0x9BAE, [6767] = 0x9BAF, [6768] = 0x9BB0,
  [6769] = 0x9BB1, [6770] = 0x9BB2, [6771] = 0x9BB3, [6772] = 0x9BB4,
  [6773] = 0x9BB5, [6774] = 0x9BB6, [6775] = 0x9BB7, [6776] = 0x9BB8,
  [6777] = 0x9BB9, [6778] = 0x9BBA, [6779] = 0x9BBB, [6780] = 0x9BBC,
  [6781] = 0x9BBD, [6782] = 0x9BBE, [6783] = 0x9BBF, [6784] = 0x9BC0,
  [6785] = 0x9BC1, [6786] = 0x9BC2, [6787] = 0x9BC3, [6788] = 0x9BC4,
  [6789] = 0x9BC5, [6790] = 0x9BC6, [6791] = 0x9BC7, [6792] = 0x9BC8,
  [6793] = 0x9BC9, [6794] = 0x9BCA, [6795] = 0x9BCB, [6796] = 0x9BCC,
  [6797] = 0x9BCD, [6798] = 0x9BCE, [6799] = 0x9BCF, [6800] = 0x9BD0,
  [6801] = 0x9BD1, [6802] = 0x9BD2, [6803] = 0x9BD3, [6804] = 0x9BD4,
  [6805] = 0x9BD5, [6806] = 0x9BD6, [6807] = 0x9BD7, [6808] = 0x9BD8,
  [6809] = 0x9BD9, [6810] = 0x9BDA, [6811] = 0x9BDB, [6812] = 0x9BDC,
  [6813] = 0x9BDD, [6814] = 0x9BDE, [6815] = 0x9BDF, [6816] = 0x9BE0,
  [6817] = 0x9BE1, [6818] = 0x9BE2, [6819] = 0x9BE3, [6820] = 0x9BE4,
  [6821] = 0x9BE5, [6822] = 0x9BE6, [6823] = 0x9BE7, [6824] = 0x9BE8,
  [6825] = 0x9BE9, [6826] = 0x9BEA, [6827] = 0x9BEB, [6828] = 0x9BEC,
  [6829] = 0x9BED, [6830] = 0x9BEE, [6831] = 0x9BEF, [6832] = 0x9BF0,
  [6833] = 0x9BF1, [6834] = 0x9BF2, [6835] = 0x9BF3, [6836] = 0x9BF4,
  [6837] = 0x9BF5, [6838] = 0x9BF6, [6839] = 0x9BF7, [6840] = 0x9BF8,
  [6841] = 0x9BF9, [6842] = 0x9BFA, [6843] = 0x9BFB, [6844] = 0x9BFC,
  [6845] = 0x9BFD, [6846] = 0x9BFE, [6912] = 0x9C40, [6913] = 0x9C41,
  [6914] = 0x9C42, [6915] = 0x9C43, [6916] = 0x9C44, [6917] = 0x9C45,
  [6918] = 0x9C46, [6919] = 0x9C47, [6920] = 0x9C48, [6921] = 0x9C49,
  [6922] = 0x9C4A, [6923] = 0x9C4B, [6924] = 0x9C4C, [6925] = 0x9C4D,
  [6926] = 0x9C4E, [6927] = 0x9C4F, [6928] = 0x9C50, [6929] = 0x9C51,
  [6930] = 0x9C52, [6931] = 0x9C53, [6932] = 0x9C54, [6933] = 0x9C55,
  [6934] = 0x9C56, [6935] = 0x9C57, [6936] = 0x9C58, [6937] = 0x9C59,
  [6938] = 0x9C5A, [6939] = 0x9C5B, [6940] = 0x9C5C, [6941] = 0x9C5D,
  [6942] = 0x9C5E, [6943] = 0x9C5F, [6944] = 0x9C60, [6945] = 0x9C61,
  [6946] = 0x9C62, [6947] = 0x9C63, [6948] = 0x9C64, [6949] = 0x9C65,
  [6950] = 0x9C66, [6951] = 0x9C67, [6952] = 0x9C68, [6953] = 0x9C69,
  [6954] = 0x9C6A, [6955] = 0x9C6B, [6956] = 0x9C6C, [6957] = 0x9C6D,
  [6958] = 0x9C6E, [6959] = 0x9C6F, [6960] = 0x9C70, [6961] = 0x9C71,
  [6962] = 0x9C72, [6963] = 0x9C73, [6964] = 0x9C74, [6965] = 0x9C75,
  [6966] = 0x9C76, [6967] = 0x9C77, [6968] = 0x9C78, [6969] = 0x9C79,
  [6970] = 0x9C7A, [6971] = 0x9C7B, [6972] = 0x9C7C, [6973] = 0x9C7D,
  [6974] = 0x9C7E, [6976] = 0x9C80, [6977] = 0x9C81, [6978] = 0x9C82,
  [6979] = 0x9C83, [6980] = 0x9C84, [6981] = 0x9C85, [6982] = 0x9C86,
  [6983] = 0x9C87, [6984] = 0x9C88, [6985] = 0x9C89, [6986] = 0x9C8A,
  [6987] = 0x9C8B, [6988] = 0x9C8C, [6989] = 0x9C8D, [6990] = 0x9C8E,
  [6991] = 0x9C8F, [6992] = 0x9C90, [6993] = 0x9C91, [6994] = 0x9C92,
  [6995] = 0x9C93, [6996] = 0x9C94, [6997] = 0x9C95, [6998] = 0x9C96,
  [6999] = 0x9C97, [7000] = 0x9C98, [7001] = 0x9C99, [7002] = 0x9C9A,
  [7003] = 0x9C9B, [7004] = 0x9C9C, [7005] = 0x9C9D, [7006] = 0x9C9E,
  [7007] = 0x9C9F, [7008] = 0x9CA0, [7009] = 0x9CA1, [7010] = 0x9CA2,
  [7011] = 0x9CA3, [7012] = 0x9CA4, [7013] = 0x9CA5, [7014] = 0x9CA6,
  [7015] = 0x9CA7, [7016] = 0x9CA8, [7017] = 0x9CA9, [7018] = 0x9CAA,
  [7019] = 0x9CAB, [7020] = 0x9CAC, [7021] = 0x9CAD, [7022] = 0x9CAE,
  [7023] = 0x9CAF, [7024] = 0x9CB0, [7025] = 0x9CB1, [7026] = 0x9CB2,
  [7027] = 0x9CB3, [7028] = 0x9CB4, [7029] = 0x9CB5, [7030] = 0x9CB6,
  [7031] = 0x9CB7, [7032] = 0x9CB8, [7033] = 0x9CB9, [7034] = 0x9CBA,
  [7035] = 0x9CBB, [7036] = 0x9CBC, [7037] = 0x9CBD, [7038] = 0x9CBE,
  [7039] = 0x9CBF, [7040] = 0x9CC0, [7041] = 0x9CC1, [7042] = 0x9CC2,
  [7043] = 0x9CC3, [7044] = 0x9CC4, [7045] = 0x9CC5, [7046] = 0x9CC6,
  [7047] = 0x9CC7, [7048] = 0x9CC8, [7049] = 0x9CC9, [7050] = 0x9CCA,
  [7051] = 0x9CCB, [7052] = 0x9CCC, [7053] = 0x9CCD, [7054] = 0x9CCE,
  [7055] = 0x9CCF, [7056] = 0x9CD0, [7057] = 0x9CD1, [7058] = 0x9CD2,
  [7059] = 0x9CD3, [7060] = 0x9CD4, [7061] = 0x9CD5, [7062] = 0x9CD6,
  [7063] = 0x9CD7, [7064] = 0x9CD8, [7065] = 0x9CD9, [7066] = 0x9CDA,
  [7067] = 0x9CDB, [7068] = 0x9CDC, [7069] = 0x9CDD, [7070] = 0x9CDE,
  [7071] = 0x9CDF, [7072] = 0x9CE0, [7073] = 0x9CE1, [7074] = 0x9CE2,
  [7075] = 0x9CE3, [7076] = 0x9CE4, [7077] = 0x9CE5, [7078] = 0x9CE6,
  [7079] = 0x9CE7, [7080] = 0x9CE8, [7081] = 0x9CE9, [7082] = 0x9CEA,
  [7083] = 0x9CEB, [7084] = 0x9CEC, [7085] = 0x9CED, [7086] = 0x9CEE,
  [7087] = 0x9CEF, [7088] = 0x9CF0, [7089] = 0x9CF1, [7090] = 0x9CF2,
  [7091] = 0x9CF3, [7092] = 0x9CF4, [7093] = 0x9CF5, [7094] = 0x9CF6,
  [7095] = 0x9CF7, [7096] = 0x9CF8, [7097] = 0x9CF9, [7098] = 0x9CFA,
  [7099] = 0x9CFB, [7100] = 0x9CFC, [7101] = 0x9CFD, [7102] = 0x9CFE,
  [7168] = 0x9D40, [7169] = 0x9D41, [7170] = 0x9D42, [7171] = 0x9D43,
  [7172] = 0x9D44, [7173] = 0x9D45, [7174] = 0x9D46, [7175] = 0x9D47,
  [7176] = 0x9D48, [7177] = 0x9D49, [7178] = 0x9D4A, [7179] = 0x9D4B,
  [7180] = 0x9D4C, [7181] = 0x9D4D, [7182] = 0x9D4E, [7183] = 0x9D4F,
  [7184] = 0x9D50, [7185] = 0x9D51, [7186] = 0x9D52, [7187] = 0x9D53,
  [7188] = 0x9D54, [7189] = 0x9D55, [7190] = 0x9D56, [7191] = 0x9D57,
  [7192] = 0x9D58, [7193] = 0x9D59, [7194] = 0x9D5A, [7195] = 0x9D5B,
  [7196] = 0x9D5C, [7197] = 0x9D5D, [7198] = 0x9D5E, [7199] = 0x9D5F,
  [7200] = 0x9D60, [7201] = 0x9D61, [7202] = 0x9D62, [7203] = 0x9D63,
  [7204] = 0x9D64, [7205] = 0x9D65, [7206] = 0x9D66, [7207] = 0x9D67,
  [7208] = 0x9D68, [7209] = 0x9D69, [7210] = 0x9D6A, [7211] = 0x9D6B,
  [7212] = 0x9D6C, [7213] = 0x9D6D, [7214] = 0x9D6E, [7215] = 0x9D6F,
  [7216] = 0x9D70, [7217] = 0x9D71, [7218] = 0x9D72, [7219] = 0x9D73,
  [7220] = 0x9D74, [7221] = 0x9D75, [7222] = 0x9D76, [7223] = 0x9D77,
  [7224] = 0x9D78, [7225] = 0x9D79, [7226] = 0x9D7A, [7227] = 0x9D7B,
  [7228] = 0x9D7C, [7229] = 0x9D7D, [7230] = 0x9D7E, [7232] = 0x9D80,
  [7233] = 0x9D81, [7234] = 0x9D82, [7235] = 0x9D83, [7236] = 0x9D84,
  [7237] = 0x9D85, [7238] = 0x9D86, [7239] = 0x9D87, [7240] = 0x9D88,
  [7241] = 0x9D89, [7242] = 0x9D8A, [7243] = 0x9D8B, [7244] = 0x9D8C,
  [7245] = 0x9D8D, [7246] = 0x9D8E, [7247] = 0x9D8F, [7248] = 0x9D90,
  [7249] = 0x9D91, [7250] = 0x9D92, [7251] = 0x9D93, [7252] = 0x9D94,
  [7253] = 0x9D95, [7254] = 0x9D96, [7255] = 0x9D97, [7256] = 0x9D98,
  [7257] = 0x9D99, [7258] = 0x9D9A, [7259] = 0x9D9B, [7260] = 0x9D9C,
  [7261] = 0x9D9D, [7262] = 0x9D9E, [7263] = 0x9D9F, [7264] = 0x9DA0,
  [7265] = 0x9DA1, [7266] = 0x9DA2, [7267] = 0x9DA3, [7268] = 0x9DA4,
  [7269] = 0x9DA5, [7270] = 0x9DA6, [7271] = 0x9DA7, [7272] = 0x9DA8,
  [7273] = 0x9DA9, [7274] = 0x9DAA, [7275] = 0x9DAB, [7276] = 0x9DAC,
  [7277] = 0x9DAD, [7278] = 0x9DAE, [7279] = 0x9DAF, [7280] = 0x9DB0,
  [7281] = 0x9DB1, [7282] = 0x9DB2, [7283] = 0x9DB3, [7284] = 0x9DB4,
  [7285] = 0x9DB5, [7286] = 0x9DB6, [7287] = 0x9DB7, [7288] = 0x9DB8,
  [7289] = 0x9DB9, [7290] = 0x9DBA, [7291] = 0x9DBB, [7292] = 0x9DBC,
  [7293] = 0x9DBD, [7294] = 0x9DBE, [7295] = 0x9DBF, [7296] = 0x9DC0,
  [7297] = 0x9DC1, [7298] = 0x9DC2, [7299] = 0x9DC3, [7300] = 0x9DC4,
  [7301] = 0x9DC5, [7302] = 0x9DC6, [7303] = 0x9DC7, [7304] = 0x9DC8,
  [7305] = 0x9DC9, [7306] = 0x9DCA, [7307] = 0x9DCB, [7308] = 0x9DCC,
  [7309] = 0x9DCD, [7310] = 0x9DCE, [7311] = 0x9DCF, [7312] = 0x9DD0,
  [7313] = 0x9DD1, [7314] = 0x9DD2, [7315] = 0x9DD3, [7316] = 0x9DD4,
  [7317] = 0x9DD5, [7318] = 0x9DD6, [7319] = 0x9DD7, [7320] = 0x9DD8,
  [7321] = 0x9DD9, [7322] = 0x9DDA, [7323] = 0x9DDB, [7324] = 0x9DDC,
  [7325] = 0x9DDD, [7326] = 0x9DDE, [7327] = 0x9DDF, [7328] = 0x9DE0,
  [7329] = 0x9DE1, [7330] = 0x9DE2, [7331] = 0x9DE3, [7332] = 0x9DE4,
  [7333] = 0x9DE5, [7334] = 0x9DE6, [7335] = 0x9DE7, [7336] = 0x9DE8,
  [7337] = 0x9DE9, [7338] = 0x9DEA, [7339] = 0x9DEB, [7340] = 0x9DEC,
  [7341] = 0x9DED, [7342] = 0x9DEE, [7343] = 0x9DEF, [7344] = 0x9DF0,
  [7345] = 0x9DF1, [7346] = 0x9DF2, [7347] = 0x9DF3, [7348] = 0x9DF4,
  [7349] = 0x9DF5, [7350] = 0x9DF6, [7351] = 0x9DF7, [7352] = 0x9DF8,
  [7353] = 0x9DF9, [7354] = 0x9DFA, [7355] = 0x9DFB, [7356] = 0x9DFC,
  [7357] = 0x9DFD, [7358] = 0x9DFE, [7424] = 0x9E40, [7425] = 0x9E41,
  [7426] = 0x9E42, [7427] = 0x9E43, [7428] = 0x9E44, [7429] = 0x9E45,
  [7430] = 0x9E46, [7431] = 0x9E47, [7432] = 0x9E48, [7433] = 0x9E49,
  [7434] = 0x9E4A, [7435] = 0x9E4B, [7436] = 0x9E4C, [7437] = 0x9E4D,
  [7438] = 0x9E4E, [7439] = 0x9E4F, [7440] = 0x9E50, [7441] = 0x9E51,
  [7442] = 0x9E52, [7443] = 0x9E53, [7444] = 0x9E54, [7445] = 0x9E55,
  [7446] = 0x9E56, [7447] = 0x9E57, [7448] = 0x9E58, [7449] = 0x9E59,
  [7450] = 0x9E5A, [7451] = 0x9E5B, [7452] = 0x9E5C, [7453] = 0x9E5D,
  [7454] = 0x9E5E, [7455] = 0x9E5F, [7456] = 0x9E60, [7457] = 0x9E61,
  [7458] = 0x9E62, [7459] = 0x9E63, [7460] = 0x9E64, [7461] = 0x9E65,
  [7462] = 0x9E66, [7463] = 0x9E67, [7464] = 0x9E68, [7465] = 0x9E69,
  [7466] = 0x9E6A, [7467] = 0x9E6B, [7468] = 0x9E6C, [7469] = 0x9E6D,
  [7470] = 0x9E6E, [7471] = 0x9E6F, [7472] = 0x9E70, [7473] = 0x9E71,
  [7474] = 0x9E72, [7475] = 0x9E73, [7476] = 0x9E74, [7477] = 0x9E75,
  [7478] = 0x9E76, [7479] = 0x9E77, [7480] = 0x9E78, [7481] = 0x9E79,
  [7482] = 0x9E7A, [7483] = 0x9E7B, [7484] = 0x9E7C, [7485] = 0x9E7D,
  [7486] = 0x9E7E, [7488] = 0x9E80, [7489] = 0x9E81, [7490] = 0x9E82,
  [7491] = 0x9E83, [7492] = 0x9E84, [7493] = 0x9E85, [7494] = 0x9E86,
  [7495] = 0x9E87, [7496] = 0x9E88, [7497] = 0x9E89, [7498] = 0x9E8A,
  [7499] = 0x9E8B, [7500] = 0x9E8C, [7501] = 0x9E8D, [7502] = 0x9E8E,
  [7503] = 0x9E8F, [7504] = 0x9E90, [7505] = 0x9E91, [7506] = 0x9E92,
  [7507] = 0x9E93, [7508] = 0x9E94, [7509] = 0x9E95, [7510] = 0x9E96,
  [7511] = 0x9E97, [7512] = 0x9E98, [7513] = 0x9E99, [7514] = 0x9E9A,
  [7515] = 0x9E9B, [7516] = 0x9E9C, [7517] = 0x9E9D, [7518] = 0x9E9E,
  [7519] = 0x9E9F, [7520] = 0x9EA0, [7521] = 0x9EA1, [7522] = 0x9EA2,
  [7523] = 0x9EA3, [7524] = 0x9EA4, [7525] = 0x9EA5, [7526] = 0x9EA6,
  [7527] = 0x9EA7, [7528] = 0x9EA8, [7529] = 0x9EA9, [7530] = 0x9EAA,
  [7531] = 0x9EAB, [7532] = 0x9EAC, [7533] = 0x9EAD, [7534] = 0x9EAE,
  [7535] = 0x9EAF, [7536] = 0x9EB0, [7537] = 0x9EB1, [7538] = 0x9EB2,
  [7539] = 0x9EB3, [7540] = 0x9EB4, [7541] = 0x9EB5, [7542] = 0x9EB6,
  [7543] = 0x9EB7, [7544] = 0x9EB8, [7545] = 0x9EB9, [7546] = 0x9EBA,
  [7547] = 0x9EBB, [7548] = 0x9EBC, [7549] = 0x9EBD, [7550] = 0x9EBE,
  [7551] = 0x9EBF, [7552] = 0x9EC0, [7553] = 0x9EC1, [7554] = 0x9EC2,
  [7555] = 0x9EC3, [7556] = 0x9EC4, [7557] = 0x9EC5, [7558] = 0x9EC6,
  [7559] = 0x9EC7, [7560] = 0x9EC8, [7561] = 0x9EC9, [7562] = 0x9ECA,
  [7563] = 0x9ECB, [7564] = 0x9ECC, [7565] = 0x9ECD, [7566] = 0x9ECE,
  [7567] = 0x9ECF, [7568] = 0x9ED0, [7569] = 0x9ED1, [7570] = 0x9ED2,
  [7571] = 0x9ED3, [7572] = 0x9ED4, [7573] = 0x9ED5, [7574] = 0x9ED6,
  [7575] = 0x9ED7, [7576] = 0x9ED8, [7577] = 0x9ED9, [7578] = 0x9EDA,
  [7579] = 0x9EDB, [7580] = 0x9EDC, [7581] = 0x9EDD, [7582] = 0x9EDE,
  [7583] = 0x9EDF, [7584] = 0x9EE0, [7585] = 0x9EE1, [7586] = 0x9EE2,
  [7587] = 0x9EE3, [7588] = 0x9EE4, [7589] = 0x9EE5, [7590] = 0x9EE6,
  [7591] = 0x9EE7, [7592] = 0x9EE8, [7593] = 0x9EE9, [7594] = 0x9EEA,
  [7595] = 0x9EEB, [7596] = 0x9EEC, [7597] = 0x9EED, [7598] = 0x9EEE,
  [7599] = 0x9EEF, [7600] = 0x9EF0, [7601] = 0x9EF1, [7602] = 0x9EF2,
  [7603] = 0x9EF3, [7604] = 0x9EF4, [7605] = 0x9EF5, [7606] = 0x9EF6,
  [7607] = 0x9EF7, [7608] = 0x9EF8, [7609] = 0x9EF9, [7610] = 0x9EFA,
  [7611] = 0x9EFB, [7612] = 0x9EFC, [7613] = 0x9EFD, [7614] = 0x9EFE,
  [7680] = 0x9F40, [7681] = 0x9F41, [7682] = 0x9F42, [7683] = 0x9F43,
  [7684] = 0x9F44, [7685] = 0x9F45, [7686] = 0x9F46, [7687] = 0x9F47,
  [7688] = 0x9F48, [7689] = 0x9F49, [7690] = 0x9F4A, [7691] = 0x9F4B,
  [7692] = 0x9F4C, [7693] = 0x9F4D, [7694] = 0x9F4E, [7695] = 0x9F4F,
  [7696] = 0x9F50, [7697] = 0x9F51, [7698] = 0x9F52, [7699] = 0x9F53,
  [7700] = 0x9F54, [7701] = 0x9F55, [7702] = 0x9F56, [7703] = 0x9F57,
  [7704] = 0x9F58, [7705] = 0x9F59, [7706] = 0x9F5A, [7707] = 0x9F5B,
  [7708] = 0x9F5C, [7709] = 0x9F5D, [7710] = 0x9F5E, [7711] = 0x9F5F,
  [7712] = 0x9F60, [7713] = 0x9F61, [7714] = 0x9F62, [7715] = 0x9F63,
  [7716] = 0x9F64, [7717] = 0x9F65, [7718] = 0x9F66, [7719] = 0x9F67,
  [7720] = 0x9F68, [7721] = 0x9F69, [7722] = 0x9F6A, [7723] = 0x9F6B,
  [7724] = 0x9F6C, [7725] = 0x9F6D, [7726] = 0x9F6E, [7727] = 0x9F6F,
  [7728] = 0x9F70, [7729] = 0x9F71, [7730] = 0x9F72, [7731] = 0x9F73,
  [7732] = 0x9F74, [7733] = 0x9F75, [7734] = 0x9F76, [7735] = 0x9F77,
  [7736] = 0x9F78, [7737] = 0x9F79, [7738] = 0x9F7A, [7739] = 0x9F7B,
  [7740] = 0x9F7C, [7741] = 0x9F7D, [7742] = 0x9F7E, [7744] = 0x9F80,
  [7745] = 0x9F81, [7746] = 0x9F82, [7747] = 0x9F83, [7748] = 0x9F84,
  [7749] = 0x9F85, [7750] = 0x9F86, [7751] = 0x9F87, [7752] = 0x9F88,
  [7753] = 0x9F89, [7754] = 0x9F8A, [7755] = 0x9F8B, [7756] = 0x9F8C,
  [7757] = 0x9F8D, [7758] = 0x9F8E, [7759] = 0x9F8F, [7760] = 0x9F90,
  [7761] = 0x9F91, [7762] = 0x9F92, [7763] = 0x9F93, [7764] = 0x9F94,
  [7765] = 0x9F95, [7766] = 0x9F96, [7767] = 0x9F97, [7768] = 0x9F98,
  [7769] = 0x9F99, [7770] = 0x9F9A, [7771] = 0x9F9B, [7772] = 0x9F9C,
  [7773] = 0x9F9D, [7774] = 0x9F9E, [7775] = 0x9F9F, [7776] = 0x9FA0,
  [7777] = 0x9FA1, [7778] = 0x9FA2, [7779] = 0x9FA3, [7780] = 0x9FA4,
  [7781] = 0x9FA5, [7782] = 0x9FA6, [7783] = 0x9FA7, [7784] = 0x9FA8,
  [7785] = 0x9FA9, [7786] = 0x9FAA, [7787] = 0x9FAB, [7788] = 0x9FAC,
  [7789] = 0x9FAD, [7790] = 0x9FAE, [7791] = 0x9FAF, [7792] = 0x9FB0,
  [7793] = 0x9FB1, [7794] = 0x9FB2, [7795] = 0x9FB3, [7796] = 0x9FB4,
  [7797] = 0x9FB5, [7798] = 0x9FB6, [7799] = 0x9FB7, [7800] = 0x9FB8,
  [7801] = 0x9FB9, [7802] = 0x9FBA, [7803] = 0x9FBB, [7804] = 0x9FBC,
  [7805] = 0x9FBD, [7806] = 0x9FBE, [7807] = 0x9FBF, [7808] = 0x9FC0,
  [7809] = 0x9FC1, [7810] = 0x9FC2, [7811] = 0x9FC3, [7812] = 0x9FC4,
  [7813] = 0x9FC5, [7814] = 0x9FC6, [7815] = 0x9FC7, [7816] = 0x9FC8,
  [7817] = 0x9FC9, [7818] = 0x9FCA, [7819] = 0x9FCB, [7820] = 0x9FCC,
  [7821] = 0x9FCD, [7822] = 0x9FCE, [7823] = 0x9FCF, [7824] = 0x9FD0,
  [7825] = 0x9FD1, [7826] = 0x9FD2, [7827] = 0x9FD3, [7828] = 0x9FD4,
  [7829] = 0x9FD5, [7830] = 0x9FD6, [7831] = 0x9FD7, [7832] = 0x9FD8,
  [7833] = 0x9FD9, [7834] = 0x9FDA, [7835] = 0x9FDB, [7836] = 0x9FDC,
  [7837] = 0x9FDD, [7838] = 0x9FDE, [7839] = 0x9FDF, [7840] = 0x9FE0,
  [7841] = 0x9FE1, [7842] = 0x9FE2, [7843] = 0x9FE3, [7844] = 0x9FE4,
  [7845] = 0x9FE5, [7846] = 0x9FE6, [7847] = 0x9FE7, [7848] = 0x9FE8,
  [7849] = 0x9FE9, [7850] = 0x9FEA, [7851] = 0x9FEB, [7852] = 0x9FEC,
  [7853] = 0x9FED, [7854] = 0x9FEE, [7855] = 0x9FEF, [7856] = 0x9FF0,
  [7857] = 0x9FF1, [7858] = 0x9FF2, [7859] = 0x9FF3, [7860] = 0x9FF4,
  [7861] = 0x9FF5, [7862] = 0x9FF6, [7863] = 0x9FF7, [7864] = 0x9FF8,
  [7865] = 0x9FF9, [7866] = 0x9FFA, [7867] = 0x9FFB, [7868] = 0x9FFC,
  [7869] = 0x9FFD, [7870] = 0x9FFE,
};


static const char from_ucs4_single[256][2] =
{
  [0x0000] = "\x00\x00", [0x0001] = "\x01\x00", [0x0002] = "\x02\x00",
  [0x0003] = "\x03\x00", [0x0004] = "\x04\x00", [0x0005] = "\x05\x00",
  [0x0006] = "\x06\x00", [0x0007] = "\x07\x00", [0x0008] = "\x08\x00",
  [0x0009] = "\x09\x00", [0x000a] = "\x0a\x00", [0x000b] = "\x0b\x00",
  [0x000c] = "\x0c\x00", [0x000d] = "\x0d\x00", [0x000e] = "\x0e\x00",
  [0x000f] = "\x0f\x00", [0x0010] = "\x10\x00", [0x0011] = "\x11\x00",
  [0x0012] = "\x12\x00", [0x0013] = "\x13\x00", [0x0014] = "\x14\x00",
  [0x0015] = "\x15\x00", [0x0016] = "\x16\x00", [0x0017] = "\x17\x00",
  [0x0018] = "\x18\x00", [0x0019] = "\x19\x00", [0x001a] = "\x1a\x00",
  [0x001b] = "\x1b\x00", [0x001c] = "\x1c\x00", [0x001d] = "\x1d\x00",
  [0x001e] = "\x1e\x00", [0x001f] = "\x1f\x00", [0x0020] = "\x20\x00",
  [0x0021] = "\x21\x00", [0x0022] = "\x22\x00", [0x0023] = "\x23\x00",
  [0x0024] = "\x24\x00", [0x0025] = "\x25\x00", [0x0026] = "\x26\x00",
  [0x0027] = "\x27\x00", [0x0028] = "\x28\x00", [0x0029] = "\x29\x00",
  [0x002a] = "\x2a\x00", [0x002b] = "\x2b\x00", [0x002c] = "\x2c\x00",
  [0x002d] = "\x2d\x00", [0x002e] = "\x2e\x00", [0x002f] = "\x2f\x00",
  [0x0030] = "\x30\x00", [0x0031] = "\x31\x00", [0x0032] = "\x32\x00",
  [0x0033] = "\x33\x00", [0x0034] = "\x34\x00", [0x0035] = "\x35\x00",
  [0x0036] = "\x36\x00", [0x0037] = "\x37\x00", [0x0038] = "\x38\x00",
  [0x0039] = "\x39\x00", [0x003a] = "\x3a\x00", [0x003b] = "\x3b\x00",
  [0x003c] = "\x3c\x00", [0x003d] = "\x3d\x00", [0x003e] = "\x3e\x00",
  [0x003f] = "\x3f\x00", [0x0040] = "\x40\x00", [0x0041] = "\x41\x00",
  [0x0042] = "\x42\x00", [0x0043] = "\x43\x00", [0x0044] = "\x44\x00",
  [0x0045] = "\x45\x00", [0x0046] = "\x46\x00", [0x0047] = "\x47\x00",
  [0x0048] = "\x48\x00", [0x0049] = "\x49\x00", [0x004a] = "\x4a\x00",
  [0x004b] = "\x4b\x00", [0x004c] = "\x4c\x00", [0x004d] = "\x4d\x00",
  [0x004e] = "\x4e\x00", [0x004f] = "\x4f\x00", [0x0050] = "\x50\x00",
  [0x0051] = "\x51\x00", [0x0052] = "\x52\x00", [0x0053] = "\x53\x00",
  [0x0054] = "\x54\x00", [0x0055] = "\x55\x00", [0x0056] = "\x56\x00",
  [0x0057] = "\x57\x00", [0x0058] = "\x58\x00", [0x0059] = "\x59\x00",
  [0x005a] = "\x5a\x00", [0x005b] = "\x5b\x00", [0x005c] = "\x5c\x00",
  [0x005d] = "\x5d\x00", [0x005e] = "\x5e\x00", [0x005f] = "\x5f\x00",
  [0x0060] = "\x60\x00", [0x0061] = "\x61\x00", [0x0062] = "\x62\x00",
  [0x0063] = "\x63\x00", [0x0064] = "\x64\x00", [0x0065] = "\x65\x00",
  [0x0066] = "\x66\x00", [0x0067] = "\x67\x00", [0x0068] = "\x68\x00",
  [0x0069] = "\x69\x00", [0x006a] = "\x6a\x00", [0x006b] = "\x6b\x00",
  [0x006c] = "\x6c\x00", [0x006d] = "\x6d\x00", [0x006e] = "\x6e\x00",
  [0x006f] = "\x6f\x00", [0x0070] = "\x70\x00", [0x0071] = "\x71\x00",
  [0x0072] = "\x72\x00", [0x0073] = "\x73\x00", [0x0074] = "\x74\x00",
  [0x0075] = "\x75\x00", [0x0076] = "\x76\x00", [0x0077] = "\x77\x00",
  [0x0078] = "\x78\x00", [0x0079] = "\x79\x00", [0x007a] = "\x7a\x00",
  [0x007b] = "\x7b\x00", [0x007c] = "\x7c\x00", [0x007d] = "\x7d\x00",
  [0x007e] = "\x7e\x00", [0x007f] = "\x7f\x00", [0x00a0] = "\xa0\x00",
  [0x00a1] = "\xa1\x00", [0x00a2] = "\xa2\x00", [0x00a3] = "\xa3\x00",
  [0x00a4] = "\xa4\x00", [0x00a5] = "\xa5\x00", [0x00a6] = "\xa6\x00",
  [0x00a7] = "\xa7\x00", [0x00a8] = "\xa8\x00", [0x00a9] = "\xa9\x00",
  [0x00aa] = "\xaa\x00", [0x00ab] = "\xab\x00", [0x00ac] = "\xac\x00",
  [0x00ad] = "\xad\x00", [0x00ae] = "\xae\x00", [0x00af] = "\xaf\x00",
  [0x00b0] = "\xb0\x00", [0x00b1] = "\xb1\x00", [0x00b2] = "\xb2\x00",
  [0x00b3] = "\xb3\x00", [0x00b4] = "\xb4\x00", [0x00b5] = "\xb5\x00",
  [0x00b6] = "\xb6\x00", [0x00b7] = "\xb7\x00", [0x00b8] = "\xb8\x00",
  [0x00b9] = "\xb9\x00", [0x00ba] = "\xba\x00", [0x00bb] = "\xbb\x00",
  [0x00bc] = "\xbc\x00", [0x00bd] = "\xbd\x00", [0x00be] = "\xbe\x00",
  [0x00bf] = "\xbf\x00", [0x00c0] = "\xc0\x00", [0x00c1] = "\xc1\x00",
  [0x00c2] = "\xc2\x00", [0x00c3] = "\xc3\x00", [0x00c4] = "\xc4\x00",
  [0x00c5] = "\xc5\x00", [0x00c6] = "\xc6\x00", [0x00c7] = "\xc7\x00",
  [0x00c8] = "\xc8\x00", [0x00c9] = "\xc9\x00", [0x00ca] = "\xca\x00",
  [0x00cb] = "\xcb\x00", [0x00cc] = "\xcc\x00", [0x00cd] = "\xcd\x00",
  [0x00ce] = "\xce\x00", [0x00cf] = "\xcf\x00", [0x00d0] = "\xd0\x00",
  [0x00d1] = "\xd1\x00", [0x00d2] = "\xd2\x00", [0x00d3] = "\xd3\x00",
  [0x00d4] = "\xd4\x00", [0x00d5] = "\xd5\x00", [0x00d6] = "\xd6\x00",
  [0x00d7] = "\xd7\x00", [0x00d8] = "\xd8\x00", [0x00d9] = "\xd9\x00",
  [0x00da] = "\xda\x00", [0x00db] = "\xdb\x00", [0x00dc] = "\xdc\x00",
  [0x00dd] = "\xdd\x00", [0x00de] = "\xde\x00", [0x00df] = "\xdf\x00",
  [0x00e0] = "\xe0\x00", [0x00e1] = "\xe1\x00", [0x00e2] = "\xe2\x00",
  [0x00e3] = "\xe3\x00", [0x00e4] = "\xe4\x00", [0x00e5] = "\xe5\x00",
  [0x00e6] = "\xe6\x00", [0x00e7] = "\xe7\x00", [0x00e8] = "\xe8\x00",
  [0x00e9] = "\xe9\x00", [0x00ea] = "\xea\x00", [0x00eb] = "\xeb\x00",
  [0x00ec] = "\xec\x00", [0x00ed] = "\xed\x00", [0x00ee] = "\xee\x00",
  [0x00ef] = "\xef\x00", [0x00f0] = "\xf0\x00", [0x00f1] = "\xf1\x00",
  [0x00f2] = "\xf2\x00", [0x00f3] = "\xf3\x00", [0x00f4] = "\xf4\x00",
  [0x00f5] = "\xf5\x00", [0x00f6] = "\xf6\x00", [0x00f7] = "\xf7\x00",
  [0x00f8] = "\xf8\x00", [0x00f9] = "\xf9\x00", [0x00fa] = "\xfa\x00",
  [0x00fb] = "\xfb\x00", [0x00fc] = "\xfc\x00", [0x00fd] = "\xfd\x00",
  [0x00fe] = "\xfe\x00", [0x00ff] = "\xff\x00"
};

static const char from_ucs4_double[0x1ebf][2] =
{
  [0x0000] = "\x81\x40", [0x0001] = "\x81\x41", [0x0002] = "\x81\x42",
  [0x0003] = "\x81\x43", [0x0004] = "\x81\x44", [0x0005] = "\x81\x45",
  [0x0006] = "\x81\x46", [0x0007] = "\x81\x47", [0x0008] = "\x81\x48",
  [0x0009] = "\x81\x49", [0x000a] = "\x81\x4a", [0x000b] = "\x81\x4b",
  [0x000c] = "\x81\x4c", [0x000d] = "\x81\x4d", [0x000e] = "\x81\x4e",
  [0x000f] = "\x81\x4f", [0x0010] = "\x81\x50", [0x0011] = "\x81\x51",
  [0x0012] = "\x81\x52", [0x0013] = "\x81\x53", [0x0014] = "\x81\x54",
  [0x0015] = "\x81\x55", [0x0016] = "\x81\x56", [0x0017] = "\x81\x57",
  [0x0018] = "\x81\x58", [0x0019] = "\x81\x59", [0x001a] = "\x81\x5a",
  [0x001b] = "\x81\x5b", [0x001c] = "\x81\x5c", [0x001d] = "\x81\x5d",
  [0x001e] = "\x81\x5e", [0x001f] = "\x81\x5f", [0x0020] = "\x81\x60",
  [0x0021] = "\x81\x61", [0x0022] = "\x81\x62", [0x0023] = "\x81\x63",
  [0x0024] = "\x81\x64", [0x0025] = "\x81\x65", [0x0026] = "\x81\x66",
  [0x0027] = "\x81\x67", [0x0028] = "\x81\x68", [0x0029] = "\x81\x69",
  [0x002a] = "\x81\x6a", [0x002b] = "\x81\x6b", [0x002c] = "\x81\x6c",
  [0x002d] = "\x81\x6d", [0x002e] = "\x81\x6e", [0x002f] = "\x81\x6f",
  [0x0030] = "\x81\x70", [0x0031] = "\x81\x71", [0x0032] = "\x81\x72",
  [0x0033] = "\x81\x73", [0x0034] = "\x81\x74", [0x0035] = "\x81\x75",
  [0x0036] = "\x81\x76", [0x0037] = "\x81\x77", [0x0038] = "\x81\x78",
  [0x0039] = "\x81\x79", [0x003a] = "\x81\x7a", [0x003b] = "\x81\x7b",
  [0x003c] = "\x81\x7c", [0x003d] = "\x81\x7d", [0x003e] = "\x81\x7e",
  [0x0040] = "\x81\x80", [0x0041] = "\x81\x81", [0x0042] = "\x81\x82",
  [0x0043] = "\x81\x83", [0x0044] = "\x81\x84", [0x0045] = "\x81\x85",
  [0x0046] = "\x81\x86", [0x0047] = "\x81\x87", [0x0048] = "\x81\x88",
  [0x0049] = "\x81\x89", [0x004a] = "\x81\x8a", [0x004b] = "\x81\x8b",
  [0x004c] = "\x81\x8c", [0x004d] = "\x81\x8d", [0x004e] = "\x81\x8e",
  [0x004f] = "\x81\x8f", [0x0050] = "\x81\x90", [0x0051] = "\x81\x91",
  [0x0052] = "\x81\x92", [0x0053] = "\x81\x93", [0x0054] = "\x81\x94",
  [0x0055] = "\x81\x95", [0x0056] = "\x81\x96", [0x0057] = "\x81\x97",
  [0x0058] = "\x81\x98", [0x0059] = "\x81\x99", [0x005a] = "\x81\x9a",
  [0x005b] = "\x81\x9b", [0x005c] = "\x81\x9c", [0x005d] = "\x81\x9d",
  [0x005e] = "\x81\x9e", [0x005f] = "\x81\x9f", [0x0060] = "\x81\xa0",
  [0x0061] = "\x81\xa1", [0x0062] = "\x81\xa2", [0x0063] = "\x81\xa3",
  [0x0064] = "\x81\xa4", [0x0065] = "\x81\xa5", [0x0066] = "\x81\xa6",
  [0x0067] = "\x81\xa7", [0x0068] = "\x81\xa8", [0x0069] = "\x81\xa9",
  [0x006a] = "\x81\xaa", [0x006b] = "\x81\xab", [0x006c] = "\x81\xac",
  [0x006d] = "\x81\xad", [0x006e] = "\x81\xae", [0x006f] = "\x81\xaf",
  [0x0070] = "\x81\xb0", [0x0071] = "\x81\xb1", [0x0072] = "\x81\xb2",
  [0x0073] = "\x81\xb3", [0x0074] = "\x81\xb4", [0x0075] = "\x81\xb5",
  [0x0076] = "\x81\xb6", [0x0077] = "\x81\xb7", [0x0078] = "\x81\xb8",
  [0x0079] = "\x81\xb9", [0x007a] = "\x81\xba", [0x007b] = "\x81\xbb",
  [0x007c] = "\x81\xbc", [0x007d] = "\x81\xbd", [0x007e] = "\x81\xbe",
  [0x007f] = "\x81\xbf", [0x0080] = "\x81\xc0", [0x0081] = "\x81\xc1",
  [0x0082] = "\x81\xc2", [0x0083] = "\x81\xc3", [0x0084] = "\x81\xc4",
  [0x0085] = "\x81\xc5", [0x0086] = "\x81\xc6", [0x0087] = "\x81\xc7",
  [0x0088] = "\x81\xc8", [0x0089] = "\x81\xc9", [0x008a] = "\x81\xca",
  [0x008b] = "\x81\xcb", [0x008c] = "\x81\xcc", [0x008d] = "\x81\xcd",
  [0x008e] = "\x81\xce", [0x008f] = "\x81\xcf", [0x0090] = "\x81\xd0",
  [0x0091] = "\x81\xd1", [0x0092] = "\x81\xd2", [0x0093] = "\x81\xd3",
  [0x0094] = "\x81\xd4", [0x0095] = "\x81\xd5", [0x0096] = "\x81\xd6",
  [0x0097] = "\x81\xd7", [0x0098] = "\x81\xd8", [0x0099] = "\x81\xd9",
  [0x009a] = "\x81\xda", [0x009b] = "\x81\xdb", [0x009c] = "\x81\xdc",
  [0x009d] = "\x81\xdd", [0x009e] = "\x81\xde", [0x009f] = "\x81\xdf",
  [0x00a0] = "\x81\xe0", [0x00a1] = "\x81\xe1", [0x00a2] = "\x81\xe2",
  [0x00a3] = "\x81\xe3", [0x00a4] = "\x81\xe4", [0x00a5] = "\x81\xe5",
  [0x00a6] = "\x81\xe6", [0x00a7] = "\x81\xe7", [0x00a8] = "\x81\xe8",
  [0x00a9] = "\x81\xe9", [0x00aa] = "\x81\xea", [0x00ab] = "\x81\xeb",
  [0x00ac] = "\x81\xec", [0x00ad] = "\x81\xed", [0x00ae] = "\x81\xee",
  [0x00af] = "\x81\xef", [0x00b0] = "\x81\xf0", [0x00b1] = "\x81\xf1",
  [0x00b2] = "\x81\xf2", [0x00b3] = "\x81\xf3", [0x00b4] = "\x81\xf4",
  [0x00b5] = "\x81\xf5", [0x00b6] = "\x81\xf6", [0x00b7] = "\x81\xf7",
  [0x00b8] = "\x81\xf8", [0x00b9] = "\x81\xf9", [0x00ba] = "\x81\xfa",
  [0x00bb] = "\x81\xfb", [0x00bc] = "\x81\xfc", [0x00bd] = "\x81\xfd",
  [0x00be] = "\x81\xfe", [0x0100] = "\x82\x40", [0x0101] = "\x82\x41",
  [0x0102] = "\x82\x42", [0x0103] = "\x82\x43", [0x0104] = "\x82\x44",
  [0x0105] = "\x82\x45", [0x0106] = "\x82\x46", [0x0107] = "\x82\x47",
  [0x0108] = "\x82\x48", [0x0109] = "\x82\x49", [0x010a] = "\x82\x4a",
  [0x010b] = "\x82\x4b", [0x010c] = "\x82\x4c", [0x010d] = "\x82\x4d",
  [0x010e] = "\x82\x4e", [0x010f] = "\x82\x4f", [0x0110] = "\x82\x50",
  [0x0111] = "\x82\x51", [0x0112] = "\x82\x52", [0x0113] = "\x82\x53",
  [0x0114] = "\x82\x54", [0x0115] = "\x82\x55", [0x0116] = "\x82\x56",
  [0x0117] = "\x82\x57", [0x0118] = "\x82\x58", [0x0119] = "\x82\x59",
  [0x011a] = "\x82\x5a", [0x011b] = "\x82\x5b", [0x011c] = "\x82\x5c",
  [0x011d] = "\x82\x5d", [0x011e] = "\x82\x5e", [0x011f] = "\x82\x5f",
  [0x0120] = "\x82\x60", [0x0121] = "\x82\x61", [0x0122] = "\x82\x62",
  [0x0123] = "\x82\x63", [0x0124] = "\x82\x64", [0x0125] = "\x82\x65",
  [0x0126] = "\x82\x66", [0x0127] = "\x82\x67", [0x0128] = "\x82\x68",
  [0x0129] = "\x82\x69", [0x012a] = "\x82\x6a", [0x012b] = "\x82\x6b",
  [0x012c] = "\x82\x6c", [0x012d] = "\x82\x6d", [0x012e] = "\x82\x6e",
  [0x012f] = "\x82\x6f", [0x0130] = "\x82\x70", [0x0131] = "\x82\x71",
  [0x0132] = "\x82\x72", [0x0133] = "\x82\x73", [0x0134] = "\x82\x74",
  [0x0135] = "\x82\x75", [0x0136] = "\x82\x76", [0x0137] = "\x82\x77",
  [0x0138] = "\x82\x78", [0x0139] = "\x82\x79", [0x013a] = "\x82\x7a",
  [0x013b] = "\x82\x7b", [0x013c] = "\x82\x7c", [0x013d] = "\x82\x7d",
  [0x013e] = "\x82\x7e", [0x0140] = "\x82\x80", [0x0141] = "\x82\x81",
  [0x0142] = "\x82\x82", [0x0143] = "\x82\x83", [0x0144] = "\x82\x84",
  [0x0145] = "\x82\x85", [0x0146] = "\x82\x86", [0x0147] = "\x82\x87",
  [0x0148] = "\x82\x88", [0x0149] = "\x82\x89", [0x014a] = "\x82\x8a",
  [0x014b] = "\x82\x8b", [0x014c] = "\x82\x8c", [0x014d] = "\x82\x8d",
  [0x014e] = "\x82\x8e", [0x014f] = "\x82\x8f", [0x0150] = "\x82\x90",
  [0x0151] = "\x82\x91", [0x0152] = "\x82\x92", [0x0153] = "\x82\x93",
  [0x0154] = "\x82\x94", [0x0155] = "\x82\x95", [0x0156] = "\x82\x96",
  [0x0157] = "\x82\x97", [0x0158] = "\x82\x98", [0x0159] = "\x82\x99",
  [0x015a] = "\x82\x9a", [0x015b] = "\x82\x9b", [0x015c] = "\x82\x9c",
  [0x015d] = "\x82\x9d", [0x015e] = "\x82\x9e", [0x015f] = "\x82\x9f",
  [0x0160] = "\x82\xa0", [0x0161] = "\x82\xa1", [0x0162] = "\x82\xa2",
  [0x0163] = "\x82\xa3", [0x0164] = "\x82\xa4", [0x0165] = "\x82\xa5",
  [0x0166] = "\x82\xa6", [0x0167] = "\x82\xa7", [0x0168] = "\x82\xa8",
  [0x0169] = "\x82\xa9", [0x016a] = "\x82\xaa", [0x016b] = "\x82\xab",
  [0x016c] = "\x82\xac", [0x016d] = "\x82\xad", [0x016e] = "\x82\xae",
  [0x016f] = "\x82\xaf", [0x0170] = "\x82\xb0", [0x0171] = "\x82\xb1",
  [0x0172] = "\x82\xb2", [0x0173] = "\x82\xb3", [0x0174] = "\x82\xb4",
  [0x0175] = "\x82\xb5", [0x0176] = "\x82\xb6", [0x0177] = "\x82\xb7",
  [0x0178] = "\x82\xb8", [0x0179] = "\x82\xb9", [0x017a] = "\x82\xba",
  [0x017b] = "\x82\xbb", [0x017c] = "\x82\xbc", [0x017d] = "\x82\xbd",
  [0x017e] = "\x82\xbe", [0x017f] = "\x82\xbf", [0x0180] = "\x82\xc0",
  [0x0181] = "\x82\xc1", [0x0182] = "\x82\xc2", [0x0183] = "\x82\xc3",
  [0x0184] = "\x82\xc4", [0x0185] = "\x82\xc5", [0x0186] = "\x82\xc6",
  [0x0187] = "\x82\xc7", [0x0188] = "\x82\xc8", [0x0189] = "\x82\xc9",
  [0x018a] = "\x82\xca", [0x018b] = "\x82\xcb", [0x018c] = "\x82\xcc",
  [0x018d] = "\x82\xcd", [0x018e] = "\x82\xce", [0x018f] = "\x82\xcf",
  [0x0190] = "\x82\xd0", [0x0191] = "\x82\xd1", [0x0192] = "\x82\xd2",
  [0x0193] = "\x82\xd3", [0x0194] = "\x82\xd4", [0x0195] = "\x82\xd5",
  [0x0196] = "\x82\xd6", [0x0197] = "\x82\xd7", [0x0198] = "\x82\xd8",
  [0x0199] = "\x82\xd9", [0x019a] = "\x82\xda", [0x019b] = "\x82\xdb",
  [0x019c] = "\x82\xdc", [0x019d] = "\x82\xdd", [0x019e] = "\x82\xde",
  [0x019f] = "\x82\xdf", [0x01a0] = "\x82\xe0", [0x01a1] = "\x82\xe1",
  [0x01a2] = "\x82\xe2", [0x01a3] = "\x82\xe3", [0x01a4] = "\x82\xe4",
  [0x01a5] = "\x82\xe5", [0x01a6] = "\x82\xe6", [0x01a7] = "\x82\xe7",
  [0x01a8] = "\x82\xe8", [0x01a9] = "\x82\xe9", [0x01aa] = "\x82\xea",
  [0x01ab] = "\x82\xeb", [0x01ac] = "\x82\xec", [0x01ad] = "\x82\xed",
  [0x01ae] = "\x82\xee", [0x01af] = "\x82\xef", [0x01b0] = "\x82\xf0",
  [0x01b1] = "\x82\xf1", [0x01b2] = "\x82\xf2", [0x01b3] = "\x82\xf3",
  [0x01b4] = "\x82\xf4", [0x01b5] = "\x82\xf5", [0x01b6] = "\x82\xf6",
  [0x01b7] = "\x82\xf7", [0x01b8] = "\x82\xf8", [0x01b9] = "\x82\xf9",
  [0x01ba] = "\x82\xfa", [0x01bb] = "\x82\xfb", [0x01bc] = "\x82\xfc",
  [0x01bd] = "\x82\xfd", [0x01be] = "\x82\xfe", [0x0200] = "\x83\x40",
  [0x0201] = "\x83\x41", [0x0202] = "\x83\x42", [0x0203] = "\x83\x43",
  [0x0204] = "\x83\x44", [0x0205] = "\x83\x45", [0x0206] = "\x83\x46",
  [0x0207] = "\x83\x47", [0x0208] = "\x83\x48", [0x0209] = "\x83\x49",
  [0x020a] = "\x83\x4a", [0x020b] = "\x83\x4b", [0x020c] = "\x83\x4c",
  [0x020d] = "\x83\x4d", [0x020e] = "\x83\x4e", [0x020f] = "\x83\x4f",
  [0x0210] = "\x83\x50", [0x0211] = "\x83\x51", [0x0212] = "\x83\x52",
  [0x0213] = "\x83\x53", [0x0214] = "\x83\x54", [0x0215] = "\x83\x55",
  [0x0216] = "\x83\x56", [0x0217] = "\x83\x57", [0x0218] = "\x83\x58",
  [0x0219] = "\x83\x59", [0x021a] = "\x83\x5a", [0x021b] = "\x83\x5b",
  [0x021c] = "\x83\x5c", [0x021d] = "\x83\x5d", [0x021e] = "\x83\x5e",
  [0x021f] = "\x83\x5f", [0x0220] = "\x83\x60", [0x0221] = "\x83\x61",
  [0x0222] = "\x83\x62", [0x0223] = "\x83\x63", [0x0224] = "\x83\x64",
  [0x0225] = "\x83\x65", [0x0226] = "\x83\x66", [0x0227] = "\x83\x67",
  [0x0228] = "\x83\x68", [0x0229] = "\x83\x69", [0x022a] = "\x83\x6a",
  [0x022b] = "\x83\x6b", [0x022c] = "\x83\x6c", [0x022d] = "\x83\x6d",
  [0x022e] = "\x83\x6e", [0x022f] = "\x83\x6f", [0x0230] = "\x83\x70",
  [0x0231] = "\x83\x71", [0x0232] = "\x83\x72", [0x0233] = "\x83\x73",
  [0x0234] = "\x83\x74", [0x0235] = "\x83\x75", [0x0236] = "\x83\x76",
  [0x0237] = "\x83\x77", [0x0238] = "\x83\x78", [0x0239] = "\x83\x79",
  [0x023a] = "\x83\x7a", [0x023b] = "\x83\x7b", [0x023c] = "\x83\x7c",
  [0x023d] = "\x83\x7d", [0x023e] = "\x83\x7e", [0x0240] = "\x83\x80",
  [0x0241] = "\x83\x81", [0x0242] = "\x83\x82", [0x0243] = "\x83\x83",
  [0x0244] = "\x83\x84", [0x0245] = "\x83\x85", [0x0246] = "\x83\x86",
  [0x0247] = "\x83\x87", [0x0248] = "\x83\x88", [0x0249] = "\x83\x89",
  [0x024a] = "\x83\x8a", [0x024b] = "\x83\x8b", [0x024c] = "\x83\x8c",
  [0x024d] = "\x83\x8d", [0x024e] = "\x83\x8e", [0x024f] = "\x83\x8f",
  [0x0250] = "\x83\x90", [0x0251] = "\x83\x91", [0x0252] = "\x83\x92",
  [0x0253] = "\x83\x93", [0x0254] = "\x83\x94", [0x0255] = "\x83\x95",
  [0x0256] = "\x83\x96", [0x0257] = "\x83\x97", [0x0258] = "\x83\x98",
  [0x0259] = "\x83\x99", [0x025a] = "\x83\x9a", [0x025b] = "\x83\x9b",
  [0x025c] = "\x83\x9c", [0x025d] = "\x83\x9d", [0x025e] = "\x83\x9e",
  [0x025f] = "\x83\x9f", [0x0260] = "\x83\xa0", [0x0261] = "\x83\xa1",
  [0x0262] = "\x83\xa2", [0x0263] = "\x83\xa3", [0x0264] = "\x83\xa4",
  [0x0265] = "\x83\xa5", [0x0266] = "\x83\xa6", [0x0267] = "\x83\xa7",
  [0x0268] = "\x83\xa8", [0x0269] = "\x83\xa9", [0x026a] = "\x83\xaa",
  [0x026b] = "\x83\xab", [0x026c] = "\x83\xac", [0x026d] = "\x83\xad",
  [0x026e] = "\x83\xae", [0x026f] = "\x83\xaf", [0x0270] = "\x83\xb0",
  [0x0271] = "\x83\xb1", [0x0272] = "\x83\xb2", [0x0273] = "\x83\xb3",
  [0x0274] = "\x83\xb4", [0x0275] = "\x83\xb5", [0x0276] = "\x83\xb6",
  [0x0277] = "\x83\xb7", [0x0278] = "\x83\xb8", [0x0279] = "\x83\xb9",
  [0x027a] = "\x83\xba", [0x027b] = "\x83\xbb", [0x027c] = "\x83\xbc",
  [0x027d] = "\x83\xbd", [0x027e] = "\x83\xbe", [0x027f] = "\x83\xbf",
  [0x0280] = "\x83\xc0", [0x0281] = "\x83\xc1", [0x0282] = "\x83\xc2",
  [0x0283] = "\x83\xc3", [0x0284] = "\x83\xc4", [0x0285] = "\x83\xc5",
  [0x0286] = "\x83\xc6", [0x0287] = "\x83\xc7", [0x0288] = "\x83\xc8",
  [0x0289] = "\x83\xc9", [0x028a] = "\x83\xca", [0x028b] = "\x83\xcb",
  [0x028c] = "\x83\xcc", [0x028d] = "\x83\xcd", [0x028e] = "\x83\xce",
  [0x028f] = "\x83\xcf", [0x0290] = "\x83\xd0", [0x0291] = "\x83\xd1",
  [0x0292] = "\x83\xd2", [0x0293] = "\x83\xd3", [0x0294] = "\x83\xd4",
  [0x0295] = "\x83\xd5", [0x0296] = "\x83\xd6", [0x0297] = "\x83\xd7",
  [0x0298] = "\x83\xd8", [0x0299] = "\x83\xd9", [0x029a] = "\x83\xda",
  [0x029b] = "\x83\xdb", [0x029c] = "\x83\xdc", [0x029d] = "\x83\xdd",
  [0x029e] = "\x83\xde", [0x029f] = "\x83\xdf", [0x02a0] = "\x83\xe0",
  [0x02a1] = "\x83\xe1", [0x02a2] = "\x83\xe2", [0x02a3] = "\x83\xe3",
  [0x02a4] = "\x83\xe4", [0x02a5] = "\x83\xe5", [0x02a6] = "\x83\xe6",
  [0x02a7] = "\x83\xe7", [0x02a8] = "\x83\xe8", [0x02a9] = "\x83\xe9",
  [0x02aa] = "\x83\xea", [0x02ab] = "\x83\xeb", [0x02ac] = "\x83\xec",
  [0x02ad] = "\x83\xed", [0x02ae] = "\x83\xee", [0x02af] = "\x83\xef",
  [0x02b0] = "\x83\xf0", [0x02b1] = "\x83\xf1", [0x02b2] = "\x83\xf2",
  [0x02b3] = "\x83\xf3", [0x02b4] = "\x83\xf4", [0x02b5] = "\x83\xf5",
  [0x02b6] = "\x83\xf6", [0x02b7] = "\x83\xf7", [0x02b8] = "\x83\xf8",
  [0x02b9] = "\x83\xf9", [0x02ba] = "\x83\xfa", [0x02bb] = "\x83\xfb",
  [0x02bc] = "\x83\xfc", [0x02bd] = "\x83\xfd", [0x02be] = "\x83\xfe",
  [0x0300] = "\x84\x40", [0x0301] = "\x84\x41", [0x0302] = "\x84\x42",
  [0x0303] = "\x84\x43", [0x0304] = "\x84\x44", [0x0305] = "\x84\x45",
  [0x0306] = "\x84\x46", [0x0307] = "\x84\x47", [0x0308] = "\x84\x48",
  [0x0309] = "\x84\x49", [0x030a] = "\x84\x4a", [0x030b] = "\x84\x4b",
  [0x030c] = "\x84\x4c", [0x030d] = "\x84\x4d", [0x030e] = "\x84\x4e",
  [0x030f] = "\x84\x4f", [0x0310] = "\x84\x50", [0x0311] = "\x84\x51",
  [0x0312] = "\x84\x52", [0x0313] = "\x84\x53", [0x0314] = "\x84\x54",
  [0x0315] = "\x84\x55", [0x0316] = "\x84\x56", [0x0317] = "\x84\x57",
  [0x0318] = "\x84\x58", [0x0319] = "\x84\x59", [0x031a] = "\x84\x5a",
  [0x031b] = "\x84\x5b", [0x031c] = "\x84\x5c", [0x031d] = "\x84\x5d",
  [0x031e] = "\x84\x5e", [0x031f] = "\x84\x5f", [0x0320] = "\x84\x60",
  [0x0321] = "\x84\x61", [0x0322] = "\x84\x62", [0x0323] = "\x84\x63",
  [0x0324] = "\x84\x64", [0x0325] = "\x84\x65", [0x0326] = "\x84\x66",
  [0x0327] = "\x84\x67", [0x0328] = "\x84\x68", [0x0329] = "\x84\x69",
  [0x032a] = "\x84\x6a", [0x032b] = "\x84\x6b", [0x032c] = "\x84\x6c",
  [0x032d] = "\x84\x6d", [0x032e] = "\x84\x6e", [0x032f] = "\x84\x6f",
  [0x0330] = "\x84\x70", [0x0331] = "\x84\x71", [0x0332] = "\x84\x72",
  [0x0333] = "\x84\x73", [0x0334] = "\x84\x74", [0x0335] = "\x84\x75",
  [0x0336] = "\x84\x76", [0x0337] = "\x84\x77", [0x0338] = "\x84\x78",
  [0x0339] = "\x84\x79", [0x033a] = "\x84\x7a", [0x033b] = "\x84\x7b",
  [0x033c] = "\x84\x7c", [0x033d] = "\x84\x7d", [0x033e] = "\x84\x7e",
  [0x0340] = "\x84\x80", [0x0341] = "\x84\x81", [0x0342] = "\x84\x82",
  [0x0343] = "\x84\x83", [0x0344] = "\x84\x84", [0x0345] = "\x84\x85",
  [0x0346] = "\x84\x86", [0x0347] = "\x84\x87", [0x0348] = "\x84\x88",
  [0x0349] = "\x84\x89", [0x034a] = "\x84\x8a", [0x034b] = "\x84\x8b",
  [0x034c] = "\x84\x8c", [0x034d] = "\x84\x8d", [0x034e] = "\x84\x8e",
  [0x034f] = "\x84\x8f", [0x0350] = "\x84\x90", [0x0351] = "\x84\x91",
  [0x0352] = "\x84\x92", [0x0353] = "\x84\x93", [0x0354] = "\x84\x94",
  [0x0355] = "\x84\x95", [0x0356] = "\x84\x96", [0x0357] = "\x84\x97",
  [0x0358] = "\x84\x98", [0x0359] = "\x84\x99", [0x035a] = "\x84\x9a",
  [0x035b] = "\x84\x9b", [0x035c] = "\x84\x9c", [0x035d] = "\x84\x9d",
  [0x035e] = "\x84\x9e", [0x035f] = "\x84\x9f", [0x0360] = "\x84\xa0",
  [0x0361] = "\x84\xa1", [0x0362] = "\x84\xa2", [0x0363] = "\x84\xa3",
  [0x0364] = "\x84\xa4", [0x0365] = "\x84\xa5", [0x0366] = "\x84\xa6",
  [0x0367] = "\x84\xa7", [0x0368] = "\x84\xa8", [0x0369] = "\x84\xa9",
  [0x036a] = "\x84\xaa", [0x036b] = "\x84\xab", [0x036c] = "\x84\xac",
  [0x036d] = "\x84\xad", [0x036e] = "\x84\xae", [0x036f] = "\x84\xaf",
  [0x0370] = "\x84\xb0", [0x0371] = "\x84\xb1", [0x0372] = "\x84\xb2",
  [0x0373] = "\x84\xb3", [0x0374] = "\x84\xb4", [0x0375] = "\x84\xb5",
  [0x0376] = "\x84\xb6", [0x0377] = "\x84\xb7", [0x0378] = "\x84\xb8",
  [0x0379] = "\x84\xb9", [0x037a] = "\x84\xba", [0x037b] = "\x84\xbb",
  [0x037c] = "\x84\xbc", [0x037d] = "\x84\xbd", [0x037e] = "\x84\xbe",
  [0x037f] = "\x84\xbf", [0x0380] = "\x84\xc0", [0x0381] = "\x84\xc1",
  [0x0382] = "\x84\xc2", [0x0383] = "\x84\xc3", [0x0384] = "\x84\xc4",
  [0x0385] = "\x84\xc5", [0x0386] = "\x84\xc6", [0x0387] = "\x84\xc7",
  [0x0388] = "\x84\xc8", [0x0389] = "\x84\xc9", [0x038a] = "\x84\xca",
  [0x038b] = "\x84\xcb", [0x038c] = "\x84\xcc", [0x038d] = "\x84\xcd",
  [0x038e] = "\x84\xce", [0x038f] = "\x84\xcf", [0x0390] = "\x84\xd0",
  [0x0391] = "\x84\xd1", [0x0392] = "\x84\xd2", [0x0393] = "\x84\xd3",
  [0x0394] = "\x84\xd4", [0x0395] = "\x84\xd5", [0x0396] = "\x84\xd6",
  [0x0397] = "\x84\xd7", [0x0398] = "\x84\xd8", [0x0399] = "\x84\xd9",
  [0x039a] = "\x84\xda", [0x039b] = "\x84\xdb", [0x039c] = "\x84\xdc",
  [0x039d] = "\x84\xdd", [0x039e] = "\x84\xde", [0x039f] = "\x84\xdf",
  [0x03a0] = "\x84\xe0", [0x03a1] = "\x84\xe1", [0x03a2] = "\x84\xe2",
  [0x03a3] = "\x84\xe3", [0x03a4] = "\x84\xe4", [0x03a5] = "\x84\xe5",
  [0x03a6] = "\x84\xe6", [0x03a7] = "\x84\xe7", [0x03a8] = "\x84\xe8",
  [0x03a9] = "\x84\xe9", [0x03aa] = "\x84\xea", [0x03ab] = "\x84\xeb",
  [0x03ac] = "\x84\xec", [0x03ad] = "\x84\xed", [0x03ae] = "\x84\xee",
  [0x03af] = "\x84\xef", [0x03b0] = "\x84\xf0", [0x03b1] = "\x84\xf1",
  [0x03b2] = "\x84\xf2", [0x03b3] = "\x84\xf3", [0x03b4] = "\x84\xf4",
  [0x03b5] = "\x84\xf5", [0x03b6] = "\x84\xf6", [0x03b7] = "\x84\xf7",
  [0x03b8] = "\x84\xf8", [0x03b9] = "\x84\xf9", [0x03ba] = "\x84\xfa",
  [0x03bb] = "\x84\xfb", [0x03bc] = "\x84\xfc", [0x03bd] = "\x84\xfd",
  [0x03be] = "\x84\xfe", [0x0400] = "\x85\x40", [0x0401] = "\x85\x41",
  [0x0402] = "\x85\x42", [0x0403] = "\x85\x43", [0x0404] = "\x85\x44",
  [0x0405] = "\x85\x45", [0x0406] = "\x85\x46", [0x0407] = "\x85\x47",
  [0x0408] = "\x85\x48", [0x0409] = "\x85\x49", [0x040a] = "\x85\x4a",
  [0x040b] = "\x85\x4b", [0x040c] = "\x85\x4c", [0x040d] = "\x85\x4d",
  [0x040e] = "\x85\x4e", [0x040f] = "\x85\x4f", [0x0410] = "\x85\x50",
  [0x0411] = "\x85\x51", [0x0412] = "\x85\x52", [0x0413] = "\x85\x53",
  [0x0414] = "\x85\x54", [0x0415] = "\x85\x55", [0x0416] = "\x85\x56",
  [0x0417] = "\x85\x57", [0x0418] = "\x85\x58", [0x0419] = "\x85\x59",
  [0x041a] = "\x85\x5a", [0x041b] = "\x85\x5b", [0x041c] = "\x85\x5c",
  [0x041d] = "\x85\x5d", [0x041e] = "\x85\x5e", [0x041f] = "\x85\x5f",
  [0x0420] = "\x85\x60", [0x0421] = "\x85\x61", [0x0422] = "\x85\x62",
  [0x0423] = "\x85\x63", [0x0424] = "\x85\x64", [0x0425] = "\x85\x65",
  [0x0426] = "\x85\x66", [0x0427] = "\x85\x67", [0x0428] = "\x85\x68",
  [0x0429] = "\x85\x69", [0x042a] = "\x85\x6a", [0x042b] = "\x85\x6b",
  [0x042c] = "\x85\x6c", [0x042d] = "\x85\x6d", [0x042e] = "\x85\x6e",
  [0x042f] = "\x85\x6f", [0x0430] = "\x85\x70", [0x0431] = "\x85\x71",
  [0x0432] = "\x85\x72", [0x0433] = "\x85\x73", [0x0434] = "\x85\x74",
  [0x0435] = "\x85\x75", [0x0436] = "\x85\x76", [0x0437] = "\x85\x77",
  [0x0438] = "\x85\x78", [0x0439] = "\x85\x79", [0x043a] = "\x85\x7a",
  [0x043b] = "\x85\x7b", [0x043c] = "\x85\x7c", [0x043d] = "\x85\x7d",
  [0x043e] = "\x85\x7e", [0x0440] = "\x85\x80", [0x0441] = "\x85\x81",
  [0x0442] = "\x85\x82", [0x0443] = "\x85\x83", [0x0444] = "\x85\x84",
  [0x0445] = "\x85\x85", [0x0446] = "\x85\x86", [0x0447] = "\x85\x87",
  [0x0448] = "\x85\x88", [0x0449] = "\x85\x89", [0x044a] = "\x85\x8a",
  [0x044b] = "\x85\x8b", [0x044c] = "\x85\x8c", [0x044d] = "\x85\x8d",
  [0x044e] = "\x85\x8e", [0x044f] = "\x85\x8f", [0x0450] = "\x85\x90",
  [0x0451] = "\x85\x91", [0x0452] = "\x85\x92", [0x0453] = "\x85\x93",
  [0x0454] = "\x85\x94", [0x0455] = "\x85\x95", [0x0456] = "\x85\x96",
  [0x0457] = "\x85\x97", [0x0458] = "\x85\x98", [0x0459] = "\x85\x99",
  [0x045a] = "\x85\x9a", [0x045b] = "\x85\x9b", [0x045c] = "\x85\x9c",
  [0x045d] = "\x85\x9d", [0x045e] = "\x85\x9e", [0x045f] = "\x85\x9f",
  [0x0460] = "\x85\xa0", [0x0461] = "\x85\xa1", [0x0462] = "\x85\xa2",
  [0x0463] = "\x85\xa3", [0x0464] = "\x85\xa4", [0x0465] = "\x85\xa5",
  [0x0466] = "\x85\xa6", [0x0467] = "\x85\xa7", [0x0468] = "\x85\xa8",
  [0x0469] = "\x85\xa9", [0x046a] = "\x85\xaa", [0x046b] = "\x85\xab",
  [0x046c] = "\x85\xac", [0x046d] = "\x85\xad", [0x046e] = "\x85\xae",
  [0x046f] = "\x85\xaf", [0x0470] = "\x85\xb0", [0x0471] = "\x85\xb1",
  [0x0472] = "\x85\xb2", [0x0473] = "\x85\xb3", [0x0474] = "\x85\xb4",
  [0x0475] = "\x85\xb5", [0x0476] = "\x85\xb6", [0x0477] = "\x85\xb7",
  [0x0478] = "\x85\xb8", [0x0479] = "\x85\xb9", [0x047a] = "\x85\xba",
  [0x047b] = "\x85\xbb", [0x047c] = "\x85\xbc", [0x047d] = "\x85\xbd",
  [0x047e] = "\x85\xbe", [0x047f] = "\x85\xbf", [0x0480] = "\x85\xc0",
  [0x0481] = "\x85\xc1", [0x0482] = "\x85\xc2", [0x0483] = "\x85\xc3",
  [0x0484] = "\x85\xc4", [0x0485] = "\x85\xc5", [0x0486] = "\x85\xc6",
  [0x0487] = "\x85\xc7", [0x0488] = "\x85\xc8", [0x0489] = "\x85\xc9",
  [0x048a] = "\x85\xca", [0x048b] = "\x85\xcb", [0x048c] = "\x85\xcc",
  [0x048d] = "\x85\xcd", [0x048e] = "\x85\xce", [0x048f] = "\x85\xcf",
  [0x0490] = "\x85\xd0", [0x0491] = "\x85\xd1", [0x0492] = "\x85\xd2",
  [0x0493] = "\x85\xd3", [0x0494] = "\x85\xd4", [0x0495] = "\x85\xd5",
  [0x0496] = "\x85\xd6", [0x0497] = "\x85\xd7", [0x0498] = "\x85\xd8",
  [0x0499] = "\x85\xd9", [0x049a] = "\x85\xda", [0x049b] = "\x85\xdb",
  [0x049c] = "\x85\xdc", [0x049d] = "\x85\xdd", [0x049e] = "\x85\xde",
  [0x049f] = "\x85\xdf", [0x04a0] = "\x85\xe0", [0x04a1] = "\x85\xe1",
  [0x04a2] = "\x85\xe2", [0x04a3] = "\x85\xe3", [0x04a4] = "\x85\xe4",
  [0x04a5] = "\x85\xe5", [0x04a6] = "\x85\xe6", [0x04a7] = "\x85\xe7",
  [0x04a8] = "\x85\xe8", [0x04a9] = "\x85\xe9", [0x04aa] = "\x85\xea",
  [0x04ab] = "\x85\xeb", [0x04ac] = "\x85\xec", [0x04ad] = "\x85\xed",
  [0x04ae] = "\x85\xee", [0x04af] = "\x85\xef", [0x04b0] = "\x85\xf0",
  [0x04b1] = "\x85\xf1", [0x04b2] = "\x85\xf2", [0x04b3] = "\x85\xf3",
  [0x04b4] = "\x85\xf4", [0x04b5] = "\x85\xf5", [0x04b6] = "\x85\xf6",
  [0x04b7] = "\x85\xf7", [0x04b8] = "\x85\xf8", [0x04b9] = "\x85\xf9",
  [0x04ba] = "\x85\xfa", [0x04bb] = "\x85\xfb", [0x04bc] = "\x85\xfc",
  [0x04bd] = "\x85\xfd", [0x04be] = "\x85\xfe", [0x0500] = "\x86\x40",
  [0x0501] = "\x86\x41", [0x0502] = "\x86\x42", [0x0503] = "\x86\x43",
  [0x0504] = "\x86\x44", [0x0505] = "\x86\x45", [0x0506] = "\x86\x46",
  [0x0507] = "\x86\x47", [0x0508] = "\x86\x48", [0x0509] = "\x86\x49",
  [0x050a] = "\x86\x4a", [0x050b] = "\x86\x4b", [0x050c] = "\x86\x4c",
  [0x050d] = "\x86\x4d", [0x050e] = "\x86\x4e", [0x050f] = "\x86\x4f",
  [0x0510] = "\x86\x50", [0x0511] = "\x86\x51", [0x0512] = "\x86\x52",
  [0x0513] = "\x86\x53", [0x0514] = "\x86\x54", [0x0515] = "\x86\x55",
  [0x0516] = "\x86\x56", [0x0517] = "\x86\x57", [0x0518] = "\x86\x58",
  [0x0519] = "\x86\x59", [0x051a] = "\x86\x5a", [0x051b] = "\x86\x5b",
  [0x051c] = "\x86\x5c", [0x051d] = "\x86\x5d", [0x051e] = "\x86\x5e",
  [0x051f] = "\x86\x5f", [0x0520] = "\x86\x60", [0x0521] = "\x86\x61",
  [0x0522] = "\x86\x62", [0x0523] = "\x86\x63", [0x0524] = "\x86\x64",
  [0x0525] = "\x86\x65", [0x0526] = "\x86\x66", [0x0527] = "\x86\x67",
  [0x0528] = "\x86\x68", [0x0529] = "\x86\x69", [0x052a] = "\x86\x6a",
  [0x052b] = "\x86\x6b", [0x052c] = "\x86\x6c", [0x052d] = "\x86\x6d",
  [0x052e] = "\x86\x6e", [0x052f] = "\x86\x6f", [0x0530] = "\x86\x70",
  [0x0531] = "\x86\x71", [0x0532] = "\x86\x72", [0x0533] = "\x86\x73",
  [0x0534] = "\x86\x74", [0x0535] = "\x86\x75", [0x0536] = "\x86\x76",
  [0x0537] = "\x86\x77", [0x0538] = "\x86\x78", [0x0539] = "\x86\x79",
  [0x053a] = "\x86\x7a", [0x053b] = "\x86\x7b", [0x053c] = "\x86\x7c",
  [0x053d] = "\x86\x7d", [0x053e] = "\x86\x7e", [0x0540] = "\x86\x80",
  [0x0541] = "\x86\x81", [0x0542] = "\x86\x82", [0x0543] = "\x86\x83",
  [0x0544] = "\x86\x84", [0x0545] = "\x86\x85", [0x0546] = "\x86\x86",
  [0x0547] = "\x86\x87", [0x0548] = "\x86\x88", [0x0549] = "\x86\x89",
  [0x054a] = "\x86\x8a", [0x054b] = "\x86\x8b", [0x054c] = "\x86\x8c",
  [0x054d] = "\x86\x8d", [0x054e] = "\x86\x8e", [0x054f] = "\x86\x8f",
  [0x0550] = "\x86\x90", [0x0551] = "\x86\x91", [0x0552] = "\x86\x92",
  [0x0553] = "\x86\x93", [0x0554] = "\x86\x94", [0x0555] = "\x86\x95",
  [0x0556] = "\x86\x96", [0x0557] = "\x86\x97", [0x0558] = "\x86\x98",
  [0x0559] = "\x86\x99", [0x055a] = "\x86\x9a", [0x055b] = "\x86\x9b",
  [0x055c] = "\x86\x9c", [0x055d] = "\x86\x9d", [0x055e] = "\x86\x9e",
  [0x055f] = "\x86\x9f", [0x0560] = "\x86\xa0", [0x0561] = "\x86\xa1",
  [0x0562] = "\x86\xa2", [0x0563] = "\x86\xa3", [0x0564] = "\x86\xa4",
  [0x0565] = "\x86\xa5", [0x0566] = "\x86\xa6", [0x0567] = "\x86\xa7",
  [0x0568] = "\x86\xa8", [0x0569] = "\x86\xa9", [0x056a] = "\x86\xaa",
  [0x056b] = "\x86\xab", [0x056c] = "\x86\xac", [0x056d] = "\x86\xad",
  [0x056e] = "\x86\xae", [0x056f] = "\x86\xaf", [0x0570] = "\x86\xb0",
  [0x0571] = "\x86\xb1", [0x0572] = "\x86\xb2", [0x0573] = "\x86\xb3",
  [0x0574] = "\x86\xb4", [0x0575] = "\x86\xb5", [0x0576] = "\x86\xb6",
  [0x0577] = "\x86\xb7", [0x0578] = "\x86\xb8", [0x0579] = "\x86\xb9",
  [0x057a] = "\x86\xba", [0x057b] = "\x86\xbb", [0x057c] = "\x86\xbc",
  [0x057d] = "\x86\xbd", [0x057e] = "\x86\xbe", [0x057f] = "\x86\xbf",
  [0x0580] = "\x86\xc0", [0x0581] = "\x86\xc1", [0x0582] = "\x86\xc2",
  [0x0583] = "\x86\xc3", [0x0584] = "\x86\xc4", [0x0585] = "\x86\xc5",
  [0x0586] = "\x86\xc6", [0x0587] = "\x86\xc7", [0x0588] = "\x86\xc8",
  [0x0589] = "\x86\xc9", [0x058a] = "\x86\xca", [0x058b] = "\x86\xcb",
  [0x058c] = "\x86\xcc", [0x058d] = "\x86\xcd", [0x058e] = "\x86\xce",
  [0x058f] = "\x86\xcf", [0x0590] = "\x86\xd0", [0x0591] = "\x86\xd1",
  [0x0592] = "\x86\xd2", [0x0593] = "\x86\xd3", [0x0594] = "\x86\xd4",
  [0x0595] = "\x86\xd5", [0x0596] = "\x86\xd6", [0x0597] = "\x86\xd7",
  [0x0598] = "\x86\xd8", [0x0599] = "\x86\xd9", [0x059a] = "\x86\xda",
  [0x059b] = "\x86\xdb", [0x059c] = "\x86\xdc", [0x059d] = "\x86\xdd",
  [0x059e] = "\x86\xde", [0x059f] = "\x86\xdf", [0x05a0] = "\x86\xe0",
  [0x05a1] = "\x86\xe1", [0x05a2] = "\x86\xe2", [0x05a3] = "\x86\xe3",
  [0x05a4] = "\x86\xe4", [0x05a5] = "\x86\xe5", [0x05a6] = "\x86\xe6",
  [0x05a7] = "\x86\xe7", [0x05a8] = "\x86\xe8", [0x05a9] = "\x86\xe9",
  [0x05aa] = "\x86\xea", [0x05ab] = "\x86\xeb", [0x05ac] = "\x86\xec",
  [0x05ad] = "\x86\xed", [0x05ae] = "\x86\xee", [0x05af] = "\x86\xef",
  [0x05b0] = "\x86\xf0", [0x05b1] = "\x86\xf1", [0x05b2] = "\x86\xf2",
  [0x05b3] = "\x86\xf3", [0x05b4] = "\x86\xf4", [0x05b5] = "\x86\xf5",
  [0x05b6] = "\x86\xf6", [0x05b7] = "\x86\xf7", [0x05b8] = "\x86\xf8",
  [0x05b9] = "\x86\xf9", [0x05ba] = "\x86\xfa", [0x05bb] = "\x86\xfb",
  [0x05bc] = "\x86\xfc", [0x05bd] = "\x86\xfd", [0x05be] = "\x86\xfe",
  [0x0600] = "\x87\x40", [0x0601] = "\x87\x41", [0x0602] = "\x87\x42",
  [0x0603] = "\x87\x43", [0x0604] = "\x87\x44", [0x0605] = "\x87\x45",
  [0x0606] = "\x87\x46", [0x0607] = "\x87\x47", [0x0608] = "\x87\x48",
  [0x0609] = "\x87\x49", [0x060a] = "\x87\x4a", [0x060b] = "\x87\x4b",
  [0x060c] = "\x87\x4c", [0x060d] = "\x87\x4d", [0x060e] = "\x87\x4e",
  [0x060f] = "\x87\x4f", [0x0610] = "\x87\x50", [0x0611] = "\x87\x51",
  [0x0612] = "\x87\x52", [0x0613] = "\x87\x53", [0x0614] = "\x87\x54",
  [0x0615] = "\x87\x55", [0x0616] = "\x87\x56", [0x0617] = "\x87\x57",
  [0x0618] = "\x87\x58", [0x0619] = "\x87\x59", [0x061a] = "\x87\x5a",
  [0x061b] = "\x87\x5b", [0x061c] = "\x87\x5c", [0x061d] = "\x87\x5d",
  [0x061e] = "\x87\x5e", [0x061f] = "\x87\x5f", [0x0620] = "\x87\x60",
  [0x0621] = "\x87\x61", [0x0622] = "\x87\x62", [0x0623] = "\x87\x63",
  [0x0624] = "\x87\x64", [0x0625] = "\x87\x65", [0x0626] = "\x87\x66",
  [0x0627] = "\x87\x67", [0x0628] = "\x87\x68", [0x0629] = "\x87\x69",
  [0x062a] = "\x87\x6a", [0x062b] = "\x87\x6b", [0x062c] = "\x87\x6c",
  [0x062d] = "\x87\x6d", [0x062e] = "\x87\x6e", [0x062f] = "\x87\x6f",
  [0x0630] = "\x87\x70", [0x0631] = "\x87\x71", [0x0632] = "\x87\x72",
  [0x0633] = "\x87\x73", [0x0634] = "\x87\x74", [0x0635] = "\x87\x75",
  [0x0636] = "\x87\x76", [0x0637] = "\x87\x77", [0x0638] = "\x87\x78",
  [0x0639] = "\x87\x79", [0x063a] = "\x87\x7a", [0x063b] = "\x87\x7b",
  [0x063c] = "\x87\x7c", [0x063d] = "\x87\x7d", [0x063e] = "\x87\x7e",
  [0x0640] = "\x87\x80", [0x0641] = "\x87\x81", [0x0642] = "\x87\x82",
  [0x0643] = "\x87\x83", [0x0644] = "\x87\x84", [0x0645] = "\x87\x85",
  [0x0646] = "\x87\x86", [0x0647] = "\x87\x87", [0x0648] = "\x87\x88",
  [0x0649] = "\x87\x89", [0x064a] = "\x87\x8a", [0x064b] = "\x87\x8b",
  [0x064c] = "\x87\x8c", [0x064d] = "\x87\x8d", [0x064e] = "\x87\x8e",
  [0x064f] = "\x87\x8f", [0x0650] = "\x87\x90", [0x0651] = "\x87\x91",
  [0x0652] = "\x87\x92", [0x0653] = "\x87\x93", [0x0654] = "\x87\x94",
  [0x0655] = "\x87\x95", [0x0656] = "\x87\x96", [0x0657] = "\x87\x97",
  [0x0658] = "\x87\x98", [0x0659] = "\x87\x99", [0x065a] = "\x87\x9a",
  [0x065b] = "\x87\x9b", [0x065c] = "\x87\x9c", [0x065d] = "\x87\x9d",
  [0x065e] = "\x87\x9e", [0x065f] = "\x87\x9f", [0x0660] = "\x87\xa0",
  [0x0661] = "\x87\xa1", [0x0662] = "\x87\xa2", [0x0663] = "\x87\xa3",
  [0x0664] = "\x87\xa4", [0x0665] = "\x87\xa5", [0x0666] = "\x87\xa6",
  [0x0667] = "\x87\xa7", [0x0668] = "\x87\xa8", [0x0669] = "\x87\xa9",
  [0x066a] = "\x87\xaa", [0x066b] = "\x87\xab", [0x066c] = "\x87\xac",
  [0x066d] = "\x87\xad", [0x066e] = "\x87\xae", [0x066f] = "\x87\xaf",
  [0x0670] = "\x87\xb0", [0x0671] = "\x87\xb1", [0x0672] = "\x87\xb2",
  [0x0673] = "\x87\xb3", [0x0674] = "\x87\xb4", [0x0675] = "\x87\xb5",
  [0x0676] = "\x87\xb6", [0x0677] = "\x87\xb7", [0x0678] = "\x87\xb8",
  [0x0679] = "\x87\xb9", [0x067a] = "\x87\xba", [0x067b] = "\x87\xbb",
  [0x067c] = "\x87\xbc", [0x067d] = "\x87\xbd", [0x067e] = "\x87\xbe",
  [0x067f] = "\x87\xbf", [0x0680] = "\x87\xc0", [0x0681] = "\x87\xc1",
  [0x0682] = "\x87\xc2", [0x0683] = "\x87\xc3", [0x0684] = "\x87\xc4",
  [0x0685] = "\x87\xc5", [0x0686] = "\x87\xc6", [0x0687] = "\x87\xc7",
  [0x0688] = "\x87\xc8", [0x0689] = "\x87\xc9", [0x068a] = "\x87\xca",
  [0x068b] = "\x87\xcb", [0x068c] = "\x87\xcc", [0x068d] = "\x87\xcd",
  [0x068e] = "\x87\xce", [0x068f] = "\x87\xcf", [0x0690] = "\x87\xd0",
  [0x0691] = "\x87\xd1", [0x0692] = "\x87\xd2", [0x0693] = "\x87\xd3",
  [0x0694] = "\x87\xd4", [0x0695] = "\x87\xd5", [0x0696] = "\x87\xd6",
  [0x0697] = "\x87\xd7", [0x0698] = "\x87\xd8", [0x0699] = "\x87\xd9",
  [0x069a] = "\x87\xda", [0x069b] = "\x87\xdb", [0x069c] = "\x87\xdc",
  [0x069d] = "\x87\xdd", [0x069e] = "\x87\xde", [0x069f] = "\x87\xdf",
  [0x06a0] = "\x87\xe0", [0x06a1] = "\x87\xe1", [0x06a2] = "\x87\xe2",
  [0x06a3] = "\x87\xe3", [0x06a4] = "\x87\xe4", [0x06a5] = "\x87\xe5",
  [0x06a6] = "\x87\xe6", [0x06a7] = "\x87\xe7", [0x06a8] = "\x87\xe8",
  [0x06a9] = "\x87\xe9", [0x06aa] = "\x87\xea", [0x06ab] = "\x87\xeb",
  [0x06ac] = "\x87\xec", [0x06ad] = "\x87\xed", [0x06ae] = "\x87\xee",
  [0x06af] = "\x87\xef", [0x06b0] = "\x87\xf0", [0x06b1] = "\x87\xf1",
  [0x06b2] = "\x87\xf2", [0x06b3] = "\x87\xf3", [0x06b4] = "\x87\xf4",
  [0x06b5] = "\x87\xf5", [0x06b6] = "\x87\xf6", [0x06b7] = "\x87\xf7",
  [0x06b8] = "\x87\xf8", [0x06b9] = "\x87\xf9", [0x06ba] = "\x87\xfa",
  [0x06bb] = "\x87\xfb", [0x06bc] = "\x87\xfc", [0x06bd] = "\x87\xfd",
  [0x06be] = "\x87\xfe", [0x0700] = "\x88\x40", [0x0701] = "\x88\x41",
  [0x0702] = "\x88\x42", [0x0703] = "\x88\x43", [0x0704] = "\x88\x44",
  [0x0705] = "\x88\x45", [0x0706] = "\x88\x46", [0x0707] = "\x88\x47",
  [0x0708] = "\x88\x48", [0x0709] = "\x88\x49", [0x070a] = "\x88\x4a",
  [0x070b] = "\x88\x4b", [0x070c] = "\x88\x4c", [0x070d] = "\x88\x4d",
  [0x070e] = "\x88\x4e", [0x070f] = "\x88\x4f", [0x0710] = "\x88\x50",
  [0x0711] = "\x88\x51", [0x0712] = "\x88\x52", [0x0713] = "\x88\x53",
  [0x0714] = "\x88\x54", [0x0715] = "\x88\x55", [0x0716] = "\x88\x56",
  [0x0717] = "\x88\x57", [0x0718] = "\x88\x58", [0x0719] = "\x88\x59",
  [0x071a] = "\x88\x5a", [0x071b] = "\x88\x5b", [0x071c] = "\x88\x5c",
  [0x071d] = "\x88\x5d", [0x071e] = "\x88\x5e", [0x071f] = "\x88\x5f",
  [0x0720] = "\x88\x60", [0x0721] = "\x88\x61", [0x0722] = "\x88\x62",
  [0x0723] = "\x88\x63", [0x0724] = "\x88\x64", [0x0725] = "\x88\x65",
  [0x0726] = "\x88\x66", [0x0727] = "\x88\x67", [0x0728] = "\x88\x68",
  [0x0729] = "\x88\x69", [0x072a] = "\x88\x6a", [0x072b] = "\x88\x6b",
  [0x072c] = "\x88\x6c", [0x072d] = "\x88\x6d", [0x072e] = "\x88\x6e",
  [0x072f] = "\x88\x6f", [0x0730] = "\x88\x70", [0x0731] = "\x88\x71",
  [0x0732] = "\x88\x72", [0x0733] = "\x88\x73", [0x0734] = "\x88\x74",
  [0x0735] = "\x88\x75", [0x0736] = "\x88\x76", [0x0737] = "\x88\x77",
  [0x0738] = "\x88\x78", [0x0739] = "\x88\x79", [0x073a] = "\x88\x7a",
  [0x073b] = "\x88\x7b", [0x073c] = "\x88\x7c", [0x073d] = "\x88\x7d",
  [0x073e] = "\x88\x7e", [0x0740] = "\x88\x80", [0x0741] = "\x88\x81",
  [0x0742] = "\x88\x82", [0x0743] = "\x88\x83", [0x0744] = "\x88\x84",
  [0x0745] = "\x88\x85", [0x0746] = "\x88\x86", [0x0747] = "\x88\x87",
  [0x0748] = "\x88\x88", [0x0749] = "\x88\x89", [0x074a] = "\x88\x8a",
  [0x074b] = "\x88\x8b", [0x074c] = "\x88\x8c", [0x074d] = "\x88\x8d",
  [0x074e] = "\x88\x8e", [0x074f] = "\x88\x8f", [0x0750] = "\x88\x90",
  [0x0751] = "\x88\x91", [0x0752] = "\x88\x92", [0x0753] = "\x88\x93",
  [0x0754] = "\x88\x94", [0x0755] = "\x88\x95", [0x0756] = "\x88\x96",
  [0x0757] = "\x88\x97", [0x0758] = "\x88\x98", [0x0759] = "\x88\x99",
  [0x075a] = "\x88\x9a", [0x075b] = "\x88\x9b", [0x075c] = "\x88\x9c",
  [0x075d] = "\x88\x9d", [0x075e] = "\x88\x9e", [0x075f] = "\x88\x9f",
  [0x0760] = "\x88\xa0", [0x0761] = "\x88\xa1", [0x0762] = "\x88\xa2",
  [0x0763] = "\x88\xa3", [0x0764] = "\x88\xa4", [0x0765] = "\x88\xa5",
  [0x0766] = "\x88\xa6", [0x0767] = "\x88\xa7", [0x0768] = "\x88\xa8",
  [0x0769] = "\x88\xa9", [0x076a] = "\x88\xaa", [0x076b] = "\x88\xab",
  [0x076c] = "\x88\xac", [0x076d] = "\x88\xad", [0x076e] = "\x88\xae",
  [0x076f] = "\x88\xaf", [0x0770] = "\x88\xb0", [0x0771] = "\x88\xb1",
  [0x0772] = "\x88\xb2", [0x0773] = "\x88\xb3", [0x0774] = "\x88\xb4",
  [0x0775] = "\x88\xb5", [0x0776] = "\x88\xb6", [0x0777] = "\x88\xb7",
  [0x0778] = "\x88\xb8", [0x0779] = "\x88\xb9", [0x077a] = "\x88\xba",
  [0x077b] = "\x88\xbb", [0x077c] = "\x88\xbc", [0x077d] = "\x88\xbd",
  [0x077e] = "\x88\xbe", [0x077f] = "\x88\xbf", [0x0780] = "\x88\xc0",
  [0x0781] = "\x88\xc1", [0x0782] = "\x88\xc2", [0x0783] = "\x88\xc3",
  [0x0784] = "\x88\xc4", [0x0785] = "\x88\xc5", [0x0786] = "\x88\xc6",
  [0x0787] = "\x88\xc7", [0x0788] = "\x88\xc8", [0x0789] = "\x88\xc9",
  [0x078a] = "\x88\xca", [0x078b] = "\x88\xcb", [0x078c] = "\x88\xcc",
  [0x078d] = "\x88\xcd", [0x078e] = "\x88\xce", [0x078f] = "\x88\xcf",
  [0x0790] = "\x88\xd0", [0x0791] = "\x88\xd1", [0x0792] = "\x88\xd2",
  [0x0793] = "\x88\xd3", [0x0794] = "\x88\xd4", [0x0795] = "\x88\xd5",
  [0x0796] = "\x88\xd6", [0x0797] = "\x88\xd7", [0x0798] = "\x88\xd8",
  [0x0799] = "\x88\xd9", [0x079a] = "\x88\xda", [0x079b] = "\x88\xdb",
  [0x079c] = "\x88\xdc", [0x079d] = "\x88\xdd", [0x079e] = "\x88\xde",
  [0x079f] = "\x88\xdf", [0x07a0] = "\x88\xe0", [0x07a1] = "\x88\xe1",
  [0x07a2] = "\x88\xe2", [0x07a3] = "\x88\xe3", [0x07a4] = "\x88\xe4",
  [0x07a5] = "\x88\xe5", [0x07a6] = "\x88\xe6", [0x07a7] = "\x88\xe7",
  [0x07a8] = "\x88\xe8", [0x07a9] = "\x88\xe9", [0x07aa] = "\x88\xea",
  [0x07ab] = "\x88\xeb", [0x07ac] = "\x88\xec", [0x07ad] = "\x88\xed",
  [0x07ae] = "\x88\xee", [0x07af] = "\x88\xef", [0x07b0] = "\x88\xf0",
  [0x07b1] = "\x88\xf1", [0x07b2] = "\x88\xf2", [0x07b3] = "\x88\xf3",
  [0x07b4] = "\x88\xf4", [0x07b5] = "\x88\xf5", [0x07b6] = "\x88\xf6",
  [0x07b7] = "\x88\xf7", [0x07b8] = "\x88\xf8", [0x07b9] = "\x88\xf9",
  [0x07ba] = "\x88\xfa", [0x07bb] = "\x88\xfb", [0x07bc] = "\x88\xfc",
  [0x07bd] = "\x88\xfd", [0x07be] = "\x88\xfe", [0x0800] = "\x89\x40",
  [0x0801] = "\x89\x41", [0x0802] = "\x89\x42", [0x0803] = "\x89\x43",
  [0x0804] = "\x89\x44", [0x0805] = "\x89\x45", [0x0806] = "\x89\x46",
  [0x0807] = "\x89\x47", [0x0808] = "\x89\x48", [0x0809] = "\x89\x49",
  [0x080a] = "\x89\x4a", [0x080b] = "\x89\x4b", [0x080c] = "\x89\x4c",
  [0x080d] = "\x89\x4d", [0x080e] = "\x89\x4e", [0x080f] = "\x89\x4f",
  [0x0810] = "\x89\x50", [0x0811] = "\x89\x51", [0x0812] = "\x89\x52",
  [0x0813] = "\x89\x53", [0x0814] = "\x89\x54", [0x0815] = "\x89\x55",
  [0x0816] = "\x89\x56", [0x0817] = "\x89\x57", [0x0818] = "\x89\x58",
  [0x0819] = "\x89\x59", [0x081a] = "\x89\x5a", [0x081b] = "\x89\x5b",
  [0x081c] = "\x89\x5c", [0x081d] = "\x89\x5d", [0x081e] = "\x89\x5e",
  [0x081f] = "\x89\x5f", [0x0820] = "\x89\x60", [0x0821] = "\x89\x61",
  [0x0822] = "\x89\x62", [0x0823] = "\x89\x63", [0x0824] = "\x89\x64",
  [0x0825] = "\x89\x65", [0x0826] = "\x89\x66", [0x0827] = "\x89\x67",
  [0x0828] = "\x89\x68", [0x0829] = "\x89\x69", [0x082a] = "\x89\x6a",
  [0x082b] = "\x89\x6b", [0x082c] = "\x89\x6c", [0x082d] = "\x89\x6d",
  [0x082e] = "\x89\x6e", [0x082f] = "\x89\x6f", [0x0830] = "\x89\x70",
  [0x0831] = "\x89\x71", [0x0832] = "\x89\x72", [0x0833] = "\x89\x73",
  [0x0834] = "\x89\x74", [0x0835] = "\x89\x75", [0x0836] = "\x89\x76",
  [0x0837] = "\x89\x77", [0x0838] = "\x89\x78", [0x0839] = "\x89\x79",
  [0x083a] = "\x89\x7a", [0x083b] = "\x89\x7b", [0x083c] = "\x89\x7c",
  [0x083d] = "\x89\x7d", [0x083e] = "\x89\x7e", [0x0840] = "\x89\x80",
  [0x0841] = "\x89\x81", [0x0842] = "\x89\x82", [0x0843] = "\x89\x83",
  [0x0844] = "\x89\x84", [0x0845] = "\x89\x85", [0x0846] = "\x89\x86",
  [0x0847] = "\x89\x87", [0x0848] = "\x89\x88", [0x0849] = "\x89\x89",
  [0x084a] = "\x89\x8a", [0x084b] = "\x89\x8b", [0x084c] = "\x89\x8c",
  [0x084d] = "\x89\x8d", [0x084e] = "\x89\x8e", [0x084f] = "\x89\x8f",
  [0x0850] = "\x89\x90", [0x0851] = "\x89\x91", [0x0852] = "\x89\x92",
  [0x0853] = "\x89\x93", [0x0854] = "\x89\x94", [0x0855] = "\x89\x95",
  [0x0856] = "\x89\x96", [0x0857] = "\x89\x97", [0x0858] = "\x89\x98",
  [0x0859] = "\x89\x99", [0x085a] = "\x89\x9a", [0x085b] = "\x89\x9b",
  [0x085c] = "\x89\x9c", [0x085d] = "\x89\x9d", [0x085e] = "\x89\x9e",
  [0x085f] = "\x89\x9f", [0x0860] = "\x89\xa0", [0x0861] = "\x89\xa1",
  [0x0862] = "\x89\xa2", [0x0863] = "\x89\xa3", [0x0864] = "\x89\xa4",
  [0x0865] = "\x89\xa5", [0x0866] = "\x89\xa6", [0x0867] = "\x89\xa7",
  [0x0868] = "\x89\xa8", [0x0869] = "\x89\xa9", [0x086a] = "\x89\xaa",
  [0x086b] = "\x89\xab", [0x086c] = "\x89\xac", [0x086d] = "\x89\xad",
  [0x086e] = "\x89\xae", [0x086f] = "\x89\xaf", [0x0870] = "\x89\xb0",
  [0x0871] = "\x89\xb1", [0x0872] = "\x89\xb2", [0x0873] = "\x89\xb3",
  [0x0874] = "\x89\xb4", [0x0875] = "\x89\xb5", [0x0876] = "\x89\xb6",
  [0x0877] = "\x89\xb7", [0x0878] = "\x89\xb8", [0x0879] = "\x89\xb9",
  [0x087a] = "\x89\xba", [0x087b] = "\x89\xbb", [0x087c] = "\x89\xbc",
  [0x087d] = "\x89\xbd", [0x087e] = "\x89\xbe", [0x087f] = "\x89\xbf",
  [0x0880] = "\x89\xc0", [0x0881] = "\x89\xc1", [0x0882] = "\x89\xc2",
  [0x0883] = "\x89\xc3", [0x0884] = "\x89\xc4", [0x0885] = "\x89\xc5",
  [0x0886] = "\x89\xc6", [0x0887] = "\x89\xc7", [0x0888] = "\x89\xc8",
  [0x0889] = "\x89\xc9", [0x088a] = "\x89\xca", [0x088b] = "\x89\xcb",
  [0x088c] = "\x89\xcc", [0x088d] = "\x89\xcd", [0x088e] = "\x89\xce",
  [0x088f] = "\x89\xcf", [0x0890] = "\x89\xd0", [0x0891] = "\x89\xd1",
  [0x0892] = "\x89\xd2", [0x0893] = "\x89\xd3", [0x0894] = "\x89\xd4",
  [0x0895] = "\x89\xd5", [0x0896] = "\x89\xd6", [0x0897] = "\x89\xd7",
  [0x0898] = "\x89\xd8", [0x0899] = "\x89\xd9", [0x089a] = "\x89\xda",
  [0x089b] = "\x89\xdb", [0x089c] = "\x89\xdc", [0x089d] = "\x89\xdd",
  [0x089e] = "\x89\xde", [0x089f] = "\x89\xdf", [0x08a0] = "\x89\xe0",
  [0x08a1] = "\x89\xe1", [0x08a2] = "\x89\xe2", [0x08a3] = "\x89\xe3",
  [0x08a4] = "\x89\xe4", [0x08a5] = "\x89\xe5", [0x08a6] = "\x89\xe6",
  [0x08a7] = "\x89\xe7", [0x08a8] = "\x89\xe8", [0x08a9] = "\x89\xe9",
  [0x08aa] = "\x89\xea", [0x08ab] = "\x89\xeb", [0x08ac] = "\x89\xec",
  [0x08ad] = "\x89\xed", [0x08ae] = "\x89\xee", [0x08af] = "\x89\xef",
  [0x08b0] = "\x89\xf0", [0x08b1] = "\x89\xf1", [0x08b2] = "\x89\xf2",
  [0x08b3] = "\x89\xf3", [0x08b4] = "\x89\xf4", [0x08b5] = "\x89\xf5",
  [0x08b6] = "\x89\xf6", [0x08b7] = "\x89\xf7", [0x08b8] = "\x89\xf8",
  [0x08b9] = "\x89\xf9", [0x08ba] = "\x89\xfa", [0x08bb] = "\x89\xfb",
  [0x08bc] = "\x89\xfc", [0x08bd] = "\x89\xfd", [0x08be] = "\x89\xfe",
  [0x0900] = "\x8a\x40", [0x0901] = "\x8a\x41", [0x0902] = "\x8a\x42",
  [0x0903] = "\x8a\x43", [0x0904] = "\x8a\x44", [0x0905] = "\x8a\x45",
  [0x0906] = "\x8a\x46", [0x0907] = "\x8a\x47", [0x0908] = "\x8a\x48",
  [0x0909] = "\x8a\x49", [0x090a] = "\x8a\x4a", [0x090b] = "\x8a\x4b",
  [0x090c] = "\x8a\x4c", [0x090d] = "\x8a\x4d", [0x090e] = "\x8a\x4e",
  [0x090f] = "\x8a\x4f", [0x0910] = "\x8a\x50", [0x0911] = "\x8a\x51",
  [0x0912] = "\x8a\x52", [0x0913] = "\x8a\x53", [0x0914] = "\x8a\x54",
  [0x0915] = "\x8a\x55", [0x0916] = "\x8a\x56", [0x0917] = "\x8a\x57",
  [0x0918] = "\x8a\x58", [0x0919] = "\x8a\x59", [0x091a] = "\x8a\x5a",
  [0x091b] = "\x8a\x5b", [0x091c] = "\x8a\x5c", [0x091d] = "\x8a\x5d",
  [0x091e] = "\x8a\x5e", [0x091f] = "\x8a\x5f", [0x0920] = "\x8a\x60",
  [0x0921] = "\x8a\x61", [0x0922] = "\x8a\x62", [0x0923] = "\x8a\x63",
  [0x0924] = "\x8a\x64", [0x0925] = "\x8a\x65", [0x0926] = "\x8a\x66",
  [0x0927] = "\x8a\x67", [0x0928] = "\x8a\x68", [0x0929] = "\x8a\x69",
  [0x092a] = "\x8a\x6a", [0x092b] = "\x8a\x6b", [0x092c] = "\x8a\x6c",
  [0x092d] = "\x8a\x6d", [0x092e] = "\x8a\x6e", [0x092f] = "\x8a\x6f",
  [0x0930] = "\x8a\x70", [0x0931] = "\x8a\x71", [0x0932] = "\x8a\x72",
  [0x0933] = "\x8a\x73", [0x0934] = "\x8a\x74", [0x0935] = "\x8a\x75",
  [0x0936] = "\x8a\x76", [0x0937] = "\x8a\x77", [0x0938] = "\x8a\x78",
  [0x0939] = "\x8a\x79", [0x093a] = "\x8a\x7a", [0x093b] = "\x8a\x7b",
  [0x093c] = "\x8a\x7c", [0x093d] = "\x8a\x7d", [0x093e] = "\x8a\x7e",
  [0x0940] = "\x8a\x80", [0x0941] = "\x8a\x81", [0x0942] = "\x8a\x82",
  [0x0943] = "\x8a\x83", [0x0944] = "\x8a\x84", [0x0945] = "\x8a\x85",
  [0x0946] = "\x8a\x86", [0x0947] = "\x8a\x87", [0x0948] = "\x8a\x88",
  [0x0949] = "\x8a\x89", [0x094a] = "\x8a\x8a", [0x094b] = "\x8a\x8b",
  [0x094c] = "\x8a\x8c", [0x094d] = "\x8a\x8d", [0x094e] = "\x8a\x8e",
  [0x094f] = "\x8a\x8f", [0x0950] = "\x8a\x90", [0x0951] = "\x8a\x91",
  [0x0952] = "\x8a\x92", [0x0953] = "\x8a\x93", [0x0954] = "\x8a\x94",
  [0x0955] = "\x8a\x95", [0x0956] = "\x8a\x96", [0x0957] = "\x8a\x97",
  [0x0958] = "\x8a\x98", [0x0959] = "\x8a\x99", [0x095a] = "\x8a\x9a",
  [0x095b] = "\x8a\x9b", [0x095c] = "\x8a\x9c", [0x095d] = "\x8a\x9d",
  [0x095e] = "\x8a\x9e", [0x095f] = "\x8a\x9f", [0x0960] = "\x8a\xa0",
  [0x0961] = "\x8a\xa1", [0x0962] = "\x8a\xa2", [0x0963] = "\x8a\xa3",
  [0x0964] = "\x8a\xa4", [0x0965] = "\x8a\xa5", [0x0966] = "\x8a\xa6",
  [0x0967] = "\x8a\xa7", [0x0968] = "\x8a\xa8", [0x0969] = "\x8a\xa9",
  [0x096a] = "\x8a\xaa", [0x096b] = "\x8a\xab", [0x096c] = "\x8a\xac",
  [0x096d] = "\x8a\xad", [0x096e] = "\x8a\xae", [0x096f] = "\x8a\xaf",
  [0x0970] = "\x8a\xb0", [0x0971] = "\x8a\xb1", [0x0972] = "\x8a\xb2",
  [0x0973] = "\x8a\xb3", [0x0974] = "\x8a\xb4", [0x0975] = "\x8a\xb5",
  [0x0976] = "\x8a\xb6", [0x0977] = "\x8a\xb7", [0x0978] = "\x8a\xb8",
  [0x0979] = "\x8a\xb9", [0x097a] = "\x8a\xba", [0x097b] = "\x8a\xbb",
  [0x097c] = "\x8a\xbc", [0x097d] = "\x8a\xbd", [0x097e] = "\x8a\xbe",
  [0x097f] = "\x8a\xbf", [0x0980] = "\x8a\xc0", [0x0981] = "\x8a\xc1",
  [0x0982] = "\x8a\xc2", [0x0983] = "\x8a\xc3", [0x0984] = "\x8a\xc4",
  [0x0985] = "\x8a\xc5", [0x0986] = "\x8a\xc6", [0x0987] = "\x8a\xc7",
  [0x0988] = "\x8a\xc8", [0x0989] = "\x8a\xc9", [0x098a] = "\x8a\xca",
  [0x098b] = "\x8a\xcb", [0x098c] = "\x8a\xcc", [0x098d] = "\x8a\xcd",
  [0x098e] = "\x8a\xce", [0x098f] = "\x8a\xcf", [0x0990] = "\x8a\xd0",
  [0x0991] = "\x8a\xd1", [0x0992] = "\x8a\xd2", [0x0993] = "\x8a\xd3",
  [0x0994] = "\x8a\xd4", [0x0995] = "\x8a\xd5", [0x0996] = "\x8a\xd6",
  [0x0997] = "\x8a\xd7", [0x0998] = "\x8a\xd8", [0x0999] = "\x8a\xd9",
  [0x099a] = "\x8a\xda", [0x099b] = "\x8a\xdb", [0x099c] = "\x8a\xdc",
  [0x099d] = "\x8a\xdd", [0x099e] = "\x8a\xde", [0x099f] = "\x8a\xdf",
  [0x09a0] = "\x8a\xe0", [0x09a1] = "\x8a\xe1", [0x09a2] = "\x8a\xe2",
  [0x09a3] = "\x8a\xe3", [0x09a4] = "\x8a\xe4", [0x09a5] = "\x8a\xe5",
  [0x09a6] = "\x8a\xe6", [0x09a7] = "\x8a\xe7", [0x09a8] = "\x8a\xe8",
  [0x09a9] = "\x8a\xe9", [0x09aa] = "\x8a\xea", [0x09ab] = "\x8a\xeb",
  [0x09ac] = "\x8a\xec", [0x09ad] = "\x8a\xed", [0x09ae] = "\x8a\xee",
  [0x09af] = "\x8a\xef", [0x09b0] = "\x8a\xf0", [0x09b1] = "\x8a\xf1",
  [0x09b2] = "\x8a\xf2", [0x09b3] = "\x8a\xf3", [0x09b4] = "\x8a\xf4",
  [0x09b5] = "\x8a\xf5", [0x09b6] = "\x8a\xf6", [0x09b7] = "\x8a\xf7",
  [0x09b8] = "\x8a\xf8", [0x09b9] = "\x8a\xf9", [0x09ba] = "\x8a\xfa",
  [0x09bb] = "\x8a\xfb", [0x09bc] = "\x8a\xfc", [0x09bd] = "\x8a\xfd",
  [0x09be] = "\x8a\xfe", [0x0a00] = "\x8b\x40", [0x0a01] = "\x8b\x41",
  [0x0a02] = "\x8b\x42", [0x0a03] = "\x8b\x43", [0x0a04] = "\x8b\x44",
  [0x0a05] = "\x8b\x45", [0x0a06] = "\x8b\x46", [0x0a07] = "\x8b\x47",
  [0x0a08] = "\x8b\x48", [0x0a09] = "\x8b\x49", [0x0a0a] = "\x8b\x4a",
  [0x0a0b] = "\x8b\x4b", [0x0a0c] = "\x8b\x4c", [0x0a0d] = "\x8b\x4d",
  [0x0a0e] = "\x8b\x4e", [0x0a0f] = "\x8b\x4f", [0x0a10] = "\x8b\x50",
  [0x0a11] = "\x8b\x51", [0x0a12] = "\x8b\x52", [0x0a13] = "\x8b\x53",
  [0x0a14] = "\x8b\x54", [0x0a15] = "\x8b\x55", [0x0a16] = "\x8b\x56",
  [0x0a17] = "\x8b\x57", [0x0a18] = "\x8b\x58", [0x0a19] = "\x8b\x59",
  [0x0a1a] = "\x8b\x5a", [0x0a1b] = "\x8b\x5b", [0x0a1c] = "\x8b\x5c",
  [0x0a1d] = "\x8b\x5d", [0x0a1e] = "\x8b\x5e", [0x0a1f] = "\x8b\x5f",
  [0x0a20] = "\x8b\x60", [0x0a21] = "\x8b\x61", [0x0a22] = "\x8b\x62",
  [0x0a23] = "\x8b\x63", [0x0a24] = "\x8b\x64", [0x0a25] = "\x8b\x65",
  [0x0a26] = "\x8b\x66", [0x0a27] = "\x8b\x67", [0x0a28] = "\x8b\x68",
  [0x0a29] = "\x8b\x69", [0x0a2a] = "\x8b\x6a", [0x0a2b] = "\x8b\x6b",
  [0x0a2c] = "\x8b\x6c", [0x0a2d] = "\x8b\x6d", [0x0a2e] = "\x8b\x6e",
  [0x0a2f] = "\x8b\x6f", [0x0a30] = "\x8b\x70", [0x0a31] = "\x8b\x71",
  [0x0a32] = "\x8b\x72", [0x0a33] = "\x8b\x73", [0x0a34] = "\x8b\x74",
  [0x0a35] = "\x8b\x75", [0x0a36] = "\x8b\x76", [0x0a37] = "\x8b\x77",
  [0x0a38] = "\x8b\x78", [0x0a39] = "\x8b\x79", [0x0a3a] = "\x8b\x7a",
  [0x0a3b] = "\x8b\x7b", [0x0a3c] = "\x8b\x7c", [0x0a3d] = "\x8b\x7d",
  [0x0a3e] = "\x8b\x7e", [0x0a40] = "\x8b\x80", [0x0a41] = "\x8b\x81",
  [0x0a42] = "\x8b\x82", [0x0a43] = "\x8b\x83", [0x0a44] = "\x8b\x84",
  [0x0a45] = "\x8b\x85", [0x0a46] = "\x8b\x86", [0x0a47] = "\x8b\x87",
  [0x0a48] = "\x8b\x88", [0x0a49] = "\x8b\x89", [0x0a4a] = "\x8b\x8a",
  [0x0a4b] = "\x8b\x8b", [0x0a4c] = "\x8b\x8c", [0x0a4d] = "\x8b\x8d",
  [0x0a4e] = "\x8b\x8e", [0x0a4f] = "\x8b\x8f", [0x0a50] = "\x8b\x90",
  [0x0a51] = "\x8b\x91", [0x0a52] = "\x8b\x92", [0x0a53] = "\x8b\x93",
  [0x0a54] = "\x8b\x94", [0x0a55] = "\x8b\x95", [0x0a56] = "\x8b\x96",
  [0x0a57] = "\x8b\x97", [0x0a58] = "\x8b\x98", [0x0a59] = "\x8b\x99",
  [0x0a5a] = "\x8b\x9a", [0x0a5b] = "\x8b\x9b", [0x0a5c] = "\x8b\x9c",
  [0x0a5d] = "\x8b\x9d", [0x0a5e] = "\x8b\x9e", [0x0a5f] = "\x8b\x9f",
  [0x0a60] = "\x8b\xa0", [0x0a61] = "\x8b\xa1", [0x0a62] = "\x8b\xa2",
  [0x0a63] = "\x8b\xa3", [0x0a64] = "\x8b\xa4", [0x0a65] = "\x8b\xa5",
  [0x0a66] = "\x8b\xa6", [0x0a67] = "\x8b\xa7", [0x0a68] = "\x8b\xa8",
  [0x0a69] = "\x8b\xa9", [0x0a6a] = "\x8b\xaa", [0x0a6b] = "\x8b\xab",
  [0x0a6c] = "\x8b\xac", [0x0a6d] = "\x8b\xad", [0x0a6e] = "\x8b\xae",
  [0x0a6f] = "\x8b\xaf", [0x0a70] = "\x8b\xb0", [0x0a71] = "\x8b\xb1",
  [0x0a72] = "\x8b\xb2", [0x0a73] = "\x8b\xb3", [0x0a74] = "\x8b\xb4",
  [0x0a75] = "\x8b\xb5", [0x0a76] = "\x8b\xb6", [0x0a77] = "\x8b\xb7",
  [0x0a78] = "\x8b\xb8", [0x0a79] = "\x8b\xb9", [0x0a7a] = "\x8b\xba",
  [0x0a7b] = "\x8b\xbb", [0x0a7c] = "\x8b\xbc", [0x0a7d] = "\x8b\xbd",
  [0x0a7e] = "\x8b\xbe", [0x0a7f] = "\x8b\xbf", [0x0a80] = "\x8b\xc0",
  [0x0a81] = "\x8b\xc1", [0x0a82] = "\x8b\xc2", [0x0a83] = "\x8b\xc3",
  [0x0a84] = "\x8b\xc4", [0x0a85] = "\x8b\xc5", [0x0a86] = "\x8b\xc6",
  [0x0a87] = "\x8b\xc7", [0x0a88] = "\x8b\xc8", [0x0a89] = "\x8b\xc9",
  [0x0a8a] = "\x8b\xca", [0x0a8b] = "\x8b\xcb", [0x0a8c] = "\x8b\xcc",
  [0x0a8d] = "\x8b\xcd", [0x0a8e] = "\x8b\xce", [0x0a8f] = "\x8b\xcf",
  [0x0a90] = "\x8b\xd0", [0x0a91] = "\x8b\xd1", [0x0a92] = "\x8b\xd2",
  [0x0a93] = "\x8b\xd3", [0x0a94] = "\x8b\xd4", [0x0a95] = "\x8b\xd5",
  [0x0a96] = "\x8b\xd6", [0x0a97] = "\x8b\xd7", [0x0a98] = "\x8b\xd8",
  [0x0a99] = "\x8b\xd9", [0x0a9a] = "\x8b\xda", [0x0a9b] = "\x8b\xdb",
  [0x0a9c] = "\x8b\xdc", [0x0a9d] = "\x8b\xdd", [0x0a9e] = "\x8b\xde",
  [0x0a9f] = "\x8b\xdf", [0x0aa0] = "\x8b\xe0", [0x0aa1] = "\x8b\xe1",
  [0x0aa2] = "\x8b\xe2", [0x0aa3] = "\x8b\xe3", [0x0aa4] = "\x8b\xe4",
  [0x0aa5] = "\x8b\xe5", [0x0aa6] = "\x8b\xe6", [0x0aa7] = "\x8b\xe7",
  [0x0aa8] = "\x8b\xe8", [0x0aa9] = "\x8b\xe9", [0x0aaa] = "\x8b\xea",
  [0x0aab] = "\x8b\xeb", [0x0aac] = "\x8b\xec", [0x0aad] = "\x8b\xed",
  [0x0aae] = "\x8b\xee", [0x0aaf] = "\x8b\xef", [0x0ab0] = "\x8b\xf0",
  [0x0ab1] = "\x8b\xf1", [0x0ab2] = "\x8b\xf2", [0x0ab3] = "\x8b\xf3",
  [0x0ab4] = "\x8b\xf4", [0x0ab5] = "\x8b\xf5", [0x0ab6] = "\x8b\xf6",
  [0x0ab7] = "\x8b\xf7", [0x0ab8] = "\x8b\xf8", [0x0ab9] = "\x8b\xf9",
  [0x0aba] = "\x8b\xfa", [0x0abb] = "\x8b\xfb", [0x0abc] = "\x8b\xfc",
  [0x0abd] = "\x8b\xfd", [0x0abe] = "\x8b\xfe", [0x0b00] = "\x8c\x40",
  [0x0b01] = "\x8c\x41", [0x0b02] = "\x8c\x42", [0x0b03] = "\x8c\x43",
  [0x0b04] = "\x8c\x44", [0x0b05] = "\x8c\x45", [0x0b06] = "\x8c\x46",
  [0x0b07] = "\x8c\x47", [0x0b08] = "\x8c\x48", [0x0b09] = "\x8c\x49",
  [0x0b0a] = "\x8c\x4a", [0x0b0b] = "\x8c\x4b", [0x0b0c] = "\x8c\x4c",
  [0x0b0d] = "\x8c\x4d", [0x0b0e] = "\x8c\x4e", [0x0b0f] = "\x8c\x4f",
  [0x0b10] = "\x8c\x50", [0x0b11] = "\x8c\x51", [0x0b12] = "\x8c\x52",
  [0x0b13] = "\x8c\x53", [0x0b14] = "\x8c\x54", [0x0b15] = "\x8c\x55",
  [0x0b16] = "\x8c\x56", [0x0b17] = "\x8c\x57", [0x0b18] = "\x8c\x58",
  [0x0b19] = "\x8c\x59", [0x0b1a] = "\x8c\x5a", [0x0b1b] = "\x8c\x5b",
  [0x0b1c] = "\x8c\x5c", [0x0b1d] = "\x8c\x5d", [0x0b1e] = "\x8c\x5e",
  [0x0b1f] = "\x8c\x5f", [0x0b20] = "\x8c\x60", [0x0b21] = "\x8c\x61",
  [0x0b22] = "\x8c\x62", [0x0b23] = "\x8c\x63", [0x0b24] = "\x8c\x64",
  [0x0b25] = "\x8c\x65", [0x0b26] = "\x8c\x66", [0x0b27] = "\x8c\x67",
  [0x0b28] = "\x8c\x68", [0x0b29] = "\x8c\x69", [0x0b2a] = "\x8c\x6a",
  [0x0b2b] = "\x8c\x6b", [0x0b2c] = "\x8c\x6c", [0x0b2d] = "\x8c\x6d",
  [0x0b2e] = "\x8c\x6e", [0x0b2f] = "\x8c\x6f", [0x0b30] = "\x8c\x70",
  [0x0b31] = "\x8c\x71", [0x0b32] = "\x8c\x72", [0x0b33] = "\x8c\x73",
  [0x0b34] = "\x8c\x74", [0x0b35] = "\x8c\x75", [0x0b36] = "\x8c\x76",
  [0x0b37] = "\x8c\x77", [0x0b38] = "\x8c\x78", [0x0b39] = "\x8c\x79",
  [0x0b3a] = "\x8c\x7a", [0x0b3b] = "\x8c\x7b", [0x0b3c] = "\x8c\x7c",
  [0x0b3d] = "\x8c\x7d", [0x0b3e] = "\x8c\x7e", [0x0b40] = "\x8c\x80",
  [0x0b41] = "\x8c\x81", [0x0b42] = "\x8c\x82", [0x0b43] = "\x8c\x83",
  [0x0b44] = "\x8c\x84", [0x0b45] = "\x8c\x85", [0x0b46] = "\x8c\x86",
  [0x0b47] = "\x8c\x87", [0x0b48] = "\x8c\x88", [0x0b49] = "\x8c\x89",
  [0x0b4a] = "\x8c\x8a", [0x0b4b] = "\x8c\x8b", [0x0b4c] = "\x8c\x8c",
  [0x0b4d] = "\x8c\x8d", [0x0b4e] = "\x8c\x8e", [0x0b4f] = "\x8c\x8f",
  [0x0b50] = "\x8c\x90", [0x0b51] = "\x8c\x91", [0x0b52] = "\x8c\x92",
  [0x0b53] = "\x8c\x93", [0x0b54] = "\x8c\x94", [0x0b55] = "\x8c\x95",
  [0x0b56] = "\x8c\x96", [0x0b57] = "\x8c\x97", [0x0b58] = "\x8c\x98",
  [0x0b59] = "\x8c\x99", [0x0b5a] = "\x8c\x9a", [0x0b5b] = "\x8c\x9b",
  [0x0b5c] = "\x8c\x9c", [0x0b5d] = "\x8c\x9d", [0x0b5e] = "\x8c\x9e",
  [0x0b5f] = "\x8c\x9f", [0x0b60] = "\x8c\xa0", [0x0b61] = "\x8c\xa1",
  [0x0b62] = "\x8c\xa2", [0x0b63] = "\x8c\xa3", [0x0b64] = "\x8c\xa4",
  [0x0b65] = "\x8c\xa5", [0x0b66] = "\x8c\xa6", [0x0b67] = "\x8c\xa7",
  [0x0b68] = "\x8c\xa8", [0x0b69] = "\x8c\xa9", [0x0b6a] = "\x8c\xaa",
  [0x0b6b] = "\x8c\xab", [0x0b6c] = "\x8c\xac", [0x0b6d] = "\x8c\xad",
  [0x0b6e] = "\x8c\xae", [0x0b6f] = "\x8c\xaf", [0x0b70] = "\x8c\xb0",
  [0x0b71] = "\x8c\xb1", [0x0b72] = "\x8c\xb2", [0x0b73] = "\x8c\xb3",
  [0x0b74] = "\x8c\xb4", [0x0b75] = "\x8c\xb5", [0x0b76] = "\x8c\xb6",
  [0x0b77] = "\x8c\xb7", [0x0b78] = "\x8c\xb8", [0x0b79] = "\x8c\xb9",
  [0x0b7a] = "\x8c\xba", [0x0b7b] = "\x8c\xbb", [0x0b7c] = "\x8c\xbc",
  [0x0b7d] = "\x8c\xbd", [0x0b7e] = "\x8c\xbe", [0x0b7f] = "\x8c\xbf",
  [0x0b80] = "\x8c\xc0", [0x0b81] = "\x8c\xc1", [0x0b82] = "\x8c\xc2",
  [0x0b83] = "\x8c\xc3", [0x0b84] = "\x8c\xc4", [0x0b85] = "\x8c\xc5",
  [0x0b86] = "\x8c\xc6", [0x0b87] = "\x8c\xc7", [0x0b88] = "\x8c\xc8",
  [0x0b89] = "\x8c\xc9", [0x0b8a] = "\x8c\xca", [0x0b8b] = "\x8c\xcb",
  [0x0b8c] = "\x8c\xcc", [0x0b8d] = "\x8c\xcd", [0x0b8e] = "\x8c\xce",
  [0x0b8f] = "\x8c\xcf", [0x0b90] = "\x8c\xd0", [0x0b91] = "\x8c\xd1",
  [0x0b92] = "\x8c\xd2", [0x0b93] = "\x8c\xd3", [0x0b94] = "\x8c\xd4",
  [0x0b95] = "\x8c\xd5", [0x0b96] = "\x8c\xd6", [0x0b97] = "\x8c\xd7",
  [0x0b98] = "\x8c\xd8", [0x0b99] = "\x8c\xd9", [0x0b9a] = "\x8c\xda",
  [0x0b9b] = "\x8c\xdb", [0x0b9c] = "\x8c\xdc", [0x0b9d] = "\x8c\xdd",
  [0x0b9e] = "\x8c\xde", [0x0b9f] = "\x8c\xdf", [0x0ba0] = "\x8c\xe0",
  [0x0ba1] = "\x8c\xe1", [0x0ba2] = "\x8c\xe2", [0x0ba3] = "\x8c\xe3",
  [0x0ba4] = "\x8c\xe4", [0x0ba5] = "\x8c\xe5", [0x0ba6] = "\x8c\xe6",
  [0x0ba7] = "\x8c\xe7", [0x0ba8] = "\x8c\xe8", [0x0ba9] = "\x8c\xe9",
  [0x0baa] = "\x8c\xea", [0x0bab] = "\x8c\xeb", [0x0bac] = "\x8c\xec",
  [0x0bad] = "\x8c\xed", [0x0bae] = "\x8c\xee", [0x0baf] = "\x8c\xef",
  [0x0bb0] = "\x8c\xf0", [0x0bb1] = "\x8c\xf1", [0x0bb2] = "\x8c\xf2",
  [0x0bb3] = "\x8c\xf3", [0x0bb4] = "\x8c\xf4", [0x0bb5] = "\x8c\xf5",
  [0x0bb6] = "\x8c\xf6", [0x0bb7] = "\x8c\xf7", [0x0bb8] = "\x8c\xf8",
  [0x0bb9] = "\x8c\xf9", [0x0bba] = "\x8c\xfa", [0x0bbb] = "\x8c\xfb",
  [0x0bbc] = "\x8c\xfc", [0x0bbd] = "\x8c\xfd", [0x0bbe] = "\x8c\xfe",
  [0x0c00] = "\x8d\x40", [0x0c01] = "\x8d\x41", [0x0c02] = "\x8d\x42",
  [0x0c03] = "\x8d\x43", [0x0c04] = "\x8d\x44", [0x0c05] = "\x8d\x45",
  [0x0c06] = "\x8d\x46", [0x0c07] = "\x8d\x47", [0x0c08] = "\x8d\x48",
  [0x0c09] = "\x8d\x49", [0x0c0a] = "\x8d\x4a", [0x0c0b] = "\x8d\x4b",
  [0x0c0c] = "\x8d\x4c", [0x0c0d] = "\x8d\x4d", [0x0c0e] = "\x8d\x4e",
  [0x0c0f] = "\x8d\x4f", [0x0c10] = "\x8d\x50", [0x0c11] = "\x8d\x51",
  [0x0c12] = "\x8d\x52", [0x0c13] = "\x8d\x53", [0x0c14] = "\x8d\x54",
  [0x0c15] = "\x8d\x55", [0x0c16] = "\x8d\x56", [0x0c17] = "\x8d\x57",
  [0x0c18] = "\x8d\x58", [0x0c19] = "\x8d\x59", [0x0c1a] = "\x8d\x5a",
  [0x0c1b] = "\x8d\x5b", [0x0c1c] = "\x8d\x5c", [0x0c1d] = "\x8d\x5d",
  [0x0c1e] = "\x8d\x5e", [0x0c1f] = "\x8d\x5f", [0x0c20] = "\x8d\x60",
  [0x0c21] = "\x8d\x61", [0x0c22] = "\x8d\x62", [0x0c23] = "\x8d\x63",
  [0x0c24] = "\x8d\x64", [0x0c25] = "\x8d\x65", [0x0c26] = "\x8d\x66",
  [0x0c27] = "\x8d\x67", [0x0c28] = "\x8d\x68", [0x0c29] = "\x8d\x69",
  [0x0c2a] = "\x8d\x6a", [0x0c2b] = "\x8d\x6b", [0x0c2c] = "\x8d\x6c",
  [0x0c2d] = "\x8d\x6d", [0x0c2e] = "\x8d\x6e", [0x0c2f] = "\x8d\x6f",
  [0x0c30] = "\x8d\x70", [0x0c31] = "\x8d\x71", [0x0c32] = "\x8d\x72",
  [0x0c33] = "\x8d\x73", [0x0c34] = "\x8d\x74", [0x0c35] = "\x8d\x75",
  [0x0c36] = "\x8d\x76", [0x0c37] = "\x8d\x77", [0x0c38] = "\x8d\x78",
  [0x0c39] = "\x8d\x79", [0x0c3a] = "\x8d\x7a", [0x0c3b] = "\x8d\x7b",
  [0x0c3c] = "\x8d\x7c", [0x0c3d] = "\x8d\x7d", [0x0c3e] = "\x8d\x7e",
  [0x0c40] = "\x8d\x80", [0x0c41] = "\x8d\x81", [0x0c42] = "\x8d\x82",
  [0x0c43] = "\x8d\x83", [0x0c44] = "\x8d\x84", [0x0c45] = "\x8d\x85",
  [0x0c46] = "\x8d\x86", [0x0c47] = "\x8d\x87", [0x0c48] = "\x8d\x88",
  [0x0c49] = "\x8d\x89", [0x0c4a] = "\x8d\x8a", [0x0c4b] = "\x8d\x8b",
  [0x0c4c] = "\x8d\x8c", [0x0c4d] = "\x8d\x8d", [0x0c4e] = "\x8d\x8e",
  [0x0c4f] = "\x8d\x8f", [0x0c50] = "\x8d\x90", [0x0c51] = "\x8d\x91",
  [0x0c52] = "\x8d\x92", [0x0c53] = "\x8d\x93", [0x0c54] = "\x8d\x94",
  [0x0c55] = "\x8d\x95", [0x0c56] = "\x8d\x96", [0x0c57] = "\x8d\x97",
  [0x0c58] = "\x8d\x98", [0x0c59] = "\x8d\x99", [0x0c5a] = "\x8d\x9a",
  [0x0c5b] = "\x8d\x9b", [0x0c5c] = "\x8d\x9c", [0x0c5d] = "\x8d\x9d",
  [0x0c5e] = "\x8d\x9e", [0x0c5f] = "\x8d\x9f", [0x0c60] = "\x8d\xa0",
  [0x0c61] = "\x8d\xa1", [0x0c62] = "\x8d\xa2", [0x0c63] = "\x8d\xa3",
  [0x0c64] = "\x8d\xa4", [0x0c65] = "\x8d\xa5", [0x0c66] = "\x8d\xa6",
  [0x0c67] = "\x8d\xa7", [0x0c68] = "\x8d\xa8", [0x0c69] = "\x8d\xa9",
  [0x0c6a] = "\x8d\xaa", [0x0c6b] = "\x8d\xab", [0x0c6c] = "\x8d\xac",
  [0x0c6d] = "\x8d\xad", [0x0c6e] = "\x8d\xae", [0x0c6f] = "\x8d\xaf",
  [0x0c70] = "\x8d\xb0", [0x0c71] = "\x8d\xb1", [0x0c72] = "\x8d\xb2",
  [0x0c73] = "\x8d\xb3", [0x0c74] = "\x8d\xb4", [0x0c75] = "\x8d\xb5",
  [0x0c76] = "\x8d\xb6", [0x0c77] = "\x8d\xb7", [0x0c78] = "\x8d\xb8",
  [0x0c79] = "\x8d\xb9", [0x0c7a] = "\x8d\xba", [0x0c7b] = "\x8d\xbb",
  [0x0c7c] = "\x8d\xbc", [0x0c7d] = "\x8d\xbd", [0x0c7e] = "\x8d\xbe",
  [0x0c7f] = "\x8d\xbf", [0x0c80] = "\x8d\xc0", [0x0c81] = "\x8d\xc1",
  [0x0c82] = "\x8d\xc2", [0x0c83] = "\x8d\xc3", [0x0c84] = "\x8d\xc4",
  [0x0c85] = "\x8d\xc5", [0x0c86] = "\x8d\xc6", [0x0c87] = "\x8d\xc7",
  [0x0c88] = "\x8d\xc8", [0x0c89] = "\x8d\xc9", [0x0c8a] = "\x8d\xca",
  [0x0c8b] = "\x8d\xcb", [0x0c8c] = "\x8d\xcc", [0x0c8d] = "\x8d\xcd",
  [0x0c8e] = "\x8d\xce", [0x0c8f] = "\x8d\xcf", [0x0c90] = "\x8d\xd0",
  [0x0c91] = "\x8d\xd1", [0x0c92] = "\x8d\xd2", [0x0c93] = "\x8d\xd3",
  [0x0c94] = "\x8d\xd4", [0x0c95] = "\x8d\xd5", [0x0c96] = "\x8d\xd6",
  [0x0c97] = "\x8d\xd7", [0x0c98] = "\x8d\xd8", [0x0c99] = "\x8d\xd9",
  [0x0c9a] = "\x8d\xda", [0x0c9b] = "\x8d\xdb", [0x0c9c] = "\x8d\xdc",
  [0x0c9d] = "\x8d\xdd", [0x0c9e] = "\x8d\xde", [0x0c9f] = "\x8d\xdf",
  [0x0ca0] = "\x8d\xe0", [0x0ca1] = "\x8d\xe1", [0x0ca2] = "\x8d\xe2",
  [0x0ca3] = "\x8d\xe3", [0x0ca4] = "\x8d\xe4", [0x0ca5] = "\x8d\xe5",
  [0x0ca6] = "\x8d\xe6", [0x0ca7] = "\x8d\xe7", [0x0ca8] = "\x8d\xe8",
  [0x0ca9] = "\x8d\xe9", [0x0caa] = "\x8d\xea", [0x0cab] = "\x8d\xeb",
  [0x0cac] = "\x8d\xec", [0x0cad] = "\x8d\xed", [0x0cae] = "\x8d\xee",
  [0x0caf] = "\x8d\xef", [0x0cb0] = "\x8d\xf0", [0x0cb1] = "\x8d\xf1",
  [0x0cb2] = "\x8d\xf2", [0x0cb3] = "\x8d\xf3", [0x0cb4] = "\x8d\xf4",
  [0x0cb5] = "\x8d\xf5", [0x0cb6] = "\x8d\xf6", [0x0cb7] = "\x8d\xf7",
  [0x0cb8] = "\x8d\xf8", [0x0cb9] = "\x8d\xf9", [0x0cba] = "\x8d\xfa",
  [0x0cbb] = "\x8d\xfb", [0x0cbc] = "\x8d\xfc", [0x0cbd] = "\x8d\xfd",
  [0x0cbe] = "\x8d\xfe", [0x0d00] = "\x8e\x40", [0x0d01] = "\x8e\x41",
  [0x0d02] = "\x8e\x42", [0x0d03] = "\x8e\x43", [0x0d04] = "\x8e\x44",
  [0x0d05] = "\x8e\x45", [0x0d06] = "\x8e\x46", [0x0d07] = "\x8e\x47",
  [0x0d08] = "\x8e\x48", [0x0d09] = "\x8e\x49", [0x0d0a] = "\x8e\x4a",
  [0x0d0b] = "\x8e\x4b", [0x0d0c] = "\x8e\x4c", [0x0d0d] = "\x8e\x4d",
  [0x0d0e] = "\x8e\x4e", [0x0d0f] = "\x8e\x4f", [0x0d10] = "\x8e\x50",
  [0x0d11] = "\x8e\x51", [0x0d12] = "\x8e\x52", [0x0d13] = "\x8e\x53",
  [0x0d14] = "\x8e\x54", [0x0d15] = "\x8e\x55", [0x0d16] = "\x8e\x56",
  [0x0d17] = "\x8e\x57", [0x0d18] = "\x8e\x58", [0x0d19] = "\x8e\x59",
  [0x0d1a] = "\x8e\x5a", [0x0d1b] = "\x8e\x5b", [0x0d1c] = "\x8e\x5c",
  [0x0d1d] = "\x8e\x5d", [0x0d1e] = "\x8e\x5e", [0x0d1f] = "\x8e\x5f",
  [0x0d20] = "\x8e\x60", [0x0d21] = "\x8e\x61", [0x0d22] = "\x8e\x62",
  [0x0d23] = "\x8e\x63", [0x0d24] = "\x8e\x64", [0x0d25] = "\x8e\x65",
  [0x0d26] = "\x8e\x66", [0x0d27] = "\x8e\x67", [0x0d28] = "\x8e\x68",
  [0x0d29] = "\x8e\x69", [0x0d2a] = "\x8e\x6a", [0x0d2b] = "\x8e\x6b",
  [0x0d2c] = "\x8e\x6c", [0x0d2d] = "\x8e\x6d", [0x0d2e] = "\x8e\x6e",
  [0x0d2f] = "\x8e\x6f", [0x0d30] = "\x8e\x70", [0x0d31] = "\x8e\x71",
  [0x0d32] = "\x8e\x72", [0x0d33] = "\x8e\x73", [0x0d34] = "\x8e\x74",
  [0x0d35] = "\x8e\x75", [0x0d36] = "\x8e\x76", [0x0d37] = "\x8e\x77",
  [0x0d38] = "\x8e\x78", [0x0d39] = "\x8e\x79", [0x0d3a] = "\x8e\x7a",
  [0x0d3b] = "\x8e\x7b", [0x0d3c] = "\x8e\x7c", [0x0d3d] = "\x8e\x7d",
  [0x0d3e] = "\x8e\x7e", [0x0d40] = "\x8e\x80", [0x0d41] = "\x8e\x81",
  [0x0d42] = "\x8e\x82", [0x0d43] = "\x8e\x83", [0x0d44] = "\x8e\x84",
  [0x0d45] = "\x8e\x85", [0x0d46] = "\x8e\x86", [0x0d47] = "\x8e\x87",
  [0x0d48] = "\x8e\x88", [0x0d49] = "\x8e\x89", [0x0d4a] = "\x8e\x8a",
  [0x0d4b] = "\x8e\x8b", [0x0d4c] = "\x8e\x8c", [0x0d4d] = "\x8e\x8d",
  [0x0d4e] = "\x8e\x8e", [0x0d4f] = "\x8e\x8f", [0x0d50] = "\x8e\x90",
  [0x0d51] = "\x8e\x91", [0x0d52] = "\x8e\x92", [0x0d53] = "\x8e\x93",
  [0x0d54] = "\x8e\x94", [0x0d55] = "\x8e\x95", [0x0d56] = "\x8e\x96",
  [0x0d57] = "\x8e\x97", [0x0d58] = "\x8e\x98", [0x0d59] = "\x8e\x99",
  [0x0d5a] = "\x8e\x9a", [0x0d5b] = "\x8e\x9b", [0x0d5c] = "\x8e\x9c",
  [0x0d5d] = "\x8e\x9d", [0x0d5e] = "\x8e\x9e", [0x0d5f] = "\x8e\x9f",
  [0x0d60] = "\x8e\xa0", [0x0d61] = "\x8e\xa1", [0x0d62] = "\x8e\xa2",
  [0x0d63] = "\x8e\xa3", [0x0d64] = "\x8e\xa4", [0x0d65] = "\x8e\xa5",
  [0x0d66] = "\x8e\xa6", [0x0d67] = "\x8e\xa7", [0x0d68] = "\x8e\xa8",
  [0x0d69] = "\x8e\xa9", [0x0d6a] = "\x8e\xaa", [0x0d6b] = "\x8e\xab",
  [0x0d6c] = "\x8e\xac", [0x0d6d] = "\x8e\xad", [0x0d6e] = "\x8e\xae",
  [0x0d6f] = "\x8e\xaf", [0x0d70] = "\x8e\xb0", [0x0d71] = "\x8e\xb1",
  [0x0d72] = "\x8e\xb2", [0x0d73] = "\x8e\xb3", [0x0d74] = "\x8e\xb4",
  [0x0d75] = "\x8e\xb5", [0x0d76] = "\x8e\xb6", [0x0d77] = "\x8e\xb7",
  [0x0d78] = "\x8e\xb8", [0x0d79] = "\x8e\xb9", [0x0d7a] = "\x8e\xba",
  [0x0d7b] = "\x8e\xbb", [0x0d7c] = "\x8e\xbc", [0x0d7d] = "\x8e\xbd",
  [0x0d7e] = "\x8e\xbe", [0x0d7f] = "\x8e\xbf", [0x0d80] = "\x8e\xc0",
  [0x0d81] = "\x8e\xc1", [0x0d82] = "\x8e\xc2", [0x0d83] = "\x8e\xc3",
  [0x0d84] = "\x8e\xc4", [0x0d85] = "\x8e\xc5", [0x0d86] = "\x8e\xc6",
  [0x0d87] = "\x8e\xc7", [0x0d88] = "\x8e\xc8", [0x0d89] = "\x8e\xc9",
  [0x0d8a] = "\x8e\xca", [0x0d8b] = "\x8e\xcb", [0x0d8c] = "\x8e\xcc",
  [0x0d8d] = "\x8e\xcd", [0x0d8e] = "\x8e\xce", [0x0d8f] = "\x8e\xcf",
  [0x0d90] = "\x8e\xd0", [0x0d91] = "\x8e\xd1", [0x0d92] = "\x8e\xd2",
  [0x0d93] = "\x8e\xd3", [0x0d94] = "\x8e\xd4", [0x0d95] = "\x8e\xd5",
  [0x0d96] = "\x8e\xd6", [0x0d97] = "\x8e\xd7", [0x0d98] = "\x8e\xd8",
  [0x0d99] = "\x8e\xd9", [0x0d9a] = "\x8e\xda", [0x0d9b] = "\x8e\xdb",
  [0x0d9c] = "\x8e\xdc", [0x0d9d] = "\x8e\xdd", [0x0d9e] = "\x8e\xde",
  [0x0d9f] = "\x8e\xdf", [0x0da0] = "\x8e\xe0", [0x0da1] = "\x8e\xe1",
  [0x0da2] = "\x8e\xe2", [0x0da3] = "\x8e\xe3", [0x0da4] = "\x8e\xe4",
  [0x0da5] = "\x8e\xe5", [0x0da6] = "\x8e\xe6", [0x0da7] = "\x8e\xe7",
  [0x0da8] = "\x8e\xe8", [0x0da9] = "\x8e\xe9", [0x0daa] = "\x8e\xea",
  [0x0dab] = "\x8e\xeb", [0x0dac] = "\x8e\xec", [0x0dad] = "\x8e\xed",
  [0x0dae] = "\x8e\xee", [0x0daf] = "\x8e\xef", [0x0db0] = "\x8e\xf0",
  [0x0db1] = "\x8e\xf1", [0x0db2] = "\x8e\xf2", [0x0db3] = "\x8e\xf3",
  [0x0db4] = "\x8e\xf4", [0x0db5] = "\x8e\xf5", [0x0db6] = "\x8e\xf6",
  [0x0db7] = "\x8e\xf7", [0x0db8] = "\x8e\xf8", [0x0db9] = "\x8e\xf9",
  [0x0dba] = "\x8e\xfa", [0x0dbb] = "\x8e\xfb", [0x0dbc] = "\x8e\xfc",
  [0x0dbd] = "\x8e\xfd", [0x0dbe] = "\x8e\xfe", [0x0e00] = "\x8f\x40",
  [0x0e01] = "\x8f\x41", [0x0e02] = "\x8f\x42", [0x0e03] = "\x8f\x43",
  [0x0e04] = "\x8f\x44", [0x0e05] = "\x8f\x45", [0x0e06] = "\x8f\x46",
  [0x0e07] = "\x8f\x47", [0x0e08] = "\x8f\x48", [0x0e09] = "\x8f\x49",
  [0x0e0a] = "\x8f\x4a", [0x0e0b] = "\x8f\x4b", [0x0e0c] = "\x8f\x4c",
  [0x0e0d] = "\x8f\x4d", [0x0e0e] = "\x8f\x4e", [0x0e0f] = "\x8f\x4f",
  [0x0e10] = "\x8f\x50", [0x0e11] = "\x8f\x51", [0x0e12] = "\x8f\x52",
  [0x0e13] = "\x8f\x53", [0x0e14] = "\x8f\x54", [0x0e15] = "\x8f\x55",
  [0x0e16] = "\x8f\x56", [0x0e17] = "\x8f\x57", [0x0e18] = "\x8f\x58",
  [0x0e19] = "\x8f\x59", [0x0e1a] = "\x8f\x5a", [0x0e1b] = "\x8f\x5b",
  [0x0e1c] = "\x8f\x5c", [0x0e1d] = "\x8f\x5d", [0x0e1e] = "\x8f\x5e",
  [0x0e1f] = "\x8f\x5f", [0x0e20] = "\x8f\x60", [0x0e21] = "\x8f\x61",
  [0x0e22] = "\x8f\x62", [0x0e23] = "\x8f\x63", [0x0e24] = "\x8f\x64",
  [0x0e25] = "\x8f\x65", [0x0e26] = "\x8f\x66", [0x0e27] = "\x8f\x67",
  [0x0e28] = "\x8f\x68", [0x0e29] = "\x8f\x69", [0x0e2a] = "\x8f\x6a",
  [0x0e2b] = "\x8f\x6b", [0x0e2c] = "\x8f\x6c", [0x0e2d] = "\x8f\x6d",
  [0x0e2e] = "\x8f\x6e", [0x0e2f] = "\x8f\x6f", [0x0e30] = "\x8f\x70",
  [0x0e31] = "\x8f\x71", [0x0e32] = "\x8f\x72", [0x0e33] = "\x8f\x73",
  [0x0e34] = "\x8f\x74", [0x0e35] = "\x8f\x75", [0x0e36] = "\x8f\x76",
  [0x0e37] = "\x8f\x77", [0x0e38] = "\x8f\x78", [0x0e39] = "\x8f\x79",
  [0x0e3a] = "\x8f\x7a", [0x0e3b] = "\x8f\x7b", [0x0e3c] = "\x8f\x7c",
  [0x0e3d] = "\x8f\x7d", [0x0e3e] = "\x8f\x7e", [0x0e40] = "\x8f\x80",
  [0x0e41] = "\x8f\x81", [0x0e42] = "\x8f\x82", [0x0e43] = "\x8f\x83",
  [0x0e44] = "\x8f\x84", [0x0e45] = "\x8f\x85", [0x0e46] = "\x8f\x86",
  [0x0e47] = "\x8f\x87", [0x0e48] = "\x8f\x88", [0x0e49] = "\x8f\x89",
  [0x0e4a] = "\x8f\x8a", [0x0e4b] = "\x8f\x8b", [0x0e4c] = "\x8f\x8c",
  [0x0e4d] = "\x8f\x8d", [0x0e4e] = "\x8f\x8e", [0x0e4f] = "\x8f\x8f",
  [0x0e50] = "\x8f\x90", [0x0e51] = "\x8f\x91", [0x0e52] = "\x8f\x92",
  [0x0e53] = "\x8f\x93", [0x0e54] = "\x8f\x94", [0x0e55] = "\x8f\x95",
  [0x0e56] = "\x8f\x96", [0x0e57] = "\x8f\x97", [0x0e58] = "\x8f\x98",
  [0x0e59] = "\x8f\x99", [0x0e5a] = "\x8f\x9a", [0x0e5b] = "\x8f\x9b",
  [0x0e5c] = "\x8f\x9c", [0x0e5d] = "\x8f\x9d", [0x0e5e] = "\x8f\x9e",
  [0x0e5f] = "\x8f\x9f", [0x0e60] = "\x8f\xa0", [0x0e61] = "\x8f\xa1",
  [0x0e62] = "\x8f\xa2", [0x0e63] = "\x8f\xa3", [0x0e64] = "\x8f\xa4",
  [0x0e65] = "\x8f\xa5", [0x0e66] = "\x8f\xa6", [0x0e67] = "\x8f\xa7",
  [0x0e68] = "\x8f\xa8", [0x0e69] = "\x8f\xa9", [0x0e6a] = "\x8f\xaa",
  [0x0e6b] = "\x8f\xab", [0x0e6c] = "\x8f\xac", [0x0e6d] = "\x8f\xad",
  [0x0e6e] = "\x8f\xae", [0x0e6f] = "\x8f\xaf", [0x0e70] = "\x8f\xb0",
  [0x0e71] = "\x8f\xb1", [0x0e72] = "\x8f\xb2", [0x0e73] = "\x8f\xb3",
  [0x0e74] = "\x8f\xb4", [0x0e75] = "\x8f\xb5", [0x0e76] = "\x8f\xb6",
  [0x0e77] = "\x8f\xb7", [0x0e78] = "\x8f\xb8", [0x0e79] = "\x8f\xb9",
  [0x0e7a] = "\x8f\xba", [0x0e7b] = "\x8f\xbb", [0x0e7c] = "\x8f\xbc",
  [0x0e7d] = "\x8f\xbd", [0x0e7e] = "\x8f\xbe", [0x0e7f] = "\x8f\xbf",
  [0x0e80] = "\x8f\xc0", [0x0e81] = "\x8f\xc1", [0x0e82] = "\x8f\xc2",
  [0x0e83] = "\x8f\xc3", [0x0e84] = "\x8f\xc4", [0x0e85] = "\x8f\xc5",
  [0x0e86] = "\x8f\xc6", [0x0e87] = "\x8f\xc7", [0x0e88] = "\x8f\xc8",
  [0x0e89] = "\x8f\xc9", [0x0e8a] = "\x8f\xca", [0x0e8b] = "\x8f\xcb",
  [0x0e8c] = "\x8f\xcc", [0x0e8d] = "\x8f\xcd", [0x0e8e] = "\x8f\xce",
  [0x0e8f] = "\x8f\xcf", [0x0e90] = "\x8f\xd0", [0x0e91] = "\x8f\xd1",
  [0x0e92] = "\x8f\xd2", [0x0e93] = "\x8f\xd3", [0x0e94] = "\x8f\xd4",
  [0x0e95] = "\x8f\xd5", [0x0e96] = "\x8f\xd6", [0x0e97] = "\x8f\xd7",
  [0x0e98] = "\x8f\xd8", [0x0e99] = "\x8f\xd9", [0x0e9a] = "\x8f\xda",
  [0x0e9b] = "\x8f\xdb", [0x0e9c] = "\x8f\xdc", [0x0e9d] = "\x8f\xdd",
  [0x0e9e] = "\x8f\xde", [0x0e9f] = "\x8f\xdf", [0x0ea0] = "\x8f\xe0",
  [0x0ea1] = "\x8f\xe1", [0x0ea2] = "\x8f\xe2", [0x0ea3] = "\x8f\xe3",
  [0x0ea4] = "\x8f\xe4", [0x0ea5] = "\x8f\xe5", [0x0ea6] = "\x8f\xe6",
  [0x0ea7] = "\x8f\xe7", [0x0ea8] = "\x8f\xe8", [0x0ea9] = "\x8f\xe9",
  [0x0eaa] = "\x8f\xea", [0x0eab] = "\x8f\xeb", [0x0eac] = "\x8f\xec",
  [0x0ead] = "\x8f\xed", [0x0eae] = "\x8f\xee", [0x0eaf] = "\x8f\xef",
  [0x0eb0] = "\x8f\xf0", [0x0eb1] = "\x8f\xf1", [0x0eb2] = "\x8f\xf2",
  [0x0eb3] = "\x8f\xf3", [0x0eb4] = "\x8f\xf4", [0x0eb5] = "\x8f\xf5",
  [0x0eb6] = "\x8f\xf6", [0x0eb7] = "\x8f\xf7", [0x0eb8] = "\x8f\xf8",
  [0x0eb9] = "\x8f\xf9", [0x0eba] = "\x8f\xfa", [0x0ebb] = "\x8f\xfb",
  [0x0ebc] = "\x8f\xfc", [0x0ebd] = "\x8f\xfd", [0x0ebe] = "\x8f\xfe",
  [0x0f00] = "\x90\x40", [0x0f01] = "\x90\x41", [0x0f02] = "\x90\x42",
  [0x0f03] = "\x90\x43", [0x0f04] = "\x90\x44", [0x0f05] = "\x90\x45",
  [0x0f06] = "\x90\x46", [0x0f07] = "\x90\x47", [0x0f08] = "\x90\x48",
  [0x0f09] = "\x90\x49", [0x0f0a] = "\x90\x4a", [0x0f0b] = "\x90\x4b",
  [0x0f0c] = "\x90\x4c", [0x0f0d] = "\x90\x4d", [0x0f0e] = "\x90\x4e",
  [0x0f0f] = "\x90\x4f", [0x0f10] = "\x90\x50", [0x0f11] = "\x90\x51",
  [0x0f12] = "\x90\x52", [0x0f13] = "\x90\x53", [0x0f14] = "\x90\x54",
  [0x0f15] = "\x90\x55", [0x0f16] = "\x90\x56", [0x0f17] = "\x90\x57",
  [0x0f18] = "\x90\x58", [0x0f19] = "\x90\x59", [0x0f1a] = "\x90\x5a",
  [0x0f1b] = "\x90\x5b", [0x0f1c] = "\x90\x5c", [0x0f1d] = "\x90\x5d",
  [0x0f1e] = "\x90\x5e", [0x0f1f] = "\x90\x5f", [0x0f20] = "\x90\x60",
  [0x0f21] = "\x90\x61", [0x0f22] = "\x90\x62", [0x0f23] = "\x90\x63",
  [0x0f24] = "\x90\x64", [0x0f25] = "\x90\x65", [0x0f26] = "\x90\x66",
  [0x0f27] = "\x90\x67", [0x0f28] = "\x90\x68", [0x0f29] = "\x90\x69",
  [0x0f2a] = "\x90\x6a", [0x0f2b] = "\x90\x6b", [0x0f2c] = "\x90\x6c",
  [0x0f2d] = "\x90\x6d", [0x0f2e] = "\x90\x6e", [0x0f2f] = "\x90\x6f",
  [0x0f30] = "\x90\x70", [0x0f31] = "\x90\x71", [0x0f32] = "\x90\x72",
  [0x0f33] = "\x90\x73", [0x0f34] = "\x90\x74", [0x0f35] = "\x90\x75",
  [0x0f36] = "\x90\x76", [0x0f37] = "\x90\x77", [0x0f38] = "\x90\x78",
  [0x0f39] = "\x90\x79", [0x0f3a] = "\x90\x7a", [0x0f3b] = "\x90\x7b",
  [0x0f3c] = "\x90\x7c", [0x0f3d] = "\x90\x7d", [0x0f3e] = "\x90\x7e",
  [0x0f40] = "\x90\x80", [0x0f41] = "\x90\x81", [0x0f42] = "\x90\x82",
  [0x0f43] = "\x90\x83", [0x0f44] = "\x90\x84", [0x0f45] = "\x90\x85",
  [0x0f46] = "\x90\x86", [0x0f47] = "\x90\x87", [0x0f48] = "\x90\x88",
  [0x0f49] = "\x90\x89", [0x0f4a] = "\x90\x8a", [0x0f4b] = "\x90\x8b",
  [0x0f4c] = "\x90\x8c", [0x0f4d] = "\x90\x8d", [0x0f4e] = "\x90\x8e",
  [0x0f4f] = "\x90\x8f", [0x0f50] = "\x90\x90", [0x0f51] = "\x90\x91",
  [0x0f52] = "\x90\x92", [0x0f53] = "\x90\x93", [0x0f54] = "\x90\x94",
  [0x0f55] = "\x90\x95", [0x0f56] = "\x90\x96", [0x0f57] = "\x90\x97",
  [0x0f58] = "\x90\x98", [0x0f59] = "\x90\x99", [0x0f5a] = "\x90\x9a",
  [0x0f5b] = "\x90\x9b", [0x0f5c] = "\x90\x9c", [0x0f5d] = "\x90\x9d",
  [0x0f5e] = "\x90\x9e", [0x0f5f] = "\x90\x9f", [0x0f60] = "\x90\xa0",
  [0x0f61] = "\x90\xa1", [0x0f62] = "\x90\xa2", [0x0f63] = "\x90\xa3",
  [0x0f64] = "\x90\xa4", [0x0f65] = "\x90\xa5", [0x0f66] = "\x90\xa6",
  [0x0f67] = "\x90\xa7", [0x0f68] = "\x90\xa8", [0x0f69] = "\x90\xa9",
  [0x0f6a] = "\x90\xaa", [0x0f6b] = "\x90\xab", [0x0f6c] = "\x90\xac",
  [0x0f6d] = "\x90\xad", [0x0f6e] = "\x90\xae", [0x0f6f] = "\x90\xaf",
  [0x0f70] = "\x90\xb0", [0x0f71] = "\x90\xb1", [0x0f72] = "\x90\xb2",
  [0x0f73] = "\x90\xb3", [0x0f74] = "\x90\xb4", [0x0f75] = "\x90\xb5",
  [0x0f76] = "\x90\xb6", [0x0f77] = "\x90\xb7", [0x0f78] = "\x90\xb8",
  [0x0f79] = "\x90\xb9", [0x0f7a] = "\x90\xba", [0x0f7b] = "\x90\xbb",
  [0x0f7c] = "\x90\xbc", [0x0f7d] = "\x90\xbd", [0x0f7e] = "\x90\xbe",
  [0x0f7f] = "\x90\xbf", [0x0f80] = "\x90\xc0", [0x0f81] = "\x90\xc1",
  [0x0f82] = "\x90\xc2", [0x0f83] = "\x90\xc3", [0x0f84] = "\x90\xc4",
  [0x0f85] = "\x90\xc5", [0x0f86] = "\x90\xc6", [0x0f87] = "\x90\xc7",
  [0x0f88] = "\x90\xc8", [0x0f89] = "\x90\xc9", [0x0f8a] = "\x90\xca",
  [0x0f8b] = "\x90\xcb", [0x0f8c] = "\x90\xcc", [0x0f8d] = "\x90\xcd",
  [0x0f8e] = "\x90\xce", [0x0f8f] = "\x90\xcf", [0x0f90] = "\x90\xd0",
  [0x0f91] = "\x90\xd1", [0x0f92] = "\x90\xd2", [0x0f93] = "\x90\xd3",
  [0x0f94] = "\x90\xd4", [0x0f95] = "\x90\xd5", [0x0f96] = "\x90\xd6",
  [0x0f97] = "\x90\xd7", [0x0f98] = "\x90\xd8", [0x0f99] = "\x90\xd9",
  [0x0f9a] = "\x90\xda", [0x0f9b] = "\x90\xdb", [0x0f9c] = "\x90\xdc",
  [0x0f9d] = "\x90\xdd", [0x0f9e] = "\x90\xde", [0x0f9f] = "\x90\xdf",
  [0x0fa0] = "\x90\xe0", [0x0fa1] = "\x90\xe1", [0x0fa2] = "\x90\xe2",
  [0x0fa3] = "\x90\xe3", [0x0fa4] = "\x90\xe4", [0x0fa5] = "\x90\xe5",
  [0x0fa6] = "\x90\xe6", [0x0fa7] = "\x90\xe7", [0x0fa8] = "\x90\xe8",
  [0x0fa9] = "\x90\xe9", [0x0faa] = "\x90\xea", [0x0fab] = "\x90\xeb",
  [0x0fac] = "\x90\xec", [0x0fad] = "\x90\xed", [0x0fae] = "\x90\xee",
  [0x0faf] = "\x90\xef", [0x0fb0] = "\x90\xf0", [0x0fb1] = "\x90\xf1",
  [0x0fb2] = "\x90\xf2", [0x0fb3] = "\x90\xf3", [0x0fb4] = "\x90\xf4",
  [0x0fb5] = "\x90\xf5", [0x0fb6] = "\x90\xf6", [0x0fb7] = "\x90\xf7",
  [0x0fb8] = "\x90\xf8", [0x0fb9] = "\x90\xf9", [0x0fba] = "\x90\xfa",
  [0x0fbb] = "\x90\xfb", [0x0fbc] = "\x90\xfc", [0x0fbd] = "\x90\xfd",
  [0x0fbe] = "\x90\xfe", [0x1000] = "\x91\x40", [0x1001] = "\x91\x41",
  [0x1002] = "\x91\x42", [0x1003] = "\x91\x43", [0x1004] = "\x91\x44",
  [0x1005] = "\x91\x45", [0x1006] = "\x91\x46", [0x1007] = "\x91\x47",
  [0x1008] = "\x91\x48", [0x1009] = "\x91\x49", [0x100a] = "\x91\x4a",
  [0x100b] = "\x91\x4b", [0x100c] = "\x91\x4c", [0x100d] = "\x91\x4d",
  [0x100e] = "\x91\x4e", [0x100f] = "\x91\x4f", [0x1010] = "\x91\x50",
  [0x1011] = "\x91\x51", [0x1012] = "\x91\x52", [0x1013] = "\x91\x53",
  [0x1014] = "\x91\x54", [0x1015] = "\x91\x55", [0x1016] = "\x91\x56",
  [0x1017] = "\x91\x57", [0x1018] = "\x91\x58", [0x1019] = "\x91\x59",
  [0x101a] = "\x91\x5a", [0x101b] = "\x91\x5b", [0x101c] = "\x91\x5c",
  [0x101d] = "\x91\x5d", [0x101e] = "\x91\x5e", [0x101f] = "\x91\x5f",
  [0x1020] = "\x91\x60", [0x1021] = "\x91\x61", [0x1022] = "\x91\x62",
  [0x1023] = "\x91\x63", [0x1024] = "\x91\x64", [0x1025] = "\x91\x65",
  [0x1026] = "\x91\x66", [0x1027] = "\x91\x67", [0x1028] = "\x91\x68",
  [0x1029] = "\x91\x69", [0x102a] = "\x91\x6a", [0x102b] = "\x91\x6b",
  [0x102c] = "\x91\x6c", [0x102d] = "\x91\x6d", [0x102e] = "\x91\x6e",
  [0x102f] = "\x91\x6f", [0x1030] = "\x91\x70", [0x1031] = "\x91\x71",
  [0x1032] = "\x91\x72", [0x1033] = "\x91\x73", [0x1034] = "\x91\x74",
  [0x1035] = "\x91\x75", [0x1036] = "\x91\x76", [0x1037] = "\x91\x77",
  [0x1038] = "\x91\x78", [0x1039] = "\x91\x79", [0x103a] = "\x91\x7a",
  [0x103b] = "\x91\x7b", [0x103c] = "\x91\x7c", [0x103d] = "\x91\x7d",
  [0x103e] = "\x91\x7e", [0x1040] = "\x91\x80", [0x1041] = "\x91\x81",
  [0x1042] = "\x91\x82", [0x1043] = "\x91\x83", [0x1044] = "\x91\x84",
  [0x1045] = "\x91\x85", [0x1046] = "\x91\x86", [0x1047] = "\x91\x87",
  [0x1048] = "\x91\x88", [0x1049] = "\x91\x89", [0x104a] = "\x91\x8a",
  [0x104b] = "\x91\x8b", [0x104c] = "\x91\x8c", [0x104d] = "\x91\x8d",
  [0x104e] = "\x91\x8e", [0x104f] = "\x91\x8f", [0x1050] = "\x91\x90",
  [0x1051] = "\x91\x91", [0x1052] = "\x91\x92", [0x1053] = "\x91\x93",
  [0x1054] = "\x91\x94", [0x1055] = "\x91\x95", [0x1056] = "\x91\x96",
  [0x1057] = "\x91\x97", [0x1058] = "\x91\x98", [0x1059] = "\x91\x99",
  [0x105a] = "\x91\x9a", [0x105b] = "\x91\x9b", [0x105c] = "\x91\x9c",
  [0x105d] = "\x91\x9d", [0x105e] = "\x91\x9e", [0x105f] = "\x91\x9f",
  [0x1060] = "\x91\xa0", [0x1061] = "\x91\xa1", [0x1062] = "\x91\xa2",
  [0x1063] = "\x91\xa3", [0x1064] = "\x91\xa4", [0x1065] = "\x91\xa5",
  [0x1066] = "\x91\xa6", [0x1067] = "\x91\xa7", [0x1068] = "\x91\xa8",
  [0x1069] = "\x91\xa9", [0x106a] = "\x91\xaa", [0x106b] = "\x91\xab",
  [0x106c] = "\x91\xac", [0x106d] = "\x91\xad", [0x106e] = "\x91\xae",
  [0x106f] = "\x91\xaf", [0x1070] = "\x91\xb0", [0x1071] = "\x91\xb1",
  [0x1072] = "\x91\xb2", [0x1073] = "\x91\xb3", [0x1074] = "\x91\xb4",
  [0x1075] = "\x91\xb5", [0x1076] = "\x91\xb6", [0x1077] = "\x91\xb7",
  [0x1078] = "\x91\xb8", [0x1079] = "\x91\xb9", [0x107a] = "\x91\xba",
  [0x107b] = "\x91\xbb", [0x107c] = "\x91\xbc", [0x107d] = "\x91\xbd",
  [0x107e] = "\x91\xbe", [0x107f] = "\x91\xbf", [0x1080] = "\x91\xc0",
  [0x1081] = "\x91\xc1", [0x1082] = "\x91\xc2", [0x1083] = "\x91\xc3",
  [0x1084] = "\x91\xc4", [0x1085] = "\x91\xc5", [0x1086] = "\x91\xc6",
  [0x1087] = "\x91\xc7", [0x1088] = "\x91\xc8", [0x1089] = "\x91\xc9",
  [0x108a] = "\x91\xca", [0x108b] = "\x91\xcb", [0x108c] = "\x91\xcc",
  [0x108d] = "\x91\xcd", [0x108e] = "\x91\xce", [0x108f] = "\x91\xcf",
  [0x1090] = "\x91\xd0", [0x1091] = "\x91\xd1", [0x1092] = "\x91\xd2",
  [0x1093] = "\x91\xd3", [0x1094] = "\x91\xd4", [0x1095] = "\x91\xd5",
  [0x1096] = "\x91\xd6", [0x1097] = "\x91\xd7", [0x1098] = "\x91\xd8",
  [0x1099] = "\x91\xd9", [0x109a] = "\x91\xda", [0x109b] = "\x91\xdb",
  [0x109c] = "\x91\xdc", [0x109d] = "\x91\xdd", [0x109e] = "\x91\xde",
  [0x109f] = "\x91\xdf", [0x10a0] = "\x91\xe0", [0x10a1] = "\x91\xe1",
  [0x10a2] = "\x91\xe2", [0x10a3] = "\x91\xe3", [0x10a4] = "\x91\xe4",
  [0x10a5] = "\x91\xe5", [0x10a6] = "\x91\xe6", [0x10a7] = "\x91\xe7",
  [0x10a8] = "\x91\xe8", [0x10a9] = "\x91\xe9", [0x10aa] = "\x91\xea",
  [0x10ab] = "\x91\xeb", [0x10ac] = "\x91\xec", [0x10ad] = "\x91\xed",
  [0x10ae] = "\x91\xee", [0x10af] = "\x91\xef", [0x10b0] = "\x91\xf0",
  [0x10b1] = "\x91\xf1", [0x10b2] = "\x91\xf2", [0x10b3] = "\x91\xf3",
  [0x10b4] = "\x91\xf4", [0x10b5] = "\x91\xf5", [0x10b6] = "\x91\xf6",
  [0x10b7] = "\x91\xf7", [0x10b8] = "\x91\xf8", [0x10b9] = "\x91\xf9",
  [0x10ba] = "\x91\xfa", [0x10bb] = "\x91\xfb", [0x10bc] = "\x91\xfc",
  [0x10bd] = "\x91\xfd", [0x10be] = "\x91\xfe", [0x1100] = "\x92\x40",
  [0x1101] = "\x92\x41", [0x1102] = "\x92\x42", [0x1103] = "\x92\x43",
  [0x1104] = "\x92\x44", [0x1105] = "\x92\x45", [0x1106] = "\x92\x46",
  [0x1107] = "\x92\x47", [0x1108] = "\x92\x48", [0x1109] = "\x92\x49",
  [0x110a] = "\x92\x4a", [0x110b] = "\x92\x4b", [0x110c] = "\x92\x4c",
  [0x110d] = "\x92\x4d", [0x110e] = "\x92\x4e", [0x110f] = "\x92\x4f",
  [0x1110] = "\x92\x50", [0x1111] = "\x92\x51", [0x1112] = "\x92\x52",
  [0x1113] = "\x92\x53", [0x1114] = "\x92\x54", [0x1115] = "\x92\x55",
  [0x1116] = "\x92\x56", [0x1117] = "\x92\x57", [0x1118] = "\x92\x58",
  [0x1119] = "\x92\x59", [0x111a] = "\x92\x5a", [0x111b] = "\x92\x5b",
  [0x111c] = "\x92\x5c", [0x111d] = "\x92\x5d", [0x111e] = "\x92\x5e",
  [0x111f] = "\x92\x5f", [0x1120] = "\x92\x60", [0x1121] = "\x92\x61",
  [0x1122] = "\x92\x62", [0x1123] = "\x92\x63", [0x1124] = "\x92\x64",
  [0x1125] = "\x92\x65", [0x1126] = "\x92\x66", [0x1127] = "\x92\x67",
  [0x1128] = "\x92\x68", [0x1129] = "\x92\x69", [0x112a] = "\x92\x6a",
  [0x112b] = "\x92\x6b", [0x112c] = "\x92\x6c", [0x112d] = "\x92\x6d",
  [0x112e] = "\x92\x6e", [0x112f] = "\x92\x6f", [0x1130] = "\x92\x70",
  [0x1131] = "\x92\x71", [0x1132] = "\x92\x72", [0x1133] = "\x92\x73",
  [0x1134] = "\x92\x74", [0x1135] = "\x92\x75", [0x1136] = "\x92\x76",
  [0x1137] = "\x92\x77", [0x1138] = "\x92\x78", [0x1139] = "\x92\x79",
  [0x113a] = "\x92\x7a", [0x113b] = "\x92\x7b", [0x113c] = "\x92\x7c",
  [0x113d] = "\x92\x7d", [0x113e] = "\x92\x7e", [0x1140] = "\x92\x80",
  [0x1141] = "\x92\x81", [0x1142] = "\x92\x82", [0x1143] = "\x92\x83",
  [0x1144] = "\x92\x84", [0x1145] = "\x92\x85", [0x1146] = "\x92\x86",
  [0x1147] = "\x92\x87", [0x1148] = "\x92\x88", [0x1149] = "\x92\x89",
  [0x114a] = "\x92\x8a", [0x114b] = "\x92\x8b", [0x114c] = "\x92\x8c",
  [0x114d] = "\x92\x8d", [0x114e] = "\x92\x8e", [0x114f] = "\x92\x8f",
  [0x1150] = "\x92\x90", [0x1151] = "\x92\x91", [0x1152] = "\x92\x92",
  [0x1153] = "\x92\x93", [0x1154] = "\x92\x94", [0x1155] = "\x92\x95",
  [0x1156] = "\x92\x96", [0x1157] = "\x92\x97", [0x1158] = "\x92\x98",
  [0x1159] = "\x92\x99", [0x115a] = "\x92\x9a", [0x115b] = "\x92\x9b",
  [0x115c] = "\x92\x9c", [0x115d] = "\x92\x9d", [0x115e] = "\x92\x9e",
  [0x115f] = "\x92\x9f", [0x1160] = "\x92\xa0", [0x1161] = "\x92\xa1",
  [0x1162] = "\x92\xa2", [0x1163] = "\x92\xa3", [0x1164] = "\x92\xa4",
  [0x1165] = "\x92\xa5", [0x1166] = "\x92\xa6", [0x1167] = "\x92\xa7",
  [0x1168] = "\x92\xa8", [0x1169] = "\x92\xa9", [0x116a] = "\x92\xaa",
  [0x116b] = "\x92\xab", [0x116c] = "\x92\xac", [0x116d] = "\x92\xad",
  [0x116e] = "\x92\xae", [0x116f] = "\x92\xaf", [0x1170] = "\x92\xb0",
  [0x1171] = "\x92\xb1", [0x1172] = "\x92\xb2", [0x1173] = "\x92\xb3",
  [0x1174] = "\x92\xb4", [0x1175] = "\x92\xb5", [0x1176] = "\x92\xb6",
  [0x1177] = "\x92\xb7", [0x1178] = "\x92\xb8", [0x1179] = "\x92\xb9",
  [0x117a] = "\x92\xba", [0x117b] = "\x92\xbb", [0x117c] = "\x92\xbc",
  [0x117d] = "\x92\xbd", [0x117e] = "\x92\xbe", [0x117f] = "\x92\xbf",
  [0x1180] = "\x92\xc0", [0x1181] = "\x92\xc1", [0x1182] = "\x92\xc2",
  [0x1183] = "\x92\xc3", [0x1184] = "\x92\xc4", [0x1185] = "\x92\xc5",
  [0x1186] = "\x92\xc6", [0x1187] = "\x92\xc7", [0x1188] = "\x92\xc8",
  [0x1189] = "\x92\xc9", [0x118a] = "\x92\xca", [0x118b] = "\x92\xcb",
  [0x118c] = "\x92\xcc", [0x118d] = "\x92\xcd", [0x118e] = "\x92\xce",
  [0x118f] = "\x92\xcf", [0x1190] = "\x92\xd0", [0x1191] = "\x92\xd1",
  [0x1192] = "\x92\xd2", [0x1193] = "\x92\xd3", [0x1194] = "\x92\xd4",
  [0x1195] = "\x92\xd5", [0x1196] = "\x92\xd6", [0x1197] = "\x92\xd7",
  [0x1198] = "\x92\xd8", [0x1199] = "\x92\xd9", [0x119a] = "\x92\xda",
  [0x119b] = "\x92\xdb", [0x119c] = "\x92\xdc", [0x119d] = "\x92\xdd",
  [0x119e] = "\x92\xde", [0x119f] = "\x92\xdf", [0x11a0] = "\x92\xe0",
  [0x11a1] = "\x92\xe1", [0x11a2] = "\x92\xe2", [0x11a3] = "\x92\xe3",
  [0x11a4] = "\x92\xe4", [0x11a5] = "\x92\xe5", [0x11a6] = "\x92\xe6",
  [0x11a7] = "\x92\xe7", [0x11a8] = "\x92\xe8", [0x11a9] = "\x92\xe9",
  [0x11aa] = "\x92\xea", [0x11ab] = "\x92\xeb", [0x11ac] = "\x92\xec",
  [0x11ad] = "\x92\xed", [0x11ae] = "\x92\xee", [0x11af] = "\x92\xef",
  [0x11b0] = "\x92\xf0", [0x11b1] = "\x92\xf1", [0x11b2] = "\x92\xf2",
  [0x11b3] = "\x92\xf3", [0x11b4] = "\x92\xf4", [0x11b5] = "\x92\xf5",
  [0x11b6] = "\x92\xf6", [0x11b7] = "\x92\xf7", [0x11b8] = "\x92\xf8",
  [0x11b9] = "\x92\xf9", [0x11ba] = "\x92\xfa", [0x11bb] = "\x92\xfb",
  [0x11bc] = "\x92\xfc", [0x11bd] = "\x92\xfd", [0x11be] = "\x92\xfe",
  [0x1200] = "\x93\x40", [0x1201] = "\x93\x41", [0x1202] = "\x93\x42",
  [0x1203] = "\x93\x43", [0x1204] = "\x93\x44", [0x1205] = "\x93\x45",
  [0x1206] = "\x93\x46", [0x1207] = "\x93\x47", [0x1208] = "\x93\x48",
  [0x1209] = "\x93\x49", [0x120a] = "\x93\x4a", [0x120b] = "\x93\x4b",
  [0x120c] = "\x93\x4c", [0x120d] = "\x93\x4d", [0x120e] = "\x93\x4e",
  [0x120f] = "\x93\x4f", [0x1210] = "\x93\x50", [0x1211] = "\x93\x51",
  [0x1212] = "\x93\x52", [0x1213] = "\x93\x53", [0x1214] = "\x93\x54",
  [0x1215] = "\x93\x55", [0x1216] = "\x93\x56", [0x1217] = "\x93\x57",
  [0x1218] = "\x93\x58", [0x1219] = "\x93\x59", [0x121a] = "\x93\x5a",
  [0x121b] = "\x93\x5b", [0x121c] = "\x93\x5c", [0x121d] = "\x93\x5d",
  [0x121e] = "\x93\x5e", [0x121f] = "\x93\x5f", [0x1220] = "\x93\x60",
  [0x1221] = "\x93\x61", [0x1222] = "\x93\x62", [0x1223] = "\x93\x63",
  [0x1224] = "\x93\x64", [0x1225] = "\x93\x65", [0x1226] = "\x93\x66",
  [0x1227] = "\x93\x67", [0x1228] = "\x93\x68", [0x1229] = "\x93\x69",
  [0x122a] = "\x93\x6a", [0x122b] = "\x93\x6b", [0x122c] = "\x93\x6c",
  [0x122d] = "\x93\x6d", [0x122e] = "\x93\x6e", [0x122f] = "\x93\x6f",
  [0x1230] = "\x93\x70", [0x1231] = "\x93\x71", [0x1232] = "\x93\x72",
  [0x1233] = "\x93\x73", [0x1234] = "\x93\x74", [0x1235] = "\x93\x75",
  [0x1236] = "\x93\x76", [0x1237] = "\x93\x77", [0x1238] = "\x93\x78",
  [0x1239] = "\x93\x79", [0x123a] = "\x93\x7a", [0x123b] = "\x93\x7b",
  [0x123c] = "\x93\x7c", [0x123d] = "\x93\x7d", [0x123e] = "\x93\x7e",
  [0x1240] = "\x93\x80", [0x1241] = "\x93\x81", [0x1242] = "\x93\x82",
  [0x1243] = "\x93\x83", [0x1244] = "\x93\x84", [0x1245] = "\x93\x85",
  [0x1246] = "\x93\x86", [0x1247] = "\x93\x87", [0x1248] = "\x93\x88",
  [0x1249] = "\x93\x89", [0x124a] = "\x93\x8a", [0x124b] = "\x93\x8b",
  [0x124c] = "\x93\x8c", [0x124d] = "\x93\x8d", [0x124e] = "\x93\x8e",
  [0x124f] = "\x93\x8f", [0x1250] = "\x93\x90", [0x1251] = "\x93\x91",
  [0x1252] = "\x93\x92", [0x1253] = "\x93\x93", [0x1254] = "\x93\x94",
  [0x1255] = "\x93\x95", [0x1256] = "\x93\x96", [0x1257] = "\x93\x97",
  [0x1258] = "\x93\x98", [0x1259] = "\x93\x99", [0x125a] = "\x93\x9a",
  [0x125b] = "\x93\x9b", [0x125c] = "\x93\x9c", [0x125d] = "\x93\x9d",
  [0x125e] = "\x93\x9e", [0x125f] = "\x93\x9f", [0x1260] = "\x93\xa0",
  [0x1261] = "\x93\xa1", [0x1262] = "\x93\xa2", [0x1263] = "\x93\xa3",
  [0x1264] = "\x93\xa4", [0x1265] = "\x93\xa5", [0x1266] = "\x93\xa6",
  [0x1267] = "\x93\xa7", [0x1268] = "\x93\xa8", [0x1269] = "\x93\xa9",
  [0x126a] = "\x93\xaa", [0x126b] = "\x93\xab", [0x126c] = "\x93\xac",
  [0x126d] = "\x93\xad", [0x126e] = "\x93\xae", [0x126f] = "\x93\xaf",
  [0x1270] = "\x93\xb0", [0x1271] = "\x93\xb1", [0x1272] = "\x93\xb2",
  [0x1273] = "\x93\xb3", [0x1274] = "\x93\xb4", [0x1275] = "\x93\xb5",
  [0x1276] = "\x93\xb6", [0x1277] = "\x93\xb7", [0x1278] = "\x93\xb8",
  [0x1279] = "\x93\xb9", [0x127a] = "\x93\xba", [0x127b] = "\x93\xbb",
  [0x127c] = "\x93\xbc", [0x127d] = "\x93\xbd", [0x127e] = "\x93\xbe",
  [0x127f] = "\x93\xbf", [0x1280] = "\x93\xc0", [0x1281] = "\x93\xc1",
  [0x1282] = "\x93\xc2", [0x1283] = "\x93\xc3", [0x1284] = "\x93\xc4",
  [0x1285] = "\x93\xc5", [0x1286] = "\x93\xc6", [0x1287] = "\x93\xc7",
  [0x1288] = "\x93\xc8", [0x1289] = "\x93\xc9", [0x128a] = "\x93\xca",
  [0x128b] = "\x93\xcb", [0x128c] = "\x93\xcc", [0x128d] = "\x93\xcd",
  [0x128e] = "\x93\xce", [0x128f] = "\x93\xcf", [0x1290] = "\x93\xd0",
  [0x1291] = "\x93\xd1", [0x1292] = "\x93\xd2", [0x1293] = "\x93\xd3",
  [0x1294] = "\x93\xd4", [0x1295] = "\x93\xd5", [0x1296] = "\x93\xd6",
  [0x1297] = "\x93\xd7", [0x1298] = "\x93\xd8", [0x1299] = "\x93\xd9",
  [0x129a] = "\x93\xda", [0x129b] = "\x93\xdb", [0x129c] = "\x93\xdc",
  [0x129d] = "\x93\xdd", [0x129e] = "\x93\xde", [0x129f] = "\x93\xdf",
  [0x12a0] = "\x93\xe0", [0x12a1] = "\x93\xe1", [0x12a2] = "\x93\xe2",
  [0x12a3] = "\x93\xe3", [0x12a4] = "\x93\xe4", [0x12a5] = "\x93\xe5",
  [0x12a6] = "\x93\xe6", [0x12a7] = "\x93\xe7", [0x12a8] = "\x93\xe8",
  [0x12a9] = "\x93\xe9", [0x12aa] = "\x93\xea", [0x12ab] = "\x93\xeb",
  [0x12ac] = "\x93\xec", [0x12ad] = "\x93\xed", [0x12ae] = "\x93\xee",
  [0x12af] = "\x93\xef", [0x12b0] = "\x93\xf0", [0x12b1] = "\x93\xf1",
  [0x12b2] = "\x93\xf2", [0x12b3] = "\x93\xf3", [0x12b4] = "\x93\xf4",
  [0x12b5] = "\x93\xf5", [0x12b6] = "\x93\xf6", [0x12b7] = "\x93\xf7",
  [0x12b8] = "\x93\xf8", [0x12b9] = "\x93\xf9", [0x12ba] = "\x93\xfa",
  [0x12bb] = "\x93\xfb", [0x12bc] = "\x93\xfc", [0x12bd] = "\x93\xfd",
  [0x12be] = "\x93\xfe", [0x1300] = "\x94\x40", [0x1301] = "\x94\x41",
  [0x1302] = "\x94\x42", [0x1303] = "\x94\x43", [0x1304] = "\x94\x44",
  [0x1305] = "\x94\x45", [0x1306] = "\x94\x46", [0x1307] = "\x94\x47",
  [0x1308] = "\x94\x48", [0x1309] = "\x94\x49", [0x130a] = "\x94\x4a",
  [0x130b] = "\x94\x4b", [0x130c] = "\x94\x4c", [0x130d] = "\x94\x4d",
  [0x130e] = "\x94\x4e", [0x130f] = "\x94\x4f", [0x1310] = "\x94\x50",
  [0x1311] = "\x94\x51", [0x1312] = "\x94\x52", [0x1313] = "\x94\x53",
  [0x1314] = "\x94\x54", [0x1315] = "\x94\x55", [0x1316] = "\x94\x56",
  [0x1317] = "\x94\x57", [0x1318] = "\x94\x58", [0x1319] = "\x94\x59",
  [0x131a] = "\x94\x5a", [0x131b] = "\x94\x5b", [0x131c] = "\x94\x5c",
  [0x131d] = "\x94\x5d", [0x131e] = "\x94\x5e", [0x131f] = "\x94\x5f",
  [0x1320] = "\x94\x60", [0x1321] = "\x94\x61", [0x1322] = "\x94\x62",
  [0x1323] = "\x94\x63", [0x1324] = "\x94\x64", [0x1325] = "\x94\x65",
  [0x1326] = "\x94\x66", [0x1327] = "\x94\x67", [0x1328] = "\x94\x68",
  [0x1329] = "\x94\x69", [0x132a] = "\x94\x6a", [0x132b] = "\x94\x6b",
  [0x132c] = "\x94\x6c", [0x132d] = "\x94\x6d", [0x132e] = "\x94\x6e",
  [0x132f] = "\x94\x6f", [0x1330] = "\x94\x70", [0x1331] = "\x94\x71",
  [0x1332] = "\x94\x72", [0x1333] = "\x94\x73", [0x1334] = "\x94\x74",
  [0x1335] = "\x94\x75", [0x1336] = "\x94\x76", [0x1337] = "\x94\x77",
  [0x1338] = "\x94\x78", [0x1339] = "\x94\x79", [0x133a] = "\x94\x7a",
  [0x133b] = "\x94\x7b", [0x133c] = "\x94\x7c", [0x133d] = "\x94\x7d",
  [0x133e] = "\x94\x7e", [0x1340] = "\x94\x80", [0x1341] = "\x94\x81",
  [0x1342] = "\x94\x82", [0x1343] = "\x94\x83", [0x1344] = "\x94\x84",
  [0x1345] = "\x94\x85", [0x1346] = "\x94\x86", [0x1347] = "\x94\x87",
  [0x1348] = "\x94\x88", [0x1349] = "\x94\x89", [0x134a] = "\x94\x8a",
  [0x134b] = "\x94\x8b", [0x134c] = "\x94\x8c", [0x134d] = "\x94\x8d",
  [0x134e] = "\x94\x8e", [0x134f] = "\x94\x8f", [0x1350] = "\x94\x90",
  [0x1351] = "\x94\x91", [0x1352] = "\x94\x92", [0x1353] = "\x94\x93",
  [0x1354] = "\x94\x94", [0x1355] = "\x94\x95", [0x1356] = "\x94\x96",
  [0x1357] = "\x94\x97", [0x1358] = "\x94\x98", [0x1359] = "\x94\x99",
  [0x135a] = "\x94\x9a", [0x135b] = "\x94\x9b", [0x135c] = "\x94\x9c",
  [0x135d] = "\x94\x9d", [0x135e] = "\x94\x9e", [0x135f] = "\x94\x9f",
  [0x1360] = "\x94\xa0", [0x1361] = "\x94\xa1", [0x1362] = "\x94\xa2",
  [0x1363] = "\x94\xa3", [0x1364] = "\x94\xa4", [0x1365] = "\x94\xa5",
  [0x1366] = "\x94\xa6", [0x1367] = "\x94\xa7", [0x1368] = "\x94\xa8",
  [0x1369] = "\x94\xa9", [0x136a] = "\x94\xaa", [0x136b] = "\x94\xab",
  [0x136c] = "\x94\xac", [0x136d] = "\x94\xad", [0x136e] = "\x94\xae",
  [0x136f] = "\x94\xaf", [0x1370] = "\x94\xb0", [0x1371] = "\x94\xb1",
  [0x1372] = "\x94\xb2", [0x1373] = "\x94\xb3", [0x1374] = "\x94\xb4",
  [0x1375] = "\x94\xb5", [0x1376] = "\x94\xb6", [0x1377] = "\x94\xb7",
  [0x1378] = "\x94\xb8", [0x1379] = "\x94\xb9", [0x137a] = "\x94\xba",
  [0x137b] = "\x94\xbb", [0x137c] = "\x94\xbc", [0x137d] = "\x94\xbd",
  [0x137e] = "\x94\xbe", [0x137f] = "\x94\xbf", [0x1380] = "\x94\xc0",
  [0x1381] = "\x94\xc1", [0x1382] = "\x94\xc2", [0x1383] = "\x94\xc3",
  [0x1384] = "\x94\xc4", [0x1385] = "\x94\xc5", [0x1386] = "\x94\xc6",
  [0x1387] = "\x94\xc7", [0x1388] = "\x94\xc8", [0x1389] = "\x94\xc9",
  [0x138a] = "\x94\xca", [0x138b] = "\x94\xcb", [0x138c] = "\x94\xcc",
  [0x138d] = "\x94\xcd", [0x138e] = "\x94\xce", [0x138f] = "\x94\xcf",
  [0x1390] = "\x94\xd0", [0x1391] = "\x94\xd1", [0x1392] = "\x94\xd2",
  [0x1393] = "\x94\xd3", [0x1394] = "\x94\xd4", [0x1395] = "\x94\xd5",
  [0x1396] = "\x94\xd6", [0x1397] = "\x94\xd7", [0x1398] = "\x94\xd8",
  [0x1399] = "\x94\xd9", [0x139a] = "\x94\xda", [0x139b] = "\x94\xdb",
  [0x139c] = "\x94\xdc", [0x139d] = "\x94\xdd", [0x139e] = "\x94\xde",
  [0x139f] = "\x94\xdf", [0x13a0] = "\x94\xe0", [0x13a1] = "\x94\xe1",
  [0x13a2] = "\x94\xe2", [0x13a3] = "\x94\xe3", [0x13a4] = "\x94\xe4",
  [0x13a5] = "\x94\xe5", [0x13a6] = "\x94\xe6", [0x13a7] = "\x94\xe7",
  [0x13a8] = "\x94\xe8", [0x13a9] = "\x94\xe9", [0x13aa] = "\x94\xea",
  [0x13ab] = "\x94\xeb", [0x13ac] = "\x94\xec", [0x13ad] = "\x94\xed",
  [0x13ae] = "\x94\xee", [0x13af] = "\x94\xef", [0x13b0] = "\x94\xf0",
  [0x13b1] = "\x94\xf1", [0x13b2] = "\x94\xf2", [0x13b3] = "\x94\xf3",
  [0x13b4] = "\x94\xf4", [0x13b5] = "\x94\xf5", [0x13b6] = "\x94\xf6",
  [0x13b7] = "\x94\xf7", [0x13b8] = "\x94\xf8", [0x13b9] = "\x94\xf9",
  [0x13ba] = "\x94\xfa", [0x13bb] = "\x94\xfb", [0x13bc] = "\x94\xfc",
  [0x13bd] = "\x94\xfd", [0x13be] = "\x94\xfe", [0x1400] = "\x95\x40",
  [0x1401] = "\x95\x41", [0x1402] = "\x95\x42", [0x1403] = "\x95\x43",
  [0x1404] = "\x95\x44", [0x1405] = "\x95\x45", [0x1406] = "\x95\x46",
  [0x1407] = "\x95\x47", [0x1408] = "\x95\x48", [0x1409] = "\x95\x49",
  [0x140a] = "\x95\x4a", [0x140b] = "\x95\x4b", [0x140c] = "\x95\x4c",
  [0x140d] = "\x95\x4d", [0x140e] = "\x95\x4e", [0x140f] = "\x95\x4f",
  [0x1410] = "\x95\x50", [0x1411] = "\x95\x51", [0x1412] = "\x95\x52",
  [0x1413] = "\x95\x53", [0x1414] = "\x95\x54", [0x1415] = "\x95\x55",
  [0x1416] = "\x95\x56", [0x1417] = "\x95\x57", [0x1418] = "\x95\x58",
  [0x1419] = "\x95\x59", [0x141a] = "\x95\x5a", [0x141b] = "\x95\x5b",
  [0x141c] = "\x95\x5c", [0x141d] = "\x95\x5d", [0x141e] = "\x95\x5e",
  [0x141f] = "\x95\x5f", [0x1420] = "\x95\x60", [0x1421] = "\x95\x61",
  [0x1422] = "\x95\x62", [0x1423] = "\x95\x63", [0x1424] = "\x95\x64",
  [0x1425] = "\x95\x65", [0x1426] = "\x95\x66", [0x1427] = "\x95\x67",
  [0x1428] = "\x95\x68", [0x1429] = "\x95\x69", [0x142a] = "\x95\x6a",
  [0x142b] = "\x95\x6b", [0x142c] = "\x95\x6c", [0x142d] = "\x95\x6d",
  [0x142e] = "\x95\x6e", [0x142f] = "\x95\x6f", [0x1430] = "\x95\x70",
  [0x1431] = "\x95\x71", [0x1432] = "\x95\x72", [0x1433] = "\x95\x73",
  [0x1434] = "\x95\x74", [0x1435] = "\x95\x75", [0x1436] = "\x95\x76",
  [0x1437] = "\x95\x77", [0x1438] = "\x95\x78", [0x1439] = "\x95\x79",
  [0x143a] = "\x95\x7a", [0x143b] = "\x95\x7b", [0x143c] = "\x95\x7c",
  [0x143d] = "\x95\x7d", [0x143e] = "\x95\x7e", [0x1440] = "\x95\x80",
  [0x1441] = "\x95\x81", [0x1442] = "\x95\x82", [0x1443] = "\x95\x83",
  [0x1444] = "\x95\x84", [0x1445] = "\x95\x85", [0x1446] = "\x95\x86",
  [0x1447] = "\x95\x87", [0x1448] = "\x95\x88", [0x1449] = "\x95\x89",
  [0x144a] = "\x95\x8a", [0x144b] = "\x95\x8b", [0x144c] = "\x95\x8c",
  [0x144d] = "\x95\x8d", [0x144e] = "\x95\x8e", [0x144f] = "\x95\x8f",
  [0x1450] = "\x95\x90", [0x1451] = "\x95\x91", [0x1452] = "\x95\x92",
  [0x1453] = "\x95\x93", [0x1454] = "\x95\x94", [0x1455] = "\x95\x95",
  [0x1456] = "\x95\x96", [0x1457] = "\x95\x97", [0x1458] = "\x95\x98",
  [0x1459] = "\x95\x99", [0x145a] = "\x95\x9a", [0x145b] = "\x95\x9b",
  [0x145c] = "\x95\x9c", [0x145d] = "\x95\x9d", [0x145e] = "\x95\x9e",
  [0x145f] = "\x95\x9f", [0x1460] = "\x95\xa0", [0x1461] = "\x95\xa1",
  [0x1462] = "\x95\xa2", [0x1463] = "\x95\xa3", [0x1464] = "\x95\xa4",
  [0x1465] = "\x95\xa5", [0x1466] = "\x95\xa6", [0x1467] = "\x95\xa7",
  [0x1468] = "\x95\xa8", [0x1469] = "\x95\xa9", [0x146a] = "\x95\xaa",
  [0x146b] = "\x95\xab", [0x146c] = "\x95\xac", [0x146d] = "\x95\xad",
  [0x146e] = "\x95\xae", [0x146f] = "\x95\xaf", [0x1470] = "\x95\xb0",
  [0x1471] = "\x95\xb1", [0x1472] = "\x95\xb2", [0x1473] = "\x95\xb3",
  [0x1474] = "\x95\xb4", [0x1475] = "\x95\xb5", [0x1476] = "\x95\xb6",
  [0x1477] = "\x95\xb7", [0x1478] = "\x95\xb8", [0x1479] = "\x95\xb9",
  [0x147a] = "\x95\xba", [0x147b] = "\x95\xbb", [0x147c] = "\x95\xbc",
  [0x147d] = "\x95\xbd", [0x147e] = "\x95\xbe", [0x147f] = "\x95\xbf",
  [0x1480] = "\x95\xc0", [0x1481] = "\x95\xc1", [0x1482] = "\x95\xc2",
  [0x1483] = "\x95\xc3", [0x1484] = "\x95\xc4", [0x1485] = "\x95\xc5",
  [0x1486] = "\x95\xc6", [0x1487] = "\x95\xc7", [0x1488] = "\x95\xc8",
  [0x1489] = "\x95\xc9", [0x148a] = "\x95\xca", [0x148b] = "\x95\xcb",
  [0x148c] = "\x95\xcc", [0x148d] = "\x95\xcd", [0x148e] = "\x95\xce",
  [0x148f] = "\x95\xcf", [0x1490] = "\x95\xd0", [0x1491] = "\x95\xd1",
  [0x1492] = "\x95\xd2", [0x1493] = "\x95\xd3", [0x1494] = "\x95\xd4",
  [0x1495] = "\x95\xd5", [0x1496] = "\x95\xd6", [0x1497] = "\x95\xd7",
  [0x1498] = "\x95\xd8", [0x1499] = "\x95\xd9", [0x149a] = "\x95\xda",
  [0x149b] = "\x95\xdb", [0x149c] = "\x95\xdc", [0x149d] = "\x95\xdd",
  [0x149e] = "\x95\xde", [0x149f] = "\x95\xdf", [0x14a0] = "\x95\xe0",
  [0x14a1] = "\x95\xe1", [0x14a2] = "\x95\xe2", [0x14a3] = "\x95\xe3",
  [0x14a4] = "\x95\xe4", [0x14a5] = "\x95\xe5", [0x14a6] = "\x95\xe6",
  [0x14a7] = "\x95\xe7", [0x14a8] = "\x95\xe8", [0x14a9] = "\x95\xe9",
  [0x14aa] = "\x95\xea", [0x14ab] = "\x95\xeb", [0x14ac] = "\x95\xec",
  [0x14ad] = "\x95\xed", [0x14ae] = "\x95\xee", [0x14af] = "\x95\xef",
  [0x14b0] = "\x95\xf0", [0x14b1] = "\x95\xf1", [0x14b2] = "\x95\xf2",
  [0x14b3] = "\x95\xf3", [0x14b4] = "\x95\xf4", [0x14b5] = "\x95\xf5",
  [0x14b6] = "\x95\xf6", [0x14b7] = "\x95\xf7", [0x14b8] = "\x95\xf8",
  [0x14b9] = "\x95\xf9", [0x14ba] = "\x95\xfa", [0x14bb] = "\x95\xfb",
  [0x14bc] = "\x95\xfc", [0x14bd] = "\x95\xfd", [0x14be] = "\x95\xfe",
  [0x1500] = "\x96\x40", [0x1501] = "\x96\x41", [0x1502] = "\x96\x42",
  [0x1503] = "\x96\x43", [0x1504] = "\x96\x44", [0x1505] = "\x96\x45",
  [0x1506] = "\x96\x46", [0x1507] = "\x96\x47", [0x1508] = "\x96\x48",
  [0x1509] = "\x96\x49", [0x150a] = "\x96\x4a", [0x150b] = "\x96\x4b",
  [0x150c] = "\x96\x4c", [0x150d] = "\x96\x4d", [0x150e] = "\x96\x4e",
  [0x150f] = "\x96\x4f", [0x1510] = "\x96\x50", [0x1511] = "\x96\x51",
  [0x1512] = "\x96\x52", [0x1513] = "\x96\x53", [0x1514] = "\x96\x54",
  [0x1515] = "\x96\x55", [0x1516] = "\x96\x56", [0x1517] = "\x96\x57",
  [0x1518] = "\x96\x58", [0x1519] = "\x96\x59", [0x151a] = "\x96\x5a",
  [0x151b] = "\x96\x5b", [0x151c] = "\x96\x5c", [0x151d] = "\x96\x5d",
  [0x151e] = "\x96\x5e", [0x151f] = "\x96\x5f", [0x1520] = "\x96\x60",
  [0x1521] = "\x96\x61", [0x1522] = "\x96\x62", [0x1523] = "\x96\x63",
  [0x1524] = "\x96\x64", [0x1525] = "\x96\x65", [0x1526] = "\x96\x66",
  [0x1527] = "\x96\x67", [0x1528] = "\x96\x68", [0x1529] = "\x96\x69",
  [0x152a] = "\x96\x6a", [0x152b] = "\x96\x6b", [0x152c] = "\x96\x6c",
  [0x152d] = "\x96\x6d", [0x152e] = "\x96\x6e", [0x152f] = "\x96\x6f",
  [0x1530] = "\x96\x70", [0x1531] = "\x96\x71", [0x1532] = "\x96\x72",
  [0x1533] = "\x96\x73", [0x1534] = "\x96\x74", [0x1535] = "\x96\x75",
  [0x1536] = "\x96\x76", [0x1537] = "\x96\x77", [0x1538] = "\x96\x78",
  [0x1539] = "\x96\x79", [0x153a] = "\x96\x7a", [0x153b] = "\x96\x7b",
  [0x153c] = "\x96\x7c", [0x153d] = "\x96\x7d", [0x153e] = "\x96\x7e",
  [0x1540] = "\x96\x80", [0x1541] = "\x96\x81", [0x1542] = "\x96\x82",
  [0x1543] = "\x96\x83", [0x1544] = "\x96\x84", [0x1545] = "\x96\x85",
  [0x1546] = "\x96\x86", [0x1547] = "\x96\x87", [0x1548] = "\x96\x88",
  [0x1549] = "\x96\x89", [0x154a] = "\x96\x8a", [0x154b] = "\x96\x8b",
  [0x154c] = "\x96\x8c", [0x154d] = "\x96\x8d", [0x154e] = "\x96\x8e",
  [0x154f] = "\x96\x8f", [0x1550] = "\x96\x90", [0x1551] = "\x96\x91",
  [0x1552] = "\x96\x92", [0x1553] = "\x96\x93", [0x1554] = "\x96\x94",
  [0x1555] = "\x96\x95", [0x1556] = "\x96\x96", [0x1557] = "\x96\x97",
  [0x1558] = "\x96\x98", [0x1559] = "\x96\x99", [0x155a] = "\x96\x9a",
  [0x155b] = "\x96\x9b", [0x155c] = "\x96\x9c", [0x155d] = "\x96\x9d",
  [0x155e] = "\x96\x9e", [0x155f] = "\x96\x9f", [0x1560] = "\x96\xa0",
  [0x1561] = "\x96\xa1", [0x1562] = "\x96\xa2", [0x1563] = "\x96\xa3",
  [0x1564] = "\x96\xa4", [0x1565] = "\x96\xa5", [0x1566] = "\x96\xa6",
  [0x1567] = "\x96\xa7", [0x1568] = "\x96\xa8", [0x1569] = "\x96\xa9",
  [0x156a] = "\x96\xaa", [0x156b] = "\x96\xab", [0x156c] = "\x96\xac",
  [0x156d] = "\x96\xad", [0x156e] = "\x96\xae", [0x156f] = "\x96\xaf",
  [0x1570] = "\x96\xb0", [0x1571] = "\x96\xb1", [0x1572] = "\x96\xb2",
  [0x1573] = "\x96\xb3", [0x1574] = "\x96\xb4", [0x1575] = "\x96\xb5",
  [0x1576] = "\x96\xb6", [0x1577] = "\x96\xb7", [0x1578] = "\x96\xb8",
  [0x1579] = "\x96\xb9", [0x157a] = "\x96\xba", [0x157b] = "\x96\xbb",
  [0x157c] = "\x96\xbc", [0x157d] = "\x96\xbd", [0x157e] = "\x96\xbe",
  [0x157f] = "\x96\xbf", [0x1580] = "\x96\xc0", [0x1581] = "\x96\xc1",
  [0x1582] = "\x96\xc2", [0x1583] = "\x96\xc3", [0x1584] = "\x96\xc4",
  [0x1585] = "\x96\xc5", [0x1586] = "\x96\xc6", [0x1587] = "\x96\xc7",
  [0x1588] = "\x96\xc8", [0x1589] = "\x96\xc9", [0x158a] = "\x96\xca",
  [0x158b] = "\x96\xcb", [0x158c] = "\x96\xcc", [0x158d] = "\x96\xcd",
  [0x158e] = "\x96\xce", [0x158f] = "\x96\xcf", [0x1590] = "\x96\xd0",
  [0x1591] = "\x96\xd1", [0x1592] = "\x96\xd2", [0x1593] = "\x96\xd3",
  [0x1594] = "\x96\xd4", [0x1595] = "\x96\xd5", [0x1596] = "\x96\xd6",
  [0x1597] = "\x96\xd7", [0x1598] = "\x96\xd8", [0x1599] = "\x96\xd9",
  [0x159a] = "\x96\xda", [0x159b] = "\x96\xdb", [0x159c] = "\x96\xdc",
  [0x159d] = "\x96\xdd", [0x159e] = "\x96\xde", [0x159f] = "\x96\xdf",
  [0x15a0] = "\x96\xe0", [0x15a1] = "\x96\xe1", [0x15a2] = "\x96\xe2",
  [0x15a3] = "\x96\xe3", [0x15a4] = "\x96\xe4", [0x15a5] = "\x96\xe5",
  [0x15a6] = "\x96\xe6", [0x15a7] = "\x96\xe7", [0x15a8] = "\x96\xe8",
  [0x15a9] = "\x96\xe9", [0x15aa] = "\x96\xea", [0x15ab] = "\x96\xeb",
  [0x15ac] = "\x96\xec", [0x15ad] = "\x96\xed", [0x15ae] = "\x96\xee",
  [0x15af] = "\x96\xef", [0x15b0] = "\x96\xf0", [0x15b1] = "\x96\xf1",
  [0x15b2] = "\x96\xf2", [0x15b3] = "\x96\xf3", [0x15b4] = "\x96\xf4",
  [0x15b5] = "\x96\xf5", [0x15b6] = "\x96\xf6", [0x15b7] = "\x96\xf7",
  [0x15b8] = "\x96\xf8", [0x15b9] = "\x96\xf9", [0x15ba] = "\x96\xfa",
  [0x15bb] = "\x96\xfb", [0x15bc] = "\x96\xfc", [0x15bd] = "\x96\xfd",
  [0x15be] = "\x96\xfe", [0x1600] = "\x97\x40", [0x1601] = "\x97\x41",
  [0x1602] = "\x97\x42", [0x1603] = "\x97\x43", [0x1604] = "\x97\x44",
  [0x1605] = "\x97\x45", [0x1606] = "\x97\x46", [0x1607] = "\x97\x47",
  [0x1608] = "\x97\x48", [0x1609] = "\x97\x49", [0x160a] = "\x97\x4a",
  [0x160b] = "\x97\x4b", [0x160c] = "\x97\x4c", [0x160d] = "\x97\x4d",
  [0x160e] = "\x97\x4e", [0x160f] = "\x97\x4f", [0x1610] = "\x97\x50",
  [0x1611] = "\x97\x51", [0x1612] = "\x97\x52", [0x1613] = "\x97\x53",
  [0x1614] = "\x97\x54", [0x1615] = "\x97\x55", [0x1616] = "\x97\x56",
  [0x1617] = "\x97\x57", [0x1618] = "\x97\x58", [0x1619] = "\x97\x59",
  [0x161a] = "\x97\x5a", [0x161b] = "\x97\x5b", [0x161c] = "\x97\x5c",
  [0x161d] = "\x97\x5d", [0x161e] = "\x97\x5e", [0x161f] = "\x97\x5f",
  [0x1620] = "\x97\x60", [0x1621] = "\x97\x61", [0x1622] = "\x97\x62",
  [0x1623] = "\x97\x63", [0x1624] = "\x97\x64", [0x1625] = "\x97\x65",
  [0x1626] = "\x97\x66", [0x1627] = "\x97\x67", [0x1628] = "\x97\x68",
  [0x1629] = "\x97\x69", [0x162a] = "\x97\x6a", [0x162b] = "\x97\x6b",
  [0x162c] = "\x97\x6c", [0x162d] = "\x97\x6d", [0x162e] = "\x97\x6e",
  [0x162f] = "\x97\x6f", [0x1630] = "\x97\x70", [0x1631] = "\x97\x71",
  [0x1632] = "\x97\x72", [0x1633] = "\x97\x73", [0x1634] = "\x97\x74",
  [0x1635] = "\x97\x75", [0x1636] = "\x97\x76", [0x1637] = "\x97\x77",
  [0x1638] = "\x97\x78", [0x1639] = "\x97\x79", [0x163a] = "\x97\x7a",
  [0x163b] = "\x97\x7b", [0x163c] = "\x97\x7c", [0x163d] = "\x97\x7d",
  [0x163e] = "\x97\x7e", [0x1640] = "\x97\x80", [0x1641] = "\x97\x81",
  [0x1642] = "\x97\x82", [0x1643] = "\x97\x83", [0x1644] = "\x97\x84",
  [0x1645] = "\x97\x85", [0x1646] = "\x97\x86", [0x1647] = "\x97\x87",
  [0x1648] = "\x97\x88", [0x1649] = "\x97\x89", [0x164a] = "\x97\x8a",
  [0x164b] = "\x97\x8b", [0x164c] = "\x97\x8c", [0x164d] = "\x97\x8d",
  [0x164e] = "\x97\x8e", [0x164f] = "\x97\x8f", [0x1650] = "\x97\x90",
  [0x1651] = "\x97\x91", [0x1652] = "\x97\x92", [0x1653] = "\x97\x93",
  [0x1654] = "\x97\x94", [0x1655] = "\x97\x95", [0x1656] = "\x97\x96",
  [0x1657] = "\x97\x97", [0x1658] = "\x97\x98", [0x1659] = "\x97\x99",
  [0x165a] = "\x97\x9a", [0x165b] = "\x97\x9b", [0x165c] = "\x97\x9c",
  [0x165d] = "\x97\x9d", [0x165e] = "\x97\x9e", [0x165f] = "\x97\x9f",
  [0x1660] = "\x97\xa0", [0x1661] = "\x97\xa1", [0x1662] = "\x97\xa2",
  [0x1663] = "\x97\xa3", [0x1664] = "\x97\xa4", [0x1665] = "\x97\xa5",
  [0x1666] = "\x97\xa6", [0x1667] = "\x97\xa7", [0x1668] = "\x97\xa8",
  [0x1669] = "\x97\xa9", [0x166a] = "\x97\xaa", [0x166b] = "\x97\xab",
  [0x166c] = "\x97\xac", [0x166d] = "\x97\xad", [0x166e] = "\x97\xae",
  [0x166f] = "\x97\xaf", [0x1670] = "\x97\xb0", [0x1671] = "\x97\xb1",
  [0x1672] = "\x97\xb2", [0x1673] = "\x97\xb3", [0x1674] = "\x97\xb4",
  [0x1675] = "\x97\xb5", [0x1676] = "\x97\xb6", [0x1677] = "\x97\xb7",
  [0x1678] = "\x97\xb8", [0x1679] = "\x97\xb9", [0x167a] = "\x97\xba",
  [0x167b] = "\x97\xbb", [0x167c] = "\x97\xbc", [0x167d] = "\x97\xbd",
  [0x167e] = "\x97\xbe", [0x167f] = "\x97\xbf", [0x1680] = "\x97\xc0",
  [0x1681] = "\x97\xc1", [0x1682] = "\x97\xc2", [0x1683] = "\x97\xc3",
  [0x1684] = "\x97\xc4", [0x1685] = "\x97\xc5", [0x1686] = "\x97\xc6",
  [0x1687] = "\x97\xc7", [0x1688] = "\x97\xc8", [0x1689] = "\x97\xc9",
  [0x168a] = "\x97\xca", [0x168b] = "\x97\xcb", [0x168c] = "\x97\xcc",
  [0x168d] = "\x97\xcd", [0x168e] = "\x97\xce", [0x168f] = "\x97\xcf",
  [0x1690] = "\x97\xd0", [0x1691] = "\x97\xd1", [0x1692] = "\x97\xd2",
  [0x1693] = "\x97\xd3", [0x1694] = "\x97\xd4", [0x1695] = "\x97\xd5",
  [0x1696] = "\x97\xd6", [0x1697] = "\x97\xd7", [0x1698] = "\x97\xd8",
  [0x1699] = "\x97\xd9", [0x169a] = "\x97\xda", [0x169b] = "\x97\xdb",
  [0x169c] = "\x97\xdc", [0x169d] = "\x97\xdd", [0x169e] = "\x97\xde",
  [0x169f] = "\x97\xdf", [0x16a0] = "\x97\xe0", [0x16a1] = "\x97\xe1",
  [0x16a2] = "\x97\xe2", [0x16a3] = "\x97\xe3", [0x16a4] = "\x97\xe4",
  [0x16a5] = "\x97\xe5", [0x16a6] = "\x97\xe6", [0x16a7] = "\x97\xe7",
  [0x16a8] = "\x97\xe8", [0x16a9] = "\x97\xe9", [0x16aa] = "\x97\xea",
  [0x16ab] = "\x97\xeb", [0x16ac] = "\x97\xec", [0x16ad] = "\x97\xed",
  [0x16ae] = "\x97\xee", [0x16af] = "\x97\xef", [0x16b0] = "\x97\xf0",
  [0x16b1] = "\x97\xf1", [0x16b2] = "\x97\xf2", [0x16b3] = "\x97\xf3",
  [0x16b4] = "\x97\xf4", [0x16b5] = "\x97\xf5", [0x16b6] = "\x97\xf6",
  [0x16b7] = "\x97\xf7", [0x16b8] = "\x97\xf8", [0x16b9] = "\x97\xf9",
  [0x16ba] = "\x97\xfa", [0x16bb] = "\x97\xfb", [0x16bc] = "\x97\xfc",
  [0x16bd] = "\x97\xfd", [0x16be] = "\x97\xfe", [0x1700] = "\x98\x40",
  [0x1701] = "\x98\x41", [0x1702] = "\x98\x42", [0x1703] = "\x98\x43",
  [0x1704] = "\x98\x44", [0x1705] = "\x98\x45", [0x1706] = "\x98\x46",
  [0x1707] = "\x98\x47", [0x1708] = "\x98\x48", [0x1709] = "\x98\x49",
  [0x170a] = "\x98\x4a", [0x170b] = "\x98\x4b", [0x170c] = "\x98\x4c",
  [0x170d] = "\x98\x4d", [0x170e] = "\x98\x4e", [0x170f] = "\x98\x4f",
  [0x1710] = "\x98\x50", [0x1711] = "\x98\x51", [0x1712] = "\x98\x52",
  [0x1713] = "\x98\x53", [0x1714] = "\x98\x54", [0x1715] = "\x98\x55",
  [0x1716] = "\x98\x56", [0x1717] = "\x98\x57", [0x1718] = "\x98\x58",
  [0x1719] = "\x98\x59", [0x171a] = "\x98\x5a", [0x171b] = "\x98\x5b",
  [0x171c] = "\x98\x5c", [0x171d] = "\x98\x5d", [0x171e] = "\x98\x5e",
  [0x171f] = "\x98\x5f", [0x1720] = "\x98\x60", [0x1721] = "\x98\x61",
  [0x1722] = "\x98\x62", [0x1723] = "\x98\x63", [0x1724] = "\x98\x64",
  [0x1725] = "\x98\x65", [0x1726] = "\x98\x66", [0x1727] = "\x98\x67",
  [0x1728] = "\x98\x68", [0x1729] = "\x98\x69", [0x172a] = "\x98\x6a",
  [0x172b] = "\x98\x6b", [0x172c] = "\x98\x6c", [0x172d] = "\x98\x6d",
  [0x172e] = "\x98\x6e", [0x172f] = "\x98\x6f", [0x1730] = "\x98\x70",
  [0x1731] = "\x98\x71", [0x1732] = "\x98\x72", [0x1733] = "\x98\x73",
  [0x1734] = "\x98\x74", [0x1735] = "\x98\x75", [0x1736] = "\x98\x76",
  [0x1737] = "\x98\x77", [0x1738] = "\x98\x78", [0x1739] = "\x98\x79",
  [0x173a] = "\x98\x7a", [0x173b] = "\x98\x7b", [0x173c] = "\x98\x7c",
  [0x173d] = "\x98\x7d", [0x173e] = "\x98\x7e", [0x1740] = "\x98\x80",
  [0x1741] = "\x98\x81", [0x1742] = "\x98\x82", [0x1743] = "\x98\x83",
  [0x1744] = "\x98\x84", [0x1745] = "\x98\x85", [0x1746] = "\x98\x86",
  [0x1747] = "\x98\x87", [0x1748] = "\x98\x88", [0x1749] = "\x98\x89",
  [0x174a] = "\x98\x8a", [0x174b] = "\x98\x8b", [0x174c] = "\x98\x8c",
  [0x174d] = "\x98\x8d", [0x174e] = "\x98\x8e", [0x174f] = "\x98\x8f",
  [0x1750] = "\x98\x90", [0x1751] = "\x98\x91", [0x1752] = "\x98\x92",
  [0x1753] = "\x98\x93", [0x1754] = "\x98\x94", [0x1755] = "\x98\x95",
  [0x1756] = "\x98\x96", [0x1757] = "\x98\x97", [0x1758] = "\x98\x98",
  [0x1759] = "\x98\x99", [0x175a] = "\x98\x9a", [0x175b] = "\x98\x9b",
  [0x175c] = "\x98\x9c", [0x175d] = "\x98\x9d", [0x175e] = "\x98\x9e",
  [0x175f] = "\x98\x9f", [0x1760] = "\x98\xa0", [0x1761] = "\x98\xa1",
  [0x1762] = "\x98\xa2", [0x1763] = "\x98\xa3", [0x1764] = "\x98\xa4",
  [0x1765] = "\x98\xa5", [0x1766] = "\x98\xa6", [0x1767] = "\x98\xa7",
  [0x1768] = "\x98\xa8", [0x1769] = "\x98\xa9", [0x176a] = "\x98\xaa",
  [0x176b] = "\x98\xab", [0x176c] = "\x98\xac", [0x176d] = "\x98\xad",
  [0x176e] = "\x98\xae", [0x176f] = "\x98\xaf", [0x1770] = "\x98\xb0",
  [0x1771] = "\x98\xb1", [0x1772] = "\x98\xb2", [0x1773] = "\x98\xb3",
  [0x1774] = "\x98\xb4", [0x1775] = "\x98\xb5", [0x1776] = "\x98\xb6",
  [0x1777] = "\x98\xb7", [0x1778] = "\x98\xb8", [0x1779] = "\x98\xb9",
  [0x177a] = "\x98\xba", [0x177b] = "\x98\xbb", [0x177c] = "\x98\xbc",
  [0x177d] = "\x98\xbd", [0x177e] = "\x98\xbe", [0x177f] = "\x98\xbf",
  [0x1780] = "\x98\xc0", [0x1781] = "\x98\xc1", [0x1782] = "\x98\xc2",
  [0x1783] = "\x98\xc3", [0x1784] = "\x98\xc4", [0x1785] = "\x98\xc5",
  [0x1786] = "\x98\xc6", [0x1787] = "\x98\xc7", [0x1788] = "\x98\xc8",
  [0x1789] = "\x98\xc9", [0x178a] = "\x98\xca", [0x178b] = "\x98\xcb",
  [0x178c] = "\x98\xcc", [0x178d] = "\x98\xcd", [0x178e] = "\x98\xce",
  [0x178f] = "\x98\xcf", [0x1790] = "\x98\xd0", [0x1791] = "\x98\xd1",
  [0x1792] = "\x98\xd2", [0x1793] = "\x98\xd3", [0x1794] = "\x98\xd4",
  [0x1795] = "\x98\xd5", [0x1796] = "\x98\xd6", [0x1797] = "\x98\xd7",
  [0x1798] = "\x98\xd8", [0x1799] = "\x98\xd9", [0x179a] = "\x98\xda",
  [0x179b] = "\x98\xdb", [0x179c] = "\x98\xdc", [0x179d] = "\x98\xdd",
  [0x179e] = "\x98\xde", [0x179f] = "\x98\xdf", [0x17a0] = "\x98\xe0",
  [0x17a1] = "\x98\xe1", [0x17a2] = "\x98\xe2", [0x17a3] = "\x98\xe3",
  [0x17a4] = "\x98\xe4", [0x17a5] = "\x98\xe5", [0x17a6] = "\x98\xe6",
  [0x17a7] = "\x98\xe7", [0x17a8] = "\x98\xe8", [0x17a9] = "\x98\xe9",
  [0x17aa] = "\x98\xea", [0x17ab] = "\x98\xeb", [0x17ac] = "\x98\xec",
  [0x17ad] = "\x98\xed", [0x17ae] = "\x98\xee", [0x17af] = "\x98\xef",
  [0x17b0] = "\x98\xf0", [0x17b1] = "\x98\xf1", [0x17b2] = "\x98\xf2",
  [0x17b3] = "\x98\xf3", [0x17b4] = "\x98\xf4", [0x17b5] = "\x98\xf5",
  [0x17b6] = "\x98\xf6", [0x17b7] = "\x98\xf7", [0x17b8] = "\x98\xf8",
  [0x17b9] = "\x98\xf9", [0x17ba] = "\x98\xfa", [0x17bb] = "\x98\xfb",
  [0x17bc] = "\x98\xfc", [0x17bd] = "\x98\xfd", [0x17be] = "\x98\xfe",
  [0x1800] = "\x99\x40", [0x1801] = "\x99\x41", [0x1802] = "\x99\x42",
  [0x1803] = "\x99\x43", [0x1804] = "\x99\x44", [0x1805] = "\x99\x45",
  [0x1806] = "\x99\x46", [0x1807] = "\x99\x47", [0x1808] = "\x99\x48",
  [0x1809] = "\x99\x49", [0x180a] = "\x99\x4a", [0x180b] = "\x99\x4b",
  [0x180c] = "\x99\x4c", [0x180d] = "\x99\x4d", [0x180e] = "\x99\x4e",
  [0x180f] = "\x99\x4f", [0x1810] = "\x99\x50", [0x1811] = "\x99\x51",
  [0x1812] = "\x99\x52", [0x1813] = "\x99\x53", [0x1814] = "\x99\x54",
  [0x1815] = "\x99\x55", [0x1816] = "\x99\x56", [0x1817] = "\x99\x57",
  [0x1818] = "\x99\x58", [0x1819] = "\x99\x59", [0x181a] = "\x99\x5a",
  [0x181b] = "\x99\x5b", [0x181c] = "\x99\x5c", [0x181d] = "\x99\x5d",
  [0x181e] = "\x99\x5e", [0x181f] = "\x99\x5f", [0x1820] = "\x99\x60",
  [0x1821] = "\x99\x61", [0x1822] = "\x99\x62", [0x1823] = "\x99\x63",
  [0x1824] = "\x99\x64", [0x1825] = "\x99\x65", [0x1826] = "\x99\x66",
  [0x1827] = "\x99\x67", [0x1828] = "\x99\x68", [0x1829] = "\x99\x69",
  [0x182a] = "\x99\x6a", [0x182b] = "\x99\x6b", [0x182c] = "\x99\x6c",
  [0x182d] = "\x99\x6d", [0x182e] = "\x99\x6e", [0x182f] = "\x99\x6f",
  [0x1830] = "\x99\x70", [0x1831] = "\x99\x71", [0x1832] = "\x99\x72",
  [0x1833] = "\x99\x73", [0x1834] = "\x99\x74", [0x1835] = "\x99\x75",
  [0x1836] = "\x99\x76", [0x1837] = "\x99\x77", [0x1838] = "\x99\x78",
  [0x1839] = "\x99\x79", [0x183a] = "\x99\x7a", [0x183b] = "\x99\x7b",
  [0x183c] = "\x99\x7c", [0x183d] = "\x99\x7d", [0x183e] = "\x99\x7e",
  [0x1840] = "\x99\x80", [0x1841] = "\x99\x81", [0x1842] = "\x99\x82",
  [0x1843] = "\x99\x83", [0x1844] = "\x99\x84", [0x1845] = "\x99\x85",
  [0x1846] = "\x99\x86", [0x1847] = "\x99\x87", [0x1848] = "\x99\x88",
  [0x1849] = "\x99\x89", [0x184a] = "\x99\x8a", [0x184b] = "\x99\x8b",
  [0x184c] = "\x99\x8c", [0x184d] = "\x99\x8d", [0x184e] = "\x99\x8e",
  [0x184f] = "\x99\x8f", [0x1850] = "\x99\x90", [0x1851] = "\x99\x91",
  [0x1852] = "\x99\x92", [0x1853] = "\x99\x93", [0x1854] = "\x99\x94",
  [0x1855] = "\x99\x95", [0x1856] = "\x99\x96", [0x1857] = "\x99\x97",
  [0x1858] = "\x99\x98", [0x1859] = "\x99\x99", [0x185a] = "\x99\x9a",
  [0x185b] = "\x99\x9b", [0x185c] = "\x99\x9c", [0x185d] = "\x99\x9d",
  [0x185e] = "\x99\x9e", [0x185f] = "\x99\x9f", [0x1860] = "\x99\xa0",
  [0x1861] = "\x99\xa1", [0x1862] = "\x99\xa2", [0x1863] = "\x99\xa3",
  [0x1864] = "\x99\xa4", [0x1865] = "\x99\xa5", [0x1866] = "\x99\xa6",
  [0x1867] = "\x99\xa7", [0x1868] = "\x99\xa8", [0x1869] = "\x99\xa9",
  [0x186a] = "\x99\xaa", [0x186b] = "\x99\xab", [0x186c] = "\x99\xac",
  [0x186d] = "\x99\xad", [0x186e] = "\x99\xae", [0x186f] = "\x99\xaf",
  [0x1870] = "\x99\xb0", [0x1871] = "\x99\xb1", [0x1872] = "\x99\xb2",
  [0x1873] = "\x99\xb3", [0x1874] = "\x99\xb4", [0x1875] = "\x99\xb5",
  [0x1876] = "\x99\xb6", [0x1877] = "\x99\xb7", [0x1878] = "\x99\xb8",
  [0x1879] = "\x99\xb9", [0x187a] = "\x99\xba", [0x187b] = "\x99\xbb",
  [0x187c] = "\x99\xbc", [0x187d] = "\x99\xbd", [0x187e] = "\x99\xbe",
  [0x187f] = "\x99\xbf", [0x1880] = "\x99\xc0", [0x1881] = "\x99\xc1",
  [0x1882] = "\x99\xc2", [0x1883] = "\x99\xc3", [0x1884] = "\x99\xc4",
  [0x1885] = "\x99\xc5", [0x1886] = "\x99\xc6", [0x1887] = "\x99\xc7",
  [0x1888] = "\x99\xc8", [0x1889] = "\x99\xc9", [0x188a] = "\x99\xca",
  [0x188b] = "\x99\xcb", [0x188c] = "\x99\xcc", [0x188d] = "\x99\xcd",
  [0x188e] = "\x99\xce", [0x188f] = "\x99\xcf", [0x1890] = "\x99\xd0",
  [0x1891] = "\x99\xd1", [0x1892] = "\x99\xd2", [0x1893] = "\x99\xd3",
  [0x1894] = "\x99\xd4", [0x1895] = "\x99\xd5", [0x1896] = "\x99\xd6",
  [0x1897] = "\x99\xd7", [0x1898] = "\x99\xd8", [0x1899] = "\x99\xd9",
  [0x189a] = "\x99\xda", [0x189b] = "\x99\xdb", [0x189c] = "\x99\xdc",
  [0x189d] = "\x99\xdd", [0x189e] = "\x99\xde", [0x189f] = "\x99\xdf",
  [0x18a0] = "\x99\xe0", [0x18a1] = "\x99\xe1", [0x18a2] = "\x99\xe2",
  [0x18a3] = "\x99\xe3", [0x18a4] = "\x99\xe4", [0x18a5] = "\x99\xe5",
  [0x18a6] = "\x99\xe6", [0x18a7] = "\x99\xe7", [0x18a8] = "\x99\xe8",
  [0x18a9] = "\x99\xe9", [0x18aa] = "\x99\xea", [0x18ab] = "\x99\xeb",
  [0x18ac] = "\x99\xec", [0x18ad] = "\x99\xed", [0x18ae] = "\x99\xee",
  [0x18af] = "\x99\xef", [0x18b0] = "\x99\xf0", [0x18b1] = "\x99\xf1",
  [0x18b2] = "\x99\xf2", [0x18b3] = "\x99\xf3", [0x18b4] = "\x99\xf4",
  [0x18b5] = "\x99\xf5", [0x18b6] = "\x99\xf6", [0x18b7] = "\x99\xf7",
  [0x18b8] = "\x99\xf8", [0x18b9] = "\x99\xf9", [0x18ba] = "\x99\xfa",
  [0x18bb] = "\x99\xfb", [0x18bc] = "\x99\xfc", [0x18bd] = "\x99\xfd",
  [0x18be] = "\x99\xfe", [0x1900] = "\x9a\x40", [0x1901] = "\x9a\x41",
  [0x1902] = "\x9a\x42", [0x1903] = "\x9a\x43", [0x1904] = "\x9a\x44",
  [0x1905] = "\x9a\x45", [0x1906] = "\x9a\x46", [0x1907] = "\x9a\x47",
  [0x1908] = "\x9a\x48", [0x1909] = "\x9a\x49", [0x190a] = "\x9a\x4a",
  [0x190b] = "\x9a\x4b", [0x190c] = "\x9a\x4c", [0x190d] = "\x9a\x4d",
  [0x190e] = "\x9a\x4e", [0x190f] = "\x9a\x4f", [0x1910] = "\x9a\x50",
  [0x1911] = "\x9a\x51", [0x1912] = "\x9a\x52", [0x1913] = "\x9a\x53",
  [0x1914] = "\x9a\x54", [0x1915] = "\x9a\x55", [0x1916] = "\x9a\x56",
  [0x1917] = "\x9a\x57", [0x1918] = "\x9a\x58", [0x1919] = "\x9a\x59",
  [0x191a] = "\x9a\x5a", [0x191b] = "\x9a\x5b", [0x191c] = "\x9a\x5c",
  [0x191d] = "\x9a\x5d", [0x191e] = "\x9a\x5e", [0x191f] = "\x9a\x5f",
  [0x1920] = "\x9a\x60", [0x1921] = "\x9a\x61", [0x1922] = "\x9a\x62",
  [0x1923] = "\x9a\x63", [0x1924] = "\x9a\x64", [0x1925] = "\x9a\x65",
  [0x1926] = "\x9a\x66", [0x1927] = "\x9a\x67", [0x1928] = "\x9a\x68",
  [0x1929] = "\x9a\x69", [0x192a] = "\x9a\x6a", [0x192b] = "\x9a\x6b",
  [0x192c] = "\x9a\x6c", [0x192d] = "\x9a\x6d", [0x192e] = "\x9a\x6e",
  [0x192f] = "\x9a\x6f", [0x1930] = "\x9a\x70", [0x1931] = "\x9a\x71",
  [0x1932] = "\x9a\x72", [0x1933] = "\x9a\x73", [0x1934] = "\x9a\x74",
  [0x1935] = "\x9a\x75", [0x1936] = "\x9a\x76", [0x1937] = "\x9a\x77",
  [0x1938] = "\x9a\x78", [0x1939] = "\x9a\x79", [0x193a] = "\x9a\x7a",
  [0x193b] = "\x9a\x7b", [0x193c] = "\x9a\x7c", [0x193d] = "\x9a\x7d",
  [0x193e] = "\x9a\x7e", [0x1940] = "\x9a\x80", [0x1941] = "\x9a\x81",
  [0x1942] = "\x9a\x82", [0x1943] = "\x9a\x83", [0x1944] = "\x9a\x84",
  [0x1945] = "\x9a\x85", [0x1946] = "\x9a\x86", [0x1947] = "\x9a\x87",
  [0x1948] = "\x9a\x88", [0x1949] = "\x9a\x89", [0x194a] = "\x9a\x8a",
  [0x194b] = "\x9a\x8b", [0x194c] = "\x9a\x8c", [0x194d] = "\x9a\x8d",
  [0x194e] = "\x9a\x8e", [0x194f] = "\x9a\x8f", [0x1950] = "\x9a\x90",
  [0x1951] = "\x9a\x91", [0x1952] = "\x9a\x92", [0x1953] = "\x9a\x93",
  [0x1954] = "\x9a\x94", [0x1955] = "\x9a\x95", [0x1956] = "\x9a\x96",
  [0x1957] = "\x9a\x97", [0x1958] = "\x9a\x98", [0x1959] = "\x9a\x99",
  [0x195a] = "\x9a\x9a", [0x195b] = "\x9a\x9b", [0x195c] = "\x9a\x9c",
  [0x195d] = "\x9a\x9d", [0x195e] = "\x9a\x9e", [0x195f] = "\x9a\x9f",
  [0x1960] = "\x9a\xa0", [0x1961] = "\x9a\xa1", [0x1962] = "\x9a\xa2",
  [0x1963] = "\x9a\xa3", [0x1964] = "\x9a\xa4", [0x1965] = "\x9a\xa5",
  [0x1966] = "\x9a\xa6", [0x1967] = "\x9a\xa7", [0x1968] = "\x9a\xa8",
  [0x1969] = "\x9a\xa9", [0x196a] = "\x9a\xaa", [0x196b] = "\x9a\xab",
  [0x196c] = "\x9a\xac", [0x196d] = "\x9a\xad", [0x196e] = "\x9a\xae",
  [0x196f] = "\x9a\xaf", [0x1970] = "\x9a\xb0", [0x1971] = "\x9a\xb1",
  [0x1972] = "\x9a\xb2", [0x1973] = "\x9a\xb3", [0x1974] = "\x9a\xb4",
  [0x1975] = "\x9a\xb5", [0x1976] = "\x9a\xb6", [0x1977] = "\x9a\xb7",
  [0x1978] = "\x9a\xb8", [0x1979] = "\x9a\xb9", [0x197a] = "\x9a\xba",
  [0x197b] = "\x9a\xbb", [0x197c] = "\x9a\xbc", [0x197d] = "\x9a\xbd",
  [0x197e] = "\x9a\xbe", [0x197f] = "\x9a\xbf", [0x1980] = "\x9a\xc0",
  [0x1981] = "\x9a\xc1", [0x1982] = "\x9a\xc2", [0x1983] = "\x9a\xc3",
  [0x1984] = "\x9a\xc4", [0x1985] = "\x9a\xc5", [0x1986] = "\x9a\xc6",
  [0x1987] = "\x9a\xc7", [0x1988] = "\x9a\xc8", [0x1989] = "\x9a\xc9",
  [0x198a] = "\x9a\xca", [0x198b] = "\x9a\xcb", [0x198c] = "\x9a\xcc",
  [0x198d] = "\x9a\xcd", [0x198e] = "\x9a\xce", [0x198f] = "\x9a\xcf",
  [0x1990] = "\x9a\xd0", [0x1991] = "\x9a\xd1", [0x1992] = "\x9a\xd2",
  [0x1993] = "\x9a\xd3", [0x1994] = "\x9a\xd4", [0x1995] = "\x9a\xd5",
  [0x1996] = "\x9a\xd6", [0x1997] = "\x9a\xd7", [0x1998] = "\x9a\xd8",
  [0x1999] = "\x9a\xd9", [0x199a] = "\x9a\xda", [0x199b] = "\x9a\xdb",
  [0x199c] = "\x9a\xdc", [0x199d] = "\x9a\xdd", [0x199e] = "\x9a\xde",
  [0x199f] = "\x9a\xdf", [0x19a0] = "\x9a\xe0", [0x19a1] = "\x9a\xe1",
  [0x19a2] = "\x9a\xe2", [0x19a3] = "\x9a\xe3", [0x19a4] = "\x9a\xe4",
  [0x19a5] = "\x9a\xe5", [0x19a6] = "\x9a\xe6", [0x19a7] = "\x9a\xe7",
  [0x19a8] = "\x9a\xe8", [0x19a9] = "\x9a\xe9", [0x19aa] = "\x9a\xea",
  [0x19ab] = "\x9a\xeb", [0x19ac] = "\x9a\xec", [0x19ad] = "\x9a\xed",
  [0x19ae] = "\x9a\xee", [0x19af] = "\x9a\xef", [0x19b0] = "\x9a\xf0",
  [0x19b1] = "\x9a\xf1", [0x19b2] = "\x9a\xf2", [0x19b3] = "\x9a\xf3",
  [0x19b4] = "\x9a\xf4", [0x19b5] = "\x9a\xf5", [0x19b6] = "\x9a\xf6",
  [0x19b7] = "\x9a\xf7", [0x19b8] = "\x9a\xf8", [0x19b9] = "\x9a\xf9",
  [0x19ba] = "\x9a\xfa", [0x19bb] = "\x9a\xfb", [0x19bc] = "\x9a\xfc",
  [0x19bd] = "\x9a\xfd", [0x19be] = "\x9a\xfe", [0x1a00] = "\x9b\x40",
  [0x1a01] = "\x9b\x41", [0x1a02] = "\x9b\x42", [0x1a03] = "\x9b\x43",
  [0x1a04] = "\x9b\x44", [0x1a05] = "\x9b\x45", [0x1a06] = "\x9b\x46",
  [0x1a07] = "\x9b\x47", [0x1a08] = "\x9b\x48", [0x1a09] = "\x9b\x49",
  [0x1a0a] = "\x9b\x4a", [0x1a0b] = "\x9b\x4b", [0x1a0c] = "\x9b\x4c",
  [0x1a0d] = "\x9b\x4d", [0x1a0e] = "\x9b\x4e", [0x1a0f] = "\x9b\x4f",
  [0x1a10] = "\x9b\x50", [0x1a11] = "\x9b\x51", [0x1a12] = "\x9b\x52",
  [0x1a13] = "\x9b\x53", [0x1a14] = "\x9b\x54", [0x1a15] = "\x9b\x55",
  [0x1a16] = "\x9b\x56", [0x1a17] = "\x9b\x57", [0x1a18] = "\x9b\x58",
  [0x1a19] = "\x9b\x59", [0x1a1a] = "\x9b\x5a", [0x1a1b] = "\x9b\x5b",
  [0x1a1c] = "\x9b\x5c", [0x1a1d] = "\x9b\x5d", [0x1a1e] = "\x9b\x5e",
  [0x1a1f] = "\x9b\x5f", [0x1a20] = "\x9b\x60", [0x1a21] = "\x9b\x61",
  [0x1a22] = "\x9b\x62", [0x1a23] = "\x9b\x63", [0x1a24] = "\x9b\x64",
  [0x1a25] = "\x9b\x65", [0x1a26] = "\x9b\x66", [0x1a27] = "\x9b\x67",
  [0x1a28] = "\x9b\x68", [0x1a29] = "\x9b\x69", [0x1a2a] = "\x9b\x6a",
  [0x1a2b] = "\x9b\x6b", [0x1a2c] = "\x9b\x6c", [0x1a2d] = "\x9b\x6d",
  [0x1a2e] = "\x9b\x6e", [0x1a2f] = "\x9b\x6f", [0x1a30] = "\x9b\x70",
  [0x1a31] = "\x9b\x71", [0x1a32] = "\x9b\x72", [0x1a33] = "\x9b\x73",
  [0x1a34] = "\x9b\x74", [0x1a35] = "\x9b\x75", [0x1a36] = "\x9b\x76",
  [0x1a37] = "\x9b\x77", [0x1a38] = "\x9b\x78", [0x1a39] = "\x9b\x79",
  [0x1a3a] = "\x9b\x7a", [0x1a3b] = "\x9b\x7b", [0x1a3c] = "\x9b\x7c",
  [0x1a3d] = "\x9b\x7d", [0x1a3e] = "\x9b\x7e", [0x1a40] = "\x9b\x80",
  [0x1a41] = "\x9b\x81", [0x1a42] = "\x9b\x82", [0x1a43] = "\x9b\x83",
  [0x1a44] = "\x9b\x84", [0x1a45] = "\x9b\x85", [0x1a46] = "\x9b\x86",
  [0x1a47] = "\x9b\x87", [0x1a48] = "\x9b\x88", [0x1a49] = "\x9b\x89",
  [0x1a4a] = "\x9b\x8a", [0x1a4b] = "\x9b\x8b", [0x1a4c] = "\x9b\x8c",
  [0x1a4d] = "\x9b\x8d", [0x1a4e] = "\x9b\x8e", [0x1a4f] = "\x9b\x8f",
  [0x1a50] = "\x9b\x90", [0x1a51] = "\x9b\x91", [0x1a52] = "\x9b\x92",
  [0x1a53] = "\x9b\x93", [0x1a54] = "\x9b\x94", [0x1a55] = "\x9b\x95",
  [0x1a56] = "\x9b\x96", [0x1a57] = "\x9b\x97", [0x1a58] = "\x9b\x98",
  [0x1a59] = "\x9b\x99", [0x1a5a] = "\x9b\x9a", [0x1a5b] = "\x9b\x9b",
  [0x1a5c] = "\x9b\x9c", [0x1a5d] = "\x9b\x9d", [0x1a5e] = "\x9b\x9e",
  [0x1a5f] = "\x9b\x9f", [0x1a60] = "\x9b\xa0", [0x1a61] = "\x9b\xa1",
  [0x1a62] = "\x9b\xa2", [0x1a63] = "\x9b\xa3", [0x1a64] = "\x9b\xa4",
  [0x1a65] = "\x9b\xa5", [0x1a66] = "\x9b\xa6", [0x1a67] = "\x9b\xa7",
  [0x1a68] = "\x9b\xa8", [0x1a69] = "\x9b\xa9", [0x1a6a] = "\x9b\xaa",
  [0x1a6b] = "\x9b\xab", [0x1a6c] = "\x9b\xac", [0x1a6d] = "\x9b\xad",
  [0x1a6e] = "\x9b\xae", [0x1a6f] = "\x9b\xaf", [0x1a70] = "\x9b\xb0",
  [0x1a71] = "\x9b\xb1", [0x1a72] = "\x9b\xb2", [0x1a73] = "\x9b\xb3",
  [0x1a74] = "\x9b\xb4", [0x1a75] = "\x9b\xb5", [0x1a76] = "\x9b\xb6",
  [0x1a77] = "\x9b\xb7", [0x1a78] = "\x9b\xb8", [0x1a79] = "\x9b\xb9",
  [0x1a7a] = "\x9b\xba", [0x1a7b] = "\x9b\xbb", [0x1a7c] = "\x9b\xbc",
  [0x1a7d] = "\x9b\xbd", [0x1a7e] = "\x9b\xbe", [0x1a7f] = "\x9b\xbf",
  [0x1a80] = "\x9b\xc0", [0x1a81] = "\x9b\xc1", [0x1a82] = "\x9b\xc2",
  [0x1a83] = "\x9b\xc3", [0x1a84] = "\x9b\xc4", [0x1a85] = "\x9b\xc5",
  [0x1a86] = "\x9b\xc6", [0x1a87] = "\x9b\xc7", [0x1a88] = "\x9b\xc8",
  [0x1a89] = "\x9b\xc9", [0x1a8a] = "\x9b\xca", [0x1a8b] = "\x9b\xcb",
  [0x1a8c] = "\x9b\xcc", [0x1a8d] = "\x9b\xcd", [0x1a8e] = "\x9b\xce",
  [0x1a8f] = "\x9b\xcf", [0x1a90] = "\x9b\xd0", [0x1a91] = "\x9b\xd1",
  [0x1a92] = "\x9b\xd2", [0x1a93] = "\x9b\xd3", [0x1a94] = "\x9b\xd4",
  [0x1a95] = "\x9b\xd5", [0x1a96] = "\x9b\xd6", [0x1a97] = "\x9b\xd7",
  [0x1a98] = "\x9b\xd8", [0x1a99] = "\x9b\xd9", [0x1a9a] = "\x9b\xda",
  [0x1a9b] = "\x9b\xdb", [0x1a9c] = "\x9b\xdc", [0x1a9d] = "\x9b\xdd",
  [0x1a9e] = "\x9b\xde", [0x1a9f] = "\x9b\xdf", [0x1aa0] = "\x9b\xe0",
  [0x1aa1] = "\x9b\xe1", [0x1aa2] = "\x9b\xe2", [0x1aa3] = "\x9b\xe3",
  [0x1aa4] = "\x9b\xe4", [0x1aa5] = "\x9b\xe5", [0x1aa6] = "\x9b\xe6",
  [0x1aa7] = "\x9b\xe7", [0x1aa8] = "\x9b\xe8", [0x1aa9] = "\x9b\xe9",
  [0x1aaa] = "\x9b\xea", [0x1aab] = "\x9b\xeb", [0x1aac] = "\x9b\xec",
  [0x1aad] = "\x9b\xed", [0x1aae] = "\x9b\xee", [0x1aaf] = "\x9b\xef",
  [0x1ab0] = "\x9b\xf0", [0x1ab1] = "\x9b\xf1", [0x1ab2] = "\x9b\xf2",
  [0x1ab3] = "\x9b\xf3", [0x1ab4] = "\x9b\xf4", [0x1ab5] = "\x9b\xf5",
  [0x1ab6] = "\x9b\xf6", [0x1ab7] = "\x9b\xf7", [0x1ab8] = "\x9b\xf8",
  [0x1ab9] = "\x9b\xf9", [0x1aba] = "\x9b\xfa", [0x1abb] = "\x9b\xfb",
  [0x1abc] = "\x9b\xfc", [0x1abd] = "\x9b\xfd", [0x1abe] = "\x9b\xfe",
  [0x1b00] = "\x9c\x40", [0x1b01] = "\x9c\x41", [0x1b02] = "\x9c\x42",
  [0x1b03] = "\x9c\x43", [0x1b04] = "\x9c\x44", [0x1b05] = "\x9c\x45",
  [0x1b06] = "\x9c\x46", [0x1b07] = "\x9c\x47", [0x1b08] = "\x9c\x48",
  [0x1b09] = "\x9c\x49", [0x1b0a] = "\x9c\x4a", [0x1b0b] = "\x9c\x4b",
  [0x1b0c] = "\x9c\x4c", [0x1b0d] = "\x9c\x4d", [0x1b0e] = "\x9c\x4e",
  [0x1b0f] = "\x9c\x4f", [0x1b10] = "\x9c\x50", [0x1b11] = "\x9c\x51",
  [0x1b12] = "\x9c\x52", [0x1b13] = "\x9c\x53", [0x1b14] = "\x9c\x54",
  [0x1b15] = "\x9c\x55", [0x1b16] = "\x9c\x56", [0x1b17] = "\x9c\x57",
  [0x1b18] = "\x9c\x58", [0x1b19] = "\x9c\x59", [0x1b1a] = "\x9c\x5a",
  [0x1b1b] = "\x9c\x5b", [0x1b1c] = "\x9c\x5c", [0x1b1d] = "\x9c\x5d",
  [0x1b1e] = "\x9c\x5e", [0x1b1f] = "\x9c\x5f", [0x1b20] = "\x9c\x60",
  [0x1b21] = "\x9c\x61", [0x1b22] = "\x9c\x62", [0x1b23] = "\x9c\x63",
  [0x1b24] = "\x9c\x64", [0x1b25] = "\x9c\x65", [0x1b26] = "\x9c\x66",
  [0x1b27] = "\x9c\x67", [0x1b28] = "\x9c\x68", [0x1b29] = "\x9c\x69",
  [0x1b2a] = "\x9c\x6a", [0x1b2b] = "\x9c\x6b", [0x1b2c] = "\x9c\x6c",
  [0x1b2d] = "\x9c\x6d", [0x1b2e] = "\x9c\x6e", [0x1b2f] = "\x9c\x6f",
  [0x1b30] = "\x9c\x70", [0x1b31] = "\x9c\x71", [0x1b32] = "\x9c\x72",
  [0x1b33] = "\x9c\x73", [0x1b34] = "\x9c\x74", [0x1b35] = "\x9c\x75",
  [0x1b36] = "\x9c\x76", [0x1b37] = "\x9c\x77", [0x1b38] = "\x9c\x78",
  [0x1b39] = "\x9c\x79", [0x1b3a] = "\x9c\x7a", [0x1b3b] = "\x9c\x7b",
  [0x1b3c] = "\x9c\x7c", [0x1b3d] = "\x9c\x7d", [0x1b3e] = "\x9c\x7e",
  [0x1b40] = "\x9c\x80", [0x1b41] = "\x9c\x81", [0x1b42] = "\x9c\x82",
  [0x1b43] = "\x9c\x83", [0x1b44] = "\x9c\x84", [0x1b45] = "\x9c\x85",
  [0x1b46] = "\x9c\x86", [0x1b47] = "\x9c\x87", [0x1b48] = "\x9c\x88",
  [0x1b49] = "\x9c\x89", [0x1b4a] = "\x9c\x8a", [0x1b4b] = "\x9c\x8b",
  [0x1b4c] = "\x9c\x8c", [0x1b4d] = "\x9c\x8d", [0x1b4e] = "\x9c\x8e",
  [0x1b4f] = "\x9c\x8f", [0x1b50] = "\x9c\x90", [0x1b51] = "\x9c\x91",
  [0x1b52] = "\x9c\x92", [0x1b53] = "\x9c\x93", [0x1b54] = "\x9c\x94",
  [0x1b55] = "\x9c\x95", [0x1b56] = "\x9c\x96", [0x1b57] = "\x9c\x97",
  [0x1b58] = "\x9c\x98", [0x1b59] = "\x9c\x99", [0x1b5a] = "\x9c\x9a",
  [0x1b5b] = "\x9c\x9b", [0x1b5c] = "\x9c\x9c", [0x1b5d] = "\x9c\x9d",
  [0x1b5e] = "\x9c\x9e", [0x1b5f] = "\x9c\x9f", [0x1b60] = "\x9c\xa0",
  [0x1b61] = "\x9c\xa1", [0x1b62] = "\x9c\xa2", [0x1b63] = "\x9c\xa3",
  [0x1b64] = "\x9c\xa4", [0x1b65] = "\x9c\xa5", [0x1b66] = "\x9c\xa6",
  [0x1b67] = "\x9c\xa7", [0x1b68] = "\x9c\xa8", [0x1b69] = "\x9c\xa9",
  [0x1b6a] = "\x9c\xaa", [0x1b6b] = "\x9c\xab", [0x1b6c] = "\x9c\xac",
  [0x1b6d] = "\x9c\xad", [0x1b6e] = "\x9c\xae", [0x1b6f] = "\x9c\xaf",
  [0x1b70] = "\x9c\xb0", [0x1b71] = "\x9c\xb1", [0x1b72] = "\x9c\xb2",
  [0x1b73] = "\x9c\xb3", [0x1b74] = "\x9c\xb4", [0x1b75] = "\x9c\xb5",
  [0x1b76] = "\x9c\xb6", [0x1b77] = "\x9c\xb7", [0x1b78] = "\x9c\xb8",
  [0x1b79] = "\x9c\xb9", [0x1b7a] = "\x9c\xba", [0x1b7b] = "\x9c\xbb",
  [0x1b7c] = "\x9c\xbc", [0x1b7d] = "\x9c\xbd", [0x1b7e] = "\x9c\xbe",
  [0x1b7f] = "\x9c\xbf", [0x1b80] = "\x9c\xc0", [0x1b81] = "\x9c\xc1",
  [0x1b82] = "\x9c\xc2", [0x1b83] = "\x9c\xc3", [0x1b84] = "\x9c\xc4",
  [0x1b85] = "\x9c\xc5", [0x1b86] = "\x9c\xc6", [0x1b87] = "\x9c\xc7",
  [0x1b88] = "\x9c\xc8", [0x1b89] = "\x9c\xc9", [0x1b8a] = "\x9c\xca",
  [0x1b8b] = "\x9c\xcb", [0x1b8c] = "\x9c\xcc", [0x1b8d] = "\x9c\xcd",
  [0x1b8e] = "\x9c\xce", [0x1b8f] = "\x9c\xcf", [0x1b90] = "\x9c\xd0",
  [0x1b91] = "\x9c\xd1", [0x1b92] = "\x9c\xd2", [0x1b93] = "\x9c\xd3",
  [0x1b94] = "\x9c\xd4", [0x1b95] = "\x9c\xd5", [0x1b96] = "\x9c\xd6",
  [0x1b97] = "\x9c\xd7", [0x1b98] = "\x9c\xd8", [0x1b99] = "\x9c\xd9",
  [0x1b9a] = "\x9c\xda", [0x1b9b] = "\x9c\xdb", [0x1b9c] = "\x9c\xdc",
  [0x1b9d] = "\x9c\xdd", [0x1b9e] = "\x9c\xde", [0x1b9f] = "\x9c\xdf",
  [0x1ba0] = "\x9c\xe0", [0x1ba1] = "\x9c\xe1", [0x1ba2] = "\x9c\xe2",
  [0x1ba3] = "\x9c\xe3", [0x1ba4] = "\x9c\xe4", [0x1ba5] = "\x9c\xe5",
  [0x1ba6] = "\x9c\xe6", [0x1ba7] = "\x9c\xe7", [0x1ba8] = "\x9c\xe8",
  [0x1ba9] = "\x9c\xe9", [0x1baa] = "\x9c\xea", [0x1bab] = "\x9c\xeb",
  [0x1bac] = "\x9c\xec", [0x1bad] = "\x9c\xed", [0x1bae] = "\x9c\xee",
  [0x1baf] = "\x9c\xef", [0x1bb0] = "\x9c\xf0", [0x1bb1] = "\x9c\xf1",
  [0x1bb2] = "\x9c\xf2", [0x1bb3] = "\x9c\xf3", [0x1bb4] = "\x9c\xf4",
  [0x1bb5] = "\x9c\xf5", [0x1bb6] = "\x9c\xf6", [0x1bb7] = "\x9c\xf7",
  [0x1bb8] = "\x9c\xf8", [0x1bb9] = "\x9c\xf9", [0x1bba] = "\x9c\xfa",
  [0x1bbb] = "\x9c\xfb", [0x1bbc] = "\x9c\xfc", [0x1bbd] = "\x9c\xfd",
  [0x1bbe] = "\x9c\xfe", [0x1c00] = "\x9d\x40", [0x1c01] = "\x9d\x41",
  [0x1c02] = "\x9d\x42", [0x1c03] = "\x9d\x43", [0x1c04] = "\x9d\x44",
  [0x1c05] = "\x9d\x45", [0x1c06] = "\x9d\x46", [0x1c07] = "\x9d\x47",
  [0x1c08] = "\x9d\x48", [0x1c09] = "\x9d\x49", [0x1c0a] = "\x9d\x4a",
  [0x1c0b] = "\x9d\x4b", [0x1c0c] = "\x9d\x4c", [0x1c0d] = "\x9d\x4d",
  [0x1c0e] = "\x9d\x4e", [0x1c0f] = "\x9d\x4f", [0x1c10] = "\x9d\x50",
  [0x1c11] = "\x9d\x51", [0x1c12] = "\x9d\x52", [0x1c13] = "\x9d\x53",
  [0x1c14] = "\x9d\x54", [0x1c15] = "\x9d\x55", [0x1c16] = "\x9d\x56",
  [0x1c17] = "\x9d\x57", [0x1c18] = "\x9d\x58", [0x1c19] = "\x9d\x59",
  [0x1c1a] = "\x9d\x5a", [0x1c1b] = "\x9d\x5b", [0x1c1c] = "\x9d\x5c",
  [0x1c1d] = "\x9d\x5d", [0x1c1e] = "\x9d\x5e", [0x1c1f] = "\x9d\x5f",
  [0x1c20] = "\x9d\x60", [0x1c21] = "\x9d\x61", [0x1c22] = "\x9d\x62",
  [0x1c23] = "\x9d\x63", [0x1c24] = "\x9d\x64", [0x1c25] = "\x9d\x65",
  [0x1c26] = "\x9d\x66", [0x1c27] = "\x9d\x67", [0x1c28] = "\x9d\x68",
  [0x1c29] = "\x9d\x69", [0x1c2a] = "\x9d\x6a", [0x1c2b] = "\x9d\x6b",
  [0x1c2c] = "\x9d\x6c", [0x1c2d] = "\x9d\x6d", [0x1c2e] = "\x9d\x6e",
  [0x1c2f] = "\x9d\x6f", [0x1c30] = "\x9d\x70", [0x1c31] = "\x9d\x71",
  [0x1c32] = "\x9d\x72", [0x1c33] = "\x9d\x73", [0x1c34] = "\x9d\x74",
  [0x1c35] = "\x9d\x75", [0x1c36] = "\x9d\x76", [0x1c37] = "\x9d\x77",
  [0x1c38] = "\x9d\x78", [0x1c39] = "\x9d\x79", [0x1c3a] = "\x9d\x7a",
  [0x1c3b] = "\x9d\x7b", [0x1c3c] = "\x9d\x7c", [0x1c3d] = "\x9d\x7d",
  [0x1c3e] = "\x9d\x7e", [0x1c40] = "\x9d\x80", [0x1c41] = "\x9d\x81",
  [0x1c42] = "\x9d\x82", [0x1c43] = "\x9d\x83", [0x1c44] = "\x9d\x84",
  [0x1c45] = "\x9d\x85", [0x1c46] = "\x9d\x86", [0x1c47] = "\x9d\x87",
  [0x1c48] = "\x9d\x88", [0x1c49] = "\x9d\x89", [0x1c4a] = "\x9d\x8a",
  [0x1c4b] = "\x9d\x8b", [0x1c4c] = "\x9d\x8c", [0x1c4d] = "\x9d\x8d",
  [0x1c4e] = "\x9d\x8e", [0x1c4f] = "\x9d\x8f", [0x1c50] = "\x9d\x90",
  [0x1c51] = "\x9d\x91", [0x1c52] = "\x9d\x92", [0x1c53] = "\x9d\x93",
  [0x1c54] = "\x9d\x94", [0x1c55] = "\x9d\x95", [0x1c56] = "\x9d\x96",
  [0x1c57] = "\x9d\x97", [0x1c58] = "\x9d\x98", [0x1c59] = "\x9d\x99",
  [0x1c5a] = "\x9d\x9a", [0x1c5b] = "\x9d\x9b", [0x1c5c] = "\x9d\x9c",
  [0x1c5d] = "\x9d\x9d", [0x1c5e] = "\x9d\x9e", [0x1c5f] = "\x9d\x9f",
  [0x1c60] = "\x9d\xa0", [0x1c61] = "\x9d\xa1", [0x1c62] = "\x9d\xa2",
  [0x1c63] = "\x9d\xa3", [0x1c64] = "\x9d\xa4", [0x1c65] = "\x9d\xa5",
  [0x1c66] = "\x9d\xa6", [0x1c67] = "\x9d\xa7", [0x1c68] = "\x9d\xa8",
  [0x1c69] = "\x9d\xa9", [0x1c6a] = "\x9d\xaa", [0x1c6b] = "\x9d\xab",
  [0x1c6c] = "\x9d\xac", [0x1c6d] = "\x9d\xad", [0x1c6e] = "\x9d\xae",
  [0x1c6f] = "\x9d\xaf", [0x1c70] = "\x9d\xb0", [0x1c71] = "\x9d\xb1",
  [0x1c72] = "\x9d\xb2", [0x1c73] = "\x9d\xb3", [0x1c74] = "\x9d\xb4",
  [0x1c75] = "\x9d\xb5", [0x1c76] = "\x9d\xb6", [0x1c77] = "\x9d\xb7",
  [0x1c78] = "\x9d\xb8", [0x1c79] = "\x9d\xb9", [0x1c7a] = "\x9d\xba",
  [0x1c7b] = "\x9d\xbb", [0x1c7c] = "\x9d\xbc", [0x1c7d] = "\x9d\xbd",
  [0x1c7e] = "\x9d\xbe", [0x1c7f] = "\x9d\xbf", [0x1c80] = "\x9d\xc0",
  [0x1c81] = "\x9d\xc1", [0x1c82] = "\x9d\xc2", [0x1c83] = "\x9d\xc3",
  [0x1c84] = "\x9d\xc4", [0x1c85] = "\x9d\xc5", [0x1c86] = "\x9d\xc6",
  [0x1c87] = "\x9d\xc7", [0x1c88] = "\x9d\xc8", [0x1c89] = "\x9d\xc9",
  [0x1c8a] = "\x9d\xca", [0x1c8b] = "\x9d\xcb", [0x1c8c] = "\x9d\xcc",
  [0x1c8d] = "\x9d\xcd", [0x1c8e] = "\x9d\xce", [0x1c8f] = "\x9d\xcf",
  [0x1c90] = "\x9d\xd0", [0x1c91] = "\x9d\xd1", [0x1c92] = "\x9d\xd2",
  [0x1c93] = "\x9d\xd3", [0x1c94] = "\x9d\xd4", [0x1c95] = "\x9d\xd5",
  [0x1c96] = "\x9d\xd6", [0x1c97] = "\x9d\xd7", [0x1c98] = "\x9d\xd8",
  [0x1c99] = "\x9d\xd9", [0x1c9a] = "\x9d\xda", [0x1c9b] = "\x9d\xdb",
  [0x1c9c] = "\x9d\xdc", [0x1c9d] = "\x9d\xdd", [0x1c9e] = "\x9d\xde",
  [0x1c9f] = "\x9d\xdf", [0x1ca0] = "\x9d\xe0", [0x1ca1] = "\x9d\xe1",
  [0x1ca2] = "\x9d\xe2", [0x1ca3] = "\x9d\xe3", [0x1ca4] = "\x9d\xe4",
  [0x1ca5] = "\x9d\xe5", [0x1ca6] = "\x9d\xe6", [0x1ca7] = "\x9d\xe7",
  [0x1ca8] = "\x9d\xe8", [0x1ca9] = "\x9d\xe9", [0x1caa] = "\x9d\xea",
  [0x1cab] = "\x9d\xeb", [0x1cac] = "\x9d\xec", [0x1cad] = "\x9d\xed",
  [0x1cae] = "\x9d\xee", [0x1caf] = "\x9d\xef", [0x1cb0] = "\x9d\xf0",
  [0x1cb1] = "\x9d\xf1", [0x1cb2] = "\x9d\xf2", [0x1cb3] = "\x9d\xf3",
  [0x1cb4] = "\x9d\xf4", [0x1cb5] = "\x9d\xf5", [0x1cb6] = "\x9d\xf6",
  [0x1cb7] = "\x9d\xf7", [0x1cb8] = "\x9d\xf8", [0x1cb9] = "\x9d\xf9",
  [0x1cba] = "\x9d\xfa", [0x1cbb] = "\x9d\xfb", [0x1cbc] = "\x9d\xfc",
  [0x1cbd] = "\x9d\xfd", [0x1cbe] = "\x9d\xfe", [0x1d00] = "\x9e\x40",
  [0x1d01] = "\x9e\x41", [0x1d02] = "\x9e\x42", [0x1d03] = "\x9e\x43",
  [0x1d04] = "\x9e\x44", [0x1d05] = "\x9e\x45", [0x1d06] = "\x9e\x46",
  [0x1d07] = "\x9e\x47", [0x1d08] = "\x9e\x48", [0x1d09] = "\x9e\x49",
  [0x1d0a] = "\x9e\x4a", [0x1d0b] = "\x9e\x4b", [0x1d0c] = "\x9e\x4c",
  [0x1d0d] = "\x9e\x4d", [0x1d0e] = "\x9e\x4e", [0x1d0f] = "\x9e\x4f",
  [0x1d10] = "\x9e\x50", [0x1d11] = "\x9e\x51", [0x1d12] = "\x9e\x52",
  [0x1d13] = "\x9e\x53", [0x1d14] = "\x9e\x54", [0x1d15] = "\x9e\x55",
  [0x1d16] = "\x9e\x56", [0x1d17] = "\x9e\x57", [0x1d18] = "\x9e\x58",
  [0x1d19] = "\x9e\x59", [0x1d1a] = "\x9e\x5a", [0x1d1b] = "\x9e\x5b",
  [0x1d1c] = "\x9e\x5c", [0x1d1d] = "\x9e\x5d", [0x1d1e] = "\x9e\x5e",
  [0x1d1f] = "\x9e\x5f", [0x1d20] = "\x9e\x60", [0x1d21] = "\x9e\x61",
  [0x1d22] = "\x9e\x62", [0x1d23] = "\x9e\x63", [0x1d24] = "\x9e\x64",
  [0x1d25] = "\x9e\x65", [0x1d26] = "\x9e\x66", [0x1d27] = "\x9e\x67",
  [0x1d28] = "\x9e\x68", [0x1d29] = "\x9e\x69", [0x1d2a] = "\x9e\x6a",
  [0x1d2b] = "\x9e\x6b", [0x1d2c] = "\x9e\x6c", [0x1d2d] = "\x9e\x6d",
  [0x1d2e] = "\x9e\x6e", [0x1d2f] = "\x9e\x6f", [0x1d30] = "\x9e\x70",
  [0x1d31] = "\x9e\x71", [0x1d32] = "\x9e\x72", [0x1d33] = "\x9e\x73",
  [0x1d34] = "\x9e\x74", [0x1d35] = "\x9e\x75", [0x1d36] = "\x9e\x76",
  [0x1d37] = "\x9e\x77", [0x1d38] = "\x9e\x78", [0x1d39] = "\x9e\x79",
  [0x1d3a] = "\x9e\x7a", [0x1d3b] = "\x9e\x7b", [0x1d3c] = "\x9e\x7c",
  [0x1d3d] = "\x9e\x7d", [0x1d3e] = "\x9e\x7e", [0x1d40] = "\x9e\x80",
  [0x1d41] = "\x9e\x81", [0x1d42] = "\x9e\x82", [0x1d43] = "\x9e\x83",
  [0x1d44] = "\x9e\x84", [0x1d45] = "\x9e\x85", [0x1d46] = "\x9e\x86",
  [0x1d47] = "\x9e\x87", [0x1d48] = "\x9e\x88", [0x1d49] = "\x9e\x89",
  [0x1d4a] = "\x9e\x8a", [0x1d4b] = "\x9e\x8b", [0x1d4c] = "\x9e\x8c",
  [0x1d4d] = "\x9e\x8d", [0x1d4e] = "\x9e\x8e", [0x1d4f] = "\x9e\x8f",
  [0x1d50] = "\x9e\x90", [0x1d51] = "\x9e\x91", [0x1d52] = "\x9e\x92",
  [0x1d53] = "\x9e\x93", [0x1d54] = "\x9e\x94", [0x1d55] = "\x9e\x95",
  [0x1d56] = "\x9e\x96", [0x1d57] = "\x9e\x97", [0x1d58] = "\x9e\x98",
  [0x1d59] = "\x9e\x99", [0x1d5a] = "\x9e\x9a", [0x1d5b] = "\x9e\x9b",
  [0x1d5c] = "\x9e\x9c", [0x1d5d] = "\x9e\x9d", [0x1d5e] = "\x9e\x9e",
  [0x1d5f] = "\x9e\x9f", [0x1d60] = "\x9e\xa0", [0x1d61] = "\x9e\xa1",
  [0x1d62] = "\x9e\xa2", [0x1d63] = "\x9e\xa3", [0x1d64] = "\x9e\xa4",
  [0x1d65] = "\x9e\xa5", [0x1d66] = "\x9e\xa6", [0x1d67] = "\x9e\xa7",
  [0x1d68] = "\x9e\xa8", [0x1d69] = "\x9e\xa9", [0x1d6a] = "\x9e\xaa",
  [0x1d6b] = "\x9e\xab", [0x1d6c] = "\x9e\xac", [0x1d6d] = "\x9e\xad",
  [0x1d6e] = "\x9e\xae", [0x1d6f] = "\x9e\xaf", [0x1d70] = "\x9e\xb0",
  [0x1d71] = "\x9e\xb1", [0x1d72] = "\x9e\xb2", [0x1d73] = "\x9e\xb3",
  [0x1d74] = "\x9e\xb4", [0x1d75] = "\x9e\xb5", [0x1d76] = "\x9e\xb6",
  [0x1d77] = "\x9e\xb7", [0x1d78] = "\x9e\xb8", [0x1d79] = "\x9e\xb9",
  [0x1d7a] = "\x9e\xba", [0x1d7b] = "\x9e\xbb", [0x1d7c] = "\x9e\xbc",
  [0x1d7d] = "\x9e\xbd", [0x1d7e] = "\x9e\xbe", [0x1d7f] = "\x9e\xbf",
  [0x1d80] = "\x9e\xc0", [0x1d81] = "\x9e\xc1", [0x1d82] = "\x9e\xc2",
  [0x1d83] = "\x9e\xc3", [0x1d84] = "\x9e\xc4", [0x1d85] = "\x9e\xc5",
  [0x1d86] = "\x9e\xc6", [0x1d87] = "\x9e\xc7", [0x1d88] = "\x9e\xc8",
  [0x1d89] = "\x9e\xc9", [0x1d8a] = "\x9e\xca", [0x1d8b] = "\x9e\xcb",
  [0x1d8c] = "\x9e\xcc", [0x1d8d] = "\x9e\xcd", [0x1d8e] = "\x9e\xce",
  [0x1d8f] = "\x9e\xcf", [0x1d90] = "\x9e\xd0", [0x1d91] = "\x9e\xd1",
  [0x1d92] = "\x9e\xd2", [0x1d93] = "\x9e\xd3", [0x1d94] = "\x9e\xd4",
  [0x1d95] = "\x9e\xd5", [0x1d96] = "\x9e\xd6", [0x1d97] = "\x9e\xd7",
  [0x1d98] = "\x9e\xd8", [0x1d99] = "\x9e\xd9", [0x1d9a] = "\x9e\xda",
  [0x1d9b] = "\x9e\xdb", [0x1d9c] = "\x9e\xdc", [0x1d9d] = "\x9e\xdd",
  [0x1d9e] = "\x9e\xde", [0x1d9f] = "\x9e\xdf", [0x1da0] = "\x9e\xe0",
  [0x1da1] = "\x9e\xe1", [0x1da2] = "\x9e\xe2", [0x1da3] = "\x9e\xe3",
  [0x1da4] = "\x9e\xe4", [0x1da5] = "\x9e\xe5", [0x1da6] = "\x9e\xe6",
  [0x1da7] = "\x9e\xe7", [0x1da8] = "\x9e\xe8", [0x1da9] = "\x9e\xe9",
  [0x1daa] = "\x9e\xea", [0x1dab] = "\x9e\xeb", [0x1dac] = "\x9e\xec",
  [0x1dad] = "\x9e\xed", [0x1dae] = "\x9e\xee", [0x1daf] = "\x9e\xef",
  [0x1db0] = "\x9e\xf0", [0x1db1] = "\x9e\xf1", [0x1db2] = "\x9e\xf2",
  [0x1db3] = "\x9e\xf3", [0x1db4] = "\x9e\xf4", [0x1db5] = "\x9e\xf5",
  [0x1db6] = "\x9e\xf6", [0x1db7] = "\x9e\xf7", [0x1db8] = "\x9e\xf8",
  [0x1db9] = "\x9e\xf9", [0x1dba] = "\x9e\xfa", [0x1dbb] = "\x9e\xfb",
  [0x1dbc] = "\x9e\xfc", [0x1dbd] = "\x9e\xfd", [0x1dbe] = "\x9e\xfe",
  [0x1e00] = "\x9f\x40", [0x1e01] = "\x9f\x41", [0x1e02] = "\x9f\x42",
  [0x1e03] = "\x9f\x43", [0x1e04] = "\x9f\x44", [0x1e05] = "\x9f\x45",
  [0x1e06] = "\x9f\x46", [0x1e07] = "\x9f\x47", [0x1e08] = "\x9f\x48",
  [0x1e09] = "\x9f\x49", [0x1e0a] = "\x9f\x4a", [0x1e0b] = "\x9f\x4b",
  [0x1e0c] = "\x9f\x4c", [0x1e0d] = "\x9f\x4d", [0x1e0e] = "\x9f\x4e",
  [0x1e0f] = "\x9f\x4f", [0x1e10] = "\x9f\x50", [0x1e11] = "\x9f\x51",
  [0x1e12] = "\x9f\x52", [0x1e13] = "\x9f\x53", [0x1e14] = "\x9f\x54",
  [0x1e15] = "\x9f\x55", [0x1e16] = "\x9f\x56", [0x1e17] = "\x9f\x57",
  [0x1e18] = "\x9f\x58", [0x1e19] = "\x9f\x59", [0x1e1a] = "\x9f\x5a",
  [0x1e1b] = "\x9f\x5b", [0x1e1c] = "\x9f\x5c", [0x1e1d] = "\x9f\x5d",
  [0x1e1e] = "\x9f\x5e", [0x1e1f] = "\x9f\x5f", [0x1e20] = "\x9f\x60",
  [0x1e21] = "\x9f\x61", [0x1e22] = "\x9f\x62", [0x1e23] = "\x9f\x63",
  [0x1e24] = "\x9f\x64", [0x1e25] = "\x9f\x65", [0x1e26] = "\x9f\x66",
  [0x1e27] = "\x9f\x67", [0x1e28] = "\x9f\x68", [0x1e29] = "\x9f\x69",
  [0x1e2a] = "\x9f\x6a", [0x1e2b] = "\x9f\x6b", [0x1e2c] = "\x9f\x6c",
  [0x1e2d] = "\x9f\x6d", [0x1e2e] = "\x9f\x6e", [0x1e2f] = "\x9f\x6f",
  [0x1e30] = "\x9f\x70", [0x1e31] = "\x9f\x71", [0x1e32] = "\x9f\x72",
  [0x1e33] = "\x9f\x73", [0x1e34] = "\x9f\x74", [0x1e35] = "\x9f\x75",
  [0x1e36] = "\x9f\x76", [0x1e37] = "\x9f\x77", [0x1e38] = "\x9f\x78",
  [0x1e39] = "\x9f\x79", [0x1e3a] = "\x9f\x7a", [0x1e3b] = "\x9f\x7b",
  [0x1e3c] = "\x9f\x7c", [0x1e3d] = "\x9f\x7d", [0x1e3e] = "\x9f\x7e",
  [0x1e40] = "\x9f\x80", [0x1e41] = "\x9f\x81", [0x1e42] = "\x9f\x82",
  [0x1e43] = "\x9f\x83", [0x1e44] = "\x9f\x84", [0x1e45] = "\x9f\x85",
  [0x1e46] = "\x9f\x86", [0x1e47] = "\x9f\x87", [0x1e48] = "\x9f\x88",
  [0x1e49] = "\x9f\x89", [0x1e4a] = "\x9f\x8a", [0x1e4b] = "\x9f\x8b",
  [0x1e4c] = "\x9f\x8c", [0x1e4d] = "\x9f\x8d", [0x1e4e] = "\x9f\x8e",
  [0x1e4f] = "\x9f\x8f", [0x1e50] = "\x9f\x90", [0x1e51] = "\x9f\x91",
  [0x1e52] = "\x9f\x92", [0x1e53] = "\x9f\x93", [0x1e54] = "\x9f\x94",
  [0x1e55] = "\x9f\x95", [0x1e56] = "\x9f\x96", [0x1e57] = "\x9f\x97",
  [0x1e58] = "\x9f\x98", [0x1e59] = "\x9f\x99", [0x1e5a] = "\x9f\x9a",
  [0x1e5b] = "\x9f\x9b", [0x1e5c] = "\x9f\x9c", [0x1e5d] = "\x9f\x9d",
  [0x1e5e] = "\x9f\x9e", [0x1e5f] = "\x9f\x9f", [0x1e60] = "\x9f\xa0",
  [0x1e61] = "\x9f\xa1", [0x1e62] = "\x9f\xa2", [0x1e63] = "\x9f\xa3",
  [0x1e64] = "\x9f\xa4", [0x1e65] = "\x9f\xa5", [0x1e66] = "\x9f\xa6",
  [0x1e67] = "\x9f\xa7", [0x1e68] = "\x9f\xa8", [0x1e69] = "\x9f\xa9",
  [0x1e6a] = "\x9f\xaa", [0x1e6b] = "\x9f\xab", [0x1e6c] = "\x9f\xac",
  [0x1e6d] = "\x9f\xad", [0x1e6e] = "\x9f\xae", [0x1e6f] = "\x9f\xaf",
  [0x1e70] = "\x9f\xb0", [0x1e71] = "\x9f\xb1", [0x1e72] = "\x9f\xb2",
  [0x1e73] = "\x9f\xb3", [0x1e74] = "\x9f\xb4", [0x1e75] = "\x9f\xb5",
  [0x1e76] = "\x9f\xb6", [0x1e77] = "\x9f\xb7", [0x1e78] = "\x9f\xb8",
  [0x1e79] = "\x9f\xb9", [0x1e7a] = "\x9f\xba", [0x1e7b] = "\x9f\xbb",
  [0x1e7c] = "\x9f\xbc", [0x1e7d] = "\x9f\xbd", [0x1e7e] = "\x9f\xbe",
  [0x1e7f] = "\x9f\xbf", [0x1e80] = "\x9f\xc0", [0x1e81] = "\x9f\xc1",
  [0x1e82] = "\x9f\xc2", [0x1e83] = "\x9f\xc3", [0x1e84] = "\x9f\xc4",
  [0x1e85] = "\x9f\xc5", [0x1e86] = "\x9f\xc6", [0x1e87] = "\x9f\xc7",
  [0x1e88] = "\x9f\xc8", [0x1e89] = "\x9f\xc9", [0x1e8a] = "\x9f\xca",
  [0x1e8b] = "\x9f\xcb", [0x1e8c] = "\x9f\xcc", [0x1e8d] = "\x9f\xcd",
  [0x1e8e] = "\x9f\xce", [0x1e8f] = "\x9f\xcf", [0x1e90] = "\x9f\xd0",
  [0x1e91] = "\x9f\xd1", [0x1e92] = "\x9f\xd2", [0x1e93] = "\x9f\xd3",
  [0x1e94] = "\x9f\xd4", [0x1e95] = "\x9f\xd5", [0x1e96] = "\x9f\xd6",
  [0x1e97] = "\x9f\xd7", [0x1e98] = "\x9f\xd8", [0x1e99] = "\x9f\xd9",
  [0x1e9a] = "\x9f\xda", [0x1e9b] = "\x9f\xdb", [0x1e9c] = "\x9f\xdc",
  [0x1e9d] = "\x9f\xdd", [0x1e9e] = "\x9f\xde", [0x1e9f] = "\x9f\xdf",
  [0x1ea0] = "\x9f\xe0", [0x1ea1] = "\x9f\xe1", [0x1ea2] = "\x9f\xe2",
  [0x1ea3] = "\x9f\xe3", [0x1ea4] = "\x9f\xe4", [0x1ea5] = "\x9f\xe5",
  [0x1ea6] = "\x9f\xe6", [0x1ea7] = "\x9f\xe7", [0x1ea8] = "\x9f\xe8",
  [0x1ea9] = "\x9f\xe9", [0x1eaa] = "\x9f\xea", [0x1eab] = "\x9f\xeb",
  [0x1eac] = "\x9f\xec", [0x1ead] = "\x9f\xed", [0x1eae] = "\x9f\xee",
  [0x1eaf] = "\x9f\xef", [0x1eb0] = "\x9f\xf0", [0x1eb1] = "\x9f\xf1",
  [0x1eb2] = "\x9f\xf2", [0x1eb3] = "\x9f\xf3", [0x1eb4] = "\x9f\xf4",
  [0x1eb5] = "\x9f\xf5", [0x1eb6] = "\x9f\xf6", [0x1eb7] = "\x9f\xf7",
  [0x1eb8] = "\x9f\xf8", [0x1eb9] = "\x9f\xf9", [0x1eba] = "\x9f\xfa",
  [0x1ebb] = "\x9f\xfb", [0x1ebc] = "\x9f\xfc", [0x1ebd] = "\x9f\xfd",
  [0x1ebe] = "\x9f\xfe"
};


/* Definitions used in the body of the `gconv' function.  */
#define CHARSET_NAME		"TRANSSIBERIAN//"
#define FROM_LOOP		from_transsiberian
#define TO_LOOP			to_transsiberian
#define DEFINE_INIT		1
#define DEFINE_FINI		1
#define MIN_NEEDED_FROM		1
#define MAX_NEEDED_FROM		2
#define MIN_NEEDED_TO		4

/* First define the conversion function from TRANSSIBERIAN to UCS4.  */
#define MIN_NEEDED_INPUT	MIN_NEEDED_FROM
#define MAX_NEEDED_INPUT	MAX_NEEDED_FROM
#define MIN_NEEDED_OUTPUT	MIN_NEEDED_TO
#define LOOPFCT			FROM_LOOP
#define BODY \
  {									      \
    uint32_t ch = *inptr;						      \
									      \
    if ((ch <= 0x7f) || (ch >= 0xa0 && ch <=0xff))			      \
      {									      \
	ch = to_ucs4_single[ch];					      \
      	++inptr;							      \
      }									      \
    else if (ch == 0x80)                                                      \
      {                                                                       \
        /* Illegal single-byte characters */  				      \
        result = __GCONV_ILLEGAL_INPUT;                                       \
        break;                                                                \
      }                                                                       \
    else								      \
      {									      \
	/* Two-byte character.  First test whether the next character	      \
	   is also available.  */					      \
	uint32_t ch2;							      \
	uint_fast32_t idx;						      \
								              \
	if (inptr + 1 >= inend)						      \
	  {								      \
	    /* The second character is not available.  Store		      \
	       the intermediate result.  */				      \
	    result = __GCONV_INCOMPLETE_INPUT;				      \
	    break;							      \
	  }								      \
									      \
	ch2 = inptr[1];							      \
	idx = ch * 256 + ch2;						      \
        if (((ch >= 0x81 && ch <= 0x9f) && (ch2 >= 0x00 && ch2 <= 0x3f)) ||   \
            ((ch >= 0x81 && ch <= 0x9f) && (ch2 == 0x7f))                ||   \
            ((ch >= 0x81 && ch <= 0x9f) && (ch2 >= 0xfd && ch2 <= 0xff)))     \
	  {								      \
	    /* This is illegal.  */					      \
	    result = __GCONV_ILLEGAL_INPUT;				      \
	    break;							      \
	  }								      \
	else 								      \
	  {								      \
	    ch = 0;							      \
	    ch = to_ucs4_double[idx - 0x8140];		         	      \
	    inptr += 2;							      \
	  }								      \
        if (ch == 0)                                                          \
          {                                                                   \
            /* No conversion, but valid double-byte characters.  */           \
            result = __GCONV_NOCONV;                                          \
            break;                                                            \
          }                                                                   \
      }									      \
									      \
    *((uint32_t *) outptr)++ = ch;					      \
  }
#include <iconv/loop.c>


/* Next, define the other direction.  */
#define MIN_NEEDED_INPUT	MIN_NEEDED_TO
#define MIN_NEEDED_OUTPUT	MIN_NEEDED_FROM
#define MAX_NEEDED_OUTPUT	MAX_NEEDED_FROM
#define LOOPFCT			TO_LOOP
#define BODY \
  {									      \
    uint32_t ch = *((uint32_t *) inptr);				      \
    const char *cp;							      \
									      \
    if (ch <= 0xff)							      \
        cp = from_ucs4_single[ch];					      \
    else if (ch >= 0x8140 && ch <= 0x9FFE)				      \
        cp = from_ucs4_double[ch - 0x08140];    	         	      \
    else								      \
      {  								      \
	/* Illegal character.  */					      \
	result = __GCONV_ILLEGAL_INPUT;					      \
	break;								      \
      }									      \
									      \
    if (cp[0] == '\0' && ch != 0)					      \
      {									      \
	/* Illegal character.  */					      \
	result = __GCONV_ILLEGAL_INPUT;					      \
	break;								      \
      }									      \
									      \
    *outptr++ = cp[0];							      \
    /* Now test for a possible second byte and write this if possible.  */    \
    if (cp[1] != '\0')							      \
      {									      \
	if (outptr >= outend)						      \
	  {								      \
	    /* The result does not fit into the buffer.  */		      \
	    result = __GCONV_FULL_OUTPUT;				      \
	    break;							      \
	  }								      \
	*outptr++ = cp[1];						      \
      }									      \
									      \
    inptr += 4;								      \
  }
#include <iconv/loop.c>


/* Now define the toplevel functions.  */
#include <iconv/skeleton.c>
