// auto generated tests from cfg/std.cfg
//
// Generated by command:
// ./generate_cfg_tests cfg/std.cfg > generated-cfg-tests-std.cpp
//
// Recommended cppcheck command line:
// $ cppcheck --enable=warning,information --inline-suppr --platform=unix64 generated-cfg-tests-std.cpp
// => 'unmatched suppression' warnings are false negatives.
//

void test__abort__noreturn() {
  int x = 1;
  if (cond) { x=100; abort(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__abort__noreturn() {
  int x = 1;
  if (cond) { x=100; std::abort(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__abs__noreturn() {
  int x = 1;
  if (cond) { x=100; result = abs(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__abs__useretval() {
  // cppcheck-suppress ignoredReturnValue
  abs(arg1);
}

void test__abs__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((abs(arg1) > 10) || (abs(arg1) < 100)) {}
}

void test__abs__leakignore() {
  char *p = malloc(10); *p=0;
  result = abs(p);
  // cppcheck-suppress memleak
}

void test__abs__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = abs(!x);
}

void test__abs__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = abs(x);
}

void test__std__abs__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::abs(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__abs__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::abs(arg1);
}

void test__std__abs__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::abs(arg1) > 10) || (std::abs(arg1) < 100)) {}
}

void test__std__abs__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = std::abs(!x);
}

void test__std__abs__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::abs(x);
}

void test__imaxabs__noreturn() {
  int x = 1;
  if (cond) { x=100; result = imaxabs(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__imaxabs__useretval() {
  // cppcheck-suppress ignoredReturnValue
  imaxabs(arg1);
}

void test__imaxabs__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((imaxabs(arg1) > 10) || (imaxabs(arg1) < 100)) {}
}

void test__imaxabs__leakignore() {
  char *p = malloc(10); *p=0;
  result = imaxabs(p);
  // cppcheck-suppress memleak
}

void test__imaxabs__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = imaxabs(x);
}

void test__std__imaxabs__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::imaxabs(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__imaxabs__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::imaxabs(arg1);
}

void test__std__imaxabs__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::imaxabs(arg1) > 10) || (std::imaxabs(arg1) < 100)) {}
}

void test__std__imaxabs__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::imaxabs(x);
}

void test__std__proj__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::proj(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__proj__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::proj(arg1);
}

void test__std__proj__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::proj(arg1) > 10) || (std::proj(arg1) < 100)) {}
}

void test__std__proj__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::proj(x);
}

void test__cproj__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cproj(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cproj__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cproj(arg1);
}

void test__cproj__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cproj(arg1) > 10) || (cproj(arg1) < 100)) {}
}

void test__cproj__leakignore() {
  char *p = malloc(10); *p=0;
  result = cproj(p);
  // cppcheck-suppress memleak
}

void test__cproj__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cproj(x);
}

void test__cprojf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cprojf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cprojf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cprojf(arg1);
}

void test__cprojf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cprojf(arg1) > 10) || (cprojf(arg1) < 100)) {}
}

void test__cprojf__leakignore() {
  char *p = malloc(10); *p=0;
  result = cprojf(p);
  // cppcheck-suppress memleak
}

void test__cprojf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cprojf(x);
}

void test__cprojl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cprojl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cprojl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cprojl(arg1);
}

void test__cprojl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cprojl(arg1) > 10) || (cprojl(arg1) < 100)) {}
}

void test__cprojl__leakignore() {
  char *p = malloc(10); *p=0;
  result = cprojl(p);
  // cppcheck-suppress memleak
}

void test__cprojl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cprojl(x);
}

void test__creal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = creal(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__creal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  creal(arg1);
}

void test__creal__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((creal(arg1) > 10) || (creal(arg1) < 100)) {}
}

void test__creal__leakignore() {
  char *p = malloc(10); *p=0;
  result = creal(p);
  // cppcheck-suppress memleak
}

void test__creal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = creal(x);
}

void test__crealf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = crealf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__crealf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  crealf(arg1);
}

void test__crealf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((crealf(arg1) > 10) || (crealf(arg1) < 100)) {}
}

void test__crealf__leakignore() {
  char *p = malloc(10); *p=0;
  result = crealf(p);
  // cppcheck-suppress memleak
}

void test__crealf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = crealf(x);
}

void test__creall__noreturn() {
  int x = 1;
  if (cond) { x=100; result = creall(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__creall__useretval() {
  // cppcheck-suppress ignoredReturnValue
  creall(arg1);
}

void test__creall__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((creall(arg1) > 10) || (creall(arg1) < 100)) {}
}

void test__creall__leakignore() {
  char *p = malloc(10); *p=0;
  result = creall(p);
  // cppcheck-suppress memleak
}

void test__creall__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = creall(x);
}

void test__acos__noreturn() {
  int x = 1;
  if (cond) { x=100; result = acos(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__acos__useretval() {
  // cppcheck-suppress ignoredReturnValue
  acos(arg1);
}

void test__acos__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((acos(arg1) > 10) || (acos(arg1) < 100)) {}
}

void test__acos__leakignore() {
  char *p = malloc(10); *p=0;
  result = acos(p);
  // cppcheck-suppress memleak
}

void test__acos__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = acos(x);
}

void test__std__acos__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::acos(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__acos__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::acos(arg1);
}

void test__std__acos__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::acos(arg1) > 10) || (std::acos(arg1) < 100)) {}
}

void test__std__acos__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::acos(x);
}

void test__acosf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = acosf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__acosf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  acosf(arg1);
}

void test__acosf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((acosf(arg1) > 10) || (acosf(arg1) < 100)) {}
}

void test__acosf__leakignore() {
  char *p = malloc(10); *p=0;
  result = acosf(p);
  // cppcheck-suppress memleak
}

void test__acosf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = acosf(x);
}

void test__std__acosf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::acosf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__acosf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::acosf(arg1);
}

void test__std__acosf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::acosf(arg1) > 10) || (std::acosf(arg1) < 100)) {}
}

void test__std__acosf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::acosf(x);
}

void test__acosl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = acosl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__acosl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  acosl(arg1);
}

void test__acosl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((acosl(arg1) > 10) || (acosl(arg1) < 100)) {}
}

void test__acosl__leakignore() {
  char *p = malloc(10); *p=0;
  result = acosl(p);
  // cppcheck-suppress memleak
}

void test__acosl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = acosl(x);
}

void test__std__acosl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::acosl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__acosl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::acosl(arg1);
}

void test__std__acosl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::acosl(arg1) > 10) || (std::acosl(arg1) < 100)) {}
}

void test__std__acosl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::acosl(x);
}

void test__acosh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = acosh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__acosh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  acosh(arg1);
}

void test__acosh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((acosh(arg1) > 10) || (acosh(arg1) < 100)) {}
}

void test__acosh__leakignore() {
  char *p = malloc(10); *p=0;
  result = acosh(p);
  // cppcheck-suppress memleak
}

void test__acosh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = acosh(x);
}

void test__std__acosh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::acosh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__acosh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::acosh(arg1);
}

void test__std__acosh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::acosh(arg1) > 10) || (std::acosh(arg1) < 100)) {}
}

void test__std__acosh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::acosh(x);
}

void test__acoshf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = acoshf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__acoshf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  acoshf(arg1);
}

void test__acoshf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((acoshf(arg1) > 10) || (acoshf(arg1) < 100)) {}
}

void test__acoshf__leakignore() {
  char *p = malloc(10); *p=0;
  result = acoshf(p);
  // cppcheck-suppress memleak
}

void test__acoshf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = acoshf(x);
}

void test__std__acoshf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::acoshf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__acoshf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::acoshf(arg1);
}

void test__std__acoshf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::acoshf(arg1) > 10) || (std::acoshf(arg1) < 100)) {}
}

void test__std__acoshf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::acoshf(x);
}

void test__acoshl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = acoshl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__acoshl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  acoshl(arg1);
}

void test__acoshl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((acoshl(arg1) > 10) || (acoshl(arg1) < 100)) {}
}

void test__acoshl__leakignore() {
  char *p = malloc(10); *p=0;
  result = acoshl(p);
  // cppcheck-suppress memleak
}

void test__acoshl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = acoshl(x);
}

void test__std__acoshl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::acoshl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__acoshl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::acoshl(arg1);
}

void test__std__acoshl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::acoshl(arg1) > 10) || (std::acoshl(arg1) < 100)) {}
}

void test__std__acoshl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::acoshl(x);
}

void test__asctime__noreturn() {
  int x = 1;
  if (cond) { x=100; result = asctime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__asctime__useretval() {
  // cppcheck-suppress ignoredReturnValue
  asctime(arg1);
}

void test__asctime__leakignore() {
  char *p = malloc(10); *p=0;
  result = asctime(p);
  // cppcheck-suppress memleak
}

void test__asctime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = asctime(NULL);
}

void test__asctime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = asctime(x);
}

void test__std__asctime__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::asctime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__asctime__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::asctime(arg1);
}

void test__std__asctime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::asctime(NULL);
}

void test__std__asctime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::asctime(x);
}

void test__assert__leakignore() {
  char *p = malloc(10); *p=0;
  assert(p);
  // cppcheck-suppress memleak
}

void test__assert__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  assert(x);
}

void test__sqrt__noreturn() {
  int x = 1;
  if (cond) { x=100; result = sqrt(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sqrt__useretval() {
  // cppcheck-suppress ignoredReturnValue
  sqrt(arg1);
}

void test__sqrt__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((sqrt(arg1) > 10) || (sqrt(arg1) < 100)) {}
}

void test__sqrt__leakignore() {
  char *p = malloc(10); *p=0;
  result = sqrt(p);
  // cppcheck-suppress memleak
}

void test__sqrt__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = sqrt(x);
}

void test__std__sqrt__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::sqrt(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__sqrt__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::sqrt(arg1);
}

void test__std__sqrt__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::sqrt(arg1) > 10) || (std::sqrt(arg1) < 100)) {}
}

void test__std__sqrt__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::sqrt(x);
}

void test__sqrtf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = sqrtf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sqrtf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  sqrtf(arg1);
}

void test__sqrtf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((sqrtf(arg1) > 10) || (sqrtf(arg1) < 100)) {}
}

void test__sqrtf__leakignore() {
  char *p = malloc(10); *p=0;
  result = sqrtf(p);
  // cppcheck-suppress memleak
}

void test__sqrtf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = sqrtf(x);
}

void test__std__sqrtf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::sqrtf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__sqrtf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::sqrtf(arg1);
}

void test__std__sqrtf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::sqrtf(arg1) > 10) || (std::sqrtf(arg1) < 100)) {}
}

void test__std__sqrtf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::sqrtf(x);
}

void test__sqrtl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = sqrtl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sqrtl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  sqrtl(arg1);
}

void test__sqrtl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((sqrtl(arg1) > 10) || (sqrtl(arg1) < 100)) {}
}

void test__sqrtl__leakignore() {
  char *p = malloc(10); *p=0;
  result = sqrtl(p);
  // cppcheck-suppress memleak
}

void test__sqrtl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = sqrtl(x);
}

void test__std__sqrtl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::sqrtl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__sqrtl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::sqrtl(arg1);
}

void test__std__sqrtl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::sqrtl(arg1) > 10) || (std::sqrtl(arg1) < 100)) {}
}

void test__std__sqrtl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::sqrtl(x);
}

void test__csqrt__noreturn() {
  int x = 1;
  if (cond) { x=100; result = csqrt(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__csqrt__useretval() {
  // cppcheck-suppress ignoredReturnValue
  csqrt(arg1);
}

void test__csqrt__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((csqrt(arg1) > 10) || (csqrt(arg1) < 100)) {}
}

void test__csqrt__leakignore() {
  char *p = malloc(10); *p=0;
  result = csqrt(p);
  // cppcheck-suppress memleak
}

void test__csqrt__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = csqrt(x);
}

void test__csqrtf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = csqrtf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__csqrtf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  csqrtf(arg1);
}

void test__csqrtf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((csqrtf(arg1) > 10) || (csqrtf(arg1) < 100)) {}
}

void test__csqrtf__leakignore() {
  char *p = malloc(10); *p=0;
  result = csqrtf(p);
  // cppcheck-suppress memleak
}

void test__csqrtf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = csqrtf(x);
}

void test__csqrtl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = csqrtl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__csqrtl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  csqrtl(arg1);
}

void test__csqrtl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((csqrtl(arg1) > 10) || (csqrtl(arg1) < 100)) {}
}

void test__csqrtl__leakignore() {
  char *p = malloc(10); *p=0;
  result = csqrtl(p);
  // cppcheck-suppress memleak
}

void test__csqrtl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = csqrtl(x);
}

void test__sinh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = sinh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sinh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  sinh(arg1);
}

void test__sinh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((sinh(arg1) > 10) || (sinh(arg1) < 100)) {}
}

void test__sinh__leakignore() {
  char *p = malloc(10); *p=0;
  result = sinh(p);
  // cppcheck-suppress memleak
}

void test__sinh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = sinh(x);
}

void test__std__sinh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::sinh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__sinh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::sinh(arg1);
}

void test__std__sinh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::sinh(arg1) > 10) || (std::sinh(arg1) < 100)) {}
}

void test__std__sinh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::sinh(x);
}

void test__sinhf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = sinhf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sinhf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  sinhf(arg1);
}

void test__sinhf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((sinhf(arg1) > 10) || (sinhf(arg1) < 100)) {}
}

void test__sinhf__leakignore() {
  char *p = malloc(10); *p=0;
  result = sinhf(p);
  // cppcheck-suppress memleak
}

void test__sinhf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = sinhf(x);
}

void test__std__sinhf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::sinhf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__sinhf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::sinhf(arg1);
}

void test__std__sinhf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::sinhf(arg1) > 10) || (std::sinhf(arg1) < 100)) {}
}

void test__std__sinhf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::sinhf(x);
}

void test__sinhl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = sinhl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sinhl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  sinhl(arg1);
}

void test__sinhl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((sinhl(arg1) > 10) || (sinhl(arg1) < 100)) {}
}

void test__sinhl__leakignore() {
  char *p = malloc(10); *p=0;
  result = sinhl(p);
  // cppcheck-suppress memleak
}

void test__sinhl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = sinhl(x);
}

void test__std__sinhl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::sinhl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__sinhl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::sinhl(arg1);
}

void test__std__sinhl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::sinhl(arg1) > 10) || (std::sinhl(arg1) < 100)) {}
}

void test__std__sinhl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::sinhl(x);
}

void test__sin__noreturn() {
  int x = 1;
  if (cond) { x=100; result = sin(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sin__useretval() {
  // cppcheck-suppress ignoredReturnValue
  sin(arg1);
}

void test__sin__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((sin(arg1) > 10) || (sin(arg1) < 100)) {}
}

void test__sin__leakignore() {
  char *p = malloc(10); *p=0;
  result = sin(p);
  // cppcheck-suppress memleak
}

void test__sin__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = sin(x);
}

void test__std__sin__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::sin(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__sin__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::sin(arg1);
}

void test__std__sin__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::sin(arg1) > 10) || (std::sin(arg1) < 100)) {}
}

void test__std__sin__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::sin(x);
}

void test__sinf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = sinf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sinf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  sinf(arg1);
}

void test__sinf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((sinf(arg1) > 10) || (sinf(arg1) < 100)) {}
}

void test__sinf__leakignore() {
  char *p = malloc(10); *p=0;
  result = sinf(p);
  // cppcheck-suppress memleak
}

void test__sinf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = sinf(x);
}

void test__std__sinf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::sinf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__sinf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::sinf(arg1);
}

void test__std__sinf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::sinf(arg1) > 10) || (std::sinf(arg1) < 100)) {}
}

void test__std__sinf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::sinf(x);
}

void test__sinl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = sinl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sinl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  sinl(arg1);
}

void test__sinl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((sinl(arg1) > 10) || (sinl(arg1) < 100)) {}
}

void test__sinl__leakignore() {
  char *p = malloc(10); *p=0;
  result = sinl(p);
  // cppcheck-suppress memleak
}

void test__sinl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = sinl(x);
}

void test__std__sinl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::sinl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__sinl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::sinl(arg1);
}

void test__std__sinl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::sinl(arg1) > 10) || (std::sinl(arg1) < 100)) {}
}

void test__std__sinl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::sinl(x);
}

void test__csin__noreturn() {
  int x = 1;
  if (cond) { x=100; result = csin(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__csin__useretval() {
  // cppcheck-suppress ignoredReturnValue
  csin(arg1);
}

void test__csin__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((csin(arg1) > 10) || (csin(arg1) < 100)) {}
}

void test__csin__leakignore() {
  char *p = malloc(10); *p=0;
  result = csin(p);
  // cppcheck-suppress memleak
}

void test__csin__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = csin(x);
}

void test__csinf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = csinf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__csinf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  csinf(arg1);
}

void test__csinf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((csinf(arg1) > 10) || (csinf(arg1) < 100)) {}
}

void test__csinf__leakignore() {
  char *p = malloc(10); *p=0;
  result = csinf(p);
  // cppcheck-suppress memleak
}

void test__csinf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = csinf(x);
}

void test__csinl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = csinl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__csinl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  csinl(arg1);
}

void test__csinl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((csinl(arg1) > 10) || (csinl(arg1) < 100)) {}
}

void test__csinl__leakignore() {
  char *p = malloc(10); *p=0;
  result = csinl(p);
  // cppcheck-suppress memleak
}

void test__csinl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = csinl(x);
}

void test__csinh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = csinh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__csinh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  csinh(arg1);
}

void test__csinh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((csinh(arg1) > 10) || (csinh(arg1) < 100)) {}
}

void test__csinh__leakignore() {
  char *p = malloc(10); *p=0;
  result = csinh(p);
  // cppcheck-suppress memleak
}

void test__csinh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = csinh(x);
}

void test__csinhf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = csinhf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__csinhf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  csinhf(arg1);
}

void test__csinhf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((csinhf(arg1) > 10) || (csinhf(arg1) < 100)) {}
}

void test__csinhf__leakignore() {
  char *p = malloc(10); *p=0;
  result = csinhf(p);
  // cppcheck-suppress memleak
}

void test__csinhf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = csinhf(x);
}

void test__csinhl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = csinhl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__csinhl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  csinhl(arg1);
}

void test__csinhl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((csinhl(arg1) > 10) || (csinhl(arg1) < 100)) {}
}

void test__csinhl__leakignore() {
  char *p = malloc(10); *p=0;
  result = csinhl(p);
  // cppcheck-suppress memleak
}

void test__csinhl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = csinhl(x);
}

void test__asin__noreturn() {
  int x = 1;
  if (cond) { x=100; result = asin(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__asin__useretval() {
  // cppcheck-suppress ignoredReturnValue
  asin(arg1);
}

void test__asin__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((asin(arg1) > 10) || (asin(arg1) < 100)) {}
}

void test__asin__leakignore() {
  char *p = malloc(10); *p=0;
  result = asin(p);
  // cppcheck-suppress memleak
}

void test__asin__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = asin(x);
}

void test__std__asin__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::asin(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__asin__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::asin(arg1);
}

void test__std__asin__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::asin(arg1) > 10) || (std::asin(arg1) < 100)) {}
}

void test__std__asin__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::asin(x);
}

void test__asinf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = asinf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__asinf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  asinf(arg1);
}

void test__asinf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((asinf(arg1) > 10) || (asinf(arg1) < 100)) {}
}

void test__asinf__leakignore() {
  char *p = malloc(10); *p=0;
  result = asinf(p);
  // cppcheck-suppress memleak
}

void test__asinf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = asinf(x);
}

void test__std__asinf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::asinf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__asinf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::asinf(arg1);
}

void test__std__asinf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::asinf(arg1) > 10) || (std::asinf(arg1) < 100)) {}
}

void test__std__asinf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::asinf(x);
}

void test__asinl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = asinl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__asinl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  asinl(arg1);
}

void test__asinl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((asinl(arg1) > 10) || (asinl(arg1) < 100)) {}
}

void test__asinl__leakignore() {
  char *p = malloc(10); *p=0;
  result = asinl(p);
  // cppcheck-suppress memleak
}

void test__asinl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = asinl(x);
}

void test__std__asinl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::asinl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__asinl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::asinl(arg1);
}

void test__std__asinl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::asinl(arg1) > 10) || (std::asinl(arg1) < 100)) {}
}

void test__std__asinl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::asinl(x);
}

void test__casin__noreturn() {
  int x = 1;
  if (cond) { x=100; result = casin(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__casin__useretval() {
  // cppcheck-suppress ignoredReturnValue
  casin(arg1);
}

void test__casin__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((casin(arg1) > 10) || (casin(arg1) < 100)) {}
}

void test__casin__leakignore() {
  char *p = malloc(10); *p=0;
  result = casin(p);
  // cppcheck-suppress memleak
}

void test__casin__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = casin(x);
}

void test__casinf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = casinf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__casinf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  casinf(arg1);
}

void test__casinf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((casinf(arg1) > 10) || (casinf(arg1) < 100)) {}
}

void test__casinf__leakignore() {
  char *p = malloc(10); *p=0;
  result = casinf(p);
  // cppcheck-suppress memleak
}

void test__casinf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = casinf(x);
}

void test__casinl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = casinl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__casinl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  casinl(arg1);
}

void test__casinl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((casinl(arg1) > 10) || (casinl(arg1) < 100)) {}
}

void test__casinl__leakignore() {
  char *p = malloc(10); *p=0;
  result = casinl(p);
  // cppcheck-suppress memleak
}

void test__casinl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = casinl(x);
}

void test__asinh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = asinh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__asinh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  asinh(arg1);
}

void test__asinh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((asinh(arg1) > 10) || (asinh(arg1) < 100)) {}
}

void test__asinh__leakignore() {
  char *p = malloc(10); *p=0;
  result = asinh(p);
  // cppcheck-suppress memleak
}

void test__asinh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = asinh(x);
}

void test__std__asinh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::asinh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__asinh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::asinh(arg1);
}

void test__std__asinh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::asinh(arg1) > 10) || (std::asinh(arg1) < 100)) {}
}

void test__std__asinh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::asinh(x);
}

void test__asinhf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = asinhf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__asinhf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  asinhf(arg1);
}

void test__asinhf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((asinhf(arg1) > 10) || (asinhf(arg1) < 100)) {}
}

void test__asinhf__leakignore() {
  char *p = malloc(10); *p=0;
  result = asinhf(p);
  // cppcheck-suppress memleak
}

void test__asinhf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = asinhf(x);
}

void test__std__asinhf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::asinhf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__asinhf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::asinhf(arg1);
}

void test__std__asinhf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::asinhf(arg1) > 10) || (std::asinhf(arg1) < 100)) {}
}

void test__std__asinhf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::asinhf(x);
}

void test__asinhl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = asinhl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__asinhl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  asinhl(arg1);
}

void test__asinhl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((asinhl(arg1) > 10) || (asinhl(arg1) < 100)) {}
}

void test__asinhl__leakignore() {
  char *p = malloc(10); *p=0;
  result = asinhl(p);
  // cppcheck-suppress memleak
}

void test__asinhl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = asinhl(x);
}

void test__std__asinhl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::asinhl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__asinhl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::asinhl(arg1);
}

void test__std__asinhl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::asinhl(arg1) > 10) || (std::asinhl(arg1) < 100)) {}
}

void test__std__asinhl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::asinhl(x);
}

void test__casinh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = casinh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__casinh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  casinh(arg1);
}

void test__casinh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((casinh(arg1) > 10) || (casinh(arg1) < 100)) {}
}

void test__casinh__leakignore() {
  char *p = malloc(10); *p=0;
  result = casinh(p);
  // cppcheck-suppress memleak
}

void test__casinh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = casinh(x);
}

void test__casinhf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = casinhf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__casinhf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  casinhf(arg1);
}

void test__casinhf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((casinhf(arg1) > 10) || (casinhf(arg1) < 100)) {}
}

void test__casinhf__leakignore() {
  char *p = malloc(10); *p=0;
  result = casinhf(p);
  // cppcheck-suppress memleak
}

void test__casinhf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = casinhf(x);
}

void test__casinhl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = casinhl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__casinhl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  casinhl(arg1);
}

void test__casinhl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((casinhl(arg1) > 10) || (casinhl(arg1) < 100)) {}
}

void test__casinhl__leakignore() {
  char *p = malloc(10); *p=0;
  result = casinhl(p);
  // cppcheck-suppress memleak
}

void test__casinhl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = casinhl(x);
}

void test__wcsftime__noreturn() {
  int x = 1;
  if (cond) { x=100; wcsftime(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcsftime__pure(int arg1,int arg2,int arg3,int arg4) {
  // cppcheck-suppress incorrectLogicOperator
  if ((wcsftime(arg1, arg2, arg3, arg4) > 10) || (wcsftime(arg1, arg2, arg3, arg4) < 100)) {}
}

void test__wcsftime__leakignore() {
  char *p = malloc(10); *p=0;
  wcsftime(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__wcsftime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wcsftime(NULL, arg2, arg3, arg4);
}

void test__wcsftime__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcsftime(arg1, x, arg3, arg4);
}

void test__wcsftime__arg3__notnull() {
  // cppcheck-suppress nullPointer
  wcsftime(arg1, arg2, NULL, arg4);
}

void test__wcsftime__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcsftime(arg1, arg2, x, arg4);
}

void test__wcsftime__arg4__notnull() {
  // cppcheck-suppress nullPointer
  wcsftime(arg1, arg2, arg3, NULL);
}

void test__wcsftime__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcsftime(arg1, arg2, arg3, x);
}

void test__std__wcsftime__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wcsftime(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcsftime__pure(int arg1,int arg2,int arg3,int arg4) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::wcsftime(arg1, arg2, arg3, arg4) > 10) || (std::wcsftime(arg1, arg2, arg3, arg4) < 100)) {}
}

void test__std__wcsftime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::wcsftime(NULL, arg2, arg3, arg4);
}

void test__std__wcsftime__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wcsftime(arg1, x, arg3, arg4);
}

void test__std__wcsftime__arg3__notnull() {
  // cppcheck-suppress nullPointer
  std::wcsftime(arg1, arg2, NULL, arg4);
}

void test__std__wcsftime__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcsftime(arg1, arg2, x, arg4);
}

void test__std__wcsftime__arg4__notnull() {
  // cppcheck-suppress nullPointer
  std::wcsftime(arg1, arg2, arg3, NULL);
}

void test__std__wcsftime__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcsftime(arg1, arg2, arg3, x);
}

void test__tan__noreturn() {
  int x = 1;
  if (cond) { x=100; result = tan(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tan__useretval() {
  // cppcheck-suppress ignoredReturnValue
  tan(arg1);
}

void test__tan__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((tan(arg1) > 10) || (tan(arg1) < 100)) {}
}

void test__tan__leakignore() {
  char *p = malloc(10); *p=0;
  result = tan(p);
  // cppcheck-suppress memleak
}

void test__tan__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = tan(x);
}

void test__std__tan__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::tan(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__tan__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::tan(arg1);
}

void test__std__tan__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::tan(arg1) > 10) || (std::tan(arg1) < 100)) {}
}

void test__std__tan__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::tan(x);
}

void test__tanf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = tanf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tanf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  tanf(arg1);
}

void test__tanf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((tanf(arg1) > 10) || (tanf(arg1) < 100)) {}
}

void test__tanf__leakignore() {
  char *p = malloc(10); *p=0;
  result = tanf(p);
  // cppcheck-suppress memleak
}

void test__tanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = tanf(x);
}

void test__std__tanf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::tanf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__tanf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::tanf(arg1);
}

void test__std__tanf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::tanf(arg1) > 10) || (std::tanf(arg1) < 100)) {}
}

void test__std__tanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::tanf(x);
}

void test__tanl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = tanl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tanl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  tanl(arg1);
}

void test__tanl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((tanl(arg1) > 10) || (tanl(arg1) < 100)) {}
}

void test__tanl__leakignore() {
  char *p = malloc(10); *p=0;
  result = tanl(p);
  // cppcheck-suppress memleak
}

void test__tanl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = tanl(x);
}

void test__std__tanl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::tanl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__tanl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::tanl(arg1);
}

void test__std__tanl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::tanl(arg1) > 10) || (std::tanl(arg1) < 100)) {}
}

void test__std__tanl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::tanl(x);
}

void test__ctan__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ctan(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ctan__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ctan(arg1);
}

void test__ctan__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ctan(arg1) > 10) || (ctan(arg1) < 100)) {}
}

void test__ctan__leakignore() {
  char *p = malloc(10); *p=0;
  result = ctan(p);
  // cppcheck-suppress memleak
}

void test__ctan__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ctan(x);
}

void test__ctanf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ctanf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ctanf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ctanf(arg1);
}

void test__ctanf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ctanf(arg1) > 10) || (ctanf(arg1) < 100)) {}
}

void test__ctanf__leakignore() {
  char *p = malloc(10); *p=0;
  result = ctanf(p);
  // cppcheck-suppress memleak
}

void test__ctanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ctanf(x);
}

void test__ctanl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ctanl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ctanl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ctanl(arg1);
}

void test__ctanl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ctanl(arg1) > 10) || (ctanl(arg1) < 100)) {}
}

void test__ctanl__leakignore() {
  char *p = malloc(10); *p=0;
  result = ctanl(p);
  // cppcheck-suppress memleak
}

void test__ctanl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ctanl(x);
}

void test__tanh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = tanh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tanh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  tanh(arg1);
}

void test__tanh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((tanh(arg1) > 10) || (tanh(arg1) < 100)) {}
}

void test__tanh__leakignore() {
  char *p = malloc(10); *p=0;
  result = tanh(p);
  // cppcheck-suppress memleak
}

void test__tanh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = tanh(x);
}

void test__std__tanh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::tanh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__tanh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::tanh(arg1);
}

void test__std__tanh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::tanh(arg1) > 10) || (std::tanh(arg1) < 100)) {}
}

void test__std__tanh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::tanh(x);
}

void test__tanhf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = tanhf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tanhf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  tanhf(arg1);
}

void test__tanhf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((tanhf(arg1) > 10) || (tanhf(arg1) < 100)) {}
}

void test__tanhf__leakignore() {
  char *p = malloc(10); *p=0;
  result = tanhf(p);
  // cppcheck-suppress memleak
}

void test__tanhf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = tanhf(x);
}

void test__std__tanhf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::tanhf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__tanhf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::tanhf(arg1);
}

void test__std__tanhf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::tanhf(arg1) > 10) || (std::tanhf(arg1) < 100)) {}
}

void test__std__tanhf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::tanhf(x);
}

void test__tanhl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = tanhl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tanhl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  tanhl(arg1);
}

void test__tanhl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((tanhl(arg1) > 10) || (tanhl(arg1) < 100)) {}
}

void test__tanhl__leakignore() {
  char *p = malloc(10); *p=0;
  result = tanhl(p);
  // cppcheck-suppress memleak
}

void test__tanhl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = tanhl(x);
}

void test__std__tanhl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::tanhl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__tanhl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::tanhl(arg1);
}

void test__std__tanhl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::tanhl(arg1) > 10) || (std::tanhl(arg1) < 100)) {}
}

void test__std__tanhl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::tanhl(x);
}

void test__ctanh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ctanh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ctanh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ctanh(arg1);
}

void test__ctanh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ctanh(arg1) > 10) || (ctanh(arg1) < 100)) {}
}

void test__ctanh__leakignore() {
  char *p = malloc(10); *p=0;
  result = ctanh(p);
  // cppcheck-suppress memleak
}

void test__ctanh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ctanh(x);
}

void test__ctanhf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ctanhf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ctanhf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ctanhf(arg1);
}

void test__ctanhf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ctanhf(arg1) > 10) || (ctanhf(arg1) < 100)) {}
}

void test__ctanhf__leakignore() {
  char *p = malloc(10); *p=0;
  result = ctanhf(p);
  // cppcheck-suppress memleak
}

void test__ctanhf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ctanhf(x);
}

void test__ctanhl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ctanhl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ctanhl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ctanhl(arg1);
}

void test__ctanhl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ctanhl(arg1) > 10) || (ctanhl(arg1) < 100)) {}
}

void test__ctanhl__leakignore() {
  char *p = malloc(10); *p=0;
  result = ctanhl(p);
  // cppcheck-suppress memleak
}

void test__ctanhl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ctanhl(x);
}

void test__feclearexcept__noreturn() {
  int x = 1;
  if (cond) { x=100; feclearexcept(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__feclearexcept__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((feclearexcept(arg1) > 10) || (feclearexcept(arg1) < 100)) {}
}

void test__feclearexcept__leakignore() {
  char *p = malloc(10); *p=0;
  feclearexcept(p);
  // cppcheck-suppress memleak
}

void test__feclearexcept__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  feclearexcept(x);
}

void test__std__feclearexcept__noreturn() {
  int x = 1;
  if (cond) { x=100; std::feclearexcept(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__feclearexcept__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::feclearexcept(arg1) > 10) || (std::feclearexcept(arg1) < 100)) {}
}

void test__std__feclearexcept__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::feclearexcept(x);
}

void test__fegetenv__noreturn() {
  int x = 1;
  if (cond) { x=100; fegetenv(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fegetenv__leakignore() {
  char *p = malloc(10); *p=0;
  fegetenv(p);
  // cppcheck-suppress memleak
}

void test__fegetenv__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fegetenv(NULL);
}

void test__std__fegetenv__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fegetenv(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fegetenv__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fegetenv(NULL);
}

void test__fegetexceptflag__noreturn() {
  int x = 1;
  if (cond) { x=100; fegetexceptflag(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fegetexceptflag__leakignore() {
  char *p = malloc(10); *p=0;
  fegetexceptflag(p, arg2);
  // cppcheck-suppress memleak
}

void test__fegetexceptflag__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fegetexceptflag(NULL, arg2);
}

void test__fegetexceptflag__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fegetexceptflag(arg1, x);
}

void test__std__fegetexceptflag__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fegetexceptflag(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fegetexceptflag__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fegetexceptflag(NULL, arg2);
}

void test__std__fegetexceptflag__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fegetexceptflag(arg1, x);
}

void test__fegetround__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fegetround(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fegetround__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fegetround();
}

void test__fegetround__pure() {
  // cppcheck-suppress incorrectLogicOperator
  if ((fegetround() > 10) || (fegetround() < 100)) {}
}

void test__fegetround__leakignore() {
  char *p = malloc(10); *p=0;
  result = fegetround();
  // cppcheck-suppress memleak
}

void test__std__fegetround__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fegetround(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fegetround__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fegetround();
}

void test__std__fegetround__pure() {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fegetround() > 10) || (std::fegetround() < 100)) {}
}

void test__feholdexcept__noreturn() {
  int x = 1;
  if (cond) { x=100; feholdexcept(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__feholdexcept__leakignore() {
  char *p = malloc(10); *p=0;
  feholdexcept(p);
  // cppcheck-suppress memleak
}

void test__feholdexcept__arg1__notnull() {
  // cppcheck-suppress nullPointer
  feholdexcept(NULL);
}

void test__std__feholdexcept__noreturn() {
  int x = 1;
  if (cond) { x=100; std::feholdexcept(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__feholdexcept__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::feholdexcept(NULL);
}

void test__feraiseexcept__noreturn() {
  int x = 1;
  if (cond) { x=100; feraiseexcept(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__feraiseexcept__leakignore() {
  char *p = malloc(10); *p=0;
  feraiseexcept(p);
  // cppcheck-suppress memleak
}

void test__feraiseexcept__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  feraiseexcept(x);
}

void test__std__feraiseexcept__noreturn() {
  int x = 1;
  if (cond) { x=100; std::feraiseexcept(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__feraiseexcept__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::feraiseexcept(x);
}

void test__fesetenv__noreturn() {
  int x = 1;
  if (cond) { x=100; fesetenv(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fesetenv__leakignore() {
  char *p = malloc(10); *p=0;
  fesetenv(p);
  // cppcheck-suppress memleak
}

void test__fesetenv__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fesetenv(NULL);
}

void test__fesetenv__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fesetenv(x);
}

void test__std__fesetenv__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fesetenv(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fesetenv__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fesetenv(NULL);
}

void test__std__fesetenv__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fesetenv(x);
}

void test__fesetexceptflag__noreturn() {
  int x = 1;
  if (cond) { x=100; fesetexceptflag(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fesetexceptflag__leakignore() {
  char *p = malloc(10); *p=0;
  fesetexceptflag(p, arg2);
  // cppcheck-suppress memleak
}

void test__fesetexceptflag__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fesetexceptflag(NULL, arg2);
}

void test__fesetexceptflag__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fesetexceptflag(x, arg2);
}

void test__fesetexceptflag__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fesetexceptflag(arg1, x);
}

void test__std__fesetexceptflag__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fesetexceptflag(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fesetexceptflag__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fesetexceptflag(NULL, arg2);
}

void test__std__fesetexceptflag__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fesetexceptflag(x, arg2);
}

void test__std__fesetexceptflag__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fesetexceptflag(arg1, x);
}

void test__fesetround__noreturn() {
  int x = 1;
  if (cond) { x=100; fesetround(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fesetround__leakignore() {
  char *p = malloc(10); *p=0;
  fesetround(p);
  // cppcheck-suppress memleak
}

void test__fesetround__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fesetround(x);
}

void test__std__fesetround__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fesetround(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fesetround__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fesetround(x);
}

void test__fetestexcept__noreturn() {
  int x = 1;
  if (cond) { x=100; fetestexcept(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fetestexcept__leakignore() {
  char *p = malloc(10); *p=0;
  fetestexcept(p);
  // cppcheck-suppress memleak
}

void test__fetestexcept__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fetestexcept(x);
}

void test__std__fetestexcept__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fetestexcept(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fetestexcept__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fetestexcept(x);
}

void test__feupdateenv__noreturn() {
  int x = 1;
  if (cond) { x=100; feupdateenv(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__feupdateenv__leakignore() {
  char *p = malloc(10); *p=0;
  feupdateenv(p);
  // cppcheck-suppress memleak
}

void test__feupdateenv__arg1__notnull() {
  // cppcheck-suppress nullPointer
  feupdateenv(NULL);
}

void test__feupdateenv__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  feupdateenv(x);
}

void test__std__feupdateenv__noreturn() {
  int x = 1;
  if (cond) { x=100; std::feupdateenv(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__feupdateenv__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::feupdateenv(NULL);
}

void test__std__feupdateenv__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::feupdateenv(x);
}

void test__atan__noreturn() {
  int x = 1;
  if (cond) { x=100; result = atan(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__atan__useretval() {
  // cppcheck-suppress ignoredReturnValue
  atan(arg1);
}

void test__atan__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((atan(arg1) > 10) || (atan(arg1) < 100)) {}
}

void test__atan__leakignore() {
  char *p = malloc(10); *p=0;
  result = atan(p);
  // cppcheck-suppress memleak
}

void test__atan__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = atan(x);
}

void test__std__atan__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::atan(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__atan__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::atan(arg1);
}

void test__std__atan__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::atan(arg1) > 10) || (std::atan(arg1) < 100)) {}
}

void test__std__atan__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::atan(x);
}

void test__atanf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = atanf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__atanf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  atanf(arg1);
}

void test__atanf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((atanf(arg1) > 10) || (atanf(arg1) < 100)) {}
}

void test__atanf__leakignore() {
  char *p = malloc(10); *p=0;
  result = atanf(p);
  // cppcheck-suppress memleak
}

void test__atanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = atanf(x);
}

void test__std__atanf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::atanf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__atanf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::atanf(arg1);
}

void test__std__atanf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::atanf(arg1) > 10) || (std::atanf(arg1) < 100)) {}
}

void test__std__atanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::atanf(x);
}

void test__atanl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = atanl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__atanl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  atanl(arg1);
}

void test__atanl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((atanl(arg1) > 10) || (atanl(arg1) < 100)) {}
}

void test__atanl__leakignore() {
  char *p = malloc(10); *p=0;
  result = atanl(p);
  // cppcheck-suppress memleak
}

void test__atanl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = atanl(x);
}

void test__std__atanl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::atanl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__atanl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::atanl(arg1);
}

void test__std__atanl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::atanl(arg1) > 10) || (std::atanl(arg1) < 100)) {}
}

void test__std__atanl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::atanl(x);
}

void test__catan__noreturn() {
  int x = 1;
  if (cond) { x=100; result = catan(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__catan__useretval() {
  // cppcheck-suppress ignoredReturnValue
  catan(arg1);
}

void test__catan__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((catan(arg1) > 10) || (catan(arg1) < 100)) {}
}

void test__catan__leakignore() {
  char *p = malloc(10); *p=0;
  result = catan(p);
  // cppcheck-suppress memleak
}

void test__catan__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = catan(x);
}

void test__catanf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = catanf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__catanf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  catanf(arg1);
}

void test__catanf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((catanf(arg1) > 10) || (catanf(arg1) < 100)) {}
}

void test__catanf__leakignore() {
  char *p = malloc(10); *p=0;
  result = catanf(p);
  // cppcheck-suppress memleak
}

void test__catanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = catanf(x);
}

void test__catanl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = catanl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__catanl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  catanl(arg1);
}

void test__catanl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((catanl(arg1) > 10) || (catanl(arg1) < 100)) {}
}

void test__catanl__leakignore() {
  char *p = malloc(10); *p=0;
  result = catanl(p);
  // cppcheck-suppress memleak
}

void test__catanl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = catanl(x);
}

void test__tgamma__noreturn() {
  int x = 1;
  if (cond) { x=100; result = tgamma(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tgamma__useretval() {
  // cppcheck-suppress ignoredReturnValue
  tgamma(arg1);
}

void test__tgamma__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((tgamma(arg1) > 10) || (tgamma(arg1) < 100)) {}
}

void test__tgamma__leakignore() {
  char *p = malloc(10); *p=0;
  result = tgamma(p);
  // cppcheck-suppress memleak
}

void test__tgamma__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = tgamma(x);
}

void test__std__tgamma__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::tgamma(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__tgamma__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::tgamma(arg1);
}

void test__std__tgamma__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::tgamma(arg1) > 10) || (std::tgamma(arg1) < 100)) {}
}

void test__std__tgamma__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::tgamma(x);
}

void test__tgammaf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = tgammaf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tgammaf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  tgammaf(arg1);
}

void test__tgammaf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((tgammaf(arg1) > 10) || (tgammaf(arg1) < 100)) {}
}

void test__tgammaf__leakignore() {
  char *p = malloc(10); *p=0;
  result = tgammaf(p);
  // cppcheck-suppress memleak
}

void test__tgammaf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = tgammaf(x);
}

void test__std__tgammaf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::tgammaf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__tgammaf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::tgammaf(arg1);
}

void test__std__tgammaf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::tgammaf(arg1) > 10) || (std::tgammaf(arg1) < 100)) {}
}

void test__std__tgammaf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::tgammaf(x);
}

void test__tgammal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = tgammal(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tgammal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  tgammal(arg1);
}

void test__tgammal__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((tgammal(arg1) > 10) || (tgammal(arg1) < 100)) {}
}

void test__tgammal__leakignore() {
  char *p = malloc(10); *p=0;
  result = tgammal(p);
  // cppcheck-suppress memleak
}

void test__tgammal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = tgammal(x);
}

void test__std__tgammal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::tgammal(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__tgammal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::tgammal(arg1);
}

void test__std__tgammal__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::tgammal(arg1) > 10) || (std::tgammal(arg1) < 100)) {}
}

void test__std__tgammal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::tgammal(x);
}

void test__trunc__noreturn() {
  int x = 1;
  if (cond) { x=100; result = trunc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__trunc__useretval() {
  // cppcheck-suppress ignoredReturnValue
  trunc(arg1);
}

void test__trunc__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((trunc(arg1) > 10) || (trunc(arg1) < 100)) {}
}

void test__trunc__leakignore() {
  char *p = malloc(10); *p=0;
  result = trunc(p);
  // cppcheck-suppress memleak
}

void test__trunc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = trunc(x);
}

void test__std__trunc__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::trunc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__trunc__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::trunc(arg1);
}

void test__std__trunc__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::trunc(arg1) > 10) || (std::trunc(arg1) < 100)) {}
}

void test__std__trunc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::trunc(x);
}

void test__truncf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = truncf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__truncf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  truncf(arg1);
}

void test__truncf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((truncf(arg1) > 10) || (truncf(arg1) < 100)) {}
}

void test__truncf__leakignore() {
  char *p = malloc(10); *p=0;
  result = truncf(p);
  // cppcheck-suppress memleak
}

void test__truncf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = truncf(x);
}

void test__std__truncf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::truncf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__truncf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::truncf(arg1);
}

void test__std__truncf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::truncf(arg1) > 10) || (std::truncf(arg1) < 100)) {}
}

void test__std__truncf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::truncf(x);
}

void test__truncl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = truncl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__truncl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  truncl(arg1);
}

void test__truncl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((truncl(arg1) > 10) || (truncl(arg1) < 100)) {}
}

void test__truncl__leakignore() {
  char *p = malloc(10); *p=0;
  result = truncl(p);
  // cppcheck-suppress memleak
}

void test__truncl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = truncl(x);
}

void test__std__truncl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::truncl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__truncl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::truncl(arg1);
}

void test__std__truncl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::truncl(arg1) > 10) || (std::truncl(arg1) < 100)) {}
}

void test__std__truncl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::truncl(x);
}

void test__atanh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = atanh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__atanh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  atanh(arg1);
}

void test__atanh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((atanh(arg1) > 10) || (atanh(arg1) < 100)) {}
}

void test__atanh__leakignore() {
  char *p = malloc(10); *p=0;
  result = atanh(p);
  // cppcheck-suppress memleak
}

void test__atanh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = atanh(x);
}

void test__std__atanh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::atanh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__atanh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::atanh(arg1);
}

void test__std__atanh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::atanh(arg1) > 10) || (std::atanh(arg1) < 100)) {}
}

void test__std__atanh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::atanh(x);
}

void test__atanhf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = atanhf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__atanhf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  atanhf(arg1);
}

void test__atanhf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((atanhf(arg1) > 10) || (atanhf(arg1) < 100)) {}
}

void test__atanhf__leakignore() {
  char *p = malloc(10); *p=0;
  result = atanhf(p);
  // cppcheck-suppress memleak
}

void test__atanhf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = atanhf(x);
}

void test__std__atanhf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::atanhf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__atanhf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::atanhf(arg1);
}

void test__std__atanhf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::atanhf(arg1) > 10) || (std::atanhf(arg1) < 100)) {}
}

void test__std__atanhf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::atanhf(x);
}

void test__atanhl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = atanhl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__atanhl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  atanhl(arg1);
}

void test__atanhl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((atanhl(arg1) > 10) || (atanhl(arg1) < 100)) {}
}

void test__atanhl__leakignore() {
  char *p = malloc(10); *p=0;
  result = atanhl(p);
  // cppcheck-suppress memleak
}

void test__atanhl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = atanhl(x);
}

void test__std__atanhl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::atanhl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__atanhl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::atanhl(arg1);
}

void test__std__atanhl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::atanhl(arg1) > 10) || (std::atanhl(arg1) < 100)) {}
}

void test__std__atanhl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::atanhl(x);
}

void test__catanh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = catanh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__catanh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  catanh(arg1);
}

void test__catanh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((catanh(arg1) > 10) || (catanh(arg1) < 100)) {}
}

void test__catanh__leakignore() {
  char *p = malloc(10); *p=0;
  result = catanh(p);
  // cppcheck-suppress memleak
}

void test__catanh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = catanh(x);
}

void test__catanhf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = catanhf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__catanhf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  catanhf(arg1);
}

void test__catanhf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((catanhf(arg1) > 10) || (catanhf(arg1) < 100)) {}
}

void test__catanhf__leakignore() {
  char *p = malloc(10); *p=0;
  result = catanhf(p);
  // cppcheck-suppress memleak
}

void test__catanhf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = catanhf(x);
}

void test__catanhl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = catanhl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__catanhl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  catanhl(arg1);
}

void test__catanhl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((catanhl(arg1) > 10) || (catanhl(arg1) < 100)) {}
}

void test__catanhl__leakignore() {
  char *p = malloc(10); *p=0;
  result = catanhl(p);
  // cppcheck-suppress memleak
}

void test__catanhl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = catanhl(x);
}

void test__atan2__noreturn() {
  int x = 1;
  if (cond) { x=100; result = atan2(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__atan2__useretval() {
  // cppcheck-suppress ignoredReturnValue
  atan2(arg1, arg2);
}

void test__atan2__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((atan2(arg1, arg2) > 10) || (atan2(arg1, arg2) < 100)) {}
}

void test__atan2__leakignore() {
  char *p = malloc(10); *p=0;
  result = atan2(p, arg2);
  // cppcheck-suppress memleak
}

void test__atan2__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = atan2(x, arg2);
}

void test__atan2__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = atan2(arg1, x);
}

void test__std__atan2__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::atan2(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__atan2__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::atan2(arg1, arg2);
}

void test__std__atan2__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::atan2(arg1, arg2) > 10) || (std::atan2(arg1, arg2) < 100)) {}
}

void test__std__atan2__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::atan2(x, arg2);
}

void test__std__atan2__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::atan2(arg1, x);
}

void test__atan2f__noreturn() {
  int x = 1;
  if (cond) { x=100; result = atan2f(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__atan2f__useretval() {
  // cppcheck-suppress ignoredReturnValue
  atan2f(arg1, arg2);
}

void test__atan2f__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((atan2f(arg1, arg2) > 10) || (atan2f(arg1, arg2) < 100)) {}
}

void test__atan2f__leakignore() {
  char *p = malloc(10); *p=0;
  result = atan2f(p, arg2);
  // cppcheck-suppress memleak
}

void test__atan2f__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = atan2f(x, arg2);
}

void test__atan2f__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = atan2f(arg1, x);
}

void test__std__atan2f__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::atan2f(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__atan2f__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::atan2f(arg1, arg2);
}

void test__std__atan2f__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::atan2f(arg1, arg2) > 10) || (std::atan2f(arg1, arg2) < 100)) {}
}

void test__std__atan2f__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::atan2f(x, arg2);
}

void test__std__atan2f__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::atan2f(arg1, x);
}

void test__atan2l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = atan2l(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__atan2l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  atan2l(arg1, arg2);
}

void test__atan2l__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((atan2l(arg1, arg2) > 10) || (atan2l(arg1, arg2) < 100)) {}
}

void test__atan2l__leakignore() {
  char *p = malloc(10); *p=0;
  result = atan2l(p, arg2);
  // cppcheck-suppress memleak
}

void test__atan2l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = atan2l(x, arg2);
}

void test__atan2l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = atan2l(arg1, x);
}

void test__std__atan2l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::atan2l(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__atan2l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::atan2l(arg1, arg2);
}

void test__std__atan2l__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::atan2l(arg1, arg2) > 10) || (std::atan2l(arg1, arg2) < 100)) {}
}

void test__std__atan2l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::atan2l(x, arg2);
}

void test__std__atan2l__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::atan2l(arg1, x);
}

void test__atexit__noreturn() {
  int x = 1;
  if (cond) { x=100; atexit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__atexit__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((atexit(arg1) > 10) || (atexit(arg1) < 100)) {}
}

void test__atexit__leakignore() {
  char *p = malloc(10); *p=0;
  atexit(p);
  // cppcheck-suppress memleak
}

void test__atexit__arg1__notnull() {
  // cppcheck-suppress nullPointer
  atexit(NULL);
}

void test__std__atexit__noreturn() {
  int x = 1;
  if (cond) { x=100; std::atexit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__atexit__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::atexit(arg1) > 10) || (std::atexit(arg1) < 100)) {}
}

void test__std__atexit__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::atexit(NULL);
}

void test__atoi__noreturn() {
  int x = 1;
  if (cond) { x=100; result = atoi(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__atoi__useretval() {
  // cppcheck-suppress ignoredReturnValue
  atoi(arg1);
}

void test__atoi__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((atoi(arg1) > 10) || (atoi(arg1) < 100)) {}
}

void test__atoi__leakignore() {
  char *p = malloc(10); *p=0;
  result = atoi(p);
  // cppcheck-suppress memleak
}

void test__atoi__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = atoi(NULL);
}

void test__atoi__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = atoi(x);
}

void test__std__atoi__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::atoi(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__atoi__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::atoi(arg1);
}

void test__std__atoi__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::atoi(arg1) > 10) || (std::atoi(arg1) < 100)) {}
}

void test__std__atoi__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::atoi(NULL);
}

void test__std__atoi__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::atoi(x);
}

void test__atol__noreturn() {
  int x = 1;
  if (cond) { x=100; result = atol(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__atol__useretval() {
  // cppcheck-suppress ignoredReturnValue
  atol(arg1);
}

void test__atol__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((atol(arg1) > 10) || (atol(arg1) < 100)) {}
}

void test__atol__leakignore() {
  char *p = malloc(10); *p=0;
  result = atol(p);
  // cppcheck-suppress memleak
}

void test__atol__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = atol(NULL);
}

void test__atol__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = atol(x);
}

void test__std__atol__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::atol(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__atol__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::atol(arg1);
}

void test__std__atol__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::atol(arg1) > 10) || (std::atol(arg1) < 100)) {}
}

void test__std__atol__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::atol(NULL);
}

void test__std__atol__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::atol(x);
}

void test__atoll__noreturn() {
  int x = 1;
  if (cond) { x=100; result = atoll(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__atoll__useretval() {
  // cppcheck-suppress ignoredReturnValue
  atoll(arg1);
}

void test__atoll__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((atoll(arg1) > 10) || (atoll(arg1) < 100)) {}
}

void test__atoll__leakignore() {
  char *p = malloc(10); *p=0;
  result = atoll(p);
  // cppcheck-suppress memleak
}

void test__atoll__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = atoll(NULL);
}

void test__atoll__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = atoll(x);
}

void test__std__atoll__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::atoll(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__atoll__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::atoll(arg1);
}

void test__std__atoll__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::atoll(arg1) > 10) || (std::atoll(arg1) < 100)) {}
}

void test__std__atoll__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::atoll(NULL);
}

void test__std__atoll__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::atoll(x);
}

void test__atof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = atof(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__atof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  atof(arg1);
}

void test__atof__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((atof(arg1) > 10) || (atof(arg1) < 100)) {}
}

void test__atof__leakignore() {
  char *p = malloc(10); *p=0;
  result = atof(p);
  // cppcheck-suppress memleak
}

void test__atof__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = atof(NULL);
}

void test__atof__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = atof(x);
}

void test__std__atof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::atof(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__atof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::atof(arg1);
}

void test__std__atof__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::atof(arg1) > 10) || (std::atof(arg1) < 100)) {}
}

void test__std__atof__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::atof(NULL);
}

void test__std__atof__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::atof(x);
}

void test__calloc__noreturn() {
  int x = 1;
  if (cond) { x=100; result = calloc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__calloc__useretval() {
  // cppcheck-suppress ignoredReturnValue
  calloc(arg1, arg2);
}

void test__calloc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = calloc(x, arg2);
}

void test__calloc__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = calloc(arg1, x);
}

void test__ceil__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ceil(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ceil__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ceil(arg1);
}

void test__ceil__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ceil(arg1) > 10) || (ceil(arg1) < 100)) {}
}

void test__ceil__leakignore() {
  char *p = malloc(10); *p=0;
  result = ceil(p);
  // cppcheck-suppress memleak
}

void test__ceil__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ceil(x);
}

void test__std__ceil__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ceil(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ceil__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ceil(arg1);
}

void test__std__ceil__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::ceil(arg1) > 10) || (std::ceil(arg1) < 100)) {}
}

void test__std__ceil__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::ceil(x);
}

void test__ceilf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ceilf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ceilf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ceilf(arg1);
}

void test__ceilf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ceilf(arg1) > 10) || (ceilf(arg1) < 100)) {}
}

void test__ceilf__leakignore() {
  char *p = malloc(10); *p=0;
  result = ceilf(p);
  // cppcheck-suppress memleak
}

void test__ceilf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ceilf(x);
}

void test__std__ceilf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ceilf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ceilf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ceilf(arg1);
}

void test__std__ceilf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::ceilf(arg1) > 10) || (std::ceilf(arg1) < 100)) {}
}

void test__std__ceilf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::ceilf(x);
}

void test__ceill__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ceill(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ceill__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ceill(arg1);
}

void test__ceill__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ceill(arg1) > 10) || (ceill(arg1) < 100)) {}
}

void test__ceill__leakignore() {
  char *p = malloc(10); *p=0;
  result = ceill(p);
  // cppcheck-suppress memleak
}

void test__ceill__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ceill(x);
}

void test__std__ceill__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ceill(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ceill__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ceill(arg1);
}

void test__std__ceill__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::ceill(arg1) > 10) || (std::ceill(arg1) < 100)) {}
}

void test__std__ceill__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::ceill(x);
}

void test__copysign__noreturn() {
  int x = 1;
  if (cond) { x=100; result = copysign(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__copysign__useretval() {
  // cppcheck-suppress ignoredReturnValue
  copysign(arg1, arg2);
}

void test__copysign__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((copysign(arg1, arg2) > 10) || (copysign(arg1, arg2) < 100)) {}
}

void test__copysign__leakignore() {
  char *p = malloc(10); *p=0;
  result = copysign(p, arg2);
  // cppcheck-suppress memleak
}

void test__copysign__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = copysign(x, arg2);
}

void test__copysign__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = copysign(arg1, x);
}

void test__std__copysign__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::copysign(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__copysign__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::copysign(arg1, arg2);
}

void test__std__copysign__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::copysign(arg1, arg2) > 10) || (std::copysign(arg1, arg2) < 100)) {}
}

void test__std__copysign__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::copysign(x, arg2);
}

void test__std__copysign__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::copysign(arg1, x);
}

void test__copysignf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = copysignf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__copysignf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  copysignf(arg1, arg2);
}

void test__copysignf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((copysignf(arg1, arg2) > 10) || (copysignf(arg1, arg2) < 100)) {}
}

void test__copysignf__leakignore() {
  char *p = malloc(10); *p=0;
  result = copysignf(p, arg2);
  // cppcheck-suppress memleak
}

void test__copysignf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = copysignf(x, arg2);
}

void test__copysignf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = copysignf(arg1, x);
}

void test__std__copysignf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::copysignf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__copysignf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::copysignf(arg1, arg2);
}

void test__std__copysignf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::copysignf(arg1, arg2) > 10) || (std::copysignf(arg1, arg2) < 100)) {}
}

void test__std__copysignf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::copysignf(x, arg2);
}

void test__std__copysignf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::copysignf(arg1, x);
}

void test__copysignl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = copysignl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__copysignl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  copysignl(arg1, arg2);
}

void test__copysignl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((copysignl(arg1, arg2) > 10) || (copysignl(arg1, arg2) < 100)) {}
}

void test__copysignl__leakignore() {
  char *p = malloc(10); *p=0;
  result = copysignl(p, arg2);
  // cppcheck-suppress memleak
}

void test__copysignl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = copysignl(x, arg2);
}

void test__copysignl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = copysignl(arg1, x);
}

void test__std__copysignl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::copysignl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__copysignl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::copysignl(arg1, arg2);
}

void test__std__copysignl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::copysignl(arg1, arg2) > 10) || (std::copysignl(arg1, arg2) < 100)) {}
}

void test__std__copysignl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::copysignl(x, arg2);
}

void test__std__copysignl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::copysignl(arg1, x);
}

void test__clearerr__noreturn() {
  int x = 1;
  if (cond) { x=100; clearerr(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__clearerr__leakignore() {
  char *p = malloc(10); *p=0;
  clearerr(p);
  // cppcheck-suppress memleak
}

void test__clearerr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  clearerr(NULL);
}

void test__clearerr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  clearerr(x);
}

void test__std__clearerr__noreturn() {
  int x = 1;
  if (cond) { x=100; std::clearerr(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__clearerr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::clearerr(NULL);
}

void test__std__clearerr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::clearerr(x);
}

void test__clock__noreturn() {
  int x = 1;
  if (cond) { x=100; result = clock(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__clock__useretval() {
  // cppcheck-suppress ignoredReturnValue
  clock();
}

void test__clock__leakignore() {
  char *p = malloc(10); *p=0;
  result = clock();
  // cppcheck-suppress memleak
}

void test__cbrt__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cbrt(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cbrt__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cbrt(arg1);
}

void test__cbrt__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cbrt(arg1) > 10) || (cbrt(arg1) < 100)) {}
}

void test__cbrt__leakignore() {
  char *p = malloc(10); *p=0;
  result = cbrt(p);
  // cppcheck-suppress memleak
}

void test__cbrt__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cbrt(x);
}

void test__std__cbrt__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::cbrt(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__cbrt__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::cbrt(arg1);
}

void test__std__cbrt__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::cbrt(arg1) > 10) || (std::cbrt(arg1) < 100)) {}
}

void test__std__cbrt__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::cbrt(x);
}

void test__cbrtf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cbrtf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cbrtf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cbrtf(arg1);
}

void test__cbrtf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cbrtf(arg1) > 10) || (cbrtf(arg1) < 100)) {}
}

void test__cbrtf__leakignore() {
  char *p = malloc(10); *p=0;
  result = cbrtf(p);
  // cppcheck-suppress memleak
}

void test__cbrtf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cbrtf(x);
}

void test__std__cbrtf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::cbrtf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__cbrtf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::cbrtf(arg1);
}

void test__std__cbrtf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::cbrtf(arg1) > 10) || (std::cbrtf(arg1) < 100)) {}
}

void test__std__cbrtf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::cbrtf(x);
}

void test__cbrtl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cbrtl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cbrtl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cbrtl(arg1);
}

void test__cbrtl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cbrtl(arg1) > 10) || (cbrtl(arg1) < 100)) {}
}

void test__cbrtl__leakignore() {
  char *p = malloc(10); *p=0;
  result = cbrtl(p);
  // cppcheck-suppress memleak
}

void test__cbrtl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cbrtl(x);
}

void test__std__cbrtl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::cbrtl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__cbrtl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::cbrtl(arg1);
}

void test__std__cbrtl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::cbrtl(arg1) > 10) || (std::cbrtl(arg1) < 100)) {}
}

void test__std__cbrtl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::cbrtl(x);
}

void test__cos__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cos(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cos__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cos(arg1);
}

void test__cos__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cos(arg1) > 10) || (cos(arg1) < 100)) {}
}

void test__cos__leakignore() {
  char *p = malloc(10); *p=0;
  result = cos(p);
  // cppcheck-suppress memleak
}

void test__cos__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cos(x);
}

void test__std__cos__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::cos(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__cos__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::cos(arg1);
}

void test__std__cos__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::cos(arg1) > 10) || (std::cos(arg1) < 100)) {}
}

void test__std__cos__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::cos(x);
}

void test__cosf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cosf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cosf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cosf(arg1);
}

void test__cosf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cosf(arg1) > 10) || (cosf(arg1) < 100)) {}
}

void test__cosf__leakignore() {
  char *p = malloc(10); *p=0;
  result = cosf(p);
  // cppcheck-suppress memleak
}

void test__cosf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cosf(x);
}

void test__std__cosf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::cosf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__cosf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::cosf(arg1);
}

void test__std__cosf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::cosf(arg1) > 10) || (std::cosf(arg1) < 100)) {}
}

void test__std__cosf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::cosf(x);
}

void test__cosl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cosl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cosl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cosl(arg1);
}

void test__cosl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cosl(arg1) > 10) || (cosl(arg1) < 100)) {}
}

void test__cosl__leakignore() {
  char *p = malloc(10); *p=0;
  result = cosl(p);
  // cppcheck-suppress memleak
}

void test__cosl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cosl(x);
}

void test__std__cosl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::cosl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__cosl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::cosl(arg1);
}

void test__std__cosl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::cosl(arg1) > 10) || (std::cosl(arg1) < 100)) {}
}

void test__std__cosl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::cosl(x);
}

void test__ccos__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ccos(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ccos__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ccos(arg1);
}

void test__ccos__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ccos(arg1) > 10) || (ccos(arg1) < 100)) {}
}

void test__ccos__leakignore() {
  char *p = malloc(10); *p=0;
  result = ccos(p);
  // cppcheck-suppress memleak
}

void test__ccos__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ccos(x);
}

void test__ccosf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ccosf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ccosf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ccosf(arg1);
}

void test__ccosf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ccosf(arg1) > 10) || (ccosf(arg1) < 100)) {}
}

void test__ccosf__leakignore() {
  char *p = malloc(10); *p=0;
  result = ccosf(p);
  // cppcheck-suppress memleak
}

void test__ccosf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ccosf(x);
}

void test__ccosl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ccosl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ccosl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ccosl(arg1);
}

void test__ccosl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ccosl(arg1) > 10) || (ccosl(arg1) < 100)) {}
}

void test__ccosl__leakignore() {
  char *p = malloc(10); *p=0;
  result = ccosl(p);
  // cppcheck-suppress memleak
}

void test__ccosl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ccosl(x);
}

void test__cosh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cosh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cosh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cosh(arg1);
}

void test__cosh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cosh(arg1) > 10) || (cosh(arg1) < 100)) {}
}

void test__cosh__leakignore() {
  char *p = malloc(10); *p=0;
  result = cosh(p);
  // cppcheck-suppress memleak
}

void test__cosh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cosh(x);
}

void test__std__cosh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::cosh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__cosh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::cosh(arg1);
}

void test__std__cosh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::cosh(arg1) > 10) || (std::cosh(arg1) < 100)) {}
}

void test__std__cosh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::cosh(x);
}

void test__coshf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = coshf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__coshf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  coshf(arg1);
}

void test__coshf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((coshf(arg1) > 10) || (coshf(arg1) < 100)) {}
}

void test__coshf__leakignore() {
  char *p = malloc(10); *p=0;
  result = coshf(p);
  // cppcheck-suppress memleak
}

void test__coshf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = coshf(x);
}

void test__std__coshf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::coshf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__coshf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::coshf(arg1);
}

void test__std__coshf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::coshf(arg1) > 10) || (std::coshf(arg1) < 100)) {}
}

void test__std__coshf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::coshf(x);
}

void test__coshl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = coshl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__coshl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  coshl(arg1);
}

void test__coshl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((coshl(arg1) > 10) || (coshl(arg1) < 100)) {}
}

void test__coshl__leakignore() {
  char *p = malloc(10); *p=0;
  result = coshl(p);
  // cppcheck-suppress memleak
}

void test__coshl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = coshl(x);
}

void test__std__coshl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::coshl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__coshl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::coshl(arg1);
}

void test__std__coshl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::coshl(arg1) > 10) || (std::coshl(arg1) < 100)) {}
}

void test__std__coshl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::coshl(x);
}

void test__ccosh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ccosh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ccosh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ccosh(arg1);
}

void test__ccosh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ccosh(arg1) > 10) || (ccosh(arg1) < 100)) {}
}

void test__ccosh__leakignore() {
  char *p = malloc(10); *p=0;
  result = ccosh(p);
  // cppcheck-suppress memleak
}

void test__ccosh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ccosh(x);
}

void test__ccoshf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ccoshf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ccoshf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ccoshf(arg1);
}

void test__ccoshf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ccoshf(arg1) > 10) || (ccoshf(arg1) < 100)) {}
}

void test__ccoshf__leakignore() {
  char *p = malloc(10); *p=0;
  result = ccoshf(p);
  // cppcheck-suppress memleak
}

void test__ccoshf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ccoshf(x);
}

void test__ccoshl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ccoshl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ccoshl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ccoshl(arg1);
}

void test__ccoshl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ccoshl(arg1) > 10) || (ccoshl(arg1) < 100)) {}
}

void test__ccoshl__leakignore() {
  char *p = malloc(10); *p=0;
  result = ccoshl(p);
  // cppcheck-suppress memleak
}

void test__ccoshl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ccoshl(x);
}

void test__ctime__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ctime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ctime__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ctime(arg1);
}

void test__ctime__leakignore() {
  char *p = malloc(10); *p=0;
  result = ctime(p);
  // cppcheck-suppress memleak
}

void test__ctime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = ctime(NULL);
}

void test__ctime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = ctime(x);
}

void test__std__ctime__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ctime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ctime__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ctime(arg1);
}

void test__std__ctime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::ctime(NULL);
}

void test__std__ctime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::ctime(x);
}

void test__difftime__noreturn() {
  int x = 1;
  if (cond) { x=100; result = difftime(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__difftime__useretval() {
  // cppcheck-suppress ignoredReturnValue
  difftime(arg1, arg2);
}

void test__difftime__leakignore() {
  char *p = malloc(10); *p=0;
  result = difftime(p, arg2);
  // cppcheck-suppress memleak
}

void test__difftime__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = difftime(x, arg2);
}

void test__difftime__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = difftime(arg1, x);
}

void test__std__difftime__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::difftime(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__difftime__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::difftime(arg1, arg2);
}

void test__std__difftime__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::difftime(x, arg2);
}

void test__std__difftime__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::difftime(arg1, x);
}

void test__div__noreturn() {
  int x = 1;
  if (cond) { x=100; div(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__div__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((div(arg1, arg2) > 10) || (div(arg1, arg2) < 100)) {}
}

void test__div__leakignore() {
  char *p = malloc(10); *p=0;
  div(p, arg2);
  // cppcheck-suppress memleak
}

void test__div__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  div(x, arg2);
}

void test__div__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  div(arg1, x);
}

void test__std__div__noreturn() {
  int x = 1;
  if (cond) { x=100; std::div(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__div__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::div(arg1, arg2) > 10) || (std::div(arg1, arg2) < 100)) {}
}

void test__std__div__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::div(x, arg2);
}

void test__std__div__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::div(arg1, x);
}

void test__imaxdiv__noreturn() {
  int x = 1;
  if (cond) { x=100; imaxdiv(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__imaxdiv__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((imaxdiv(arg1, arg2) > 10) || (imaxdiv(arg1, arg2) < 100)) {}
}

void test__imaxdiv__leakignore() {
  char *p = malloc(10); *p=0;
  imaxdiv(p, arg2);
  // cppcheck-suppress memleak
}

void test__imaxdiv__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  imaxdiv(x, arg2);
}

void test__imaxdiv__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  imaxdiv(arg1, x);
}

void test__std__imaxdiv__noreturn() {
  int x = 1;
  if (cond) { x=100; std::imaxdiv(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__imaxdiv__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::imaxdiv(arg1, arg2) > 10) || (std::imaxdiv(arg1, arg2) < 100)) {}
}

void test__std__imaxdiv__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::imaxdiv(x, arg2);
}

void test__std__imaxdiv__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::imaxdiv(arg1, x);
}

void test__exit__noreturn() {
  int x = 1;
  if (cond) { x=100; exit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__exit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  exit(x);
}

void test__std__exit__noreturn() {
  int x = 1;
  if (cond) { x=100; std::exit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__exit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::exit(x);
}

void test__erf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = erf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__erf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  erf(arg1);
}

void test__erf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((erf(arg1) > 10) || (erf(arg1) < 100)) {}
}

void test__erf__leakignore() {
  char *p = malloc(10); *p=0;
  result = erf(p);
  // cppcheck-suppress memleak
}

void test__erf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = erf(x);
}

void test__std__erf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::erf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__erf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::erf(arg1);
}

void test__std__erf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::erf(arg1) > 10) || (std::erf(arg1) < 100)) {}
}

void test__std__erf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::erf(x);
}

void test__erff__noreturn() {
  int x = 1;
  if (cond) { x=100; result = erff(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__erff__useretval() {
  // cppcheck-suppress ignoredReturnValue
  erff(arg1);
}

void test__erff__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((erff(arg1) > 10) || (erff(arg1) < 100)) {}
}

void test__erff__leakignore() {
  char *p = malloc(10); *p=0;
  result = erff(p);
  // cppcheck-suppress memleak
}

void test__erff__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = erff(x);
}

void test__std__erff__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::erff(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__erff__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::erff(arg1);
}

void test__std__erff__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::erff(arg1) > 10) || (std::erff(arg1) < 100)) {}
}

void test__std__erff__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::erff(x);
}

void test__erfl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = erfl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__erfl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  erfl(arg1);
}

void test__erfl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((erfl(arg1) > 10) || (erfl(arg1) < 100)) {}
}

void test__erfl__leakignore() {
  char *p = malloc(10); *p=0;
  result = erfl(p);
  // cppcheck-suppress memleak
}

void test__erfl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = erfl(x);
}

void test__std__erfl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::erfl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__erfl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::erfl(arg1);
}

void test__std__erfl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::erfl(arg1) > 10) || (std::erfl(arg1) < 100)) {}
}

void test__std__erfl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::erfl(x);
}

void test__erfc__noreturn() {
  int x = 1;
  if (cond) { x=100; result = erfc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__erfc__useretval() {
  // cppcheck-suppress ignoredReturnValue
  erfc(arg1);
}

void test__erfc__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((erfc(arg1) > 10) || (erfc(arg1) < 100)) {}
}

void test__erfc__leakignore() {
  char *p = malloc(10); *p=0;
  result = erfc(p);
  // cppcheck-suppress memleak
}

void test__erfc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = erfc(x);
}

void test__std__erfc__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::erfc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__erfc__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::erfc(arg1);
}

void test__std__erfc__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::erfc(arg1) > 10) || (std::erfc(arg1) < 100)) {}
}

void test__std__erfc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::erfc(x);
}

void test__erfcf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = erfcf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__erfcf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  erfcf(arg1);
}

void test__erfcf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((erfcf(arg1) > 10) || (erfcf(arg1) < 100)) {}
}

void test__erfcf__leakignore() {
  char *p = malloc(10); *p=0;
  result = erfcf(p);
  // cppcheck-suppress memleak
}

void test__erfcf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = erfcf(x);
}

void test__std__erfcf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::erfcf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__erfcf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::erfcf(arg1);
}

void test__std__erfcf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::erfcf(arg1) > 10) || (std::erfcf(arg1) < 100)) {}
}

void test__std__erfcf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::erfcf(x);
}

void test__erfcl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = erfcl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__erfcl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  erfcl(arg1);
}

void test__erfcl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((erfcl(arg1) > 10) || (erfcl(arg1) < 100)) {}
}

void test__erfcl__leakignore() {
  char *p = malloc(10); *p=0;
  result = erfcl(p);
  // cppcheck-suppress memleak
}

void test__erfcl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = erfcl(x);
}

void test__std__erfcl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::erfcl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__erfcl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::erfcl(arg1);
}

void test__std__erfcl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::erfcl(arg1) > 10) || (std::erfcl(arg1) < 100)) {}
}

void test__std__erfcl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::erfcl(x);
}

void test__carg__noreturn() {
  int x = 1;
  if (cond) { x=100; result = carg(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__carg__useretval() {
  // cppcheck-suppress ignoredReturnValue
  carg(arg1);
}

void test__carg__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((carg(arg1) > 10) || (carg(arg1) < 100)) {}
}

void test__carg__leakignore() {
  char *p = malloc(10); *p=0;
  result = carg(p);
  // cppcheck-suppress memleak
}

void test__carg__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = carg(x);
}

void test__cargf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cargf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cargf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cargf(arg1);
}

void test__cargf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cargf(arg1) > 10) || (cargf(arg1) < 100)) {}
}

void test__cargf__leakignore() {
  char *p = malloc(10); *p=0;
  result = cargf(p);
  // cppcheck-suppress memleak
}

void test__cargf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cargf(x);
}

void test__cargl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cargl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cargl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cargl(arg1);
}

void test__cargl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cargl(arg1) > 10) || (cargl(arg1) < 100)) {}
}

void test__cargl__leakignore() {
  char *p = malloc(10); *p=0;
  result = cargl(p);
  // cppcheck-suppress memleak
}

void test__cargl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cargl(x);
}

void test__exp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = exp(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__exp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  exp(arg1);
}

void test__exp__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((exp(arg1) > 10) || (exp(arg1) < 100)) {}
}

void test__exp__leakignore() {
  char *p = malloc(10); *p=0;
  result = exp(p);
  // cppcheck-suppress memleak
}

void test__exp__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = exp(x);
}

void test__std__exp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::exp(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__exp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::exp(arg1);
}

void test__std__exp__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::exp(arg1) > 10) || (std::exp(arg1) < 100)) {}
}

void test__std__exp__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::exp(x);
}

void test__expf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = expf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__expf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  expf(arg1);
}

void test__expf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((expf(arg1) > 10) || (expf(arg1) < 100)) {}
}

void test__expf__leakignore() {
  char *p = malloc(10); *p=0;
  result = expf(p);
  // cppcheck-suppress memleak
}

void test__expf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = expf(x);
}

void test__std__expf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::expf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__expf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::expf(arg1);
}

void test__std__expf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::expf(arg1) > 10) || (std::expf(arg1) < 100)) {}
}

void test__std__expf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::expf(x);
}

void test__expl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = expl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__expl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  expl(arg1);
}

void test__expl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((expl(arg1) > 10) || (expl(arg1) < 100)) {}
}

void test__expl__leakignore() {
  char *p = malloc(10); *p=0;
  result = expl(p);
  // cppcheck-suppress memleak
}

void test__expl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = expl(x);
}

void test__std__expl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::expl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__expl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::expl(arg1);
}

void test__std__expl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::expl(arg1) > 10) || (std::expl(arg1) < 100)) {}
}

void test__std__expl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::expl(x);
}

void test__cexp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cexp(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cexp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cexp(arg1);
}

void test__cexp__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cexp(arg1) > 10) || (cexp(arg1) < 100)) {}
}

void test__cexp__leakignore() {
  char *p = malloc(10); *p=0;
  result = cexp(p);
  // cppcheck-suppress memleak
}

void test__cexp__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cexp(x);
}

void test__cexpf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cexpf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cexpf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cexpf(arg1);
}

void test__cexpf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cexpf(arg1) > 10) || (cexpf(arg1) < 100)) {}
}

void test__cexpf__leakignore() {
  char *p = malloc(10); *p=0;
  result = cexpf(p);
  // cppcheck-suppress memleak
}

void test__cexpf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cexpf(x);
}

void test__cexpl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cexpl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cexpl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cexpl(arg1);
}

void test__cexpl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cexpl(arg1) > 10) || (cexpl(arg1) < 100)) {}
}

void test__cexpl__leakignore() {
  char *p = malloc(10); *p=0;
  result = cexpl(p);
  // cppcheck-suppress memleak
}

void test__cexpl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cexpl(x);
}

void test__cimag__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cimag(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cimag__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cimag(arg1);
}

void test__cimag__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cimag(arg1) > 10) || (cimag(arg1) < 100)) {}
}

void test__cimag__leakignore() {
  char *p = malloc(10); *p=0;
  result = cimag(p);
  // cppcheck-suppress memleak
}

void test__cimag__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cimag(x);
}

void test__cimagf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cimagf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cimagf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cimagf(arg1);
}

void test__cimagf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cimagf(arg1) > 10) || (cimagf(arg1) < 100)) {}
}

void test__cimagf__leakignore() {
  char *p = malloc(10); *p=0;
  result = cimagf(p);
  // cppcheck-suppress memleak
}

void test__cimagf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cimagf(x);
}

void test__cimagl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cimagl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cimagl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cimagl(arg1);
}

void test__cimagl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cimagl(arg1) > 10) || (cimagl(arg1) < 100)) {}
}

void test__cimagl__leakignore() {
  char *p = malloc(10); *p=0;
  result = cimagl(p);
  // cppcheck-suppress memleak
}

void test__cimagl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cimagl(x);
}

void test__exp2__noreturn() {
  int x = 1;
  if (cond) { x=100; result = exp2(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__exp2__useretval() {
  // cppcheck-suppress ignoredReturnValue
  exp2(arg1);
}

void test__exp2__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((exp2(arg1) > 10) || (exp2(arg1) < 100)) {}
}

void test__exp2__leakignore() {
  char *p = malloc(10); *p=0;
  result = exp2(p);
  // cppcheck-suppress memleak
}

void test__exp2__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = exp2(x);
}

void test__std__exp2__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::exp2(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__exp2__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::exp2(arg1);
}

void test__std__exp2__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::exp2(arg1) > 10) || (std::exp2(arg1) < 100)) {}
}

void test__std__exp2__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::exp2(x);
}

void test__exp2f__noreturn() {
  int x = 1;
  if (cond) { x=100; result = exp2f(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__exp2f__useretval() {
  // cppcheck-suppress ignoredReturnValue
  exp2f(arg1);
}

void test__exp2f__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((exp2f(arg1) > 10) || (exp2f(arg1) < 100)) {}
}

void test__exp2f__leakignore() {
  char *p = malloc(10); *p=0;
  result = exp2f(p);
  // cppcheck-suppress memleak
}

void test__exp2f__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = exp2f(x);
}

void test__std__exp2f__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::exp2f(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__exp2f__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::exp2f(arg1);
}

void test__std__exp2f__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::exp2f(arg1) > 10) || (std::exp2f(arg1) < 100)) {}
}

void test__std__exp2f__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::exp2f(x);
}

void test__exp2l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = exp2l(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__exp2l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  exp2l(arg1);
}

void test__exp2l__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((exp2l(arg1) > 10) || (exp2l(arg1) < 100)) {}
}

void test__exp2l__leakignore() {
  char *p = malloc(10); *p=0;
  result = exp2l(p);
  // cppcheck-suppress memleak
}

void test__exp2l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = exp2l(x);
}

void test__std__exp2l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::exp2l(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__exp2l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::exp2l(arg1);
}

void test__std__exp2l__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::exp2l(arg1) > 10) || (std::exp2l(arg1) < 100)) {}
}

void test__std__exp2l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::exp2l(x);
}

void test__expm1__noreturn() {
  int x = 1;
  if (cond) { x=100; result = expm1(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__expm1__useretval() {
  // cppcheck-suppress ignoredReturnValue
  expm1(arg1);
}

void test__expm1__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((expm1(arg1) > 10) || (expm1(arg1) < 100)) {}
}

void test__expm1__leakignore() {
  char *p = malloc(10); *p=0;
  result = expm1(p);
  // cppcheck-suppress memleak
}

void test__expm1__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = expm1(x);
}

void test__std__expm1__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::expm1(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__expm1__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::expm1(arg1);
}

void test__std__expm1__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::expm1(arg1) > 10) || (std::expm1(arg1) < 100)) {}
}

void test__std__expm1__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::expm1(x);
}

void test__expm1f__noreturn() {
  int x = 1;
  if (cond) { x=100; result = expm1f(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__expm1f__useretval() {
  // cppcheck-suppress ignoredReturnValue
  expm1f(arg1);
}

void test__expm1f__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((expm1f(arg1) > 10) || (expm1f(arg1) < 100)) {}
}

void test__expm1f__leakignore() {
  char *p = malloc(10); *p=0;
  result = expm1f(p);
  // cppcheck-suppress memleak
}

void test__expm1f__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = expm1f(x);
}

void test__std__expm1f__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::expm1f(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__expm1f__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::expm1f(arg1);
}

void test__std__expm1f__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::expm1f(arg1) > 10) || (std::expm1f(arg1) < 100)) {}
}

void test__std__expm1f__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::expm1f(x);
}

void test__expm1l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = expm1l(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__expm1l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  expm1l(arg1);
}

void test__expm1l__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((expm1l(arg1) > 10) || (expm1l(arg1) < 100)) {}
}

void test__expm1l__leakignore() {
  char *p = malloc(10); *p=0;
  result = expm1l(p);
  // cppcheck-suppress memleak
}

void test__expm1l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = expm1l(x);
}

void test__std__expm1l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::expm1l(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__expm1l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::expm1l(arg1);
}

void test__std__expm1l__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::expm1l(arg1) > 10) || (std::expm1l(arg1) < 100)) {}
}

void test__std__expm1l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::expm1l(x);
}

void test___Exit__noreturn() {
  int x = 1;
  if (cond) { x=100; _Exit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___Exit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _Exit(x);
}

void test__quick_exit__noreturn() {
  int x = 1;
  if (cond) { x=100; quick_exit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__quick_exit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  quick_exit(x);
}

void test__fabs__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fabs(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fabs__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fabs(arg1);
}

void test__fabs__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fabs(arg1) > 10) || (fabs(arg1) < 100)) {}
}

void test__fabs__leakignore() {
  char *p = malloc(10); *p=0;
  result = fabs(p);
  // cppcheck-suppress memleak
}

void test__fabs__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fabs(x);
}

void test__std__fabs__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fabs(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fabs__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fabs(arg1);
}

void test__std__fabs__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fabs(arg1) > 10) || (std::fabs(arg1) < 100)) {}
}

void test__std__fabs__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fabs(x);
}

void test__fabsf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fabsf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fabsf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fabsf(arg1);
}

void test__fabsf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fabsf(arg1) > 10) || (fabsf(arg1) < 100)) {}
}

void test__fabsf__leakignore() {
  char *p = malloc(10); *p=0;
  result = fabsf(p);
  // cppcheck-suppress memleak
}

void test__fabsf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fabsf(x);
}

void test__std__fabsf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fabsf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fabsf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fabsf(arg1);
}

void test__std__fabsf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fabsf(arg1) > 10) || (std::fabsf(arg1) < 100)) {}
}

void test__std__fabsf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fabsf(x);
}

void test__fabsl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fabsl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fabsl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fabsl(arg1);
}

void test__fabsl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fabsl(arg1) > 10) || (fabsl(arg1) < 100)) {}
}

void test__fabsl__leakignore() {
  char *p = malloc(10); *p=0;
  result = fabsl(p);
  // cppcheck-suppress memleak
}

void test__fabsl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fabsl(x);
}

void test__std__fabsl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fabsl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fabsl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fabsl(arg1);
}

void test__std__fabsl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fabsl(arg1) > 10) || (std::fabsl(arg1) < 100)) {}
}

void test__std__fabsl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fabsl(x);
}

void test__fdim__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fdim(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fdim__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fdim(arg1, arg2);
}

void test__fdim__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fdim(arg1, arg2) > 10) || (fdim(arg1, arg2) < 100)) {}
}

void test__fdim__leakignore() {
  char *p = malloc(10); *p=0;
  result = fdim(p, arg2);
  // cppcheck-suppress memleak
}

void test__fdim__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fdim(x, arg2);
}

void test__fdim__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fdim(arg1, x);
}

void test__std__fdim__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fdim(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fdim__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fdim(arg1, arg2);
}

void test__std__fdim__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fdim(arg1, arg2) > 10) || (std::fdim(arg1, arg2) < 100)) {}
}

void test__std__fdim__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fdim(x, arg2);
}

void test__std__fdim__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fdim(arg1, x);
}

void test__fdimf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fdimf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fdimf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fdimf(arg1, arg2);
}

void test__fdimf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fdimf(arg1, arg2) > 10) || (fdimf(arg1, arg2) < 100)) {}
}

void test__fdimf__leakignore() {
  char *p = malloc(10); *p=0;
  result = fdimf(p, arg2);
  // cppcheck-suppress memleak
}

void test__fdimf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fdimf(x, arg2);
}

void test__fdimf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fdimf(arg1, x);
}

void test__std__fdimf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fdimf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fdimf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fdimf(arg1, arg2);
}

void test__std__fdimf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fdimf(arg1, arg2) > 10) || (std::fdimf(arg1, arg2) < 100)) {}
}

void test__std__fdimf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fdimf(x, arg2);
}

void test__std__fdimf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fdimf(arg1, x);
}

void test__fdiml__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fdiml(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fdiml__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fdiml(arg1, arg2);
}

void test__fdiml__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fdiml(arg1, arg2) > 10) || (fdiml(arg1, arg2) < 100)) {}
}

void test__fdiml__leakignore() {
  char *p = malloc(10); *p=0;
  result = fdiml(p, arg2);
  // cppcheck-suppress memleak
}

void test__fdiml__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fdiml(x, arg2);
}

void test__fdiml__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fdiml(arg1, x);
}

void test__std__fdiml__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fdiml(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fdiml__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fdiml(arg1, arg2);
}

void test__std__fdiml__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fdiml(arg1, arg2) > 10) || (std::fdiml(arg1, arg2) < 100)) {}
}

void test__std__fdiml__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fdiml(x, arg2);
}

void test__std__fdiml__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fdiml(arg1, x);
}

void test__fclose__noreturn() {
  int x = 1;
  if (cond) { x=100; fclose(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fclose__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fclose(NULL);
}

void test__fclose__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fclose(x);
}

void test__std__fclose__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fclose(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fclose__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fclose(NULL);
}

void test__std__fclose__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fclose(x);
}

void test__feof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = feof(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__feof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  feof(arg1);
}

void test__feof__leakignore() {
  char *p = malloc(10); *p=0;
  result = feof(p);
  // cppcheck-suppress memleak
}

void test__feof__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = feof(NULL);
}

void test__feof__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = feof(x);
}

void test__std__feof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::feof(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__feof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::feof(arg1);
}

void test__std__feof__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::feof(NULL);
}

void test__std__feof__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::feof(x);
}

void test__ferror__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ferror(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ferror__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ferror(arg1);
}

void test__ferror__leakignore() {
  char *p = malloc(10); *p=0;
  result = ferror(p);
  // cppcheck-suppress memleak
}

void test__ferror__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = ferror(NULL);
}

void test__ferror__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = ferror(x);
}

void test__std__ferror__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ferror(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ferror__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ferror(arg1);
}

void test__std__ferror__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::ferror(NULL);
}

void test__std__ferror__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::ferror(x);
}

void test__fflush__noreturn() {
  int x = 1;
  if (cond) { x=100; fflush(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fflush__leakignore() {
  char *p = malloc(10); *p=0;
  fflush(p);
  // cppcheck-suppress memleak
}

void test__fflush__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fflush(x);
}

void test__std__fflush__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fflush(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fflush__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fflush(x);
}

void test__fgetc__noreturn() {
  int x = 1;
  if (cond) { x=100; fgetc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fgetc__leakignore() {
  char *p = malloc(10); *p=0;
  fgetc(p);
  // cppcheck-suppress memleak
}

void test__fgetc__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fgetc(NULL);
}

void test__fgetc__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fgetc(x);
}

void test__std__fgetc__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fgetc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fgetc__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fgetc(NULL);
}

void test__std__fgetc__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fgetc(x);
}

void test__getc__noreturn() {
  int x = 1;
  if (cond) { x=100; getc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getc__leakignore() {
  char *p = malloc(10); *p=0;
  getc(p);
  // cppcheck-suppress memleak
}

void test__getc__arg1__notnull() {
  // cppcheck-suppress nullPointer
  getc(NULL);
}

void test__getc__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  getc(x);
}

void test__std__getc__noreturn() {
  int x = 1;
  if (cond) { x=100; std::getc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__getc__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::getc(NULL);
}

void test__std__getc__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::getc(x);
}

void test__fgetwc__noreturn() {
  int x = 1;
  if (cond) { x=100; fgetwc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fgetwc__leakignore() {
  char *p = malloc(10); *p=0;
  fgetwc(p);
  // cppcheck-suppress memleak
}

void test__fgetwc__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fgetwc(NULL);
}

void test__fgetwc__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fgetwc(x);
}

void test__std__fgetwc__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fgetwc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fgetwc__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fgetwc(NULL);
}

void test__std__fgetwc__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fgetwc(x);
}

void test__getwc__noreturn() {
  int x = 1;
  if (cond) { x=100; getwc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getwc__leakignore() {
  char *p = malloc(10); *p=0;
  getwc(p);
  // cppcheck-suppress memleak
}

void test__getwc__arg1__notnull() {
  // cppcheck-suppress nullPointer
  getwc(NULL);
}

void test__getwc__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  getwc(x);
}

void test__std__getwc__noreturn() {
  int x = 1;
  if (cond) { x=100; std::getwc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__getwc__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::getwc(NULL);
}

void test__std__getwc__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::getwc(x);
}

void test__fgetpos__noreturn() {
  int x = 1;
  if (cond) { x=100; fgetpos(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fgetpos__leakignore() {
  char *p = malloc(10); *p=0;
  fgetpos(p, arg2);
  // cppcheck-suppress memleak
}

void test__fgetpos__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fgetpos(NULL, arg2);
}

void test__fgetpos__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fgetpos(x, arg2);
}

void test__fgetpos__arg2__notnull() {
  // cppcheck-suppress nullPointer
  fgetpos(arg1, NULL);
}

void test__std__fgetpos__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fgetpos(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fgetpos__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fgetpos(NULL, arg2);
}

void test__std__fgetpos__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fgetpos(x, arg2);
}

void test__std__fgetpos__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::fgetpos(arg1, NULL);
}

void test__floor__noreturn() {
  int x = 1;
  if (cond) { x=100; result = floor(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__floor__useretval() {
  // cppcheck-suppress ignoredReturnValue
  floor(arg1);
}

void test__floor__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((floor(arg1) > 10) || (floor(arg1) < 100)) {}
}

void test__floor__leakignore() {
  char *p = malloc(10); *p=0;
  result = floor(p);
  // cppcheck-suppress memleak
}

void test__floor__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = floor(x);
}

void test__std__floor__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::floor(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__floor__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::floor(arg1);
}

void test__std__floor__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::floor(arg1) > 10) || (std::floor(arg1) < 100)) {}
}

void test__std__floor__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::floor(x);
}

void test__floorf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = floorf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__floorf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  floorf(arg1);
}

void test__floorf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((floorf(arg1) > 10) || (floorf(arg1) < 100)) {}
}

void test__floorf__leakignore() {
  char *p = malloc(10); *p=0;
  result = floorf(p);
  // cppcheck-suppress memleak
}

void test__floorf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = floorf(x);
}

void test__std__floorf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::floorf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__floorf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::floorf(arg1);
}

void test__std__floorf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::floorf(arg1) > 10) || (std::floorf(arg1) < 100)) {}
}

void test__std__floorf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::floorf(x);
}

void test__floorl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = floorl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__floorl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  floorl(arg1);
}

void test__floorl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((floorl(arg1) > 10) || (floorl(arg1) < 100)) {}
}

void test__floorl__leakignore() {
  char *p = malloc(10); *p=0;
  result = floorl(p);
  // cppcheck-suppress memleak
}

void test__floorl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = floorl(x);
}

void test__std__floorl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::floorl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__floorl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::floorl(arg1);
}

void test__std__floorl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::floorl(arg1) > 10) || (std::floorl(arg1) < 100)) {}
}

void test__std__floorl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::floorl(x);
}

void test__fma__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fma(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fma__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fma(arg1, arg2, arg3);
}

void test__fma__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fma(arg1, arg2, arg3) > 10) || (fma(arg1, arg2, arg3) < 100)) {}
}

void test__fma__leakignore() {
  char *p = malloc(10); *p=0;
  result = fma(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__fma__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fma(x, arg2, arg3);
}

void test__fma__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fma(arg1, x, arg3);
}

void test__fma__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fma(arg1, arg2, x);
}

void test__std__fma__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fma(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fma__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fma(arg1, arg2, arg3);
}

void test__std__fma__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fma(arg1, arg2, arg3) > 10) || (std::fma(arg1, arg2, arg3) < 100)) {}
}

void test__std__fma__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fma(x, arg2, arg3);
}

void test__std__fma__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fma(arg1, x, arg3);
}

void test__std__fma__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fma(arg1, arg2, x);
}

void test__fmaf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fmaf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fmaf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fmaf(arg1, arg2, arg3);
}

void test__fmaf__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fmaf(arg1, arg2, arg3) > 10) || (fmaf(arg1, arg2, arg3) < 100)) {}
}

void test__fmaf__leakignore() {
  char *p = malloc(10); *p=0;
  result = fmaf(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__fmaf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmaf(x, arg2, arg3);
}

void test__fmaf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmaf(arg1, x, arg3);
}

void test__fmaf__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmaf(arg1, arg2, x);
}

void test__std__fmaf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fmaf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fmaf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fmaf(arg1, arg2, arg3);
}

void test__std__fmaf__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fmaf(arg1, arg2, arg3) > 10) || (std::fmaf(arg1, arg2, arg3) < 100)) {}
}

void test__std__fmaf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmaf(x, arg2, arg3);
}

void test__std__fmaf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmaf(arg1, x, arg3);
}

void test__std__fmaf__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmaf(arg1, arg2, x);
}

void test__fmal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fmal(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fmal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fmal(arg1, arg2, arg3);
}

void test__fmal__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fmal(arg1, arg2, arg3) > 10) || (fmal(arg1, arg2, arg3) < 100)) {}
}

void test__fmal__leakignore() {
  char *p = malloc(10); *p=0;
  result = fmal(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__fmal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmal(x, arg2, arg3);
}

void test__fmal__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmal(arg1, x, arg3);
}

void test__fmal__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmal(arg1, arg2, x);
}

void test__std__fmal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fmal(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fmal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fmal(arg1, arg2, arg3);
}

void test__std__fmal__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fmal(arg1, arg2, arg3) > 10) || (std::fmal(arg1, arg2, arg3) < 100)) {}
}

void test__std__fmal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmal(x, arg2, arg3);
}

void test__std__fmal__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmal(arg1, x, arg3);
}

void test__std__fmal__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmal(arg1, arg2, x);
}

void test__fmax__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fmax(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fmax__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fmax(arg1, arg2);
}

void test__fmax__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fmax(arg1, arg2) > 10) || (fmax(arg1, arg2) < 100)) {}
}

void test__fmax__leakignore() {
  char *p = malloc(10); *p=0;
  result = fmax(p, arg2);
  // cppcheck-suppress memleak
}

void test__fmax__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmax(x, arg2);
}

void test__fmax__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmax(arg1, x);
}

void test__std__fmax__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fmax(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fmax__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fmax(arg1, arg2);
}

void test__std__fmax__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fmax(arg1, arg2) > 10) || (std::fmax(arg1, arg2) < 100)) {}
}

void test__std__fmax__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmax(x, arg2);
}

void test__std__fmax__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmax(arg1, x);
}

void test__fmaxf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fmaxf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fmaxf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fmaxf(arg1, arg2);
}

void test__fmaxf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fmaxf(arg1, arg2) > 10) || (fmaxf(arg1, arg2) < 100)) {}
}

void test__fmaxf__leakignore() {
  char *p = malloc(10); *p=0;
  result = fmaxf(p, arg2);
  // cppcheck-suppress memleak
}

void test__fmaxf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmaxf(x, arg2);
}

void test__fmaxf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmaxf(arg1, x);
}

void test__std__fmaxf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fmaxf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fmaxf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fmaxf(arg1, arg2);
}

void test__std__fmaxf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fmaxf(arg1, arg2) > 10) || (std::fmaxf(arg1, arg2) < 100)) {}
}

void test__std__fmaxf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmaxf(x, arg2);
}

void test__std__fmaxf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmaxf(arg1, x);
}

void test__fmaxl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fmaxl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fmaxl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fmaxl(arg1, arg2);
}

void test__fmaxl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fmaxl(arg1, arg2) > 10) || (fmaxl(arg1, arg2) < 100)) {}
}

void test__fmaxl__leakignore() {
  char *p = malloc(10); *p=0;
  result = fmaxl(p, arg2);
  // cppcheck-suppress memleak
}

void test__fmaxl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmaxl(x, arg2);
}

void test__fmaxl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmaxl(arg1, x);
}

void test__std__fmaxl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fmaxl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fmaxl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fmaxl(arg1, arg2);
}

void test__std__fmaxl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fmaxl(arg1, arg2) > 10) || (std::fmaxl(arg1, arg2) < 100)) {}
}

void test__std__fmaxl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmaxl(x, arg2);
}

void test__std__fmaxl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmaxl(arg1, x);
}

void test__fmin__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fmin(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fmin__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fmin(arg1, arg2);
}

void test__fmin__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fmin(arg1, arg2) > 10) || (fmin(arg1, arg2) < 100)) {}
}

void test__fmin__leakignore() {
  char *p = malloc(10); *p=0;
  result = fmin(p, arg2);
  // cppcheck-suppress memleak
}

void test__fmin__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmin(x, arg2);
}

void test__fmin__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmin(arg1, x);
}

void test__std__fmin__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fmin(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fmin__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fmin(arg1, arg2);
}

void test__std__fmin__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fmin(arg1, arg2) > 10) || (std::fmin(arg1, arg2) < 100)) {}
}

void test__std__fmin__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmin(x, arg2);
}

void test__std__fmin__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmin(arg1, x);
}

void test__fminf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fminf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fminf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fminf(arg1, arg2);
}

void test__fminf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fminf(arg1, arg2) > 10) || (fminf(arg1, arg2) < 100)) {}
}

void test__fminf__leakignore() {
  char *p = malloc(10); *p=0;
  result = fminf(p, arg2);
  // cppcheck-suppress memleak
}

void test__fminf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fminf(x, arg2);
}

void test__fminf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fminf(arg1, x);
}

void test__std__fminf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fminf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fminf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fminf(arg1, arg2);
}

void test__std__fminf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fminf(arg1, arg2) > 10) || (std::fminf(arg1, arg2) < 100)) {}
}

void test__std__fminf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fminf(x, arg2);
}

void test__std__fminf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fminf(arg1, x);
}

void test__fminl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fminl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fminl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fminl(arg1, arg2);
}

void test__fminl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fminl(arg1, arg2) > 10) || (fminl(arg1, arg2) < 100)) {}
}

void test__fminl__leakignore() {
  char *p = malloc(10); *p=0;
  result = fminl(p, arg2);
  // cppcheck-suppress memleak
}

void test__fminl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fminl(x, arg2);
}

void test__fminl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fminl(arg1, x);
}

void test__std__fminl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fminl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fminl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fminl(arg1, arg2);
}

void test__std__fminl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fminl(arg1, arg2) > 10) || (std::fminl(arg1, arg2) < 100)) {}
}

void test__std__fminl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fminl(x, arg2);
}

void test__std__fminl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fminl(arg1, x);
}

void test__fmod__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fmod(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fmod__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fmod(arg1, arg2);
}

void test__fmod__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fmod(arg1, arg2) > 10) || (fmod(arg1, arg2) < 100)) {}
}

void test__fmod__leakignore() {
  char *p = malloc(10); *p=0;
  result = fmod(p, arg2);
  // cppcheck-suppress memleak
}

void test__fmod__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmod(x, arg2);
}

void test__fmod__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmod(arg1, x);
}

void test__std__fmod__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fmod(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fmod__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fmod(arg1, arg2);
}

void test__std__fmod__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fmod(arg1, arg2) > 10) || (std::fmod(arg1, arg2) < 100)) {}
}

void test__std__fmod__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmod(x, arg2);
}

void test__std__fmod__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmod(arg1, x);
}

void test__fmodf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fmodf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fmodf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fmodf(arg1, arg2);
}

void test__fmodf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fmodf(arg1, arg2) > 10) || (fmodf(arg1, arg2) < 100)) {}
}

void test__fmodf__leakignore() {
  char *p = malloc(10); *p=0;
  result = fmodf(p, arg2);
  // cppcheck-suppress memleak
}

void test__fmodf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmodf(x, arg2);
}

void test__fmodf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmodf(arg1, x);
}

void test__std__fmodf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fmodf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fmodf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fmodf(arg1, arg2);
}

void test__std__fmodf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fmodf(arg1, arg2) > 10) || (std::fmodf(arg1, arg2) < 100)) {}
}

void test__std__fmodf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmodf(x, arg2);
}

void test__std__fmodf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmodf(arg1, x);
}

void test__fmodl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fmodl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fmodl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fmodl(arg1, arg2);
}

void test__fmodl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fmodl(arg1, arg2) > 10) || (fmodl(arg1, arg2) < 100)) {}
}

void test__fmodl__leakignore() {
  char *p = malloc(10); *p=0;
  result = fmodl(p, arg2);
  // cppcheck-suppress memleak
}

void test__fmodl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmodl(x, arg2);
}

void test__fmodl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fmodl(arg1, x);
}

void test__std__fmodl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fmodl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fmodl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fmodl(arg1, arg2);
}

void test__std__fmodl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fmodl(arg1, arg2) > 10) || (std::fmodl(arg1, arg2) < 100)) {}
}

void test__std__fmodl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmodl(x, arg2);
}

void test__std__fmodl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fmodl(arg1, x);
}

void test__fopen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fopen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fopen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fopen(arg1, arg2);
}

void test__fopen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = fopen(NULL, arg2);
}

void test__fopen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = fopen(x, arg2);
}

void test__fopen__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = fopen(arg1, NULL);
}

void test__fopen__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = fopen(arg1, x);
}

void test__std__fopen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fopen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fopen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fopen(arg1, arg2);
}

void test__std__fopen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::fopen(NULL, arg2);
}

void test__std__fopen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::fopen(x, arg2);
}

void test__std__fopen__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::fopen(arg1, NULL);
}

void test__std__fopen__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::fopen(arg1, x);
}

void test__fopen_s__noreturn() {
  int x = 1;
  if (cond) { x=100; fopen_s(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fopen_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fopen_s(NULL, arg2, arg3);
}

void test__fopen_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  fopen_s(arg1, NULL, arg3);
}

void test__fopen_s__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fopen_s(arg1, x, arg3);
}

void test__fopen_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  fopen_s(arg1, arg2, NULL);
}

void test__fopen_s__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fopen_s(arg1, arg2, x);
}

void test__fprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; fprintf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fprintf__leakignore() {
  char *p = malloc(10); *p=0;
  fprintf(p, arg2);
  // cppcheck-suppress memleak
}

void test__fprintf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fprintf(NULL, arg2);
}

void test__fprintf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fprintf(x, arg2);
}

void test__fprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fprintf(arg1, x);
}

void test__std__fprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fprintf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fprintf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fprintf(NULL, arg2);
}

void test__std__fprintf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fprintf(x, arg2);
}

void test__std__fprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fprintf(arg1, x);
}

void test__vfprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; vfprintf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vfprintf__leakignore() {
  char *p = malloc(10); *p=0;
  vfprintf(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__vfprintf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  vfprintf(NULL, arg2, arg3);
}

void test__vfprintf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  vfprintf(x, arg2, arg3);
}

void test__vfprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  vfprintf(arg1, x, arg3);
}

void test__std__vfprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vfprintf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vfprintf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::vfprintf(NULL, arg2, arg3);
}

void test__std__vfprintf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::vfprintf(x, arg2, arg3);
}

void test__std__vfprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::vfprintf(arg1, x, arg3);
}

void test__vfwprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; vfwprintf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vfwprintf__leakignore() {
  char *p = malloc(10); *p=0;
  vfwprintf(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__vfwprintf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  vfwprintf(NULL, arg2, arg3);
}

void test__vfwprintf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  vfwprintf(x, arg2, arg3);
}

void test__vfwprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  vfwprintf(arg1, x, arg3);
}

void test__std__vfwprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vfwprintf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vfwprintf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::vfwprintf(NULL, arg2, arg3);
}

void test__std__vfwprintf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::vfwprintf(x, arg2, arg3);
}

void test__std__vfwprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::vfwprintf(arg1, x, arg3);
}

void test__fputc__noreturn() {
  int x = 1;
  if (cond) { x=100; fputc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fputc__leakignore() {
  char *p = malloc(10); *p=0;
  fputc(p, arg2);
  // cppcheck-suppress memleak
}

void test__fputc__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  fputc(!x, arg2);
}

void test__fputc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fputc(x, arg2);
}

void test__fputc__arg2__notnull() {
  // cppcheck-suppress nullPointer
  fputc(arg1, NULL);
}

void test__fputc__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fputc(arg1, x);
}

void test__std__fputc__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fputc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fputc__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::fputc(!x, arg2);
}

void test__std__fputc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fputc(x, arg2);
}

void test__std__fputc__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::fputc(arg1, NULL);
}

void test__std__fputc__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fputc(arg1, x);
}

void test__fputwc__noreturn() {
  int x = 1;
  if (cond) { x=100; fputwc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fputwc__leakignore() {
  char *p = malloc(10); *p=0;
  fputwc(p, arg2);
  // cppcheck-suppress memleak
}

void test__fputwc__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  fputwc(!x, arg2);
}

void test__fputwc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fputwc(x, arg2);
}

void test__fputwc__arg2__notnull() {
  // cppcheck-suppress nullPointer
  fputwc(arg1, NULL);
}

void test__fputwc__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fputwc(arg1, x);
}

void test__std__fputwc__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fputwc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fputwc__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::fputwc(!x, arg2);
}

void test__std__fputwc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fputwc(x, arg2);
}

void test__std__fputwc__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::fputwc(arg1, NULL);
}

void test__std__fputwc__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fputwc(arg1, x);
}

void test__fputs__noreturn() {
  int x = 1;
  if (cond) { x=100; fputs(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fputs__leakignore() {
  char *p = malloc(10); *p=0;
  fputs(p, arg2);
  // cppcheck-suppress memleak
}

void test__fputs__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fputs(NULL, arg2);
}

void test__fputs__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fputs(x, arg2);
}

void test__fputs__arg2__notnull() {
  // cppcheck-suppress nullPointer
  fputs(arg1, NULL);
}

void test__fputs__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fputs(arg1, x);
}

void test__std__fputs__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fputs(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fputs__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fputs(NULL, arg2);
}

void test__std__fputs__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fputs(x, arg2);
}

void test__std__fputs__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::fputs(arg1, NULL);
}

void test__std__fputs__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fputs(arg1, x);
}

void test__fputws__noreturn() {
  int x = 1;
  if (cond) { x=100; fputws(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fputws__leakignore() {
  char *p = malloc(10); *p=0;
  fputws(p, arg2);
  // cppcheck-suppress memleak
}

void test__fputws__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fputws(NULL, arg2);
}

void test__fputws__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fputws(x, arg2);
}

void test__fputws__arg2__notnull() {
  // cppcheck-suppress nullPointer
  fputws(arg1, NULL);
}

void test__fputws__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fputws(arg1, x);
}

void test__std__fputws__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fputws(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fputws__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fputws(NULL, arg2);
}

void test__std__fputws__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fputws(x, arg2);
}

void test__std__fputws__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::fputws(arg1, NULL);
}

void test__std__fputws__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fputws(arg1, x);
}

void test__fread__noreturn() {
  int x = 1;
  if (cond) { x=100; fread(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fread__leakignore() {
  char *p = malloc(10); *p=0;
  fread(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__fread__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fread(NULL, arg2, arg3, arg4);
}

void test__fread__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fread(arg1, x, arg3, arg4);
}

void test__fread__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fread(arg1, arg2, x, arg4);
}

void test__fread__arg4__notnull() {
  // cppcheck-suppress nullPointer
  fread(arg1, arg2, arg3, NULL);
}

void test__fread__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fread(arg1, arg2, arg3, x);
}

void test__std__fread__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fread(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fread__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fread(NULL, arg2, arg3, arg4);
}

void test__std__fread__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fread(arg1, x, arg3, arg4);
}

void test__std__fread__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fread(arg1, arg2, x, arg4);
}

void test__std__fread__arg4__notnull() {
  // cppcheck-suppress nullPointer
  std::fread(arg1, arg2, arg3, NULL);
}

void test__std__fread__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fread(arg1, arg2, arg3, x);
}

void test__free__noreturn() {
  int x = 1;
  if (cond) { x=100; free(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__free__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  free(x);
}

void test__std__free__noreturn() {
  int x = 1;
  if (cond) { x=100; std::free(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__free__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::free(x);
}

void test__freopen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = freopen(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__freopen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  freopen(arg1, arg2, arg3);
}

void test__freopen__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = freopen(x, arg2, arg3);
}

void test__freopen__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = freopen(arg1, NULL, arg3);
}

void test__freopen__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = freopen(arg1, x, arg3);
}

void test__freopen__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = freopen(arg1, arg2, NULL);
}

void test__freopen__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = freopen(arg1, arg2, x);
}

void test__std__freopen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::freopen(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__freopen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::freopen(arg1, arg2, arg3);
}

void test__std__freopen__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::freopen(x, arg2, arg3);
}

void test__std__freopen__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::freopen(arg1, NULL, arg3);
}

void test__std__freopen__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::freopen(arg1, x, arg3);
}

void test__std__freopen__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = std::freopen(arg1, arg2, NULL);
}

void test__std__freopen__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::freopen(arg1, arg2, x);
}

void test__freopen_s__noreturn() {
  int x = 1;
  if (cond) { x=100; result = freopen_s(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__freopen_s__useretval() {
  // cppcheck-suppress ignoredReturnValue
  freopen_s(arg1, arg2, arg3, arg4);
}

void test__freopen_s__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = freopen_s(x, arg2, arg3, arg4);
}

void test__freopen_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = freopen_s(arg1, x, arg3, arg4);
}

void test__freopen_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = freopen_s(arg1, arg2, NULL, arg4);
}

void test__freopen_s__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = freopen_s(arg1, arg2, x, arg4);
}

void test__freopen_s__arg4__notnull() {
  // cppcheck-suppress nullPointer
  result = freopen_s(arg1, arg2, arg3, NULL);
}

void test__freopen_s__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = freopen_s(arg1, arg2, arg3, x);
}

void test__frexp__noreturn() {
  int x = 1;
  if (cond) { x=100; frexp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__frexp__leakignore() {
  char *p = malloc(10); *p=0;
  frexp(p, arg2);
  // cppcheck-suppress memleak
}

void test__frexp__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  frexp(x, arg2);
}

void test__frexp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  frexp(arg1, NULL);
}

void test__std__frexp__noreturn() {
  int x = 1;
  if (cond) { x=100; std::frexp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__frexp__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::frexp(x, arg2);
}

void test__std__frexp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::frexp(arg1, NULL);
}

void test__frexpf__noreturn() {
  int x = 1;
  if (cond) { x=100; frexpf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__frexpf__leakignore() {
  char *p = malloc(10); *p=0;
  frexpf(p, arg2);
  // cppcheck-suppress memleak
}

void test__frexpf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  frexpf(x, arg2);
}

void test__frexpf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  frexpf(arg1, NULL);
}

void test__std__frexpf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::frexpf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__frexpf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::frexpf(x, arg2);
}

void test__std__frexpf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::frexpf(arg1, NULL);
}

void test__frexpl__noreturn() {
  int x = 1;
  if (cond) { x=100; frexpl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__frexpl__leakignore() {
  char *p = malloc(10); *p=0;
  frexpl(p, arg2);
  // cppcheck-suppress memleak
}

void test__frexpl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  frexpl(x, arg2);
}

void test__frexpl__arg2__notnull() {
  // cppcheck-suppress nullPointer
  frexpl(arg1, NULL);
}

void test__std__frexpl__noreturn() {
  int x = 1;
  if (cond) { x=100; std::frexpl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__frexpl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::frexpl(x, arg2);
}

void test__std__frexpl__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::frexpl(arg1, NULL);
}

void test__hypot__noreturn() {
  int x = 1;
  if (cond) { x=100; result = hypot(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__hypot__useretval() {
  // cppcheck-suppress ignoredReturnValue
  hypot(arg1, arg2, arg3);
}

void test__hypot__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((hypot(arg1, arg2, arg3) > 10) || (hypot(arg1, arg2, arg3) < 100)) {}
}

void test__hypot__leakignore() {
  char *p = malloc(10); *p=0;
  result = hypot(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__hypot__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = hypot(x, arg2, arg3);
}

void test__hypot__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = hypot(arg1, x, arg3);
}

void test__hypot__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = hypot(arg1, arg2, x);
}

void test__std__hypot__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::hypot(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__hypot__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::hypot(arg1, arg2, arg3);
}

void test__std__hypot__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::hypot(arg1, arg2, arg3) > 10) || (std::hypot(arg1, arg2, arg3) < 100)) {}
}

void test__std__hypot__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::hypot(x, arg2, arg3);
}

void test__std__hypot__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::hypot(arg1, x, arg3);
}

void test__std__hypot__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::hypot(arg1, arg2, x);
}

void test__hypotf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = hypotf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__hypotf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  hypotf(arg1, arg2);
}

void test__hypotf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((hypotf(arg1, arg2) > 10) || (hypotf(arg1, arg2) < 100)) {}
}

void test__hypotf__leakignore() {
  char *p = malloc(10); *p=0;
  result = hypotf(p, arg2);
  // cppcheck-suppress memleak
}

void test__hypotf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = hypotf(x, arg2);
}

void test__hypotf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = hypotf(arg1, x);
}

void test__std__hypotf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::hypotf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__hypotf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::hypotf(arg1, arg2);
}

void test__std__hypotf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::hypotf(arg1, arg2) > 10) || (std::hypotf(arg1, arg2) < 100)) {}
}

void test__std__hypotf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::hypotf(x, arg2);
}

void test__std__hypotf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::hypotf(arg1, x);
}

void test__hypotl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = hypotl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__hypotl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  hypotl(arg1, arg2);
}

void test__hypotl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((hypotl(arg1, arg2) > 10) || (hypotl(arg1, arg2) < 100)) {}
}

void test__hypotl__leakignore() {
  char *p = malloc(10); *p=0;
  result = hypotl(p, arg2);
  // cppcheck-suppress memleak
}

void test__hypotl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = hypotl(x, arg2);
}

void test__hypotl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = hypotl(arg1, x);
}

void test__std__hypotl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::hypotl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__hypotl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::hypotl(arg1, arg2);
}

void test__std__hypotl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::hypotl(arg1, arg2) > 10) || (std::hypotl(arg1, arg2) < 100)) {}
}

void test__std__hypotl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::hypotl(x, arg2);
}

void test__std__hypotl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::hypotl(arg1, x);
}

void test__fscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; fscanf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fscanf__leakignore() {
  char *p = malloc(10); *p=0;
  fscanf(p, arg2);
  // cppcheck-suppress memleak
}

void test__fscanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fscanf(x, arg2);
}

void test__fscanf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fscanf(arg1, x);
}

void test__std__fscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fscanf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fscanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fscanf(x, arg2);
}

void test__std__fscanf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fscanf(arg1, x);
}

void test__vfscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; vfscanf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vfscanf__leakignore() {
  char *p = malloc(10); *p=0;
  vfscanf(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__vfscanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  vfscanf(x, arg2, arg3);
}

void test__vfscanf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  vfscanf(arg1, x, arg3);
}

void test__std__vfscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vfscanf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vfscanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::vfscanf(x, arg2, arg3);
}

void test__std__vfscanf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::vfscanf(arg1, x, arg3);
}

void test__vfwscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; vfwscanf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vfwscanf__leakignore() {
  char *p = malloc(10); *p=0;
  vfwscanf(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__vfwscanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  vfwscanf(x, arg2, arg3);
}

void test__vfwscanf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  vfwscanf(arg1, NULL, arg3);
}

void test__vfwscanf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  vfwscanf(arg1, x, arg3);
}

void test__std__vfwscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vfwscanf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vfwscanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::vfwscanf(x, arg2, arg3);
}

void test__std__vfwscanf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::vfwscanf(arg1, NULL, arg3);
}

void test__std__vfwscanf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::vfwscanf(arg1, x, arg3);
}

void test__fseek__noreturn() {
  int x = 1;
  if (cond) { x=100; fseek(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fseek__leakignore() {
  char *p = malloc(10); *p=0;
  fseek(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__fseek__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fseek(NULL, arg2, arg3);
}

void test__fseek__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fseek(x, arg2, arg3);
}

void test__fseek__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fseek(arg1, x, arg3);
}

void test__fseek__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fseek(arg1, arg2, x);
}

void test__std__fseek__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fseek(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fseek__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fseek(NULL, arg2, arg3);
}

void test__std__fseek__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fseek(x, arg2, arg3);
}

void test__std__fseek__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fseek(arg1, x, arg3);
}

void test__std__fseek__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fseek(arg1, arg2, x);
}

void test__fsetpos__noreturn() {
  int x = 1;
  if (cond) { x=100; fsetpos(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fsetpos__leakignore() {
  char *p = malloc(10); *p=0;
  fsetpos(p, arg2);
  // cppcheck-suppress memleak
}

void test__fsetpos__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fsetpos(NULL, arg2);
}

void test__fsetpos__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fsetpos(x, arg2);
}

void test__fsetpos__arg2__notnull() {
  // cppcheck-suppress nullPointer
  fsetpos(arg1, NULL);
}

void test__fsetpos__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fsetpos(arg1, x);
}

void test__std__fsetpos__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fsetpos(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fsetpos__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fsetpos(NULL, arg2);
}

void test__std__fsetpos__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fsetpos(x, arg2);
}

void test__std__fsetpos__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::fsetpos(arg1, NULL);
}

void test__std__fsetpos__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fsetpos(arg1, x);
}

void test__fgets__noreturn() {
  int x = 1;
  if (cond) { x=100; fgets(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fgets__leakignore() {
  char *p = malloc(10); *p=0;
  fgets(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__fgets__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fgets(NULL, arg2, arg3);
}

void test__fgets__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  fgets(arg1, !x, arg3);
}

void test__fgets__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fgets(arg1, x, arg3);
}

void test__fgets__arg3__notnull() {
  // cppcheck-suppress nullPointer
  fgets(arg1, arg2, NULL);
}

void test__fgets__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fgets(arg1, arg2, x);
}

void test__std__fgets__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fgets(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fgets__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fgets(NULL, arg2, arg3);
}

void test__std__fgets__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::fgets(arg1, !x, arg3);
}

void test__std__fgets__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fgets(arg1, x, arg3);
}

void test__std__fgets__arg3__notnull() {
  // cppcheck-suppress nullPointer
  std::fgets(arg1, arg2, NULL);
}

void test__std__fgets__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fgets(arg1, arg2, x);
}

void test__fgetws__noreturn() {
  int x = 1;
  if (cond) { x=100; fgetws(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fgetws__leakignore() {
  char *p = malloc(10); *p=0;
  fgetws(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__fgetws__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fgetws(NULL, arg2, arg3);
}

void test__fgetws__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  fgetws(arg1, !x, arg3);
}

void test__fgetws__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fgetws(arg1, x, arg3);
}

void test__fgetws__arg3__notnull() {
  // cppcheck-suppress nullPointer
  fgetws(arg1, arg2, NULL);
}

void test__fgetws__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fgetws(arg1, arg2, x);
}

void test__std__fgetws__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fgetws(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fgetws__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fgetws(NULL, arg2, arg3);
}

void test__std__fgetws__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::fgetws(arg1, !x, arg3);
}

void test__std__fgetws__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fgetws(arg1, x, arg3);
}

void test__std__fgetws__arg3__notnull() {
  // cppcheck-suppress nullPointer
  std::fgetws(arg1, arg2, NULL);
}

void test__std__fgetws__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fgetws(arg1, arg2, x);
}

void test__ftell__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ftell(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ftell__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ftell(arg1);
}

void test__ftell__leakignore() {
  char *p = malloc(10); *p=0;
  result = ftell(p);
  // cppcheck-suppress memleak
}

void test__ftell__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = ftell(NULL);
}

void test__ftell__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = ftell(x);
}

void test__std__ftell__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ftell(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ftell__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ftell(arg1);
}

void test__std__ftell__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::ftell(NULL);
}

void test__std__ftell__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::ftell(x);
}

void test__fwide__noreturn() {
  int x = 1;
  if (cond) { x=100; fwide(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fwide__leakignore() {
  char *p = malloc(10); *p=0;
  fwide(p, arg2);
  // cppcheck-suppress memleak
}

void test__fwide__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fwide(NULL, arg2);
}

void test__fwide__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fwide(x, arg2);
}

void test__fwide__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fwide(arg1, x);
}

void test__std__fwide__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fwide(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fwide__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fwide(NULL, arg2);
}

void test__std__fwide__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fwide(x, arg2);
}

void test__std__fwide__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fwide(arg1, x);
}

void test__fwrite__noreturn() {
  int x = 1;
  if (cond) { x=100; fwrite(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fwrite__leakignore() {
  char *p = malloc(10); *p=0;
  fwrite(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__fwrite__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fwrite(NULL, arg2, arg3, arg4);
}

void test__fwrite__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fwrite(x, arg2, arg3, arg4);
}

void test__fwrite__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fwrite(arg1, x, arg3, arg4);
}

void test__fwrite__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fwrite(arg1, arg2, x, arg4);
}

void test__fwrite__arg4__notnull() {
  // cppcheck-suppress nullPointer
  fwrite(arg1, arg2, arg3, NULL);
}

void test__fwrite__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fwrite(arg1, arg2, arg3, x);
}

void test__std__fwrite__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fwrite(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fwrite__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fwrite(NULL, arg2, arg3, arg4);
}

void test__std__fwrite__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fwrite(x, arg2, arg3, arg4);
}

void test__std__fwrite__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fwrite(arg1, x, arg3, arg4);
}

void test__std__fwrite__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fwrite(arg1, arg2, x, arg4);
}

void test__std__fwrite__arg4__notnull() {
  // cppcheck-suppress nullPointer
  std::fwrite(arg1, arg2, arg3, NULL);
}

void test__std__fwrite__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fwrite(arg1, arg2, arg3, x);
}

void test__mblen__noreturn() {
  int x = 1;
  if (cond) { x=100; mblen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mblen__leakignore() {
  char *p = malloc(10); *p=0;
  mblen(p, arg2);
  // cppcheck-suppress memleak
}

void test__mblen__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mblen(x, arg2);
}

void test__mblen__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mblen(arg1, x);
}

void test__std__mblen__noreturn() {
  int x = 1;
  if (cond) { x=100; std::mblen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__mblen__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::mblen(x, arg2);
}

void test__std__mblen__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::mblen(arg1, x);
}

void test__mbtowc__noreturn() {
  int x = 1;
  if (cond) { x=100; mbtowc(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mbtowc__leakignore() {
  char *p = malloc(10); *p=0;
  mbtowc(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__mbtowc__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mbtowc(arg1, x, arg3);
}

void test__mbtowc__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mbtowc(arg1, arg2, x);
}

void test__std__mbtowc__noreturn() {
  int x = 1;
  if (cond) { x=100; std::mbtowc(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__mbtowc__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::mbtowc(arg1, x, arg3);
}

void test__std__mbtowc__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::mbtowc(arg1, arg2, x);
}

void test__mbrlen__noreturn() {
  int x = 1;
  if (cond) { x=100; mbrlen(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mbrlen__leakignore() {
  char *p = malloc(10); *p=0;
  mbrlen(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__mbrlen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  mbrlen(NULL, arg2, arg3);
}

void test__mbrlen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  mbrlen(x, arg2, arg3);
}

void test__mbrlen__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mbrlen(arg1, x, arg3);
}

void test__mbrlen__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mbrlen(arg1, arg2, x);
}

void test__std__mbrlen__noreturn() {
  int x = 1;
  if (cond) { x=100; std::mbrlen(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__mbrlen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::mbrlen(NULL, arg2, arg3);
}

void test__std__mbrlen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::mbrlen(x, arg2, arg3);
}

void test__std__mbrlen__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::mbrlen(arg1, x, arg3);
}

void test__std__mbrlen__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::mbrlen(arg1, arg2, x);
}

void test__btowc__noreturn() {
  int x = 1;
  if (cond) { x=100; result = btowc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__btowc__useretval() {
  // cppcheck-suppress ignoredReturnValue
  btowc(arg1);
}

void test__btowc__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((btowc(arg1) > 10) || (btowc(arg1) < 100)) {}
}

void test__btowc__leakignore() {
  char *p = malloc(10); *p=0;
  result = btowc(p);
  // cppcheck-suppress memleak
}

void test__btowc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = btowc(x);
}

void test__std__btowc__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::btowc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__btowc__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::btowc(arg1);
}

void test__std__btowc__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::btowc(arg1) > 10) || (std::btowc(arg1) < 100)) {}
}

void test__std__btowc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::btowc(x);
}

void test__mbsinit__noreturn() {
  int x = 1;
  if (cond) { x=100; mbsinit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mbsinit__leakignore() {
  char *p = malloc(10); *p=0;
  mbsinit(p);
  // cppcheck-suppress memleak
}

void test__mbsinit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mbsinit(x);
}

void test__std__mbsinit__noreturn() {
  int x = 1;
  if (cond) { x=100; std::mbsinit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__mbsinit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::mbsinit(x);
}

void test__getwchar__noreturn() {
  int x = 1;
  if (cond) { x=100; getwchar(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getwchar__leakignore() {
  char *p = malloc(10); *p=0;
  getwchar();
  // cppcheck-suppress memleak
}

void test__mbstowcs__noreturn() {
  int x = 1;
  if (cond) { x=100; mbstowcs(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mbstowcs__leakignore() {
  char *p = malloc(10); *p=0;
  mbstowcs(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__mbstowcs__arg2__notnull() {
  // cppcheck-suppress nullPointer
  mbstowcs(arg1, NULL, arg3);
}

void test__mbstowcs__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  mbstowcs(arg1, x, arg3);
}

void test__mbstowcs__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mbstowcs(arg1, arg2, x);
}

void test__std__mbstowcs__noreturn() {
  int x = 1;
  if (cond) { x=100; std::mbstowcs(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__mbstowcs__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::mbstowcs(arg1, NULL, arg3);
}

void test__std__mbstowcs__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::mbstowcs(arg1, x, arg3);
}

void test__std__mbstowcs__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::mbstowcs(arg1, arg2, x);
}

void test__mbsrtowcs__noreturn() {
  int x = 1;
  if (cond) { x=100; mbsrtowcs(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mbsrtowcs__leakignore() {
  char *p = malloc(10); *p=0;
  mbsrtowcs(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__mbsrtowcs__arg2__notnull() {
  // cppcheck-suppress nullPointer
  mbsrtowcs(arg1, NULL, arg3, arg4);
}

void test__mbsrtowcs__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  mbsrtowcs(arg1, x, arg3, arg4);
}

void test__mbsrtowcs__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mbsrtowcs(arg1, arg2, x, arg4);
}

void test__mbsrtowcs__arg4__notnull() {
  // cppcheck-suppress nullPointer
  mbsrtowcs(arg1, arg2, arg3, NULL);
}

void test__std__mbsrtowcs__noreturn() {
  int x = 1;
  if (cond) { x=100; std::mbsrtowcs(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__mbsrtowcs__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::mbsrtowcs(arg1, NULL, arg3, arg4);
}

void test__std__mbsrtowcs__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::mbsrtowcs(arg1, x, arg3, arg4);
}

void test__std__mbsrtowcs__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::mbsrtowcs(arg1, arg2, x, arg4);
}

void test__std__mbsrtowcs__arg4__notnull() {
  // cppcheck-suppress nullPointer
  std::mbsrtowcs(arg1, arg2, arg3, NULL);
}

void test__wctob__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wctob(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wctob__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wctob(arg1);
}

void test__wctob__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((wctob(arg1) > 10) || (wctob(arg1) < 100)) {}
}

void test__wctob__leakignore() {
  char *p = malloc(10); *p=0;
  result = wctob(p);
  // cppcheck-suppress memleak
}

void test__wctob__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = wctob(x);
}

void test__std__wctob__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wctob(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wctob__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wctob(arg1);
}

void test__std__wctob__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::wctob(arg1) > 10) || (std::wctob(arg1) < 100)) {}
}

void test__std__wctob__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wctob(x);
}

void test__wctomb__noreturn() {
  int x = 1;
  if (cond) { x=100; wctomb(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wctomb__leakignore() {
  char *p = malloc(10); *p=0;
  wctomb(p, arg2);
  // cppcheck-suppress memleak
}

void test__wctomb__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wctomb(x, arg2);
}

void test__wctomb__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wctomb(arg1, x);
}

void test__std__wctomb__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wctomb(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wctomb__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wctomb(x, arg2);
}

void test__std__wctomb__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wctomb(arg1, x);
}

void test__wcstombs__noreturn() {
  int x = 1;
  if (cond) { x=100; wcstombs(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcstombs__leakignore() {
  char *p = malloc(10); *p=0;
  wcstombs(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcstombs__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wcstombs(arg1, NULL, arg3);
}

void test__wcstombs__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcstombs(arg1, x, arg3);
}

void test__wcstombs__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcstombs(arg1, arg2, x);
}

void test__std__wcstombs__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wcstombs(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcstombs__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::wcstombs(arg1, NULL, arg3);
}

void test__std__wcstombs__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcstombs(arg1, x, arg3);
}

void test__std__wcstombs__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wcstombs(arg1, arg2, x);
}

void test__getchar__noreturn() {
  int x = 1;
  if (cond) { x=100; getchar(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getchar__leakignore() {
  char *p = malloc(10); *p=0;
  getchar();
  // cppcheck-suppress memleak
}

void test__ungetc__noreturn() {
  int x = 1;
  if (cond) { x=100; ungetc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ungetc__leakignore() {
  char *p = malloc(10); *p=0;
  ungetc(p, arg2);
  // cppcheck-suppress memleak
}

void test__ungetc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ungetc(x, arg2);
}

void test__ungetc__arg2__notnull() {
  // cppcheck-suppress nullPointer
  ungetc(arg1, NULL);
}

void test__ungetc__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  ungetc(arg1, x);
}

void test__std__ungetc__noreturn() {
  int x = 1;
  if (cond) { x=100; std::ungetc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ungetc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::ungetc(x, arg2);
}

void test__std__ungetc__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::ungetc(arg1, NULL);
}

void test__std__ungetc__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::ungetc(arg1, x);
}

void test__ungetwc__noreturn() {
  int x = 1;
  if (cond) { x=100; ungetwc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ungetwc__leakignore() {
  char *p = malloc(10); *p=0;
  ungetwc(p, arg2);
  // cppcheck-suppress memleak
}

void test__ungetwc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ungetwc(x, arg2);
}

void test__ungetwc__arg2__notnull() {
  // cppcheck-suppress nullPointer
  ungetwc(arg1, NULL);
}

void test__ungetwc__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  ungetwc(arg1, x);
}

void test__std__ungetwc__noreturn() {
  int x = 1;
  if (cond) { x=100; std::ungetwc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ungetwc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::ungetwc(x, arg2);
}

void test__std__ungetwc__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::ungetwc(arg1, NULL);
}

void test__std__ungetwc__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::ungetwc(arg1, x);
}

void test__getenv__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getenv(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getenv__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getenv(arg1);
}

void test__getenv__leakignore() {
  char *p = malloc(10); *p=0;
  result = getenv(p);
  // cppcheck-suppress memleak
}

void test__getenv__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = getenv(NULL);
}

void test__getenv__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = getenv(x);
}

void test__std__getenv__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::getenv(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__getenv__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::getenv(arg1);
}

void test__std__getenv__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::getenv(NULL);
}

void test__std__getenv__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::getenv(x);
}

void test__gets__noreturn() {
  int x = 1;
  if (cond) { x=100; gets(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__gets__leakignore() {
  char *p = malloc(10); *p=0;
  gets(p);
  // cppcheck-suppress memleak
}

void test__gets__arg1__notnull() {
  // cppcheck-suppress nullPointer
  gets(NULL);
}

void test__std__gets__noreturn() {
  int x = 1;
  if (cond) { x=100; std::gets(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__gets__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::gets(NULL);
}

void test__gets_s__noreturn() {
  int x = 1;
  if (cond) { x=100; gets_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__gets_s__leakignore() {
  char *p = malloc(10); *p=0;
  gets_s(p, arg2);
  // cppcheck-suppress memleak
}

void test__gets_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  gets_s(NULL, arg2);
}

void test__gets_s__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  gets_s(arg1, !x);
}

void test__gets_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  gets_s(arg1, x);
}

void test__std__gets_s__noreturn() {
  int x = 1;
  if (cond) { x=100; std::gets_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__gets_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::gets_s(NULL, arg2);
}

void test__std__gets_s__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::gets_s(arg1, !x);
}

void test__std__gets_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::gets_s(arg1, x);
}

void test__gmtime__noreturn() {
  int x = 1;
  if (cond) { x=100; result = gmtime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__gmtime__useretval() {
  // cppcheck-suppress ignoredReturnValue
  gmtime(arg1);
}

void test__gmtime__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((gmtime(arg1) > 10) || (gmtime(arg1) < 100)) {}
}

void test__gmtime__leakignore() {
  char *p = malloc(10); *p=0;
  result = gmtime(p);
  // cppcheck-suppress memleak
}

void test__gmtime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = gmtime(NULL);
}

void test__gmtime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = gmtime(x);
}

void test__std__gmtime__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::gmtime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__gmtime__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::gmtime(arg1);
}

void test__std__gmtime__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::gmtime(arg1) > 10) || (std::gmtime(arg1) < 100)) {}
}

void test__std__gmtime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::gmtime(NULL);
}

void test__std__gmtime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::gmtime(x);
}

void test__isalnum__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isalnum(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isalnum__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isalnum(arg1);
}

void test__isalnum__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isalnum(arg1) > 10) || (isalnum(arg1) < 100)) {}
}

void test__isalnum__leakignore() {
  char *p = malloc(10); *p=0;
  result = isalnum(p);
  // cppcheck-suppress memleak
}

void test__isalnum__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isalnum(x);
}

void test__std__isalnum__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isalnum(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isalnum__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isalnum(arg1);
}

void test__std__isalnum__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isalnum(arg1) > 10) || (std::isalnum(arg1) < 100)) {}
}

void test__std__isalnum__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isalnum(x);
}

void test__iswalnum__noreturn() {
  int x = 1;
  if (cond) { x=100; result = iswalnum(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iswalnum__useretval() {
  // cppcheck-suppress ignoredReturnValue
  iswalnum(arg1);
}

void test__iswalnum__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((iswalnum(arg1) > 10) || (iswalnum(arg1) < 100)) {}
}

void test__iswalnum__leakignore() {
  char *p = malloc(10); *p=0;
  result = iswalnum(p);
  // cppcheck-suppress memleak
}

void test__iswalnum__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iswalnum(x);
}

void test__std__iswalnum__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::iswalnum(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__iswalnum__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::iswalnum(arg1);
}

void test__std__iswalnum__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::iswalnum(arg1) > 10) || (std::iswalnum(arg1) < 100)) {}
}

void test__std__iswalnum__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iswalnum(x);
}

void test__isalpha__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isalpha(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isalpha__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isalpha(arg1);
}

void test__isalpha__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isalpha(arg1) > 10) || (isalpha(arg1) < 100)) {}
}

void test__isalpha__leakignore() {
  char *p = malloc(10); *p=0;
  result = isalpha(p);
  // cppcheck-suppress memleak
}

void test__isalpha__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isalpha(x);
}

void test__std__isalpha__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isalpha(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isalpha__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isalpha(arg1);
}

void test__std__isalpha__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isalpha(arg1) > 10) || (std::isalpha(arg1) < 100)) {}
}

void test__std__isalpha__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isalpha(x);
}

void test__iswalpha__noreturn() {
  int x = 1;
  if (cond) { x=100; result = iswalpha(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iswalpha__useretval() {
  // cppcheck-suppress ignoredReturnValue
  iswalpha(arg1);
}

void test__iswalpha__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((iswalpha(arg1) > 10) || (iswalpha(arg1) < 100)) {}
}

void test__iswalpha__leakignore() {
  char *p = malloc(10); *p=0;
  result = iswalpha(p);
  // cppcheck-suppress memleak
}

void test__iswalpha__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iswalpha(x);
}

void test__std__iswalpha__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::iswalpha(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__iswalpha__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::iswalpha(arg1);
}

void test__std__iswalpha__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::iswalpha(arg1) > 10) || (std::iswalpha(arg1) < 100)) {}
}

void test__std__iswalpha__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iswalpha(x);
}

void test__isblank__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isblank(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isblank__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isblank(arg1);
}

void test__isblank__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isblank(arg1) > 10) || (isblank(arg1) < 100)) {}
}

void test__isblank__leakignore() {
  char *p = malloc(10); *p=0;
  result = isblank(p);
  // cppcheck-suppress memleak
}

void test__isblank__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isblank(x);
}

void test__std__isblank__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isblank(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isblank__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isblank(arg1);
}

void test__std__isblank__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isblank(arg1) > 10) || (std::isblank(arg1) < 100)) {}
}

void test__std__isblank__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isblank(x);
}

void test__iswblank__noreturn() {
  int x = 1;
  if (cond) { x=100; result = iswblank(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iswblank__useretval() {
  // cppcheck-suppress ignoredReturnValue
  iswblank(arg1);
}

void test__iswblank__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((iswblank(arg1) > 10) || (iswblank(arg1) < 100)) {}
}

void test__iswblank__leakignore() {
  char *p = malloc(10); *p=0;
  result = iswblank(p);
  // cppcheck-suppress memleak
}

void test__iswblank__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iswblank(x);
}

void test__std__iswblank__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::iswblank(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__iswblank__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::iswblank(arg1);
}

void test__std__iswblank__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::iswblank(arg1) > 10) || (std::iswblank(arg1) < 100)) {}
}

void test__std__iswblank__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iswblank(x);
}

void test__iscntrl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = iscntrl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iscntrl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  iscntrl(arg1);
}

void test__iscntrl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((iscntrl(arg1) > 10) || (iscntrl(arg1) < 100)) {}
}

void test__iscntrl__leakignore() {
  char *p = malloc(10); *p=0;
  result = iscntrl(p);
  // cppcheck-suppress memleak
}

void test__iscntrl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iscntrl(x);
}

void test__std__iscntrl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::iscntrl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__iscntrl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::iscntrl(arg1);
}

void test__std__iscntrl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::iscntrl(arg1) > 10) || (std::iscntrl(arg1) < 100)) {}
}

void test__std__iscntrl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iscntrl(x);
}

void test__iswcntrl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = iswcntrl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iswcntrl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  iswcntrl(arg1);
}

void test__iswcntrl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((iswcntrl(arg1) > 10) || (iswcntrl(arg1) < 100)) {}
}

void test__iswcntrl__leakignore() {
  char *p = malloc(10); *p=0;
  result = iswcntrl(p);
  // cppcheck-suppress memleak
}

void test__iswcntrl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iswcntrl(x);
}

void test__std__iswcntrl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::iswcntrl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__iswcntrl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::iswcntrl(arg1);
}

void test__std__iswcntrl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::iswcntrl(arg1) > 10) || (std::iswcntrl(arg1) < 100)) {}
}

void test__std__iswcntrl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iswcntrl(x);
}

void test__iswctype__noreturn() {
  int x = 1;
  if (cond) { x=100; result = iswctype(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iswctype__useretval() {
  // cppcheck-suppress ignoredReturnValue
  iswctype(arg1, arg2);
}

void test__iswctype__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((iswctype(arg1, arg2) > 10) || (iswctype(arg1, arg2) < 100)) {}
}

void test__iswctype__leakignore() {
  char *p = malloc(10); *p=0;
  result = iswctype(p, arg2);
  // cppcheck-suppress memleak
}

void test__iswctype__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iswctype(x, arg2);
}

void test__iswctype__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iswctype(arg1, x);
}

void test__std__iswctype__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::iswctype(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__iswctype__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::iswctype(arg1, arg2);
}

void test__std__iswctype__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::iswctype(arg1, arg2) > 10) || (std::iswctype(arg1, arg2) < 100)) {}
}

void test__std__iswctype__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iswctype(x, arg2);
}

void test__std__iswctype__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iswctype(arg1, x);
}

void test__isdigit__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isdigit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isdigit__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isdigit(arg1);
}

void test__isdigit__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isdigit(arg1) > 10) || (isdigit(arg1) < 100)) {}
}

void test__isdigit__leakignore() {
  char *p = malloc(10); *p=0;
  result = isdigit(p);
  // cppcheck-suppress memleak
}

void test__isdigit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isdigit(x);
}

void test__std__isdigit__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isdigit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isdigit__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isdigit(arg1);
}

void test__std__isdigit__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isdigit(arg1) > 10) || (std::isdigit(arg1) < 100)) {}
}

void test__std__isdigit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isdigit(x);
}

void test__iswdigit__noreturn() {
  int x = 1;
  if (cond) { x=100; result = iswdigit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iswdigit__useretval() {
  // cppcheck-suppress ignoredReturnValue
  iswdigit(arg1);
}

void test__iswdigit__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((iswdigit(arg1) > 10) || (iswdigit(arg1) < 100)) {}
}

void test__iswdigit__leakignore() {
  char *p = malloc(10); *p=0;
  result = iswdigit(p);
  // cppcheck-suppress memleak
}

void test__iswdigit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iswdigit(x);
}

void test__std__iswdigit__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::iswdigit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__iswdigit__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::iswdigit(arg1);
}

void test__std__iswdigit__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::iswdigit(arg1) > 10) || (std::iswdigit(arg1) < 100)) {}
}

void test__std__iswdigit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iswdigit(x);
}

void test__isgraph__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isgraph(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isgraph__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isgraph(arg1);
}

void test__isgraph__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isgraph(arg1) > 10) || (isgraph(arg1) < 100)) {}
}

void test__isgraph__leakignore() {
  char *p = malloc(10); *p=0;
  result = isgraph(p);
  // cppcheck-suppress memleak
}

void test__isgraph__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isgraph(x);
}

void test__std__isgraph__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isgraph(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isgraph__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isgraph(arg1);
}

void test__std__isgraph__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isgraph(arg1) > 10) || (std::isgraph(arg1) < 100)) {}
}

void test__std__isgraph__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isgraph(x);
}

void test__iswgraph__noreturn() {
  int x = 1;
  if (cond) { x=100; result = iswgraph(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iswgraph__useretval() {
  // cppcheck-suppress ignoredReturnValue
  iswgraph(arg1);
}

void test__iswgraph__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((iswgraph(arg1) > 10) || (iswgraph(arg1) < 100)) {}
}

void test__iswgraph__leakignore() {
  char *p = malloc(10); *p=0;
  result = iswgraph(p);
  // cppcheck-suppress memleak
}

void test__iswgraph__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iswgraph(x);
}

void test__std__iswgraph__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::iswgraph(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__iswgraph__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::iswgraph(arg1);
}

void test__std__iswgraph__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::iswgraph(arg1) > 10) || (std::iswgraph(arg1) < 100)) {}
}

void test__std__iswgraph__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iswgraph(x);
}

void test__islower__noreturn() {
  int x = 1;
  if (cond) { x=100; result = islower(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__islower__useretval() {
  // cppcheck-suppress ignoredReturnValue
  islower(arg1);
}

void test__islower__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((islower(arg1) > 10) || (islower(arg1) < 100)) {}
}

void test__islower__leakignore() {
  char *p = malloc(10); *p=0;
  result = islower(p);
  // cppcheck-suppress memleak
}

void test__islower__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = islower(x);
}

void test__std__islower__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::islower(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__islower__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::islower(arg1);
}

void test__std__islower__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::islower(arg1) > 10) || (std::islower(arg1) < 100)) {}
}

void test__std__islower__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::islower(x);
}

void test__iswlower__noreturn() {
  int x = 1;
  if (cond) { x=100; result = iswlower(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iswlower__useretval() {
  // cppcheck-suppress ignoredReturnValue
  iswlower(arg1);
}

void test__iswlower__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((iswlower(arg1) > 10) || (iswlower(arg1) < 100)) {}
}

void test__iswlower__leakignore() {
  char *p = malloc(10); *p=0;
  result = iswlower(p);
  // cppcheck-suppress memleak
}

void test__iswlower__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iswlower(x);
}

void test__std__iswlower__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::iswlower(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__iswlower__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::iswlower(arg1);
}

void test__std__iswlower__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::iswlower(arg1) > 10) || (std::iswlower(arg1) < 100)) {}
}

void test__std__iswlower__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iswlower(x);
}

void test__isprint__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isprint(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isprint__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isprint(arg1);
}

void test__isprint__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isprint(arg1) > 10) || (isprint(arg1) < 100)) {}
}

void test__isprint__leakignore() {
  char *p = malloc(10); *p=0;
  result = isprint(p);
  // cppcheck-suppress memleak
}

void test__isprint__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isprint(x);
}

void test__std__isprint__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isprint(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isprint__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isprint(arg1);
}

void test__std__isprint__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isprint(arg1) > 10) || (std::isprint(arg1) < 100)) {}
}

void test__std__isprint__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isprint(x);
}

void test__iswprint__noreturn() {
  int x = 1;
  if (cond) { x=100; result = iswprint(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iswprint__useretval() {
  // cppcheck-suppress ignoredReturnValue
  iswprint(arg1);
}

void test__iswprint__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((iswprint(arg1) > 10) || (iswprint(arg1) < 100)) {}
}

void test__iswprint__leakignore() {
  char *p = malloc(10); *p=0;
  result = iswprint(p);
  // cppcheck-suppress memleak
}

void test__iswprint__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iswprint(x);
}

void test__std__iswprint__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::iswprint(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__iswprint__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::iswprint(arg1);
}

void test__std__iswprint__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::iswprint(arg1) > 10) || (std::iswprint(arg1) < 100)) {}
}

void test__std__iswprint__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iswprint(x);
}

void test__ispunct__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ispunct(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ispunct__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ispunct(arg1);
}

void test__ispunct__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ispunct(arg1) > 10) || (ispunct(arg1) < 100)) {}
}

void test__ispunct__leakignore() {
  char *p = malloc(10); *p=0;
  result = ispunct(p);
  // cppcheck-suppress memleak
}

void test__ispunct__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ispunct(x);
}

void test__std__ispunct__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ispunct(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ispunct__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ispunct(arg1);
}

void test__std__ispunct__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::ispunct(arg1) > 10) || (std::ispunct(arg1) < 100)) {}
}

void test__std__ispunct__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::ispunct(x);
}

void test__iswpunct__noreturn() {
  int x = 1;
  if (cond) { x=100; result = iswpunct(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iswpunct__useretval() {
  // cppcheck-suppress ignoredReturnValue
  iswpunct(arg1);
}

void test__iswpunct__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((iswpunct(arg1) > 10) || (iswpunct(arg1) < 100)) {}
}

void test__iswpunct__leakignore() {
  char *p = malloc(10); *p=0;
  result = iswpunct(p);
  // cppcheck-suppress memleak
}

void test__iswpunct__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iswpunct(x);
}

void test__std__iswpunct__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::iswpunct(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__iswpunct__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::iswpunct(arg1);
}

void test__std__iswpunct__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::iswpunct(arg1) > 10) || (std::iswpunct(arg1) < 100)) {}
}

void test__std__iswpunct__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iswpunct(x);
}

void test__isspace__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isspace(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isspace__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isspace(arg1);
}

void test__isspace__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isspace(arg1) > 10) || (isspace(arg1) < 100)) {}
}

void test__isspace__leakignore() {
  char *p = malloc(10); *p=0;
  result = isspace(p);
  // cppcheck-suppress memleak
}

void test__isspace__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isspace(x);
}

void test__std__isspace__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isspace(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isspace__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isspace(arg1);
}

void test__std__isspace__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isspace(arg1) > 10) || (std::isspace(arg1) < 100)) {}
}

void test__std__isspace__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isspace(x);
}

void test__iswspace__noreturn() {
  int x = 1;
  if (cond) { x=100; result = iswspace(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iswspace__useretval() {
  // cppcheck-suppress ignoredReturnValue
  iswspace(arg1);
}

void test__iswspace__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((iswspace(arg1) > 10) || (iswspace(arg1) < 100)) {}
}

void test__iswspace__leakignore() {
  char *p = malloc(10); *p=0;
  result = iswspace(p);
  // cppcheck-suppress memleak
}

void test__iswspace__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iswspace(x);
}

void test__std__iswspace__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::iswspace(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__iswspace__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::iswspace(arg1);
}

void test__std__iswspace__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::iswspace(arg1) > 10) || (std::iswspace(arg1) < 100)) {}
}

void test__std__iswspace__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iswspace(x);
}

void test__isupper__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isupper(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isupper__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isupper(arg1);
}

void test__isupper__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isupper(arg1) > 10) || (isupper(arg1) < 100)) {}
}

void test__isupper__leakignore() {
  char *p = malloc(10); *p=0;
  result = isupper(p);
  // cppcheck-suppress memleak
}

void test__isupper__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isupper(x);
}

void test__std__isupper__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isupper(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isupper__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isupper(arg1);
}

void test__std__isupper__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isupper(arg1) > 10) || (std::isupper(arg1) < 100)) {}
}

void test__std__isupper__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isupper(x);
}

void test__iswupper__noreturn() {
  int x = 1;
  if (cond) { x=100; result = iswupper(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iswupper__useretval() {
  // cppcheck-suppress ignoredReturnValue
  iswupper(arg1);
}

void test__iswupper__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((iswupper(arg1) > 10) || (iswupper(arg1) < 100)) {}
}

void test__iswupper__leakignore() {
  char *p = malloc(10); *p=0;
  result = iswupper(p);
  // cppcheck-suppress memleak
}

void test__iswupper__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iswupper(x);
}

void test__std__iswupper__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::iswupper(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__iswupper__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::iswupper(arg1);
}

void test__std__iswupper__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::iswupper(arg1) > 10) || (std::iswupper(arg1) < 100)) {}
}

void test__std__iswupper__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iswupper(x);
}

void test__isxdigit__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isxdigit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isxdigit__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isxdigit(arg1);
}

void test__isxdigit__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isxdigit(arg1) > 10) || (isxdigit(arg1) < 100)) {}
}

void test__isxdigit__leakignore() {
  char *p = malloc(10); *p=0;
  result = isxdigit(p);
  // cppcheck-suppress memleak
}

void test__isxdigit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isxdigit(x);
}

void test__std__isxdigit__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isxdigit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isxdigit__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isxdigit(arg1);
}

void test__std__isxdigit__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isxdigit(arg1) > 10) || (std::isxdigit(arg1) < 100)) {}
}

void test__std__isxdigit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isxdigit(x);
}

void test__iswxdigit__noreturn() {
  int x = 1;
  if (cond) { x=100; result = iswxdigit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__iswxdigit__useretval() {
  // cppcheck-suppress ignoredReturnValue
  iswxdigit(arg1);
}

void test__iswxdigit__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((iswxdigit(arg1) > 10) || (iswxdigit(arg1) < 100)) {}
}

void test__iswxdigit__leakignore() {
  char *p = malloc(10); *p=0;
  result = iswxdigit(p);
  // cppcheck-suppress memleak
}

void test__iswxdigit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = iswxdigit(x);
}

void test__std__iswxdigit__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::iswxdigit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__iswxdigit__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::iswxdigit(arg1);
}

void test__std__iswxdigit__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::iswxdigit(arg1) > 10) || (std::iswxdigit(arg1) < 100)) {}
}

void test__std__iswxdigit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::iswxdigit(x);
}

void test__towctrans__noreturn() {
  int x = 1;
  if (cond) { x=100; result = towctrans(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__towctrans__useretval() {
  // cppcheck-suppress ignoredReturnValue
  towctrans(arg1, arg2);
}

void test__towctrans__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((towctrans(arg1, arg2) > 10) || (towctrans(arg1, arg2) < 100)) {}
}

void test__towctrans__leakignore() {
  char *p = malloc(10); *p=0;
  result = towctrans(p, arg2);
  // cppcheck-suppress memleak
}

void test__towctrans__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = towctrans(x, arg2);
}

void test__towctrans__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = towctrans(arg1, x);
}

void test__std__towctrans__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::towctrans(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__towctrans__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::towctrans(arg1, arg2);
}

void test__std__towctrans__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::towctrans(arg1, arg2) > 10) || (std::towctrans(arg1, arg2) < 100)) {}
}

void test__std__towctrans__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::towctrans(x, arg2);
}

void test__std__towctrans__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::towctrans(arg1, x);
}

void test__towlower__noreturn() {
  int x = 1;
  if (cond) { x=100; result = towlower(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__towlower__useretval() {
  // cppcheck-suppress ignoredReturnValue
  towlower(arg1);
}

void test__towlower__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((towlower(arg1) > 10) || (towlower(arg1) < 100)) {}
}

void test__towlower__leakignore() {
  char *p = malloc(10); *p=0;
  result = towlower(p);
  // cppcheck-suppress memleak
}

void test__towlower__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = towlower(x);
}

void test__std__towlower__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::towlower(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__towlower__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::towlower(arg1);
}

void test__std__towlower__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::towlower(arg1) > 10) || (std::towlower(arg1) < 100)) {}
}

void test__std__towlower__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::towlower(x);
}

void test__towupper__noreturn() {
  int x = 1;
  if (cond) { x=100; result = towupper(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__towupper__useretval() {
  // cppcheck-suppress ignoredReturnValue
  towupper(arg1);
}

void test__towupper__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((towupper(arg1) > 10) || (towupper(arg1) < 100)) {}
}

void test__towupper__leakignore() {
  char *p = malloc(10); *p=0;
  result = towupper(p);
  // cppcheck-suppress memleak
}

void test__towupper__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = towupper(x);
}

void test__std__towupper__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::towupper(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__towupper__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::towupper(arg1);
}

void test__std__towupper__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::towupper(arg1) > 10) || (std::towupper(arg1) < 100)) {}
}

void test__std__towupper__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::towupper(x);
}

void test__wctrans__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wctrans(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wctrans__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wctrans(arg1);
}

void test__wctrans__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((wctrans(arg1) > 10) || (wctrans(arg1) < 100)) {}
}

void test__wctrans__leakignore() {
  char *p = malloc(10); *p=0;
  result = wctrans(p);
  // cppcheck-suppress memleak
}

void test__wctrans__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wctrans(NULL);
}

void test__wctrans__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wctrans(x);
}

void test__std__wctrans__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wctrans(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wctrans__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wctrans(arg1);
}

void test__std__wctrans__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::wctrans(arg1) > 10) || (std::wctrans(arg1) < 100)) {}
}

void test__std__wctrans__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wctrans(NULL);
}

void test__std__wctrans__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wctrans(x);
}

void test__wctype__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wctype(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wctype__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wctype(arg1);
}

void test__wctype__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((wctype(arg1) > 10) || (wctype(arg1) < 100)) {}
}

void test__wctype__leakignore() {
  char *p = malloc(10); *p=0;
  result = wctype(p);
  // cppcheck-suppress memleak
}

void test__wctype__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wctype(NULL);
}

void test__wctype__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wctype(x);
}

void test__std__wctype__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wctype(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wctype__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wctype(arg1);
}

void test__std__wctype__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::wctype(arg1) > 10) || (std::wctype(arg1) < 100)) {}
}

void test__std__wctype__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wctype(NULL);
}

void test__std__wctype__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wctype(x);
}

void test__cabs__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cabs(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cabs__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cabs(arg1);
}

void test__cabs__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cabs(arg1) > 10) || (cabs(arg1) < 100)) {}
}

void test__cabs__leakignore() {
  char *p = malloc(10); *p=0;
  result = cabs(p);
  // cppcheck-suppress memleak
}

void test__cabs__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cabs(x);
}

void test__cabsf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cabsf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cabsf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cabsf(arg1);
}

void test__cabsf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cabsf(arg1) > 10) || (cabsf(arg1) < 100)) {}
}

void test__cabsf__leakignore() {
  char *p = malloc(10); *p=0;
  result = cabsf(p);
  // cppcheck-suppress memleak
}

void test__cabsf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cabsf(x);
}

void test__cabsl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cabsl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cabsl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cabsl(arg1);
}

void test__cabsl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cabsl(arg1) > 10) || (cabsl(arg1) < 100)) {}
}

void test__cabsl__leakignore() {
  char *p = malloc(10); *p=0;
  result = cabsl(p);
  // cppcheck-suppress memleak
}

void test__cabsl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cabsl(x);
}

void test__cacos__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cacos(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cacos__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cacos(arg1);
}

void test__cacos__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cacos(arg1) > 10) || (cacos(arg1) < 100)) {}
}

void test__cacos__leakignore() {
  char *p = malloc(10); *p=0;
  result = cacos(p);
  // cppcheck-suppress memleak
}

void test__cacos__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cacos(x);
}

void test__cacosf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cacosf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cacosf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cacosf(arg1);
}

void test__cacosf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cacosf(arg1) > 10) || (cacosf(arg1) < 100)) {}
}

void test__cacosf__leakignore() {
  char *p = malloc(10); *p=0;
  result = cacosf(p);
  // cppcheck-suppress memleak
}

void test__cacosf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cacosf(x);
}

void test__cacosl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cacosl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cacosl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cacosl(arg1);
}

void test__cacosl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cacosl(arg1) > 10) || (cacosl(arg1) < 100)) {}
}

void test__cacosl__leakignore() {
  char *p = malloc(10); *p=0;
  result = cacosl(p);
  // cppcheck-suppress memleak
}

void test__cacosl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cacosl(x);
}

void test__cacosh__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cacosh(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cacosh__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cacosh(arg1);
}

void test__cacosh__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cacosh(arg1) > 10) || (cacosh(arg1) < 100)) {}
}

void test__cacosh__leakignore() {
  char *p = malloc(10); *p=0;
  result = cacosh(p);
  // cppcheck-suppress memleak
}

void test__cacosh__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cacosh(x);
}

void test__cacoshf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cacoshf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cacoshf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cacoshf(arg1);
}

void test__cacoshf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cacoshf(arg1) > 10) || (cacoshf(arg1) < 100)) {}
}

void test__cacoshf__leakignore() {
  char *p = malloc(10); *p=0;
  result = cacoshf(p);
  // cppcheck-suppress memleak
}

void test__cacoshf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cacoshf(x);
}

void test__cacoshl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cacoshl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cacoshl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cacoshl(arg1);
}

void test__cacoshl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cacoshl(arg1) > 10) || (cacoshl(arg1) < 100)) {}
}

void test__cacoshl__leakignore() {
  char *p = malloc(10); *p=0;
  result = cacoshl(p);
  // cppcheck-suppress memleak
}

void test__cacoshl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cacoshl(x);
}

void test__labs__noreturn() {
  int x = 1;
  if (cond) { x=100; result = labs(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__labs__useretval() {
  // cppcheck-suppress ignoredReturnValue
  labs(arg1);
}

void test__labs__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((labs(arg1) > 10) || (labs(arg1) < 100)) {}
}

void test__labs__leakignore() {
  char *p = malloc(10); *p=0;
  result = labs(p);
  // cppcheck-suppress memleak
}

void test__labs__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = labs(x);
}

void test__std__labs__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::labs(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__labs__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::labs(arg1);
}

void test__std__labs__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::labs(arg1) > 10) || (std::labs(arg1) < 100)) {}
}

void test__std__labs__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::labs(x);
}

void test__llabs__noreturn() {
  int x = 1;
  if (cond) { x=100; result = llabs(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__llabs__useretval() {
  // cppcheck-suppress ignoredReturnValue
  llabs(arg1);
}

void test__llabs__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((llabs(arg1) > 10) || (llabs(arg1) < 100)) {}
}

void test__llabs__leakignore() {
  char *p = malloc(10); *p=0;
  result = llabs(p);
  // cppcheck-suppress memleak
}

void test__llabs__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = llabs(x);
}

void test__std__llabs__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::llabs(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__llabs__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::llabs(arg1);
}

void test__std__llabs__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::llabs(arg1) > 10) || (std::llabs(arg1) < 100)) {}
}

void test__std__llabs__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::llabs(x);
}

void test__ldexp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ldexp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ldexp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ldexp(arg1, arg2);
}

void test__ldexp__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ldexp(arg1, arg2) > 10) || (ldexp(arg1, arg2) < 100)) {}
}

void test__ldexp__leakignore() {
  char *p = malloc(10); *p=0;
  result = ldexp(p, arg2);
  // cppcheck-suppress memleak
}

void test__ldexp__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ldexp(x, arg2);
}

void test__ldexp__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ldexp(arg1, x);
}

void test__std__ldexp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ldexp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ldexp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ldexp(arg1, arg2);
}

void test__std__ldexp__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::ldexp(arg1, arg2) > 10) || (std::ldexp(arg1, arg2) < 100)) {}
}

void test__std__ldexp__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::ldexp(x, arg2);
}

void test__std__ldexp__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::ldexp(arg1, x);
}

void test__ldexpf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ldexpf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ldexpf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ldexpf(arg1, arg2);
}

void test__ldexpf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ldexpf(arg1, arg2) > 10) || (ldexpf(arg1, arg2) < 100)) {}
}

void test__ldexpf__leakignore() {
  char *p = malloc(10); *p=0;
  result = ldexpf(p, arg2);
  // cppcheck-suppress memleak
}

void test__ldexpf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ldexpf(x, arg2);
}

void test__ldexpf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ldexpf(arg1, x);
}

void test__std__ldexpf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ldexpf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ldexpf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ldexpf(arg1, arg2);
}

void test__std__ldexpf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::ldexpf(arg1, arg2) > 10) || (std::ldexpf(arg1, arg2) < 100)) {}
}

void test__std__ldexpf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::ldexpf(x, arg2);
}

void test__std__ldexpf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::ldexpf(arg1, x);
}

void test__ldexpl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ldexpl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ldexpl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ldexpl(arg1, arg2);
}

void test__ldexpl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ldexpl(arg1, arg2) > 10) || (ldexpl(arg1, arg2) < 100)) {}
}

void test__ldexpl__leakignore() {
  char *p = malloc(10); *p=0;
  result = ldexpl(p, arg2);
  // cppcheck-suppress memleak
}

void test__ldexpl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ldexpl(x, arg2);
}

void test__ldexpl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ldexpl(arg1, x);
}

void test__std__ldexpl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ldexpl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ldexpl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ldexpl(arg1, arg2);
}

void test__std__ldexpl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::ldexpl(arg1, arg2) > 10) || (std::ldexpl(arg1, arg2) < 100)) {}
}

void test__std__ldexpl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::ldexpl(x, arg2);
}

void test__std__ldexpl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::ldexpl(arg1, x);
}

void test__lgamma__noreturn() {
  int x = 1;
  if (cond) { x=100; result = lgamma(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__lgamma__useretval() {
  // cppcheck-suppress ignoredReturnValue
  lgamma(arg1);
}

void test__lgamma__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((lgamma(arg1) > 10) || (lgamma(arg1) < 100)) {}
}

void test__lgamma__leakignore() {
  char *p = malloc(10); *p=0;
  result = lgamma(p);
  // cppcheck-suppress memleak
}

void test__lgamma__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = lgamma(x);
}

void test__std__lgamma__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::lgamma(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__lgamma__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::lgamma(arg1);
}

void test__std__lgamma__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::lgamma(arg1) > 10) || (std::lgamma(arg1) < 100)) {}
}

void test__std__lgamma__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::lgamma(x);
}

void test__lgammaf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = lgammaf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__lgammaf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  lgammaf(arg1);
}

void test__lgammaf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((lgammaf(arg1) > 10) || (lgammaf(arg1) < 100)) {}
}

void test__lgammaf__leakignore() {
  char *p = malloc(10); *p=0;
  result = lgammaf(p);
  // cppcheck-suppress memleak
}

void test__lgammaf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = lgammaf(x);
}

void test__std__lgammaf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::lgammaf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__lgammaf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::lgammaf(arg1);
}

void test__std__lgammaf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::lgammaf(arg1) > 10) || (std::lgammaf(arg1) < 100)) {}
}

void test__std__lgammaf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::lgammaf(x);
}

void test__lgammal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = lgammal(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__lgammal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  lgammal(arg1);
}

void test__lgammal__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((lgammal(arg1) > 10) || (lgammal(arg1) < 100)) {}
}

void test__lgammal__leakignore() {
  char *p = malloc(10); *p=0;
  result = lgammal(p);
  // cppcheck-suppress memleak
}

void test__lgammal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = lgammal(x);
}

void test__std__lgammal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::lgammal(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__lgammal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::lgammal(arg1);
}

void test__std__lgammal__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::lgammal(arg1) > 10) || (std::lgammal(arg1) < 100)) {}
}

void test__std__lgammal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::lgammal(x);
}

void test__rint__noreturn() {
  int x = 1;
  if (cond) { x=100; result = rint(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__rint__useretval() {
  // cppcheck-suppress ignoredReturnValue
  rint(arg1);
}

void test__rint__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((rint(arg1) > 10) || (rint(arg1) < 100)) {}
}

void test__rint__leakignore() {
  char *p = malloc(10); *p=0;
  result = rint(p);
  // cppcheck-suppress memleak
}

void test__rint__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = rint(x);
}

void test__std__rint__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::rint(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__rint__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::rint(arg1);
}

void test__std__rint__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::rint(arg1) > 10) || (std::rint(arg1) < 100)) {}
}

void test__std__rint__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::rint(x);
}

void test__rintf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = rintf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__rintf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  rintf(arg1);
}

void test__rintf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((rintf(arg1) > 10) || (rintf(arg1) < 100)) {}
}

void test__rintf__leakignore() {
  char *p = malloc(10); *p=0;
  result = rintf(p);
  // cppcheck-suppress memleak
}

void test__rintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = rintf(x);
}

void test__std__rintf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::rintf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__rintf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::rintf(arg1);
}

void test__std__rintf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::rintf(arg1) > 10) || (std::rintf(arg1) < 100)) {}
}

void test__std__rintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::rintf(x);
}

void test__rintl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = rintl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__rintl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  rintl(arg1);
}

void test__rintl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((rintl(arg1) > 10) || (rintl(arg1) < 100)) {}
}

void test__rintl__leakignore() {
  char *p = malloc(10); *p=0;
  result = rintl(p);
  // cppcheck-suppress memleak
}

void test__rintl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = rintl(x);
}

void test__std__rintl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::rintl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__rintl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::rintl(arg1);
}

void test__std__rintl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::rintl(arg1) > 10) || (std::rintl(arg1) < 100)) {}
}

void test__std__rintl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::rintl(x);
}

void test__lrint__noreturn() {
  int x = 1;
  if (cond) { x=100; result = lrint(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__lrint__useretval() {
  // cppcheck-suppress ignoredReturnValue
  lrint(arg1);
}

void test__lrint__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((lrint(arg1) > 10) || (lrint(arg1) < 100)) {}
}

void test__lrint__leakignore() {
  char *p = malloc(10); *p=0;
  result = lrint(p);
  // cppcheck-suppress memleak
}

void test__lrint__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = lrint(x);
}

void test__std__lrint__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::lrint(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__lrint__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::lrint(arg1);
}

void test__std__lrint__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::lrint(arg1) > 10) || (std::lrint(arg1) < 100)) {}
}

void test__std__lrint__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::lrint(x);
}

void test__lrintf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = lrintf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__lrintf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  lrintf(arg1);
}

void test__lrintf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((lrintf(arg1) > 10) || (lrintf(arg1) < 100)) {}
}

void test__lrintf__leakignore() {
  char *p = malloc(10); *p=0;
  result = lrintf(p);
  // cppcheck-suppress memleak
}

void test__lrintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = lrintf(x);
}

void test__std__lrintf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::lrintf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__lrintf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::lrintf(arg1);
}

void test__std__lrintf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::lrintf(arg1) > 10) || (std::lrintf(arg1) < 100)) {}
}

void test__std__lrintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::lrintf(x);
}

void test__lrintl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = lrintl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__lrintl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  lrintl(arg1);
}

void test__lrintl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((lrintl(arg1) > 10) || (lrintl(arg1) < 100)) {}
}

void test__lrintl__leakignore() {
  char *p = malloc(10); *p=0;
  result = lrintl(p);
  // cppcheck-suppress memleak
}

void test__lrintl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = lrintl(x);
}

void test__std__lrintl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::lrintl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__lrintl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::lrintl(arg1);
}

void test__std__lrintl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::lrintl(arg1) > 10) || (std::lrintl(arg1) < 100)) {}
}

void test__std__lrintl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::lrintl(x);
}

void test__llrint__noreturn() {
  int x = 1;
  if (cond) { x=100; result = llrint(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__llrint__useretval() {
  // cppcheck-suppress ignoredReturnValue
  llrint(arg1);
}

void test__llrint__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((llrint(arg1) > 10) || (llrint(arg1) < 100)) {}
}

void test__llrint__leakignore() {
  char *p = malloc(10); *p=0;
  result = llrint(p);
  // cppcheck-suppress memleak
}

void test__llrint__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = llrint(x);
}

void test__std__llrint__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::llrint(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__llrint__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::llrint(arg1);
}

void test__std__llrint__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::llrint(arg1) > 10) || (std::llrint(arg1) < 100)) {}
}

void test__std__llrint__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::llrint(x);
}

void test__llrintf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = llrintf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__llrintf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  llrintf(arg1);
}

void test__llrintf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((llrintf(arg1) > 10) || (llrintf(arg1) < 100)) {}
}

void test__llrintf__leakignore() {
  char *p = malloc(10); *p=0;
  result = llrintf(p);
  // cppcheck-suppress memleak
}

void test__llrintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = llrintf(x);
}

void test__std__llrintf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::llrintf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__llrintf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::llrintf(arg1);
}

void test__std__llrintf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::llrintf(arg1) > 10) || (std::llrintf(arg1) < 100)) {}
}

void test__std__llrintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::llrintf(x);
}

void test__llrintl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = llrintl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__llrintl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  llrintl(arg1);
}

void test__llrintl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((llrintl(arg1) > 10) || (llrintl(arg1) < 100)) {}
}

void test__llrintl__leakignore() {
  char *p = malloc(10); *p=0;
  result = llrintl(p);
  // cppcheck-suppress memleak
}

void test__llrintl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = llrintl(x);
}

void test__std__llrintl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::llrintl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__llrintl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::llrintl(arg1);
}

void test__std__llrintl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::llrintl(arg1) > 10) || (std::llrintl(arg1) < 100)) {}
}

void test__std__llrintl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::llrintl(x);
}

void test__llround__noreturn() {
  int x = 1;
  if (cond) { x=100; result = llround(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__llround__useretval() {
  // cppcheck-suppress ignoredReturnValue
  llround(arg1);
}

void test__llround__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((llround(arg1) > 10) || (llround(arg1) < 100)) {}
}

void test__llround__leakignore() {
  char *p = malloc(10); *p=0;
  result = llround(p);
  // cppcheck-suppress memleak
}

void test__llround__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = llround(x);
}

void test__std__llround__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::llround(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__llround__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::llround(arg1);
}

void test__std__llround__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::llround(arg1) > 10) || (std::llround(arg1) < 100)) {}
}

void test__std__llround__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::llround(x);
}

void test__llroundf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = llroundf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__llroundf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  llroundf(arg1);
}

void test__llroundf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((llroundf(arg1) > 10) || (llroundf(arg1) < 100)) {}
}

void test__llroundf__leakignore() {
  char *p = malloc(10); *p=0;
  result = llroundf(p);
  // cppcheck-suppress memleak
}

void test__llroundf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = llroundf(x);
}

void test__std__llroundf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::llroundf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__llroundf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::llroundf(arg1);
}

void test__std__llroundf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::llroundf(arg1) > 10) || (std::llroundf(arg1) < 100)) {}
}

void test__std__llroundf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::llroundf(x);
}

void test__llroundl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = llroundl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__llroundl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  llroundl(arg1);
}

void test__llroundl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((llroundl(arg1) > 10) || (llroundl(arg1) < 100)) {}
}

void test__llroundl__leakignore() {
  char *p = malloc(10); *p=0;
  result = llroundl(p);
  // cppcheck-suppress memleak
}

void test__llroundl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = llroundl(x);
}

void test__std__llroundl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::llroundl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__llroundl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::llroundl(arg1);
}

void test__std__llroundl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::llroundl(arg1) > 10) || (std::llroundl(arg1) < 100)) {}
}

void test__std__llroundl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::llroundl(x);
}

void test__lround__noreturn() {
  int x = 1;
  if (cond) { x=100; result = lround(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__lround__useretval() {
  // cppcheck-suppress ignoredReturnValue
  lround(arg1);
}

void test__lround__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((lround(arg1) > 10) || (lround(arg1) < 100)) {}
}

void test__lround__leakignore() {
  char *p = malloc(10); *p=0;
  result = lround(p);
  // cppcheck-suppress memleak
}

void test__lround__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = lround(x);
}

void test__std__lround__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::lround(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__lround__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::lround(arg1);
}

void test__std__lround__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::lround(arg1) > 10) || (std::lround(arg1) < 100)) {}
}

void test__std__lround__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::lround(x);
}

void test__lroundf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = lroundf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__lroundf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  lroundf(arg1);
}

void test__lroundf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((lroundf(arg1) > 10) || (lroundf(arg1) < 100)) {}
}

void test__lroundf__leakignore() {
  char *p = malloc(10); *p=0;
  result = lroundf(p);
  // cppcheck-suppress memleak
}

void test__lroundf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = lroundf(x);
}

void test__std__lroundf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::lroundf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__lroundf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::lroundf(arg1);
}

void test__std__lroundf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::lroundf(arg1) > 10) || (std::lroundf(arg1) < 100)) {}
}

void test__std__lroundf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::lroundf(x);
}

void test__lroundl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = lroundl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__lroundl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  lroundl(arg1);
}

void test__lroundl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((lroundl(arg1) > 10) || (lroundl(arg1) < 100)) {}
}

void test__lroundl__leakignore() {
  char *p = malloc(10); *p=0;
  result = lroundl(p);
  // cppcheck-suppress memleak
}

void test__lroundl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = lroundl(x);
}

void test__std__lroundl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::lroundl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__lroundl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::lroundl(arg1);
}

void test__std__lroundl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::lroundl(arg1) > 10) || (std::lroundl(arg1) < 100)) {}
}

void test__std__lroundl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::lroundl(x);
}

void test__rand__noreturn() {
  int x = 1;
  if (cond) { x=100; result = rand(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__rand__useretval() {
  // cppcheck-suppress ignoredReturnValue
  rand();
}

void test__rand__leakignore() {
  char *p = malloc(10); *p=0;
  result = rand();
  // cppcheck-suppress memleak
}

void test__srand__noreturn() {
  int x = 1;
  if (cond) { x=100; srand(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__srand__leakignore() {
  char *p = malloc(10); *p=0;
  srand(p);
  // cppcheck-suppress memleak
}

void test__srand__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  srand(x);
}

void test__std__srand__noreturn() {
  int x = 1;
  if (cond) { x=100; std::srand(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__srand__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::srand(x);
}

void test__ldiv__noreturn() {
  int x = 1;
  if (cond) { x=100; ldiv(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ldiv__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ldiv(arg1, arg2) > 10) || (ldiv(arg1, arg2) < 100)) {}
}

void test__ldiv__leakignore() {
  char *p = malloc(10); *p=0;
  ldiv(p, arg2);
  // cppcheck-suppress memleak
}

void test__ldiv__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ldiv(x, arg2);
}

void test__ldiv__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ldiv(arg1, x);
}

void test__std__ldiv__noreturn() {
  int x = 1;
  if (cond) { x=100; std::ldiv(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ldiv__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::ldiv(arg1, arg2) > 10) || (std::ldiv(arg1, arg2) < 100)) {}
}

void test__std__ldiv__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::ldiv(x, arg2);
}

void test__std__ldiv__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::ldiv(arg1, x);
}

void test__lldiv__noreturn() {
  int x = 1;
  if (cond) { x=100; lldiv(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__lldiv__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((lldiv(arg1, arg2) > 10) || (lldiv(arg1, arg2) < 100)) {}
}

void test__lldiv__leakignore() {
  char *p = malloc(10); *p=0;
  lldiv(p, arg2);
  // cppcheck-suppress memleak
}

void test__lldiv__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  lldiv(x, arg2);
}

void test__lldiv__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  lldiv(arg1, x);
}

void test__std__lldiv__noreturn() {
  int x = 1;
  if (cond) { x=100; std::lldiv(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__lldiv__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::lldiv(arg1, arg2) > 10) || (std::lldiv(arg1, arg2) < 100)) {}
}

void test__std__lldiv__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::lldiv(x, arg2);
}

void test__std__lldiv__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::lldiv(arg1, x);
}

void test__localtime__noreturn() {
  int x = 1;
  if (cond) { x=100; localtime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__localtime__leakignore() {
  char *p = malloc(10); *p=0;
  localtime(p);
  // cppcheck-suppress memleak
}

void test__localtime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  localtime(NULL);
}

void test__localtime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  localtime(x);
}

void test__std__localtime__noreturn() {
  int x = 1;
  if (cond) { x=100; std::localtime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__localtime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::localtime(NULL);
}

void test__std__localtime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::localtime(x);
}

void test__localtime_s__noreturn() {
  int x = 1;
  if (cond) { x=100; localtime_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__localtime_s__leakignore() {
  char *p = malloc(10); *p=0;
  localtime_s(p, arg2);
  // cppcheck-suppress memleak
}

void test__localtime_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  localtime_s(NULL, arg2);
}

void test__localtime_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  localtime_s(arg1, NULL);
}

void test__std__localtime_s__noreturn() {
  int x = 1;
  if (cond) { x=100; std::localtime_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__localtime_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::localtime_s(NULL, arg2);
}

void test__std__localtime_s__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::localtime_s(arg1, NULL);
}

void test__log__noreturn() {
  int x = 1;
  if (cond) { x=100; result = log(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__log__useretval() {
  // cppcheck-suppress ignoredReturnValue
  log(arg1);
}

void test__log__leakignore() {
  char *p = malloc(10); *p=0;
  result = log(p);
  // cppcheck-suppress memleak
}

void test__log__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = log(x);
}

void test__std__log__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::log(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__log__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::log(arg1);
}

void test__std__log__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::log(x);
}

void test__logf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = logf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__logf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  logf(arg1);
}

void test__logf__leakignore() {
  char *p = malloc(10); *p=0;
  result = logf(p);
  // cppcheck-suppress memleak
}

void test__logf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = logf(x);
}

void test__std__logf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::logf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__logf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::logf(arg1);
}

void test__std__logf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::logf(x);
}

void test__logl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = logl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__logl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  logl(arg1);
}

void test__logl__leakignore() {
  char *p = malloc(10); *p=0;
  result = logl(p);
  // cppcheck-suppress memleak
}

void test__logl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = logl(x);
}

void test__std__logl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::logl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__logl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::logl(arg1);
}

void test__std__logl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::logl(x);
}

void test__clog__noreturn() {
  int x = 1;
  if (cond) { x=100; result = clog(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__clog__useretval() {
  // cppcheck-suppress ignoredReturnValue
  clog(arg1);
}

void test__clog__leakignore() {
  char *p = malloc(10); *p=0;
  result = clog(p);
  // cppcheck-suppress memleak
}

void test__clog__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = clog(x);
}

void test__clogf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = clogf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__clogf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  clogf(arg1);
}

void test__clogf__leakignore() {
  char *p = malloc(10); *p=0;
  result = clogf(p);
  // cppcheck-suppress memleak
}

void test__clogf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = clogf(x);
}

void test__clogl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = clogl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__clogl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  clogl(arg1);
}

void test__clogl__leakignore() {
  char *p = malloc(10); *p=0;
  result = clogl(p);
  // cppcheck-suppress memleak
}

void test__clogl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = clogl(x);
}

void test__conj__noreturn() {
  int x = 1;
  if (cond) { x=100; result = conj(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__conj__useretval() {
  // cppcheck-suppress ignoredReturnValue
  conj(arg1);
}

void test__conj__leakignore() {
  char *p = malloc(10); *p=0;
  result = conj(p);
  // cppcheck-suppress memleak
}

void test__conj__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = conj(x);
}

void test__conjf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = conjf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__conjf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  conjf(arg1);
}

void test__conjf__leakignore() {
  char *p = malloc(10); *p=0;
  result = conjf(p);
  // cppcheck-suppress memleak
}

void test__conjf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = conjf(x);
}

void test__conjl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = conjl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__conjl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  conjl(arg1);
}

void test__conjl__leakignore() {
  char *p = malloc(10); *p=0;
  result = conjl(p);
  // cppcheck-suppress memleak
}

void test__conjl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = conjl(x);
}

void test__fpclassify__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fpclassify(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fpclassify__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fpclassify(arg1);
}

void test__fpclassify__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fpclassify(arg1) > 10) || (fpclassify(arg1) < 100)) {}
}

void test__fpclassify__leakignore() {
  char *p = malloc(10); *p=0;
  result = fpclassify(p);
  // cppcheck-suppress memleak
}

void test__fpclassify__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fpclassify(x);
}

void test__std__fpclassify__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::fpclassify(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fpclassify__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::fpclassify(arg1);
}

void test__std__fpclassify__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::fpclassify(arg1) > 10) || (std::fpclassify(arg1) < 100)) {}
}

void test__std__fpclassify__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::fpclassify(x);
}

void test__isfinite__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isfinite(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isfinite__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isfinite(arg1);
}

void test__isfinite__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isfinite(arg1) > 10) || (isfinite(arg1) < 100)) {}
}

void test__isfinite__leakignore() {
  char *p = malloc(10); *p=0;
  result = isfinite(p);
  // cppcheck-suppress memleak
}

void test__isfinite__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isfinite(x);
}

void test__std__isfinite__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isfinite(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isfinite__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isfinite(arg1);
}

void test__std__isfinite__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isfinite(arg1) > 10) || (std::isfinite(arg1) < 100)) {}
}

void test__std__isfinite__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isfinite(x);
}

void test__isgreater__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isgreater(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isgreater__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isgreater(arg1, arg2);
}

void test__isgreater__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isgreater(arg1, arg2) > 10) || (isgreater(arg1, arg2) < 100)) {}
}

void test__isgreater__leakignore() {
  char *p = malloc(10); *p=0;
  result = isgreater(p, arg2);
  // cppcheck-suppress memleak
}

void test__isgreater__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isgreater(x, arg2);
}

void test__isgreater__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isgreater(arg1, x);
}

void test__std__isgreater__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isgreater(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isgreater__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isgreater(arg1, arg2);
}

void test__std__isgreater__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isgreater(arg1, arg2) > 10) || (std::isgreater(arg1, arg2) < 100)) {}
}

void test__std__isgreater__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isgreater(x, arg2);
}

void test__std__isgreater__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isgreater(arg1, x);
}

void test__isgreaterequal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isgreaterequal(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isgreaterequal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isgreaterequal(arg1, arg2);
}

void test__isgreaterequal__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isgreaterequal(arg1, arg2) > 10) || (isgreaterequal(arg1, arg2) < 100)) {}
}

void test__isgreaterequal__leakignore() {
  char *p = malloc(10); *p=0;
  result = isgreaterequal(p, arg2);
  // cppcheck-suppress memleak
}

void test__isgreaterequal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isgreaterequal(x, arg2);
}

void test__isgreaterequal__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isgreaterequal(arg1, x);
}

void test__std__isgreaterequal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isgreaterequal(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isgreaterequal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isgreaterequal(arg1, arg2);
}

void test__std__isgreaterequal__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isgreaterequal(arg1, arg2) > 10) || (std::isgreaterequal(arg1, arg2) < 100)) {}
}

void test__std__isgreaterequal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isgreaterequal(x, arg2);
}

void test__std__isgreaterequal__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isgreaterequal(arg1, x);
}

void test__isinf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isinf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isinf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isinf(arg1);
}

void test__isinf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isinf(arg1) > 10) || (isinf(arg1) < 100)) {}
}

void test__isinf__leakignore() {
  char *p = malloc(10); *p=0;
  result = isinf(p);
  // cppcheck-suppress memleak
}

void test__isinf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isinf(x);
}

void test__std__isinf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isinf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isinf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isinf(arg1);
}

void test__std__isinf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isinf(arg1) > 10) || (std::isinf(arg1) < 100)) {}
}

void test__std__isinf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isinf(x);
}

void test__logb__noreturn() {
  int x = 1;
  if (cond) { x=100; result = logb(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__logb__useretval() {
  // cppcheck-suppress ignoredReturnValue
  logb(arg1);
}

void test__logb__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((logb(arg1) > 10) || (logb(arg1) < 100)) {}
}

void test__logb__leakignore() {
  char *p = malloc(10); *p=0;
  result = logb(p);
  // cppcheck-suppress memleak
}

void test__logb__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = logb(x);
}

void test__std__logb__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::logb(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__logb__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::logb(arg1);
}

void test__std__logb__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::logb(arg1) > 10) || (std::logb(arg1) < 100)) {}
}

void test__std__logb__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::logb(x);
}

void test__logbf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = logbf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__logbf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  logbf(arg1);
}

void test__logbf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((logbf(arg1) > 10) || (logbf(arg1) < 100)) {}
}

void test__logbf__leakignore() {
  char *p = malloc(10); *p=0;
  result = logbf(p);
  // cppcheck-suppress memleak
}

void test__logbf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = logbf(x);
}

void test__std__logbf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::logbf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__logbf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::logbf(arg1);
}

void test__std__logbf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::logbf(arg1) > 10) || (std::logbf(arg1) < 100)) {}
}

void test__std__logbf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::logbf(x);
}

void test__logbl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = logbl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__logbl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  logbl(arg1);
}

void test__logbl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((logbl(arg1) > 10) || (logbl(arg1) < 100)) {}
}

void test__logbl__leakignore() {
  char *p = malloc(10); *p=0;
  result = logbl(p);
  // cppcheck-suppress memleak
}

void test__logbl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = logbl(x);
}

void test__std__logbl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::logbl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__logbl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::logbl(arg1);
}

void test__std__logbl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::logbl(arg1) > 10) || (std::logbl(arg1) < 100)) {}
}

void test__std__logbl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::logbl(x);
}

void test__isless__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isless(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isless__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isless(arg1, arg2);
}

void test__isless__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isless(arg1, arg2) > 10) || (isless(arg1, arg2) < 100)) {}
}

void test__isless__leakignore() {
  char *p = malloc(10); *p=0;
  result = isless(p, arg2);
  // cppcheck-suppress memleak
}

void test__isless__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isless(x, arg2);
}

void test__isless__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isless(arg1, x);
}

void test__std__isless__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isless(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isless__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isless(arg1, arg2);
}

void test__std__isless__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isless(arg1, arg2) > 10) || (std::isless(arg1, arg2) < 100)) {}
}

void test__std__isless__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isless(x, arg2);
}

void test__std__isless__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isless(arg1, x);
}

void test__islessequal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = islessequal(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__islessequal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  islessequal(arg1, arg2);
}

void test__islessequal__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((islessequal(arg1, arg2) > 10) || (islessequal(arg1, arg2) < 100)) {}
}

void test__islessequal__leakignore() {
  char *p = malloc(10); *p=0;
  result = islessequal(p, arg2);
  // cppcheck-suppress memleak
}

void test__islessequal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = islessequal(x, arg2);
}

void test__islessequal__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = islessequal(arg1, x);
}

void test__std__islessequal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::islessequal(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__islessequal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::islessequal(arg1, arg2);
}

void test__std__islessequal__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::islessequal(arg1, arg2) > 10) || (std::islessequal(arg1, arg2) < 100)) {}
}

void test__std__islessequal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::islessequal(x, arg2);
}

void test__std__islessequal__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::islessequal(arg1, x);
}

void test__islessgreater__noreturn() {
  int x = 1;
  if (cond) { x=100; result = islessgreater(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__islessgreater__useretval() {
  // cppcheck-suppress ignoredReturnValue
  islessgreater(arg1, arg2);
}

void test__islessgreater__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((islessgreater(arg1, arg2) > 10) || (islessgreater(arg1, arg2) < 100)) {}
}

void test__islessgreater__leakignore() {
  char *p = malloc(10); *p=0;
  result = islessgreater(p, arg2);
  // cppcheck-suppress memleak
}

void test__islessgreater__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = islessgreater(x, arg2);
}

void test__islessgreater__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = islessgreater(arg1, x);
}

void test__std__islessgreater__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::islessgreater(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__islessgreater__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::islessgreater(arg1, arg2);
}

void test__std__islessgreater__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::islessgreater(arg1, arg2) > 10) || (std::islessgreater(arg1, arg2) < 100)) {}
}

void test__std__islessgreater__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::islessgreater(x, arg2);
}

void test__std__islessgreater__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::islessgreater(arg1, x);
}

void test__nan__noreturn() {
  int x = 1;
  if (cond) { x=100; result = nan(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__nan__useretval() {
  // cppcheck-suppress ignoredReturnValue
  nan(arg1);
}

void test__nan__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((nan(arg1) > 10) || (nan(arg1) < 100)) {}
}

void test__nan__leakignore() {
  char *p = malloc(10); *p=0;
  result = nan(p);
  // cppcheck-suppress memleak
}

void test__nan__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = nan(NULL);
}

void test__nan__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = nan(x);
}

void test__std__nan__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::nan(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__nan__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::nan(arg1);
}

void test__std__nan__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::nan(arg1) > 10) || (std::nan(arg1) < 100)) {}
}

void test__std__nan__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::nan(NULL);
}

void test__std__nan__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::nan(x);
}

void test__nanf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = nanf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__nanf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  nanf(arg1);
}

void test__nanf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((nanf(arg1) > 10) || (nanf(arg1) < 100)) {}
}

void test__nanf__leakignore() {
  char *p = malloc(10); *p=0;
  result = nanf(p);
  // cppcheck-suppress memleak
}

void test__nanf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = nanf(NULL);
}

void test__nanf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = nanf(x);
}

void test__std__nanf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::nanf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__nanf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::nanf(arg1);
}

void test__std__nanf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::nanf(arg1) > 10) || (std::nanf(arg1) < 100)) {}
}

void test__std__nanf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::nanf(NULL);
}

void test__std__nanf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::nanf(x);
}

void test__nanl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = nanl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__nanl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  nanl(arg1);
}

void test__nanl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((nanl(arg1) > 10) || (nanl(arg1) < 100)) {}
}

void test__nanl__leakignore() {
  char *p = malloc(10); *p=0;
  result = nanl(p);
  // cppcheck-suppress memleak
}

void test__nanl__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = nanl(NULL);
}

void test__nanl__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = nanl(x);
}

void test__std__nanl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::nanl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__nanl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::nanl(arg1);
}

void test__std__nanl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::nanl(arg1) > 10) || (std::nanl(arg1) < 100)) {}
}

void test__std__nanl__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::nanl(NULL);
}

void test__std__nanl__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::nanl(x);
}

void test__isnan__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isnan(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isnan__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isnan(arg1);
}

void test__isnan__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isnan(arg1) > 10) || (isnan(arg1) < 100)) {}
}

void test__isnan__leakignore() {
  char *p = malloc(10); *p=0;
  result = isnan(p);
  // cppcheck-suppress memleak
}

void test__isnan__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isnan(x);
}

void test__std__isnan__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isnan(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isnan__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isnan(arg1);
}

void test__std__isnan__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isnan(arg1) > 10) || (std::isnan(arg1) < 100)) {}
}

void test__std__isnan__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isnan(x);
}

void test__isnormal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isnormal(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isnormal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isnormal(arg1);
}

void test__isnormal__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isnormal(arg1) > 10) || (isnormal(arg1) < 100)) {}
}

void test__isnormal__leakignore() {
  char *p = malloc(10); *p=0;
  result = isnormal(p);
  // cppcheck-suppress memleak
}

void test__isnormal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isnormal(x);
}

void test__std__isnormal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isnormal(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isnormal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isnormal(arg1);
}

void test__std__isnormal__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isnormal(arg1) > 10) || (std::isnormal(arg1) < 100)) {}
}

void test__std__isnormal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isnormal(x);
}

void test__isunordered__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isunordered(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isunordered__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isunordered(arg1, arg2);
}

void test__isunordered__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((isunordered(arg1, arg2) > 10) || (isunordered(arg1, arg2) < 100)) {}
}

void test__isunordered__leakignore() {
  char *p = malloc(10); *p=0;
  result = isunordered(p, arg2);
  // cppcheck-suppress memleak
}

void test__isunordered__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isunordered(x, arg2);
}

void test__isunordered__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isunordered(arg1, x);
}

void test__std__isunordered__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::isunordered(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__isunordered__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::isunordered(arg1, arg2);
}

void test__std__isunordered__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::isunordered(arg1, arg2) > 10) || (std::isunordered(arg1, arg2) < 100)) {}
}

void test__std__isunordered__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isunordered(x, arg2);
}

void test__std__isunordered__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::isunordered(arg1, x);
}

void test__ilogb__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ilogb(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ilogb__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ilogb(arg1);
}

void test__ilogb__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ilogb(arg1) > 10) || (ilogb(arg1) < 100)) {}
}

void test__ilogb__leakignore() {
  char *p = malloc(10); *p=0;
  result = ilogb(p);
  // cppcheck-suppress memleak
}

void test__ilogb__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ilogb(x);
}

void test__std__ilogb__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ilogb(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ilogb__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ilogb(arg1);
}

void test__std__ilogb__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::ilogb(arg1) > 10) || (std::ilogb(arg1) < 100)) {}
}

void test__std__ilogb__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::ilogb(x);
}

void test__ilogbf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ilogbf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ilogbf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ilogbf(arg1);
}

void test__ilogbf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ilogbf(arg1) > 10) || (ilogbf(arg1) < 100)) {}
}

void test__ilogbf__leakignore() {
  char *p = malloc(10); *p=0;
  result = ilogbf(p);
  // cppcheck-suppress memleak
}

void test__ilogbf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ilogbf(x);
}

void test__std__ilogbf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ilogbf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ilogbf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ilogbf(arg1);
}

void test__std__ilogbf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::ilogbf(arg1) > 10) || (std::ilogbf(arg1) < 100)) {}
}

void test__std__ilogbf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::ilogbf(x);
}

void test__ilogbl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ilogbl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ilogbl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ilogbl(arg1);
}

void test__ilogbl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((ilogbl(arg1) > 10) || (ilogbl(arg1) < 100)) {}
}

void test__ilogbl__leakignore() {
  char *p = malloc(10); *p=0;
  result = ilogbl(p);
  // cppcheck-suppress memleak
}

void test__ilogbl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ilogbl(x);
}

void test__std__ilogbl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ilogbl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ilogbl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ilogbl(arg1);
}

void test__std__ilogbl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::ilogbl(arg1) > 10) || (std::ilogbl(arg1) < 100)) {}
}

void test__std__ilogbl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::ilogbl(x);
}

void test__log10__noreturn() {
  int x = 1;
  if (cond) { x=100; result = log10(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__log10__useretval() {
  // cppcheck-suppress ignoredReturnValue
  log10(arg1);
}

void test__log10__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((log10(arg1) > 10) || (log10(arg1) < 100)) {}
}

void test__log10__leakignore() {
  char *p = malloc(10); *p=0;
  result = log10(p);
  // cppcheck-suppress memleak
}

void test__log10__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = log10(x);
}

void test__std__log10__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::log10(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__log10__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::log10(arg1);
}

void test__std__log10__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::log10(arg1) > 10) || (std::log10(arg1) < 100)) {}
}

void test__std__log10__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::log10(x);
}

void test__log10f__noreturn() {
  int x = 1;
  if (cond) { x=100; result = log10f(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__log10f__useretval() {
  // cppcheck-suppress ignoredReturnValue
  log10f(arg1);
}

void test__log10f__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((log10f(arg1) > 10) || (log10f(arg1) < 100)) {}
}

void test__log10f__leakignore() {
  char *p = malloc(10); *p=0;
  result = log10f(p);
  // cppcheck-suppress memleak
}

void test__log10f__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = log10f(x);
}

void test__std__log10f__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::log10f(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__log10f__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::log10f(arg1);
}

void test__std__log10f__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::log10f(arg1) > 10) || (std::log10f(arg1) < 100)) {}
}

void test__std__log10f__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::log10f(x);
}

void test__log10l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = log10l(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__log10l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  log10l(arg1);
}

void test__log10l__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((log10l(arg1) > 10) || (log10l(arg1) < 100)) {}
}

void test__log10l__leakignore() {
  char *p = malloc(10); *p=0;
  result = log10l(p);
  // cppcheck-suppress memleak
}

void test__log10l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = log10l(x);
}

void test__std__log10l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::log10l(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__log10l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::log10l(arg1);
}

void test__std__log10l__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::log10l(arg1) > 10) || (std::log10l(arg1) < 100)) {}
}

void test__std__log10l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::log10l(x);
}

void test__log1p__noreturn() {
  int x = 1;
  if (cond) { x=100; result = log1p(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__log1p__useretval() {
  // cppcheck-suppress ignoredReturnValue
  log1p(arg1);
}

void test__log1p__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((log1p(arg1) > 10) || (log1p(arg1) < 100)) {}
}

void test__log1p__leakignore() {
  char *p = malloc(10); *p=0;
  result = log1p(p);
  // cppcheck-suppress memleak
}

void test__log1p__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = log1p(x);
}

void test__std__log1p__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::log1p(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__log1p__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::log1p(arg1);
}

void test__std__log1p__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::log1p(arg1) > 10) || (std::log1p(arg1) < 100)) {}
}

void test__std__log1p__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::log1p(x);
}

void test__log1pf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = log1pf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__log1pf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  log1pf(arg1);
}

void test__log1pf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((log1pf(arg1) > 10) || (log1pf(arg1) < 100)) {}
}

void test__log1pf__leakignore() {
  char *p = malloc(10); *p=0;
  result = log1pf(p);
  // cppcheck-suppress memleak
}

void test__log1pf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = log1pf(x);
}

void test__std__log1pf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::log1pf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__log1pf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::log1pf(arg1);
}

void test__std__log1pf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::log1pf(arg1) > 10) || (std::log1pf(arg1) < 100)) {}
}

void test__std__log1pf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::log1pf(x);
}

void test__log1pl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = log1pl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__log1pl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  log1pl(arg1);
}

void test__log1pl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((log1pl(arg1) > 10) || (log1pl(arg1) < 100)) {}
}

void test__log1pl__leakignore() {
  char *p = malloc(10); *p=0;
  result = log1pl(p);
  // cppcheck-suppress memleak
}

void test__log1pl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = log1pl(x);
}

void test__std__log1pl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::log1pl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__log1pl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::log1pl(arg1);
}

void test__std__log1pl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::log1pl(arg1) > 10) || (std::log1pl(arg1) < 100)) {}
}

void test__std__log1pl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::log1pl(x);
}

void test__log2__noreturn() {
  int x = 1;
  if (cond) { x=100; result = log2(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__log2__useretval() {
  // cppcheck-suppress ignoredReturnValue
  log2(arg1);
}

void test__log2__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((log2(arg1) > 10) || (log2(arg1) < 100)) {}
}

void test__log2__leakignore() {
  char *p = malloc(10); *p=0;
  result = log2(p);
  // cppcheck-suppress memleak
}

void test__log2__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = log2(x);
}

void test__std__log2__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::log2(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__log2__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::log2(arg1);
}

void test__std__log2__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::log2(arg1) > 10) || (std::log2(arg1) < 100)) {}
}

void test__std__log2__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::log2(x);
}

void test__log2f__noreturn() {
  int x = 1;
  if (cond) { x=100; result = log2f(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__log2f__useretval() {
  // cppcheck-suppress ignoredReturnValue
  log2f(arg1);
}

void test__log2f__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((log2f(arg1) > 10) || (log2f(arg1) < 100)) {}
}

void test__log2f__leakignore() {
  char *p = malloc(10); *p=0;
  result = log2f(p);
  // cppcheck-suppress memleak
}

void test__log2f__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = log2f(x);
}

void test__std__log2f__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::log2f(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__log2f__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::log2f(arg1);
}

void test__std__log2f__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::log2f(arg1) > 10) || (std::log2f(arg1) < 100)) {}
}

void test__std__log2f__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::log2f(x);
}

void test__log2l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = log2l(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__log2l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  log2l(arg1);
}

void test__log2l__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((log2l(arg1) > 10) || (log2l(arg1) < 100)) {}
}

void test__log2l__leakignore() {
  char *p = malloc(10); *p=0;
  result = log2l(p);
  // cppcheck-suppress memleak
}

void test__log2l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = log2l(x);
}

void test__std__log2l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::log2l(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__log2l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::log2l(arg1);
}

void test__std__log2l__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::log2l(arg1) > 10) || (std::log2l(arg1) < 100)) {}
}

void test__std__log2l__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::log2l(x);
}

void test__nearbyint__noreturn() {
  int x = 1;
  if (cond) { x=100; result = nearbyint(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__nearbyint__useretval() {
  // cppcheck-suppress ignoredReturnValue
  nearbyint(arg1);
}

void test__nearbyint__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((nearbyint(arg1) > 10) || (nearbyint(arg1) < 100)) {}
}

void test__nearbyint__leakignore() {
  char *p = malloc(10); *p=0;
  result = nearbyint(p);
  // cppcheck-suppress memleak
}

void test__nearbyint__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nearbyint(x);
}

void test__std__nearbyint__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::nearbyint(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__nearbyint__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::nearbyint(arg1);
}

void test__std__nearbyint__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::nearbyint(arg1) > 10) || (std::nearbyint(arg1) < 100)) {}
}

void test__std__nearbyint__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nearbyint(x);
}

void test__nearbyintf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = nearbyintf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__nearbyintf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  nearbyintf(arg1);
}

void test__nearbyintf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((nearbyintf(arg1) > 10) || (nearbyintf(arg1) < 100)) {}
}

void test__nearbyintf__leakignore() {
  char *p = malloc(10); *p=0;
  result = nearbyintf(p);
  // cppcheck-suppress memleak
}

void test__nearbyintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nearbyintf(x);
}

void test__std__nearbyintf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::nearbyintf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__nearbyintf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::nearbyintf(arg1);
}

void test__std__nearbyintf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::nearbyintf(arg1) > 10) || (std::nearbyintf(arg1) < 100)) {}
}

void test__std__nearbyintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nearbyintf(x);
}

void test__nearbyintl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = nearbyintl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__nearbyintl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  nearbyintl(arg1);
}

void test__nearbyintl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((nearbyintl(arg1) > 10) || (nearbyintl(arg1) < 100)) {}
}

void test__nearbyintl__leakignore() {
  char *p = malloc(10); *p=0;
  result = nearbyintl(p);
  // cppcheck-suppress memleak
}

void test__nearbyintl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nearbyintl(x);
}

void test__std__nearbyintl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::nearbyintl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__nearbyintl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::nearbyintl(arg1);
}

void test__std__nearbyintl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::nearbyintl(arg1) > 10) || (std::nearbyintl(arg1) < 100)) {}
}

void test__std__nearbyintl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nearbyintl(x);
}

void test__nextafter__noreturn() {
  int x = 1;
  if (cond) { x=100; result = nextafter(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__nextafter__useretval() {
  // cppcheck-suppress ignoredReturnValue
  nextafter(arg1, arg2);
}

void test__nextafter__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((nextafter(arg1, arg2) > 10) || (nextafter(arg1, arg2) < 100)) {}
}

void test__nextafter__leakignore() {
  char *p = malloc(10); *p=0;
  result = nextafter(p, arg2);
  // cppcheck-suppress memleak
}

void test__nextafter__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nextafter(x, arg2);
}

void test__nextafter__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nextafter(arg1, x);
}

void test__std__nextafter__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::nextafter(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__nextafter__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::nextafter(arg1, arg2);
}

void test__std__nextafter__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::nextafter(arg1, arg2) > 10) || (std::nextafter(arg1, arg2) < 100)) {}
}

void test__std__nextafter__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nextafter(x, arg2);
}

void test__std__nextafter__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nextafter(arg1, x);
}

void test__nextafterf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = nextafterf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__nextafterf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  nextafterf(arg1, arg2);
}

void test__nextafterf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((nextafterf(arg1, arg2) > 10) || (nextafterf(arg1, arg2) < 100)) {}
}

void test__nextafterf__leakignore() {
  char *p = malloc(10); *p=0;
  result = nextafterf(p, arg2);
  // cppcheck-suppress memleak
}

void test__nextafterf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nextafterf(x, arg2);
}

void test__nextafterf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nextafterf(arg1, x);
}

void test__std__nextafterf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::nextafterf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__nextafterf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::nextafterf(arg1, arg2);
}

void test__std__nextafterf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::nextafterf(arg1, arg2) > 10) || (std::nextafterf(arg1, arg2) < 100)) {}
}

void test__std__nextafterf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nextafterf(x, arg2);
}

void test__std__nextafterf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nextafterf(arg1, x);
}

void test__nextafterl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = nextafterl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__nextafterl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  nextafterl(arg1, arg2);
}

void test__nextafterl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((nextafterl(arg1, arg2) > 10) || (nextafterl(arg1, arg2) < 100)) {}
}

void test__nextafterl__leakignore() {
  char *p = malloc(10); *p=0;
  result = nextafterl(p, arg2);
  // cppcheck-suppress memleak
}

void test__nextafterl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nextafterl(x, arg2);
}

void test__nextafterl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nextafterl(arg1, x);
}

void test__std__nextafterl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::nextafterl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__nextafterl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::nextafterl(arg1, arg2);
}

void test__std__nextafterl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::nextafterl(arg1, arg2) > 10) || (std::nextafterl(arg1, arg2) < 100)) {}
}

void test__std__nextafterl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nextafterl(x, arg2);
}

void test__std__nextafterl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nextafterl(arg1, x);
}

void test__nexttoward__noreturn() {
  int x = 1;
  if (cond) { x=100; result = nexttoward(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__nexttoward__useretval() {
  // cppcheck-suppress ignoredReturnValue
  nexttoward(arg1, arg2);
}

void test__nexttoward__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((nexttoward(arg1, arg2) > 10) || (nexttoward(arg1, arg2) < 100)) {}
}

void test__nexttoward__leakignore() {
  char *p = malloc(10); *p=0;
  result = nexttoward(p, arg2);
  // cppcheck-suppress memleak
}

void test__nexttoward__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nexttoward(x, arg2);
}

void test__nexttoward__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nexttoward(arg1, x);
}

void test__std__nexttoward__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::nexttoward(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__nexttoward__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::nexttoward(arg1, arg2);
}

void test__std__nexttoward__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::nexttoward(arg1, arg2) > 10) || (std::nexttoward(arg1, arg2) < 100)) {}
}

void test__std__nexttoward__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nexttoward(x, arg2);
}

void test__std__nexttoward__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nexttoward(arg1, x);
}

void test__nexttowardf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = nexttowardf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__nexttowardf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  nexttowardf(arg1, arg2);
}

void test__nexttowardf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((nexttowardf(arg1, arg2) > 10) || (nexttowardf(arg1, arg2) < 100)) {}
}

void test__nexttowardf__leakignore() {
  char *p = malloc(10); *p=0;
  result = nexttowardf(p, arg2);
  // cppcheck-suppress memleak
}

void test__nexttowardf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nexttowardf(x, arg2);
}

void test__nexttowardf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nexttowardf(arg1, x);
}

void test__std__nexttowardf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::nexttowardf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__nexttowardf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::nexttowardf(arg1, arg2);
}

void test__std__nexttowardf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::nexttowardf(arg1, arg2) > 10) || (std::nexttowardf(arg1, arg2) < 100)) {}
}

void test__std__nexttowardf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nexttowardf(x, arg2);
}

void test__std__nexttowardf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nexttowardf(arg1, x);
}

void test__nexttowardl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = nexttowardl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__nexttowardl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  nexttowardl(arg1, arg2);
}

void test__nexttowardl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((nexttowardl(arg1, arg2) > 10) || (nexttowardl(arg1, arg2) < 100)) {}
}

void test__nexttowardl__leakignore() {
  char *p = malloc(10); *p=0;
  result = nexttowardl(p, arg2);
  // cppcheck-suppress memleak
}

void test__nexttowardl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nexttowardl(x, arg2);
}

void test__nexttowardl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = nexttowardl(arg1, x);
}

void test__std__nexttowardl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::nexttowardl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__nexttowardl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::nexttowardl(arg1, arg2);
}

void test__std__nexttowardl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::nexttowardl(arg1, arg2) > 10) || (std::nexttowardl(arg1, arg2) < 100)) {}
}

void test__std__nexttowardl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nexttowardl(x, arg2);
}

void test__std__nexttowardl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::nexttowardl(arg1, x);
}

void test__longjmp__noreturn() {
  int x = 1;
  if (cond) { x=100; longjmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__longjmp__leakignore() {
  char *p = malloc(10); *p=0;
  longjmp(p, arg2);
  // cppcheck-suppress memleak
}

void test__longjmp__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  longjmp(x, arg2);
}

void test__longjmp__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  longjmp(arg1, x);
}

void test__std__longjmp__noreturn() {
  int x = 1;
  if (cond) { x=100; std::longjmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__longjmp__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::longjmp(x, arg2);
}

void test__std__longjmp__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::longjmp(arg1, x);
}

void test__malloc__noreturn() {
  int x = 1;
  if (cond) { x=100; result = malloc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__malloc__useretval() {
  // cppcheck-suppress ignoredReturnValue
  malloc(arg1);
}

void test__malloc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = malloc(x);
}

void test__std__malloc__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::malloc(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__malloc__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::malloc(arg1);
}

void test__std__malloc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::malloc(x);
}

void test__alloca__noreturn() {
  int x = 1;
  if (cond) { x=100; result = alloca(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__alloca__useretval() {
  // cppcheck-suppress ignoredReturnValue
  alloca(arg1);
}

void test__alloca__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = alloca(x);
}

void test__memchr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = memchr(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__memchr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  memchr(arg1, arg2, arg3);
}

void test__memchr__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((memchr(arg1, arg2, arg3) > 10) || (memchr(arg1, arg2, arg3) < 100)) {}
}

void test__memchr__leakignore() {
  char *p = malloc(10); *p=0;
  result = memchr(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__memchr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = memchr(NULL, arg2, arg3);
}

void test__memchr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = memchr(x, arg2, arg3);
}

void test__memchr__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = memchr(arg1, !x, arg3);
}

void test__memchr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = memchr(arg1, x, arg3);
}

void test__memchr__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = memchr(arg1, arg2, !x);
}

void test__memchr__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = memchr(arg1, arg2, x);
}

void test__std__memchr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::memchr(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__memchr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::memchr(arg1, arg2, arg3);
}

void test__std__memchr__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::memchr(arg1, arg2, arg3) > 10) || (std::memchr(arg1, arg2, arg3) < 100)) {}
}

void test__std__memchr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::memchr(NULL, arg2, arg3);
}

void test__std__memchr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::memchr(x, arg2, arg3);
}

void test__std__memchr__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = std::memchr(arg1, !x, arg3);
}

void test__std__memchr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::memchr(arg1, x, arg3);
}

void test__std__memchr__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = std::memchr(arg1, arg2, !x);
}

void test__std__memchr__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::memchr(arg1, arg2, x);
}

void test__wmemchr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wmemchr(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wmemchr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wmemchr(arg1, arg2, arg3);
}

void test__wmemchr__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((wmemchr(arg1, arg2, arg3) > 10) || (wmemchr(arg1, arg2, arg3) < 100)) {}
}

void test__wmemchr__leakignore() {
  char *p = malloc(10); *p=0;
  result = wmemchr(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wmemchr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wmemchr(NULL, arg2, arg3);
}

void test__wmemchr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wmemchr(x, arg2, arg3);
}

void test__wmemchr__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = wmemchr(arg1, !x, arg3);
}

void test__wmemchr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = wmemchr(arg1, x, arg3);
}

void test__wmemchr__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = wmemchr(arg1, arg2, !x);
}

void test__wmemchr__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = wmemchr(arg1, arg2, x);
}

void test__std__wmemchr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wmemchr(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wmemchr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wmemchr(arg1, arg2, arg3);
}

void test__std__wmemchr__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::wmemchr(arg1, arg2, arg3) > 10) || (std::wmemchr(arg1, arg2, arg3) < 100)) {}
}

void test__std__wmemchr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wmemchr(NULL, arg2, arg3);
}

void test__std__wmemchr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wmemchr(x, arg2, arg3);
}

void test__std__wmemchr__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = std::wmemchr(arg1, !x, arg3);
}

void test__std__wmemchr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wmemchr(arg1, x, arg3);
}

void test__std__wmemchr__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = std::wmemchr(arg1, arg2, !x);
}

void test__std__wmemchr__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wmemchr(arg1, arg2, x);
}

void test__memcmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = memcmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__memcmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  memcmp(arg1, arg2, arg3);
}

void test__memcmp__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((memcmp(arg1, arg2, arg3) > 10) || (memcmp(arg1, arg2, arg3) < 100)) {}
}

void test__memcmp__leakignore() {
  char *p = malloc(10); *p=0;
  result = memcmp(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__memcmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = memcmp(NULL, arg2, arg3);
}

void test__memcmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = memcmp(x, arg2, arg3);
}

void test__memcmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = memcmp(arg1, NULL, arg3);
}

void test__memcmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = memcmp(arg1, x, arg3);
}

void test__memcmp__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = memcmp(arg1, arg2, !x);
}

void test__memcmp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = memcmp(arg1, arg2, x);
}

void test__std__memcmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::memcmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__memcmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::memcmp(arg1, arg2, arg3);
}

void test__std__memcmp__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::memcmp(arg1, arg2, arg3) > 10) || (std::memcmp(arg1, arg2, arg3) < 100)) {}
}

void test__std__memcmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::memcmp(NULL, arg2, arg3);
}

void test__std__memcmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::memcmp(x, arg2, arg3);
}

void test__std__memcmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::memcmp(arg1, NULL, arg3);
}

void test__std__memcmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::memcmp(arg1, x, arg3);
}

void test__std__memcmp__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = std::memcmp(arg1, arg2, !x);
}

void test__std__memcmp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::memcmp(arg1, arg2, x);
}

void test__wmemcmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wmemcmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wmemcmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wmemcmp(arg1, arg2, arg3);
}

void test__wmemcmp__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((wmemcmp(arg1, arg2, arg3) > 10) || (wmemcmp(arg1, arg2, arg3) < 100)) {}
}

void test__wmemcmp__leakignore() {
  char *p = malloc(10); *p=0;
  result = wmemcmp(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wmemcmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wmemcmp(NULL, arg2, arg3);
}

void test__wmemcmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wmemcmp(x, arg2, arg3);
}

void test__wmemcmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = wmemcmp(arg1, NULL, arg3);
}

void test__wmemcmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wmemcmp(arg1, x, arg3);
}

void test__wmemcmp__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = wmemcmp(arg1, arg2, !x);
}

void test__wmemcmp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = wmemcmp(arg1, arg2, x);
}

void test__std__wmemcmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wmemcmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wmemcmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wmemcmp(arg1, arg2, arg3);
}

void test__std__wmemcmp__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::wmemcmp(arg1, arg2, arg3) > 10) || (std::wmemcmp(arg1, arg2, arg3) < 100)) {}
}

void test__std__wmemcmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wmemcmp(NULL, arg2, arg3);
}

void test__std__wmemcmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wmemcmp(x, arg2, arg3);
}

void test__std__wmemcmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wmemcmp(arg1, NULL, arg3);
}

void test__std__wmemcmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wmemcmp(arg1, x, arg3);
}

void test__std__wmemcmp__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = std::wmemcmp(arg1, arg2, !x);
}

void test__std__wmemcmp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wmemcmp(arg1, arg2, x);
}

void test__memcpy__noreturn() {
  int x = 1;
  if (cond) { x=100; memcpy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__memcpy__leakignore() {
  char *p = malloc(10); *p=0;
  memcpy(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__memcpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  memcpy(NULL, arg2, arg3);
}

void test__memcpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  memcpy(arg1, NULL, arg3);
}

void test__memcpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  memcpy(arg1, x, arg3);
}

void test__memcpy__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  memcpy(arg1, arg2, !x);
}

void test__memcpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  memcpy(arg1, arg2, x);
}

void test__std__memcpy__noreturn() {
  int x = 1;
  if (cond) { x=100; std::memcpy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__memcpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::memcpy(NULL, arg2, arg3);
}

void test__std__memcpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::memcpy(arg1, NULL, arg3);
}

void test__std__memcpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::memcpy(arg1, x, arg3);
}

void test__std__memcpy__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::memcpy(arg1, arg2, !x);
}

void test__std__memcpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::memcpy(arg1, arg2, x);
}

void test__wmemcpy__noreturn() {
  int x = 1;
  if (cond) { x=100; wmemcpy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wmemcpy__leakignore() {
  char *p = malloc(10); *p=0;
  wmemcpy(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wmemcpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wmemcpy(NULL, arg2, arg3);
}

void test__wmemcpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wmemcpy(arg1, NULL, arg3);
}

void test__wmemcpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wmemcpy(arg1, x, arg3);
}

void test__wmemcpy__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  wmemcpy(arg1, arg2, !x);
}

void test__wmemcpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wmemcpy(arg1, arg2, x);
}

void test__std__wmemcpy__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wmemcpy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wmemcpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::wmemcpy(NULL, arg2, arg3);
}

void test__std__wmemcpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::wmemcpy(arg1, NULL, arg3);
}

void test__std__wmemcpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wmemcpy(arg1, x, arg3);
}

void test__std__wmemcpy__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::wmemcpy(arg1, arg2, !x);
}

void test__std__wmemcpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wmemcpy(arg1, arg2, x);
}

void test__memcpy_s__noreturn() {
  int x = 1;
  if (cond) { x=100; memcpy_s(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__memcpy_s__leakignore() {
  char *p = malloc(10); *p=0;
  memcpy_s(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__memcpy_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  memcpy_s(NULL, arg2, arg3, arg4);
}

void test__memcpy_s__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  memcpy_s(arg1, !x, arg3, arg4);
}

void test__memcpy_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  memcpy_s(arg1, x, arg3, arg4);
}

void test__memcpy_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  memcpy_s(arg1, arg2, NULL, arg4);
}

void test__memcpy_s__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  memcpy_s(arg1, arg2, x, arg4);
}

void test__memcpy_s__arg4__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  memcpy_s(arg1, arg2, arg3, !x);
}

void test__memcpy_s__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  memcpy_s(arg1, arg2, arg3, x);
}

void test__wmemcpy_s__noreturn() {
  int x = 1;
  if (cond) { x=100; wmemcpy_s(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wmemcpy_s__leakignore() {
  char *p = malloc(10); *p=0;
  wmemcpy_s(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__wmemcpy_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wmemcpy_s(NULL, arg2, arg3, arg4);
}

void test__wmemcpy_s__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  wmemcpy_s(arg1, !x, arg3, arg4);
}

void test__wmemcpy_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wmemcpy_s(arg1, x, arg3, arg4);
}

void test__wmemcpy_s__arg3__notnull() {
  // cppcheck-suppress nullPointer
  wmemcpy_s(arg1, arg2, NULL, arg4);
}

void test__wmemcpy_s__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wmemcpy_s(arg1, arg2, x, arg4);
}

void test__wmemcpy_s__arg4__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  wmemcpy_s(arg1, arg2, arg3, !x);
}

void test__wmemcpy_s__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wmemcpy_s(arg1, arg2, arg3, x);
}

void test__memmove__noreturn() {
  int x = 1;
  if (cond) { x=100; memmove(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__memmove__leakignore() {
  char *p = malloc(10); *p=0;
  memmove(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__memmove__arg1__notnull() {
  // cppcheck-suppress nullPointer
  memmove(NULL, arg2, arg3);
}

void test__memmove__arg2__notnull() {
  // cppcheck-suppress nullPointer
  memmove(arg1, NULL, arg3);
}

void test__memmove__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  memmove(arg1, x, arg3);
}

void test__memmove__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  memmove(arg1, arg2, !x);
}

void test__memmove__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  memmove(arg1, arg2, x);
}

void test__std__memmove__noreturn() {
  int x = 1;
  if (cond) { x=100; std::memmove(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__memmove__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::memmove(NULL, arg2, arg3);
}

void test__std__memmove__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::memmove(arg1, NULL, arg3);
}

void test__std__memmove__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::memmove(arg1, x, arg3);
}

void test__std__memmove__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::memmove(arg1, arg2, !x);
}

void test__std__memmove__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::memmove(arg1, arg2, x);
}

void test__wmemmove__noreturn() {
  int x = 1;
  if (cond) { x=100; wmemmove(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wmemmove__leakignore() {
  char *p = malloc(10); *p=0;
  wmemmove(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wmemmove__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wmemmove(NULL, arg2, arg3);
}

void test__wmemmove__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wmemmove(arg1, NULL, arg3);
}

void test__wmemmove__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wmemmove(arg1, x, arg3);
}

void test__wmemmove__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  wmemmove(arg1, arg2, !x);
}

void test__wmemmove__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wmemmove(arg1, arg2, x);
}

void test__std__wmemmove__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wmemmove(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wmemmove__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::wmemmove(NULL, arg2, arg3);
}

void test__std__wmemmove__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::wmemmove(arg1, NULL, arg3);
}

void test__std__wmemmove__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wmemmove(arg1, x, arg3);
}

void test__std__wmemmove__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::wmemmove(arg1, arg2, !x);
}

void test__std__wmemmove__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wmemmove(arg1, arg2, x);
}

void test__memset_s__noreturn() {
  int x = 1;
  if (cond) { x=100; memset_s(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__memset_s__leakignore() {
  char *p = malloc(10); *p=0;
  memset_s(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__memset_s__arg1__notnull() {
  // cppcheck-suppress nullPointer
  memset_s(NULL, arg2, arg3, arg4);
}

void test__memset_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  memset_s(arg1, x, arg3, arg4);
}

void test__memset_s__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  memset_s(arg1, arg2, x, arg4);
}

void test__memset_s__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  memset_s(arg1, arg2, arg3, x);
}

void test__memset__noreturn() {
  int x = 1;
  if (cond) { x=100; memset(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__memset__leakignore() {
  char *p = malloc(10); *p=0;
  memset(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__memset__arg1__notnull() {
  // cppcheck-suppress nullPointer
  memset(NULL, arg2, arg3);
}

void test__memset__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  memset(arg1, x, arg3);
}

void test__memset__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  memset(arg1, arg2, !x);
}

void test__memset__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  memset(arg1, arg2, x);
}

void test__std__memset__noreturn() {
  int x = 1;
  if (cond) { x=100; std::memset(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__memset__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::memset(NULL, arg2, arg3);
}

void test__std__memset__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::memset(arg1, x, arg3);
}

void test__std__memset__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::memset(arg1, arg2, !x);
}

void test__std__memset__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::memset(arg1, arg2, x);
}

void test__wmemset__noreturn() {
  int x = 1;
  if (cond) { x=100; wmemset(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wmemset__leakignore() {
  char *p = malloc(10); *p=0;
  wmemset(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wmemset__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wmemset(NULL, arg2, arg3);
}

void test__wmemset__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wmemset(arg1, x, arg3);
}

void test__wmemset__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  wmemset(arg1, arg2, !x);
}

void test__wmemset__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wmemset(arg1, arg2, x);
}

void test__std__wmemset__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wmemset(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wmemset__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::wmemset(NULL, arg2, arg3);
}

void test__std__wmemset__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wmemset(arg1, x, arg3);
}

void test__std__wmemset__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::wmemset(arg1, arg2, !x);
}

void test__std__wmemset__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wmemset(arg1, arg2, x);
}

void test__mktime__noreturn() {
  int x = 1;
  if (cond) { x=100; mktime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mktime__leakignore() {
  char *p = malloc(10); *p=0;
  mktime(p);
  // cppcheck-suppress memleak
}

void test__mktime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  mktime(NULL);
}

void test__mktime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  mktime(x);
}

void test__std__mktime__noreturn() {
  int x = 1;
  if (cond) { x=100; std::mktime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__mktime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::mktime(NULL);
}

void test__std__mktime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::mktime(x);
}

void test__mkxtime__noreturn() {
  int x = 1;
  if (cond) { x=100; mkxtime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mkxtime__leakignore() {
  char *p = malloc(10); *p=0;
  mkxtime(p);
  // cppcheck-suppress memleak
}

void test__mkxtime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  mkxtime(NULL);
}

void test__mkxtime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  mkxtime(x);
}

void test__modf__noreturn() {
  int x = 1;
  if (cond) { x=100; modf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__modf__leakignore() {
  char *p = malloc(10); *p=0;
  modf(p, arg2);
  // cppcheck-suppress memleak
}

void test__modf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  modf(x, arg2);
}

void test__modf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  modf(arg1, NULL);
}

void test__std__modf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::modf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__modf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::modf(x, arg2);
}

void test__std__modf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::modf(arg1, NULL);
}

void test__modff__noreturn() {
  int x = 1;
  if (cond) { x=100; modff(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__modff__leakignore() {
  char *p = malloc(10); *p=0;
  modff(p, arg2);
  // cppcheck-suppress memleak
}

void test__modff__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  modff(x, arg2);
}

void test__modff__arg2__notnull() {
  // cppcheck-suppress nullPointer
  modff(arg1, NULL);
}

void test__std__modff__noreturn() {
  int x = 1;
  if (cond) { x=100; std::modff(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__modff__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::modff(x, arg2);
}

void test__std__modff__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::modff(arg1, NULL);
}

void test__modfl__noreturn() {
  int x = 1;
  if (cond) { x=100; modfl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__modfl__leakignore() {
  char *p = malloc(10); *p=0;
  modfl(p, arg2);
  // cppcheck-suppress memleak
}

void test__modfl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  modfl(x, arg2);
}

void test__modfl__arg2__notnull() {
  // cppcheck-suppress nullPointer
  modfl(arg1, NULL);
}

void test__std__modfl__noreturn() {
  int x = 1;
  if (cond) { x=100; std::modfl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__modfl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::modfl(x, arg2);
}

void test__std__modfl__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::modfl(arg1, NULL);
}

void test__perror__noreturn() {
  int x = 1;
  if (cond) { x=100; perror(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__perror__leakignore() {
  char *p = malloc(10); *p=0;
  perror(p);
  // cppcheck-suppress memleak
}

void test__perror__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  perror(x);
}

void test__std__perror__noreturn() {
  int x = 1;
  if (cond) { x=100; std::perror(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__perror__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::perror(x);
}

void test__pow__noreturn() {
  int x = 1;
  if (cond) { x=100; result = pow(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pow__useretval() {
  // cppcheck-suppress ignoredReturnValue
  pow(arg1, arg2);
}

void test__pow__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((pow(arg1, arg2) > 10) || (pow(arg1, arg2) < 100)) {}
}

void test__pow__leakignore() {
  char *p = malloc(10); *p=0;
  result = pow(p, arg2);
  // cppcheck-suppress memleak
}

void test__pow__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = pow(x, arg2);
}

void test__pow__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = pow(arg1, x);
}

void test__std__pow__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::pow(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__pow__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::pow(arg1, arg2);
}

void test__std__pow__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::pow(arg1, arg2) > 10) || (std::pow(arg1, arg2) < 100)) {}
}

void test__std__pow__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::pow(x, arg2);
}

void test__std__pow__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::pow(arg1, x);
}

void test__powf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = powf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__powf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  powf(arg1, arg2);
}

void test__powf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((powf(arg1, arg2) > 10) || (powf(arg1, arg2) < 100)) {}
}

void test__powf__leakignore() {
  char *p = malloc(10); *p=0;
  result = powf(p, arg2);
  // cppcheck-suppress memleak
}

void test__powf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = powf(x, arg2);
}

void test__powf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = powf(arg1, x);
}

void test__std__powf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::powf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__powf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::powf(arg1, arg2);
}

void test__std__powf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::powf(arg1, arg2) > 10) || (std::powf(arg1, arg2) < 100)) {}
}

void test__std__powf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::powf(x, arg2);
}

void test__std__powf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::powf(arg1, x);
}

void test__powl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = powl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__powl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  powl(arg1, arg2);
}

void test__powl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((powl(arg1, arg2) > 10) || (powl(arg1, arg2) < 100)) {}
}

void test__powl__leakignore() {
  char *p = malloc(10); *p=0;
  result = powl(p, arg2);
  // cppcheck-suppress memleak
}

void test__powl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = powl(x, arg2);
}

void test__powl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = powl(arg1, x);
}

void test__std__powl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::powl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__powl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::powl(arg1, arg2);
}

void test__std__powl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::powl(arg1, arg2) > 10) || (std::powl(arg1, arg2) < 100)) {}
}

void test__std__powl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::powl(x, arg2);
}

void test__std__powl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::powl(arg1, x);
}

void test__cpow__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cpow(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cpow__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cpow(arg1, arg2);
}

void test__cpow__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cpow(arg1, arg2) > 10) || (cpow(arg1, arg2) < 100)) {}
}

void test__cpow__leakignore() {
  char *p = malloc(10); *p=0;
  result = cpow(p, arg2);
  // cppcheck-suppress memleak
}

void test__cpow__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cpow(x, arg2);
}

void test__cpow__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cpow(arg1, x);
}

void test__cpowf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cpowf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cpowf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cpowf(arg1, arg2);
}

void test__cpowf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cpowf(arg1, arg2) > 10) || (cpowf(arg1, arg2) < 100)) {}
}

void test__cpowf__leakignore() {
  char *p = malloc(10); *p=0;
  result = cpowf(p, arg2);
  // cppcheck-suppress memleak
}

void test__cpowf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cpowf(x, arg2);
}

void test__cpowf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cpowf(arg1, x);
}

void test__cpowl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = cpowl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cpowl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  cpowl(arg1, arg2);
}

void test__cpowl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((cpowl(arg1, arg2) > 10) || (cpowl(arg1, arg2) < 100)) {}
}

void test__cpowl__leakignore() {
  char *p = malloc(10); *p=0;
  result = cpowl(p, arg2);
  // cppcheck-suppress memleak
}

void test__cpowl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cpowl(x, arg2);
}

void test__cpowl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = cpowl(arg1, x);
}

void test__remainder__noreturn() {
  int x = 1;
  if (cond) { x=100; result = remainder(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__remainder__useretval() {
  // cppcheck-suppress ignoredReturnValue
  remainder(arg1, arg2);
}

void test__remainder__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((remainder(arg1, arg2) > 10) || (remainder(arg1, arg2) < 100)) {}
}

void test__remainder__leakignore() {
  char *p = malloc(10); *p=0;
  result = remainder(p, arg2);
  // cppcheck-suppress memleak
}

void test__remainder__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = remainder(x, arg2);
}

void test__remainder__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = remainder(arg1, x);
}

void test__std__remainder__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::remainder(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__remainder__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::remainder(arg1, arg2);
}

void test__std__remainder__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::remainder(arg1, arg2) > 10) || (std::remainder(arg1, arg2) < 100)) {}
}

void test__std__remainder__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::remainder(x, arg2);
}

void test__std__remainder__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::remainder(arg1, x);
}

void test__remainderf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = remainderf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__remainderf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  remainderf(arg1, arg2);
}

void test__remainderf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((remainderf(arg1, arg2) > 10) || (remainderf(arg1, arg2) < 100)) {}
}

void test__remainderf__leakignore() {
  char *p = malloc(10); *p=0;
  result = remainderf(p, arg2);
  // cppcheck-suppress memleak
}

void test__remainderf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = remainderf(x, arg2);
}

void test__remainderf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = remainderf(arg1, x);
}

void test__std__remainderf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::remainderf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__remainderf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::remainderf(arg1, arg2);
}

void test__std__remainderf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::remainderf(arg1, arg2) > 10) || (std::remainderf(arg1, arg2) < 100)) {}
}

void test__std__remainderf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::remainderf(x, arg2);
}

void test__std__remainderf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::remainderf(arg1, x);
}

void test__remainderl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = remainderl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__remainderl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  remainderl(arg1, arg2);
}

void test__remainderl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((remainderl(arg1, arg2) > 10) || (remainderl(arg1, arg2) < 100)) {}
}

void test__remainderl__leakignore() {
  char *p = malloc(10); *p=0;
  result = remainderl(p, arg2);
  // cppcheck-suppress memleak
}

void test__remainderl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = remainderl(x, arg2);
}

void test__remainderl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = remainderl(arg1, x);
}

void test__std__remainderl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::remainderl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__remainderl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::remainderl(arg1, arg2);
}

void test__std__remainderl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::remainderl(arg1, arg2) > 10) || (std::remainderl(arg1, arg2) < 100)) {}
}

void test__std__remainderl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::remainderl(x, arg2);
}

void test__std__remainderl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::remainderl(arg1, x);
}

void test__remquo__noreturn() {
  int x = 1;
  if (cond) { x=100; result = remquo(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__remquo__useretval() {
  // cppcheck-suppress ignoredReturnValue
  remquo(arg1, arg2, arg3);
}

void test__remquo__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((remquo(arg1, arg2, arg3) > 10) || (remquo(arg1, arg2, arg3) < 100)) {}
}

void test__remquo__leakignore() {
  char *p = malloc(10); *p=0;
  result = remquo(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__remquo__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = remquo(x, arg2, arg3);
}

void test__remquo__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = remquo(arg1, x, arg3);
}

void test__remquo__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = remquo(arg1, arg2, NULL);
}

void test__std__remquo__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::remquo(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__remquo__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::remquo(arg1, arg2, arg3);
}

void test__std__remquo__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::remquo(arg1, arg2, arg3) > 10) || (std::remquo(arg1, arg2, arg3) < 100)) {}
}

void test__std__remquo__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::remquo(x, arg2, arg3);
}

void test__std__remquo__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::remquo(arg1, x, arg3);
}

void test__std__remquo__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = std::remquo(arg1, arg2, NULL);
}

void test__remquof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = remquof(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__remquof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  remquof(arg1, arg2, arg3);
}

void test__remquof__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((remquof(arg1, arg2, arg3) > 10) || (remquof(arg1, arg2, arg3) < 100)) {}
}

void test__remquof__leakignore() {
  char *p = malloc(10); *p=0;
  result = remquof(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__remquof__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = remquof(x, arg2, arg3);
}

void test__remquof__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = remquof(arg1, x, arg3);
}

void test__remquof__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = remquof(arg1, arg2, NULL);
}

void test__std__remquof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::remquof(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__remquof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::remquof(arg1, arg2, arg3);
}

void test__std__remquof__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::remquof(arg1, arg2, arg3) > 10) || (std::remquof(arg1, arg2, arg3) < 100)) {}
}

void test__std__remquof__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::remquof(x, arg2, arg3);
}

void test__std__remquof__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::remquof(arg1, x, arg3);
}

void test__std__remquof__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = std::remquof(arg1, arg2, NULL);
}

void test__remquol__noreturn() {
  int x = 1;
  if (cond) { x=100; result = remquol(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__remquol__useretval() {
  // cppcheck-suppress ignoredReturnValue
  remquol(arg1, arg2, arg3);
}

void test__remquol__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((remquol(arg1, arg2, arg3) > 10) || (remquol(arg1, arg2, arg3) < 100)) {}
}

void test__remquol__leakignore() {
  char *p = malloc(10); *p=0;
  result = remquol(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__remquol__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = remquol(x, arg2, arg3);
}

void test__remquol__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = remquol(arg1, x, arg3);
}

void test__remquol__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = remquol(arg1, arg2, NULL);
}

void test__std__remquol__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::remquol(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__remquol__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::remquol(arg1, arg2, arg3);
}

void test__std__remquol__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::remquol(arg1, arg2, arg3) > 10) || (std::remquol(arg1, arg2, arg3) < 100)) {}
}

void test__std__remquol__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::remquol(x, arg2, arg3);
}

void test__std__remquol__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::remquol(arg1, x, arg3);
}

void test__std__remquol__arg3__notnull() {
  // cppcheck-suppress nullPointer
  result = std::remquol(arg1, arg2, NULL);
}

void test__printf__noreturn() {
  int x = 1;
  if (cond) { x=100; printf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__printf__leakignore() {
  char *p = malloc(10); *p=0;
  printf(p);
  // cppcheck-suppress memleak
}

void test__printf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  printf(x);
}

void test__std__printf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::printf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__printf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::printf(x);
}

void test__vprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; vprintf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vprintf__leakignore() {
  char *p = malloc(10); *p=0;
  vprintf(p, arg2);
  // cppcheck-suppress memleak
}

void test__vprintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  vprintf(x, arg2);
}

void test__std__vprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vprintf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vprintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::vprintf(x, arg2);
}

void test__vwprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; vwprintf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vwprintf__leakignore() {
  char *p = malloc(10); *p=0;
  vwprintf(p, arg2);
  // cppcheck-suppress memleak
}

void test__vwprintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  vwprintf(x, arg2);
}

void test__std__vwprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vwprintf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vwprintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::vwprintf(x, arg2);
}

void test__bsearch__noreturn() {
  int x = 1;
  if (cond) { x=100; result = bsearch(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__bsearch__useretval() {
  // cppcheck-suppress ignoredReturnValue
  bsearch(arg1, arg2, arg3, arg4, arg5);
}

void test__bsearch__pure(int arg1,int arg2,int arg3,int arg4,int arg5) {
  // cppcheck-suppress incorrectLogicOperator
  if ((bsearch(arg1, arg2, arg3, arg4, arg5) > 10) || (bsearch(arg1, arg2, arg3, arg4, arg5) < 100)) {}
}

void test__bsearch__leakignore() {
  char *p = malloc(10); *p=0;
  result = bsearch(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__bsearch__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = bsearch(NULL, arg2, arg3, arg4, arg5);
}

void test__bsearch__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = bsearch(x, arg2, arg3, arg4, arg5);
}

void test__bsearch__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = bsearch(arg1, NULL, arg3, arg4, arg5);
}

void test__bsearch__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = bsearch(arg1, x, arg3, arg4, arg5);
}

void test__bsearch__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = bsearch(arg1, arg2, x, arg4, arg5);
}

void test__bsearch__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = bsearch(arg1, arg2, arg3, x, arg5);
}

void test__bsearch__arg5__notnull() {
  // cppcheck-suppress nullPointer
  result = bsearch(arg1, arg2, arg3, arg4, NULL);
}

void test__bsearch__arg5__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = bsearch(arg1, arg2, arg3, arg4, x);
}

void test__std__bsearch__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::bsearch(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__bsearch__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::bsearch(arg1, arg2, arg3, arg4, arg5);
}

void test__std__bsearch__pure(int arg1,int arg2,int arg3,int arg4,int arg5) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::bsearch(arg1, arg2, arg3, arg4, arg5) > 10) || (std::bsearch(arg1, arg2, arg3, arg4, arg5) < 100)) {}
}

void test__std__bsearch__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::bsearch(NULL, arg2, arg3, arg4, arg5);
}

void test__std__bsearch__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::bsearch(x, arg2, arg3, arg4, arg5);
}

void test__std__bsearch__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::bsearch(arg1, NULL, arg3, arg4, arg5);
}

void test__std__bsearch__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::bsearch(arg1, x, arg3, arg4, arg5);
}

void test__std__bsearch__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::bsearch(arg1, arg2, x, arg4, arg5);
}

void test__std__bsearch__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::bsearch(arg1, arg2, arg3, x, arg5);
}

void test__std__bsearch__arg5__notnull() {
  // cppcheck-suppress nullPointer
  result = std::bsearch(arg1, arg2, arg3, arg4, NULL);
}

void test__std__bsearch__arg5__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::bsearch(arg1, arg2, arg3, arg4, x);
}

void test__qsort__noreturn() {
  int x = 1;
  if (cond) { x=100; qsort(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__qsort__leakignore() {
  char *p = malloc(10); *p=0;
  qsort(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__qsort__arg1__notnull() {
  // cppcheck-suppress nullPointer
  qsort(NULL, arg2, arg3, arg4);
}

void test__qsort__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  qsort(x, arg2, arg3, arg4);
}

void test__qsort__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  qsort(arg1, x, arg3, arg4);
}

void test__qsort__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  qsort(arg1, arg2, x, arg4);
}

void test__qsort__arg4__notnull() {
  // cppcheck-suppress nullPointer
  qsort(arg1, arg2, arg3, NULL);
}

void test__qsort__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  qsort(arg1, arg2, arg3, x);
}

void test__std__qsort__noreturn() {
  int x = 1;
  if (cond) { x=100; std::qsort(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__qsort__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::qsort(NULL, arg2, arg3, arg4);
}

void test__std__qsort__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::qsort(x, arg2, arg3, arg4);
}

void test__std__qsort__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::qsort(arg1, x, arg3, arg4);
}

void test__std__qsort__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::qsort(arg1, arg2, x, arg4);
}

void test__std__qsort__arg4__notnull() {
  // cppcheck-suppress nullPointer
  std::qsort(arg1, arg2, arg3, NULL);
}

void test__std__qsort__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::qsort(arg1, arg2, arg3, x);
}

void test__putc__noreturn() {
  int x = 1;
  if (cond) { x=100; putc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__putc__leakignore() {
  char *p = malloc(10); *p=0;
  putc(p, arg2);
  // cppcheck-suppress memleak
}

void test__putc__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  putc(!x, arg2);
}

void test__putc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  putc(x, arg2);
}

void test__putc__arg2__notnull() {
  // cppcheck-suppress nullPointer
  putc(arg1, NULL);
}

void test__putc__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  putc(arg1, x);
}

void test__std__putc__noreturn() {
  int x = 1;
  if (cond) { x=100; std::putc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__putc__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::putc(!x, arg2);
}

void test__std__putc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::putc(x, arg2);
}

void test__std__putc__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::putc(arg1, NULL);
}

void test__std__putc__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::putc(arg1, x);
}

void test__putwc__noreturn() {
  int x = 1;
  if (cond) { x=100; putwc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__putwc__leakignore() {
  char *p = malloc(10); *p=0;
  putwc(p, arg2);
  // cppcheck-suppress memleak
}

void test__putwc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  putwc(x, arg2);
}

void test__putwc__arg2__notnull() {
  // cppcheck-suppress nullPointer
  putwc(arg1, NULL);
}

void test__putwc__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  putwc(arg1, x);
}

void test__std__putwc__noreturn() {
  int x = 1;
  if (cond) { x=100; std::putwc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__putwc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::putwc(x, arg2);
}

void test__std__putwc__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::putwc(arg1, NULL);
}

void test__std__putwc__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::putwc(arg1, x);
}

void test__putchar__noreturn() {
  int x = 1;
  if (cond) { x=100; putchar(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__putchar__leakignore() {
  char *p = malloc(10); *p=0;
  putchar(p);
  // cppcheck-suppress memleak
}

void test__putchar__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  putchar(!x);
}

void test__putchar__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  putchar(x);
}

void test__std__putchar__noreturn() {
  int x = 1;
  if (cond) { x=100; std::putchar(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__putchar__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::putchar(!x);
}

void test__std__putchar__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::putchar(x);
}

void test__putwchar__noreturn() {
  int x = 1;
  if (cond) { x=100; putwchar(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__putwchar__leakignore() {
  char *p = malloc(10); *p=0;
  putwchar(p);
  // cppcheck-suppress memleak
}

void test__putwchar__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  putwchar(x);
}

void test__std__putwchar__noreturn() {
  int x = 1;
  if (cond) { x=100; std::putwchar(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__putwchar__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::putwchar(x);
}

void test__puts__noreturn() {
  int x = 1;
  if (cond) { x=100; puts(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__puts__leakignore() {
  char *p = malloc(10); *p=0;
  puts(p);
  // cppcheck-suppress memleak
}

void test__puts__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  puts(!x);
}

void test__puts__arg1__notnull() {
  // cppcheck-suppress nullPointer
  puts(NULL);
}

void test__puts__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  puts(x);
}

void test__std__puts__noreturn() {
  int x = 1;
  if (cond) { x=100; std::puts(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__puts__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::puts(!x);
}

void test__std__puts__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::puts(NULL);
}

void test__std__puts__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::puts(x);
}

void test__realloc__noreturn() {
  int x = 1;
  if (cond) { x=100; realloc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__realloc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  realloc(x, arg2);
}

void test__realloc__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  realloc(arg1, x);
}

void test__std__realloc__noreturn() {
  int x = 1;
  if (cond) { x=100; std::realloc(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__realloc__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::realloc(x, arg2);
}

void test__std__realloc__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::realloc(arg1, x);
}

void test__remove__noreturn() {
  int x = 1;
  if (cond) { x=100; remove(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__remove__leakignore() {
  char *p = malloc(10); *p=0;
  remove(p);
  // cppcheck-suppress memleak
}

void test__remove__arg1__notnull() {
  // cppcheck-suppress nullPointer
  remove(NULL);
}

void test__remove__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  remove(x);
}

void test__std__remove__noreturn() {
  int x = 1;
  if (cond) { x=100; std::remove(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__remove__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::remove(NULL);
}

void test__std__remove__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::remove(x);
}

void test__rename__noreturn() {
  int x = 1;
  if (cond) { x=100; rename(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__rename__leakignore() {
  char *p = malloc(10); *p=0;
  rename(p, arg2);
  // cppcheck-suppress memleak
}

void test__rename__arg1__notnull() {
  // cppcheck-suppress nullPointer
  rename(NULL, arg2);
}

void test__rename__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  rename(x, arg2);
}

void test__rename__arg2__notnull() {
  // cppcheck-suppress nullPointer
  rename(arg1, NULL);
}

void test__rename__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  rename(arg1, x);
}

void test__std__rename__noreturn() {
  int x = 1;
  if (cond) { x=100; std::rename(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__rename__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::rename(NULL, arg2);
}

void test__std__rename__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::rename(x, arg2);
}

void test__std__rename__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::rename(arg1, NULL);
}

void test__std__rename__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::rename(arg1, x);
}

void test__rewind__noreturn() {
  int x = 1;
  if (cond) { x=100; rewind(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__rewind__leakignore() {
  char *p = malloc(10); *p=0;
  rewind(p);
  // cppcheck-suppress memleak
}

void test__rewind__arg1__notnull() {
  // cppcheck-suppress nullPointer
  rewind(NULL);
}

void test__rewind__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  rewind(x);
}

void test__std__rewind__noreturn() {
  int x = 1;
  if (cond) { x=100; std::rewind(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__rewind__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::rewind(NULL);
}

void test__std__rewind__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::rewind(x);
}

void test__round__noreturn() {
  int x = 1;
  if (cond) { x=100; result = round(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__round__useretval() {
  // cppcheck-suppress ignoredReturnValue
  round(arg1);
}

void test__round__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((round(arg1) > 10) || (round(arg1) < 100)) {}
}

void test__round__leakignore() {
  char *p = malloc(10); *p=0;
  result = round(p);
  // cppcheck-suppress memleak
}

void test__round__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = round(x);
}

void test__std__round__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::round(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__round__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::round(arg1);
}

void test__std__round__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::round(arg1) > 10) || (std::round(arg1) < 100)) {}
}

void test__std__round__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::round(x);
}

void test__roundf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = roundf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__roundf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  roundf(arg1);
}

void test__roundf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((roundf(arg1) > 10) || (roundf(arg1) < 100)) {}
}

void test__roundf__leakignore() {
  char *p = malloc(10); *p=0;
  result = roundf(p);
  // cppcheck-suppress memleak
}

void test__roundf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = roundf(x);
}

void test__std__roundf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::roundf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__roundf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::roundf(arg1);
}

void test__std__roundf__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::roundf(arg1) > 10) || (std::roundf(arg1) < 100)) {}
}

void test__std__roundf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::roundf(x);
}

void test__roundl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = roundl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__roundl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  roundl(arg1);
}

void test__roundl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((roundl(arg1) > 10) || (roundl(arg1) < 100)) {}
}

void test__roundl__leakignore() {
  char *p = malloc(10); *p=0;
  result = roundl(p);
  // cppcheck-suppress memleak
}

void test__roundl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = roundl(x);
}

void test__std__roundl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::roundl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__roundl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::roundl(arg1);
}

void test__std__roundl__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::roundl(arg1) > 10) || (std::roundl(arg1) < 100)) {}
}

void test__std__roundl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::roundl(x);
}

void test__scalbn__noreturn() {
  int x = 1;
  if (cond) { x=100; result = scalbn(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__scalbn__useretval() {
  // cppcheck-suppress ignoredReturnValue
  scalbn(arg1, arg2);
}

void test__scalbn__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((scalbn(arg1, arg2) > 10) || (scalbn(arg1, arg2) < 100)) {}
}

void test__scalbn__leakignore() {
  char *p = malloc(10); *p=0;
  result = scalbn(p, arg2);
  // cppcheck-suppress memleak
}

void test__scalbn__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = scalbn(x, arg2);
}

void test__scalbn__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = scalbn(arg1, x);
}

void test__std__scalbn__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::scalbn(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__scalbn__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::scalbn(arg1, arg2);
}

void test__std__scalbn__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::scalbn(arg1, arg2) > 10) || (std::scalbn(arg1, arg2) < 100)) {}
}

void test__std__scalbn__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::scalbn(x, arg2);
}

void test__std__scalbn__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::scalbn(arg1, x);
}

void test__scalbnf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = scalbnf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__scalbnf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  scalbnf(arg1, arg2);
}

void test__scalbnf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((scalbnf(arg1, arg2) > 10) || (scalbnf(arg1, arg2) < 100)) {}
}

void test__scalbnf__leakignore() {
  char *p = malloc(10); *p=0;
  result = scalbnf(p, arg2);
  // cppcheck-suppress memleak
}

void test__scalbnf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = scalbnf(x, arg2);
}

void test__scalbnf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = scalbnf(arg1, x);
}

void test__std__scalbnf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::scalbnf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__scalbnf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::scalbnf(arg1, arg2);
}

void test__std__scalbnf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::scalbnf(arg1, arg2) > 10) || (std::scalbnf(arg1, arg2) < 100)) {}
}

void test__std__scalbnf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::scalbnf(x, arg2);
}

void test__std__scalbnf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::scalbnf(arg1, x);
}

void test__scalbnl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = scalbnl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__scalbnl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  scalbnl(arg1, arg2);
}

void test__scalbnl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((scalbnl(arg1, arg2) > 10) || (scalbnl(arg1, arg2) < 100)) {}
}

void test__scalbnl__leakignore() {
  char *p = malloc(10); *p=0;
  result = scalbnl(p, arg2);
  // cppcheck-suppress memleak
}

void test__scalbnl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = scalbnl(x, arg2);
}

void test__scalbnl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = scalbnl(arg1, x);
}

void test__std__scalbnl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::scalbnl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__scalbnl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::scalbnl(arg1, arg2);
}

void test__std__scalbnl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::scalbnl(arg1, arg2) > 10) || (std::scalbnl(arg1, arg2) < 100)) {}
}

void test__std__scalbnl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::scalbnl(x, arg2);
}

void test__std__scalbnl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::scalbnl(arg1, x);
}

void test__scalbln__noreturn() {
  int x = 1;
  if (cond) { x=100; result = scalbln(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__scalbln__useretval() {
  // cppcheck-suppress ignoredReturnValue
  scalbln(arg1, arg2);
}

void test__scalbln__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((scalbln(arg1, arg2) > 10) || (scalbln(arg1, arg2) < 100)) {}
}

void test__scalbln__leakignore() {
  char *p = malloc(10); *p=0;
  result = scalbln(p, arg2);
  // cppcheck-suppress memleak
}

void test__scalbln__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = scalbln(x, arg2);
}

void test__scalbln__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = scalbln(arg1, x);
}

void test__std__scalbln__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::scalbln(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__scalbln__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::scalbln(arg1, arg2);
}

void test__std__scalbln__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::scalbln(arg1, arg2) > 10) || (std::scalbln(arg1, arg2) < 100)) {}
}

void test__std__scalbln__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::scalbln(x, arg2);
}

void test__std__scalbln__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::scalbln(arg1, x);
}

void test__scalblnf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = scalblnf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__scalblnf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  scalblnf(arg1, arg2);
}

void test__scalblnf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((scalblnf(arg1, arg2) > 10) || (scalblnf(arg1, arg2) < 100)) {}
}

void test__scalblnf__leakignore() {
  char *p = malloc(10); *p=0;
  result = scalblnf(p, arg2);
  // cppcheck-suppress memleak
}

void test__scalblnf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = scalblnf(x, arg2);
}

void test__scalblnf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = scalblnf(arg1, x);
}

void test__std__scalblnf__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::scalblnf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__scalblnf__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::scalblnf(arg1, arg2);
}

void test__std__scalblnf__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::scalblnf(arg1, arg2) > 10) || (std::scalblnf(arg1, arg2) < 100)) {}
}

void test__std__scalblnf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::scalblnf(x, arg2);
}

void test__std__scalblnf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::scalblnf(arg1, x);
}

void test__scalblnl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = scalblnl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__scalblnl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  scalblnl(arg1, arg2);
}

void test__scalblnl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((scalblnl(arg1, arg2) > 10) || (scalblnl(arg1, arg2) < 100)) {}
}

void test__scalblnl__leakignore() {
  char *p = malloc(10); *p=0;
  result = scalblnl(p, arg2);
  // cppcheck-suppress memleak
}

void test__scalblnl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = scalblnl(x, arg2);
}

void test__scalblnl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = scalblnl(arg1, x);
}

void test__std__scalblnl__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::scalblnl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__scalblnl__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::scalblnl(arg1, arg2);
}

void test__std__scalblnl__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::scalblnl(arg1, arg2) > 10) || (std::scalblnl(arg1, arg2) < 100)) {}
}

void test__std__scalblnl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::scalblnl(x, arg2);
}

void test__std__scalblnl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::scalblnl(arg1, x);
}

void test__signbit__noreturn() {
  int x = 1;
  if (cond) { x=100; result = signbit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__signbit__useretval() {
  // cppcheck-suppress ignoredReturnValue
  signbit(arg1);
}

void test__signbit__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((signbit(arg1) > 10) || (signbit(arg1) < 100)) {}
}

void test__signbit__leakignore() {
  char *p = malloc(10); *p=0;
  result = signbit(p);
  // cppcheck-suppress memleak
}

void test__signbit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = signbit(x);
}

void test__std__signbit__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::signbit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__signbit__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::signbit(arg1);
}

void test__std__signbit__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::signbit(arg1) > 10) || (std::signbit(arg1) < 100)) {}
}

void test__std__signbit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::signbit(x);
}

void test__signal__noreturn() {
  int x = 1;
  if (cond) { x=100; signal(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__signal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  signal(x, arg2);
}

void test__std__signal__noreturn() {
  int x = 1;
  if (cond) { x=100; std::signal(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__signal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::signal(x, arg2);
}

void test__raise__noreturn() {
  int x = 1;
  if (cond) { x=100; raise(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__raise__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  raise(x);
}

void test__std__raise__noreturn() {
  int x = 1;
  if (cond) { x=100; std::raise(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__raise__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::raise(x);
}

void test__scanf__noreturn() {
  int x = 1;
  if (cond) { x=100; scanf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__scanf__leakignore() {
  char *p = malloc(10); *p=0;
  scanf(p);
  // cppcheck-suppress memleak
}

void test__scanf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  scanf(NULL);
}

void test__scanf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  scanf(x);
}

void test__std__scanf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::scanf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__scanf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::scanf(NULL);
}

void test__std__scanf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::scanf(x);
}

void test__vsscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; vsscanf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vsscanf__leakignore() {
  char *p = malloc(10); *p=0;
  vsscanf(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__vsscanf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  vsscanf(NULL, arg2, arg3);
}

void test__vsscanf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  vsscanf(x, arg2, arg3);
}

void test__vsscanf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  vsscanf(arg1, NULL, arg3);
}

void test__vsscanf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  vsscanf(arg1, x, arg3);
}

void test__std__vsscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vsscanf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vsscanf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::vsscanf(NULL, arg2, arg3);
}

void test__std__vsscanf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::vsscanf(x, arg2, arg3);
}

void test__std__vsscanf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::vsscanf(arg1, NULL, arg3);
}

void test__std__vsscanf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::vsscanf(arg1, x, arg3);
}

void test__vswscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; vswscanf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vswscanf__leakignore() {
  char *p = malloc(10); *p=0;
  vswscanf(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__vswscanf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  vswscanf(NULL, arg2, arg3);
}

void test__vswscanf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  vswscanf(x, arg2, arg3);
}

void test__vswscanf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  vswscanf(arg1, NULL, arg3);
}

void test__vswscanf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  vswscanf(arg1, x, arg3);
}

void test__std__vswscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vswscanf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vswscanf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::vswscanf(NULL, arg2, arg3);
}

void test__std__vswscanf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::vswscanf(x, arg2, arg3);
}

void test__std__vswscanf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::vswscanf(arg1, NULL, arg3);
}

void test__std__vswscanf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::vswscanf(arg1, x, arg3);
}

void test__vscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; vscanf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vscanf__leakignore() {
  char *p = malloc(10); *p=0;
  vscanf(p, arg2);
  // cppcheck-suppress memleak
}

void test__vscanf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  vscanf(NULL, arg2);
}

void test__vscanf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  vscanf(x, arg2);
}

void test__std__vscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vscanf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vscanf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::vscanf(NULL, arg2);
}

void test__std__vscanf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::vscanf(x, arg2);
}

void test__vwscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; vwscanf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vwscanf__leakignore() {
  char *p = malloc(10); *p=0;
  vwscanf(p, arg2);
  // cppcheck-suppress memleak
}

void test__vwscanf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  vwscanf(NULL, arg2);
}

void test__std__vwscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vwscanf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vwscanf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::vwscanf(NULL, arg2);
}

void test__setbuf__noreturn() {
  int x = 1;
  if (cond) { x=100; setbuf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setbuf__leakignore() {
  char *p = malloc(10); *p=0;
  setbuf(p, arg2);
  // cppcheck-suppress memleak
}

void test__setbuf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  setbuf(NULL, arg2);
}

void test__setbuf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  setbuf(x, arg2);
}

void test__setbuf__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  setbuf(arg1, !x);
}

void test__std__setbuf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::setbuf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__setbuf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::setbuf(NULL, arg2);
}

void test__std__setbuf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::setbuf(x, arg2);
}

void test__std__setbuf__arg2__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::setbuf(arg1, !x);
}

void test__setvbuf__noreturn() {
  int x = 1;
  if (cond) { x=100; setvbuf(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setvbuf__leakignore() {
  char *p = malloc(10); *p=0;
  setvbuf(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__setvbuf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  setvbuf(NULL, arg2, arg3, arg4);
}

void test__setvbuf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  setvbuf(x, arg2, arg3, arg4);
}

void test__setvbuf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setvbuf(arg1, x, arg3, arg4);
}

void test__setvbuf__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setvbuf(arg1, arg2, x, arg4);
}

void test__setvbuf__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setvbuf(arg1, arg2, arg3, x);
}

void test__std__setvbuf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::setvbuf(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__setvbuf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::setvbuf(NULL, arg2, arg3, arg4);
}

void test__std__setvbuf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::setvbuf(x, arg2, arg3, arg4);
}

void test__std__setvbuf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::setvbuf(arg1, x, arg3, arg4);
}

void test__std__setvbuf__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::setvbuf(arg1, arg2, x, arg4);
}

void test__std__setvbuf__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::setvbuf(arg1, arg2, arg3, x);
}

void test__setjmp__noreturn() {
  int x = 1;
  if (cond) { x=100; setjmp(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setjmp__leakignore() {
  char *p = malloc(10); *p=0;
  setjmp(p);
  // cppcheck-suppress memleak
}

void test__strcat__noreturn() {
  int x = 1;
  if (cond) { x=100; strcat(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strcat__leakignore() {
  char *p = malloc(10); *p=0;
  strcat(p, arg2);
  // cppcheck-suppress memleak
}

void test__strcat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strcat(NULL, arg2);
}

void test__strcat__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strcat(x, arg2);
}

void test__strcat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  strcat(arg1, NULL);
}

void test__strcat__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strcat(arg1, x);
}

void test__std__strcat__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strcat(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strcat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::strcat(NULL, arg2);
}

void test__std__strcat__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strcat(x, arg2);
}

void test__std__strcat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::strcat(arg1, NULL);
}

void test__std__strcat__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strcat(arg1, x);
}

void test__wcscat__noreturn() {
  int x = 1;
  if (cond) { x=100; wcscat(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcscat__leakignore() {
  char *p = malloc(10); *p=0;
  wcscat(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcscat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wcscat(NULL, arg2);
}

void test__wcscat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wcscat(arg1, NULL);
}

void test__wcscat__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcscat(arg1, x);
}

void test__std__wcscat__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wcscat(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcscat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::wcscat(NULL, arg2);
}

void test__std__wcscat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::wcscat(arg1, NULL);
}

void test__std__wcscat__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcscat(arg1, x);
}

void test__wcrtomb__noreturn() {
  int x = 1;
  if (cond) { x=100; wcrtomb(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcrtomb__leakignore() {
  char *p = malloc(10); *p=0;
  wcrtomb(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcrtomb__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcrtomb(arg1, x, arg3);
}

void test__std__wcrtomb__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wcrtomb(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcrtomb__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wcrtomb(arg1, x, arg3);
}

void test__strchr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = strchr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strchr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  strchr(arg1, arg2);
}

void test__strchr__leakignore() {
  char *p = malloc(10); *p=0;
  result = strchr(p, arg2);
  // cppcheck-suppress memleak
}

void test__strchr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = strchr(NULL, arg2);
}

void test__strchr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strchr(x, arg2);
}

void test__strchr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = strchr(arg1, x);
}

void test__std__strchr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::strchr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strchr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::strchr(arg1, arg2);
}

void test__std__strchr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strchr(NULL, arg2);
}

void test__std__strchr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strchr(x, arg2);
}

void test__std__strchr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::strchr(arg1, x);
}

void test__wcschr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcschr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcschr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcschr(arg1, arg2);
}

void test__wcschr__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcschr(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcschr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcschr(NULL, arg2);
}

void test__wcschr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcschr(x, arg2);
}

void test__wcschr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = wcschr(arg1, x);
}

void test__std__wcschr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcschr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcschr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcschr(arg1, arg2);
}

void test__std__wcschr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcschr(NULL, arg2);
}

void test__std__wcschr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcschr(x, arg2);
}

void test__std__wcschr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wcschr(arg1, x);
}

void test__strcmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = strcmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strcmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  strcmp(arg1, arg2);
}

void test__strcmp__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((strcmp(arg1, arg2) > 10) || (strcmp(arg1, arg2) < 100)) {}
}

void test__strcmp__leakignore() {
  char *p = malloc(10); *p=0;
  result = strcmp(p, arg2);
  // cppcheck-suppress memleak
}

void test__strcmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = strcmp(NULL, arg2);
}

void test__strcmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strcmp(x, arg2);
}

void test__strcmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = strcmp(arg1, NULL);
}

void test__strcmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strcmp(arg1, x);
}

void test__std__strcmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::strcmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strcmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::strcmp(arg1, arg2);
}

void test__std__strcmp__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::strcmp(arg1, arg2) > 10) || (std::strcmp(arg1, arg2) < 100)) {}
}

void test__std__strcmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strcmp(NULL, arg2);
}

void test__std__strcmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strcmp(x, arg2);
}

void test__std__strcmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strcmp(arg1, NULL);
}

void test__std__strcmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strcmp(arg1, x);
}

void test__wcscmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcscmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcscmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcscmp(arg1, arg2);
}

void test__wcscmp__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((wcscmp(arg1, arg2) > 10) || (wcscmp(arg1, arg2) < 100)) {}
}

void test__wcscmp__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcscmp(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcscmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcscmp(NULL, arg2);
}

void test__wcscmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcscmp(x, arg2);
}

void test__wcscmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = wcscmp(arg1, NULL);
}

void test__wcscmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcscmp(arg1, x);
}

void test__std__wcscmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcscmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcscmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcscmp(arg1, arg2);
}

void test__std__wcscmp__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::wcscmp(arg1, arg2) > 10) || (std::wcscmp(arg1, arg2) < 100)) {}
}

void test__std__wcscmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcscmp(NULL, arg2);
}

void test__std__wcscmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcscmp(x, arg2);
}

void test__std__wcscmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcscmp(arg1, NULL);
}

void test__std__wcscmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcscmp(arg1, x);
}

void test__strcpy__noreturn() {
  int x = 1;
  if (cond) { x=100; strcpy(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strcpy__leakignore() {
  char *p = malloc(10); *p=0;
  strcpy(p, arg2);
  // cppcheck-suppress memleak
}

void test__strcpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strcpy(NULL, arg2);
}

void test__strcpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  strcpy(arg1, NULL);
}

void test__strcpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strcpy(arg1, x);
}

void test__std__strcpy__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strcpy(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strcpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::strcpy(NULL, arg2);
}

void test__std__strcpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::strcpy(arg1, NULL);
}

void test__std__strcpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strcpy(arg1, x);
}

void test__wcscpy__noreturn() {
  int x = 1;
  if (cond) { x=100; wcscpy(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcscpy__leakignore() {
  char *p = malloc(10); *p=0;
  wcscpy(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcscpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wcscpy(NULL, arg2);
}

void test__wcscpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wcscpy(arg1, NULL);
}

void test__wcscpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcscpy(arg1, x);
}

void test__std__wcscpy__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wcscpy(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcscpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::wcscpy(NULL, arg2);
}

void test__std__wcscpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::wcscpy(arg1, NULL);
}

void test__std__wcscpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcscpy(arg1, x);
}

void test__strftime__noreturn() {
  int x = 1;
  if (cond) { x=100; strftime(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strftime__leakignore() {
  char *p = malloc(10); *p=0;
  strftime(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__strftime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strftime(NULL, arg2, arg3, arg4);
}

void test__strftime__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strftime(arg1, x, arg3, arg4);
}

void test__strftime__arg3__notnull() {
  // cppcheck-suppress nullPointer
  strftime(arg1, arg2, NULL, arg4);
}

void test__strftime__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strftime(arg1, arg2, x, arg4);
}

void test__strftime__arg4__notnull() {
  // cppcheck-suppress nullPointer
  strftime(arg1, arg2, arg3, NULL);
}

void test__strftime__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strftime(arg1, arg2, arg3, x);
}

void test__std__strftime__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strftime(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strftime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::strftime(NULL, arg2, arg3, arg4);
}

void test__std__strftime__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::strftime(arg1, x, arg3, arg4);
}

void test__std__strftime__arg3__notnull() {
  // cppcheck-suppress nullPointer
  std::strftime(arg1, arg2, NULL, arg4);
}

void test__std__strftime__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strftime(arg1, arg2, x, arg4);
}

void test__std__strftime__arg4__notnull() {
  // cppcheck-suppress nullPointer
  std::strftime(arg1, arg2, arg3, NULL);
}

void test__std__strftime__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strftime(arg1, arg2, arg3, x);
}

void test__strfxtime__noreturn() {
  int x = 1;
  if (cond) { x=100; strfxtime(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strfxtime__leakignore() {
  char *p = malloc(10); *p=0;
  strfxtime(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__strfxtime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strfxtime(NULL, arg2, arg3, arg4);
}

void test__strfxtime__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strfxtime(arg1, x, arg3, arg4);
}

void test__strfxtime__arg3__notnull() {
  // cppcheck-suppress nullPointer
  strfxtime(arg1, arg2, NULL, arg4);
}

void test__strfxtime__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strfxtime(arg1, arg2, x, arg4);
}

void test__strfxtime__arg4__notnull() {
  // cppcheck-suppress nullPointer
  strfxtime(arg1, arg2, arg3, NULL);
}

void test__strfxtime__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strfxtime(arg1, arg2, arg3, x);
}

void test__strlen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = strlen(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strlen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  strlen(arg1);
}

void test__strlen__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((strlen(arg1) > 10) || (strlen(arg1) < 100)) {}
}

void test__strlen__leakignore() {
  char *p = malloc(10); *p=0;
  result = strlen(p);
  // cppcheck-suppress memleak
}

void test__strlen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = strlen(NULL);
}

void test__strlen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strlen(x);
}

void test__std__strlen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::strlen(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strlen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::strlen(arg1);
}

void test__std__strlen__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::strlen(arg1) > 10) || (std::strlen(arg1) < 100)) {}
}

void test__std__strlen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strlen(NULL);
}

void test__std__strlen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strlen(x);
}

void test__wcslen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcslen(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcslen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcslen(arg1);
}

void test__wcslen__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((wcslen(arg1) > 10) || (wcslen(arg1) < 100)) {}
}

void test__wcslen__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcslen(p);
  // cppcheck-suppress memleak
}

void test__wcslen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcslen(NULL);
}

void test__wcslen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcslen(x);
}

void test__std__wcslen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcslen(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcslen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcslen(arg1);
}

void test__std__wcslen__pure(int arg1) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::wcslen(arg1) > 10) || (std::wcslen(arg1) < 100)) {}
}

void test__std__wcslen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcslen(NULL);
}

void test__std__wcslen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcslen(x);
}

void test__strncpy__noreturn() {
  int x = 1;
  if (cond) { x=100; strncpy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strncpy__leakignore() {
  char *p = malloc(10); *p=0;
  strncpy(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__strncpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strncpy(NULL, arg2, arg3);
}

void test__strncpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  strncpy(arg1, NULL, arg3);
}

void test__strncpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strncpy(arg1, x, arg3);
}

void test__strncpy__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  strncpy(arg1, arg2, !x);
}

void test__strncpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strncpy(arg1, arg2, x);
}

void test__std__strncpy__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strncpy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strncpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::strncpy(NULL, arg2, arg3);
}

void test__std__strncpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::strncpy(arg1, NULL, arg3);
}

void test__std__strncpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strncpy(arg1, x, arg3);
}

void test__std__strncpy__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::strncpy(arg1, arg2, !x);
}

void test__std__strncpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::strncpy(arg1, arg2, x);
}

void test__strpbrk__noreturn() {
  int x = 1;
  if (cond) { x=100; result = strpbrk(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strpbrk__useretval() {
  // cppcheck-suppress ignoredReturnValue
  strpbrk(arg1, arg2);
}

void test__strpbrk__leakignore() {
  char *p = malloc(10); *p=0;
  result = strpbrk(p, arg2);
  // cppcheck-suppress memleak
}

void test__strpbrk__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = strpbrk(NULL, arg2);
}

void test__strpbrk__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strpbrk(x, arg2);
}

void test__strpbrk__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = strpbrk(arg1, NULL);
}

void test__strpbrk__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strpbrk(arg1, x);
}

void test__std__strpbrk__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::strpbrk(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strpbrk__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::strpbrk(arg1, arg2);
}

void test__std__strpbrk__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strpbrk(NULL, arg2);
}

void test__std__strpbrk__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strpbrk(x, arg2);
}

void test__std__strpbrk__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strpbrk(arg1, NULL);
}

void test__std__strpbrk__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strpbrk(arg1, x);
}

void test__strncat__noreturn() {
  int x = 1;
  if (cond) { x=100; strncat(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strncat__leakignore() {
  char *p = malloc(10); *p=0;
  strncat(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__strncat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strncat(NULL, arg2, arg3);
}

void test__strncat__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strncat(x, arg2, arg3);
}

void test__strncat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  strncat(arg1, NULL, arg3);
}

void test__strncat__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strncat(arg1, x, arg3);
}

void test__strncat__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  strncat(arg1, arg2, !x);
}

void test__strncat__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strncat(arg1, arg2, x);
}

void test__std__strncat__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strncat(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strncat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::strncat(NULL, arg2, arg3);
}

void test__std__strncat__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strncat(x, arg2, arg3);
}

void test__std__strncat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::strncat(arg1, NULL, arg3);
}

void test__std__strncat__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strncat(arg1, x, arg3);
}

void test__std__strncat__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::strncat(arg1, arg2, !x);
}

void test__std__strncat__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::strncat(arg1, arg2, x);
}

void test__wcsncat__noreturn() {
  int x = 1;
  if (cond) { x=100; wcsncat(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcsncat__leakignore() {
  char *p = malloc(10); *p=0;
  wcsncat(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcsncat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wcsncat(NULL, arg2, arg3);
}

void test__wcsncat__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcsncat(x, arg2, arg3);
}

void test__wcsncat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wcsncat(arg1, NULL, arg3);
}

void test__wcsncat__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcsncat(arg1, x, arg3);
}

void test__wcsncat__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  wcsncat(arg1, arg2, !x);
}

void test__wcsncat__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcsncat(arg1, arg2, x);
}

void test__std__wcsncat__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wcsncat(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcsncat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::wcsncat(NULL, arg2, arg3);
}

void test__std__wcsncat__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcsncat(x, arg2, arg3);
}

void test__std__wcsncat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::wcsncat(arg1, NULL, arg3);
}

void test__std__wcsncat__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcsncat(arg1, x, arg3);
}

void test__std__wcsncat__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::wcsncat(arg1, arg2, !x);
}

void test__std__wcsncat__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wcsncat(arg1, arg2, x);
}

void test__strncmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = strncmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strncmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  strncmp(arg1, arg2, arg3);
}

void test__strncmp__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((strncmp(arg1, arg2, arg3) > 10) || (strncmp(arg1, arg2, arg3) < 100)) {}
}

void test__strncmp__leakignore() {
  char *p = malloc(10); *p=0;
  result = strncmp(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__strncmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = strncmp(NULL, arg2, arg3);
}

void test__strncmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strncmp(x, arg2, arg3);
}

void test__strncmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = strncmp(arg1, NULL, arg3);
}

void test__strncmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strncmp(arg1, x, arg3);
}

void test__strncmp__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = strncmp(arg1, arg2, !x);
}

void test__strncmp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = strncmp(arg1, arg2, x);
}

void test__std__strncmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::strncmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strncmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::strncmp(arg1, arg2, arg3);
}

void test__std__strncmp__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::strncmp(arg1, arg2, arg3) > 10) || (std::strncmp(arg1, arg2, arg3) < 100)) {}
}

void test__std__strncmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strncmp(NULL, arg2, arg3);
}

void test__std__strncmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strncmp(x, arg2, arg3);
}

void test__std__strncmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strncmp(arg1, NULL, arg3);
}

void test__std__strncmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strncmp(arg1, x, arg3);
}

void test__std__strncmp__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = std::strncmp(arg1, arg2, !x);
}

void test__std__strncmp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::strncmp(arg1, arg2, x);
}

void test__wcsncmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcsncmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcsncmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcsncmp(arg1, arg2, arg3);
}

void test__wcsncmp__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((wcsncmp(arg1, arg2, arg3) > 10) || (wcsncmp(arg1, arg2, arg3) < 100)) {}
}

void test__wcsncmp__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcsncmp(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcsncmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcsncmp(NULL, arg2, arg3);
}

void test__wcsncmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcsncmp(x, arg2, arg3);
}

void test__wcsncmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = wcsncmp(arg1, NULL, arg3);
}

void test__wcsncmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcsncmp(arg1, x, arg3);
}

void test__wcsncmp__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = wcsncmp(arg1, arg2, !x);
}

void test__wcsncmp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = wcsncmp(arg1, arg2, x);
}

void test__std__wcsncmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcsncmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcsncmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcsncmp(arg1, arg2, arg3);
}

void test__std__wcsncmp__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::wcsncmp(arg1, arg2, arg3) > 10) || (std::wcsncmp(arg1, arg2, arg3) < 100)) {}
}

void test__std__wcsncmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcsncmp(NULL, arg2, arg3);
}

void test__std__wcsncmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcsncmp(x, arg2, arg3);
}

void test__std__wcsncmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcsncmp(arg1, NULL, arg3);
}

void test__std__wcsncmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcsncmp(arg1, x, arg3);
}

void test__std__wcsncmp__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = std::wcsncmp(arg1, arg2, !x);
}

void test__std__wcsncmp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wcsncmp(arg1, arg2, x);
}

void test__strstr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = strstr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strstr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  strstr(arg1, arg2);
}

void test__strstr__leakignore() {
  char *p = malloc(10); *p=0;
  result = strstr(p, arg2);
  // cppcheck-suppress memleak
}

void test__strstr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = strstr(NULL, arg2);
}

void test__strstr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strstr(x, arg2);
}

void test__strstr__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = strstr(arg1, NULL);
}

void test__strstr__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strstr(arg1, x);
}

void test__std__strstr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::strstr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strstr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::strstr(arg1, arg2);
}

void test__std__strstr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strstr(NULL, arg2);
}

void test__std__strstr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strstr(x, arg2);
}

void test__std__strstr__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strstr(arg1, NULL);
}

void test__std__strstr__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strstr(arg1, x);
}

void test__wcsstr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcsstr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcsstr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcsstr(arg1, arg2);
}

void test__wcsstr__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((wcsstr(arg1, arg2) > 10) || (wcsstr(arg1, arg2) < 100)) {}
}

void test__wcsstr__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcsstr(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcsstr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcsstr(NULL, arg2);
}

void test__wcsstr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcsstr(x, arg2);
}

void test__wcsstr__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = wcsstr(arg1, NULL);
}

void test__wcsstr__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcsstr(arg1, x);
}

void test__std__wcsstr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcsstr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcsstr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcsstr(arg1, arg2);
}

void test__std__wcsstr__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::wcsstr(arg1, arg2) > 10) || (std::wcsstr(arg1, arg2) < 100)) {}
}

void test__std__wcsstr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcsstr(NULL, arg2);
}

void test__std__wcsstr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcsstr(x, arg2);
}

void test__std__wcsstr__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcsstr(arg1, NULL);
}

void test__std__wcsstr__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcsstr(arg1, x);
}

void test__strspn__noreturn() {
  int x = 1;
  if (cond) { x=100; result = strspn(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strspn__useretval() {
  // cppcheck-suppress ignoredReturnValue
  strspn(arg1, arg2);
}

void test__strspn__leakignore() {
  char *p = malloc(10); *p=0;
  result = strspn(p, arg2);
  // cppcheck-suppress memleak
}

void test__strspn__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = strspn(NULL, arg2);
}

void test__strspn__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strspn(x, arg2);
}

void test__strspn__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = strspn(arg1, NULL);
}

void test__strspn__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strspn(arg1, x);
}

void test__std__strspn__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::strspn(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strspn__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::strspn(arg1, arg2);
}

void test__std__strspn__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strspn(NULL, arg2);
}

void test__std__strspn__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strspn(x, arg2);
}

void test__std__strspn__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strspn(arg1, NULL);
}

void test__std__strspn__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strspn(arg1, x);
}

void test__strxfrm__noreturn() {
  int x = 1;
  if (cond) { x=100; strxfrm(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strxfrm__leakignore() {
  char *p = malloc(10); *p=0;
  strxfrm(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__strxfrm__arg2__notnull() {
  // cppcheck-suppress nullPointer
  strxfrm(arg1, NULL, arg3);
}

void test__strxfrm__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strxfrm(arg1, x, arg3);
}

void test__strxfrm__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strxfrm(arg1, arg2, x);
}

void test__std__strxfrm__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strxfrm(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strxfrm__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::strxfrm(arg1, NULL, arg3);
}

void test__std__strxfrm__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strxfrm(arg1, x, arg3);
}

void test__std__strxfrm__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::strxfrm(arg1, arg2, x);
}

void test__wcsxfrm__noreturn() {
  int x = 1;
  if (cond) { x=100; wcsxfrm(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcsxfrm__leakignore() {
  char *p = malloc(10); *p=0;
  wcsxfrm(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcsxfrm__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wcsxfrm(arg1, NULL, arg3);
}

void test__wcsxfrm__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcsxfrm(arg1, x, arg3);
}

void test__wcsxfrm__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcsxfrm(arg1, arg2, x);
}

void test__std__wcsxfrm__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wcsxfrm(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcsxfrm__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::wcsxfrm(arg1, NULL, arg3);
}

void test__std__wcsxfrm__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcsxfrm(arg1, x, arg3);
}

void test__std__wcsxfrm__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wcsxfrm(arg1, arg2, x);
}

void test__wcsspn__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcsspn(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcsspn__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcsspn(arg1, arg2);
}

void test__wcsspn__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((wcsspn(arg1, arg2) > 10) || (wcsspn(arg1, arg2) < 100)) {}
}

void test__wcsspn__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcsspn(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcsspn__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcsspn(NULL, arg2);
}

void test__wcsspn__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcsspn(x, arg2);
}

void test__wcsspn__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = wcsspn(arg1, NULL);
}

void test__wcsspn__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcsspn(arg1, x);
}

void test__std__wcsspn__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcsspn(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcsspn__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcsspn(arg1, arg2);
}

void test__std__wcsspn__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::wcsspn(arg1, arg2) > 10) || (std::wcsspn(arg1, arg2) < 100)) {}
}

void test__std__wcsspn__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcsspn(NULL, arg2);
}

void test__std__wcsspn__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcsspn(x, arg2);
}

void test__std__wcsspn__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcsspn(arg1, NULL);
}

void test__std__wcsspn__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcsspn(arg1, x);
}

void test__localeconv__noreturn() {
  int x = 1;
  if (cond) { x=100; result = localeconv(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__localeconv__useretval() {
  // cppcheck-suppress ignoredReturnValue
  localeconv();
}

void test__localeconv__leakignore() {
  char *p = malloc(10); *p=0;
  result = localeconv();
  // cppcheck-suppress memleak
}

void test__std__localeconv__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::localeconv(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__localeconv__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::localeconv();
}

void test__std__locale__global__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::locale::global(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__locale__global__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::locale::global(arg1);
}

void test__std__locale__global__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::locale::global(x);
}

void test__std__locale__classic__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::locale::classic(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__locale__classic__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::locale::classic();
}

void test__setlocale__noreturn() {
  int x = 1;
  if (cond) { x=100; setlocale(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setlocale__leakignore() {
  char *p = malloc(10); *p=0;
  setlocale(p, arg2);
  // cppcheck-suppress memleak
}

void test__setlocale__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setlocale(x, arg2);
}

void test__setlocale__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setlocale(arg1, x);
}

void test__std__setlocale__noreturn() {
  int x = 1;
  if (cond) { x=100; std::setlocale(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__setlocale__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::setlocale(x, arg2);
}

void test__std__setlocale__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::setlocale(arg1, x);
}

void test__strerror__noreturn() {
  int x = 1;
  if (cond) { x=100; result = strerror(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strerror__useretval() {
  // cppcheck-suppress ignoredReturnValue
  strerror(arg1);
}

void test__strerror__leakignore() {
  char *p = malloc(10); *p=0;
  result = strerror(p);
  // cppcheck-suppress memleak
}

void test__strerror__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = strerror(x);
}

void test__std__strerror__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::strerror(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strerror__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::strerror(arg1);
}

void test__std__strerror__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::strerror(x);
}

void test__strcspn__noreturn() {
  int x = 1;
  if (cond) { x=100; result = strcspn(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strcspn__useretval() {
  // cppcheck-suppress ignoredReturnValue
  strcspn(arg1, arg2);
}

void test__strcspn__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((strcspn(arg1, arg2) > 10) || (strcspn(arg1, arg2) < 100)) {}
}

void test__strcspn__leakignore() {
  char *p = malloc(10); *p=0;
  result = strcspn(p, arg2);
  // cppcheck-suppress memleak
}

void test__strcspn__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = strcspn(NULL, arg2);
}

void test__strcspn__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strcspn(x, arg2);
}

void test__strcspn__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = strcspn(arg1, NULL);
}

void test__strcspn__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strcspn(arg1, x);
}

void test__std__strcspn__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::strcspn(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strcspn__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::strcspn(arg1, arg2);
}

void test__std__strcspn__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::strcspn(arg1, arg2) > 10) || (std::strcspn(arg1, arg2) < 100)) {}
}

void test__std__strcspn__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strcspn(NULL, arg2);
}

void test__std__strcspn__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strcspn(x, arg2);
}

void test__std__strcspn__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strcspn(arg1, NULL);
}

void test__std__strcspn__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strcspn(arg1, x);
}

void test__wcscspn__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcscspn(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcscspn__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcscspn(arg1, arg2);
}

void test__wcscspn__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((wcscspn(arg1, arg2) > 10) || (wcscspn(arg1, arg2) < 100)) {}
}

void test__wcscspn__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcscspn(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcscspn__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcscspn(NULL, arg2);
}

void test__wcscspn__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcscspn(x, arg2);
}

void test__wcscspn__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = wcscspn(arg1, NULL);
}

void test__wcscspn__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcscspn(arg1, x);
}

void test__std__wcscspn__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcscspn(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcscspn__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcscspn(arg1, arg2);
}

void test__std__wcscspn__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::wcscspn(arg1, arg2) > 10) || (std::wcscspn(arg1, arg2) < 100)) {}
}

void test__std__wcscspn__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcscspn(NULL, arg2);
}

void test__std__wcscspn__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcscspn(x, arg2);
}

void test__std__wcscspn__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcscspn(arg1, NULL);
}

void test__std__wcscspn__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcscspn(arg1, x);
}

void test__wcspbrk__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcspbrk(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcspbrk__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcspbrk(arg1, arg2);
}

void test__wcspbrk__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcspbrk(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcspbrk__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcspbrk(NULL, arg2);
}

void test__wcspbrk__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcspbrk(x, arg2);
}

void test__wcspbrk__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = wcspbrk(arg1, x);
}

void test__std__wcspbrk__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcspbrk(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcspbrk__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcspbrk(arg1, arg2);
}

void test__std__wcspbrk__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcspbrk(NULL, arg2);
}

void test__std__wcspbrk__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcspbrk(x, arg2);
}

void test__std__wcspbrk__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wcspbrk(arg1, x);
}

void test__wcsncpy__noreturn() {
  int x = 1;
  if (cond) { x=100; wcsncpy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcsncpy__leakignore() {
  char *p = malloc(10); *p=0;
  wcsncpy(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcsncpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wcsncpy(NULL, arg2, arg3);
}

void test__wcsncpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wcsncpy(arg1, NULL, arg3);
}

void test__wcsncpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcsncpy(arg1, x, arg3);
}

void test__wcsncpy__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  wcsncpy(arg1, arg2, !x);
}

void test__wcsncpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcsncpy(arg1, arg2, x);
}

void test__std__wcsncpy__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wcsncpy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcsncpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::wcsncpy(NULL, arg2, arg3);
}

void test__std__wcsncpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::wcsncpy(arg1, NULL, arg3);
}

void test__std__wcsncpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcsncpy(arg1, x, arg3);
}

void test__std__wcsncpy__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  std::wcsncpy(arg1, arg2, !x);
}

void test__std__wcsncpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wcsncpy(arg1, arg2, x);
}

void test__strcoll__noreturn() {
  int x = 1;
  if (cond) { x=100; result = strcoll(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strcoll__useretval() {
  // cppcheck-suppress ignoredReturnValue
  strcoll(arg1, arg2);
}

void test__strcoll__leakignore() {
  char *p = malloc(10); *p=0;
  result = strcoll(p, arg2);
  // cppcheck-suppress memleak
}

void test__strcoll__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = strcoll(NULL, arg2);
}

void test__strcoll__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strcoll(x, arg2);
}

void test__strcoll__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = strcoll(arg1, NULL);
}

void test__strcoll__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strcoll(arg1, x);
}

void test__std__strcoll__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::strcoll(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strcoll__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::strcoll(arg1, arg2);
}

void test__std__strcoll__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strcoll(NULL, arg2);
}

void test__std__strcoll__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strcoll(x, arg2);
}

void test__std__strcoll__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strcoll(arg1, NULL);
}

void test__std__strcoll__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strcoll(arg1, x);
}

void test__wcscoll__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcscoll(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcscoll__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcscoll(arg1, arg2);
}

void test__wcscoll__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcscoll(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcscoll__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcscoll(NULL, arg2);
}

void test__wcscoll__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcscoll(x, arg2);
}

void test__wcscoll__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = wcscoll(arg1, NULL);
}

void test__wcscoll__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcscoll(arg1, x);
}

void test__std__wcscoll__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcscoll(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcscoll__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcscoll(arg1, arg2);
}

void test__std__wcscoll__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcscoll(NULL, arg2);
}

void test__std__wcscoll__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcscoll(x, arg2);
}

void test__std__wcscoll__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcscoll(arg1, NULL);
}

void test__std__wcscoll__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcscoll(arg1, x);
}

void test__strrchr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = strrchr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strrchr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  strrchr(arg1, arg2);
}

void test__strrchr__leakignore() {
  char *p = malloc(10); *p=0;
  result = strrchr(p, arg2);
  // cppcheck-suppress memleak
}

void test__strrchr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = strrchr(NULL, arg2);
}

void test__strrchr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strrchr(x, arg2);
}

void test__strrchr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = strrchr(arg1, x);
}

void test__std__strrchr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::strrchr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strrchr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::strrchr(arg1, arg2);
}

void test__std__strrchr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::strrchr(NULL, arg2);
}

void test__std__strrchr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::strrchr(x, arg2);
}

void test__std__strrchr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::strrchr(arg1, x);
}

void test__wcsrchr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcsrchr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcsrchr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcsrchr(arg1, arg2);
}

void test__wcsrchr__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcsrchr(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcsrchr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcsrchr(NULL, arg2);
}

void test__wcsrchr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcsrchr(x, arg2);
}

void test__wcsrchr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = wcsrchr(arg1, x);
}

void test__std__wcsrchr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcsrchr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcsrchr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcsrchr(arg1, arg2);
}

void test__std__wcsrchr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcsrchr(NULL, arg2);
}

void test__std__wcsrchr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcsrchr(x, arg2);
}

void test__std__wcsrchr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wcsrchr(arg1, x);
}

void test__wcsrtombs__noreturn() {
  int x = 1;
  if (cond) { x=100; wcsrtombs(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcsrtombs__leakignore() {
  char *p = malloc(10); *p=0;
  wcsrtombs(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__wcsrtombs__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wcsrtombs(arg1, NULL, arg3, arg4);
}

void test__wcsrtombs__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcsrtombs(arg1, x, arg3, arg4);
}

void test__wcsrtombs__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcsrtombs(arg1, arg2, x, arg4);
}

void test__wcsrtombs__arg4__notnull() {
  // cppcheck-suppress nullPointer
  wcsrtombs(arg1, arg2, arg3, NULL);
}

void test__std__wcsrtombs__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wcsrtombs(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcsrtombs__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::wcsrtombs(arg1, NULL, arg3, arg4);
}

void test__std__wcsrtombs__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcsrtombs(arg1, x, arg3, arg4);
}

void test__std__wcsrtombs__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wcsrtombs(arg1, arg2, x, arg4);
}

void test__std__wcsrtombs__arg4__notnull() {
  // cppcheck-suppress nullPointer
  std::wcsrtombs(arg1, arg2, arg3, NULL);
}

void test__strtok__noreturn() {
  int x = 1;
  if (cond) { x=100; strtok(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strtok__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((strtok(arg1, arg2) > 10) || (strtok(arg1, arg2) < 100)) {}
}

void test__strtok__leakignore() {
  char *p = malloc(10); *p=0;
  strtok(p, arg2);
  // cppcheck-suppress memleak
}

void test__strtok__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strtok(x, arg2);
}

void test__strtok__arg2__notnull() {
  // cppcheck-suppress nullPointer
  strtok(arg1, NULL);
}

void test__strtok__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strtok(arg1, x);
}

void test__std__strtok__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strtok(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strtok__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((std::strtok(arg1, arg2) > 10) || (std::strtok(arg1, arg2) < 100)) {}
}

void test__std__strtok__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::strtok(x, arg2);
}

void test__std__strtok__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::strtok(arg1, NULL);
}

void test__std__strtok__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strtok(arg1, x);
}

void test__strtof__noreturn() {
  int x = 1;
  if (cond) { x=100; strtof(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strtof__leakignore() {
  char *p = malloc(10); *p=0;
  strtof(p, arg2);
  // cppcheck-suppress memleak
}

void test__strtof__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strtof(NULL, arg2);
}

void test__strtof__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strtof(x, arg2);
}

void test__std__strtof__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strtof(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strtof__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::strtof(NULL, arg2);
}

void test__std__strtof__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strtof(x, arg2);
}

void test__strtod__noreturn() {
  int x = 1;
  if (cond) { x=100; strtod(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strtod__leakignore() {
  char *p = malloc(10); *p=0;
  strtod(p, arg2);
  // cppcheck-suppress memleak
}

void test__strtod__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strtod(NULL, arg2);
}

void test__strtod__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strtod(x, arg2);
}

void test__std__strtod__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strtod(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strtod__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::strtod(NULL, arg2);
}

void test__std__strtod__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strtod(x, arg2);
}

void test__strtold__noreturn() {
  int x = 1;
  if (cond) { x=100; strtold(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strtold__leakignore() {
  char *p = malloc(10); *p=0;
  strtold(p, arg2);
  // cppcheck-suppress memleak
}

void test__strtold__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strtold(NULL, arg2);
}

void test__strtold__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strtold(x, arg2);
}

void test__std__strtold__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strtold(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strtold__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::strtold(NULL, arg2);
}

void test__std__strtold__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strtold(x, arg2);
}

void test__strtol__noreturn() {
  int x = 1;
  if (cond) { x=100; strtol(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strtol__leakignore() {
  char *p = malloc(10); *p=0;
  strtol(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__strtol__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strtol(NULL, arg2, arg3);
}

void test__strtol__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strtol(x, arg2, arg3);
}

void test__strtol__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strtol(arg1, arg2, x);
}

void test__std__strtol__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strtol(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strtol__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::strtol(NULL, arg2, arg3);
}

void test__std__strtol__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strtol(x, arg2, arg3);
}

void test__std__strtol__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::strtol(arg1, arg2, x);
}

void test__strtoul__noreturn() {
  int x = 1;
  if (cond) { x=100; strtoul(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strtoul__leakignore() {
  char *p = malloc(10); *p=0;
  strtoul(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__strtoul__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strtoul(NULL, arg2, arg3);
}

void test__strtoul__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strtoul(x, arg2, arg3);
}

void test__strtoul__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strtoul(arg1, arg2, x);
}

void test__std__strtoul__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strtoul(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strtoul__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::strtoul(NULL, arg2, arg3);
}

void test__std__strtoul__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strtoul(x, arg2, arg3);
}

void test__std__strtoul__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::strtoul(arg1, arg2, x);
}

void test__strtoll__noreturn() {
  int x = 1;
  if (cond) { x=100; strtoll(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strtoll__leakignore() {
  char *p = malloc(10); *p=0;
  strtoll(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__strtoll__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strtoll(NULL, arg2, arg3);
}

void test__strtoll__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strtoll(x, arg2, arg3);
}

void test__strtoll__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strtoll(arg1, arg2, x);
}

void test__std__strtoll__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strtoll(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strtoll__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::strtoll(NULL, arg2, arg3);
}

void test__std__strtoll__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strtoll(x, arg2, arg3);
}

void test__std__strtoll__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::strtoll(arg1, arg2, x);
}

void test__strtoull__noreturn() {
  int x = 1;
  if (cond) { x=100; strtoull(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strtoull__leakignore() {
  char *p = malloc(10); *p=0;
  strtoull(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__strtoull__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strtoull(NULL, arg2, arg3);
}

void test__strtoull__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strtoull(x, arg2, arg3);
}

void test__strtoull__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strtoull(arg1, arg2, x);
}

void test__std__strtoull__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strtoull(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strtoull__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::strtoull(NULL, arg2, arg3);
}

void test__std__strtoull__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strtoull(x, arg2, arg3);
}

void test__std__strtoull__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::strtoull(arg1, arg2, x);
}

void test__strtoimax__noreturn() {
  int x = 1;
  if (cond) { x=100; strtoimax(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strtoimax__leakignore() {
  char *p = malloc(10); *p=0;
  strtoimax(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__strtoimax__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strtoimax(NULL, arg2, arg3);
}

void test__strtoimax__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strtoimax(x, arg2, arg3);
}

void test__strtoimax__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strtoimax(arg1, arg2, x);
}

void test__std__strtoimax__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strtoimax(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strtoimax__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::strtoimax(NULL, arg2, arg3);
}

void test__std__strtoimax__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strtoimax(x, arg2, arg3);
}

void test__std__strtoimax__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::strtoimax(arg1, arg2, x);
}

void test__strtoumax__noreturn() {
  int x = 1;
  if (cond) { x=100; strtoumax(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strtoumax__leakignore() {
  char *p = malloc(10); *p=0;
  strtoumax(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__strtoumax__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strtoumax(NULL, arg2, arg3);
}

void test__strtoumax__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strtoumax(x, arg2, arg3);
}

void test__strtoumax__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strtoumax(arg1, arg2, x);
}

void test__std__strtoumax__noreturn() {
  int x = 1;
  if (cond) { x=100; std::strtoumax(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__strtoumax__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::strtoumax(NULL, arg2, arg3);
}

void test__std__strtoumax__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::strtoumax(x, arg2, arg3);
}

void test__std__strtoumax__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::strtoumax(arg1, arg2, x);
}

void test__time__noreturn() {
  int x = 1;
  if (cond) { x=100; time(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__time__leakignore() {
  char *p = malloc(10); *p=0;
  time(p);
  // cppcheck-suppress memleak
}

void test__time__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  time(x);
}

void test__std__time__noreturn() {
  int x = 1;
  if (cond) { x=100; std::time(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__time__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::time(x);
}

void test__tmpnam__noreturn() {
  int x = 1;
  if (cond) { x=100; tmpnam(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tmpnam__leakignore() {
  char *p = malloc(10); *p=0;
  tmpnam(p);
  // cppcheck-suppress memleak
}

void test__tmpnam__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  tmpnam(x);
}

void test__std__tmpnam__noreturn() {
  int x = 1;
  if (cond) { x=100; std::tmpnam(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__tmpnam__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::tmpnam(x);
}

void test__tmpnam_s__noreturn() {
  int x = 1;
  if (cond) { x=100; tmpnam_s(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tmpnam_s__leakignore() {
  char *p = malloc(10); *p=0;
  tmpnam_s(p, arg2);
  // cppcheck-suppress memleak
}

void test__tmpnam_s__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  tmpnam_s(x, arg2);
}

void test__tmpnam_s__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  tmpnam_s(arg1, x);
}

void test__tmpfile__noreturn() {
  int x = 1;
  if (cond) { x=100; result = tmpfile(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tmpfile__useretval() {
  // cppcheck-suppress ignoredReturnValue
  tmpfile();
}

void test__tolower__noreturn() {
  int x = 1;
  if (cond) { x=100; result = tolower(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tolower__useretval() {
  // cppcheck-suppress ignoredReturnValue
  tolower(arg1);
}

void test__tolower__leakignore() {
  char *p = malloc(10); *p=0;
  result = tolower(p);
  // cppcheck-suppress memleak
}

void test__tolower__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = tolower(x);
}

void test__std__tolower__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::tolower(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__tolower__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::tolower(arg1);
}

void test__std__tolower__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::tolower(x);
}

void test__toupper__noreturn() {
  int x = 1;
  if (cond) { x=100; result = toupper(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__toupper__useretval() {
  // cppcheck-suppress ignoredReturnValue
  toupper(arg1);
}

void test__toupper__leakignore() {
  char *p = malloc(10); *p=0;
  result = toupper(p);
  // cppcheck-suppress memleak
}

void test__toupper__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = toupper(x);
}

void test__std__toupper__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::toupper(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__toupper__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::toupper(arg1);
}

void test__std__toupper__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::toupper(x);
}

void test__typeid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = typeid(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__typeid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  typeid(arg1);
}

void test__va_arg__noreturn() {
  int x = 1;
  if (cond) { x=100; va_arg(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__va_arg__leakignore() {
  char *p = malloc(10); *p=0;
  va_arg(p, arg2);
  // cppcheck-suppress memleak
}

void test__va_copy__noreturn() {
  int x = 1;
  if (cond) { x=100; va_copy(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__va_copy__leakignore() {
  char *p = malloc(10); *p=0;
  va_copy(p, arg2);
  // cppcheck-suppress memleak
}

void test__va_end__noreturn() {
  int x = 1;
  if (cond) { x=100; va_end(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__va_end__leakignore() {
  char *p = malloc(10); *p=0;
  va_end(p);
  // cppcheck-suppress memleak
}

void test__va_start__noreturn() {
  int x = 1;
  if (cond) { x=100; va_start(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__va_start__leakignore() {
  char *p = malloc(10); *p=0;
  va_start(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcstof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcstof(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcstof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcstof(arg1, arg2);
}

void test__wcstof__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcstof(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcstof__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcstof(NULL, arg2);
}

void test__wcstof__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcstof(x, arg2);
}

void test__std__wcstof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcstof(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcstof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcstof(arg1, arg2);
}

void test__std__wcstof__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcstof(NULL, arg2);
}

void test__std__wcstof__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcstof(x, arg2);
}

void test__wcstod__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcstod(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcstod__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcstod(arg1, arg2);
}

void test__wcstod__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcstod(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcstod__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcstod(NULL, arg2);
}

void test__wcstod__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcstod(x, arg2);
}

void test__std__wcstod__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcstod(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcstod__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcstod(arg1, arg2);
}

void test__std__wcstod__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcstod(NULL, arg2);
}

void test__std__wcstod__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcstod(x, arg2);
}

void test__wcstold__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcstold(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcstold__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcstold(arg1, arg2);
}

void test__wcstold__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcstold(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcstold__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcstold(NULL, arg2);
}

void test__wcstold__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcstold(x, arg2);
}

void test__std__wcstold__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcstold(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcstold__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcstold(arg1, arg2);
}

void test__std__wcstold__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcstold(NULL, arg2);
}

void test__std__wcstold__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcstold(x, arg2);
}

void test__stof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = stof(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__stof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  stof(arg1, arg2);
}

void test__stof__leakignore() {
  char *p = malloc(10); *p=0;
  result = stof(p, arg2);
  // cppcheck-suppress memleak
}

void test__stof__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stof(x, arg2);
}

void test__stof__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stof(arg1, x);
}

void test__std__stof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::stof(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::stof(arg1, arg2);
}

void test__std__stof__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stof(x, arg2);
}

void test__std__stof__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stof(arg1, x);
}

void test__stod__noreturn() {
  int x = 1;
  if (cond) { x=100; result = stod(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__stod__useretval() {
  // cppcheck-suppress ignoredReturnValue
  stod(arg1, arg2);
}

void test__stod__leakignore() {
  char *p = malloc(10); *p=0;
  result = stod(p, arg2);
  // cppcheck-suppress memleak
}

void test__stod__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stod(x, arg2);
}

void test__stod__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stod(arg1, x);
}

void test__std__stod__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::stod(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stod__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::stod(arg1, arg2);
}

void test__std__stod__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stod(x, arg2);
}

void test__std__stod__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stod(arg1, x);
}

void test__stold__noreturn() {
  int x = 1;
  if (cond) { x=100; result = stold(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__stold__useretval() {
  // cppcheck-suppress ignoredReturnValue
  stold(arg1, arg2);
}

void test__stold__leakignore() {
  char *p = malloc(10); *p=0;
  result = stold(p, arg2);
  // cppcheck-suppress memleak
}

void test__stold__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stold(x, arg2);
}

void test__stold__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stold(arg1, x);
}

void test__std__stold__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::stold(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stold__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::stold(arg1, arg2);
}

void test__std__stold__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stold(x, arg2);
}

void test__std__stold__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stold(arg1, x);
}

void test__stoi__noreturn() {
  int x = 1;
  if (cond) { x=100; result = stoi(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__stoi__useretval() {
  // cppcheck-suppress ignoredReturnValue
  stoi(arg1, arg2, arg3);
}

void test__stoi__leakignore() {
  char *p = malloc(10); *p=0;
  result = stoi(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__stoi__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stoi(x, arg2, arg3);
}

void test__stoi__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stoi(arg1, x, arg3);
}

void test__stoi__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stoi(arg1, arg2, x);
}

void test__std__stoi__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::stoi(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stoi__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::stoi(arg1, arg2, arg3);
}

void test__std__stoi__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stoi(x, arg2, arg3);
}

void test__std__stoi__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stoi(arg1, x, arg3);
}

void test__std__stoi__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stoi(arg1, arg2, x);
}

void test__stol__noreturn() {
  int x = 1;
  if (cond) { x=100; result = stol(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__stol__useretval() {
  // cppcheck-suppress ignoredReturnValue
  stol(arg1, arg2, arg3);
}

void test__stol__leakignore() {
  char *p = malloc(10); *p=0;
  result = stol(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__stol__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stol(x, arg2, arg3);
}

void test__stol__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stol(arg1, x, arg3);
}

void test__stol__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stol(arg1, arg2, x);
}

void test__std__stol__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::stol(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stol__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::stol(arg1, arg2, arg3);
}

void test__std__stol__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stol(x, arg2, arg3);
}

void test__std__stol__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stol(arg1, x, arg3);
}

void test__std__stol__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stol(arg1, arg2, x);
}

void test__stoll__noreturn() {
  int x = 1;
  if (cond) { x=100; result = stoll(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__stoll__useretval() {
  // cppcheck-suppress ignoredReturnValue
  stoll(arg1, arg2, arg3);
}

void test__stoll__leakignore() {
  char *p = malloc(10); *p=0;
  result = stoll(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__stoll__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stoll(x, arg2, arg3);
}

void test__stoll__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stoll(arg1, x, arg3);
}

void test__stoll__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stoll(arg1, arg2, x);
}

void test__std__stoll__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::stoll(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stoll__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::stoll(arg1, arg2, arg3);
}

void test__std__stoll__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stoll(x, arg2, arg3);
}

void test__std__stoll__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stoll(arg1, x, arg3);
}

void test__std__stoll__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stoll(arg1, arg2, x);
}

void test__stoul__noreturn() {
  int x = 1;
  if (cond) { x=100; result = stoul(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__stoul__useretval() {
  // cppcheck-suppress ignoredReturnValue
  stoul(arg1, arg2, arg3);
}

void test__stoul__leakignore() {
  char *p = malloc(10); *p=0;
  result = stoul(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__stoul__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stoul(x, arg2, arg3);
}

void test__stoul__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stoul(arg1, x, arg3);
}

void test__stoul__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stoul(arg1, arg2, x);
}

void test__std__stoul__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::stoul(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stoul__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::stoul(arg1, arg2, arg3);
}

void test__std__stoul__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stoul(x, arg2, arg3);
}

void test__std__stoul__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stoul(arg1, x, arg3);
}

void test__std__stoul__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stoul(arg1, arg2, x);
}

void test__stoull__noreturn() {
  int x = 1;
  if (cond) { x=100; result = stoull(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__stoull__useretval() {
  // cppcheck-suppress ignoredReturnValue
  stoull(arg1, arg2, arg3);
}

void test__stoull__leakignore() {
  char *p = malloc(10); *p=0;
  result = stoull(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__stoull__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stoull(x, arg2, arg3);
}

void test__stoull__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stoull(arg1, x, arg3);
}

void test__stoull__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = stoull(arg1, arg2, x);
}

void test__std__stoull__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::stoull(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stoull__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::stoull(arg1, arg2, arg3);
}

void test__std__stoull__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stoull(x, arg2, arg3);
}

void test__std__stoull__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stoull(arg1, x, arg3);
}

void test__std__stoull__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::stoull(arg1, arg2, x);
}

void test__std__to_string__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::to_string(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__to_string__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::to_string(arg1);
}

void test__std__to_string__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::to_string(x);
}

void test__std__string__resize__noreturn() {
  int x = 1;
  if (cond) { x=100; std::string::resize(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__resize__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::string::resize(x, arg2);
}

void test__std__string__resize__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::string::resize(arg1, x);
}

void test__std__wstring__resize__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wstring::resize(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wstring__resize__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wstring::resize(x, arg2);
}

void test__std__wstring__resize__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wstring::resize(arg1, x);
}

void test__std__to_wstring__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::to_wstring(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__to_wstring__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::to_wstring(arg1);
}

void test__std__to_wstring__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::to_wstring(x);
}

void test__mbrtowc__noreturn() {
  int x = 1;
  if (cond) { x=100; mbrtowc(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mbrtowc__leakignore() {
  char *p = malloc(10); *p=0;
  mbrtowc(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__mbrtowc__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mbrtowc(arg1, x, arg3, arg4);
}

void test__mbrtowc__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mbrtowc(arg1, arg2, x, arg4);
}

void test__mbrtowc__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mbrtowc(arg1, arg2, arg3, x);
}

void test__std__mbrtowc__noreturn() {
  int x = 1;
  if (cond) { x=100; std::mbrtowc(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__mbrtowc__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::mbrtowc(arg1, x, arg3, arg4);
}

void test__std__mbrtowc__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::mbrtowc(arg1, arg2, x, arg4);
}

void test__std__mbrtowc__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::mbrtowc(arg1, arg2, arg3, x);
}

void test__wcstok__noreturn() {
  int x = 1;
  if (cond) { x=100; wcstok(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcstok__leakignore() {
  char *p = malloc(10); *p=0;
  wcstok(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcstok__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcstok(x, arg2, arg3);
}

void test__wcstok__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wcstok(arg1, NULL, arg3);
}

void test__wcstok__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcstok(arg1, x, arg3);
}

void test__wcstok__arg3__notnull() {
  // cppcheck-suppress nullPointer
  wcstok(arg1, arg2, NULL);
}

void test__std__wcstok__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wcstok(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcstok__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wcstok(x, arg2, arg3);
}

void test__std__wcstok__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::wcstok(arg1, NULL, arg3);
}

void test__std__wcstok__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcstok(arg1, x, arg3);
}

void test__std__wcstok__arg3__notnull() {
  // cppcheck-suppress nullPointer
  std::wcstok(arg1, arg2, NULL);
}

void test__wcstoimax__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcstoimax(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcstoimax__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcstoimax(arg1, arg2, arg3);
}

void test__wcstoimax__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcstoimax(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcstoimax__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcstoimax(NULL, arg2, arg3);
}

void test__wcstoimax__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcstoimax(x, arg2, arg3);
}

void test__wcstoimax__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = wcstoimax(arg1, arg2, x);
}

void test__std__wcstoimax__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcstoimax(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcstoimax__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcstoimax(arg1, arg2, arg3);
}

void test__std__wcstoimax__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcstoimax(NULL, arg2, arg3);
}

void test__std__wcstoimax__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcstoimax(x, arg2, arg3);
}

void test__std__wcstoimax__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wcstoimax(arg1, arg2, x);
}

void test__wcstoumax__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcstoumax(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcstoumax__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcstoumax(arg1, arg2, arg3);
}

void test__wcstoumax__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcstoumax(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcstoumax__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcstoumax(NULL, arg2, arg3);
}

void test__wcstoumax__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcstoumax(x, arg2, arg3);
}

void test__wcstoumax__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = wcstoumax(arg1, arg2, x);
}

void test__std__wcstoumax__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wcstoumax(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcstoumax__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wcstoumax(arg1, arg2, arg3);
}

void test__std__wcstoumax__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = std::wcstoumax(NULL, arg2, arg3);
}

void test__std__wcstoumax__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = std::wcstoumax(x, arg2, arg3);
}

void test__std__wcstoumax__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wcstoumax(arg1, arg2, x);
}

void test__wcstol__noreturn() {
  int x = 1;
  if (cond) { x=100; wcstol(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcstol__leakignore() {
  char *p = malloc(10); *p=0;
  wcstol(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcstol__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wcstol(NULL, arg2, arg3);
}

void test__wcstol__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcstol(x, arg2, arg3);
}

void test__wcstol__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcstol(arg1, arg2, x);
}

void test__std__wcstol__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wcstol(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcstol__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::wcstol(NULL, arg2, arg3);
}

void test__std__wcstol__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcstol(x, arg2, arg3);
}

void test__std__wcstol__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wcstol(arg1, arg2, x);
}

void test__wcstoll__noreturn() {
  int x = 1;
  if (cond) { x=100; wcstoll(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcstoll__leakignore() {
  char *p = malloc(10); *p=0;
  wcstoll(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcstoll__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wcstoll(NULL, arg2, arg3);
}

void test__wcstoll__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcstoll(x, arg2, arg3);
}

void test__wcstoll__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcstoll(arg1, arg2, x);
}

void test__std__wcstoll__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wcstoll(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcstoll__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::wcstoll(NULL, arg2, arg3);
}

void test__std__wcstoll__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcstoll(x, arg2, arg3);
}

void test__std__wcstoll__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wcstoll(arg1, arg2, x);
}

void test__wcstoul__noreturn() {
  int x = 1;
  if (cond) { x=100; wcstoul(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcstoul__leakignore() {
  char *p = malloc(10); *p=0;
  wcstoul(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcstoul__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wcstoul(NULL, arg2, arg3);
}

void test__wcstoul__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcstoul(x, arg2, arg3);
}

void test__wcstoul__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcstoul(arg1, arg2, x);
}

void test__std__wcstoul__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wcstoul(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcstoul__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::wcstoul(NULL, arg2, arg3);
}

void test__std__wcstoul__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcstoul(x, arg2, arg3);
}

void test__std__wcstoul__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wcstoul(arg1, arg2, x);
}

void test__wcstoull__noreturn() {
  int x = 1;
  if (cond) { x=100; wcstoull(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcstoull__leakignore() {
  char *p = malloc(10); *p=0;
  wcstoull(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcstoull__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wcstoull(NULL, arg2, arg3);
}

void test__wcstoull__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcstoull(x, arg2, arg3);
}

void test__wcstoull__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcstoull(arg1, arg2, x);
}

void test__std__wcstoull__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wcstoull(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wcstoull__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::wcstoull(NULL, arg2, arg3);
}

void test__std__wcstoull__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wcstoull(x, arg2, arg3);
}

void test__std__wcstoull__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wcstoull(arg1, arg2, x);
}

void test__wprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; wprintf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wprintf__leakignore() {
  char *p = malloc(10); *p=0;
  wprintf(p);
  // cppcheck-suppress memleak
}

void test__wprintf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wprintf(NULL);
}

void test__std__wprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wprintf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wprintf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::wprintf(NULL);
}

void test__sprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; sprintf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sprintf__leakignore() {
  char *p = malloc(10); *p=0;
  sprintf(p, arg2);
  // cppcheck-suppress memleak
}

void test__sprintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sprintf(x, arg2);
}

void test__sprintf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  sprintf(arg1, NULL);
}

void test__sprintf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  sprintf(arg1, x);
}

void test__std__sprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::sprintf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__sprintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::sprintf(x, arg2);
}

void test__std__sprintf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::sprintf(arg1, NULL);
}

void test__std__sprintf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::sprintf(arg1, x);
}

void test__swprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; swprintf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__swprintf__leakignore() {
  char *p = malloc(10); *p=0;
  swprintf(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__swprintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  swprintf(x, arg2, arg3);
}

void test__swprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  swprintf(arg1, x, arg3);
}

void test__swprintf__arg3__notnull() {
  // cppcheck-suppress nullPointer
  swprintf(arg1, arg2, NULL);
}

void test__swprintf__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  swprintf(arg1, arg2, x);
}

void test__std__swprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::swprintf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__swprintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::swprintf(x, arg2, arg3);
}

void test__std__swprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::swprintf(arg1, x, arg3);
}

void test__std__swprintf__arg3__notnull() {
  // cppcheck-suppress nullPointer
  std::swprintf(arg1, arg2, NULL);
}

void test__std__swprintf__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::swprintf(arg1, arg2, x);
}

void test__vsprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; vsprintf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vsprintf__leakignore() {
  char *p = malloc(10); *p=0;
  vsprintf(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__vsprintf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  vsprintf(NULL, arg2, arg3);
}

void test__vsprintf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  vsprintf(arg1, NULL, arg3);
}

void test__vsprintf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  vsprintf(arg1, x, arg3);
}

void test__std__vsprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vsprintf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vsprintf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::vsprintf(NULL, arg2, arg3);
}

void test__std__vsprintf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::vsprintf(arg1, NULL, arg3);
}

void test__std__vsprintf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::vsprintf(arg1, x, arg3);
}

void test__vswprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; vswprintf(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vswprintf__leakignore() {
  char *p = malloc(10); *p=0;
  vswprintf(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__vswprintf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  vswprintf(NULL, arg2, arg3, arg4);
}

void test__vswprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  vswprintf(arg1, x, arg3, arg4);
}

void test__vswprintf__arg3__notnull() {
  // cppcheck-suppress nullPointer
  vswprintf(arg1, arg2, NULL, arg4);
}

void test__vswprintf__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  vswprintf(arg1, arg2, x, arg4);
}

void test__std__vswprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vswprintf(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vswprintf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::vswprintf(NULL, arg2, arg3, arg4);
}

void test__std__vswprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::vswprintf(arg1, x, arg3, arg4);
}

void test__std__vswprintf__arg3__notnull() {
  // cppcheck-suppress nullPointer
  std::vswprintf(arg1, arg2, NULL, arg4);
}

void test__std__vswprintf__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::vswprintf(arg1, arg2, x, arg4);
}

void test__fwprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; fwprintf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fwprintf__leakignore() {
  char *p = malloc(10); *p=0;
  fwprintf(p, arg2);
  // cppcheck-suppress memleak
}

void test__fwprintf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fwprintf(NULL, arg2);
}

void test__fwprintf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  fwprintf(arg1, NULL);
}

void test__fwprintf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fwprintf(arg1, x);
}

void test__std__fwprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fwprintf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fwprintf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::fwprintf(NULL, arg2);
}

void test__std__fwprintf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::fwprintf(arg1, NULL);
}

void test__std__fwprintf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::fwprintf(arg1, x);
}

void test__snprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; snprintf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__snprintf__leakignore() {
  char *p = malloc(10); *p=0;
  snprintf(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__snprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  snprintf(arg1, x, arg3);
}

void test__snprintf__arg3__notnull() {
  // cppcheck-suppress nullPointer
  snprintf(arg1, arg2, NULL);
}

void test__snprintf__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  snprintf(arg1, arg2, x);
}

void test__std__snprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::snprintf(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__snprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::snprintf(arg1, x, arg3);
}

void test__std__snprintf__arg3__notnull() {
  // cppcheck-suppress nullPointer
  std::snprintf(arg1, arg2, NULL);
}

void test__std__snprintf__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::snprintf(arg1, arg2, x);
}

void test__vsnprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; vsnprintf(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vsnprintf__leakignore() {
  char *p = malloc(10); *p=0;
  vsnprintf(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__vsnprintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  vsnprintf(x, arg2, arg3, arg4);
}

void test__vsnprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  vsnprintf(arg1, x, arg3, arg4);
}

void test__vsnprintf__arg3__notnull() {
  // cppcheck-suppress nullPointer
  vsnprintf(arg1, arg2, NULL, arg4);
}

void test__vsnprintf__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  vsnprintf(arg1, arg2, x, arg4);
}

void test__std__vsnprintf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vsnprintf(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vsnprintf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::vsnprintf(x, arg2, arg3, arg4);
}

void test__std__vsnprintf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::vsnprintf(arg1, x, arg3, arg4);
}

void test__std__vsnprintf__arg3__notnull() {
  // cppcheck-suppress nullPointer
  std::vsnprintf(arg1, arg2, NULL, arg4);
}

void test__std__vsnprintf__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::vsnprintf(arg1, arg2, x, arg4);
}

void test__wscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; wscanf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wscanf__leakignore() {
  char *p = malloc(10); *p=0;
  wscanf(p);
  // cppcheck-suppress memleak
}

void test__wscanf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wscanf(NULL);
}

void test__wscanf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wscanf(x);
}

void test__std__wscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wscanf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wscanf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::wscanf(NULL);
}

void test__std__wscanf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::wscanf(x);
}

void test__sscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; sscanf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sscanf__leakignore() {
  char *p = malloc(10); *p=0;
  sscanf(p, arg2);
  // cppcheck-suppress memleak
}

void test__sscanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sscanf(x, arg2);
}

void test__sscanf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  sscanf(arg1, NULL);
}

void test__sscanf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  sscanf(arg1, x);
}

void test__std__sscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::sscanf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__sscanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::sscanf(x, arg2);
}

void test__std__sscanf__arg2__notnull() {
  // cppcheck-suppress nullPointer
  std::sscanf(arg1, NULL);
}

void test__std__sscanf__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::sscanf(arg1, x);
}

void test__fwscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; fwscanf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fwscanf__leakignore() {
  char *p = malloc(10); *p=0;
  fwscanf(p, arg2);
  // cppcheck-suppress memleak
}

void test__fwscanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fwscanf(x, arg2);
}

void test__fwscanf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fwscanf(arg1, x);
}

void test__std__fwscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fwscanf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fwscanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fwscanf(x, arg2);
}

void test__std__fwscanf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fwscanf(arg1, x);
}

void test__swscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; swscanf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__swscanf__leakignore() {
  char *p = malloc(10); *p=0;
  swscanf(p, arg2);
  // cppcheck-suppress memleak
}

void test__swscanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  swscanf(x, arg2);
}

void test__swscanf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  swscanf(arg1, x);
}

void test__std__swscanf__noreturn() {
  int x = 1;
  if (cond) { x=100; std::swscanf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__swscanf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::swscanf(x, arg2);
}

void test__std__swscanf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::swscanf(arg1, x);
}

void test__system__noreturn() {
  int x = 1;
  if (cond) { x=100; system(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__system__leakignore() {
  char *p = malloc(10); *p=0;
  system(p);
  // cppcheck-suppress memleak
}

void test__system__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  system(x);
}

void test__std__system__noreturn() {
  int x = 1;
  if (cond) { x=100; std::system(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__system__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::system(x);
}

void test__setw__noreturn() {
  int x = 1;
  if (cond) { x=100; setw(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setw__leakignore() {
  char *p = malloc(10); *p=0;
  setw(p);
  // cppcheck-suppress memleak
}

void test__setw__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setw(x);
}

void test__std__setw__noreturn() {
  int x = 1;
  if (cond) { x=100; std::setw(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__setw__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::setw(x);
}

void test__min__noreturn() {
  int x = 1;
  if (cond) { x=100; result = min(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__min__useretval() {
  // cppcheck-suppress ignoredReturnValue
  min(arg1, arg2);
}

void test__min__leakignore() {
  char *p = malloc(10); *p=0;
  result = min(p, arg2);
  // cppcheck-suppress memleak
}

void test__min__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = min(x, arg2);
}

void test__min__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = min(arg1, x);
}

void test__std__min__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::min(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__min__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::min(arg1, arg2);
}

void test__std__min__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::min(x, arg2);
}

void test__std__min__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::min(arg1, x);
}

void test__max__noreturn() {
  int x = 1;
  if (cond) { x=100; result = max(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__max__useretval() {
  // cppcheck-suppress ignoredReturnValue
  max(arg1, arg2);
}

void test__max__leakignore() {
  char *p = malloc(10); *p=0;
  result = max(p, arg2);
  // cppcheck-suppress memleak
}

void test__max__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = max(x, arg2);
}

void test__max__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = max(arg1, x);
}

void test__std__max__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::max(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__max__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::max(arg1, arg2);
}

void test__std__max__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::max(x, arg2);
}

void test__std__max__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::max(arg1, x);
}

void test__setiosflags__noreturn() {
  int x = 1;
  if (cond) { x=100; setiosflags(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setiosflags__leakignore() {
  char *p = malloc(10); *p=0;
  setiosflags(p);
  // cppcheck-suppress memleak
}

void test__setiosflags__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setiosflags(x);
}

void test__std__setiosflags__noreturn() {
  int x = 1;
  if (cond) { x=100; std::setiosflags(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__setiosflags__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::setiosflags(x);
}

void test__resetiosflags__noreturn() {
  int x = 1;
  if (cond) { x=100; resetiosflags(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__resetiosflags__leakignore() {
  char *p = malloc(10); *p=0;
  resetiosflags(p);
  // cppcheck-suppress memleak
}

void test__resetiosflags__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  resetiosflags(x);
}

void test__std__resetiosflags__noreturn() {
  int x = 1;
  if (cond) { x=100; std::resetiosflags(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__resetiosflags__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::resetiosflags(x);
}

void test__setfill__noreturn() {
  int x = 1;
  if (cond) { x=100; setfill(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setfill__leakignore() {
  char *p = malloc(10); *p=0;
  setfill(p);
  // cppcheck-suppress memleak
}

void test__setfill__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setfill(x);
}

void test__std__setfill__noreturn() {
  int x = 1;
  if (cond) { x=100; std::setfill(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__setfill__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::setfill(x);
}

void test__setprecision__noreturn() {
  int x = 1;
  if (cond) { x=100; setprecision(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setprecision__leakignore() {
  char *p = malloc(10); *p=0;
  setprecision(p);
  // cppcheck-suppress memleak
}

void test__setprecision__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setprecision(x);
}

void test__std__setprecision__noreturn() {
  int x = 1;
  if (cond) { x=100; std::setprecision(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__setprecision__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::setprecision(x);
}

void test__setbase__noreturn() {
  int x = 1;
  if (cond) { x=100; setbase(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setbase__leakignore() {
  char *p = malloc(10); *p=0;
  setbase(p);
  // cppcheck-suppress memleak
}

void test__setbase__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setbase(x);
}

void test__std__setbase__noreturn() {
  int x = 1;
  if (cond) { x=100; std::setbase(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__setbase__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::setbase(x);
}

void test__zonetime__noreturn() {
  int x = 1;
  if (cond) { x=100; result = zonetime(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__zonetime__useretval() {
  // cppcheck-suppress ignoredReturnValue
  zonetime(arg1, arg2);
}

void test__zonetime__leakignore() {
  char *p = malloc(10); *p=0;
  result = zonetime(p, arg2);
  // cppcheck-suppress memleak
}

void test__zonetime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = zonetime(NULL, arg2);
}

void test__zonetime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = zonetime(x, arg2);
}

void test__zonetime__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = zonetime(arg1, x);
}

void test__c16rtomb__noreturn() {
  int x = 1;
  if (cond) { x=100; c16rtomb(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__c16rtomb__leakignore() {
  char *p = malloc(10); *p=0;
  c16rtomb(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__c16rtomb__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  c16rtomb(arg1, x, arg3);
}

void test__c16rtomb__arg3__notnull() {
  // cppcheck-suppress nullPointer
  c16rtomb(arg1, arg2, NULL);
}

void test__c16rtomb__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  c16rtomb(arg1, arg2, x);
}

void test__c32rtomb__noreturn() {
  int x = 1;
  if (cond) { x=100; c32rtomb(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__c32rtomb__leakignore() {
  char *p = malloc(10); *p=0;
  c32rtomb(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__c32rtomb__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  c32rtomb(arg1, x, arg3);
}

void test__c32rtomb__arg3__notnull() {
  // cppcheck-suppress nullPointer
  c32rtomb(arg1, arg2, NULL);
}

void test__c32rtomb__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  c32rtomb(arg1, arg2, x);
}

void test__mbrtoc16__noreturn() {
  int x = 1;
  if (cond) { x=100; mbrtoc16(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mbrtoc16__leakignore() {
  char *p = malloc(10); *p=0;
  mbrtoc16(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__mbrtoc16__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mbrtoc16(arg1, x, arg3, arg4);
}

void test__mbrtoc16__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mbrtoc16(arg1, arg2, x, arg4);
}

void test__mbrtoc16__arg4__notnull() {
  // cppcheck-suppress nullPointer
  mbrtoc16(arg1, arg2, arg3, NULL);
}

void test__mbrtoc16__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  mbrtoc16(arg1, arg2, arg3, x);
}

void test__mbrtoc32__noreturn() {
  int x = 1;
  if (cond) { x=100; mbrtoc32(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mbrtoc32__leakignore() {
  char *p = malloc(10); *p=0;
  mbrtoc32(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__mbrtoc32__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mbrtoc32(arg1, x, arg3, arg4);
}

void test__mbrtoc32__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mbrtoc32(arg1, arg2, x, arg4);
}

void test__mbrtoc32__arg4__notnull() {
  // cppcheck-suppress nullPointer
  mbrtoc32(arg1, arg2, arg3, NULL);
}

void test__mbrtoc32__arg4__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  mbrtoc32(arg1, arg2, arg3, x);
}

void test__std__swap__noreturn() {
  int x = 1;
  if (cond) { x=100; std::swap(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__swap__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::swap(x, arg2);
}

void test__std__swap__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::swap(arg1, x);
}

void test__std__ostringstream__str__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ostringstream::str(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ostringstream__str__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ostringstream::str();
}

void test__std__ios__good__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ios::good(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ios__good__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ios::good();
}

void test__std__ios_base__good__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ios_base::good(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ios_base__good__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ios_base::good();
}

void test__std__ostream__good__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ostream::good(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ostream__good__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ostream::good();
}

void test__std__ofstream__good__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ofstream::good(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ofstream__good__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ofstream::good();
}

void test__std__ostringstream__good__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ostringstream::good(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ostringstream__good__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ostringstream::good();
}

void test__std__ios__eof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ios::eof(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ios__eof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ios::eof();
}

void test__std__ios_base__eof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ios_base::eof(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ios_base__eof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ios_base::eof();
}

void test__std__ostream__eof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ostream::eof(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ostream__eof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ostream::eof();
}

void test__std__ofstream__eof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ofstream::eof(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ofstream__eof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ofstream::eof();
}

void test__std__ostringstream__eof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ostringstream::eof(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ostringstream__eof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ostringstream::eof();
}

void test__std__ios__fail__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ios::fail(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ios__fail__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ios::fail();
}

void test__std__ios_base__fail__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ios_base::fail(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ios_base__fail__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ios_base::fail();
}

void test__std__ostream__fail__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ostream::fail(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ostream__fail__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ostream::fail();
}

void test__std__ofstream__fail__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ofstream::fail(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ofstream__fail__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ofstream::fail();
}

void test__std__ostringstream__fail__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ostringstream::fail(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ostringstream__fail__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ostringstream::fail();
}

void test__std__ios__bad__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ios::bad(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ios__bad__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ios::bad();
}

void test__std__ios_base__bad__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ios_base::bad(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ios_base__bad__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ios_base::bad();
}

void test__std__ostream__bad__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ostream::bad(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ostream__bad__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ostream::bad();
}

void test__std__ofstream__bad__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ofstream::bad(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ofstream__bad__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ofstream::bad();
}

void test__std__ostringstream__bad__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::ostringstream::bad(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ostringstream__bad__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::ostringstream::bad();
}

void test__std__array__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::array::clear(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__deque__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::deque::clear(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__list__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::list::clear(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__forward_list__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::forward_list::clear(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__map__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::map::clear(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__unordered_map__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::unordered_map::clear(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__queue__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::queue::clear(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__set__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::set::clear(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__unordered_set__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::unordered_set::clear(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stack__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::stack::clear(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::string::clear(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wstring__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wstring::clear(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__basic_string__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::basic_string::clear(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vector::clear(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__array__empty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::array::empty(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__array__empty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::array::empty();
}

void test__std__deque__empty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::deque::empty(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__deque__empty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::deque::empty();
}

void test__std__list__empty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::list::empty(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__list__empty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::list::empty();
}

void test__std__forward_list__empty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::forward_list::empty(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__forward_list__empty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::forward_list::empty();
}

void test__std__map__empty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::map::empty(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__map__empty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::map::empty();
}

void test__std__unordered_map__empty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::unordered_map::empty(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__unordered_map__empty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::unordered_map::empty();
}

void test__std__queue__empty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::queue::empty(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__queue__empty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::queue::empty();
}

void test__std__set__empty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::set::empty(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__set__empty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::set::empty();
}

void test__std__unordered_set__empty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::unordered_set::empty(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__unordered_set__empty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::unordered_set::empty();
}

void test__std__stack__empty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::stack::empty(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stack__empty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::stack::empty();
}

void test__std__string__empty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::empty(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__empty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::empty();
}

void test__std__wstring__empty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wstring::empty(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wstring__empty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wstring::empty();
}

void test__std__basic_string__empty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::basic_string::empty(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__basic_string__empty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::basic_string::empty();
}

void test__std__vector__empty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::vector::empty(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__empty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::vector::empty();
}

void test__std__deque__push_back__noreturn() {
  int x = 1;
  if (cond) { x=100; std::deque::push_back(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__deque__push_back__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::deque::push_back(x);
}

void test__std__deque__push_front__noreturn() {
  int x = 1;
  if (cond) { x=100; std::deque::push_front(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__deque__push_front__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::deque::push_front(x);
}

void test__std__list__push_back__noreturn() {
  int x = 1;
  if (cond) { x=100; std::list::push_back(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__list__push_back__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::list::push_back(x);
}

void test__std__list__push_front__noreturn() {
  int x = 1;
  if (cond) { x=100; std::list::push_front(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__list__push_front__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::list::push_front(x);
}

void test__std__forward_list__push_front__noreturn() {
  int x = 1;
  if (cond) { x=100; std::forward_list::push_front(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__forward_list__push_front__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::forward_list::push_front(x);
}

void test__std__queue__push__noreturn() {
  int x = 1;
  if (cond) { x=100; std::queue::push(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__queue__push__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::queue::push(x);
}

void test__std__stack__push__noreturn() {
  int x = 1;
  if (cond) { x=100; std::stack::push(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stack__push__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::stack::push(x);
}

void test__std__vector__push_back__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vector::push_back(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__push_back__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::vector::push_back(x);
}

void test__std__vector__push_front__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vector::push_front(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__push_front__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::vector::push_front(x);
}

void test__std__list__insert__noreturn() {
  int x = 1;
  if (cond) { x=100; std::list::insert(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__list__insert__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::list::insert(x);
}

void test__std__multimap__insert__noreturn() {
  int x = 1;
  if (cond) { x=100; std::multimap::insert(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__multimap__insert__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::multimap::insert(x);
}

void test__std__set__insert__noreturn() {
  int x = 1;
  if (cond) { x=100; std::set::insert(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__set__insert__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::set::insert(x);
}

void test__std__string__insert__noreturn() {
  int x = 1;
  if (cond) { x=100; std::string::insert(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__insert__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::string::insert(x);
}

void test__std__vector__insert__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vector::insert(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__insert__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::vector::insert(x);
}

void test__std__deque__emplace_back__noreturn() {
  int x = 1;
  if (cond) { x=100; std::deque::emplace_back(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__deque__emplace_front__noreturn() {
  int x = 1;
  if (cond) { x=100; std::deque::emplace_front(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__list__emplace_back__noreturn() {
  int x = 1;
  if (cond) { x=100; std::list::emplace_back(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__list__emplace_front__noreturn() {
  int x = 1;
  if (cond) { x=100; std::list::emplace_front(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__forward_list__emplace_front__noreturn() {
  int x = 1;
  if (cond) { x=100; std::forward_list::emplace_front(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__queue__emplace__noreturn() {
  int x = 1;
  if (cond) { x=100; std::queue::emplace(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stack__emplace__noreturn() {
  int x = 1;
  if (cond) { x=100; std::stack::emplace(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__emplace_back__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vector::emplace_back(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__emplace_front__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vector::emplace_front(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__list__find__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::list::find(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__list__find__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::list::find(arg1);
}

void test__std__list__find__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::list::find(x);
}

void test__std__map__find__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::map::find(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__map__find__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::map::find(arg1);
}

void test__std__map__find__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::map::find(x);
}

void test__std__set__find__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::set::find(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__set__find__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::set::find(arg1);
}

void test__std__set__find__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::set::find(x);
}

void test__std__vector__find__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::vector::find(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__find__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::vector::find(arg1);
}

void test__std__vector__find__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::vector::find(x);
}

void test__std__deque__size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::deque::size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__deque__size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::deque::size();
}

void test__std__deque__max_size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::deque::max_size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__deque__max_size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::deque::max_size();
}

void test__std__list__size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::list::size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__list__size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::list::size();
}

void test__std__list__max_size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::list::max_size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__list__max_size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::list::max_size();
}

void test__std__map__size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::map::size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__map__size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::map::size();
}

void test__std__map__max_size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::map::max_size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__map__max_size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::map::max_size();
}

void test__std__unordered_map__size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::unordered_map::size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__unordered_map__size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::unordered_map::size();
}

void test__std__unordered_map__max_size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::unordered_map::max_size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__unordered_map__max_size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::unordered_map::max_size();
}

void test__std__queue__size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::queue::size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__queue__size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::queue::size();
}

void test__std__set__size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::set::size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__set__size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::set::size();
}

void test__std__set__max_size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::set::max_size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__set__max_size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::set::max_size();
}

void test__std__unordered_set__size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::unordered_set::size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__unordered_set__size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::unordered_set::size();
}

void test__std__unordered_set__max_size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::unordered_set::max_size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__unordered_set__max_size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::unordered_set::max_size();
}

void test__std__stack__size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::stack::size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stack__size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::stack::size();
}

void test__std__string__size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::size();
}

void test__std__wstring__size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wstring::size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wstring__size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wstring::size();
}

void test__std__vector__size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::vector::size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::vector::size();
}

void test__std__vector__capacity__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::vector::capacity(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__capacity__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::vector::capacity();
}

void test__std__vector__max_size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::vector::max_size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__max_size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::vector::max_size();
}

void test__std__array__size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::array::size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__array__size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::array::size();
}

void test__std__array__max_size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::array::max_size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__array__max_size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::array::max_size();
}

void test__std__list__back__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::list::back(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__list__back__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::list::back();
}

void test__std__list__front__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::list::front(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__list__front__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::list::front();
}

void test__std__forward_list__front__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::forward_list::front(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__forward_list__front__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::forward_list::front();
}

void test__std__queue__back__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::queue::back(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__queue__back__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::queue::back();
}

void test__std__queue__front__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::queue::front(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__queue__front__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::queue::front();
}

void test__std__vector__back__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::vector::back(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__back__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::vector::back();
}

void test__std__vector__front__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::vector::front(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__front__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::vector::front();
}

void test__std__array__front__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::array::front(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__array__front__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::array::front();
}

void test__std__array__back__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::array::back(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__array__back__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::array::back();
}

void test__std__vector__at__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::vector::at(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__at__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::vector::at(arg1);
}

void test__std__vector__at__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::vector::at(x);
}

void test__std__list__pop_back__noreturn() {
  int x = 1;
  if (cond) { x=100; std::list::pop_back(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__list__pop_front__noreturn() {
  int x = 1;
  if (cond) { x=100; std::list::pop_front(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__forward_list__pop_front__noreturn() {
  int x = 1;
  if (cond) { x=100; std::forward_list::pop_front(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__vector__pop_back__noreturn() {
  int x = 1;
  if (cond) { x=100; std::vector::pop_back(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stack__pop__noreturn() {
  int x = 1;
  if (cond) { x=100; std::stack::pop(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__queue__pop__noreturn() {
  int x = 1;
  if (cond) { x=100; std::queue::pop(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stack__top__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::stack::top(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__stack__top__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::stack::top();
}

void test__std__string__at__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::at(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__at__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::at(arg1);
}

void test__std__string__at__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::at(x);
}

void test__std__string__push_back__noreturn() {
  int x = 1;
  if (cond) { x=100; std::string::push_back(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__push_back__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::string::push_back(x);
}

void test__std__string__back__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::back(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__back__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::back();
}

void test__std__string__swap__noreturn() {
  int x = 1;
  if (cond) { x=100; std::string::swap(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__c_str__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::c_str(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__c_str__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::c_str();
}

void test__std__string__data__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::data(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__data__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::data();
}

void test__std__string__front__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::front(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__front__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::front();
}

void test__std__basic_string__find_last_not_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::basic_string::find_last_not_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__basic_string__find_last_not_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::basic_string::find_last_not_of(arg1, arg2, arg3);
}

void test__std__basic_string__find_last_not_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find_last_not_of(x, arg2, arg3);
}

void test__std__basic_string__find_last_not_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find_last_not_of(arg1, x, arg3);
}

void test__std__basic_string__find_last_not_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find_last_not_of(arg1, arg2, x);
}

void test__std__string__find_last_not_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::find_last_not_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__find_last_not_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::find_last_not_of(arg1, arg2, arg3);
}

void test__std__string__find_last_not_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find_last_not_of(x, arg2, arg3);
}

void test__std__string__find_last_not_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find_last_not_of(arg1, x, arg3);
}

void test__std__string__find_last_not_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find_last_not_of(arg1, arg2, x);
}

void test__std__wstring__find_last_not_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wstring::find_last_not_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wstring__find_last_not_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wstring::find_last_not_of(arg1, arg2, arg3);
}

void test__std__wstring__find_last_not_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find_last_not_of(x, arg2, arg3);
}

void test__std__wstring__find_last_not_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find_last_not_of(arg1, x, arg3);
}

void test__std__wstring__find_last_not_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find_last_not_of(arg1, arg2, x);
}

void test__std__basic_string__find_first_not_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::basic_string::find_first_not_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__basic_string__find_first_not_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::basic_string::find_first_not_of(arg1, arg2, arg3);
}

void test__std__basic_string__find_first_not_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find_first_not_of(x, arg2, arg3);
}

void test__std__basic_string__find_first_not_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find_first_not_of(arg1, x, arg3);
}

void test__std__basic_string__find_first_not_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find_first_not_of(arg1, arg2, x);
}

void test__std__string__find_first_not_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::find_first_not_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__find_first_not_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::find_first_not_of(arg1, arg2, arg3);
}

void test__std__string__find_first_not_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find_first_not_of(x, arg2, arg3);
}

void test__std__string__find_first_not_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find_first_not_of(arg1, x, arg3);
}

void test__std__string__find_first_not_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find_first_not_of(arg1, arg2, x);
}

void test__std__wstring__find_first_not_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wstring::find_first_not_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wstring__find_first_not_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wstring::find_first_not_of(arg1, arg2, arg3);
}

void test__std__wstring__find_first_not_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find_first_not_of(x, arg2, arg3);
}

void test__std__wstring__find_first_not_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find_first_not_of(arg1, x, arg3);
}

void test__std__wstring__find_first_not_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find_first_not_of(arg1, arg2, x);
}

void test__std__string__find__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::find(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__find__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::find(arg1, arg2, arg3);
}

void test__std__string__find__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find(x, arg2, arg3);
}

void test__std__string__find__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find(arg1, x, arg3);
}

void test__std__string__find__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find(arg1, arg2, x);
}

void test__std__string__rfind__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::rfind(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__rfind__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::rfind(arg1, arg2, arg3);
}

void test__std__string__rfind__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::rfind(x, arg2, arg3);
}

void test__std__string__rfind__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::rfind(arg1, x, arg3);
}

void test__std__string__rfind__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::rfind(arg1, arg2, x);
}

void test__std__wstring__find__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wstring::find(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wstring__find__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wstring::find(arg1, arg2, arg3);
}

void test__std__wstring__find__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find(x, arg2, arg3);
}

void test__std__wstring__find__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find(arg1, x, arg3);
}

void test__std__wstring__find__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find(arg1, arg2, x);
}

void test__std__wstring__rfind__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wstring::rfind(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wstring__rfind__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wstring::rfind(arg1, arg2, arg3);
}

void test__std__wstring__rfind__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::rfind(x, arg2, arg3);
}

void test__std__wstring__rfind__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::rfind(arg1, x, arg3);
}

void test__std__wstring__rfind__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::rfind(arg1, arg2, x);
}

void test__std__basic_string__find__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::basic_string::find(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__basic_string__find__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::basic_string::find(arg1, arg2, arg3);
}

void test__std__basic_string__find__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find(x, arg2, arg3);
}

void test__std__basic_string__find__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find(arg1, x, arg3);
}

void test__std__basic_string__find__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find(arg1, arg2, x);
}

void test__std__basic_string__rfind__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::basic_string::rfind(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__basic_string__rfind__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::basic_string::rfind(arg1, arg2, arg3);
}

void test__std__basic_string__rfind__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::rfind(x, arg2, arg3);
}

void test__std__basic_string__rfind__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::rfind(arg1, x, arg3);
}

void test__std__basic_string__rfind__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::rfind(arg1, arg2, x);
}

void test__std__string__find_first_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::find_first_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__find_first_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::find_first_of(arg1, arg2, arg3);
}

void test__std__string__find_first_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find_first_of(x, arg2, arg3);
}

void test__std__string__find_first_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find_first_of(arg1, x, arg3);
}

void test__std__string__find_first_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find_first_of(arg1, arg2, x);
}

void test__std__wstring__find_first_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wstring::find_first_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wstring__find_first_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wstring::find_first_of(arg1, arg2, arg3);
}

void test__std__wstring__find_first_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find_first_of(x, arg2, arg3);
}

void test__std__wstring__find_first_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find_first_of(arg1, x, arg3);
}

void test__std__wstring__find_first_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find_first_of(arg1, arg2, x);
}

void test__std__basic_string__find_first_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::basic_string::find_first_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__basic_string__find_first_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::basic_string::find_first_of(arg1, arg2, arg3);
}

void test__std__basic_string__find_first_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find_first_of(x, arg2, arg3);
}

void test__std__basic_string__find_first_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find_first_of(arg1, x, arg3);
}

void test__std__basic_string__find_first_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find_first_of(arg1, arg2, x);
}

void test__std__string__find_last_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::find_last_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__find_last_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::find_last_of(arg1, arg2, arg3);
}

void test__std__string__find_last_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find_last_of(x, arg2, arg3);
}

void test__std__string__find_last_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find_last_of(arg1, x, arg3);
}

void test__std__string__find_last_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::find_last_of(arg1, arg2, x);
}

void test__std__wstring__find_last_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wstring::find_last_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wstring__find_last_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wstring::find_last_of(arg1, arg2, arg3);
}

void test__std__wstring__find_last_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find_last_of(x, arg2, arg3);
}

void test__std__wstring__find_last_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find_last_of(arg1, x, arg3);
}

void test__std__wstring__find_last_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::find_last_of(arg1, arg2, x);
}

void test__std__basic_string__find_last_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::basic_string::find_last_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__basic_string__find_last_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::basic_string::find_last_of(arg1, arg2, arg3);
}

void test__std__basic_string__find_last_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find_last_of(x, arg2, arg3);
}

void test__std__basic_string__find_last_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find_last_of(arg1, x, arg3);
}

void test__std__basic_string__find_last_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::find_last_of(arg1, arg2, x);
}

void test__std__string__length__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::length(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__length__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::length();
}

void test__std__wstring__length__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wstring::length(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wstring__length__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wstring::length();
}

void test__std__basic_string__size__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::basic_string::size(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__basic_string__size__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::basic_string::size();
}

void test__std__basic_string__length__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::basic_string::length(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__basic_string__length__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::basic_string::length();
}

void test__std__string__substr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::string::substr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__substr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::string::substr(arg1, arg2);
}

void test__std__string__substr__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::substr(x, arg2);
}

void test__std__string__substr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::string::substr(arg1, x);
}

void test__std__wstring__substr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::wstring::substr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wstring__substr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::wstring::substr(arg1, arg2);
}

void test__std__wstring__substr__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::substr(x, arg2);
}

void test__std__wstring__substr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::wstring::substr(arg1, x);
}

void test__std__basic_string__substr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::basic_string::substr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__basic_string__substr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::basic_string::substr(arg1, arg2);
}

void test__std__basic_string__substr__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::substr(x, arg2);
}

void test__std__basic_string__substr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::basic_string::substr(arg1, x);
}

void test__std__ios__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::ios::clear(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ios__clear__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::ios::clear(x);
}

void test__std__fstream__clear__noreturn() {
  int x = 1;
  if (cond) { x=100; std::fstream::clear(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__fstream__clear__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::fstream::clear(x);
}

void test__std__istream__read__noreturn() {
  int x = 1;
  if (cond) { x=100; std::istream::read(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__istream__read__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::istream::read(NULL, arg2);
}

void test__std__istream__read__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::istream::read(arg1, x);
}

void test__std__ifstream__read__noreturn() {
  int x = 1;
  if (cond) { x=100; std::ifstream::read(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ifstream__read__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::ifstream::read(NULL, arg2);
}

void test__std__ifstream__read__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::ifstream::read(arg1, x);
}

void test__std__istream__readsome__noreturn() {
  int x = 1;
  if (cond) { x=100; std::istream::readsome(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__istream__readsome__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::istream::readsome(NULL, arg2);
}

void test__std__istream__readsome__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::istream::readsome(arg1, x);
}

void test__std__ifstream__readsome__noreturn() {
  int x = 1;
  if (cond) { x=100; std::ifstream::readsome(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ifstream__readsome__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::ifstream::readsome(NULL, arg2);
}

void test__std__ifstream__readsome__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::ifstream::readsome(arg1, x);
}

void test__std__istream__getline__noreturn() {
  int x = 1;
  if (cond) { x=100; std::istream::getline(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__istream__getline__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::istream::getline(NULL, arg2, arg3);
}

void test__std__istream__getline__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::istream::getline(arg1, x, arg3);
}

void test__std__istream__getline__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::istream::getline(arg1, arg2, x);
}

void test__std__ifstream__getline__noreturn() {
  int x = 1;
  if (cond) { x=100; std::ifstream::getline(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ifstream__getline__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::ifstream::getline(NULL, arg2, arg3);
}

void test__std__ifstream__getline__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::ifstream::getline(arg1, x, arg3);
}

void test__std__ifstream__getline__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::ifstream::getline(arg1, arg2, x);
}

void test__std__istream__get__noreturn() {
  int x = 1;
  if (cond) { x=100; std::istream::get(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__istream__get__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::istream::get(NULL, arg2, arg3);
}

void test__std__istream__get__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::istream::get(arg1, x, arg3);
}

void test__std__istream__get__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::istream::get(arg1, arg2, x);
}

void test__std__ifstream__get__noreturn() {
  int x = 1;
  if (cond) { x=100; std::ifstream::get(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__ifstream__get__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::ifstream::get(NULL, arg2, arg3);
}

void test__std__ifstream__get__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::ifstream::get(arg1, x, arg3);
}

void test__std__ifstream__get__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::ifstream::get(arg1, arg2, x);
}

void test__itoa__noreturn() {
  int x = 1;
  if (cond) { x=100; itoa(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__itoa__leakignore() {
  char *p = malloc(10); *p=0;
  itoa(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__itoa__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  itoa(x, arg2, arg3);
}

void test__itoa__arg2__notnull() {
  // cppcheck-suppress nullPointer
  itoa(arg1, NULL, arg3);
}

void test__itoa__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  itoa(arg1, arg2, x);
}

void test__std__string__erase__noreturn() {
  int x = 1;
  if (cond) { x=100; std::string::erase(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__erase__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::string::erase(x, arg2);
}

void test__std__string__erase__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::string::erase(arg1, x);
}

void test__std__wstring__erase__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wstring::erase(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wstring__erase__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wstring::erase(x, arg2);
}

void test__std__wstring__erase__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wstring::erase(arg1, x);
}

void test__std__basic_string__erase__noreturn() {
  int x = 1;
  if (cond) { x=100; std::basic_string::erase(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__basic_string__erase__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::basic_string::erase(x, arg2);
}

void test__std__basic_string__erase__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::basic_string::erase(arg1, x);
}

void test__std__string__reserve__noreturn() {
  int x = 1;
  if (cond) { x=100; std::string::reserve(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__string__reserve__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::string::reserve(x);
}

void test__std__wstring__reserve__noreturn() {
  int x = 1;
  if (cond) { x=100; std::wstring::reserve(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__wstring__reserve__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::wstring::reserve(x);
}

void test__std__basic_string__reserve__noreturn() {
  int x = 1;
  if (cond) { x=100; std::basic_string::reserve(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__basic_string__reserve__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::basic_string::reserve(x);
}

void test__std__adjacent_find__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::adjacent_find(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__adjacent_find__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::adjacent_find(arg1, arg2, arg3);
}

void test__std__adjacent_find__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::adjacent_find(x, arg2, arg3);
}

void test__std__adjacent_find__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::adjacent_find(arg1, x, arg3);
}

void test__std__adjacent_find__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::adjacent_find(arg1, arg2, x);
}

void test__std__find__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::find(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__find__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::find(arg1, arg2, arg3);
}

void test__std__find__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find(x, arg2, arg3);
}

void test__std__find__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find(arg1, x, arg3);
}

void test__std__find__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find(arg1, arg2, x);
}

void test__std__find_if__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::find_if(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__find_if__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::find_if(arg1, arg2, arg3);
}

void test__std__find_if__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_if(x, arg2, arg3);
}

void test__std__find_if__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_if(arg1, x, arg3);
}

void test__std__find_if__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_if(arg1, arg2, x);
}

void test__std__find_if_not__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::find_if_not(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__find_if_not__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::find_if_not(arg1, arg2, arg3);
}

void test__std__find_if_not__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_if_not(x, arg2, arg3);
}

void test__std__find_if_not__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_if_not(arg1, x, arg3);
}

void test__std__find_if_not__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_if_not(arg1, arg2, x);
}

void test__std__copy__noreturn() {
  int x = 1;
  if (cond) { x=100; std::copy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__copy__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::copy(x, arg2, arg3);
}

void test__std__copy__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::copy(arg1, x, arg3);
}

void test__std__copy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::copy(arg1, arg2, x);
}

void test__std__all_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::all_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__all_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::all_of(arg1, arg2, arg3);
}

void test__std__all_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::all_of(x, arg2, arg3);
}

void test__std__all_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::all_of(arg1, x, arg3);
}

void test__std__all_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::all_of(arg1, arg2, x);
}

void test__std__any_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::any_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__any_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::any_of(arg1, arg2, arg3);
}

void test__std__any_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::any_of(x, arg2, arg3);
}

void test__std__any_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::any_of(arg1, x, arg3);
}

void test__std__any_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::any_of(arg1, arg2, x);
}

void test__std__none_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::none_of(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__none_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::none_of(arg1, arg2, arg3);
}

void test__std__none_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::none_of(x, arg2, arg3);
}

void test__std__none_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::none_of(arg1, x, arg3);
}

void test__std__none_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::none_of(arg1, arg2, x);
}

void test__std__count__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::count(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__count__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::count(arg1, arg2, arg3);
}

void test__std__count__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::count(x, arg2, arg3);
}

void test__std__count__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::count(arg1, x, arg3);
}

void test__std__count__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::count(arg1, arg2, x);
}

void test__std__count_if__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::count_if(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__count_if__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::count_if(arg1, arg2, arg3);
}

void test__std__count_if__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::count_if(x, arg2, arg3);
}

void test__std__count_if__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::count_if(arg1, x, arg3);
}

void test__std__count_if__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::count_if(arg1, arg2, x);
}

void test__std__for_each__noreturn() {
  int x = 1;
  if (cond) { x=100; std::for_each(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__for_each__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::for_each(x, arg2, arg3);
}

void test__std__for_each__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::for_each(arg1, x, arg3);
}

void test__std__for_each__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::for_each(arg1, arg2, x);
}

void test__std__search_n__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::search_n(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__search_n__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::search_n(arg1, arg2, arg3, arg4, arg5);
}

void test__std__search_n__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::search_n(x, arg2, arg3, arg4, arg5);
}

void test__std__search_n__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::search_n(arg1, x, arg3, arg4, arg5);
}

void test__std__search_n__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::search_n(arg1, arg2, x, arg4, arg5);
}

void test__std__search_n__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::search_n(arg1, arg2, arg3, x, arg5);
}

void test__std__find_end__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::find_end(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__find_end__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::find_end(arg1, arg2, arg3, arg4, arg5);
}

void test__std__find_end__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_end(x, arg2, arg3, arg4, arg5);
}

void test__std__find_end__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_end(arg1, x, arg3, arg4, arg5);
}

void test__std__find_end__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_end(arg1, arg2, x, arg4, arg5);
}

void test__std__find_end__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_end(arg1, arg2, arg3, x, arg5);
}

void test__std__find_end__arg5__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = std::find_end(arg1, arg2, arg3, arg4, !x);
}

void test__std__find_end__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_end(arg1, arg2, arg3, arg4, x);
}

void test__std__find_first_of__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::find_first_of(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__find_first_of__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::find_first_of(arg1, arg2, arg3, arg4, arg5);
}

void test__std__find_first_of__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_first_of(x, arg2, arg3, arg4, arg5);
}

void test__std__find_first_of__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_first_of(arg1, x, arg3, arg4, arg5);
}

void test__std__find_first_of__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_first_of(arg1, arg2, x, arg4, arg5);
}

void test__std__find_first_of__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_first_of(arg1, arg2, arg3, x, arg5);
}

void test__std__find_first_of__arg5__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = std::find_first_of(arg1, arg2, arg3, arg4, !x);
}

void test__std__find_first_of__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::find_first_of(arg1, arg2, arg3, arg4, x);
}

void test__std__search__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::search(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__search__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::search(arg1, arg2, arg3, arg4, arg5);
}

void test__std__search__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::search(x, arg2, arg3, arg4, arg5);
}

void test__std__search__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::search(arg1, x, arg3, arg4, arg5);
}

void test__std__search__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::search(arg1, arg2, x, arg4, arg5);
}

void test__std__search__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::search(arg1, arg2, arg3, x, arg5);
}

void test__std__search__arg5__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  result = std::search(arg1, arg2, arg3, arg4, !x);
}

void test__std__search__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::search(arg1, arg2, arg3, arg4, x);
}

void test__std__inplace_merge__noreturn() {
  int x = 1;
  if (cond) { x=100; std::inplace_merge(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__inplace_merge__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::inplace_merge(x, arg2, arg3);
}

void test__std__inplace_merge__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::inplace_merge(arg1, x, arg3);
}

void test__std__inplace_merge__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  std::inplace_merge(arg1, arg2, x);
}

void test__std__equal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::equal(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__equal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::equal(arg1, arg2, arg3);
}

void test__std__equal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::equal(x, arg2, arg3);
}

void test__std__equal__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::equal(arg1, x, arg3);
}

void test__std__equal__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::equal(arg1, arg2, x);
}

void test__std__is_permutation__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::is_permutation(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__is_permutation__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::is_permutation(arg1, arg2, arg3);
}

void test__std__is_permutation__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::is_permutation(x, arg2, arg3);
}

void test__std__is_permutation__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::is_permutation(arg1, x, arg3);
}

void test__std__is_permutation__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::is_permutation(arg1, arg2, x);
}

void test__std__mismatch__noreturn() {
  int x = 1;
  if (cond) { x=100; result = std::mismatch(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__mismatch__useretval() {
  // cppcheck-suppress ignoredReturnValue
  std::mismatch(arg1, arg2, arg3);
}

void test__std__mismatch__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::mismatch(x, arg2, arg3);
}

void test__std__mismatch__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::mismatch(arg1, x, arg3);
}

void test__std__mismatch__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = std::mismatch(arg1, arg2, x);
}

void test__offsetof__noreturn() {
  int x = 1;
  if (cond) { x=100; result = offsetof(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__offsetof__useretval() {
  // cppcheck-suppress ignoredReturnValue
  offsetof(arg1, arg2);
}

void test__offsetof__leakignore() {
  char *p = malloc(10); *p=0;
  result = offsetof(p, arg2);
  // cppcheck-suppress memleak
}

