# Hey Emacs, this is a -*- shell-script -*- !!!  :-)

test_prog="ctdb_takeover_tests ctdb_takeover_run_core"

define_test ()
{
    _f=$(basename "$0" ".sh")

    export CTDB_IP_ALGORITHM="${_f%%.*}"
    case "$CTDB_IP_ALGORITHM" in
	lcp2|nondet|det) : ;;
	*) die "Unknown algorithm for testcase \"$_f\"" ;;
    esac

    printf "%-12s - %s\n" "$_f" "$1"
}

simple_test ()
{
    # Do some filtering of the output to replace date/time.
    if [ \( "$CTDB_IP_ALGORITHM" = "lcp2" -a -n "$CTDB_TEST_LOGLEVEL" \) -o \
	"$CTDB_IP_ALGORITHM" = "det" ] ; then
	OUT_FILTER='s@^.*:@DATE\ TIME\ \[PID\]:@'
    fi

    _states="$1"
    _out=$($VALGRIND $test_prog $_states 2>&1)

    result_check "Algorithm: $CTDB_IP_ALGORITHM"
}
