/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easymock.ArgumentsMatcher;
import org.easymock.IAnswer;
import org.easymock.IArgumentMatcher;
import org.easymock.MockControl;
import org.easymock.internal.ExpectedInvocation;
import org.easymock.internal.IMocksBehavior;
import org.easymock.internal.IMocksControlState;
import org.easymock.internal.Invocation;
import org.easymock.internal.LastControl;
import org.easymock.internal.MocksControl;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.RuntimeExceptionWrapper;

public class RecordState
implements IMocksControlState {
    private ExpectedInvocation lastInvocation;
    private boolean lastInvocationUsed = true;
    private Result lastResult;
    private IMocksBehavior behavior;
    private static Map<Class, Object> emptyReturnValues = new HashMap<Class, Object>();
    private static Map<Class, Class> primitiveToWrapperType;

    public RecordState(IMocksBehavior behavior) {
        this.behavior = behavior;
    }

    public void assertRecordState() {
    }

    public Object invoke(Invocation invocation) {
        this.closeMethod();
        List<IArgumentMatcher> lastMatchers = LastControl.pullMatchers();
        this.lastInvocation = new ExpectedInvocation(invocation, lastMatchers);
        this.lastInvocationUsed = false;
        return RecordState.emptyReturnValueFor(invocation.getMethod().getReturnType());
    }

    public void replay() {
        this.closeMethod();
        if (LastControl.pullMatchers() != null) {
            throw new IllegalStateException("matcher calls were not used outside expectations");
        }
    }

    public void verify() {
        throw new RuntimeExceptionWrapper(new IllegalStateException("calling verify is not allowed in record state"));
    }

    public void andReturn(Object value) {
        this.requireMethodCall("return value");
        value = this.convertNumberClassIfNeccessary(value);
        this.requireAssignable(value);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.lastResult = Result.createReturnResult(value);
    }

    public void andThrow(Throwable throwable) {
        this.requireMethodCall("Throwable");
        this.requireValidThrowable(throwable);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.lastResult = Result.createThrowResult(throwable);
    }

    public void andAnswer(IAnswer answer) {
        this.requireMethodCall("answer");
        this.requireValidAnswer(answer);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.lastResult = Result.createAnswerResult(answer);
    }

    public void andStubReturn(Object value) {
        this.requireMethodCall("stub return value");
        value = this.convertNumberClassIfNeccessary(value);
        this.requireAssignable(value);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.behavior.addStub(this.lastInvocation, Result.createReturnResult(value));
        this.lastInvocationUsed = true;
    }

    public void setDefaultReturnValue(Object value) {
        this.requireMethodCall("default return value");
        value = this.convertNumberClassIfNeccessary(value);
        this.requireAssignable(value);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.behavior.addStub(this.lastInvocation.withMatcher(MockControl.ALWAYS_MATCHER), Result.createReturnResult(value));
        this.lastInvocationUsed = true;
    }

    public void asStub() {
        this.requireMethodCall("stub behavior");
        this.requireVoidMethod();
        this.behavior.addStub(this.lastInvocation, Result.createReturnResult(null));
        this.lastInvocationUsed = true;
    }

    public void setDefaultVoidCallable() {
        this.requireMethodCall("default void callable");
        this.requireVoidMethod();
        this.behavior.addStub(this.lastInvocation.withMatcher(MockControl.ALWAYS_MATCHER), Result.createReturnResult(null));
        this.lastInvocationUsed = true;
    }

    public void andStubThrow(Throwable throwable) {
        this.requireMethodCall("stub Throwable");
        this.requireValidThrowable(throwable);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.behavior.addStub(this.lastInvocation, Result.createThrowResult(throwable));
        this.lastInvocationUsed = true;
    }

    public void setDefaultThrowable(Throwable throwable) {
        this.requireMethodCall("default Throwable");
        this.requireValidThrowable(throwable);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.behavior.addStub(this.lastInvocation.withMatcher(MockControl.ALWAYS_MATCHER), Result.createThrowResult(throwable));
        this.lastInvocationUsed = true;
    }

    public void andStubAnswer(IAnswer answer) {
        this.requireMethodCall("stub answer");
        this.requireValidAnswer(answer);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.behavior.addStub(this.lastInvocation, Result.createAnswerResult(answer));
        this.lastInvocationUsed = true;
    }

    public void times(Range range) {
        this.requireMethodCall("times");
        this.requireLastResultOrVoidMethod();
        this.behavior.addExpected(this.lastInvocation, this.lastResult != null ? this.lastResult : Result.createReturnResult(null), range);
        this.lastInvocationUsed = true;
        this.lastResult = null;
    }

    private Object createNumberObject(Object value, Class returnType) {
        if (!(value instanceof Number)) {
            return value;
        }
        Number number = (Number)value;
        if (returnType.equals(Byte.TYPE)) {
            return number.byteValue();
        }
        if (returnType.equals(Short.TYPE)) {
            return number.shortValue();
        }
        if (returnType.equals(Character.TYPE)) {
            return Character.valueOf((char)number.intValue());
        }
        if (returnType.equals(Integer.TYPE)) {
            return number.intValue();
        }
        if (returnType.equals(Long.TYPE)) {
            return number.longValue();
        }
        if (returnType.equals(Float.TYPE)) {
            return Float.valueOf(number.floatValue());
        }
        if (returnType.equals(Double.TYPE)) {
            return number.doubleValue();
        }
        return number;
    }

    private Object convertNumberClassIfNeccessary(Object o) {
        Class<?> returnType = this.lastInvocation.getMethod().getReturnType();
        return this.createNumberObject(o, returnType);
    }

    private void closeMethod() {
        if (this.lastInvocationUsed && this.lastResult == null) {
            return;
        }
        if (!this.isLastResultOrVoidMethod()) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("missing behavior definition for the preceeding method call " + this.lastInvocation.toString()));
        }
        this.times(MockControl.ONE);
    }

    public static Object emptyReturnValueFor(Class type) {
        return type.isPrimitive() ? emptyReturnValues.get(type) : null;
    }

    private void requireMethodCall(String failMessage) {
        if (this.lastInvocation == null) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("method call on the mock needed before setting " + failMessage));
        }
    }

    private void requireAssignable(Object returnValue) {
        if (this.lastMethodIsVoidMethod()) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("void method cannot return a value"));
        }
        if (returnValue == null) {
            return;
        }
        Class returnedType = this.lastInvocation.getMethod().getReturnType();
        if (returnedType.isPrimitive()) {
            returnedType = primitiveToWrapperType.get(returnedType);
        }
        if (!returnedType.isAssignableFrom(returnValue.getClass())) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("incompatible return value type"));
        }
    }

    private void requireValidThrowable(Throwable throwable) {
        if (throwable == null) {
            throw new RuntimeExceptionWrapper(new NullPointerException("null cannot be thrown"));
        }
        if (this.isValidThrowable(throwable)) {
            return;
        }
        throw new RuntimeExceptionWrapper(new IllegalArgumentException("last method called on mock cannot throw " + throwable.getClass().getName()));
    }

    private void requireValidAnswer(IAnswer answer) {
        if (answer == null) {
            throw new RuntimeExceptionWrapper(new NullPointerException("answer object must not be null"));
        }
    }

    private void requireLastResultOrVoidMethod() {
        if (this.isLastResultOrVoidMethod()) {
            return;
        }
        throw new RuntimeExceptionWrapper(new IllegalStateException("last method called on mock is not a void method"));
    }

    private void requireVoidMethod() {
        if (this.lastMethodIsVoidMethod()) {
            return;
        }
        throw new RuntimeExceptionWrapper(new IllegalStateException("last method called on mock is not a void method"));
    }

    private boolean isLastResultOrVoidMethod() {
        return this.lastResult != null || this.lastMethodIsVoidMethod();
    }

    private boolean lastMethodIsVoidMethod() {
        Class<?> returnType = this.lastInvocation.getMethod().getReturnType();
        return returnType.equals(Void.TYPE);
    }

    private boolean isValidThrowable(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return true;
        }
        if (throwable instanceof Error) {
            return true;
        }
        Class<?>[] exceptions = this.lastInvocation.getMethod().getExceptionTypes();
        Class<?> throwableClass = throwable.getClass();
        for (Class<?> exception : exceptions) {
            if (!exception.isAssignableFrom(throwableClass)) continue;
            return true;
        }
        return false;
    }

    public void checkOrder(boolean value) {
        this.closeMethod();
        this.behavior.checkOrder(value);
    }

    public void setDefaultMatcher(ArgumentsMatcher matcher) {
        this.behavior.setDefaultMatcher(matcher);
    }

    public void setMatcher(Method method, ArgumentsMatcher matcher) {
        this.requireMethodCall("matcher");
        this.behavior.setMatcher(this.lastInvocation.getMethod(), matcher);
    }

    static {
        emptyReturnValues.put(Void.TYPE, null);
        emptyReturnValues.put(Boolean.TYPE, Boolean.FALSE);
        emptyReturnValues.put(Byte.TYPE, new Byte(0));
        emptyReturnValues.put(Short.TYPE, new Short(0));
        emptyReturnValues.put(Character.TYPE, new Character('\u0000'));
        emptyReturnValues.put(Integer.TYPE, new Integer(0));
        emptyReturnValues.put(Long.TYPE, new Long(0L));
        emptyReturnValues.put(Float.TYPE, new Float(0.0f));
        emptyReturnValues.put(Double.TYPE, new Double(0.0));
        primitiveToWrapperType = new HashMap<Class, Class>();
        primitiveToWrapperType.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapperType.put(Byte.TYPE, Byte.class);
        primitiveToWrapperType.put(Short.TYPE, Short.class);
        primitiveToWrapperType.put(Character.TYPE, Character.class);
        primitiveToWrapperType.put(Integer.TYPE, Integer.class);
        primitiveToWrapperType.put(Long.TYPE, Long.class);
        primitiveToWrapperType.put(Float.TYPE, Float.class);
        primitiveToWrapperType.put(Double.TYPE, Double.class);
    }
}

