/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv;

import java.util.Hashtable;
import org.apache.xerces.impl.dv.DVFactoryException;
import org.apache.xerces.impl.dv.DatatypeValidator;

public abstract class DTDDVFactory {
    private static final String DEFAULT_FACTORY_CLASS = "org.apache.xerces.impl.dv.dtd.DTDDVFactoryImpl";

    public static final synchronized DTDDVFactory getInstance() throws DVFactoryException {
        return DTDDVFactory.getInstance(DEFAULT_FACTORY_CLASS);
    }

    public static final synchronized DTDDVFactory getInstance(String string) throws DVFactoryException {
        try {
            return (DTDDVFactory)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DVFactoryException("DTD factory class " + string + " not found.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DVFactoryException("DTD factory class " + string + " found but cannot be loaded.");
        }
        catch (InstantiationException instantiationException) {
            throw new DVFactoryException("DTD factory class " + string + " loaded but cannot be instantiated (no empty public constructor?).");
        }
        catch (ClassCastException classCastException) {
            throw new DVFactoryException("DTD factory class " + string + " does not extend from DTDDVFactory.");
        }
    }

    protected DTDDVFactory() {
    }

    public abstract DatatypeValidator getBuiltInDV(String var1);

    public abstract Hashtable getBuiltInTypes();
}

