/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class StreamHandler {
    private File base = null;

    public StreamHandler(String string) throws IOException {
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        this.base = new File(string).getCanonicalFile();
        if (!this.base.isDirectory()) {
            this.mkdir(this.base);
        }
    }

    public OutputStream getOutputStream(String string) throws IOException {
        File file = new File(string);
        if (file.isAbsolute()) {
            return new FileOutputStream(file);
        }
        if (file.getParent() != null) {
            this.mkdir(new File(this.base, file.getParent()));
        }
        return new FileOutputStream(new File(this.base, string));
    }

    private void mkdir(File file) throws IOException {
        if (file == null) {
            return;
        }
        this.mkdir(file.getParentFile());
        if (file.isDirectory()) {
            return;
        }
        file.mkdir();
    }
}

