/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.collect.EmptyImmutableMap;
import org.python.google.common.collect.ImmutableCollection;
import org.python.google.common.collect.ImmutableMapKeySet;
import org.python.google.common.collect.ImmutableMapValues;
import org.python.google.common.collect.ImmutableSet;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.Maps;
import org.python.google.common.collect.RegularImmutableMap;
import org.python.google.common.collect.SingletonImmutableMap;

public abstract class ImmutableMap<K, V>
implements Serializable,
Map<K, V> {
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;

    public static <K, V> ImmutableMap<K, V> of() {
        return EmptyImmutableMap.INSTANCE;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        CharMatcher.LookupTable.checkNotNull(key, "null key in entry: null=%s", value);
        CharMatcher.LookupTable.checkNotNull(value, "null value in entry: %s=null", key);
        return Maps.immutableEntry(key, value);
    }

    ImmutableMap() {
    }

    @Override
    public final V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return value != null && Maps.containsValueImpl(this, value);
    }

    @Override
    public abstract V get(@Nullable Object var1);

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> result = this.entrySet;
        if (result == null) {
            this.entrySet = this.createEntrySet();
            return this.entrySet;
        }
        return result;
    }

    abstract ImmutableSet<Map.Entry<K, V>> createEntrySet();

    @Override
    public ImmutableSet<K> keySet() {
        ImmutableSet<K> result = this.keySet;
        if (result == null) {
            this.keySet = this.createKeySet();
            return this.keySet;
        }
        return result;
    }

    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet<K, V>(this, (ImmutableSet)this.entrySet()){
            private /* synthetic */ ImmutableMap this$0;
            {
                this.this$0 = immutableMap;
                super(x0);
            }

            @Override
            final ImmutableMap<K, V> map() {
                return this.this$0;
            }
        };
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> result = this.values;
        if (result == null) {
            this.values = this.createValues();
            return this.values;
        }
        return result;
    }

    ImmutableCollection<V> createValues() {
        return new ImmutableMapValues<K, V>(this){
            private /* synthetic */ ImmutableMap this$0;
            {
                this.this$0 = immutableMap;
            }

            @Override
            final ImmutableMap<K, V> map() {
                return this.this$0;
            }
        };
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return Maps.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return ((ImmutableSet)this.entrySet()).hashCode();
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }

    public static final class Builder<K, V> {
        private ArrayList<Map.Entry<K, V>> entries = new ArrayList();

        public final Builder<K, V> put(K key, V value) {
            this.entries.add(ImmutableMap.entryOf(key, value));
            return this;
        }

        public final ImmutableMap<K, V> build() {
            ArrayList<Map.Entry<K, V>> arrayList = this.entries;
            int n = arrayList.size();
            switch (n) {
                case 0: {
                    return ImmutableMap.of();
                }
                case 1: {
                    ArrayList<Map.Entry<K, V>> arrayList2 = arrayList;
                    return new SingletonImmutableMap((Map.Entry)Iterators.getOnlyElement(arrayList2.iterator()));
                }
            }
            Map.Entry[] entryArray = arrayList.toArray(new Map.Entry[arrayList.size()]);
            return new RegularImmutableMap(entryArray);
        }
    }
}

