/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.distribution;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.regex.Pattern;
import net.grinder.console.communication.DistributionControl;
import net.grinder.console.communication.ProcessControl;
import net.grinder.console.distribution.AgentCacheState;
import net.grinder.console.distribution.AgentCacheStateImplementation;
import net.grinder.console.distribution.AgentSet;
import net.grinder.console.distribution.CacheParameters;
import net.grinder.console.distribution.FileChangeWatcher;
import net.grinder.console.distribution.FileDistribution;
import net.grinder.console.distribution.FileDistributionHandler;
import net.grinder.console.distribution.FileDistributionHandlerImplementation;
import net.grinder.console.distribution.UpdateableAgentCacheState;
import net.grinder.util.Directory;
import net.grinder.util.ListenerSupport;

public final class FileDistributionImplementation
implements FileDistribution {
    private static final String PRIVATE_DIRECTORY_NAME = ".grinder";
    private final ListenerSupport m_filesChangedListeners = new ListenerSupport();
    private final DistributionControl m_distributionControl;
    private final UpdateableAgentCacheState m_cacheState;
    private volatile long m_lastScanTime;

    public FileDistributionImplementation(DistributionControl distributionControl, ProcessControl processControl, Directory directory, Pattern distributionFileFilterPattern) {
        this(distributionControl, new AgentCacheStateImplementation(processControl, directory, distributionFileFilterPattern));
    }

    FileDistributionImplementation(DistributionControl distributionControl, UpdateableAgentCacheState agentCacheState) {
        this.m_distributionControl = distributionControl;
        this.m_cacheState = agentCacheState;
    }

    public void setDirectory(Directory directory) {
        this.m_lastScanTime = -1L;
        this.m_cacheState.setDirectory(directory);
    }

    public void setFileFilterPattern(Pattern distributionFileFilterPattern) {
        this.m_lastScanTime = -1L;
        this.m_cacheState.setFileFilterPattern(distributionFileFilterPattern);
    }

    public AgentCacheState getAgentCacheState() {
        return this.m_cacheState;
    }

    public FileDistributionHandler getHandler() {
        this.scanDistributionFiles();
        AgentSet agents = this.m_cacheState.getAgentSet();
        CacheParameters cacheParameters = this.m_cacheState.getCacheParameters();
        return new FileDistributionHandlerImplementation(cacheParameters, cacheParameters.getDirectory().getFile(), cacheParameters.getDirectory().listContents(new FixedPatternFileFilter(agents.getEarliestAgentTime(), cacheParameters.getFileFilterPattern())), this.m_distributionControl, agents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanDistributionFiles() {
        Object temporaryFile;
        long scanTime = this.m_lastScanTime;
        CacheParameters cacheParameters = this.m_cacheState.getCacheParameters();
        try {
            File privateDirectory = new File(cacheParameters.getDirectory().getFile(), PRIVATE_DIRECTORY_NAME);
            privateDirectory.mkdir();
            privateDirectory.deleteOnExit();
            temporaryFile = File.createTempFile(".scantime", "", privateDirectory);
            ((File)temporaryFile).deleteOnExit();
            FileDistributionImplementation fileDistributionImplementation = this;
            synchronized (fileDistributionImplementation) {
                this.m_lastScanTime = ((File)temporaryFile).lastModified();
            }
            ((File)temporaryFile).delete();
        }
        catch (IOException e) {
            temporaryFile = this;
            synchronized (temporaryFile) {
                this.m_lastScanTime = System.currentTimeMillis() - 1000L;
            }
        }
        File[] laterFiles = cacheParameters.getDirectory().listContents(new FixedPatternFileFilter(scanTime, cacheParameters.getFileFilterPattern()), true, true);
        if (laterFiles.length > 0) {
            HashSet<File> changedFiles = new HashSet<File>(laterFiles.length / 2);
            for (int i = 0; i < laterFiles.length; ++i) {
                File laterFile = laterFiles[i];
                if (laterFile.isDirectory() && laterFile.lastModified() < scanTime) continue;
                if (laterFile.isFile()) {
                    this.m_cacheState.setNewFileTime(laterFile.lastModified());
                }
                changedFiles.add(laterFile);
            }
            final File[] changedFilesArray = changedFiles.toArray(new File[changedFiles.size()]);
            this.m_filesChangedListeners.apply(new ListenerSupport.Informer(){

                public void inform(Object listener) {
                    ((FileChangeWatcher.FileChangedListener)listener).filesChanged(changedFilesArray);
                }
            });
        }
    }

    public void addFileChangedListener(FileChangeWatcher.FileChangedListener listener) {
        this.m_filesChangedListeners.add(listener);
    }

    public FileFilter getDistributionFileFilter() {
        return new AbstractFileFilter(-1L){

            protected Pattern getFileFilterPattern() {
                return FileDistributionImplementation.this.m_cacheState.getCacheParameters().getFileFilterPattern();
            }
        };
    }

    static final class FixedPatternFileFilter
    extends AbstractFileFilter {
        private final Pattern m_pattern;

        public FixedPatternFileFilter(long earliestTime, Pattern pattern) {
            super(earliestTime);
            this.m_pattern = pattern;
        }

        protected Pattern getFileFilterPattern() {
            return this.m_pattern;
        }
    }

    private static abstract class AbstractFileFilter
    implements FileFilter {
        private final long m_earliestTime;

        protected AbstractFileFilter(long earliestTime) {
            this.m_earliestTime = earliestTime;
        }

        public final boolean accept(File file) {
            String name = file.getName();
            Pattern pattern = this.getFileFilterPattern();
            if (file.isDirectory()) {
                File readmeFile;
                if (name.equals(FileDistributionImplementation.PRIVATE_DIRECTORY_NAME)) {
                    return false;
                }
                if (name.endsWith("-file-store") && (readmeFile = new File(file, "README.txt")).isFile()) {
                    return false;
                }
                return !pattern.matcher(name + "/").matches();
            }
            if (pattern.matcher(name).matches()) {
                return false;
            }
            return file.lastModified() >= this.m_earliestTime;
        }

        protected abstract Pattern getFileFilterPattern();
    }
}

