/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.io.PrintWriter;
import net.grinder.common.Logger;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextLocator;

final class ExternalLogger
implements Logger {
    private final Logger m_processLogger;
    private final ThreadContextLocator m_threadContextLocator;

    public ExternalLogger(Logger processLogger, ThreadContextLocator threadContextLocator) {
        this.m_processLogger = processLogger;
        this.m_threadContextLocator = threadContextLocator;
    }

    public void output(String message, int where) {
        this.getLogger().output(message, where);
    }

    public void output(String message) {
        this.getLogger().output(message);
    }

    public void error(String message, int where) {
        this.getLogger().error(message, where);
    }

    public void error(String message) {
        this.getLogger().error(message);
    }

    public PrintWriter getOutputLogWriter() {
        return this.getLogger().getOutputLogWriter();
    }

    public PrintWriter getErrorLogWriter() {
        return this.getLogger().getErrorLogWriter();
    }

    private Logger getLogger() {
        ThreadContext threadContext = this.m_threadContextLocator.get();
        if (threadContext != null) {
            return threadContext.getThreadLogger();
        }
        return this.m_processLogger;
    }
}

