/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public final class EndPoint
implements Comparable {
    private final String m_host;
    private final int m_port;
    private final int m_hashCode;

    public EndPoint(String host, int port) {
        this.m_host = host.toLowerCase();
        this.m_port = port;
        this.m_hashCode = this.m_host.hashCode() ^ this.m_port;
    }

    public EndPoint(InetAddress address, int port) {
        this(address.getHostName(), port);
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != EndPoint.class) {
            return false;
        }
        EndPoint otherEndPoint = (EndPoint)other;
        return this.hashCode() == otherEndPoint.hashCode() && this.getPort() == otherEndPoint.getPort() && this.getHost().equals(otherEndPoint.getHost());
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public String toString() {
        return this.m_host + ":" + this.m_port;
    }

    public int compareTo(Object other) {
        EndPoint otherEndPoint = (EndPoint)other;
        int c = this.getHost().compareTo(otherEndPoint.getHost());
        if (c != 0) {
            return c;
        }
        return this.getPort() - otherEndPoint.getPort();
    }

    public static EndPoint clientEndPoint(Socket socket) {
        return new EndPoint(socket.getInetAddress(), socket.getPort());
    }

    public static EndPoint serverEndPoint(ServerSocket socket) {
        return new EndPoint(socket.getInetAddress(), socket.getLocalPort());
    }
}

