/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.unixp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.jvnet.process_factory.AbstractProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnixProcess
extends AbstractProcess {
    public UnixProcess(int pid) {
        super(pid);
    }

    public UnixProcess(Process p) throws Exception {
        super(UnixProcess.getPid(p));
    }

    private static int getPid(Process process) throws Exception {
        if (process.getClass().getName().equals("java.lang.UNIXProcess")) {
            try {
                Field f = process.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                return f.getInt(process);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unable to get PID. Process class: " + process.getClass());
    }

    @Override
    public void killRecursively() throws IOException {
        UnixProcess.killRecursively(this.pid);
    }

    @Override
    public void kill() throws IOException {
        UnixProcess.runAndGetOutput("kill", "-KILL", Integer.toString(this.pid));
    }

    private static void killRecursively(int pid, LinkedHashSet<Integer> listed) throws IOException {
        listed.add(pid);
        UnixProcess.runAndGetOutput("kill", "-stop", Integer.toString(pid));
        Output outputPGrep = UnixProcess.runAndGetOutput("pgrep", "-P", Integer.toString(pid));
        if (outputPGrep.stderr != null && outputPGrep.stderr.length() > 0) {
            throw new RuntimeException(outputPGrep.stderr);
        }
        UnixProcess.runAndGetOutput("kill", "-KILL", Integer.toString(pid));
        String ids = outputPGrep.stdout;
        StringTokenizer strTok = new StringTokenizer(ids);
        while (strTok.hasMoreTokens()) {
            String nextToken = strTok.nextToken();
            int found = Integer.parseInt(nextToken);
            if (listed.contains(found)) continue;
            UnixProcess.killRecursively(found, listed);
        }
    }

    private static LinkedHashSet<Integer> killRecursively(int pid) throws IOException {
        LinkedHashSet<Integer> listed = new LinkedHashSet<Integer>();
        UnixProcess.killRecursively(pid, listed);
        return listed;
    }

    private static Output runAndGetOutput(String ... cmdarray) throws IOException {
        Process createProcess = Runtime.getRuntime().exec(cmdarray, null, null);
        return UnixProcess.getProcessOutput(createProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Output getProcessOutput(Process process) throws IOException {
        try {
            process.getOutputStream().close();
        }
        catch (IOException e2) {
            // empty catch block
        }
        InputStreamReader inputStream = new InputStreamReader(new BufferedInputStream(process.getInputStream()));
        InputStreamReader errorStream = new InputStreamReader(new BufferedInputStream(process.getErrorStream()));
        try {
            process.waitFor();
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        try {
            Object sync;
            Object object = sync = new Object();
            synchronized (object) {
                sync.wait(10L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Output(UnixProcess.readInputStream(inputStream), UnixProcess.readInputStream(errorStream));
    }

    private static String readInputStream(InputStreamReader in) throws IOException {
        int c;
        StringBuffer contents = new StringBuffer();
        char[] buf = new char[80];
        while ((c = in.read(buf)) != -1) {
            contents.append(buf, 0, c);
        }
        return contents.toString();
    }

    private static class Output {
        public final String stdout;
        public final String stderr;

        public Output(String stdout, String stderr) {
            this.stdout = stdout;
            this.stderr = stderr;
        }
    }
}

