/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Function;
import org.python.google.common.base.Joiner;
import org.python.google.common.collect.AbstractIndexedListIterator;
import org.python.google.common.collect.TransformedIterator;
import org.python.google.common.collect.UnmodifiableIterator;
import org.python.google.common.collect.UnmodifiableListIterator;

public final class Iterators {
    static final UnmodifiableListIterator<Object> EMPTY_LIST_ITERATOR = new UnmodifiableListIterator<Object>(){

        @Override
        public final boolean hasNext() {
            return false;
        }

        @Override
        public final Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public final boolean hasPrevious() {
            return false;
        }

        @Override
        public final Object previous() {
            throw new NoSuchElementException();
        }

        @Override
        public final int nextIndex() {
            return 0;
        }

        @Override
        public final int previousIndex() {
            return -1;
        }
    };

    public static <T> UnmodifiableIterator<T> emptyIterator() {
        return EMPTY_LIST_ITERATOR;
    }

    public static boolean contains(Iterator<?> iterator, @Nullable Object element) {
        if (element == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!element.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean elementsEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext()) {
            Object o2;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object o1 = iterator1.next();
            if (CharMatcher.LookupTable.equal(o1, o2 = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static String toString(Iterator<?> iterator) {
        return Joiner.on(", ").useForNull("null").appendTo(new StringBuilder("["), iterator).append(']').toString();
    }

    public static <T> T getOnlyElement(Iterator<T> iterator) {
        T first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("expected one element but was: <" + first);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            sb.append(", " + iterator.next());
        }
        if (iterator.hasNext()) {
            sb.append(", ...");
        }
        sb.append('>');
        throw new IllegalArgumentException(sb.toString());
    }

    public static <F, T> Iterator<T> transform(Iterator<F> fromIterator, Function<? super F, ? extends T> function) {
        CharMatcher.LookupTable.checkNotNull(function);
        return new TransformedIterator<F, T>(fromIterator, function){
            private /* synthetic */ Function val$function;
            {
                this.val$function = function;
                super(x0);
            }

            @Override
            final T transform(F from) {
                return this.val$function.apply(from);
            }
        };
    }

    static <T> UnmodifiableListIterator<T> forArray(T[] array, int offset, int length, int index) {
        CharMatcher.LookupTable.checkArgument(length >= 0);
        int end = offset + length;
        CharMatcher.LookupTable.checkPositionIndexes(offset, end, array.length);
        return new AbstractIndexedListIterator<T>(length, index, array, offset){
            private /* synthetic */ Object[] val$array;
            private /* synthetic */ int val$offset;
            {
                this.val$array = objectArray;
                this.val$offset = n;
                super(x0, x1);
            }

            @Override
            protected final T get(int index) {
                return this.val$array[this.val$offset + index];
            }
        };
    }

    public static <T> UnmodifiableIterator<T> singletonIterator(@Nullable T value) {
        return new UnmodifiableIterator<T>(value){
            private boolean done;
            private /* synthetic */ Object val$value;
            {
                this.val$value = object;
            }

            @Override
            public final boolean hasNext() {
                return !this.done;
            }

            @Override
            public final T next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return this.val$value;
            }
        };
    }

    static {
        new Iterator<Object>(){

            @Override
            public final boolean hasNext() {
                return false;
            }

            @Override
            public final Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public final void remove() {
                throw new IllegalStateException();
            }
        };
    }
}

