/*
 * Decompiled with CFR 0.152.
 */
package net.grinder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.grinder.common.Logger;
import net.grinder.plugin.http.tcpproxyfilter.ProcessHTTPRecordingWithXSLT;
import net.grinder.tools.tcpproxy.CommentSourceImplementation;
import net.grinder.tools.tcpproxy.CompositeFilter;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import net.grinder.tools.tcpproxy.EndPoint;
import net.grinder.tools.tcpproxy.HTTPProxyTCPProxyEngine;
import net.grinder.tools.tcpproxy.PortForwarderTCPProxyEngine;
import net.grinder.tools.tcpproxy.TCPProxyConsole;
import net.grinder.tools.tcpproxy.TCPProxyEngine;
import net.grinder.tools.tcpproxy.TCPProxyFilter;
import net.grinder.tools.tcpproxy.TCPProxySSLSocketFactoryImplementation;
import net.grinder.tools.tcpproxy.TCPProxySocketFactory;
import net.grinder.util.AbstractMainClass;
import net.grinder.util.FixedWidthFormatter;
import net.grinder.util.SimpleLogger;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.monitors.WriterComponentMonitor;

public final class TCPProxy
extends AbstractMainClass {
    private static final String USAGE = "\n  java " + TCPProxy.class + " <options>" + "\n\n" + "Commonly used options:" + "\n  [-http [<stylesheet>]]       See below." + "\n  [-console]                   Display the console." + "\n  [-requestfilter <filter>]    Add a request filter." + "\n  [-responsefilter <filter>]   Add a response filter." + "\n  [-localhost <host name/ip>]  Default is localhost." + "\n  [-localport <port>]          Default is 8001." + "\n  [-keystore <file>]           Key store details for" + "\n  [-keystorepassword <pass>]   SSL certificates." + "\n  [-keystoretype <type>]       Default is JSSE dependent." + "\n\n" + "Other options:" + "\n  [-properties <file>]         Properties to pass to the filters." + "\n  [-remotehost <host name>]    Default is localhost." + "\n  [-remoteport <port>]         Default is 7001." + "\n  [-timeout <seconds>]         Proxy engine timeout." + "\n  [-httpproxy <host> <port>]   Route via HTTP/HTTPS proxy." + "\n  [-httpsproxy <host> <port>]  Override -httpproxy settings for" + "\n                               HTTPS." + "\n  [-ssl]                       Use SSL when port forwarding." + "\n  [-colour]                    Be pretty on ANSI terminals." + "\n  [-component <class>]         Register a component class with" + "\n                               the filter PicoContainer." + "\n  [-debug]                     Make PicoContainer chatty." + "\n\n" + "<filter> is the name of a class that implements " + TCPProxyFilter.class.getName() + " or one of NONE, ECHO. The default " + "is ECHO. Multiple filters can be specified for each stream." + "\n\n" + "By default, the TCPProxy listens as an HTTP/HTTPS Proxy on " + "<localhost:localport>." + "\n\n" + "If either -remotehost or -remoteport is specified, the TCPProxy " + "acts a simple port forwarder between <localhost:localport> and " + "<remotehost:remoteport>. Specify -ssl for SSL support." + "\n\n" + "-http sets up request and response filters to produce a test script " + "suitable for use with the HTTP plugin. The output can be customised " + "by specifying the file name of an alternative XSLT style sheet." + "\n\n" + "-timeout is how long the TCPProxy will wait for a request " + "before timing out and freeing the local port. The TCPProxy will " + "not time out if there are active connections." + "\n\n" + "-console displays a simple control window that allows the TCPProxy " + "to be shutdown cleanly. This is needed because some shells, e.g. " + "Cygwin bash, do not allow Java processes to be interrupted cleanly, " + "so filters cannot rely on standard shutdown hooks. " + "\n\n" + "-httpproxy and -httpsproxy allow output to be directed through " + "another HTTP/HTTPS proxy; this may help you reach the Internet. " + "These options are not supported in port forwarding mode." + "\n\n" + "Typical usage: " + "\n  java " + TCPProxy.class + " -http -console > grinder.py" + "\n\n";
    private final DefaultPicoContainer m_filterContainer = new DefaultPicoContainer();
    private final TCPProxyEngine m_proxyEngine;
    static /* synthetic */ Class class$net$grinder$plugin$http$tcpproxyfilter$HTTPRequestFilter;
    static /* synthetic */ Class class$net$grinder$plugin$http$tcpproxyfilter$HTTPResponseFilter;
    static /* synthetic */ Class class$net$grinder$util$AttributeStringParserImplementation;
    static /* synthetic */ Class class$net$grinder$plugin$http$tcpproxyfilter$ConnectionCache;
    static /* synthetic */ Class class$net$grinder$plugin$http$tcpproxyfilter$ConnectionHandlerFactoryImplementation;
    static /* synthetic */ Class class$net$grinder$plugin$http$tcpproxyfilter$HTTPRecordingImplementation;
    static /* synthetic */ Class class$net$grinder$plugin$http$tcpproxyfilter$ProcessHTTPRecordingWithXSLT;
    static /* synthetic */ Class class$net$grinder$plugin$http$tcpproxyfilter$RegularExpressionsImplementation;
    static /* synthetic */ Class class$net$grinder$util$URIParserImplementation;
    static /* synthetic */ Class class$net$grinder$util$SimpleStringEscaper;
    static /* synthetic */ Class class$net$grinder$tools$tcpproxy$NullFilter;
    static /* synthetic */ Class class$net$grinder$tools$tcpproxy$EchoFilter;

    public static void main(String[] args) {
        SimpleLogger logger = new SimpleLogger("tcpproxy", new PrintWriter(System.out), new PrintWriter(System.err), new FixedWidthFormatter(0, 10, 80));
        try {
            TCPProxy tcpProxy = new TCPProxy(args, logger);
            tcpProxy.run();
        }
        catch (AbstractMainClass.LoggedInitialisationException e) {
            System.exit(1);
        }
        catch (Throwable e) {
            logger.error("Could not initialise:");
            PrintWriter errorWriter = logger.getErrorLogWriter();
            e.printStackTrace(errorWriter);
            errorWriter.flush();
            System.exit(2);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCPProxy(String[] args, Logger logger) throws Exception {
        super(logger, USAGE);
        this.m_filterContainer.registerComponentInstance((Object)logger);
        CommentSourceImplementation commentSource = new CommentSourceImplementation();
        this.m_filterContainer.registerComponentInstance((Object)commentSource);
        int localPort = 8001;
        String remoteHost = "localhost";
        String localHost = "localhost";
        int remotePort = 7001;
        boolean useSSLPortForwarding = false;
        File keyStoreFile = null;
        char[] keyStorePassword = null;
        String keyStoreType = null;
        boolean isHTTPProxy = true;
        boolean console = false;
        EndPoint chainedHTTPProxy = null;
        EndPoint chainedHTTPSProxy = null;
        int timeout = 0;
        boolean useColour = false;
        FilterChain requestFilterChain = new FilterChain("request");
        FilterChain responseFilterChain = new FilterChain("response");
        try {
            int i;
            for (i = 0; i < args.length; ++i) {
                if (!args[i].equalsIgnoreCase("-properties")) continue;
                Properties properties = new Properties();
                FileInputStream in = new FileInputStream(new File(args[++i]));
                try {
                    properties.load(in);
                }
                finally {
                    in.close();
                }
                System.getProperties().putAll((Map<?, ?>)properties);
            }
            for (i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-requestfilter")) {
                    requestFilterChain.add(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-responsefilter")) {
                    responseFilterChain.add(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-component")) {
                    Class<?> componentClass;
                    try {
                        componentClass = Class.forName(args[++i]);
                    }
                    catch (ClassNotFoundException e) {
                        throw this.barfError("class '" + args[i] + "' not found.");
                    }
                    this.m_filterContainer.registerComponentImplementation(componentClass);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-http")) {
                    requestFilterChain.add(class$net$grinder$plugin$http$tcpproxyfilter$HTTPRequestFilter == null ? TCPProxy.class$("net.grinder.plugin.http.tcpproxyfilter.HTTPRequestFilter") : class$net$grinder$plugin$http$tcpproxyfilter$HTTPRequestFilter);
                    responseFilterChain.add(class$net$grinder$plugin$http$tcpproxyfilter$HTTPResponseFilter == null ? TCPProxy.class$("net.grinder.plugin.http.tcpproxyfilter.HTTPResponseFilter") : class$net$grinder$plugin$http$tcpproxyfilter$HTTPResponseFilter);
                    this.m_filterContainer.registerComponentImplementation(class$net$grinder$util$AttributeStringParserImplementation == null ? TCPProxy.class$("net.grinder.util.AttributeStringParserImplementation") : class$net$grinder$util$AttributeStringParserImplementation);
                    this.m_filterContainer.registerComponentImplementation(class$net$grinder$plugin$http$tcpproxyfilter$ConnectionCache == null ? TCPProxy.class$("net.grinder.plugin.http.tcpproxyfilter.ConnectionCache") : class$net$grinder$plugin$http$tcpproxyfilter$ConnectionCache);
                    this.m_filterContainer.registerComponentImplementation(class$net$grinder$plugin$http$tcpproxyfilter$ConnectionHandlerFactoryImplementation == null ? TCPProxy.class$("net.grinder.plugin.http.tcpproxyfilter.ConnectionHandlerFactoryImplementation") : class$net$grinder$plugin$http$tcpproxyfilter$ConnectionHandlerFactoryImplementation);
                    this.m_filterContainer.registerComponentImplementation(class$net$grinder$plugin$http$tcpproxyfilter$HTTPRecordingImplementation == null ? TCPProxy.class$("net.grinder.plugin.http.tcpproxyfilter.HTTPRecordingImplementation") : class$net$grinder$plugin$http$tcpproxyfilter$HTTPRecordingImplementation);
                    this.m_filterContainer.registerComponentImplementation(class$net$grinder$plugin$http$tcpproxyfilter$ProcessHTTPRecordingWithXSLT == null ? TCPProxy.class$("net.grinder.plugin.http.tcpproxyfilter.ProcessHTTPRecordingWithXSLT") : class$net$grinder$plugin$http$tcpproxyfilter$ProcessHTTPRecordingWithXSLT);
                    this.m_filterContainer.registerComponentImplementation(class$net$grinder$plugin$http$tcpproxyfilter$RegularExpressionsImplementation == null ? TCPProxy.class$("net.grinder.plugin.http.tcpproxyfilter.RegularExpressionsImplementation") : class$net$grinder$plugin$http$tcpproxyfilter$RegularExpressionsImplementation);
                    this.m_filterContainer.registerComponentImplementation(class$net$grinder$util$URIParserImplementation == null ? TCPProxy.class$("net.grinder.util.URIParserImplementation") : class$net$grinder$util$URIParserImplementation);
                    this.m_filterContainer.registerComponentImplementation(class$net$grinder$util$SimpleStringEscaper == null ? TCPProxy.class$("net.grinder.util.SimpleStringEscaper") : class$net$grinder$util$SimpleStringEscaper);
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue;
                    this.m_filterContainer.registerComponentInstance((Object)new ProcessHTTPRecordingWithXSLT.StyleSheetInputStream(new File(args[++i])));
                    continue;
                }
                if (args[i].equalsIgnoreCase("-localhost")) {
                    localHost = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-localport")) {
                    localPort = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-remotehost")) {
                    remoteHost = args[++i];
                    isHTTPProxy = false;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-remoteport")) {
                    remotePort = Integer.parseInt(args[++i]);
                    isHTTPProxy = false;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-ssl")) {
                    useSSLPortForwarding = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-keystore")) {
                    keyStoreFile = new File(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-keystorepassword") || args[i].equalsIgnoreCase("-storepass")) {
                    keyStorePassword = args[++i].toCharArray();
                    continue;
                }
                if (args[i].equalsIgnoreCase("-keystoretype") || args[i].equalsIgnoreCase("-storetype")) {
                    keyStoreType = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-timeout")) {
                    timeout = Integer.parseInt(args[++i]) * 1000;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-console")) {
                    console = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-colour") || args[i].equalsIgnoreCase("-color")) {
                    useColour = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-properties")) {
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-httpproxy")) {
                    chainedHTTPProxy = new EndPoint(args[++i], Integer.parseInt(args[++i]));
                    continue;
                }
                if (args[i].equalsIgnoreCase("-httpsproxy")) {
                    chainedHTTPSProxy = new EndPoint(args[++i], Integer.parseInt(args[++i]));
                    continue;
                }
                if (args[i].equalsIgnoreCase("-debug")) {
                    this.m_filterContainer.changeMonitor((ComponentMonitor)new WriterComponentMonitor((Writer)logger.getErrorLogWriter()));
                    continue;
                }
                if (args[i].equalsIgnoreCase("-initialtest")) {
                    String argument = i + 1 < args.length ? args[++i] : "123";
                    throw this.barfError("-initialTest is no longer supported. Use -DHTTPPlugin.initialTest=" + argument + " or the -properties option instead.");
                }
                throw this.barfUsage();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw this.barfError(fnfe.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw this.barfUsage();
        }
        catch (NumberFormatException e) {
            throw this.barfUsage();
        }
        if (timeout < 0) {
            throw this.barfError("timeout must be non-negative.");
        }
        EndPoint localEndPoint = new EndPoint(localHost, localPort);
        EndPoint remoteEndPoint = new EndPoint(remoteHost, remotePort);
        if (chainedHTTPSProxy == null && chainedHTTPProxy != null) {
            chainedHTTPSProxy = chainedHTTPProxy;
        }
        if (chainedHTTPSProxy != null && !isHTTPProxy) {
            throw this.barfError("routing through a HTTP/HTTPS proxy is not supported in port forwarding mode.");
        }
        TCPProxyFilter requestFilter = requestFilterChain.resolveFilter();
        TCPProxyFilter responseFilter = responseFilterChain.resolveFilter();
        StringBuffer startMessage = new StringBuffer();
        startMessage.append("Initialising as ");
        if (isHTTPProxy) {
            startMessage.append("an HTTP/HTTPS proxy");
        } else if (useSSLPortForwarding) {
            startMessage.append("an SSL port forwarder");
        } else {
            startMessage.append("a TCP port forwarder");
        }
        startMessage.append(" with the parameters:");
        startMessage.append("\n   Request filters:    ");
        startMessage.append(requestFilter);
        startMessage.append("\n   Response filters:   ");
        startMessage.append(responseFilter);
        startMessage.append("\n   Local address:      " + localEndPoint);
        if (!isHTTPProxy) {
            startMessage.append("\n   Remote address:     " + remoteEndPoint);
        }
        if (chainedHTTPProxy != null) {
            startMessage.append("\n   HTTP proxy:         " + chainedHTTPProxy);
        }
        if (chainedHTTPSProxy != null) {
            startMessage.append("\n   HTTPS proxy:        " + chainedHTTPSProxy);
        }
        if (keyStoreFile != null) {
            startMessage.append("\n   Key store:          ");
            startMessage.append(keyStoreFile.toString());
            if (keyStorePassword != null) {
                startMessage.append("\n   Key store password: ");
                for (int i = 0; i < keyStorePassword.length; ++i) {
                    startMessage.append('*');
                }
            }
            if (keyStoreType != null) {
                startMessage.append("\n   Key store type:     " + keyStoreType);
            }
        }
        logger.error(startMessage.toString());
        TCPProxySSLSocketFactoryImplementation sslSocketFactory = keyStoreFile != null ? new TCPProxySSLSocketFactoryImplementation(keyStoreFile, keyStorePassword, keyStoreType) : new TCPProxySSLSocketFactoryImplementation();
        this.m_filterContainer.start();
        this.m_proxyEngine = isHTTPProxy ? new HTTPProxyTCPProxyEngine(sslSocketFactory, requestFilter, responseFilter, logger, localEndPoint, useColour, timeout, chainedHTTPProxy, chainedHTTPSProxy) : (useSSLPortForwarding ? new PortForwarderTCPProxyEngine((TCPProxySocketFactory)sslSocketFactory, requestFilter, responseFilter, logger, new ConnectionDetails(localEndPoint, remoteEndPoint, true), useColour, timeout) : new PortForwarderTCPProxyEngine(requestFilter, responseFilter, logger, new ConnectionDetails(localEndPoint, remoteEndPoint, false), useColour, timeout));
        if (console) {
            new TCPProxyConsole(this.m_proxyEngine, commentSource);
        }
        logger.error("Engine initialised, listening on port " + localPort);
    }

    private void run() {
        Runnable shutdown = new Runnable(){
            private boolean m_stopped = false;

            public synchronized void run() {
                if (!this.m_stopped) {
                    this.m_stopped = true;
                    TCPProxy.this.m_proxyEngine.stop();
                    TCPProxy.this.m_filterContainer.stop();
                    TCPProxy.this.m_filterContainer.dispose();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(shutdown));
        this.m_proxyEngine.run();
        shutdown.run();
        this.getLogger().error("Engine exited");
    }

    private final class FilterChain {
        private final String m_type;
        private final List m_adapterList = new ArrayList();
        private int m_value;

        public FilterChain(String type) {
            this.m_type = type;
        }

        public void add(Class theClass) {
            this.m_adapterList.add(TCPProxy.this.m_filterContainer.registerComponentImplementation((Object)(this.m_type + ++this.m_value), theClass));
        }

        public void add(String filterClassName) throws AbstractMainClass.LoggedInitialisationException {
            if (filterClassName.equals("NONE")) {
                this.add(class$net$grinder$tools$tcpproxy$NullFilter == null ? (class$net$grinder$tools$tcpproxy$NullFilter = TCPProxy.class$("net.grinder.tools.tcpproxy.NullFilter")) : class$net$grinder$tools$tcpproxy$NullFilter);
            } else if (filterClassName.equals("ECHO")) {
                this.add(class$net$grinder$tools$tcpproxy$EchoFilter == null ? (class$net$grinder$tools$tcpproxy$EchoFilter = TCPProxy.class$("net.grinder.tools.tcpproxy.EchoFilter")) : class$net$grinder$tools$tcpproxy$EchoFilter);
            } else {
                Class<?> filterClass;
                try {
                    filterClass = Class.forName(filterClassName);
                }
                catch (ClassNotFoundException e) {
                    throw TCPProxy.this.barfError("class '" + filterClassName + "' not found.");
                }
                if (!(class$net$grinder$tools$tcpproxy$TCPProxyFilter == null ? (class$net$grinder$tools$tcpproxy$TCPProxyFilter = TCPProxy.class$("net.grinder.tools.tcpproxy.TCPProxyFilter")) : class$net$grinder$tools$tcpproxy$TCPProxyFilter).isAssignableFrom(filterClass)) {
                    throw TCPProxy.this.barfError("the class '" + filterClass.getName() + "' does not implement the interface: '" + (class$net$grinder$tools$tcpproxy$TCPProxyFilter == null ? (class$net$grinder$tools$tcpproxy$TCPProxyFilter = TCPProxy.class$("net.grinder.tools.tcpproxy.TCPProxyFilter")) : class$net$grinder$tools$tcpproxy$TCPProxyFilter).getName() + "'.");
                }
                this.add(filterClass);
            }
        }

        public TCPProxyFilter resolveFilter() {
            if (this.m_adapterList.size() == 0) {
                this.add(class$net$grinder$tools$tcpproxy$EchoFilter == null ? (class$net$grinder$tools$tcpproxy$EchoFilter = TCPProxy.class$("net.grinder.tools.tcpproxy.EchoFilter")) : class$net$grinder$tools$tcpproxy$EchoFilter);
            }
            CompositeFilter result = new CompositeFilter();
            Iterator iterator = this.m_adapterList.iterator();
            while (iterator.hasNext()) {
                ComponentAdapter adapter = (ComponentAdapter)iterator.next();
                result.add((TCPProxyFilter)adapter.getComponentInstance((PicoContainer)TCPProxy.this.m_filterContainer));
            }
            return result;
        }
    }
}

