/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.io.PrintWriter;
import net.grinder.common.GrinderProperties;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.process.LoggerImplementation;
import net.grinder.engine.process.ProcessContext;
import net.grinder.engine.process.ScriptEngine;
import net.grinder.engine.process.ShutdownException;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextImplementation;
import net.grinder.engine.process.ThreadLogger;
import net.grinder.engine.process.WorkerThreadSynchronisation;
import net.grinder.util.Sleeper;

class GrinderThread
implements Runnable {
    private final WorkerThreadSynchronisation m_threadSynchronisation;
    private final ProcessContext m_processContext;
    private final ScriptEngine m_scriptEngine;
    private final ThreadContext m_context;
    private final ScriptEngine.WorkerRunnable m_workerRunnable;

    public GrinderThread(WorkerThreadSynchronisation threadSynchronisation, ProcessContext processContext, LoggerImplementation loggerImplementation, ScriptEngine scriptEngine, int threadID, ScriptEngine.WorkerRunnable workerRunnable) throws EngineException {
        this.m_threadSynchronisation = threadSynchronisation;
        this.m_processContext = processContext;
        this.m_scriptEngine = scriptEngine;
        this.m_workerRunnable = workerRunnable;
        this.m_context = new ThreadContextImplementation(processContext, loggerImplementation.createThreadLogger(threadID), loggerImplementation.getFilenameFactory().createSubContextFilenameFactory(Integer.toString(threadID)), loggerImplementation.getDataWriter());
        this.m_processContext.fireThreadCreatedEvent(this.m_context);
        threadSynchronisation.threadCreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_processContext.getThreadContextLocator().set(this.m_context);
        ThreadLogger logger = this.m_context.getThreadLogger();
        PrintWriter errorWriter = logger.getErrorLogWriter();
        logger.setCurrentRunNumber(-1);
        this.m_context.fireBeginThreadEvent();
        try {
            int currentRun;
            ScriptEngine.WorkerRunnable scriptThreadRunnable = this.m_workerRunnable == null ? this.m_scriptEngine.createWorkerRunnable() : this.m_workerRunnable;
            GrinderProperties properties = this.m_processContext.getProperties();
            int numberOfRuns = properties.getInt("grinder.runs", 1);
            if (numberOfRuns == 0) {
                logger.output("starting, will run forever");
            } else {
                logger.output("starting, will do " + numberOfRuns + " run" + (numberOfRuns == 1 ? "" : "s"));
            }
            this.m_threadSynchronisation.awaitStart();
            this.m_processContext.getSleeper().sleepFlat(properties.getLong("grinder.initialSleepTime", 0L));
            for (currentRun = 0; numberOfRuns == 0 || currentRun < numberOfRuns; ++currentRun) {
                logger.setCurrentRunNumber(currentRun);
                this.m_context.fireBeginRunEvent();
                try {
                    scriptThreadRunnable.run();
                }
                catch (ScriptEngine.ScriptExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ShutdownException || cause instanceof Sleeper.ShutdownException) {
                        logger.output("shut down");
                        break;
                    }
                    PrintWriter printWriter = errorWriter;
                    synchronized (printWriter) {
                        logger.error("Aborted run due to " + e.getShortMessage());
                        e.printStackTrace(errorWriter);
                    }
                }
                this.m_context.fireEndRunEvent();
            }
            logger.setCurrentRunNumber(-1);
            logger.output("finished " + currentRun + (currentRun == 1 ? " run" : " runs"));
            this.m_context.fireBeginShutdownEvent();
            try {
                scriptThreadRunnable.shutdown();
            }
            catch (ScriptEngine.ScriptExecutionException e) {
                PrintWriter printWriter = errorWriter;
                synchronized (printWriter) {
                    logger.error("Aborted test runner shut down due to " + e.getShortMessage());
                    e.printStackTrace(errorWriter);
                }
            }
            this.m_context.fireEndThreadEvent();
        }
        catch (ScriptEngine.ScriptExecutionException e) {
            PrintWriter printWriter = errorWriter;
            synchronized (printWriter) {
                logger.error("Aborting thread due to " + e.getShortMessage());
                e.printStackTrace(errorWriter);
            }
        }
        catch (Exception e) {
            PrintWriter printWriter = errorWriter;
            synchronized (printWriter) {
                logger.error("Aborting thread due to " + e);
                e.printStackTrace(errorWriter);
            }
        }
        finally {
            logger.setCurrentRunNumber(-1);
            this.m_threadSynchronisation.threadFinished();
        }
    }
}

