/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import net.grinder.common.SSLContextFactory;
import net.grinder.common.SkeletonThreadLifeCycleListener;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextLocator;
import net.grinder.script.InvalidContextException;
import net.grinder.script.SSLControl;
import net.grinder.util.InsecureSSLContextFactory;

final class SSLControlImplementation
implements SSLControl {
    private final ThreadContextLocator m_threadContextLocator;
    private boolean m_shareContextBetweenRuns = false;

    public SSLControlImplementation(ThreadContextLocator threadContextLocator) {
        this.m_threadContextLocator = threadContextLocator;
    }

    public void setKeyManagers(KeyManager[] keyManagers) throws InvalidContextException {
        ThreadContext threadContext = this.m_threadContextLocator.get();
        if (threadContext == null) {
            throw new InvalidContextException("setKeyManagers is only supported for worker threads.");
        }
        this.setThreadSSLContextFactory(threadContext, new CachingSSLContextFactory(new InsecureSSLContextFactory(keyManagers)));
    }

    public void setKeyStore(InputStream keyStoreInputStream, String password, String keyStoreType) throws GeneralSecurityException, InvalidContextException, IOException {
        ThreadContext threadContext = this.m_threadContextLocator.get();
        if (threadContext == null) {
            throw new InvalidContextException("setKeyStore is only supported for worker threads.");
        }
        char[] passwordChars = password != null ? password.toCharArray() : null;
        this.setThreadSSLContextFactory(threadContext, new CachingSSLContextFactory(new InsecureSSLContextFactory(keyStoreInputStream, passwordChars, keyStoreType)));
    }

    public void setKeyStore(InputStream keyStoreInputStream, String password) throws GeneralSecurityException, InvalidContextException, IOException {
        this.setKeyStore(keyStoreInputStream, password, KeyStore.getDefaultType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyStoreFile(String keyStoreFileName, String password, String keyStoreType) throws GeneralSecurityException, InvalidContextException, IOException {
        ThreadContext threadContext = this.m_threadContextLocator.get();
        if (threadContext == null) {
            throw new InvalidContextException("setKeyStoreFile is only supported for worker threads.");
        }
        FileInputStream fileInputStream = new FileInputStream(keyStoreFileName);
        try {
            this.setKeyStore(fileInputStream, password, keyStoreType);
        }
        finally {
            fileInputStream.close();
        }
    }

    public void setKeyStoreFile(String keyStoreFileName, String password) throws GeneralSecurityException, InvalidContextException, IOException {
        this.setKeyStoreFile(keyStoreFileName, password, KeyStore.getDefaultType());
    }

    public SSLContext getSSLContext() throws SSLContextFactory.SSLContextFactoryException {
        ThreadContext threadContext = this.m_threadContextLocator.get();
        if (threadContext == null) {
            throw new SSLContextFactory.SSLContextFactoryException("getSSLContext is only supported for worker threads.");
        }
        SSLContextFactory threadSSLContextFactory = threadContext.getThreadSSLContextFactory();
        if (threadSSLContextFactory != null) {
            return threadSSLContextFactory.getSSLContext();
        }
        CachingSSLContextFactory defaultContextFactoryForThread = new CachingSSLContextFactory(new InsecureSSLContextFactory());
        this.setThreadSSLContextFactory(threadContext, defaultContextFactoryForThread);
        return defaultContextFactoryForThread.getSSLContext();
    }

    public boolean getShareContextBetweenRuns() {
        return this.m_shareContextBetweenRuns;
    }

    public void setShareContextBetweenRuns(boolean b) {
        this.m_shareContextBetweenRuns = b;
    }

    private void setThreadSSLContextFactory(ThreadContext threadContext, CachingSSLContextFactory cachingSSLContextFactory) {
        threadContext.setThreadSSLContextFactory(cachingSSLContextFactory);
        threadContext.registerThreadLifeCycleListener(cachingSSLContextFactory);
    }

    private class CachingSSLContextFactory
    extends SkeletonThreadLifeCycleListener
    implements SSLContextFactory {
        private final SSLContextFactory m_delegateContextFactory;
        private SSLContext m_sslContext;

        public CachingSSLContextFactory(SSLContextFactory delegateContextFactory) {
            this.m_delegateContextFactory = delegateContextFactory;
        }

        public final SSLContext getSSLContext() throws SSLContextFactory.SSLContextFactoryException {
            if (this.m_sslContext == null) {
                this.m_sslContext = this.m_delegateContextFactory.getSSLContext();
            }
            return this.m_sslContext;
        }

        public void endRun() {
            if (!SSLControlImplementation.this.m_shareContextBetweenRuns) {
                this.m_sslContext = null;
            }
        }
    }
}

