/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.PyUnicode;
import org.python.core.SyspathArchive;
import org.python.core.util.RelativeFile;

public class SyspathJavaLoader
extends ClassLoader {
    private static final char SLASH_CHAR = '/';

    public SyspathJavaLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getBytesFromInputStream(InputStream input, int size) {
        byte[] byArray;
        try {
            byte[] buffer = new byte[size];
            for (int nread = 0; nread < size; nread += input.read(buffer, nread, size - nread)) {
            }
            byArray = buffer;
        }
        catch (IOException iOException) {
            try {
                input.close();
                return null;
            }
            catch (IOException iOException2) {}
            return null;
        }
        catch (Throwable throwable) {
            try {
                input.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            input.close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
    }

    private byte[] getBytesFromDir(String dir, String name) {
        try {
            File file = this.getFile(dir, name);
            if (file == null) {
                return null;
            }
            return this.getBytesFromInputStream(new FileInputStream(file), (int)file.length());
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private byte[] getBytesFromArchive(SyspathArchive archive, String name) {
        String entryname = name.replace('.', '/') + ".class";
        ZipEntry ze = archive.getEntry(entryname);
        if (ze == null) {
            return null;
        }
        try {
            return this.getBytesFromInputStream(archive.getInputStream(ze), (int)ze.getSize());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected Package definePackageForClass(String name) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return null;
        }
        String pkgname = name.substring(0, lastDotIndex);
        Package pkg = this.getPackage(pkgname);
        if (pkg == null) {
            pkg = this.definePackage(pkgname, null, null, null, null, null, null, null);
        }
        return pkg;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        PySystemState sys = Py.getSystemState();
        ClassLoader sysClassLoader = sys.getClassLoader();
        if (sysClassLoader != null) {
            return sysClassLoader.loadClass(name);
        }
        PyList path = sys.path;
        for (int i = 0; i < path.__len__(); ++i) {
            byte[] buffer;
            PyObject entry = SyspathJavaLoader.replacePathItem(sys, i, path);
            if (entry instanceof SyspathArchive) {
                SyspathArchive archive = (SyspathArchive)entry;
                buffer = this.getBytesFromArchive(archive, name);
            } else {
                if (!(entry instanceof PyUnicode)) {
                    entry = entry.__str__();
                }
                String dir = entry.toString();
                buffer = this.getBytesFromDir(dir, name);
            }
            if (buffer == null) continue;
            this.definePackageForClass(name);
            return this.defineClass(name, buffer, 0, buffer.length);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String res) {
        PySystemState sys = Py.getSystemState();
        if (res.charAt(0) == '/') {
            res = res.substring(1);
        }
        String entryRes = res;
        if (File.separatorChar != '/') {
            res = res.replace('/', File.separatorChar);
            entryRes = entryRes.replace(File.separatorChar, '/');
        }
        PyList path = sys.path;
        for (int i = 0; i < path.__len__(); ++i) {
            PyObject entry = SyspathJavaLoader.replacePathItem(sys, i, path);
            if (entry instanceof SyspathArchive) {
                SyspathArchive archive = (SyspathArchive)entry;
                ZipEntry ze = archive.getEntry(entryRes);
                if (ze == null) continue;
                try {
                    return new URL("jar:file:" + archive.asUriCompatibleString() + "!/" + entryRes);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!(entry instanceof PyUnicode)) {
                entry = entry.__str__();
            }
            String dir = sys.getPath(entry.toString());
            try {
                File resource = new File(dir, res);
                if (!resource.exists()) continue;
                return resource.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static PyObject replacePathItem(PySystemState sys, int idx, PyList paths) {
        PyObject path = paths.__getitem__(idx);
        if (path instanceof SyspathArchive) {
            return path;
        }
        try {
            path = new SyspathArchive(sys.getPath(path.toString()));
        }
        catch (Exception exception) {
            return path;
        }
        paths.__setitem__(idx, path);
        return path;
    }

    private File getFile(String dir, String name) {
        String accum = "";
        boolean first = true;
        StringTokenizer t = new StringTokenizer(name, ".");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (!first) {
                accum = accum + File.separator;
            }
            accum = accum + token;
            first = false;
        }
        return new RelativeFile(dir, accum + ".class");
    }
}

