/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.ObjectArrays;
import org.python.google.common.collect.UnmodifiableIterator;
import org.python.google.common.collect.UnmodifiableListIterator;

final class EmptyImmutableList
extends ImmutableList<Object> {
    static final EmptyImmutableList INSTANCE = new EmptyImmutableList();

    private EmptyImmutableList() {
    }

    @Override
    public final int size() {
        return 0;
    }

    @Override
    public final boolean isEmpty() {
        return true;
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    public final boolean contains(@Nullable Object target) {
        return false;
    }

    @Override
    public final boolean containsAll(Collection<?> targets) {
        return targets.isEmpty();
    }

    @Override
    public final UnmodifiableIterator<Object> iterator() {
        EmptyImmutableList emptyImmutableList = this;
        return Iterators.EMPTY_LIST_ITERATOR;
    }

    @Override
    public final Object[] toArray() {
        return ObjectArrays.EMPTY_ARRAY;
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        if (a.length > 0) {
            a[0] = null;
        }
        return a;
    }

    @Override
    public final Object get(int index) {
        CharMatcher.LookupTable.checkElementIndex(index, 0);
        throw new AssertionError((Object)"unreachable");
    }

    @Override
    public final int indexOf(@Nullable Object target) {
        return -1;
    }

    @Override
    public final int lastIndexOf(@Nullable Object target) {
        return -1;
    }

    @Override
    public final ImmutableList<Object> subList(int fromIndex, int toIndex) {
        CharMatcher.LookupTable.checkPositionIndexes(fromIndex, toIndex, 0);
        return this;
    }

    @Override
    public final UnmodifiableListIterator<Object> listIterator() {
        return Iterators.EMPTY_LIST_ITERATOR;
    }

    @Override
    public final UnmodifiableListIterator<Object> listIterator(int start) {
        CharMatcher.LookupTable.checkPositionIndex(start, 0);
        return Iterators.EMPTY_LIST_ITERATOR;
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (object instanceof List) {
            List that = (List)object;
            return that.isEmpty();
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return 1;
    }

    @Override
    public final String toString() {
        return "[]";
    }
}

