/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdiff.APIComparator;
import jdiff.Diff;
import jdiff.Modifiers;
import jdiff.ParamAPI;

class MethodAPI
implements Comparable {
    public String name_ = null;
    public String returnType_ = null;
    public String inheritedFrom_ = null;
    public String exceptions_ = "no exceptions";
    public boolean isAbstract_ = false;
    public boolean isNative_ = false;
    public boolean isSynchronized_ = false;
    public Modifiers modifiers_;
    public List params_;
    public String doc_ = null;
    public String signature_ = null;

    public MethodAPI(String name, String returnType, boolean isAbstract, boolean isNative, boolean isSynchronized, Modifiers modifiers) {
        this.name_ = name;
        this.returnType_ = returnType;
        this.isAbstract_ = isAbstract;
        this.isNative_ = isNative;
        this.isSynchronized_ = isSynchronized;
        this.modifiers_ = modifiers;
        this.params_ = new ArrayList();
    }

    public MethodAPI(MethodAPI m) {
        this.name_ = m.name_;
        this.returnType_ = m.returnType_;
        this.inheritedFrom_ = m.inheritedFrom_;
        this.exceptions_ = m.exceptions_;
        this.isAbstract_ = m.isAbstract_;
        this.isNative_ = m.isNative_;
        this.isSynchronized_ = m.isSynchronized_;
        this.modifiers_ = m.modifiers_;
        this.params_ = m.params_;
        this.doc_ = m.doc_;
        this.signature_ = m.signature_;
    }

    public int compareTo(Object o) {
        MethodAPI oMethod = (MethodAPI)o;
        int comp = this.name_.compareTo(oMethod.name_);
        if (comp != 0) {
            return comp;
        }
        comp = this.returnType_.compareTo(oMethod.returnType_);
        if (comp != 0) {
            return comp;
        }
        if (APIComparator.changedInheritance(this.inheritedFrom_, oMethod.inheritedFrom_) != 0) {
            return -1;
        }
        if (this.isAbstract_ != oMethod.isAbstract_) {
            return -1;
        }
        if (Diff.showAllChanges && this.isNative_ != oMethod.isNative_) {
            return -1;
        }
        if (Diff.showAllChanges && this.isSynchronized_ != oMethod.isSynchronized_) {
            return -1;
        }
        comp = this.exceptions_.compareTo(oMethod.exceptions_);
        if (comp != 0) {
            return comp;
        }
        comp = this.modifiers_.compareTo(oMethod.modifiers_);
        if (comp != 0) {
            return comp;
        }
        comp = this.getSignature().compareTo(oMethod.getSignature());
        if (comp != 0) {
            return comp;
        }
        if (APIComparator.docChanged(this.doc_, oMethod.doc_)) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return this.name_.compareTo(((MethodAPI)o).name_) == 0;
    }

    public boolean equalSignatures(Object o) {
        return this.getSignature().compareTo(((MethodAPI)o).getSignature()) == 0;
    }

    public String getSignature() {
        if (this.signature_ != null) {
            return this.signature_;
        }
        String res = "";
        boolean first = true;
        Iterator iter = this.params_.iterator();
        while (iter.hasNext()) {
            if (!first) {
                res = res + ", ";
            }
            ParamAPI param = (ParamAPI)iter.next();
            res = res + param.toString();
            first = false;
        }
        this.signature_ = res;
        return res;
    }
}

