/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import jdiff.API;
import jdiff.JDiff;
import jdiff.Options;
import jdiff.XMLToAPI;

public class RootDocToXML {
    public static String outputFileName = null;
    public static String apiIdentifier = null;
    private static PrintWriter outputFile = null;
    public static String outputDirectory = null;
    public static String classVisibilityLevel = "protected";
    public static String memberVisibilityLevel = "protected";
    public static boolean saveAllDocs = true;
    public static boolean doExclude = false;
    public static String excludeTag = null;
    public static String baseURI = "http://www.w3.org";
    static boolean stripNonPrintables = true;
    static boolean addSrcInfo = false;
    static boolean packagesOnly = false;
    private static boolean trace = false;

    public static boolean writeXML(RootDoc root) {
        String tempFileName = outputFileName;
        if (outputDirectory != null) {
            tempFileName = outputDirectory;
            if (!tempFileName.endsWith(JDiff.DIR_SEP)) {
                tempFileName = tempFileName + JDiff.DIR_SEP;
            }
            tempFileName = tempFileName + outputFileName;
        }
        try {
            FileOutputStream fos = new FileOutputStream(tempFileName);
            outputFile = new PrintWriter(fos);
            System.out.println("JDiff: writing the API to file '" + tempFileName + "'...");
            if (root.specifiedPackages().length != 0 || root.specifiedClasses().length != 0) {
                RootDocToXML apiWriter = new RootDocToXML();
                apiWriter.emitXMLHeader();
                apiWriter.logOptions();
                apiWriter.processPackages(root);
                apiWriter.emitXMLFooter();
            }
            outputFile.close();
        }
        catch (IOException e) {
            System.out.println("IO Error while attempting to create " + tempFileName);
            System.out.println("Error: " + e.getMessage());
            System.exit(1);
        }
        if (XMLToAPI.validateXML) {
            RootDocToXML.writeXSD();
        }
        return true;
    }

    public static void writeXSD() {
        String xsdFileName = outputFileName;
        if (outputDirectory == null) {
            int idx = xsdFileName.lastIndexOf(92);
            int idx2 = xsdFileName.lastIndexOf(47);
            if (idx == -1 && idx2 == -1) {
                xsdFileName = "";
            } else if (idx == -1 && idx2 != -1) {
                xsdFileName = xsdFileName.substring(0, idx2);
            } else if (idx != -1 && idx2 == -1) {
                xsdFileName = xsdFileName.substring(0, idx);
            } else if (idx != -1 && idx2 != -1) {
                int max = idx2 > idx ? idx2 : idx;
                xsdFileName = xsdFileName.substring(0, max);
            }
        } else {
            xsdFileName = outputDirectory;
            if (!xsdFileName.endsWith(JDiff.DIR_SEP)) {
                xsdFileName = xsdFileName + JDiff.DIR_SEP;
            }
        }
        xsdFileName = xsdFileName + "api.xsd";
        try {
            FileOutputStream fos = new FileOutputStream(xsdFileName);
            PrintWriter xsdFile = new PrintWriter(fos);
            xsdFile.println("<?xml version=\"1.0\" encoding=\"iso-8859-1\" standalone=\"no\"?>");
            xsdFile.println("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
            xsdFile.println("");
            xsdFile.println("<xsd:annotation>");
            xsdFile.println("  <xsd:documentation>");
            xsdFile.println("  Schema for JDiff API representation.");
            xsdFile.println("  </xsd:documentation>");
            xsdFile.println("</xsd:annotation>");
            xsdFile.println();
            xsdFile.println("<xsd:element name=\"api\" type=\"apiType\"/>");
            xsdFile.println("");
            xsdFile.println("<xsd:complexType name=\"apiType\">");
            xsdFile.println("  <xsd:sequence>");
            xsdFile.println("    <xsd:element name=\"package\" type=\"packageType\" minOccurs='1' maxOccurs='unbounded'/>");
            xsdFile.println("  </xsd:sequence>");
            xsdFile.println("  <xsd:attribute name=\"name\" type=\"xsd:string\"/>");
            xsdFile.println("  <xsd:attribute name=\"jdversion\" type=\"xsd:string\"/>");
            xsdFile.println("</xsd:complexType>");
            xsdFile.println();
            xsdFile.println("<xsd:complexType name=\"packageType\">");
            xsdFile.println("  <xsd:sequence>");
            xsdFile.println("    <xsd:choice maxOccurs='unbounded'>");
            xsdFile.println("      <xsd:element name=\"class\" type=\"classType\"/>");
            xsdFile.println("      <xsd:element name=\"interface\" type=\"classType\"/>");
            xsdFile.println("    </xsd:choice>");
            xsdFile.println("    <xsd:element name=\"doc\" type=\"xsd:string\" minOccurs='0' maxOccurs='1'/>");
            xsdFile.println("  </xsd:sequence>");
            xsdFile.println("  <xsd:attribute name=\"name\" type=\"xsd:string\"/>");
            xsdFile.println("</xsd:complexType>");
            xsdFile.println();
            xsdFile.println("<xsd:complexType name=\"classType\">");
            xsdFile.println("  <xsd:sequence>");
            xsdFile.println("    <xsd:element name=\"implements\" type=\"interfaceTypeName\" minOccurs='0' maxOccurs='unbounded'/>");
            xsdFile.println("    <xsd:element name=\"constructor\" type=\"constructorType\" minOccurs='0' maxOccurs='unbounded'/>");
            xsdFile.println("    <xsd:element name=\"method\" type=\"methodType\" minOccurs='0' maxOccurs='unbounded'/>");
            xsdFile.println("    <xsd:element name=\"field\" type=\"fieldType\" minOccurs='0' maxOccurs='unbounded'/>");
            xsdFile.println("    <xsd:element name=\"doc\" type=\"xsd:string\" minOccurs='0' maxOccurs='1'/>");
            xsdFile.println("  </xsd:sequence>");
            xsdFile.println("  <xsd:attribute name=\"name\" type=\"xsd:string\"/>");
            xsdFile.println("  <xsd:attribute name=\"extends\" type=\"xsd:string\" use='optional'/>");
            xsdFile.println("  <xsd:attribute name=\"abstract\" type=\"xsd:boolean\"/>");
            xsdFile.println("  <xsd:attribute name=\"src\" type=\"xsd:string\" use='optional'/>");
            xsdFile.println("  <xsd:attribute name=\"static\" type=\"xsd:boolean\"/>");
            xsdFile.println("  <xsd:attribute name=\"final\" type=\"xsd:boolean\"/>");
            xsdFile.println("  <xsd:attribute name=\"deprecated\" type=\"xsd:string\"/>");
            xsdFile.println("  <xsd:attribute name=\"visibility\" type=\"xsd:string\"/>");
            xsdFile.println("</xsd:complexType>");
            xsdFile.println();
            xsdFile.println("<xsd:complexType name=\"interfaceTypeName\">");
            xsdFile.println("  <xsd:attribute name=\"name\" type=\"xsd:string\"/>");
            xsdFile.println("</xsd:complexType>");
            xsdFile.println();
            xsdFile.println("<xsd:complexType name=\"constructorType\">");
            xsdFile.println("  <xsd:sequence>");
            xsdFile.println("    <xsd:element name=\"exception\" type=\"exceptionType\" minOccurs='0' maxOccurs='unbounded'/>");
            xsdFile.println("    <xsd:element name=\"doc\" type=\"xsd:string\" minOccurs='0' maxOccurs='1'/>");
            xsdFile.println("  </xsd:sequence>");
            xsdFile.println("  <xsd:attribute name=\"name\" type=\"xsd:string\"/>");
            xsdFile.println("  <xsd:attribute name=\"type\" type=\"xsd:string\" use='optional'/>");
            xsdFile.println("  <xsd:attribute name=\"src\" type=\"xsd:string\" use='optional'/>");
            xsdFile.println("  <xsd:attribute name=\"static\" type=\"xsd:boolean\"/>");
            xsdFile.println("  <xsd:attribute name=\"final\" type=\"xsd:boolean\"/>");
            xsdFile.println("  <xsd:attribute name=\"deprecated\" type=\"xsd:string\"/>");
            xsdFile.println("  <xsd:attribute name=\"visibility\" type=\"xsd:string\"/>");
            xsdFile.println("</xsd:complexType>");
            xsdFile.println();
            xsdFile.println("<xsd:complexType name=\"paramsType\">");
            xsdFile.println("  <xsd:attribute name=\"name\" type=\"xsd:string\"/>");
            xsdFile.println("  <xsd:attribute name=\"type\" type=\"xsd:string\"/>");
            xsdFile.println("</xsd:complexType>");
            xsdFile.println();
            xsdFile.println("<xsd:complexType name=\"exceptionType\">");
            xsdFile.println("  <xsd:attribute name=\"name\" type=\"xsd:string\"/>");
            xsdFile.println("  <xsd:attribute name=\"type\" type=\"xsd:string\"/>");
            xsdFile.println("</xsd:complexType>");
            xsdFile.println();
            xsdFile.println("<xsd:complexType name=\"methodType\">");
            xsdFile.println("  <xsd:sequence>");
            xsdFile.println("    <xsd:element name=\"param\" type=\"paramsType\" minOccurs='0' maxOccurs='unbounded'/>");
            xsdFile.println("    <xsd:element name=\"exception\" type=\"exceptionType\" minOccurs='0' maxOccurs='unbounded'/>");
            xsdFile.println("    <xsd:element name=\"doc\" type=\"xsd:string\" minOccurs='0' maxOccurs='1'/>");
            xsdFile.println("  </xsd:sequence>");
            xsdFile.println("  <xsd:attribute name=\"name\" type=\"xsd:string\"/>");
            xsdFile.println("  <xsd:attribute name=\"return\" type=\"xsd:string\" use='optional'/>");
            xsdFile.println("  <xsd:attribute name=\"abstract\" type=\"xsd:boolean\"/>");
            xsdFile.println("  <xsd:attribute name=\"native\" type=\"xsd:boolean\"/>");
            xsdFile.println("  <xsd:attribute name=\"synchronized\" type=\"xsd:boolean\"/>");
            xsdFile.println("  <xsd:attribute name=\"src\" type=\"xsd:string\" use='optional'/>");
            xsdFile.println("  <xsd:attribute name=\"static\" type=\"xsd:boolean\"/>");
            xsdFile.println("  <xsd:attribute name=\"final\" type=\"xsd:boolean\"/>");
            xsdFile.println("  <xsd:attribute name=\"deprecated\" type=\"xsd:string\"/>");
            xsdFile.println("  <xsd:attribute name=\"visibility\" type=\"xsd:string\"/>");
            xsdFile.println("</xsd:complexType>");
            xsdFile.println();
            xsdFile.println("<xsd:complexType name=\"fieldType\">");
            xsdFile.println("  <xsd:sequence>");
            xsdFile.println("    <xsd:element name=\"doc\" type=\"xsd:string\" minOccurs='0' maxOccurs='1'/>");
            xsdFile.println("  </xsd:sequence>");
            xsdFile.println("  <xsd:attribute name=\"name\" type=\"xsd:string\"/>");
            xsdFile.println("  <xsd:attribute name=\"type\" type=\"xsd:string\"/>");
            xsdFile.println("  <xsd:attribute name=\"transient\" type=\"xsd:boolean\"/>");
            xsdFile.println("  <xsd:attribute name=\"volatile\" type=\"xsd:boolean\"/>");
            xsdFile.println("  <xsd:attribute name=\"value\" type=\"xsd:string\" use='optional'/>");
            xsdFile.println("  <xsd:attribute name=\"src\" type=\"xsd:string\" use='optional'/>");
            xsdFile.println("  <xsd:attribute name=\"static\" type=\"xsd:boolean\"/>");
            xsdFile.println("  <xsd:attribute name=\"final\" type=\"xsd:boolean\"/>");
            xsdFile.println("  <xsd:attribute name=\"deprecated\" type=\"xsd:string\"/>");
            xsdFile.println("  <xsd:attribute name=\"visibility\" type=\"xsd:string\"/>");
            xsdFile.println("</xsd:complexType>");
            xsdFile.println();
            xsdFile.println("</xsd:schema>");
            xsdFile.close();
        }
        catch (IOException e) {
            System.out.println("IO Error while attempting to create " + xsdFileName);
            System.out.println("Error: " + e.getMessage());
            System.exit(1);
        }
    }

    public void logOptions() {
        outputFile.print("<!-- ");
        outputFile.print(" Command line arguments = " + Options.cmdOptions);
        outputFile.println(" -->");
    }

    public void processPackages(RootDoc root) {
        String pkgName;
        PackageDoc[] specified_pd = root.specifiedPackages();
        TreeMap<String, PackageDoc> pdl = new TreeMap<String, PackageDoc>();
        for (int i = 0; specified_pd != null && i < specified_pd.length; ++i) {
            pdl.put(specified_pd[i].name(), specified_pd[i]);
        }
        ClassDoc[] cd = root.specifiedClasses();
        HashMap<String, ArrayList> classesToUse = new HashMap<String, ArrayList>();
        for (int i = 0; cd != null && i < cd.length; ++i) {
            PackageDoc cpd = cd[i].containingPackage();
            if (cpd == null && !packagesOnly) {
                cpd = root.packageNamed("anonymous");
            }
            pkgName = cpd.name();
            String className = cd[i].name();
            if (trace) {
                System.out.println("Found package " + pkgName + " for class " + className);
            }
            if (!pdl.containsKey(pkgName)) {
                if (trace) {
                    System.out.println("Adding new package " + pkgName);
                }
                pdl.put(pkgName, cpd);
            }
            ArrayList classes = classesToUse.containsKey(pkgName) ? (ArrayList)classesToUse.get(pkgName) : new ArrayList();
            classes.add(cd[i]);
            classesToUse.put(pkgName, classes);
        }
        PackageDoc[] pd = pdl.values().toArray(new PackageDoc[0]);
        for (int i = 0; pd != null && i < pd.length; ++i) {
            AbstractList classList;
            pkgName = pd[i].name();
            if (!this.shownElement((Doc)pd[i], null)) continue;
            if (trace) {
                System.out.println("PROCESSING PACKAGE: " + pkgName);
            }
            outputFile.println("<package name=\"" + pkgName + "\">");
            int tagCount = pd[i].tags().length;
            if (trace) {
                System.out.println("#tags: " + tagCount);
            }
            if (classesToUse.containsKey(pkgName)) {
                System.out.println("Using the specified classes");
                classList = (ArrayList)classesToUse.get(pkgName);
            } else {
                classList = new LinkedList<ClassDoc>(Arrays.asList(pd[i].allClasses()));
            }
            Collections.sort(classList);
            ClassDoc[] classes = new ClassDoc[classList.size()];
            classes = classList.toArray(classes);
            this.processClasses(classes, pkgName);
            this.addPkgDocumentation(root, pd[i], 2);
            outputFile.println("</package>");
        }
    }

    public void processClasses(ClassDoc[] cd, String pkgName) {
        if (cd.length == 0) {
            return;
        }
        if (trace) {
            System.out.println("PROCESSING CLASSES, number=" + cd.length);
        }
        for (int i = 0; i < cd.length; ++i) {
            String className = cd[i].name();
            if (trace) {
                System.out.println("PROCESSING CLASS/IFC: " + className);
            }
            if (!this.shownElement((Doc)cd[i], classVisibilityLevel)) continue;
            boolean isInterface = false;
            if (cd[i].isInterface()) {
                isInterface = true;
            }
            if (isInterface) {
                outputFile.println("  <!-- start interface " + pkgName + "." + className + " -->");
                outputFile.print("  <interface name=\"" + className + "\"");
            } else {
                outputFile.println("  <!-- start class " + pkgName + "." + className + " -->");
                outputFile.print("  <class name=\"" + className + "\"");
            }
            Type parent = cd[i].superclassType();
            if (parent != null) {
                outputFile.println(" extends=\"" + this.buildEmittableTypeString(parent) + "\"");
            }
            outputFile.println("    abstract=\"" + cd[i].isAbstract() + "\"");
            this.addCommonModifiers((ProgramElementDoc)cd[i], 4);
            outputFile.println(">");
            this.processInterfaces(cd[i].interfaceTypes());
            this.processConstructors(cd[i].constructors());
            this.processMethods(cd[i], cd[i].methods());
            this.processFields(cd[i].fields());
            this.addDocumentation((ProgramElementDoc)cd[i], 4);
            if (isInterface) {
                outputFile.println("  </interface>");
                outputFile.println("  <!-- end interface " + pkgName + "." + className + " -->");
                continue;
            }
            outputFile.println("  </class>");
            outputFile.println("  <!-- end class " + pkgName + "." + className + " -->");
        }
    }

    public void addCommonModifiers(ProgramElementDoc ped, int indent) {
        this.addSourcePosition(ped, indent);
        for (int i = 0; i < indent; ++i) {
            outputFile.print(" ");
        }
        outputFile.print("static=\"" + ped.isStatic() + "\"");
        outputFile.print(" final=\"" + ped.isFinal() + "\"");
        String visibility = null;
        if (ped.isPublic()) {
            visibility = "public";
        } else if (ped.isProtected()) {
            visibility = "protected";
        } else if (ped.isPackagePrivate()) {
            visibility = "package";
        } else if (ped.isPrivate()) {
            visibility = "private";
        }
        outputFile.println(" visibility=\"" + visibility + "\"");
        for (int i = 0; i < indent; ++i) {
            outputFile.print(" ");
        }
        boolean isDeprecated = false;
        Tag[] ta = ped.tags("deprecated");
        if (ta.length != 0) {
            isDeprecated = true;
        }
        if (ta.length > 1) {
            System.out.println("JDiff: warning: multiple @deprecated tags found in comments for " + ped.name() + ". Using the first one only.");
            System.out.println("Text is: " + ped.getRawCommentText());
        }
        if (isDeprecated) {
            String text = ta[0].text();
            if (text != null && text.compareTo("") != 0) {
                int idx = RootDocToXML.endOfFirstSentence(text);
                if (idx == 0) {
                    outputFile.print("deprecated=\"deprecated, no comment\"");
                } else {
                    String fs = null;
                    fs = idx == -1 ? text : text.substring(0, idx + 1);
                    String st = API.hideHTMLTags(fs);
                    outputFile.print("deprecated=\"" + st + "\"");
                }
            } else {
                outputFile.print("deprecated=\"deprecated, no comment\"");
            }
        } else {
            outputFile.print("deprecated=\"not deprecated\"");
        }
    }

    public void addSourcePosition(ProgramElementDoc ped, int indent) {
        if (!addSrcInfo) {
            return;
        }
        if (JDiff.javaVersion.startsWith("1.1") || JDiff.javaVersion.startsWith("1.2") || JDiff.javaVersion.startsWith("1.3")) {
            return;
        }
        try {
            Class<ProgramElementDoc> c = ProgramElementDoc.class;
            Method m = c.getMethod("position", null);
            Object sp = m.invoke((Object)ped, null);
            if (sp != null) {
                for (int i = 0; i < indent; ++i) {
                    outputFile.print(" ");
                }
                outputFile.println("src=\"" + sp + "\"");
            }
        }
        catch (NoSuchMethodException e2) {
            System.err.println("Error: method \"position\" not found");
            e2.printStackTrace();
        }
        catch (IllegalAccessException e4) {
            System.err.println("Error: class not permitted to be instantiated");
            e4.printStackTrace();
        }
        catch (InvocationTargetException e5) {
            System.err.println("Error: method \"position\" could not be invoked");
            e5.printStackTrace();
        }
        catch (Exception e6) {
            System.err.println("Error: ");
            e6.printStackTrace();
        }
    }

    public void processInterfaces(Type[] ifaces) {
        if (trace) {
            System.out.println("PROCESSING INTERFACES, number=" + ifaces.length);
        }
        for (int i = 0; i < ifaces.length; ++i) {
            String ifaceName = this.buildEmittableTypeString(ifaces[i]);
            if (trace) {
                System.out.println("PROCESSING INTERFACE: " + ifaceName);
            }
            outputFile.println("    <implements name=\"" + ifaceName + "\"/>");
        }
    }

    public void processConstructors(ConstructorDoc[] ct) {
        if (trace) {
            System.out.println("PROCESSING CONSTRUCTORS, number=" + ct.length);
        }
        for (int i = 0; i < ct.length; ++i) {
            String ctorName = ct[i].name();
            if (trace) {
                System.out.println("PROCESSING CONSTRUCTOR: " + ctorName);
            }
            if (!this.shownElement((Doc)ct[i], memberVisibilityLevel)) continue;
            outputFile.print("    <constructor name=\"" + ctorName + "\"");
            Parameter[] params = ct[i].parameters();
            boolean first = true;
            if (params.length != 0) {
                outputFile.print(" type=\"");
                for (int j = 0; j < params.length; ++j) {
                    if (!first) {
                        outputFile.print(", ");
                    }
                    this.emitType(params[j].type());
                    first = false;
                }
                outputFile.println("\"");
            } else {
                outputFile.println();
            }
            this.addCommonModifiers((ProgramElementDoc)ct[i], 6);
            outputFile.println(">");
            this.processExceptions(ct[i].thrownExceptions());
            this.addDocumentation((ProgramElementDoc)ct[i], 6);
            outputFile.println("    </constructor>");
        }
    }

    public void processExceptions(ClassDoc[] cd) {
        if (trace) {
            System.out.println("PROCESSING EXCEPTIONS, number=" + cd.length);
        }
        for (int i = 0; i < cd.length; ++i) {
            String exceptionName = cd[i].name();
            if (trace) {
                System.out.println("PROCESSING EXCEPTION: " + exceptionName);
            }
            outputFile.print("      <exception name=\"" + exceptionName + "\" type=\"");
            this.emitType((Type)cd[i]);
            outputFile.println("\"/>");
        }
    }

    public void processMethods(ClassDoc cd, MethodDoc[] md) {
        if (trace) {
            System.out.println("PROCESSING " + cd.name() + " METHODS, number = " + md.length);
        }
        for (int i = 0; i < md.length; ++i) {
            String methodName = md[i].name();
            if (trace) {
                System.out.println("PROCESSING METHOD: " + methodName);
            }
            if (methodName.startsWith("<") || !this.shownElement((Doc)md[i], memberVisibilityLevel)) continue;
            outputFile.print("    <method name=\"" + methodName + "\"");
            Type retType = md[i].returnType();
            if (retType.qualifiedTypeName().compareTo("void") == 0) {
                outputFile.println();
            } else {
                outputFile.print(" return=\"");
                this.emitType(retType);
                outputFile.println("\"");
            }
            outputFile.print("      abstract=\"" + md[i].isAbstract() + "\"");
            outputFile.print(" native=\"" + md[i].isNative() + "\"");
            outputFile.println(" synchronized=\"" + md[i].isSynchronized() + "\"");
            this.addCommonModifiers((ProgramElementDoc)md[i], 6);
            outputFile.println(">");
            Parameter[] params = md[i].parameters();
            for (int j = 0; j < params.length; ++j) {
                outputFile.print("      <param name=\"" + params[j].name() + "\"");
                outputFile.print(" type=\"");
                this.emitType(params[j].type());
                outputFile.println("\"/>");
            }
            this.processExceptions(md[i].thrownExceptions());
            this.addDocumentation((ProgramElementDoc)md[i], 6);
            outputFile.println("    </method>");
        }
    }

    public void processFields(FieldDoc[] fd) {
        if (trace) {
            System.out.println("PROCESSING FIELDS, number=" + fd.length);
        }
        for (int i = 0; i < fd.length; ++i) {
            String fieldName = fd[i].name();
            if (trace) {
                System.out.println("PROCESSING FIELD: " + fieldName);
            }
            if (!this.shownElement((Doc)fd[i], memberVisibilityLevel)) continue;
            outputFile.print("    <field name=\"" + fieldName + "\"");
            outputFile.print(" type=\"");
            this.emitType(fd[i].type());
            outputFile.println("\"");
            outputFile.print("      transient=\"" + fd[i].isTransient() + "\"");
            outputFile.println(" volatile=\"" + fd[i].isVolatile() + "\"");
            this.addCommonModifiers((ProgramElementDoc)fd[i], 6);
            outputFile.println(">");
            this.addDocumentation((ProgramElementDoc)fd[i], 6);
            outputFile.println("    </field>");
        }
    }

    public void emitType(Type type) {
        String name = this.buildEmittableTypeString(type);
        if (name == null) {
            return;
        }
        outputFile.print(name);
    }

    private String buildEmittableTypeString(Type type) {
        if (type == null) {
            return null;
        }
        String name = type.toString().replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        if (name.startsWith("<<ambiguous>>")) {
            name = name.substring(13);
        }
        return name;
    }

    public void emitXMLHeader() {
        outputFile.println("<?xml version=\"1.0\" encoding=\"iso-8859-1\" standalone=\"no\"?>");
        outputFile.println("<!-- Generated by the JDiff Javadoc doclet -->");
        outputFile.println("<!-- (http://www.jdiff.org) -->");
        outputFile.println("<!-- on " + new Date() + " -->");
        outputFile.println();
        outputFile.println("<api");
        outputFile.println("  xmlns:xsi='" + baseURI + "/2001/XMLSchema-instance'");
        outputFile.println("  xsi:noNamespaceSchemaLocation='api.xsd'");
        outputFile.println("  name=\"" + apiIdentifier + "\"");
        outputFile.println("  jdversion=\"1.1.1\">");
        outputFile.println();
    }

    public void emitXMLFooter() {
        outputFile.println();
        outputFile.println("</api>");
    }

    public boolean shownElement(Doc doc, String visLevel) {
        String rct;
        if (doExclude && excludeTag != null && doc != null && (rct = doc.getRawCommentText()) != null && rct.indexOf(excludeTag) != -1) {
            return false;
        }
        if (visLevel == null) {
            return true;
        }
        ProgramElementDoc ped = null;
        if (doc instanceof ProgramElementDoc) {
            ped = (ProgramElementDoc)doc;
        }
        if (visLevel.compareTo("private") == 0) {
            return true;
        }
        if (visLevel.compareTo("package") == 0) {
            return !ped.isPrivate();
        }
        if (visLevel.compareTo("protected") == 0) {
            return !ped.isPrivate() && !ped.isPackagePrivate();
        }
        if (visLevel.compareTo("public") == 0) {
            return ped.isPublic();
        }
        return false;
    }

    public String stripNonPrintingChars(String s, Doc doc) {
        if (!stripNonPrintables) {
            return s;
        }
        char[] sa = s.toCharArray();
        for (int i = 0; i < sa.length; ++i) {
            char c = sa[i];
            if (Character.isLetterOrDigit(c) || c == ' ' || c == '.' || c == ',' || c == '\r' || c == '\t' || c == '\n' || c == '!' || c == '?' || c == ';' || c == ':' || c == '[' || c == ']' || c == '(' || c == ')' || c == '~' || c == '@' || c == '#' || c == '$' || c == '%' || c == '^' || c == '&' || c == '*' || c == '-' || c == '=' || c == '+' || c == '_' || c == '|' || c == '\\' || c == '/' || c == '\'' || c == '}' || c == '{' || c == '\"' || c == '<' || c == '>' || c == '`') continue;
            sa[i] = 35;
        }
        return new String(sa);
    }

    public boolean inRange(int val, int min, int max) {
        if (val < min) {
            return false;
        }
        return val <= max;
    }

    public void addDocumentation(ProgramElementDoc ped, int indent) {
        String rct = ped.getRawCommentText();
        if (rct != null) {
            rct = this.stripNonPrintingChars(rct, (Doc)ped);
            if ((rct = rct.trim()).compareTo("") != 0 && rct.indexOf("InsertCommentsHere") == -1 && rct.indexOf("InsertOtherCommentsHere") == -1) {
                int i;
                int idx = RootDocToXML.endOfFirstSentence(rct);
                if (idx == 0) {
                    return;
                }
                for (i = 0; i < indent; ++i) {
                    outputFile.print(" ");
                }
                outputFile.println("<doc>");
                for (i = 0; i < indent; ++i) {
                    outputFile.print(" ");
                }
                String firstSentence = null;
                firstSentence = idx == -1 ? rct : rct.substring(0, idx + 1);
                boolean checkForAts = false;
                if (checkForAts && firstSentence.indexOf("@") != -1 && firstSentence.indexOf("@link") == -1) {
                    System.out.println("Warning: @ tag seen in comment: " + firstSentence);
                }
                String firstSentenceNoTags = API.stuffHTMLTags(firstSentence);
                outputFile.println(firstSentenceNoTags);
                for (int i2 = 0; i2 < indent; ++i2) {
                    outputFile.print(" ");
                }
                outputFile.println("</doc>");
            }
        }
    }

    public void addPkgDocumentation(RootDoc root, PackageDoc pd, int indent) {
        String rct = null;
        String filename = pd.name();
        try {
            File f2;
            String srcLocation = null;
            String[][] options = root.options();
            for (int opt = 0; opt < options.length; ++opt) {
                if (options[opt][0].compareTo("-sourcepath") != 0) continue;
                srcLocation = options[opt][1];
                break;
            }
            filename = filename.replace('.', JDiff.DIR_SEP.charAt(0));
            if (srcLocation != null) {
                if (srcLocation.startsWith("..")) {
                    String curDir = System.getProperty("user.dir");
                    while (srcLocation.startsWith("..")) {
                        srcLocation = srcLocation.substring(3);
                        int idx = curDir.lastIndexOf(JDiff.DIR_SEP);
                        curDir = curDir.substring(0, idx + 1);
                    }
                    srcLocation = curDir + srcLocation;
                }
                filename = srcLocation + JDiff.DIR_SEP + filename;
            }
            if (!(f2 = new File(filename = filename + JDiff.DIR_SEP + "package.htm")).exists()) {
                filename = filename + "l";
            }
            FileInputStream f = new FileInputStream(filename);
            BufferedReader d = new BufferedReader(new InputStreamReader(f));
            String str = d.readLine();
            boolean inBody = false;
            while (str != null) {
                if (!inBody) {
                    if (str.toLowerCase().trim().startsWith("<body")) {
                        inBody = true;
                    }
                    str = d.readLine();
                    continue;
                }
                if (str.toLowerCase().trim().startsWith("</body")) {
                    inBody = false;
                    continue;
                }
                rct = rct == null ? str + "\n" : rct + str + "\n";
                str = d.readLine();
            }
        }
        catch (FileNotFoundException e) {
            if (trace) {
                System.out.println("No package level documentation file at '" + filename + "'");
            }
        }
        catch (IOException e) {
            System.out.println("Error reading file \"" + filename + "\": " + e.getMessage());
            System.exit(5);
        }
        if (rct != null) {
            rct = this.stripNonPrintingChars(rct, (Doc)pd);
            if ((rct = rct.trim()).compareTo("") != 0 && rct.indexOf("InsertCommentsHere") == -1 && rct.indexOf("InsertOtherCommentsHere") == -1) {
                int i;
                int idx = RootDocToXML.endOfFirstSentence(rct);
                if (idx == 0) {
                    return;
                }
                for (i = 0; i < indent; ++i) {
                    outputFile.print(" ");
                }
                outputFile.println("<doc>");
                for (i = 0; i < indent; ++i) {
                    outputFile.print(" ");
                }
                String firstSentence = null;
                firstSentence = idx == -1 ? rct : rct.substring(0, idx + 1);
                String firstSentenceNoTags = API.stuffHTMLTags(firstSentence);
                outputFile.println(firstSentenceNoTags);
                for (int i2 = 0; i2 < indent; ++i2) {
                    outputFile.print(" ");
                }
                outputFile.println("</doc>");
            }
        }
    }

    public static int endOfFirstSentence(String text) {
        return RootDocToXML.endOfFirstSentence(text, true);
    }

    public static int endOfFirstSentence(String text, boolean writingToXML) {
        int i;
        if (saveAllDocs && writingToXML) {
            return -1;
        }
        int textLen = text.length();
        if (textLen == 0) {
            return 0;
        }
        int index = -1;
        int fromindex = 0;
        int ellipsis = text.indexOf(". . .");
        if (ellipsis != -1) {
            fromindex = ellipsis + 5;
        }
        for (i = 0; i < textLen && text.charAt(i) == ' '; ++i) {
        }
        if (text.charAt(i) == '@' && fromindex < textLen - 1) {
            fromindex = i + 1;
        }
        index = RootDocToXML.minIndex(index, text.indexOf("? ", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("?\t", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("?\n", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("?\r", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("?\f", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("! ", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("!\t", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("!\n", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("!\r", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("!\f", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf(". ", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf(".\t", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf(".\n", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf(".\r", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf(".\f", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("@param", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("@return", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("@throw", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("@serial", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("@exception", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("@deprecate", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("@author", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("@since", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("@see", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("@version", fromindex));
        if (doExclude && excludeTag != null) {
            index = RootDocToXML.minIndex(index, text.indexOf(excludeTag));
        }
        index = RootDocToXML.minIndex(index, text.indexOf("@vtexclude", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("@vtinclude", fromindex));
        index = RootDocToXML.minIndex(index, text.indexOf("<p>", 2));
        index = RootDocToXML.minIndex(index, text.indexOf("<P>", 2));
        index = RootDocToXML.minIndex(index, text.indexOf("<blockquote", 2));
        if ((index = RootDocToXML.minIndex(index, text.indexOf("<pre", fromindex))) != -1 && (text.charAt(index) == '@' || text.charAt(index) == '<') && index != 0) {
            --index;
        }
        return index;
    }

    public static int minIndex(int i, int j) {
        if (i == -1) {
            return j;
        }
        if (j == -1) {
            return i;
        }
        return Math.min(i, j);
    }
}

