// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/monitoredres/monitored_resource.proto
// DO NOT EDIT!

/*
Package monitoredres is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/api/monitoredres/monitored_resource.proto

It has these top-level messages:
	MonitoredResourceDescriptor
	MonitoredResource
*/
package monitoredres // import "google.golang.org/genproto/googleapis/api/monitoredres"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_api "google.golang.org/genproto/googleapis/api/label"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// An object that describes the schema of a [MonitoredResource][google.api.MonitoredResource] object using a
// type name and a set of labels.  For example, the monitored resource
// descriptor for Google Compute Engine VM instances has a type of
// `"gce_instance"` and specifies the use of the labels `"instance_id"` and
// `"zone"` to identify particular VM instances.
//
// Different APIs can support different monitored resource types. APIs generally
// provide a `list` method that returns the monitored resource descriptors used
// by the API.
type MonitoredResourceDescriptor struct {
	// Optional. The resource name of the monitored resource descriptor:
	// `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
	// {type} is the value of the `type` field in this object and
	// {project_id} is a project ID that provides API-specific context for
	// accessing the type.  APIs that do not use project information can use the
	// resource name format `"monitoredResourceDescriptors/{type}"`.
	Name string `protobuf:"bytes,5,opt,name=name" json:"name,omitempty"`
	// Required. The monitored resource type. For example, the type
	// `"cloudsql_database"` represents databases in Google Cloud SQL.
	// The maximum length of this value is 256 characters.
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// Optional. A concise name for the monitored resource type that might be
	// displayed in user interfaces. It should be a Title Cased Noun Phrase,
	// without any article or other determiners. For example,
	// `"Google Cloud SQL Database"`.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// Optional. A detailed description of the monitored resource type that might
	// be used in documentation.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// Required. A set of labels used to describe instances of this monitored
	// resource type. For example, an individual Google Cloud SQL database is
	// identified by values for the labels `"database_id"` and `"zone"`.
	Labels []*google_api.LabelDescriptor `protobuf:"bytes,4,rep,name=labels" json:"labels,omitempty"`
}

func (m *MonitoredResourceDescriptor) Reset()                    { *m = MonitoredResourceDescriptor{} }
func (m *MonitoredResourceDescriptor) String() string            { return proto.CompactTextString(m) }
func (*MonitoredResourceDescriptor) ProtoMessage()               {}
func (*MonitoredResourceDescriptor) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *MonitoredResourceDescriptor) GetLabels() []*google_api.LabelDescriptor {
	if m != nil {
		return m.Labels
	}
	return nil
}

// An object representing a resource that can be used for monitoring, logging,
// billing, or other purposes. Examples include virtual machine instances,
// databases, and storage devices such as disks. The `type` field identifies a
// [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor] object that describes the resource's
// schema. Information in the `labels` field identifies the actual resource and
// its attributes according to the schema. For example, a particular Compute
// Engine VM instance could be represented by the following object, because the
// [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor] for `"gce_instance"` has labels
// `"instance_id"` and `"zone"`:
//
//     { "type": "gce_instance",
//       "labels": { "instance_id": "12345678901234",
//                   "zone": "us-central1-a" }}
type MonitoredResource struct {
	// Required. The monitored resource type. This field must match
	// the `type` field of a [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor] object. For
	// example, the type of a Cloud SQL database is `"cloudsql_database"`.
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// Required. Values for all of the labels listed in the associated monitored
	// resource descriptor. For example, Cloud SQL databases use the labels
	// `"database_id"` and `"zone"`.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *MonitoredResource) Reset()                    { *m = MonitoredResource{} }
func (m *MonitoredResource) String() string            { return proto.CompactTextString(m) }
func (*MonitoredResource) ProtoMessage()               {}
func (*MonitoredResource) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *MonitoredResource) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func init() {
	proto.RegisterType((*MonitoredResourceDescriptor)(nil), "google.api.MonitoredResourceDescriptor")
	proto.RegisterType((*MonitoredResource)(nil), "google.api.MonitoredResource")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/monitoredres/monitored_resource.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 324 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xe2, 0xf2, 0x4f, 0xcf, 0xcf, 0x4f,
	0xcf, 0x49, 0xd5, 0x4b, 0xcf, 0xcf, 0x49, 0xcc, 0x4b, 0xd7, 0xcb, 0x2f, 0x4a, 0xd7, 0x4f, 0x4f,
	0xcd, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0xd7, 0x87, 0x48, 0x25, 0x16, 0x64, 0x16, 0xeb, 0x03, 0x09,
	0xfd, 0xdc, 0xfc, 0xbc, 0xcc, 0x92, 0xfc, 0xa2, 0xd4, 0x94, 0xa2, 0xd4, 0x62, 0x04, 0x27, 0x1e,
	0xc8, 0xcb, 0x2f, 0x2d, 0x4a, 0x4e, 0xd5, 0x03, 0x6b, 0x12, 0xe2, 0x82, 0x1a, 0x08, 0xd4, 0x21,
	0x65, 0x4d, 0xbc, 0xe1, 0x39, 0x89, 0x49, 0xa9, 0x39, 0x10, 0x12, 0x62, 0x90, 0xd2, 0x7e, 0x46,
	0x2e, 0x69, 0x5f, 0x98, 0x2d, 0x41, 0x50, 0x4b, 0x5c, 0x52, 0x8b, 0x93, 0x8b, 0x32, 0x0b, 0x80,
	0x62, 0x42, 0x42, 0x5c, 0x2c, 0x79, 0x89, 0xb9, 0xa9, 0x12, 0xac, 0x0a, 0x8c, 0x1a, 0x9c, 0x41,
	0x60, 0x36, 0x48, 0xac, 0xa4, 0xb2, 0x20, 0x55, 0x82, 0x11, 0x22, 0x06, 0x62, 0x0b, 0x29, 0x72,
	0xf1, 0xa4, 0x64, 0x16, 0x17, 0xe4, 0x24, 0x56, 0xc6, 0x83, 0xd5, 0x33, 0x81, 0xe5, 0xb8, 0xa1,
	0x62, 0x7e, 0x20, 0x6d, 0x0a, 0x5c, 0xdc, 0x29, 0x50, 0x83, 0x33, 0xf3, 0xf3, 0x24, 0x98, 0xa1,
	0x2a, 0x10, 0x42, 0x42, 0xc6, 0x5c, 0x6c, 0x60, 0xb7, 0x15, 0x4b, 0xb0, 0x28, 0x30, 0x6b, 0x70,
	0x1b, 0x49, 0xeb, 0x21, 0xbc, 0xa9, 0xe7, 0x03, 0x92, 0x41, 0xb8, 0x2c, 0x08, 0xaa, 0x54, 0x69,
	0x29, 0x23, 0x97, 0x20, 0x86, 0x0f, 0xb0, 0xba, 0xd1, 0x11, 0x6e, 0x3c, 0x13, 0xd8, 0x78, 0x4d,
	0x64, 0xe3, 0x31, 0x8c, 0x80, 0x58, 0x58, 0xec, 0x9a, 0x57, 0x52, 0x54, 0x09, 0xb3, 0x4c, 0xca,
	0x92, 0x8b, 0x1b, 0x49, 0x58, 0x48, 0x80, 0x8b, 0x39, 0x3b, 0xb5, 0x12, 0x6a, 0x09, 0x88, 0x29,
	0x24, 0xc2, 0xc5, 0x5a, 0x96, 0x98, 0x53, 0x0a, 0x0b, 0x00, 0x08, 0xc7, 0x8a, 0xc9, 0x82, 0xd1,
	0x29, 0x87, 0x8b, 0x2f, 0x39, 0x3f, 0x17, 0xc9, 0x4a, 0x27, 0x31, 0x0c, 0x3b, 0x03, 0x40, 0x71,
	0x12, 0xc0, 0x18, 0x65, 0x46, 0x5e, 0x7a, 0xf9, 0xc1, 0xc8, 0xb8, 0x88, 0x89, 0xc5, 0xdd, 0x31,
	0xc0, 0x33, 0x89, 0x0d, 0xac, 0xd8, 0x18, 0x10, 0x00, 0x00, 0xff, 0xff, 0x6b, 0x87, 0xa2, 0x37,
	0x7a, 0x02, 0x00, 0x00,
}
