page_title: README first
page_description: Introduction to project contribution at Docker
page_keywords: Gordon, introduction, turtle, machine, libcontainer, how to

# README first 

This section of the documentation contains a guide for Docker users who want to
contribute code or documentation to the Docker project. As a community, we
share rules of behavior and interaction. Make sure you are familiar with the <a
href="https://github.com/docker/docker/blob/master/CONTRIBUTING.md#docker-community-guidelines"
target="_blank">community guidelines</a> before continuing.

## Where and what you can contribute

The Docker project consists of not just one but several repositories on GitHub.
So, in addition to the `docker/docker` repository, there is the
`docker/libcontainer` repo, the `docker/machine` repo, and several more.
Contribute to any of these and you contribute to the Docker project.

Not all Docker repositories use the Go language. Also, each repository has its
own focus area. So, if you are an experienced contributor, think about
contributing to a Docker repository that has a language or a focus area you are
familiar with.

If you are new to the open source community, to Docker, or to formal
programming, you should start out contributing to the `docker/docker`
repository. Why? Because this guide is written for that repository specifically.

Finally, code or documentation isn't the only way to contribute. You can report
an issue, add to discussions in our community channel, write a blog post, or
take a usability test. You can even propose your own type of contribution.
Right now we don't have a lot written about this yet, so just email
<mailto:feedback@docker.com> if this type of contributing interests you.

## A turtle is involved

![Gordon](/project/images/gordon.jpeg)

Enough said.

## How to use this guide

This is written for the distracted, the overworked, the sloppy reader with fair
`git` skills and a failing memory for the GitHub GUI. The guide attempts to
explain how to use the Docker environment as precisely, predictably, and
procedurally as possible.

Users who are new to the Docker development environment should start by setting
up their environment. Then, they should try a simple code change. After that,
you should find something to work on or propose at totally new change.

If you are a programming prodigy, you still may find this documentation useful.
Please feel free to skim past information you find obvious or boring.

## How to get started

Start by [getting the software you need to contribute](/project/software-required/).
