page_title: About Docker
page_description: Introduction to Docker.
page_keywords: docker, introduction, documentation, about, technology, understanding, Dockerfile

# About Docker

**Develop, Ship and Run Any Application, Anywhere**

## Introduction

[**Docker**](https://www.docker.io) is a platform for developers and
sysadmins to develop, ship, and run applications.  Docker consists of:

* The Docker Engine - our lightweight and powerful open source container
  virtualization technology combined with a work flow to help you build
  and containerize your applications.
* [Docker.io](https://index.docker.io) - our SAAS service that helps you
  share and manage your applications stacks.

Docker enables applications to be quickly assembled from components and
eliminates the friction when shipping code. We want to help you get code
from your desktop, tested and deployed into production as fast as
possible.

## Why Docker?

- **Faster delivery of your applications**  
    * We want to help your environment work better. Docker containers,
      and the work flow that comes with them, helps your developers,
      sysadmins, QA folks, and release engineers work together to get code
      into production and doing something useful. We've created a standard
      container format that allows developers to care about their applications
      inside containers and sysadmins and operators to care about running the
      container. This creates a separation of duties that makes managing and
      deploying code much easier and much more streamlined.
    * We make it easy to build new containers, enable rapid iteration of
      your applications and increase the visibility of changes. This
      helps everyone in your organization understand how an application works
      and how it is built.
    * Docker containers are lightweight and fast! Containers have
      sub-second launch times! With containers you can reduce the cycle
      time in development, testing and deployment.

- **Deploy and scale more easily**  
    * Docker containers run (almost!) everywhere. You can deploy your
      containers on desktops, physical servers, virtual machines, into
      data centers and to public and private clouds.
    * As Docker runs on so many platforms it makes it easy to move your
      appications around. You can easily move an application from a
      testing environment into the cloud and back whenever you need.
    * The lightweight containers Docker creates also making scaling and
      down really fast and easy. If you need more containers you can
      quickly launch them and then shut them down when you don't need them
      anymore.

- **Get higher density and run more workloads**  
    * Docker containers don't need a hypervisor so you can pack more of
      them onto your hosts. This means you get more value out of every
      server and can potentially reduce the money you spend on equipment and
      licenses!

- **Faster deployment makes for easier management**  
    * As Docker speeds up your work flow it makes it easier to make lots
      of little changes instead of huge, big bang updates. Smaller
      changes mean smaller risks and mean more uptime!

## About this guide

First we'll show you [what makes Docker tick in our Understanding Docker
section](introduction/understanding-docker.md):

 - You will find see how Docker works at a high level;
 - The architecture of Docker;
 - Discover Docker's features;
 - See how Docker compares to virtual machines;
 - And see some common use cases.

> [Click here to go to the Understanding
> Docker section](introduction/understanding-docker.md).

Next we get [**practical** with the Working with Docker
section](introduction/working-with-docker.md) and you can learn about:

 - Docker on the command line;
 - Get introduced to your first Docker commands;
 - Get to know your way around the basics of Docker operation.

> [Click here to go to the Working with
> Docker section](introduction/working-with-docker.md).

If you want to see how to install Docker you can jump to the
[installation](/installation/#installation) section.

> **Note**:
> We know how valuable your time is so you if you want to get started
> with Docker straight away don't hesitate to jump to [Working with
> Docker](introduction/working-with-docker.md). For a fuller
> understanding of Docker though we do recommend you read [Understanding
> Docker]( introduction/understanding-docker.md).
