/*
 * See the dyninst/COPYRIGHT file for copyright information.
 * 
 * We provide the Paradyn Tools (below described as "Paradyn")
 * on an AS IS basis, and do not warrant its validity or performance.
 * We reserve the right to update, modify, or discontinue this
 * software at any time.  We shall have no obligation to supply such
 * updates or modifications or any other form of support to you.
 * 
 * By your use of Paradyn, you understand and agree that we (or any
 * other person or entity with proprietary rights in Paradyn) are
 * under no obligation to provide either maintenance services,
 * update services, notices of latent defects, or correction of
 * defects for Paradyn.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "dataflowAPI/src/RegisterMap.h"
#include <boost/assign/list_of.hpp>
#include <map>
#include <boost/config.hpp>

using namespace boost::assign;

// We use the singleton approach, rather than static construction, to ensure the
// register maps are created correctly. In at least one case (Ubuntu 12.04) they 
// weren't. 

namespace Dyninst {
namespace DataflowAPI {

#if !defined(NO_INITIALIZER_LIST_SUPPORT) && !defined(os_windows)
   // This fails on VS2010; revisit when we move to VS2012. 
   // Also on gcc 4.3.

RegisterMap &machRegIndex_x86() {
   static RegisterMap mrmap;
   if (mrmap.empty()) {
      mrmap = { 
         {x86::eax, 0},
         {x86::ecx, 1},
         {x86::edx, 2},
         {x86::ebx, 3},
         {x86::esp, 4},
         {x86::ebp, 5},
         {x86::esi, 6},
         {x86::edi, 7},
         {x86::eip, 8},
         {x86::cf, 9},
         {x86::flag1, 10},
         {x86::pf, 11},
         {x86::flag3, 12},
         {x86::af, 13},
         {x86::flag5, 14},
         {x86::zf, 15},
         {x86::sf, 16},
         {x86::tf, 17},
         {x86::if_, 18},
         {x86::df, 19},
         {x86::of, 20},
         {x86::flagc, 21},
         {x86::flagd, 22},
         {x86::nt_, 23},
         {x86::flagf, 24},
         {x86::rf, 25},
         {x86::ds, 26},
         {x86::es, 27},
         {x86::fs, 28},
         {x86::gs, 29},
         {x86::cs, 30},
         {x86::ss, 31},
         {x86::oeax, 32},
         {x86::fsbase, 33},
         {x86::gsbase, 34},
         {x86::xmm0, 35},
         {x86::xmm1, 36},
         {x86::xmm2, 37},
         {x86::xmm3, 38},
         {x86::xmm4, 39},
         {x86::xmm5, 40},
         {x86::xmm6, 41},
         {x86::xmm7, 42},
         {x86::mm0, 43},  // mm0 to mm7 and st0 to st7 collapse to mm0
         {x86::cr0, 44},
         {x86::cr1, 45},
         {x86::cr2, 46},
         {x86::cr3, 47},
         {x86::cr4, 48},
         {x86::cr5, 49},
         {x86::cr6, 50},
         {x86::cr7, 51},
         {x86::dr0, 52},
         {x86::dr1, 53},
         {x86::dr2, 54},
         {x86::dr3, 55},
         {x86::dr4, 56},
         {x86::dr5, 57},
         {x86::dr6, 58},
         {x86::dr7, 59},
         {x86::tr0, 60},
         {x86::tr1, 61},
         {x86::tr2, 62},
         {x86::tr3, 63},
         {x86::tr4, 64},
         {x86::tr5, 65},
         {x86::tr6, 66},
         {x86::tr7, 67} };
   }
   return mrmap;
}

RegisterMap &machRegIndex_x86_64() {
   static RegisterMap mrmap;
   if (mrmap.empty()) {
      mrmap = {
         {x86_64::rax, 0},
         {x86_64::rcx, 1},
         {x86_64::rdx, 2},
         {x86_64::rbx, 3},
         {x86_64::rsp, 4},
         {x86_64::rbp, 5},
         {x86_64::rsi, 6},
         {x86_64::rdi, 7},
         {x86_64::r8, 8},
         {x86_64::r9, 9},
         {x86_64::r10, 10},
         {x86_64::r11, 11},
         {x86_64::r12, 12},
         {x86_64::r13, 13},
         {x86_64::r14, 14},
         {x86_64::r15, 15},
         {x86_64::rip, 16},
         {x86_64::cf, 17},
         {x86_64::pf, 18},
         {x86_64::af, 19},
         {x86_64::zf, 20},
         {x86_64::sf, 21},
         {x86_64::tf, 22},
         {x86_64::if_, 23},
         {x86_64::df, 24},
         {x86_64::of, 25},
         {x86_64::nt_, 26},
         {x86_64::rf, 27},
         {x86_64::ds, 28},
         {x86_64::es, 29},
         {x86_64::fs, 30},
         {x86_64::gs, 31},
         {x86_64::cs, 32},
         {x86_64::ss, 33},
         {x86_64::orax, 34},
         {x86_64::fsbase, 35},
         {x86_64::gsbase, 36},
         {x86_64::xmm0, 37},
         {x86_64::xmm1, 38},
         {x86_64::xmm2, 39},
         {x86_64::xmm3, 40},
         {x86_64::xmm4, 41},
         {x86_64::xmm5, 42},
         {x86_64::xmm6, 43},
         {x86_64::xmm7, 44},
         {x86_64::xmm8, 45},
         {x86_64::xmm9, 46},
         {x86_64::xmm10, 47},
         {x86_64::xmm11, 48},
         {x86_64::xmm12, 49},
         {x86_64::xmm13, 50},
         {x86_64::xmm14, 51},
         {x86_64::xmm15, 52},
         {x86_64::mm0, 53}, // mm0 to mm7 and st0 to st7 collapse to mm0
         {x86_64::cr0, 54},
         {x86_64::cr1, 55},
         {x86_64::cr2, 56},
         {x86_64::cr3, 57},
         {x86_64::cr4, 58},
         {x86_64::cr5, 59},
         {x86_64::cr6, 60},
         {x86_64::cr7, 61},
         {x86_64::dr0, 62},
         {x86_64::dr1, 63},
         {x86_64::dr2, 64},
         {x86_64::dr3, 65},
         {x86_64::dr4, 66},
         {x86_64::dr5, 67},
         {x86_64::dr6, 68},
         {x86_64::dr7, 69},
         {x86_64::tr0, 70},
         {x86_64::tr1, 71},
         {x86_64::tr2, 72},
         {x86_64::tr3, 73},
         {x86_64::tr4, 74},
         {x86_64::tr5, 75},
         {x86_64::tr6, 76},
         {x86_64::tr7, 77} 
      };
   }
   return mrmap;
}

RegisterMap &machRegIndex_ppc() {
   static RegisterMap mrmap;
   if (mrmap.empty()) {
      mrmap = {
         {ppc32::r0, 0},
         {ppc32::r1, 1},
         {ppc32::r2, 2},
         {ppc32::r3, 3},
         {ppc32::r4, 4},
         {ppc32::r5, 5},
         {ppc32::r6, 6},
         {ppc32::r7, 7},
         {ppc32::r8, 8},
         {ppc32::r9, 9},
         {ppc32::r10, 10},
         {ppc32::r11, 11},
         {ppc32::r12, 12},
         {ppc32::r13, 13},
         {ppc32::r14, 14},
         {ppc32::r15, 15},
         {ppc32::r16, 16},
         {ppc32::r17, 17},
         {ppc32::r18, 18},
         {ppc32::r19, 19},
         {ppc32::r20, 20},
         {ppc32::r21, 21},
         {ppc32::r22, 22},
         {ppc32::r23, 23},
         {ppc32::r24, 24},
         {ppc32::r25, 25},
         {ppc32::r26, 26},
         {ppc32::r27, 27},
         {ppc32::r28, 28},
         {ppc32::r29, 29},
         {ppc32::r30, 30},
         {ppc32::r31, 31},
         {ppc32::fpr0, 32},
         {ppc32::fpr1, 33},
         {ppc32::fpr2, 34},
         {ppc32::fpr3, 35},
         {ppc32::fpr4, 36},
         {ppc32::fpr5, 37},
         {ppc32::fpr6, 38},
         {ppc32::fpr7, 39},
         {ppc32::fpr8, 40},
         {ppc32::fpr9, 41},
         {ppc32::fpr10, 42},
         {ppc32::fpr11, 43},
         {ppc32::fpr12, 44},
         {ppc32::fpr13, 45},
         {ppc32::fpr14, 46},
         {ppc32::fpr15, 47},
         {ppc32::fpr16, 48},
         {ppc32::fpr17, 49},
         {ppc32::fpr18, 50},
         {ppc32::fpr19, 51},
         {ppc32::fpr20, 52},
         {ppc32::fpr21, 53},
         {ppc32::fpr22, 54},
         {ppc32::fpr23, 55},
         {ppc32::fpr24, 56},
         {ppc32::fpr25, 57},
         {ppc32::fpr26, 58},
         {ppc32::fpr27, 59},
         {ppc32::fpr28, 60},
         {ppc32::fpr29, 61},
         {ppc32::fpr30, 62},
         {ppc32::fpr31, 63},
         {ppc32::fsr0, 64},
         {ppc32::fsr1, 65},
         {ppc32::fsr2, 66},
         {ppc32::fsr3, 67},
         {ppc32::fsr4, 68},
         {ppc32::fsr5, 69},
         {ppc32::fsr6, 70},
         {ppc32::fsr7, 71},
         {ppc32::fsr8, 72},
         {ppc32::fsr9, 73},
         {ppc32::fsr10, 74},
         {ppc32::fsr11, 75},
         {ppc32::fsr12, 76},
         {ppc32::fsr13, 77},
         {ppc32::fsr14, 78},
         {ppc32::fsr15, 79},
         {ppc32::fsr16, 80},
         {ppc32::fsr17, 81},
         {ppc32::fsr18, 82},
         {ppc32::fsr19, 83},
         {ppc32::fsr20, 84},
         {ppc32::fsr21, 85},
         {ppc32::fsr22, 86},
         {ppc32::fsr23, 87},
         {ppc32::fsr24, 88},
         {ppc32::fsr25, 89},
         {ppc32::fsr26, 90},
         {ppc32::fsr27, 91},
         {ppc32::fsr28, 92},
         {ppc32::fsr29, 93},
         {ppc32::fsr30, 94},
         {ppc32::fsr31, 95},
         {ppc32::mq, 96},
         {ppc32::xer, 97},
         {ppc32::lr, 98},
         {ppc32::ctr, 99},
         {ppc32::dsisr, 100},
         {ppc32::dar, 101},
         {ppc32::dec, 102},
         {ppc32::sdr1, 103},
         {ppc32::srr0, 104},
         {ppc32::srr1, 105},
         {ppc32::sprg0, 106},
         {ppc32::sprg1, 107},
         {ppc32::sprg2, 108},
         {ppc32::sprg3, 109},
         {ppc32::sprg3_ro, 109},
         {ppc32::ear, 110},
         {ppc32::tbl_wo, 111},
         {ppc32::tbl_ro, 111},
         {ppc32::tbu_wo, 112},
         {ppc32::tbu_ro, 112},
         {ppc32::pvr, 113},
         {ppc32::ibat0u, 114},
         {ppc32::ibat0l, 115},
         {ppc32::ibat1u, 116},
         {ppc32::ibat1l, 117},
         {ppc32::ibat2u, 118},
         {ppc32::ibat2l, 119},
         {ppc32::ibat3u, 120},
         {ppc32::ibat3l, 121},
         {ppc32::dbat0u, 122},
         {ppc32::dbat0l, 123},
         {ppc32::dbat1u, 124},
         {ppc32::dbat1l, 125},
         {ppc32::dbat2u, 126},
         {ppc32::dbat2l, 127},
         {ppc32::dbat3u, 128},
         {ppc32::dbat3l, 129},
         {ppc32::pc, 130},
         {ppc32::fpscw, 131},
         {ppc32::fpscw0, 132},
         {ppc32::fpscw1, 133},
         {ppc32::fpscw2, 134},
         {ppc32::fpscw3, 135},
         {ppc32::fpscw4, 136},
         {ppc32::fpscw5, 137},
         {ppc32::fpscw6, 138},
         {ppc32::fpscw7, 139},
         {ppc32::msr, 140},
         {ppc32::ivpr, 141},
         {ppc32::ivor8, 142},
         {ppc32::seg0, 143},
         {ppc32::seg1, 144},
         {ppc32::seg2, 145},
         {ppc32::seg3, 146},
         {ppc32::seg4, 147},
         {ppc32::seg5, 148},
         {ppc32::seg6, 149},
         {ppc32::seg7, 150},
         {ppc32::cr0, 151},
         {ppc32::cr1, 152},
         {ppc32::cr2, 153},
         {ppc32::cr3, 154},
         {ppc32::cr4, 155},
         {ppc32::cr5, 156},
         {ppc32::cr6, 157},
         {ppc32::cr7, 158},
         {ppc32::cr, 159},
         {ppc32::sprg4, 160},
         {ppc32::sprg4_ro, 160},
         {ppc32::sprg5, 161},
         {ppc32::sprg5_ro, 161},
         {ppc32::sprg6, 162},
         {ppc32::sprg6_ro, 162},
         {ppc32::sprg7, 163},
         {ppc32::sprg7_ro, 163}
   };
   }
   return mrmap;
}

RegisterMap &machRegIndex_ppc_64() {
   static RegisterMap mrmap;
   if (mrmap.empty()) {
      mrmap = {
         {ppc64::r0, 0},
         {ppc64::r1, 1},
         {ppc64::r2, 2},
         {ppc64::r3, 3},
         {ppc64::r4, 4},
         {ppc64::r5, 5},
         {ppc64::r6, 6},
         {ppc64::r7, 7},
         {ppc64::r8, 8},
         {ppc64::r9, 9},
         {ppc64::r10, 10},
         {ppc64::r11, 11},
         {ppc64::r12, 12},
         {ppc64::r13, 13},
         {ppc64::r14, 14},
         {ppc64::r15, 15},
         {ppc64::r16, 16},
         {ppc64::r17, 17},
         {ppc64::r18, 18},
         {ppc64::r19, 19},
         {ppc64::r20, 20},
         {ppc64::r21, 21},
         {ppc64::r22, 22},
         {ppc64::r23, 23},
         {ppc64::r24, 24},
         {ppc64::r25, 25},
         {ppc64::r26, 26},
         {ppc64::r27, 27},
         {ppc64::r28, 28},
         {ppc64::r29, 29},
         {ppc64::r30, 30},
         {ppc64::r31, 31},
         {ppc64::fpr0, 32},
         {ppc64::fpr1, 33},
         {ppc64::fpr2, 34},
         {ppc64::fpr3, 35},
         {ppc64::fpr4, 36},
         {ppc64::fpr5, 37},
         {ppc64::fpr6, 38},
         {ppc64::fpr7, 39},
         {ppc64::fpr8, 40},
         {ppc64::fpr9, 41},
         {ppc64::fpr10, 42},
         {ppc64::fpr11, 43},
         {ppc64::fpr12, 44},
         {ppc64::fpr13, 45},
         {ppc64::fpr14, 46},
         {ppc64::fpr15, 47},
         {ppc64::fpr16, 48},
         {ppc64::fpr17, 49},
         {ppc64::fpr18, 50},
         {ppc64::fpr19, 51},
         {ppc64::fpr20, 52},
         {ppc64::fpr21, 53},
         {ppc64::fpr22, 54},
         {ppc64::fpr23, 55},
         {ppc64::fpr24, 56},
         {ppc64::fpr25, 57},
         {ppc64::fpr26, 58},
         {ppc64::fpr27, 59},
         {ppc64::fpr28, 60},
         {ppc64::fpr29, 61},
         {ppc64::fpr30, 62},
         {ppc64::fpr31, 63},
         {ppc64::fsr0, 64},
         {ppc64::fsr1, 65},
         {ppc64::fsr2, 66},
         {ppc64::fsr3, 67},
         {ppc64::fsr4, 68},
         {ppc64::fsr5, 69},
         {ppc64::fsr6, 70},
         {ppc64::fsr7, 71},
         {ppc64::fsr8, 72},
         {ppc64::fsr9, 73},
         {ppc64::fsr10, 74},
         {ppc64::fsr11, 75},
         {ppc64::fsr12, 76},
         {ppc64::fsr13, 77},
         {ppc64::fsr14, 78},
         {ppc64::fsr15, 79},
         {ppc64::fsr16, 80},
         {ppc64::fsr17, 81},
         {ppc64::fsr18, 82},
         {ppc64::fsr19, 83},
         {ppc64::fsr20, 84},
         {ppc64::fsr21, 85},
         {ppc64::fsr22, 86},
         {ppc64::fsr23, 87},
         {ppc64::fsr24, 88},
         {ppc64::fsr25, 89},
         {ppc64::fsr26, 90},
         {ppc64::fsr27, 91},
         {ppc64::fsr28, 92},
         {ppc64::fsr29, 93},
         {ppc64::fsr30, 94},
         {ppc64::fsr31, 95},
         {ppc64::mq, 96},
         {ppc64::xer, 97},
         {ppc64::lr, 98},
         {ppc64::ctr, 99},
         {ppc64::dsisr, 100},
         {ppc64::dar, 101},
         {ppc64::dec, 102},
         {ppc64::sdr1, 103},
         {ppc64::srr0, 104},
         {ppc64::srr1, 105},
         {ppc64::sprg0, 106},
         {ppc64::sprg1, 107},
         {ppc64::sprg2, 108},
         {ppc64::sprg3, 109},
         {ppc64::sprg3_ro, 109},
         {ppc64::ear, 110},
         {ppc64::tbl_wo, 111},
         {ppc64::tbl_ro, 111},
         {ppc64::tbu_wo, 112},
         {ppc64::tbu_ro, 112},
         {ppc64::pvr, 113},
         {ppc64::ibat0u, 114},
         {ppc64::ibat0l, 115},
         {ppc64::ibat1u, 116},
         {ppc64::ibat1l, 117},
         {ppc64::ibat2u, 118},
         {ppc64::ibat2l, 119},
         {ppc64::ibat3u, 120},
         {ppc64::ibat3l, 121},
         {ppc64::dbat0u, 122},
         {ppc64::dbat0l, 123},
         {ppc64::dbat1u, 124},
         {ppc64::dbat1l, 125},
         {ppc64::dbat2u, 126},
         {ppc64::dbat2l, 127},
         {ppc64::dbat3u, 128},
         {ppc64::dbat3l, 129},
         {ppc64::pc, 130},
         {ppc64::fpscw, 131},
         {ppc64::fpscw0, 132},
         {ppc64::fpscw1, 133},
         {ppc64::fpscw2, 134},
         {ppc64::fpscw3, 135},
         {ppc64::fpscw4, 136},
         {ppc64::fpscw5, 137},
         {ppc64::fpscw6, 138},
         {ppc64::fpscw7, 139},
         {ppc64::msr, 140},
         {ppc64::ivpr, 141},
         {ppc64::ivor8, 142},
         {ppc64::seg0, 143},
         {ppc64::seg1, 144},
         {ppc64::seg2, 145},
         {ppc64::seg3, 146},
         {ppc64::seg4, 147},
         {ppc64::seg5, 148},
         {ppc64::seg6, 149},
         {ppc64::seg7, 150},
         {ppc64::cr0, 151},
         {ppc64::cr1, 152},
         {ppc64::cr2, 153},
         {ppc64::cr3, 154},
         {ppc64::cr4, 155},
         {ppc64::cr5, 156},
         {ppc64::cr6, 157},
         {ppc64::cr7, 158},
         {ppc64::cr, 159},
         {ppc64::sprg4, 160},
         {ppc64::sprg4_ro, 160},
         {ppc64::sprg5, 161},
         {ppc64::sprg5_ro, 161},
         {ppc64::sprg6, 162},
         {ppc64::sprg6_ro, 162},
         {ppc64::sprg7, 163},
         {ppc64::sprg7_ro, 163}
   };
   }
   return mrmap;
}

#else

RegisterMap &machRegIndex_x86() {
   static RegisterMap mrmap;
   if (mrmap.empty()) {
      mrmap = map_list_of
         (x86::eax, 0)
         (x86::ecx, 1)
         (x86::edx, 2)
         (x86::ebx, 3)
         (x86::esp, 4)
         (x86::ebp, 5)
         (x86::esi, 6)
         (x86::edi, 7)
         (x86::eip, 8)
         (x86::cf, 9)
         (x86::flag1, 10)
         (x86::pf, 11)
         (x86::flag3, 12)
         (x86::af, 13)
         (x86::flag5, 14)
         (x86::zf, 15)
         (x86::sf, 16)
         (x86::tf, 17)
         (x86::if_, 18)
         (x86::df, 19)
         (x86::of, 20)
         (x86::flagc, 21)
         (x86::flagd, 22)
         (x86::nt_, 23)
         (x86::flagf, 24)
         (x86::rf, 25)
         (x86::ds, 26)
         (x86::es, 27)
         (x86::fs, 28)
         (x86::gs, 29)
         (x86::cs, 30)
         (x86::ss, 31)
         (x86::oeax, 32)
         (x86::fsbase, 33)
         (x86::gsbase, 34)
         (x86::xmm0, 35)
         (x86::xmm1, 36)
         (x86::xmm2, 37)
         (x86::xmm3, 38)
         (x86::xmm4, 39)
         (x86::xmm5, 40)
         (x86::xmm6, 41)
         (x86::xmm7, 42)
         (x86::mm0, 43)  // mm0 to mm7 and st0 to st7 collapse to mm0
         (x86::cr0, 44)
         (x86::cr1, 45)
         (x86::cr2, 46)
         (x86::cr3, 47)
         (x86::cr4, 48)
         (x86::cr5, 49)
         (x86::cr6, 50)
         (x86::cr7, 51)
         (x86::dr0, 52)
         (x86::dr1, 53)
         (x86::dr2, 54)
         (x86::dr3, 55)
         (x86::dr4, 56)
         (x86::dr5, 57)
         (x86::dr6, 58)
         (x86::dr7, 59)
         (x86::tr0, 60)
         (x86::tr1, 61)
         (x86::tr2, 62)
         (x86::tr3, 63)
         (x86::tr4, 64)
         (x86::tr5, 65)
         (x86::tr6, 66)
         (x86::tr7, 67);
   }
   return mrmap;
}

RegisterMap &machRegIndex_x86_64() {
   static RegisterMap mrmap;
   if (mrmap.empty()) {
      mrmap = map_list_of
         (x86_64::rax, 0)
         (x86_64::rcx, 1)
         (x86_64::rdx, 2)
         (x86_64::rbx, 3)
         (x86_64::rsp, 4)
         (x86_64::rbp, 5)
         (x86_64::rsi, 6)
         (x86_64::rdi, 7)
         (x86_64::r8, 8)
         (x86_64::r9, 9)
         (x86_64::r10, 10)
         (x86_64::r11, 11)
         (x86_64::r12, 12)
         (x86_64::r13, 13)
         (x86_64::r14, 14)
         (x86_64::r15, 15)
         (x86_64::rip, 16)
         (x86_64::cf, 17)
         (x86_64::pf, 18)
         (x86_64::af, 19)
         (x86_64::zf, 20)
         (x86_64::sf, 21)
         (x86_64::tf, 22)
         (x86_64::if_, 23)
         (x86_64::df, 24)
         (x86_64::of, 25)
         (x86_64::nt_, 26)
         (x86_64::rf, 27)
         (x86_64::ds, 28)
         (x86_64::es, 29)
         (x86_64::fs, 30)
         (x86_64::gs, 31)
         (x86_64::cs, 32)
         (x86_64::ss, 33)
         (x86_64::orax, 34)
         (x86_64::fsbase, 35)
         (x86_64::gsbase, 36)
         (x86_64::xmm0, 37)
         (x86_64::xmm1, 38)
         (x86_64::xmm2, 39)
         (x86_64::xmm3, 40)
         (x86_64::xmm4, 41)
         (x86_64::xmm5, 42)
         (x86_64::xmm6, 43)
         (x86_64::xmm7, 44)
         (x86_64::xmm8, 45)
         (x86_64::xmm9, 46)
         (x86_64::xmm10, 47)
         (x86_64::xmm11, 48)
         (x86_64::xmm12, 49)
         (x86_64::xmm13, 50)
         (x86_64::xmm14, 51)
         (x86_64::xmm15, 52)
         (x86_64::mm0, 53) // mm0 to mm7 and st0 to st7 collapse to mm0
         (x86_64::cr0, 54)
         (x86_64::cr1, 55)
         (x86_64::cr2, 56)
         (x86_64::cr3, 57)
         (x86_64::cr4, 58)
         (x86_64::cr5, 59)
         (x86_64::cr6, 60)
         (x86_64::cr7, 61)
         (x86_64::dr0, 62)
         (x86_64::dr1, 63)
         (x86_64::dr2, 64)
         (x86_64::dr3, 65)
         (x86_64::dr4, 66)
         (x86_64::dr5, 67)
         (x86_64::dr6, 68)
         (x86_64::dr7, 69)
         (x86_64::tr0, 70)
         (x86_64::tr1, 71)
         (x86_64::tr2, 72)
         (x86_64::tr3, 73)
         (x86_64::tr4, 74)
         (x86_64::tr5, 75)
         (x86_64::tr6, 76)
         (x86_64::tr7, 77)
         ;
   }
   return mrmap;
}

RegisterMap &machRegIndex_ppc() {
   static RegisterMap mrmap;
   if (mrmap.empty()) {
      mrmap = map_list_of
         (ppc32::r0, 0)
         (ppc32::r1, 1)
         (ppc32::r2, 2)
         (ppc32::r3, 3)
         (ppc32::r4, 4)
         (ppc32::r5, 5)
         (ppc32::r6, 6)
         (ppc32::r7, 7)
         (ppc32::r8, 8)
         (ppc32::r9, 9)
         (ppc32::r10, 10)
         (ppc32::r11, 11)
         (ppc32::r12, 12)
         (ppc32::r13, 13)
         (ppc32::r14, 14)
         (ppc32::r15, 15)
         (ppc32::r16, 16)
         (ppc32::r17, 17)
         (ppc32::r18, 18)
         (ppc32::r19, 19)
         (ppc32::r20, 20)
         (ppc32::r21, 21)
         (ppc32::r22, 22)
         (ppc32::r23, 23)
         (ppc32::r24, 24)
         (ppc32::r25, 25)
         (ppc32::r26, 26)
         (ppc32::r27, 27)
         (ppc32::r28, 28)
         (ppc32::r29, 29)
         (ppc32::r30, 30)
         (ppc32::r31, 31)
         (ppc32::fpr0, 32)
         (ppc32::fpr1, 33)
         (ppc32::fpr2, 34)
         (ppc32::fpr3, 35)
         (ppc32::fpr4, 36)
         (ppc32::fpr5, 37)
         (ppc32::fpr6, 38)
         (ppc32::fpr7, 39)
         (ppc32::fpr8, 40)
         (ppc32::fpr9, 41)
         (ppc32::fpr10, 42)
         (ppc32::fpr11, 43)
         (ppc32::fpr12, 44)
         (ppc32::fpr13, 45)
         (ppc32::fpr14, 46)
         (ppc32::fpr15, 47)
         (ppc32::fpr16, 48)
         (ppc32::fpr17, 49)
         (ppc32::fpr18, 50)
         (ppc32::fpr19, 51)
         (ppc32::fpr20, 52)
         (ppc32::fpr21, 53)
         (ppc32::fpr22, 54)
         (ppc32::fpr23, 55)
         (ppc32::fpr24, 56)
         (ppc32::fpr25, 57)
         (ppc32::fpr26, 58)
         (ppc32::fpr27, 59)
         (ppc32::fpr28, 60)
         (ppc32::fpr29, 61)
         (ppc32::fpr30, 62)
         (ppc32::fpr31, 63)
         (ppc32::fsr0, 64)
         (ppc32::fsr1, 65)
         (ppc32::fsr2, 66)
         (ppc32::fsr3, 67)
         (ppc32::fsr4, 68)
         (ppc32::fsr5, 69)
         (ppc32::fsr6, 70)
         (ppc32::fsr7, 71)
         (ppc32::fsr8, 72)
         (ppc32::fsr9, 73)
         (ppc32::fsr10, 74)
         (ppc32::fsr11, 75)
         (ppc32::fsr12, 76)
         (ppc32::fsr13, 77)
         (ppc32::fsr14, 78)
         (ppc32::fsr15, 79)
         (ppc32::fsr16, 80)
         (ppc32::fsr17, 81)
         (ppc32::fsr18, 82)
         (ppc32::fsr19, 83)
         (ppc32::fsr20, 84)
         (ppc32::fsr21, 85)
         (ppc32::fsr22, 86)
         (ppc32::fsr23, 87)
         (ppc32::fsr24, 88)
         (ppc32::fsr25, 89)
         (ppc32::fsr26, 90)
         (ppc32::fsr27, 91)
         (ppc32::fsr28, 92)
         (ppc32::fsr29, 93)
         (ppc32::fsr30, 94)
         (ppc32::fsr31, 95)
         (ppc32::mq, 96)
         (ppc32::xer, 97)
         (ppc32::lr, 98)
         (ppc32::ctr, 99)
         (ppc32::dsisr, 100)
         (ppc32::dar, 101)
         (ppc32::dec, 102)
         (ppc32::sdr1, 103)
         (ppc32::srr0, 104)
         (ppc32::srr1, 105)
         (ppc32::sprg0, 106)
         (ppc32::sprg1, 107)
         (ppc32::sprg2, 108)
         (ppc32::sprg3, 109)
         (ppc32::sprg3_ro, 109)
         (ppc32::ear, 110)
         (ppc32::tbl_wo, 111)
         (ppc32::tbl_ro, 111)
         (ppc32::tbu_wo, 112)
         (ppc32::tbu_ro, 112)
         (ppc32::pvr, 113)
         (ppc32::ibat0u, 114)
         (ppc32::ibat0l, 115)
         (ppc32::ibat1u, 116)
         (ppc32::ibat1l, 117)
         (ppc32::ibat2u, 118)
         (ppc32::ibat2l, 119)
         (ppc32::ibat3u, 120)
         (ppc32::ibat3l, 121)
         (ppc32::dbat0u, 122)
         (ppc32::dbat0l, 123)
         (ppc32::dbat1u, 124)
         (ppc32::dbat1l, 125)
         (ppc32::dbat2u, 126)
         (ppc32::dbat2l, 127)
         (ppc32::dbat3u, 128)
         (ppc32::dbat3l, 129)
         (ppc32::pc, 130)
         (ppc32::fpscw, 131)
         (ppc32::fpscw0, 132)
         (ppc32::fpscw1, 133)
         (ppc32::fpscw2, 134)
         (ppc32::fpscw3, 135)
         (ppc32::fpscw4, 136)
         (ppc32::fpscw5, 137)
         (ppc32::fpscw6, 138)
         (ppc32::fpscw7, 139)
         (ppc32::msr, 140)
         (ppc32::ivpr, 141)
         (ppc32::ivor8, 142)
         (ppc32::seg0, 143)
         (ppc32::seg1, 144)
         (ppc32::seg2, 145)
         (ppc32::seg3, 146)
         (ppc32::seg4, 147)
         (ppc32::seg5, 148)
         (ppc32::seg6, 149)
         (ppc32::seg7, 150)
         (ppc32::cr0, 151)
         (ppc32::cr1, 152)
         (ppc32::cr2, 153)
         (ppc32::cr3, 154)
         (ppc32::cr4, 155)
         (ppc32::cr5, 156)
         (ppc32::cr6, 157)
         (ppc32::cr7, 158)
         (ppc32::cr, 159)
         (ppc32::sprg4, 160)
         (ppc32::sprg4_ro, 160)
         (ppc32::sprg5, 161)
         (ppc32::sprg5_ro, 161)
         (ppc32::sprg6, 162)
         (ppc32::sprg6_ro, 162)
         (ppc32::sprg7, 163)
         (ppc32::sprg7_ro, 163);
   }
   return mrmap;
}

RegisterMap &machRegIndex_ppc_64() {
   static RegisterMap mrmap;
   if (mrmap.empty()) {
      mrmap = map_list_of
         (ppc64::r0, 0)
         (ppc64::r1, 1)
         (ppc64::r2, 2)
         (ppc64::r3, 3)
         (ppc64::r4, 4)
         (ppc64::r5, 5)
         (ppc64::r6, 6)
         (ppc64::r7, 7)
         (ppc64::r8, 8)
         (ppc64::r9, 9)
         (ppc64::r10, 10)
         (ppc64::r11, 11)
         (ppc64::r12, 12)
         (ppc64::r13, 13)
         (ppc64::r14, 14)
         (ppc64::r15, 15)
         (ppc64::r16, 16)
         (ppc64::r17, 17)
         (ppc64::r18, 18)
         (ppc64::r19, 19)
         (ppc64::r20, 20)
         (ppc64::r21, 21)
         (ppc64::r22, 22)
         (ppc64::r23, 23)
         (ppc64::r24, 24)
         (ppc64::r25, 25)
         (ppc64::r26, 26)
         (ppc64::r27, 27)
         (ppc64::r28, 28)
         (ppc64::r29, 29)
         (ppc64::r30, 30)
         (ppc64::r31, 31)
         (ppc64::fpr0, 32)
         (ppc64::fpr1, 33)
         (ppc64::fpr2, 34)
         (ppc64::fpr3, 35)
         (ppc64::fpr4, 36)
         (ppc64::fpr5, 37)
         (ppc64::fpr6, 38)
         (ppc64::fpr7, 39)
         (ppc64::fpr8, 40)
         (ppc64::fpr9, 41)
         (ppc64::fpr10, 42)
         (ppc64::fpr11, 43)
         (ppc64::fpr12, 44)
         (ppc64::fpr13, 45)
         (ppc64::fpr14, 46)
         (ppc64::fpr15, 47)
         (ppc64::fpr16, 48)
         (ppc64::fpr17, 49)
         (ppc64::fpr18, 50)
         (ppc64::fpr19, 51)
         (ppc64::fpr20, 52)
         (ppc64::fpr21, 53)
         (ppc64::fpr22, 54)
         (ppc64::fpr23, 55)
         (ppc64::fpr24, 56)
         (ppc64::fpr25, 57)
         (ppc64::fpr26, 58)
         (ppc64::fpr27, 59)
         (ppc64::fpr28, 60)
         (ppc64::fpr29, 61)
         (ppc64::fpr30, 62)
         (ppc64::fpr31, 63)
         (ppc64::fsr0, 64)
         (ppc64::fsr1, 65)
         (ppc64::fsr2, 66)
         (ppc64::fsr3, 67)
         (ppc64::fsr4, 68)
         (ppc64::fsr5, 69)
         (ppc64::fsr6, 70)
         (ppc64::fsr7, 71)
         (ppc64::fsr8, 72)
         (ppc64::fsr9, 73)
         (ppc64::fsr10, 74)
         (ppc64::fsr11, 75)
         (ppc64::fsr12, 76)
         (ppc64::fsr13, 77)
         (ppc64::fsr14, 78)
         (ppc64::fsr15, 79)
         (ppc64::fsr16, 80)
         (ppc64::fsr17, 81)
         (ppc64::fsr18, 82)
         (ppc64::fsr19, 83)
         (ppc64::fsr20, 84)
         (ppc64::fsr21, 85)
         (ppc64::fsr22, 86)
         (ppc64::fsr23, 87)
         (ppc64::fsr24, 88)
         (ppc64::fsr25, 89)
         (ppc64::fsr26, 90)
         (ppc64::fsr27, 91)
         (ppc64::fsr28, 92)
         (ppc64::fsr29, 93)
         (ppc64::fsr30, 94)
         (ppc64::fsr31, 95)
         (ppc64::mq, 96)
         (ppc64::xer, 97)
         (ppc64::lr, 98)
         (ppc64::ctr, 99)
         (ppc64::dsisr, 100)
         (ppc64::dar, 101)
         (ppc64::dec, 102)
         (ppc64::sdr1, 103)
         (ppc64::srr0, 104)
         (ppc64::srr1, 105)
         (ppc64::sprg0, 106)
         (ppc64::sprg1, 107)
         (ppc64::sprg2, 108)
         (ppc64::sprg3, 109)
         (ppc64::sprg3_ro, 109)
         (ppc64::ear, 110)
         (ppc64::tbl_wo, 111)
         (ppc64::tbl_ro, 111)
         (ppc64::tbu_wo, 112)
         (ppc64::tbu_ro, 112)
         (ppc64::pvr, 113)
         (ppc64::ibat0u, 114)
         (ppc64::ibat0l, 115)
         (ppc64::ibat1u, 116)
         (ppc64::ibat1l, 117)
         (ppc64::ibat2u, 118)
         (ppc64::ibat2l, 119)
         (ppc64::ibat3u, 120)
         (ppc64::ibat3l, 121)
         (ppc64::dbat0u, 122)
         (ppc64::dbat0l, 123)
         (ppc64::dbat1u, 124)
         (ppc64::dbat1l, 125)
         (ppc64::dbat2u, 126)
         (ppc64::dbat2l, 127)
         (ppc64::dbat3u, 128)
         (ppc64::dbat3l, 129)
         (ppc64::pc, 130)
         (ppc64::fpscw, 131)
         (ppc64::fpscw0, 132)
         (ppc64::fpscw1, 133)
         (ppc64::fpscw2, 134)
         (ppc64::fpscw3, 135)
         (ppc64::fpscw4, 136)
         (ppc64::fpscw5, 137)
         (ppc64::fpscw6, 138)
         (ppc64::fpscw7, 139)
         (ppc64::msr, 140)
         (ppc64::ivpr, 141)
         (ppc64::ivor8, 142)
         (ppc64::seg0, 143)
         (ppc64::seg1, 144)
         (ppc64::seg2, 145)
         (ppc64::seg3, 146)
         (ppc64::seg4, 147)
         (ppc64::seg5, 148)
         (ppc64::seg6, 149)
         (ppc64::seg7, 150)
         (ppc64::cr0, 151)
         (ppc64::cr1, 152)
         (ppc64::cr2, 153)
         (ppc64::cr3, 154)
         (ppc64::cr4, 155)
         (ppc64::cr5, 156)
         (ppc64::cr6, 157)
         (ppc64::cr7, 158)
         (ppc64::cr, 159)
         (ppc64::sprg4, 160)
         (ppc64::sprg4_ro, 160)
         (ppc64::sprg5, 161)
         (ppc64::sprg5_ro, 161)
         (ppc64::sprg6, 162)
         (ppc64::sprg6_ro, 162)
         (ppc64::sprg7, 163)
         (ppc64::sprg7_ro, 163);
   }
   return mrmap;
}

#endif

};
};
