// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package ec2 provides a client for Amazon Elastic Compute Cloud.
package ec2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/ec2query"
)

const opAcceptReservedInstancesExchangeQuote = "AcceptReservedInstancesExchangeQuote"

// AcceptReservedInstancesExchangeQuoteRequest generates a "aws/request.Request" representing the
// client's request for the AcceptReservedInstancesExchangeQuote operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AcceptReservedInstancesExchangeQuote for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AcceptReservedInstancesExchangeQuote method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AcceptReservedInstancesExchangeQuoteRequest method.
//    req, resp := client.AcceptReservedInstancesExchangeQuoteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote
func (c *EC2) AcceptReservedInstancesExchangeQuoteRequest(input *AcceptReservedInstancesExchangeQuoteInput) (req *request.Request, output *AcceptReservedInstancesExchangeQuoteOutput) {
	op := &request.Operation{
		Name:       opAcceptReservedInstancesExchangeQuote,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptReservedInstancesExchangeQuoteInput{}
	}

	output = &AcceptReservedInstancesExchangeQuoteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptReservedInstancesExchangeQuote API operation for Amazon Elastic Compute Cloud.
//
// Accepts the Convertible Reserved Instance exchange quote described in the
// GetReservedInstancesExchangeQuote call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptReservedInstancesExchangeQuote for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote
func (c *EC2) AcceptReservedInstancesExchangeQuote(input *AcceptReservedInstancesExchangeQuoteInput) (*AcceptReservedInstancesExchangeQuoteOutput, error) {
	req, out := c.AcceptReservedInstancesExchangeQuoteRequest(input)
	err := req.Send()
	return out, err
}

const opAcceptVpcPeeringConnection = "AcceptVpcPeeringConnection"

// AcceptVpcPeeringConnectionRequest generates a "aws/request.Request" representing the
// client's request for the AcceptVpcPeeringConnection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AcceptVpcPeeringConnection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AcceptVpcPeeringConnection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AcceptVpcPeeringConnectionRequest method.
//    req, resp := client.AcceptVpcPeeringConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection
func (c *EC2) AcceptVpcPeeringConnectionRequest(input *AcceptVpcPeeringConnectionInput) (req *request.Request, output *AcceptVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opAcceptVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptVpcPeeringConnectionInput{}
	}

	output = &AcceptVpcPeeringConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptVpcPeeringConnection API operation for Amazon Elastic Compute Cloud.
//
// Accept a VPC peering connection request. To accept a request, the VPC peering
// connection must be in the pending-acceptance state, and you must be the owner
// of the peer VPC. Use the DescribeVpcPeeringConnections request to view your
// outstanding VPC peering connection requests.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptVpcPeeringConnection for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection
func (c *EC2) AcceptVpcPeeringConnection(input *AcceptVpcPeeringConnectionInput) (*AcceptVpcPeeringConnectionOutput, error) {
	req, out := c.AcceptVpcPeeringConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opAllocateAddress = "AllocateAddress"

// AllocateAddressRequest generates a "aws/request.Request" representing the
// client's request for the AllocateAddress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AllocateAddress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AllocateAddress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AllocateAddressRequest method.
//    req, resp := client.AllocateAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress
func (c *EC2) AllocateAddressRequest(input *AllocateAddressInput) (req *request.Request, output *AllocateAddressOutput) {
	op := &request.Operation{
		Name:       opAllocateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateAddressInput{}
	}

	output = &AllocateAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateAddress API operation for Amazon Elastic Compute Cloud.
//
// Acquires an Elastic IP address.
//
// An Elastic IP address is for use either in the EC2-Classic platform or in
// a VPC. For more information, see Elastic IP Addresses (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AllocateAddress for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress
func (c *EC2) AllocateAddress(input *AllocateAddressInput) (*AllocateAddressOutput, error) {
	req, out := c.AllocateAddressRequest(input)
	err := req.Send()
	return out, err
}

const opAllocateHosts = "AllocateHosts"

// AllocateHostsRequest generates a "aws/request.Request" representing the
// client's request for the AllocateHosts operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AllocateHosts for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AllocateHosts method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AllocateHostsRequest method.
//    req, resp := client.AllocateHostsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts
func (c *EC2) AllocateHostsRequest(input *AllocateHostsInput) (req *request.Request, output *AllocateHostsOutput) {
	op := &request.Operation{
		Name:       opAllocateHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateHostsInput{}
	}

	output = &AllocateHostsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateHosts API operation for Amazon Elastic Compute Cloud.
//
// Allocates a Dedicated Host to your account. At minimum you need to specify
// the instance size type, Availability Zone, and quantity of hosts you want
// to allocate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AllocateHosts for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts
func (c *EC2) AllocateHosts(input *AllocateHostsInput) (*AllocateHostsOutput, error) {
	req, out := c.AllocateHostsRequest(input)
	err := req.Send()
	return out, err
}

const opAssignIpv6Addresses = "AssignIpv6Addresses"

// AssignIpv6AddressesRequest generates a "aws/request.Request" representing the
// client's request for the AssignIpv6Addresses operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AssignIpv6Addresses for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AssignIpv6Addresses method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AssignIpv6AddressesRequest method.
//    req, resp := client.AssignIpv6AddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses
func (c *EC2) AssignIpv6AddressesRequest(input *AssignIpv6AddressesInput) (req *request.Request, output *AssignIpv6AddressesOutput) {
	op := &request.Operation{
		Name:       opAssignIpv6Addresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignIpv6AddressesInput{}
	}

	output = &AssignIpv6AddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssignIpv6Addresses API operation for Amazon Elastic Compute Cloud.
//
// Assigns one or more IPv6 addresses to the specified network interface. You
// can specify one or more specific IPv6 addresses, or you can specify the number
// of IPv6 addresses to be automatically assigned from within the subnet's IPv6
// CIDR block range. You can assign as many IPv6 addresses to a network interface
// as you can assign private IPv4 addresses, and the limit varies per instance
// type. For information, see IP Addresses Per Network Interface Per Instance
// Type (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssignIpv6Addresses for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses
func (c *EC2) AssignIpv6Addresses(input *AssignIpv6AddressesInput) (*AssignIpv6AddressesOutput, error) {
	req, out := c.AssignIpv6AddressesRequest(input)
	err := req.Send()
	return out, err
}

const opAssignPrivateIpAddresses = "AssignPrivateIpAddresses"

// AssignPrivateIpAddressesRequest generates a "aws/request.Request" representing the
// client's request for the AssignPrivateIpAddresses operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AssignPrivateIpAddresses for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AssignPrivateIpAddresses method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AssignPrivateIpAddressesRequest method.
//    req, resp := client.AssignPrivateIpAddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses
func (c *EC2) AssignPrivateIpAddressesRequest(input *AssignPrivateIpAddressesInput) (req *request.Request, output *AssignPrivateIpAddressesOutput) {
	op := &request.Operation{
		Name:       opAssignPrivateIpAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignPrivateIpAddressesInput{}
	}

	output = &AssignPrivateIpAddressesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssignPrivateIpAddresses API operation for Amazon Elastic Compute Cloud.
//
// Assigns one or more secondary private IP addresses to the specified network
// interface. You can specify one or more specific secondary IP addresses, or
// you can specify the number of secondary IP addresses to be automatically
// assigned within the subnet's CIDR block range. The number of secondary IP
// addresses that you can assign to an instance varies by instance type. For
// information about instance types, see Instance Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
// in the Amazon Elastic Compute Cloud User Guide. For more information about
// Elastic IP addresses, see Elastic IP Addresses (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// AssignPrivateIpAddresses is available only in EC2-VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssignPrivateIpAddresses for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses
func (c *EC2) AssignPrivateIpAddresses(input *AssignPrivateIpAddressesInput) (*AssignPrivateIpAddressesOutput, error) {
	req, out := c.AssignPrivateIpAddressesRequest(input)
	err := req.Send()
	return out, err
}

const opAssociateAddress = "AssociateAddress"

// AssociateAddressRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAddress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AssociateAddress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AssociateAddress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AssociateAddressRequest method.
//    req, resp := client.AssociateAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress
func (c *EC2) AssociateAddressRequest(input *AssociateAddressInput) (req *request.Request, output *AssociateAddressOutput) {
	op := &request.Operation{
		Name:       opAssociateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateAddressInput{}
	}

	output = &AssociateAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateAddress API operation for Amazon Elastic Compute Cloud.
//
// Associates an Elastic IP address with an instance or a network interface.
//
// An Elastic IP address is for use in either the EC2-Classic platform or in
// a VPC. For more information, see Elastic IP Addresses (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// [EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address is
// already associated with a different instance, it is disassociated from that
// instance and associated with the specified instance.
//
// [VPC in an EC2-Classic account] If you don't specify a private IP address,
// the Elastic IP address is associated with the primary IP address. If the
// Elastic IP address is already associated with a different instance or a network
// interface, you get an error unless you allow reassociation.
//
// This is an idempotent operation. If you perform the operation more than once,
// Amazon EC2 doesn't return an error, and you may be charged for each time
// the Elastic IP address is remapped to the same instance. For more information,
// see the Elastic IP Addresses section of Amazon EC2 Pricing (http://aws.amazon.com/ec2/pricing/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateAddress for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress
func (c *EC2) AssociateAddress(input *AssociateAddressInput) (*AssociateAddressOutput, error) {
	req, out := c.AssociateAddressRequest(input)
	err := req.Send()
	return out, err
}

const opAssociateDhcpOptions = "AssociateDhcpOptions"

// AssociateDhcpOptionsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateDhcpOptions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AssociateDhcpOptions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AssociateDhcpOptions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AssociateDhcpOptionsRequest method.
//    req, resp := client.AssociateDhcpOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions
func (c *EC2) AssociateDhcpOptionsRequest(input *AssociateDhcpOptionsInput) (req *request.Request, output *AssociateDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opAssociateDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateDhcpOptionsInput{}
	}

	output = &AssociateDhcpOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateDhcpOptions API operation for Amazon Elastic Compute Cloud.
//
// Associates a set of DHCP options (that you've previously created) with the
// specified VPC, or associates no DHCP options with the VPC.
//
// After you associate the options with the VPC, any existing instances and
// all new instances that you launch in that VPC use the options. You don't
// need to restart or relaunch the instances. They automatically pick up the
// changes within a few hours, depending on how frequently the instance renews
// its DHCP lease. You can explicitly renew the lease using the operating system
// on the instance.
//
// For more information, see DHCP Options Sets (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateDhcpOptions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions
func (c *EC2) AssociateDhcpOptions(input *AssociateDhcpOptionsInput) (*AssociateDhcpOptionsOutput, error) {
	req, out := c.AssociateDhcpOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opAssociateRouteTable = "AssociateRouteTable"

// AssociateRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the AssociateRouteTable operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AssociateRouteTable for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AssociateRouteTable method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AssociateRouteTableRequest method.
//    req, resp := client.AssociateRouteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable
func (c *EC2) AssociateRouteTableRequest(input *AssociateRouteTableInput) (req *request.Request, output *AssociateRouteTableOutput) {
	op := &request.Operation{
		Name:       opAssociateRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateRouteTableInput{}
	}

	output = &AssociateRouteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Associates a subnet with a route table. The subnet and route table must be
// in the same VPC. This association causes traffic originating from the subnet
// to be routed according to the routes in the route table. The action returns
// an association ID, which you need in order to disassociate the route table
// from the subnet later. A route table can be associated with multiple subnets.
//
// For more information about route tables, see Route Tables (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateRouteTable for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable
func (c *EC2) AssociateRouteTable(input *AssociateRouteTableInput) (*AssociateRouteTableOutput, error) {
	req, out := c.AssociateRouteTableRequest(input)
	err := req.Send()
	return out, err
}

const opAssociateSubnetCidrBlock = "AssociateSubnetCidrBlock"

// AssociateSubnetCidrBlockRequest generates a "aws/request.Request" representing the
// client's request for the AssociateSubnetCidrBlock operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AssociateSubnetCidrBlock for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AssociateSubnetCidrBlock method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AssociateSubnetCidrBlockRequest method.
//    req, resp := client.AssociateSubnetCidrBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock
func (c *EC2) AssociateSubnetCidrBlockRequest(input *AssociateSubnetCidrBlockInput) (req *request.Request, output *AssociateSubnetCidrBlockOutput) {
	op := &request.Operation{
		Name:       opAssociateSubnetCidrBlock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateSubnetCidrBlockInput{}
	}

	output = &AssociateSubnetCidrBlockOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateSubnetCidrBlock API operation for Amazon Elastic Compute Cloud.
//
// Associates a CIDR block with your subnet. You can only associate a single
// IPv6 CIDR block with your subnet. An IPv6 CIDR block must have a prefix length
// of /64.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateSubnetCidrBlock for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock
func (c *EC2) AssociateSubnetCidrBlock(input *AssociateSubnetCidrBlockInput) (*AssociateSubnetCidrBlockOutput, error) {
	req, out := c.AssociateSubnetCidrBlockRequest(input)
	err := req.Send()
	return out, err
}

const opAssociateVpcCidrBlock = "AssociateVpcCidrBlock"

// AssociateVpcCidrBlockRequest generates a "aws/request.Request" representing the
// client's request for the AssociateVpcCidrBlock operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AssociateVpcCidrBlock for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AssociateVpcCidrBlock method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AssociateVpcCidrBlockRequest method.
//    req, resp := client.AssociateVpcCidrBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock
func (c *EC2) AssociateVpcCidrBlockRequest(input *AssociateVpcCidrBlockInput) (req *request.Request, output *AssociateVpcCidrBlockOutput) {
	op := &request.Operation{
		Name:       opAssociateVpcCidrBlock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateVpcCidrBlockInput{}
	}

	output = &AssociateVpcCidrBlockOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateVpcCidrBlock API operation for Amazon Elastic Compute Cloud.
//
// Associates a CIDR block with your VPC. You can only associate a single Amazon-provided
// IPv6 CIDR block with your VPC. The IPv6 CIDR block size is fixed at /56.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateVpcCidrBlock for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock
func (c *EC2) AssociateVpcCidrBlock(input *AssociateVpcCidrBlockInput) (*AssociateVpcCidrBlockOutput, error) {
	req, out := c.AssociateVpcCidrBlockRequest(input)
	err := req.Send()
	return out, err
}

const opAttachClassicLinkVpc = "AttachClassicLinkVpc"

// AttachClassicLinkVpcRequest generates a "aws/request.Request" representing the
// client's request for the AttachClassicLinkVpc operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AttachClassicLinkVpc for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AttachClassicLinkVpc method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AttachClassicLinkVpcRequest method.
//    req, resp := client.AttachClassicLinkVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc
func (c *EC2) AttachClassicLinkVpcRequest(input *AttachClassicLinkVpcInput) (req *request.Request, output *AttachClassicLinkVpcOutput) {
	op := &request.Operation{
		Name:       opAttachClassicLinkVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachClassicLinkVpcInput{}
	}

	output = &AttachClassicLinkVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachClassicLinkVpc API operation for Amazon Elastic Compute Cloud.
//
// Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or
// more of the VPC's security groups. You cannot link an EC2-Classic instance
// to more than one VPC at a time. You can only link an instance that's in the
// running state. An instance is automatically unlinked from a VPC when it's
// stopped - you can link it to the VPC again when you restart it.
//
// After you've linked an instance, you cannot change the VPC security groups
// that are associated with it. To change the security groups, you must first
// unlink the instance, and then link it again.
//
// Linking your instance to a VPC is sometimes referred to as attaching your
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachClassicLinkVpc for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc
func (c *EC2) AttachClassicLinkVpc(input *AttachClassicLinkVpcInput) (*AttachClassicLinkVpcOutput, error) {
	req, out := c.AttachClassicLinkVpcRequest(input)
	err := req.Send()
	return out, err
}

const opAttachInternetGateway = "AttachInternetGateway"

// AttachInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the AttachInternetGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AttachInternetGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AttachInternetGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AttachInternetGatewayRequest method.
//    req, resp := client.AttachInternetGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway
func (c *EC2) AttachInternetGatewayRequest(input *AttachInternetGatewayInput) (req *request.Request, output *AttachInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opAttachInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachInternetGatewayInput{}
	}

	output = &AttachInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// Attaches an Internet gateway to a VPC, enabling connectivity between the
// Internet and the VPC. For more information about your VPC and Internet gateway,
// see the Amazon Virtual Private Cloud User Guide (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachInternetGateway for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway
func (c *EC2) AttachInternetGateway(input *AttachInternetGatewayInput) (*AttachInternetGatewayOutput, error) {
	req, out := c.AttachInternetGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opAttachNetworkInterface = "AttachNetworkInterface"

// AttachNetworkInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the AttachNetworkInterface operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AttachNetworkInterface for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AttachNetworkInterface method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AttachNetworkInterfaceRequest method.
//    req, resp := client.AttachNetworkInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface
func (c *EC2) AttachNetworkInterfaceRequest(input *AttachNetworkInterfaceInput) (req *request.Request, output *AttachNetworkInterfaceOutput) {
	op := &request.Operation{
		Name:       opAttachNetworkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachNetworkInterfaceInput{}
	}

	output = &AttachNetworkInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachNetworkInterface API operation for Amazon Elastic Compute Cloud.
//
// Attaches a network interface to an instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachNetworkInterface for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface
func (c *EC2) AttachNetworkInterface(input *AttachNetworkInterfaceInput) (*AttachNetworkInterfaceOutput, error) {
	req, out := c.AttachNetworkInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opAttachVolume = "AttachVolume"

// AttachVolumeRequest generates a "aws/request.Request" representing the
// client's request for the AttachVolume operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AttachVolume for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AttachVolume method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AttachVolumeRequest method.
//    req, resp := client.AttachVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume
func (c *EC2) AttachVolumeRequest(input *AttachVolumeInput) (req *request.Request, output *VolumeAttachment) {
	op := &request.Operation{
		Name:       opAttachVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachVolumeInput{}
	}

	output = &VolumeAttachment{}
	req = c.newRequest(op, input, output)
	return
}

// AttachVolume API operation for Amazon Elastic Compute Cloud.
//
// Attaches an EBS volume to a running or stopped instance and exposes it to
// the instance with the specified device name.
//
// Encrypted EBS volumes may only be attached to instances that support Amazon
// EBS encryption. For more information, see Amazon EBS Encryption (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For a list of supported device names, see Attaching an EBS Volume to an Instance
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html).
// Any device names that aren't reserved for instance store volumes can be used
// for EBS volumes. For more information, see Amazon EC2 Instance Store (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// If a volume has an AWS Marketplace product code:
//
//    * The volume can be attached only to a stopped instance.
//
//    * AWS Marketplace product codes are copied from the volume to the instance.
//
//    * You must be subscribed to the product.
//
//    * The instance type and operating system of the instance must support
//    the product. For example, you can't detach a volume from a Windows instance
//    and attach it to a Linux instance.
//
// For an overview of the AWS Marketplace, see Introducing AWS Marketplace (https://aws.amazon.com/marketplace/help/200900000).
//
// For more information about EBS volumes, see Attaching Amazon EBS Volumes
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachVolume for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume
func (c *EC2) AttachVolume(input *AttachVolumeInput) (*VolumeAttachment, error) {
	req, out := c.AttachVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opAttachVpnGateway = "AttachVpnGateway"

// AttachVpnGatewayRequest generates a "aws/request.Request" representing the
// client's request for the AttachVpnGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AttachVpnGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AttachVpnGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AttachVpnGatewayRequest method.
//    req, resp := client.AttachVpnGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway
func (c *EC2) AttachVpnGatewayRequest(input *AttachVpnGatewayInput) (req *request.Request, output *AttachVpnGatewayOutput) {
	op := &request.Operation{
		Name:       opAttachVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachVpnGatewayInput{}
	}

	output = &AttachVpnGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachVpnGateway API operation for Amazon Elastic Compute Cloud.
//
// Attaches a virtual private gateway to a VPC. For more information, see Adding
// a Hardware Virtual Private Gateway to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachVpnGateway for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway
func (c *EC2) AttachVpnGateway(input *AttachVpnGatewayInput) (*AttachVpnGatewayOutput, error) {
	req, out := c.AttachVpnGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opAuthorizeSecurityGroupEgress = "AuthorizeSecurityGroupEgress"

// AuthorizeSecurityGroupEgressRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeSecurityGroupEgress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AuthorizeSecurityGroupEgress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AuthorizeSecurityGroupEgress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AuthorizeSecurityGroupEgressRequest method.
//    req, resp := client.AuthorizeSecurityGroupEgressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress
func (c *EC2) AuthorizeSecurityGroupEgressRequest(input *AuthorizeSecurityGroupEgressInput) (req *request.Request, output *AuthorizeSecurityGroupEgressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeSecurityGroupEgress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeSecurityGroupEgressInput{}
	}

	output = &AuthorizeSecurityGroupEgressOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AuthorizeSecurityGroupEgress API operation for Amazon Elastic Compute Cloud.
//
// [EC2-VPC only] Adds one or more egress rules to a security group for use
// with a VPC. Specifically, this action permits instances to send traffic to
// one or more destination IPv4 or IPv6 CIDR address ranges, or to one or more
// destination security groups for the same VPC. This action doesn't apply to
// security groups for use in EC2-Classic. For more information, see Security
// Groups for Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
// in the Amazon Virtual Private Cloud User Guide. For more information about
// security group limits, see Amazon VPC Limits (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Appendix_Limits.html).
//
// Each rule consists of the protocol (for example, TCP), plus either a CIDR
// range or a source group. For the TCP and UDP protocols, you must also specify
// the destination port or port range. For the ICMP protocol, you must also
// specify the ICMP type and code. You can use -1 for the type or code to mean
// all types or all codes.
//
// Rule changes are propagated to affected instances as quickly as possible.
// However, a small delay might occur.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AuthorizeSecurityGroupEgress for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress
func (c *EC2) AuthorizeSecurityGroupEgress(input *AuthorizeSecurityGroupEgressInput) (*AuthorizeSecurityGroupEgressOutput, error) {
	req, out := c.AuthorizeSecurityGroupEgressRequest(input)
	err := req.Send()
	return out, err
}

const opAuthorizeSecurityGroupIngress = "AuthorizeSecurityGroupIngress"

// AuthorizeSecurityGroupIngressRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeSecurityGroupIngress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AuthorizeSecurityGroupIngress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AuthorizeSecurityGroupIngress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AuthorizeSecurityGroupIngressRequest method.
//    req, resp := client.AuthorizeSecurityGroupIngressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress
func (c *EC2) AuthorizeSecurityGroupIngressRequest(input *AuthorizeSecurityGroupIngressInput) (req *request.Request, output *AuthorizeSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeSecurityGroupIngressInput{}
	}

	output = &AuthorizeSecurityGroupIngressOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AuthorizeSecurityGroupIngress API operation for Amazon Elastic Compute Cloud.
//
// Adds one or more ingress rules to a security group.
//
// Rule changes are propagated to instances within the security group as quickly
// as possible. However, a small delay might occur.
//
// [EC2-Classic] This action gives one or more IPv4 CIDR address ranges permission
// to access a security group in your account, or gives one or more security
// groups (called the source groups) permission to access a security group for
// your account. A source group can be for your own AWS account, or another.
// You can have up to 100 rules per group.
//
// [EC2-VPC] This action gives one or more IPv4 or IPv6 CIDR address ranges
// permission to access a security group in your VPC, or gives one or more other
// security groups (called the source groups) permission to access a security
// group for your VPC. The security groups must all be for the same VPC or a
// peer VPC in a VPC peering connection. For more information about VPC security
// group limits, see Amazon VPC Limits (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Appendix_Limits.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AuthorizeSecurityGroupIngress for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress
func (c *EC2) AuthorizeSecurityGroupIngress(input *AuthorizeSecurityGroupIngressInput) (*AuthorizeSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeSecurityGroupIngressRequest(input)
	err := req.Send()
	return out, err
}

const opBundleInstance = "BundleInstance"

// BundleInstanceRequest generates a "aws/request.Request" representing the
// client's request for the BundleInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BundleInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BundleInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BundleInstanceRequest method.
//    req, resp := client.BundleInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance
func (c *EC2) BundleInstanceRequest(input *BundleInstanceInput) (req *request.Request, output *BundleInstanceOutput) {
	op := &request.Operation{
		Name:       opBundleInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BundleInstanceInput{}
	}

	output = &BundleInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BundleInstance API operation for Amazon Elastic Compute Cloud.
//
// Bundles an Amazon instance store-backed Windows instance.
//
// During bundling, only the root device volume (C:\) is bundled. Data on other
// instance store volumes is not preserved.
//
// This action is not applicable for Linux/Unix instances or Windows instances
// that are backed by Amazon EBS.
//
// For more information, see Creating an Instance Store-Backed Windows AMI (http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/Creating_InstanceStoreBacked_WinAMI.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation BundleInstance for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance
func (c *EC2) BundleInstance(input *BundleInstanceInput) (*BundleInstanceOutput, error) {
	req, out := c.BundleInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opCancelBundleTask = "CancelBundleTask"

// CancelBundleTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelBundleTask operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelBundleTask for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelBundleTask method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelBundleTaskRequest method.
//    req, resp := client.CancelBundleTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask
func (c *EC2) CancelBundleTaskRequest(input *CancelBundleTaskInput) (req *request.Request, output *CancelBundleTaskOutput) {
	op := &request.Operation{
		Name:       opCancelBundleTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelBundleTaskInput{}
	}

	output = &CancelBundleTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelBundleTask API operation for Amazon Elastic Compute Cloud.
//
// Cancels a bundling operation for an instance store-backed Windows instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelBundleTask for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask
func (c *EC2) CancelBundleTask(input *CancelBundleTaskInput) (*CancelBundleTaskOutput, error) {
	req, out := c.CancelBundleTaskRequest(input)
	err := req.Send()
	return out, err
}

const opCancelConversionTask = "CancelConversionTask"

// CancelConversionTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelConversionTask operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelConversionTask for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelConversionTask method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelConversionTaskRequest method.
//    req, resp := client.CancelConversionTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask
func (c *EC2) CancelConversionTaskRequest(input *CancelConversionTaskInput) (req *request.Request, output *CancelConversionTaskOutput) {
	op := &request.Operation{
		Name:       opCancelConversionTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelConversionTaskInput{}
	}

	output = &CancelConversionTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelConversionTask API operation for Amazon Elastic Compute Cloud.
//
// Cancels an active conversion task. The task can be the import of an instance
// or volume. The action removes all artifacts of the conversion, including
// a partially uploaded volume or instance. If the conversion is complete or
// is in the process of transferring the final disk image, the command fails
// and returns an exception.
//
// For more information, see Importing a Virtual Machine Using the Amazon EC2
// CLI (http://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelConversionTask for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask
func (c *EC2) CancelConversionTask(input *CancelConversionTaskInput) (*CancelConversionTaskOutput, error) {
	req, out := c.CancelConversionTaskRequest(input)
	err := req.Send()
	return out, err
}

const opCancelExportTask = "CancelExportTask"

// CancelExportTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelExportTask operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelExportTask for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelExportTask method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelExportTaskRequest method.
//    req, resp := client.CancelExportTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask
func (c *EC2) CancelExportTaskRequest(input *CancelExportTaskInput) (req *request.Request, output *CancelExportTaskOutput) {
	op := &request.Operation{
		Name:       opCancelExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelExportTaskInput{}
	}

	output = &CancelExportTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelExportTask API operation for Amazon Elastic Compute Cloud.
//
// Cancels an active export task. The request removes all artifacts of the export,
// including any partially-created Amazon S3 objects. If the export task is
// complete or is in the process of transferring the final disk image, the command
// fails and returns an error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelExportTask for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask
func (c *EC2) CancelExportTask(input *CancelExportTaskInput) (*CancelExportTaskOutput, error) {
	req, out := c.CancelExportTaskRequest(input)
	err := req.Send()
	return out, err
}

const opCancelImportTask = "CancelImportTask"

// CancelImportTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelImportTask operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelImportTask for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelImportTask method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelImportTaskRequest method.
//    req, resp := client.CancelImportTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask
func (c *EC2) CancelImportTaskRequest(input *CancelImportTaskInput) (req *request.Request, output *CancelImportTaskOutput) {
	op := &request.Operation{
		Name:       opCancelImportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelImportTaskInput{}
	}

	output = &CancelImportTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelImportTask API operation for Amazon Elastic Compute Cloud.
//
// Cancels an in-process import virtual machine or import snapshot task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelImportTask for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask
func (c *EC2) CancelImportTask(input *CancelImportTaskInput) (*CancelImportTaskOutput, error) {
	req, out := c.CancelImportTaskRequest(input)
	err := req.Send()
	return out, err
}

const opCancelReservedInstancesListing = "CancelReservedInstancesListing"

// CancelReservedInstancesListingRequest generates a "aws/request.Request" representing the
// client's request for the CancelReservedInstancesListing operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelReservedInstancesListing for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelReservedInstancesListing method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelReservedInstancesListingRequest method.
//    req, resp := client.CancelReservedInstancesListingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing
func (c *EC2) CancelReservedInstancesListingRequest(input *CancelReservedInstancesListingInput) (req *request.Request, output *CancelReservedInstancesListingOutput) {
	op := &request.Operation{
		Name:       opCancelReservedInstancesListing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelReservedInstancesListingInput{}
	}

	output = &CancelReservedInstancesListingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelReservedInstancesListing API operation for Amazon Elastic Compute Cloud.
//
// Cancels the specified Reserved Instance listing in the Reserved Instance
// Marketplace.
//
// For more information, see Reserved Instance Marketplace (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelReservedInstancesListing for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing
func (c *EC2) CancelReservedInstancesListing(input *CancelReservedInstancesListingInput) (*CancelReservedInstancesListingOutput, error) {
	req, out := c.CancelReservedInstancesListingRequest(input)
	err := req.Send()
	return out, err
}

const opCancelSpotFleetRequests = "CancelSpotFleetRequests"

// CancelSpotFleetRequestsRequest generates a "aws/request.Request" representing the
// client's request for the CancelSpotFleetRequests operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelSpotFleetRequests for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelSpotFleetRequests method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelSpotFleetRequestsRequest method.
//    req, resp := client.CancelSpotFleetRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests
func (c *EC2) CancelSpotFleetRequestsRequest(input *CancelSpotFleetRequestsInput) (req *request.Request, output *CancelSpotFleetRequestsOutput) {
	op := &request.Operation{
		Name:       opCancelSpotFleetRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelSpotFleetRequestsInput{}
	}

	output = &CancelSpotFleetRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelSpotFleetRequests API operation for Amazon Elastic Compute Cloud.
//
// Cancels the specified Spot fleet requests.
//
// After you cancel a Spot fleet request, the Spot fleet launches no new Spot
// instances. You must specify whether the Spot fleet should also terminate
// its Spot instances. If you terminate the instances, the Spot fleet request
// enters the cancelled_terminating state. Otherwise, the Spot fleet request
// enters the cancelled_running state and the instances continue to run until
// they are interrupted or you terminate them manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelSpotFleetRequests for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests
func (c *EC2) CancelSpotFleetRequests(input *CancelSpotFleetRequestsInput) (*CancelSpotFleetRequestsOutput, error) {
	req, out := c.CancelSpotFleetRequestsRequest(input)
	err := req.Send()
	return out, err
}

const opCancelSpotInstanceRequests = "CancelSpotInstanceRequests"

// CancelSpotInstanceRequestsRequest generates a "aws/request.Request" representing the
// client's request for the CancelSpotInstanceRequests operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelSpotInstanceRequests for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelSpotInstanceRequests method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelSpotInstanceRequestsRequest method.
//    req, resp := client.CancelSpotInstanceRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests
func (c *EC2) CancelSpotInstanceRequestsRequest(input *CancelSpotInstanceRequestsInput) (req *request.Request, output *CancelSpotInstanceRequestsOutput) {
	op := &request.Operation{
		Name:       opCancelSpotInstanceRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelSpotInstanceRequestsInput{}
	}

	output = &CancelSpotInstanceRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelSpotInstanceRequests API operation for Amazon Elastic Compute Cloud.
//
// Cancels one or more Spot instance requests. Spot instances are instances
// that Amazon EC2 starts on your behalf when the bid price that you specify
// exceeds the current Spot price. Amazon EC2 periodically sets the Spot price
// based on available Spot instance capacity and current Spot instance requests.
// For more information, see Spot Instance Requests (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Canceling a Spot instance request does not terminate running Spot instances
// associated with the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelSpotInstanceRequests for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests
func (c *EC2) CancelSpotInstanceRequests(input *CancelSpotInstanceRequestsInput) (*CancelSpotInstanceRequestsOutput, error) {
	req, out := c.CancelSpotInstanceRequestsRequest(input)
	err := req.Send()
	return out, err
}

const opConfirmProductInstance = "ConfirmProductInstance"

// ConfirmProductInstanceRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmProductInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ConfirmProductInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ConfirmProductInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ConfirmProductInstanceRequest method.
//    req, resp := client.ConfirmProductInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance
func (c *EC2) ConfirmProductInstanceRequest(input *ConfirmProductInstanceInput) (req *request.Request, output *ConfirmProductInstanceOutput) {
	op := &request.Operation{
		Name:       opConfirmProductInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmProductInstanceInput{}
	}

	output = &ConfirmProductInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmProductInstance API operation for Amazon Elastic Compute Cloud.
//
// Determines whether a product code is associated with an instance. This action
// can only be used by the owner of the product code. It is useful when a product
// code owner needs to verify whether another user's instance is eligible for
// support.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ConfirmProductInstance for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance
func (c *EC2) ConfirmProductInstance(input *ConfirmProductInstanceInput) (*ConfirmProductInstanceOutput, error) {
	req, out := c.ConfirmProductInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opCopyImage = "CopyImage"

// CopyImageRequest generates a "aws/request.Request" representing the
// client's request for the CopyImage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CopyImage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CopyImage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CopyImageRequest method.
//    req, resp := client.CopyImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage
func (c *EC2) CopyImageRequest(input *CopyImageInput) (req *request.Request, output *CopyImageOutput) {
	op := &request.Operation{
		Name:       opCopyImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyImageInput{}
	}

	output = &CopyImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyImage API operation for Amazon Elastic Compute Cloud.
//
// Initiates the copy of an AMI from the specified source region to the current
// region. You specify the destination region by using its endpoint when making
// the request.
//
// For more information, see Copying AMIs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CopyImage for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage
func (c *EC2) CopyImage(input *CopyImageInput) (*CopyImageOutput, error) {
	req, out := c.CopyImageRequest(input)
	err := req.Send()
	return out, err
}

const opCopySnapshot = "CopySnapshot"

// CopySnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CopySnapshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CopySnapshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CopySnapshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CopySnapshotRequest method.
//    req, resp := client.CopySnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot
func (c *EC2) CopySnapshotRequest(input *CopySnapshotInput) (req *request.Request, output *CopySnapshotOutput) {
	op := &request.Operation{
		Name:       opCopySnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopySnapshotInput{}
	}

	output = &CopySnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopySnapshot API operation for Amazon Elastic Compute Cloud.
//
// Copies a point-in-time snapshot of an EBS volume and stores it in Amazon
// S3. You can copy the snapshot within the same region or from one region to
// another. You can use the snapshot to create EBS volumes or Amazon Machine
// Images (AMIs). The snapshot is copied to the regional endpoint that you send
// the HTTP request to.
//
// Copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted
// snapshots remain unencrypted, unless the Encrypted flag is specified during
// the snapshot copy operation. By default, encrypted snapshot copies use the
// default AWS Key Management Service (AWS KMS) customer master key (CMK); however,
// you can specify a non-default CMK with the KmsKeyId parameter.
//
// To copy an encrypted snapshot that has been shared from another account,
// you must have permissions for the CMK used to encrypt the snapshot.
//
// Snapshots created by the CopySnapshot action have an arbitrary volume ID
// that should not be used for any purpose.
//
// For more information, see Copying an Amazon EBS Snapshot (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CopySnapshot for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot
func (c *EC2) CopySnapshot(input *CopySnapshotInput) (*CopySnapshotOutput, error) {
	req, out := c.CopySnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCreateCustomerGateway = "CreateCustomerGateway"

// CreateCustomerGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomerGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateCustomerGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateCustomerGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateCustomerGatewayRequest method.
//    req, resp := client.CreateCustomerGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway
func (c *EC2) CreateCustomerGatewayRequest(input *CreateCustomerGatewayInput) (req *request.Request, output *CreateCustomerGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateCustomerGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomerGatewayInput{}
	}

	output = &CreateCustomerGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomerGateway API operation for Amazon Elastic Compute Cloud.
//
// Provides information to AWS about your VPN customer gateway device. The customer
// gateway is the appliance at your end of the VPN connection. (The device on
// the AWS side of the VPN connection is the virtual private gateway.) You must
// provide the Internet-routable IP address of the customer gateway's external
// interface. The IP address must be static and may be behind a device performing
// network address translation (NAT).
//
// For devices that use Border Gateway Protocol (BGP), you can also provide
// the device's BGP Autonomous System Number (ASN). You can use an existing
// ASN assigned to your network. If you don't have an ASN already, you can use
// a private ASN (in the 64512 - 65534 range).
//
// Amazon EC2 supports all 2-byte ASN numbers in the range of 1 - 65534, with
// the exception of 7224, which is reserved in the us-east-1 region, and 9059,
// which is reserved in the eu-west-1 region.
//
// For more information about VPN customer gateways, see Adding a Hardware Virtual
// Private Gateway to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// You cannot create more than one customer gateway with the same VPN type,
// IP address, and BGP ASN parameter values. If you run an identical request
// more than one time, the first request creates the customer gateway, and subsequent
// requests return information about the existing customer gateway. The subsequent
// requests do not create new customer gateway resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateCustomerGateway for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway
func (c *EC2) CreateCustomerGateway(input *CreateCustomerGatewayInput) (*CreateCustomerGatewayOutput, error) {
	req, out := c.CreateCustomerGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDhcpOptions = "CreateDhcpOptions"

// CreateDhcpOptionsRequest generates a "aws/request.Request" representing the
// client's request for the CreateDhcpOptions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateDhcpOptions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateDhcpOptions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateDhcpOptionsRequest method.
//    req, resp := client.CreateDhcpOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions
func (c *EC2) CreateDhcpOptionsRequest(input *CreateDhcpOptionsInput) (req *request.Request, output *CreateDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opCreateDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDhcpOptionsInput{}
	}

	output = &CreateDhcpOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDhcpOptions API operation for Amazon Elastic Compute Cloud.
//
// Creates a set of DHCP options for your VPC. After creating the set, you must
// associate it with the VPC, causing all existing and new instances that you
// launch in the VPC to use this set of DHCP options. The following are the
// individual DHCP options you can specify. For more information about the options,
// see RFC 2132 (http://www.ietf.org/rfc/rfc2132.txt).
//
//    * domain-name-servers - The IP addresses of up to four domain name servers,
//    or AmazonProvidedDNS. The default DHCP option set specifies AmazonProvidedDNS.
//    If specifying more than one domain name server, specify the IP addresses
//    in a single parameter, separated by commas. If you want your instance
//    to receive a custom DNS hostname as specified in domain-name, you must
//    set domain-name-servers to a custom DNS server.
//
//    * domain-name - If you're using AmazonProvidedDNS in "us-east-1", specify
//    "ec2.internal". If you're using AmazonProvidedDNS in another region, specify
//    "region.compute.internal" (for example, "ap-northeast-1.compute.internal").
//    Otherwise, specify a domain name (for example, "MyCompany.com"). This
//    value is used to complete unqualified DNS hostnames. Important: Some Linux
//    operating systems accept multiple domain names separated by spaces. However,
//    Windows and other Linux operating systems treat the value as a single
//    domain, which results in unexpected behavior. If your DHCP options set
//    is associated with a VPC that has instances with multiple operating systems,
//    specify only one domain name.
//
//    * ntp-servers - The IP addresses of up to four Network Time Protocol (NTP)
//    servers.
//
//    * netbios-name-servers - The IP addresses of up to four NetBIOS name servers.
//
//    * netbios-node-type - The NetBIOS node type (1, 2, 4, or 8). We recommend
//    that you specify 2 (broadcast and multicast are not currently supported).
//    For more information about these node types, see RFC 2132 (http://www.ietf.org/rfc/rfc2132.txt).
//
// Your VPC automatically starts out with a set of DHCP options that includes
// only a DNS server that we provide (AmazonProvidedDNS). If you create a set
// of options, and if your VPC has an Internet gateway, make sure to set the
// domain-name-servers option either to AmazonProvidedDNS or to a domain name
// server of your choice. For more information about DHCP options, see DHCP
// Options Sets (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateDhcpOptions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions
func (c *EC2) CreateDhcpOptions(input *CreateDhcpOptionsInput) (*CreateDhcpOptionsOutput, error) {
	req, out := c.CreateDhcpOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opCreateEgressOnlyInternetGateway = "CreateEgressOnlyInternetGateway"

// CreateEgressOnlyInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateEgressOnlyInternetGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateEgressOnlyInternetGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateEgressOnlyInternetGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateEgressOnlyInternetGatewayRequest method.
//    req, resp := client.CreateEgressOnlyInternetGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway
func (c *EC2) CreateEgressOnlyInternetGatewayRequest(input *CreateEgressOnlyInternetGatewayInput) (req *request.Request, output *CreateEgressOnlyInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateEgressOnlyInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEgressOnlyInternetGatewayInput{}
	}

	output = &CreateEgressOnlyInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEgressOnlyInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// [IPv6 only] Creates an egress-only Internet gateway for your VPC. An egress-only
// Internet gateway is used to enable outbound communication over IPv6 from
// instances in your VPC to the Internet, and prevents hosts outside of your
// VPC from initiating an IPv6 connection with your instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateEgressOnlyInternetGateway for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway
func (c *EC2) CreateEgressOnlyInternetGateway(input *CreateEgressOnlyInternetGatewayInput) (*CreateEgressOnlyInternetGatewayOutput, error) {
	req, out := c.CreateEgressOnlyInternetGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opCreateFlowLogs = "CreateFlowLogs"

// CreateFlowLogsRequest generates a "aws/request.Request" representing the
// client's request for the CreateFlowLogs operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateFlowLogs for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateFlowLogs method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateFlowLogsRequest method.
//    req, resp := client.CreateFlowLogsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs
func (c *EC2) CreateFlowLogsRequest(input *CreateFlowLogsInput) (req *request.Request, output *CreateFlowLogsOutput) {
	op := &request.Operation{
		Name:       opCreateFlowLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFlowLogsInput{}
	}

	output = &CreateFlowLogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFlowLogs API operation for Amazon Elastic Compute Cloud.
//
// Creates one or more flow logs to capture IP traffic for a specific network
// interface, subnet, or VPC. Flow logs are delivered to a specified log group
// in Amazon CloudWatch Logs. If you specify a VPC or subnet in the request,
// a log stream is created in CloudWatch Logs for each network interface in
// the subnet or VPC. Log streams can include information about accepted and
// rejected traffic to a network interface. You can view the data in your log
// streams using Amazon CloudWatch Logs.
//
// In your request, you must also specify an IAM role that has permission to
// publish logs to CloudWatch Logs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateFlowLogs for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs
func (c *EC2) CreateFlowLogs(input *CreateFlowLogsInput) (*CreateFlowLogsOutput, error) {
	req, out := c.CreateFlowLogsRequest(input)
	err := req.Send()
	return out, err
}

const opCreateImage = "CreateImage"

// CreateImageRequest generates a "aws/request.Request" representing the
// client's request for the CreateImage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateImage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateImage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateImageRequest method.
//    req, resp := client.CreateImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage
func (c *EC2) CreateImageRequest(input *CreateImageInput) (req *request.Request, output *CreateImageOutput) {
	op := &request.Operation{
		Name:       opCreateImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateImageInput{}
	}

	output = &CreateImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImage API operation for Amazon Elastic Compute Cloud.
//
// Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that
// is either running or stopped.
//
// If you customized your instance with instance store volumes or EBS volumes
// in addition to the root device volume, the new AMI contains block device
// mapping information for those volumes. When you launch an instance from this
// new AMI, the instance automatically launches with those additional volumes.
//
// For more information, see Creating Amazon EBS-Backed Linux AMIs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateImage for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage
func (c *EC2) CreateImage(input *CreateImageInput) (*CreateImageOutput, error) {
	req, out := c.CreateImageRequest(input)
	err := req.Send()
	return out, err
}

const opCreateInstanceExportTask = "CreateInstanceExportTask"

// CreateInstanceExportTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstanceExportTask operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateInstanceExportTask for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateInstanceExportTask method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateInstanceExportTaskRequest method.
//    req, resp := client.CreateInstanceExportTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask
func (c *EC2) CreateInstanceExportTaskRequest(input *CreateInstanceExportTaskInput) (req *request.Request, output *CreateInstanceExportTaskOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceExportTaskInput{}
	}

	output = &CreateInstanceExportTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstanceExportTask API operation for Amazon Elastic Compute Cloud.
//
// Exports a running or stopped instance to an S3 bucket.
//
// For information about the supported operating systems, image formats, and
// known limitations for the types of instances you can export, see Exporting
// an Instance as a VM Using VM Import/Export (http://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html)
// in the VM Import/Export User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateInstanceExportTask for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask
func (c *EC2) CreateInstanceExportTask(input *CreateInstanceExportTaskInput) (*CreateInstanceExportTaskOutput, error) {
	req, out := c.CreateInstanceExportTaskRequest(input)
	err := req.Send()
	return out, err
}

const opCreateInternetGateway = "CreateInternetGateway"

// CreateInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateInternetGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateInternetGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateInternetGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateInternetGatewayRequest method.
//    req, resp := client.CreateInternetGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway
func (c *EC2) CreateInternetGatewayRequest(input *CreateInternetGatewayInput) (req *request.Request, output *CreateInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInternetGatewayInput{}
	}

	output = &CreateInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// Creates an Internet gateway for use with a VPC. After creating the Internet
// gateway, you attach it to a VPC using AttachInternetGateway.
//
// For more information about your VPC and Internet gateway, see the Amazon
// Virtual Private Cloud User Guide (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateInternetGateway for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway
func (c *EC2) CreateInternetGateway(input *CreateInternetGatewayInput) (*CreateInternetGatewayOutput, error) {
	req, out := c.CreateInternetGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opCreateKeyPair = "CreateKeyPair"

// CreateKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the CreateKeyPair operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateKeyPair for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateKeyPair method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateKeyPairRequest method.
//    req, resp := client.CreateKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair
func (c *EC2) CreateKeyPairRequest(input *CreateKeyPairInput) (req *request.Request, output *CreateKeyPairOutput) {
	op := &request.Operation{
		Name:       opCreateKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyPairInput{}
	}

	output = &CreateKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKeyPair API operation for Amazon Elastic Compute Cloud.
//
// Creates a 2048-bit RSA key pair with the specified name. Amazon EC2 stores
// the public key and displays the private key for you to save to a file. The
// private key is returned as an unencrypted PEM encoded PKCS#8 private key.
// If a key with the specified name already exists, Amazon EC2 returns an error.
//
// You can have up to five thousand key pairs per region.
//
// The key pair returned to you is available only in the region in which you
// create it. To create a key pair that is available in all regions, use ImportKeyPair.
//
// For more information about key pairs, see Key Pairs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateKeyPair for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair
func (c *EC2) CreateKeyPair(input *CreateKeyPairInput) (*CreateKeyPairOutput, error) {
	req, out := c.CreateKeyPairRequest(input)
	err := req.Send()
	return out, err
}

const opCreateNatGateway = "CreateNatGateway"

// CreateNatGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateNatGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateNatGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateNatGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateNatGatewayRequest method.
//    req, resp := client.CreateNatGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway
func (c *EC2) CreateNatGatewayRequest(input *CreateNatGatewayInput) (req *request.Request, output *CreateNatGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateNatGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNatGatewayInput{}
	}

	output = &CreateNatGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNatGateway API operation for Amazon Elastic Compute Cloud.
//
// Creates a NAT gateway in the specified subnet. A NAT gateway can be used
// to enable instances in a private subnet to connect to the Internet. This
// action creates a network interface in the specified subnet with a private
// IP address from the IP address range of the subnet. For more information,
// see NAT Gateways (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNatGateway for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway
func (c *EC2) CreateNatGateway(input *CreateNatGatewayInput) (*CreateNatGatewayOutput, error) {
	req, out := c.CreateNatGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opCreateNetworkAcl = "CreateNetworkAcl"

// CreateNetworkAclRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkAcl operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateNetworkAcl for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateNetworkAcl method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateNetworkAclRequest method.
//    req, resp := client.CreateNetworkAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl
func (c *EC2) CreateNetworkAclRequest(input *CreateNetworkAclInput) (req *request.Request, output *CreateNetworkAclOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkAcl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkAclInput{}
	}

	output = &CreateNetworkAclOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkAcl API operation for Amazon Elastic Compute Cloud.
//
// Creates a network ACL in a VPC. Network ACLs provide an optional layer of
// security (in addition to security groups) for the instances in your VPC.
//
// For more information about network ACLs, see Network ACLs (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNetworkAcl for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl
func (c *EC2) CreateNetworkAcl(input *CreateNetworkAclInput) (*CreateNetworkAclOutput, error) {
	req, out := c.CreateNetworkAclRequest(input)
	err := req.Send()
	return out, err
}

const opCreateNetworkAclEntry = "CreateNetworkAclEntry"

// CreateNetworkAclEntryRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkAclEntry operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateNetworkAclEntry for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateNetworkAclEntry method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateNetworkAclEntryRequest method.
//    req, resp := client.CreateNetworkAclEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry
func (c *EC2) CreateNetworkAclEntryRequest(input *CreateNetworkAclEntryInput) (req *request.Request, output *CreateNetworkAclEntryOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkAclEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkAclEntryInput{}
	}

	output = &CreateNetworkAclEntryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateNetworkAclEntry API operation for Amazon Elastic Compute Cloud.
//
// Creates an entry (a rule) in a network ACL with the specified rule number.
// Each network ACL has a set of numbered ingress rules and a separate set of
// numbered egress rules. When determining whether a packet should be allowed
// in or out of a subnet associated with the ACL, we process the entries in
// the ACL according to the rule numbers, in ascending order. Each network ACL
// has a set of ingress rules and a separate set of egress rules.
//
// We recommend that you leave room between the rule numbers (for example, 100,
// 110, 120, ...), and not number them one right after the other (for example,
// 101, 102, 103, ...). This makes it easier to add a rule between existing
// ones without having to renumber the rules.
//
// After you add an entry, you can't modify it; you must either replace it,
// or create an entry and delete the old one.
//
// For more information about network ACLs, see Network ACLs (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNetworkAclEntry for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry
func (c *EC2) CreateNetworkAclEntry(input *CreateNetworkAclEntryInput) (*CreateNetworkAclEntryOutput, error) {
	req, out := c.CreateNetworkAclEntryRequest(input)
	err := req.Send()
	return out, err
}

const opCreateNetworkInterface = "CreateNetworkInterface"

// CreateNetworkInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkInterface operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateNetworkInterface for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateNetworkInterface method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateNetworkInterfaceRequest method.
//    req, resp := client.CreateNetworkInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface
func (c *EC2) CreateNetworkInterfaceRequest(input *CreateNetworkInterfaceInput) (req *request.Request, output *CreateNetworkInterfaceOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkInterfaceInput{}
	}

	output = &CreateNetworkInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkInterface API operation for Amazon Elastic Compute Cloud.
//
// Creates a network interface in the specified subnet.
//
// For more information about network interfaces, see Elastic Network Interfaces
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html) in the
// Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNetworkInterface for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface
func (c *EC2) CreateNetworkInterface(input *CreateNetworkInterfaceInput) (*CreateNetworkInterfaceOutput, error) {
	req, out := c.CreateNetworkInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePlacementGroup = "CreatePlacementGroup"

// CreatePlacementGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlacementGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePlacementGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePlacementGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePlacementGroupRequest method.
//    req, resp := client.CreatePlacementGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup
func (c *EC2) CreatePlacementGroupRequest(input *CreatePlacementGroupInput) (req *request.Request, output *CreatePlacementGroupOutput) {
	op := &request.Operation{
		Name:       opCreatePlacementGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlacementGroupInput{}
	}

	output = &CreatePlacementGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreatePlacementGroup API operation for Amazon Elastic Compute Cloud.
//
// Creates a placement group that you launch cluster instances into. You must
// give the group a name that's unique within the scope of your account.
//
// For more information about placement groups and cluster instances, see Cluster
// Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cluster_computing.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreatePlacementGroup for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup
func (c *EC2) CreatePlacementGroup(input *CreatePlacementGroupInput) (*CreatePlacementGroupOutput, error) {
	req, out := c.CreatePlacementGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateReservedInstancesListing = "CreateReservedInstancesListing"

// CreateReservedInstancesListingRequest generates a "aws/request.Request" representing the
// client's request for the CreateReservedInstancesListing operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateReservedInstancesListing for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateReservedInstancesListing method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateReservedInstancesListingRequest method.
//    req, resp := client.CreateReservedInstancesListingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing
func (c *EC2) CreateReservedInstancesListingRequest(input *CreateReservedInstancesListingInput) (req *request.Request, output *CreateReservedInstancesListingOutput) {
	op := &request.Operation{
		Name:       opCreateReservedInstancesListing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReservedInstancesListingInput{}
	}

	output = &CreateReservedInstancesListingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReservedInstancesListing API operation for Amazon Elastic Compute Cloud.
//
// Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in
// the Reserved Instance Marketplace. You can submit one Standard Reserved Instance
// listing at a time. To get a list of your Standard Reserved Instances, you
// can use the DescribeReservedInstances operation.
//
// Only Standard Reserved Instances with a capacity reservation can be sold
// in the Reserved Instance Marketplace. Convertible Reserved Instances and
// Standard Reserved Instances with a regional benefit cannot be sold.
//
// The Reserved Instance Marketplace matches sellers who want to resell Standard
// Reserved Instance capacity that they no longer need with buyers who want
// to purchase additional capacity. Reserved Instances bought and sold through
// the Reserved Instance Marketplace work like any other Reserved Instances.
//
// To sell your Standard Reserved Instances, you must first register as a seller
// in the Reserved Instance Marketplace. After completing the registration process,
// you can create a Reserved Instance Marketplace listing of some or all of
// your Standard Reserved Instances, and specify the upfront price to receive
// for them. Your Standard Reserved Instance listings then become available
// for purchase. To view the details of your Standard Reserved Instance listing,
// you can use the DescribeReservedInstancesListings operation.
//
// For more information, see Reserved Instance Marketplace (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateReservedInstancesListing for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing
func (c *EC2) CreateReservedInstancesListing(input *CreateReservedInstancesListingInput) (*CreateReservedInstancesListingOutput, error) {
	req, out := c.CreateReservedInstancesListingRequest(input)
	err := req.Send()
	return out, err
}

const opCreateRoute = "CreateRoute"

// CreateRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateRoute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateRoute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateRouteRequest method.
//    req, resp := client.CreateRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute
func (c *EC2) CreateRouteRequest(input *CreateRouteInput) (req *request.Request, output *CreateRouteOutput) {
	op := &request.Operation{
		Name:       opCreateRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRouteInput{}
	}

	output = &CreateRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoute API operation for Amazon Elastic Compute Cloud.
//
// Creates a route in a route table within a VPC.
//
// You must specify one of the following targets: Internet gateway or virtual
// private gateway, NAT instance, NAT gateway, VPC peering connection, network
// interface, or egress-only Internet gateway.
//
// When determining how to route traffic, we use the route with the most specific
// match. For example, traffic is destined for the IPv4 address 192.0.2.3, and
// the route table includes the following two IPv4 routes:
//
//    * 192.0.2.0/24 (goes to some target A)
//
//    * 192.0.2.0/28 (goes to some target B)
//
// Both routes apply to the traffic destined for 192.0.2.3. However, the second
// route in the list covers a smaller number of IP addresses and is therefore
// more specific, so we use that route to determine where to target the traffic.
//
// For more information about route tables, see Route Tables (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateRoute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute
func (c *EC2) CreateRoute(input *CreateRouteInput) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	err := req.Send()
	return out, err
}

const opCreateRouteTable = "CreateRouteTable"

// CreateRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateRouteTable operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateRouteTable for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateRouteTable method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateRouteTableRequest method.
//    req, resp := client.CreateRouteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable
func (c *EC2) CreateRouteTableRequest(input *CreateRouteTableInput) (req *request.Request, output *CreateRouteTableOutput) {
	op := &request.Operation{
		Name:       opCreateRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRouteTableInput{}
	}

	output = &CreateRouteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Creates a route table for the specified VPC. After you create a route table,
// you can add routes and associate the table with a subnet.
//
// For more information about route tables, see Route Tables (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateRouteTable for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable
func (c *EC2) CreateRouteTable(input *CreateRouteTableInput) (*CreateRouteTableOutput, error) {
	req, out := c.CreateRouteTableRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSecurityGroup = "CreateSecurityGroup"

// CreateSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateSecurityGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSecurityGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSecurityGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSecurityGroupRequest method.
//    req, resp := client.CreateSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup
func (c *EC2) CreateSecurityGroupRequest(input *CreateSecurityGroupInput) (req *request.Request, output *CreateSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecurityGroupInput{}
	}

	output = &CreateSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSecurityGroup API operation for Amazon Elastic Compute Cloud.
//
// Creates a security group.
//
// A security group is for use with instances either in the EC2-Classic platform
// or in a specific VPC. For more information, see Amazon EC2 Security Groups
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
// in the Amazon Elastic Compute Cloud User Guide and Security Groups for Your
// VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// EC2-Classic: You can have up to 500 security groups.
//
// EC2-VPC: You can create up to 500 security groups per VPC.
//
// When you create a security group, you specify a friendly name of your choice.
// You can have a security group for use in EC2-Classic with the same name as
// a security group for use in a VPC. However, you can't have two security groups
// for use in EC2-Classic with the same name or two security groups for use
// in a VPC with the same name.
//
// You have a default security group for use in EC2-Classic and a default security
// group for use in your VPC. If you don't specify a security group when you
// launch an instance, the instance is launched into the appropriate default
// security group. A default security group includes a default rule that grants
// instances unrestricted network access to each other.
//
// You can add or remove rules from your security groups using AuthorizeSecurityGroupIngress,
// AuthorizeSecurityGroupEgress, RevokeSecurityGroupIngress, and RevokeSecurityGroupEgress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSecurityGroup for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup
func (c *EC2) CreateSecurityGroup(input *CreateSecurityGroupInput) (*CreateSecurityGroupOutput, error) {
	req, out := c.CreateSecurityGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSnapshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSnapshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSnapshotRequest method.
//    req, resp := client.CreateSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot
func (c *EC2) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *Snapshot) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	output = &Snapshot{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshot API operation for Amazon Elastic Compute Cloud.
//
// Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use
// snapshots for backups, to make copies of EBS volumes, and to save data before
// shutting down an instance.
//
// When a snapshot is created, any AWS Marketplace product codes that are associated
// with the source volume are propagated to the snapshot.
//
// You can take a snapshot of an attached volume that is in use. However, snapshots
// only capture data that has been written to your EBS volume at the time the
// snapshot command is issued; this may exclude any data that has been cached
// by any applications or the operating system. If you can pause any file systems
// on the volume long enough to take a snapshot, your snapshot should be complete.
// However, if you cannot pause all file writes to the volume, you should unmount
// the volume from within the instance, issue the snapshot command, and then
// remount the volume to ensure a consistent and complete snapshot. You may
// remount and use your volume while the snapshot status is pending.
//
// To create a snapshot for EBS volumes that serve as root devices, you should
// stop the instance before taking the snapshot.
//
// Snapshots that are taken from encrypted volumes are automatically encrypted.
// Volumes that are created from encrypted snapshots are also automatically
// encrypted. Your encrypted volumes and any associated snapshots always remain
// protected.
//
// For more information, see Amazon Elastic Block Store (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html)
// and Amazon EBS Encryption (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSnapshot for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot
func (c *EC2) CreateSnapshot(input *CreateSnapshotInput) (*Snapshot, error) {
	req, out := c.CreateSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSpotDatafeedSubscription = "CreateSpotDatafeedSubscription"

// CreateSpotDatafeedSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSpotDatafeedSubscription operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSpotDatafeedSubscription for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSpotDatafeedSubscription method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSpotDatafeedSubscriptionRequest method.
//    req, resp := client.CreateSpotDatafeedSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription
func (c *EC2) CreateSpotDatafeedSubscriptionRequest(input *CreateSpotDatafeedSubscriptionInput) (req *request.Request, output *CreateSpotDatafeedSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateSpotDatafeedSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSpotDatafeedSubscriptionInput{}
	}

	output = &CreateSpotDatafeedSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSpotDatafeedSubscription API operation for Amazon Elastic Compute Cloud.
//
// Creates a data feed for Spot instances, enabling you to view Spot instance
// usage logs. You can create one data feed per AWS account. For more information,
// see Spot Instance Data Feed (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSpotDatafeedSubscription for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription
func (c *EC2) CreateSpotDatafeedSubscription(input *CreateSpotDatafeedSubscriptionInput) (*CreateSpotDatafeedSubscriptionOutput, error) {
	req, out := c.CreateSpotDatafeedSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSubnet = "CreateSubnet"

// CreateSubnetRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubnet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSubnet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSubnet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSubnetRequest method.
//    req, resp := client.CreateSubnetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet
func (c *EC2) CreateSubnetRequest(input *CreateSubnetInput) (req *request.Request, output *CreateSubnetOutput) {
	op := &request.Operation{
		Name:       opCreateSubnet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSubnetInput{}
	}

	output = &CreateSubnetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubnet API operation for Amazon Elastic Compute Cloud.
//
// Creates a subnet in an existing VPC.
//
// When you create each subnet, you provide the VPC ID and the CIDR block you
// want for the subnet. After you create a subnet, you can't change its CIDR
// block. The subnet's IPv4 CIDR block can be the same as the VPC's IPv4 CIDR
// block (assuming you want only a single subnet in the VPC), or a subset of
// the VPC's IPv4 CIDR block. If you create more than one subnet in a VPC, the
// subnets' CIDR blocks must not overlap. The smallest IPv4 subnet (and VPC)
// you can create uses a /28 netmask (16 IPv4 addresses), and the largest uses
// a /16 netmask (65,536 IPv4 addresses).
//
// If you've associated an IPv6 CIDR block with your VPC, you can create a subnet
// with an IPv6 CIDR block that uses a /64 prefix length.
//
// AWS reserves both the first four and the last IP address in each subnet's
// CIDR block. They're not available for use.
//
// If you add more than one subnet to a VPC, they're set up in a star topology
// with a logical router in the middle.
//
// If you launch an instance in a VPC using an Amazon EBS-backed AMI, the IP
// address doesn't change if you stop and restart the instance (unlike a similar
// instance launched outside a VPC, which gets a new IP address when restarted).
// It's therefore possible to have a subnet with no running instances (they're
// all stopped), but no remaining IP addresses available.
//
// For more information about subnets, see Your VPC and Subnets (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSubnet for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet
func (c *EC2) CreateSubnet(input *CreateSubnetInput) (*CreateSubnetOutput, error) {
	req, out := c.CreateSubnetRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTagsRequest method.
//    req, resp := client.CreateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags
func (c *EC2) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTags API operation for Amazon Elastic Compute Cloud.
//
// Adds or overwrites one or more tags for the specified Amazon EC2 resource
// or resources. Each resource can have a maximum of 50 tags. Each tag consists
// of a key and optional value. Tag keys must be unique per resource.
//
// For more information about tags, see Tagging Your Resources (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon Elastic Compute Cloud User Guide. For more information about
// creating IAM policies that control users' access to resources based on tags,
// see Supported Resource-Level Permissions for Amazon EC2 API Actions (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTags for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags
func (c *EC2) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVolume = "CreateVolume"

// CreateVolumeRequest generates a "aws/request.Request" representing the
// client's request for the CreateVolume operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateVolume for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateVolume method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateVolumeRequest method.
//    req, resp := client.CreateVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume
func (c *EC2) CreateVolumeRequest(input *CreateVolumeInput) (req *request.Request, output *Volume) {
	op := &request.Operation{
		Name:       opCreateVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVolumeInput{}
	}

	output = &Volume{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVolume API operation for Amazon Elastic Compute Cloud.
//
// Creates an EBS volume that can be attached to an instance in the same Availability
// Zone. The volume is created in the regional endpoint that you send the HTTP
// request to. For more information see Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html).
//
// You can create a new empty volume or restore a volume from an EBS snapshot.
// Any AWS Marketplace product codes from the snapshot are propagated to the
// volume.
//
// You can create encrypted volumes with the Encrypted parameter. Encrypted
// volumes may only be attached to instances that support Amazon EBS encryption.
// Volumes that are created from encrypted snapshots are also automatically
// encrypted. For more information, see Amazon EBS Encryption (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For more information, see Creating or Restoring an Amazon EBS Volume (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVolume for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume
func (c *EC2) CreateVolume(input *CreateVolumeInput) (*Volume, error) {
	req, out := c.CreateVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVpc = "CreateVpc"

// CreateVpcRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpc operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateVpc for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateVpc method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateVpcRequest method.
//    req, resp := client.CreateVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc
func (c *EC2) CreateVpcRequest(input *CreateVpcInput) (req *request.Request, output *CreateVpcOutput) {
	op := &request.Operation{
		Name:       opCreateVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcInput{}
	}

	output = &CreateVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpc API operation for Amazon Elastic Compute Cloud.
//
// Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you can
// create uses a /28 netmask (16 IPv4 addresses), and the largest uses a /16
// netmask (65,536 IPv4 addresses). To help you decide how big to make your
// VPC, see Your VPC and Subnets (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// You can optionally request an Amazon-provided IPv6 CIDR block for the VPC.
// The IPv6 CIDR block uses a /56 prefix length, and is allocated from Amazon's
// pool of IPv6 addresses. You cannot choose the IPv6 range for your VPC.
//
// By default, each instance you launch in the VPC has the default DHCP options,
// which includes only a default DNS server that we provide (AmazonProvidedDNS).
// For more information about DHCP options, see DHCP Options Sets (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// You can specify the instance tenancy value for the VPC when you create it.
// You can't change this value for the VPC after you create it. For more information,
// see Dedicated Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpc for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc
func (c *EC2) CreateVpc(input *CreateVpcInput) (*CreateVpcOutput, error) {
	req, out := c.CreateVpcRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVpcEndpoint = "CreateVpcEndpoint"

// CreateVpcEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcEndpoint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateVpcEndpoint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateVpcEndpoint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateVpcEndpointRequest method.
//    req, resp := client.CreateVpcEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint
func (c *EC2) CreateVpcEndpointRequest(input *CreateVpcEndpointInput) (req *request.Request, output *CreateVpcEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateVpcEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcEndpointInput{}
	}

	output = &CreateVpcEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcEndpoint API operation for Amazon Elastic Compute Cloud.
//
// Creates a VPC endpoint for a specified AWS service. An endpoint enables you
// to create a private connection between your VPC and another AWS service in
// your account. You can specify an endpoint policy to attach to the endpoint
// that will control access to the service from your VPC. You can also specify
// the VPC route tables that use the endpoint.
//
// Use DescribeVpcEndpointServices to get a list of supported AWS services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpcEndpoint for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint
func (c *EC2) CreateVpcEndpoint(input *CreateVpcEndpointInput) (*CreateVpcEndpointOutput, error) {
	req, out := c.CreateVpcEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVpcPeeringConnection = "CreateVpcPeeringConnection"

// CreateVpcPeeringConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcPeeringConnection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateVpcPeeringConnection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateVpcPeeringConnection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateVpcPeeringConnectionRequest method.
//    req, resp := client.CreateVpcPeeringConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection
func (c *EC2) CreateVpcPeeringConnectionRequest(input *CreateVpcPeeringConnectionInput) (req *request.Request, output *CreateVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcPeeringConnectionInput{}
	}

	output = &CreateVpcPeeringConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcPeeringConnection API operation for Amazon Elastic Compute Cloud.
//
// Requests a VPC peering connection between two VPCs: a requester VPC that
// you own and a peer VPC with which to create the connection. The peer VPC
// can belong to another AWS account. The requester VPC and peer VPC cannot
// have overlapping CIDR blocks.
//
// The owner of the peer VPC must accept the peering request to activate the
// peering connection. The VPC peering connection request expires after 7 days,
// after which it cannot be accepted or rejected.
//
// A CreateVpcPeeringConnection request between VPCs with overlapping CIDR blocks
// results in the VPC peering connection having a status of failed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpcPeeringConnection for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection
func (c *EC2) CreateVpcPeeringConnection(input *CreateVpcPeeringConnectionInput) (*CreateVpcPeeringConnectionOutput, error) {
	req, out := c.CreateVpcPeeringConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVpnConnection = "CreateVpnConnection"

// CreateVpnConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpnConnection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateVpnConnection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateVpnConnection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateVpnConnectionRequest method.
//    req, resp := client.CreateVpnConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection
func (c *EC2) CreateVpnConnectionRequest(input *CreateVpnConnectionInput) (req *request.Request, output *CreateVpnConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateVpnConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpnConnectionInput{}
	}

	output = &CreateVpnConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpnConnection API operation for Amazon Elastic Compute Cloud.
//
// Creates a VPN connection between an existing virtual private gateway and
// a VPN customer gateway. The only supported connection type is ipsec.1.
//
// The response includes information that you need to give to your network administrator
// to configure your customer gateway.
//
// We strongly recommend that you use HTTPS when calling this operation because
// the response contains sensitive cryptographic information for configuring
// your customer gateway.
//
// If you decide to shut down your VPN connection for any reason and later create
// a new VPN connection, you must reconfigure your customer gateway with the
// new information returned from this call.
//
// This is an idempotent operation. If you perform the operation more than once,
// Amazon EC2 doesn't return an error.
//
// For more information about VPN connections, see Adding a Hardware Virtual
// Private Gateway to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpnConnection for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection
func (c *EC2) CreateVpnConnection(input *CreateVpnConnectionInput) (*CreateVpnConnectionOutput, error) {
	req, out := c.CreateVpnConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVpnConnectionRoute = "CreateVpnConnectionRoute"

// CreateVpnConnectionRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpnConnectionRoute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateVpnConnectionRoute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateVpnConnectionRoute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateVpnConnectionRouteRequest method.
//    req, resp := client.CreateVpnConnectionRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute
func (c *EC2) CreateVpnConnectionRouteRequest(input *CreateVpnConnectionRouteInput) (req *request.Request, output *CreateVpnConnectionRouteOutput) {
	op := &request.Operation{
		Name:       opCreateVpnConnectionRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpnConnectionRouteInput{}
	}

	output = &CreateVpnConnectionRouteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateVpnConnectionRoute API operation for Amazon Elastic Compute Cloud.
//
// Creates a static route associated with a VPN connection between an existing
// virtual private gateway and a VPN customer gateway. The static route allows
// traffic to be routed from the virtual private gateway to the VPN customer
// gateway.
//
// For more information about VPN connections, see Adding a Hardware Virtual
// Private Gateway to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpnConnectionRoute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute
func (c *EC2) CreateVpnConnectionRoute(input *CreateVpnConnectionRouteInput) (*CreateVpnConnectionRouteOutput, error) {
	req, out := c.CreateVpnConnectionRouteRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVpnGateway = "CreateVpnGateway"

// CreateVpnGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpnGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateVpnGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateVpnGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateVpnGatewayRequest method.
//    req, resp := client.CreateVpnGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway
func (c *EC2) CreateVpnGatewayRequest(input *CreateVpnGatewayInput) (req *request.Request, output *CreateVpnGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpnGatewayInput{}
	}

	output = &CreateVpnGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpnGateway API operation for Amazon Elastic Compute Cloud.
//
// Creates a virtual private gateway. A virtual private gateway is the endpoint
// on the VPC side of your VPN connection. You can create a virtual private
// gateway before creating the VPC itself.
//
// For more information about virtual private gateways, see Adding a Hardware
// Virtual Private Gateway to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpnGateway for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway
func (c *EC2) CreateVpnGateway(input *CreateVpnGatewayInput) (*CreateVpnGatewayOutput, error) {
	req, out := c.CreateVpnGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteCustomerGateway = "DeleteCustomerGateway"

// DeleteCustomerGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomerGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteCustomerGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteCustomerGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteCustomerGatewayRequest method.
//    req, resp := client.DeleteCustomerGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway
func (c *EC2) DeleteCustomerGatewayRequest(input *DeleteCustomerGatewayInput) (req *request.Request, output *DeleteCustomerGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomerGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomerGatewayInput{}
	}

	output = &DeleteCustomerGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomerGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified customer gateway. You must delete the VPN connection
// before you can delete the customer gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteCustomerGateway for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway
func (c *EC2) DeleteCustomerGateway(input *DeleteCustomerGatewayInput) (*DeleteCustomerGatewayOutput, error) {
	req, out := c.DeleteCustomerGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDhcpOptions = "DeleteDhcpOptions"

// DeleteDhcpOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDhcpOptions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteDhcpOptions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteDhcpOptions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteDhcpOptionsRequest method.
//    req, resp := client.DeleteDhcpOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions
func (c *EC2) DeleteDhcpOptionsRequest(input *DeleteDhcpOptionsInput) (req *request.Request, output *DeleteDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opDeleteDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDhcpOptionsInput{}
	}

	output = &DeleteDhcpOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDhcpOptions API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified set of DHCP options. You must disassociate the set
// of DHCP options before you can delete it. You can disassociate the set of
// DHCP options by associating either a new set of options or the default set
// of options with the VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteDhcpOptions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions
func (c *EC2) DeleteDhcpOptions(input *DeleteDhcpOptionsInput) (*DeleteDhcpOptionsOutput, error) {
	req, out := c.DeleteDhcpOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteEgressOnlyInternetGateway = "DeleteEgressOnlyInternetGateway"

// DeleteEgressOnlyInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEgressOnlyInternetGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteEgressOnlyInternetGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteEgressOnlyInternetGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteEgressOnlyInternetGatewayRequest method.
//    req, resp := client.DeleteEgressOnlyInternetGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway
func (c *EC2) DeleteEgressOnlyInternetGatewayRequest(input *DeleteEgressOnlyInternetGatewayInput) (req *request.Request, output *DeleteEgressOnlyInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteEgressOnlyInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEgressOnlyInternetGatewayInput{}
	}

	output = &DeleteEgressOnlyInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEgressOnlyInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes an egress-only Internet gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteEgressOnlyInternetGateway for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway
func (c *EC2) DeleteEgressOnlyInternetGateway(input *DeleteEgressOnlyInternetGatewayInput) (*DeleteEgressOnlyInternetGatewayOutput, error) {
	req, out := c.DeleteEgressOnlyInternetGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteFlowLogs = "DeleteFlowLogs"

// DeleteFlowLogsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFlowLogs operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteFlowLogs for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteFlowLogs method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteFlowLogsRequest method.
//    req, resp := client.DeleteFlowLogsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs
func (c *EC2) DeleteFlowLogsRequest(input *DeleteFlowLogsInput) (req *request.Request, output *DeleteFlowLogsOutput) {
	op := &request.Operation{
		Name:       opDeleteFlowLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFlowLogsInput{}
	}

	output = &DeleteFlowLogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFlowLogs API operation for Amazon Elastic Compute Cloud.
//
// Deletes one or more flow logs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteFlowLogs for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs
func (c *EC2) DeleteFlowLogs(input *DeleteFlowLogsInput) (*DeleteFlowLogsOutput, error) {
	req, out := c.DeleteFlowLogsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteInternetGateway = "DeleteInternetGateway"

// DeleteInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInternetGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteInternetGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteInternetGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteInternetGatewayRequest method.
//    req, resp := client.DeleteInternetGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway
func (c *EC2) DeleteInternetGatewayRequest(input *DeleteInternetGatewayInput) (req *request.Request, output *DeleteInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInternetGatewayInput{}
	}

	output = &DeleteInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Internet gateway. You must detach the Internet gateway
// from the VPC before you can delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteInternetGateway for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway
func (c *EC2) DeleteInternetGateway(input *DeleteInternetGatewayInput) (*DeleteInternetGatewayOutput, error) {
	req, out := c.DeleteInternetGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteKeyPair = "DeleteKeyPair"

// DeleteKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKeyPair operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteKeyPair for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteKeyPair method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteKeyPairRequest method.
//    req, resp := client.DeleteKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair
func (c *EC2) DeleteKeyPairRequest(input *DeleteKeyPairInput) (req *request.Request, output *DeleteKeyPairOutput) {
	op := &request.Operation{
		Name:       opDeleteKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteKeyPairInput{}
	}

	output = &DeleteKeyPairOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteKeyPair API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified key pair, by removing the public key from Amazon EC2.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteKeyPair for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair
func (c *EC2) DeleteKeyPair(input *DeleteKeyPairInput) (*DeleteKeyPairOutput, error) {
	req, out := c.DeleteKeyPairRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteNatGateway = "DeleteNatGateway"

// DeleteNatGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNatGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteNatGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteNatGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteNatGatewayRequest method.
//    req, resp := client.DeleteNatGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway
func (c *EC2) DeleteNatGatewayRequest(input *DeleteNatGatewayInput) (req *request.Request, output *DeleteNatGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteNatGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNatGatewayInput{}
	}

	output = &DeleteNatGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNatGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified NAT gateway. Deleting a NAT gateway disassociates its
// Elastic IP address, but does not release the address from your account. Deleting
// a NAT gateway does not delete any NAT gateway routes in your route tables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNatGateway for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway
func (c *EC2) DeleteNatGateway(input *DeleteNatGatewayInput) (*DeleteNatGatewayOutput, error) {
	req, out := c.DeleteNatGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteNetworkAcl = "DeleteNetworkAcl"

// DeleteNetworkAclRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkAcl operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteNetworkAcl for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteNetworkAcl method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteNetworkAclRequest method.
//    req, resp := client.DeleteNetworkAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl
func (c *EC2) DeleteNetworkAclRequest(input *DeleteNetworkAclInput) (req *request.Request, output *DeleteNetworkAclOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkAcl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkAclInput{}
	}

	output = &DeleteNetworkAclOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNetworkAcl API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified network ACL. You can't delete the ACL if it's associated
// with any subnets. You can't delete the default network ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkAcl for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl
func (c *EC2) DeleteNetworkAcl(input *DeleteNetworkAclInput) (*DeleteNetworkAclOutput, error) {
	req, out := c.DeleteNetworkAclRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteNetworkAclEntry = "DeleteNetworkAclEntry"

// DeleteNetworkAclEntryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkAclEntry operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteNetworkAclEntry for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteNetworkAclEntry method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteNetworkAclEntryRequest method.
//    req, resp := client.DeleteNetworkAclEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry
func (c *EC2) DeleteNetworkAclEntryRequest(input *DeleteNetworkAclEntryInput) (req *request.Request, output *DeleteNetworkAclEntryOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkAclEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkAclEntryInput{}
	}

	output = &DeleteNetworkAclEntryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNetworkAclEntry API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified ingress or egress entry (rule) from the specified network
// ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkAclEntry for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry
func (c *EC2) DeleteNetworkAclEntry(input *DeleteNetworkAclEntryInput) (*DeleteNetworkAclEntryOutput, error) {
	req, out := c.DeleteNetworkAclEntryRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteNetworkInterface = "DeleteNetworkInterface"

// DeleteNetworkInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkInterface operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteNetworkInterface for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteNetworkInterface method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteNetworkInterfaceRequest method.
//    req, resp := client.DeleteNetworkInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface
func (c *EC2) DeleteNetworkInterfaceRequest(input *DeleteNetworkInterfaceInput) (req *request.Request, output *DeleteNetworkInterfaceOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkInterfaceInput{}
	}

	output = &DeleteNetworkInterfaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNetworkInterface API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified network interface. You must detach the network interface
// before you can delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkInterface for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface
func (c *EC2) DeleteNetworkInterface(input *DeleteNetworkInterfaceInput) (*DeleteNetworkInterfaceOutput, error) {
	req, out := c.DeleteNetworkInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePlacementGroup = "DeletePlacementGroup"

// DeletePlacementGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeletePlacementGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeletePlacementGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeletePlacementGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeletePlacementGroupRequest method.
//    req, resp := client.DeletePlacementGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup
func (c *EC2) DeletePlacementGroupRequest(input *DeletePlacementGroupInput) (req *request.Request, output *DeletePlacementGroupOutput) {
	op := &request.Operation{
		Name:       opDeletePlacementGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePlacementGroupInput{}
	}

	output = &DeletePlacementGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePlacementGroup API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified placement group. You must terminate all instances in
// the placement group before you can delete the placement group. For more information
// about placement groups and cluster instances, see Cluster Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cluster_computing.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeletePlacementGroup for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup
func (c *EC2) DeletePlacementGroup(input *DeletePlacementGroupInput) (*DeletePlacementGroupOutput, error) {
	req, out := c.DeletePlacementGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRoute = "DeleteRoute"

// DeleteRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteRoute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRoute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRouteRequest method.
//    req, resp := client.DeleteRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute
func (c *EC2) DeleteRouteRequest(input *DeleteRouteInput) (req *request.Request, output *DeleteRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRouteInput{}
	}

	output = &DeleteRouteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRoute API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified route from the specified route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteRoute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute
func (c *EC2) DeleteRoute(input *DeleteRouteInput) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRouteTable = "DeleteRouteTable"

// DeleteRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRouteTable operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteRouteTable for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRouteTable method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRouteTableRequest method.
//    req, resp := client.DeleteRouteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable
func (c *EC2) DeleteRouteTableRequest(input *DeleteRouteTableInput) (req *request.Request, output *DeleteRouteTableOutput) {
	op := &request.Operation{
		Name:       opDeleteRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRouteTableInput{}
	}

	output = &DeleteRouteTableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified route table. You must disassociate the route table
// from any subnets before you can delete it. You can't delete the main route
// table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteRouteTable for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable
func (c *EC2) DeleteRouteTable(input *DeleteRouteTableInput) (*DeleteRouteTableOutput, error) {
	req, out := c.DeleteRouteTableRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSecurityGroup = "DeleteSecurityGroup"

// DeleteSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSecurityGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSecurityGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSecurityGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSecurityGroupRequest method.
//    req, resp := client.DeleteSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup
func (c *EC2) DeleteSecurityGroupRequest(input *DeleteSecurityGroupInput) (req *request.Request, output *DeleteSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSecurityGroupInput{}
	}

	output = &DeleteSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSecurityGroup API operation for Amazon Elastic Compute Cloud.
//
// Deletes a security group.
//
// If you attempt to delete a security group that is associated with an instance,
// or is referenced by another security group, the operation fails with InvalidGroup.InUse
// in EC2-Classic or DependencyViolation in EC2-VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteSecurityGroup for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup
func (c *EC2) DeleteSecurityGroup(input *DeleteSecurityGroupInput) (*DeleteSecurityGroupOutput, error) {
	req, out := c.DeleteSecurityGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSnapshot = "DeleteSnapshot"

// DeleteSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSnapshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSnapshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSnapshotRequest method.
//    req, resp := client.DeleteSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot
func (c *EC2) DeleteSnapshotRequest(input *DeleteSnapshotInput) (req *request.Request, output *DeleteSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotInput{}
	}

	output = &DeleteSnapshotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSnapshot API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified snapshot.
//
// When you make periodic snapshots of a volume, the snapshots are incremental,
// and only the blocks on the device that have changed since your last snapshot
// are saved in the new snapshot. When you delete a snapshot, only the data
// not needed for any other snapshot is removed. So regardless of which prior
// snapshots have been deleted, all active snapshots will have access to all
// the information needed to restore the volume.
//
// You cannot delete a snapshot of the root device of an EBS volume used by
// a registered AMI. You must first de-register the AMI before you can delete
// the snapshot.
//
// For more information, see Deleting an Amazon EBS Snapshot (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteSnapshot for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot
func (c *EC2) DeleteSnapshot(input *DeleteSnapshotInput) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSpotDatafeedSubscription = "DeleteSpotDatafeedSubscription"

// DeleteSpotDatafeedSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSpotDatafeedSubscription operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSpotDatafeedSubscription for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSpotDatafeedSubscription method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSpotDatafeedSubscriptionRequest method.
//    req, resp := client.DeleteSpotDatafeedSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription
func (c *EC2) DeleteSpotDatafeedSubscriptionRequest(input *DeleteSpotDatafeedSubscriptionInput) (req *request.Request, output *DeleteSpotDatafeedSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteSpotDatafeedSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSpotDatafeedSubscriptionInput{}
	}

	output = &DeleteSpotDatafeedSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSpotDatafeedSubscription API operation for Amazon Elastic Compute Cloud.
//
// Deletes the data feed for Spot instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteSpotDatafeedSubscription for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription
func (c *EC2) DeleteSpotDatafeedSubscription(input *DeleteSpotDatafeedSubscriptionInput) (*DeleteSpotDatafeedSubscriptionOutput, error) {
	req, out := c.DeleteSpotDatafeedSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSubnet = "DeleteSubnet"

// DeleteSubnetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubnet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSubnet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSubnet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSubnetRequest method.
//    req, resp := client.DeleteSubnetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet
func (c *EC2) DeleteSubnetRequest(input *DeleteSubnetInput) (req *request.Request, output *DeleteSubnetOutput) {
	op := &request.Operation{
		Name:       opDeleteSubnet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSubnetInput{}
	}

	output = &DeleteSubnetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSubnet API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified subnet. You must terminate all running instances in
// the subnet before you can delete the subnet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteSubnet for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet
func (c *EC2) DeleteSubnet(input *DeleteSubnetInput) (*DeleteSubnetOutput, error) {
	req, out := c.DeleteSubnetRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags
func (c *EC2) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified set of tags from the specified set of resources. This
// call is designed to follow a DescribeTags request.
//
// For more information about tags, see Tagging Your Resources (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTags for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags
func (c *EC2) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVolume = "DeleteVolume"

// DeleteVolumeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVolume operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteVolume for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteVolume method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteVolumeRequest method.
//    req, resp := client.DeleteVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume
func (c *EC2) DeleteVolumeRequest(input *DeleteVolumeInput) (req *request.Request, output *DeleteVolumeOutput) {
	op := &request.Operation{
		Name:       opDeleteVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVolumeInput{}
	}

	output = &DeleteVolumeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVolume API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified EBS volume. The volume must be in the available state
// (not attached to an instance).
//
// The volume may remain in the deleting state for several minutes.
//
// For more information, see Deleting an Amazon EBS Volume (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVolume for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume
func (c *EC2) DeleteVolume(input *DeleteVolumeInput) (*DeleteVolumeOutput, error) {
	req, out := c.DeleteVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVpc = "DeleteVpc"

// DeleteVpcRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpc operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteVpc for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteVpc method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteVpcRequest method.
//    req, resp := client.DeleteVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc
func (c *EC2) DeleteVpcRequest(input *DeleteVpcInput) (req *request.Request, output *DeleteVpcOutput) {
	op := &request.Operation{
		Name:       opDeleteVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcInput{}
	}

	output = &DeleteVpcOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpc API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified VPC. You must detach or delete all gateways and resources
// that are associated with the VPC before you can delete it. For example, you
// must terminate all instances running in the VPC, delete all security groups
// associated with the VPC (except the default one), delete all route tables
// associated with the VPC (except the default one), and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpc for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc
func (c *EC2) DeleteVpc(input *DeleteVpcInput) (*DeleteVpcOutput, error) {
	req, out := c.DeleteVpcRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVpcEndpoints = "DeleteVpcEndpoints"

// DeleteVpcEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcEndpoints operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteVpcEndpoints for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteVpcEndpoints method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteVpcEndpointsRequest method.
//    req, resp := client.DeleteVpcEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints
func (c *EC2) DeleteVpcEndpointsRequest(input *DeleteVpcEndpointsInput) (req *request.Request, output *DeleteVpcEndpointsOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcEndpointsInput{}
	}

	output = &DeleteVpcEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcEndpoints API operation for Amazon Elastic Compute Cloud.
//
// Deletes one or more specified VPC endpoints. Deleting the endpoint also deletes
// the endpoint routes in the route tables that were associated with the endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpcEndpoints for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints
func (c *EC2) DeleteVpcEndpoints(input *DeleteVpcEndpointsInput) (*DeleteVpcEndpointsOutput, error) {
	req, out := c.DeleteVpcEndpointsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVpcPeeringConnection = "DeleteVpcPeeringConnection"

// DeleteVpcPeeringConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcPeeringConnection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteVpcPeeringConnection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteVpcPeeringConnection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteVpcPeeringConnectionRequest method.
//    req, resp := client.DeleteVpcPeeringConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection
func (c *EC2) DeleteVpcPeeringConnectionRequest(input *DeleteVpcPeeringConnectionInput) (req *request.Request, output *DeleteVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcPeeringConnectionInput{}
	}

	output = &DeleteVpcPeeringConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcPeeringConnection API operation for Amazon Elastic Compute Cloud.
//
// Deletes a VPC peering connection. Either the owner of the requester VPC or
// the owner of the peer VPC can delete the VPC peering connection if it's in
// the active state. The owner of the requester VPC can delete a VPC peering
// connection in the pending-acceptance state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpcPeeringConnection for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection
func (c *EC2) DeleteVpcPeeringConnection(input *DeleteVpcPeeringConnectionInput) (*DeleteVpcPeeringConnectionOutput, error) {
	req, out := c.DeleteVpcPeeringConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVpnConnection = "DeleteVpnConnection"

// DeleteVpnConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpnConnection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteVpnConnection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteVpnConnection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteVpnConnectionRequest method.
//    req, resp := client.DeleteVpnConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection
func (c *EC2) DeleteVpnConnectionRequest(input *DeleteVpnConnectionInput) (req *request.Request, output *DeleteVpnConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteVpnConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpnConnectionInput{}
	}

	output = &DeleteVpnConnectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpnConnection API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified VPN connection.
//
// If you're deleting the VPC and its associated components, we recommend that
// you detach the virtual private gateway from the VPC and delete the VPC before
// deleting the VPN connection. If you believe that the tunnel credentials for
// your VPN connection have been compromised, you can delete the VPN connection
// and create a new one that has new keys, without needing to delete the VPC
// or virtual private gateway. If you create a new VPN connection, you must
// reconfigure the customer gateway using the new configuration information
// returned with the new VPN connection ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpnConnection for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection
func (c *EC2) DeleteVpnConnection(input *DeleteVpnConnectionInput) (*DeleteVpnConnectionOutput, error) {
	req, out := c.DeleteVpnConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVpnConnectionRoute = "DeleteVpnConnectionRoute"

// DeleteVpnConnectionRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpnConnectionRoute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteVpnConnectionRoute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteVpnConnectionRoute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteVpnConnectionRouteRequest method.
//    req, resp := client.DeleteVpnConnectionRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute
func (c *EC2) DeleteVpnConnectionRouteRequest(input *DeleteVpnConnectionRouteInput) (req *request.Request, output *DeleteVpnConnectionRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteVpnConnectionRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpnConnectionRouteInput{}
	}

	output = &DeleteVpnConnectionRouteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpnConnectionRoute API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified static route associated with a VPN connection between
// an existing virtual private gateway and a VPN customer gateway. The static
// route allows traffic to be routed from the virtual private gateway to the
// VPN customer gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpnConnectionRoute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute
func (c *EC2) DeleteVpnConnectionRoute(input *DeleteVpnConnectionRouteInput) (*DeleteVpnConnectionRouteOutput, error) {
	req, out := c.DeleteVpnConnectionRouteRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVpnGateway = "DeleteVpnGateway"

// DeleteVpnGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpnGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteVpnGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteVpnGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteVpnGatewayRequest method.
//    req, resp := client.DeleteVpnGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway
func (c *EC2) DeleteVpnGatewayRequest(input *DeleteVpnGatewayInput) (req *request.Request, output *DeleteVpnGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpnGatewayInput{}
	}

	output = &DeleteVpnGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpnGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified virtual private gateway. We recommend that before you
// delete a virtual private gateway, you detach it from the VPC and delete the
// VPN connection. Note that you don't need to delete the virtual private gateway
// if you plan to delete and recreate the VPN connection between your VPC and
// your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpnGateway for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway
func (c *EC2) DeleteVpnGateway(input *DeleteVpnGatewayInput) (*DeleteVpnGatewayOutput, error) {
	req, out := c.DeleteVpnGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDeregisterImage = "DeregisterImage"

// DeregisterImageRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterImage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeregisterImage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeregisterImage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeregisterImageRequest method.
//    req, resp := client.DeregisterImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage
func (c *EC2) DeregisterImageRequest(input *DeregisterImageInput) (req *request.Request, output *DeregisterImageOutput) {
	op := &request.Operation{
		Name:       opDeregisterImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterImageInput{}
	}

	output = &DeregisterImageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterImage API operation for Amazon Elastic Compute Cloud.
//
// Deregisters the specified AMI. After you deregister an AMI, it can't be used
// to launch new instances.
//
// This command does not delete the AMI.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeregisterImage for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage
func (c *EC2) DeregisterImage(input *DeregisterImageInput) (*DeregisterImageOutput, error) {
	req, out := c.DeregisterImageRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAccountAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAccountAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAccountAttributesRequest method.
//    req, resp := client.DescribeAccountAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes
func (c *EC2) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	output = &DescribeAccountAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAttributes API operation for Amazon Elastic Compute Cloud.
//
// Describes attributes of your AWS account. The following are the supported
// account attributes:
//
//    * supported-platforms: Indicates whether your account can launch instances
//    into EC2-Classic and EC2-VPC, or only into EC2-VPC.
//
//    * default-vpc: The ID of the default VPC for your account, or none.
//
//    * max-instances: The maximum number of On-Demand instances that you can
//    run.
//
//    * vpc-max-security-groups-per-interface: The maximum number of security
//    groups that you can assign to a network interface.
//
//    * max-elastic-ips: The maximum number of Elastic IP addresses that you
//    can allocate for use with EC2-Classic.
//
//    * vpc-max-elastic-ips: The maximum number of Elastic IP addresses that
//    you can allocate for use with EC2-VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAccountAttributes for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes
func (c *EC2) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAddresses = "DescribeAddresses"

// DescribeAddressesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddresses operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAddresses for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAddresses method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAddressesRequest method.
//    req, resp := client.DescribeAddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses
func (c *EC2) DescribeAddressesRequest(input *DescribeAddressesInput) (req *request.Request, output *DescribeAddressesOutput) {
	op := &request.Operation{
		Name:       opDescribeAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAddressesInput{}
	}

	output = &DescribeAddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddresses API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your Elastic IP addresses.
//
// An Elastic IP address is for use in either the EC2-Classic platform or in
// a VPC. For more information, see Elastic IP Addresses (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAddresses for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses
func (c *EC2) DescribeAddresses(input *DescribeAddressesInput) (*DescribeAddressesOutput, error) {
	req, out := c.DescribeAddressesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAvailabilityZones = "DescribeAvailabilityZones"

// DescribeAvailabilityZonesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAvailabilityZones operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAvailabilityZones for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAvailabilityZones method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAvailabilityZonesRequest method.
//    req, resp := client.DescribeAvailabilityZonesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones
func (c *EC2) DescribeAvailabilityZonesRequest(input *DescribeAvailabilityZonesInput) (req *request.Request, output *DescribeAvailabilityZonesOutput) {
	op := &request.Operation{
		Name:       opDescribeAvailabilityZones,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAvailabilityZonesInput{}
	}

	output = &DescribeAvailabilityZonesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAvailabilityZones API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of the Availability Zones that are available to you.
// The results include zones only for the region you're currently using. If
// there is an event impacting an Availability Zone, you can use this request
// to view the state and any provided message for that Availability Zone.
//
// For more information, see Regions and Availability Zones (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAvailabilityZones for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones
func (c *EC2) DescribeAvailabilityZones(input *DescribeAvailabilityZonesInput) (*DescribeAvailabilityZonesOutput, error) {
	req, out := c.DescribeAvailabilityZonesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeBundleTasks = "DescribeBundleTasks"

// DescribeBundleTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBundleTasks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeBundleTasks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeBundleTasks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeBundleTasksRequest method.
//    req, resp := client.DescribeBundleTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks
func (c *EC2) DescribeBundleTasksRequest(input *DescribeBundleTasksInput) (req *request.Request, output *DescribeBundleTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeBundleTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBundleTasksInput{}
	}

	output = &DescribeBundleTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBundleTasks API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your bundling tasks.
//
// Completed bundle tasks are listed for only a limited time. If your bundle
// task is no longer in the list, you can still register an AMI from it. Just
// use RegisterImage with the Amazon S3 bucket name and image manifest name
// you provided to the bundle task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeBundleTasks for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks
func (c *EC2) DescribeBundleTasks(input *DescribeBundleTasksInput) (*DescribeBundleTasksOutput, error) {
	req, out := c.DescribeBundleTasksRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeClassicLinkInstances = "DescribeClassicLinkInstances"

// DescribeClassicLinkInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClassicLinkInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeClassicLinkInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeClassicLinkInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeClassicLinkInstancesRequest method.
//    req, resp := client.DescribeClassicLinkInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstances
func (c *EC2) DescribeClassicLinkInstancesRequest(input *DescribeClassicLinkInstancesInput) (req *request.Request, output *DescribeClassicLinkInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeClassicLinkInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClassicLinkInstancesInput{}
	}

	output = &DescribeClassicLinkInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClassicLinkInstances API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your linked EC2-Classic instances. This request
// only returns information about EC2-Classic instances linked to a VPC through
// ClassicLink; you cannot use this request to return information about other
// instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeClassicLinkInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstances
func (c *EC2) DescribeClassicLinkInstances(input *DescribeClassicLinkInstancesInput) (*DescribeClassicLinkInstancesOutput, error) {
	req, out := c.DescribeClassicLinkInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeConversionTasks = "DescribeConversionTasks"

// DescribeConversionTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConversionTasks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeConversionTasks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeConversionTasks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeConversionTasksRequest method.
//    req, resp := client.DescribeConversionTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasks
func (c *EC2) DescribeConversionTasksRequest(input *DescribeConversionTasksInput) (req *request.Request, output *DescribeConversionTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeConversionTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConversionTasksInput{}
	}

	output = &DescribeConversionTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConversionTasks API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your conversion tasks. For more information, see
// the VM Import/Export User Guide (http://docs.aws.amazon.com/vm-import/latest/userguide/).
//
// For information about the import manifest referenced by this API action,
// see VM Import Manifest (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeConversionTasks for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasks
func (c *EC2) DescribeConversionTasks(input *DescribeConversionTasksInput) (*DescribeConversionTasksOutput, error) {
	req, out := c.DescribeConversionTasksRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCustomerGateways = "DescribeCustomerGateways"

// DescribeCustomerGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCustomerGateways operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeCustomerGateways for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeCustomerGateways method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeCustomerGatewaysRequest method.
//    req, resp := client.DescribeCustomerGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGateways
func (c *EC2) DescribeCustomerGatewaysRequest(input *DescribeCustomerGatewaysInput) (req *request.Request, output *DescribeCustomerGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomerGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCustomerGatewaysInput{}
	}

	output = &DescribeCustomerGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCustomerGateways API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your VPN customer gateways.
//
// For more information about VPN customer gateways, see Adding a Hardware Virtual
// Private Gateway to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeCustomerGateways for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGateways
func (c *EC2) DescribeCustomerGateways(input *DescribeCustomerGatewaysInput) (*DescribeCustomerGatewaysOutput, error) {
	req, out := c.DescribeCustomerGatewaysRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDhcpOptions = "DescribeDhcpOptions"

// DescribeDhcpOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDhcpOptions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeDhcpOptions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeDhcpOptions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeDhcpOptionsRequest method.
//    req, resp := client.DescribeDhcpOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptions
func (c *EC2) DescribeDhcpOptionsRequest(input *DescribeDhcpOptionsInput) (req *request.Request, output *DescribeDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDhcpOptionsInput{}
	}

	output = &DescribeDhcpOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDhcpOptions API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your DHCP options sets.
//
// For more information about DHCP options sets, see DHCP Options Sets (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeDhcpOptions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptions
func (c *EC2) DescribeDhcpOptions(input *DescribeDhcpOptionsInput) (*DescribeDhcpOptionsOutput, error) {
	req, out := c.DescribeDhcpOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEgressOnlyInternetGateways = "DescribeEgressOnlyInternetGateways"

// DescribeEgressOnlyInternetGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEgressOnlyInternetGateways operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeEgressOnlyInternetGateways for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeEgressOnlyInternetGateways method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeEgressOnlyInternetGatewaysRequest method.
//    req, resp := client.DescribeEgressOnlyInternetGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGateways
func (c *EC2) DescribeEgressOnlyInternetGatewaysRequest(input *DescribeEgressOnlyInternetGatewaysInput) (req *request.Request, output *DescribeEgressOnlyInternetGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeEgressOnlyInternetGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEgressOnlyInternetGatewaysInput{}
	}

	output = &DescribeEgressOnlyInternetGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEgressOnlyInternetGateways API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your egress-only Internet gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeEgressOnlyInternetGateways for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGateways
func (c *EC2) DescribeEgressOnlyInternetGateways(input *DescribeEgressOnlyInternetGatewaysInput) (*DescribeEgressOnlyInternetGatewaysOutput, error) {
	req, out := c.DescribeEgressOnlyInternetGatewaysRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeExportTasks = "DescribeExportTasks"

// DescribeExportTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExportTasks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeExportTasks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeExportTasks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeExportTasksRequest method.
//    req, resp := client.DescribeExportTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasks
func (c *EC2) DescribeExportTasksRequest(input *DescribeExportTasksInput) (req *request.Request, output *DescribeExportTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeExportTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExportTasksInput{}
	}

	output = &DescribeExportTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExportTasks API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your export tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeExportTasks for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasks
func (c *EC2) DescribeExportTasks(input *DescribeExportTasksInput) (*DescribeExportTasksOutput, error) {
	req, out := c.DescribeExportTasksRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeFlowLogs = "DescribeFlowLogs"

// DescribeFlowLogsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFlowLogs operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeFlowLogs for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeFlowLogs method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeFlowLogsRequest method.
//    req, resp := client.DescribeFlowLogsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogs
func (c *EC2) DescribeFlowLogsRequest(input *DescribeFlowLogsInput) (req *request.Request, output *DescribeFlowLogsOutput) {
	op := &request.Operation{
		Name:       opDescribeFlowLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFlowLogsInput{}
	}

	output = &DescribeFlowLogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFlowLogs API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more flow logs. To view the information in your flow logs
// (the log streams for the network interfaces), you must use the CloudWatch
// Logs console or the CloudWatch Logs API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFlowLogs for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogs
func (c *EC2) DescribeFlowLogs(input *DescribeFlowLogsInput) (*DescribeFlowLogsOutput, error) {
	req, out := c.DescribeFlowLogsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeHostReservationOfferings = "DescribeHostReservationOfferings"

// DescribeHostReservationOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHostReservationOfferings operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeHostReservationOfferings for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeHostReservationOfferings method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeHostReservationOfferingsRequest method.
//    req, resp := client.DescribeHostReservationOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferings
func (c *EC2) DescribeHostReservationOfferingsRequest(input *DescribeHostReservationOfferingsInput) (req *request.Request, output *DescribeHostReservationOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeHostReservationOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHostReservationOfferingsInput{}
	}

	output = &DescribeHostReservationOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHostReservationOfferings API operation for Amazon Elastic Compute Cloud.
//
// Describes the Dedicated Host Reservations that are available to purchase.
//
// The results describe all the Dedicated Host Reservation offerings, including
// offerings that may not match the instance family and region of your Dedicated
// Hosts. When purchasing an offering, ensure that the the instance family and
// region of the offering matches that of the Dedicated Host/s it will be associated
// with. For an overview of supported instance types, see Dedicated Hosts Overview
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeHostReservationOfferings for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferings
func (c *EC2) DescribeHostReservationOfferings(input *DescribeHostReservationOfferingsInput) (*DescribeHostReservationOfferingsOutput, error) {
	req, out := c.DescribeHostReservationOfferingsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeHostReservations = "DescribeHostReservations"

// DescribeHostReservationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHostReservations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeHostReservations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeHostReservations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeHostReservationsRequest method.
//    req, resp := client.DescribeHostReservationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservations
func (c *EC2) DescribeHostReservationsRequest(input *DescribeHostReservationsInput) (req *request.Request, output *DescribeHostReservationsOutput) {
	op := &request.Operation{
		Name:       opDescribeHostReservations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHostReservationsInput{}
	}

	output = &DescribeHostReservationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHostReservations API operation for Amazon Elastic Compute Cloud.
//
// Describes Dedicated Host Reservations which are associated with Dedicated
// Hosts in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeHostReservations for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservations
func (c *EC2) DescribeHostReservations(input *DescribeHostReservationsInput) (*DescribeHostReservationsOutput, error) {
	req, out := c.DescribeHostReservationsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeHosts = "DescribeHosts"

// DescribeHostsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHosts operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeHosts for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeHosts method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeHostsRequest method.
//    req, resp := client.DescribeHostsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHosts
func (c *EC2) DescribeHostsRequest(input *DescribeHostsInput) (req *request.Request, output *DescribeHostsOutput) {
	op := &request.Operation{
		Name:       opDescribeHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHostsInput{}
	}

	output = &DescribeHostsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHosts API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your Dedicated Hosts.
//
// The results describe only the Dedicated Hosts in the region you're currently
// using. All listed instances consume capacity on your Dedicated Host. Dedicated
// Hosts that have recently been released will be listed with the state released.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeHosts for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHosts
func (c *EC2) DescribeHosts(input *DescribeHostsInput) (*DescribeHostsOutput, error) {
	req, out := c.DescribeHostsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeIdFormat = "DescribeIdFormat"

// DescribeIdFormatRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdFormat operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeIdFormat for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeIdFormat method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeIdFormatRequest method.
//    req, resp := client.DescribeIdFormatRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormat
func (c *EC2) DescribeIdFormatRequest(input *DescribeIdFormatInput) (req *request.Request, output *DescribeIdFormatOutput) {
	op := &request.Operation{
		Name:       opDescribeIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdFormatInput{}
	}

	output = &DescribeIdFormatOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdFormat API operation for Amazon Elastic Compute Cloud.
//
// Describes the ID format settings for your resources on a per-region basis,
// for example, to view which resource types are enabled for longer IDs. This
// request only returns information about resource types whose ID formats can
// be modified; it does not return information about other resource types.
//
// The following resource types support longer IDs: instance | reservation |
// snapshot | volume.
//
// These settings apply to the IAM user who makes the request; they do not apply
// to the entire AWS account. By default, an IAM user defaults to the same settings
// as the root user, unless they explicitly override the settings by running
// the ModifyIdFormat command. Resources created with longer IDs are visible
// to all IAM users, regardless of these settings and provided that they have
// permission to use the relevant Describe command for the resource type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeIdFormat for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormat
func (c *EC2) DescribeIdFormat(input *DescribeIdFormatInput) (*DescribeIdFormatOutput, error) {
	req, out := c.DescribeIdFormatRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeIdentityIdFormat = "DescribeIdentityIdFormat"

// DescribeIdentityIdFormatRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdentityIdFormat operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeIdentityIdFormat for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeIdentityIdFormat method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeIdentityIdFormatRequest method.
//    req, resp := client.DescribeIdentityIdFormatRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormat
func (c *EC2) DescribeIdentityIdFormatRequest(input *DescribeIdentityIdFormatInput) (req *request.Request, output *DescribeIdentityIdFormatOutput) {
	op := &request.Operation{
		Name:       opDescribeIdentityIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdentityIdFormatInput{}
	}

	output = &DescribeIdentityIdFormatOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdentityIdFormat API operation for Amazon Elastic Compute Cloud.
//
// Describes the ID format settings for resources for the specified IAM user,
// IAM role, or root user. For example, you can view the resource types that
// are enabled for longer IDs. This request only returns information about resource
// types whose ID formats can be modified; it does not return information about
// other resource types. For more information, see Resource IDs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// The following resource types support longer IDs: instance | reservation |
// snapshot | volume.
//
// These settings apply to the principal specified in the request. They do not
// apply to the principal that makes the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeIdentityIdFormat for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormat
func (c *EC2) DescribeIdentityIdFormat(input *DescribeIdentityIdFormatInput) (*DescribeIdentityIdFormatOutput, error) {
	req, out := c.DescribeIdentityIdFormatRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeImageAttribute = "DescribeImageAttribute"

// DescribeImageAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImageAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeImageAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeImageAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeImageAttributeRequest method.
//    req, resp := client.DescribeImageAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttribute
func (c *EC2) DescribeImageAttributeRequest(input *DescribeImageAttributeInput) (req *request.Request, output *DescribeImageAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeImageAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImageAttributeInput{}
	}

	output = &DescribeImageAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImageAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified attribute of the specified AMI. You can specify only
// one attribute at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeImageAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttribute
func (c *EC2) DescribeImageAttribute(input *DescribeImageAttributeInput) (*DescribeImageAttributeOutput, error) {
	req, out := c.DescribeImageAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeImages = "DescribeImages"

// DescribeImagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImages operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeImages for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeImages method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeImagesRequest method.
//    req, resp := client.DescribeImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImages
func (c *EC2) DescribeImagesRequest(input *DescribeImagesInput) (req *request.Request, output *DescribeImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImagesInput{}
	}

	output = &DescribeImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImages API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of the images (AMIs, AKIs, and ARIs) available to you.
// Images available to you include public images, private images that you own,
// and private images owned by other AWS accounts but for which you have explicit
// launch permissions.
//
// Deregistered images are included in the returned results for an unspecified
// interval after deregistration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeImages for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImages
func (c *EC2) DescribeImages(input *DescribeImagesInput) (*DescribeImagesOutput, error) {
	req, out := c.DescribeImagesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeImportImageTasks = "DescribeImportImageTasks"

// DescribeImportImageTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImportImageTasks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeImportImageTasks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeImportImageTasks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeImportImageTasksRequest method.
//    req, resp := client.DescribeImportImageTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasks
func (c *EC2) DescribeImportImageTasksRequest(input *DescribeImportImageTasksInput) (req *request.Request, output *DescribeImportImageTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeImportImageTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImportImageTasksInput{}
	}

	output = &DescribeImportImageTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImportImageTasks API operation for Amazon Elastic Compute Cloud.
//
// Displays details about an import virtual machine or import snapshot tasks
// that are already created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeImportImageTasks for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasks
func (c *EC2) DescribeImportImageTasks(input *DescribeImportImageTasksInput) (*DescribeImportImageTasksOutput, error) {
	req, out := c.DescribeImportImageTasksRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeImportSnapshotTasks = "DescribeImportSnapshotTasks"

// DescribeImportSnapshotTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImportSnapshotTasks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeImportSnapshotTasks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeImportSnapshotTasks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeImportSnapshotTasksRequest method.
//    req, resp := client.DescribeImportSnapshotTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasks
func (c *EC2) DescribeImportSnapshotTasksRequest(input *DescribeImportSnapshotTasksInput) (req *request.Request, output *DescribeImportSnapshotTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeImportSnapshotTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImportSnapshotTasksInput{}
	}

	output = &DescribeImportSnapshotTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImportSnapshotTasks API operation for Amazon Elastic Compute Cloud.
//
// Describes your import snapshot tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeImportSnapshotTasks for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasks
func (c *EC2) DescribeImportSnapshotTasks(input *DescribeImportSnapshotTasksInput) (*DescribeImportSnapshotTasksOutput, error) {
	req, out := c.DescribeImportSnapshotTasksRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeInstanceAttribute = "DescribeInstanceAttribute"

// DescribeInstanceAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeInstanceAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeInstanceAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeInstanceAttributeRequest method.
//    req, resp := client.DescribeInstanceAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttribute
func (c *EC2) DescribeInstanceAttributeRequest(input *DescribeInstanceAttributeInput) (req *request.Request, output *DescribeInstanceAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceAttributeInput{}
	}

	output = &DescribeInstanceAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified attribute of the specified instance. You can specify
// only one attribute at a time. Valid attribute values are: instanceType |
// kernel | ramdisk | userData | disableApiTermination | instanceInitiatedShutdownBehavior
// | rootDeviceName | blockDeviceMapping | productCodes | sourceDestCheck |
// groupSet | ebsOptimized | sriovNetSupport
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeInstanceAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttribute
func (c *EC2) DescribeInstanceAttribute(input *DescribeInstanceAttributeInput) (*DescribeInstanceAttributeOutput, error) {
	req, out := c.DescribeInstanceAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeInstanceStatus = "DescribeInstanceStatus"

// DescribeInstanceStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeInstanceStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeInstanceStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeInstanceStatusRequest method.
//    req, resp := client.DescribeInstanceStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatus
func (c *EC2) DescribeInstanceStatusRequest(input *DescribeInstanceStatusInput) (req *request.Request, output *DescribeInstanceStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstanceStatusInput{}
	}

	output = &DescribeInstanceStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceStatus API operation for Amazon Elastic Compute Cloud.
//
// Describes the status of one or more instances. By default, only running instances
// are described, unless specified otherwise.
//
// Instance status includes the following components:
//
//    * Status checks - Amazon EC2 performs status checks on running EC2 instances
//    to identify hardware and software issues. For more information, see Status
//    Checks for Your Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html)
//    and Troubleshooting Instances with Failed Status Checks (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html)
//    in the Amazon Elastic Compute Cloud User Guide.
//
//    * Scheduled events - Amazon EC2 can schedule events (such as reboot, stop,
//    or terminate) for your instances related to hardware issues, software
//    updates, or system maintenance. For more information, see Scheduled Events
//    for Your Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html)
//    in the Amazon Elastic Compute Cloud User Guide.
//
//    * Instance state - You can manage your instances from the moment you launch
//    them through their termination. For more information, see Instance Lifecycle
//    (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html)
//    in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeInstanceStatus for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatus
func (c *EC2) DescribeInstanceStatus(input *DescribeInstanceStatusInput) (*DescribeInstanceStatusOutput, error) {
	req, out := c.DescribeInstanceStatusRequest(input)
	err := req.Send()
	return out, err
}

// DescribeInstanceStatusPages iterates over the pages of a DescribeInstanceStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstanceStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeInstanceStatus operation.
//    pageNum := 0
//    err := client.DescribeInstanceStatusPages(params,
//        func(page *DescribeInstanceStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeInstanceStatusPages(input *DescribeInstanceStatusInput, fn func(p *DescribeInstanceStatusOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeInstanceStatusRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeInstanceStatusOutput), lastPage)
	})
}

const opDescribeInstances = "DescribeInstances"

// DescribeInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeInstancesRequest method.
//    req, resp := client.DescribeInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstances
func (c *EC2) DescribeInstancesRequest(input *DescribeInstancesInput) (req *request.Request, output *DescribeInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstancesInput{}
	}

	output = &DescribeInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstances API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your instances.
//
// If you specify one or more instance IDs, Amazon EC2 returns information for
// those instances. If you do not specify instance IDs, Amazon EC2 returns information
// for all relevant instances. If you specify an instance ID that is not valid,
// an error is returned. If you specify an instance that you do not own, it
// is not included in the returned results.
//
// Recently terminated instances might appear in the returned results. This
// interval is usually less than one hour.
//
// If you describe instances in the rare case where an Availability Zone is
// experiencing a service disruption and you specify instance IDs that are in
// the affected zone, or do not specify any instance IDs at all, the call fails.
// If you describe instances and specify only instance IDs that are in an unaffected
// zone, the call works normally.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstances
func (c *EC2) DescribeInstances(input *DescribeInstancesInput) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeInstancesPages iterates over the pages of a DescribeInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeInstances operation.
//    pageNum := 0
//    err := client.DescribeInstancesPages(params,
//        func(page *DescribeInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeInstancesPages(input *DescribeInstancesInput, fn func(p *DescribeInstancesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeInstancesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeInstancesOutput), lastPage)
	})
}

const opDescribeInternetGateways = "DescribeInternetGateways"

// DescribeInternetGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInternetGateways operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeInternetGateways for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeInternetGateways method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeInternetGatewaysRequest method.
//    req, resp := client.DescribeInternetGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGateways
func (c *EC2) DescribeInternetGatewaysRequest(input *DescribeInternetGatewaysInput) (req *request.Request, output *DescribeInternetGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeInternetGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInternetGatewaysInput{}
	}

	output = &DescribeInternetGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInternetGateways API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your Internet gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeInternetGateways for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGateways
func (c *EC2) DescribeInternetGateways(input *DescribeInternetGatewaysInput) (*DescribeInternetGatewaysOutput, error) {
	req, out := c.DescribeInternetGatewaysRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeKeyPairs = "DescribeKeyPairs"

// DescribeKeyPairsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeKeyPairs operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeKeyPairs for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeKeyPairs method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeKeyPairsRequest method.
//    req, resp := client.DescribeKeyPairsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeKeyPairs
func (c *EC2) DescribeKeyPairsRequest(input *DescribeKeyPairsInput) (req *request.Request, output *DescribeKeyPairsOutput) {
	op := &request.Operation{
		Name:       opDescribeKeyPairs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeKeyPairsInput{}
	}

	output = &DescribeKeyPairsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeKeyPairs API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your key pairs.
//
// For more information about key pairs, see Key Pairs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeKeyPairs for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeKeyPairs
func (c *EC2) DescribeKeyPairs(input *DescribeKeyPairsInput) (*DescribeKeyPairsOutput, error) {
	req, out := c.DescribeKeyPairsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeMovingAddresses = "DescribeMovingAddresses"

// DescribeMovingAddressesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMovingAddresses operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeMovingAddresses for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeMovingAddresses method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeMovingAddressesRequest method.
//    req, resp := client.DescribeMovingAddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMovingAddresses
func (c *EC2) DescribeMovingAddressesRequest(input *DescribeMovingAddressesInput) (req *request.Request, output *DescribeMovingAddressesOutput) {
	op := &request.Operation{
		Name:       opDescribeMovingAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMovingAddressesInput{}
	}

	output = &DescribeMovingAddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMovingAddresses API operation for Amazon Elastic Compute Cloud.
//
// Describes your Elastic IP addresses that are being moved to the EC2-VPC platform,
// or that are being restored to the EC2-Classic platform. This request does
// not return information about any other Elastic IP addresses in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeMovingAddresses for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMovingAddresses
func (c *EC2) DescribeMovingAddresses(input *DescribeMovingAddressesInput) (*DescribeMovingAddressesOutput, error) {
	req, out := c.DescribeMovingAddressesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeNatGateways = "DescribeNatGateways"

// DescribeNatGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNatGateways operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeNatGateways for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeNatGateways method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeNatGatewaysRequest method.
//    req, resp := client.DescribeNatGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNatGateways
func (c *EC2) DescribeNatGatewaysRequest(input *DescribeNatGatewaysInput) (req *request.Request, output *DescribeNatGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeNatGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNatGatewaysInput{}
	}

	output = &DescribeNatGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNatGateways API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of the your NAT gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeNatGateways for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNatGateways
func (c *EC2) DescribeNatGateways(input *DescribeNatGatewaysInput) (*DescribeNatGatewaysOutput, error) {
	req, out := c.DescribeNatGatewaysRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeNetworkAcls = "DescribeNetworkAcls"

// DescribeNetworkAclsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNetworkAcls operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeNetworkAcls for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeNetworkAcls method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeNetworkAclsRequest method.
//    req, resp := client.DescribeNetworkAclsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkAcls
func (c *EC2) DescribeNetworkAclsRequest(input *DescribeNetworkAclsInput) (req *request.Request, output *DescribeNetworkAclsOutput) {
	op := &request.Operation{
		Name:       opDescribeNetworkAcls,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNetworkAclsInput{}
	}

	output = &DescribeNetworkAclsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNetworkAcls API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your network ACLs.
//
// For more information about network ACLs, see Network ACLs (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeNetworkAcls for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkAcls
func (c *EC2) DescribeNetworkAcls(input *DescribeNetworkAclsInput) (*DescribeNetworkAclsOutput, error) {
	req, out := c.DescribeNetworkAclsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeNetworkInterfaceAttribute = "DescribeNetworkInterfaceAttribute"

// DescribeNetworkInterfaceAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNetworkInterfaceAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeNetworkInterfaceAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeNetworkInterfaceAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeNetworkInterfaceAttributeRequest method.
//    req, resp := client.DescribeNetworkInterfaceAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaceAttribute
func (c *EC2) DescribeNetworkInterfaceAttributeRequest(input *DescribeNetworkInterfaceAttributeInput) (req *request.Request, output *DescribeNetworkInterfaceAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeNetworkInterfaceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNetworkInterfaceAttributeInput{}
	}

	output = &DescribeNetworkInterfaceAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNetworkInterfaceAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes a network interface attribute. You can specify only one attribute
// at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeNetworkInterfaceAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaceAttribute
func (c *EC2) DescribeNetworkInterfaceAttribute(input *DescribeNetworkInterfaceAttributeInput) (*DescribeNetworkInterfaceAttributeOutput, error) {
	req, out := c.DescribeNetworkInterfaceAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeNetworkInterfaces = "DescribeNetworkInterfaces"

// DescribeNetworkInterfacesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNetworkInterfaces operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeNetworkInterfaces for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeNetworkInterfaces method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeNetworkInterfacesRequest method.
//    req, resp := client.DescribeNetworkInterfacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaces
func (c *EC2) DescribeNetworkInterfacesRequest(input *DescribeNetworkInterfacesInput) (req *request.Request, output *DescribeNetworkInterfacesOutput) {
	op := &request.Operation{
		Name:       opDescribeNetworkInterfaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNetworkInterfacesInput{}
	}

	output = &DescribeNetworkInterfacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNetworkInterfaces API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your network interfaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeNetworkInterfaces for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaces
func (c *EC2) DescribeNetworkInterfaces(input *DescribeNetworkInterfacesInput) (*DescribeNetworkInterfacesOutput, error) {
	req, out := c.DescribeNetworkInterfacesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribePlacementGroups = "DescribePlacementGroups"

// DescribePlacementGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePlacementGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribePlacementGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribePlacementGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribePlacementGroupsRequest method.
//    req, resp := client.DescribePlacementGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePlacementGroups
func (c *EC2) DescribePlacementGroupsRequest(input *DescribePlacementGroupsInput) (req *request.Request, output *DescribePlacementGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribePlacementGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePlacementGroupsInput{}
	}

	output = &DescribePlacementGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePlacementGroups API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your placement groups. For more information about
// placement groups and cluster instances, see Cluster Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cluster_computing.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribePlacementGroups for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePlacementGroups
func (c *EC2) DescribePlacementGroups(input *DescribePlacementGroupsInput) (*DescribePlacementGroupsOutput, error) {
	req, out := c.DescribePlacementGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribePrefixLists = "DescribePrefixLists"

// DescribePrefixListsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePrefixLists operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribePrefixLists for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribePrefixLists method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribePrefixListsRequest method.
//    req, resp := client.DescribePrefixListsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrefixLists
func (c *EC2) DescribePrefixListsRequest(input *DescribePrefixListsInput) (req *request.Request, output *DescribePrefixListsOutput) {
	op := &request.Operation{
		Name:       opDescribePrefixLists,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePrefixListsInput{}
	}

	output = &DescribePrefixListsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePrefixLists API operation for Amazon Elastic Compute Cloud.
//
// Describes available AWS services in a prefix list format, which includes
// the prefix list name and prefix list ID of the service and the IP address
// range for the service. A prefix list ID is required for creating an outbound
// security group rule that allows traffic from a VPC to access an AWS service
// through a VPC endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribePrefixLists for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrefixLists
func (c *EC2) DescribePrefixLists(input *DescribePrefixListsInput) (*DescribePrefixListsOutput, error) {
	req, out := c.DescribePrefixListsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeRegions = "DescribeRegions"

// DescribeRegionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRegions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeRegions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeRegions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeRegionsRequest method.
//    req, resp := client.DescribeRegionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRegions
func (c *EC2) DescribeRegionsRequest(input *DescribeRegionsInput) (req *request.Request, output *DescribeRegionsOutput) {
	op := &request.Operation{
		Name:       opDescribeRegions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRegionsInput{}
	}

	output = &DescribeRegionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRegions API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more regions that are currently available to you.
//
// For a list of the regions supported by Amazon EC2, see Regions and Endpoints
// (http://docs.aws.amazon.com/general/latest/gr/rande.html#ec2_region).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeRegions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRegions
func (c *EC2) DescribeRegions(input *DescribeRegionsInput) (*DescribeRegionsOutput, error) {
	req, out := c.DescribeRegionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeReservedInstances = "DescribeReservedInstances"

// DescribeReservedInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeReservedInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeReservedInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeReservedInstancesRequest method.
//    req, resp := client.DescribeReservedInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstances
func (c *EC2) DescribeReservedInstancesRequest(input *DescribeReservedInstancesInput) (req *request.Request, output *DescribeReservedInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReservedInstancesInput{}
	}

	output = &DescribeReservedInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedInstances API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of the Reserved Instances that you purchased.
//
// For more information about Reserved Instances, see Reserved Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeReservedInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstances
func (c *EC2) DescribeReservedInstances(input *DescribeReservedInstancesInput) (*DescribeReservedInstancesOutput, error) {
	req, out := c.DescribeReservedInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeReservedInstancesListings = "DescribeReservedInstancesListings"

// DescribeReservedInstancesListingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedInstancesListings operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeReservedInstancesListings for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeReservedInstancesListings method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeReservedInstancesListingsRequest method.
//    req, resp := client.DescribeReservedInstancesListingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesListings
func (c *EC2) DescribeReservedInstancesListingsRequest(input *DescribeReservedInstancesListingsInput) (req *request.Request, output *DescribeReservedInstancesListingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstancesListings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReservedInstancesListingsInput{}
	}

	output = &DescribeReservedInstancesListingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedInstancesListings API operation for Amazon Elastic Compute Cloud.
//
// Describes your account's Reserved Instance listings in the Reserved Instance
// Marketplace.
//
// The Reserved Instance Marketplace matches sellers who want to resell Reserved
// Instance capacity that they no longer need with buyers who want to purchase
// additional capacity. Reserved Instances bought and sold through the Reserved
// Instance Marketplace work like any other Reserved Instances.
//
// As a seller, you choose to list some or all of your Reserved Instances, and
// you specify the upfront price to receive for them. Your Reserved Instances
// are then listed in the Reserved Instance Marketplace and are available for
// purchase.
//
// As a buyer, you specify the configuration of the Reserved Instance to purchase,
// and the Marketplace matches what you're searching for with what's available.
// The Marketplace first sells the lowest priced Reserved Instances to you,
// and continues to sell available Reserved Instance listings to you until your
// demand is met. You are charged based on the total price of all of the listings
// that you purchase.
//
// For more information, see Reserved Instance Marketplace (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeReservedInstancesListings for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesListings
func (c *EC2) DescribeReservedInstancesListings(input *DescribeReservedInstancesListingsInput) (*DescribeReservedInstancesListingsOutput, error) {
	req, out := c.DescribeReservedInstancesListingsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeReservedInstancesModifications = "DescribeReservedInstancesModifications"

// DescribeReservedInstancesModificationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedInstancesModifications operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeReservedInstancesModifications for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeReservedInstancesModifications method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeReservedInstancesModificationsRequest method.
//    req, resp := client.DescribeReservedInstancesModificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesModifications
func (c *EC2) DescribeReservedInstancesModificationsRequest(input *DescribeReservedInstancesModificationsInput) (req *request.Request, output *DescribeReservedInstancesModificationsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstancesModifications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedInstancesModificationsInput{}
	}

	output = &DescribeReservedInstancesModificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedInstancesModifications API operation for Amazon Elastic Compute Cloud.
//
// Describes the modifications made to your Reserved Instances. If no parameter
// is specified, information about all your Reserved Instances modification
// requests is returned. If a modification ID is specified, only information
// about the specific modification is returned.
//
// For more information, see Modifying Reserved Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeReservedInstancesModifications for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesModifications
func (c *EC2) DescribeReservedInstancesModifications(input *DescribeReservedInstancesModificationsInput) (*DescribeReservedInstancesModificationsOutput, error) {
	req, out := c.DescribeReservedInstancesModificationsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeReservedInstancesModificationsPages iterates over the pages of a DescribeReservedInstancesModifications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedInstancesModifications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedInstancesModifications operation.
//    pageNum := 0
//    err := client.DescribeReservedInstancesModificationsPages(params,
//        func(page *DescribeReservedInstancesModificationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeReservedInstancesModificationsPages(input *DescribeReservedInstancesModificationsInput, fn func(p *DescribeReservedInstancesModificationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeReservedInstancesModificationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeReservedInstancesModificationsOutput), lastPage)
	})
}

const opDescribeReservedInstancesOfferings = "DescribeReservedInstancesOfferings"

// DescribeReservedInstancesOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedInstancesOfferings operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeReservedInstancesOfferings for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeReservedInstancesOfferings method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeReservedInstancesOfferingsRequest method.
//    req, resp := client.DescribeReservedInstancesOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesOfferings
func (c *EC2) DescribeReservedInstancesOfferingsRequest(input *DescribeReservedInstancesOfferingsInput) (req *request.Request, output *DescribeReservedInstancesOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstancesOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedInstancesOfferingsInput{}
	}

	output = &DescribeReservedInstancesOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedInstancesOfferings API operation for Amazon Elastic Compute Cloud.
//
// Describes Reserved Instance offerings that are available for purchase. With
// Reserved Instances, you purchase the right to launch instances for a period
// of time. During that time period, you do not receive insufficient capacity
// errors, and you pay a lower usage rate than the rate charged for On-Demand
// instances for the actual time used.
//
// If you have listed your own Reserved Instances for sale in the Reserved Instance
// Marketplace, they will be excluded from these results. This is to ensure
// that you do not purchase your own Reserved Instances.
//
// For more information, see Reserved Instance Marketplace (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeReservedInstancesOfferings for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesOfferings
func (c *EC2) DescribeReservedInstancesOfferings(input *DescribeReservedInstancesOfferingsInput) (*DescribeReservedInstancesOfferingsOutput, error) {
	req, out := c.DescribeReservedInstancesOfferingsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeReservedInstancesOfferingsPages iterates over the pages of a DescribeReservedInstancesOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedInstancesOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedInstancesOfferings operation.
//    pageNum := 0
//    err := client.DescribeReservedInstancesOfferingsPages(params,
//        func(page *DescribeReservedInstancesOfferingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeReservedInstancesOfferingsPages(input *DescribeReservedInstancesOfferingsInput, fn func(p *DescribeReservedInstancesOfferingsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeReservedInstancesOfferingsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeReservedInstancesOfferingsOutput), lastPage)
	})
}

const opDescribeRouteTables = "DescribeRouteTables"

// DescribeRouteTablesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRouteTables operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeRouteTables for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeRouteTables method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeRouteTablesRequest method.
//    req, resp := client.DescribeRouteTablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRouteTables
func (c *EC2) DescribeRouteTablesRequest(input *DescribeRouteTablesInput) (req *request.Request, output *DescribeRouteTablesOutput) {
	op := &request.Operation{
		Name:       opDescribeRouteTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRouteTablesInput{}
	}

	output = &DescribeRouteTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRouteTables API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your route tables.
//
// Each subnet in your VPC must be associated with a route table. If a subnet
// is not explicitly associated with any route table, it is implicitly associated
// with the main route table. This command does not return the subnet ID for
// implicit associations.
//
// For more information about route tables, see Route Tables (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeRouteTables for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRouteTables
func (c *EC2) DescribeRouteTables(input *DescribeRouteTablesInput) (*DescribeRouteTablesOutput, error) {
	req, out := c.DescribeRouteTablesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeScheduledInstanceAvailability = "DescribeScheduledInstanceAvailability"

// DescribeScheduledInstanceAvailabilityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScheduledInstanceAvailability operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeScheduledInstanceAvailability for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeScheduledInstanceAvailability method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeScheduledInstanceAvailabilityRequest method.
//    req, resp := client.DescribeScheduledInstanceAvailabilityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstanceAvailability
func (c *EC2) DescribeScheduledInstanceAvailabilityRequest(input *DescribeScheduledInstanceAvailabilityInput) (req *request.Request, output *DescribeScheduledInstanceAvailabilityOutput) {
	op := &request.Operation{
		Name:       opDescribeScheduledInstanceAvailability,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScheduledInstanceAvailabilityInput{}
	}

	output = &DescribeScheduledInstanceAvailabilityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScheduledInstanceAvailability API operation for Amazon Elastic Compute Cloud.
//
// Finds available schedules that meet the specified criteria.
//
// You can search for an available schedule no more than 3 months in advance.
// You must meet the minimum required duration of 1,200 hours per year. For
// example, the minimum daily schedule is 4 hours, the minimum weekly schedule
// is 24 hours, and the minimum monthly schedule is 100 hours.
//
// After you find a schedule that meets your needs, call PurchaseScheduledInstances
// to purchase Scheduled Instances with that schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeScheduledInstanceAvailability for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstanceAvailability
func (c *EC2) DescribeScheduledInstanceAvailability(input *DescribeScheduledInstanceAvailabilityInput) (*DescribeScheduledInstanceAvailabilityOutput, error) {
	req, out := c.DescribeScheduledInstanceAvailabilityRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeScheduledInstances = "DescribeScheduledInstances"

// DescribeScheduledInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScheduledInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeScheduledInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeScheduledInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeScheduledInstancesRequest method.
//    req, resp := client.DescribeScheduledInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstances
func (c *EC2) DescribeScheduledInstancesRequest(input *DescribeScheduledInstancesInput) (req *request.Request, output *DescribeScheduledInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeScheduledInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScheduledInstancesInput{}
	}

	output = &DescribeScheduledInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScheduledInstances API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your Scheduled Instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeScheduledInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstances
func (c *EC2) DescribeScheduledInstances(input *DescribeScheduledInstancesInput) (*DescribeScheduledInstancesOutput, error) {
	req, out := c.DescribeScheduledInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSecurityGroupReferences = "DescribeSecurityGroupReferences"

// DescribeSecurityGroupReferencesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSecurityGroupReferences operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSecurityGroupReferences for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSecurityGroupReferences method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSecurityGroupReferencesRequest method.
//    req, resp := client.DescribeSecurityGroupReferencesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupReferences
func (c *EC2) DescribeSecurityGroupReferencesRequest(input *DescribeSecurityGroupReferencesInput) (req *request.Request, output *DescribeSecurityGroupReferencesOutput) {
	op := &request.Operation{
		Name:       opDescribeSecurityGroupReferences,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSecurityGroupReferencesInput{}
	}

	output = &DescribeSecurityGroupReferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSecurityGroupReferences API operation for Amazon Elastic Compute Cloud.
//
// [EC2-VPC only] Describes the VPCs on the other side of a VPC peering connection
// that are referencing the security groups you've specified in this request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSecurityGroupReferences for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupReferences
func (c *EC2) DescribeSecurityGroupReferences(input *DescribeSecurityGroupReferencesInput) (*DescribeSecurityGroupReferencesOutput, error) {
	req, out := c.DescribeSecurityGroupReferencesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSecurityGroups = "DescribeSecurityGroups"

// DescribeSecurityGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSecurityGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSecurityGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSecurityGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSecurityGroupsRequest method.
//    req, resp := client.DescribeSecurityGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroups
func (c *EC2) DescribeSecurityGroupsRequest(input *DescribeSecurityGroupsInput) (req *request.Request, output *DescribeSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSecurityGroupsInput{}
	}

	output = &DescribeSecurityGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSecurityGroups API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your security groups.
//
// A security group is for use with instances either in the EC2-Classic platform
// or in a specific VPC. For more information, see Amazon EC2 Security Groups
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
// in the Amazon Elastic Compute Cloud User Guide and Security Groups for Your
// VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSecurityGroups for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroups
func (c *EC2) DescribeSecurityGroups(input *DescribeSecurityGroupsInput) (*DescribeSecurityGroupsOutput, error) {
	req, out := c.DescribeSecurityGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSnapshotAttribute = "DescribeSnapshotAttribute"

// DescribeSnapshotAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSnapshotAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSnapshotAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSnapshotAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSnapshotAttributeRequest method.
//    req, resp := client.DescribeSnapshotAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotAttribute
func (c *EC2) DescribeSnapshotAttributeRequest(input *DescribeSnapshotAttributeInput) (req *request.Request, output *DescribeSnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotAttributeInput{}
	}

	output = &DescribeSnapshotAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSnapshotAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified attribute of the specified snapshot. You can specify
// only one attribute at a time.
//
// For more information about EBS snapshots, see Amazon EBS Snapshots (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSnapshotAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotAttribute
func (c *EC2) DescribeSnapshotAttribute(input *DescribeSnapshotAttributeInput) (*DescribeSnapshotAttributeOutput, error) {
	req, out := c.DescribeSnapshotAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSnapshots = "DescribeSnapshots"

// DescribeSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSnapshots operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSnapshots for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSnapshots method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSnapshotsRequest method.
//    req, resp := client.DescribeSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshots
func (c *EC2) DescribeSnapshotsRequest(input *DescribeSnapshotsInput) (req *request.Request, output *DescribeSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSnapshotsInput{}
	}

	output = &DescribeSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSnapshots API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of the EBS snapshots available to you. Available snapshots
// include public snapshots available for any AWS account to launch, private
// snapshots that you own, and private snapshots owned by another AWS account
// but for which you've been given explicit create volume permissions.
//
// The create volume permissions fall into the following categories:
//
//    * public: The owner of the snapshot granted create volume permissions
//    for the snapshot to the all group. All AWS accounts have create volume
//    permissions for these snapshots.
//
//    * explicit: The owner of the snapshot granted create volume permissions
//    to a specific AWS account.
//
//    * implicit: An AWS account has implicit create volume permissions for
//    all snapshots it owns.
//
// The list of snapshots returned can be modified by specifying snapshot IDs,
// snapshot owners, or AWS accounts with create volume permissions. If no options
// are specified, Amazon EC2 returns all snapshots for which you have create
// volume permissions.
//
// If you specify one or more snapshot IDs, only snapshots that have the specified
// IDs are returned. If you specify an invalid snapshot ID, an error is returned.
// If you specify a snapshot ID for which you do not have access, it is not
// included in the returned results.
//
// If you specify one or more snapshot owners using the OwnerIds option, only
// snapshots from the specified owners and for which you have access are returned.
// The results can include the AWS account IDs of the specified owners, amazon
// for snapshots owned by Amazon, or self for snapshots that you own.
//
// If you specify a list of restorable users, only snapshots with create snapshot
// permissions for those users are returned. You can specify AWS account IDs
// (if you own the snapshots), self for snapshots for which you own or have
// explicit permissions, or all for public snapshots.
//
// If you are describing a long list of snapshots, you can paginate the output
// to make the list more manageable. The MaxResults parameter sets the maximum
// number of results returned in a single page. If the list of results exceeds
// your MaxResults value, then that number of results is returned along with
// a NextToken value that can be passed to a subsequent DescribeSnapshots request
// to retrieve the remaining results.
//
// For more information about EBS snapshots, see Amazon EBS Snapshots (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSnapshots for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshots
func (c *EC2) DescribeSnapshots(input *DescribeSnapshotsInput) (*DescribeSnapshotsOutput, error) {
	req, out := c.DescribeSnapshotsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeSnapshotsPages iterates over the pages of a DescribeSnapshots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSnapshots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeSnapshots operation.
//    pageNum := 0
//    err := client.DescribeSnapshotsPages(params,
//        func(page *DescribeSnapshotsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeSnapshotsPages(input *DescribeSnapshotsInput, fn func(p *DescribeSnapshotsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeSnapshotsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeSnapshotsOutput), lastPage)
	})
}

const opDescribeSpotDatafeedSubscription = "DescribeSpotDatafeedSubscription"

// DescribeSpotDatafeedSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSpotDatafeedSubscription operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSpotDatafeedSubscription for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSpotDatafeedSubscription method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSpotDatafeedSubscriptionRequest method.
//    req, resp := client.DescribeSpotDatafeedSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotDatafeedSubscription
func (c *EC2) DescribeSpotDatafeedSubscriptionRequest(input *DescribeSpotDatafeedSubscriptionInput) (req *request.Request, output *DescribeSpotDatafeedSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotDatafeedSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpotDatafeedSubscriptionInput{}
	}

	output = &DescribeSpotDatafeedSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSpotDatafeedSubscription API operation for Amazon Elastic Compute Cloud.
//
// Describes the data feed for Spot instances. For more information, see Spot
// Instance Data Feed (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSpotDatafeedSubscription for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotDatafeedSubscription
func (c *EC2) DescribeSpotDatafeedSubscription(input *DescribeSpotDatafeedSubscriptionInput) (*DescribeSpotDatafeedSubscriptionOutput, error) {
	req, out := c.DescribeSpotDatafeedSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSpotFleetInstances = "DescribeSpotFleetInstances"

// DescribeSpotFleetInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSpotFleetInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSpotFleetInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSpotFleetInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSpotFleetInstancesRequest method.
//    req, resp := client.DescribeSpotFleetInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetInstances
func (c *EC2) DescribeSpotFleetInstancesRequest(input *DescribeSpotFleetInstancesInput) (req *request.Request, output *DescribeSpotFleetInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotFleetInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpotFleetInstancesInput{}
	}

	output = &DescribeSpotFleetInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSpotFleetInstances API operation for Amazon Elastic Compute Cloud.
//
// Describes the running instances for the specified Spot fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSpotFleetInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetInstances
func (c *EC2) DescribeSpotFleetInstances(input *DescribeSpotFleetInstancesInput) (*DescribeSpotFleetInstancesOutput, error) {
	req, out := c.DescribeSpotFleetInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSpotFleetRequestHistory = "DescribeSpotFleetRequestHistory"

// DescribeSpotFleetRequestHistoryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSpotFleetRequestHistory operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSpotFleetRequestHistory for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSpotFleetRequestHistory method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSpotFleetRequestHistoryRequest method.
//    req, resp := client.DescribeSpotFleetRequestHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequestHistory
func (c *EC2) DescribeSpotFleetRequestHistoryRequest(input *DescribeSpotFleetRequestHistoryInput) (req *request.Request, output *DescribeSpotFleetRequestHistoryOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotFleetRequestHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpotFleetRequestHistoryInput{}
	}

	output = &DescribeSpotFleetRequestHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSpotFleetRequestHistory API operation for Amazon Elastic Compute Cloud.
//
// Describes the events for the specified Spot fleet request during the specified
// time.
//
// Spot fleet events are delayed by up to 30 seconds before they can be described.
// This ensures that you can query by the last evaluated time and not miss a
// recorded event.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSpotFleetRequestHistory for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequestHistory
func (c *EC2) DescribeSpotFleetRequestHistory(input *DescribeSpotFleetRequestHistoryInput) (*DescribeSpotFleetRequestHistoryOutput, error) {
	req, out := c.DescribeSpotFleetRequestHistoryRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSpotFleetRequests = "DescribeSpotFleetRequests"

// DescribeSpotFleetRequestsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSpotFleetRequests operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSpotFleetRequests for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSpotFleetRequests method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSpotFleetRequestsRequest method.
//    req, resp := client.DescribeSpotFleetRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequests
func (c *EC2) DescribeSpotFleetRequestsRequest(input *DescribeSpotFleetRequestsInput) (req *request.Request, output *DescribeSpotFleetRequestsOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotFleetRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSpotFleetRequestsInput{}
	}

	output = &DescribeSpotFleetRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSpotFleetRequests API operation for Amazon Elastic Compute Cloud.
//
// Describes your Spot fleet requests.
//
// Spot fleet requests are deleted 48 hours after they are canceled and their
// instances are terminated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSpotFleetRequests for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequests
func (c *EC2) DescribeSpotFleetRequests(input *DescribeSpotFleetRequestsInput) (*DescribeSpotFleetRequestsOutput, error) {
	req, out := c.DescribeSpotFleetRequestsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeSpotFleetRequestsPages iterates over the pages of a DescribeSpotFleetRequests operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSpotFleetRequests method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeSpotFleetRequests operation.
//    pageNum := 0
//    err := client.DescribeSpotFleetRequestsPages(params,
//        func(page *DescribeSpotFleetRequestsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeSpotFleetRequestsPages(input *DescribeSpotFleetRequestsInput, fn func(p *DescribeSpotFleetRequestsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeSpotFleetRequestsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeSpotFleetRequestsOutput), lastPage)
	})
}

const opDescribeSpotInstanceRequests = "DescribeSpotInstanceRequests"

// DescribeSpotInstanceRequestsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSpotInstanceRequests operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSpotInstanceRequests for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSpotInstanceRequests method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSpotInstanceRequestsRequest method.
//    req, resp := client.DescribeSpotInstanceRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotInstanceRequests
func (c *EC2) DescribeSpotInstanceRequestsRequest(input *DescribeSpotInstanceRequestsInput) (req *request.Request, output *DescribeSpotInstanceRequestsOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotInstanceRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpotInstanceRequestsInput{}
	}

	output = &DescribeSpotInstanceRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSpotInstanceRequests API operation for Amazon Elastic Compute Cloud.
//
// Describes the Spot instance requests that belong to your account. Spot instances
// are instances that Amazon EC2 launches when the bid price that you specify
// exceeds the current Spot price. Amazon EC2 periodically sets the Spot price
// based on available Spot instance capacity and current Spot instance requests.
// For more information, see Spot Instance Requests (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// You can use DescribeSpotInstanceRequests to find a running Spot instance
// by examining the response. If the status of the Spot instance is fulfilled,
// the instance ID appears in the response and contains the identifier of the
// instance. Alternatively, you can use DescribeInstances with a filter to look
// for instances where the instance lifecycle is spot.
//
// Spot instance requests are deleted 4 hours after they are canceled and their
// instances are terminated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSpotInstanceRequests for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotInstanceRequests
func (c *EC2) DescribeSpotInstanceRequests(input *DescribeSpotInstanceRequestsInput) (*DescribeSpotInstanceRequestsOutput, error) {
	req, out := c.DescribeSpotInstanceRequestsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSpotPriceHistory = "DescribeSpotPriceHistory"

// DescribeSpotPriceHistoryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSpotPriceHistory operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSpotPriceHistory for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSpotPriceHistory method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSpotPriceHistoryRequest method.
//    req, resp := client.DescribeSpotPriceHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotPriceHistory
func (c *EC2) DescribeSpotPriceHistoryRequest(input *DescribeSpotPriceHistoryInput) (req *request.Request, output *DescribeSpotPriceHistoryOutput) {
	op := &request.Operation{
		Name:       opDescribeSpotPriceHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSpotPriceHistoryInput{}
	}

	output = &DescribeSpotPriceHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSpotPriceHistory API operation for Amazon Elastic Compute Cloud.
//
// Describes the Spot price history. For more information, see Spot Instance
// Pricing History (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// When you specify a start and end time, this operation returns the prices
// of the instance types within the time range that you specified and the time
// when the price changed. The price is valid within the time period that you
// specified; the response merely indicates the last time that the price changed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSpotPriceHistory for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotPriceHistory
func (c *EC2) DescribeSpotPriceHistory(input *DescribeSpotPriceHistoryInput) (*DescribeSpotPriceHistoryOutput, error) {
	req, out := c.DescribeSpotPriceHistoryRequest(input)
	err := req.Send()
	return out, err
}

// DescribeSpotPriceHistoryPages iterates over the pages of a DescribeSpotPriceHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSpotPriceHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeSpotPriceHistory operation.
//    pageNum := 0
//    err := client.DescribeSpotPriceHistoryPages(params,
//        func(page *DescribeSpotPriceHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeSpotPriceHistoryPages(input *DescribeSpotPriceHistoryInput, fn func(p *DescribeSpotPriceHistoryOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeSpotPriceHistoryRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeSpotPriceHistoryOutput), lastPage)
	})
}

const opDescribeStaleSecurityGroups = "DescribeStaleSecurityGroups"

// DescribeStaleSecurityGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStaleSecurityGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeStaleSecurityGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeStaleSecurityGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeStaleSecurityGroupsRequest method.
//    req, resp := client.DescribeStaleSecurityGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeStaleSecurityGroups
func (c *EC2) DescribeStaleSecurityGroupsRequest(input *DescribeStaleSecurityGroupsInput) (req *request.Request, output *DescribeStaleSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeStaleSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStaleSecurityGroupsInput{}
	}

	output = &DescribeStaleSecurityGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStaleSecurityGroups API operation for Amazon Elastic Compute Cloud.
//
// [EC2-VPC only] Describes the stale security group rules for security groups
// in a specified VPC. Rules are stale when they reference a deleted security
// group in a peer VPC, or a security group in a peer VPC for which the VPC
// peering connection has been deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeStaleSecurityGroups for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeStaleSecurityGroups
func (c *EC2) DescribeStaleSecurityGroups(input *DescribeStaleSecurityGroupsInput) (*DescribeStaleSecurityGroupsOutput, error) {
	req, out := c.DescribeStaleSecurityGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSubnets = "DescribeSubnets"

// DescribeSubnetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSubnets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSubnets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSubnets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSubnetsRequest method.
//    req, resp := client.DescribeSubnetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSubnets
func (c *EC2) DescribeSubnetsRequest(input *DescribeSubnetsInput) (req *request.Request, output *DescribeSubnetsOutput) {
	op := &request.Operation{
		Name:       opDescribeSubnets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSubnetsInput{}
	}

	output = &DescribeSubnetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSubnets API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your subnets.
//
// For more information about subnets, see Your VPC and Subnets (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeSubnets for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSubnets
func (c *EC2) DescribeSubnets(input *DescribeSubnetsInput) (*DescribeSubnetsOutput, error) {
	req, out := c.DescribeSubnetsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTags
func (c *EC2) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of the tags for your EC2 resources.
//
// For more information about tags, see Tagging Your Resources (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeTags for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTags
func (c *EC2) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeTagsPages iterates over the pages of a DescribeTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTags operation.
//    pageNum := 0
//    err := client.DescribeTagsPages(params,
//        func(page *DescribeTagsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeTagsPages(input *DescribeTagsInput, fn func(p *DescribeTagsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeTagsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeTagsOutput), lastPage)
	})
}

const opDescribeVolumeAttribute = "DescribeVolumeAttribute"

// DescribeVolumeAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVolumeAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVolumeAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVolumeAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVolumeAttributeRequest method.
//    req, resp := client.DescribeVolumeAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeAttribute
func (c *EC2) DescribeVolumeAttributeRequest(input *DescribeVolumeAttributeInput) (req *request.Request, output *DescribeVolumeAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeVolumeAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVolumeAttributeInput{}
	}

	output = &DescribeVolumeAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVolumeAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified attribute of the specified volume. You can specify
// only one attribute at a time.
//
// For more information about EBS volumes, see Amazon EBS Volumes (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeVolumeAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeAttribute
func (c *EC2) DescribeVolumeAttribute(input *DescribeVolumeAttributeInput) (*DescribeVolumeAttributeOutput, error) {
	req, out := c.DescribeVolumeAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVolumeStatus = "DescribeVolumeStatus"

// DescribeVolumeStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVolumeStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVolumeStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVolumeStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVolumeStatusRequest method.
//    req, resp := client.DescribeVolumeStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeStatus
func (c *EC2) DescribeVolumeStatusRequest(input *DescribeVolumeStatusInput) (req *request.Request, output *DescribeVolumeStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeVolumeStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeVolumeStatusInput{}
	}

	output = &DescribeVolumeStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVolumeStatus API operation for Amazon Elastic Compute Cloud.
//
// Describes the status of the specified volumes. Volume status provides the
// result of the checks performed on your volumes to determine events that can
// impair the performance of your volumes. The performance of a volume can be
// affected if an issue occurs on the volume's underlying host. If the volume's
// underlying host experiences a power outage or system issue, after the system
// is restored, there could be data inconsistencies on the volume. Volume events
// notify you if this occurs. Volume actions notify you if any action needs
// to be taken in response to the event.
//
// The DescribeVolumeStatus operation provides the following information about
// the specified volumes:
//
// Status: Reflects the current status of the volume. The possible values are
// ok, impaired , warning, or insufficient-data. If all checks pass, the overall
// status of the volume is ok. If the check fails, the overall status is impaired.
// If the status is insufficient-data, then the checks may still be taking place
// on your volume at the time. We recommend that you retry the request. For
// more information on volume status, see Monitoring the Status of Your Volumes
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-status.html).
//
// Events: Reflect the cause of a volume status and may require you to take
// action. For example, if your volume returns an impaired status, then the
// volume event might be potential-data-inconsistency. This means that your
// volume has been affected by an issue with the underlying host, has all I/O
// operations disabled, and may have inconsistent data.
//
// Actions: Reflect the actions you may have to take in response to an event.
// For example, if the status of the volume is impaired and the volume event
// shows potential-data-inconsistency, then the action shows enable-volume-io.
// This means that you may want to enable the I/O operations for the volume
// by calling the EnableVolumeIO action and then check the volume for data consistency.
//
// Volume status is based on the volume status checks, and does not reflect
// the volume state. Therefore, volume status does not indicate volumes in the
// error state (for example, when a volume is incapable of accepting I/O.)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeVolumeStatus for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeStatus
func (c *EC2) DescribeVolumeStatus(input *DescribeVolumeStatusInput) (*DescribeVolumeStatusOutput, error) {
	req, out := c.DescribeVolumeStatusRequest(input)
	err := req.Send()
	return out, err
}

// DescribeVolumeStatusPages iterates over the pages of a DescribeVolumeStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeVolumeStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeVolumeStatus operation.
//    pageNum := 0
//    err := client.DescribeVolumeStatusPages(params,
//        func(page *DescribeVolumeStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeVolumeStatusPages(input *DescribeVolumeStatusInput, fn func(p *DescribeVolumeStatusOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeVolumeStatusRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeVolumeStatusOutput), lastPage)
	})
}

const opDescribeVolumes = "DescribeVolumes"

// DescribeVolumesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVolumes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVolumes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVolumes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVolumesRequest method.
//    req, resp := client.DescribeVolumesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumes
func (c *EC2) DescribeVolumesRequest(input *DescribeVolumesInput) (req *request.Request, output *DescribeVolumesOutput) {
	op := &request.Operation{
		Name:       opDescribeVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeVolumesInput{}
	}

	output = &DescribeVolumesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVolumes API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified EBS volumes.
//
// If you are describing a long list of volumes, you can paginate the output
// to make the list more manageable. The MaxResults parameter sets the maximum
// number of results returned in a single page. If the list of results exceeds
// your MaxResults value, then that number of results is returned along with
// a NextToken value that can be passed to a subsequent DescribeVolumes request
// to retrieve the remaining results.
//
// For more information about EBS volumes, see Amazon EBS Volumes (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeVolumes for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumes
func (c *EC2) DescribeVolumes(input *DescribeVolumesInput) (*DescribeVolumesOutput, error) {
	req, out := c.DescribeVolumesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeVolumesPages iterates over the pages of a DescribeVolumes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeVolumes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeVolumes operation.
//    pageNum := 0
//    err := client.DescribeVolumesPages(params,
//        func(page *DescribeVolumesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EC2) DescribeVolumesPages(input *DescribeVolumesInput, fn func(p *DescribeVolumesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeVolumesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeVolumesOutput), lastPage)
	})
}

const opDescribeVpcAttribute = "DescribeVpcAttribute"

// DescribeVpcAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpcAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVpcAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVpcAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVpcAttributeRequest method.
//    req, resp := client.DescribeVpcAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcAttribute
func (c *EC2) DescribeVpcAttributeRequest(input *DescribeVpcAttributeInput) (req *request.Request, output *DescribeVpcAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcAttributeInput{}
	}

	output = &DescribeVpcAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpcAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified attribute of the specified VPC. You can specify only
// one attribute at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeVpcAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcAttribute
func (c *EC2) DescribeVpcAttribute(input *DescribeVpcAttributeInput) (*DescribeVpcAttributeOutput, error) {
	req, out := c.DescribeVpcAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpcClassicLink = "DescribeVpcClassicLink"

// DescribeVpcClassicLinkRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpcClassicLink operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVpcClassicLink for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVpcClassicLink method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVpcClassicLinkRequest method.
//    req, resp := client.DescribeVpcClassicLinkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLink
func (c *EC2) DescribeVpcClassicLinkRequest(input *DescribeVpcClassicLinkInput) (req *request.Request, output *DescribeVpcClassicLinkOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcClassicLink,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcClassicLinkInput{}
	}

	output = &DescribeVpcClassicLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpcClassicLink API operation for Amazon Elastic Compute Cloud.
//
// Describes the ClassicLink status of one or more VPCs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeVpcClassicLink for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLink
func (c *EC2) DescribeVpcClassicLink(input *DescribeVpcClassicLinkInput) (*DescribeVpcClassicLinkOutput, error) {
	req, out := c.DescribeVpcClassicLinkRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpcClassicLinkDnsSupport = "DescribeVpcClassicLinkDnsSupport"

// DescribeVpcClassicLinkDnsSupportRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpcClassicLinkDnsSupport operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVpcClassicLinkDnsSupport for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVpcClassicLinkDnsSupport method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVpcClassicLinkDnsSupportRequest method.
//    req, resp := client.DescribeVpcClassicLinkDnsSupportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLinkDnsSupport
func (c *EC2) DescribeVpcClassicLinkDnsSupportRequest(input *DescribeVpcClassicLinkDnsSupportInput) (req *request.Request, output *DescribeVpcClassicLinkDnsSupportOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcClassicLinkDnsSupport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcClassicLinkDnsSupportInput{}
	}

	output = &DescribeVpcClassicLinkDnsSupportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpcClassicLinkDnsSupport API operation for Amazon Elastic Compute Cloud.
//
// Describes the ClassicLink DNS support status of one or more VPCs. If enabled,
// the DNS hostname of a linked EC2-Classic instance resolves to its private
// IP address when addressed from an instance in the VPC to which it's linked.
// Similarly, the DNS hostname of an instance in a VPC resolves to its private
// IP address when addressed from a linked EC2-Classic instance. For more information
// about ClassicLink, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeVpcClassicLinkDnsSupport for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLinkDnsSupport
func (c *EC2) DescribeVpcClassicLinkDnsSupport(input *DescribeVpcClassicLinkDnsSupportInput) (*DescribeVpcClassicLinkDnsSupportOutput, error) {
	req, out := c.DescribeVpcClassicLinkDnsSupportRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpcEndpointServices = "DescribeVpcEndpointServices"

// DescribeVpcEndpointServicesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpcEndpointServices operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVpcEndpointServices for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVpcEndpointServices method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVpcEndpointServicesRequest method.
//    req, resp := client.DescribeVpcEndpointServicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServices
func (c *EC2) DescribeVpcEndpointServicesRequest(input *DescribeVpcEndpointServicesInput) (req *request.Request, output *DescribeVpcEndpointServicesOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcEndpointServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcEndpointServicesInput{}
	}

	output = &DescribeVpcEndpointServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpcEndpointServices API operation for Amazon Elastic Compute Cloud.
//
// Describes all supported AWS services that can be specified when creating
// a VPC endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeVpcEndpointServices for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServices
func (c *EC2) DescribeVpcEndpointServices(input *DescribeVpcEndpointServicesInput) (*DescribeVpcEndpointServicesOutput, error) {
	req, out := c.DescribeVpcEndpointServicesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpcEndpoints = "DescribeVpcEndpoints"

// DescribeVpcEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpcEndpoints operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVpcEndpoints for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVpcEndpoints method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVpcEndpointsRequest method.
//    req, resp := client.DescribeVpcEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpoints
func (c *EC2) DescribeVpcEndpointsRequest(input *DescribeVpcEndpointsInput) (req *request.Request, output *DescribeVpcEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcEndpointsInput{}
	}

	output = &DescribeVpcEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpcEndpoints API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your VPC endpoints.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeVpcEndpoints for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpoints
func (c *EC2) DescribeVpcEndpoints(input *DescribeVpcEndpointsInput) (*DescribeVpcEndpointsOutput, error) {
	req, out := c.DescribeVpcEndpointsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpcPeeringConnections = "DescribeVpcPeeringConnections"

// DescribeVpcPeeringConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpcPeeringConnections operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVpcPeeringConnections for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVpcPeeringConnections method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVpcPeeringConnectionsRequest method.
//    req, resp := client.DescribeVpcPeeringConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcPeeringConnections
func (c *EC2) DescribeVpcPeeringConnectionsRequest(input *DescribeVpcPeeringConnectionsInput) (req *request.Request, output *DescribeVpcPeeringConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcPeeringConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcPeeringConnectionsInput{}
	}

	output = &DescribeVpcPeeringConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpcPeeringConnections API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your VPC peering connections.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeVpcPeeringConnections for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcPeeringConnections
func (c *EC2) DescribeVpcPeeringConnections(input *DescribeVpcPeeringConnectionsInput) (*DescribeVpcPeeringConnectionsOutput, error) {
	req, out := c.DescribeVpcPeeringConnectionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpcs = "DescribeVpcs"

// DescribeVpcsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpcs operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVpcs for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVpcs method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVpcsRequest method.
//    req, resp := client.DescribeVpcsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcs
func (c *EC2) DescribeVpcsRequest(input *DescribeVpcsInput) (req *request.Request, output *DescribeVpcsOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcsInput{}
	}

	output = &DescribeVpcsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpcs API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your VPCs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeVpcs for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcs
func (c *EC2) DescribeVpcs(input *DescribeVpcsInput) (*DescribeVpcsOutput, error) {
	req, out := c.DescribeVpcsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpnConnections = "DescribeVpnConnections"

// DescribeVpnConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpnConnections operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVpnConnections for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVpnConnections method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVpnConnectionsRequest method.
//    req, resp := client.DescribeVpnConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnConnections
func (c *EC2) DescribeVpnConnectionsRequest(input *DescribeVpnConnectionsInput) (req *request.Request, output *DescribeVpnConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeVpnConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpnConnectionsInput{}
	}

	output = &DescribeVpnConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpnConnections API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your VPN connections.
//
// For more information about VPN connections, see Adding a Hardware Virtual
// Private Gateway to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeVpnConnections for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnConnections
func (c *EC2) DescribeVpnConnections(input *DescribeVpnConnectionsInput) (*DescribeVpnConnectionsOutput, error) {
	req, out := c.DescribeVpnConnectionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVpnGateways = "DescribeVpnGateways"

// DescribeVpnGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpnGateways operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVpnGateways for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVpnGateways method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVpnGatewaysRequest method.
//    req, resp := client.DescribeVpnGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnGateways
func (c *EC2) DescribeVpnGatewaysRequest(input *DescribeVpnGatewaysInput) (req *request.Request, output *DescribeVpnGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeVpnGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpnGatewaysInput{}
	}

	output = &DescribeVpnGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpnGateways API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your virtual private gateways.
//
// For more information about virtual private gateways, see Adding an IPsec
// Hardware VPN to Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeVpnGateways for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnGateways
func (c *EC2) DescribeVpnGateways(input *DescribeVpnGatewaysInput) (*DescribeVpnGatewaysOutput, error) {
	req, out := c.DescribeVpnGatewaysRequest(input)
	err := req.Send()
	return out, err
}

const opDetachClassicLinkVpc = "DetachClassicLinkVpc"

// DetachClassicLinkVpcRequest generates a "aws/request.Request" representing the
// client's request for the DetachClassicLinkVpc operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DetachClassicLinkVpc for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DetachClassicLinkVpc method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DetachClassicLinkVpcRequest method.
//    req, resp := client.DetachClassicLinkVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachClassicLinkVpc
func (c *EC2) DetachClassicLinkVpcRequest(input *DetachClassicLinkVpcInput) (req *request.Request, output *DetachClassicLinkVpcOutput) {
	op := &request.Operation{
		Name:       opDetachClassicLinkVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachClassicLinkVpcInput{}
	}

	output = &DetachClassicLinkVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachClassicLinkVpc API operation for Amazon Elastic Compute Cloud.
//
// Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance
// has been unlinked, the VPC security groups are no longer associated with
// it. An instance is automatically unlinked from a VPC when it's stopped.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DetachClassicLinkVpc for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachClassicLinkVpc
func (c *EC2) DetachClassicLinkVpc(input *DetachClassicLinkVpcInput) (*DetachClassicLinkVpcOutput, error) {
	req, out := c.DetachClassicLinkVpcRequest(input)
	err := req.Send()
	return out, err
}

const opDetachInternetGateway = "DetachInternetGateway"

// DetachInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DetachInternetGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DetachInternetGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DetachInternetGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DetachInternetGatewayRequest method.
//    req, resp := client.DetachInternetGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachInternetGateway
func (c *EC2) DetachInternetGatewayRequest(input *DetachInternetGatewayInput) (req *request.Request, output *DetachInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opDetachInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachInternetGatewayInput{}
	}

	output = &DetachInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// Detaches an Internet gateway from a VPC, disabling connectivity between the
// Internet and the VPC. The VPC must not contain any running instances with
// Elastic IP addresses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DetachInternetGateway for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachInternetGateway
func (c *EC2) DetachInternetGateway(input *DetachInternetGatewayInput) (*DetachInternetGatewayOutput, error) {
	req, out := c.DetachInternetGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDetachNetworkInterface = "DetachNetworkInterface"

// DetachNetworkInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the DetachNetworkInterface operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DetachNetworkInterface for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DetachNetworkInterface method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DetachNetworkInterfaceRequest method.
//    req, resp := client.DetachNetworkInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachNetworkInterface
func (c *EC2) DetachNetworkInterfaceRequest(input *DetachNetworkInterfaceInput) (req *request.Request, output *DetachNetworkInterfaceOutput) {
	op := &request.Operation{
		Name:       opDetachNetworkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachNetworkInterfaceInput{}
	}

	output = &DetachNetworkInterfaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachNetworkInterface API operation for Amazon Elastic Compute Cloud.
//
// Detaches a network interface from an instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DetachNetworkInterface for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachNetworkInterface
func (c *EC2) DetachNetworkInterface(input *DetachNetworkInterfaceInput) (*DetachNetworkInterfaceOutput, error) {
	req, out := c.DetachNetworkInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opDetachVolume = "DetachVolume"

// DetachVolumeRequest generates a "aws/request.Request" representing the
// client's request for the DetachVolume operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DetachVolume for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DetachVolume method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DetachVolumeRequest method.
//    req, resp := client.DetachVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachVolume
func (c *EC2) DetachVolumeRequest(input *DetachVolumeInput) (req *request.Request, output *VolumeAttachment) {
	op := &request.Operation{
		Name:       opDetachVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachVolumeInput{}
	}

	output = &VolumeAttachment{}
	req = c.newRequest(op, input, output)
	return
}

// DetachVolume API operation for Amazon Elastic Compute Cloud.
//
// Detaches an EBS volume from an instance. Make sure to unmount any file systems
// on the device within your operating system before detaching the volume. Failure
// to do so can result in the volume becoming stuck in the busy state while
// detaching. If this happens, detachment can be delayed indefinitely until
// you unmount the volume, force detachment, reboot the instance, or all three.
// If an EBS volume is the root device of an instance, it can't be detached
// while the instance is running. To detach the root volume, stop the instance
// first.
//
// When a volume with an AWS Marketplace product code is detached from an instance,
// the product code is no longer associated with the instance.
//
// For more information, see Detaching an Amazon EBS Volume (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-detaching-volume.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DetachVolume for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachVolume
func (c *EC2) DetachVolume(input *DetachVolumeInput) (*VolumeAttachment, error) {
	req, out := c.DetachVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opDetachVpnGateway = "DetachVpnGateway"

// DetachVpnGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DetachVpnGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DetachVpnGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DetachVpnGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DetachVpnGatewayRequest method.
//    req, resp := client.DetachVpnGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachVpnGateway
func (c *EC2) DetachVpnGatewayRequest(input *DetachVpnGatewayInput) (req *request.Request, output *DetachVpnGatewayOutput) {
	op := &request.Operation{
		Name:       opDetachVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachVpnGatewayInput{}
	}

	output = &DetachVpnGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachVpnGateway API operation for Amazon Elastic Compute Cloud.
//
// Detaches a virtual private gateway from a VPC. You do this if you're planning
// to turn off the VPC and not use it anymore. You can confirm a virtual private
// gateway has been completely detached from a VPC by describing the virtual
// private gateway (any attachments to the virtual private gateway are also
// described).
//
// You must wait for the attachment's state to switch to detached before you
// can delete the VPC or attach a different VPC to the virtual private gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DetachVpnGateway for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachVpnGateway
func (c *EC2) DetachVpnGateway(input *DetachVpnGatewayInput) (*DetachVpnGatewayOutput, error) {
	req, out := c.DetachVpnGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDisableVgwRoutePropagation = "DisableVgwRoutePropagation"

// DisableVgwRoutePropagationRequest generates a "aws/request.Request" representing the
// client's request for the DisableVgwRoutePropagation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableVgwRoutePropagation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableVgwRoutePropagation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableVgwRoutePropagationRequest method.
//    req, resp := client.DisableVgwRoutePropagationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVgwRoutePropagation
func (c *EC2) DisableVgwRoutePropagationRequest(input *DisableVgwRoutePropagationInput) (req *request.Request, output *DisableVgwRoutePropagationOutput) {
	op := &request.Operation{
		Name:       opDisableVgwRoutePropagation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableVgwRoutePropagationInput{}
	}

	output = &DisableVgwRoutePropagationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableVgwRoutePropagation API operation for Amazon Elastic Compute Cloud.
//
// Disables a virtual private gateway (VGW) from propagating routes to a specified
// route table of a VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DisableVgwRoutePropagation for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVgwRoutePropagation
func (c *EC2) DisableVgwRoutePropagation(input *DisableVgwRoutePropagationInput) (*DisableVgwRoutePropagationOutput, error) {
	req, out := c.DisableVgwRoutePropagationRequest(input)
	err := req.Send()
	return out, err
}

const opDisableVpcClassicLink = "DisableVpcClassicLink"

// DisableVpcClassicLinkRequest generates a "aws/request.Request" representing the
// client's request for the DisableVpcClassicLink operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableVpcClassicLink for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableVpcClassicLink method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableVpcClassicLinkRequest method.
//    req, resp := client.DisableVpcClassicLinkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVpcClassicLink
func (c *EC2) DisableVpcClassicLinkRequest(input *DisableVpcClassicLinkInput) (req *request.Request, output *DisableVpcClassicLinkOutput) {
	op := &request.Operation{
		Name:       opDisableVpcClassicLink,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableVpcClassicLinkInput{}
	}

	output = &DisableVpcClassicLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableVpcClassicLink API operation for Amazon Elastic Compute Cloud.
//
// Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC
// that has EC2-Classic instances linked to it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DisableVpcClassicLink for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVpcClassicLink
func (c *EC2) DisableVpcClassicLink(input *DisableVpcClassicLinkInput) (*DisableVpcClassicLinkOutput, error) {
	req, out := c.DisableVpcClassicLinkRequest(input)
	err := req.Send()
	return out, err
}

const opDisableVpcClassicLinkDnsSupport = "DisableVpcClassicLinkDnsSupport"

// DisableVpcClassicLinkDnsSupportRequest generates a "aws/request.Request" representing the
// client's request for the DisableVpcClassicLinkDnsSupport operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableVpcClassicLinkDnsSupport for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableVpcClassicLinkDnsSupport method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableVpcClassicLinkDnsSupportRequest method.
//    req, resp := client.DisableVpcClassicLinkDnsSupportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVpcClassicLinkDnsSupport
func (c *EC2) DisableVpcClassicLinkDnsSupportRequest(input *DisableVpcClassicLinkDnsSupportInput) (req *request.Request, output *DisableVpcClassicLinkDnsSupportOutput) {
	op := &request.Operation{
		Name:       opDisableVpcClassicLinkDnsSupport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableVpcClassicLinkDnsSupportInput{}
	}

	output = &DisableVpcClassicLinkDnsSupportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableVpcClassicLinkDnsSupport API operation for Amazon Elastic Compute Cloud.
//
// Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames resolve
// to public IP addresses when addressed between a linked EC2-Classic instance
// and instances in the VPC to which it's linked. For more information about
// ClassicLink, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DisableVpcClassicLinkDnsSupport for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVpcClassicLinkDnsSupport
func (c *EC2) DisableVpcClassicLinkDnsSupport(input *DisableVpcClassicLinkDnsSupportInput) (*DisableVpcClassicLinkDnsSupportOutput, error) {
	req, out := c.DisableVpcClassicLinkDnsSupportRequest(input)
	err := req.Send()
	return out, err
}

const opDisassociateAddress = "DisassociateAddress"

// DisassociateAddressRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateAddress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisassociateAddress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisassociateAddress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisassociateAddressRequest method.
//    req, resp := client.DisassociateAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateAddress
func (c *EC2) DisassociateAddressRequest(input *DisassociateAddressInput) (req *request.Request, output *DisassociateAddressOutput) {
	op := &request.Operation{
		Name:       opDisassociateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateAddressInput{}
	}

	output = &DisassociateAddressOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateAddress API operation for Amazon Elastic Compute Cloud.
//
// Disassociates an Elastic IP address from the instance or network interface
// it's associated with.
//
// An Elastic IP address is for use in either the EC2-Classic platform or in
// a VPC. For more information, see Elastic IP Addresses (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// This is an idempotent operation. If you perform the operation more than once,
// Amazon EC2 doesn't return an error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DisassociateAddress for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateAddress
func (c *EC2) DisassociateAddress(input *DisassociateAddressInput) (*DisassociateAddressOutput, error) {
	req, out := c.DisassociateAddressRequest(input)
	err := req.Send()
	return out, err
}

const opDisassociateRouteTable = "DisassociateRouteTable"

// DisassociateRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateRouteTable operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisassociateRouteTable for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisassociateRouteTable method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisassociateRouteTableRequest method.
//    req, resp := client.DisassociateRouteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateRouteTable
func (c *EC2) DisassociateRouteTableRequest(input *DisassociateRouteTableInput) (req *request.Request, output *DisassociateRouteTableOutput) {
	op := &request.Operation{
		Name:       opDisassociateRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateRouteTableInput{}
	}

	output = &DisassociateRouteTableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Disassociates a subnet from a route table.
//
// After you perform this action, the subnet no longer uses the routes in the
// route table. Instead, it uses the routes in the VPC's main route table. For
// more information about route tables, see Route Tables (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DisassociateRouteTable for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateRouteTable
func (c *EC2) DisassociateRouteTable(input *DisassociateRouteTableInput) (*DisassociateRouteTableOutput, error) {
	req, out := c.DisassociateRouteTableRequest(input)
	err := req.Send()
	return out, err
}

const opDisassociateSubnetCidrBlock = "DisassociateSubnetCidrBlock"

// DisassociateSubnetCidrBlockRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateSubnetCidrBlock operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisassociateSubnetCidrBlock for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisassociateSubnetCidrBlock method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisassociateSubnetCidrBlockRequest method.
//    req, resp := client.DisassociateSubnetCidrBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateSubnetCidrBlock
func (c *EC2) DisassociateSubnetCidrBlockRequest(input *DisassociateSubnetCidrBlockInput) (req *request.Request, output *DisassociateSubnetCidrBlockOutput) {
	op := &request.Operation{
		Name:       opDisassociateSubnetCidrBlock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateSubnetCidrBlockInput{}
	}

	output = &DisassociateSubnetCidrBlockOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateSubnetCidrBlock API operation for Amazon Elastic Compute Cloud.
//
// Disassociates a CIDR block from a subnet. Currently, you can disassociate
// an IPv6 CIDR block only. You must detach or delete all gateways and resources
// that are associated with the CIDR block before you can disassociate it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DisassociateSubnetCidrBlock for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateSubnetCidrBlock
func (c *EC2) DisassociateSubnetCidrBlock(input *DisassociateSubnetCidrBlockInput) (*DisassociateSubnetCidrBlockOutput, error) {
	req, out := c.DisassociateSubnetCidrBlockRequest(input)
	err := req.Send()
	return out, err
}

const opDisassociateVpcCidrBlock = "DisassociateVpcCidrBlock"

// DisassociateVpcCidrBlockRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateVpcCidrBlock operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisassociateVpcCidrBlock for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisassociateVpcCidrBlock method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisassociateVpcCidrBlockRequest method.
//    req, resp := client.DisassociateVpcCidrBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateVpcCidrBlock
func (c *EC2) DisassociateVpcCidrBlockRequest(input *DisassociateVpcCidrBlockInput) (req *request.Request, output *DisassociateVpcCidrBlockOutput) {
	op := &request.Operation{
		Name:       opDisassociateVpcCidrBlock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateVpcCidrBlockInput{}
	}

	output = &DisassociateVpcCidrBlockOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateVpcCidrBlock API operation for Amazon Elastic Compute Cloud.
//
// Disassociates a CIDR block from a VPC. Currently, you can disassociate an
// IPv6 CIDR block only. You must detach or delete all gateways and resources
// that are associated with the CIDR block before you can disassociate it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DisassociateVpcCidrBlock for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateVpcCidrBlock
func (c *EC2) DisassociateVpcCidrBlock(input *DisassociateVpcCidrBlockInput) (*DisassociateVpcCidrBlockOutput, error) {
	req, out := c.DisassociateVpcCidrBlockRequest(input)
	err := req.Send()
	return out, err
}

const opEnableVgwRoutePropagation = "EnableVgwRoutePropagation"

// EnableVgwRoutePropagationRequest generates a "aws/request.Request" representing the
// client's request for the EnableVgwRoutePropagation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableVgwRoutePropagation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableVgwRoutePropagation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableVgwRoutePropagationRequest method.
//    req, resp := client.EnableVgwRoutePropagationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EnableVgwRoutePropagation
func (c *EC2) EnableVgwRoutePropagationRequest(input *EnableVgwRoutePropagationInput) (req *request.Request, output *EnableVgwRoutePropagationOutput) {
	op := &request.Operation{
		Name:       opEnableVgwRoutePropagation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableVgwRoutePropagationInput{}
	}

	output = &EnableVgwRoutePropagationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableVgwRoutePropagation API operation for Amazon Elastic Compute Cloud.
//
// Enables a virtual private gateway (VGW) to propagate routes to the specified
// route table of a VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation EnableVgwRoutePropagation for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EnableVgwRoutePropagation
func (c *EC2) EnableVgwRoutePropagation(input *EnableVgwRoutePropagationInput) (*EnableVgwRoutePropagationOutput, error) {
	req, out := c.EnableVgwRoutePropagationRequest(input)
	err := req.Send()
	return out, err
}

const opEnableVolumeIO = "EnableVolumeIO"

// EnableVolumeIORequest generates a "aws/request.Request" representing the
// client's request for the EnableVolumeIO operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableVolumeIO for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableVolumeIO method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableVolumeIORequest method.
//    req, resp := client.EnableVolumeIORequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EnableVolumeIO
func (c *EC2) EnableVolumeIORequest(input *EnableVolumeIOInput) (req *request.Request, output *EnableVolumeIOOutput) {
	op := &request.Operation{
		Name:       opEnableVolumeIO,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableVolumeIOInput{}
	}

	output = &EnableVolumeIOOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableVolumeIO API operation for Amazon Elastic Compute Cloud.
//
// Enables I/O operations for a volume that had I/O operations disabled because
// the data on the volume was potentially inconsistent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation EnableVolumeIO for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EnableVolumeIO
func (c *EC2) EnableVolumeIO(input *EnableVolumeIOInput) (*EnableVolumeIOOutput, error) {
	req, out := c.EnableVolumeIORequest(input)
	err := req.Send()
	return out, err
}

const opEnableVpcClassicLink = "EnableVpcClassicLink"

// EnableVpcClassicLinkRequest generates a "aws/request.Request" representing the
// client's request for the EnableVpcClassicLink operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableVpcClassicLink for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableVpcClassicLink method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableVpcClassicLinkRequest method.
//    req, resp := client.EnableVpcClassicLinkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EnableVpcClassicLink
func (c *EC2) EnableVpcClassicLinkRequest(input *EnableVpcClassicLinkInput) (req *request.Request, output *EnableVpcClassicLinkOutput) {
	op := &request.Operation{
		Name:       opEnableVpcClassicLink,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableVpcClassicLinkInput{}
	}

	output = &EnableVpcClassicLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableVpcClassicLink API operation for Amazon Elastic Compute Cloud.
//
// Enables a VPC for ClassicLink. You can then link EC2-Classic instances to
// your ClassicLink-enabled VPC to allow communication over private IP addresses.
// You cannot enable your VPC for ClassicLink if any of your VPC's route tables
// have existing routes for address ranges within the 10.0.0.0/8 IP address
// range, excluding local routes for VPCs in the 10.0.0.0/16 and 10.1.0.0/16
// IP address ranges. For more information, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation EnableVpcClassicLink for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EnableVpcClassicLink
func (c *EC2) EnableVpcClassicLink(input *EnableVpcClassicLinkInput) (*EnableVpcClassicLinkOutput, error) {
	req, out := c.EnableVpcClassicLinkRequest(input)
	err := req.Send()
	return out, err
}

const opEnableVpcClassicLinkDnsSupport = "EnableVpcClassicLinkDnsSupport"

// EnableVpcClassicLinkDnsSupportRequest generates a "aws/request.Request" representing the
// client's request for the EnableVpcClassicLinkDnsSupport operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableVpcClassicLinkDnsSupport for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableVpcClassicLinkDnsSupport method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableVpcClassicLinkDnsSupportRequest method.
//    req, resp := client.EnableVpcClassicLinkDnsSupportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EnableVpcClassicLinkDnsSupport
func (c *EC2) EnableVpcClassicLinkDnsSupportRequest(input *EnableVpcClassicLinkDnsSupportInput) (req *request.Request, output *EnableVpcClassicLinkDnsSupportOutput) {
	op := &request.Operation{
		Name:       opEnableVpcClassicLinkDnsSupport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableVpcClassicLinkDnsSupportInput{}
	}

	output = &EnableVpcClassicLinkDnsSupportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableVpcClassicLinkDnsSupport API operation for Amazon Elastic Compute Cloud.
//
// Enables a VPC to support DNS hostname resolution for ClassicLink. If enabled,
// the DNS hostname of a linked EC2-Classic instance resolves to its private
// IP address when addressed from an instance in the VPC to which it's linked.
// Similarly, the DNS hostname of an instance in a VPC resolves to its private
// IP address when addressed from a linked EC2-Classic instance. For more information
// about ClassicLink, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation EnableVpcClassicLinkDnsSupport for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EnableVpcClassicLinkDnsSupport
func (c *EC2) EnableVpcClassicLinkDnsSupport(input *EnableVpcClassicLinkDnsSupportInput) (*EnableVpcClassicLinkDnsSupportOutput, error) {
	req, out := c.EnableVpcClassicLinkDnsSupportRequest(input)
	err := req.Send()
	return out, err
}

const opGetConsoleOutput = "GetConsoleOutput"

// GetConsoleOutputRequest generates a "aws/request.Request" representing the
// client's request for the GetConsoleOutput operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetConsoleOutput for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetConsoleOutput method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetConsoleOutputRequest method.
//    req, resp := client.GetConsoleOutputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetConsoleOutput
func (c *EC2) GetConsoleOutputRequest(input *GetConsoleOutputInput) (req *request.Request, output *GetConsoleOutputOutput) {
	op := &request.Operation{
		Name:       opGetConsoleOutput,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConsoleOutputInput{}
	}

	output = &GetConsoleOutputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConsoleOutput API operation for Amazon Elastic Compute Cloud.
//
// Gets the console output for the specified instance.
//
// Instances do not have a physical monitor through which you can view their
// console output. They also lack physical controls that allow you to power
// up, reboot, or shut them down. To allow these actions, we provide them through
// the Amazon EC2 API and command line interface.
//
// Instance console output is buffered and posted shortly after instance boot,
// reboot, and termination. Amazon EC2 preserves the most recent 64 KB output
// which is available for at least one hour after the most recent post.
//
// For Linux instances, the instance console output displays the exact console
// output that would normally be displayed on a physical monitor attached to
// a computer. This output is buffered because the instance produces it and
// then posts it to a store where the instance's owner can retrieve it.
//
// For Windows instances, the instance console output includes output from the
// EC2Config service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation GetConsoleOutput for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetConsoleOutput
func (c *EC2) GetConsoleOutput(input *GetConsoleOutputInput) (*GetConsoleOutputOutput, error) {
	req, out := c.GetConsoleOutputRequest(input)
	err := req.Send()
	return out, err
}

const opGetConsoleScreenshot = "GetConsoleScreenshot"

// GetConsoleScreenshotRequest generates a "aws/request.Request" representing the
// client's request for the GetConsoleScreenshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetConsoleScreenshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetConsoleScreenshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetConsoleScreenshotRequest method.
//    req, resp := client.GetConsoleScreenshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetConsoleScreenshot
func (c *EC2) GetConsoleScreenshotRequest(input *GetConsoleScreenshotInput) (req *request.Request, output *GetConsoleScreenshotOutput) {
	op := &request.Operation{
		Name:       opGetConsoleScreenshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConsoleScreenshotInput{}
	}

	output = &GetConsoleScreenshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConsoleScreenshot API operation for Amazon Elastic Compute Cloud.
//
// Retrieve a JPG-format screenshot of a running instance to help with troubleshooting.
//
// The returned content is Base64-encoded.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation GetConsoleScreenshot for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetConsoleScreenshot
func (c *EC2) GetConsoleScreenshot(input *GetConsoleScreenshotInput) (*GetConsoleScreenshotOutput, error) {
	req, out := c.GetConsoleScreenshotRequest(input)
	err := req.Send()
	return out, err
}

const opGetHostReservationPurchasePreview = "GetHostReservationPurchasePreview"

// GetHostReservationPurchasePreviewRequest generates a "aws/request.Request" representing the
// client's request for the GetHostReservationPurchasePreview operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetHostReservationPurchasePreview for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetHostReservationPurchasePreview method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetHostReservationPurchasePreviewRequest method.
//    req, resp := client.GetHostReservationPurchasePreviewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetHostReservationPurchasePreview
func (c *EC2) GetHostReservationPurchasePreviewRequest(input *GetHostReservationPurchasePreviewInput) (req *request.Request, output *GetHostReservationPurchasePreviewOutput) {
	op := &request.Operation{
		Name:       opGetHostReservationPurchasePreview,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetHostReservationPurchasePreviewInput{}
	}

	output = &GetHostReservationPurchasePreviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetHostReservationPurchasePreview API operation for Amazon Elastic Compute Cloud.
//
// Preview a reservation purchase with configurations that match those of your
// Dedicated Host. You must have active Dedicated Hosts in your account before
// you purchase a reservation.
//
// This is a preview of the PurchaseHostReservation action and does not result
// in the offering being purchased.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation GetHostReservationPurchasePreview for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetHostReservationPurchasePreview
func (c *EC2) GetHostReservationPurchasePreview(input *GetHostReservationPurchasePreviewInput) (*GetHostReservationPurchasePreviewOutput, error) {
	req, out := c.GetHostReservationPurchasePreviewRequest(input)
	err := req.Send()
	return out, err
}

const opGetPasswordData = "GetPasswordData"

// GetPasswordDataRequest generates a "aws/request.Request" representing the
// client's request for the GetPasswordData operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetPasswordData for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetPasswordData method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetPasswordDataRequest method.
//    req, resp := client.GetPasswordDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetPasswordData
func (c *EC2) GetPasswordDataRequest(input *GetPasswordDataInput) (req *request.Request, output *GetPasswordDataOutput) {
	op := &request.Operation{
		Name:       opGetPasswordData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPasswordDataInput{}
	}

	output = &GetPasswordDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPasswordData API operation for Amazon Elastic Compute Cloud.
//
// Retrieves the encrypted administrator password for an instance running Windows.
//
// The Windows password is generated at boot if the EC2Config service plugin,
// Ec2SetPassword, is enabled. This usually only happens the first time an AMI
// is launched, and then Ec2SetPassword is automatically disabled. The password
// is not generated for rebundled AMIs unless Ec2SetPassword is enabled before
// bundling.
//
// The password is encrypted using the key pair that you specified when you
// launched the instance. You must provide the corresponding key pair file.
//
// Password generation and encryption takes a few moments. We recommend that
// you wait up to 15 minutes after launching an instance before trying to retrieve
// the generated password.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation GetPasswordData for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetPasswordData
func (c *EC2) GetPasswordData(input *GetPasswordDataInput) (*GetPasswordDataOutput, error) {
	req, out := c.GetPasswordDataRequest(input)
	err := req.Send()
	return out, err
}

const opGetReservedInstancesExchangeQuote = "GetReservedInstancesExchangeQuote"

// GetReservedInstancesExchangeQuoteRequest generates a "aws/request.Request" representing the
// client's request for the GetReservedInstancesExchangeQuote operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetReservedInstancesExchangeQuote for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetReservedInstancesExchangeQuote method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetReservedInstancesExchangeQuoteRequest method.
//    req, resp := client.GetReservedInstancesExchangeQuoteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetReservedInstancesExchangeQuote
func (c *EC2) GetReservedInstancesExchangeQuoteRequest(input *GetReservedInstancesExchangeQuoteInput) (req *request.Request, output *GetReservedInstancesExchangeQuoteOutput) {
	op := &request.Operation{
		Name:       opGetReservedInstancesExchangeQuote,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetReservedInstancesExchangeQuoteInput{}
	}

	output = &GetReservedInstancesExchangeQuoteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReservedInstancesExchangeQuote API operation for Amazon Elastic Compute Cloud.
//
// Returns details about the values and term of your specified Convertible Reserved
// Instances. When a target configuration is specified, it returns information
// about whether the exchange is valid and can be performed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation GetReservedInstancesExchangeQuote for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetReservedInstancesExchangeQuote
func (c *EC2) GetReservedInstancesExchangeQuote(input *GetReservedInstancesExchangeQuoteInput) (*GetReservedInstancesExchangeQuoteOutput, error) {
	req, out := c.GetReservedInstancesExchangeQuoteRequest(input)
	err := req.Send()
	return out, err
}

const opImportImage = "ImportImage"

// ImportImageRequest generates a "aws/request.Request" representing the
// client's request for the ImportImage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ImportImage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ImportImage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ImportImageRequest method.
//    req, resp := client.ImportImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportImage
func (c *EC2) ImportImageRequest(input *ImportImageInput) (req *request.Request, output *ImportImageOutput) {
	op := &request.Operation{
		Name:       opImportImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportImageInput{}
	}

	output = &ImportImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportImage API operation for Amazon Elastic Compute Cloud.
//
// Import single or multi-volume disk images or EBS snapshots into an Amazon
// Machine Image (AMI). For more information, see Importing a VM as an Image
// Using VM Import/Export (http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html)
// in the VM Import/Export User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ImportImage for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportImage
func (c *EC2) ImportImage(input *ImportImageInput) (*ImportImageOutput, error) {
	req, out := c.ImportImageRequest(input)
	err := req.Send()
	return out, err
}

const opImportInstance = "ImportInstance"

// ImportInstanceRequest generates a "aws/request.Request" representing the
// client's request for the ImportInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ImportInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ImportInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ImportInstanceRequest method.
//    req, resp := client.ImportInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportInstance
func (c *EC2) ImportInstanceRequest(input *ImportInstanceInput) (req *request.Request, output *ImportInstanceOutput) {
	op := &request.Operation{
		Name:       opImportInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportInstanceInput{}
	}

	output = &ImportInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportInstance API operation for Amazon Elastic Compute Cloud.
//
// Creates an import instance task using metadata from the specified disk image.
// ImportInstance only supports single-volume VMs. To import multi-volume VMs,
// use ImportImage. For more information, see Importing a Virtual Machine Using
// the Amazon EC2 CLI (http://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html).
//
// For information about the import manifest referenced by this API action,
// see VM Import Manifest (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ImportInstance for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportInstance
func (c *EC2) ImportInstance(input *ImportInstanceInput) (*ImportInstanceOutput, error) {
	req, out := c.ImportInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opImportKeyPair = "ImportKeyPair"

// ImportKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the ImportKeyPair operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ImportKeyPair for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ImportKeyPair method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ImportKeyPairRequest method.
//    req, resp := client.ImportKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportKeyPair
func (c *EC2) ImportKeyPairRequest(input *ImportKeyPairInput) (req *request.Request, output *ImportKeyPairOutput) {
	op := &request.Operation{
		Name:       opImportKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportKeyPairInput{}
	}

	output = &ImportKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportKeyPair API operation for Amazon Elastic Compute Cloud.
//
// Imports the public key from an RSA key pair that you created with a third-party
// tool. Compare this with CreateKeyPair, in which AWS creates the key pair
// and gives the keys to you (AWS keeps a copy of the public key). With ImportKeyPair,
// you create the key pair and give AWS just the public key. The private key
// is never transferred between you and AWS.
//
// For more information about key pairs, see Key Pairs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ImportKeyPair for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportKeyPair
func (c *EC2) ImportKeyPair(input *ImportKeyPairInput) (*ImportKeyPairOutput, error) {
	req, out := c.ImportKeyPairRequest(input)
	err := req.Send()
	return out, err
}

const opImportSnapshot = "ImportSnapshot"

// ImportSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the ImportSnapshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ImportSnapshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ImportSnapshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ImportSnapshotRequest method.
//    req, resp := client.ImportSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportSnapshot
func (c *EC2) ImportSnapshotRequest(input *ImportSnapshotInput) (req *request.Request, output *ImportSnapshotOutput) {
	op := &request.Operation{
		Name:       opImportSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportSnapshotInput{}
	}

	output = &ImportSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportSnapshot API operation for Amazon Elastic Compute Cloud.
//
// Imports a disk into an EBS snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ImportSnapshot for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportSnapshot
func (c *EC2) ImportSnapshot(input *ImportSnapshotInput) (*ImportSnapshotOutput, error) {
	req, out := c.ImportSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opImportVolume = "ImportVolume"

// ImportVolumeRequest generates a "aws/request.Request" representing the
// client's request for the ImportVolume operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ImportVolume for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ImportVolume method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ImportVolumeRequest method.
//    req, resp := client.ImportVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportVolume
func (c *EC2) ImportVolumeRequest(input *ImportVolumeInput) (req *request.Request, output *ImportVolumeOutput) {
	op := &request.Operation{
		Name:       opImportVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportVolumeInput{}
	}

	output = &ImportVolumeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportVolume API operation for Amazon Elastic Compute Cloud.
//
// Creates an import volume task using metadata from the specified disk image.For
// more information, see Importing Disks to Amazon EBS (http://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/importing-your-volumes-into-amazon-ebs.html).
//
// For information about the import manifest referenced by this API action,
// see VM Import Manifest (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ImportVolume for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportVolume
func (c *EC2) ImportVolume(input *ImportVolumeInput) (*ImportVolumeOutput, error) {
	req, out := c.ImportVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyHosts = "ModifyHosts"

// ModifyHostsRequest generates a "aws/request.Request" representing the
// client's request for the ModifyHosts operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyHosts for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyHosts method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyHostsRequest method.
//    req, resp := client.ModifyHostsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyHosts
func (c *EC2) ModifyHostsRequest(input *ModifyHostsInput) (req *request.Request, output *ModifyHostsOutput) {
	op := &request.Operation{
		Name:       opModifyHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyHostsInput{}
	}

	output = &ModifyHostsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyHosts API operation for Amazon Elastic Compute Cloud.
//
// Modify the auto-placement setting of a Dedicated Host. When auto-placement
// is enabled, AWS will place instances that you launch with a tenancy of host,
// but without targeting a specific host ID, onto any available Dedicated Host
// in your account which has auto-placement enabled. When auto-placement is
// disabled, you need to provide a host ID if you want the instance to launch
// onto a specific host. If no host ID is provided, the instance will be launched
// onto a suitable host which has auto-placement enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifyHosts for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyHosts
func (c *EC2) ModifyHosts(input *ModifyHostsInput) (*ModifyHostsOutput, error) {
	req, out := c.ModifyHostsRequest(input)
	err := req.Send()
	return out, err
}

const opModifyIdFormat = "ModifyIdFormat"

// ModifyIdFormatRequest generates a "aws/request.Request" representing the
// client's request for the ModifyIdFormat operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyIdFormat for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyIdFormat method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyIdFormatRequest method.
//    req, resp := client.ModifyIdFormatRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyIdFormat
func (c *EC2) ModifyIdFormatRequest(input *ModifyIdFormatInput) (req *request.Request, output *ModifyIdFormatOutput) {
	op := &request.Operation{
		Name:       opModifyIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyIdFormatInput{}
	}

	output = &ModifyIdFormatOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyIdFormat API operation for Amazon Elastic Compute Cloud.
//
// Modifies the ID format for the specified resource on a per-region basis.
// You can specify that resources should receive longer IDs (17-character IDs)
// when they are created. The following resource types support longer IDs: instance
// | reservation | snapshot | volume.
//
// This setting applies to the IAM user who makes the request; it does not apply
// to the entire AWS account. By default, an IAM user defaults to the same settings
// as the root user. If you're using this action as the root user, then these
// settings apply to the entire account, unless an IAM user explicitly overrides
// these settings for themselves. For more information, see Resource IDs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Resources created with longer IDs are visible to all IAM roles and users,
// regardless of these settings and provided that they have permission to use
// the relevant Describe command for the resource type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifyIdFormat for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyIdFormat
func (c *EC2) ModifyIdFormat(input *ModifyIdFormatInput) (*ModifyIdFormatOutput, error) {
	req, out := c.ModifyIdFormatRequest(input)
	err := req.Send()
	return out, err
}

const opModifyIdentityIdFormat = "ModifyIdentityIdFormat"

// ModifyIdentityIdFormatRequest generates a "aws/request.Request" representing the
// client's request for the ModifyIdentityIdFormat operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyIdentityIdFormat for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyIdentityIdFormat method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyIdentityIdFormatRequest method.
//    req, resp := client.ModifyIdentityIdFormatRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyIdentityIdFormat
func (c *EC2) ModifyIdentityIdFormatRequest(input *ModifyIdentityIdFormatInput) (req *request.Request, output *ModifyIdentityIdFormatOutput) {
	op := &request.Operation{
		Name:       opModifyIdentityIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyIdentityIdFormatInput{}
	}

	output = &ModifyIdentityIdFormatOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyIdentityIdFormat API operation for Amazon Elastic Compute Cloud.
//
// Modifies the ID format of a resource for a specified IAM user, IAM role,
// or the root user for an account; or all IAM users, IAM roles, and the root
// user for an account. You can specify that resources should receive longer
// IDs (17-character IDs) when they are created.
//
// The following resource types support longer IDs: instance | reservation |
// snapshot | volume. For more information, see Resource IDs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// This setting applies to the principal specified in the request; it does not
// apply to the principal that makes the request.
//
// Resources created with longer IDs are visible to all IAM roles and users,
// regardless of these settings and provided that they have permission to use
// the relevant Describe command for the resource type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifyIdentityIdFormat for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyIdentityIdFormat
func (c *EC2) ModifyIdentityIdFormat(input *ModifyIdentityIdFormatInput) (*ModifyIdentityIdFormatOutput, error) {
	req, out := c.ModifyIdentityIdFormatRequest(input)
	err := req.Send()
	return out, err
}

const opModifyImageAttribute = "ModifyImageAttribute"

// ModifyImageAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ModifyImageAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyImageAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyImageAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyImageAttributeRequest method.
//    req, resp := client.ModifyImageAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyImageAttribute
func (c *EC2) ModifyImageAttributeRequest(input *ModifyImageAttributeInput) (req *request.Request, output *ModifyImageAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyImageAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyImageAttributeInput{}
	}

	output = &ModifyImageAttributeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyImageAttribute API operation for Amazon Elastic Compute Cloud.
//
// Modifies the specified attribute of the specified AMI. You can specify only
// one attribute at a time.
//
// AWS Marketplace product codes cannot be modified. Images with an AWS Marketplace
// product code cannot be made public.
//
// The SriovNetSupport enhanced networking attribute cannot be changed using
// this command. Instead, enable SriovNetSupport on an instance and create an
// AMI from the instance. This will result in an image with SriovNetSupport
// enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifyImageAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyImageAttribute
func (c *EC2) ModifyImageAttribute(input *ModifyImageAttributeInput) (*ModifyImageAttributeOutput, error) {
	req, out := c.ModifyImageAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyInstanceAttribute = "ModifyInstanceAttribute"

// ModifyInstanceAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ModifyInstanceAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyInstanceAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyInstanceAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyInstanceAttributeRequest method.
//    req, resp := client.ModifyInstanceAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyInstanceAttribute
func (c *EC2) ModifyInstanceAttributeRequest(input *ModifyInstanceAttributeInput) (req *request.Request, output *ModifyInstanceAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyInstanceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyInstanceAttributeInput{}
	}

	output = &ModifyInstanceAttributeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyInstanceAttribute API operation for Amazon Elastic Compute Cloud.
//
// Modifies the specified attribute of the specified instance. You can specify
// only one attribute at a time.
//
// To modify some attributes, the instance must be stopped. For more information,
// see Modifying Attributes of a Stopped Instance (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingAttributesWhileInstanceStopped.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifyInstanceAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyInstanceAttribute
func (c *EC2) ModifyInstanceAttribute(input *ModifyInstanceAttributeInput) (*ModifyInstanceAttributeOutput, error) {
	req, out := c.ModifyInstanceAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyInstancePlacement = "ModifyInstancePlacement"

// ModifyInstancePlacementRequest generates a "aws/request.Request" representing the
// client's request for the ModifyInstancePlacement operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyInstancePlacement for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyInstancePlacement method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyInstancePlacementRequest method.
//    req, resp := client.ModifyInstancePlacementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyInstancePlacement
func (c *EC2) ModifyInstancePlacementRequest(input *ModifyInstancePlacementInput) (req *request.Request, output *ModifyInstancePlacementOutput) {
	op := &request.Operation{
		Name:       opModifyInstancePlacement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyInstancePlacementInput{}
	}

	output = &ModifyInstancePlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyInstancePlacement API operation for Amazon Elastic Compute Cloud.
//
// Set the instance affinity value for a specific stopped instance and modify
// the instance tenancy setting.
//
// Instance affinity is disabled by default. When instance affinity is host
// and it is not associated with a specific Dedicated Host, the next time it
// is launched it will automatically be associated with the host it lands on.
// This relationship will persist if the instance is stopped/started, or rebooted.
//
// You can modify the host ID associated with a stopped instance. If a stopped
// instance has a new host ID association, the instance will target that host
// when restarted.
//
// You can modify the tenancy of a stopped instance with a tenancy of host or
// dedicated.
//
// Affinity, hostID, and tenancy are not required parameters, but at least one
// of them must be specified in the request. Affinity and tenancy can be modified
// in the same request, but tenancy can only be modified on instances that are
// stopped.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifyInstancePlacement for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyInstancePlacement
func (c *EC2) ModifyInstancePlacement(input *ModifyInstancePlacementInput) (*ModifyInstancePlacementOutput, error) {
	req, out := c.ModifyInstancePlacementRequest(input)
	err := req.Send()
	return out, err
}

const opModifyNetworkInterfaceAttribute = "ModifyNetworkInterfaceAttribute"

// ModifyNetworkInterfaceAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ModifyNetworkInterfaceAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyNetworkInterfaceAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyNetworkInterfaceAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyNetworkInterfaceAttributeRequest method.
//    req, resp := client.ModifyNetworkInterfaceAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyNetworkInterfaceAttribute
func (c *EC2) ModifyNetworkInterfaceAttributeRequest(input *ModifyNetworkInterfaceAttributeInput) (req *request.Request, output *ModifyNetworkInterfaceAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyNetworkInterfaceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyNetworkInterfaceAttributeInput{}
	}

	output = &ModifyNetworkInterfaceAttributeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyNetworkInterfaceAttribute API operation for Amazon Elastic Compute Cloud.
//
// Modifies the specified network interface attribute. You can specify only
// one attribute at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifyNetworkInterfaceAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyNetworkInterfaceAttribute
func (c *EC2) ModifyNetworkInterfaceAttribute(input *ModifyNetworkInterfaceAttributeInput) (*ModifyNetworkInterfaceAttributeOutput, error) {
	req, out := c.ModifyNetworkInterfaceAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyReservedInstances = "ModifyReservedInstances"

// ModifyReservedInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReservedInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyReservedInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyReservedInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyReservedInstancesRequest method.
//    req, resp := client.ModifyReservedInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyReservedInstances
func (c *EC2) ModifyReservedInstancesRequest(input *ModifyReservedInstancesInput) (req *request.Request, output *ModifyReservedInstancesOutput) {
	op := &request.Operation{
		Name:       opModifyReservedInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReservedInstancesInput{}
	}

	output = &ModifyReservedInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyReservedInstances API operation for Amazon Elastic Compute Cloud.
//
// Modifies the Availability Zone, instance count, instance type, or network
// platform (EC2-Classic or EC2-VPC) of your Standard Reserved Instances. The
// Reserved Instances to be modified must be identical, except for Availability
// Zone, network platform, and instance type.
//
// For more information, see Modifying Reserved Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifyReservedInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyReservedInstances
func (c *EC2) ModifyReservedInstances(input *ModifyReservedInstancesInput) (*ModifyReservedInstancesOutput, error) {
	req, out := c.ModifyReservedInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opModifySnapshotAttribute = "ModifySnapshotAttribute"

// ModifySnapshotAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ModifySnapshotAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifySnapshotAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifySnapshotAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifySnapshotAttributeRequest method.
//    req, resp := client.ModifySnapshotAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifySnapshotAttribute
func (c *EC2) ModifySnapshotAttributeRequest(input *ModifySnapshotAttributeInput) (req *request.Request, output *ModifySnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opModifySnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySnapshotAttributeInput{}
	}

	output = &ModifySnapshotAttributeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifySnapshotAttribute API operation for Amazon Elastic Compute Cloud.
//
// Adds or removes permission settings for the specified snapshot. You may add
// or remove specified AWS account IDs from a snapshot's list of create volume
// permissions, but you cannot do both in a single API call. If you need to
// both add and remove account IDs for a snapshot, you must use multiple API
// calls.
//
// Encrypted snapshots and snapshots with AWS Marketplace product codes cannot
// be made public. Snapshots encrypted with your default CMK cannot be shared
// with other accounts.
//
// For more information on modifying snapshot permissions, see Sharing Snapshots
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifySnapshotAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifySnapshotAttribute
func (c *EC2) ModifySnapshotAttribute(input *ModifySnapshotAttributeInput) (*ModifySnapshotAttributeOutput, error) {
	req, out := c.ModifySnapshotAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifySpotFleetRequest = "ModifySpotFleetRequest"

// ModifySpotFleetRequestRequest generates a "aws/request.Request" representing the
// client's request for the ModifySpotFleetRequest operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifySpotFleetRequest for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifySpotFleetRequest method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifySpotFleetRequestRequest method.
//    req, resp := client.ModifySpotFleetRequestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifySpotFleetRequest
func (c *EC2) ModifySpotFleetRequestRequest(input *ModifySpotFleetRequestInput) (req *request.Request, output *ModifySpotFleetRequestOutput) {
	op := &request.Operation{
		Name:       opModifySpotFleetRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySpotFleetRequestInput{}
	}

	output = &ModifySpotFleetRequestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifySpotFleetRequest API operation for Amazon Elastic Compute Cloud.
//
// Modifies the specified Spot fleet request.
//
// While the Spot fleet request is being modified, it is in the modifying state.
//
// To scale up your Spot fleet, increase its target capacity. The Spot fleet
// launches the additional Spot instances according to the allocation strategy
// for the Spot fleet request. If the allocation strategy is lowestPrice, the
// Spot fleet launches instances using the Spot pool with the lowest price.
// If the allocation strategy is diversified, the Spot fleet distributes the
// instances across the Spot pools.
//
// To scale down your Spot fleet, decrease its target capacity. First, the Spot
// fleet cancels any open bids that exceed the new target capacity. You can
// request that the Spot fleet terminate Spot instances until the size of the
// fleet no longer exceeds the new target capacity. If the allocation strategy
// is lowestPrice, the Spot fleet terminates the instances with the highest
// price per unit. If the allocation strategy is diversified, the Spot fleet
// terminates instances across the Spot pools. Alternatively, you can request
// that the Spot fleet keep the fleet at its current size, but not replace any
// Spot instances that are interrupted or that you terminate manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifySpotFleetRequest for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifySpotFleetRequest
func (c *EC2) ModifySpotFleetRequest(input *ModifySpotFleetRequestInput) (*ModifySpotFleetRequestOutput, error) {
	req, out := c.ModifySpotFleetRequestRequest(input)
	err := req.Send()
	return out, err
}

const opModifySubnetAttribute = "ModifySubnetAttribute"

// ModifySubnetAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ModifySubnetAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifySubnetAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifySubnetAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifySubnetAttributeRequest method.
//    req, resp := client.ModifySubnetAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifySubnetAttribute
func (c *EC2) ModifySubnetAttributeRequest(input *ModifySubnetAttributeInput) (req *request.Request, output *ModifySubnetAttributeOutput) {
	op := &request.Operation{
		Name:       opModifySubnetAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySubnetAttributeInput{}
	}

	output = &ModifySubnetAttributeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifySubnetAttribute API operation for Amazon Elastic Compute Cloud.
//
// Modifies a subnet attribute. You can only modify one attribute at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifySubnetAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifySubnetAttribute
func (c *EC2) ModifySubnetAttribute(input *ModifySubnetAttributeInput) (*ModifySubnetAttributeOutput, error) {
	req, out := c.ModifySubnetAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyVolumeAttribute = "ModifyVolumeAttribute"

// ModifyVolumeAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ModifyVolumeAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyVolumeAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyVolumeAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyVolumeAttributeRequest method.
//    req, resp := client.ModifyVolumeAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVolumeAttribute
func (c *EC2) ModifyVolumeAttributeRequest(input *ModifyVolumeAttributeInput) (req *request.Request, output *ModifyVolumeAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyVolumeAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyVolumeAttributeInput{}
	}

	output = &ModifyVolumeAttributeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyVolumeAttribute API operation for Amazon Elastic Compute Cloud.
//
// Modifies a volume attribute.
//
// By default, all I/O operations for the volume are suspended when the data
// on the volume is determined to be potentially inconsistent, to prevent undetectable,
// latent data corruption. The I/O access to the volume can be resumed by first
// enabling I/O access and then checking the data consistency on your volume.
//
// You can change the default behavior to resume I/O operations. We recommend
// that you change this only for boot volumes or for volumes that are stateless
// or disposable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifyVolumeAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVolumeAttribute
func (c *EC2) ModifyVolumeAttribute(input *ModifyVolumeAttributeInput) (*ModifyVolumeAttributeOutput, error) {
	req, out := c.ModifyVolumeAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyVpcAttribute = "ModifyVpcAttribute"

// ModifyVpcAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ModifyVpcAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyVpcAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyVpcAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyVpcAttributeRequest method.
//    req, resp := client.ModifyVpcAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVpcAttribute
func (c *EC2) ModifyVpcAttributeRequest(input *ModifyVpcAttributeInput) (req *request.Request, output *ModifyVpcAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyVpcAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyVpcAttributeInput{}
	}

	output = &ModifyVpcAttributeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyVpcAttribute API operation for Amazon Elastic Compute Cloud.
//
// Modifies the specified attribute of the specified VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifyVpcAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVpcAttribute
func (c *EC2) ModifyVpcAttribute(input *ModifyVpcAttributeInput) (*ModifyVpcAttributeOutput, error) {
	req, out := c.ModifyVpcAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyVpcEndpoint = "ModifyVpcEndpoint"

// ModifyVpcEndpointRequest generates a "aws/request.Request" representing the
// client's request for the ModifyVpcEndpoint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyVpcEndpoint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyVpcEndpoint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyVpcEndpointRequest method.
//    req, resp := client.ModifyVpcEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVpcEndpoint
func (c *EC2) ModifyVpcEndpointRequest(input *ModifyVpcEndpointInput) (req *request.Request, output *ModifyVpcEndpointOutput) {
	op := &request.Operation{
		Name:       opModifyVpcEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyVpcEndpointInput{}
	}

	output = &ModifyVpcEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyVpcEndpoint API operation for Amazon Elastic Compute Cloud.
//
// Modifies attributes of a specified VPC endpoint. You can modify the policy
// associated with the endpoint, and you can add and remove route tables associated
// with the endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifyVpcEndpoint for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVpcEndpoint
func (c *EC2) ModifyVpcEndpoint(input *ModifyVpcEndpointInput) (*ModifyVpcEndpointOutput, error) {
	req, out := c.ModifyVpcEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opModifyVpcPeeringConnectionOptions = "ModifyVpcPeeringConnectionOptions"

// ModifyVpcPeeringConnectionOptionsRequest generates a "aws/request.Request" representing the
// client's request for the ModifyVpcPeeringConnectionOptions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyVpcPeeringConnectionOptions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyVpcPeeringConnectionOptions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyVpcPeeringConnectionOptionsRequest method.
//    req, resp := client.ModifyVpcPeeringConnectionOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVpcPeeringConnectionOptions
func (c *EC2) ModifyVpcPeeringConnectionOptionsRequest(input *ModifyVpcPeeringConnectionOptionsInput) (req *request.Request, output *ModifyVpcPeeringConnectionOptionsOutput) {
	op := &request.Operation{
		Name:       opModifyVpcPeeringConnectionOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyVpcPeeringConnectionOptionsInput{}
	}

	output = &ModifyVpcPeeringConnectionOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyVpcPeeringConnectionOptions API operation for Amazon Elastic Compute Cloud.
//
// Modifies the VPC peering connection options on one side of a VPC peering
// connection. You can do the following:
//
//    * Enable/disable communication over the peering connection between an
//    EC2-Classic instance that's linked to your VPC (using ClassicLink) and
//    instances in the peer VPC.
//
//    * Enable/disable communication over the peering connection between instances
//    in your VPC and an EC2-Classic instance that's linked to the peer VPC.
//
//    * Enable/disable a local VPC to resolve public DNS hostnames to private
//    IP addresses when queried from instances in the peer VPC.
//
// If the peered VPCs are in different accounts, each owner must initiate a
// separate request to modify the peering connection options, depending on whether
// their VPC was the requester or accepter for the VPC peering connection. If
// the peered VPCs are in the same account, you can modify the requester and
// accepter options in the same request. To confirm which VPC is the accepter
// and requester for a VPC peering connection, use the DescribeVpcPeeringConnections
// command.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ModifyVpcPeeringConnectionOptions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVpcPeeringConnectionOptions
func (c *EC2) ModifyVpcPeeringConnectionOptions(input *ModifyVpcPeeringConnectionOptionsInput) (*ModifyVpcPeeringConnectionOptionsOutput, error) {
	req, out := c.ModifyVpcPeeringConnectionOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opMonitorInstances = "MonitorInstances"

// MonitorInstancesRequest generates a "aws/request.Request" representing the
// client's request for the MonitorInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See MonitorInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the MonitorInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the MonitorInstancesRequest method.
//    req, resp := client.MonitorInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/MonitorInstances
func (c *EC2) MonitorInstancesRequest(input *MonitorInstancesInput) (req *request.Request, output *MonitorInstancesOutput) {
	op := &request.Operation{
		Name:       opMonitorInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MonitorInstancesInput{}
	}

	output = &MonitorInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// MonitorInstances API operation for Amazon Elastic Compute Cloud.
//
// Enables detailed monitoring for a running instance. Otherwise, basic monitoring
// is enabled. For more information, see Monitoring Your Instances and Volumes
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// To disable detailed monitoring, see .
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation MonitorInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/MonitorInstances
func (c *EC2) MonitorInstances(input *MonitorInstancesInput) (*MonitorInstancesOutput, error) {
	req, out := c.MonitorInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opMoveAddressToVpc = "MoveAddressToVpc"

// MoveAddressToVpcRequest generates a "aws/request.Request" representing the
// client's request for the MoveAddressToVpc operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See MoveAddressToVpc for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the MoveAddressToVpc method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the MoveAddressToVpcRequest method.
//    req, resp := client.MoveAddressToVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/MoveAddressToVpc
func (c *EC2) MoveAddressToVpcRequest(input *MoveAddressToVpcInput) (req *request.Request, output *MoveAddressToVpcOutput) {
	op := &request.Operation{
		Name:       opMoveAddressToVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MoveAddressToVpcInput{}
	}

	output = &MoveAddressToVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// MoveAddressToVpc API operation for Amazon Elastic Compute Cloud.
//
// Moves an Elastic IP address from the EC2-Classic platform to the EC2-VPC
// platform. The Elastic IP address must be allocated to your account for more
// than 24 hours, and it must not be associated with an instance. After the
// Elastic IP address is moved, it is no longer available for use in the EC2-Classic
// platform, unless you move it back using the RestoreAddressToClassic request.
// You cannot move an Elastic IP address that was originally allocated for use
// in the EC2-VPC platform to the EC2-Classic platform.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation MoveAddressToVpc for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/MoveAddressToVpc
func (c *EC2) MoveAddressToVpc(input *MoveAddressToVpcInput) (*MoveAddressToVpcOutput, error) {
	req, out := c.MoveAddressToVpcRequest(input)
	err := req.Send()
	return out, err
}

const opPurchaseHostReservation = "PurchaseHostReservation"

// PurchaseHostReservationRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseHostReservation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PurchaseHostReservation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PurchaseHostReservation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PurchaseHostReservationRequest method.
//    req, resp := client.PurchaseHostReservationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PurchaseHostReservation
func (c *EC2) PurchaseHostReservationRequest(input *PurchaseHostReservationInput) (req *request.Request, output *PurchaseHostReservationOutput) {
	op := &request.Operation{
		Name:       opPurchaseHostReservation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseHostReservationInput{}
	}

	output = &PurchaseHostReservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseHostReservation API operation for Amazon Elastic Compute Cloud.
//
// Purchase a reservation with configurations that match those of your Dedicated
// Host. You must have active Dedicated Hosts in your account before you purchase
// a reservation. This action results in the specified reservation being purchased
// and charged to your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation PurchaseHostReservation for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PurchaseHostReservation
func (c *EC2) PurchaseHostReservation(input *PurchaseHostReservationInput) (*PurchaseHostReservationOutput, error) {
	req, out := c.PurchaseHostReservationRequest(input)
	err := req.Send()
	return out, err
}

const opPurchaseReservedInstancesOffering = "PurchaseReservedInstancesOffering"

// PurchaseReservedInstancesOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseReservedInstancesOffering operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PurchaseReservedInstancesOffering for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PurchaseReservedInstancesOffering method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PurchaseReservedInstancesOfferingRequest method.
//    req, resp := client.PurchaseReservedInstancesOfferingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PurchaseReservedInstancesOffering
func (c *EC2) PurchaseReservedInstancesOfferingRequest(input *PurchaseReservedInstancesOfferingInput) (req *request.Request, output *PurchaseReservedInstancesOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseReservedInstancesOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseReservedInstancesOfferingInput{}
	}

	output = &PurchaseReservedInstancesOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseReservedInstancesOffering API operation for Amazon Elastic Compute Cloud.
//
// Purchases a Reserved Instance for use with your account. With Reserved Instances,
// you pay a lower hourly rate compared to On-Demand instance pricing.
//
// Use DescribeReservedInstancesOfferings to get a list of Reserved Instance
// offerings that match your specifications. After you've purchased a Reserved
// Instance, you can check for your new Reserved Instance with DescribeReservedInstances.
//
// For more information, see Reserved Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html)
// and Reserved Instance Marketplace (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation PurchaseReservedInstancesOffering for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PurchaseReservedInstancesOffering
func (c *EC2) PurchaseReservedInstancesOffering(input *PurchaseReservedInstancesOfferingInput) (*PurchaseReservedInstancesOfferingOutput, error) {
	req, out := c.PurchaseReservedInstancesOfferingRequest(input)
	err := req.Send()
	return out, err
}

const opPurchaseScheduledInstances = "PurchaseScheduledInstances"

// PurchaseScheduledInstancesRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseScheduledInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PurchaseScheduledInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PurchaseScheduledInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PurchaseScheduledInstancesRequest method.
//    req, resp := client.PurchaseScheduledInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PurchaseScheduledInstances
func (c *EC2) PurchaseScheduledInstancesRequest(input *PurchaseScheduledInstancesInput) (req *request.Request, output *PurchaseScheduledInstancesOutput) {
	op := &request.Operation{
		Name:       opPurchaseScheduledInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseScheduledInstancesInput{}
	}

	output = &PurchaseScheduledInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseScheduledInstances API operation for Amazon Elastic Compute Cloud.
//
// Purchases one or more Scheduled Instances with the specified schedule.
//
// Scheduled Instances enable you to purchase Amazon EC2 compute capacity by
// the hour for a one-year term. Before you can purchase a Scheduled Instance,
// you must call DescribeScheduledInstanceAvailability to check for available
// schedules and obtain a purchase token. After you purchase a Scheduled Instance,
// you must call RunScheduledInstances during each scheduled time period.
//
// After you purchase a Scheduled Instance, you can't cancel, modify, or resell
// your purchase.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation PurchaseScheduledInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PurchaseScheduledInstances
func (c *EC2) PurchaseScheduledInstances(input *PurchaseScheduledInstancesInput) (*PurchaseScheduledInstancesOutput, error) {
	req, out := c.PurchaseScheduledInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opRebootInstances = "RebootInstances"

// RebootInstancesRequest generates a "aws/request.Request" representing the
// client's request for the RebootInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RebootInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RebootInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RebootInstancesRequest method.
//    req, resp := client.RebootInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RebootInstances
func (c *EC2) RebootInstancesRequest(input *RebootInstancesInput) (req *request.Request, output *RebootInstancesOutput) {
	op := &request.Operation{
		Name:       opRebootInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootInstancesInput{}
	}

	output = &RebootInstancesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RebootInstances API operation for Amazon Elastic Compute Cloud.
//
// Requests a reboot of one or more instances. This operation is asynchronous;
// it only queues a request to reboot the specified instances. The operation
// succeeds if the instances are valid and belong to you. Requests to reboot
// terminated instances are ignored.
//
// If an instance does not cleanly shut down within four minutes, Amazon EC2
// performs a hard reboot.
//
// For more information about troubleshooting, see Getting Console Output and
// Rebooting Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation RebootInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RebootInstances
func (c *EC2) RebootInstances(input *RebootInstancesInput) (*RebootInstancesOutput, error) {
	req, out := c.RebootInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterImage = "RegisterImage"

// RegisterImageRequest generates a "aws/request.Request" representing the
// client's request for the RegisterImage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RegisterImage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RegisterImage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RegisterImageRequest method.
//    req, resp := client.RegisterImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RegisterImage
func (c *EC2) RegisterImageRequest(input *RegisterImageInput) (req *request.Request, output *RegisterImageOutput) {
	op := &request.Operation{
		Name:       opRegisterImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterImageInput{}
	}

	output = &RegisterImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterImage API operation for Amazon Elastic Compute Cloud.
//
// Registers an AMI. When you're creating an AMI, this is the final step you
// must complete before you can launch an instance from the AMI. For more information
// about creating AMIs, see Creating Your Own AMIs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For Amazon EBS-backed instances, CreateImage creates and registers the AMI
// in a single request, so you don't have to register the AMI yourself.
//
// You can also use RegisterImage to create an Amazon EBS-backed Linux AMI from
// a snapshot of a root device volume. For more information, see Launching an
// Instance from a Snapshot (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_LaunchingInstanceFromSnapshot.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Some Linux distributions, such as Red Hat Enterprise Linux (RHEL) and SUSE
// Linux Enterprise Server (SLES), use the EC2 billingProduct code associated
// with an AMI to verify subscription status for package updates. Creating an
// AMI from an EBS snapshot does not maintain this billing code, and subsequent
// instances launched from such an AMI will not be able to connect to package
// update infrastructure.
//
// Similarly, although you can create a Windows AMI from a snapshot, you can't
// successfully launch an instance from the AMI.
//
// To create Windows AMIs or to create AMIs for Linux operating systems that
// must retain AMI billing codes to work properly, see CreateImage.
//
// If needed, you can deregister an AMI at any time. Any modifications you make
// to an AMI backed by an instance store volume invalidates its registration.
// If you make changes to an image, deregister the previous image and register
// the new image.
//
// You can't register an image where a secondary (non-root) snapshot has AWS
// Marketplace product codes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation RegisterImage for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RegisterImage
func (c *EC2) RegisterImage(input *RegisterImageInput) (*RegisterImageOutput, error) {
	req, out := c.RegisterImageRequest(input)
	err := req.Send()
	return out, err
}

const opRejectVpcPeeringConnection = "RejectVpcPeeringConnection"

// RejectVpcPeeringConnectionRequest generates a "aws/request.Request" representing the
// client's request for the RejectVpcPeeringConnection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RejectVpcPeeringConnection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RejectVpcPeeringConnection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RejectVpcPeeringConnectionRequest method.
//    req, resp := client.RejectVpcPeeringConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RejectVpcPeeringConnection
func (c *EC2) RejectVpcPeeringConnectionRequest(input *RejectVpcPeeringConnectionInput) (req *request.Request, output *RejectVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opRejectVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectVpcPeeringConnectionInput{}
	}

	output = &RejectVpcPeeringConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RejectVpcPeeringConnection API operation for Amazon Elastic Compute Cloud.
//
// Rejects a VPC peering connection request. The VPC peering connection must
// be in the pending-acceptance state. Use the DescribeVpcPeeringConnections
// request to view your outstanding VPC peering connection requests. To delete
// an active VPC peering connection, or to delete a VPC peering connection request
// that you initiated, use DeleteVpcPeeringConnection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation RejectVpcPeeringConnection for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RejectVpcPeeringConnection
func (c *EC2) RejectVpcPeeringConnection(input *RejectVpcPeeringConnectionInput) (*RejectVpcPeeringConnectionOutput, error) {
	req, out := c.RejectVpcPeeringConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opReleaseAddress = "ReleaseAddress"

// ReleaseAddressRequest generates a "aws/request.Request" representing the
// client's request for the ReleaseAddress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReleaseAddress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReleaseAddress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReleaseAddressRequest method.
//    req, resp := client.ReleaseAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReleaseAddress
func (c *EC2) ReleaseAddressRequest(input *ReleaseAddressInput) (req *request.Request, output *ReleaseAddressOutput) {
	op := &request.Operation{
		Name:       opReleaseAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReleaseAddressInput{}
	}

	output = &ReleaseAddressOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ReleaseAddress API operation for Amazon Elastic Compute Cloud.
//
// Releases the specified Elastic IP address.
//
// After releasing an Elastic IP address, it is released to the IP address pool
// and might be unavailable to you. Be sure to update your DNS records and any
// servers or devices that communicate with the address. If you attempt to release
// an Elastic IP address that you already released, you'll get an AuthFailure
// error if the address is already allocated to another AWS account.
//
// [EC2-Classic, default VPC] Releasing an Elastic IP address automatically
// disassociates it from any instance that it's associated with. To disassociate
// an Elastic IP address without releasing it, use DisassociateAddress.
//
// [Nondefault VPC] You must use DisassociateAddress to disassociate the Elastic
// IP address before you try to release it. Otherwise, Amazon EC2 returns an
// error (InvalidIPAddress.InUse).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ReleaseAddress for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReleaseAddress
func (c *EC2) ReleaseAddress(input *ReleaseAddressInput) (*ReleaseAddressOutput, error) {
	req, out := c.ReleaseAddressRequest(input)
	err := req.Send()
	return out, err
}

const opReleaseHosts = "ReleaseHosts"

// ReleaseHostsRequest generates a "aws/request.Request" representing the
// client's request for the ReleaseHosts operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReleaseHosts for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReleaseHosts method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReleaseHostsRequest method.
//    req, resp := client.ReleaseHostsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReleaseHosts
func (c *EC2) ReleaseHostsRequest(input *ReleaseHostsInput) (req *request.Request, output *ReleaseHostsOutput) {
	op := &request.Operation{
		Name:       opReleaseHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReleaseHostsInput{}
	}

	output = &ReleaseHostsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReleaseHosts API operation for Amazon Elastic Compute Cloud.
//
// When you no longer want to use an On-Demand Dedicated Host it can be released.
// On-Demand billing is stopped and the host goes into released state. The host
// ID of Dedicated Hosts that have been released can no longer be specified
// in another request, e.g., ModifyHosts. You must stop or terminate all instances
// on a host before it can be released.
//
// When Dedicated Hosts are released, it make take some time for them to stop
// counting toward your limit and you may receive capacity errors when trying
// to allocate new Dedicated hosts. Try waiting a few minutes, and then try
// again.
//
// Released hosts will still appear in a DescribeHosts response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ReleaseHosts for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReleaseHosts
func (c *EC2) ReleaseHosts(input *ReleaseHostsInput) (*ReleaseHostsOutput, error) {
	req, out := c.ReleaseHostsRequest(input)
	err := req.Send()
	return out, err
}

const opReplaceNetworkAclAssociation = "ReplaceNetworkAclAssociation"

// ReplaceNetworkAclAssociationRequest generates a "aws/request.Request" representing the
// client's request for the ReplaceNetworkAclAssociation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReplaceNetworkAclAssociation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReplaceNetworkAclAssociation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReplaceNetworkAclAssociationRequest method.
//    req, resp := client.ReplaceNetworkAclAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceNetworkAclAssociation
func (c *EC2) ReplaceNetworkAclAssociationRequest(input *ReplaceNetworkAclAssociationInput) (req *request.Request, output *ReplaceNetworkAclAssociationOutput) {
	op := &request.Operation{
		Name:       opReplaceNetworkAclAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReplaceNetworkAclAssociationInput{}
	}

	output = &ReplaceNetworkAclAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReplaceNetworkAclAssociation API operation for Amazon Elastic Compute Cloud.
//
// Changes which network ACL a subnet is associated with. By default when you
// create a subnet, it's automatically associated with the default network ACL.
// For more information about network ACLs, see Network ACLs (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ReplaceNetworkAclAssociation for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceNetworkAclAssociation
func (c *EC2) ReplaceNetworkAclAssociation(input *ReplaceNetworkAclAssociationInput) (*ReplaceNetworkAclAssociationOutput, error) {
	req, out := c.ReplaceNetworkAclAssociationRequest(input)
	err := req.Send()
	return out, err
}

const opReplaceNetworkAclEntry = "ReplaceNetworkAclEntry"

// ReplaceNetworkAclEntryRequest generates a "aws/request.Request" representing the
// client's request for the ReplaceNetworkAclEntry operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReplaceNetworkAclEntry for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReplaceNetworkAclEntry method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReplaceNetworkAclEntryRequest method.
//    req, resp := client.ReplaceNetworkAclEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceNetworkAclEntry
func (c *EC2) ReplaceNetworkAclEntryRequest(input *ReplaceNetworkAclEntryInput) (req *request.Request, output *ReplaceNetworkAclEntryOutput) {
	op := &request.Operation{
		Name:       opReplaceNetworkAclEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReplaceNetworkAclEntryInput{}
	}

	output = &ReplaceNetworkAclEntryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ReplaceNetworkAclEntry API operation for Amazon Elastic Compute Cloud.
//
// Replaces an entry (rule) in a network ACL. For more information about network
// ACLs, see Network ACLs (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ReplaceNetworkAclEntry for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceNetworkAclEntry
func (c *EC2) ReplaceNetworkAclEntry(input *ReplaceNetworkAclEntryInput) (*ReplaceNetworkAclEntryOutput, error) {
	req, out := c.ReplaceNetworkAclEntryRequest(input)
	err := req.Send()
	return out, err
}

const opReplaceRoute = "ReplaceRoute"

// ReplaceRouteRequest generates a "aws/request.Request" representing the
// client's request for the ReplaceRoute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReplaceRoute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReplaceRoute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReplaceRouteRequest method.
//    req, resp := client.ReplaceRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceRoute
func (c *EC2) ReplaceRouteRequest(input *ReplaceRouteInput) (req *request.Request, output *ReplaceRouteOutput) {
	op := &request.Operation{
		Name:       opReplaceRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReplaceRouteInput{}
	}

	output = &ReplaceRouteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ReplaceRoute API operation for Amazon Elastic Compute Cloud.
//
// Replaces an existing route within a route table in a VPC. You must provide
// only one of the following: Internet gateway or virtual private gateway, NAT
// instance, NAT gateway, VPC peering connection, network interface, or egress-only
// Internet gateway.
//
// For more information about route tables, see Route Tables (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ReplaceRoute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceRoute
func (c *EC2) ReplaceRoute(input *ReplaceRouteInput) (*ReplaceRouteOutput, error) {
	req, out := c.ReplaceRouteRequest(input)
	err := req.Send()
	return out, err
}

const opReplaceRouteTableAssociation = "ReplaceRouteTableAssociation"

// ReplaceRouteTableAssociationRequest generates a "aws/request.Request" representing the
// client's request for the ReplaceRouteTableAssociation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReplaceRouteTableAssociation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReplaceRouteTableAssociation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReplaceRouteTableAssociationRequest method.
//    req, resp := client.ReplaceRouteTableAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceRouteTableAssociation
func (c *EC2) ReplaceRouteTableAssociationRequest(input *ReplaceRouteTableAssociationInput) (req *request.Request, output *ReplaceRouteTableAssociationOutput) {
	op := &request.Operation{
		Name:       opReplaceRouteTableAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReplaceRouteTableAssociationInput{}
	}

	output = &ReplaceRouteTableAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReplaceRouteTableAssociation API operation for Amazon Elastic Compute Cloud.
//
// Changes the route table associated with a given subnet in a VPC. After the
// operation completes, the subnet uses the routes in the new route table it's
// associated with. For more information about route tables, see Route Tables
// (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// You can also use ReplaceRouteTableAssociation to change which table is the
// main route table in the VPC. You just specify the main route table's association
// ID and the route table to be the new main route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ReplaceRouteTableAssociation for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceRouteTableAssociation
func (c *EC2) ReplaceRouteTableAssociation(input *ReplaceRouteTableAssociationInput) (*ReplaceRouteTableAssociationOutput, error) {
	req, out := c.ReplaceRouteTableAssociationRequest(input)
	err := req.Send()
	return out, err
}

const opReportInstanceStatus = "ReportInstanceStatus"

// ReportInstanceStatusRequest generates a "aws/request.Request" representing the
// client's request for the ReportInstanceStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReportInstanceStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReportInstanceStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReportInstanceStatusRequest method.
//    req, resp := client.ReportInstanceStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReportInstanceStatus
func (c *EC2) ReportInstanceStatusRequest(input *ReportInstanceStatusInput) (req *request.Request, output *ReportInstanceStatusOutput) {
	op := &request.Operation{
		Name:       opReportInstanceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReportInstanceStatusInput{}
	}

	output = &ReportInstanceStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ReportInstanceStatus API operation for Amazon Elastic Compute Cloud.
//
// Submits feedback about the status of an instance. The instance must be in
// the running state. If your experience with the instance differs from the
// instance status returned by DescribeInstanceStatus, use ReportInstanceStatus
// to report your experience with the instance. Amazon EC2 collects this information
// to improve the accuracy of status checks.
//
// Use of this action does not change the value returned by DescribeInstanceStatus.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ReportInstanceStatus for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReportInstanceStatus
func (c *EC2) ReportInstanceStatus(input *ReportInstanceStatusInput) (*ReportInstanceStatusOutput, error) {
	req, out := c.ReportInstanceStatusRequest(input)
	err := req.Send()
	return out, err
}

const opRequestSpotFleet = "RequestSpotFleet"

// RequestSpotFleetRequest generates a "aws/request.Request" representing the
// client's request for the RequestSpotFleet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RequestSpotFleet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RequestSpotFleet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RequestSpotFleetRequest method.
//    req, resp := client.RequestSpotFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RequestSpotFleet
func (c *EC2) RequestSpotFleetRequest(input *RequestSpotFleetInput) (req *request.Request, output *RequestSpotFleetOutput) {
	op := &request.Operation{
		Name:       opRequestSpotFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestSpotFleetInput{}
	}

	output = &RequestSpotFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RequestSpotFleet API operation for Amazon Elastic Compute Cloud.
//
// Creates a Spot fleet request.
//
// You can submit a single request that includes multiple launch specifications
// that vary by instance type, AMI, Availability Zone, or subnet.
//
// By default, the Spot fleet requests Spot instances in the Spot pool where
// the price per unit is the lowest. Each launch specification can include its
// own instance weighting that reflects the value of the instance type to your
// application workload.
//
// Alternatively, you can specify that the Spot fleet distribute the target
// capacity across the Spot pools included in its launch specifications. By
// ensuring that the Spot instances in your Spot fleet are in different Spot
// pools, you can improve the availability of your fleet.
//
// For more information, see Spot Fleet Requests (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation RequestSpotFleet for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RequestSpotFleet
func (c *EC2) RequestSpotFleet(input *RequestSpotFleetInput) (*RequestSpotFleetOutput, error) {
	req, out := c.RequestSpotFleetRequest(input)
	err := req.Send()
	return out, err
}

const opRequestSpotInstances = "RequestSpotInstances"

// RequestSpotInstancesRequest generates a "aws/request.Request" representing the
// client's request for the RequestSpotInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RequestSpotInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RequestSpotInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RequestSpotInstancesRequest method.
//    req, resp := client.RequestSpotInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RequestSpotInstances
func (c *EC2) RequestSpotInstancesRequest(input *RequestSpotInstancesInput) (req *request.Request, output *RequestSpotInstancesOutput) {
	op := &request.Operation{
		Name:       opRequestSpotInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestSpotInstancesInput{}
	}

	output = &RequestSpotInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RequestSpotInstances API operation for Amazon Elastic Compute Cloud.
//
// Creates a Spot instance request. Spot instances are instances that Amazon
// EC2 launches when the bid price that you specify exceeds the current Spot
// price. Amazon EC2 periodically sets the Spot price based on available Spot
// Instance capacity and current Spot instance requests. For more information,
// see Spot Instance Requests (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation RequestSpotInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RequestSpotInstances
func (c *EC2) RequestSpotInstances(input *RequestSpotInstancesInput) (*RequestSpotInstancesOutput, error) {
	req, out := c.RequestSpotInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opResetImageAttribute = "ResetImageAttribute"

// ResetImageAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ResetImageAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ResetImageAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ResetImageAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ResetImageAttributeRequest method.
//    req, resp := client.ResetImageAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetImageAttribute
func (c *EC2) ResetImageAttributeRequest(input *ResetImageAttributeInput) (req *request.Request, output *ResetImageAttributeOutput) {
	op := &request.Operation{
		Name:       opResetImageAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetImageAttributeInput{}
	}

	output = &ResetImageAttributeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ResetImageAttribute API operation for Amazon Elastic Compute Cloud.
//
// Resets an attribute of an AMI to its default value.
//
// The productCodes attribute can't be reset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ResetImageAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetImageAttribute
func (c *EC2) ResetImageAttribute(input *ResetImageAttributeInput) (*ResetImageAttributeOutput, error) {
	req, out := c.ResetImageAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opResetInstanceAttribute = "ResetInstanceAttribute"

// ResetInstanceAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ResetInstanceAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ResetInstanceAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ResetInstanceAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ResetInstanceAttributeRequest method.
//    req, resp := client.ResetInstanceAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetInstanceAttribute
func (c *EC2) ResetInstanceAttributeRequest(input *ResetInstanceAttributeInput) (req *request.Request, output *ResetInstanceAttributeOutput) {
	op := &request.Operation{
		Name:       opResetInstanceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetInstanceAttributeInput{}
	}

	output = &ResetInstanceAttributeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ResetInstanceAttribute API operation for Amazon Elastic Compute Cloud.
//
// Resets an attribute of an instance to its default value. To reset the kernel
// or ramdisk, the instance must be in a stopped state. To reset the sourceDestCheck,
// the instance can be either running or stopped.
//
// The sourceDestCheck attribute controls whether source/destination checking
// is enabled. The default value is true, which means checking is enabled. This
// value must be false for a NAT instance to perform NAT. For more information,
// see NAT Instances (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ResetInstanceAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetInstanceAttribute
func (c *EC2) ResetInstanceAttribute(input *ResetInstanceAttributeInput) (*ResetInstanceAttributeOutput, error) {
	req, out := c.ResetInstanceAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opResetNetworkInterfaceAttribute = "ResetNetworkInterfaceAttribute"

// ResetNetworkInterfaceAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ResetNetworkInterfaceAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ResetNetworkInterfaceAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ResetNetworkInterfaceAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ResetNetworkInterfaceAttributeRequest method.
//    req, resp := client.ResetNetworkInterfaceAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetNetworkInterfaceAttribute
func (c *EC2) ResetNetworkInterfaceAttributeRequest(input *ResetNetworkInterfaceAttributeInput) (req *request.Request, output *ResetNetworkInterfaceAttributeOutput) {
	op := &request.Operation{
		Name:       opResetNetworkInterfaceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetNetworkInterfaceAttributeInput{}
	}

	output = &ResetNetworkInterfaceAttributeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ResetNetworkInterfaceAttribute API operation for Amazon Elastic Compute Cloud.
//
// Resets a network interface attribute. You can specify only one attribute
// at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ResetNetworkInterfaceAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetNetworkInterfaceAttribute
func (c *EC2) ResetNetworkInterfaceAttribute(input *ResetNetworkInterfaceAttributeInput) (*ResetNetworkInterfaceAttributeOutput, error) {
	req, out := c.ResetNetworkInterfaceAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opResetSnapshotAttribute = "ResetSnapshotAttribute"

// ResetSnapshotAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ResetSnapshotAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ResetSnapshotAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ResetSnapshotAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ResetSnapshotAttributeRequest method.
//    req, resp := client.ResetSnapshotAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetSnapshotAttribute
func (c *EC2) ResetSnapshotAttributeRequest(input *ResetSnapshotAttributeInput) (req *request.Request, output *ResetSnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opResetSnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetSnapshotAttributeInput{}
	}

	output = &ResetSnapshotAttributeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ResetSnapshotAttribute API operation for Amazon Elastic Compute Cloud.
//
// Resets permission settings for the specified snapshot.
//
// For more information on modifying snapshot permissions, see Sharing Snapshots
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ResetSnapshotAttribute for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetSnapshotAttribute
func (c *EC2) ResetSnapshotAttribute(input *ResetSnapshotAttributeInput) (*ResetSnapshotAttributeOutput, error) {
	req, out := c.ResetSnapshotAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opRestoreAddressToClassic = "RestoreAddressToClassic"

// RestoreAddressToClassicRequest generates a "aws/request.Request" representing the
// client's request for the RestoreAddressToClassic operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RestoreAddressToClassic for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RestoreAddressToClassic method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RestoreAddressToClassicRequest method.
//    req, resp := client.RestoreAddressToClassicRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RestoreAddressToClassic
func (c *EC2) RestoreAddressToClassicRequest(input *RestoreAddressToClassicInput) (req *request.Request, output *RestoreAddressToClassicOutput) {
	op := &request.Operation{
		Name:       opRestoreAddressToClassic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreAddressToClassicInput{}
	}

	output = &RestoreAddressToClassicOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreAddressToClassic API operation for Amazon Elastic Compute Cloud.
//
// Restores an Elastic IP address that was previously moved to the EC2-VPC platform
// back to the EC2-Classic platform. You cannot move an Elastic IP address that
// was originally allocated for use in EC2-VPC. The Elastic IP address must
// not be associated with an instance or network interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation RestoreAddressToClassic for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RestoreAddressToClassic
func (c *EC2) RestoreAddressToClassic(input *RestoreAddressToClassicInput) (*RestoreAddressToClassicOutput, error) {
	req, out := c.RestoreAddressToClassicRequest(input)
	err := req.Send()
	return out, err
}

const opRevokeSecurityGroupEgress = "RevokeSecurityGroupEgress"

// RevokeSecurityGroupEgressRequest generates a "aws/request.Request" representing the
// client's request for the RevokeSecurityGroupEgress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RevokeSecurityGroupEgress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RevokeSecurityGroupEgress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RevokeSecurityGroupEgressRequest method.
//    req, resp := client.RevokeSecurityGroupEgressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RevokeSecurityGroupEgress
func (c *EC2) RevokeSecurityGroupEgressRequest(input *RevokeSecurityGroupEgressInput) (req *request.Request, output *RevokeSecurityGroupEgressOutput) {
	op := &request.Operation{
		Name:       opRevokeSecurityGroupEgress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeSecurityGroupEgressInput{}
	}

	output = &RevokeSecurityGroupEgressOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokeSecurityGroupEgress API operation for Amazon Elastic Compute Cloud.
//
// [EC2-VPC only] Removes one or more egress rules from a security group for
// EC2-VPC. This action doesn't apply to security groups for use in EC2-Classic.
// The values that you specify in the revoke request (for example, ports) must
// match the existing rule's values for the rule to be revoked.
//
// Each rule consists of the protocol and the IPv4 or IPv6 CIDR range or source
// security group. For the TCP and UDP protocols, you must also specify the
// destination port or range of ports. For the ICMP protocol, you must also
// specify the ICMP type and code.
//
// Rule changes are propagated to instances within the security group as quickly
// as possible. However, a small delay might occur.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation RevokeSecurityGroupEgress for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RevokeSecurityGroupEgress
func (c *EC2) RevokeSecurityGroupEgress(input *RevokeSecurityGroupEgressInput) (*RevokeSecurityGroupEgressOutput, error) {
	req, out := c.RevokeSecurityGroupEgressRequest(input)
	err := req.Send()
	return out, err
}

const opRevokeSecurityGroupIngress = "RevokeSecurityGroupIngress"

// RevokeSecurityGroupIngressRequest generates a "aws/request.Request" representing the
// client's request for the RevokeSecurityGroupIngress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RevokeSecurityGroupIngress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RevokeSecurityGroupIngress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RevokeSecurityGroupIngressRequest method.
//    req, resp := client.RevokeSecurityGroupIngressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RevokeSecurityGroupIngress
func (c *EC2) RevokeSecurityGroupIngressRequest(input *RevokeSecurityGroupIngressInput) (req *request.Request, output *RevokeSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opRevokeSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeSecurityGroupIngressInput{}
	}

	output = &RevokeSecurityGroupIngressOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokeSecurityGroupIngress API operation for Amazon Elastic Compute Cloud.
//
// Removes one or more ingress rules from a security group. The values that
// you specify in the revoke request (for example, ports) must match the existing
// rule's values for the rule to be removed.
//
// Each rule consists of the protocol and the CIDR range or source security
// group. For the TCP and UDP protocols, you must also specify the destination
// port or range of ports. For the ICMP protocol, you must also specify the
// ICMP type and code.
//
// Rule changes are propagated to instances within the security group as quickly
// as possible. However, a small delay might occur.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation RevokeSecurityGroupIngress for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RevokeSecurityGroupIngress
func (c *EC2) RevokeSecurityGroupIngress(input *RevokeSecurityGroupIngressInput) (*RevokeSecurityGroupIngressOutput, error) {
	req, out := c.RevokeSecurityGroupIngressRequest(input)
	err := req.Send()
	return out, err
}

const opRunInstances = "RunInstances"

// RunInstancesRequest generates a "aws/request.Request" representing the
// client's request for the RunInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RunInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RunInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RunInstancesRequest method.
//    req, resp := client.RunInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RunInstances
func (c *EC2) RunInstancesRequest(input *RunInstancesInput) (req *request.Request, output *Reservation) {
	op := &request.Operation{
		Name:       opRunInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RunInstancesInput{}
	}

	output = &Reservation{}
	req = c.newRequest(op, input, output)
	return
}

// RunInstances API operation for Amazon Elastic Compute Cloud.
//
// Launches the specified number of instances using an AMI for which you have
// permissions.
//
// You can specify a number of options, or leave the default options. The following
// rules apply:
//
//    * [EC2-VPC] If you don't specify a subnet ID, we choose a default subnet
//    from your default VPC for you. If you don't have a default VPC, you must
//    specify a subnet ID in the request.
//
//    * [EC2-Classic] If don't specify an Availability Zone, we choose one for
//    you.
//
//    * Some instance types must be launched into a VPC. If you do not have
//    a default VPC, or if you do not specify a subnet ID, the request fails.
//    For more information, see Instance Types Available Only in a VPC (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-vpc.html#vpc-only-instance-types).
//
//    * [EC2-VPC] All instances have a network interface with a primary private
//    IPv4 address. If you don't specify this address, we choose one from the
//    IPv4 range of your subnet.
//
//    * Not all instance types support IPv6 addresses. For more information,
//    see Amazon EC2 Instance Types (http://aws.amazon.com/ec2/instance-types/).
//
//    * If you don't specify a security group ID, we use the default security
//    group. For more information, see Security Groups (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html).
//
//    * If any of the AMIs have a product code attached for which the user has
//    not subscribed, the request fails.
//
// To ensure faster instance launches, break up large requests into smaller
// batches. For example, create 5 separate launch requests for 100 instances
// each instead of 1 launch request for 500 instances.
//
// An instance is ready for you to use when it's in the running state. You can
// check the state of your instance using DescribeInstances. After launch, you
// can apply tags to your running instance (requires a resource ID). For more
// information, see CreateTags and Tagging Your Amazon EC2 Resources (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html).
//
// Linux instances have access to the public key of the key pair at boot. You
// can use this key to provide secure access to the instance. Amazon EC2 public
// images use this feature to provide secure access without passwords. For more
// information, see Key Pairs (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For troubleshooting, see What To Do If An Instance Immediately Terminates
// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_InstanceStraightToTerminated.html),
// and Troubleshooting Connecting to Your Instance (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesConnecting.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation RunInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RunInstances
func (c *EC2) RunInstances(input *RunInstancesInput) (*Reservation, error) {
	req, out := c.RunInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opRunScheduledInstances = "RunScheduledInstances"

// RunScheduledInstancesRequest generates a "aws/request.Request" representing the
// client's request for the RunScheduledInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RunScheduledInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RunScheduledInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RunScheduledInstancesRequest method.
//    req, resp := client.RunScheduledInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RunScheduledInstances
func (c *EC2) RunScheduledInstancesRequest(input *RunScheduledInstancesInput) (req *request.Request, output *RunScheduledInstancesOutput) {
	op := &request.Operation{
		Name:       opRunScheduledInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RunScheduledInstancesInput{}
	}

	output = &RunScheduledInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RunScheduledInstances API operation for Amazon Elastic Compute Cloud.
//
// Launches the specified Scheduled Instances.
//
// Before you can launch a Scheduled Instance, you must purchase it and obtain
// an identifier using PurchaseScheduledInstances.
//
// You must launch a Scheduled Instance during its scheduled time period. You
// can't stop or reboot a Scheduled Instance, but you can terminate it as needed.
// If you terminate a Scheduled Instance before the current scheduled time period
// ends, you can launch it again after a few minutes. For more information,
// see Scheduled Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-scheduled-instances.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation RunScheduledInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RunScheduledInstances
func (c *EC2) RunScheduledInstances(input *RunScheduledInstancesInput) (*RunScheduledInstancesOutput, error) {
	req, out := c.RunScheduledInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opStartInstances = "StartInstances"

// StartInstancesRequest generates a "aws/request.Request" representing the
// client's request for the StartInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StartInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StartInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StartInstancesRequest method.
//    req, resp := client.StartInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/StartInstances
func (c *EC2) StartInstancesRequest(input *StartInstancesInput) (req *request.Request, output *StartInstancesOutput) {
	op := &request.Operation{
		Name:       opStartInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartInstancesInput{}
	}

	output = &StartInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartInstances API operation for Amazon Elastic Compute Cloud.
//
// Starts an Amazon EBS-backed AMI that you've previously stopped.
//
// Instances that use Amazon EBS volumes as their root devices can be quickly
// stopped and started. When an instance is stopped, the compute resources are
// released and you are not billed for hourly instance usage. However, your
// root partition Amazon EBS volume remains, continues to persist your data,
// and you are charged for Amazon EBS volume usage. You can restart your instance
// at any time. Each time you transition an instance from stopped to started,
// Amazon EC2 charges a full instance hour, even if transitions happen multiple
// times within a single hour.
//
// Before stopping an instance, make sure it is in a state from which it can
// be restarted. Stopping an instance does not preserve data stored in RAM.
//
// Performing this operation on an instance that uses an instance store as its
// root device returns an error.
//
// For more information, see Stopping Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation StartInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/StartInstances
func (c *EC2) StartInstances(input *StartInstancesInput) (*StartInstancesOutput, error) {
	req, out := c.StartInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opStopInstances = "StopInstances"

// StopInstancesRequest generates a "aws/request.Request" representing the
// client's request for the StopInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StopInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StopInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StopInstancesRequest method.
//    req, resp := client.StopInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/StopInstances
func (c *EC2) StopInstancesRequest(input *StopInstancesInput) (req *request.Request, output *StopInstancesOutput) {
	op := &request.Operation{
		Name:       opStopInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopInstancesInput{}
	}

	output = &StopInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopInstances API operation for Amazon Elastic Compute Cloud.
//
// Stops an Amazon EBS-backed instance.
//
// We don't charge hourly usage for a stopped instance, or data transfer fees;
// however, your root partition Amazon EBS volume remains, continues to persist
// your data, and you are charged for Amazon EBS volume usage. Each time you
// transition an instance from stopped to started, Amazon EC2 charges a full
// instance hour, even if transitions happen multiple times within a single
// hour.
//
// You can't start or stop Spot instances, and you can't stop instance store-backed
// instances.
//
// When you stop an instance, we shut it down. You can restart your instance
// at any time. Before stopping an instance, make sure it is in a state from
// which it can be restarted. Stopping an instance does not preserve data stored
// in RAM.
//
// Stopping an instance is different to rebooting or terminating it. For example,
// when you stop an instance, the root device and any other devices attached
// to the instance persist. When you terminate an instance, the root device
// and any other devices attached during the instance launch are automatically
// deleted. For more information about the differences between rebooting, stopping,
// and terminating instances, see Instance Lifecycle (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// When you stop an instance, we attempt to shut it down forcibly after a short
// while. If your instance appears stuck in the stopping state after a period
// of time, there may be an issue with the underlying host computer. For more
// information, see Troubleshooting Stopping Your Instance (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesStopping.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation StopInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/StopInstances
func (c *EC2) StopInstances(input *StopInstancesInput) (*StopInstancesOutput, error) {
	req, out := c.StopInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opTerminateInstances = "TerminateInstances"

// TerminateInstancesRequest generates a "aws/request.Request" representing the
// client's request for the TerminateInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TerminateInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TerminateInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TerminateInstancesRequest method.
//    req, resp := client.TerminateInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TerminateInstances
func (c *EC2) TerminateInstancesRequest(input *TerminateInstancesInput) (req *request.Request, output *TerminateInstancesOutput) {
	op := &request.Operation{
		Name:       opTerminateInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateInstancesInput{}
	}

	output = &TerminateInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateInstances API operation for Amazon Elastic Compute Cloud.
//
// Shuts down one or more instances. This operation is idempotent; if you terminate
// an instance more than once, each call succeeds.
//
// If you specify multiple instances and the request fails (for example, because
// of a single incorrect instance ID), none of the instances are terminated.
//
// Terminated instances remain visible after termination (for approximately
// one hour).
//
// By default, Amazon EC2 deletes all EBS volumes that were attached when the
// instance launched. Volumes attached after instance launch continue running.
//
// You can stop, start, and terminate EBS-backed instances. You can only terminate
// instance store-backed instances. What happens to an instance differs if you
// stop it or terminate it. For example, when you stop an instance, the root
// device and any other devices attached to the instance persist. When you terminate
// an instance, any attached EBS volumes with the DeleteOnTermination block
// device mapping parameter set to true are automatically deleted. For more
// information about the differences between stopping and terminating instances,
// see Instance Lifecycle (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For more information about troubleshooting, see Troubleshooting Terminating
// Your Instance (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesShuttingDown.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation TerminateInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TerminateInstances
func (c *EC2) TerminateInstances(input *TerminateInstancesInput) (*TerminateInstancesOutput, error) {
	req, out := c.TerminateInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opUnassignIpv6Addresses = "UnassignIpv6Addresses"

// UnassignIpv6AddressesRequest generates a "aws/request.Request" representing the
// client's request for the UnassignIpv6Addresses operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UnassignIpv6Addresses for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UnassignIpv6Addresses method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UnassignIpv6AddressesRequest method.
//    req, resp := client.UnassignIpv6AddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnassignIpv6Addresses
func (c *EC2) UnassignIpv6AddressesRequest(input *UnassignIpv6AddressesInput) (req *request.Request, output *UnassignIpv6AddressesOutput) {
	op := &request.Operation{
		Name:       opUnassignIpv6Addresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnassignIpv6AddressesInput{}
	}

	output = &UnassignIpv6AddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UnassignIpv6Addresses API operation for Amazon Elastic Compute Cloud.
//
// Unassigns one or more IPv6 addresses from a network interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation UnassignIpv6Addresses for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnassignIpv6Addresses
func (c *EC2) UnassignIpv6Addresses(input *UnassignIpv6AddressesInput) (*UnassignIpv6AddressesOutput, error) {
	req, out := c.UnassignIpv6AddressesRequest(input)
	err := req.Send()
	return out, err
}

const opUnassignPrivateIpAddresses = "UnassignPrivateIpAddresses"

// UnassignPrivateIpAddressesRequest generates a "aws/request.Request" representing the
// client's request for the UnassignPrivateIpAddresses operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UnassignPrivateIpAddresses for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UnassignPrivateIpAddresses method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UnassignPrivateIpAddressesRequest method.
//    req, resp := client.UnassignPrivateIpAddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnassignPrivateIpAddresses
func (c *EC2) UnassignPrivateIpAddressesRequest(input *UnassignPrivateIpAddressesInput) (req *request.Request, output *UnassignPrivateIpAddressesOutput) {
	op := &request.Operation{
		Name:       opUnassignPrivateIpAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnassignPrivateIpAddressesInput{}
	}

	output = &UnassignPrivateIpAddressesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UnassignPrivateIpAddresses API operation for Amazon Elastic Compute Cloud.
//
// Unassigns one or more secondary private IP addresses from a network interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation UnassignPrivateIpAddresses for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnassignPrivateIpAddresses
func (c *EC2) UnassignPrivateIpAddresses(input *UnassignPrivateIpAddressesInput) (*UnassignPrivateIpAddressesOutput, error) {
	req, out := c.UnassignPrivateIpAddressesRequest(input)
	err := req.Send()
	return out, err
}

const opUnmonitorInstances = "UnmonitorInstances"

// UnmonitorInstancesRequest generates a "aws/request.Request" representing the
// client's request for the UnmonitorInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UnmonitorInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UnmonitorInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UnmonitorInstancesRequest method.
//    req, resp := client.UnmonitorInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnmonitorInstances
func (c *EC2) UnmonitorInstancesRequest(input *UnmonitorInstancesInput) (req *request.Request, output *UnmonitorInstancesOutput) {
	op := &request.Operation{
		Name:       opUnmonitorInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnmonitorInstancesInput{}
	}

	output = &UnmonitorInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UnmonitorInstances API operation for Amazon Elastic Compute Cloud.
//
// Disables detailed monitoring for a running instance. For more information,
// see Monitoring Your Instances and Volumes (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation UnmonitorInstances for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnmonitorInstances
func (c *EC2) UnmonitorInstances(input *UnmonitorInstancesInput) (*UnmonitorInstancesOutput, error) {
	req, out := c.UnmonitorInstancesRequest(input)
	err := req.Send()
	return out, err
}

// Contains the parameters for accepting the quote.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuoteRequest
type AcceptReservedInstancesExchangeQuoteInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The IDs of the Convertible Reserved Instances to exchange for other Convertible
	// Reserved Instances of the same or higher value.
	//
	// ReservedInstanceIds is a required field
	ReservedInstanceIds []*string `locationName:"ReservedInstanceId" locationNameList:"ReservedInstanceId" type:"list" required:"true"`

	// The configurations of the Convertible Reserved Instance offerings that you
	// are purchasing in this exchange.
	TargetConfigurations []*TargetConfigurationRequest `locationName:"TargetConfiguration" locationNameList:"TargetConfigurationRequest" type:"list"`
}

// String returns the string representation
func (s AcceptReservedInstancesExchangeQuoteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptReservedInstancesExchangeQuoteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptReservedInstancesExchangeQuoteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptReservedInstancesExchangeQuoteInput"}
	if s.ReservedInstanceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedInstanceIds"))
	}
	if s.TargetConfigurations != nil {
		for i, v := range s.TargetConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *AcceptReservedInstancesExchangeQuoteInput) SetDryRun(v bool) *AcceptReservedInstancesExchangeQuoteInput {
	s.DryRun = &v
	return s
}

// SetReservedInstanceIds sets the ReservedInstanceIds field's value.
func (s *AcceptReservedInstancesExchangeQuoteInput) SetReservedInstanceIds(v []*string) *AcceptReservedInstancesExchangeQuoteInput {
	s.ReservedInstanceIds = v
	return s
}

// SetTargetConfigurations sets the TargetConfigurations field's value.
func (s *AcceptReservedInstancesExchangeQuoteInput) SetTargetConfigurations(v []*TargetConfigurationRequest) *AcceptReservedInstancesExchangeQuoteInput {
	s.TargetConfigurations = v
	return s
}

// The result of the exchange and whether it was successful.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuoteResult
type AcceptReservedInstancesExchangeQuoteOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the successful exchange.
	ExchangeId *string `locationName:"exchangeId" type:"string"`
}

// String returns the string representation
func (s AcceptReservedInstancesExchangeQuoteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptReservedInstancesExchangeQuoteOutput) GoString() string {
	return s.String()
}

// SetExchangeId sets the ExchangeId field's value.
func (s *AcceptReservedInstancesExchangeQuoteOutput) SetExchangeId(v string) *AcceptReservedInstancesExchangeQuoteOutput {
	s.ExchangeId = &v
	return s
}

// Contains the parameters for AcceptVpcPeeringConnection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnectionRequest
type AcceptVpcPeeringConnectionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC peering connection.
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string"`
}

// String returns the string representation
func (s AcceptVpcPeeringConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptVpcPeeringConnectionInput) GoString() string {
	return s.String()
}

// SetDryRun sets the DryRun field's value.
func (s *AcceptVpcPeeringConnectionInput) SetDryRun(v bool) *AcceptVpcPeeringConnectionInput {
	s.DryRun = &v
	return s
}

// SetVpcPeeringConnectionId sets the VpcPeeringConnectionId field's value.
func (s *AcceptVpcPeeringConnectionInput) SetVpcPeeringConnectionId(v string) *AcceptVpcPeeringConnectionInput {
	s.VpcPeeringConnectionId = &v
	return s
}

// Contains the output of AcceptVpcPeeringConnection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnectionResult
type AcceptVpcPeeringConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the VPC peering connection.
	VpcPeeringConnection *VpcPeeringConnection `locationName:"vpcPeeringConnection" type:"structure"`
}

// String returns the string representation
func (s AcceptVpcPeeringConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptVpcPeeringConnectionOutput) GoString() string {
	return s.String()
}

// SetVpcPeeringConnection sets the VpcPeeringConnection field's value.
func (s *AcceptVpcPeeringConnectionOutput) SetVpcPeeringConnection(v *VpcPeeringConnection) *AcceptVpcPeeringConnectionOutput {
	s.VpcPeeringConnection = v
	return s
}

// Describes an account attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AccountAttribute
type AccountAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the account attribute.
	AttributeName *string `locationName:"attributeName" type:"string"`

	// One or more values for the account attribute.
	AttributeValues []*AccountAttributeValue `locationName:"attributeValueSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s AccountAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountAttribute) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *AccountAttribute) SetAttributeName(v string) *AccountAttribute {
	s.AttributeName = &v
	return s
}

// SetAttributeValues sets the AttributeValues field's value.
func (s *AccountAttribute) SetAttributeValues(v []*AccountAttributeValue) *AccountAttribute {
	s.AttributeValues = v
	return s
}

// Describes a value of an account attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AccountAttributeValue
type AccountAttributeValue struct {
	_ struct{} `type:"structure"`

	// The value of the attribute.
	AttributeValue *string `locationName:"attributeValue" type:"string"`
}

// String returns the string representation
func (s AccountAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountAttributeValue) GoString() string {
	return s.String()
}

// SetAttributeValue sets the AttributeValue field's value.
func (s *AccountAttributeValue) SetAttributeValue(v string) *AccountAttributeValue {
	s.AttributeValue = &v
	return s
}

// Describes a running instance in a Spot fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ActiveInstance
type ActiveInstance struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The instance type.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The ID of the Spot instance request.
	SpotInstanceRequestId *string `locationName:"spotInstanceRequestId" type:"string"`
}

// String returns the string representation
func (s ActiveInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActiveInstance) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *ActiveInstance) SetInstanceId(v string) *ActiveInstance {
	s.InstanceId = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ActiveInstance) SetInstanceType(v string) *ActiveInstance {
	s.InstanceType = &v
	return s
}

// SetSpotInstanceRequestId sets the SpotInstanceRequestId field's value.
func (s *ActiveInstance) SetSpotInstanceRequestId(v string) *ActiveInstance {
	s.SpotInstanceRequestId = &v
	return s
}

// Describes an Elastic IP address.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Address
type Address struct {
	_ struct{} `type:"structure"`

	// The ID representing the allocation of the address for use with EC2-VPC.
	AllocationId *string `locationName:"allocationId" type:"string"`

	// The ID representing the association of the address with an instance in a
	// VPC.
	AssociationId *string `locationName:"associationId" type:"string"`

	// Indicates whether this Elastic IP address is for use with instances in EC2-Classic
	// (standard) or instances in a VPC (vpc).
	Domain *string `locationName:"domain" type:"string" enum:"DomainType"`

	// The ID of the instance that the address is associated with (if any).
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The ID of the AWS account that owns the network interface.
	NetworkInterfaceOwnerId *string `locationName:"networkInterfaceOwnerId" type:"string"`

	// The private IP address associated with the Elastic IP address.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The Elastic IP address.
	PublicIp *string `locationName:"publicIp" type:"string"`
}

// String returns the string representation
func (s Address) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Address) GoString() string {
	return s.String()
}

// SetAllocationId sets the AllocationId field's value.
func (s *Address) SetAllocationId(v string) *Address {
	s.AllocationId = &v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *Address) SetAssociationId(v string) *Address {
	s.AssociationId = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *Address) SetDomain(v string) *Address {
	s.Domain = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *Address) SetInstanceId(v string) *Address {
	s.InstanceId = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *Address) SetNetworkInterfaceId(v string) *Address {
	s.NetworkInterfaceId = &v
	return s
}

// SetNetworkInterfaceOwnerId sets the NetworkInterfaceOwnerId field's value.
func (s *Address) SetNetworkInterfaceOwnerId(v string) *Address {
	s.NetworkInterfaceOwnerId = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *Address) SetPrivateIpAddress(v string) *Address {
	s.PrivateIpAddress = &v
	return s
}

// SetPublicIp sets the PublicIp field's value.
func (s *Address) SetPublicIp(v string) *Address {
	s.PublicIp = &v
	return s
}

// Contains the parameters for AllocateAddress.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddressRequest
type AllocateAddressInput struct {
	_ struct{} `type:"structure"`

	// Set to vpc to allocate the address for use with instances in a VPC.
	//
	// Default: The address is for use with instances in EC2-Classic.
	Domain *string `type:"string" enum:"DomainType"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s AllocateAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateAddressInput) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *AllocateAddressInput) SetDomain(v string) *AllocateAddressInput {
	s.Domain = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *AllocateAddressInput) SetDryRun(v bool) *AllocateAddressInput {
	s.DryRun = &v
	return s
}

// Contains the output of AllocateAddress.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddressResult
type AllocateAddressOutput struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] The ID that AWS assigns to represent the allocation of the Elastic
	// IP address for use with instances in a VPC.
	AllocationId *string `locationName:"allocationId" type:"string"`

	// Indicates whether this Elastic IP address is for use with instances in EC2-Classic
	// (standard) or instances in a VPC (vpc).
	Domain *string `locationName:"domain" type:"string" enum:"DomainType"`

	// The Elastic IP address.
	PublicIp *string `locationName:"publicIp" type:"string"`
}

// String returns the string representation
func (s AllocateAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateAddressOutput) GoString() string {
	return s.String()
}

// SetAllocationId sets the AllocationId field's value.
func (s *AllocateAddressOutput) SetAllocationId(v string) *AllocateAddressOutput {
	s.AllocationId = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *AllocateAddressOutput) SetDomain(v string) *AllocateAddressOutput {
	s.Domain = &v
	return s
}

// SetPublicIp sets the PublicIp field's value.
func (s *AllocateAddressOutput) SetPublicIp(v string) *AllocateAddressOutput {
	s.PublicIp = &v
	return s
}

// Contains the parameters for AllocateHosts.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHostsRequest
type AllocateHostsInput struct {
	_ struct{} `type:"structure"`

	// This is enabled by default. This property allows instances to be automatically
	// placed onto available Dedicated Hosts, when you are launching instances without
	// specifying a host ID.
	//
	// Default: Enabled
	AutoPlacement *string `locationName:"autoPlacement" type:"string" enum:"AutoPlacement"`

	// The Availability Zone for the Dedicated Hosts.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// Unique, case-sensitive identifier you provide to ensure idempotency of the
	// request. For more information, see How to Ensure Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Specify the instance type that you want your Dedicated Hosts to be configured
	// for. When you specify the instance type, that is the only instance type that
	// you can launch onto that host.
	//
	// InstanceType is a required field
	InstanceType *string `locationName:"instanceType" type:"string" required:"true"`

	// The number of Dedicated Hosts you want to allocate to your account with these
	// parameters.
	//
	// Quantity is a required field
	Quantity *int64 `locationName:"quantity" type:"integer" required:"true"`
}

// String returns the string representation
func (s AllocateHostsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateHostsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocateHostsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocateHostsInput"}
	if s.AvailabilityZone == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZone"))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoPlacement sets the AutoPlacement field's value.
func (s *AllocateHostsInput) SetAutoPlacement(v string) *AllocateHostsInput {
	s.AutoPlacement = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *AllocateHostsInput) SetAvailabilityZone(v string) *AllocateHostsInput {
	s.AvailabilityZone = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *AllocateHostsInput) SetClientToken(v string) *AllocateHostsInput {
	s.ClientToken = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *AllocateHostsInput) SetInstanceType(v string) *AllocateHostsInput {
	s.InstanceType = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *AllocateHostsInput) SetQuantity(v int64) *AllocateHostsInput {
	s.Quantity = &v
	return s
}

// Contains the output of AllocateHosts.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHostsResult
type AllocateHostsOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the allocated Dedicated Host. This is used when you want to launch
	// an instance onto a specific host.
	HostIds []*string `locationName:"hostIdSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s AllocateHostsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateHostsOutput) GoString() string {
	return s.String()
}

// SetHostIds sets the HostIds field's value.
func (s *AllocateHostsOutput) SetHostIds(v []*string) *AllocateHostsOutput {
	s.HostIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6AddressesRequest
type AssignIpv6AddressesInput struct {
	_ struct{} `type:"structure"`

	// The number of IPv6 addresses to assign to the network interface. Amazon EC2
	// automatically selects the IPv6 addresses from the subnet range. You can't
	// use this option if specifying specific IPv6 addresses.
	Ipv6AddressCount *int64 `locationName:"ipv6AddressCount" type:"integer"`

	// One or more specific IPv6 addresses to be assigned to the network interface.
	// You can't use this option if you're specifying a number of IPv6 addresses.
	Ipv6Addresses []*string `locationName:"ipv6Addresses" locationNameList:"item" type:"list"`

	// The ID of the network interface.
	//
	// NetworkInterfaceId is a required field
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssignIpv6AddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignIpv6AddressesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssignIpv6AddressesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssignIpv6AddressesInput"}
	if s.NetworkInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpv6AddressCount sets the Ipv6AddressCount field's value.
func (s *AssignIpv6AddressesInput) SetIpv6AddressCount(v int64) *AssignIpv6AddressesInput {
	s.Ipv6AddressCount = &v
	return s
}

// SetIpv6Addresses sets the Ipv6Addresses field's value.
func (s *AssignIpv6AddressesInput) SetIpv6Addresses(v []*string) *AssignIpv6AddressesInput {
	s.Ipv6Addresses = v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AssignIpv6AddressesInput) SetNetworkInterfaceId(v string) *AssignIpv6AddressesInput {
	s.NetworkInterfaceId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6AddressesResult
type AssignIpv6AddressesOutput struct {
	_ struct{} `type:"structure"`

	// The IPv6 addresses assigned to the network interface.
	AssignedIpv6Addresses []*string `locationName:"assignedIpv6Addresses" locationNameList:"item" type:"list"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`
}

// String returns the string representation
func (s AssignIpv6AddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignIpv6AddressesOutput) GoString() string {
	return s.String()
}

// SetAssignedIpv6Addresses sets the AssignedIpv6Addresses field's value.
func (s *AssignIpv6AddressesOutput) SetAssignedIpv6Addresses(v []*string) *AssignIpv6AddressesOutput {
	s.AssignedIpv6Addresses = v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AssignIpv6AddressesOutput) SetNetworkInterfaceId(v string) *AssignIpv6AddressesOutput {
	s.NetworkInterfaceId = &v
	return s
}

// Contains the parameters for AssignPrivateIpAddresses.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddressesRequest
type AssignPrivateIpAddressesInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether to allow an IP address that is already assigned to another
	// network interface or instance to be reassigned to the specified network interface.
	AllowReassignment *bool `locationName:"allowReassignment" type:"boolean"`

	// The ID of the network interface.
	//
	// NetworkInterfaceId is a required field
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string" required:"true"`

	// One or more IP addresses to be assigned as a secondary private IP address
	// to the network interface. You can't specify this parameter when also specifying
	// a number of secondary IP addresses.
	//
	// If you don't specify an IP address, Amazon EC2 automatically selects an IP
	// address within the subnet range.
	PrivateIpAddresses []*string `locationName:"privateIpAddress" locationNameList:"PrivateIpAddress" type:"list"`

	// The number of secondary IP addresses to assign to the network interface.
	// You can't specify this parameter when also specifying private IP addresses.
	SecondaryPrivateIpAddressCount *int64 `locationName:"secondaryPrivateIpAddressCount" type:"integer"`
}

// String returns the string representation
func (s AssignPrivateIpAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignPrivateIpAddressesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssignPrivateIpAddressesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssignPrivateIpAddressesInput"}
	if s.NetworkInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowReassignment sets the AllowReassignment field's value.
func (s *AssignPrivateIpAddressesInput) SetAllowReassignment(v bool) *AssignPrivateIpAddressesInput {
	s.AllowReassignment = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AssignPrivateIpAddressesInput) SetNetworkInterfaceId(v string) *AssignPrivateIpAddressesInput {
	s.NetworkInterfaceId = &v
	return s
}

// SetPrivateIpAddresses sets the PrivateIpAddresses field's value.
func (s *AssignPrivateIpAddressesInput) SetPrivateIpAddresses(v []*string) *AssignPrivateIpAddressesInput {
	s.PrivateIpAddresses = v
	return s
}

// SetSecondaryPrivateIpAddressCount sets the SecondaryPrivateIpAddressCount field's value.
func (s *AssignPrivateIpAddressesInput) SetSecondaryPrivateIpAddressCount(v int64) *AssignPrivateIpAddressesInput {
	s.SecondaryPrivateIpAddressCount = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddressesOutput
type AssignPrivateIpAddressesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssignPrivateIpAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignPrivateIpAddressesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for AssociateAddress.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddressRequest
type AssociateAddressInput struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] The allocation ID. This is required for EC2-VPC.
	AllocationId *string `type:"string"`

	// [EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic
	// IP address that is already associated with an instance or network interface
	// to be reassociated with the specified instance or network interface. Otherwise,
	// the operation fails. In a VPC in an EC2-VPC-only account, reassociation is
	// automatic, therefore you can specify false to ensure the operation fails
	// if the Elastic IP address is already associated with another resource.
	AllowReassociation *bool `locationName:"allowReassociation" type:"boolean"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance. This is required for EC2-Classic. For EC2-VPC, you
	// can specify either the instance ID or the network interface ID, but not both.
	// The operation fails if you specify an instance ID unless exactly one network
	// interface is attached.
	InstanceId *string `type:"string"`

	// [EC2-VPC] The ID of the network interface. If the instance has more than
	// one network interface, you must specify a network interface ID.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// [EC2-VPC] The primary or secondary private IP address to associate with the
	// Elastic IP address. If no private IP address is specified, the Elastic IP
	// address is associated with the primary private IP address.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The Elastic IP address. This is required for EC2-Classic.
	PublicIp *string `type:"string"`
}

// String returns the string representation
func (s AssociateAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateAddressInput) GoString() string {
	return s.String()
}

// SetAllocationId sets the AllocationId field's value.
func (s *AssociateAddressInput) SetAllocationId(v string) *AssociateAddressInput {
	s.AllocationId = &v
	return s
}

// SetAllowReassociation sets the AllowReassociation field's value.
func (s *AssociateAddressInput) SetAllowReassociation(v bool) *AssociateAddressInput {
	s.AllowReassociation = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *AssociateAddressInput) SetDryRun(v bool) *AssociateAddressInput {
	s.DryRun = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociateAddressInput) SetInstanceId(v string) *AssociateAddressInput {
	s.InstanceId = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AssociateAddressInput) SetNetworkInterfaceId(v string) *AssociateAddressInput {
	s.NetworkInterfaceId = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *AssociateAddressInput) SetPrivateIpAddress(v string) *AssociateAddressInput {
	s.PrivateIpAddress = &v
	return s
}

// SetPublicIp sets the PublicIp field's value.
func (s *AssociateAddressInput) SetPublicIp(v string) *AssociateAddressInput {
	s.PublicIp = &v
	return s
}

// Contains the output of AssociateAddress.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddressResult
type AssociateAddressOutput struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] The ID that represents the association of the Elastic IP address
	// with an instance.
	AssociationId *string `locationName:"associationId" type:"string"`
}

// String returns the string representation
func (s AssociateAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateAddressOutput) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *AssociateAddressOutput) SetAssociationId(v string) *AssociateAddressOutput {
	s.AssociationId = &v
	return s
}

// Contains the parameters for AssociateDhcpOptions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptionsRequest
type AssociateDhcpOptionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the DHCP options set, or default to associate no DHCP options with
	// the VPC.
	//
	// DhcpOptionsId is a required field
	DhcpOptionsId *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateDhcpOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDhcpOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateDhcpOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateDhcpOptionsInput"}
	if s.DhcpOptionsId == nil {
		invalidParams.Add(request.NewErrParamRequired("DhcpOptionsId"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDhcpOptionsId sets the DhcpOptionsId field's value.
func (s *AssociateDhcpOptionsInput) SetDhcpOptionsId(v string) *AssociateDhcpOptionsInput {
	s.DhcpOptionsId = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *AssociateDhcpOptionsInput) SetDryRun(v bool) *AssociateDhcpOptionsInput {
	s.DryRun = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AssociateDhcpOptionsInput) SetVpcId(v string) *AssociateDhcpOptionsInput {
	s.VpcId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptionsOutput
type AssociateDhcpOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateDhcpOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDhcpOptionsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for AssociateRouteTable.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTableRequest
type AssociateRouteTableInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the route table.
	//
	// RouteTableId is a required field
	RouteTableId *string `locationName:"routeTableId" type:"string" required:"true"`

	// The ID of the subnet.
	//
	// SubnetId is a required field
	SubnetId *string `locationName:"subnetId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateRouteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateRouteTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateRouteTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateRouteTableInput"}
	if s.RouteTableId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteTableId"))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *AssociateRouteTableInput) SetDryRun(v bool) *AssociateRouteTableInput {
	s.DryRun = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *AssociateRouteTableInput) SetRouteTableId(v string) *AssociateRouteTableInput {
	s.RouteTableId = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AssociateRouteTableInput) SetSubnetId(v string) *AssociateRouteTableInput {
	s.SubnetId = &v
	return s
}

// Contains the output of AssociateRouteTable.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTableResult
type AssociateRouteTableOutput struct {
	_ struct{} `type:"structure"`

	// The route table association ID (needed to disassociate the route table).
	AssociationId *string `locationName:"associationId" type:"string"`
}

// String returns the string representation
func (s AssociateRouteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateRouteTableOutput) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *AssociateRouteTableOutput) SetAssociationId(v string) *AssociateRouteTableOutput {
	s.AssociationId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlockRequest
type AssociateSubnetCidrBlockInput struct {
	_ struct{} `type:"structure"`

	// The IPv6 CIDR block for your subnet. The subnet must have a /64 prefix length.
	//
	// Ipv6CidrBlock is a required field
	Ipv6CidrBlock *string `locationName:"ipv6CidrBlock" type:"string" required:"true"`

	// The ID of your subnet.
	//
	// SubnetId is a required field
	SubnetId *string `locationName:"subnetId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateSubnetCidrBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateSubnetCidrBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateSubnetCidrBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateSubnetCidrBlockInput"}
	if s.Ipv6CidrBlock == nil {
		invalidParams.Add(request.NewErrParamRequired("Ipv6CidrBlock"))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpv6CidrBlock sets the Ipv6CidrBlock field's value.
func (s *AssociateSubnetCidrBlockInput) SetIpv6CidrBlock(v string) *AssociateSubnetCidrBlockInput {
	s.Ipv6CidrBlock = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AssociateSubnetCidrBlockInput) SetSubnetId(v string) *AssociateSubnetCidrBlockInput {
	s.SubnetId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlockResult
type AssociateSubnetCidrBlockOutput struct {
	_ struct{} `type:"structure"`

	// Information about the IPv6 CIDR block association.
	Ipv6CidrBlockAssociation *SubnetIpv6CidrBlockAssociation `locationName:"ipv6CidrBlockAssociation" type:"structure"`

	// The ID of the subnet.
	SubnetId *string `locationName:"subnetId" type:"string"`
}

// String returns the string representation
func (s AssociateSubnetCidrBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateSubnetCidrBlockOutput) GoString() string {
	return s.String()
}

// SetIpv6CidrBlockAssociation sets the Ipv6CidrBlockAssociation field's value.
func (s *AssociateSubnetCidrBlockOutput) SetIpv6CidrBlockAssociation(v *SubnetIpv6CidrBlockAssociation) *AssociateSubnetCidrBlockOutput {
	s.Ipv6CidrBlockAssociation = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AssociateSubnetCidrBlockOutput) SetSubnetId(v string) *AssociateSubnetCidrBlockOutput {
	s.SubnetId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlockRequest
type AssociateVpcCidrBlockInput struct {
	_ struct{} `type:"structure"`

	// Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
	// the VPC. You cannot specify the range of IPv6 addresses, or the size of the
	// CIDR block.
	AmazonProvidedIpv6CidrBlock *bool `locationName:"amazonProvidedIpv6CidrBlock" type:"boolean"`

	// The ID of the VPC.
	//
	// VpcId is a required field
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateVpcCidrBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateVpcCidrBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateVpcCidrBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateVpcCidrBlockInput"}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmazonProvidedIpv6CidrBlock sets the AmazonProvidedIpv6CidrBlock field's value.
func (s *AssociateVpcCidrBlockInput) SetAmazonProvidedIpv6CidrBlock(v bool) *AssociateVpcCidrBlockInput {
	s.AmazonProvidedIpv6CidrBlock = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AssociateVpcCidrBlockInput) SetVpcId(v string) *AssociateVpcCidrBlockInput {
	s.VpcId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlockResult
type AssociateVpcCidrBlockOutput struct {
	_ struct{} `type:"structure"`

	// Information about the IPv6 CIDR block association.
	Ipv6CidrBlockAssociation *VpcIpv6CidrBlockAssociation `locationName:"ipv6CidrBlockAssociation" type:"structure"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s AssociateVpcCidrBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateVpcCidrBlockOutput) GoString() string {
	return s.String()
}

// SetIpv6CidrBlockAssociation sets the Ipv6CidrBlockAssociation field's value.
func (s *AssociateVpcCidrBlockOutput) SetIpv6CidrBlockAssociation(v *VpcIpv6CidrBlockAssociation) *AssociateVpcCidrBlockOutput {
	s.Ipv6CidrBlockAssociation = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AssociateVpcCidrBlockOutput) SetVpcId(v string) *AssociateVpcCidrBlockOutput {
	s.VpcId = &v
	return s
}

// Contains the parameters for AttachClassicLinkVpc.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpcRequest
type AttachClassicLinkVpcInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of one or more of the VPC's security groups. You cannot specify security
	// groups from a different VPC.
	//
	// Groups is a required field
	Groups []*string `locationName:"SecurityGroupId" locationNameList:"groupId" type:"list" required:"true"`

	// The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.
	//
	// InstanceId is a required field
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	// The ID of a ClassicLink-enabled VPC.
	//
	// VpcId is a required field
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachClassicLinkVpcInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachClassicLinkVpcInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachClassicLinkVpcInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachClassicLinkVpcInput"}
	if s.Groups == nil {
		invalidParams.Add(request.NewErrParamRequired("Groups"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *AttachClassicLinkVpcInput) SetDryRun(v bool) *AttachClassicLinkVpcInput {
	s.DryRun = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *AttachClassicLinkVpcInput) SetGroups(v []*string) *AttachClassicLinkVpcInput {
	s.Groups = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AttachClassicLinkVpcInput) SetInstanceId(v string) *AttachClassicLinkVpcInput {
	s.InstanceId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AttachClassicLinkVpcInput) SetVpcId(v string) *AttachClassicLinkVpcInput {
	s.VpcId = &v
	return s
}

// Contains the output of AttachClassicLinkVpc.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpcResult
type AttachClassicLinkVpcOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s AttachClassicLinkVpcOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachClassicLinkVpcOutput) GoString() string {
	return s.String()
}

// SetReturn sets the Return field's value.
func (s *AttachClassicLinkVpcOutput) SetReturn(v bool) *AttachClassicLinkVpcOutput {
	s.Return = &v
	return s
}

// Contains the parameters for AttachInternetGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGatewayRequest
type AttachInternetGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the Internet gateway.
	//
	// InternetGatewayId is a required field
	InternetGatewayId *string `locationName:"internetGatewayId" type:"string" required:"true"`

	// The ID of the VPC.
	//
	// VpcId is a required field
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachInternetGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachInternetGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachInternetGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachInternetGatewayInput"}
	if s.InternetGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("InternetGatewayId"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *AttachInternetGatewayInput) SetDryRun(v bool) *AttachInternetGatewayInput {
	s.DryRun = &v
	return s
}

// SetInternetGatewayId sets the InternetGatewayId field's value.
func (s *AttachInternetGatewayInput) SetInternetGatewayId(v string) *AttachInternetGatewayInput {
	s.InternetGatewayId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AttachInternetGatewayInput) SetVpcId(v string) *AttachInternetGatewayInput {
	s.VpcId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGatewayOutput
type AttachInternetGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachInternetGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachInternetGatewayOutput) GoString() string {
	return s.String()
}

// Contains the parameters for AttachNetworkInterface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterfaceRequest
type AttachNetworkInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The index of the device for the network interface attachment.
	//
	// DeviceIndex is a required field
	DeviceIndex *int64 `locationName:"deviceIndex" type:"integer" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	// The ID of the network interface.
	//
	// NetworkInterfaceId is a required field
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachNetworkInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachNetworkInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachNetworkInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachNetworkInterfaceInput"}
	if s.DeviceIndex == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceIndex"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.NetworkInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceIndex sets the DeviceIndex field's value.
func (s *AttachNetworkInterfaceInput) SetDeviceIndex(v int64) *AttachNetworkInterfaceInput {
	s.DeviceIndex = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *AttachNetworkInterfaceInput) SetDryRun(v bool) *AttachNetworkInterfaceInput {
	s.DryRun = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AttachNetworkInterfaceInput) SetInstanceId(v string) *AttachNetworkInterfaceInput {
	s.InstanceId = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AttachNetworkInterfaceInput) SetNetworkInterfaceId(v string) *AttachNetworkInterfaceInput {
	s.NetworkInterfaceId = &v
	return s
}

// Contains the output of AttachNetworkInterface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterfaceResult
type AttachNetworkInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the network interface attachment.
	AttachmentId *string `locationName:"attachmentId" type:"string"`
}

// String returns the string representation
func (s AttachNetworkInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachNetworkInterfaceOutput) GoString() string {
	return s.String()
}

// SetAttachmentId sets the AttachmentId field's value.
func (s *AttachNetworkInterfaceOutput) SetAttachmentId(v string) *AttachNetworkInterfaceOutput {
	s.AttachmentId = &v
	return s
}

// Contains the parameters for AttachVolume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolumeRequest
type AttachVolumeInput struct {
	_ struct{} `type:"structure"`

	// The device name to expose to the instance (for example, /dev/sdh or xvdh).
	//
	// Device is a required field
	Device *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The ID of the EBS volume. The volume and instance must be within the same
	// Availability Zone.
	//
	// VolumeId is a required field
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AttachVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachVolumeInput"}
	if s.Device == nil {
		invalidParams.Add(request.NewErrParamRequired("Device"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.VolumeId == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDevice sets the Device field's value.
func (s *AttachVolumeInput) SetDevice(v string) *AttachVolumeInput {
	s.Device = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *AttachVolumeInput) SetDryRun(v bool) *AttachVolumeInput {
	s.DryRun = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AttachVolumeInput) SetInstanceId(v string) *AttachVolumeInput {
	s.InstanceId = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *AttachVolumeInput) SetVolumeId(v string) *AttachVolumeInput {
	s.VolumeId = &v
	return s
}

// Contains the parameters for AttachVpnGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGatewayRequest
type AttachVpnGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`

	// The ID of the virtual private gateway.
	//
	// VpnGatewayId is a required field
	VpnGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AttachVpnGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachVpnGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachVpnGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachVpnGatewayInput"}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.VpnGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpnGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *AttachVpnGatewayInput) SetDryRun(v bool) *AttachVpnGatewayInput {
	s.DryRun = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AttachVpnGatewayInput) SetVpcId(v string) *AttachVpnGatewayInput {
	s.VpcId = &v
	return s
}

// SetVpnGatewayId sets the VpnGatewayId field's value.
func (s *AttachVpnGatewayInput) SetVpnGatewayId(v string) *AttachVpnGatewayInput {
	s.VpnGatewayId = &v
	return s
}

// Contains the output of AttachVpnGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGatewayResult
type AttachVpnGatewayOutput struct {
	_ struct{} `type:"structure"`

	// Information about the attachment.
	VpcAttachment *VpcAttachment `locationName:"attachment" type:"structure"`
}

// String returns the string representation
func (s AttachVpnGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachVpnGatewayOutput) GoString() string {
	return s.String()
}

// SetVpcAttachment sets the VpcAttachment field's value.
func (s *AttachVpnGatewayOutput) SetVpcAttachment(v *VpcAttachment) *AttachVpnGatewayOutput {
	s.VpcAttachment = v
	return s
}

// Describes a value for a resource attribute that is a Boolean value.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttributeBooleanValue
type AttributeBooleanValue struct {
	_ struct{} `type:"structure"`

	// The attribute value. The valid values are true or false.
	Value *bool `locationName:"value" type:"boolean"`
}

// String returns the string representation
func (s AttributeBooleanValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeBooleanValue) GoString() string {
	return s.String()
}

// SetValue sets the Value field's value.
func (s *AttributeBooleanValue) SetValue(v bool) *AttributeBooleanValue {
	s.Value = &v
	return s
}

// Describes a value for a resource attribute that is a String.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttributeValue
type AttributeValue struct {
	_ struct{} `type:"structure"`

	// The attribute value. Note that the value is case-sensitive.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s AttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeValue) GoString() string {
	return s.String()
}

// SetValue sets the Value field's value.
func (s *AttributeValue) SetValue(v string) *AttributeValue {
	s.Value = &v
	return s
}

// Contains the parameters for AuthorizeSecurityGroupEgress.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgressRequest
type AuthorizeSecurityGroupEgressInput struct {
	_ struct{} `type:"structure"`

	// The CIDR IPv4 address range. We recommend that you specify the CIDR range
	// in a set of IP permissions instead.
	CidrIp *string `locationName:"cidrIp" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The start of port range for the TCP and UDP protocols, or an ICMP type number.
	// We recommend that you specify the port range in a set of IP permissions instead.
	FromPort *int64 `locationName:"fromPort" type:"integer"`

	// The ID of the security group.
	//
	// GroupId is a required field
	GroupId *string `locationName:"groupId" type:"string" required:"true"`

	// A set of IP permissions. You can't specify a destination security group and
	// a CIDR IP address range.
	IpPermissions []*IpPermission `locationName:"ipPermissions" locationNameList:"item" type:"list"`

	// The IP protocol name or number. We recommend that you specify the protocol
	// in a set of IP permissions instead.
	IpProtocol *string `locationName:"ipProtocol" type:"string"`

	// The name of a destination security group. To authorize outbound access to
	// a destination security group, we recommend that you use a set of IP permissions
	// instead.
	SourceSecurityGroupName *string `locationName:"sourceSecurityGroupName" type:"string"`

	// The AWS account number for a destination security group. To authorize outbound
	// access to a destination security group, we recommend that you use a set of
	// IP permissions instead.
	SourceSecurityGroupOwnerId *string `locationName:"sourceSecurityGroupOwnerId" type:"string"`

	// The end of port range for the TCP and UDP protocols, or an ICMP type number.
	// We recommend that you specify the port range in a set of IP permissions instead.
	ToPort *int64 `locationName:"toPort" type:"integer"`
}

// String returns the string representation
func (s AuthorizeSecurityGroupEgressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeSecurityGroupEgressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeSecurityGroupEgressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizeSecurityGroupEgressInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidrIp sets the CidrIp field's value.
func (s *AuthorizeSecurityGroupEgressInput) SetCidrIp(v string) *AuthorizeSecurityGroupEgressInput {
	s.CidrIp = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *AuthorizeSecurityGroupEgressInput) SetDryRun(v bool) *AuthorizeSecurityGroupEgressInput {
	s.DryRun = &v
	return s
}

// SetFromPort sets the FromPort field's value.
func (s *AuthorizeSecurityGroupEgressInput) SetFromPort(v int64) *AuthorizeSecurityGroupEgressInput {
	s.FromPort = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *AuthorizeSecurityGroupEgressInput) SetGroupId(v string) *AuthorizeSecurityGroupEgressInput {
	s.GroupId = &v
	return s
}

// SetIpPermissions sets the IpPermissions field's value.
func (s *AuthorizeSecurityGroupEgressInput) SetIpPermissions(v []*IpPermission) *AuthorizeSecurityGroupEgressInput {
	s.IpPermissions = v
	return s
}

// SetIpProtocol sets the IpProtocol field's value.
func (s *AuthorizeSecurityGroupEgressInput) SetIpProtocol(v string) *AuthorizeSecurityGroupEgressInput {
	s.IpProtocol = &v
	return s
}

// SetSourceSecurityGroupName sets the SourceSecurityGroupName field's value.
func (s *AuthorizeSecurityGroupEgressInput) SetSourceSecurityGroupName(v string) *AuthorizeSecurityGroupEgressInput {
	s.SourceSecurityGroupName = &v
	return s
}

// SetSourceSecurityGroupOwnerId sets the SourceSecurityGroupOwnerId field's value.
func (s *AuthorizeSecurityGroupEgressInput) SetSourceSecurityGroupOwnerId(v string) *AuthorizeSecurityGroupEgressInput {
	s.SourceSecurityGroupOwnerId = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *AuthorizeSecurityGroupEgressInput) SetToPort(v int64) *AuthorizeSecurityGroupEgressInput {
	s.ToPort = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgressOutput
type AuthorizeSecurityGroupEgressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AuthorizeSecurityGroupEgressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeSecurityGroupEgressOutput) GoString() string {
	return s.String()
}

// Contains the parameters for AuthorizeSecurityGroupIngress.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngressRequest
type AuthorizeSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The CIDR IPv4 address range. You can't specify this parameter when specifying
	// a source security group.
	CidrIp *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// type number. For the ICMP/ICMPv6 type number, use -1 to specify all types.
	FromPort *int64 `type:"integer"`

	// The ID of the security group. Required for a nondefault VPC.
	GroupId *string `type:"string"`

	// [EC2-Classic, default VPC] The name of the security group.
	GroupName *string `type:"string"`

	// A set of IP permissions. Can be used to specify multiple rules in a single
	// command.
	IpPermissions []*IpPermission `locationNameList:"item" type:"list"`

	// The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers (http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)).
	// (VPC only) Use -1 to specify all protocols. If you specify -1, or a protocol
	// number other than tcp, udp, icmp, or 58 (ICMPv6), traffic on all ports is
	// allowed, regardless of any ports you specify. For tcp, udp, and icmp, you
	// must specify a port range. For protocol 58 (ICMPv6), you can optionally specify
	// a port range; if you don't, traffic for all types and codes is allowed.
	IpProtocol *string `type:"string"`

	// [EC2-Classic, default VPC] The name of the source security group. You can't
	// specify this parameter in combination with the following parameters: the
	// CIDR IP address range, the start of the port range, the IP protocol, and
	// the end of the port range. Creates rules that grant full ICMP, UDP, and TCP
	// access. To create a rule with a specific IP protocol and port range, use
	// a set of IP permissions instead. For EC2-VPC, the source security group must
	// be in the same VPC.
	SourceSecurityGroupName *string `type:"string"`

	// [EC2-Classic] The AWS account number for the source security group, if the
	// source security group is in a different account. You can't specify this parameter
	// in combination with the following parameters: the CIDR IP address range,
	// the IP protocol, the start of the port range, and the end of the port range.
	// Creates rules that grant full ICMP, UDP, and TCP access. To create a rule
	// with a specific IP protocol and port range, use a set of IP permissions instead.
	SourceSecurityGroupOwnerId *string `type:"string"`

	// The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code
	// number. For the ICMP/ICMPv6 code number, use -1 to specify all codes.
	ToPort *int64 `type:"integer"`
}

// String returns the string representation
func (s AuthorizeSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeSecurityGroupIngressInput) GoString() string {
	return s.String()
}

// SetCidrIp sets the CidrIp field's value.
func (s *AuthorizeSecurityGroupIngressInput) SetCidrIp(v string) *AuthorizeSecurityGroupIngressInput {
	s.CidrIp = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *AuthorizeSecurityGroupIngressInput) SetDryRun(v bool) *AuthorizeSecurityGroupIngressInput {
	s.DryRun = &v
	return s
}

// SetFromPort sets the FromPort field's value.
func (s *AuthorizeSecurityGroupIngressInput) SetFromPort(v int64) *AuthorizeSecurityGroupIngressInput {
	s.FromPort = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *AuthorizeSecurityGroupIngressInput) SetGroupId(v string) *AuthorizeSecurityGroupIngressInput {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AuthorizeSecurityGroupIngressInput) SetGroupName(v string) *AuthorizeSecurityGroupIngressInput {
	s.GroupName = &v
	return s
}

// SetIpPermissions sets the IpPermissions field's value.
func (s *AuthorizeSecurityGroupIngressInput) SetIpPermissions(v []*IpPermission) *AuthorizeSecurityGroupIngressInput {
	s.IpPermissions = v
	return s
}

// SetIpProtocol sets the IpProtocol field's value.
func (s *AuthorizeSecurityGroupIngressInput) SetIpProtocol(v string) *AuthorizeSecurityGroupIngressInput {
	s.IpProtocol = &v
	return s
}

// SetSourceSecurityGroupName sets the SourceSecurityGroupName field's value.
func (s *AuthorizeSecurityGroupIngressInput) SetSourceSecurityGroupName(v string) *AuthorizeSecurityGroupIngressInput {
	s.SourceSecurityGroupName = &v
	return s
}

// SetSourceSecurityGroupOwnerId sets the SourceSecurityGroupOwnerId field's value.
func (s *AuthorizeSecurityGroupIngressInput) SetSourceSecurityGroupOwnerId(v string) *AuthorizeSecurityGroupIngressInput {
	s.SourceSecurityGroupOwnerId = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *AuthorizeSecurityGroupIngressInput) SetToPort(v int64) *AuthorizeSecurityGroupIngressInput {
	s.ToPort = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngressOutput
type AuthorizeSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AuthorizeSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// Describes an Availability Zone.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailabilityZone
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// Any messages about the Availability Zone.
	Messages []*AvailabilityZoneMessage `locationName:"messageSet" locationNameList:"item" type:"list"`

	// The name of the region.
	RegionName *string `locationName:"regionName" type:"string"`

	// The state of the Availability Zone.
	State *string `locationName:"zoneState" type:"string" enum:"AvailabilityZoneState"`

	// The name of the Availability Zone.
	ZoneName *string `locationName:"zoneName" type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetMessages sets the Messages field's value.
func (s *AvailabilityZone) SetMessages(v []*AvailabilityZoneMessage) *AvailabilityZone {
	s.Messages = v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *AvailabilityZone) SetRegionName(v string) *AvailabilityZone {
	s.RegionName = &v
	return s
}

// SetState sets the State field's value.
func (s *AvailabilityZone) SetState(v string) *AvailabilityZone {
	s.State = &v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *AvailabilityZone) SetZoneName(v string) *AvailabilityZone {
	s.ZoneName = &v
	return s
}

// Describes a message about an Availability Zone.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailabilityZoneMessage
type AvailabilityZoneMessage struct {
	_ struct{} `type:"structure"`

	// The message about the Availability Zone.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AvailabilityZoneMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZoneMessage) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *AvailabilityZoneMessage) SetMessage(v string) *AvailabilityZoneMessage {
	s.Message = &v
	return s
}

// The capacity information for instances launched onto the Dedicated Host.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailableCapacity
type AvailableCapacity struct {
	_ struct{} `type:"structure"`

	// The total number of instances that the Dedicated Host supports.
	AvailableInstanceCapacity []*InstanceCapacity `locationName:"availableInstanceCapacity" locationNameList:"item" type:"list"`

	// The number of vCPUs available on the Dedicated Host.
	AvailableVCpus *int64 `locationName:"availableVCpus" type:"integer"`
}

// String returns the string representation
func (s AvailableCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailableCapacity) GoString() string {
	return s.String()
}

// SetAvailableInstanceCapacity sets the AvailableInstanceCapacity field's value.
func (s *AvailableCapacity) SetAvailableInstanceCapacity(v []*InstanceCapacity) *AvailableCapacity {
	s.AvailableInstanceCapacity = v
	return s
}

// SetAvailableVCpus sets the AvailableVCpus field's value.
func (s *AvailableCapacity) SetAvailableVCpus(v int64) *AvailableCapacity {
	s.AvailableVCpus = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BlobAttributeValue
type BlobAttributeValue struct {
	_ struct{} `type:"structure"`

	// Value is automatically base64 encoded/decoded by the SDK.
	Value []byte `locationName:"value" type:"blob"`
}

// String returns the string representation
func (s BlobAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlobAttributeValue) GoString() string {
	return s.String()
}

// SetValue sets the Value field's value.
func (s *BlobAttributeValue) SetValue(v []byte) *BlobAttributeValue {
	s.Value = v
	return s
}

// Describes a block device mapping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BlockDeviceMapping
type BlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device name exposed to the instance (for example, /dev/sdh or xvdh).
	DeviceName *string `locationName:"deviceName" type:"string"`

	// Parameters used to automatically set up EBS volumes when the instance is
	// launched.
	Ebs *EbsBlockDevice `locationName:"ebs" type:"structure"`

	// Suppresses the specified device included in the block device mapping of the
	// AMI.
	NoDevice *string `locationName:"noDevice" type:"string"`

	// The virtual device name (ephemeralN). Instance store volumes are numbered
	// starting from 0. An instance type with 2 available instance store volumes
	// can specify mappings for ephemeral0 and ephemeral1.The number of available
	// instance store volumes depends on the instance type. After you connect to
	// the instance, you must mount the volume.
	//
	// Constraints: For M3 instances, you must specify instance store volumes in
	// the block device mapping for the instance. When you launch an M3 instance,
	// we ignore any instance store volumes specified in the block device mapping
	// for the AMI.
	VirtualName *string `locationName:"virtualName" type:"string"`
}

// String returns the string representation
func (s BlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockDeviceMapping) GoString() string {
	return s.String()
}

// SetDeviceName sets the DeviceName field's value.
func (s *BlockDeviceMapping) SetDeviceName(v string) *BlockDeviceMapping {
	s.DeviceName = &v
	return s
}

// SetEbs sets the Ebs field's value.
func (s *BlockDeviceMapping) SetEbs(v *EbsBlockDevice) *BlockDeviceMapping {
	s.Ebs = v
	return s
}

// SetNoDevice sets the NoDevice field's value.
func (s *BlockDeviceMapping) SetNoDevice(v string) *BlockDeviceMapping {
	s.NoDevice = &v
	return s
}

// SetVirtualName sets the VirtualName field's value.
func (s *BlockDeviceMapping) SetVirtualName(v string) *BlockDeviceMapping {
	s.VirtualName = &v
	return s
}

// Contains the parameters for BundleInstance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstanceRequest
type BundleInstanceInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance to bundle.
	//
	// Type: String
	//
	// Default: None
	//
	// Required: Yes
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The bucket in which to store the AMI. You can specify a bucket that you already
	// own or a new bucket that Amazon EC2 creates on your behalf. If you specify
	// a bucket that belongs to someone else, Amazon EC2 returns an error.
	//
	// Storage is a required field
	Storage *Storage `type:"structure" required:"true"`
}

// String returns the string representation
func (s BundleInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BundleInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BundleInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BundleInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Storage == nil {
		invalidParams.Add(request.NewErrParamRequired("Storage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *BundleInstanceInput) SetDryRun(v bool) *BundleInstanceInput {
	s.DryRun = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *BundleInstanceInput) SetInstanceId(v string) *BundleInstanceInput {
	s.InstanceId = &v
	return s
}

// SetStorage sets the Storage field's value.
func (s *BundleInstanceInput) SetStorage(v *Storage) *BundleInstanceInput {
	s.Storage = v
	return s
}

// Contains the output of BundleInstance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstanceResult
type BundleInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the bundle task.
	BundleTask *BundleTask `locationName:"bundleInstanceTask" type:"structure"`
}

// String returns the string representation
func (s BundleInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BundleInstanceOutput) GoString() string {
	return s.String()
}

// SetBundleTask sets the BundleTask field's value.
func (s *BundleInstanceOutput) SetBundleTask(v *BundleTask) *BundleInstanceOutput {
	s.BundleTask = v
	return s
}

// Describes a bundle task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleTask
type BundleTask struct {
	_ struct{} `type:"structure"`

	// The ID of the bundle task.
	BundleId *string `locationName:"bundleId" type:"string"`

	// If the task fails, a description of the error.
	BundleTaskError *BundleTaskError `locationName:"error" type:"structure"`

	// The ID of the instance associated with this bundle task.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The level of task completion, as a percent (for example, 20%).
	Progress *string `locationName:"progress" type:"string"`

	// The time this task started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// The state of the task.
	State *string `locationName:"state" type:"string" enum:"BundleTaskState"`

	// The Amazon S3 storage locations.
	Storage *Storage `locationName:"storage" type:"structure"`

	// The time of the most recent update for the task.
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s BundleTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BundleTask) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *BundleTask) SetBundleId(v string) *BundleTask {
	s.BundleId = &v
	return s
}

// SetBundleTaskError sets the BundleTaskError field's value.
func (s *BundleTask) SetBundleTaskError(v *BundleTaskError) *BundleTask {
	s.BundleTaskError = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *BundleTask) SetInstanceId(v string) *BundleTask {
	s.InstanceId = &v
	return s
}

// SetProgress sets the Progress field's value.
func (s *BundleTask) SetProgress(v string) *BundleTask {
	s.Progress = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *BundleTask) SetStartTime(v time.Time) *BundleTask {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *BundleTask) SetState(v string) *BundleTask {
	s.State = &v
	return s
}

// SetStorage sets the Storage field's value.
func (s *BundleTask) SetStorage(v *Storage) *BundleTask {
	s.Storage = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *BundleTask) SetUpdateTime(v time.Time) *BundleTask {
	s.UpdateTime = &v
	return s
}

// Describes an error for BundleInstance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleTaskError
type BundleTaskError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *string `locationName:"code" type:"string"`

	// The error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BundleTaskError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BundleTaskError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BundleTaskError) SetCode(v string) *BundleTaskError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BundleTaskError) SetMessage(v string) *BundleTaskError {
	s.Message = &v
	return s
}

// Contains the parameters for CancelBundleTask.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTaskRequest
type CancelBundleTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the bundle task.
	//
	// BundleId is a required field
	BundleId *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s CancelBundleTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelBundleTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelBundleTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelBundleTaskInput"}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *CancelBundleTaskInput) SetBundleId(v string) *CancelBundleTaskInput {
	s.BundleId = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CancelBundleTaskInput) SetDryRun(v bool) *CancelBundleTaskInput {
	s.DryRun = &v
	return s
}

// Contains the output of CancelBundleTask.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTaskResult
type CancelBundleTaskOutput struct {
	_ struct{} `type:"structure"`

	// Information about the bundle task.
	BundleTask *BundleTask `locationName:"bundleInstanceTask" type:"structure"`
}

// String returns the string representation
func (s CancelBundleTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelBundleTaskOutput) GoString() string {
	return s.String()
}

// SetBundleTask sets the BundleTask field's value.
func (s *CancelBundleTaskOutput) SetBundleTask(v *BundleTask) *CancelBundleTaskOutput {
	s.BundleTask = v
	return s
}

// Contains the parameters for CancelConversionTask.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionRequest
type CancelConversionTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the conversion task.
	//
	// ConversionTaskId is a required field
	ConversionTaskId *string `locationName:"conversionTaskId" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The reason for canceling the conversion task.
	ReasonMessage *string `locationName:"reasonMessage" type:"string"`
}

// String returns the string representation
func (s CancelConversionTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelConversionTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelConversionTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelConversionTaskInput"}
	if s.ConversionTaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConversionTaskId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConversionTaskId sets the ConversionTaskId field's value.
func (s *CancelConversionTaskInput) SetConversionTaskId(v string) *CancelConversionTaskInput {
	s.ConversionTaskId = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CancelConversionTaskInput) SetDryRun(v bool) *CancelConversionTaskInput {
	s.DryRun = &v
	return s
}

// SetReasonMessage sets the ReasonMessage field's value.
func (s *CancelConversionTaskInput) SetReasonMessage(v string) *CancelConversionTaskInput {
	s.ReasonMessage = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTaskOutput
type CancelConversionTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelConversionTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelConversionTaskOutput) GoString() string {
	return s.String()
}

// Contains the parameters for CancelExportTask.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTaskRequest
type CancelExportTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the export task. This is the ID returned by CreateInstanceExportTask.
	//
	// ExportTaskId is a required field
	ExportTaskId *string `locationName:"exportTaskId" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelExportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelExportTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelExportTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelExportTaskInput"}
	if s.ExportTaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportTaskId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportTaskId sets the ExportTaskId field's value.
func (s *CancelExportTaskInput) SetExportTaskId(v string) *CancelExportTaskInput {
	s.ExportTaskId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTaskOutput
type CancelExportTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelExportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelExportTaskOutput) GoString() string {
	return s.String()
}

// Contains the parameters for CancelImportTask.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTaskRequest
type CancelImportTaskInput struct {
	_ struct{} `type:"structure"`

	// The reason for canceling the task.
	CancelReason *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the import image or import snapshot task to be canceled.
	ImportTaskId *string `type:"string"`
}

// String returns the string representation
func (s CancelImportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelImportTaskInput) GoString() string {
	return s.String()
}

// SetCancelReason sets the CancelReason field's value.
func (s *CancelImportTaskInput) SetCancelReason(v string) *CancelImportTaskInput {
	s.CancelReason = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CancelImportTaskInput) SetDryRun(v bool) *CancelImportTaskInput {
	s.DryRun = &v
	return s
}

// SetImportTaskId sets the ImportTaskId field's value.
func (s *CancelImportTaskInput) SetImportTaskId(v string) *CancelImportTaskInput {
	s.ImportTaskId = &v
	return s
}

// Contains the output for CancelImportTask.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTaskResult
type CancelImportTaskOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the task being canceled.
	ImportTaskId *string `locationName:"importTaskId" type:"string"`

	// The current state of the task being canceled.
	PreviousState *string `locationName:"previousState" type:"string"`

	// The current state of the task being canceled.
	State *string `locationName:"state" type:"string"`
}

// String returns the string representation
func (s CancelImportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelImportTaskOutput) GoString() string {
	return s.String()
}

// SetImportTaskId sets the ImportTaskId field's value.
func (s *CancelImportTaskOutput) SetImportTaskId(v string) *CancelImportTaskOutput {
	s.ImportTaskId = &v
	return s
}

// SetPreviousState sets the PreviousState field's value.
func (s *CancelImportTaskOutput) SetPreviousState(v string) *CancelImportTaskOutput {
	s.PreviousState = &v
	return s
}

// SetState sets the State field's value.
func (s *CancelImportTaskOutput) SetState(v string) *CancelImportTaskOutput {
	s.State = &v
	return s
}

// Contains the parameters for CancelReservedInstancesListing.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListingRequest
type CancelReservedInstancesListingInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Reserved Instance listing.
	//
	// ReservedInstancesListingId is a required field
	ReservedInstancesListingId *string `locationName:"reservedInstancesListingId" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelReservedInstancesListingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelReservedInstancesListingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelReservedInstancesListingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelReservedInstancesListingInput"}
	if s.ReservedInstancesListingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedInstancesListingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReservedInstancesListingId sets the ReservedInstancesListingId field's value.
func (s *CancelReservedInstancesListingInput) SetReservedInstancesListingId(v string) *CancelReservedInstancesListingInput {
	s.ReservedInstancesListingId = &v
	return s
}

// Contains the output of CancelReservedInstancesListing.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListingResult
type CancelReservedInstancesListingOutput struct {
	_ struct{} `type:"structure"`

	// The Reserved Instance listing.
	ReservedInstancesListings []*ReservedInstancesListing `locationName:"reservedInstancesListingsSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CancelReservedInstancesListingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelReservedInstancesListingOutput) GoString() string {
	return s.String()
}

// SetReservedInstancesListings sets the ReservedInstancesListings field's value.
func (s *CancelReservedInstancesListingOutput) SetReservedInstancesListings(v []*ReservedInstancesListing) *CancelReservedInstancesListingOutput {
	s.ReservedInstancesListings = v
	return s
}

// Describes a Spot fleet error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsError
type CancelSpotFleetRequestsError struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"CancelBatchErrorCode"`

	// The description for the error code.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelSpotFleetRequestsError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSpotFleetRequestsError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *CancelSpotFleetRequestsError) SetCode(v string) *CancelSpotFleetRequestsError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *CancelSpotFleetRequestsError) SetMessage(v string) *CancelSpotFleetRequestsError {
	s.Message = &v
	return s
}

// Describes a Spot fleet request that was not successfully canceled.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsErrorItem
type CancelSpotFleetRequestsErrorItem struct {
	_ struct{} `type:"structure"`

	// The error.
	//
	// Error is a required field
	Error *CancelSpotFleetRequestsError `locationName:"error" type:"structure" required:"true"`

	// The ID of the Spot fleet request.
	//
	// SpotFleetRequestId is a required field
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelSpotFleetRequestsErrorItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSpotFleetRequestsErrorItem) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *CancelSpotFleetRequestsErrorItem) SetError(v *CancelSpotFleetRequestsError) *CancelSpotFleetRequestsErrorItem {
	s.Error = v
	return s
}

// SetSpotFleetRequestId sets the SpotFleetRequestId field's value.
func (s *CancelSpotFleetRequestsErrorItem) SetSpotFleetRequestId(v string) *CancelSpotFleetRequestsErrorItem {
	s.SpotFleetRequestId = &v
	return s
}

// Contains the parameters for CancelSpotFleetRequests.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsRequest
type CancelSpotFleetRequestsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The IDs of the Spot fleet requests.
	//
	// SpotFleetRequestIds is a required field
	SpotFleetRequestIds []*string `locationName:"spotFleetRequestId" locationNameList:"item" type:"list" required:"true"`

	// Indicates whether to terminate instances for a Spot fleet request if it is
	// canceled successfully.
	//
	// TerminateInstances is a required field
	TerminateInstances *bool `locationName:"terminateInstances" type:"boolean" required:"true"`
}

// String returns the string representation
func (s CancelSpotFleetRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSpotFleetRequestsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelSpotFleetRequestsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelSpotFleetRequestsInput"}
	if s.SpotFleetRequestIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SpotFleetRequestIds"))
	}
	if s.TerminateInstances == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminateInstances"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *CancelSpotFleetRequestsInput) SetDryRun(v bool) *CancelSpotFleetRequestsInput {
	s.DryRun = &v
	return s
}

// SetSpotFleetRequestIds sets the SpotFleetRequestIds field's value.
func (s *CancelSpotFleetRequestsInput) SetSpotFleetRequestIds(v []*string) *CancelSpotFleetRequestsInput {
	s.SpotFleetRequestIds = v
	return s
}

// SetTerminateInstances sets the TerminateInstances field's value.
func (s *CancelSpotFleetRequestsInput) SetTerminateInstances(v bool) *CancelSpotFleetRequestsInput {
	s.TerminateInstances = &v
	return s
}

// Contains the output of CancelSpotFleetRequests.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsResponse
type CancelSpotFleetRequestsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Spot fleet requests that are successfully canceled.
	SuccessfulFleetRequests []*CancelSpotFleetRequestsSuccessItem `locationName:"successfulFleetRequestSet" locationNameList:"item" type:"list"`

	// Information about the Spot fleet requests that are not successfully canceled.
	UnsuccessfulFleetRequests []*CancelSpotFleetRequestsErrorItem `locationName:"unsuccessfulFleetRequestSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CancelSpotFleetRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSpotFleetRequestsOutput) GoString() string {
	return s.String()
}

// SetSuccessfulFleetRequests sets the SuccessfulFleetRequests field's value.
func (s *CancelSpotFleetRequestsOutput) SetSuccessfulFleetRequests(v []*CancelSpotFleetRequestsSuccessItem) *CancelSpotFleetRequestsOutput {
	s.SuccessfulFleetRequests = v
	return s
}

// SetUnsuccessfulFleetRequests sets the UnsuccessfulFleetRequests field's value.
func (s *CancelSpotFleetRequestsOutput) SetUnsuccessfulFleetRequests(v []*CancelSpotFleetRequestsErrorItem) *CancelSpotFleetRequestsOutput {
	s.UnsuccessfulFleetRequests = v
	return s
}

// Describes a Spot fleet request that was successfully canceled.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsSuccessItem
type CancelSpotFleetRequestsSuccessItem struct {
	_ struct{} `type:"structure"`

	// The current state of the Spot fleet request.
	//
	// CurrentSpotFleetRequestState is a required field
	CurrentSpotFleetRequestState *string `locationName:"currentSpotFleetRequestState" type:"string" required:"true" enum:"BatchState"`

	// The previous state of the Spot fleet request.
	//
	// PreviousSpotFleetRequestState is a required field
	PreviousSpotFleetRequestState *string `locationName:"previousSpotFleetRequestState" type:"string" required:"true" enum:"BatchState"`

	// The ID of the Spot fleet request.
	//
	// SpotFleetRequestId is a required field
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelSpotFleetRequestsSuccessItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSpotFleetRequestsSuccessItem) GoString() string {
	return s.String()
}

// SetCurrentSpotFleetRequestState sets the CurrentSpotFleetRequestState field's value.
func (s *CancelSpotFleetRequestsSuccessItem) SetCurrentSpotFleetRequestState(v string) *CancelSpotFleetRequestsSuccessItem {
	s.CurrentSpotFleetRequestState = &v
	return s
}

// SetPreviousSpotFleetRequestState sets the PreviousSpotFleetRequestState field's value.
func (s *CancelSpotFleetRequestsSuccessItem) SetPreviousSpotFleetRequestState(v string) *CancelSpotFleetRequestsSuccessItem {
	s.PreviousSpotFleetRequestState = &v
	return s
}

// SetSpotFleetRequestId sets the SpotFleetRequestId field's value.
func (s *CancelSpotFleetRequestsSuccessItem) SetSpotFleetRequestId(v string) *CancelSpotFleetRequestsSuccessItem {
	s.SpotFleetRequestId = &v
	return s
}

// Contains the parameters for CancelSpotInstanceRequests.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequestsRequest
type CancelSpotInstanceRequestsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more Spot instance request IDs.
	//
	// SpotInstanceRequestIds is a required field
	SpotInstanceRequestIds []*string `locationName:"SpotInstanceRequestId" locationNameList:"SpotInstanceRequestId" type:"list" required:"true"`
}

// String returns the string representation
func (s CancelSpotInstanceRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSpotInstanceRequestsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelSpotInstanceRequestsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelSpotInstanceRequestsInput"}
	if s.SpotInstanceRequestIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SpotInstanceRequestIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *CancelSpotInstanceRequestsInput) SetDryRun(v bool) *CancelSpotInstanceRequestsInput {
	s.DryRun = &v
	return s
}

// SetSpotInstanceRequestIds sets the SpotInstanceRequestIds field's value.
func (s *CancelSpotInstanceRequestsInput) SetSpotInstanceRequestIds(v []*string) *CancelSpotInstanceRequestsInput {
	s.SpotInstanceRequestIds = v
	return s
}

// Contains the output of CancelSpotInstanceRequests.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequestsResult
type CancelSpotInstanceRequestsOutput struct {
	_ struct{} `type:"structure"`

	// One or more Spot instance requests.
	CancelledSpotInstanceRequests []*CancelledSpotInstanceRequest `locationName:"spotInstanceRequestSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CancelSpotInstanceRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSpotInstanceRequestsOutput) GoString() string {
	return s.String()
}

// SetCancelledSpotInstanceRequests sets the CancelledSpotInstanceRequests field's value.
func (s *CancelSpotInstanceRequestsOutput) SetCancelledSpotInstanceRequests(v []*CancelledSpotInstanceRequest) *CancelSpotInstanceRequestsOutput {
	s.CancelledSpotInstanceRequests = v
	return s
}

// Describes a request to cancel a Spot instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelledSpotInstanceRequest
type CancelledSpotInstanceRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the Spot instance request.
	SpotInstanceRequestId *string `locationName:"spotInstanceRequestId" type:"string"`

	// The state of the Spot instance request.
	State *string `locationName:"state" type:"string" enum:"CancelSpotInstanceRequestState"`
}

// String returns the string representation
func (s CancelledSpotInstanceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelledSpotInstanceRequest) GoString() string {
	return s.String()
}

// SetSpotInstanceRequestId sets the SpotInstanceRequestId field's value.
func (s *CancelledSpotInstanceRequest) SetSpotInstanceRequestId(v string) *CancelledSpotInstanceRequest {
	s.SpotInstanceRequestId = &v
	return s
}

// SetState sets the State field's value.
func (s *CancelledSpotInstanceRequest) SetState(v string) *CancelledSpotInstanceRequest {
	s.State = &v
	return s
}

// Describes the ClassicLink DNS support status of a VPC.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClassicLinkDnsSupport
type ClassicLinkDnsSupport struct {
	_ struct{} `type:"structure"`

	// Indicates whether ClassicLink DNS support is enabled for the VPC.
	ClassicLinkDnsSupported *bool `locationName:"classicLinkDnsSupported" type:"boolean"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s ClassicLinkDnsSupport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClassicLinkDnsSupport) GoString() string {
	return s.String()
}

// SetClassicLinkDnsSupported sets the ClassicLinkDnsSupported field's value.
func (s *ClassicLinkDnsSupport) SetClassicLinkDnsSupported(v bool) *ClassicLinkDnsSupport {
	s.ClassicLinkDnsSupported = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ClassicLinkDnsSupport) SetVpcId(v string) *ClassicLinkDnsSupport {
	s.VpcId = &v
	return s
}

// Describes a linked EC2-Classic instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClassicLinkInstance
type ClassicLinkInstance struct {
	_ struct{} `type:"structure"`

	// A list of security groups.
	Groups []*GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// Any tags assigned to the instance.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s ClassicLinkInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClassicLinkInstance) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *ClassicLinkInstance) SetGroups(v []*GroupIdentifier) *ClassicLinkInstance {
	s.Groups = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ClassicLinkInstance) SetInstanceId(v string) *ClassicLinkInstance {
	s.InstanceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ClassicLinkInstance) SetTags(v []*Tag) *ClassicLinkInstance {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ClassicLinkInstance) SetVpcId(v string) *ClassicLinkInstance {
	s.VpcId = &v
	return s
}

// Describes the client-specific data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientData
type ClientData struct {
	_ struct{} `type:"structure"`

	// A user-defined comment about the disk upload.
	Comment *string `type:"string"`

	// The time that the disk upload ends.
	UploadEnd *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The size of the uploaded disk image, in GiB.
	UploadSize *float64 `type:"double"`

	// The time that the disk upload starts.
	UploadStart *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ClientData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClientData) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *ClientData) SetComment(v string) *ClientData {
	s.Comment = &v
	return s
}

// SetUploadEnd sets the UploadEnd field's value.
func (s *ClientData) SetUploadEnd(v time.Time) *ClientData {
	s.UploadEnd = &v
	return s
}

// SetUploadSize sets the UploadSize field's value.
func (s *ClientData) SetUploadSize(v float64) *ClientData {
	s.UploadSize = &v
	return s
}

// SetUploadStart sets the UploadStart field's value.
func (s *ClientData) SetUploadStart(v time.Time) *ClientData {
	s.UploadStart = &v
	return s
}

// Contains the parameters for ConfirmProductInstance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstanceRequest
type ConfirmProductInstanceInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The product code. This must be a product code that you own.
	//
	// ProductCode is a required field
	ProductCode *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmProductInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmProductInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmProductInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmProductInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.ProductCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *ConfirmProductInstanceInput) SetDryRun(v bool) *ConfirmProductInstanceInput {
	s.DryRun = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ConfirmProductInstanceInput) SetInstanceId(v string) *ConfirmProductInstanceInput {
	s.InstanceId = &v
	return s
}

// SetProductCode sets the ProductCode field's value.
func (s *ConfirmProductInstanceInput) SetProductCode(v string) *ConfirmProductInstanceInput {
	s.ProductCode = &v
	return s
}

// Contains the output of ConfirmProductInstance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstanceResult
type ConfirmProductInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the instance owner. This is only present if the product
	// code is attached to the instance.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The return value of the request. Returns true if the specified product code
	// is owned by the requester and associated with the specified instance.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s ConfirmProductInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmProductInstanceOutput) GoString() string {
	return s.String()
}

// SetOwnerId sets the OwnerId field's value.
func (s *ConfirmProductInstanceOutput) SetOwnerId(v string) *ConfirmProductInstanceOutput {
	s.OwnerId = &v
	return s
}

// SetReturn sets the Return field's value.
func (s *ConfirmProductInstanceOutput) SetReturn(v bool) *ConfirmProductInstanceOutput {
	s.Return = &v
	return s
}

// Describes a conversion task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConversionTask
type ConversionTask struct {
	_ struct{} `type:"structure"`

	// The ID of the conversion task.
	//
	// ConversionTaskId is a required field
	ConversionTaskId *string `locationName:"conversionTaskId" type:"string" required:"true"`

	// The time when the task expires. If the upload isn't complete before the expiration
	// time, we automatically cancel the task.
	ExpirationTime *string `locationName:"expirationTime" type:"string"`

	// If the task is for importing an instance, this contains information about
	// the import instance task.
	ImportInstance *ImportInstanceTaskDetails `locationName:"importInstance" type:"structure"`

	// If the task is for importing a volume, this contains information about the
	// import volume task.
	ImportVolume *ImportVolumeTaskDetails `locationName:"importVolume" type:"structure"`

	// The state of the conversion task.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"ConversionTaskState"`

	// The status message related to the conversion task.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// Any tags assigned to the task.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s ConversionTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConversionTask) GoString() string {
	return s.String()
}

// SetConversionTaskId sets the ConversionTaskId field's value.
func (s *ConversionTask) SetConversionTaskId(v string) *ConversionTask {
	s.ConversionTaskId = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *ConversionTask) SetExpirationTime(v string) *ConversionTask {
	s.ExpirationTime = &v
	return s
}

// SetImportInstance sets the ImportInstance field's value.
func (s *ConversionTask) SetImportInstance(v *ImportInstanceTaskDetails) *ConversionTask {
	s.ImportInstance = v
	return s
}

// SetImportVolume sets the ImportVolume field's value.
func (s *ConversionTask) SetImportVolume(v *ImportVolumeTaskDetails) *ConversionTask {
	s.ImportVolume = v
	return s
}

// SetState sets the State field's value.
func (s *ConversionTask) SetState(v string) *ConversionTask {
	s.State = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ConversionTask) SetStatusMessage(v string) *ConversionTask {
	s.StatusMessage = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ConversionTask) SetTags(v []*Tag) *ConversionTask {
	s.Tags = v
	return s
}

// Contains the parameters for CopyImage.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImageRequest
type CopyImageInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure idempotency of the
	// request. For more information, see How to Ensure Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClientToken *string `type:"string"`

	// A description for the new AMI in the destination region.
	Description *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Specifies whether the destination snapshots of the copied image should be
	// encrypted. The default CMK for EBS is used unless a non-default AWS Key Management
	// Service (AWS KMS) CMK is specified with KmsKeyId. For more information, see
	// Amazon EBS Encryption (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The full ARN of the AWS Key Management Service (AWS KMS) CMK to use when
	// encrypting the snapshots of an image during a copy operation. This parameter
	// is only required if you want to use a non-default CMK; if this parameter
	// is not specified, the default CMK for EBS is used. The ARN contains the arn:aws:kms
	// namespace, followed by the region of the CMK, the AWS account ID of the CMK
	// owner, the key namespace, and then the CMK ID. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.
	// The specified CMK must exist in the region that the snapshot is being copied
	// to. If a KmsKeyId is specified, the Encrypted flag must also be set.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The name of the new AMI in the destination region.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The ID of the AMI to copy.
	//
	// SourceImageId is a required field
	SourceImageId *string `type:"string" required:"true"`

	// The name of the region that contains the AMI to copy.
	//
	// SourceRegion is a required field
	SourceRegion *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyImageInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SourceImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceImageId"))
	}
	if s.SourceRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceRegion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CopyImageInput) SetClientToken(v string) *CopyImageInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CopyImageInput) SetDescription(v string) *CopyImageInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CopyImageInput) SetDryRun(v bool) *CopyImageInput {
	s.DryRun = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *CopyImageInput) SetEncrypted(v bool) *CopyImageInput {
	s.Encrypted = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CopyImageInput) SetKmsKeyId(v string) *CopyImageInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CopyImageInput) SetName(v string) *CopyImageInput {
	s.Name = &v
	return s
}

// SetSourceImageId sets the SourceImageId field's value.
func (s *CopyImageInput) SetSourceImageId(v string) *CopyImageInput {
	s.SourceImageId = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CopyImageInput) SetSourceRegion(v string) *CopyImageInput {
	s.SourceRegion = &v
	return s
}

// Contains the output of CopyImage.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImageResult
type CopyImageOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the new AMI.
	ImageId *string `locationName:"imageId" type:"string"`
}

// String returns the string representation
func (s CopyImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyImageOutput) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *CopyImageOutput) SetImageId(v string) *CopyImageOutput {
	s.ImageId = &v
	return s
}

// Contains the parameters for CopySnapshot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshotRequest
type CopySnapshotInput struct {
	_ struct{} `type:"structure"`

	// A description for the EBS snapshot.
	Description *string `type:"string"`

	// The destination region to use in the PresignedUrl parameter of a snapshot
	// copy operation. This parameter is only valid for specifying the destination
	// region in a PresignedUrl parameter, where it is required.
	//
	// CopySnapshot sends the snapshot copy to the regional endpoint that you send
	// the HTTP request to, such as ec2.us-east-1.amazonaws.com (in the AWS CLI,
	// this is specified with the --region parameter or the default region in your
	// AWS configuration file).
	DestinationRegion *string `locationName:"destinationRegion" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Specifies whether the destination snapshot should be encrypted. You can encrypt
	// a copy of an unencrypted snapshot using this flag, but you cannot use it
	// to create an unencrypted copy from an encrypted snapshot. Your default CMK
	// for EBS is used unless a non-default AWS Key Management Service (AWS KMS)
	// CMK is specified with KmsKeyId. For more information, see Amazon EBS Encryption
	// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) in
	// the Amazon Elastic Compute Cloud User Guide.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The full ARN of the AWS Key Management Service (AWS KMS) CMK to use when
	// creating the snapshot copy. This parameter is only required if you want to
	// use a non-default CMK; if this parameter is not specified, the default CMK
	// for EBS is used. The ARN contains the arn:aws:kms namespace, followed by
	// the region of the CMK, the AWS account ID of the CMK owner, the key namespace,
	// and then the CMK ID. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.
	// The specified CMK must exist in the region that the snapshot is being copied
	// to. If a KmsKeyId is specified, the Encrypted flag must also be set.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The pre-signed URL that facilitates copying an encrypted snapshot. This parameter
	// is only required when copying an encrypted snapshot with the Amazon EC2 Query
	// API; it is available as an optional parameter in all other cases. The PresignedUrl
	// should use the snapshot source endpoint, the CopySnapshot action, and include
	// the SourceRegion, SourceSnapshotId, and DestinationRegion parameters. The
	// PresignedUrl must be signed using AWS Signature Version 4. Because EBS snapshots
	// are stored in Amazon S3, the signing algorithm for this parameter uses the
	// same logic that is described in Authenticating Requests by Using Query Parameters
	// (AWS Signature Version 4) (http://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
	// in the Amazon Simple Storage Service API Reference. An invalid or improperly
	// signed PresignedUrl will cause the copy operation to fail asynchronously,
	// and the snapshot will move to an error state.
	PresignedUrl *string `locationName:"presignedUrl" type:"string"`

	// The ID of the region that contains the snapshot to be copied.
	//
	// SourceRegion is a required field
	SourceRegion *string `type:"string" required:"true"`

	// The ID of the EBS snapshot to copy.
	//
	// SourceSnapshotId is a required field
	SourceSnapshotId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopySnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopySnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopySnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopySnapshotInput"}
	if s.SourceRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceRegion"))
	}
	if s.SourceSnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceSnapshotId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CopySnapshotInput) SetDescription(v string) *CopySnapshotInput {
	s.Description = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *CopySnapshotInput) SetDestinationRegion(v string) *CopySnapshotInput {
	s.DestinationRegion = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CopySnapshotInput) SetDryRun(v bool) *CopySnapshotInput {
	s.DryRun = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *CopySnapshotInput) SetEncrypted(v bool) *CopySnapshotInput {
	s.Encrypted = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CopySnapshotInput) SetKmsKeyId(v string) *CopySnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetPresignedUrl sets the PresignedUrl field's value.
func (s *CopySnapshotInput) SetPresignedUrl(v string) *CopySnapshotInput {
	s.PresignedUrl = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CopySnapshotInput) SetSourceRegion(v string) *CopySnapshotInput {
	s.SourceRegion = &v
	return s
}

// SetSourceSnapshotId sets the SourceSnapshotId field's value.
func (s *CopySnapshotInput) SetSourceSnapshotId(v string) *CopySnapshotInput {
	s.SourceSnapshotId = &v
	return s
}

// Contains the output of CopySnapshot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshotResult
type CopySnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the new snapshot.
	SnapshotId *string `locationName:"snapshotId" type:"string"`
}

// String returns the string representation
func (s CopySnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopySnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *CopySnapshotOutput) SetSnapshotId(v string) *CopySnapshotOutput {
	s.SnapshotId = &v
	return s
}

// Contains the parameters for CreateCustomerGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGatewayRequest
type CreateCustomerGatewayInput struct {
	_ struct{} `type:"structure"`

	// For devices that support BGP, the customer gateway's BGP ASN.
	//
	// Default: 65000
	//
	// BgpAsn is a required field
	BgpAsn *int64 `type:"integer" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The Internet-routable IP address for the customer gateway's outside interface.
	// The address must be static.
	//
	// PublicIp is a required field
	PublicIp *string `locationName:"IpAddress" type:"string" required:"true"`

	// The type of VPN connection that this customer gateway supports (ipsec.1).
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"GatewayType"`
}

// String returns the string representation
func (s CreateCustomerGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomerGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomerGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomerGatewayInput"}
	if s.BgpAsn == nil {
		invalidParams.Add(request.NewErrParamRequired("BgpAsn"))
	}
	if s.PublicIp == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicIp"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBgpAsn sets the BgpAsn field's value.
func (s *CreateCustomerGatewayInput) SetBgpAsn(v int64) *CreateCustomerGatewayInput {
	s.BgpAsn = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateCustomerGatewayInput) SetDryRun(v bool) *CreateCustomerGatewayInput {
	s.DryRun = &v
	return s
}

// SetPublicIp sets the PublicIp field's value.
func (s *CreateCustomerGatewayInput) SetPublicIp(v string) *CreateCustomerGatewayInput {
	s.PublicIp = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateCustomerGatewayInput) SetType(v string) *CreateCustomerGatewayInput {
	s.Type = &v
	return s
}

// Contains the output of CreateCustomerGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGatewayResult
type CreateCustomerGatewayOutput struct {
	_ struct{} `type:"structure"`

	// Information about the customer gateway.
	CustomerGateway *CustomerGateway `locationName:"customerGateway" type:"structure"`
}

// String returns the string representation
func (s CreateCustomerGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomerGatewayOutput) GoString() string {
	return s.String()
}

// SetCustomerGateway sets the CustomerGateway field's value.
func (s *CreateCustomerGatewayOutput) SetCustomerGateway(v *CustomerGateway) *CreateCustomerGatewayOutput {
	s.CustomerGateway = v
	return s
}

// Contains the parameters for CreateDhcpOptions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptionsRequest
type CreateDhcpOptionsInput struct {
	_ struct{} `type:"structure"`

	// A DHCP configuration option.
	//
	// DhcpConfigurations is a required field
	DhcpConfigurations []*NewDhcpConfiguration `locationName:"dhcpConfiguration" locationNameList:"item" type:"list" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s CreateDhcpOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDhcpOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDhcpOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDhcpOptionsInput"}
	if s.DhcpConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("DhcpConfigurations"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDhcpConfigurations sets the DhcpConfigurations field's value.
func (s *CreateDhcpOptionsInput) SetDhcpConfigurations(v []*NewDhcpConfiguration) *CreateDhcpOptionsInput {
	s.DhcpConfigurations = v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateDhcpOptionsInput) SetDryRun(v bool) *CreateDhcpOptionsInput {
	s.DryRun = &v
	return s
}

// Contains the output of CreateDhcpOptions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptionsResult
type CreateDhcpOptionsOutput struct {
	_ struct{} `type:"structure"`

	// A set of DHCP options.
	DhcpOptions *DhcpOptions `locationName:"dhcpOptions" type:"structure"`
}

// String returns the string representation
func (s CreateDhcpOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDhcpOptionsOutput) GoString() string {
	return s.String()
}

// SetDhcpOptions sets the DhcpOptions field's value.
func (s *CreateDhcpOptionsOutput) SetDhcpOptions(v *DhcpOptions) *CreateDhcpOptionsOutput {
	s.DhcpOptions = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGatewayRequest
type CreateEgressOnlyInternetGatewayInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. For more information, see How to Ensure Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
	ClientToken *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the VPC for which to create the egress-only Internet gateway.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEgressOnlyInternetGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEgressOnlyInternetGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEgressOnlyInternetGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEgressOnlyInternetGatewayInput"}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateEgressOnlyInternetGatewayInput) SetClientToken(v string) *CreateEgressOnlyInternetGatewayInput {
	s.ClientToken = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateEgressOnlyInternetGatewayInput) SetDryRun(v bool) *CreateEgressOnlyInternetGatewayInput {
	s.DryRun = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateEgressOnlyInternetGatewayInput) SetVpcId(v string) *CreateEgressOnlyInternetGatewayInput {
	s.VpcId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGatewayResult
type CreateEgressOnlyInternetGatewayOutput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about the egress-only Internet gateway.
	EgressOnlyInternetGateway *EgressOnlyInternetGateway `locationName:"egressOnlyInternetGateway" type:"structure"`
}

// String returns the string representation
func (s CreateEgressOnlyInternetGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEgressOnlyInternetGatewayOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateEgressOnlyInternetGatewayOutput) SetClientToken(v string) *CreateEgressOnlyInternetGatewayOutput {
	s.ClientToken = &v
	return s
}

// SetEgressOnlyInternetGateway sets the EgressOnlyInternetGateway field's value.
func (s *CreateEgressOnlyInternetGatewayOutput) SetEgressOnlyInternetGateway(v *EgressOnlyInternetGateway) *CreateEgressOnlyInternetGatewayOutput {
	s.EgressOnlyInternetGateway = v
	return s
}

// Contains the parameters for CreateFlowLogs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogsRequest
type CreateFlowLogsInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. For more information, see How to Ensure Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
	ClientToken *string `type:"string"`

	// The ARN for the IAM role that's used to post flow logs to a CloudWatch Logs
	// log group.
	//
	// DeliverLogsPermissionArn is a required field
	DeliverLogsPermissionArn *string `type:"string" required:"true"`

	// The name of the CloudWatch log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `type:"string" required:"true"`

	// One or more subnet, network interface, or VPC IDs.
	//
	// Constraints: Maximum of 1000 resources
	//
	// ResourceIds is a required field
	ResourceIds []*string `locationName:"ResourceId" locationNameList:"item" type:"list" required:"true"`

	// The type of resource on which to create the flow log.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"FlowLogsResourceType"`

	// The type of traffic to log.
	//
	// TrafficType is a required field
	TrafficType *string `type:"string" required:"true" enum:"TrafficType"`
}

// String returns the string representation
func (s CreateFlowLogsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlowLogsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFlowLogsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFlowLogsInput"}
	if s.DeliverLogsPermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliverLogsPermissionArn"))
	}
	if s.LogGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LogGroupName"))
	}
	if s.ResourceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIds"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.TrafficType == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateFlowLogsInput) SetClientToken(v string) *CreateFlowLogsInput {
	s.ClientToken = &v
	return s
}

// SetDeliverLogsPermissionArn sets the DeliverLogsPermissionArn field's value.
func (s *CreateFlowLogsInput) SetDeliverLogsPermissionArn(v string) *CreateFlowLogsInput {
	s.DeliverLogsPermissionArn = &v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *CreateFlowLogsInput) SetLogGroupName(v string) *CreateFlowLogsInput {
	s.LogGroupName = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *CreateFlowLogsInput) SetResourceIds(v []*string) *CreateFlowLogsInput {
	s.ResourceIds = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *CreateFlowLogsInput) SetResourceType(v string) *CreateFlowLogsInput {
	s.ResourceType = &v
	return s
}

// SetTrafficType sets the TrafficType field's value.
func (s *CreateFlowLogsInput) SetTrafficType(v string) *CreateFlowLogsInput {
	s.TrafficType = &v
	return s
}

// Contains the output of CreateFlowLogs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogsResult
type CreateFlowLogsOutput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The IDs of the flow logs.
	FlowLogIds []*string `locationName:"flowLogIdSet" locationNameList:"item" type:"list"`

	// Information about the flow logs that could not be created successfully.
	Unsuccessful []*UnsuccessfulItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CreateFlowLogsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlowLogsOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateFlowLogsOutput) SetClientToken(v string) *CreateFlowLogsOutput {
	s.ClientToken = &v
	return s
}

// SetFlowLogIds sets the FlowLogIds field's value.
func (s *CreateFlowLogsOutput) SetFlowLogIds(v []*string) *CreateFlowLogsOutput {
	s.FlowLogIds = v
	return s
}

// SetUnsuccessful sets the Unsuccessful field's value.
func (s *CreateFlowLogsOutput) SetUnsuccessful(v []*UnsuccessfulItem) *CreateFlowLogsOutput {
	s.Unsuccessful = v
	return s
}

// Contains the parameters for CreateImage.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImageRequest
type CreateImageInput struct {
	_ struct{} `type:"structure"`

	// Information about one or more block device mappings.
	BlockDeviceMappings []*BlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"BlockDeviceMapping" type:"list"`

	// A description for the new image.
	Description *string `locationName:"description" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	// A name for the new image.
	//
	// Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets
	// ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('),
	// at-signs (@), or underscores(_)
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// By default, Amazon EC2 attempts to shut down and reboot the instance before
	// creating the image. If the 'No Reboot' option is set, Amazon EC2 doesn't
	// shut down the instance before creating the image. When this option is used,
	// file system integrity on the created image can't be guaranteed.
	NoReboot *bool `locationName:"noReboot" type:"boolean"`
}

// String returns the string representation
func (s CreateImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateImageInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockDeviceMappings sets the BlockDeviceMappings field's value.
func (s *CreateImageInput) SetBlockDeviceMappings(v []*BlockDeviceMapping) *CreateImageInput {
	s.BlockDeviceMappings = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateImageInput) SetDescription(v string) *CreateImageInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateImageInput) SetDryRun(v bool) *CreateImageInput {
	s.DryRun = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateImageInput) SetInstanceId(v string) *CreateImageInput {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateImageInput) SetName(v string) *CreateImageInput {
	s.Name = &v
	return s
}

// SetNoReboot sets the NoReboot field's value.
func (s *CreateImageInput) SetNoReboot(v bool) *CreateImageInput {
	s.NoReboot = &v
	return s
}

// Contains the output of CreateImage.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImageResult
type CreateImageOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the new AMI.
	ImageId *string `locationName:"imageId" type:"string"`
}

// String returns the string representation
func (s CreateImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImageOutput) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *CreateImageOutput) SetImageId(v string) *CreateImageOutput {
	s.ImageId = &v
	return s
}

// Contains the parameters for CreateInstanceExportTask.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTaskRequest
type CreateInstanceExportTaskInput struct {
	_ struct{} `type:"structure"`

	// A description for the conversion task or the resource being exported. The
	// maximum length is 255 bytes.
	Description *string `locationName:"description" type:"string"`

	// The format and location for an instance export task.
	ExportToS3Task *ExportToS3TaskSpecification `locationName:"exportToS3" type:"structure"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	// The target virtualization environment.
	TargetEnvironment *string `locationName:"targetEnvironment" type:"string" enum:"ExportEnvironment"`
}

// String returns the string representation
func (s CreateInstanceExportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceExportTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceExportTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstanceExportTaskInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateInstanceExportTaskInput) SetDescription(v string) *CreateInstanceExportTaskInput {
	s.Description = &v
	return s
}

// SetExportToS3Task sets the ExportToS3Task field's value.
func (s *CreateInstanceExportTaskInput) SetExportToS3Task(v *ExportToS3TaskSpecification) *CreateInstanceExportTaskInput {
	s.ExportToS3Task = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateInstanceExportTaskInput) SetInstanceId(v string) *CreateInstanceExportTaskInput {
	s.InstanceId = &v
	return s
}

// SetTargetEnvironment sets the TargetEnvironment field's value.
func (s *CreateInstanceExportTaskInput) SetTargetEnvironment(v string) *CreateInstanceExportTaskInput {
	s.TargetEnvironment = &v
	return s
}

// Contains the output for CreateInstanceExportTask.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTaskResult
type CreateInstanceExportTaskOutput struct {
	_ struct{} `type:"structure"`

	// Information about the instance export task.
	ExportTask *ExportTask `locationName:"exportTask" type:"structure"`
}

// String returns the string representation
func (s CreateInstanceExportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceExportTaskOutput) GoString() string {
	return s.String()
}

// SetExportTask sets the ExportTask field's value.
func (s *CreateInstanceExportTaskOutput) SetExportTask(v *ExportTask) *CreateInstanceExportTaskOutput {
	s.ExportTask = v
	return s
}

// Contains the parameters for CreateInternetGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGatewayRequest
type CreateInternetGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s CreateInternetGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInternetGatewayInput) GoString() string {
	return s.String()
}

// SetDryRun sets the DryRun field's value.
func (s *CreateInternetGatewayInput) SetDryRun(v bool) *CreateInternetGatewayInput {
	s.DryRun = &v
	return s
}

// Contains the output of CreateInternetGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGatewayResult
type CreateInternetGatewayOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Internet gateway.
	InternetGateway *InternetGateway `locationName:"internetGateway" type:"structure"`
}

// String returns the string representation
func (s CreateInternetGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInternetGatewayOutput) GoString() string {
	return s.String()
}

// SetInternetGateway sets the InternetGateway field's value.
func (s *CreateInternetGatewayOutput) SetInternetGateway(v *InternetGateway) *CreateInternetGatewayOutput {
	s.InternetGateway = v
	return s
}

// Contains the parameters for CreateKeyPair.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPairRequest
type CreateKeyPairInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// A unique name for the key pair.
	//
	// Constraints: Up to 255 ASCII characters
	//
	// KeyName is a required field
	KeyName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKeyPairInput"}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *CreateKeyPairInput) SetDryRun(v bool) *CreateKeyPairInput {
	s.DryRun = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *CreateKeyPairInput) SetKeyName(v string) *CreateKeyPairInput {
	s.KeyName = &v
	return s
}

// Describes a key pair.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/KeyPair
type CreateKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// The SHA-1 digest of the DER encoded private key.
	KeyFingerprint *string `locationName:"keyFingerprint" type:"string"`

	// An unencrypted PEM encoded RSA private key.
	KeyMaterial *string `locationName:"keyMaterial" type:"string"`

	// The name of the key pair.
	KeyName *string `locationName:"keyName" type:"string"`
}

// String returns the string representation
func (s CreateKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyPairOutput) GoString() string {
	return s.String()
}

// SetKeyFingerprint sets the KeyFingerprint field's value.
func (s *CreateKeyPairOutput) SetKeyFingerprint(v string) *CreateKeyPairOutput {
	s.KeyFingerprint = &v
	return s
}

// SetKeyMaterial sets the KeyMaterial field's value.
func (s *CreateKeyPairOutput) SetKeyMaterial(v string) *CreateKeyPairOutput {
	s.KeyMaterial = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *CreateKeyPairOutput) SetKeyName(v string) *CreateKeyPairOutput {
	s.KeyName = &v
	return s
}

// Contains the parameters for CreateNatGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGatewayRequest
type CreateNatGatewayInput struct {
	_ struct{} `type:"structure"`

	// The allocation ID of an Elastic IP address to associate with the NAT gateway.
	// If the Elastic IP address is associated with another resource, you must first
	// disassociate it.
	//
	// AllocationId is a required field
	AllocationId *string `type:"string" required:"true"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. For more information, see How to Ensure Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	//
	// Constraint: Maximum 64 ASCII characters.
	ClientToken *string `type:"string"`

	// The subnet in which to create the NAT gateway.
	//
	// SubnetId is a required field
	SubnetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateNatGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNatGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNatGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNatGatewayInput"}
	if s.AllocationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AllocationId"))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocationId sets the AllocationId field's value.
func (s *CreateNatGatewayInput) SetAllocationId(v string) *CreateNatGatewayInput {
	s.AllocationId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateNatGatewayInput) SetClientToken(v string) *CreateNatGatewayInput {
	s.ClientToken = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateNatGatewayInput) SetSubnetId(v string) *CreateNatGatewayInput {
	s.SubnetId = &v
	return s
}

// Contains the output of CreateNatGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGatewayResult
type CreateNatGatewayOutput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure the idempotency of the request.
	// Only returned if a client token was provided in the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about the NAT gateway.
	NatGateway *NatGateway `locationName:"natGateway" type:"structure"`
}

// String returns the string representation
func (s CreateNatGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNatGatewayOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateNatGatewayOutput) SetClientToken(v string) *CreateNatGatewayOutput {
	s.ClientToken = &v
	return s
}

// SetNatGateway sets the NatGateway field's value.
func (s *CreateNatGatewayOutput) SetNatGateway(v *NatGateway) *CreateNatGatewayOutput {
	s.NatGateway = v
	return s
}

// Contains the parameters for CreateNetworkAclEntry.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntryRequest
type CreateNetworkAclEntryInput struct {
	_ struct{} `type:"structure"`

	// The IPv4 network range to allow or deny, in CIDR notation (for example 172.16.0.0/24).
	CidrBlock *string `locationName:"cidrBlock" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Indicates whether this is an egress rule (rule is applied to traffic leaving
	// the subnet).
	//
	// Egress is a required field
	Egress *bool `locationName:"egress" type:"boolean" required:"true"`

	// ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying the
	// ICMP protocol, or protocol 58 (ICMPv6) with an IPv6 CIDR block.
	IcmpTypeCode *IcmpTypeCode `locationName:"Icmp" type:"structure"`

	// The IPv6 network range to allow or deny, in CIDR notation (for example 2001:db8:1234:1a00::/64).
	Ipv6CidrBlock *string `locationName:"ipv6CidrBlock" type:"string"`

	// The ID of the network ACL.
	//
	// NetworkAclId is a required field
	NetworkAclId *string `locationName:"networkAclId" type:"string" required:"true"`

	// TCP or UDP protocols: The range of ports the rule applies to.
	PortRange *PortRange `locationName:"portRange" type:"structure"`

	// The protocol. A value of -1 or all means all protocols. If you specify all,
	// -1, or a protocol number other than tcp, udp, or icmp, traffic on all ports
	// is allowed, regardless of any ports or ICMP types or codes you specify. If
	// you specify protocol 58 (ICMPv6) and specify an IPv4 CIDR block, traffic
	// for all ICMP types and codes allowed, regardless of any that you specify.
	// If you specify protocol 58 (ICMPv6) and specify an IPv6 CIDR block, you must
	// specify an ICMP type and code.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true"`

	// Indicates whether to allow or deny the traffic that matches the rule.
	//
	// RuleAction is a required field
	RuleAction *string `locationName:"ruleAction" type:"string" required:"true" enum:"RuleAction"`

	// The rule number for the entry (for example, 100). ACL entries are processed
	// in ascending order by rule number.
	//
	// Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is
	// reserved for internal use.
	//
	// RuleNumber is a required field
	RuleNumber *int64 `locationName:"ruleNumber" type:"integer" required:"true"`
}

// String returns the string representation
func (s CreateNetworkAclEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkAclEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNetworkAclEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNetworkAclEntryInput"}
	if s.Egress == nil {
		invalidParams.Add(request.NewErrParamRequired("Egress"))
	}
	if s.NetworkAclId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkAclId"))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.RuleAction == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleAction"))
	}
	if s.RuleNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidrBlock sets the CidrBlock field's value.
func (s *CreateNetworkAclEntryInput) SetCidrBlock(v string) *CreateNetworkAclEntryInput {
	s.CidrBlock = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateNetworkAclEntryInput) SetDryRun(v bool) *CreateNetworkAclEntryInput {
	s.DryRun = &v
	return s
}

// SetEgress sets the Egress field's value.
func (s *CreateNetworkAclEntryInput) SetEgress(v bool) *CreateNetworkAclEntryInput {
	s.Egress = &v
	return s
}

// SetIcmpTypeCode sets the IcmpTypeCode field's value.
func (s *CreateNetworkAclEntryInput) SetIcmpTypeCode(v *IcmpTypeCode) *CreateNetworkAclEntryInput {
	s.IcmpTypeCode = v
	return s
}

// SetIpv6CidrBlock sets the Ipv6CidrBlock field's value.
func (s *CreateNetworkAclEntryInput) SetIpv6CidrBlock(v string) *CreateNetworkAclEntryInput {
	s.Ipv6CidrBlock = &v
	return s
}

// SetNetworkAclId sets the NetworkAclId field's value.
func (s *CreateNetworkAclEntryInput) SetNetworkAclId(v string) *CreateNetworkAclEntryInput {
	s.NetworkAclId = &v
	return s
}

// SetPortRange sets the PortRange field's value.
func (s *CreateNetworkAclEntryInput) SetPortRange(v *PortRange) *CreateNetworkAclEntryInput {
	s.PortRange = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CreateNetworkAclEntryInput) SetProtocol(v string) *CreateNetworkAclEntryInput {
	s.Protocol = &v
	return s
}

// SetRuleAction sets the RuleAction field's value.
func (s *CreateNetworkAclEntryInput) SetRuleAction(v string) *CreateNetworkAclEntryInput {
	s.RuleAction = &v
	return s
}

// SetRuleNumber sets the RuleNumber field's value.
func (s *CreateNetworkAclEntryInput) SetRuleNumber(v int64) *CreateNetworkAclEntryInput {
	s.RuleNumber = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntryOutput
type CreateNetworkAclEntryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateNetworkAclEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkAclEntryOutput) GoString() string {
	return s.String()
}

// Contains the parameters for CreateNetworkAcl.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclRequest
type CreateNetworkAclInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	//
	// VpcId is a required field
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateNetworkAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNetworkAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNetworkAclInput"}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *CreateNetworkAclInput) SetDryRun(v bool) *CreateNetworkAclInput {
	s.DryRun = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateNetworkAclInput) SetVpcId(v string) *CreateNetworkAclInput {
	s.VpcId = &v
	return s
}

// Contains the output of CreateNetworkAcl.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclResult
type CreateNetworkAclOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network ACL.
	NetworkAcl *NetworkAcl `locationName:"networkAcl" type:"structure"`
}

// String returns the string representation
func (s CreateNetworkAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkAclOutput) GoString() string {
	return s.String()
}

// SetNetworkAcl sets the NetworkAcl field's value.
func (s *CreateNetworkAclOutput) SetNetworkAcl(v *NetworkAcl) *CreateNetworkAclOutput {
	s.NetworkAcl = v
	return s
}

// Contains the parameters for CreateNetworkInterface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfaceRequest
type CreateNetworkInterfaceInput struct {
	_ struct{} `type:"structure"`

	// A description for the network interface.
	Description *string `locationName:"description" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The IDs of one or more security groups.
	Groups []*string `locationName:"SecurityGroupId" locationNameList:"SecurityGroupId" type:"list"`

	// The number of IPv6 addresses to assign to a network interface. Amazon EC2
	// automatically selects the IPv6 addresses from the subnet range. You can't
	// use this option if specifying specific IPv6 addresses. If your subnet has
	// the AssignIpv6AddressOnCreation attribute set to true, you can specify 0
	// to override this setting.
	Ipv6AddressCount *int64 `locationName:"ipv6AddressCount" type:"integer"`

	// One or more specific IPv6 addresses from the IPv6 CIDR block range of your
	// subnet. You can't use this option if you're specifying a number of IPv6 addresses.
	Ipv6Addresses []*InstanceIpv6Address `locationName:"ipv6Addresses" locationNameList:"item" type:"list"`

	// The primary private IPv4 address of the network interface. If you don't specify
	// an IPv4 address, Amazon EC2 selects one for you from the subnet's IPv4 CIDR
	// range. If you specify an IP address, you cannot indicate any IP addresses
	// specified in privateIpAddresses as primary (only one IP address can be designated
	// as primary).
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// One or more private IPv4 addresses.
	PrivateIpAddresses []*PrivateIpAddressSpecification `locationName:"privateIpAddresses" locationNameList:"item" type:"list"`

	// The number of secondary private IPv4 addresses to assign to a network interface.
	// When you specify a number of secondary IPv4 addresses, Amazon EC2 selects
	// these IP addresses within the subnet's IPv4 CIDR range. You can't specify
	// this option and specify more than one private IP address using privateIpAddresses.
	//
	// The number of IP addresses you can assign to a network interface varies by
	// instance type. For more information, see IP Addresses Per ENI Per Instance
	// Type (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI)
	// in the Amazon Virtual Private Cloud User Guide.
	SecondaryPrivateIpAddressCount *int64 `locationName:"secondaryPrivateIpAddressCount" type:"integer"`

	// The ID of the subnet to associate with the network interface.
	//
	// SubnetId is a required field
	SubnetId *string `locationName:"subnetId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateNetworkInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNetworkInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNetworkInterfaceInput"}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}
	if s.PrivateIpAddresses != nil {
		for i, v := range s.PrivateIpAddresses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PrivateIpAddresses", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateNetworkInterfaceInput) SetDescription(v string) *CreateNetworkInterfaceInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateNetworkInterfaceInput) SetDryRun(v bool) *CreateNetworkInterfaceInput {
	s.DryRun = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *CreateNetworkInterfaceInput) SetGroups(v []*string) *CreateNetworkInterfaceInput {
	s.Groups = v
	return s
}

// SetIpv6AddressCount sets the Ipv6AddressCount field's value.
func (s *CreateNetworkInterfaceInput) SetIpv6AddressCount(v int64) *CreateNetworkInterfaceInput {
	s.Ipv6AddressCount = &v
	return s
}

// SetIpv6Addresses sets the Ipv6Addresses field's value.
func (s *CreateNetworkInterfaceInput) SetIpv6Addresses(v []*InstanceIpv6Address) *CreateNetworkInterfaceInput {
	s.Ipv6Addresses = v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *CreateNetworkInterfaceInput) SetPrivateIpAddress(v string) *CreateNetworkInterfaceInput {
	s.PrivateIpAddress = &v
	return s
}

// SetPrivateIpAddresses sets the PrivateIpAddresses field's value.
func (s *CreateNetworkInterfaceInput) SetPrivateIpAddresses(v []*PrivateIpAddressSpecification) *CreateNetworkInterfaceInput {
	s.PrivateIpAddresses = v
	return s
}

// SetSecondaryPrivateIpAddressCount sets the SecondaryPrivateIpAddressCount field's value.
func (s *CreateNetworkInterfaceInput) SetSecondaryPrivateIpAddressCount(v int64) *CreateNetworkInterfaceInput {
	s.SecondaryPrivateIpAddressCount = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateNetworkInterfaceInput) SetSubnetId(v string) *CreateNetworkInterfaceInput {
	s.SubnetId = &v
	return s
}

// Contains the output of CreateNetworkInterface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfaceResult
type CreateNetworkInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network interface.
	NetworkInterface *NetworkInterface `locationName:"networkInterface" type:"structure"`
}

// String returns the string representation
func (s CreateNetworkInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkInterfaceOutput) GoString() string {
	return s.String()
}

// SetNetworkInterface sets the NetworkInterface field's value.
func (s *CreateNetworkInterfaceOutput) SetNetworkInterface(v *NetworkInterface) *CreateNetworkInterfaceOutput {
	s.NetworkInterface = v
	return s
}

// Contains the parameters for CreatePlacementGroup.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroupRequest
type CreatePlacementGroupInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// A name for the placement group.
	//
	// Constraints: Up to 255 ASCII characters
	//
	// GroupName is a required field
	GroupName *string `locationName:"groupName" type:"string" required:"true"`

	// The placement strategy.
	//
	// Strategy is a required field
	Strategy *string `locationName:"strategy" type:"string" required:"true" enum:"PlacementStrategy"`
}

// String returns the string representation
func (s CreatePlacementGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlacementGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlacementGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePlacementGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.Strategy == nil {
		invalidParams.Add(request.NewErrParamRequired("Strategy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *CreatePlacementGroupInput) SetDryRun(v bool) *CreatePlacementGroupInput {
	s.DryRun = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreatePlacementGroupInput) SetGroupName(v string) *CreatePlacementGroupInput {
	s.GroupName = &v
	return s
}

// SetStrategy sets the Strategy field's value.
func (s *CreatePlacementGroupInput) SetStrategy(v string) *CreatePlacementGroupInput {
	s.Strategy = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroupOutput
type CreatePlacementGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreatePlacementGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlacementGroupOutput) GoString() string {
	return s.String()
}

// Contains the parameters for CreateReservedInstancesListing.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListingRequest
type CreateReservedInstancesListingInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure idempotency of your
	// listings. This helps avoid duplicate listings. For more information, see
	// Ensuring Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	//
	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" type:"string" required:"true"`

	// The number of instances that are a part of a Reserved Instance account to
	// be listed in the Reserved Instance Marketplace. This number should be less
	// than or equal to the instance count associated with the Reserved Instance
	// ID specified in this call.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `locationName:"instanceCount" type:"integer" required:"true"`

	// A list specifying the price of the Standard Reserved Instance for each month
	// remaining in the Reserved Instance term.
	//
	// PriceSchedules is a required field
	PriceSchedules []*PriceScheduleSpecification `locationName:"priceSchedules" locationNameList:"item" type:"list" required:"true"`

	// The ID of the active Standard Reserved Instance.
	//
	// ReservedInstancesId is a required field
	ReservedInstancesId *string `locationName:"reservedInstancesId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReservedInstancesListingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReservedInstancesListingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReservedInstancesListingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReservedInstancesListingInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.InstanceCount == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceCount"))
	}
	if s.PriceSchedules == nil {
		invalidParams.Add(request.NewErrParamRequired("PriceSchedules"))
	}
	if s.ReservedInstancesId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedInstancesId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateReservedInstancesListingInput) SetClientToken(v string) *CreateReservedInstancesListingInput {
	s.ClientToken = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *CreateReservedInstancesListingInput) SetInstanceCount(v int64) *CreateReservedInstancesListingInput {
	s.InstanceCount = &v
	return s
}

// SetPriceSchedules sets the PriceSchedules field's value.
func (s *CreateReservedInstancesListingInput) SetPriceSchedules(v []*PriceScheduleSpecification) *CreateReservedInstancesListingInput {
	s.PriceSchedules = v
	return s
}

// SetReservedInstancesId sets the ReservedInstancesId field's value.
func (s *CreateReservedInstancesListingInput) SetReservedInstancesId(v string) *CreateReservedInstancesListingInput {
	s.ReservedInstancesId = &v
	return s
}

// Contains the output of CreateReservedInstancesListing.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListingResult
type CreateReservedInstancesListingOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Standard Reserved Instance listing.
	ReservedInstancesListings []*ReservedInstancesListing `locationName:"reservedInstancesListingsSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CreateReservedInstancesListingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReservedInstancesListingOutput) GoString() string {
	return s.String()
}

// SetReservedInstancesListings sets the ReservedInstancesListings field's value.
func (s *CreateReservedInstancesListingOutput) SetReservedInstancesListings(v []*ReservedInstancesListing) *CreateReservedInstancesListingOutput {
	s.ReservedInstancesListings = v
	return s
}

// Contains the parameters for CreateRoute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteRequest
type CreateRouteInput struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR address block used for the destination match. Routing decisions
	// are based on the most specific match.
	DestinationCidrBlock *string `locationName:"destinationCidrBlock" type:"string"`

	// The IPv6 CIDR block used for the destination match. Routing decisions are
	// based on the most specific match.
	DestinationIpv6CidrBlock *string `locationName:"destinationIpv6CidrBlock" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// [IPv6 traffic only] The ID of an egress-only Internet gateway.
	EgressOnlyInternetGatewayId *string `locationName:"egressOnlyInternetGatewayId" type:"string"`

	// The ID of an Internet gateway or virtual private gateway attached to your
	// VPC.
	GatewayId *string `locationName:"gatewayId" type:"string"`

	// The ID of a NAT instance in your VPC. The operation fails if you specify
	// an instance ID unless exactly one network interface is attached.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// [IPv4 traffic only] The ID of a NAT gateway.
	NatGatewayId *string `locationName:"natGatewayId" type:"string"`

	// The ID of a network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The ID of the route table for the route.
	//
	// RouteTableId is a required field
	RouteTableId *string `locationName:"routeTableId" type:"string" required:"true"`

	// The ID of a VPC peering connection.
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string"`
}

// String returns the string representation
func (s CreateRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRouteInput"}
	if s.RouteTableId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteTableId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationCidrBlock sets the DestinationCidrBlock field's value.
func (s *CreateRouteInput) SetDestinationCidrBlock(v string) *CreateRouteInput {
	s.DestinationCidrBlock = &v
	return s
}

// SetDestinationIpv6CidrBlock sets the DestinationIpv6CidrBlock field's value.
func (s *CreateRouteInput) SetDestinationIpv6CidrBlock(v string) *CreateRouteInput {
	s.DestinationIpv6CidrBlock = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateRouteInput) SetDryRun(v bool) *CreateRouteInput {
	s.DryRun = &v
	return s
}

// SetEgressOnlyInternetGatewayId sets the EgressOnlyInternetGatewayId field's value.
func (s *CreateRouteInput) SetEgressOnlyInternetGatewayId(v string) *CreateRouteInput {
	s.EgressOnlyInternetGatewayId = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *CreateRouteInput) SetGatewayId(v string) *CreateRouteInput {
	s.GatewayId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateRouteInput) SetInstanceId(v string) *CreateRouteInput {
	s.InstanceId = &v
	return s
}

// SetNatGatewayId sets the NatGatewayId field's value.
func (s *CreateRouteInput) SetNatGatewayId(v string) *CreateRouteInput {
	s.NatGatewayId = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *CreateRouteInput) SetNetworkInterfaceId(v string) *CreateRouteInput {
	s.NetworkInterfaceId = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *CreateRouteInput) SetRouteTableId(v string) *CreateRouteInput {
	s.RouteTableId = &v
	return s
}

// SetVpcPeeringConnectionId sets the VpcPeeringConnectionId field's value.
func (s *CreateRouteInput) SetVpcPeeringConnectionId(v string) *CreateRouteInput {
	s.VpcPeeringConnectionId = &v
	return s
}

// Contains the output of CreateRoute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteResult
type CreateRouteOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s CreateRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteOutput) GoString() string {
	return s.String()
}

// SetReturn sets the Return field's value.
func (s *CreateRouteOutput) SetReturn(v bool) *CreateRouteOutput {
	s.Return = &v
	return s
}

// Contains the parameters for CreateRouteTable.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTableRequest
type CreateRouteTableInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	//
	// VpcId is a required field
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRouteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRouteTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRouteTableInput"}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *CreateRouteTableInput) SetDryRun(v bool) *CreateRouteTableInput {
	s.DryRun = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateRouteTableInput) SetVpcId(v string) *CreateRouteTableInput {
	s.VpcId = &v
	return s
}

// Contains the output of CreateRouteTable.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTableResult
type CreateRouteTableOutput struct {
	_ struct{} `type:"structure"`

	// Information about the route table.
	RouteTable *RouteTable `locationName:"routeTable" type:"structure"`
}

// String returns the string representation
func (s CreateRouteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteTableOutput) GoString() string {
	return s.String()
}

// SetRouteTable sets the RouteTable field's value.
func (s *CreateRouteTableOutput) SetRouteTable(v *RouteTable) *CreateRouteTableOutput {
	s.RouteTable = v
	return s
}

// Contains the parameters for CreateSecurityGroup.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroupRequest
type CreateSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// A description for the security group. This is informational only.
	//
	// Constraints: Up to 255 characters in length
	//
	// Constraints for EC2-Classic: ASCII characters
	//
	// Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&;{}!$*
	//
	// Description is a required field
	Description *string `locationName:"GroupDescription" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The name of the security group.
	//
	// Constraints: Up to 255 characters in length
	//
	// Constraints for EC2-Classic: ASCII characters
	//
	// Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&;{}!$*
	//
	// GroupName is a required field
	GroupName *string `type:"string" required:"true"`

	// [EC2-VPC] The ID of the VPC. Required for EC2-VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s CreateSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSecurityGroupInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateSecurityGroupInput) SetDescription(v string) *CreateSecurityGroupInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateSecurityGroupInput) SetDryRun(v bool) *CreateSecurityGroupInput {
	s.DryRun = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateSecurityGroupInput) SetGroupName(v string) *CreateSecurityGroupInput {
	s.GroupName = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateSecurityGroupInput) SetVpcId(v string) *CreateSecurityGroupInput {
	s.VpcId = &v
	return s
}

// Contains the output of CreateSecurityGroup.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroupResult
type CreateSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `locationName:"groupId" type:"string"`
}

// String returns the string representation
func (s CreateSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *CreateSecurityGroupOutput) SetGroupId(v string) *CreateSecurityGroupOutput {
	s.GroupId = &v
	return s
}

// Contains the parameters for CreateSnapshot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshotRequest
type CreateSnapshotInput struct {
	_ struct{} `type:"structure"`

	// A description for the snapshot.
	Description *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the EBS volume.
	//
	// VolumeId is a required field
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotInput"}
	if s.VolumeId == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateSnapshotInput) SetDescription(v string) *CreateSnapshotInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateSnapshotInput) SetDryRun(v bool) *CreateSnapshotInput {
	s.DryRun = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *CreateSnapshotInput) SetVolumeId(v string) *CreateSnapshotInput {
	s.VolumeId = &v
	return s
}

// Contains the parameters for CreateSpotDatafeedSubscription.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscriptionRequest
type CreateSpotDatafeedSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket in which to store the Spot instance data feed.
	//
	// Bucket is a required field
	Bucket *string `locationName:"bucket" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// A prefix for the data feed file names.
	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation
func (s CreateSpotDatafeedSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSpotDatafeedSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSpotDatafeedSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSpotDatafeedSubscriptionInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *CreateSpotDatafeedSubscriptionInput) SetBucket(v string) *CreateSpotDatafeedSubscriptionInput {
	s.Bucket = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateSpotDatafeedSubscriptionInput) SetDryRun(v bool) *CreateSpotDatafeedSubscriptionInput {
	s.DryRun = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *CreateSpotDatafeedSubscriptionInput) SetPrefix(v string) *CreateSpotDatafeedSubscriptionInput {
	s.Prefix = &v
	return s
}

// Contains the output of CreateSpotDatafeedSubscription.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscriptionResult
type CreateSpotDatafeedSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The Spot instance data feed subscription.
	SpotDatafeedSubscription *SpotDatafeedSubscription `locationName:"spotDatafeedSubscription" type:"structure"`
}

// String returns the string representation
func (s CreateSpotDatafeedSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSpotDatafeedSubscriptionOutput) GoString() string {
	return s.String()
}

// SetSpotDatafeedSubscription sets the SpotDatafeedSubscription field's value.
func (s *CreateSpotDatafeedSubscriptionOutput) SetSpotDatafeedSubscription(v *SpotDatafeedSubscription) *CreateSpotDatafeedSubscriptionOutput {
	s.SpotDatafeedSubscription = v
	return s
}

// Contains the parameters for CreateSubnet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetRequest
type CreateSubnetInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone for the subnet.
	//
	// Default: AWS selects one for you. If you create more than one subnet in your
	// VPC, we may not necessarily select a different zone for each subnet.
	AvailabilityZone *string `type:"string"`

	// The IPv4 network range for the subnet, in CIDR notation. For example, 10.0.0.0/24.
	//
	// CidrBlock is a required field
	CidrBlock *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The IPv6 network range for the subnet, in CIDR notation. The subnet size
	// must use a /64 prefix length.
	Ipv6CidrBlock *string `type:"string"`

	// The ID of the VPC.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSubnetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubnetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubnetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubnetInput"}
	if s.CidrBlock == nil {
		invalidParams.Add(request.NewErrParamRequired("CidrBlock"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateSubnetInput) SetAvailabilityZone(v string) *CreateSubnetInput {
	s.AvailabilityZone = &v
	return s
}

// SetCidrBlock sets the CidrBlock field's value.
func (s *CreateSubnetInput) SetCidrBlock(v string) *CreateSubnetInput {
	s.CidrBlock = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateSubnetInput) SetDryRun(v bool) *CreateSubnetInput {
	s.DryRun = &v
	return s
}

// SetIpv6CidrBlock sets the Ipv6CidrBlock field's value.
func (s *CreateSubnetInput) SetIpv6CidrBlock(v string) *CreateSubnetInput {
	s.Ipv6CidrBlock = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateSubnetInput) SetVpcId(v string) *CreateSubnetInput {
	s.VpcId = &v
	return s
}

// Contains the output of CreateSubnet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetResult
type CreateSubnetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the subnet.
	Subnet *Subnet `locationName:"subnet" type:"structure"`
}

// String returns the string representation
func (s CreateSubnetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubnetOutput) GoString() string {
	return s.String()
}

// SetSubnet sets the Subnet field's value.
func (s *CreateSubnetOutput) SetSubnet(v *Subnet) *CreateSubnetOutput {
	s.Subnet = v
	return s
}

// Contains the parameters for CreateTags.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTagsRequest
type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The IDs of one or more resources to tag. For example, ami-1a2b3c4d.
	//
	// Resources is a required field
	Resources []*string `locationName:"ResourceId" type:"list" required:"true"`

	// One or more tags. The value parameter is required, but if you don't want
	// the tag to have a value, specify the parameter with no value, and we set
	// the value to an empty string.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"Tag" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.Resources == nil {
		invalidParams.Add(request.NewErrParamRequired("Resources"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *CreateTagsInput) SetDryRun(v bool) *CreateTagsInput {
	s.DryRun = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *CreateTagsInput) SetResources(v []*string) *CreateTagsInput {
	s.Resources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTagsInput) SetTags(v []*Tag) *CreateTagsInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTagsOutput
type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for CreateVolume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolumeRequest
type CreateVolumeInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which to create the volume. Use DescribeAvailabilityZones
	// to list the Availability Zones that are currently available to you.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Specifies whether the volume should be encrypted. Encrypted Amazon EBS volumes
	// may only be attached to instances that support Amazon EBS encryption. Volumes
	// that are created from encrypted snapshots are automatically encrypted. There
	// is no way to create an encrypted volume from an unencrypted snapshot or vice
	// versa. If your AMI uses encrypted volumes, you can only launch it on supported
	// instance types. For more information, see Amazon EBS Encryption (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// Only valid for Provisioned IOPS SSD volumes. The number of I/O operations
	// per second (IOPS) to provision for the volume, with a maximum ratio of 50
	// IOPS/GiB.
	//
	// Constraint: Range is 100 to 20000 for Provisioned IOPS SSD volumes
	Iops *int64 `type:"integer"`

	// The full ARN of the AWS Key Management Service (AWS KMS) customer master
	// key (CMK) to use when creating the encrypted volume. This parameter is only
	// required if you want to use a non-default CMK; if this parameter is not specified,
	// the default CMK for EBS is used. The ARN contains the arn:aws:kms namespace,
	// followed by the region of the CMK, the AWS account ID of the CMK owner, the
	// key namespace, and then the CMK ID. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.
	// If a KmsKeyId is specified, the Encrypted flag must also be set.
	KmsKeyId *string `type:"string"`

	// The size of the volume, in GiBs.
	//
	// Constraints: 1-16384 for gp2, 4-16384 for io1, 500-16384 for st1, 500-16384
	// for sc1, and 1-1024 for standard. If you specify a snapshot, the volume size
	// must be equal to or larger than the snapshot size.
	//
	// Default: If you're creating the volume from a snapshot and don't specify
	// a volume size, the default is the snapshot size.
	Size *int64 `type:"integer"`

	// The snapshot from which to create the volume.
	SnapshotId *string `type:"string"`

	// The volume type. This can be gp2 for General Purpose SSD, io1 for Provisioned
	// IOPS SSD, st1 for Throughput Optimized HDD, sc1 for Cold HDD, or standard
	// for Magnetic volumes.
	//
	// Default: standard
	VolumeType *string `type:"string" enum:"VolumeType"`
}

// String returns the string representation
func (s CreateVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVolumeInput"}
	if s.AvailabilityZone == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZone"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateVolumeInput) SetAvailabilityZone(v string) *CreateVolumeInput {
	s.AvailabilityZone = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateVolumeInput) SetDryRun(v bool) *CreateVolumeInput {
	s.DryRun = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *CreateVolumeInput) SetEncrypted(v bool) *CreateVolumeInput {
	s.Encrypted = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *CreateVolumeInput) SetIops(v int64) *CreateVolumeInput {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateVolumeInput) SetKmsKeyId(v string) *CreateVolumeInput {
	s.KmsKeyId = &v
	return s
}

// SetSize sets the Size field's value.
func (s *CreateVolumeInput) SetSize(v int64) *CreateVolumeInput {
	s.Size = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *CreateVolumeInput) SetSnapshotId(v string) *CreateVolumeInput {
	s.SnapshotId = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *CreateVolumeInput) SetVolumeType(v string) *CreateVolumeInput {
	s.VolumeType = &v
	return s
}

// Describes the user or group to be added or removed from the permissions for
// a volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolumePermission
type CreateVolumePermission struct {
	_ struct{} `type:"structure"`

	// The specific group that is to be added or removed from a volume's list of
	// create volume permissions.
	Group *string `locationName:"group" type:"string" enum:"PermissionGroup"`

	// The specific AWS account ID that is to be added or removed from a volume's
	// list of create volume permissions.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation
func (s CreateVolumePermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVolumePermission) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *CreateVolumePermission) SetGroup(v string) *CreateVolumePermission {
	s.Group = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateVolumePermission) SetUserId(v string) *CreateVolumePermission {
	s.UserId = &v
	return s
}

// Describes modifications to the permissions for a volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolumePermissionModifications
type CreateVolumePermissionModifications struct {
	_ struct{} `type:"structure"`

	// Adds a specific AWS account ID or group to a volume's list of create volume
	// permissions.
	Add []*CreateVolumePermission `locationNameList:"item" type:"list"`

	// Removes a specific AWS account ID or group from a volume's list of create
	// volume permissions.
	Remove []*CreateVolumePermission `locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CreateVolumePermissionModifications) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVolumePermissionModifications) GoString() string {
	return s.String()
}

// SetAdd sets the Add field's value.
func (s *CreateVolumePermissionModifications) SetAdd(v []*CreateVolumePermission) *CreateVolumePermissionModifications {
	s.Add = v
	return s
}

// SetRemove sets the Remove field's value.
func (s *CreateVolumePermissionModifications) SetRemove(v []*CreateVolumePermission) *CreateVolumePermissionModifications {
	s.Remove = v
	return s
}

// Contains the parameters for CreateVpcEndpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointRequest
type CreateVpcEndpointInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. For more information, see How to Ensure Idempotency (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// A policy to attach to the endpoint that controls access to the service. The
	// policy must be in valid JSON format. If this parameter is not specified,
	// we attach a default policy that allows full access to the service.
	PolicyDocument *string `type:"string"`

	// One or more route table IDs.
	RouteTableIds []*string `locationName:"RouteTableId" locationNameList:"item" type:"list"`

	// The AWS service name, in the form com.amazonaws.region.service. To get a
	// list of available services, use the DescribeVpcEndpointServices request.
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true"`

	// The ID of the VPC in which the endpoint will be used.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVpcEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpcEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVpcEndpointInput"}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVpcEndpointInput) SetClientToken(v string) *CreateVpcEndpointInput {
	s.ClientToken = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateVpcEndpointInput) SetDryRun(v bool) *CreateVpcEndpointInput {
	s.DryRun = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreateVpcEndpointInput) SetPolicyDocument(v string) *CreateVpcEndpointInput {
	s.PolicyDocument = &v
	return s
}

// SetRouteTableIds sets the RouteTableIds field's value.
func (s *CreateVpcEndpointInput) SetRouteTableIds(v []*string) *CreateVpcEndpointInput {
	s.RouteTableIds = v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *CreateVpcEndpointInput) SetServiceName(v string) *CreateVpcEndpointInput {
	s.ServiceName = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateVpcEndpointInput) SetVpcId(v string) *CreateVpcEndpointInput {
	s.VpcId = &v
	return s
}

// Contains the output of CreateVpcEndpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointResult
type CreateVpcEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about the endpoint.
	VpcEndpoint *VpcEndpoint `locationName:"vpcEndpoint" type:"structure"`
}

// String returns the string representation
func (s CreateVpcEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcEndpointOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVpcEndpointOutput) SetClientToken(v string) *CreateVpcEndpointOutput {
	s.ClientToken = &v
	return s
}

// SetVpcEndpoint sets the VpcEndpoint field's value.
func (s *CreateVpcEndpointOutput) SetVpcEndpoint(v *VpcEndpoint) *CreateVpcEndpointOutput {
	s.VpcEndpoint = v
	return s
}

// Contains the parameters for CreateVpc.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcRequest
type CreateVpcInput struct {
	_ struct{} `type:"structure"`

	// Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
	// the VPC. You cannot specify the range of IP addresses, or the size of the
	// CIDR block.
	AmazonProvidedIpv6CidrBlock *bool `locationName:"amazonProvidedIpv6CidrBlock" type:"boolean"`

	// The IPv4 network range for the VPC, in CIDR notation. For example, 10.0.0.0/16.
	//
	// CidrBlock is a required field
	CidrBlock *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The tenancy options for instances launched into the VPC. For default, instances
	// are launched with shared tenancy by default. You can launch instances with
	// any tenancy into a shared tenancy VPC. For dedicated, instances are launched
	// as dedicated tenancy instances by default. You can only launch instances
	// with a tenancy of dedicated or host into a dedicated tenancy VPC.
	//
	// Important: The host value cannot be used with this parameter. Use the default
	// or dedicated values only.
	//
	// Default: default
	InstanceTenancy *string `locationName:"instanceTenancy" type:"string" enum:"Tenancy"`
}

// String returns the string representation
func (s CreateVpcInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpcInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVpcInput"}
	if s.CidrBlock == nil {
		invalidParams.Add(request.NewErrParamRequired("CidrBlock"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmazonProvidedIpv6CidrBlock sets the AmazonProvidedIpv6CidrBlock field's value.
func (s *CreateVpcInput) SetAmazonProvidedIpv6CidrBlock(v bool) *CreateVpcInput {
	s.AmazonProvidedIpv6CidrBlock = &v
	return s
}

// SetCidrBlock sets the CidrBlock field's value.
func (s *CreateVpcInput) SetCidrBlock(v string) *CreateVpcInput {
	s.CidrBlock = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateVpcInput) SetDryRun(v bool) *CreateVpcInput {
	s.DryRun = &v
	return s
}

// SetInstanceTenancy sets the InstanceTenancy field's value.
func (s *CreateVpcInput) SetInstanceTenancy(v string) *CreateVpcInput {
	s.InstanceTenancy = &v
	return s
}

// Contains the output of CreateVpc.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcResult
type CreateVpcOutput struct {
	_ struct{} `type:"structure"`

	// Information about the VPC.
	Vpc *Vpc `locationName:"vpc" type:"structure"`
}

// String returns the string representation
func (s CreateVpcOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcOutput) GoString() string {
	return s.String()
}

// SetVpc sets the Vpc field's value.
func (s *CreateVpcOutput) SetVpc(v *Vpc) *CreateVpcOutput {
	s.Vpc = v
	return s
}

// Contains the parameters for CreateVpcPeeringConnection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnectionRequest
type CreateVpcPeeringConnectionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The AWS account ID of the owner of the peer VPC.
	//
	// Default: Your AWS account ID
	PeerOwnerId *string `locationName:"peerOwnerId" type:"string"`

	// The ID of the VPC with which you are creating the VPC peering connection.
	PeerVpcId *string `locationName:"peerVpcId" type:"string"`

	// The ID of the requester VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s CreateVpcPeeringConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcPeeringConnectionInput) GoString() string {
	return s.String()
}

// SetDryRun sets the DryRun field's value.
func (s *CreateVpcPeeringConnectionInput) SetDryRun(v bool) *CreateVpcPeeringConnectionInput {
	s.DryRun = &v
	return s
}

// SetPeerOwnerId sets the PeerOwnerId field's value.
func (s *CreateVpcPeeringConnectionInput) SetPeerOwnerId(v string) *CreateVpcPeeringConnectionInput {
	s.PeerOwnerId = &v
	return s
}

// SetPeerVpcId sets the PeerVpcId field's value.
func (s *CreateVpcPeeringConnectionInput) SetPeerVpcId(v string) *CreateVpcPeeringConnectionInput {
	s.PeerVpcId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateVpcPeeringConnectionInput) SetVpcId(v string) *CreateVpcPeeringConnectionInput {
	s.VpcId = &v
	return s
}

// Contains the output of CreateVpcPeeringConnection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnectionResult
type CreateVpcPeeringConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the VPC peering connection.
	VpcPeeringConnection *VpcPeeringConnection `locationName:"vpcPeeringConnection" type:"structure"`
}

// String returns the string representation
func (s CreateVpcPeeringConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcPeeringConnectionOutput) GoString() string {
	return s.String()
}

// SetVpcPeeringConnection sets the VpcPeeringConnection field's value.
func (s *CreateVpcPeeringConnectionOutput) SetVpcPeeringConnection(v *VpcPeeringConnection) *CreateVpcPeeringConnectionOutput {
	s.VpcPeeringConnection = v
	return s
}

// Contains the parameters for CreateVpnConnection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRequest
type CreateVpnConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the customer gateway.
	//
	// CustomerGatewayId is a required field
	CustomerGatewayId *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Indicates whether the VPN connection requires static routes. If you are creating
	// a VPN connection for a device that does not support BGP, you must specify
	// true.
	//
	// Default: false
	Options *VpnConnectionOptionsSpecification `locationName:"options" type:"structure"`

	// The type of VPN connection (ipsec.1).
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`

	// The ID of the virtual private gateway.
	//
	// VpnGatewayId is a required field
	VpnGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVpnConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpnConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpnConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVpnConnectionInput"}
	if s.CustomerGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomerGatewayId"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.VpnGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpnGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomerGatewayId sets the CustomerGatewayId field's value.
func (s *CreateVpnConnectionInput) SetCustomerGatewayId(v string) *CreateVpnConnectionInput {
	s.CustomerGatewayId = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateVpnConnectionInput) SetDryRun(v bool) *CreateVpnConnectionInput {
	s.DryRun = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *CreateVpnConnectionInput) SetOptions(v *VpnConnectionOptionsSpecification) *CreateVpnConnectionInput {
	s.Options = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateVpnConnectionInput) SetType(v string) *CreateVpnConnectionInput {
	s.Type = &v
	return s
}

// SetVpnGatewayId sets the VpnGatewayId field's value.
func (s *CreateVpnConnectionInput) SetVpnGatewayId(v string) *CreateVpnConnectionInput {
	s.VpnGatewayId = &v
	return s
}

// Contains the output of CreateVpnConnection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionResult
type CreateVpnConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the VPN connection.
	VpnConnection *VpnConnection `locationName:"vpnConnection" type:"structure"`
}

// String returns the string representation
func (s CreateVpnConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpnConnectionOutput) GoString() string {
	return s.String()
}

// SetVpnConnection sets the VpnConnection field's value.
func (s *CreateVpnConnectionOutput) SetVpnConnection(v *VpnConnection) *CreateVpnConnectionOutput {
	s.VpnConnection = v
	return s
}

// Contains the parameters for CreateVpnConnectionRoute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRouteRequest
type CreateVpnConnectionRouteInput struct {
	_ struct{} `type:"structure"`

	// The CIDR block associated with the local subnet of the customer network.
	//
	// DestinationCidrBlock is a required field
	DestinationCidrBlock *string `type:"string" required:"true"`

	// The ID of the VPN connection.
	//
	// VpnConnectionId is a required field
	VpnConnectionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVpnConnectionRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpnConnectionRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpnConnectionRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVpnConnectionRouteInput"}
	if s.DestinationCidrBlock == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationCidrBlock"))
	}
	if s.VpnConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpnConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationCidrBlock sets the DestinationCidrBlock field's value.
func (s *CreateVpnConnectionRouteInput) SetDestinationCidrBlock(v string) *CreateVpnConnectionRouteInput {
	s.DestinationCidrBlock = &v
	return s
}

// SetVpnConnectionId sets the VpnConnectionId field's value.
func (s *CreateVpnConnectionRouteInput) SetVpnConnectionId(v string) *CreateVpnConnectionRouteInput {
	s.VpnConnectionId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRouteOutput
type CreateVpnConnectionRouteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateVpnConnectionRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpnConnectionRouteOutput) GoString() string {
	return s.String()
}

// Contains the parameters for CreateVpnGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGatewayRequest
type CreateVpnGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone for the virtual private gateway.
	AvailabilityZone *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The type of VPN connection this virtual private gateway supports.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"GatewayType"`
}

// String returns the string representation
func (s CreateVpnGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpnGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpnGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVpnGatewayInput"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateVpnGatewayInput) SetAvailabilityZone(v string) *CreateVpnGatewayInput {
	s.AvailabilityZone = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateVpnGatewayInput) SetDryRun(v bool) *CreateVpnGatewayInput {
	s.DryRun = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateVpnGatewayInput) SetType(v string) *CreateVpnGatewayInput {
	s.Type = &v
	return s
}

// Contains the output of CreateVpnGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGatewayResult
type CreateVpnGatewayOutput struct {
	_ struct{} `type:"structure"`

	// Information about the virtual private gateway.
	VpnGateway *VpnGateway `locationName:"vpnGateway" type:"structure"`
}

// String returns the string representation
func (s CreateVpnGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpnGatewayOutput) GoString() string {
	return s.String()
}

// SetVpnGateway sets the VpnGateway field's value.
func (s *CreateVpnGatewayOutput) SetVpnGateway(v *VpnGateway) *CreateVpnGatewayOutput {
	s.VpnGateway = v
	return s
}

// Describes a customer gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CustomerGateway
type CustomerGateway struct {
	_ struct{} `type:"structure"`

	// The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number
	// (ASN).
	BgpAsn *string `locationName:"bgpAsn" type:"string"`

	// The ID of the customer gateway.
	CustomerGatewayId *string `locationName:"customerGatewayId" type:"string"`

	// The Internet-routable IP address of the customer gateway's outside interface.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// The current state of the customer gateway (pending | available | deleting
	// | deleted).
	State *string `locationName:"state" type:"string"`

	// Any tags assigned to the customer gateway.
	Tags []*Tag `locationName:"tagSet" locationNameList:"item" type:"list"`

	// The type of VPN connection the customer gateway supports (ipsec.1).
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s CustomerGateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomerGateway) GoString() string {
	return s.String()
}

// SetBgpAsn sets the BgpAsn field's value.
func (s *CustomerGateway) SetBgpAsn(v string) *CustomerGateway {
	s.BgpAsn = &v
	return s
}

// SetCustomerGatewayId sets the CustomerGatewayId field's value.
func (s *CustomerGateway) SetCustomerGatewayId(v string) *CustomerGateway {
	s.CustomerGatewayId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *CustomerGateway) SetIpAddress(v string) *CustomerGateway {
	s.IpAddress = &v
	return s
}

// SetState sets the State field's value.
func (s *CustomerGateway) SetState(v string) *CustomerGateway {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CustomerGateway) SetTags(v []*Tag) *CustomerGateway {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CustomerGateway) SetType(v string) *CustomerGateway {
	s.Type = &v
	return s
}

// Contains the parameters for DeleteCustomerGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGatewayRequest
type DeleteCustomerGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ID of the customer gateway.
	//
	// CustomerGatewayId is a required field
	CustomerGatewayId *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s DeleteCustomerGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomerGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomerGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomerGatewayInput"}
	if s.CustomerGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomerGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomerGatewayId sets the CustomerGatewayId field's value.
func (s *DeleteCustomerGatewayInput) SetCustomerGatewayId(v string) *DeleteCustomerGatewayInput {
	s.CustomerGatewayId = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteCustomerGatewayInput) SetDryRun(v bool) *DeleteCustomerGatewayInput {
	s.DryRun = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGatewayOutput
type DeleteCustomerGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCustomerGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomerGatewayOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteDhcpOptions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptionsRequest
type DeleteDhcpOptionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the DHCP options set.
	//
	// DhcpOptionsId is a required field
	DhcpOptionsId *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s DeleteDhcpOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDhcpOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDhcpOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDhcpOptionsInput"}
	if s.DhcpOptionsId == nil {
		invalidParams.Add(request.NewErrParamRequired("DhcpOptionsId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDhcpOptionsId sets the DhcpOptionsId field's value.
func (s *DeleteDhcpOptionsInput) SetDhcpOptionsId(v string) *DeleteDhcpOptionsInput {
	s.DhcpOptionsId = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteDhcpOptionsInput) SetDryRun(v bool) *DeleteDhcpOptionsInput {
	s.DryRun = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptionsOutput
type DeleteDhcpOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDhcpOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDhcpOptionsOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGatewayRequest
type DeleteEgressOnlyInternetGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the egress-only Internet gateway.
	//
	// EgressOnlyInternetGatewayId is a required field
	EgressOnlyInternetGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEgressOnlyInternetGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEgressOnlyInternetGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEgressOnlyInternetGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEgressOnlyInternetGatewayInput"}
	if s.EgressOnlyInternetGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("EgressOnlyInternetGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteEgressOnlyInternetGatewayInput) SetDryRun(v bool) *DeleteEgressOnlyInternetGatewayInput {
	s.DryRun = &v
	return s
}

// SetEgressOnlyInternetGatewayId sets the EgressOnlyInternetGatewayId field's value.
func (s *DeleteEgressOnlyInternetGatewayInput) SetEgressOnlyInternetGatewayId(v string) *DeleteEgressOnlyInternetGatewayInput {
	s.EgressOnlyInternetGatewayId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGatewayResult
type DeleteEgressOnlyInternetGatewayOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	ReturnCode *bool `locationName:"returnCode" type:"boolean"`
}

// String returns the string representation
func (s DeleteEgressOnlyInternetGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEgressOnlyInternetGatewayOutput) GoString() string {
	return s.String()
}

// SetReturnCode sets the ReturnCode field's value.
func (s *DeleteEgressOnlyInternetGatewayOutput) SetReturnCode(v bool) *DeleteEgressOnlyInternetGatewayOutput {
	s.ReturnCode = &v
	return s
}

// Contains the parameters for DeleteFlowLogs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogsRequest
type DeleteFlowLogsInput struct {
	_ struct{} `type:"structure"`

	// One or more flow log IDs.
	//
	// FlowLogIds is a required field
	FlowLogIds []*string `locationName:"FlowLogId" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteFlowLogsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFlowLogsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFlowLogsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFlowLogsInput"}
	if s.FlowLogIds == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowLogIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowLogIds sets the FlowLogIds field's value.
func (s *DeleteFlowLogsInput) SetFlowLogIds(v []*string) *DeleteFlowLogsInput {
	s.FlowLogIds = v
	return s
}

// Contains the output of DeleteFlowLogs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogsResult
type DeleteFlowLogsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the flow logs that could not be deleted successfully.
	Unsuccessful []*UnsuccessfulItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DeleteFlowLogsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFlowLogsOutput) GoString() string {
	return s.String()
}

// SetUnsuccessful sets the Unsuccessful field's value.
func (s *DeleteFlowLogsOutput) SetUnsuccessful(v []*UnsuccessfulItem) *DeleteFlowLogsOutput {
	s.Unsuccessful = v
	return s
}

// Contains the parameters for DeleteInternetGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGatewayRequest
type DeleteInternetGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the Internet gateway.
	//
	// InternetGatewayId is a required field
	InternetGatewayId *string `locationName:"internetGatewayId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInternetGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInternetGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInternetGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInternetGatewayInput"}
	if s.InternetGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("InternetGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteInternetGatewayInput) SetDryRun(v bool) *DeleteInternetGatewayInput {
	s.DryRun = &v
	return s
}

// SetInternetGatewayId sets the InternetGatewayId field's value.
func (s *DeleteInternetGatewayInput) SetInternetGatewayId(v string) *DeleteInternetGatewayInput {
	s.InternetGatewayId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGatewayOutput
type DeleteInternetGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteInternetGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInternetGatewayOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteKeyPair.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPairRequest
type DeleteKeyPairInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The name of the key pair.
	//
	// KeyName is a required field
	KeyName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKeyPairInput"}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteKeyPairInput) SetDryRun(v bool) *DeleteKeyPairInput {
	s.DryRun = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *DeleteKeyPairInput) SetKeyName(v string) *DeleteKeyPairInput {
	s.KeyName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPairOutput
type DeleteKeyPairOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKeyPairOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteNatGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGatewayRequest
type DeleteNatGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ID of the NAT gateway.
	//
	// NatGatewayId is a required field
	NatGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNatGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNatGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNatGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNatGatewayInput"}
	if s.NatGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("NatGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNatGatewayId sets the NatGatewayId field's value.
func (s *DeleteNatGatewayInput) SetNatGatewayId(v string) *DeleteNatGatewayInput {
	s.NatGatewayId = &v
	return s
}

// Contains the output of DeleteNatGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGatewayResult
type DeleteNatGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the NAT gateway.
	NatGatewayId *string `locationName:"natGatewayId" type:"string"`
}

// String returns the string representation
func (s DeleteNatGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNatGatewayOutput) GoString() string {
	return s.String()
}

// SetNatGatewayId sets the NatGatewayId field's value.
func (s *DeleteNatGatewayOutput) SetNatGatewayId(v string) *DeleteNatGatewayOutput {
	s.NatGatewayId = &v
	return s
}

// Contains the parameters for DeleteNetworkAclEntry.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntryRequest
type DeleteNetworkAclEntryInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Indicates whether the rule is an egress rule.
	//
	// Egress is a required field
	Egress *bool `locationName:"egress" type:"boolean" required:"true"`

	// The ID of the network ACL.
	//
	// NetworkAclId is a required field
	NetworkAclId *string `locationName:"networkAclId" type:"string" required:"true"`

	// The rule number of the entry to delete.
	//
	// RuleNumber is a required field
	RuleNumber *int64 `locationName:"ruleNumber" type:"integer" required:"true"`
}

// String returns the string representation
func (s DeleteNetworkAclEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNetworkAclEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNetworkAclEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNetworkAclEntryInput"}
	if s.Egress == nil {
		invalidParams.Add(request.NewErrParamRequired("Egress"))
	}
	if s.NetworkAclId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkAclId"))
	}
	if s.RuleNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteNetworkAclEntryInput) SetDryRun(v bool) *DeleteNetworkAclEntryInput {
	s.DryRun = &v
	return s
}

// SetEgress sets the Egress field's value.
func (s *DeleteNetworkAclEntryInput) SetEgress(v bool) *DeleteNetworkAclEntryInput {
	s.Egress = &v
	return s
}

// SetNetworkAclId sets the NetworkAclId field's value.
func (s *DeleteNetworkAclEntryInput) SetNetworkAclId(v string) *DeleteNetworkAclEntryInput {
	s.NetworkAclId = &v
	return s
}

// SetRuleNumber sets the RuleNumber field's value.
func (s *DeleteNetworkAclEntryInput) SetRuleNumber(v int64) *DeleteNetworkAclEntryInput {
	s.RuleNumber = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntryOutput
type DeleteNetworkAclEntryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNetworkAclEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNetworkAclEntryOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteNetworkAcl.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclRequest
type DeleteNetworkAclInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the network ACL.
	//
	// NetworkAclId is a required field
	NetworkAclId *string `locationName:"networkAclId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNetworkAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNetworkAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNetworkAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNetworkAclInput"}
	if s.NetworkAclId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkAclId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteNetworkAclInput) SetDryRun(v bool) *DeleteNetworkAclInput {
	s.DryRun = &v
	return s
}

// SetNetworkAclId sets the NetworkAclId field's value.
func (s *DeleteNetworkAclInput) SetNetworkAclId(v string) *DeleteNetworkAclInput {
	s.NetworkAclId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclOutput
type DeleteNetworkAclOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNetworkAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNetworkAclOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteNetworkInterface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfaceRequest
type DeleteNetworkInterfaceInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the network interface.
	//
	// NetworkInterfaceId is a required field
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNetworkInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNetworkInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNetworkInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNetworkInterfaceInput"}
	if s.NetworkInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteNetworkInterfaceInput) SetDryRun(v bool) *DeleteNetworkInterfaceInput {
	s.DryRun = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *DeleteNetworkInterfaceInput) SetNetworkInterfaceId(v string) *DeleteNetworkInterfaceInput {
	s.NetworkInterfaceId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfaceOutput
type DeleteNetworkInterfaceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNetworkInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNetworkInterfaceOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeletePlacementGroup.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroupRequest
type DeletePlacementGroupInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The name of the placement group.
	//
	// GroupName is a required field
	GroupName *string `locationName:"groupName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePlacementGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlacementGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePlacementGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePlacementGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeletePlacementGroupInput) SetDryRun(v bool) *DeletePlacementGroupInput {
	s.DryRun = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DeletePlacementGroupInput) SetGroupName(v string) *DeletePlacementGroupInput {
	s.GroupName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroupOutput
type DeletePlacementGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePlacementGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlacementGroupOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteRoute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteRequest
type DeleteRouteInput struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR range for the route. The value you specify must match the CIDR
	// for the route exactly.
	DestinationCidrBlock *string `locationName:"destinationCidrBlock" type:"string"`

	// The IPv6 CIDR range for the route. The value you specify must match the CIDR
	// for the route exactly.
	DestinationIpv6CidrBlock *string `locationName:"destinationIpv6CidrBlock" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the route table.
	//
	// RouteTableId is a required field
	RouteTableId *string `locationName:"routeTableId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRouteInput"}
	if s.RouteTableId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteTableId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationCidrBlock sets the DestinationCidrBlock field's value.
func (s *DeleteRouteInput) SetDestinationCidrBlock(v string) *DeleteRouteInput {
	s.DestinationCidrBlock = &v
	return s
}

// SetDestinationIpv6CidrBlock sets the DestinationIpv6CidrBlock field's value.
func (s *DeleteRouteInput) SetDestinationIpv6CidrBlock(v string) *DeleteRouteInput {
	s.DestinationIpv6CidrBlock = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteRouteInput) SetDryRun(v bool) *DeleteRouteInput {
	s.DryRun = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *DeleteRouteInput) SetRouteTableId(v string) *DeleteRouteInput {
	s.RouteTableId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteOutput
type DeleteRouteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteRouteTable.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTableRequest
type DeleteRouteTableInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the route table.
	//
	// RouteTableId is a required field
	RouteTableId *string `locationName:"routeTableId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRouteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRouteTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRouteTableInput"}
	if s.RouteTableId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteTableId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteRouteTableInput) SetDryRun(v bool) *DeleteRouteTableInput {
	s.DryRun = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *DeleteRouteTableInput) SetRouteTableId(v string) *DeleteRouteTableInput {
	s.RouteTableId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTableOutput
type DeleteRouteTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRouteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteTableOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteSecurityGroup.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroupRequest
type DeleteSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the security group. Required for a nondefault VPC.
	GroupId *string `type:"string"`

	// [EC2-Classic, default VPC] The name of the security group. You can specify
	// either the security group name or the security group ID.
	GroupName *string `type:"string"`
}

// String returns the string representation
func (s DeleteSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSecurityGroupInput) GoString() string {
	return s.String()
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteSecurityGroupInput) SetDryRun(v bool) *DeleteSecurityGroupInput {
	s.DryRun = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *DeleteSecurityGroupInput) SetGroupId(v string) *DeleteSecurityGroupInput {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteSecurityGroupInput) SetGroupName(v string) *DeleteSecurityGroupInput {
	s.GroupName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroupOutput
type DeleteSecurityGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSecurityGroupOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteSnapshot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshotRequest
type DeleteSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the EBS snapshot.
	//
	// SnapshotId is a required field
	SnapshotId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSnapshotInput"}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteSnapshotInput) SetDryRun(v bool) *DeleteSnapshotInput {
	s.DryRun = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *DeleteSnapshotInput) SetSnapshotId(v string) *DeleteSnapshotInput {
	s.SnapshotId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshotOutput
type DeleteSnapshotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteSpotDatafeedSubscription.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscriptionRequest
type DeleteSpotDatafeedSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s DeleteSpotDatafeedSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSpotDatafeedSubscriptionInput) GoString() string {
	return s.String()
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteSpotDatafeedSubscriptionInput) SetDryRun(v bool) *DeleteSpotDatafeedSubscriptionInput {
	s.DryRun = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscriptionOutput
type DeleteSpotDatafeedSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSpotDatafeedSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSpotDatafeedSubscriptionOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteSubnet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetRequest
type DeleteSubnetInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the subnet.
	//
	// SubnetId is a required field
	SubnetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSubnetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubnetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubnetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSubnetInput"}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteSubnetInput) SetDryRun(v bool) *DeleteSubnetInput {
	s.DryRun = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *DeleteSubnetInput) SetSubnetId(v string) *DeleteSubnetInput {
	s.SubnetId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetOutput
type DeleteSubnetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSubnetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubnetOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteTags.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTagsRequest
type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the resource. For example, ami-1a2b3c4d. You can specify more than
	// one resource ID.
	//
	// Resources is a required field
	Resources []*string `locationName:"resourceId" type:"list" required:"true"`

	// One or more tags to delete. If you omit the value parameter, we delete the
	// tag regardless of its value. If you specify this parameter with an empty
	// string as the value, we delete the key only if its value is an empty string.
	Tags []*Tag `locationName:"tag" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.Resources == nil {
		invalidParams.Add(request.NewErrParamRequired("Resources"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteTagsInput) SetDryRun(v bool) *DeleteTagsInput {
	s.DryRun = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *DeleteTagsInput) SetResources(v []*string) *DeleteTagsInput {
	s.Resources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DeleteTagsInput) SetTags(v []*Tag) *DeleteTagsInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTagsOutput
type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteVolume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolumeRequest
type DeleteVolumeInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the volume.
	//
	// VolumeId is a required field
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVolumeInput"}
	if s.VolumeId == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteVolumeInput) SetDryRun(v bool) *DeleteVolumeInput {
	s.DryRun = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *DeleteVolumeInput) SetVolumeId(v string) *DeleteVolumeInput {
	s.VolumeId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolumeOutput
type DeleteVolumeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVolumeOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteVpcEndpoints.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointsRequest
type DeleteVpcEndpointsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more endpoint IDs.
	//
	// VpcEndpointIds is a required field
	VpcEndpointIds []*string `locationName:"VpcEndpointId" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteVpcEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpcEndpointsInput"}
	if s.VpcEndpointIds == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcEndpointIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteVpcEndpointsInput) SetDryRun(v bool) *DeleteVpcEndpointsInput {
	s.DryRun = &v
	return s
}

// SetVpcEndpointIds sets the VpcEndpointIds field's value.
func (s *DeleteVpcEndpointsInput) SetVpcEndpointIds(v []*string) *DeleteVpcEndpointsInput {
	s.VpcEndpointIds = v
	return s
}

// Contains the output of DeleteVpcEndpoints.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointsResult
type DeleteVpcEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the endpoints that were not successfully deleted.
	Unsuccessful []*UnsuccessfulItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DeleteVpcEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcEndpointsOutput) GoString() string {
	return s.String()
}

// SetUnsuccessful sets the Unsuccessful field's value.
func (s *DeleteVpcEndpointsOutput) SetUnsuccessful(v []*UnsuccessfulItem) *DeleteVpcEndpointsOutput {
	s.Unsuccessful = v
	return s
}

// Contains the parameters for DeleteVpc.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcRequest
type DeleteVpcInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpcInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpcInput"}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteVpcInput) SetDryRun(v bool) *DeleteVpcInput {
	s.DryRun = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DeleteVpcInput) SetVpcId(v string) *DeleteVpcInput {
	s.VpcId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcOutput
type DeleteVpcOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpcOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteVpcPeeringConnection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnectionRequest
type DeleteVpcPeeringConnectionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC peering connection.
	//
	// VpcPeeringConnectionId is a required field
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpcPeeringConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcPeeringConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcPeeringConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpcPeeringConnectionInput"}
	if s.VpcPeeringConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcPeeringConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteVpcPeeringConnectionInput) SetDryRun(v bool) *DeleteVpcPeeringConnectionInput {
	s.DryRun = &v
	return s
}

// SetVpcPeeringConnectionId sets the VpcPeeringConnectionId field's value.
func (s *DeleteVpcPeeringConnectionInput) SetVpcPeeringConnectionId(v string) *DeleteVpcPeeringConnectionInput {
	s.VpcPeeringConnectionId = &v
	return s
}

// Contains the output of DeleteVpcPeeringConnection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnectionResult
type DeleteVpcPeeringConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s DeleteVpcPeeringConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcPeeringConnectionOutput) GoString() string {
	return s.String()
}

// SetReturn sets the Return field's value.
func (s *DeleteVpcPeeringConnectionOutput) SetReturn(v bool) *DeleteVpcPeeringConnectionOutput {
	s.Return = &v
	return s
}

// Contains the parameters for DeleteVpnConnection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRequest
type DeleteVpnConnectionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPN connection.
	//
	// VpnConnectionId is a required field
	VpnConnectionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpnConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpnConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpnConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpnConnectionInput"}
	if s.VpnConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpnConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteVpnConnectionInput) SetDryRun(v bool) *DeleteVpnConnectionInput {
	s.DryRun = &v
	return s
}

// SetVpnConnectionId sets the VpnConnectionId field's value.
func (s *DeleteVpnConnectionInput) SetVpnConnectionId(v string) *DeleteVpnConnectionInput {
	s.VpnConnectionId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionOutput
type DeleteVpnConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpnConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpnConnectionOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteVpnConnectionRoute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRouteRequest
type DeleteVpnConnectionRouteInput struct {
	_ struct{} `type:"structure"`

	// The CIDR block associated with the local subnet of the customer network.
	//
	// DestinationCidrBlock is a required field
	DestinationCidrBlock *string `type:"string" required:"true"`

	// The ID of the VPN connection.
	//
	// VpnConnectionId is a required field
	VpnConnectionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpnConnectionRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpnConnectionRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpnConnectionRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpnConnectionRouteInput"}
	if s.DestinationCidrBlock == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationCidrBlock"))
	}
	if s.VpnConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpnConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationCidrBlock sets the DestinationCidrBlock field's value.
func (s *DeleteVpnConnectionRouteInput) SetDestinationCidrBlock(v string) *DeleteVpnConnectionRouteInput {
	s.DestinationCidrBlock = &v
	return s
}

// SetVpnConnectionId sets the VpnConnectionId field's value.
func (s *DeleteVpnConnectionRouteInput) SetVpnConnectionId(v string) *DeleteVpnConnectionRouteInput {
	s.VpnConnectionId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRouteOutput
type DeleteVpnConnectionRouteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpnConnectionRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpnConnectionRouteOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteVpnGateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGatewayRequest
type DeleteVpnGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the virtual private gateway.
	//
	// VpnGatewayId is a required field
	VpnGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpnGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpnGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpnGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpnGatewayInput"}
	if s.VpnGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpnGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteVpnGatewayInput) SetDryRun(v bool) *DeleteVpnGatewayInput {
	s.DryRun = &v
	return s
}

// SetVpnGatewayId sets the VpnGatewayId field's value.
func (s *DeleteVpnGatewayInput) SetVpnGatewayId(v string) *DeleteVpnGatewayInput {
	s.VpnGatewayId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGatewayOutput
type DeleteVpnGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpnGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpnGatewayOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeregisterImage.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImageRequest
type DeregisterImageInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the AMI.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterImageInput"}
	if s.ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeregisterImageInput) SetDryRun(v bool) *DeregisterImageInput {
	s.DryRun = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *DeregisterImageInput) SetImageId(v string) *DeregisterImageInput {
	s.ImageId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImageOutput
type DeregisterImageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterImageOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeAccountAttributes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributesRequest
type DescribeAccountAttributesInput struct {
	_ struct{} `type:"structure"`

	// One or more account attribute names.
	AttributeNames []*string `locationName:"attributeName" locationNameList:"attributeName" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s DescribeAccountAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesInput) GoString() string {
	return s.String()
}

// SetAttributeNames sets the AttributeNames field's value.
func (s *DescribeAccountAttributesInput) SetAttributeNames(v []*string) *DescribeAccountAttributesInput {
	s.AttributeNames = v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *DescribeAccountAttributesInput) SetDryRun(v bool) *DescribeAccountAttributesInput {
	s.DryRun = &v
	return s
}

// Contains the output of DescribeAccountAttributes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributesResult
type DescribeAccountAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more account attributes.
	AccountAttributes []*AccountAttribute `locationName:"accountAttributeSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeAccountAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesOutput) GoString() string {
	return s.String()
}

// SetAccountAttributes sets the AccountAttributes field's value.
func (s *DescribeAccountAttributesOutput) SetAccountAttributes(v []*AccountAttribute) *DescribeAccountAttributesOutput {
	s.AccountAttributes = v
	return s
}

// Contains the parameters for DescribeAddresses.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesRequest
type DescribeAddressesInput struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] One or more allocation IDs.
	//
	// Default: Describes all your Elastic IP addresses.
	AllocationIds []*string `locationName:"AllocationId" locationNameList:"AllocationId" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters. Filter names and values are case-sensitive.
	//
	//    * allocation-id - [EC2-VPC] The allocation ID for the address.
	//
	//    * association-id - [EC2-VPC] The association ID for the address.
	//
	//    * domain - Indicates whether the address is for use in EC2-Classic (standard)
	//    or in a VPC (vpc).
	//
	//    * instance-id - The ID of the instance the address is associated with,
	//    if any.
	//
	//    * network-interface-id - [EC2-VPC] The ID of the network interface that
	//    the address is associated with, if any.
	//
	//    * network-interface-owner-id - The AWS account ID of the owner.
	//
	//    * private-ip-address - [EC2-VPC] The private IP address associated with
	//    the Elastic IP address.
	//
	//    * public-ip - The Elastic IP address.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// [EC2-Classic] One or more Elastic IP addresses.
	//
	// Default: Describes all your Elastic IP addresses.
	PublicIps []*string `locationName:"PublicIp" locationNameList:"PublicIp" type:"list"`
}

// String returns the string representation
func (s DescribeAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressesInput) GoString() string {
	return s.String()
}

// SetAllocationIds sets the AllocationIds field's value.
func (s *DescribeAddressesInput) SetAllocationIds(v []*string) *DescribeAddressesInput {
	s.AllocationIds = v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *DescribeAddressesInput) SetDryRun(v bool) *DescribeAddressesInput {
	s.DryRun = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeAddressesInput) SetFilters(v []*Filter) *DescribeAddressesInput {
	s.Filters = v
	return s
}

// SetPublicIps sets the PublicIps field's value.
func (s *DescribeAddressesInput) SetPublicIps(v []*string) *DescribeAddressesInput {
	s.PublicIps = v
	return s
}

// Contains the output of DescribeAddresses.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesResult
type DescribeAddressesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more Elastic IP addresses.
	Addresses []*Address `locationName:"addressesSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressesOutput) GoString() string {
	return s.String()
}

// SetAddresses sets the Addresses field's value.
func (s *DescribeAddressesOutput) SetAddresses(v []*Address) *DescribeAddressesOutput {
	s.Addresses = v
	return s
}

// Contains the parameters for DescribeAvailabilityZones.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZonesRequest
type DescribeAvailabilityZonesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//    * message - Information about the Availability Zone.
	//
	//    * region-name - The name of the region for the Availability Zone (for
	//    example, us-east-1).
	//
	//    * state - The state of the Availability Zone (available | information
	//    | impaired | unavailable).
	//
	//    * zone-name - The name of the Availability Zone (for example, us-east-1a).
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The names of one or more Availability Zones.
	ZoneNames []*string `locationName:"ZoneName" locationNameList:"ZoneName" type:"list"`
}

// String returns the string representation
func (s DescribeAvailabilityZonesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAvailabilityZonesInput) GoString() string {
	return s.String()
}

// SetDryRun sets the DryRun field's value.
func (s *DescribeAvailabilityZonesInput) SetDryRun(v bool) *DescribeAvailabilityZonesInput {
	s.DryRun = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeAvailabilityZonesInput) SetFilters(v []*Filter) *DescribeAvailabilityZonesInput {
	s.Filters = v
	return s
}

// SetZoneNames sets the ZoneNames field's value.
func (s *DescribeAvailabilityZonesInput) SetZoneNames(v []*string) *DescribeAvailabilityZonesInput {
	s.ZoneNames = v
	return s
}

// Contains the output of DescribeAvailabiltyZones.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZonesResult
type DescribeAvailabilityZonesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more Availability Zones.
	AvailabilityZones []*AvailabilityZone `locationName:"availabilityZoneInfo" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeAvailabilityZonesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAvailabilityZonesOutput) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DescribeAvailabilityZonesOutput) SetAvailabilityZones(v []*AvailabilityZone) *DescribeAvailabilityZonesOutput {
	s.AvailabilityZones = v
	return s
}

// Contains the parameters for DescribeBundleTasks.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasksRequest
type DescribeBundleTasksInput struct {
	_ struct{} `type:"structure"`

	// One or more bundle task IDs.
	//
	// Default: Describes all your bundle tasks.
	BundleIds []*string `locationName:"BundleId" locationNameList:"BundleId" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//    * bundle-id - The ID of the bundle task.
	//
	//    * error-code - If the task failed, the error code returned.
	//
	//    * error-message - If the task failed, the error message returned.
	//
	//    * instance-id - The ID of the instance.
	//
	//    * progress - The level of task completion, as a percentage (for example,
	//    20%).
	//
	//    * s3-bucket - The Amazon S3 bucket to store the AMI.
	//
	//    * s3-prefix - The beginning of the AMI name.
	//
	//    * start-time - The time the task started (for example, 2013-09-15T17:15:20.000Z).
	//
	//    * state - The state of the task (pending | waiting-for-shutdown | bundling
	//    | storing | cancelling | complete | failed).
	//
	//    * update-time - The time of the most recent update for the task.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`
}

// String returns the string representation
func (s DescribeBundleTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBundleTasksInput) GoString() string {
	return s.String()
}

// SetBundleIds sets the BundleIds field's value.
func (s *DescribeBundleTasksInput) SetBundleIds(v []*string) *DescribeBundleTasksInput {
	s.BundleIds = v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *DescribeBundleTasksInput) SetDryRun(v bool) *DescribeBundleTasksInput {
	s.DryRun = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeBundleTasksInput) SetFilters(v []*Filter) *DescribeBundleTasksInput {
	s.Filters = v
	return s
}

// Contains the output of DescribeBundleTasks.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasksResult
type DescribeBundleTasksOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more bundle tasks.
	BundleTasks []*BundleTask `locationName:"bundleInstanceTasksSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeBundleTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBundleTasksOutput) GoString() string {
	return s.String()
}

// SetBundleTasks sets the BundleTasks field's value.
func (s *DescribeBundleTasksOutput) SetBundleTasks(v []*BundleTask) *DescribeBundleTasksOutput {
	s.BundleTasks = v
	return s
}

// Contains the parameters for DescribeClassicLinkInstances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstancesRequest
type DescribeClassicLinkInstancesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//    * group-id - The ID of a VPC security group that's associated with the
	//    instance.
	//
	//    * instance-id - The ID of the instance.
	//
	//    * tag:key=value - The key/value combination of a tag assigned to the resource.
	//
	//    * tag-key - The key of a tag assigned to the resource. This filter is
	//    independent of the tag-value filter. For example, if you use both the
	//    filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources
	//    assigned both the tag key Purpose (regardless of what the tag's value
	//    is), and the tag value X (regardless of what the tag's key is). If you
	//    want to list only resources where Purpose is X, see the tag:key=value
	//    filter.
	//
	//    * tag-value - The value of a tag assigned to the resource. This filter
	//    is independent of the tag-key filter.
	//
	//    * vpc-id - The ID of the VPC that the instance is linked to.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more instance IDs. Must be instances linked to a VPC through ClassicLink.
	InstanceIds []*string `locationName:"InstanceId" locationNameList:"InstanceId" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results of the initial request can be seen by sending another
	// request with the returned NextToken value. This value can be between 5 and
	// 1000; if MaxResults is given a value larger than 1000, only 1000 results
	// are returned. You cannot specify this parameter and the instance IDs parameter
	// in the same request.
	//
	// Constraint: If the value is greater than 1000, we return only 1000 items.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to retrieve the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeClassicLinkInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClassicLinkInstancesInput) GoString() string {
	return s.String()
}

// SetDryRun sets the DryRun field's value.
func (s *DescribeClassicLinkInstancesInput) SetDryRun(v bool) *DescribeClassicLinkInstancesInput {
	s.DryRun = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeClassicLinkInstancesInput) SetFilters(v []*Filter) *DescribeClassicLinkInstancesInput {
	s.Filters = v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *DescribeClassicLinkInstancesInput) SetInstanceIds(v []*string) *DescribeClassicLinkInstancesInput {
	s.InstanceIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeClassicLinkInstancesInput) SetMaxResults(v int64) *DescribeClassicLinkInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeClassicLinkInstancesInput) SetNextToken(v string) *DescribeClassicLinkInstancesInput {
	s.NextToken = &v
	return s
}

// Contains the output of DescribeClassicLinkInstances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstancesResult
type DescribeClassicLinkInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more linked EC2-Classic instances.
	Instances []*ClassicLinkInstance `locationName:"instancesSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeClassicLinkInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClassicLinkInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *DescribeClassicLinkInstancesOutput) SetInstances(v []*ClassicLinkInstance) *DescribeClassicLinkInstancesOutput {
	s.Instances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeClassicLinkInstancesOutput) SetNextToken(v string) *DescribeClassicLinkInstancesOutput {
	s.NextToken = &v
	return s
}

// Contains the parameters for DescribeConversionTasks.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasksRequest
type DescribeConversionTasksInput struct {
	_ struct{} `type:"structure"`

	// One or more conversion task IDs.
	ConversionTaskIds []*string `locationName:"conversionTaskId" locationNameList:"item" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s DescribeConversionTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConversionTasksInput) GoString() string {
	return s.String()
}

// SetConversionTaskIds sets the ConversionTaskIds field's value.
func (s *DescribeConversionTasksInput) SetConversionTaskIds(v []*string) *DescribeConversionTasksInput {
	s.ConversionTaskIds = v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *DescribeConversionTasksInput) SetDryRun(v bool) *DescribeConversionTasksInput {
	s.DryRun = &v
	return s
}

// Contains the output for DescribeConversionTasks.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasksResult
type DescribeConversionTasksOutput struct {
	_ struct{} `type:"structure"`

	// Information about the conversion tasks.
	ConversionTasks []*ConversionTask `locationName:"conversionTasks" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeConversionTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConversionTasksOutput) GoString() string {
	return s.String()
}

// SetConversionTasks sets the ConversionTasks field's value.
func (s *DescribeConversionTasksOutput) SetConversionTasks(v []*ConversionTask) *DescribeConversionTasksOutput {
	s.ConversionTasks = v
	return s
}

// Contains the parameters for DescribeCustomerGateways.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGatewaysRequest
type DescribeCustomerGatewaysInput struct {
	_ struct{} `type:"structure"`

	// One or more customer gateway IDs.
	//
	// Default: Describes all your customer gateways.
	CustomerGatewayIds []*string `locationName:"CustomerGatewayId" locationNameList:"CustomerGatewayId" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//    * bgp-asn - The customer gateway's Border Gateway Protocol (BGP) Autonomous
	//    System Number (ASN).
	//
	//    * customer-gateway-id - The ID of the customer gateway.
	//
	//    * ip-address - The IP address of the customer gateway's Internet-routable
	//    external interface.
	//
	//    * state - The state of the customer gateway (pending | available | deleting
	//    | deleted).
	//
	//    * type - The type of customer gateway. Currently, the only supported type
	//    is ipsec.1.
	//
	//    * tag:key=value - The key/value combination of a tag assigned to the resource.
	//    Specify the key of the tag in the filter name and the value of the tag
	//    in the filter value. For example, for the tag Purpose=X, specify tag:Purpose
	//    for the filter name and X for the filter value.
	//
	//    * tag-key - The key of a tag assigned to the resource. This filter is
	//    independent of the tag-value filter. For example, if you use both the
	//    filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources
	//    assigned both the tag key Purpose (regardless of what the tag's value
	//    is), and the tag value X (regardless of what the tag's key is). If you
	//    want to list only resources where Purpose is X, see the tag:key=value
	//    filter.
	//
	//    * tag-value - The value of a tag assigned to the resource. This filter
	//    is independent of the tag-key filter.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`
}

// String returns the string representation
func (s DescribeCustomerGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCustomerGatewaysInput) GoString() string {
	return s.String()
}

// SetCustomerGatewayIds sets the CustomerGatewayIds field's value.
func (s *DescribeCustomerGatewaysInput) SetCustomerGatewayIds(v []*string) *DescribeCustomerGatewaysInput {
	s.CustomerGatewayIds = v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *DescribeCustomerGatewaysInput) SetDryRun(v bool) *DescribeCustomerGatewaysInput {
	s.DryRun = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeCustomerGatewaysInput) SetFilters(v []*Filter) *DescribeCustomerGatewaysInput {
	s.Filters = v
	return s
}

// Contains the output of DescribeCustomerGateways.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGatewaysResult
type DescribeCustomerGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more customer gateways.
	CustomerGateways []*CustomerGateway `locationName:"customerGatewaySet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeCustomerGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCustomerGatewaysOutput) GoString() string {
	return s.String()
}

// SetCustomerGateways sets the CustomerGateways field's value.
func (s *DescribeCustomerGatewaysOutput) SetCustomerGateways(v []*CustomerGateway) *DescribeCustomerGatewaysOutput {
	s.CustomerGateways = v
	return s
}

// Contains the parameters for DescribeDhcpOptions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptionsRequest
type DescribeDhcpOptionsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of one or more DHCP options sets.
	//
	// Default: Describes all your DHCP options sets.
	DhcpOptionsIds []*string `locationName:"DhcpOptionsId" locationNameList:"DhcpOptionsId" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//    * dhcp-options-id - The ID of a set of DHCP options.
	//
	//    * key - The key for one of the options (for example, domain-name).
	//
	//    * value - The value for one of the options.
	//
	//    * tag:key=value - The key/value combination of a tag assigned to the resource.
	//    Specify the key of the tag in the filter name and the value of the tag
	//    in the filter value. For example, for the tag Purpose=X, specify tag:Purpose
	//    for the filter name and X for the filter value.
	//
	//    * tag-key - The key of a tag assigned to the resource. This filter is
	//    independent of the tag-value filter. For example, if you use both the
	//    filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources
	//    assigned both the tag key Purpose (regardless of what the tag's value
	//    is), and the tag value X (regardless of what the tag's key is). If you
	//    want to list only resources where Purpose is X, see the tag:key=value
	//    filter.
	//
	//    * tag-value - The value of a tag assigned to the resource. This filter
	//    is independent of the tag-key filter.
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`
}

// String returns the string representation
func (s DescribeDhcpOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDhcpOptionsInput) GoString() string {
	return s.String()
}

// SetDhcpOptionsIds sets the DhcpOptionsIds field's value.
func (s *DescribeDhcpOptionsInput) SetDhcpOptionsIds(v []*string) *DescribeDhcpOptionsInput {
	s.DhcpOptionsIds = v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *DescribeDhcpOptionsInput) SetDryRun(v bool) *DescribeDhcpOptionsInput {
	s.DryRun = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDhcpOptionsInput) SetFilters(v []*Filter) *DescribeDhcpOptionsInput {
	s.Filters = v
	return s
}

// Contains the output of DescribeDhcpOptions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptionsResult
type DescribeDhcpOptionsOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more DHCP options sets.
	DhcpOptions []*DhcpOptions `locationName:"dhcpOptionsSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeDhcpOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDhcpOptionsOutput) GoString() string {
	return s.String()
}

// SetDhcpOptions sets the DhcpOptions field's value.
func (s *DescribeDhcpOptionsOutput) SetDhcpOptions(v []*DhcpOptions) *DescribeDhcpOptionsOutput {
	s.DhcpOptions = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGatewaysRequest
type DescribeEgressOnlyInternetGatewaysInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more egress-only Internet gateway IDs.
	EgressOnlyInternetGatewayIds []*string `locationName:"EgressOnlyInternetGatewayId" locationNameList:"item" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results can be seen by sending another request with the returned
	// NextToken value. This value can be between 5 and 1000; if MaxResults is given
	// a value larger than 1000, only 1000 results are returned.
	MaxResults *int64 `type:"integer"`

	// The token to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeEgressOnlyInternetGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEgressOnlyInternetGatewaysInput) GoString() string {
	return s.String()
}

// SetDryRun sets the DryRun field's value.
func (s *DescribeEgressOnlyInternetGatewaysInput) SetDryRun(v bool) *DescribeEgressOnlyInternetGatewaysInput {
	s.DryRun = &v
	return s
}

// SetEgressOnlyInternetGatewayIds sets the EgressOnlyInternetGatewayIds field's value.
func (s *DescribeEgressOnlyInternetGatewaysInput) SetEgressOnlyInternetGatewayIds(v []*string) *DescribeEgressOnlyInternetGatewaysInput {
	s.EgressOnlyInternetGatewayIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeEgressOnlyInternetGatewaysInput) SetMaxResults(v int64) *DescribeEgressOnlyInternetGatewaysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEgressOnlyInternetGatewaysInput) SetNextToken(v string) *DescribeEgressOnlyInternetGatewaysInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGatewaysResult
type DescribeEgressOnlyInternetGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// Information about the egress-only Internet gateways.
	EgressOnlyInternetGateways []*EgressOnlyInternetGateway `locationName:"egressOnlyInternetGatewaySet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeEgressOnlyInternetGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEgressOnlyInternetGatewaysOutput) GoString() string {
	return s.String()
}

// SetEgressOnlyInternetGateways sets the EgressOnlyInternetGateways field's value.
func (s *DescribeEgressOnlyInternetGatewaysOutput) SetEgressOnlyInternetGateways(v []*EgressOnlyInternetGateway) *DescribeEgressOnlyInternetGatewaysOutput {
	s.EgressOnlyInternetGateways = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEgressOnlyInternetGatewaysOutput) SetNextToken(v string) *DescribeEgressOnlyInternetGatewaysOutput {
	s.NextToken = &v
	return s
}

// Contains the parameters for DescribeExportTasks.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasksRequest
type DescribeExportTasksInput struct {
	_ struct{} `type:"structure"`

	// One or more export task IDs.
	ExportTaskIds []*string `locationName:"exportTaskId" locationNameList:"ExportTaskId" type:"list"`
}

// String returns the string representation
func (s DescribeExportTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportTasksInput) GoString() string {
	return s.String()
}

// SetExportTaskIds sets the ExportTaskIds field's value.
func (s *DescribeExportTasksInput) SetExportTaskIds(v []*string) *DescribeExportTasksInput {
	s.ExportTaskIds = v
	return s
}

// Contains the output for DescribeExportTasks.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasksResult
type DescribeExportTasksOutput struct {
	_ struct{} `type:"structure"`

	// Information about the export tasks.
	ExportTasks []*ExportTask `locationName:"exportTaskSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeExportTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportTasksOutput) GoString() string {
	return s.String()
}

// SetExportTasks sets the ExportTasks field's value.
func (s *DescribeExportTasksOutput) SetExportTasks(v []*ExportTask) *DescribeExportTasksOutput {
	s.ExportTasks = v
	return s
}

// Contains the parameters for DescribeFlowLogs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogsRequest
type DescribeFlowLogsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters.
	//
	//    * deliver-log-status - The status of the logs delivery (SUCCESS | FAILED).
	//
	//    * flow-log-id - The ID of the flow log.
	//
	//    * log-group-name - The name of the log group.
	//
	//    * resource-id - The ID of the VPC, subnet, or network interface.
	//
	//    * traffic-type - The type of traffic (ACCEPT | REJECT | ALL)
	Filter []*Filter `locationNameList:"Filter" type:"list"`

	// One or more flow log IDs.
	FlowLogIds []*string `locationName:"FlowLogId" locationNameList:"item" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results can be seen by sending another request with the returned
	// NextToken value. This value can be between 5 and 1000; if MaxResults is given
	// a value larger than 1000, only 1000 results are returned. You cannot specify
	// this parameter and the flow log IDs parameter in the same request.
	MaxResults *int64 `type:"integer"`

	// The token to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeFlowLogsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowLogsInput) GoString() string {
	return s.String()
}

// SetFilter sets the Filter field's value.
func (s *DescribeFlowLogsInput) SetFilter(v []*Filter) *DescribeFlowLogsInput {
	s.Filter = v
	return s
}

// SetFlowLogIds sets the FlowLogIds field's value.
func (s *DescribeFlowLogsInput) SetFlowLogIds(v []*string) *DescribeFlowLogsInput {
	s.FlowLogIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeFlowLogsInput) SetMaxResults(v int64) *DescribeFlowLogsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFlowLogsInput) SetNextToken(v string) *DescribeFlowLogsInput {
	s.NextToken = &v
	return s
}

// Contains the output of DescribeFlowLogs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogsResult
type DescribeFlowLogsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the flow logs.
	FlowLogs []*FlowLog `locationName:"flowLogSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeFlowLogsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowLogsOutput) GoString() string {
	return s.String()
}

// SetFlowLogs sets the FlowLogs field's value.
func (s *DescribeFlowLogsOutput) SetFlowLogs(v []*FlowLog) *DescribeFlowLogsOutput {
	s.FlowLogs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFlowLogsOutput) SetNextToken(v string) *DescribeFlowLogsOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferingsRequest
type DescribeHostReservationOfferingsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters.
	//
	//    * instance-family - The instance family of the offering (e.g., m4).
	//
	//    * payment-option - The payment option (NoUpfront | PartialUpfront | AllUpfront).
	Filter []*Filter `locationNameList:"Filter" type:"list"`

	// This is the maximum duration of the reservation you'd like to purchase, specified
	// in seconds. Reservations are available in one-year and three-year terms.
	// The number of seconds specified must be the number of seconds in a year (365x24x60x60)
	// times one of the supported durations (1 or 3). For example, specify 94608000
	// for three years.
	MaxDuration *int64 `type:"integer"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results can be seen by sending another request with the returned
	// nextToken value. This value can be between 5 and 500; if maxResults is given
	// a larger value than 500, you will receive an error.
	MaxResults *int64 `type:"integer"`

	// This is the minimum duration of the reservation you'd like to purchase, specified
	// in seconds. Reservations are available in one-year and three-year terms.
	// The number of seconds specified must be the number of seconds in a year (365x24x60x60)
	// times one of the supported durations (1 or 3). For example, specify 31536000
	// for one year.
	MinDuration *int64 `type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`

	// The ID of the reservation offering.
	OfferingId *string `type:"string"`
}

// String returns the string representation
func (s DescribeHostReservationOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHostReservationOfferingsInput) GoString() string {
	return s.String()
}

// SetFilter sets the Filter field's value.
func (s *DescribeHostReservationOfferingsInput) SetFilter(v []*Filter) *DescribeHostReservationOfferingsInput {
	s.Filter = v
	return s
}

// SetMaxDuration sets the MaxDuration field's value.
func (s *DescribeHostReservationOfferingsInput) SetMaxDuration(v int64) *DescribeHostReservationOfferingsInput {
	s.MaxDuration = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeHostReservationOfferingsInput) SetMaxResults(v int64) *DescribeHostReservationOfferingsInput {
	s.MaxResults = &v
	return s
}

// SetMinDuration sets the MinDuration field's value.
func (s *DescribeHostReservationOfferingsInput) SetMinDuration(v int64) *DescribeHostReservationOfferingsInput {
	s.MinDuration = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeHostReservationOfferingsInput) SetNextToken(v string) *DescribeHostReservationOfferingsInput {
	s.NextToken = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *DescribeHostReservationOfferingsInput) SetOfferingId(v string) *DescribeHostReservationOfferingsInput {
	s.OfferingId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferingsResult
type DescribeHostReservationOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the offerings.
	OfferingSet []*HostOffering `locationName:"offeringSet" type:"list"`
}

// String returns the string representation
func (s DescribeHostReservationOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHostReservationOfferingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeHostReservationOfferingsOutput) SetNextToken(v string) *DescribeHostReservationOfferingsOutput {
	s.NextToken = &v
	return s
}

// SetOfferingSet sets the OfferingSet field's value.
func (s *DescribeHostReservationOfferingsOutput) SetOfferingSet(v []*HostOffering) *DescribeHostReservationOfferingsOutput {
	s.OfferingSet = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationsRequest
type DescribeHostReservationsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters.
	//
	//    * instance-family - The instance family (e.g., m4).
	//
	//    * payment-option - The payment option (NoUpfront | PartialUpfront | AllUpfront).
	//
	//    * state - The state of the reservation (payment-pending | payment-failed
	//    | active | retired).
	Filter []*Filter `locationNameList:"Filter" type:"list"`

	// One or more host reservation IDs.
	HostReservationIdSet []*string `locationNameList:"item" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results can be seen by sending another request with the returned
	// nextToken value. This value can be between 5 and 500; if maxResults is given
	// a larger value than 500, you will receive an error.
	MaxResults *int64 `type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeHostReservationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHostReservationsInput) GoString() string {
	return s.String()
}

// SetFilter sets the Filter field's value.
func (s *DescribeHostReservationsInput) SetFilter(v []*Filter) *DescribeHostReservationsInput {
	s.Filter = v
	return s
}

// SetHostReservationIdSet sets the HostReservationIdSet field's value.
func (s *DescribeHostReservationsInput) SetHostReservationIdSet(v []*string) *DescribeHostReservationsInput {
	s.HostReservationIdSet = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeHostReservationsInput) SetMaxResults(v int64) *DescribeHostReservationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeHostReservationsInput) SetNextToken(v string) *DescribeHostReservationsInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationsResult
type DescribeHostReservationsOutput struct {
	_ struct{} `type:"structure"`

	// Details about the reservation's configuration.
	HostReservationSet []*HostReservation `locationName:"hostReservationSet" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeHostReservationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHostReservationsOutput) GoString() string {
	return s.String()
}

// SetHostReservationSet sets the HostReservationSet field's value.
func (s *DescribeHostReservationsOutput) SetHostReservationSet(v []*HostReservation) *DescribeHostReservationsOutput {
	s.HostReservationSet = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeHostReservationsOutput) SetNextToken(v string) *DescribeHostReservationsOutput {
	s.NextToken = &v
	return s
}

// Contains the parameters for DescribeHosts.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostsRequest
type DescribeHostsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters.
	//
	//    * instance-type - The instance type size that the Dedicated Host is configured
	//    to support.
	//
	//    * auto-placement - Whether auto-placement is enabled or disabled (on |
	//    off).
	//
	//    * host-reservation-id - The ID of the reservation assigned to this host.
	//
	//    * client-token - The idempotency token you provided when you launched
	//    the instance
	//
	//    * state- The allocation state of the Dedicated Host (available | under-assessment
	//    | permanent-failure | released | released-permanent-failure).
	//
	//    * availability-zone - The Availability Zone of the host.
	Filter []*Filter `locationName:"filter" locationNameList:"Filter" type:"list"`

	// The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
	HostIds []*string `locationName:"hostId" locationNameList:"item" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results can be seen by sending another request with the returned
	// nextToken value. This value can be between 5 and 500; if maxResults is given
	// a larger value than 500, you will receive an error. You cannot specify this
	// parameter and the host IDs parameter in the same request.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to retrieve the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeHostsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHostsInput) GoString() string {
	return s.String()
}

// SetFilter sets the Filter field's value.
func (s *DescribeHostsInput) SetFilter(v []*Filter) *DescribeHostsInput {
	s.Filter = v
	return s
}

// SetHostIds sets the HostIds field's value.
func (s *DescribeHostsInput) SetHostIds(v []*string) *DescribeHostsInput {
	s.HostIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeHostsInput) SetMaxResults(v int64) *DescribeHostsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeHostsInput) SetNextToken(v string) *DescribeHostsInput {
	s.NextToken = &v
	return s
}

// Contains the output of DescribeHosts.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostsResult
type DescribeHostsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Dedicated Hosts.
	Hosts []*Host `locationName:"hostSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeHostsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHostsOutput) GoString() string {
	return s.String()
}

// SetHosts sets the Hosts field's value.
func (s *DescribeHostsOutput) SetHosts(v []*Host) *DescribeHostsOutput {
	s.Hosts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeHostsOutput) SetNextToken(v string) *DescribeHostsOutput {
	s.NextToken = &v
	return s
}

// Contains the parameters for DescribeIdFormat.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormatRequest
type DescribeIdFormatInput struct {
	_ struct{} `type:"structure"`

	// The type of resource: instance | reservation | snapshot | volume
	Resource *string `type:"string"`
}

// String returns the string representation
func (s DescribeIdFormatInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdFormatInput) GoString() string {
	return s.String()
}

// SetResource sets the Resource field's value.
func (s *DescribeIdFormatInput) SetResource(v string) *DescribeIdFormatInput {
	s.Resource = &v
	return s
}

// Contains the output of DescribeIdFormat.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormatResult
type DescribeIdFormatOutput struct {
	_ struct{} `type:"structure"`

	// Information about the ID format for the resource.
	Statuses []*IdFormat `locationName:"statusSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeIdFormatOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdFormatOutput) GoString() string {
	return s.String()
}

// SetStatuses sets the Statuses field's value.
func (s *DescribeIdFormatOutput) SetStatuses(v []*IdFormat) *DescribeIdFormatOutput {
	s.Statuses = v
	return s
}

// Contains the parameters for DescribeIdentityIdFormat.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormatRequest
type DescribeIdentityIdFormatInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the principal, which can be an IAM role, IAM user, or the root
	// user.
	//
	// PrincipalArn is a required field
	PrincipalArn *string `locationName:"principalArn" type:"string" required:"true"`

	// The type of resource: instance | reservation | snapshot | volume
	Resource *string `locationName:"resource" type:"string"`
}

// String returns the string representation
func (s DescribeIdentityIdFormatInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdentityIdFormatInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityIdFormatInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIdentityIdFormatInput"}
	if s.PrincipalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *DescribeIdentityIdFormatInput) SetPrincipalArn(v string) *DescribeIdentityIdFormatInput {
	s.PrincipalArn = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *DescribeIdentityIdFormatInput) SetResource(v string) *DescribeIdentityIdFormatInput {
	s.Resource = &v
	return s
}

// Contains the output of DescribeIdentityIdFormat.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormatResult
type DescribeIdentityIdFormatOutput struct {
	_ struct{} `type:"structure"`

	// Information about the ID format for the resources.
	Statuses []*IdFormat `locationName:"statusSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeIdentityIdFormatOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdentityIdFormatOutput) GoString() string {
	return s.String()
}

// SetStatuses sets the Statuses field's value.
func (s *DescribeIdentityIdFormatOutput) SetStatuses(v []*IdFormat) *DescribeIdentityIdFormatOutput {
	s.Statuses = v
	return s
}

// Contains the parameters for DescribeImageAttribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttributeRequest
type DescribeImageAttributeInput struct {
	_ struct{} `type:"structure"`

	// The AMI attribute.
	//
	// Note: Depending on your account privileges, the blockDeviceMapping attribute
	// may return a Client.AuthFailure error. If this happens, use DescribeImages
	// to get information about the block device mapping for the AMI.
	//
	// Attribute is a required field
	Attribute *string `type:"string" required:"true" enum:"ImageAttributeName"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the AMI.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeImageAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImageAttributeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImageAttributeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeImageAttributeInput"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *DescribeImageAttributeInput) SetAttribute(v string) *DescribeImageAttributeInput {
	s.Attribute = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *DescribeImageAttributeInput) SetDryRun(v bool) *DescribeImageAttributeInput {
	s.DryRun = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *DescribeImageAttributeInput) SetImageId(v string) *DescribeImageAttributeInput {
	s.ImageId = &v
	return s
}

// Describes an image attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImageAttribute
type DescribeImageAttributeOutput struct {
	_ struct{} `type:"structure"`

	// One or more block device mapping entries.
	BlockDeviceMappings []*BlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// A description for the AMI.
	Description *AttributeValue `locationName:"description" type:"structure"`

	// The ID of the AMI.
	ImageId *string `locationName:"imageId" type:"string"`

	// The kernel ID.
	KernelId *AttributeValue `locationName:"kernel" type:"structure"`

	// One or more launch permissions.
	LaunchPermissions []*LaunchPermission `locationName:"launchPermission" locationNameList:"item" type:"list"`

	// One or more product codes.
	ProductCodes []*ProductCode `locationName:"productCodes" locationNameList:"item" type:"list"`

	// The RAM disk ID.
	RamdiskId *AttributeValue `locationName:"ramdisk" type:"structure"`

	// Indicates whether enhanced networking with the Intel 82599 Virtual Function
	// interface is enabled.
	SriovNetSupport *AttributeValue `locationName:"sriovNetSupport" type:"structure"`
}

// String returns the string representation
func (s DescribeImageAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImageAttributeOutput) GoString() string {
	return s.String()
}

// SetBlockDeviceMappings sets the BlockDeviceMappings field's value.
func (s *DescribeImageAttributeOutput) SetBlockDeviceMappings(v []*BlockDeviceMapping) *DescribeImageAttributeOutput {
	s.BlockDeviceMappings = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeImageAttributeOutput) SetDescription(v *AttributeValue) *DescribeImageAttributeOutput {
	s.Description = v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *DescribeImageAttributeOutput) SetImageId(v string) *DescribeImageAttributeOutput {
	s.ImageId = &v
	return s
}

// SetKernelId sets the KernelId field's value.
func (s *DescribeImageAttributeOutput) SetKernelId(v *AttributeValue) *DescribeImageAttributeOutput {
	s.KernelId = v
	return s
}

// SetLaunchPermissions sets the LaunchPermissions field's value.
func (s *DescribeImageAttributeOutput) SetLaunchPermissions(v []*LaunchPermission) *DescribeImageAttributeOutput {
	s.LaunchPermissions = v
	return s
}

// SetProductCodes sets the ProductCodes field's value.
func (s *DescribeImageAttributeOutput) SetProductCodes(v []*ProductCode) *DescribeImageAttributeOutput {
	s.ProductCodes = v
	return s
}

// SetRamdiskId sets the RamdiskId field's value.
func (s *DescribeImageAttributeOutput) SetRamdiskId(v *AttributeValue) *DescribeImageAttributeOutput {
	s.RamdiskId = v
	return s
}

// SetSriovNetSupport sets the SriovNetSupport field's value.
func (s *DescribeImageAttributeOutput) SetSriovNetSupport(v *AttributeValue) *DescribeImageAttributeOutput {
	s.SriovNetSupport = v
	return s
}

// Contains the parameters for DescribeImages.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImagesRequest
type DescribeImagesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Scopes the images by users with explicit launch permissions. Specify an AWS
	// account ID, self (the sender of the request), or all (public AMIs).
	ExecutableUsers []*string `locationName:"ExecutableBy" locationNameList:"ExecutableBy" type:"list"`

	// One or more filters.
	//
	//    * architecture - The image architecture (i386 | x86_64).
	//
	//    * block-device-mapping.delete-on-termination - A Boolean value that indicates
	//    whether the Amazon EBS volume is deleted on instance termination.
	//
	//    * block-device-mapping.device-name - The device name for the EBS volume
	//    (for example, /dev/sdh).
	//
	//    * block-device-mapping.snapshot-id - The ID of the snapshot used for the
	//    EBS volume.
	//
	//    * block-device-mapping.volume-size - The volume size of the EBS volume,
	//    in GiB.
	//
	//    * block-device-mapping.volume-type - The volume type of the EBS volume
	//    (gp2 | io1 | st1 | sc1 | standard).
	//
	//    * description - The description of the image (provided during image creation).
	//
	//    * ena-support - A Boolean that indicates whether enhanced networking with
	//    ENA is enabled.
	//
	//    * hypervisor - The hypervisor type (ovm | xen).
	//
	//    * image-id - The ID of the image.
	//
	//    * image-type - The image type (machine | kernel | ramdisk).
	//
	//    * is-public - A Boolean that indicates whether the image is public.
	//
	//    * kernel-id - The kernel ID.
	//
	//    * manifest-location - The location of the image manifest.
	//
	//    * name - The name of the AMI (provided during image creation).
	//
	//    * owner-alias - String value from an Amazon-maintained list (amazon |
	//    aws-marketplace | microsoft) of snapshot owners. Not to be confused with
	//    the user-configured AWS account alias, which is set from the IAM console.
	//
	//    * owner-id - The AWS account ID of the image owner.
	//
	//    * platform - The platform. To only list Windows-based AMIs, use windows.
	//
	//    * product-code - The product code.
	//
	//    * product-code.type - The type of the product code (devpay | marketplace).
	//
	//    * ramdisk-id - The RAM disk ID.
	//
	//    * root-device-name - The name of the root device volume (for example,
	//    /dev/sda1).
	//
	//    * root-device-type - The type of the root device volume (ebs | instance-store).
	//
	//    * state - The state of the image (available | pending | failed).
	//
	//    * state-reason-code - The reason code for the state change.
	//
	//    * state-reason-message - The message for the state change.
	//
	//    * tag:key=value - The key/value combination of a tag assigned to the resource.
	//    Specify the key of the tag in the filter name and the value of the tag
	//    in the filter value. For example, for the tag Purpose=X, specify tag:Purpose
	//    for the filter name and X for the filter value.
	//
	//    * tag-key - The key of a tag assigned to the resource. This filter is
	//    independent of the tag-value filter. For example, if you use both the
	//    filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources
	//    assigned both the tag key Purpose (regardless of what the tag's value
	//    is), and the tag value X (regardless of what the tag's key is). If you
	//    want to list only resources where Purpose is X, see the tag:key=value
	//    filter.
	//
	//    * tag-value - The value of a tag assigned to the resource. This filter
	//    is independent of the tag-key filter.
	//
	//    * virtualization-type - The virtualization type (paravirtual | hvm).
	Filters []*Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more image IDs.
	//
	// Default: Describes all images available to you.
	ImageIds []*string `locationName:"ImageId" locationNameList:"ImageId" type:"list"`

	// Filters the images by the owner. Specify an AWS account ID, self (owner is
	// the sender of the request), or an AWS owner alias (valid values are amazon
	// | aws-marketplace | microsoft). Omitting this option returns all images for
	// which you have launch permissions, regardless of ownership.
	Owners []*string `locationName:"Owner" locationNameList:"Owner" type:"list"`
}

// String returns the string representation
func (s DescribeImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagesInput) GoString() string {
	return s.String()
}

// SetDryRun sets the DryRun field's value.
func (s *DescribeImagesInput) SetDryRun(v bool) *DescribeImagesInput {
	s.DryRun = &v
	return s
}

// SetExecutableUsers sets the ExecutableUsers field's value.
func (s *DescribeImagesInput) SetExecutableUsers(v []*string) *DescribeImagesInput {
	s.ExecutableUsers = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeImagesInput) SetFilters(v []*Filter) *DescribeImagesInput {
	s.Filters = v
	return s
}

// SetImageIds sets the ImageIds field's value.
func (s *DescribeImagesInput) SetImageIds(v []*string) *DescribeImagesInput {
	s.ImageIds = v
	return s
}

// SetOwners sets the Owners field's value.
func (s *DescribeImagesInput) SetOwners(v []*string) *DescribeImagesInput {
	s.Owners = v
	return s
}

// Contains the output of DescribeImages.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImagesResult
type DescribeImagesOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more images.
	Images []*Image `locationName:"imagesSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagesOutput) GoString() string {
	return s.String()
}

// SetImages sets the Images field's value.
func (s *DescribeImagesOutput) SetImages(v []*Image) *DescribeImagesOutput {
	s.Images = v
	return s
}

// Contains the parameters for DescribeImportImageTasks.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasksRequest
type DescribeImportImageTasksInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// Filter tasks using the task-state filter and one of the following values:
	// active, completed, deleting, deleted.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// A list of import image task IDs.
	ImportTaskIds []*string `locationName:"ImportTaskId" locationNameList:"ImportTaskId" type:"list"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int64 `type:"integer"`

	// A token that indicates the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeImportImageTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImportImageTasksInput) GoString() string {
	return s.String()
}

// SetDryRun sets the DryRun field's value.
func (s *DescribeImportImageTasksInput) SetDryRun(v bool) *DescribeImportImageTasksInput {
	s.DryRun = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeImportImageTasksInput) SetFilters(v []*Filter) *DescribeImportImageTasksInput {
	s.Filters = v
	return s
}

// SetImportTaskIds sets the ImportTaskIds field's value.
func (s *DescribeImportImageTasksInput) SetImportTaskIds(v []*string) *DescribeImportImageTasksInput {
	s.ImportTaskIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeImportImageTasksInput) SetMaxResults(v int64) *DescribeImportImageTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImportImageTasksInput) SetNextToken(v string) *DescribeImportImageTasksInput {
	s.NextToken = &v
	return s
}

// Contains the output for DescribeImportImageTasks.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasksResult
type DescribeImportImageTasksOutput struct {
	_ struct{} `type:"structure"`

	// A list of zero or more import image tasks that are currently active or were
	// completed or canceled in the previous 7 days.
	ImportImageTasks []*ImportImageTask `locationName:"importImageTaskSet" locationNameList:"item" type:"list"`

	// The token to use to get the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeImportImageTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImportImageTasksOutput) GoString() string {
	return s.String()
}

// SetImportImageTasks sets the ImportImageTasks field's value.
func (s *DescribeImportImageTasksOutput) SetImportImageTasks(v []*ImportImageTask) *DescribeImportImageTasksOutput {
	s.ImportImageTasks = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImportImageTasksOutput) SetNextToken(v string) *DescribeImportImageTasksOutput {
	s.NextToken = &v
	return s
}

// Contains the parameters for DescribeImportSnapshotTasks.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasksRequest
type DescribeImportSnapshotTasksInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// A list of import snapshot task IDs.
	ImportTaskIds []*string `locationName:"ImportTaskId" locationNameList:"ImportTaskId" type:"list"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int64 `type:"integer"`

	// A token that indicates the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeImportSnapshotTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImportSnapshotTasksInput) GoString() string {
	return s.String()
}

// SetDryRun sets the DryRun field's value.
func (s *DescribeImportSnapshotTasksInput) SetDryRun(v bool) *DescribeImportSnapshotTasksInput {
	s.DryRun = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeImportSnapshotTasksInput) SetFilters(v []*Filter) *DescribeImportSnapshotTasksInput {
	s.Filters = v
	return s
}

// SetImportTaskIds sets the ImportTaskIds field's value.
func (s *DescribeImportSnapshotTasksInput) SetImportTaskIds(v []*string) *DescribeImportSnapshotTasksInput {
	s.ImportTaskIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeImportSnapshotTasksInput) SetMaxResults(v int64) *DescribeImportSnapshotTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImportSnapshotTasksInput) SetNextToken(v string) *DescribeImportSnapshotTasksInput {
	s.NextToken = &v
	return s
}

// Contains the output for DescribeImportSnapshotTasks.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasksResult
type DescribeImportSnapshotTasksOutput struct {
	_ struct{} `type:"structure"`

	// A list of zero or more import snapshot tasks that are currently active or
	// were completed or canceled in the previous 7 days.
	ImportSnapshotTasks []*ImportSnapshotTask `locationName:"importSnapshotTaskSet" locationNameList:"item" type:"list"`

	// The token to use to get the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeImportSnapshotTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImportSnapshotTasksOutput) GoString() string {
	return s.String()
}

// SetImportSnapshotTasks sets the ImportSnapshotTasks field's value.
func (s *DescribeImportSnapshotTasksOutput) SetImportSnapshotTasks(v []*ImportSnapshotTask) *DescribeImportSnapshotTasksOutput {
	s.ImportSnapshotTasks = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImportSnapshotTasksOutput) SetNextToken(v string) *DescribeImportSnapshotTasksOutput {
	s.NextToken = &v
	return s
}

// Contains the parameters for DescribeInstanceAttribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttributeRequest
type DescribeInstanceAttributeInput struct {
	_ struct{} `type:"structure"`

	// The instance attribute.
	//
	// Note: The enaSupport attribute is not supported at this time.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"InstanceAttributeName"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInstanceAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceAttributeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceAttributeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstanceAttributeInput"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *DescribeInstanceAttributeInput) SetAttribute(v string) *DescribeInstanceAttributeInput {
	s.Attribute = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *DescribeInstanceAttributeInput) SetDryRun(v bool) *DescribeInstanceAttributeInput {
	s.DryRun = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeInstanceAttributeInput) SetInstanceId(v string) *DescribeInstanceAttributeInput {
	s.InstanceId = &v
	return s
}

// Describes an instance attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceAttribute
type DescribeInstanceAttributeOutput struct {
	_ struct{} `type:"structure"`

	// The block device mapping of the instance.
	BlockDeviceMappings []*InstanceBlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"item" type:"list"`

	// If the value is true, you can't terminate the instance through the Amazon
	// EC2 console, CLI, or API; otherwise, you can.
	DisableApiTermination *AttributeBooleanValue `locationName:"disableApiTermination" type:"structure"`

	// Indicates whether the instance is optimized for EBS I/O.
	EbsOptimized *AttributeBooleanValue `locationName:"ebsOptimized" type:"structure"`

	// Indicates whether enhanced networking with ENA is enabled.
	EnaSupport *AttributeBooleanValue `locationName:"enaSupport" type:"structure"`

	// The security groups associated with the instance.
	Groups []*GroupIdentifier `locationName:"groupSet" locationNameList:"item" type:"list"`

	// The ID of the instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// Indicates whether an instance stops or terminates when you initiate shutdown
	// from the instance (using the operating system command for system shutdown).
	InstanceInitiatedShutdownBehavior *AttributeValue `locationName:"instanceInitiatedShutdownBehavior" type:"structure"`

	// The instance type.
	InstanceType *AttributeValue `locationName:"instanceType" type:"structure"`

	// The kernel ID.
	KernelId *AttributeValue `locationName:"kernel" type:"structure"`

	// A list of product codes.
	ProductCodes []*ProductCode `locationName:"productCodes" locationNameList:"item" type:"list"`

	// The RAM disk ID.
	RamdiskId *AttributeValue `locationName:"ramdisk" type:"structure"`

	// The name of the root device (for example, /dev/sda1 or /dev/xvda).
	RootDeviceName *AttributeValue `locationName:"rootDeviceName" type:"structure"`

	// Indicates whether source/destination checking is enabled. A value of true
	// means checking is enabled, and false means checking is disabled. This value
	// must be false for a NAT instance to perform NAT.
	SourceDestCheck *AttributeBooleanValue `locationName:"sourceDestCheck" type:"structure"`

	// Indicates whether enhanced networking with the Intel 82599 Virtual Function
	// interface is enabled.
	SriovNetSupport *AttributeValue `locationName:"sriovNetSupport" type:"structure"`

	// The user data.
	UserData *AttributeValue `locationName:"userData" type:"structure"`
}

// String returns the string representation
func (s DescribeInstanceAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceAttributeOutput) GoString() string {
	return s.String()
}

// SetBlockDeviceMappings sets the BlockDeviceMappings field's value.
func (s *DescribeInstanceAttributeOutput) SetBlockDeviceMappings(v []*InstanceBlockDeviceMapping) *DescribeInstanceAttributeOutput {
	s.BlockDeviceMappings = v
	return s
}

// SetDisableApiTermination sets the DisableApiTermination field's value.
func (s *DescribeInstanceAttributeOutput) SetDisableApiTermination(v *AttributeBooleanValue) *DescribeInstanceAttributeOutput {
	s.DisableApiTermination = v
	return s
}

// SetEbsOptimized sets the EbsOptimized field's value.
func (s *DescribeInstanceAttributeOutput) SetEbsOptimized(v *AttributeBooleanValue) *DescribeInstanceAttributeOutput {
	s.EbsOptimized = v
	return s
}

// SetEnaSupport sets the EnaSupport field's value.
func (s *DescribeInstanceAttributeOutput) SetEnaSupport(v *AttributeBooleanValue) *DescribeInstanceAttributeOutput {
	s.EnaSupport = v
	return s
}

// SetGroups sets the Groups field's value.
func (s *DescribeInstanceAttributeOutput) SetGroups(v []*GroupIdentifier) *DescribeInstanceAttributeOutput {
	s.Groups = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeInstanceAttributeOutput) SetInstanceId(v string) *DescribeInstanceAttributeOutput {
	s.InstanceId = &v
	return s
}

// SetInstanceInitiatedShutdownBehavior sets the InstanceInitiatedShutdownBehavior field's value.
func (s *DescribeInstanceAttributeOutput) SetInstanceInitiatedShutdownBehavior(v *AttributeValue) *DescribeInstanceAttributeOutput {
	s.InstanceInitiatedShutdownBehavior = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *DescribeInstanceAttributeOutput) SetInstanceType(v *AttributeValue) *DescribeInstanceAttributeOutput {
	s.InstanceType = v
	return s
}

// SetKernelId sets the KernelId field's value.
func (s *DescribeInstanceAttributeOutput) SetKernelId(v *AttributeValue) *DescribeInstanceAttributeOutput {
	s.KernelId = v
	return s
}

// SetProductCodes sets the ProductCodes field's value.
func (s *DescribeInstanceAttributeOutput) SetProductCodes(v []*ProductCode) *DescribeInstanceAttributeOutput {
	s.ProductCodes = v
	return s
}

// SetRamdiskId sets the RamdiskId field's value.
func (s *DescribeInstanceAttributeOutput) SetRamdiskId(v *AttributeValue) *DescribeInstanceAttributeOutput {
	s.RamdiskId = v
	return s
}

// SetRootDeviceName sets the RootDeviceName field's value.
func (s *DescribeInstanceAttributeOutput) SetRootDeviceName(v *AttributeValue) *DescribeInstanceAttributeOutput {
	s.RootDeviceName = v
	return s
}

// SetSourceDestCheck sets the SourceDestCheck field's value.
func (s *DescribeInstanceAttributeOutput) SetSourceDestCheck(v *AttributeBooleanValue) *DescribeInstanceAttributeOutput {
	s.SourceDestCheck = v
	return s
}

// SetSriovNetSupport sets the SriovNetSupport field's value.
func (s *DescribeInstanceAttributeOutput) SetSriovNetSupport(v *AttributeValue) *DescribeInstanceAttributeOutput {
	s.SriovNetSupport = v
	return s
}

// SetUserData sets the UserData field's value.
func (s *DescribeInstanceAttributeOutput) SetUserData(v *AttributeValue) *DescribeInstanceAttributeOutput {
	s.UserData = v
	return s
}

// Contains the parameters for DescribeInstanceStatus.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatusRequest
type DescribeInstanceStatusInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//    * availability-zone - The Availability Zone of the instance.
	//
	//    * event.code - The code for the scheduled event (instance-reboot | system-reboot
	//    | system-maintenance | instance-retirement | instance-stop).
	//
	//    * event.description - A description of the event.
	//
	//    * event.not-after - The latest end time for the scheduled event (for example,
	//    2014-09-15T17:15:20.000Z).
	//
	//    * event.not-before - The earliest start time for the scheduled event (for
	//    example, 2014-09-15T17:15:20.000Z).
	//
	//    * instance-state-code - The code for t