<!--[metadata]>
+++
title = "S3 storage driver"
description = "Explains how to use the S3 storage drivers"
keywords = ["registry, service, driver, images, storage,  S3"]
+++
<![end-metadata]-->


# S3 storage driver

An implementation of the `storagedriver.StorageDriver` interface which uses Amazon S3 or S3 compatible services for object storage.

## Parameters

<table>
  <tr>
    <th>Parameter</th>
    <th>Required</th>
    <th>Description</th>
  </tr>
  <tr>
    <td>
      <code>accesskey</code>
    </td>
    <td>
      yes
    </td>
    <td>
      Your AWS Access Key.
    </td>
  </tr>
  <tr>
    <td>
      <code>secretkey</code>
    </td>
    <td>
      yes
    </td>
    <td>
      Your AWS Secret Key.
    </td>
  </tr>
  <tr>
    <td>
      <code>region</code>
    </td>
    <td>
      yes
    </td>
    <td>
      The AWS region in which your bucket exists. For the moment, the Go AWS
      library in use does not use the newer DNS based bucket routing.
    </td>
  </tr>
  <tr>
    <td>
      <code>regionendpoint</code>
    </td>
    <td>
      no
    </td>
    <td>
      Endpoint for S3 compatible storage services (Minio, etc)
    </td>
  </tr>
    <tr>
    <td>
      <code>bucket</code>
    </td>
    <td>
      yes
    </td>
    <td>
      The bucket name in which you want to store the registry's data.
    </td>
  </tr>
  <tr>
    <td>
      <code>encrypt</code>
    </td>
    <td>
      no
    </td>
    <td>
       Specifies whether the registry stores the image in encrypted format or
       not. A boolean value. The default is false.
    </td>
  </tr>
  <tr>
    <td>
      <code>keyid</code>
    </td>
    <td>
      no
    </td>
    <td>
       Optional KMS key ID to use for encryption (encrypt must be true, or this
       parameter will be ignored). The default is none.
    </td>
  </tr>
  <tr>
    <td>
      <code>secure</code>
    </td>
    <td>
      no
    </td>
    <td>
      Indicates whether to use HTTPS instead of HTTP. A boolean value. The
      default is <code>true</code>.
    </td>
  </tr>
  <tr>
    <td>
      <code>v4auth</code>
    </td>
    <td>
      no
    </td>
    <td>
      Indicates whether the registry uses Version 4 of AWS's authentication.
      Generally, you should set this to <code>true</code>. By default, this is
      <code>false</code>.
    </td>
  </tr>
  <tr>
    <td>
      <code>chunksize</code>
    </td>
    <td>
      no
    </td>
    <td>
      The S3 API requires multipart upload chunks to be at least 5MB. This value
      should be a number that is larger than 5*1024*1024.
    </td>
  </tr>
  <tr>
    <td>
      <code>rootdirectory</code>
    </td>
    <td>
      no
    </td>
    <td>
      This is a prefix that will be applied to all S3 keys to allow you to segment data in your bucket if necessary.
    </td>
  </tr>
  <tr>
    <td>
      <code>storageclass</code>
    </td>
    <td>
      no
    </td>
    <td>
      The S3 storage class applied to each registry file. The default value is STANDARD.
    </td>
  </tr>
</table>


`accesskey`: Your aws access key.

`secretkey`: Your aws secret key.

**Note** You can provide empty strings for your access and secret keys if you plan on running the driver on an ec2 instance and will handle authentication with the instance's credentials.

`region`: The name of the aws region in which you would like to store objects (for example `us-east-1`). For a list of regions, you can look at http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html

`regionendpoint`: (optional) Endpoint URL for S3 compatible APIs. This should not be provided when using Amazon S3.

`bucket`: The name of your S3 bucket where you wish to store objects. The bucket must exist prior to the driver initialization.

`encrypt`: (optional) Whether you would like your data encrypted on the server side (defaults to false if not specified).

`keyid`: (optional) Whether you would like your data encrypted with this KMS key ID (defaults to none if not specified, will be ignored if encrypt is not true).

`secure`: (optional) Whether you would like to transfer data to the bucket over ssl or not. Defaults to true (meaning transferring over ssl) if not specified. Note that while setting this to false will improve performance, it is not recommended due to security concerns.

`v4auth`: (optional) Whether you would like to use aws signature version 4 with your requests. This defaults to false if not specified (note that the eu-central-1 region does not work with version 2 signatures, so the driver will error out if initialized with this region and v4auth set to false)

`chunksize`: (optional) The default part size for multipart uploads (performed by WriteStream) to S3. The default is 10 MB. Keep in mind that the minimum part size for S3 is 5MB. Depending on the speed of your connection to S3, a larger chunk size may result in better performance; faster connections will benefit from larger chunk sizes.

`rootdirectory`: (optional) The root directory tree in which all registry files will be stored. Defaults to the empty string (bucket root).

`storageclass`: (optional) The storage class applied to each registry file. Defaults to STANDARD. Valid options are STANDARD and REDUCED_REDUNDANCY.

## S3 permission scopes

The following IAM permissions are required by the registry for push and pull.  See [the S3 policy documentation](http://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html) for more details.

```
 "Statement": [
      {
        "Effect": "Allow",
        "Action": [
          "s3:ListBucket",
          "s3:GetBucketLocation",
          "s3:ListBucketMultipartUploads"
        ],
        "Resource": "arn:aws:s3:::mybucket"
      },
      {
        "Effect": "Allow",
        "Action": [
          "s3:PutObject",
          "s3:GetObject",
          "s3:DeleteObject",
          "s3:ListMultipartUploadParts",
          "s3:AbortMultipartUpload"
        ],
        "Resource": "arn:aws:s3:::mybucket/*"
      }
]
```

# CloudFront as Middleware with S3 backend

## Use Case

Adding CloudFront as a middleware for your S3 backed registry can dramatically improve pull times. Your registry will have the ability to retrieve your images from edge servers, rather than the geographically limited location of your S3 bucket. The farther your registry is from your bucket, the more improvements you will see. See [Amazon CloudFront](https://aws.amazon.com/cloudfront/details/).

## Configuring CloudFront for Distribution

If you are unfamiliar with creating a CloudFront distribution, see [Getting Started with Cloudfront](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/GettingStarted.html).

Defaults can be kept in most areas except:

### Origin:

The CloudFront distribution must be created such that the `Origin Path` is set to the directory level of the root "docker" key in S3. If your registry exists on the root of the bucket, this path should be left blank.

### Behaviors:

  - Viewer Protocol Policy: HTTPS Only
  - Allowed HTTP Methods: GET, HEAD, OPTIONS, PUT, POST, PATCH, DELETE
  - Cached HTTP Methods: OPTIONS (checked)
  - Restrict Viewer Access (Use Signed URLs or Signed Cookies): Yes
    - Trusted Signers: Self (Can add other accounts as long as you have access to CloudFront Key Pairs for those additional accounts)

## Registry configuration

Here the `middleware` option is used. It is still important to keep the `storage` option as CloudFront will only handle `pull` actions; `push` actions are still directly written to S3.

The following example shows what you will need at minimum:
```
...
storage:
  s3:
    region: us-east-1
    bucket: docker.myregistry.com
middleware:
  storage:
    - name: cloudfront
      options:
        baseurl: https://abcdefghijklmn.cloudfront.net/
        privatekey: /etc/docker/cloudfront/pk-ABCEDFGHIJKLMNOPQRST.pem
        keypairid: ABCEDFGHIJKLMNOPQRST
...
```

## CloudFront Key-Pair

A CloudFront key-pair is required for all AWS accounts needing access to your CloudFront distribution. For information, please see [Creating CloudFront Key Pairs](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html#private-content-creating-cloudfront-key-pairs).
