"	% $Id: html-btxbst.doc 1.5 2010/12/08 19:02:34 dds Exp $\n"
"	% \n"
"	% This file is either \"html-btxbst.doc\" or was derived from\n"
"	% \"html-btxbst.doc\" using cpp.  \"html-btxbst.doc\" itself was edited\n"
"	% from \"btxbst.doc\" and \"named.bst\".\n"
"	% The following copyright information is from btxbst.doc:\n"
"	% version 0.99b for BibTeX versions 0.99a or later, LaTeX version 2.09.\n"
"	% Copyright (C) 1985, all rights reserved.\n"
"	% Copying of this file is authorized only if either\n"
"	% (1) you make absolutely no changes to your copy, including name, or\n"
"	% (2) if you do make changes, you name it something other than\n"
"	% btxbst.doc, plain.bst, unsrt.bst, alpha.bst, and abbrv.bst.\n"
"	% This restriction helps ensure that all standard styles are identical.\n"
"	% The file btxbst.doc has the documentation for this style.\n"
" % \"named\" style (sorted keys of the form [name, year])\n"
" % Some code for this was taken from \"named.bst\".\n"
"\n"
"ENTRY\n"
"  { address\n"
"    author\n"
"    booktitle\n"
"    chapter\n"
"    edition\n"
"    editor\n"
"    howpublished\n"
"    institution\n"
"    journal\n"
"    key\n"
"    month\n"
"    note\n"
"    number\n"
"    organization\n"
"    pages\n"
"    publisher\n"
"    school\n"
"    series\n"
"    title\n"
"    type\n"
"    volume\n"
"    year\n"
"    dvi\n"
"    html\n"
"    keywords\n"
"    pdf\n"
"    postscript\n"
"    url\n"
"    doi\n"
"    mailto\n"
"  }\n"
"  {}\n"
"  { label extra.label sort.label }\n"
"\n"
"INTEGERS { output.state before.all mid.sentence after.sentence after.block }\n"
"\n"
"FUNCTION {init.state.consts}\n"
"{ #0 'before.all :=\n"
"  #1 'mid.sentence :=\n"
"  #2 'after.sentence :=\n"
"  #3 'after.block :=\n"
"}\n"
"\n"
"STRINGS { s t }\n"
"\n"
"FUNCTION {output.nonnull}\n"
"{ 's :=\n"
"  output.state mid.sentence =\n"
"    { \", \" * write$ }\n"
"    { output.state after.block =\n"
"	{ add.period$ write$\n"
"	  newline$\n"
"	}\n"
"	{ output.state before.all =\n"
"	    'write$\n"
"	    { add.period$ \" \" * write$ }\n"
"	  if$\n"
"	}\n"
"      if$\n"
"      mid.sentence 'output.state :=\n"
"    }\n"
"  if$\n"
"  s\n"
"}\n"
"\n"
"FUNCTION {output}\n"
"{ duplicate$ empty$\n"
"    'pop$\n"
"    'output.nonnull\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {output.check}\n"
"{ 't :=\n"
"  duplicate$ empty$\n"
"    { pop$ \"empty \" t * \" in \" * cite$ * warning$ }\n"
"    'output.nonnull\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {output.bibitem}\n"
"{ newline$\n"
"  author empty$\n"
"    { editor empty$\n"
"	{ organization empty$\n"
"	    'skip$\n"
"	    { \"<!-- Authors: \" organization purify$ * \" -->\" * write$ newline$ }\n"
"          if$\n"
"	} \n"
"        { \"<!-- Authors: \" editor purify$ * \" -->\" * write$ newline$ }\n"
"      if$\n"
"    }\n"
"    { \"<!-- Authors: \" author purify$ * \" -->\" * write$ newline$ }\n"
"  if$\n"
"  keywords empty$\n"
"    'skip$\n"
"    { \"<!-- Keywords: \" keywords * \" -->\" * write$ newline$ }\n"
"  if$\n"
"  \"<dt><a name=\" quote$ * \"CITEREF_\" * cite$ * quote$ * \">[\" * label * \"]</a></dt><dd>\" * write$\n"
"  \"\"\n"
"  before.all 'output.state :=\n"
"}\n"
"\n"
"FUNCTION {fin.entry}\n"
"{ add.period$\n"
"  write$\n"
"  postscript empty$\n"
"    'skip$\n"
"    { newline$ \"<!-- PostScript: \" postscript * \" -->\" * write$ }\n"
"  if$\n"
"  pdf empty$\n"
"    'skip$\n"
"    { newline$ \"<!-- PDF: \" pdf * \" -->\" * write$ }\n"
"  if$\n"
"  dvi empty$\n"
"    'skip$\n"
"    { newline$ \"<!-- DVI: \" dvi * \" -->\" * write$ }\n"
"  if$\n"
"  doi empty$\n"
"    'skip$\n"
"    { newline$ \"<!-- DOI: \" doi * \" -->\" * write$ }\n"
"  if$\n"
"  \"</dd>\" write$\n"
"  newline$\n"
"  newline$\n"
"}\n"
"\n"
"FUNCTION {new.block}\n"
"{ output.state before.all =\n"
"    'skip$\n"
"    { after.block 'output.state := }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {new.sentence}\n"
"{ output.state after.block =\n"
"    'skip$\n"
"    { output.state before.all =\n"
"	'skip$\n"
"	{ after.sentence 'output.state := }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {not}\n"
"{   { #0 }\n"
"    { #1 }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {and}\n"
"{   'skip$\n"
"    { pop$ #0 }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {or}\n"
"{   { pop$ #1 }\n"
"    'skip$\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {str.to.int}\n"
"{\n"
"  's :=\n"
"  #0\n"
"    { s empty$ not }\n"
"    { % Multiply the number on the top of the stack by 10 = 1010 binary\n"
"      duplicate$ +			% x2\n"
"      duplicate$			% x2 x2\n"
"      duplicate$ + duplicate$ +		% x2 x8\n"
"      +\n"
"      s #1 #1 substring$ chr.to.int$ #48 - + % #48 is ascii for '0'\n"
"      s #2 global.max$ substring$ 's :=\n"
"    }\n"
"  while$\n"
"}\n"
"\n"
"FUNCTION {new.block.checka}\n"
"{ empty$\n"
"    'skip$\n"
"    'new.block\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {new.block.checkb}\n"
"{ empty$\n"
"  swap$ empty$\n"
"  and\n"
"    'skip$\n"
"    'new.block\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {new.sentence.checka}\n"
"{ empty$\n"
"    'skip$\n"
"    'new.sentence\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {new.sentence.checkb}\n"
"{ empty$\n"
"  swap$ empty$\n"
"  and\n"
"    'skip$\n"
"    'new.sentence\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {field.or.null}\n"
"{ duplicate$ empty$\n"
"    { pop$ \"\" }\n"
"    'skip$\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {emphasize}\n"
"{ duplicate$ empty$\n"
"    { pop$ \"\" }\n"
"    { \"<em>\" swap$ * \"</em>\" * }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {add.link} % title\n"
"{\n"
"  't :=\n"
"  t empty$\n"
"    { \"\" }\n"
"    { url empty$\n"
"	{ html empty$\n"
"	    { t }\n"
"	    { \"<a href=\" quote$ * html * quote$ * \">\" * t * \"</a>\" * }\n"
"	  if$ }\n"
"	{ \"<a href=\" quote$ * url * quote$ * \">\" * t * \"</a>\" * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {add.mailto} % authors\n"
"{\n"
"  't :=\n"
"  t empty$\n"
"    { \"\" }\n"
"    { mailto empty$\n"
"        { t }\n"
"        { \"<a href=\" quote$ * \"mailto:\" * mailto * quote$ * \">\" * t * \"</a>\" * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"INTEGERS { nameptr namesleft numnames }\n"
"\n"
"FUNCTION {format.names}\n"
"{ 's :=\n"
"  #1 'nameptr :=\n"
"  s num.names$ 'numnames :=\n"
"  numnames 'namesleft :=\n"
"    { namesleft #0 > }\n"
"    { s nameptr \"{ff~}{vv~}{ll}{, jj}\" format.name$ 't :=\n"
"      \"\\bibxhtmlname{\" t * \"}\" * 't :=\n"
"      nameptr #1 >\n"
"	{ namesleft #1 >\n"
"	    { \", \" * t * }\n"
"	    { numnames #2 >\n"
"		{ \",\" * }\n"
"		'skip$\n"
"	      if$\n"
"	      t \"others\" =\n"
"		{ \" et~al.\" * }\n"
"		{ \" and \" * t * }\n"
"	      if$\n"
"	    }\n"
"	  if$\n"
"	}\n"
"	't\n"
"      if$\n"
"      nameptr #1 + 'nameptr :=\n"
"      namesleft #1 - 'namesleft :=\n"
"    }\n"
"  while$\n"
"}\n"
"\n"
"FUNCTION {format.authors}\n"
"{ author empty$\n"
"    { \"\" }\n"
"    { author format.names }\n"
"  if$\n"
"  add.mailto\n"
"}\n"
"\n"
"FUNCTION {format.editors}\n"
"{ editor empty$\n"
"    { \"\" }\n"
"    { editor format.names\n"
"      editor num.names$ #1 >\n"
"	{ \", editors\" * }\n"
"	{ \", editor\" * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.title}\n"
"{ title empty$\n"
"    { \"\" }\n"
"    { title \"t\" change.case$ }\n"
"  if$\n"
"  add.link\n"
"}\n"
"\n"
"FUNCTION {n.dashify}\n"
"{ 't :=\n"
"  \"\"\n"
"    { t empty$ not }\n"
"    { t #1 #1 substring$ \"-\" =\n"
"	{ t #1 #2 substring$ \"--\" = not\n"
"	    { \"--\" *\n"
"	      t #2 global.max$ substring$ 't :=\n"
"	    }\n"
"	    {   { t #1 #1 substring$ \"-\" = }\n"
"		{ \"-\" *\n"
"		  t #2 global.max$ substring$ 't :=\n"
"		}\n"
"	      while$\n"
"	    }\n"
"	  if$\n"
"	}\n"
"	{ t #1 #1 substring$ *\n"
"	  t #2 global.max$ substring$ 't :=\n"
"	}\n"
"      if$\n"
"    }\n"
"  while$\n"
"}\n"
"\n"
"FUNCTION {format.date}\n"
"{ year empty$\n"
"    { month empty$\n"
"	{ \"\" }\n"
"	{ \"there's a month but no year in \" cite$ * warning$\n"
"	  month\n"
"	}\n"
"      if$\n"
"    }\n"
"    { month empty$\n"
"	'year\n"
"	{ month \" \" * year * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.btitle}\n"
"{ title emphasize\n"
"  add.link\n"
"}\n"
"\n"
"FUNCTION {tie.or.space.connect}\n"
"{ duplicate$ text.length$ #3 <\n"
"    { \"~\" }\n"
"    { \" \" }\n"
"  if$\n"
"  swap$ * *\n"
"}\n"
"\n"
"FUNCTION {either.or.check}\n"
"{ empty$\n"
"    'pop$\n"
"    { \"can't use both \" swap$ * \" fields in \" * cite$ * warning$ }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.bvolume}\n"
"{ volume empty$\n"
"    { \"\" }\n"
"    { \"volume\" volume tie.or.space.connect\n"
"      series empty$\n"
"	'skip$\n"
"	{ \" of \" * series emphasize * }\n"
"      if$\n"
"      \"volume and number\" number either.or.check\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.number.series}\n"
"{ volume empty$\n"
"    { number empty$\n"
"	{ series field.or.null }\n"
"	{ output.state mid.sentence =\n"
"	    { \"number\" }\n"
"	    { \"Number\" }\n"
"	  if$\n"
"	  number tie.or.space.connect\n"
"	  series empty$\n"
"	    { \"there's a number but no series in \" cite$ * warning$ }\n"
"	    { \" in \" * series * }\n"
"	  if$\n"
"	}\n"
"      if$\n"
"    }\n"
"    { \"\" }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.edition}\n"
"{ edition empty$\n"
"    { \"\" }\n"
"    { output.state mid.sentence =\n"
"	{ edition \"l\" change.case$ \" edition\" * }\n"
"	{ edition \"t\" change.case$ \" edition\" * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"INTEGERS { multiresult }\n"
"\n"
"FUNCTION {multi.page.check}\n"
"{ 't :=\n"
"  #0 'multiresult :=\n"
"    { multiresult not\n"
"      t empty$ not\n"
"      and\n"
"    }\n"
"    { t #1 #1 substring$\n"
"      duplicate$ \"-\" =\n"
"      swap$ duplicate$ \",\" =\n"
"      swap$ \"+\" =\n"
"      or or\n"
"	{ #1 'multiresult := }\n"
"	{ t #2 global.max$ substring$ 't := }\n"
"      if$\n"
"    }\n"
"  while$\n"
"  multiresult\n"
"}\n"
"\n"
"FUNCTION {format.pages}\n"
"{ pages empty$\n"
"    { \"\" }\n"
"    { pages multi.page.check\n"
"	{ \"pages\" pages n.dashify tie.or.space.connect }\n"
"	{ \"page\" pages tie.or.space.connect }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.vol.num.pages}\n"
"{ volume field.or.null\n"
"  number empty$\n"
"    'skip$\n"
"    { \"(\" number * \")\" * *\n"
"      volume empty$\n"
"	{ \"there's a number but no volume in \" cite$ * warning$ }\n"
"	'skip$\n"
"      if$\n"
"    }\n"
"  if$\n"
"  pages empty$\n"
"    'skip$\n"
"    { duplicate$ empty$\n"
"	{ pop$ format.pages }\n"
"	{ \":\" * pages n.dashify * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.chapter.pages}\n"
"{ chapter empty$\n"
"    'format.pages\n"
"    { type empty$\n"
"	{ \"chapter\" }\n"
"	{ type \"l\" change.case$ }\n"
"      if$\n"
"      chapter tie.or.space.connect\n"
"      pages empty$\n"
"	'skip$\n"
"	{ \", \" * format.pages * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.in.ed.booktitle}\n"
"{ booktitle empty$\n"
"    { \"\" }\n"
"    { editor empty$\n"
"	{ \"In \" booktitle emphasize * }\n"
"	{ \"In \" format.editors * \", \" * booktitle emphasize * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {empty.misc.check}\n"
"{ author empty$ title empty$ howpublished empty$\n"
"  month empty$ year empty$ note empty$\n"
"  and and and and and\n"
"  key empty$ not and\n"
"    { \"all relevant fields are empty in \" cite$ * warning$ }\n"
"    'skip$\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.thesis.type}\n"
"{ type empty$\n"
"    'skip$\n"
"    { pop$\n"
"      type \"t\" change.case$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.tr.number}\n"
"{ type empty$\n"
"    { \"Technical Report\" }\n"
"    'type\n"
"  if$\n"
"  number empty$\n"
"    { \"t\" change.case$ }\n"
"    { number tie.or.space.connect }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.article.crossref}\n"
"{\n"
"  \"In <a href=\" quote$ * \"#\" * crossref * quote$ * \">\" *\n"
"  key empty$\n"
"    { journal empty$\n"
"	{ \"need key or journal for \" cite$ * \" to crossref \" * crossref *\n"
"	  warning$\n"
"	  \"\"\n"
"	}\n"
"        { \"<cite>\" * journal * \"</cite>\" * }\n"
"      if$\n"
"    }\n"
"    { key * }\n"
"  if$\n"
"  \"</a> \\citelabel{\" * crossref * \"}\" *\n"
"}\n"
"\n"
"FUNCTION {format.crossref.editor}\n"
"{ editor #1 \"{vv~}{ll}\" format.name$\n"
"  editor num.names$ duplicate$\n"
"  #2 >\n"
"    { pop$ \" et~al.\" * }\n"
"    { #2 <\n"
"	'skip$\n"
"	{ editor #2 \"{ff }{vv }{ll}{ jj}\" format.name$ \"others\" =\n"
"	    { \" et~al.\" * }\n"
"	    { \" and \" * editor #2 \"{vv~}{ll}\" format.name$ * }\n"
"	  if$\n"
"	}\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {format.book.crossref}\n"
"{ volume empty$\n"
"    { \"empty volume in \" cite$ * \"'s crossref of \" * crossref * warning$\n"
"      \"In \"\n"
"    }\n"
"    { \"Volume\" volume tie.or.space.connect\n"
"      \" of \" *\n"
"    }\n"
"  if$\n"
"  \"<a href=\" * quote$ * \"#\" * crossref * quote$ * \">\" *\n"
"  editor empty$\n"
"  editor field.or.null author field.or.null =\n"
"  or\n"
"    { key empty$\n"
"	{ series empty$\n"
"	    { \"need editor, key, or series for \" cite$ * \" to crossref \" *\n"
"	      crossref * warning$\n"
"	      \"\" *\n"
"	    }\n"
"            { \"<cite>\" * series * \"</cite>\" * }\n"
"	  if$\n"
"	}\n"
"	{ key * }\n"
"      if$\n"
"    }\n"
"    { format.crossref.editor * }\n"
"  if$\n"
"  \"</a> \\citelabel{\" * crossref * \"}\" *\n"
"}\n"
"\n"
"FUNCTION {format.incoll.inproc.crossref}\n"
"{\n"
"  \"In <a href=\" quote$ * \"#\" * crossref * quote$ * \">\" *\n"
"  editor empty$\n"
"  editor field.or.null author field.or.null =\n"
"  or\n"
"    { key empty$\n"
"	{ booktitle empty$\n"
"	    { \"need editor, key, or booktitle for \" cite$ * \" to crossref \" *\n"
"	      crossref * warning$\n"
"	      \"\"\n"
"	    }\n"
"            { \"<cite>\" * booktitle * \"</cite>\" * }\n"
"	  if$\n"
"	}\n"
"        { key * }\n"
"      if$\n"
"    }\n"
"    { format.crossref.editor * }\n"
"  if$\n"
"  \"</a> \\citelabel{\" * crossref * \"}\" *\n"
"}\n"
"\n"
"FUNCTION {article}\n"
"{ output.bibitem\n"
"  format.authors \"author\" output.check\n"
"  new.block\n"
"  format.title \"title\" output.check\n"
"  new.block\n"
"  crossref missing$\n"
"    { journal emphasize \"journal\" output.check\n"
"      format.vol.num.pages output\n"
"      format.date \"year\" output.check\n"
"    }\n"
"    { format.article.crossref output.nonnull\n"
"      format.pages output\n"
"    }\n"
"  if$\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {book}\n"
"{ output.bibitem\n"
"  author empty$\n"
"    { format.editors \"author and editor\" output.check }\n"
"    { format.authors output.nonnull\n"
"      crossref missing$\n"
"	{ \"author and editor\" editor either.or.check }\n"
"	'skip$\n"
"      if$\n"
"    }\n"
"  if$\n"
"  new.block\n"
"  format.btitle \"title\" output.check\n"
"  crossref missing$\n"
"    { format.bvolume output\n"
"      new.block\n"
"      format.number.series output\n"
"      new.sentence\n"
"      publisher \"publisher\" output.check\n"
"      address output\n"
"    }\n"
"    { new.block\n"
"      format.book.crossref output.nonnull\n"
"    }\n"
"  if$\n"
"  format.edition output\n"
"  format.date \"year\" output.check\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {booklet}\n"
"{ output.bibitem\n"
"  format.authors output\n"
"  new.block\n"
"  format.title \"title\" output.check\n"
"  howpublished address new.block.checkb\n"
"  howpublished output\n"
"  address output\n"
"  format.date output\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {inbook}\n"
"{ output.bibitem\n"
"  author empty$\n"
"    { format.editors \"author and editor\" output.check }\n"
"    { format.authors output.nonnull\n"
"      crossref missing$\n"
"	{ \"author and editor\" editor either.or.check }\n"
"	'skip$\n"
"      if$\n"
"    }\n"
"  if$\n"
"  new.block\n"
"  format.btitle \"title\" output.check\n"
"  crossref missing$\n"
"    { format.bvolume output\n"
"      format.chapter.pages \"chapter and pages\" output.check\n"
"      new.block\n"
"      format.number.series output\n"
"      new.sentence\n"
"      publisher \"publisher\" output.check\n"
"      address output\n"
"    }\n"
"    { format.chapter.pages \"chapter and pages\" output.check\n"
"      new.block\n"
"      format.book.crossref output.nonnull\n"
"    }\n"
"  if$\n"
"  format.edition output\n"
"  format.date \"year\" output.check\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {incollection}\n"
"{ output.bibitem\n"
"  format.authors \"author\" output.check\n"
"  new.block\n"
"  format.title \"title\" output.check\n"
"  new.block\n"
"  crossref missing$\n"
"    { format.in.ed.booktitle \"booktitle\" output.check\n"
"      format.bvolume output\n"
"      format.number.series output\n"
"      format.chapter.pages output\n"
"      new.sentence\n"
"      publisher \"publisher\" output.check\n"
"      address output\n"
"      format.edition output\n"
"      format.date \"year\" output.check\n"
"    }\n"
"    { format.incoll.inproc.crossref output.nonnull\n"
"      format.chapter.pages output\n"
"    }\n"
"  if$\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {inproceedings}\n"
"{ output.bibitem\n"
"  format.authors \"author\" output.check\n"
"  new.block\n"
"  format.title \"title\" output.check\n"
"  new.block\n"
"  crossref missing$\n"
"    { format.in.ed.booktitle \"booktitle\" output.check\n"
"      format.bvolume output\n"
"      format.number.series output\n"
"      format.pages output\n"
"      address empty$\n"
"	{ organization publisher new.sentence.checkb\n"
"	  organization output\n"
"	  publisher output\n"
"	  format.date \"year\" output.check\n"
"	}\n"
"	{ address output.nonnull\n"
"	  format.date \"year\" output.check\n"
"	  new.sentence\n"
"	  organization output\n"
"	  publisher output\n"
"	}\n"
"      if$\n"
"    }\n"
"    { format.incoll.inproc.crossref output.nonnull\n"
"      format.pages output\n"
"    }\n"
"  if$\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {conference} { inproceedings }\n"
"\n"
"FUNCTION {manual}\n"
"{ output.bibitem\n"
"  author empty$\n"
"    { organization empty$\n"
"	'skip$\n"
"	{ organization output.nonnull\n"
"	  address output\n"
"	}\n"
"      if$\n"
"    }\n"
"    { format.authors output.nonnull }\n"
"  if$\n"
"  new.block\n"
"  format.btitle \"title\" output.check\n"
"  author empty$\n"
"    { organization empty$\n"
"	{ address new.block.checka\n"
"	  address output\n"
"	}\n"
"	'skip$\n"
"      if$\n"
"    }\n"
"    { organization address new.block.checkb\n"
"      organization output\n"
"      address output\n"
"    }\n"
"  if$\n"
"  format.edition output\n"
"  format.date output\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {mastersthesis}\n"
"{ output.bibitem\n"
"  format.authors \"author\" output.check\n"
"  new.block\n"
"  format.title \"title\" output.check\n"
"  new.block\n"
"  \"Master's thesis\" format.thesis.type output.nonnull\n"
"  school \"school\" output.check\n"
"  address output\n"
"  format.date \"year\" output.check\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {misc}\n"
"{ output.bibitem\n"
"  format.authors output\n"
"  title howpublished new.block.checkb\n"
"  format.title output\n"
"  howpublished new.block.checka\n"
"  howpublished output\n"
"  format.date output\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"  empty.misc.check\n"
"}\n"
"\n"
"FUNCTION {phdthesis}\n"
"{ output.bibitem\n"
"  format.authors \"author\" output.check\n"
"  new.block\n"
"  format.btitle \"title\" output.check\n"
"  new.block\n"
"  \"PhD thesis\" format.thesis.type output.nonnull\n"
"  school \"school\" output.check\n"
"  address output\n"
"  format.date \"year\" output.check\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {proceedings}\n"
"{ output.bibitem\n"
"  editor empty$\n"
"    { organization output }\n"
"    { format.editors output.nonnull }\n"
"  if$\n"
"  new.block\n"
"  format.btitle \"title\" output.check\n"
"  format.bvolume output\n"
"  format.number.series output\n"
"  address empty$\n"
"    { editor empty$\n"
"	{ publisher new.sentence.checka }\n"
"	{ organization publisher new.sentence.checkb\n"
"	  organization output\n"
"	}\n"
"      if$\n"
"      publisher output\n"
"      format.date \"year\" output.check\n"
"    }\n"
"    { address output.nonnull\n"
"      format.date \"year\" output.check\n"
"      new.sentence\n"
"      editor empty$\n"
"	'skip$\n"
"	{ organization output }\n"
"      if$\n"
"      publisher output\n"
"    }\n"
"  if$\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {techreport}\n"
"{ output.bibitem\n"
"  format.authors \"author\" output.check\n"
"  new.block\n"
"  format.title \"title\" output.check\n"
"  new.block\n"
"  format.tr.number output.nonnull\n"
"  institution \"institution\" output.check\n"
"  address output\n"
"  format.date \"year\" output.check\n"
"  new.block\n"
"  note output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {unpublished}\n"
"{ output.bibitem\n"
"  format.authors \"author\" output.check\n"
"  new.block\n"
"  format.title \"title\" output.check\n"
"  new.block\n"
"  note \"note\" output.check\n"
"  format.date output\n"
"  fin.entry\n"
"}\n"
"\n"
"FUNCTION {default.type} { misc }\n"
"\n"
"MACRO {jan} {\"January\"}\n"
"\n"
"MACRO {feb} {\"February\"}\n"
"\n"
"MACRO {mar} {\"March\"}\n"
"\n"
"MACRO {apr} {\"April\"}\n"
"\n"
"MACRO {may} {\"May\"}\n"
"\n"
"MACRO {jun} {\"June\"}\n"
"\n"
"MACRO {jul} {\"July\"}\n"
"\n"
"MACRO {aug} {\"August\"}\n"
"\n"
"MACRO {sep} {\"September\"}\n"
"\n"
"MACRO {oct} {\"October\"}\n"
"\n"
"MACRO {nov} {\"November\"}\n"
"\n"
"MACRO {dec} {\"December\"}\n"
"\n"
"MACRO {acmcs} {\"ACM Computing Surveys\"}\n"
"\n"
"MACRO {acta} {\"Acta Informatica\"}\n"
"\n"
"MACRO {cacm} {\"Communications of the ACM\"}\n"
"\n"
"MACRO {ibmjrd} {\"IBM Journal of Research and Development\"}\n"
"\n"
"MACRO {ibmsj} {\"IBM Systems Journal\"}\n"
"\n"
"MACRO {ieeese} {\"IEEE Transactions on Software Engineering\"}\n"
"\n"
"MACRO {ieeetc} {\"IEEE Transactions on Computers\"}\n"
"\n"
"MACRO {ieeetcad}\n"
" {\"IEEE Transactions on Computer-Aided Design of Integrated Circuits\"}\n"
"\n"
"MACRO {ipl} {\"Information Processing Letters\"}\n"
"\n"
"MACRO {jacm} {\"Journal of the ACM\"}\n"
"\n"
"MACRO {jcss} {\"Journal of Computer and System Sciences\"}\n"
"\n"
"MACRO {scp} {\"Science of Computer Programming\"}\n"
"\n"
"MACRO {sicomp} {\"SIAM Journal on Computing\"}\n"
"\n"
"MACRO {tocs} {\"ACM Transactions on Computer Systems\"}\n"
"\n"
"MACRO {tods} {\"ACM Transactions on Database Systems\"}\n"
"\n"
"MACRO {tog} {\"ACM Transactions on Graphics\"}\n"
"\n"
"MACRO {toms} {\"ACM Transactions on Mathematical Software\"}\n"
"\n"
"MACRO {toois} {\"ACM Transactions on Office Information Systems\"}\n"
"\n"
"MACRO {toplas} {\"ACM Transactions on Programming Languages and Systems\"}\n"
"\n"
"MACRO {tcs} {\"Theoretical Computer Science\"}\n"
"\n"
"READ\n"
"\n"
"FUNCTION {sortify}\n"
"{ purify$\n"
"  \"l\" change.case$\n"
"}\n"
"\n"
"INTEGERS { len }\n"
"\n"
"FUNCTION {chop.word}\n"
"{ 's :=\n"
"  'len :=\n"
"  s #1 len substring$ =\n"
"    { s len #1 + global.max$ substring$ }\n"
"    's\n"
"  if$\n"
"}\n"
"\n"
"\n"
"FUNCTION {format.lab.names}\n"
"{ 's :=\n"
"  s num.names$ 'numnames :=\n"
"  numnames #1 =\n"
"    { s #1 \"{vv }{ll}\" format.name$ }\n"
"    { numnames #2 =\n"
"        { s #1 \"{vv }{ll }and \" format.name$ s #2 \"{vv }{ll}\" format.name$ * }\n"
"        { s #1 \"{vv }{ll }\" format.name$ \"et~al.\" * }\n"
"      if$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {author.key.label}\n"
"{ author empty$\n"
"    { key empty$\n"
"	{ cite$ #1 #3 substring$ }\n"
"	{ key }\n"
"      if$\n"
"    }\n"
"    { author format.lab.names }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {author.editor.key.label}\n"
"{ author empty$\n"
"    { editor empty$\n"
"	{ key empty$\n"
"	    { cite$ #1 #3 substring$ }\n"
"	    { key }\n"
"	  if$\n"
"	}\n"
"	{ editor format.lab.names }\n"
"      if$\n"
"    }\n"
"    { author format.lab.names }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {author.key.organization.label}\n"
"{ author empty$\n"
"    { key empty$\n"
"	{ organization empty$\n"
"	    { cite$ #1 #3 substring$ }\n"
"	    { \"The \" #4 organization chop.word #3 text.prefix$ }\n"
"	  if$\n"
"	}\n"
"	{ key }\n"
"      if$\n"
"    }\n"
"    { author format.lab.names }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {editor.key.organization.label}\n"
"{ editor empty$\n"
"    { key empty$\n"
"	{ organization empty$\n"
"	    { cite$ #1 #3 substring$ }\n"
"	    { \"The \" #4 organization chop.word #3 text.prefix$ }\n"
"	  if$\n"
"	}\n"
"	{ key }\n"
"      if$\n"
"    }\n"
"    { editor format.lab.names }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {month.to.int}\n"
"{\n"
"	\"l\" change.case$ #3 text.prefix$\n"
"	's :=\n"
"	s \"jan\" = { #1 }  {\n"
"	s \"feb\" = { #2 }  {\n"
"	s \"mar\" = { #3 }  {\n"
"	s \"apr\" = { #4 }  {\n"
"	s \"may\" = { #5 }  {\n"
"	s \"jun\" = { #6 }  {\n"
"	s \"jul\" = { #7 }  {\n"
"	s \"aug\" = { #8 }  {\n"
"	s \"sep\" = { #9 }  {\n"
"	s \"oct\" = { #10 } {\n"
"	s \"nov\" = { #11 } {\n"
"    s \"dec\" = { #12 } { #13 }  % 13 if nothing matches\n"
"    if$}if$}if$}if$}if$}if$}if$}if$}if$}if$}if$}if$\n"
"}\n"
"\n"
"INTEGERS { done c } \n"
"FUNCTION { get.day }\n"
"{ month field.or.null 's :=\n"
"  \n"
"  % Strip out month name\n"
"  #0 'done := \n"
"  { s \"\" = not done not and }\n"
"  { s #1 #1 substring$ \" \" = 'done :=\n"
"    s #2 global.max$ substring$ 's :=\n"
"  }\n"
"  while$\n"
"\n"
"  % Build up first number in t\n"
"  \"0\" 't :=\n"
"  #0 'done :=\n"
"  { s \"\" = not done not and }\n"
"  { s #1 #1 substring$ chr.to.int$ 'c :=\n"
"    c #47 > c #58 < and\n"
"      { t c int.to.chr$ * 't := }\n"
"      { #1 'done := }\n"
"    if$\n"
"    s #2 global.max$ substring$ 's :=\n"
"  }\n"
"  while$\n"
"\n"
"  t str.to.int\n"
"}\n"
"\n"
"FUNCTION { sortify.fourdigit }\n"
"{ 's :=\n"
"  s empty$\n"
"    { \"0000\" }\n"
"    { s\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION { sortify.twodigit }\n"
"{ 's :=\n"
"  s empty$\n"
"    { \"00\" }\n"
"    { s\n"
"      str.to.int #10 + int.to.str$\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {calc.label}\n"
"{ type$ \"book\" =\n"
"  type$ \"inbook\" =\n"
"  or\n"
"    'author.editor.key.label\n"
"    { type$ \"proceedings\" =\n"
"	'editor.key.organization.label\n"
"	{ type$ \"manual\" =\n"
"	    'author.key.organization.label\n"
"	    'author.key.label\n"
"	  if$\n"
"	}\n"
"      if$\n"
"    }\n"
"  if$\n"
"  duplicate$\n"
"\n"
"  year empty$\n"
"    'skip$\n"
"    { \", \" * }\n"
"  if$\n"
"  year field.or.null purify$ *  % CHANGED - pfps - 15 Feb 1989\n"
"  'label :=\n"
"\n"
"  year field.or.null purify$\n"
"  #-1 #4 substring$ \n"
"  sortify.fourdigit \n"
"  \"  \" *\n"
"  month field.or.null month.to.int int.to.str$ sortify.twodigit *\n"
"  \"  \" *  \n"
"  get.day int.to.str$ sortify.twodigit *\n"
"  \"  \" *\n"
"  * sortify 'sort.label :=\n"
"}\n"
"\n"
"FUNCTION {sort.format.names}\n"
"{ 's :=\n"
"  #1 'nameptr :=\n"
"  \"\"\n"
"  s num.names$ 'numnames :=\n"
"  numnames 'namesleft :=\n"
"    { namesleft #0 > }\n"
"    { nameptr #1 >\n"
"	{ \"   \" * }\n"
"	'skip$\n"
"      if$\n"
"      s nameptr \"{vv{ } }{ll{ }}{  ff{ }}{  jj{ }}\" format.name$ 't :=\n"
"      nameptr numnames = t \"others\" = and\n"
"	{ \"et al.\" * }\n"
"	{ t sortify * }\n"
"      if$\n"
"      nameptr #1 + 'nameptr :=\n"
"      namesleft #1 - 'namesleft :=\n"
"    }\n"
"  while$\n"
"}\n"
"\n"
"FUNCTION {sort.format.title}\n"
"{ 't :=\n"
"  \"A \" #2\n"
"    \"An \" #3\n"
"      \"The \" #4 t chop.word\n"
"    chop.word\n"
"  chop.word\n"
"  sortify\n"
"  #1 global.max$ substring$\n"
"}\n"
"\n"
"FUNCTION {author.sort}\n"
"{ author empty$\n"
"    { key empty$\n"
"	{ \"to sort, need author or key in \" cite$ * warning$\n"
"	  \"\"\n"
"	}\n"
"	{ key sortify }\n"
"      if$\n"
"    }\n"
"    { author sort.format.names }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {author.editor.sort}\n"
"{ author empty$\n"
"    { editor empty$\n"
"	{ key empty$\n"
"	    { \"to sort, need author, editor, or key in \" cite$ * warning$\n"
"	      \"\"\n"
"	    }\n"
"	    { key sortify }\n"
"	  if$\n"
"	}\n"
"	{ editor sort.format.names }\n"
"      if$\n"
"    }\n"
"    { author sort.format.names }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {author.organization.sort}\n"
"{ author empty$\n"
"    { organization empty$\n"
"	{ key empty$\n"
"	    { \"to sort, need author, organization, or key in \" cite$ * warning$\n"
"	      \"\"\n"
"	    }\n"
"	    { key sortify }\n"
"	  if$\n"
"	}\n"
"	{ \"The \" #4 organization chop.word sortify }\n"
"      if$\n"
"    }\n"
"    { author sort.format.names }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {editor.organization.sort}\n"
"{ editor empty$\n"
"    { organization empty$\n"
"	{ key empty$\n"
"	    { \"to sort, need editor, organization, or key in \" cite$ * warning$\n"
"	      \"\"\n"
"	    }\n"
"	    { key sortify }\n"
"	  if$\n"
"	}\n"
"	{ \"The \" #4 organization chop.word sortify }\n"
"      if$\n"
"    }\n"
"    { editor sort.format.names }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {presort}\n"
"{ calc.label\n"
"  sort.label\n"
"  \"    \"\n"
"  *\n"
"  type$ \"book\" =\n"
"  type$ \"inbook\" =\n"
"  or\n"
"    'author.editor.sort\n"
"    { type$ \"proceedings\" =\n"
"	'editor.organization.sort\n"
"	{ type$ \"manual\" =\n"
"	    'author.organization.sort\n"
"	    'author.sort\n"
"	  if$\n"
"	}\n"
"      if$\n"
"    }\n"
"  if$\n"
"  *\n"
"  \"    \"\n"
"  *\n"
"  year field.or.null sortify\n"
"  *\n"
"  \"    \"\n"
"  *\n"
"  title field.or.null\n"
"  sort.format.title\n"
"  *\n"
"  #1 entry.max$ substring$\n"
"  'sort.key$ :=\n"
"}\n"
"\n"
"ITERATE {presort}\n"
"\n"
"SORT\n"
"\n"
"STRINGS { longest.label last.sort.label next.extra }\n"
"\n"
"INTEGERS { longest.label.width last.extra.num }\n"
"\n"
"FUNCTION {initialize.longest.label}\n"
"{ \"\" 'longest.label :=\n"
"  #0 int.to.chr$ 'last.sort.label :=\n"
"  \"\" 'next.extra :=\n"
"  #0 'longest.label.width :=\n"
"  #0 'last.extra.num :=\n"
"}\n"
"\n"
"FUNCTION {forward.pass}\n"
"{ last.sort.label sort.label =\n"
"    { last.extra.num #1 + 'last.extra.num :=\n"
"      last.extra.num int.to.chr$ 'extra.label :=\n"
"    }\n"
"    { \"a\" chr.to.int$ 'last.extra.num :=\n"
"      \"\" 'extra.label :=\n"
"      sort.label 'last.sort.label :=\n"
"    }\n"
"  if$\n"
"}\n"
"\n"
"FUNCTION {reverse.pass}\n"
"{ next.extra \"b\" =\n"
"    { \"a\" 'extra.label := }\n"
"    'skip$\n"
"  if$\n"
"  label extra.label * 'label :=\n"
"  label width$ longest.label.width >\n"
"    { label 'longest.label :=\n"
"      label width$ 'longest.label.width :=\n"
"    }\n"
"    'skip$\n"
"  if$\n"
"  extra.label 'next.extra :=\n"
"}\n"
"\n"
"EXECUTE {initialize.longest.label}\n"
"\n"
"ITERATE {forward.pass}\n"
"\n"
"REVERSE {reverse.pass}\n"
"\n"
"FUNCTION {begin.bib}\n"
"{\n"
"  \"# label-style: default\" write$ newline$\n"
"}\n"
"\n"
"EXECUTE {begin.bib}\n"
"\n"
"EXECUTE {init.state.consts}\n"
"\n"
"ITERATE {call.type$}\n"
"\n"
"FUNCTION {end.bib}\n"
"{ newline$\n"
"}\n"
"\n"
"EXECUTE {end.bib}\n"
