+++
title = "Developer resources"
description = "Resources for Grafana developers"
keywords = ["grafana", "documentation", "developers", "resources"]
type = "docs"
[menu.docs]
name = "Grafana resources"
identifier = "Developer resources"
weight = 30
+++

# Developer resources

This page lists resources for developers who want to contribute to the Grafana software ecosystem or build plugins for Grafana.

## 
General resources
These resources are useful for all developers.

* [Contributing to Grafana](https://github.com/grafana/grafana/blob/master/CONTRIBUTING.md): Start here to learn how you can contribute your skills to make Grafana even better.

* [Developer guide](https://github.com/grafana/grafana/blob/master/contribute/developer-guide.md): A guide to help you get started developing Grafana software, includes instructions for how to configure Grafana for development.

* [Contributing to documentation](https://github.com/grafana/grafana/blob/master/contribute/documentation.md): A guide to help you contribute to Grafana documentation, includes links to beginner-friendly issues.

* [Architecture guides](https://github.com/grafana/grafana/tree/master/contribute/architecture): These guides explain Grafana’s background architecture.

* [Create a pull request](https://github.com/grafana/grafana/blob/master/contribute/create-pull-request.md): A guide for new contributors about how to create your first Grafana pull request.

* [REST APIs](https://grafana.com/docs/grafana/latest/http_api/) allow you to interact programmatically with the Grafana backend.

## Best practices and style

Our [style guides](https://github.com/grafana/grafana/tree/master/contribute/style-guides) outline Grafana style for frontend, backend, documentation, and more, including best practices. Please read through them before you start editing or coding!

* [Backend style guide](https://github.com/grafana/grafana/blob/master/contribute/style-guides/backend.md) explains how we want to write Go code in the future.

* [Documentation style guide](https://github.com/grafana/grafana/blob/master/contribute/style-guides/documentation-style-guide.md) applies to all documentation created for Grafana products.

* [End to end test framework](https://github.com/grafana/grafana/blob/master/contribute/style-guides/e2e.md) provides guidance for Grafana e2e tests.

* [Frontend style guide](https://github.com/grafana/grafana/blob/master/contribute/style-guides/frontend.md) provides rules and guidance on developing in React for Grafana.

* [Redux framework](https://github.com/grafana/grafana/blob/master/contribute/style-guides/redux.md) explains how Grafana handles Redux boilerplate code.

* [Styling Grafana](https://github.com/grafana/grafana/blob/master/contribute/style-guides/styling.md) expands on styling React components with Emotion.

* [Theming Grafana](https://github.com/grafana/grafana/blob/master/contribute/style-guides/themes.md) explains how to use themes and ThemeContext in Grafana code.
