+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "@grafana/data"
keywords = ["grafana","documentation","sdk","@grafana/data"]
type = "docs"
draft = true
+++

## @grafana/data package

A library containing most of the core functionality and data types used in Grafana.

## Classes

|  Class | Description |
|  --- | --- |
|  [AppendedVectors](./appendedvectors/) | This may be more trouble than it is worth. This trades some computation time for RAM -- rather than allocate a new array the size of all previous arrays, this just points the correct index to their original array values |
|  [AppPlugin](./appplugin/) |  |
|  [ArrayVector](./arrayvector/) |  |
|  [CircularDataFrame](./circulardataframe/) | This dataframe can have values constantly added, and will never exceed the given capacity |
|  [CircularVector](./circularvector/) | Circular vector uses a single buffer to capture a stream of values overwriting the oldest value on add.<!-- -->This supports addting to the 'head' or 'tail' and will grow the buffer to match a configured capacity. |
|  [ConstantVector](./constantvector/) |  |
|  [CSVReader](./csvreader/) |  |
|  [DataFrameView](./dataframeview/) | <b><i>(BETA)</i></b> This abstraction will present the contents of a DataFrame as if it were a well typed javascript object Vector. |
|  [DataSourceApi](./datasourceapi/) | The main data source abstraction interface, represents an instance of a data source<!-- -->Although this is a class, datasource implementations do not \*yet\* need to extend it. As such, we can not yet add functions with default implementations. |
|  [DataSourcePlugin](./datasourceplugin/) |  |
|  [FieldCache](./fieldcache/) |  |
|  [GrafanaPlugin](./grafanaplugin/) |  |
|  [LanguageProvider](./languageprovider/) |  |
|  [MutableDataFrame](./mutabledataframe/) |  |
|  [PanelPlugin](./panelplugin/) |  |
|  [Registry](./registry/) |  |
|  [ScaledVector](./scaledvector/) |  |
|  [SortedVector](./sortedvector/) | Values are returned in the order defined by the input parameter |

## Enumerations

|  Enumeration | Description |
|  --- | --- |
|  [ColorScheme](./colorscheme/) |  |
|  [CoreApp](./coreapp/) |  |
|  [CSVHeaderStyle](./csvheaderstyle/) |  |
|  [DataSourceStatus](./datasourcestatus/) |  |
|  [DataTransformerID](./datatransformerid/) |  |
|  [ExploreMode](./exploremode/) |  |
|  [FieldColorMode](./fieldcolormode/) |  |
|  [FieldMatcherID](./fieldmatcherid/) |  |
|  [FieldType](./fieldtype/) |  |
|  [FrameMatcherID](./framematcherid/) | Field name matchers |
|  [GrafanaThemeType](./grafanathemetype/) |  |
|  [LoadingState](./loadingstate/) |  |
|  [LogLevel](./loglevel/) | Mapping of log level abbreviation to canonical log level. Supported levels are reduce to limit color variation. |
|  [LogsDedupDescription](./logsdedupdescription/) |  |
|  [LogsDedupStrategy](./logsdedupstrategy/) |  |
|  [LogsMetaKind](./logsmetakind/) |  |
|  [MappingType](./mappingtype/) |  |
|  [MatcherID](./matcherid/) |  |
|  [NullValueMode](./nullvaluemode/) |  |
|  [OrgRole](./orgrole/) |  |
|  [PluginIncludeType](./pluginincludetype/) |  |
|  [PluginState](./pluginstate/) |  |
|  [PluginType](./plugintype/) |  |
|  [ReducerID](./reducerid/) |  |
|  [ThresholdsMode](./thresholdsmode/) |  |
|  [VariableOrigin](./variableorigin/) |  |
|  [VariableSuggestionsScope](./variablesuggestionsscope/) |  |
|  [VizOrientation](./vizorientation/) |  |

## Functions

|  Function | Description |
|  --- | --- |
|  [addLogLevelToSeries(series, lineIndex)](./addlogleveltoseries/) |  |
|  [applyFieldOverrides(options)](./applyfieldoverrides/) | Return a copy of the DataFrame with all rules applied |
|  [arrowTableToDataFrame(table)](./arrowtabletodataframe/) |  |
|  [base64StringToArrowTable(text)](./base64stringtoarrowtable/) |  |
|  [calculateFieldStats(rows, extractor)](./calculatefieldstats/) |  |
|  [calculateLogsLabelStats(rows, label)](./calculatelogslabelstats/) |  |
|  [calculateStats(values)](./calculatestats/) |  |
|  [eventFactory(name)](./eventfactory/) |  |
|  [findCommonLabels(labelsSets)](./findcommonlabels/) | Returns a map labels that are common to the given label sets. |
|  [findHighlightChunksInText({ searchWords, textToHighlight, })](./findhighlightchunksintext/) | Adapt findMatchesInText for react-highlight-words findChunks handler. See https://github.com/bvaughn/react-highlight-words\#props |
|  [findMatchesInText(haystack, needle)](./findmatchesintext/) | Returns a list of substring regexp matches. |
|  [findUniqueLabels(labels, commonLabels)](./finduniquelabels/) | Returns a map of labels that are in <code>labels</code>, but not in <code>commonLabels</code>. |
|  [formatLabels(labels, defaultValue)](./formatlabels/) | Serializes the given labels to a string. |
|  [formattedValueToString(val)](./formattedvaluetostring/) |  |
|  [getActiveThreshold(value, thresholds)](./getactivethreshold/) |  |
|  [getDataFrameRow(data, row)](./getdataframerow/) | Wrapper to get an array from each field value |
|  [getDecimalsForValue(value, decimalOverride)](./getdecimalsforvalue/) |  |
|  [getDisplayProcessor(options)](./getdisplayprocessor/) |  |
|  [getDisplayValueAlignmentFactors(values)](./getdisplayvaluealignmentfactors/) |  |
|  [getFieldMatcher(config)](./getfieldmatcher/) |  |
|  [getFlotPairs({ xField, yField, nullValueMode })](./getflotpairs/) |  |
|  [getFlotPairsConstant(seriesData, range)](./getflotpairsconstant/) | Returns a constant series based on the first value from the provide series. |
|  [getFrameMatchers(config)](./getframematchers/) |  |
|  [getLogLevel(line)](./getloglevel/) | Returns the log level of a log line. Parse the line for level words. If no level is found, it returns <code>LogLevel.unknown</code>.<!-- -->Example: <code>getLogLevel('WARN 1999-12-31 this is great') // LogLevel.warn</code> |
|  [getLogLevelFromKey(key)](./getloglevelfromkey/) |  |
|  [getParser(line)](./getparser/) |  |
|  [getScaleCalculator(field, theme)](./getscalecalculator/) |  |
|  [getValueFormat(id)](./getvalueformat/) |  |
|  [getValueFormats()](./getvalueformats/) |  |
|  [getValueFormatterIndex()](./getvalueformatterindex/) |  |
|  [grafanaDataFrameToArrowTable(data)](./grafanadataframetoarrowtable/) |  |
|  [guessFieldTypeForField(field)](./guessfieldtypeforfield/) | Looks at the data to guess the column type. This ignores any existing setting |
|  [guessFieldTypeFromValue(v)](./guessfieldtypefromvalue/) | Given a value this will guess the best column type<!-- -->TODO: better Date/Time support! Look for standard date strings? |
|  [locale(value, decimals)](./locale/) |  |
|  [parseFlags(text)](./parseflags/) | Converts any mode modifiers in the text to the Javascript equivalent flag |
|  [parseLabels(labels)](./parselabels/) | Returns a map of label keys to value from an input selector string.<!-- -->Example: <code>parseLabels('{job=&quot;foo&quot;, instance=&quot;bar&quot;}) // {job: &quot;foo&quot;, instance: &quot;bar&quot;}</code> |
|  [readCSV(csv, options)](./readcsv/) |  |
|  [reduceField(options)](./reducefield/) |  |
|  [renderMarkdown(str)](./rendermarkdown/) |  |
|  [resultsToDataFrames(rsp)](./resultstodataframes/) |  |
|  [reverseDataFrame(data)](./reversedataframe/) | Returns a copy with all values reversed |
|  [scaledUnits(factor, extArray)](./scaledunits/) |  |
|  [setMarkdownOptions(optionsOverride)](./setmarkdownoptions/) |  |
|  [simpleCountUnit(symbol)](./simplecountunit/) |  |
|  [sortDataFrame(data, sortIndex, reverse)](./sortdataframe/) |  |
|  [sortThresholds(thresholds)](./sortthresholds/) | Sorts the thresholds |
|  [stringStartsAsRegEx(str)](./stringstartsasregex/) |  |
|  [stringToJsRegex(str)](./stringtojsregex/) |  |
|  [stringToMs(str)](./stringtoms/) |  |
|  [toCSV(data, config)](./tocsv/) |  |
|  [toDataFrameDTO(data)](./todataframedto/) | Returns a copy that does not include functions |
|  [toFixed(value, decimals)](./tofixed/) |  |
|  [toFixedScaled(value, decimals, scaledDecimals, additionalDecimals, ext)](./tofixedscaled/) |  |
|  [toFixedUnit(unit, asPrefix)](./tofixedunit/) |  |
|  [toFloatOrUndefined(value)](./tofloatorundefined/) |  |
|  [toIntegerOrUndefined(value)](./tointegerorundefined/) |  |
|  [toNumberString(value)](./tonumberstring/) |  |
|  [transformDataFrame(options, data)](./transformdataframe/) | Apply configured transformations to the input data |
|  [updateDatasourcePluginOption(props, key, val)](./updatedatasourcepluginoption/) |  |
|  [updateDatasourcePluginResetOption(props, key)](./updatedatasourcepluginresetoption/) |  |
|  [validateFieldConfig(config)](./validatefieldconfig/) | This checks that all options on FieldConfig make sense. It mutates any value that needs fixed. In particular this makes sure that the first threshold value is -Infinity (not valid in JSON) |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [AbsoluteTimeRange](./absolutetimerange/) |  |
|  [AngularPanelMenuItem](./angularpanelmenuitem/) |  |
|  [AnnotationEvent](./annotationevent/) |  |
|  [AnnotationQueryRequest](./annotationqueryrequest/) | Options passed to the datasource.annotationQuery method. See docs/plugins/developing/datasource.md |
|  [AppEvent](./appevent/) |  |
|  [AppPluginMeta](./apppluginmeta/) |  |
|  [AppRootProps](./approotprops/) |  |
|  [ArrowDataFrame](./arrowdataframe/) |  |
|  [Column](./column/) |  |
|  [ConfigOverrideRule](./configoverriderule/) |  |
|  [CreatePlotOverlay](./createplotoverlay/) |  |
|  [CSVConfig](./csvconfig/) |  |
|  [CSVOptions](./csvoptions/) |  |
|  [CSVParseCallbacks](./csvparsecallbacks/) |  |
|  [DataFrame](./dataframe/) |  |
|  [DataFrameDTO](./dataframedto/) | Like a DataFrame, but fields may be a FieldDTO |
|  [DataLink](./datalink/) | Link configuration. The values may contain variables that need to be processed before running |
|  [DataLinkClickEvent](./datalinkclickevent/) | Callback info for DataLink click events |
|  [DataQuery](./dataquery/) |  |
|  [DataQueryError](./dataqueryerror/) |  |
|  [DataQueryRequest](./dataqueryrequest/) |  |
|  [DataQueryResponse](./dataqueryresponse/) |  |
|  [DataSourceConstructor](./datasourceconstructor/) |  |
|  [DataSourceInstanceSettings](./datasourceinstancesettings/) | Frontend settings model that is passed to Datasource constructor. This differs a bit from the model above as this data model is available to every user who has access to a data source (Viewers+). This is loaded in bootData (on page load), or from: /api/frontend/settings |
|  [DataSourceJsonData](./datasourcejsondata/) |  |
|  [DataSourcePluginComponents](./datasourceplugincomponents/) |  |
|  [DataSourcePluginMeta](./datasourcepluginmeta/) |  |
|  [DataSourcePluginOptionsEditorProps](./datasourcepluginoptionseditorprops/) |  |
|  [DataSourceSelectItem](./datasourceselectitem/) |  |
|  [DataSourceSettings](./datasourcesettings/) | Data Source instance edit model. This is returned from: /api/datasources |
|  [DataTransformerConfig](./datatransformerconfig/) |  |
|  [DataTransformerInfo](./datatransformerinfo/) |  |
|  [DateTime](./datetime/) |  |
|  [DateTimeBuiltinFormat](./datetimebuiltinformat/) |  |
|  [DateTimeDuration](./datetimeduration/) |  |
|  [DateTimeLocale](./datetimelocale/) |  |
|  [DecimalInfo](./decimalinfo/) |  |
|  [Dimension](./dimension/) |  |
|  [DisplayValue](./displayvalue/) |  |
|  [DisplayValueAlignmentFactors](./displayvaluealignmentfactors/) | These represents the display value with the longest title and text. Used to align widths and heights when displaying multiple DisplayValues |
|  [DynamicConfigValue](./dynamicconfigvalue/) |  |
|  [ExploreQueryFieldProps](./explorequeryfieldprops/) |  |
|  [ExploreStartPageProps](./explorestartpageprops/) |  |
|  [Field](./field/) |  |
|  [FieldCalcs](./fieldcalcs/) |  |
|  [FieldColor](./fieldcolor/) |  |
|  [FieldConfig](./fieldconfig/) | Every property is optional<!-- -->Plugins may extend this with additional properties. Something like series overrides |
|  [FieldConfigEditorProps](./fieldconfigeditorprops/) |  |
|  [FieldConfigSource](./fieldconfigsource/) |  |
|  [FieldDisplay](./fielddisplay/) |  |
|  [FieldDisplayOptions](./fielddisplayoptions/) |  |
|  [FieldDTO](./fielddto/) | Like a field, but properties are optional and values may be a simple array |
|  [FieldMatcherInfo](./fieldmatcherinfo/) |  |
|  [FieldOverrideContext](./fieldoverridecontext/) |  |
|  [FieldOverrideEditorProps](./fieldoverrideeditorprops/) |  |
|  [FieldPropertyEditorItem](./fieldpropertyeditoritem/) |  |
|  [FieldReducerInfo](./fieldreducerinfo/) |  |
|  [FieldWithIndex](./fieldwithindex/) |  |
|  [FilterFieldsByNameTransformerOptions](./filterfieldsbynametransformeroptions/) |  |
|  [FilterFramesByRefIdTransformerOptions](./filterframesbyrefidtransformeroptions/) |  |
|  [FlotDataPoint](./flotdatapoint/) |  |
|  [FormattedValue](./formattedvalue/) |  |
|  [FrameMatcherInfo](./framematcherinfo/) |  |
|  [GetFieldDisplayValuesOptions](./getfielddisplayvaluesoptions/) |  |
|  [GrafanaTheme](./grafanatheme/) |  |
|  [GrafanaThemeCommons](./grafanathemecommons/) |  |
|  [GraphSeriesXY](./graphseriesxy/) | View model projection of a series |
|  [HistoryItem](./historyitem/) |  |
|  [IntervalValues](./intervalvalues/) |  |
|  [Labels](./labels/) |  |
|  [LinkModel](./linkmodel/) | Processed Link Model. The values are ready to use |
|  [LinkModelSupplier](./linkmodelsupplier/) | Provides a way to produce links on demand<!-- -->TODO: ScopedVars in in GrafanaUI package! |
|  [LogLabelStatsModel](./loglabelstatsmodel/) |  |
|  [LogRowModel](./logrowmodel/) |  |
|  [LogSearchMatch](./logsearchmatch/) |  |
|  [LogsMetaItem](./logsmetaitem/) |  |
|  [LogsModel](./logsmodel/) |  |
|  [LogsParser](./logsparser/) |  |
|  [MatcherConfig](./matcherconfig/) |  |
|  [MetadataInspectorProps](./metadatainspectorprops/) |  |
|  [MetricFindValue](./metricfindvalue/) |  |
|  [MutableVector](./mutablevector/) | Vector with standard manipulation functions |
|  [NavModel](./navmodel/) |  |
|  [NavModelBreadcrumb](./navmodelbreadcrumb/) |  |
|  [NavModelItem](./navmodelitem/) |  |
|  [PanelData](./paneldata/) |  |
|  [PanelEditorProps](./paneleditorprops/) |  |
|  [PanelMenuItem](./panelmenuitem/) |  |
|  [PanelModel](./panelmodel/) |  |
|  [PanelPluginMeta](./panelpluginmeta/) |  |
|  [PanelProps](./panelprops/) |  |
|  [PluginBuildInfo](./pluginbuildinfo/) |  |
|  [PluginConfigPage](./pluginconfigpage/) |  |
|  [PluginConfigPageProps](./pluginconfigpageprops/) |  |
|  [PluginDependencies](./plugindependencies/) |  |
|  [PluginInclude](./plugininclude/) |  |
|  [PluginMeta](./pluginmeta/) |  |
|  [PluginMetaInfo](./pluginmetainfo/) |  |
|  [QueryEditorProps](./queryeditorprops/) |  |
|  [QueryFix](./queryfix/) |  |
|  [QueryFixAction](./queryfixaction/) |  |
|  [QueryHint](./queryhint/) |  |
|  [QueryResultBase](./queryresultbase/) |  |
|  [QueryResultMeta](./queryresultmeta/) |  |
|  [RangeMap](./rangemap/) |  |
|  [RawTimeRange](./rawtimerange/) |  |
|  [ReadWriteVector](./readwritevector/) | Apache arrow vectors are Read/Write |
|  [ReduceTransformerOptions](./reducetransformeroptions/) |  |
|  [RegistryItem](./registryitem/) |  |
|  [RegistryItemWithOptions](./registryitemwithoptions/) |  |
|  [ScaledValue](./scaledvalue/) |  |
|  [ScopedVar](./scopedvar/) |  |
|  [ScopedVars](./scopedvars/) |  |
|  [ScreenshotInfo](./screenshotinfo/) |  |
|  [SelectableValue](./selectablevalue/) | Used in select elements |
|  [TableData](./tabledata/) |  |
|  [TextMatch](./textmatch/) |  |
|  [Threshold](./threshold/) |  |
|  [ThresholdsConfig](./thresholdsconfig/) |  |
|  [TimeOption](./timeoption/) |  |
|  [TimeOptions](./timeoptions/) |  |
|  [TimeRange](./timerange/) |  |
|  [TimeSeries](./timeseries/) |  |
|  [UserOrgDTO](./userorgdto/) |  |
|  [ValueFormat](./valueformat/) |  |
|  [ValueFormatCategory](./valueformatcategory/) |  |
|  [ValueMap](./valuemap/) |  |
|  [VariableSuggestion](./variablesuggestion/) |  |
|  [Vector](./vector/) |  |
|  [YAxis](./yaxis/) |  |

## Namespaces

|  Namespace | Description |
|  --- | --- |
|  [AppEvents](./appevents/) |  |
|  [dateMath](./datemath/) |  |
|  [PanelEvents](./panelevents/) |  |
|  [rangeUtil](./rangeutil/) |  |

## Variables

|  Variable | Description |
|  --- | --- |
|  [createDimension](./createdimension/) |  |
|  [dateTime](./datetime/) |  |
|  [dateTimeAsMoment](./datetimeasmoment/) |  |
|  [dateTimeForTimeZone](./datetimefortimezone/) |  |
|  [DEFAULT\_DATE\_TIME\_FORMAT](./default_date_time_format/) |  |
|  [DEFAULT\_FIELD\_DISPLAY\_VALUES\_LIMIT](./default_field_display_values_limit/) |  |
|  [DefaultTimeRange](./defaulttimerange/) |  |
|  [DefaultTimeZone](./defaulttimezone/) |  |
|  [deprecationWarning](./deprecationwarning/) |  |
|  [escapeStringForRegex](./escapestringforregex/) |  |
|  [fieldMatchers](./fieldmatchers/) |  |
|  [fieldReducers](./fieldreducers/) |  |
|  [frameMatchers](./framematchers/) |  |
|  [getAllValuesFromDimension](./getallvaluesfromdimension/) |  |
|  [getColorByName](./getcolorbyname/) |  |
|  [getColorDefinition](./getcolordefinition/) |  |
|  [getColorDefinitionByName](./getcolordefinitionbyname/) |  |
|  [getColorForTheme](./getcolorfortheme/) |  |
|  [getColorFromHexRgbOrName](./getcolorfromhexrgborname/) |  |
|  [getColorName](./getcolorname/) |  |
|  [getColumnFromDimension](./getcolumnfromdimension/) |  |
|  [getColumnsFromDimension](./getcolumnsfromdimension/) |  |
|  [getDimensionByName](./getdimensionbyname/) |  |
|  [getFieldDisplayValues](./getfielddisplayvalues/) |  |
|  [getLocaleData](./getlocaledata/) |  |
|  [getMappedValue](./getmappedvalue/) |  |
|  [getNamedColorPalette](./getnamedcolorpalette/) |  |
|  [getSeriesTimeStep](./getseriestimestep/) | Returns minimal time step from series time field |
|  [getTimeField](./gettimefield/) |  |
|  [getTimeZoneGroups](./gettimezonegroups/) |  |
|  [getValueFromDimension](./getvaluefromdimension/) |  |
|  [guessFieldTypes](./guessfieldtypes/) |  |
|  [hasMsResolution](./hasmsresolution/) | Checks if series time field has ms resolution |
|  [isDataFrame](./isdataframe/) |  |
|  [isDateTime](./isdatetime/) |  |
|  [ISO\_8601](./iso_8601/) |  |
|  [isTableData](./istabledata/) |  |
|  [LogsParsers](./logsparsers/) |  |
|  [MISSING\_VALUE](./missing_value/) |  |
|  [MS\_DATE\_TIME\_FORMAT](./ms_date_time_format/) |  |
|  [objRemoveUndefined](./objremoveundefined/) |  |
|  [onUpdateDatasourceJsonDataOption](./onupdatedatasourcejsondataoption/) |  |
|  [onUpdateDatasourceJsonDataOptionSelect](./onupdatedatasourcejsondataoptionselect/) |  |
|  [onUpdateDatasourceOption](./onupdatedatasourceoption/) |  |
|  [onUpdateDatasourceResetOption](./onupdatedatasourceresetoption/) |  |
|  [onUpdateDatasourceSecureJsonDataOption](./onupdatedatasourcesecurejsondataoption/) |  |
|  [onUpdateDatasourceSecureJsonDataOptionSelect](./onupdatedatasourcesecurejsondataoptionselect/) |  |
|  [setLocale](./setlocale/) |  |
|  [standardFieldConfigEditorRegistry](./standardfieldconfigeditorregistry/) |  |
|  [TIME\_FORMAT](./time_format/) |  |
|  [toDataFrame](./todataframe/) |  |
|  [toDuration](./toduration/) |  |
|  [toLegacyResponseData](./tolegacyresponsedata/) |  |
|  [toUtc](./toutc/) |  |
|  [transformersRegistry](./transformersregistry/) |  |
|  [unEscapeStringFromRegex](./unescapestringfromregex/) |  |
|  [updateDatasourcePluginJsonDataOption](./updatedatasourcepluginjsondataoption/) |  |
|  [updateDatasourcePluginSecureJsonDataOption](./updatedatasourcepluginsecurejsondataoption/) |  |
|  [VAR\_CALC](./var_calc/) |  |
|  [VAR\_CELL\_PREFIX](./var_cell_prefix/) |  |
|  [VAR\_FIELD\_NAME](./var_field_name/) |  |
|  [VAR\_SERIES\_NAME](./var_series_name/) |  |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [Color](./color/) |  |
|  [ColorDefinition](./colordefinition/) |  |
|  [DataQueryResponseData](./dataqueryresponsedata/) |  |
|  [DataSourceOptionsType](./datasourceoptionstype/) |  |
|  [DataSourceQueryType](./datasourcequerytype/) |  |
|  [DataTransformer](./datatransformer/) | Immutable data transformation |
|  [DateTimeInput](./datetimeinput/) |  |
|  [DecimalCount](./decimalcount/) |  |
|  [Dimensions](./dimensions/) |  |
|  [DisplayProcessor](./displayprocessor/) |  |
|  [DurationInput](./durationinput/) |  |
|  [DurationUnit](./durationunit/) |  |
|  [FieldConfigEditorRegistry](./fieldconfigeditorregistry/) |  |
|  [FieldMatcher](./fieldmatcher/) |  |
|  [FormatInput](./formatinput/) |  |
|  [FrameMatcher](./framematcher/) |  |
|  [GraphSeriesValue](./graphseriesvalue/) |  |
|  [InterpolateFunction](./interpolatefunction/) |  |
|  [KeyValue](./keyvalue/) |  |
|  [LegacyResponseData](./legacyresponsedata/) | Starting in v6.2 DataFrame can represent both TimeSeries and TableData |
|  [LinkTarget](./linktarget/) |  |
|  [MutableField](./mutablefield/) |  |
|  [NavIndex](./navindex/) |  |
|  [Omit](./omit/) |  |
|  [PanelMigrationHandler](./panelmigrationhandler/) | Called when a panel is first loaded with current panel model |
|  [PanelTypeChangedHandler](./paneltypechangedhandler/) | Called before a panel is initialized |
|  [ScaleCalculator](./scalecalculator/) |  |
|  [Subtract](./subtract/) |  |
|  [TimeFragment](./timefragment/) |  |
|  [TimeSeriesPoints](./timeseriespoints/) |  |
|  [TimeSeriesValue](./timeseriesvalue/) |  |
|  [TimeZone](./timezone/) |  |
|  [TimeZoneBrowser](./timezonebrowser/) |  |
|  [TimeZoneUtc](./timezoneutc/) |  |
|  [ValueFormatter](./valueformatter/) |  |
|  [ValueMapping](./valuemapping/) |  |

