/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class RangeTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testAll() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testAll();
}

public void testApply() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testApply();
}

public void testAtLeast() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testAtLeast();
}

public void testAtMost() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testAtMost();
}

public void testCanonical() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testCanonical();
}

public void testCanonical_unboundedDomain() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testCanonical_unboundedDomain();
}

public void testClosed() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testClosed();
}

public void testClosedOpen() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testClosedOpen();
}

public void testClosed_invalid() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testClosed_invalid();
}

public void testContainsAll() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testContainsAll();
}

public void testEmpty1() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testEmpty1();
}

public void testEmpty2() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testEmpty2();
}

public void testEncloseAll() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testEncloseAll();
}

public void testEncloseAll_empty() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testEncloseAll_empty();
}

public void testEncloseAll_nullValue() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testEncloseAll_nullValue();
}

public void testEncloses_closed() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testEncloses_closed();
}

public void testEncloses_open() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testEncloses_open();
}

public void testEquals() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testEquals();
}

public void testEquivalentFactories() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testEquivalentFactories();
}

public void testGap_connectedAdjacentYieldsEmpty() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testGap_connectedAdjacentYieldsEmpty();
}

public void testGap_general() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testGap_general();
}

public void testGap_overlapping() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testGap_overlapping();
}

public void testGreaterThan() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testGreaterThan();
}

public void testIntersection_deFactoEmpty() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testIntersection_deFactoEmpty();
}

public void testIntersection_empty() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testIntersection_empty();
}

public void testIntersection_general() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testIntersection_general();
}

public void testIntersection_singleton() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testIntersection_singleton();
}

public void testIsConnected() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testIsConnected();
}

public void testLegacyComparable() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testLegacyComparable();
}

public void testLessThan() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testLessThan();
}

public void testOpen() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testOpen();
}

public void testOpenClosed() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testOpenClosed();
}

public void testOpen_invalid() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testOpen_invalid();
}

public void testOrderingCuts() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testOrderingCuts();
}

public void testSingleton() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testSingleton();
}

public void testSpan_general() throws Exception {
  com.google.common.collect.RangeTest testCase = new com.google.common.collect.RangeTest();
  testCase.testSpan_general();
}
}
