h39787
s 00013/00004/00419
d D 1.15 02/02/03 12:40:30 shannon 17 16
c close file when done; use a BufferedReader
e
s 00005/00016/00418
d D 1.14 99/12/06 16:33:31 shannon 16 15
c Update copyright for SCSL release
e
s 00000/00017/00434
d D 1.13 99/11/18 15:38:01 shannon 15 14
c remove unneeded method referencing unneeded MailcapEntry class
e
s 00036/00004/00415
d D 1.12 99/04/21 13:58:08 shannon 14 13
c add debugging; when reading an input stream, use iso-8859-1 - bug 4231750
e
s 00002/00000/00417
d D 1.11 99/03/12 15:13:56 shannon 13 12
c comment out "main" method
e
s 00001/00005/00416
d D 1.10 98/02/12 13:32:08 bhc 12 10
c now passes te exception back up the call stack like it should...
c 
e
s 00005/00009/00421
d D 1.8.1.1 98/01/20 14:35:30 bhc 11 9
c interum
e
s 00284/00293/00137
d D 1.9 98/01/18 00:49:39 shannon 10 9
c significantly cleaned up, but still a mess
e
s 00041/00007/00389
d D 1.8 97/12/18 13:22:50 bhc 9 8
c fixed the search semantics for wildcard types
c 
e
s 00097/00203/00299
d D 1.7 97/12/16 14:53:23 bhc 8 7
c fixed kapono's bug about cmds being insterted in the wrong order..
e
s 00023/00040/00479
d D 1.6 97/12/05 15:56:52 bhc 7 6
c took out some dead code
c 
e
s 00001/00002/00518
d D 1.5 97/10/13 16:18:56 bhc 6 5
c minor big fix
c 
e
s 00007/00009/00513
d D 1.4 97/10/13 14:25:38 bhc 5 4
c added wildcards
c 
e
s 00091/00070/00431
d D 1.3 97/10/13 11:23:42 bhc 4 3
c updated to use new mailcap parser, yanked some of the dead code
c 
e
s 00187/00000/00314
d D 1.2 97/10/10 13:53:32 jmoore 3 1
c Add a new parser!
e
s 00000/00000/00000
d R 1.2 97/09/05 16:25:24 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/com/sun/activation/registries/MailcapFile.java
c Name history : 1 0 src/classes/com/sun/activation/registries/MailcapFile.java
e
s 00314/00000/00000
d D 1.1 97/09/05 16:25:23 bhc 1 0
c date and time created 97/09/05 16:25:23 by bhc
e
u
U
f e 0
t
T
I 1
/*
 * %W% %E%
D 10
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
E 10
I 10
 *
D 14
 * Copyright (c) 1997-1998 Sun Microsystems, Inc. All Rights Reserved.
E 14
I 14
D 16
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
E 14
 *
E 10
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
D 10
 * 
E 10
I 10
 *
E 10
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
D 10
 * 
 * 
E 10
I 10
 *
 *
E 16
I 16
D 17
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
E 17
I 17
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
E 17
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 16
E 10
 */

package com.sun.activation.registries;

import java.io.*;
import java.util.*;

public class MailcapFile {
I 14

E 14
D 10

E 10
    private Hashtable type_hash = null;
I 14
    private static boolean debug = false;
E 14
D 10
    private boolean DEBUG = false;
    
    ///////////////////////////////////////////////////////////////////////
E 10
I 10

I 14
    static {
	try {
	    debug = Boolean.getBoolean("javax.activation.debug");
	} catch (Throwable t) {
	    // ignore any errors
	}
    }

E 14
E 10
    /**
D 10
     * The construtor that takes a filename as an argument.
     * 
E 10
I 10
     * The constructor that takes a filename as an argument.
     *
E 10
     * @param new_fname The file name of the mailcap file.
     */
D 4
    public MailcapFile(String new_fname)
	{
	    File mc_file = null;
	    FileInputStream fis = null;
	    //	    private String fname = null;
	    //	    fname = new_fname; // remember the file name

	    type_hash = new Hashtable();
	    
	    mc_file = new File(new_fname); // get a file object
	    
	    try {
		fis = new FileInputStream(mc_file);
	    }
	    catch(FileNotFoundException e)
		{
		    System.out.println("File: " + new_fname + " not found.");
		    // remind: create default table here
		    System.out.println(e);
		}

	    this.parseMailcapFile(fis);

	    try {
		fis.close(); // close it!
	    }
	    catch(IOException e)
		{
		    // igore it for the moment (REMIND)
		}

E 4
I 4
D 10
D 11
    public MailcapFile(String new_fname) {
E 11
I 11
    public MailcapFile(String new_fname) throws FileNotFoundException {
E 11
E 10
I 10
    public MailcapFile(String new_fname) throws IOException {
I 14
	if (debug)
	    System.out.println("new MailcapFile: file " + new_fname);
E 14
E 10
	FileReader reader = null;
D 11
D 12
	try {
	    reader = new FileReader(new_fname);
	} catch (FileNotFoundException e) {
	    e.printStackTrace();
E 4
	}
E 12
I 12
D 17
	reader = new FileReader(new_fname);
E 12
I 4
D 10
	
E 11
I 11
	reader = new FileReader(new_fname);
		
E 11
	type_hash = this.createMailcapHash(reader);
	
E 10
I 10
	type_hash = createMailcapHash(reader);
E 17
I 17
	try {
	    reader = new FileReader(new_fname);
	    type_hash = createMailcapHash(new BufferedReader(reader));
	} finally {
	    if (reader != null) {
		try {
		    reader.close();
		} catch (IOException ex) { }
	    }
	}
E 17
E 10
    }
E 4
D 10
    ///////////////////////////////////////////////////////////////////////
E 10
I 10

E 10
    /**
D 10
     * Mailcap file default constructor
E 10
I 10
     * The constructor that takes an input stream as an argument.
     *
     * @param is	the input stream
E 10
     */
I 10
    public MailcapFile(InputStream is) throws IOException {
D 14
	type_hash = createMailcapHash(new InputStreamReader(is));
E 14
I 14
	if (debug)
	    System.out.println("new MailcapFile: InputStream");
D 17
	type_hash = createMailcapHash(new InputStreamReader(is, "iso-8859-1"));
E 17
I 17
	type_hash = createMailcapHash(
	    new BufferedReader(new InputStreamReader(is, "iso-8859-1")));
E 17
E 14
    }

    /**
     * Mailcap file default constructor.
     */
E 10
D 8
    public MailcapFile()
	{
	    // initialize the hash table
	    type_hash = new Hashtable();
	}
E 8
I 8
    public MailcapFile() {
I 14
	if (debug)
	    System.out.println("new MailcapFile: default");
E 14
	// initialize the hash table
	type_hash = new Hashtable();
    }
E 8
D 10
    ///////////////////////////////////////////////////////////////////////
E 10
I 10

E 10
    /**
D 10
     * get the MCTypeEntry based on the file extension
E 10
I 10
D 15
     * Get the MailcapEntry based on the MIME type.
E 10
     *
     * <p>
     * <strong>Semantics:</strong> First check for the literal mime type,
     * if that fails looks for wildcard <type>/\* and return that. Return
D 10
     * the first one we find...
     * </p>
E 10
I 10
     * the first one we find. <p>
     *
     * XXX - This isn't implemented.
E 10
     */
D 8
    public MailcapEntry getMailcapEntry(String mime_type)
	{
	    MailcapEntry search_result = null;
	    Vector entry_list = null;
D 4

	    // first try the literal
	    entry_list = (Vector)this.getMailcapList(mime_type);
E 4
I 4
D 7
	    // !!!!remind
// 	    // first try the literal
// 	    entry_list = (Vector)this.getMailcapList(mime_type);
E 7
E 4
	    
D 4
	    if(entry_list == null) // then try the wild card
		{
		    int separator = mime_type.indexOf('/');
		    String type = mime_type.substring(0, separator + 1);
		    type = new String(type + "*");
E 4
I 4
D 7
// 	    if(entry_list == null) // then try the wild card
// 		{
// 		    int separator = mime_type.indexOf('/');
// 		    String type = mime_type.substring(0, separator + 1);
// 		    type = new String(type + "*");
E 4

D 4
		    entry_list = (Vector)this.getMailcapList(type);
E 4
I 4
// 		    entry_list = (Vector)this.getMailcapList(type);
E 4
		    
D 4
		}
E 4
I 4
// 		}
E 4

D 4
	    // return the first elememt
	    if(entry_list != null)
		search_result = (MailcapEntry)entry_list.firstElement();
E 4
I 4
// 	    // return the first elememt
// 	    if(entry_list != null)
// 		search_result = (MailcapEntry)entry_list.firstElement();
E 4
	    
E 7
	    return search_result;
	}
E 8
I 8
    public MailcapEntry getMailcapEntry(String mime_type) {
	MailcapEntry search_result = null;
	Vector entry_list = null;
D 10
	
E 10
I 10

E 10
	return search_result;
    }
E 8
D 10
    ///////////////////////////////////////////////////////////////////////
E 10
I 10

E 10
    /**
E 15
D 10
     * get the Vector of MCTypeEntrys based on the file extension
E 10
I 10
     * Get the Hashtable of MailcapEntries based on the MIME type.
E 10
     *
     * <p>
     * <strong>Semantics:</strong> First check for the litteral mime type,
     * if that fails looks for wildcard <type>/\* and return that. Return the
     * list of all that hit.
D 10
     * </p>
E 10
     */
D 4
    public Vector getMailcapList(String mime_type)
E 4
I 4
D 8
    public Hashtable getMailcapList(String mime_type)
E 4
	{
D 4
	    Vector search_result = null;
E 4
I 4
	    Hashtable search_result = null;
E 4

	    // first try the literal
D 4
	    search_result = (Vector)type_hash.get((Object)mime_type);
E 4
I 4
	    search_result = (Hashtable)type_hash.get((Object)mime_type);
E 4
	    
D 4
	    if(search_result == null) // then try the wild card
		{
		    int separator = mime_type.indexOf('/');
		    String type = mime_type.substring(0, separator + 1);
		    type = new String(type + "*");
E 4
I 4
	    // REMIND: ADD THIS IN LATER
D 5
// 	    if(search_result == null) // then try the wild card
// 		{
// 		    int separator = mime_type.indexOf('/');
// 		    String type = mime_type.substring(0, separator + 1);
// 		    type = new String(type + "*");
E 4

D 4
		    search_result = (Vector)type_hash.get((Object) type);
E 4
I 4
// 		    search_result = (Vector)type_hash.get((Object) type);
E 4
		    
D 4
		}
E 4
I 4
// 		}
E 5
I 5
 	    if(search_result == null) { // then try the wild card
		int separator = mime_type.indexOf('/');
		String type = mime_type.substring(0, separator + 1);
		type = new String(type + "*");
D 6
		
E 6
		search_result = (Hashtable)type_hash.get((Object) type);
	    }
E 5
E 4
	    
	    return search_result;
E 8
I 8
D 10
    public Hashtable getMailcapList(String mime_type){
E 10
I 10
    public Hashtable getMailcapList(String mime_type) {
E 10
	Hashtable search_result = null;
I 9
	Hashtable wildcard_result = null;
E 9
D 10
	
E 10
I 10

E 10
	// first try the literal
D 10
	search_result = (Hashtable)type_hash.get((Object)mime_type);
	
E 10
I 10
	search_result = (Hashtable)type_hash.get(mime_type);

E 10
D 9
	// REMIND: ADD THIS IN LATER
	if(search_result == null) { // then try the wild card
	    int separator = mime_type.indexOf('/');
	    String type = mime_type.substring(0, separator + 1);
	    type = new String(type + "*");
	    search_result = (Hashtable)type_hash.get((Object) type);
E 9
I 9
	// ok, now try the wildcard
	int separator = mime_type.indexOf('/');
D 10
	String type = mime_type.substring(0, separator + 1);
	type = new String(type + "*");
	wildcard_result = (Hashtable)type_hash.get((Object) type);
E 10
I 10
	String type = mime_type.substring(0, separator + 1) + "*";
	wildcard_result = (Hashtable)type_hash.get(type);
E 10

D 10
	if(wildcard_result != null){ // damn, we have to merge!!!
	    if(search_result != null)
E 10
I 10
	if (wildcard_result != null) { // damn, we have to merge!!!
	    if (search_result != null)
E 10
		search_result = mergeResults(search_result, wildcard_result);
	    else
		search_result = wildcard_result;
E 9
E 8
	}
I 8
D 9
	
E 9
	return search_result;
    }
I 10

E 10
I 9
    /**
D 10
     * merge the second hash into the second
E 10
I 10
     * Merge the first hash into the second.
E 10
     * This merge will only effect the hashtable that is
     * returned, we don't want to touch the one passed in since
D 10
     * it's integrity must be maintained.
E 10
I 10
     * its integrity must be maintained.
E 10
     */
D 10
    private Hashtable mergeResults(Hashtable first, Hashtable second){
E 10
I 10
    private Hashtable mergeResults(Hashtable first, Hashtable second) {
E 10
	Enumeration verb_enum = second.keys();
	Hashtable clonedHash = (Hashtable)first.clone();

	// iterate through the verbs in the second map
D 10
	while(verb_enum.hasMoreElements()){
E 10
I 10
	while (verb_enum.hasMoreElements()) {
E 10
	    String verb = (String)verb_enum.nextElement();
	    Vector cmdVector = (Vector)clonedHash.get(verb);
D 10
	    if(cmdVector == null){
E 10
I 10
	    if (cmdVector == null) {
E 10
		clonedHash.put(verb, second.get(verb));
	    } else {
		// merge the two
		Vector oldV = (Vector)second.get(verb);
		Enumeration v_enum = oldV.elements();
		cmdVector = (Vector)cmdVector.clone();
		clonedHash.put(verb, cmdVector);
D 10
		while(v_enum.hasMoreElements()){
E 10
I 10
		while (v_enum.hasMoreElements()) {
E 10
		    cmdVector.addElement(v_enum.nextElement());
		}
	    }
	}
	return clonedHash;
    }
E 9
E 8
D 10
    ///////////////////////////////////////////////////////////////////////
E 10
I 10

E 10
    /**
     * appendToMailcap: Append to this Mailcap DB, use the mailcap
D 10
     * format: 
E 10
I 10
     * format:
E 10
     * Comment == "# <i>comment string</i>
     * Entry == "mimetype;        javabeanclass<nl>
     *
     * Example:
     * # this is a comment
     * image/gif       jaf.viewers.ImageViewer
     */
D 4
    public void appendToMailcap(String mail_cap)
	{
	    parseBufferizedMailcapFile( new StringBuffer( mail_cap ),
				       type_hash);
	}
E 4
I 4
    public void appendToMailcap(String mail_cap) {
I 14
	if (debug)
	    System.out.println("appendToMailcap: " + mail_cap);
E 14
D 7
	//	System.out.println("type hash before = " + type_hash);
E 7
D 10
	parseBufferizedMailcapFile( new StringReader( mail_cap ),
				    type_hash);
E 10
I 10
	try {
	    parse(new StringReader(mail_cap), type_hash);
	} catch (IOException ex) {
	    // can't happen
	}
E 10
D 8

E 8
D 7
	//	System.out.println("type hash after = " + type_hash);
E 7
    }
E 4
D 10
     
    ///////////////////////////////////////////////////////////////////////
E 10
I 10

E 10
    /**
D 8
     * The method that parses the bits in the mailcap file.
     *
     * @param ins The InputStream the represents the file
     */
D 7
    private void parseMailcapFile(InputStream ins)
	{
	    StringBuffer file_contents = null;
E 7
I 7
    private void parseMailcapFile(InputStream ins) {
	StringBuffer file_contents = null;
	
	// bufferize the file contents
	file_contents = this.bufferizeMailcapFile(ins);
E 7

D 7
	    // bufferize the file contents
	    file_contents = this.bufferizeMailcapFile(ins);

	    // parse the bufferized file
D 4
	    type_hash = this.createMailcapFileHash(file_contents);
E 4
I 4
	    // type_hash = this.createMailcapFileHash(file_contents);
E 4

	    
	}
E 7
I 7
    }
E 7
    ///////////////////////////////////////////////////////////////////////
    /**
E 8
     * create a hash table of Mail Type Entry Obj from a string buffer
     */
D 4
    private Hashtable createMailcapFileHash(StringBuffer file_contents)
E 4
I 4
D 7
    private Hashtable createMailcapHash(Reader reader)
E 4
	{
	    Hashtable new_hash = new Hashtable();

D 4
	    parseBufferizedMailcapFile(file_contents, new_hash);
E 4
I 4
	    parseBufferizedMailcapFile(reader, new_hash);
E 4

	    return new_hash;

	}
E 7
I 7
D 10
    private Hashtable createMailcapHash(Reader reader) {
E 10
I 10
    private Hashtable createMailcapHash(Reader reader) throws IOException {
E 10
	Hashtable new_hash = new Hashtable();
D 10
	
	parseBufferizedMailcapFile(reader, new_hash);
	
E 10
I 10

	parse(reader, new_hash);

E 10
	return new_hash;
D 10
	
E 10
    }
E 7
D 10
    ///////////////////////////////////////////////////////////////////////
E 10
I 10

E 10
    /**
D 10
     * parse bufferized file into a hash table of MC Type Entry Obj
E 10
I 10
     * parse file into a hash table of MC Type Entry Obj
E 10
     */
D 4
    private void parseBufferizedMailcapFile(StringBuffer file_contents,
E 4
I 4
D 10
    private void parseBufferizedMailcapFile(Reader reader,
E 4
D 8
					    Hashtable hash)
	{
D 4
	    // make a string reader
	    StringReader sins = new StringReader(file_contents.toString());
E 4
I 4
	    // StringReader sins = new StringReader(file_contents.toString());
E 4
	    // make a buffered string reader to parse for us
D 4
	    BufferedReader buf_reader = new BufferedReader(sins);
E 4
I 4
	    BufferedReader buf_reader = new BufferedReader(reader);
E 4
	    String line_o_text = null;
I 4
	    String continued = null;
E 4
	    boolean done = false;

	    try {
		while(buf_reader.ready() && !done)
		    {
			try {
			    line_o_text = buf_reader.readLine();
I 4
D 7
			    //  System.out.print("beep..");
E 7
I 7
			    //    System.out.println("parsing line: " + line_o_text);
E 7
			    if(line_o_text == null) {
E 8
I 8
					    Hashtable hash) {
	// StringReader sins = new StringReader(file_contents.toString());
	// make a buffered string reader to parse for us
E 10
I 10
    private void parse(Reader reader, Hashtable hash) throws IOException {
E 10
	BufferedReader buf_reader = new BufferedReader(reader);
D 10
	String line_o_text = null;
E 10
I 10
	String line = null;
E 10
	String continued = null;
D 10
	boolean done = false;
	
	try {
	    while(buf_reader.ready() && !done)
		{
E 10
I 10

	while ((line = buf_reader.readLine()) != null) {
	    //    System.out.println("parsing line: " + line);

	    line = line.trim();

	    try {
		if (line.charAt(0) == '#')
		    continue;
		if (line.charAt(line.length() - 1) == '\\') {
		    if (continued != null)
			continued += line.substring(0, line.length() - 1);
		    else
			continued = line.substring(0, line.length() - 1);
		} else if (continued != null) {
		    // handle the two strings
		    continued = continued + line;
		    //	System.out.println("parse: " + continued);
E 10
		    try {
D 10
			line_o_text = buf_reader.readLine();
			//    System.out.println("parsing line: " + line_o_text);
			if(line_o_text == null) {
E 8
D 6
			      System.out.println("encountered a null line");
E 6
I 6
				// System.out.println("encountered a null line");
E 6
D 8
			      break;
			    }
			      
			    line_o_text = line_o_text.trim();
			    
			    try {
			      if(line_o_text.charAt(0) != '#') {
E 8
I 8
			    break;
			}
			
			line_o_text = line_o_text.trim();
			
			try {
			    if(line_o_text.charAt(0) != '#') {
E 8
				if(line_o_text.charAt(
D 8
					   line_o_text.length() - 1) == '\\') {
				  if(continued != null)
				    continued = continued +
				      line_o_text.substring(0,
						   line_o_text.length() - 1);
				  else
				    continued = line_o_text.substring(0,
						    line_o_text.length() - 1);
E 8
I 8
						      line_o_text.length() - 1) == '\\') {
				    if(continued != null)
					continued = continued +
					    line_o_text.substring(0,
								  line_o_text.length() - 1);
				    else
					continued = line_o_text.substring(0,
									  line_o_text.length() - 1);
E 8
				} else if(continued != null) {
D 8
				  // handle the two strings
				  continued = continued + line_o_text;
				  //				  System.out.println("parse: " + continued);
				  try {
				    this.parse(continued, hash);
				  } catch (MailcapParseException e) {
				    e.printStackTrace(); }
				  continued = null;
E 8
I 8
				    // handle the two strings
				    continued = continued + line_o_text;
				    //				  System.out.println("parse: " + continued);
				    try {
					this.parse(continued, hash);
				    } catch (MailcapParseException e) {
					e.printStackTrace(); }
				    continued = null;
E 8
				} 
				else {
				    //				  System.out.println("parse: " + line_o_text);
D 8
				  try {
				    this.parse(line_o_text, hash);
// 				    System.out.println("hash.size = " +
// 						       hash.size());
				  } catch (MailcapParseException e) {
				    e.printStackTrace(); }
E 8
I 8
				    try {
					this.parse(line_o_text, hash);
					// 				    System.out.println("hash.size = " +
					// 						       hash.size());
				    } catch (MailcapParseException e) {
					e.printStackTrace(); }
E 8
				}
D 8
			      }
			    } catch (StringIndexOutOfBoundsException e) {}
E 4
			} catch(IOException e)
			    {
				System.out.println(e);
E 8
			    }
D 4
			if(line_o_text != null) // empty line
			    this.parseMailcapFileLine(line_o_text, hash);
			else
			    done = true;
E 4
I 4
D 8
			if(line_o_text == null) // empty line
			  done = true;
			//			System.out.println("DONE PARSING MAILCAP");
E 4
			
		    }
		} catch(IOException e)
		    {
			// REMIND: handle me better!
			System.out.println(e);
		    }
		
	}
    ///////////////////////////////////////////////////////////////////////
    /**
     * Parse of line of a .mailcap file
     */
    private void parseMailcapFileLine(String line, Hashtable hash)
	{
	    String mime_type = null;
	    String application = null;
	    String sub_string = new String(line.trim()); // create & trim
	    int next_semi = 0;
	    MailcapEntry mce = null;
	    Vector entry_list = null;

	    if(sub_string.length() == 0) // empty line...
		return; // BAIL!

	    // check to see if this is a comment line?
	    if(sub_string.charAt(0) == '#') 
		return; // then we are done!

	    next_semi = sub_string.indexOf(";");
	    
	    // get the MIME type
	    mime_type = sub_string.substring(0, next_semi);

	    sub_string = sub_string.substring(next_semi + 1);

	    sub_string = sub_string.trim(); // trim excess whitespace

	    mce = new MailcapEntry(mime_type, sub_string);

	    // first check to see if there are already entries for
	    // that MIME type:
	    entry_list = (Vector)hash.get((Object)mime_type);
	    if(entry_list == null) // we have no entry..
		entry_list = new Vector();
	    
	    entry_list.addElement((Object)mce);
	    
	    hash.put(mime_type, entry_list);
	    
	    if(DEBUG)
		System.out.println("Added: "+ mce.toString()+" to mailcapDB");

	}
    ///////////////////////////////////////////////////////////////////////
    /**
     * Bring file into memory
     *
     */
    private StringBuffer bufferizeMailcapFile(InputStream ins)
	{
	    byte b_array[] = new byte[1024];
	    int available = 0;
	    int bytes_read = 0;
	    boolean done = false;
	    StringBuffer file_contents = new StringBuffer();

	    while(!done)
		{
		    try {
			bytes_read = ins.read(b_array);
E 8
I 8
			} catch (StringIndexOutOfBoundsException e) {}
E 8
		    } catch(IOException e)
			{
D 8
			    // remind handle better
E 8
D 11
			    System.out.println(e);
E 11
I 11
			    //  System.out.println(e);
E 11
			}
D 8
		    // append to the file contents
		    file_contents.append(new String(b_array, 0, 
						    bytes_read));
		
		    // check if there is still stuff to read
		    try {
			available = ins.available();
		    }
		    catch (IOException e)
			{
			    System.out.println(e);
			}

		    // if not, we're done
		    if(available <= 0)
E 8
I 8
		    if(line_o_text == null) // empty line
E 8
			done = true;
I 8
		    //			System.out.println("DONE PARSING MAILCAP");
		    
E 10
I 10
			parseLine(continued, hash);
		    } catch (MailcapParseException e) {
			//e.printStackTrace();
		    }
		    continued = null;
E 10
E 8
		}
I 8
D 10
	} catch(IOException e)
	    {
		// REMIND: handle me better!
D 11
		System.out.println(e);
E 11
I 11
		//	System.out.println(e);
E 11
	    }
	
E 10
I 10
		else {
		    //	System.out.println("parse: " + line);
		    try {
			parseLine(line, hash);
			// System.out.println("hash.size = " + hash.size());
		    } catch (MailcapParseException e) {
			//e.printStackTrace();
		    }
		}
	    } catch (StringIndexOutOfBoundsException e) {}
	}
E 10
    }
E 8

D 8
	    return file_contents;
	}

I 3

	/**
	 *	A routine to parse individual entries in a Mailcap file.
	 *	
	 *	Note that this routine does not handle line continuations.
	 *	They should have been handled prior to calling this routine.
	 */
	 protected static void	parse(String mailcapEntry, Hashtable masterHash) throws MailcapParseException
	 {
	 	MailcapTokenizer tokenizer = new MailcapTokenizer(mailcapEntry);
	 	tokenizer.setIsAutoquoting(false);
	 	String primaryType = "";
	 	String subType = "*";
I 7
		String soFar = new String();
E 7
	 	
E 8
I 8
    /**
     *	A routine to parse individual entries in a Mailcap file.
D 10
     *	
E 10
I 10
     *
E 10
     *	Note that this routine does not handle line continuations.
     *	They should have been handled prior to calling this routine.
     */
D 10
    protected static void	parse(String mailcapEntry, Hashtable masterHash) 
	throws MailcapParseException {
	    MailcapTokenizer tokenizer = new MailcapTokenizer(mailcapEntry);
	    tokenizer.setIsAutoquoting(false);
	    String primaryType = "";
	    String subType = "*";
	    String soFar = new String();
	    
E 8
	    //	parse the primary type
	    int currentToken = tokenizer.nextToken();
E 10
I 10
    protected static void parseLine(String mailcapEntry, Hashtable masterHash)
				throws MailcapParseException, IOException {
	MailcapTokenizer tokenizer = new MailcapTokenizer(mailcapEntry);
	tokenizer.setIsAutoquoting(false);
	String primaryType = "";
	String subType = "*";
	String soFar = "";

I 14
	if (debug)
	    System.out.println("parse: " + mailcapEntry);
E 14
	//	parse the primary type
	int currentToken = tokenizer.nextToken();
	soFar = soFar.concat(tokenizer.getCurrentTokenValue());
	if (currentToken != MailcapTokenizer.STRING_TOKEN) {
	    reportParseError(MailcapTokenizer.STRING_TOKEN, currentToken,
					tokenizer.getCurrentTokenValue());
	}
	primaryType = tokenizer.getCurrentTokenValue().toLowerCase();

	//	parse the '/' between primary and sub
	//	if it's not present that's ok, we just don't have a subtype
	currentToken = tokenizer.nextToken();
	soFar = soFar.concat(tokenizer.getCurrentTokenValue());
	if ((currentToken != MailcapTokenizer.SLASH_TOKEN) &&
			(currentToken != MailcapTokenizer.SEMICOLON_TOKEN)) {
	    reportParseError(MailcapTokenizer.SLASH_TOKEN,
				MailcapTokenizer.SEMICOLON_TOKEN, currentToken,
				tokenizer.getCurrentTokenValue());
	}

	//	only need to look for a sub type if we got a '/'
	if (currentToken == MailcapTokenizer.SLASH_TOKEN) {
	    //	parse the sub type
	    currentToken = tokenizer.nextToken();
E 10
I 7
	    soFar = soFar.concat(tokenizer.getCurrentTokenValue());
E 7
D 8
	    if(currentToken != MailcapTokenizer.STRING_TOKEN)
	    {
E 8
I 8
D 10
	    if(currentToken != MailcapTokenizer.STRING_TOKEN) {
E 8
	    	reportParseError(MailcapTokenizer.STRING_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
E 10
I 10
	    if (currentToken != MailcapTokenizer.STRING_TOKEN) {
		reportParseError(MailcapTokenizer.STRING_TOKEN,
			    currentToken, tokenizer.getCurrentTokenValue());
E 10
	    }
D 10
	    primaryType = tokenizer.getCurrentTokenValue().toLowerCase();
	    
	    //	parse the '/' between primary and sub
	    //	if it's not present that's ok, we just don't have a subtype
E 10
I 10
	    subType = tokenizer.getCurrentTokenValue().toLowerCase();

	    //	get the next token to simplify the next step
E 10
	    currentToken = tokenizer.nextToken();
I 7
	    soFar = soFar.concat(tokenizer.getCurrentTokenValue());
E 7
D 10
	    if((currentToken != MailcapTokenizer.SLASH_TOKEN) && (currentToken != MailcapTokenizer.SEMICOLON_TOKEN))
	    {
	    	reportParseError(MailcapTokenizer.SLASH_TOKEN, MailcapTokenizer.SEMICOLON_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
	    }
	    
	    //	only need to look for a sub type if we got a '/'
	    if(currentToken == MailcapTokenizer.SLASH_TOKEN)
	    {
	    	//	parse the sub type
	    	currentToken = tokenizer.nextToken();
I 7
		soFar = soFar.concat(tokenizer.getCurrentTokenValue());
E 7
		    if(currentToken != MailcapTokenizer.STRING_TOKEN)
		    {
		    	reportParseError(MailcapTokenizer.STRING_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
		    }
		    subType = tokenizer.getCurrentTokenValue().toLowerCase();
		    
		    //	get the next token to simplify the next step
		    currentToken = tokenizer.nextToken();
I 7
		    soFar = soFar.concat(tokenizer.getCurrentTokenValue());
E 10
I 10
	}

I 14
	if (debug)
	    System.out.println("  Type: " + primaryType + "/" + subType);
E 14
	//	now setup the commands hashtable
	Hashtable commands =
	    (Hashtable)masterHash.get(primaryType + "/" + subType);
	if (commands == null) {
		commands = new Hashtable();
		masterHash.put(primaryType + "/" + subType, commands);
	}

	//	parse the ';' that separates the type from the parameters
	if (currentToken != MailcapTokenizer.SEMICOLON_TOKEN) {
	    reportParseError(MailcapTokenizer.SEMICOLON_TOKEN,
			    currentToken, tokenizer.getCurrentTokenValue());
	}
	//	eat it

	//	parse the required view command
	tokenizer.setIsAutoquoting(true);
	currentToken = tokenizer.nextToken();
	tokenizer.setIsAutoquoting(false);
	soFar = soFar.concat(tokenizer.getCurrentTokenValue());
	if ((currentToken != MailcapTokenizer.STRING_TOKEN) &&
		    (currentToken != MailcapTokenizer.SEMICOLON_TOKEN)) {
	    //	System.out.println("THE LINE SO FAR: " + soFar);
	    reportParseError(MailcapTokenizer.STRING_TOKEN,
			    MailcapTokenizer.SEMICOLON_TOKEN, currentToken,
			    tokenizer.getCurrentTokenValue());
	}
	//	eat it since JAF doesn't really care

	//	only have to get the next token if the current one isn't a ';'
	if (currentToken != MailcapTokenizer.SEMICOLON_TOKEN) {
	    currentToken = tokenizer.nextToken();
	}

	// look for a ';' which will indicate whether
	// a parameter list is present or not
	if (currentToken == MailcapTokenizer.SEMICOLON_TOKEN) {
	    do {
		//	eat the ';'

		//	parse the parameter name
		currentToken = tokenizer.nextToken();
		if (currentToken != MailcapTokenizer.STRING_TOKEN) {
		    reportParseError(MailcapTokenizer.STRING_TOKEN,
			    currentToken, tokenizer.getCurrentTokenValue());
E 10
E 7
		}
D 10
		
		//	now setup the commands hashtable
		Hashtable commands = (Hashtable)masterHash.get(primaryType + "/" + subType);
		if(commands == null)
		{
			commands = new Hashtable();
			masterHash.put(primaryType + "/" + subType, commands);
		}
		
		//	parse the ';' that separates the type from the parameters
		if(currentToken != MailcapTokenizer.SEMICOLON_TOKEN)
		{
	    	reportParseError(MailcapTokenizer.SEMICOLON_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
		}
		//	eat it
		
		//	parse the required view command
		tokenizer.setIsAutoquoting(true);
E 10
I 10
		String paramName =
		    tokenizer.getCurrentTokenValue().toLowerCase();

		//	parse the '=' which separates the name from the value
E 10
		currentToken = tokenizer.nextToken();
D 10
		tokenizer.setIsAutoquoting(false);
I 7
		soFar = soFar.concat(tokenizer.getCurrentTokenValue());
E 7
	    if((currentToken != MailcapTokenizer.STRING_TOKEN) && (currentToken != MailcapTokenizer.SEMICOLON_TOKEN))
	    {
I 7
		//	System.out.println("THE LINE SO FAR: " + soFar);
E 7
	    	reportParseError(MailcapTokenizer.STRING_TOKEN, MailcapTokenizer.SEMICOLON_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
E 10
I 10
		if ((currentToken != MailcapTokenizer.EQUALS_TOKEN) &&
		    (currentToken != MailcapTokenizer.SEMICOLON_TOKEN) &&
		    (currentToken != MailcapTokenizer.EOI_TOKEN)) {
		    reportParseError(MailcapTokenizer.EQUALS_TOKEN,
			    MailcapTokenizer.SEMICOLON_TOKEN,
			    MailcapTokenizer.EOI_TOKEN,
			    currentToken, tokenizer.getCurrentTokenValue());
		}
E 10
I 7

E 7
D 10
	    }
	    //	eat it since JAF doesn't really care
	    
	    //	only have to get the next token if the current one isn't a ';'
	    if(currentToken != MailcapTokenizer.SEMICOLON_TOKEN)
	    {
E 10
I 10
		//	we only have a useful command if it is named
		if (currentToken == MailcapTokenizer.EQUALS_TOKEN) {
		    //	eat it

		    //	parse the parameter value (which is autoquoted)
		    tokenizer.setIsAutoquoting(true);
E 10
		    currentToken = tokenizer.nextToken();
D 10
	    }
	    
	    //	look for a ';' which will indicate whether a parameter list is present or not
	    if(currentToken == MailcapTokenizer.SEMICOLON_TOKEN)
	    {
	    	do
	    	{
		    	//	eat the ';'
		    	
			    //	parse the parameter name
			    currentToken = tokenizer.nextToken();
			    if(currentToken != MailcapTokenizer.STRING_TOKEN)
			    {
			    	reportParseError(MailcapTokenizer.STRING_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
			    }
			    String paramName = tokenizer.getCurrentTokenValue().toLowerCase();
			    
			    //	parse the '=' which separates the name from the value
			    currentToken = tokenizer.nextToken();
			    if((currentToken != MailcapTokenizer.EQUALS_TOKEN) && (currentToken != MailcapTokenizer.SEMICOLON_TOKEN) &&(currentToken != MailcapTokenizer.EOI_TOKEN))
			    {
			    	reportParseError(MailcapTokenizer.EQUALS_TOKEN, MailcapTokenizer.SEMICOLON_TOKEN, MailcapTokenizer.EOI_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
			    }
			    
			    //	we only have a useful command if it is named
			    if(currentToken == MailcapTokenizer.EQUALS_TOKEN)
			    {
				    //	eat it
				    
				    //	parse the parameter value (which is autoquoted)
				    tokenizer.setIsAutoquoting(true);
				    currentToken = tokenizer.nextToken();
				    tokenizer.setIsAutoquoting(false);
				    if(currentToken != MailcapTokenizer.STRING_TOKEN)
				    {
				    	reportParseError(MailcapTokenizer.STRING_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
				    }
				    String paramValue = tokenizer.getCurrentTokenValue();
				    
				    //	add the class to the classlist iff it is one we care about
				    if(paramName.startsWith("x-java-"))
				    {
				    	String commandName = paramName.substring(7);	//	7 == "x-java-".length
				    	
					    //	setup the class entry list
					    Vector classes = (Vector)commands.get(commandName);
					    if(classes == null)
					    {
					    	classes = new Vector();
					    	commands.put(commandName, classes);
					    }
D 8
					    classes.addElement(paramValue);
E 8
I 8
					    // classes.addElement(paramValue);
					    classes.insertElementAt(paramValue, 0);
E 8
				    }
				    
				    //	set up the next iteration
				    currentToken = tokenizer.nextToken();
			    }
E 10
I 10
		    tokenizer.setIsAutoquoting(false);
		    if (currentToken != MailcapTokenizer.STRING_TOKEN) {
			reportParseError(MailcapTokenizer.STRING_TOKEN,
			currentToken, tokenizer.getCurrentTokenValue());
E 10
		    }
D 10
		    while(currentToken == MailcapTokenizer.SEMICOLON_TOKEN);
	    }
	    else if(currentToken != MailcapTokenizer.EOI_TOKEN)
	    {
	    	reportParseError(MailcapTokenizer.EOI_TOKEN, MailcapTokenizer.SEMICOLON_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
	    }
	 }
    
     protected static void	reportParseError(int expectedToken, int actualToken, String actualTokenValue) throws MailcapParseException
     {
     	throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(actualToken) + " token (" + actualTokenValue + ") while expecting a " + MailcapTokenizer.nameForToken(expectedToken) + " token.");
E 10
I 10
		    String paramValue =
				tokenizer.getCurrentTokenValue();

		    // add the class to the list iff it is one we care about
		    if (paramName.startsWith("x-java-")) {
			String commandName = paramName.substring(7);
			//	7 == "x-java-".length

			//	setup the class entry list
I 14
			if (debug)
			    System.out.println("    Command: " + commandName +
						", Class: " + paramValue);
E 14
			Vector classes =
				(Vector)commands.get(commandName);
			if (classes == null) {
			    classes = new Vector();
			    commands.put(commandName, classes);
			}
			// classes.addElement(paramValue);
			classes.insertElementAt(paramValue, 0);
		    }

		    //	set up the next iteration
		    currentToken = tokenizer.nextToken();
		}
	    } while (currentToken == MailcapTokenizer.SEMICOLON_TOKEN);
	} else if (currentToken != MailcapTokenizer.EOI_TOKEN) {
	    reportParseError(MailcapTokenizer.EOI_TOKEN,
		MailcapTokenizer.SEMICOLON_TOKEN,
		currentToken, tokenizer.getCurrentTokenValue());
	}
E 10
     }
D 10
    
     protected static void	reportParseError(int expectedToken, int otherExpectedToken, int actualToken, String actualTokenValue) throws MailcapParseException
     {
     	throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(actualToken) + " token (" + actualTokenValue + ") while expecting a " + MailcapTokenizer.nameForToken(expectedToken) + " or a " + MailcapTokenizer.nameForToken(otherExpectedToken) + " token.");
E 10
I 10

     protected static void reportParseError(int expectedToken, int actualToken,
		String actualTokenValue) throws MailcapParseException {
     	throw new MailcapParseException("Encountered a " +
		MailcapTokenizer.nameForToken(actualToken) + " token (" +
		actualTokenValue + ") while expecting a " +
		MailcapTokenizer.nameForToken(expectedToken) + " token.");
E 10
     }
D 10
     
     protected static void	reportParseError(int expectedToken, int otherExpectedToken, int anotherExpectedToken, int actualToken, String actualTokenValue) throws MailcapParseException
     {
     	throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(actualToken) + " token (" + actualTokenValue + ") while expecting a " + MailcapTokenizer.nameForToken(expectedToken) + ", a " + MailcapTokenizer.nameForToken(otherExpectedToken) + ", or a " + MailcapTokenizer.nameForToken(anotherExpectedToken) + " token.");
E 10
I 10

     protected static void reportParseError(int expectedToken,
	int otherExpectedToken, int actualToken, String actualTokenValue)
					throws MailcapParseException {
     	throw new MailcapParseException("Encountered a " +
		MailcapTokenizer.nameForToken(actualToken) + " token (" +
		actualTokenValue + ") while expecting a " +
		MailcapTokenizer.nameForToken(expectedToken) + " or a " +
		MailcapTokenizer.nameForToken(otherExpectedToken) + " token.");
E 10
     }
D 10
     
     public static void	main(String[] args) throws MailcapParseException
     {
E 10
I 10

     protected static void reportParseError(int expectedToken,
D 14
	int otherExpectedToken, int anotherExpectedToken, int actualToken,
	String actualTokenValue) throws MailcapParseException {
E 14
I 14
	    int otherExpectedToken, int anotherExpectedToken, int actualToken,
	    String actualTokenValue) throws MailcapParseException {
	if (debug)
	    System.out.println("PARSE ERROR: " + "Encountered a " +
		MailcapTokenizer.nameForToken(actualToken) + " token (" +
		actualTokenValue + ") while expecting a " +
		MailcapTokenizer.nameForToken(expectedToken) + ", a " +
		MailcapTokenizer.nameForToken(otherExpectedToken) + ", or a " +
		MailcapTokenizer.nameForToken(anotherExpectedToken) + " token.");
E 14
     	throw new MailcapParseException("Encountered a " +
		MailcapTokenizer.nameForToken(actualToken) + " token (" +
		actualTokenValue + ") while expecting a " +
		MailcapTokenizer.nameForToken(expectedToken) + ", a " +
		MailcapTokenizer.nameForToken(otherExpectedToken) + ", or a " +
		MailcapTokenizer.nameForToken(anotherExpectedToken) + " token.");
     }

I 13
     /** for debugging
E 13
     public static void	main(String[] args) throws Exception {
E 10
     	Hashtable masterHash = new Hashtable();
D 10
     	for(int i = 0; i < args.length; ++i)
     	{
     		System.out.println("Entry " + i + ": " + args[i]);
     		parse(args[i], masterHash);
E 10
I 10
     	for (int i = 0; i < args.length; ++i) {
	    System.out.println("Entry " + i + ": " + args[i]);
	    parseLine(args[i], masterHash);
E 10
     	}
D 10
     	
E 10
I 10

E 10
     	Enumeration types = masterHash.keys();
D 10
     	while(types.hasMoreElements())
     	{
     		String key = (String)types.nextElement();
     		System.out.println("MIME Type: " + key);
     		
     		Hashtable commandHash = (Hashtable)masterHash.get(key);
     		Enumeration commands = commandHash.keys();
     		while(commands.hasMoreElements())
     		{
     			String command = (String)commands.nextElement();
     			System.out.println("    Command: " + command);
     			
     			Vector classes = (Vector)commandHash.get(command);
     			for(int i = 0; i < classes.size(); ++i)
     			{
	     			System.out.println("        Class: " + (String)classes.elementAt(i));
     			}
     		}
     		
     		System.out.println("");
     	}
     }
E 10
I 10
     	while (types.hasMoreElements()) {
	    String key = (String)types.nextElement();
	    System.out.println("MIME Type: " + key);

	    Hashtable commandHash = (Hashtable)masterHash.get(key);
	    Enumeration commands = commandHash.keys();
	    while (commands.hasMoreElements()) {
		String command = (String)commands.nextElement();
		System.out.println("    Command: " + command);

		Vector classes = (Vector)commandHash.get(command);
		for (int i = 0; i < classes.size(); ++i) {
			System.out.println("        Class: " +
					    (String)classes.elementAt(i));
		}
	    }

	    System.out.println("");
	}
    }
I 13
    */
E 13
E 10
E 3
}
E 1
