h22417
s 00006/00017/00063
d D 1.8 99/12/06 16:33:40 shannon 9 8
c Update copyright for SCSL release
e
s 00006/00002/00074
d D 1.7 99/09/01 13:56:12 shannon 8 7
c clarify javadocs - bug 4267294
e
s 00017/00015/00059
d D 1.6 99/03/25 17:34:58 shannon 7 6
c clean up code and javadocs
e
s 00011/00010/00063
d D 1.5 98/02/20 19:32:36 miltonb 6 5
c edit 0.6 version
e
s 00003/00002/00070
d D 1.4 97/12/19 14:32:57 bhc 5 4
c javadoc fixes
c 
e
s 00004/00002/00068
d D 1.3 97/12/08 08:12:30 bhc 4 3
c changed javadoc to reflect that getCT should always return SOMETHING
e
s 00004/00003/00066
d D 1.2 97/10/13 11:26:35 bhc 3 1
c now throws correct exceptions
c 
e
s 00000/00000/00000
d R 1.2 97/09/05 16:22:25 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/javax/activation/DataSource.java
c Name history : 1 0 src/classes/javax/activation/DataSource.java
e
s 00069/00000/00000
d D 1.1 97/09/05 16:22:24 bhc 1 0
c date and time created 97/09/05 16:22:24 by bhc
e
u
U
f e 0
t
T
I 1
/*
D 6
 * %W% %E%
E 6
I 6
D 7
 * @(#)DataSource.java	1.4 97/12/19
E 7
I 7
D 9
 * %W%	%E%
E 9
I 9
 * %W% %E%
E 9
E 7
E 6
 *
D 7
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
E 7
I 7
D 9
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
E 7
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You shall
 * not disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * @author Bart Calder
E 9
I 9
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 9
 */

package javax.activation;

import java.io.InputStream;
import java.io.OutputStream;
I 3
import java.io.IOException;
E 3

/**
 * The DataSource interface provides the JavaBeans Activation Framework
D 6
 * with an abstraction of some arbitrary collection of data. It is
D 5
 * reasonsible for providing type for that data as well as access
 * to it in the form of Input and Output streams where appropriate.
E 5
I 5
 * responsible for providing a type for that data as well as access
E 6
I 6
D 7
 * with an abstraction of some arbitrary collection of data. It 
E 7
I 7
 * with an abstraction of some arbitrary collection of data. It
E 7
 * provides a type for that data as well as access
E 6
D 7
 * to it in the form of <code>InputStreams</code> and 
E 7
I 7
 * to it in the form of <code>InputStreams</code> and
E 7
 * <code>OutputStreams</code> where appropriate.
E 5
D 3

E 3
 */
I 3

E 3
public interface DataSource {

D 7
    /** 
D 6
     * This method will return an <code>InputStream</code> representing the 
     * the data and will throw the appropriate exception if it can
E 6
I 6
     * This method returns an <code>InputStream</code> representing the 
E 7
I 7
    /**
     * This method returns an <code>InputStream</code> representing the
E 7
     * the data and throws the appropriate exception if it can
E 6
D 8
     * not do so.
E 8
I 8
     * not do so.  Note that a new <code>InputStream</code> object must be
     * returned each time this method is called, and the stream must be
     * positioned at the beginning of the data.
E 8
     *
D 7
     * @return          an InputStream
E 7
I 7
     * @return an InputStream
E 7
     */
D 3
    public InputStream getInputStream() throws Exception;
E 3
I 3
    public InputStream getInputStream() throws IOException;
E 3

D 7
    /** 
D 6
     * This method will return an <code>OutputStream</code> where the 
     * data can be written and will throw the appropriate exception if it can
E 6
I 6
     * This method returns an <code>OutputStream</code> where the 
E 7
I 7
    /**
     * This method returns an <code>OutputStream</code> where the
E 7
     * data can be written and throws the appropriate exception if it can
E 6
D 8
     * not do so.
E 8
I 8
     * not do so.  Note that a new <code>OutputStream</code> object must
     * be returned each time this method is called, and the stream must
     * be positioned at the location the data is to be written.
E 8
I 7
     *
E 7
     * @return an OutputStream
     */
D 3
    public OutputStream getOutputStream() throws Exception;
E 3
I 3
    public OutputStream getOutputStream() throws IOException;
E 3

    /**
D 4
     * This method returns the MIME type of the data in the for of a 
     * string.
E 4
I 4
D 7
     * This method returns the MIME type of the data in the form of a 
E 7
I 7
     * This method returns the MIME type of the data in the form of a
E 7
     * string. It should always return a valid type. It is suggested
D 6
     * that the type to be returned if the DataSource implementation
     * cannot determine the type be "application/octet-stream".
E 6
I 6
     * that getContentType return "application/octet-stream" if the
     * DataSource implementation can not determine the data type.
     *
E 6
E 4
     * @return the MIME Type
     */
    public String getContentType();
D 7
    
E 7
I 7

E 7
    /**
D 7
     * Return the 'name' of this object where the name of the object
E 7
I 7
     * Return the <i>name</i> of this object where the name of the object
E 7
     * is dependant on the nature of the underlying objects. DataSources
D 7
     * encapsulating file may choose to return the filename of the object.
D 6
     *
E 6
I 6
     * 
E 7
I 7
     * encapsulating files may choose to return the filename of the object.
     * (Typically this would be the last component of the filename, not an
     * entire pathname.)
     *
E 7
E 6
     * @return the name of the object.
     */
    public String getName();
D 7

E 7
}
E 1
