/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.reporter.Reporter;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Pattern;

public class Macro {
    Properties properties;
    Reporter domain;
    static Pattern commands = Pattern.compile(";");
    static /* synthetic */ Class class$0;

    public Macro(Properties properties, Reporter domain) {
        this.properties = properties;
        this.domain = domain;
    }

    public Macro(Reporter processor) {
        this(new Properties(), processor);
    }

    public String process(String line) {
        StringBuffer sb = new StringBuffer();
        this.process(line, 0, '\u0000', '\u0000', sb);
        return sb.toString();
    }

    int process(String line, int index, char begin, char end, StringBuffer result) {
        int nesting = 1;
        StringBuffer variable = new StringBuffer();
        while (index < line.length()) {
            char c2;
            char terminator;
            char c1;
            if ((c1 = line.charAt(index++)) == end) {
                if (--nesting == 0) {
                    result.append(this.replace(variable.toString()));
                    return index;
                }
            } else if (c1 == begin) {
                ++nesting;
            } else if (c1 == '$' && index < line.length() - 2 && (terminator = this.getTerminator(c2 = line.charAt(index))) != '\u0000') {
                index = this.process(line, index + 1, c2, terminator, variable);
                continue;
            }
            variable.append(c1);
        }
        result.append(variable);
        return index;
    }

    char getTerminator(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '{': {
                return '}';
            }
            case '<': {
                return '>';
            }
            case '\u00ab': {
                return '\u00bb';
            }
            case '\u2039': {
                return '\u203a';
            }
        }
        return '\u0000';
    }

    protected String replace(String key) {
        if (key != null) {
            if ((key = key.trim()).length() > 0) {
                String value = this.properties.getProperty(key);
                if (value != null) {
                    return value;
                }
                value = this.doCommands(key);
                if (value != null) {
                    return value;
                }
                if (key != null && key.trim().length() > 0 && (value = System.getProperty(key)) != null) {
                    return value;
                }
                this.domain.warning("No translation found for macro: " + key);
            } else {
                this.domain.warning("Found empty macro key");
            }
        } else {
            this.domain.warning("Found null macro key");
        }
        return "${" + key + "}";
    }

    private String doCommands(String key) {
        String[] args = commands.split(key);
        if (args == null || args.length == 0) {
            return null;
        }
        String result = this.doCommand(this.domain, args);
        if (result != null) {
            return result;
        }
        return this.doCommand(this, args);
    }

    private String doCommand(Object target, String[] args) {
        String cname = "_" + args[0].replaceAll("-", "_");
        try {
            Class<?> clazz = target.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("[Ljava.lang.String;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method m = clazz.getMethod(cname, classArray);
            return (String)m.invoke(target, new Object[]{args});
        }
        catch (NoSuchMethodException m) {
        }
        catch (InvocationTargetException e) {
            this.domain.warning("Exception in replace: " + e.getCause());
        }
        catch (Exception e) {
            this.domain.warning("Exception in replace: " + e);
        }
        return null;
    }

    public String _filter(String[] args) {
        if (args.length != 3) {
            this.domain.warning("Invalid nr of arguments to filter " + Arrays.asList(args));
            return null;
        }
        String[] list = args[1].split("\\s*,\\s*");
        StringBuffer sb = new StringBuffer();
        String del = "";
        int i = 0;
        while (i < list.length) {
            if (list[i].matches(args[2])) {
                sb.append(del);
                sb.append(list[i]);
                del = ", ";
            }
            ++i;
        }
        return sb.toString();
    }

    public String _filterout(String[] args) {
        if (args.length != 3) {
            this.domain.warning("Invalid nr of arguments to filterout " + Arrays.asList(args));
            return null;
        }
        String[] list = args[1].split("\\s*,\\s*");
        StringBuffer sb = new StringBuffer();
        String del = "";
        int i = 0;
        while (i < list.length) {
            if (!list[i].matches(args[2])) {
                sb.append(del);
                sb.append(list[i]);
                del = ", ";
            }
            ++i;
        }
        return sb.toString();
    }

    public String _sort(String[] args) {
        if (args.length != 2) {
            this.domain.warning("Invalid nr of arguments to join " + Arrays.asList(args));
            return null;
        }
        Object[] list = args[1].split("\\s*,\\s*");
        StringBuffer sb = new StringBuffer();
        String del = "";
        Arrays.sort(list);
        int i = 0;
        while (i < list.length) {
            sb.append(del);
            sb.append((String)list[i]);
            del = ", ";
            ++i;
        }
        return sb.toString();
    }

    public String _join(String[] args) {
        if (args.length == 1) {
            this.domain.warning("Invalid nr of arguments to join " + Arrays.asList(args));
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String del = "";
        int i = 1;
        while (i < args.length) {
            String[] list = args[i].split("\\s*,\\s*");
            int j = 0;
            while (j < list.length) {
                sb.append(del);
                sb.append(list[j]);
                del = ", ";
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    public String _if(String[] args) {
        if (args.length < 3) {
            this.domain.warning("Invalid nr of arguments to if " + Arrays.asList(args));
            return null;
        }
        if (args[1].trim().length() != 0) {
            return args[2];
        }
        if (args.length > 3) {
            return args[3];
        }
        return "";
    }

    public String _now(String[] args) {
        return new Date().toString();
    }

    public String _fmodified(String[] args) throws Exception {
        if (args.length != 2) {
            this.domain.warning("Fmodified takes only 1 parameter " + Arrays.asList(args));
            return null;
        }
        long time = 0L;
        String[] list = args[1].split("\\s*,\\s*");
        int i = 0;
        while (i < list.length) {
            File f = new File(list[i].trim());
            if (f.exists() && f.lastModified() > time) {
                time = f.lastModified();
            }
            ++i;
        }
        return "" + time;
    }

    public String _long2date(String[] args) {
        try {
            return new Date(Long.parseLong(args[1])).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "not a valid long";
        }
    }

    public String _literal(String[] args) {
        if (args.length != 2) {
            throw new RuntimeException("Need a value for the ${literal:<value>} macro");
        }
        return "${" + args[1] + "}";
    }

    public String _replace(String[] args) {
        if (args.length != 4) {
            this.domain.warning("Invalid nr of arguments to replace " + Arrays.asList(args));
            return null;
        }
        String[] list = args[1].split("\\s*,\\s*");
        StringBuffer sb = new StringBuffer();
        String del = "";
        int i = 0;
        while (i < list.length) {
            String element = list[i].trim();
            if (!element.equals("")) {
                sb.append(del);
                sb.append(element.replaceAll(args[2], args[3]));
                del = ", ";
            }
            ++i;
        }
        return sb.toString();
    }

    public String _warning(String[] args) {
        int i = 1;
        while (i < args.length) {
            this.domain.warning(this.process(args[i]));
            ++i;
        }
        return "";
    }

    public String _error(String[] args) {
        int i = 1;
        while (i < args.length) {
            this.domain.error(this.process(args[i]));
            ++i;
        }
        return "";
    }

    public String _toclassname(String[] args) {
        if (args.length != 2) {
            this.domain.warning("Invalid nr of arguments to toclassname " + Arrays.asList(args));
            return null;
        }
        String[] list = args[1].split("\\s*,\\s*");
        StringBuffer sb = new StringBuffer();
        String del = "";
        int i = 0;
        while (i < list.length) {
            String element = list[i];
            if (element.endsWith(".class")) {
                element = element.substring(0, element.length() - 6).replace('/', '.');
                sb.append(del);
                sb.append(element);
                del = ", ";
            } else {
                this.domain.warning("in toclassname, " + args[1] + " is not a class path because it does not end in .class");
            }
            ++i;
        }
        return sb.toString();
    }

    public String _toclasspath(String[] args) {
        if (args.length != 2) {
            this.domain.warning("Invalid nr of arguments to toclasspath " + Arrays.asList(args));
            return null;
        }
        String[] list = args[1].split("\\s*,\\s*");
        StringBuffer sb = new StringBuffer();
        String del = "";
        int i = 0;
        while (i < list.length) {
            String element = list[i];
            element = String.valueOf(element.replace('.', '/')) + ".class";
            sb.append(del);
            sb.append(element);
            del = ", ";
            ++i;
        }
        return sb.toString();
    }
}

