/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.ErrorConsts;
import com.fasterxml.aalto.IoStreamException;
import com.fasterxml.aalto.UncheckedStreamException;
import com.fasterxml.aalto.WFCException;
import com.fasterxml.aalto.in.InputBootstrapper;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.XmlScanner;
import com.fasterxml.aalto.util.TextAccumulator;
import com.fasterxml.aalto.util.XmlNames;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.AttributeInfo;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.LocationInfo;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.ri.Stax2Util;
import org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import org.codehaus.stax2.ri.typed.ValueDecoderFactory;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.Base64Variants;
import org.codehaus.stax2.typed.TypedArrayDecoder;
import org.codehaus.stax2.typed.TypedValueDecoder;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import org.codehaus.stax2.validation.DTDValidationSchema;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;

public final class StreamReaderImpl
implements XMLStreamReader2,
AttributeInfo,
DTDInfo,
LocationInfo {
    static final int STATE_PROLOG = 0;
    static final int STATE_TREE = 1;
    static final int STATE_EPILOG = 2;
    static final int STATE_CLOSED = 3;
    protected final XmlScanner _scanner;
    protected final boolean _cfgCoalesceText;
    protected final boolean _cfgReportTextAsChars;
    protected int _currToken;
    protected int _parseState;
    protected PName _currName;
    protected int _attrCount;
    protected ValueDecoderFactory _decoderFactory;
    protected CharArrayBase64Decoder _base64Decoder = null;
    private static final int MASK_GET_TEXT = 6768;
    private static final int MASK_GET_TEXT_XXX = 4208;
    private static final int MASK_GET_TEXT_WITH_WRITER = 6776;
    private static final int MASK_GET_ELEMENT_TEXT = 4688;
    private static final int MASK_TYPED_ACCESS_ARRAY = 4182;
    private static final int MASK_TYPED_ACCESS_BINARY = 4178;

    public StreamReaderImpl(XmlScanner scanner) {
        this._scanner = scanner;
        this._currToken = 7;
        ReaderConfig cfg = scanner.getConfig();
        this._cfgCoalesceText = cfg.willCoalesceText();
        this._cfgReportTextAsChars = !cfg.willReportCData();
    }

    public static StreamReaderImpl construct(InputBootstrapper bs) throws XMLStreamException {
        return new StreamReaderImpl(bs.bootstrap());
    }

    public XmlScanner getScanner() {
        return this._scanner;
    }

    public String getCharacterEncodingScheme() {
        return this._scanner.getConfig().getXmlDeclEncoding();
    }

    public String getEncoding() {
        return this._scanner.getConfig().getActualEncoding();
    }

    public String getVersion() {
        return this._scanner.getConfig().getXmlDeclVersion();
    }

    public boolean isStandalone() {
        return this._scanner.getConfig().getXmlDeclStandalone() == 1;
    }

    public boolean standaloneSet() {
        return this._scanner.getConfig().getXmlDeclStandalone() != 0;
    }

    public Object getProperty(String name) {
        if (name.equals("javax.xml.stream.entities")) {
            return Collections.EMPTY_LIST;
        }
        if (name.equals("javax.xml.stream.notations")) {
            return Collections.EMPTY_LIST;
        }
        return this._scanner.getConfig().getProperty(name, false);
    }

    public int getAttributeCount() {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._attrCount;
    }

    public String getAttributeLocalName(int index) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index >= this._attrCount || index < 0) {
            this.reportInvalidAttrIndex(index);
        }
        return this._scanner.getAttrLocalName(index);
    }

    public QName getAttributeName(int index) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index >= this._attrCount || index < 0) {
            this.reportInvalidAttrIndex(index);
        }
        return this._scanner.getAttrQName(index);
    }

    public String getAttributeNamespace(int index) {
        String p;
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index >= this._attrCount || index < 0) {
            this.reportInvalidAttrIndex(index);
        }
        return (p = this._scanner.getAttrNsURI(index)) == null ? "" : p;
    }

    public String getAttributePrefix(int index) {
        String p;
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index >= this._attrCount || index < 0) {
            this.reportInvalidAttrIndex(index);
        }
        return (p = this._scanner.getAttrPrefix(index)) == null ? "" : p;
    }

    public String getAttributeType(int index) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index >= this._attrCount || index < 0) {
            this.reportInvalidAttrIndex(index);
        }
        return this._scanner.getAttrType(index);
    }

    public String getAttributeValue(int index) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index >= this._attrCount || index < 0) {
            this.reportInvalidAttrIndex(index);
        }
        return this._scanner.getAttrValue(index);
    }

    public String getAttributeValue(String nsURI, String localName) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._scanner.getAttrValue(nsURI, localName);
    }

    public String getElementText() throws XMLStreamException {
        int type;
        int type2;
        if (this._currToken != 1) {
            this.throwWfe(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        do {
            if ((type2 = this.next()) != 2) continue;
            return "";
        } while (type2 == 5 || type2 == 3);
        if ((1 << type2 & 0x1250) == 0) {
            this.throwWfe("Expected a text token, got " + ErrorConsts.tokenTypeDesc(type2) + ".");
        }
        String text = this._scanner.getText();
        TextAccumulator acc = null;
        while ((type = this.next()) != 2) {
            if ((1 << type & 0x1250) != 0) {
                if (acc == null) {
                    acc = new TextAccumulator();
                    acc.addText(text);
                }
                acc.addText(this.getText());
                continue;
            }
            if (type == 5 || type == 3) continue;
            this.throwWfe("Expected a text token, got " + ErrorConsts.tokenTypeDesc(type) + ".");
        }
        return acc == null ? text : acc.getAndClear();
    }

    public int getEventType() {
        if (this._currToken == 12 && (this._cfgCoalesceText || this._cfgReportTextAsChars)) {
            return 4;
        }
        return this._currToken;
    }

    public String getLocalName() {
        if (this._currToken == 1 || this._currToken == 2 || this._currToken == 9) {
            return this._currName.getLocalName();
        }
        throw new IllegalStateException("Current state not START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE");
    }

    public QName getName() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this._scanner.getQName();
    }

    public NamespaceContext getNamespaceContext() {
        return this._scanner;
    }

    public int getNamespaceCount() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this._scanner.getNsCount();
    }

    public String getNamespacePrefix(int index) {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String p = this._scanner.getNamespacePrefix(index);
        return p == null ? "" : p;
    }

    public String getNamespaceURI() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String uri = this._scanner.getNamespaceURI();
        return uri == null ? "" : uri;
    }

    public String getNamespaceURI(int index) {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String uri = this._scanner.getNamespaceURI(index);
        return uri == null ? "" : uri;
    }

    public String getNamespaceURI(String prefix) {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this._scanner.getNamespaceURI(prefix);
    }

    public String getPIData() {
        if (this._currToken != 3) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_PI);
        }
        try {
            return this._scanner.getText();
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    public String getPITarget() {
        if (this._currToken != 3) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_PI);
        }
        return this._currName.getLocalName();
    }

    public String getPrefix() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String p = this._currName.getPrefix();
        return p == null ? "" : p;
    }

    public String getText() {
        if ((1 << this._currToken & 0x1A70) == 0) {
            this.throwNotTextual(this._currToken);
        }
        try {
            return this._scanner.getText();
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    public char[] getTextCharacters() {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        try {
            return this._scanner.getTextCharacters();
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    public int getTextCharacters(int srcStart, char[] target, int targetStart, int len) {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        try {
            return this._scanner.getTextCharacters(srcStart, target, targetStart, len);
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    public int getTextLength() {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        try {
            return this._scanner.getTextLength();
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    public int getTextStart() {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        return 0;
    }

    public boolean hasName() {
        return this._currToken == 1 || this._currToken == 2;
    }

    public boolean hasNext() {
        return this._currToken != 8;
    }

    public boolean hasText() {
        return (1 << this._currToken & 0x1A70) != 0;
    }

    public boolean isAttributeSpecified(int index) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._scanner.isAttrSpecified(index);
    }

    public boolean isCharacters() {
        return this._currToken == 4;
    }

    public boolean isEndElement() {
        return this._currToken == 2;
    }

    public boolean isStartElement() {
        return this._currToken == 1;
    }

    public boolean isWhiteSpace() {
        if (this._currToken == 4 || this._currToken == 12) {
            try {
                return this._scanner.isTextWhitespace();
            }
            catch (XMLStreamException sex) {
                throw UncheckedStreamException.createFrom(sex);
            }
        }
        return this._currToken == 6;
    }

    public void require(int type, String nsUri, String localName) throws XMLStreamException {
        int curr = this._currToken;
        if (curr != type) {
            if (curr == 12) {
                if (this._cfgCoalesceText || this._cfgReportTextAsChars) {
                    curr = 4;
                }
            } else if (curr == 6) {
                // empty if block
            }
        }
        if (type != curr) {
            this.throwWfe("Expected type " + ErrorConsts.tokenTypeDesc(type) + ", current type " + ErrorConsts.tokenTypeDesc(curr));
        }
        if (localName != null) {
            String n;
            if (curr != 1 && curr != 2 && curr != 9) {
                this.throwWfe("Expected non-null local name, but current token not a START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE (was " + ErrorConsts.tokenTypeDesc(this._currToken) + ")");
            }
            if ((n = this.getLocalName()) != localName && !n.equals(localName)) {
                this.throwWfe("Expected local name '" + localName + "'; current local name '" + n + "'.");
            }
        }
        if (nsUri != null) {
            if (curr != 1 && curr != 2) {
                this.throwWfe("Expected non-null NS URI, but current token not a START_ELEMENT or END_ELEMENT (was " + ErrorConsts.tokenTypeDesc(curr) + ")");
            }
            String uri = this.getNamespaceURI();
            if (nsUri.length() == 0) {
                if (uri != null && uri.length() > 0) {
                    this.throwWfe("Expected empty namespace, instead have '" + uri + "'.");
                }
            } else if (nsUri != uri && !nsUri.equals(uri)) {
                this.throwWfe("Expected namespace '" + nsUri + "'; have '" + uri + "'.");
            }
        }
    }

    public int next() throws XMLStreamException {
        int type;
        if (this._parseState == 1) {
            int type2 = this._scanner.nextFromTree();
            if (type2 == -1) {
                this.handleTreeEoi();
            }
            this._currToken = type2;
            if (type2 == 12) {
                if (this._cfgCoalesceText || this._cfgReportTextAsChars) {
                    return 4;
                }
            } else {
                this._currName = this._scanner.getName();
                if (type2 == 2) {
                    if (this._scanner.hasEmptyStack()) {
                        this._parseState = 2;
                    }
                } else if (type2 == 1) {
                    this._attrCount = this._scanner.getAttrCount();
                }
            }
            return type2;
        }
        if (this._parseState == 0) {
            type = this._scanner.nextFromProlog(true);
            if (type == 1) {
                this._parseState = 1;
                this._attrCount = this._scanner.getAttrCount();
            }
        } else if (this._parseState == 2) {
            type = this._scanner.nextFromProlog(false);
        } else {
            throw new NoSuchElementException();
        }
        if (type < 0) {
            return this.handlePrologEoi(this._parseState == 0);
        }
        this._currName = this._scanner.getName();
        this._currToken = type;
        return this._currToken;
    }

    public int nextTag() throws XMLStreamException {
        block5: while (true) {
            int next = this.next();
            switch (next) {
                case 3: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 4: 
                case 12: {
                    if (this.isWhiteSpace()) continue block5;
                    this.throwWfe("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().");
                    break;
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
            this.throwWfe("Received event " + ErrorConsts.tokenTypeDesc(next) + ", instead of START_ELEMENT or END_ELEMENT.");
        }
    }

    public void close() throws XMLStreamException {
        this._closeScanner(false);
    }

    public Location getLocation() {
        return this.getStartLocation();
    }

    public boolean getElementAsBoolean() throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder dec = this._decoderFactory().getBooleanDecoder();
        this.getElementAs((TypedValueDecoder)dec);
        return dec.getValue();
    }

    public int getElementAsInt() throws XMLStreamException {
        ValueDecoderFactory.IntDecoder dec = this._decoderFactory().getIntDecoder();
        this.getElementAs((TypedValueDecoder)dec);
        return dec.getValue();
    }

    public long getElementAsLong() throws XMLStreamException {
        ValueDecoderFactory.LongDecoder dec = this._decoderFactory().getLongDecoder();
        this.getElementAs((TypedValueDecoder)dec);
        return dec.getValue();
    }

    public float getElementAsFloat() throws XMLStreamException {
        ValueDecoderFactory.FloatDecoder dec = this._decoderFactory().getFloatDecoder();
        this.getElementAs((TypedValueDecoder)dec);
        return dec.getValue();
    }

    public double getElementAsDouble() throws XMLStreamException {
        ValueDecoderFactory.DoubleDecoder dec = this._decoderFactory().getDoubleDecoder();
        this.getElementAs((TypedValueDecoder)dec);
        return dec.getValue();
    }

    public BigInteger getElementAsInteger() throws XMLStreamException {
        ValueDecoderFactory.IntegerDecoder dec = this._decoderFactory().getIntegerDecoder();
        this.getElementAs((TypedValueDecoder)dec);
        return dec.getValue();
    }

    public BigDecimal getElementAsDecimal() throws XMLStreamException {
        ValueDecoderFactory.DecimalDecoder dec = this._decoderFactory().getDecimalDecoder();
        this.getElementAs((TypedValueDecoder)dec);
        return dec.getValue();
    }

    public QName getElementAsQName() throws XMLStreamException {
        ValueDecoderFactory.QNameDecoder dec = this._decoderFactory().getQNameDecoder(this.getNamespaceContext());
        this.getElementAs((TypedValueDecoder)dec);
        return this.verifyQName(dec.getValue());
    }

    public final byte[] getElementAsBinary() throws XMLStreamException {
        return this.getElementAsBinary(Base64Variants.getDefaultVariant());
    }

    public void getElementAs(TypedValueDecoder tvd) throws XMLStreamException {
        String value = this.getElementText();
        if ((value = value.trim()).length() == 0) {
            this._handleEmptyValue(tvd);
            return;
        }
        try {
            tvd.decode(value);
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypeException(iae, value);
        }
    }

    public byte[] getElementAsBinary(Base64Variant v) throws XMLStreamException {
        Stax2Util.ByteAggregator aggr = this._base64Decoder().getByteAggregator();
        byte[] buffer = aggr.startAggregation();
        while (true) {
            int readCount;
            int offset = 0;
            int len = buffer.length;
            do {
                if ((readCount = this.readElementAsBinary(buffer, offset, len, v)) < 1) {
                    return aggr.aggregateAll(buffer, offset);
                }
                offset += readCount;
            } while ((len -= readCount) > 0);
            buffer = aggr.addFullBlock(buffer);
        }
    }

    public int readElementAsIntArray(int[] value, int from, int length) throws XMLStreamException {
        return this.readElementAsArray((TypedArrayDecoder)this._decoderFactory().getIntArrayDecoder(value, from, length));
    }

    public int readElementAsLongArray(long[] value, int from, int length) throws XMLStreamException {
        return this.readElementAsArray((TypedArrayDecoder)this._decoderFactory().getLongArrayDecoder(value, from, length));
    }

    public int readElementAsFloatArray(float[] value, int from, int length) throws XMLStreamException {
        return this.readElementAsArray((TypedArrayDecoder)this._decoderFactory().getFloatArrayDecoder(value, from, length));
    }

    public int readElementAsDoubleArray(double[] value, int from, int length) throws XMLStreamException {
        return this.readElementAsArray((TypedArrayDecoder)this._decoderFactory().getDoubleArrayDecoder(value, from, length));
    }

    public final int readElementAsArray(TypedArrayDecoder dec) throws XMLStreamException {
        boolean reset;
        int type = this._currToken;
        if ((1 << type & 0x1056) == 0) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM_OR_TEXT);
        }
        if (type == 1) {
            if (this._scanner.isEmptyTag()) {
                this.next();
                return -1;
            }
            do {
                if ((type = this.next()) != 2) continue;
                return -1;
            } while (type == 5 || type == 3);
            if (type != 4 && type != 12) {
                throw this._constructUnexpectedInTyped(type);
            }
            reset = true;
        } else {
            reset = false;
        }
        int count = 0;
        while (type != 2) {
            if (type == 4 || type == 12 || type == 6) {
                count += this._scanner.decodeElements(dec, reset);
                if (!dec.hasRoom()) {
                    break;
                }
            } else if (type != 5 && type != 3) {
                throw this._constructUnexpectedInTyped(type);
            }
            reset = true;
            type = this.next();
        }
        return count > 0 ? count : -1;
    }

    public final int readElementAsBinary(byte[] resultBuffer, int offset, int maxLength) throws XMLStreamException {
        return this.readElementAsBinary(resultBuffer, offset, maxLength, Base64Variants.getDefaultVariant());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readElementAsBinary(byte[] resultBuffer, int offset, int maxLength, Base64Variant v) throws XMLStreamException {
        if (resultBuffer == null) {
            throw new IllegalArgumentException("resultBuffer is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Illegal offset (" + offset + "), must be [0, " + resultBuffer.length + "[");
        }
        if (maxLength < 1 || offset + maxLength > resultBuffer.length) {
            if (maxLength != 0) throw new IllegalArgumentException("Illegal maxLength (" + maxLength + "), has to be positive number, and offset+maxLength can not exceed" + resultBuffer.length);
            return 0;
        }
        CharArrayBase64Decoder dec = this._base64Decoder();
        int type = this._currToken;
        if ((1 << type & 0x1052) == 0) {
            if (type != 2) throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM_OR_TEXT);
            if (!dec.hasData()) {
                return -1;
            }
        } else if (type == 1) {
            if (this._scanner.isEmptyTag()) {
                this.next();
                return -1;
            }
            do {
                if ((type = this.next()) != 2) continue;
                return -1;
            } while (type == 5 || type == 3);
            if (type != 4) {
                if (type != 12) throw this._constructUnexpectedInTyped(type);
            }
            this._scanner.resetForDecoding(v, dec, true);
        }
        int totalCount = 0;
        while (true) {
            int count;
            try {
                count = dec.decode(resultBuffer, offset, maxLength);
            }
            catch (IllegalArgumentException iae) {
                throw this._constructTypeException(iae.getMessage(), "");
            }
            offset += count;
            totalCount += count;
            if ((maxLength -= count) < 1 || this._currToken == 2) break;
            while ((type = this.next()) == 5 || type == 3 || type == 6) {
            }
            if (type == 2) {
                int left = dec.endOfContent();
                if (left < 0) {
                    throw this._constructTypeException("Incomplete base64 triplet at the end of decoded content", "");
                }
                if (left <= 0) break;
                continue;
            }
            this._scanner.resetForDecoding(v, dec, false);
        }
        if (totalCount <= 0) return -1;
        int n = totalCount;
        return n;
    }

    public int getAttributeIndex(String namespaceURI, String localName) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this.findAttributeIndex(namespaceURI, localName);
    }

    public boolean getAttributeAsBoolean(int index) throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder dec = this._decoderFactory().getBooleanDecoder();
        this.getAttributeAs(index, (TypedValueDecoder)dec);
        return dec.getValue();
    }

    public int getAttributeAsInt(int index) throws XMLStreamException {
        ValueDecoderFactory.IntDecoder dec = this._decoderFactory().getIntDecoder();
        this.getAttributeAs(index, (TypedValueDecoder)dec);
        return dec.getValue();
    }

    public long getAttributeAsLong(int index) throws XMLStreamException {
        ValueDecoderFactory.LongDecoder dec = this._decoderFactory().getLongDecoder();
        this.getAttributeAs(index, (TypedValueDecoder)dec);
        return dec.getValue();
    }

    public float getAttributeAsFloat(int index) throws XMLStreamException {
        ValueDecoderFactory.FloatDecoder dec = this._decoderFactory().getFloatDecoder();
        this.getAttributeAs(index, (TypedValueDecoder)dec);
        return dec.getValue();
    }

    public double getAttributeAsDouble(int index) throws XMLStreamException {
        ValueDecoderFactory.DoubleDecoder dec = this._decoderFactory().getDoubleDecoder();
        this.getAttributeAs(index, (TypedValueDecoder)dec);
        return dec.getValue();
    }

    public BigInteger getAttributeAsInteger(int index) throws XMLStreamException {
        ValueDecoderFactory.IntegerDecoder dec = this._decoderFactory().getIntegerDecoder();
        this.getAttributeAs(index, (TypedValueDecoder)dec);
        return dec.getValue();
    }

    public BigDecimal getAttributeAsDecimal(int index) throws XMLStreamException {
        ValueDecoderFactory.DecimalDecoder dec = this._decoderFactory().getDecimalDecoder();
        this.getAttributeAs(index, (TypedValueDecoder)dec);
        return dec.getValue();
    }

    public QName getAttributeAsQName(int index) throws XMLStreamException {
        ValueDecoderFactory.QNameDecoder dec = this._decoderFactory().getQNameDecoder(this.getNamespaceContext());
        this.getAttributeAs(index, (TypedValueDecoder)dec);
        return this.verifyQName(dec.getValue());
    }

    public void getAttributeAs(int index, TypedValueDecoder tvd) throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        try {
            this._scanner.decodeAttrValue(index, tvd);
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypeException(iae, this.getAttributeValue(index));
        }
    }

    public int[] getAttributeAsIntArray(int index) throws XMLStreamException {
        ValueDecoderFactory.IntArrayDecoder dec = this._decoderFactory().getIntArrayDecoder();
        this.getAttributeAsArray(index, (TypedArrayDecoder)dec);
        return dec.getValues();
    }

    public long[] getAttributeAsLongArray(int index) throws XMLStreamException {
        ValueDecoderFactory.LongArrayDecoder dec = this._decoderFactory().getLongArrayDecoder();
        this.getAttributeAsArray(index, (TypedArrayDecoder)dec);
        return dec.getValues();
    }

    public float[] getAttributeAsFloatArray(int index) throws XMLStreamException {
        ValueDecoderFactory.FloatArrayDecoder dec = this._decoderFactory().getFloatArrayDecoder();
        this.getAttributeAsArray(index, (TypedArrayDecoder)dec);
        return dec.getValues();
    }

    public double[] getAttributeAsDoubleArray(int index) throws XMLStreamException {
        ValueDecoderFactory.DoubleArrayDecoder dec = this._decoderFactory().getDoubleArrayDecoder();
        this.getAttributeAsArray(index, (TypedArrayDecoder)dec);
        return dec.getValues();
    }

    public int getAttributeAsArray(int index, TypedArrayDecoder tad) throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._scanner.decodeAttrValues(index, tad);
    }

    public byte[] getAttributeAsBinary(int index) throws XMLStreamException {
        return this.getAttributeAsBinary(index, Base64Variants.getDefaultVariant());
    }

    public byte[] getAttributeAsBinary(int index, Base64Variant v) throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._scanner.decodeAttrBinaryValue(index, v, this._base64Decoder());
    }

    protected QName verifyQName(QName n) throws TypedXMLStreamException {
        String ln = n.getLocalPart();
        int ix = XmlNames.findIllegalNameChar(ln, false);
        if (ix >= 0) {
            String prefix = n.getPrefix();
            String pname = prefix != null && prefix.length() > 0 ? prefix + ":" + ln : ln;
            throw this._constructTypeException("Invalid local name \"" + ln + "\" (character at #" + ix + " is invalid)", pname);
        }
        return n;
    }

    public Object getFeature(String name) {
        return null;
    }

    public void setFeature(String name, Object value) {
    }

    public boolean isPropertySupported(String name) {
        return this._scanner.getConfig().isPropertySupported(name);
    }

    public boolean setProperty(String name, Object value) {
        return this._scanner.getConfig().setProperty(name, value);
    }

    public void skipElement() throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        int nesting = 1;
        while (true) {
            int type;
            if ((type = this.next()) == 1) {
                ++nesting;
                continue;
            }
            if (type == 2 && --nesting == 0) break;
        }
    }

    public AttributeInfo getAttributeInfo() throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this;
    }

    public DTDInfo getDTDInfo() throws XMLStreamException {
        if (this._currToken != 11) {
            return null;
        }
        return this;
    }

    public final LocationInfo getLocationInfo() {
        return this;
    }

    public int getText(Writer w, boolean preserveContents) throws XMLStreamException {
        if ((1 << this._currToken & 0x1A78) == 0) {
            this.throwNotTextual(this._currToken);
        }
        return this._scanner.getText(w, preserveContents);
    }

    public int getDepth() {
        int d = this._scanner.getDepth();
        if (this._currToken == 2) {
            ++d;
        }
        return d;
    }

    public boolean isEmptyElement() throws XMLStreamException {
        return this._currToken == 1 ? this._scanner.isEmptyTag() : false;
    }

    public NamespaceContext getNonTransientNamespaceContext() {
        return this._scanner.getNonTransientNamespaceContext();
    }

    public String getPrefixedName() {
        switch (this._currToken) {
            case 1: 
            case 2: {
                return this._currName.getPrefixedName();
            }
            case 9: {
                return this.getLocalName();
            }
            case 3: {
                return this.getPITarget();
            }
            case 11: {
                return this.getDTDRootName();
            }
        }
        throw new IllegalStateException("Current state not START_ELEMENT, END_ELEMENT, ENTITY_REFERENCE, PROCESSING_INSTRUCTION or DTD");
    }

    public void closeCompletely() throws XMLStreamException {
        this._closeScanner(true);
    }

    public Object getProcessedDTD() {
        return null;
    }

    public String getDTDRootName() {
        return this._currToken == 11 ? this._currName.getPrefixedName() : null;
    }

    public String getDTDPublicId() {
        return this._scanner.getDtdPublicId();
    }

    public String getDTDSystemId() {
        return this._scanner.getDtdSystemId();
    }

    public String getDTDInternalSubset() {
        if (this._currToken != 11) {
            return null;
        }
        try {
            return this._scanner.getText();
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    public DTDValidationSchema getProcessedDTDSchema() {
        return null;
    }

    public long getStartingByteOffset() {
        return -1L;
    }

    public long getStartingCharOffset() {
        return -1L;
    }

    public long getEndingByteOffset() throws XMLStreamException {
        return -1L;
    }

    public long getEndingCharOffset() throws XMLStreamException {
        return -1L;
    }

    public final XMLStreamLocation2 getStartLocation() {
        return this._scanner.getStartLocation();
    }

    public final XMLStreamLocation2 getEndLocation() throws XMLStreamException {
        return this._scanner.getEndLocation();
    }

    public final XMLStreamLocation2 getCurrentLocation() {
        return this._scanner.getStartLocation();
    }

    public int findAttributeIndex(String nsURI, String localName) {
        return this._scanner.findAttrIndex(nsURI, localName);
    }

    public int getIdAttributeIndex() {
        return -1;
    }

    public int getNotationAttributeIndex() {
        return -1;
    }

    public XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        return null;
    }

    public ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler h) {
        return null;
    }

    protected Location getLastCharLocation() {
        return this._scanner.getCurrentLocation();
    }

    protected int handlePrologEoi(boolean isProlog) throws XMLStreamException {
        this.close();
        if (isProlog) {
            this.throwUnexpectedEOI(ErrorConsts.SUFFIX_IN_PROLOG);
        }
        return 8;
    }

    protected void handleTreeEoi() throws XMLStreamException {
        this._currToken = 8;
        this.throwUnexpectedEOI(ErrorConsts.SUFFIX_IN_TREE);
    }

    protected void throwWfe(String msg) throws XMLStreamException {
        throw new WFCException(msg, this.getLastCharLocation());
    }

    private void throwNotTextual(int type) {
        throw new IllegalStateException("Not a textual event (" + ErrorConsts.tokenTypeDesc(this._currToken) + ")");
    }

    private void throwNotTextXxx(int type) {
        throw new IllegalStateException("getTextXxx() methods can not be called on " + ErrorConsts.tokenTypeDesc(this._currToken));
    }

    protected void throwFromIOE(IOException ioe) throws XMLStreamException {
        throw new IoStreamException(ioe);
    }

    protected void throwUnexpectedEOI(String msg) throws XMLStreamException {
        this.throwWfe("Unexpected End-of-input" + msg);
    }

    protected XMLStreamException _constructUnexpectedInTyped(int nextToken) {
        if (nextToken == 1) {
            return this._constructTypeException("Element content can not contain child START_ELEMENT when using Typed Access methods", null);
        }
        return this._constructTypeException("Expected a text token, got " + ErrorConsts.tokenTypeDesc(nextToken), null);
    }

    private TypedXMLStreamException _constructTypeException(IllegalArgumentException iae, String lexicalValue) {
        return new TypedXMLStreamException(lexicalValue, iae.getMessage(), (Location)this.getStartLocation(), iae);
    }

    private TypedXMLStreamException _constructTypeException(String msg, String lexicalValue) {
        return new TypedXMLStreamException(lexicalValue, msg, (Location)this.getStartLocation());
    }

    protected void reportInvalidAttrIndex(int index) {
        throw new IllegalArgumentException("Illegal attribute index, " + index + ", current START_ELEMENT has " + this._attrCount + " attributes");
    }

    protected void _closeScanner(boolean forceStreamClose) throws XMLStreamException {
        if (this._parseState != 3) {
            this._parseState = 3;
            if (this._currToken != 8) {
                this._currToken = 8;
            }
        }
        this._scanner.close(forceStreamClose);
    }

    protected final ValueDecoderFactory _decoderFactory() {
        if (this._decoderFactory == null) {
            this._decoderFactory = new ValueDecoderFactory();
        }
        return this._decoderFactory;
    }

    protected CharArrayBase64Decoder _base64Decoder() {
        if (this._base64Decoder == null) {
            this._base64Decoder = new CharArrayBase64Decoder();
        }
        return this._base64Decoder;
    }

    private void _handleEmptyValue(TypedValueDecoder dec) throws XMLStreamException {
        try {
            dec.handleEmptyValue();
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypeException(iae, "");
        }
    }

    public String toString() {
        return "[Aalto stream reader, scanner type: " + this._scanner.getClass().getName() + "]";
    }
}

