/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.repackage.cglib.transform;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.hibernate.repackage.cglib.asm.Attribute;
import org.hibernate.repackage.cglib.asm.ClassReader;
import org.hibernate.repackage.cglib.asm.ClassWriter;
import org.hibernate.repackage.cglib.asm.attrs.Attributes;
import org.hibernate.repackage.cglib.core.ClassGenerator;
import org.hibernate.repackage.cglib.core.CodeGenerationException;
import org.hibernate.repackage.cglib.core.DebuggingClassWriter;
import org.hibernate.repackage.cglib.transform.ClassFilter;
import org.hibernate.repackage.cglib.transform.ClassReaderGenerator;

public abstract class AbstractClassLoader
extends ClassLoader {
    private ClassFilter filter;
    private ClassLoader classPath;
    private static ProtectionDomain DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return (class$org$hibernate$repackage$cglib$transform$AbstractClassLoader == null ? (class$org$hibernate$repackage$cglib$transform$AbstractClassLoader = AbstractClassLoader.class$("org.hibernate.repackage.cglib.transform.AbstractClassLoader")) : class$org$hibernate$repackage$cglib$transform$AbstractClassLoader).getProtectionDomain();
        }
    });
    static /* synthetic */ Class class$org$hibernate$repackage$cglib$transform$AbstractClassLoader;

    protected AbstractClassLoader(ClassLoader parent, ClassLoader classPath, ClassFilter filter) {
        super(parent);
        this.filter = filter;
        this.classPath = classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String name) throws ClassNotFoundException {
        ClassReader r;
        Class<?> loaded = this.findLoadedClass(name);
        if (loaded != null && loaded.getClassLoader() == this) {
            return loaded;
        }
        if (!this.filter.accept(name)) {
            return super.loadClass(name);
        }
        try {
            InputStream is = this.classPath.getResourceAsStream(name.replace('.', '/') + ".class");
            if (is == null) {
                throw new ClassNotFoundException(name);
            }
            try {
                r = new ClassReader(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name + ":" + e.getMessage());
        }
        try {
            DebuggingClassWriter w = new DebuggingClassWriter(true);
            this.getGenerator(r).generateClass(w);
            byte[] b = ((ClassWriter)w).toByteArray();
            Class<?> c = super.defineClass(name, b, 0, b.length, DOMAIN);
            this.postProcess(c);
            return c;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    protected ClassGenerator getGenerator(ClassReader r) {
        return new ClassReaderGenerator(r, this.attributes(), this.skipDebug());
    }

    protected boolean skipDebug() {
        return false;
    }

    protected Attribute[] attributes() {
        return Attributes.getDefaultAttributes();
    }

    protected void postProcess(Class c) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

