/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.AbstractJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.SymbolTable;
import java.util.Map;

public class DefaultJSONParser
extends AbstractJSONParser {
    protected final JSONLexer lexer;
    protected final Object input;
    protected final SymbolTable symbolTable;
    protected ParserConfig config;

    public DefaultJSONParser(String input) {
        this(input, ParserConfig.getGlobalInstance(), JSON.DEFAULT_PARSER_FEATURE);
    }

    public DefaultJSONParser(String input, ParserConfig config) {
        this((Object)input, new JSONScanner(input, JSON.DEFAULT_PARSER_FEATURE), config);
    }

    public DefaultJSONParser(String input, ParserConfig config, int features) {
        this((Object)input, new JSONScanner(input, features), config);
    }

    public DefaultJSONParser(char[] input, int length, ParserConfig config, int features) {
        this(input, new JSONScanner(input, length, features), config);
    }

    public DefaultJSONParser(Object input, JSONLexer lexer, ParserConfig config) {
        this.input = input;
        this.lexer = lexer;
        this.config = config;
        this.symbolTable = config.getSymbolTable();
        lexer.nextToken(12);
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public JSONLexer getLexer() {
        return this.lexer;
    }

    public String getInput() {
        if (this.input instanceof char[]) {
            return new String((char[])this.input);
        }
        return this.input.toString();
    }

    public final void parseObject(Map object) {
        String key;
        char ch;
        JSONScanner lexer = (JSONScanner)this.lexer;
        if (lexer.token() != 12) {
            throw new JSONException("syntax error, expect {, actual " + lexer.token());
        }
        while (true) {
            Object value;
            lexer.skipWhitespace();
            ch = lexer.getCurrent();
            if (this.isEnabled(Feature.AllowArbitraryCommas)) {
                while (ch == ',') {
                    lexer.incrementBufferPosition();
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                }
            }
            if (ch == '\"') {
                key = lexer.scanSymbol(this.symbolTable, '\"');
                lexer.skipWhitespace();
                ch = lexer.getCurrent();
                if (ch != ':') {
                    throw new JSONException("expect ':' at " + lexer.pos() + ", name " + key);
                }
            } else {
                if (ch == '}') {
                    lexer.incrementBufferPosition();
                    lexer.resetStringPosition();
                    lexer.nextToken();
                    return;
                }
                if (ch == '\'') {
                    if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                        throw new JSONException("syntax error");
                    }
                    key = lexer.scanSymbol(this.symbolTable, '\'');
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos());
                    }
                } else {
                    if (ch == '\u001a') {
                        throw new JSONException("syntax error");
                    }
                    if (ch == ',') {
                        throw new JSONException("syntax error");
                    }
                    if (!this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                        throw new JSONException("syntax error");
                    }
                    key = lexer.scanSymbolUnQuoted(this.symbolTable);
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                    }
                }
            }
            lexer.incrementBufferPosition();
            lexer.skipWhitespace();
            ch = lexer.getCurrent();
            lexer.resetStringPosition();
            if (ch == '\"') {
                JSONScanner iso8601Lexer;
                lexer.scanString();
                String strValue = lexer.stringVal();
                value = strValue;
                if (lexer.isEnabled(Feature.AllowISO8601DateFormat) && (iso8601Lexer = new JSONScanner(strValue)).scanISO8601DateIfMatch()) {
                    value = iso8601Lexer.getCalendar().getTime();
                }
                object.put(key, value);
            } else if (ch >= '0' && ch <= '9' || ch == '-') {
                lexer.scanNumber();
                value = lexer.token() == 2 ? lexer.integerValue() : lexer.decimalValue();
                object.put(key, value);
            } else {
                if (ch == '[') {
                    lexer.nextToken();
                    JSONArray list = new JSONArray();
                    this.parseArray(list);
                    value = list;
                    object.put(key, value);
                    if (lexer.token() == 13) {
                        lexer.nextToken();
                        return;
                    }
                    if (lexer.token() == 16) continue;
                    throw new JSONException("syntax error");
                }
                if (ch == '{') {
                    lexer.nextToken();
                    JSONObject obj = new JSONObject();
                    this.parseObject(obj);
                    object.put(key, obj);
                    if (lexer.token() == 13) {
                        lexer.nextToken();
                        return;
                    }
                    if (lexer.token() == 16) continue;
                    throw new JSONException("syntax error");
                }
                lexer.nextToken();
                value = this.parse();
                object.put(key, value);
                if (lexer.token() == 13) {
                    lexer.nextToken();
                    return;
                }
                if (lexer.token() == 16) continue;
                throw new JSONException("syntax error, position at " + lexer.pos() + ", name " + key);
            }
            lexer.skipWhitespace();
            ch = lexer.getCurrent();
            if (ch != ',') break;
            lexer.incrementBufferPosition();
        }
        if (ch == '}') {
            lexer.incrementBufferPosition();
            lexer.resetStringPosition();
            lexer.nextToken();
            return;
        }
        throw new JSONException("syntax error, position at " + lexer.pos() + ", name " + key);
    }
}

