/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.main.compiler;

import aQute.lib.osgi.Processor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.compiler.batch.Main;

public class BndCompiler
extends Processor {
    File[] classpath;
    File[] sourcepath;
    File bin;
    String targetLevel;
    String sourceLevel;
    boolean debug;
    String cwd = new File("").getAbsolutePath();
    static /* synthetic */ Class class$0;

    public static boolean isAvailable() {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("aQute.bnd.main.compiler.BndCompiler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            clazz.getClassLoader().loadClass("org.eclipse.jdt.internal.compiler.batch.Main");
            return true;
        }
        catch (ClassNotFoundException t) {
            return false;
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setClasspath(File[] classpath) {
        this.classpath = classpath;
    }

    public void setSourcepath(File[] sourcepath) {
        this.sourcepath = sourcepath;
    }

    public void setTargetLevel(String targetLevel) {
        this.targetLevel = targetLevel;
    }

    public void setSourceLevel(String sourceLevel) {
        this.sourceLevel = sourceLevel;
    }

    public void setBin(File bin) {
        this.bin = bin;
    }

    public void compile() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("-classpath ");
        this.explode(sb, this.classpath, File.pathSeparator);
        sb.append(String.valueOf(File.pathSeparator) + System.getProperty("java.class.path"));
        sb.append(" -sourcepath ");
        this.explode(sb, this.sourcepath, File.pathSeparator);
        sb.append(" -target ");
        sb.append(this.targetLevel);
        sb.append(" -source ");
        sb.append(this.sourceLevel);
        sb.append(" -d ");
        sb.append(this.bin.getAbsolutePath());
        sb.append(" -g ");
        int i = 0;
        while (i < this.sourcepath.length) {
            File dir = this.sourcepath[i];
            ArrayList l = new ArrayList();
            this.expand(l, dir);
            Iterator sub = l.iterator();
            while (sub.hasNext()) {
                File f = (File)sub.next();
                String path = this.getShortPath(f);
                sb.append(" ");
                sb.append(path);
            }
            ++i;
        }
        StringWriter errors = new StringWriter();
        StringWriter warnings = new StringWriter();
        System.out.println("Compile: " + sb.toString());
        Main.compile((String)sb.toString(), (PrintWriter)new PrintWriter(errors), (PrintWriter)new PrintWriter(warnings));
        this.addToList(this.getErrors(), errors.getBuffer());
        this.addToList(this.getWarnings(), warnings.getBuffer());
    }

    private void expand(List l, File dir) {
        File[] subs = dir.listFiles();
        int i = 0;
        while (i < subs.length) {
            if (subs[i].isDirectory()) {
                this.expand(l, subs[i]);
            } else if (subs[i].getName().endsWith(".java")) {
                l.add(subs[i]);
            }
            ++i;
        }
    }

    private void addToList(List list, StringBuffer buffer) throws IOException {
        BufferedReader rdr = new BufferedReader(new StringReader(buffer.toString()));
        String line = rdr.readLine();
        while (line != null) {
            list.add(line);
        }
    }

    private void explode(StringBuffer sb, File[] classpath, String separator) {
        String del = "";
        int i = 0;
        while (i < classpath.length) {
            sb.append(del);
            sb.append(this.getShortPath(classpath[i]));
            del = separator;
            ++i;
        }
    }

    private String getShortPath(File file) {
        String path = file.getAbsolutePath();
        if (path.startsWith(this.cwd)) {
            path = path.substring(this.cwd.length());
        }
        return path;
    }
}

