/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.popup.actions;

import aQute.bnd.plugin.Activator;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.eclipse.EclipseClasspath;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class MakeBundle
implements IObjectActionDelegate {
    IFile[] locations;

    public void run(IAction action) {
        block13: {
            Activator activator = Activator.getDefault();
            try {
                if (this.locations == null) break block13;
                int i = 0;
                while (i < this.locations.length) {
                    try {
                        File mf = this.locations[i].getLocation().toFile();
                        Builder builder = MakeBundle.setBuilder(activator, this.locations[i].getProject(), mf);
                        String path = builder.getProperty("-output");
                        if (path == null) {
                            path = mf.getAbsolutePath().replaceAll("\\.bnd$", ".jar");
                        }
                        File target = new File(path);
                        target.delete();
                        builder.build();
                        Jar jar = builder.getJar();
                        if (builder.getErrors().size() > 0) {
                            activator.error(builder.getErrors());
                        } else {
                            jar.write(target);
                            File copy = activator.getCopy();
                            if (copy != null) {
                                copy = new File(copy, target.getName());
                                jar.write(copy);
                            }
                            if (builder.getWarnings().size() > 0) {
                                activator.warning(builder.getWarnings());
                            } else if (activator.getReportDone()) {
                                String msg = "Saved as " + path;
                                if (copy != null) {
                                    msg = String.valueOf(msg) + " and copied to " + copy;
                                }
                                activator.message(msg);
                            }
                        }
                        builder.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        activator.error("While generating JAR " + this.locations[i], e);
                    }
                    this.locations[i].getParent().refreshLocal(1, null);
                    ++i;
                }
            }
            catch (Exception e) {
                activator.error("Error in bnd", e);
            }
        }
    }

    public static Builder setBuilder(Activator activator, IProject project, File mf) throws Exception, IOException, FileNotFoundException {
        Builder builder = new Builder();
        builder.setPedantic(activator.isPedantic() || activator.isDebugging());
        File p = project.getLocation().toFile();
        EclipseClasspath ecp = new EclipseClasspath(builder, p.getParentFile(), p);
        builder.setClasspath(ecp.getClasspath().toArray(new File[0]));
        builder.setSourcepath(ecp.getSourcepath().toArray(new File[0]));
        builder.setProperties(mf);
        return builder;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.locations = this.getLocations(selection);
    }

    IFile[] getLocations(ISelection selection) {
        if (selection != null && selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)selection;
            IFile[] result = new IFile[ss.size()];
            int n = 0;
            Iterator i = ss.iterator();
            while (i.hasNext()) {
                result[n++] = (IFile)i.next();
            }
            return result;
        }
        return null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

