/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.build.plugin.bnd;

import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.types.Path;

public class BuildTask
extends Task {
    Properties m_instructions = new Properties();
    File m_target;
    File m_outputDir;
    Path m_classpath;
    String m_filename;

    public void execute() {
        try {
            boolean hasChanged;
            String version;
            Properties properties = new Properties();
            if (this.m_outputDir == null) {
                File file = this.m_outputDir = this.m_target == null ? this.getProject().getBaseDir() : this.m_target.getParentFile().getAbsoluteFile();
            }
            if ((version = this.m_instructions.getProperty("Bundle-Version")) != null) {
                Pattern P_VERSION = Pattern.compile("([0-9]+(\\.[0-9])*)-(.*)");
                Matcher m = P_VERSION.matcher(version);
                if (m.matches()) {
                    version = m.group(1) + "." + m.group(3);
                }
                this.m_instructions.put("Bundle-Version", version);
                version = "-" + version;
            } else {
                version = "";
            }
            if (this.m_target == null) {
                this.m_target = this.m_filename != null ? new File(this.m_outputDir, this.m_filename + ".jar") : new File(this.m_outputDir, this.m_instructions.getProperty("Bundle-SymbolicName", this.m_instructions.getProperty("Bundle-Name").replace(" ", "").trim()) + version + ".jar");
            }
            properties.put("Import-Package", "*");
            if (!this.m_instructions.containsKey("Private-Package")) {
                properties.put("Export-Package", this.m_instructions.getProperty("Bundle-SymbolicName") + ".*");
            }
            properties.putAll((Map<?, ?>)this.m_instructions);
            if (this.m_classpath == null) {
                throw new BuildException("Classpath not set");
            }
            if (this.m_classpath.list().length == 0) {
                throw new BuildException("Classpath is empty");
            }
            ArrayList<Jar> classpath = new ArrayList<Jar>(this.m_classpath.list().length);
            String classpathString = null;
            for (String cpElement : this.m_classpath.list()) {
                File f = new File(cpElement);
                if (f.exists()) {
                    classpath.add(new Jar(f.getName(), f));
                    if (classpathString == null) {
                        classpathString = f.toString();
                        continue;
                    }
                    classpathString = classpathString + ":" + f;
                    continue;
                }
                this.log("classpath element '" + cpElement + "' does not exist; ignored.", 1);
            }
            this.log("Classpath: " + classpathString, 3);
            Builder builder = new Builder();
            builder.setBase(this.getProject().getBaseDir());
            builder.setProperties(properties);
            builder.setClasspath(classpath.toArray(new Jar[classpath.size()]));
            builder.build();
            Jar jar = builder.getJar();
            jar.setName(this.m_target.getName());
            List errors = builder.getErrors();
            List warnings = builder.getWarnings();
            if (errors.size() > 0) {
                this.m_target.delete();
                for (String msg : errors) {
                    this.getProject().log(msg);
                }
                throw new BuildException("Found errors, see log");
            }
            boolean exists = this.m_target.exists();
            boolean bl = hasChanged = this.m_target.lastModified() <= jar.lastModified();
            if (!exists || hasChanged) {
                jar.write(this.m_target);
                if (exists) {
                    this.getProject().log("modified " + jar.getName());
                } else {
                    this.getProject().log("created " + jar.getName());
                }
            }
            for (String msg : warnings) {
                this.getProject().log(msg);
            }
        }
        catch (BuildException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new BuildException("Unknown error occurred", (Throwable)e);
        }
    }

    public void setClasspathRefId(String value) {
        if (value == null) {
            throw new BuildException("ClasspathRefId value can not be null");
        }
        if (this.getProject().getReference(value) == null) {
            throw new BuildException("ClasspathRefId value [" + value + "] not found in project");
        }
        this.m_classpath = (Path)this.getProject().getReference(value);
    }

    public Path createClasspath() {
        if (this.m_classpath == null) {
            this.m_classpath = new Path(this.getProject());
        }
        return this.m_classpath.createPath();
    }

    public void setClasspath(Path classpath) {
        if (this.m_classpath == null) {
            this.m_classpath = classpath;
        } else {
            this.m_classpath.append(classpath);
        }
    }

    public void setTarget(File value) {
        this.m_target = value;
    }

    public void setOutputDir(File value) {
        this.m_outputDir = value;
    }

    public void setBundleClassPath(String value) {
        this.m_instructions.put("Bundle-ClassPath", value);
    }

    public void setBundleCopyright(String value) {
        this.m_instructions.put("Bundle-Copyright", value);
    }

    public void setBundleDescription(String value) {
        this.m_instructions.put("Bundle-Description", value);
    }

    public void setBundleName(String value) {
        this.m_instructions.put("Bundle-Name", value);
    }

    public void setBundleNativeCode(String value) {
        this.m_instructions.put("Bundle-NativeCode", value);
    }

    public void setExportPackage(String value) {
        this.m_instructions.put("Export-Package", value);
    }

    public void setExportService(String value) {
        this.m_instructions.put("Export-Service", value);
    }

    public void setImportPackage(String value) {
        this.m_instructions.put("Import-Package", value);
    }

    public void setDynamicImportPackage(String value) {
        this.m_instructions.put("DynamicImport-Package", value);
    }

    public void setImportService(String value) {
        this.m_instructions.put("Import-Service", value);
    }

    public void setBundleVendor(String value) {
        this.m_instructions.put("Bundle-Vendor", value);
    }

    public void setBundleVersion(String value) {
        this.m_instructions.put("Bundle-Version", value);
    }

    public void setBundleDocURL(String value) {
        this.m_instructions.put("Bundle-DocURL", value);
    }

    public void setBundleContactAddress(String value) {
        this.m_instructions.put("Bundle-ContactAddress", value);
    }

    public void setBundleActivator(String value) {
        this.m_instructions.put("Bundle-Activator", value);
    }

    public void setBundleRequiredExecutionEnvironment(String value) {
        this.m_instructions.put("Bundle-RequiredExecutionEnvironment", value);
    }

    public void setBundleSymbolicName(String value) {
        this.m_instructions.put("Bundle-SymbolicName", value);
    }

    public void setBundleLocalization(String value) {
        this.m_instructions.put("Bundle-Localization", value);
    }

    public void setRequireBundle(String value) {
        this.m_instructions.put("Require-Bundle", value);
    }

    public void setFragmentHost(String value) {
        this.m_instructions.put("Fragment-Host", value);
    }

    public void setBundleManifestVersion(String value) {
        this.log("attribute bundleManifestVersion is deprecated and ignored (bundle manifest version is always '2')");
    }

    public void setServiceComponent(String value) {
        this.m_instructions.put("Service-Component", value);
    }

    public void setBundleLicense(String value) {
        this.m_instructions.put("Bundle-License", value);
    }

    public void setPrivatePackage(String value) {
        this.m_instructions.put("Private-Package", value);
    }

    public void setIgnorePackage(String value) {
        this.m_instructions.put("Ignore-Package", value);
    }

    public void setIncludeResource(String value) {
        if (value == null) {
            throw new BuildException("Resource to include can not be null");
        }
        if (value.length() == 0) {
            this.log("empty string passed to the include resource, ignored as BND uses this to include the currect directory", 3);
            return;
        }
        this.m_instructions.put("Include-Resource", value);
    }

    public void setIncludeIncludeResourceHeader(boolean include) {
        if (!include) {
            this.m_instructions.put("-removeheaders", "Include-Resource");
        }
    }

    public void setAdditionalManifest(File value) {
        this.m_instructions.put("-include", value.getAbsolutePath());
    }

    public void addConfiguredManifest(Manifest newManifest) throws IOException {
        if (newManifest == null) {
            throw new BuildException("manifest can not be null");
        }
        File temp = File.createTempFile("bnd", ".tmp");
        temp.deleteOnExit();
        PrintWriter tempWriter = new PrintWriter(temp);
        Manifest.Section main = newManifest.getMainSection();
        Enumeration e = main.getAttributeKeys();
        while (e.hasMoreElements()) {
            Manifest.Attribute attr = main.getAttribute((String)e.nextElement());
            tempWriter.println(attr.getName() + "=" + attr.getValue());
        }
        tempWriter.close();
        this.setAdditionalManifest(temp);
    }

    public void setFilename(String filename) {
        this.m_filename = filename;
    }
}

