/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONAwareEx;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStreamAware;
import net.minidev.json.JSONStreamAwareEx;
import net.minidev.json.JSONStyle;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.FakeContainerFactory;
import net.minidev.json.parser.FlatContainerFactory;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.JSONParserStream;
import net.minidev.json.parser.ParseException;

public class JSONValue {
    public static JSONStyle COMPRESSION = JSONStyle.NO_COMPRESS;
    private static final FakeContainerFactory FakeFactory = new FakeContainerFactory();

    public static Object parse(Reader in) {
        try {
            return new JSONParserStream(-1).parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(String s) {
        try {
            return new JSONParser(-1).parse(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(Reader in) {
        try {
            return new JSONParserStream(-1).parse(in, ContainerFactory.FACTORYOrdered);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(String in) {
        try {
            return new JSONParser(-1).parse(in, ContainerFactory.FACTORYOrdered);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String compress(String s) throws ParseException {
        Object value = new JSONParser(-1).parse(s, new FlatContainerFactory());
        return JSONValue.toJSONString(value, JSONStyle.MAX_COMPRESS);
    }

    public static String uncompress(String s) throws ParseException {
        Object value = new JSONParser(-1).parse(s, new FlatContainerFactory());
        return JSONValue.toJSONString(value, JSONStyle.NO_COMPRESS);
    }

    public static Object parseWithException(Reader in) throws IOException, ParseException {
        return new JSONParserStream(-1).parse(in, ContainerFactory.FACTORY);
    }

    public static Object parseWithException(String s) throws ParseException {
        return new JSONParser(-1).parse(s, ContainerFactory.FACTORY);
    }

    public static Object parseStrict(Reader in) throws IOException, ParseException {
        return new JSONParserStream(0).parse(in, ContainerFactory.FACTORY);
    }

    public static Object parseStrict(String s) throws ParseException {
        return new JSONParser(0).parse(s, ContainerFactory.FACTORY);
    }

    public static boolean isValidJsonStrict(Reader in) throws IOException {
        try {
            new JSONParserStream(0).parse(in, FakeFactory);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJsonStrict(String s) {
        try {
            new JSONParser(0).parse(s, FakeFactory);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJson(Reader in) throws IOException {
        try {
            new JSONParserStream(-1).parse(in, FakeFactory);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJson(String s) {
        try {
            new JSONParser(-1).parse(s, FakeFactory);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static void writeJSONString(Object value, Appendable out) throws IOException {
        JSONValue.writeJSONString(value, out, COMPRESSION);
    }

    public static void writeJSONString(Object value, Appendable out, JSONStyle compression) throws IOException {
        if (value == null) {
            out.append("null");
            return;
        }
        if (value instanceof String) {
            if (!compression.mustProtectValue((String)value)) {
                out.append((String)value);
            } else {
                out.append('\"');
                JSONValue.escape((String)value, out, compression);
                out.append('\"');
            }
            return;
        }
        if (value instanceof Number) {
            if (value instanceof Double) {
                if (((Double)value).isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value.toString());
                }
            } else if (value instanceof Float) {
                if (((Float)value).isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value.toString());
                }
            } else {
                out.append(value.toString());
            }
            return;
        }
        if (value instanceof Boolean) {
            out.append(value.toString());
        } else if (value instanceof JSONStreamAware) {
            if (value instanceof JSONStreamAwareEx) {
                ((JSONStreamAwareEx)value).writeJSONString(out, compression);
            } else {
                ((JSONStreamAware)value).writeJSONString(out);
            }
        } else if (value instanceof JSONAware) {
            if (value instanceof JSONAwareEx) {
                out.append(((JSONAwareEx)value).toJSONString(compression));
            } else {
                out.append(((JSONAware)value).toJSONString());
            }
        } else if (value instanceof Map) {
            JSONObject.writeJSONString((Map)value, out, compression);
        } else if (value instanceof List) {
            JSONArray.writeJSONString((List)value, out, compression);
        } else {
            out.append('\"');
            out.append(JSONValue.escape(value.toString(), compression));
            out.append('\"');
        }
    }

    public static String toJSONString(Object value) {
        return JSONValue.toJSONString(value, COMPRESSION);
    }

    public static String toJSONString(Object value, JSONStyle compression) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONValue.writeJSONString(value, sb, compression);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String escape(String s) {
        return JSONValue.escape(s, COMPRESSION);
    }

    public static String escape(String s, JSONStyle compression) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        compression.escape(s, sb);
        return sb.toString();
    }

    public static void escape(String s, Appendable ap) {
        JSONValue.escape(s, ap, COMPRESSION);
    }

    public static void escape(String s, Appendable ap, JSONStyle compression) {
        if (s == null) {
            return;
        }
        compression.escape(s, ap);
    }
}

