/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.stax;

import com.fasterxml.aalto.IoStreamException;
import com.fasterxml.aalto.StreamExceptionBase;
import com.fasterxml.aalto.dom.DOMWriterImpl;
import com.fasterxml.aalto.out.AsciiXmlWriter;
import com.fasterxml.aalto.out.CharXmlWriter;
import com.fasterxml.aalto.out.Latin1XmlWriter;
import com.fasterxml.aalto.out.NonRepairingStreamWriter;
import com.fasterxml.aalto.out.RepairingStreamWriter;
import com.fasterxml.aalto.out.Utf8XmlWriter;
import com.fasterxml.aalto.out.WNameTable;
import com.fasterxml.aalto.out.WriterConfig;
import com.fasterxml.aalto.out.XmlWriter;
import com.fasterxml.aalto.util.CharsetNames;
import com.fasterxml.aalto.util.URLUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.io.Stax2Result;
import org.codehaus.stax2.ri.Stax2EventWriterImpl;
import org.codehaus.stax2.ri.Stax2WriterAdapter;

public final class OutputFactoryImpl
extends XMLOutputFactory2 {
    protected final WriterConfig _config = new WriterConfig();

    public XMLEventWriter createXMLEventWriter(OutputStream out) throws XMLStreamException {
        return this.createXMLEventWriter(out, null);
    }

    public XMLEventWriter createXMLEventWriter(OutputStream out, String enc) throws XMLStreamException {
        return new Stax2EventWriterImpl(this.createSW(out, null, enc, false));
    }

    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return new Stax2EventWriterImpl(this.createSW(result));
    }

    public XMLEventWriter createXMLEventWriter(Writer w) throws XMLStreamException {
        return new Stax2EventWriterImpl(this.createSW(null, w, null, false));
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream out) throws XMLStreamException {
        return this.createXMLStreamWriter(out, null);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream out, String enc) throws XMLStreamException {
        return this.createSW(out, null, enc, false);
    }

    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        return this.createSW(result);
    }

    public XMLStreamWriter createXMLStreamWriter(Writer w) throws XMLStreamException {
        return this.createSW(null, w, null, false);
    }

    public Object getProperty(String name) {
        return this._config.getProperty(name, false);
    }

    public boolean isPropertySupported(String name) {
        return this._config.isPropertySupported(name);
    }

    public void setProperty(String name, Object value) {
        this._config.setProperty(name, value);
    }

    public XMLEventWriter createXMLEventWriter(Writer w, String enc) throws XMLStreamException {
        return new Stax2EventWriterImpl(this.createSW(null, w, enc, false));
    }

    public XMLEventWriter createXMLEventWriter(XMLStreamWriter sw) throws XMLStreamException {
        XMLStreamWriter2 sw2 = Stax2WriterAdapter.wrapIfNecessary((XMLStreamWriter)sw);
        return new Stax2EventWriterImpl(sw2);
    }

    public XMLStreamWriter2 createXMLStreamWriter(Writer w, String enc) throws XMLStreamException {
        return this.createSW(null, w, enc, false);
    }

    public void configureForXmlConformance() {
        this._config.configureForXmlConformance();
    }

    public void configureForRobustness() {
        this._config.configureForRobustness();
    }

    public void configureForSpeed() {
        this._config.configureForSpeed();
    }

    private XMLStreamWriter2 createSW(OutputStream out, Writer w, String enc, boolean forceAutoClose) throws XMLStreamException {
        WNameTable symbols;
        XmlWriter xw;
        WriterConfig cfg = this._config.createNonShared();
        if (forceAutoClose) {
            cfg.doAutoCloseOutput(true);
        }
        if (w == null) {
            if (enc == null) {
                enc = "UTF-8";
            } else if (enc != "UTF-8" && enc != "ISO-8859-1" && enc != "US-ASCII") {
                enc = CharsetNames.normalize(enc);
            }
            cfg.setActualEncodingIfNotSet(enc);
            try {
                if (enc == "UTF-8") {
                    xw = new Utf8XmlWriter(cfg, out);
                    symbols = this._config.getUtf8Symbols(xw);
                }
                if (enc == "ISO-8859-1") {
                    xw = new Latin1XmlWriter(cfg, out);
                    symbols = this._config.getLatin1Symbols(xw);
                }
                if (enc == "US-ASCII") {
                    xw = new AsciiXmlWriter(cfg, out);
                    symbols = this._config.getAsciiSymbols(xw);
                }
                w = new OutputStreamWriter(out, enc);
                xw = new CharXmlWriter(cfg, w);
                symbols = this._config.getCharSymbols(xw);
            }
            catch (IOException ioe) {
                throw new XMLStreamException(ioe);
            }
        } else {
            if (enc == null) {
                enc = CharsetNames.findEncodingFor(w);
            }
            if (enc != null) {
                cfg.setActualEncodingIfNotSet(enc);
            }
            xw = new CharXmlWriter(cfg, w);
            symbols = this._config.getCharSymbols(xw);
        }
        if (cfg.willRepairNamespaces()) {
            return new RepairingStreamWriter(cfg, xw, symbols);
        }
        return new NonRepairingStreamWriter(cfg, xw, symbols);
    }

    private XMLStreamWriter2 createSW(Result res) throws XMLStreamException {
        boolean autoclose;
        Object sr;
        OutputStream out = null;
        Writer w = null;
        String encoding = null;
        String sysId = null;
        if (res instanceof Stax2Result) {
            sr = (Stax2Result)res;
            try {
                out = sr.constructOutputStream();
                if (out == null) {
                    w = sr.constructWriter();
                }
            }
            catch (IOException ioe) {
                throw new StreamExceptionBase(ioe);
            }
            autoclose = true;
        } else if (res instanceof StreamResult) {
            sr = (StreamResult)res;
            sysId = ((StreamResult)sr).getSystemId();
            out = ((StreamResult)sr).getOutputStream();
            if (out == null) {
                w = ((StreamResult)sr).getWriter();
            }
            autoclose = false;
        } else if (res instanceof SAXResult) {
            sr = (SAXResult)res;
            sysId = ((SAXResult)sr).getSystemId();
            if (sysId == null || sysId.length() == 0) {
                throw new StreamExceptionBase("Can not create a stream writer for a SAXResult that does not have System Id (support for using SAX input source not implemented)");
            }
            autoclose = true;
        } else {
            if (res instanceof DOMResult) {
                return DOMWriterImpl.createFrom(this._config.createNonShared(), (DOMResult)res);
            }
            throw new IllegalArgumentException("Can not create XMLStreamWriter for Result type " + res.getClass() + " (unrecognized type)");
        }
        if (out != null) {
            return this.createSW(out, null, encoding, autoclose);
        }
        if (w != null) {
            return this.createSW(null, w, encoding, autoclose);
        }
        if (sysId != null && sysId.length() > 0) {
            autoclose = true;
            try {
                out = URLUtil.outputStreamFromURL(URLUtil.urlFromSystemId(sysId));
            }
            catch (IOException ioe) {
                throw new IoStreamException(ioe);
            }
            return this.createSW(out, null, encoding, autoclose);
        }
        throw new StreamExceptionBase("Can not create XMLStreamWriter for passed-in Result -- neither writer, output stream nor system id (to create one) was accessible");
    }
}

