/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.platforms;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.TargetMatcher;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.LinkType;

public final class WindowsPlatform {
    private WindowsPlatform() {
    }

    public static void addVersionFiles(VersionInfo versionInfo, LinkType linkType, File outputFile, boolean isDebug, File objDir, TargetMatcher matcher) throws IOException {
        if (versionInfo == null) {
            throw new NullPointerException("versionInfo");
        }
        if (linkType == null) {
            throw new NullPointerException("linkType");
        }
        if (outputFile == null) {
            throw new NullPointerException("outputFile");
        }
        if (objDir == null) {
            throw new NullPointerException("objDir");
        }
        VersionInfo mergedInfo = versionInfo.merge();
        File versionResource = new File(objDir, "versioninfo.rc");
        boolean notChanged = false;
        if (versionResource.exists()) {
            ByteArrayOutputStream memStream = new ByteArrayOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(memStream));
            WindowsPlatform.writeResource(writer, mergedInfo, outputFile, isDebug, linkType);
            ((Writer)writer).close();
            ByteArrayInputStream proposedResource = new ByteArrayInputStream(memStream.toByteArray());
            FileInputStream existingResource = new FileInputStream(versionResource);
            notChanged = WindowsPlatform.hasSameContent(proposedResource, existingResource);
            ((InputStream)existingResource).close();
        }
        if (!notChanged) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(versionResource)));
            WindowsPlatform.writeResource(writer, mergedInfo, outputFile, isDebug, linkType);
            ((Writer)writer).close();
        }
        if (matcher != null) {
            matcher.visit(new File(versionResource.getParent()), versionResource.getName());
        }
    }

    private static boolean hasSameContent(InputStream stream1, InputStream stream2) throws IOException {
        int byte1 = -1;
        int byte2 = -1;
        while ((byte1 = stream1.read()) == (byte2 = stream2.read()) && byte1 != -1) {
        }
        return byte1 == byte2;
    }

    public static short[] parseVersion(String version) {
        short[] values = new short[4];
        if (version != null) {
            StringBuffer buf = new StringBuffer(version);
            int start = 0;
            int i = 0;
            block4: while (i < 4) {
                int end = version.indexOf(46, start);
                if (end <= 0) {
                    int j = end = version.length();
                    while (j > start) {
                        String part = buf.substring(start, end);
                        try {
                            values[i] = Short.parseShort(part);
                            break block4;
                        }
                        catch (NumberFormatException ex) {
                            values[i] = 0;
                            --j;
                        }
                    }
                    break;
                }
                String part = buf.substring(start, end);
                try {
                    values[i] = Short.parseShort(part);
                    start = end + 1;
                }
                catch (NumberFormatException ex) {
                    break;
                }
                ++i;
            }
        }
        return values;
    }

    private static void encodeVersion(StringBuffer buf, short[] version) {
        int i = 0;
        while (i < 3) {
            buf.append(Short.toString(version[i]));
            buf.append(',');
            ++i;
        }
        buf.append(Short.toString(version[3]));
    }

    public static void writeResource(Writer writer, VersionInfo versionInfo, File outputFile, boolean isDebug, LinkType linkType) throws IOException {
        writer.write("VS_VERSION_INFO VERSIONINFO\n");
        StringBuffer buf = new StringBuffer("FILEVERSION ");
        WindowsPlatform.encodeVersion(buf, WindowsPlatform.parseVersion(versionInfo.getFileversion()));
        buf.append("\nPRODUCTVERSION ");
        WindowsPlatform.encodeVersion(buf, WindowsPlatform.parseVersion(versionInfo.getProductversion()));
        buf.append("\n");
        writer.write(buf.toString());
        buf.setLength(0);
        buf.append("FILEFLAGSMASK 0x1L /* VS_FF_DEBUG */");
        Boolean patched = versionInfo.getPatched();
        Boolean prerelease = versionInfo.getPrerelease();
        if (patched != null) {
            buf.append(" | 0x4L /* VS_FF_PATCHED */");
        }
        if (prerelease != null) {
            buf.append(" | 0x2L /* VS_FF_PRERELEASE */");
        }
        if (versionInfo.getPrivatebuild() != null) {
            buf.append(" | 0x8L /* VS_FF_PRIVATEBUILD */");
        }
        if (versionInfo.getSpecialbuild() != null) {
            buf.append(" | 0x20L /* VS_FF_SPECIALBUILD */");
        }
        buf.append('\n');
        writer.write(buf.toString());
        buf.setLength(0);
        buf.append("FILEFLAGS ");
        if (isDebug) {
            buf.append("0x1L /* VS_FF_DEBUG */ | ");
        }
        if (Boolean.TRUE.equals(patched)) {
            buf.append("0x4L /* VS_FF_PATCHED */ | ");
        }
        if (Boolean.TRUE.equals(prerelease)) {
            buf.append("0x2L /* VS_FF_PRERELEASE */ | ");
        }
        if (Boolean.TRUE.equals(versionInfo.getPrivatebuild())) {
            buf.append("0x8L /* VS_FF_PRIVATEBUILD */ | ");
        }
        if (Boolean.TRUE.equals(versionInfo.getSpecialbuild())) {
            buf.append("0x20L /* VS_FF_SPECIALBUILD */ | ");
        }
        if (buf.length() > 10) {
            buf.setLength(buf.length() - 3);
            buf.append('\n');
        } else {
            buf.append("0\n");
        }
        writer.write(buf.toString());
        buf.setLength(0);
        writer.write("FILEOS 0x40004 /* VOS_NT_WINDOWS32 */\nFILETYPE ");
        if (linkType.isExecutable()) {
            writer.write("0x1L /* VFT_APP */\n");
        } else if (linkType.isSharedLibrary()) {
            writer.write("0x2L /* VFT_DLL */\n");
        } else if (linkType.isStaticLibrary()) {
            writer.write("0x7L /* VFT_STATIC_LIB */\n");
        } else {
            writer.write("0x0L /* VFT_UNKNOWN */\n");
        }
        writer.write("FILESUBTYPE 0x0L\n");
        writer.write("BEGIN\n");
        writer.write("BLOCK \"StringFileInfo\"\n");
        writer.write("   BEGIN\n#ifdef UNICODE\nBLOCK \"040904B0\"\n");
        writer.write("#else\nBLOCK \"040904E4\"\n#endif\n");
        writer.write("BEGIN\n");
        if (versionInfo.getFilecomments() != null) {
            writer.write("VALUE \"Comments\", \"");
            writer.write(versionInfo.getFilecomments());
            writer.write("\\0\"\n");
        }
        if (versionInfo.getCompanyname() != null) {
            writer.write("VALUE \"CompanyName\", \"");
            writer.write(versionInfo.getCompanyname());
            writer.write("\\0\"\n");
        }
        if (versionInfo.getFiledescription() != null) {
            writer.write("VALUE \"FileDescription\", \"");
            writer.write(versionInfo.getFiledescription());
            writer.write("\\0\"\n");
        }
        if (versionInfo.getFileversion() != null) {
            writer.write("VALUE \"FileVersion\", \"");
            writer.write(versionInfo.getFileversion());
            writer.write("\\0\"\n");
        }
        String baseName = CUtil.getBasename(outputFile);
        String internalName = versionInfo.getInternalname();
        if (internalName == null) {
            internalName = baseName;
        }
        writer.write("VALUE \"InternalName\", \"");
        writer.write(internalName);
        writer.write("\\0\"\n");
        if (versionInfo.getLegalcopyright() != null) {
            writer.write("VALUE \"LegalCopyright\", \"");
            writer.write(versionInfo.getLegalcopyright());
            writer.write("\\0\"\n");
        }
        if (versionInfo.getLegaltrademarks() != null) {
            writer.write("VALUE \"LegalTrademarks\", \"");
            writer.write(versionInfo.getLegaltrademarks());
            writer.write("\\0\"\n");
        }
        writer.write("VALUE \"OriginalFilename\", \"");
        writer.write(baseName);
        writer.write("\\0\"\n");
        if (versionInfo.getPrivatebuild() != null) {
            writer.write("VALUE \"PrivateBuild\", \"");
            writer.write(versionInfo.getPrivatebuild());
            writer.write("\\0\"\n");
        }
        if (versionInfo.getProductname() != null) {
            writer.write("VALUE \"ProductName\", \"");
            writer.write(versionInfo.getProductname());
            writer.write("\\0\"\n");
        }
        if (versionInfo.getProductversion() != null) {
            writer.write("VALUE \"ProductVersion\", \"");
            writer.write(versionInfo.getProductversion());
            writer.write("\\0\"\n");
        }
        if (versionInfo.getSpecialbuild() != null) {
            writer.write("VALUE \"SpecialBuild\", \"");
            writer.write(versionInfo.getSpecialbuild());
            writer.write("\\0\"\n");
        }
        writer.write("END\n");
        writer.write("END\n");
        writer.write("BLOCK \"VarFileInfo\"\n");
        writer.write("BEGIN\n#ifdef UNICODE\n");
        writer.write("VALUE \"Translation\", 0x409, 1200\n");
        writer.write("#else\n");
        writer.write("VALUE \"Translation\", 0x409, 1252\n");
        writer.write("#endif\n");
        writer.write("END\n");
        writer.write("END\n");
    }
}

