/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.SerializerFactory;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.transformer.SerializerSwitcher;
import org.apache.xml.utils.DOM2Helper;
import org.apache.xml.utils.DOMBuilder;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.TreeWalker;
import org.apache.xml.utils.WrappedRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransformerIdentityImpl
extends Transformer
implements TransformerHandler,
DeclHandler {
    boolean m_flushedStartDoc = false;
    private FileOutputStream m_outputStream = null;
    private ContentHandler m_resultContentHandler;
    private LexicalHandler m_resultLexicalHandler;
    private DTDHandler m_resultDTDHandler;
    private DeclHandler m_resultDeclHandler;
    private Serializer m_serializer;
    private Result m_result;
    private String m_systemID;
    private Hashtable m_params;
    private ErrorListener m_errorListener = new DefaultErrorHandler();
    URIResolver m_URIResolver;
    private OutputProperties m_outputFormat = new OutputProperties("xml");
    boolean m_foundFirstElement;

    public void setResult(Result result) throws IllegalArgumentException {
        if (null == result) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_RESULT_NULL", null));
        }
        this.m_result = result;
    }

    public void setSystemId(String systemID) {
        this.m_systemID = systemID;
    }

    public String getSystemId() {
        return this.m_systemID;
    }

    public Transformer getTransformer() {
        return this;
    }

    private void createResultContentHandler(Result outputTarget) throws TransformerException {
        if (outputTarget instanceof SAXResult) {
            SAXResult saxResult = (SAXResult)outputTarget;
            this.m_resultContentHandler = saxResult.getHandler();
            this.m_resultLexicalHandler = saxResult.getLexicalHandler();
            if (this.m_resultContentHandler instanceof Serializer) {
                this.m_serializer = (Serializer)((Object)this.m_resultContentHandler);
            }
        } else if (outputTarget instanceof DOMResult) {
            Document doc;
            short type;
            DOMResult domResult = (DOMResult)outputTarget;
            Node outputNode = domResult.getNode();
            if (null != outputNode) {
                type = outputNode.getNodeType();
                doc = 9 == type ? (Document)outputNode : outputNode.getOwnerDocument();
            } else {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    doc = db.newDocument();
                }
                catch (ParserConfigurationException pce) {
                    throw new TransformerException(pce);
                }
                outputNode = doc;
                type = outputNode.getNodeType();
                ((DOMResult)outputTarget).setNode(outputNode);
            }
            this.m_resultContentHandler = 11 == type ? new DOMBuilder(doc, (DocumentFragment)outputNode) : new DOMBuilder(doc, outputNode);
            this.m_resultLexicalHandler = (LexicalHandler)((Object)this.m_resultContentHandler);
        } else if (outputTarget instanceof StreamResult) {
            StreamResult sresult = (StreamResult)outputTarget;
            String method = this.m_outputFormat.getProperty("method");
            try {
                Serializer serializer;
                this.m_serializer = serializer = SerializerFactory.getSerializer(this.m_outputFormat.getProperties());
                if (null != sresult.getWriter()) {
                    serializer.setWriter(sresult.getWriter());
                } else if (null != sresult.getOutputStream()) {
                    serializer.setOutputStream(sresult.getOutputStream());
                } else if (null != sresult.getSystemId()) {
                    String fileURL = sresult.getSystemId();
                    if (fileURL.startsWith("file:///")) {
                        fileURL = fileURL.substring(8).indexOf(":") > 0 ? fileURL.substring(8) : fileURL.substring(7);
                    }
                    this.m_outputStream = new FileOutputStream(fileURL);
                    serializer.setOutputStream(this.m_outputStream);
                } else {
                    throw new TransformerException(XSLMessages.createMessage("ER_NO_OUTPUT_SPECIFIED", null));
                }
                this.m_resultContentHandler = serializer.asContentHandler();
            }
            catch (IOException ioe) {
                throw new TransformerException(ioe);
            }
        } else {
            throw new TransformerException(XSLMessages.createMessage("ER_CANNOT_TRANSFORM_TO_RESULT_TYPE", new Object[]{outputTarget.getClass().getName()}));
        }
        if (this.m_resultContentHandler instanceof DTDHandler) {
            this.m_resultDTDHandler = (DTDHandler)((Object)this.m_resultContentHandler);
        }
        if (this.m_resultContentHandler instanceof DeclHandler) {
            this.m_resultDeclHandler = (DeclHandler)((Object)this.m_resultContentHandler);
        }
        if (this.m_resultContentHandler instanceof LexicalHandler) {
            this.m_resultLexicalHandler = (LexicalHandler)((Object)this.m_resultContentHandler);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transform(Source source, Result outputTarget) throws TransformerException {
        block47: {
            block44: {
                block46: {
                    block43: {
                        this.createResultContentHandler(outputTarget);
                        try {
                            if (source instanceof DOMSource) {
                                block42: {
                                    dsource = (DOMSource)source;
                                    this.m_systemID = dsource.getSystemId();
                                    dNode = dsource.getNode();
                                    if (null == dNode) {
                                        messageStr = XSLMessages.createMessage("ER_ILLEGAL_DOMSOURCE_INPUT", null);
                                        throw new IllegalArgumentException(messageStr);
                                    }
                                    try {
                                        if (dNode.getNodeType() != 9) {
                                            this.startDocument();
                                        }
                                        try {
                                            if (dNode.getNodeType() == 2) {
                                                data = dNode.getNodeValue();
                                                chars = data.toCharArray();
                                                this.characters(chars, 0, chars.length);
                                            } else {
                                                walker = new TreeWalker(this, new DOM2Helper(), this.m_systemID);
                                                walker.traverse(dNode);
                                            }
                                            var8_23 = null;
                                            if (dNode.getNodeType() == 9) break block42;
                                        }
                                        catch (Throwable var7_26) {
                                            var8_24 = null;
                                            if (dNode.getNodeType() == 9) throw var7_26;
                                            this.endDocument();
                                            throw var7_26;
                                        }
                                        this.endDocument();
                                    }
                                    catch (SAXException se) {
                                        throw new TransformerException(se);
                                    }
                                }
                                var10_28 = null;
                                if (null == this.m_outputStream) return;
                                break block43;
                            }
                            xmlSource = SAXSource.sourceToInputSource(source);
                            if (null == xmlSource) {
                                throw new TransformerException(XSLMessages.createMessage("ER_CANNOT_TRANSFORM_SOURCE_TYPE", new Object[]{source.getClass().getName()}));
                            }
                            if (null != xmlSource.getSystemId()) {
                                this.m_systemID = xmlSource.getSystemId();
                            }
                            try {
                                reader = null;
                                if (source instanceof SAXSource) {
                                    reader = ((SAXSource)source).getXMLReader();
                                }
                                if (null == reader) {
                                    try {
                                        factory = SAXParserFactory.newInstance();
                                        factory.setNamespaceAware(true);
                                        jaxpParser = factory.newSAXParser();
                                        reader = jaxpParser.getXMLReader();
                                    }
                                    catch (ParserConfigurationException ex) {
                                        throw new SAXException(ex);
                                    }
                                    catch (FactoryConfigurationError ex1) {
                                        throw new SAXException(ex1.toString());
                                    }
                                    catch (NoSuchMethodError ex2) {
                                    }
                                    catch (AbstractMethodError ame) {
                                        // empty catch block
                                    }
                                }
                                if (null == reader) {
                                    reader = XMLReaderFactory.createXMLReader();
                                }
                                try {
                                    reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                                }
                                catch (SAXException se) {
                                    // empty catch block
                                }
                                inputHandler = this;
                                reader.setContentHandler(inputHandler);
                                if (inputHandler instanceof DTDHandler) {
                                    reader.setDTDHandler(inputHandler);
                                }
                                try {
                                    if (inputHandler instanceof LexicalHandler) {
                                        reader.setProperty("http://xml.org/sax/properties/lexical-handler", inputHandler);
                                    }
                                    if (inputHandler instanceof DeclHandler) {
                                        reader.setProperty("http://xml.org/sax/properties/declaration-handler", inputHandler);
                                    }
                                }
                                catch (SAXException se) {
                                    // empty catch block
                                }
                                try {
                                    if (inputHandler instanceof LexicalHandler) {
                                        reader.setProperty("http://xml.org/sax/handlers/LexicalHandler", inputHandler);
                                    }
                                    if (inputHandler instanceof DeclHandler) {
                                        reader.setProperty("http://xml.org/sax/handlers/DeclHandler", inputHandler);
                                    }
                                }
                                catch (SAXNotRecognizedException snre) {
                                    // empty catch block
                                }
                                reader.parse(xmlSource);
                                break block44;
                            }
                            catch (WrappedRuntimeException wre) {
                                throwable = wre.getException();
                            }
                            while (true) {
                                if (!(throwable instanceof WrappedRuntimeException)) {
                                    throw new TransformerException(wre.getException());
                                }
                                throwable = ((WrappedRuntimeException)throwable).getException();
                            }
                            catch (SAXException se) {
                                throw new TransformerException(se);
                            }
                            catch (IOException ioe) {
                                throw new TransformerException(ioe);
                            }
                        }
                        catch (Throwable var9_34) {
                            var10_30 = null;
                            if (null == this.m_outputStream) throw var9_34;
                            try {
                                this.m_outputStream.close();
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                            this.m_outputStream = null;
                            throw var9_34;
                        }
                    }
                    ** try [egrp 8[TRYBLOCK] [13 : 578->588)] { 
lbl117:
                    // 1 sources

                    this.m_outputStream.close();
                    break block46;
lbl119:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                this.m_outputStream = null;
                return;
            }
            var10_29 = null;
            if (null == this.m_outputStream) return;
            ** try [egrp 8[TRYBLOCK] [13 : 578->588)] { 
lbl128:
            // 1 sources

            this.m_outputStream.close();
            break block47;
lbl130:
            // 1 sources

            catch (IOException ioe) {
                // empty catch block
            }
        }
        this.m_outputStream = null;
    }

    public void setParameter(String name, Object value) {
        if (null == this.m_params) {
            this.m_params = new Hashtable();
        }
        this.m_params.put(name, value);
    }

    public Object getParameter(String name) {
        if (null == this.m_params) {
            return null;
        }
        return this.m_params.get(name);
    }

    public void clearParameters() {
        if (null == this.m_params) {
            return;
        }
        this.m_params.clear();
    }

    public void setURIResolver(URIResolver resolver) {
        this.m_URIResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.m_URIResolver;
    }

    public void setOutputProperties(Properties oformat) throws IllegalArgumentException {
        if (null != oformat) {
            String method = (String)((Hashtable)oformat).get("method");
            this.m_outputFormat = null != method ? new OutputProperties(method) : new OutputProperties();
        }
        if (null != oformat) {
            this.m_outputFormat.copyFrom(oformat);
        }
    }

    public Properties getOutputProperties() {
        return (Properties)((Hashtable)this.m_outputFormat.getProperties()).clone();
    }

    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        if (!this.m_outputFormat.isLegalPropertyKey(name)) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_OUTPUT_PROPERTY_NOT_RECOGNIZED", new Object[]{name}));
        }
        this.m_outputFormat.setProperty(name, value);
    }

    public String getOutputProperty(String name) throws IllegalArgumentException {
        String value = null;
        OutputProperties props = this.m_outputFormat;
        value = props.getProperty(name);
        if (null == value && !props.isLegalPropertyKey(name)) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_OUTPUT_PROPERTY_NOT_RECOGNIZED", new Object[]{name}));
        }
        return value;
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_NULL_ERROR_HANDLER", null));
        }
        this.m_errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (null != this.m_resultDTDHandler) {
            this.m_resultDTDHandler.notationDecl(name, publicId, systemId);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (null != this.m_resultDTDHandler) {
            this.m_resultDTDHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    public void setDocumentLocator(Locator locator) {
        try {
            if (null == this.m_resultContentHandler) {
                this.createResultContentHandler(this.m_result);
            }
        }
        catch (TransformerException te) {
            throw new WrappedRuntimeException(te);
        }
        this.m_resultContentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        try {
            if (null == this.m_resultContentHandler) {
                this.createResultContentHandler(this.m_result);
            }
        }
        catch (TransformerException te) {
            throw new SAXException(te.getMessage(), te);
        }
        this.m_flushedStartDoc = false;
        this.m_foundFirstElement = false;
    }

    protected final void flushStartDoc() throws SAXException {
        if (!this.m_flushedStartDoc) {
            this.m_resultContentHandler.startDocument();
            this.m_flushedStartDoc = true;
        }
    }

    public void endDocument() throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.m_foundFirstElement && null != this.m_serializer) {
            Serializer newSerializer;
            this.m_foundFirstElement = true;
            try {
                newSerializer = SerializerSwitcher.switchSerializerIfHTML(uri, localName, this.m_outputFormat.getProperties(), this.m_serializer);
            }
            catch (TransformerException te) {
                throw new SAXException(te);
            }
            if (newSerializer != this.m_serializer) {
                try {
                    this.m_resultContentHandler = newSerializer.asContentHandler();
                }
                catch (IOException ioe) {
                    throw new SAXException(ioe);
                }
                if (this.m_resultContentHandler instanceof DTDHandler) {
                    this.m_resultDTDHandler = (DTDHandler)((Object)this.m_resultContentHandler);
                }
                if (this.m_resultContentHandler instanceof LexicalHandler) {
                    this.m_resultLexicalHandler = (LexicalHandler)((Object)this.m_resultContentHandler);
                }
                this.m_serializer = newSerializer;
            }
        }
        this.flushStartDoc();
        this.m_resultContentHandler.startElement(uri, localName, qName, attributes);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.m_resultContentHandler.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.m_resultContentHandler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.skippedEntity(name);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.flushStartDoc();
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    public void endDTD() throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.endDTD();
        }
    }

    public void startEntity(String name) throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.flushStartDoc();
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.comment(ch, start, length);
        }
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (null != this.m_resultDeclHandler) {
            this.m_resultDeclHandler.elementDecl(name, model);
        }
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        if (null != this.m_resultDeclHandler) {
            this.m_resultDeclHandler.attributeDecl(eName, aName, type, valueDefault, value);
        }
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (null != this.m_resultDeclHandler) {
            this.m_resultDeclHandler.internalEntityDecl(name, value);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (null != this.m_resultDeclHandler) {
            this.m_resultDeclHandler.externalEntityDecl(name, publicId, systemId);
        }
    }
}

