#!/bin/bash
# shellcheck disable=SC2153

if [ -n "$DISTLOCALVERSION" ]; then
	SPECBUILDID=$(printf "%%define buildid %s" "$DISTLOCALVERSION")
else
	SPECBUILDID="# define buildid .local"
fi

# The SPECRELEASE variable uses the SPECBUILDID variable which is
# defined above.  IOW, don't remove SPECBUILDID ;)
SPECRELEASE="${UPSTREAMBUILD}""${BUILD}""%{?buildid}%{?dist}"

# self-test begin
test -f "$SOURCES/kernel-headers.spec" &&
	sed -i -e "
	s/%%SPECBUILDID%%/$SPECBUILDID/
	s/%%SPECKVERSION%%/$SPECKVERSION/
	s/%%SPECKPATCHLEVEL%%/$SPECKPATCHLEVEL/
	s/%%SPECBUILD%%/$SPECBUILD/
	s/%%SPECRELEASE%%/$SPECRELEASE/
	s/%%SPECRELEASED_KERNEL%%/$SPECRELEASED_KERNEL/
	s/%%SPECINCLUDE_FEDORA_FILES%%/$SPECINCLUDE_FEDORA_FILES/
	s/%%SPECINCLUDE_RHEL_FILES%%/$SPECINCLUDE_RHEL_FILES/
	s/%%SPECPATCHLIST_CHANGELOG%%/$SPECPATCHLIST_CHANGELOG/
	s/%%SPECINCLUDE_RT_FILES%%/$SPECINCLUDE_RT_FILES/
	s/%%SPECINCLUDE_AUTOMOTIVE_FILES%%/$SPECINCLUDE_AUTOMOTIVE_FILES/
	s/%%SPECVERSION%%/$SPECVERSION/
	s/%%SPECRPMVERSION%%/$SPECRPMVERSION/
	s/%%SPECKABIVERSION%%/$SPECKABIVERSION/
	s/%%SPECTARFILE_RELEASE%%/$SPECTARFILE_RELEASE/
	s/%%SPECPACKAGE_NAME%%/$SPECPACKAGE_NAME/
	s/%%SPECGEMINI%%/$SPECGEMINI/
	s/%%SPECSELFTESTS_MUST_BUILD%%/$SPECSELFTESTS_MUST_BUILD/" "$SOURCES/kernel-headers.spec"
# self-test end
