/*
Copyright 2015 The Kubernetes Authors All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v1beta1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg4_resource "k8s.io/kubernetes/pkg/api/resource"
	pkg1_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg2_v1 "k8s.io/kubernetes/pkg/api/v1"
	pkg3_types "k8s.io/kubernetes/pkg/types"
	pkg6_intstr "k8s.io/kubernetes/pkg/util/intstr"
	"reflect"
	"runtime"
	pkg5_inf "speter.net/go/exp/math/dec/inf"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg4_resource.Quantity
		var v1 pkg1_unversioned.TypeMeta
		var v2 pkg2_v1.ObjectMeta
		var v3 pkg3_types.UID
		var v4 pkg6_intstr.IntOrString
		var v5 pkg5_inf.Dec
		var v6 time.Time
		_, _, _, _, _, _, _ = v0, v1, v2, v3, v4, v5, v6
	}
}

func (x *ScaleSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Replicas != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym6 := z.DecBinary()
	_ = yym6
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct7 := r.ContainerType()
		if yyct7 == codecSelferValueTypeMap1234 {
			yyl7 := r.ReadMapStart()
			if yyl7 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl7, d)
			}
		} else if yyct7 == codecSelferValueTypeArray1234 {
			yyl7 := r.ReadArrayStart()
			if yyl7 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl7, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys8Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys8Slc
	var yyhl8 bool = l >= 0
	for yyj8 := 0; ; yyj8++ {
		if yyhl8 {
			if yyj8 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys8Slc = r.DecodeBytes(yys8Slc, true, true)
		yys8 := string(yys8Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys8 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys8)
		} // end switch yys8
	} // end for yyj8
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ScaleStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym12 := z.EncBinary()
		_ = yym12
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep13 := !z.EncBinary()
			yy2arr13 := z.EncBasicHandle().StructToArray
			var yyq13 [2]bool
			_, _, _ = yysep13, yyq13, yy2arr13
			const yyr13 bool = false
			yyq13[1] = len(x.Selector) != 0
			var yynn13 int
			if yyr13 || yy2arr13 {
				r.EncodeArrayStart(2)
			} else {
				yynn13 = 1
				for _, b := range yyq13 {
					if b {
						yynn13++
					}
				}
				r.EncodeMapStart(yynn13)
				yynn13 = 0
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym15 := z.EncBinary()
				_ = yym15
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq13[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym18 := z.EncBinary()
						_ = yym18
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq13[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				}
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym20 := z.DecBinary()
	_ = yym20
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct21 := r.ContainerType()
		if yyct21 == codecSelferValueTypeMap1234 {
			yyl21 := r.ReadMapStart()
			if yyl21 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl21, d)
			}
		} else if yyct21 == codecSelferValueTypeArray1234 {
			yyl21 := r.ReadArrayStart()
			if yyl21 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl21, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys22Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys22Slc
	var yyhl22 bool = l >= 0
	for yyj22 := 0; ; yyj22++ {
		if yyhl22 {
			if yyj22 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys22Slc = r.DecodeBytes(yys22Slc, true, true)
		yys22 := string(yys22Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys22 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv24 := &x.Selector
				yym25 := z.DecBinary()
				_ = yym25
				if false {
				} else {
					z.F.DecMapStringStringX(yyv24, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys22)
		} // end switch yys22
	} // end for yyj22
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj26 int
	var yyb26 bool
	var yyhl26 bool = l >= 0
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv28 := &x.Selector
		yym29 := z.DecBinary()
		_ = yym29
		if false {
		} else {
			z.F.DecMapStringStringX(yyv28, false, d)
		}
	}
	for {
		yyj26++
		if yyhl26 {
			yyb26 = yyj26 > l
		} else {
			yyb26 = r.CheckBreak()
		}
		if yyb26 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj26-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Scale) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym30 := z.EncBinary()
		_ = yym30
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep31 := !z.EncBinary()
			yy2arr31 := z.EncBasicHandle().StructToArray
			var yyq31 [5]bool
			_, _, _ = yysep31, yyq31, yy2arr31
			const yyr31 bool = false
			yyq31[0] = x.Kind != ""
			yyq31[1] = x.APIVersion != ""
			yyq31[2] = true
			yyq31[3] = true
			yyq31[4] = true
			var yynn31 int
			if yyr31 || yy2arr31 {
				r.EncodeArrayStart(5)
			} else {
				yynn31 = 0
				for _, b := range yyq31 {
					if b {
						yynn31++
					}
				}
				r.EncodeMapStart(yynn31)
				yynn31 = 0
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[0] {
					yym33 := z.EncBinary()
					_ = yym33
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq31[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym34 := z.EncBinary()
					_ = yym34
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[1] {
					yym36 := z.EncBinary()
					_ = yym36
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq31[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym37 := z.EncBinary()
					_ = yym37
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[2] {
					yy39 := &x.ObjectMeta
					yy39.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq31[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy40 := &x.ObjectMeta
					yy40.CodecEncodeSelf(e)
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[3] {
					yy42 := &x.Spec
					yy42.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq31[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy43 := &x.Spec
					yy43.CodecEncodeSelf(e)
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[4] {
					yy45 := &x.Status
					yy45.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq31[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy46 := &x.Status
					yy46.CodecEncodeSelf(e)
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Scale) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym47 := z.DecBinary()
	_ = yym47
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct48 := r.ContainerType()
		if yyct48 == codecSelferValueTypeMap1234 {
			yyl48 := r.ReadMapStart()
			if yyl48 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl48, d)
			}
		} else if yyct48 == codecSelferValueTypeArray1234 {
			yyl48 := r.ReadArrayStart()
			if yyl48 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl48, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Scale) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys49Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys49Slc
	var yyhl49 bool = l >= 0
	for yyj49 := 0; ; yyj49++ {
		if yyhl49 {
			if yyj49 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys49Slc = r.DecodeBytes(yys49Slc, true, true)
		yys49 := string(yys49Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys49 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv52 := &x.ObjectMeta
				yyv52.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ScaleSpec{}
			} else {
				yyv53 := &x.Spec
				yyv53.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ScaleStatus{}
			} else {
				yyv54 := &x.Status
				yyv54.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys49)
		} // end switch yys49
	} // end for yyj49
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Scale) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj55 int
	var yyb55 bool
	var yyhl55 bool = l >= 0
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv58 := &x.ObjectMeta
		yyv58.CodecDecodeSelf(d)
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ScaleSpec{}
	} else {
		yyv59 := &x.Spec
		yyv59.CodecDecodeSelf(d)
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ScaleStatus{}
	} else {
		yyv60 := &x.Status
		yyv60.CodecDecodeSelf(d)
	}
	for {
		yyj55++
		if yyhl55 {
			yyb55 = yyj55 > l
		} else {
			yyb55 = r.CheckBreak()
		}
		if yyb55 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj55-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerDummy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym61 := z.EncBinary()
		_ = yym61
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep62 := !z.EncBinary()
			yy2arr62 := z.EncBasicHandle().StructToArray
			var yyq62 [2]bool
			_, _, _ = yysep62, yyq62, yy2arr62
			const yyr62 bool = false
			yyq62[0] = x.Kind != ""
			yyq62[1] = x.APIVersion != ""
			var yynn62 int
			if yyr62 || yy2arr62 {
				r.EncodeArrayStart(2)
			} else {
				yynn62 = 0
				for _, b := range yyq62 {
					if b {
						yynn62++
					}
				}
				r.EncodeMapStart(yynn62)
				yynn62 = 0
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq62[0] {
					yym64 := z.EncBinary()
					_ = yym64
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq62[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym65 := z.EncBinary()
					_ = yym65
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq62[1] {
					yym67 := z.EncBinary()
					_ = yym67
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq62[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym68 := z.EncBinary()
					_ = yym68
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerDummy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym69 := z.DecBinary()
	_ = yym69
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct70 := r.ContainerType()
		if yyct70 == codecSelferValueTypeMap1234 {
			yyl70 := r.ReadMapStart()
			if yyl70 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl70, d)
			}
		} else if yyct70 == codecSelferValueTypeArray1234 {
			yyl70 := r.ReadArrayStart()
			if yyl70 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl70, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerDummy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys71Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys71Slc
	var yyhl71 bool = l >= 0
	for yyj71 := 0; ; yyj71++ {
		if yyhl71 {
			if yyj71 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys71Slc = r.DecodeBytes(yys71Slc, true, true)
		yys71 := string(yys71Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys71 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys71)
		} // end switch yys71
	} // end for yyj71
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerDummy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj74 int
	var yyb74 bool
	var yyhl74 bool = l >= 0
	yyj74++
	if yyhl74 {
		yyb74 = yyj74 > l
	} else {
		yyb74 = r.CheckBreak()
	}
	if yyb74 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj74++
	if yyhl74 {
		yyb74 = yyj74 > l
	} else {
		yyb74 = r.CheckBreak()
	}
	if yyb74 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	for {
		yyj74++
		if yyhl74 {
			yyb74 = yyj74 > l
		} else {
			yyb74 = r.CheckBreak()
		}
		if yyb74 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj74-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SubresourceReference) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym77 := z.EncBinary()
		_ = yym77
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep78 := !z.EncBinary()
			yy2arr78 := z.EncBasicHandle().StructToArray
			var yyq78 [4]bool
			_, _, _ = yysep78, yyq78, yy2arr78
			const yyr78 bool = false
			yyq78[0] = x.Kind != ""
			yyq78[1] = x.Name != ""
			yyq78[2] = x.APIVersion != ""
			yyq78[3] = x.Subresource != ""
			var yynn78 int
			if yyr78 || yy2arr78 {
				r.EncodeArrayStart(4)
			} else {
				yynn78 = 0
				for _, b := range yyq78 {
					if b {
						yynn78++
					}
				}
				r.EncodeMapStart(yynn78)
				yynn78 = 0
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq78[0] {
					yym80 := z.EncBinary()
					_ = yym80
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq78[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym81 := z.EncBinary()
					_ = yym81
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq78[1] {
					yym83 := z.EncBinary()
					_ = yym83
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq78[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym84 := z.EncBinary()
					_ = yym84
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq78[2] {
					yym86 := z.EncBinary()
					_ = yym86
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq78[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym87 := z.EncBinary()
					_ = yym87
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq78[3] {
					yym89 := z.EncBinary()
					_ = yym89
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subresource))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq78[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subresource"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym90 := z.EncBinary()
					_ = yym90
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subresource))
					}
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SubresourceReference) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym91 := z.DecBinary()
	_ = yym91
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct92 := r.ContainerType()
		if yyct92 == codecSelferValueTypeMap1234 {
			yyl92 := r.ReadMapStart()
			if yyl92 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl92, d)
			}
		} else if yyct92 == codecSelferValueTypeArray1234 {
			yyl92 := r.ReadArrayStart()
			if yyl92 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl92, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SubresourceReference) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys93Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys93Slc
	var yyhl93 bool = l >= 0
	for yyj93 := 0; ; yyj93++ {
		if yyhl93 {
			if yyj93 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys93Slc = r.DecodeBytes(yys93Slc, true, true)
		yys93 := string(yys93Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys93 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "subresource":
			if r.TryDecodeAsNil() {
				x.Subresource = ""
			} else {
				x.Subresource = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys93)
		} // end switch yys93
	} // end for yyj93
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SubresourceReference) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj98 int
	var yyb98 bool
	var yyhl98 bool = l >= 0
	yyj98++
	if yyhl98 {
		yyb98 = yyj98 > l
	} else {
		yyb98 = r.CheckBreak()
	}
	if yyb98 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj98++
	if yyhl98 {
		yyb98 = yyj98 > l
	} else {
		yyb98 = r.CheckBreak()
	}
	if yyb98 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj98++
	if yyhl98 {
		yyb98 = yyj98 > l
	} else {
		yyb98 = r.CheckBreak()
	}
	if yyb98 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj98++
	if yyhl98 {
		yyb98 = yyj98 > l
	} else {
		yyb98 = r.CheckBreak()
	}
	if yyb98 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subresource = ""
	} else {
		x.Subresource = string(r.DecodeString())
	}
	for {
		yyj98++
		if yyhl98 {
			yyb98 = yyj98 > l
		} else {
			yyb98 = r.CheckBreak()
		}
		if yyb98 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj98-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CPUTargetUtilization) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym103 := z.EncBinary()
		_ = yym103
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep104 := !z.EncBinary()
			yy2arr104 := z.EncBasicHandle().StructToArray
			var yyq104 [1]bool
			_, _, _ = yysep104, yyq104, yy2arr104
			const yyr104 bool = false
			var yynn104 int
			if yyr104 || yy2arr104 {
				r.EncodeArrayStart(1)
			} else {
				yynn104 = 1
				for _, b := range yyq104 {
					if b {
						yynn104++
					}
				}
				r.EncodeMapStart(yynn104)
				yynn104 = 0
			}
			if yyr104 || yy2arr104 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym106 := z.EncBinary()
				_ = yym106
				if false {
				} else {
					r.EncodeInt(int64(x.TargetPercentage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetPercentage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym107 := z.EncBinary()
				_ = yym107
				if false {
				} else {
					r.EncodeInt(int64(x.TargetPercentage))
				}
			}
			if yyr104 || yy2arr104 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CPUTargetUtilization) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym108 := z.DecBinary()
	_ = yym108
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct109 := r.ContainerType()
		if yyct109 == codecSelferValueTypeMap1234 {
			yyl109 := r.ReadMapStart()
			if yyl109 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl109, d)
			}
		} else if yyct109 == codecSelferValueTypeArray1234 {
			yyl109 := r.ReadArrayStart()
			if yyl109 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl109, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CPUTargetUtilization) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys110Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys110Slc
	var yyhl110 bool = l >= 0
	for yyj110 := 0; ; yyj110++ {
		if yyhl110 {
			if yyj110 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys110Slc = r.DecodeBytes(yys110Slc, true, true)
		yys110 := string(yys110Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys110 {
		case "targetPercentage":
			if r.TryDecodeAsNil() {
				x.TargetPercentage = 0
			} else {
				x.TargetPercentage = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys110)
		} // end switch yys110
	} // end for yyj110
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CPUTargetUtilization) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj112 int
	var yyb112 bool
	var yyhl112 bool = l >= 0
	yyj112++
	if yyhl112 {
		yyb112 = yyj112 > l
	} else {
		yyb112 = r.CheckBreak()
	}
	if yyb112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPercentage = 0
	} else {
		x.TargetPercentage = int32(r.DecodeInt(32))
	}
	for {
		yyj112++
		if yyhl112 {
			yyb112 = yyj112 > l
		} else {
			yyb112 = r.CheckBreak()
		}
		if yyb112 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj112-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym114 := z.EncBinary()
		_ = yym114
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep115 := !z.EncBinary()
			yy2arr115 := z.EncBasicHandle().StructToArray
			var yyq115 [4]bool
			_, _, _ = yysep115, yyq115, yy2arr115
			const yyr115 bool = false
			yyq115[1] = x.MinReplicas != nil
			yyq115[3] = x.CPUUtilization != nil
			var yynn115 int
			if yyr115 || yy2arr115 {
				r.EncodeArrayStart(4)
			} else {
				yynn115 = 2
				for _, b := range yyq115 {
					if b {
						yynn115++
					}
				}
				r.EncodeMapStart(yynn115)
				yynn115 = 0
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy117 := &x.ScaleRef
				yy117.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("scaleRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy118 := &x.ScaleRef
				yy118.CodecEncodeSelf(e)
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq115[1] {
					if x.MinReplicas == nil {
						r.EncodeNil()
					} else {
						yy120 := *x.MinReplicas
						yym121 := z.EncBinary()
						_ = yym121
						if false {
						} else {
							r.EncodeInt(int64(yy120))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq115[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MinReplicas == nil {
						r.EncodeNil()
					} else {
						yy122 := *x.MinReplicas
						yym123 := z.EncBinary()
						_ = yym123
						if false {
						} else {
							r.EncodeInt(int64(yy122))
						}
					}
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym125 := z.EncBinary()
				_ = yym125
				if false {
				} else {
					r.EncodeInt(int64(x.MaxReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym126 := z.EncBinary()
				_ = yym126
				if false {
				} else {
					r.EncodeInt(int64(x.MaxReplicas))
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq115[3] {
					if x.CPUUtilization == nil {
						r.EncodeNil()
					} else {
						x.CPUUtilization.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq115[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cpuUtilization"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CPUUtilization == nil {
						r.EncodeNil()
					} else {
						x.CPUUtilization.CodecEncodeSelf(e)
					}
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym128 := z.DecBinary()
	_ = yym128
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct129 := r.ContainerType()
		if yyct129 == codecSelferValueTypeMap1234 {
			yyl129 := r.ReadMapStart()
			if yyl129 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl129, d)
			}
		} else if yyct129 == codecSelferValueTypeArray1234 {
			yyl129 := r.ReadArrayStart()
			if yyl129 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl129, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys130Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys130Slc
	var yyhl130 bool = l >= 0
	for yyj130 := 0; ; yyj130++ {
		if yyhl130 {
			if yyj130 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys130Slc = r.DecodeBytes(yys130Slc, true, true)
		yys130 := string(yys130Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys130 {
		case "scaleRef":
			if r.TryDecodeAsNil() {
				x.ScaleRef = SubresourceReference{}
			} else {
				yyv131 := &x.ScaleRef
				yyv131.CodecDecodeSelf(d)
			}
		case "minReplicas":
			if r.TryDecodeAsNil() {
				if x.MinReplicas != nil {
					x.MinReplicas = nil
				}
			} else {
				if x.MinReplicas == nil {
					x.MinReplicas = new(int32)
				}
				yym133 := z.DecBinary()
				_ = yym133
				if false {
				} else {
					*((*int32)(x.MinReplicas)) = int32(r.DecodeInt(32))
				}
			}
		case "maxReplicas":
			if r.TryDecodeAsNil() {
				x.MaxReplicas = 0
			} else {
				x.MaxReplicas = int32(r.DecodeInt(32))
			}
		case "cpuUtilization":
			if r.TryDecodeAsNil() {
				if x.CPUUtilization != nil {
					x.CPUUtilization = nil
				}
			} else {
				if x.CPUUtilization == nil {
					x.CPUUtilization = new(CPUTargetUtilization)
				}
				x.CPUUtilization.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys130)
		} // end switch yys130
	} // end for yyj130
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj136 int
	var yyb136 bool
	var yyhl136 bool = l >= 0
	yyj136++
	if yyhl136 {
		yyb136 = yyj136 > l
	} else {
		yyb136 = r.CheckBreak()
	}
	if yyb136 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ScaleRef = SubresourceReference{}
	} else {
		yyv137 := &x.ScaleRef
		yyv137.CodecDecodeSelf(d)
	}
	yyj136++
	if yyhl136 {
		yyb136 = yyj136 > l
	} else {
		yyb136 = r.CheckBreak()
	}
	if yyb136 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.MinReplicas != nil {
			x.MinReplicas = nil
		}
	} else {
		if x.MinReplicas == nil {
			x.MinReplicas = new(int32)
		}
		yym139 := z.DecBinary()
		_ = yym139
		if false {
		} else {
			*((*int32)(x.MinReplicas)) = int32(r.DecodeInt(32))
		}
	}
	yyj136++
	if yyhl136 {
		yyb136 = yyj136 > l
	} else {
		yyb136 = r.CheckBreak()
	}
	if yyb136 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxReplicas = 0
	} else {
		x.MaxReplicas = int32(r.DecodeInt(32))
	}
	yyj136++
	if yyhl136 {
		yyb136 = yyj136 > l
	} else {
		yyb136 = r.CheckBreak()
	}
	if yyb136 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CPUUtilization != nil {
			x.CPUUtilization = nil
		}
	} else {
		if x.CPUUtilization == nil {
			x.CPUUtilization = new(CPUTargetUtilization)
		}
		x.CPUUtilization.CodecDecodeSelf(d)
	}
	for {
		yyj136++
		if yyhl136 {
			yyb136 = yyj136 > l
		} else {
			yyb136 = r.CheckBreak()
		}
		if yyb136 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj136-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym142 := z.EncBinary()
		_ = yym142
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep143 := !z.EncBinary()
			yy2arr143 := z.EncBasicHandle().StructToArray
			var yyq143 [5]bool
			_, _, _ = yysep143, yyq143, yy2arr143
			const yyr143 bool = false
			yyq143[0] = x.ObservedGeneration != nil
			yyq143[1] = x.LastScaleTime != nil
			yyq143[4] = x.CurrentCPUUtilizationPercentage != nil
			var yynn143 int
			if yyr143 || yy2arr143 {
				r.EncodeArrayStart(5)
			} else {
				yynn143 = 2
				for _, b := range yyq143 {
					if b {
						yynn143++
					}
				}
				r.EncodeMapStart(yynn143)
				yynn143 = 0
			}
			if yyr143 || yy2arr143 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq143[0] {
					if x.ObservedGeneration == nil {
						r.EncodeNil()
					} else {
						yy145 := *x.ObservedGeneration
						yym146 := z.EncBinary()
						_ = yym146
						if false {
						} else {
							r.EncodeInt(int64(yy145))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq143[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ObservedGeneration == nil {
						r.EncodeNil()
					} else {
						yy147 := *x.ObservedGeneration
						yym148 := z.EncBinary()
						_ = yym148
						if false {
						} else {
							r.EncodeInt(int64(yy147))
						}
					}
				}
			}
			if yyr143 || yy2arr143 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq143[1] {
					if x.LastScaleTime == nil {
						r.EncodeNil()
					} else {
						yym150 := z.EncBinary()
						_ = yym150
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LastScaleTime) {
						} else if yym150 {
							z.EncBinaryMarshal(x.LastScaleTime)
						} else if !yym150 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.LastScaleTime)
						} else {
							z.EncFallback(x.LastScaleTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq143[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastScaleTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LastScaleTime == nil {
						r.EncodeNil()
					} else {
						yym151 := z.EncBinary()
						_ = yym151
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LastScaleTime) {
						} else if yym151 {
							z.EncBinaryMarshal(x.LastScaleTime)
						} else if !yym151 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.LastScaleTime)
						} else {
							z.EncFallback(x.LastScaleTime)
						}
					}
				}
			}
			if yyr143 || yy2arr143 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym153 := z.EncBinary()
				_ = yym153
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("currentReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym154 := z.EncBinary()
				_ = yym154
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentReplicas))
				}
			}
			if yyr143 || yy2arr143 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym156 := z.EncBinary()
				_ = yym156
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("desiredReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym157 := z.EncBinary()
				_ = yym157
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredReplicas))
				}
			}
			if yyr143 || yy2arr143 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq143[4] {
					if x.CurrentCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy159 := *x.CurrentCPUUtilizationPercentage
						yym160 := z.EncBinary()
						_ = yym160
						if false {
						} else {
							r.EncodeInt(int64(yy159))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq143[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("currentCPUUtilizationPercentage"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CurrentCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy161 := *x.CurrentCPUUtilizationPercentage
						yym162 := z.EncBinary()
						_ = yym162
						if false {
						} else {
							r.EncodeInt(int64(yy161))
						}
					}
				}
			}
			if yyr143 || yy2arr143 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym163 := z.DecBinary()
	_ = yym163
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct164 := r.ContainerType()
		if yyct164 == codecSelferValueTypeMap1234 {
			yyl164 := r.ReadMapStart()
			if yyl164 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl164, d)
			}
		} else if yyct164 == codecSelferValueTypeArray1234 {
			yyl164 := r.ReadArrayStart()
			if yyl164 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl164, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys165Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys165Slc
	var yyhl165 bool = l >= 0
	for yyj165 := 0; ; yyj165++ {
		if yyhl165 {
			if yyj165 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys165Slc = r.DecodeBytes(yys165Slc, true, true)
		yys165 := string(yys165Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys165 {
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				if x.ObservedGeneration != nil {
					x.ObservedGeneration = nil
				}
			} else {
				if x.ObservedGeneration == nil {
					x.ObservedGeneration = new(int64)
				}
				yym167 := z.DecBinary()
				_ = yym167
				if false {
				} else {
					*((*int64)(x.ObservedGeneration)) = int64(r.DecodeInt(64))
				}
			}
		case "lastScaleTime":
			if r.TryDecodeAsNil() {
				if x.LastScaleTime != nil {
					x.LastScaleTime = nil
				}
			} else {
				if x.LastScaleTime == nil {
					x.LastScaleTime = new(pkg1_unversioned.Time)
				}
				yym169 := z.DecBinary()
				_ = yym169
				if false {
				} else if z.HasExtensions() && z.DecExt(x.LastScaleTime) {
				} else if yym169 {
					z.DecBinaryUnmarshal(x.LastScaleTime)
				} else if !yym169 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.LastScaleTime)
				} else {
					z.DecFallback(x.LastScaleTime, false)
				}
			}
		case "currentReplicas":
			if r.TryDecodeAsNil() {
				x.CurrentReplicas = 0
			} else {
				x.CurrentReplicas = int32(r.DecodeInt(32))
			}
		case "desiredReplicas":
			if r.TryDecodeAsNil() {
				x.DesiredReplicas = 0
			} else {
				x.DesiredReplicas = int32(r.DecodeInt(32))
			}
		case "currentCPUUtilizationPercentage":
			if r.TryDecodeAsNil() {
				if x.CurrentCPUUtilizationPercentage != nil {
					x.CurrentCPUUtilizationPercentage = nil
				}
			} else {
				if x.CurrentCPUUtilizationPercentage == nil {
					x.CurrentCPUUtilizationPercentage = new(int32)
				}
				yym173 := z.DecBinary()
				_ = yym173
				if false {
				} else {
					*((*int32)(x.CurrentCPUUtilizationPercentage)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys165)
		} // end switch yys165
	} // end for yyj165
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj174 int
	var yyb174 bool
	var yyhl174 bool = l >= 0
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ObservedGeneration != nil {
			x.ObservedGeneration = nil
		}
	} else {
		if x.ObservedGeneration == nil {
			x.ObservedGeneration = new(int64)
		}
		yym176 := z.DecBinary()
		_ = yym176
		if false {
		} else {
			*((*int64)(x.ObservedGeneration)) = int64(r.DecodeInt(64))
		}
	}
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LastScaleTime != nil {
			x.LastScaleTime = nil
		}
	} else {
		if x.LastScaleTime == nil {
			x.LastScaleTime = new(pkg1_unversioned.Time)
		}
		yym178 := z.DecBinary()
		_ = yym178
		if false {
		} else if z.HasExtensions() && z.DecExt(x.LastScaleTime) {
		} else if yym178 {
			z.DecBinaryUnmarshal(x.LastScaleTime)
		} else if !yym178 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.LastScaleTime)
		} else {
			z.DecFallback(x.LastScaleTime, false)
		}
	}
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentReplicas = 0
	} else {
		x.CurrentReplicas = int32(r.DecodeInt(32))
	}
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DesiredReplicas = 0
	} else {
		x.DesiredReplicas = int32(r.DecodeInt(32))
	}
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CurrentCPUUtilizationPercentage != nil {
			x.CurrentCPUUtilizationPercentage = nil
		}
	} else {
		if x.CurrentCPUUtilizationPercentage == nil {
			x.CurrentCPUUtilizationPercentage = new(int32)
		}
		yym182 := z.DecBinary()
		_ = yym182
		if false {
		} else {
			*((*int32)(x.CurrentCPUUtilizationPercentage)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj174++
		if yyhl174 {
			yyb174 = yyj174 > l
		} else {
			yyb174 = r.CheckBreak()
		}
		if yyb174 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj174-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscaler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym183 := z.EncBinary()
		_ = yym183
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep184 := !z.EncBinary()
			yy2arr184 := z.EncBasicHandle().StructToArray
			var yyq184 [5]bool
			_, _, _ = yysep184, yyq184, yy2arr184
			const yyr184 bool = false
			yyq184[0] = x.Kind != ""
			yyq184[1] = x.APIVersion != ""
			yyq184[2] = true
			yyq184[3] = true
			yyq184[4] = true
			var yynn184 int
			if yyr184 || yy2arr184 {
				r.EncodeArrayStart(5)
			} else {
				yynn184 = 0
				for _, b := range yyq184 {
					if b {
						yynn184++
					}
				}
				r.EncodeMapStart(yynn184)
				yynn184 = 0
			}
			if yyr184 || yy2arr184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq184[0] {
					yym186 := z.EncBinary()
					_ = yym186
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq184[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym187 := z.EncBinary()
					_ = yym187
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr184 || yy2arr184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq184[1] {
					yym189 := z.EncBinary()
					_ = yym189
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq184[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym190 := z.EncBinary()
					_ = yym190
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr184 || yy2arr184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq184[2] {
					yy192 := &x.ObjectMeta
					yy192.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq184[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy193 := &x.ObjectMeta
					yy193.CodecEncodeSelf(e)
				}
			}
			if yyr184 || yy2arr184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq184[3] {
					yy195 := &x.Spec
					yy195.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq184[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy196 := &x.Spec
					yy196.CodecEncodeSelf(e)
				}
			}
			if yyr184 || yy2arr184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq184[4] {
					yy198 := &x.Status
					yy198.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq184[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy199 := &x.Status
					yy199.CodecEncodeSelf(e)
				}
			}
			if yyr184 || yy2arr184 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscaler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym200 := z.DecBinary()
	_ = yym200
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct201 := r.ContainerType()
		if yyct201 == codecSelferValueTypeMap1234 {
			yyl201 := r.ReadMapStart()
			if yyl201 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl201, d)
			}
		} else if yyct201 == codecSelferValueTypeArray1234 {
			yyl201 := r.ReadArrayStart()
			if yyl201 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl201, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscaler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys202Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys202Slc
	var yyhl202 bool = l >= 0
	for yyj202 := 0; ; yyj202++ {
		if yyhl202 {
			if yyj202 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys202Slc = r.DecodeBytes(yys202Slc, true, true)
		yys202 := string(yys202Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys202 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv205 := &x.ObjectMeta
				yyv205.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = HorizontalPodAutoscalerSpec{}
			} else {
				yyv206 := &x.Spec
				yyv206.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = HorizontalPodAutoscalerStatus{}
			} else {
				yyv207 := &x.Status
				yyv207.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys202)
		} // end switch yys202
	} // end for yyj202
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscaler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj208 int
	var yyb208 bool
	var yyhl208 bool = l >= 0
	yyj208++
	if yyhl208 {
		yyb208 = yyj208 > l
	} else {
		yyb208 = r.CheckBreak()
	}
	if yyb208 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj208++
	if yyhl208 {
		yyb208 = yyj208 > l
	} else {
		yyb208 = r.CheckBreak()
	}
	if yyb208 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj208++
	if yyhl208 {
		yyb208 = yyj208 > l
	} else {
		yyb208 = r.CheckBreak()
	}
	if yyb208 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv211 := &x.ObjectMeta
		yyv211.CodecDecodeSelf(d)
	}
	yyj208++
	if yyhl208 {
		yyb208 = yyj208 > l
	} else {
		yyb208 = r.CheckBreak()
	}
	if yyb208 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = HorizontalPodAutoscalerSpec{}
	} else {
		yyv212 := &x.Spec
		yyv212.CodecDecodeSelf(d)
	}
	yyj208++
	if yyhl208 {
		yyb208 = yyj208 > l
	} else {
		yyb208 = r.CheckBreak()
	}
	if yyb208 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = HorizontalPodAutoscalerStatus{}
	} else {
		yyv213 := &x.Status
		yyv213.CodecDecodeSelf(d)
	}
	for {
		yyj208++
		if yyhl208 {
			yyb208 = yyj208 > l
		} else {
			yyb208 = r.CheckBreak()
		}
		if yyb208 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj208-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym214 := z.EncBinary()
		_ = yym214
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep215 := !z.EncBinary()
			yy2arr215 := z.EncBasicHandle().StructToArray
			var yyq215 [4]bool
			_, _, _ = yysep215, yyq215, yy2arr215
			const yyr215 bool = false
			yyq215[0] = x.Kind != ""
			yyq215[1] = x.APIVersion != ""
			yyq215[2] = true
			var yynn215 int
			if yyr215 || yy2arr215 {
				r.EncodeArrayStart(4)
			} else {
				yynn215 = 1
				for _, b := range yyq215 {
					if b {
						yynn215++
					}
				}
				r.EncodeMapStart(yynn215)
				yynn215 = 0
			}
			if yyr215 || yy2arr215 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq215[0] {
					yym217 := z.EncBinary()
					_ = yym217
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq215[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym218 := z.EncBinary()
					_ = yym218
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr215 || yy2arr215 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq215[1] {
					yym220 := z.EncBinary()
					_ = yym220
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq215[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym221 := z.EncBinary()
					_ = yym221
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr215 || yy2arr215 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq215[2] {
					yy223 := &x.ListMeta
					yym224 := z.EncBinary()
					_ = yym224
					if false {
					} else if z.HasExtensions() && z.EncExt(yy223) {
					} else {
						z.EncFallback(yy223)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq215[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy225 := &x.ListMeta
					yym226 := z.EncBinary()
					_ = yym226
					if false {
					} else if z.HasExtensions() && z.EncExt(yy225) {
					} else {
						z.EncFallback(yy225)
					}
				}
			}
			if yyr215 || yy2arr215 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym228 := z.EncBinary()
					_ = yym228
					if false {
					} else {
						h.encSliceHorizontalPodAutoscaler(([]HorizontalPodAutoscaler)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym229 := z.EncBinary()
					_ = yym229
					if false {
					} else {
						h.encSliceHorizontalPodAutoscaler(([]HorizontalPodAutoscaler)(x.Items), e)
					}
				}
			}
			if yyr215 || yy2arr215 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym230 := z.DecBinary()
	_ = yym230
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct231 := r.ContainerType()
		if yyct231 == codecSelferValueTypeMap1234 {
			yyl231 := r.ReadMapStart()
			if yyl231 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl231, d)
			}
		} else if yyct231 == codecSelferValueTypeArray1234 {
			yyl231 := r.ReadArrayStart()
			if yyl231 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl231, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys232Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys232Slc
	var yyhl232 bool = l >= 0
	for yyj232 := 0; ; yyj232++ {
		if yyhl232 {
			if yyj232 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys232Slc = r.DecodeBytes(yys232Slc, true, true)
		yys232 := string(yys232Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys232 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv235 := &x.ListMeta
				yym236 := z.DecBinary()
				_ = yym236
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv235) {
				} else {
					z.DecFallback(yyv235, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv237 := &x.Items
				yym238 := z.DecBinary()
				_ = yym238
				if false {
				} else {
					h.decSliceHorizontalPodAutoscaler((*[]HorizontalPodAutoscaler)(yyv237), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys232)
		} // end switch yys232
	} // end for yyj232
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj239 int
	var yyb239 bool
	var yyhl239 bool = l >= 0
	yyj239++
	if yyhl239 {
		yyb239 = yyj239 > l
	} else {
		yyb239 = r.CheckBreak()
	}
	if yyb239 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj239++
	if yyhl239 {
		yyb239 = yyj239 > l
	} else {
		yyb239 = r.CheckBreak()
	}
	if yyb239 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj239++
	if yyhl239 {
		yyb239 = yyj239 > l
	} else {
		yyb239 = r.CheckBreak()
	}
	if yyb239 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv242 := &x.ListMeta
		yym243 := z.DecBinary()
		_ = yym243
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv242) {
		} else {
			z.DecFallback(yyv242, false)
		}
	}
	yyj239++
	if yyhl239 {
		yyb239 = yyj239 > l
	} else {
		yyb239 = r.CheckBreak()
	}
	if yyb239 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv244 := &x.Items
		yym245 := z.DecBinary()
		_ = yym245
		if false {
		} else {
			h.decSliceHorizontalPodAutoscaler((*[]HorizontalPodAutoscaler)(yyv244), d)
		}
	}
	for {
		yyj239++
		if yyhl239 {
			yyb239 = yyj239 > l
		} else {
			yyb239 = r.CheckBreak()
		}
		if yyb239 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj239-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym246 := z.EncBinary()
		_ = yym246
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep247 := !z.EncBinary()
			yy2arr247 := z.EncBasicHandle().StructToArray
			var yyq247 [5]bool
			_, _, _ = yysep247, yyq247, yy2arr247
			const yyr247 bool = false
			yyq247[0] = x.Kind != ""
			yyq247[1] = x.APIVersion != ""
			yyq247[2] = true
			yyq247[3] = x.Description != ""
			yyq247[4] = len(x.Versions) != 0
			var yynn247 int
			if yyr247 || yy2arr247 {
				r.EncodeArrayStart(5)
			} else {
				yynn247 = 0
				for _, b := range yyq247 {
					if b {
						yynn247++
					}
				}
				r.EncodeMapStart(yynn247)
				yynn247 = 0
			}
			if yyr247 || yy2arr247 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq247[0] {
					yym249 := z.EncBinary()
					_ = yym249
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq247[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym250 := z.EncBinary()
					_ = yym250
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr247 || yy2arr247 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq247[1] {
					yym252 := z.EncBinary()
					_ = yym252
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq247[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym253 := z.EncBinary()
					_ = yym253
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr247 || yy2arr247 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq247[2] {
					yy255 := &x.ObjectMeta
					yy255.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq247[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy256 := &x.ObjectMeta
					yy256.CodecEncodeSelf(e)
				}
			}
			if yyr247 || yy2arr247 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq247[3] {
					yym258 := z.EncBinary()
					_ = yym258
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Description))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq247[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("description"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym259 := z.EncBinary()
					_ = yym259
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Description))
					}
				}
			}
			if yyr247 || yy2arr247 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq247[4] {
					if x.Versions == nil {
						r.EncodeNil()
					} else {
						yym261 := z.EncBinary()
						_ = yym261
						if false {
						} else {
							h.encSliceAPIVersion(([]APIVersion)(x.Versions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq247[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("versions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Versions == nil {
						r.EncodeNil()
					} else {
						yym262 := z.EncBinary()
						_ = yym262
						if false {
						} else {
							h.encSliceAPIVersion(([]APIVersion)(x.Versions), e)
						}
					}
				}
			}
			if yyr247 || yy2arr247 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym263 := z.DecBinary()
	_ = yym263
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct264 := r.ContainerType()
		if yyct264 == codecSelferValueTypeMap1234 {
			yyl264 := r.ReadMapStart()
			if yyl264 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl264, d)
			}
		} else if yyct264 == codecSelferValueTypeArray1234 {
			yyl264 := r.ReadArrayStart()
			if yyl264 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl264, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys265Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys265Slc
	var yyhl265 bool = l >= 0
	for yyj265 := 0; ; yyj265++ {
		if yyhl265 {
			if yyj265 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys265Slc = r.DecodeBytes(yys265Slc, true, true)
		yys265 := string(yys265Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys265 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv268 := &x.ObjectMeta
				yyv268.CodecDecodeSelf(d)
			}
		case "description":
			if r.TryDecodeAsNil() {
				x.Description = ""
			} else {
				x.Description = string(r.DecodeString())
			}
		case "versions":
			if r.TryDecodeAsNil() {
				x.Versions = nil
			} else {
				yyv270 := &x.Versions
				yym271 := z.DecBinary()
				_ = yym271
				if false {
				} else {
					h.decSliceAPIVersion((*[]APIVersion)(yyv270), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys265)
		} // end switch yys265
	} // end for yyj265
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj272 int
	var yyb272 bool
	var yyhl272 bool = l >= 0
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv275 := &x.ObjectMeta
		yyv275.CodecDecodeSelf(d)
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Description = ""
	} else {
		x.Description = string(r.DecodeString())
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Versions = nil
	} else {
		yyv277 := &x.Versions
		yym278 := z.DecBinary()
		_ = yym278
		if false {
		} else {
			h.decSliceAPIVersion((*[]APIVersion)(yyv277), d)
		}
	}
	for {
		yyj272++
		if yyhl272 {
			yyb272 = yyj272 > l
		} else {
			yyb272 = r.CheckBreak()
		}
		if yyb272 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj272-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym279 := z.EncBinary()
		_ = yym279
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep280 := !z.EncBinary()
			yy2arr280 := z.EncBasicHandle().StructToArray
			var yyq280 [4]bool
			_, _, _ = yysep280, yyq280, yy2arr280
			const yyr280 bool = false
			yyq280[0] = x.Kind != ""
			yyq280[1] = x.APIVersion != ""
			yyq280[2] = true
			var yynn280 int
			if yyr280 || yy2arr280 {
				r.EncodeArrayStart(4)
			} else {
				yynn280 = 1
				for _, b := range yyq280 {
					if b {
						yynn280++
					}
				}
				r.EncodeMapStart(yynn280)
				yynn280 = 0
			}
			if yyr280 || yy2arr280 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq280[0] {
					yym282 := z.EncBinary()
					_ = yym282
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq280[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym283 := z.EncBinary()
					_ = yym283
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr280 || yy2arr280 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq280[1] {
					yym285 := z.EncBinary()
					_ = yym285
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq280[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym286 := z.EncBinary()
					_ = yym286
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr280 || yy2arr280 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq280[2] {
					yy288 := &x.ListMeta
					yym289 := z.EncBinary()
					_ = yym289
					if false {
					} else if z.HasExtensions() && z.EncExt(yy288) {
					} else {
						z.EncFallback(yy288)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq280[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy290 := &x.ListMeta
					yym291 := z.EncBinary()
					_ = yym291
					if false {
					} else if z.HasExtensions() && z.EncExt(yy290) {
					} else {
						z.EncFallback(yy290)
					}
				}
			}
			if yyr280 || yy2arr280 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym293 := z.EncBinary()
					_ = yym293
					if false {
					} else {
						h.encSliceThirdPartyResource(([]ThirdPartyResource)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym294 := z.EncBinary()
					_ = yym294
					if false {
					} else {
						h.encSliceThirdPartyResource(([]ThirdPartyResource)(x.Items), e)
					}
				}
			}
			if yyr280 || yy2arr280 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym295 := z.DecBinary()
	_ = yym295
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct296 := r.ContainerType()
		if yyct296 == codecSelferValueTypeMap1234 {
			yyl296 := r.ReadMapStart()
			if yyl296 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl296, d)
			}
		} else if yyct296 == codecSelferValueTypeArray1234 {
			yyl296 := r.ReadArrayStart()
			if yyl296 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl296, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys297Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys297Slc
	var yyhl297 bool = l >= 0
	for yyj297 := 0; ; yyj297++ {
		if yyhl297 {
			if yyj297 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys297Slc = r.DecodeBytes(yys297Slc, true, true)
		yys297 := string(yys297Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys297 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv300 := &x.ListMeta
				yym301 := z.DecBinary()
				_ = yym301
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv300) {
				} else {
					z.DecFallback(yyv300, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv302 := &x.Items
				yym303 := z.DecBinary()
				_ = yym303
				if false {
				} else {
					h.decSliceThirdPartyResource((*[]ThirdPartyResource)(yyv302), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys297)
		} // end switch yys297
	} // end for yyj297
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj304 int
	var yyb304 bool
	var yyhl304 bool = l >= 0
	yyj304++
	if yyhl304 {
		yyb304 = yyj304 > l
	} else {
		yyb304 = r.CheckBreak()
	}
	if yyb304 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj304++
	if yyhl304 {
		yyb304 = yyj304 > l
	} else {
		yyb304 = r.CheckBreak()
	}
	if yyb304 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj304++
	if yyhl304 {
		yyb304 = yyj304 > l
	} else {
		yyb304 = r.CheckBreak()
	}
	if yyb304 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv307 := &x.ListMeta
		yym308 := z.DecBinary()
		_ = yym308
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv307) {
		} else {
			z.DecFallback(yyv307, false)
		}
	}
	yyj304++
	if yyhl304 {
		yyb304 = yyj304 > l
	} else {
		yyb304 = r.CheckBreak()
	}
	if yyb304 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv309 := &x.Items
		yym310 := z.DecBinary()
		_ = yym310
		if false {
		} else {
			h.decSliceThirdPartyResource((*[]ThirdPartyResource)(yyv309), d)
		}
	}
	for {
		yyj304++
		if yyhl304 {
			yyb304 = yyj304 > l
		} else {
			yyb304 = r.CheckBreak()
		}
		if yyb304 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj304-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *APIVersion) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym311 := z.EncBinary()
		_ = yym311
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep312 := !z.EncBinary()
			yy2arr312 := z.EncBasicHandle().StructToArray
			var yyq312 [2]bool
			_, _, _ = yysep312, yyq312, yy2arr312
			const yyr312 bool = false
			yyq312[0] = x.Name != ""
			yyq312[1] = x.APIGroup != ""
			var yynn312 int
			if yyr312 || yy2arr312 {
				r.EncodeArrayStart(2)
			} else {
				yynn312 = 0
				for _, b := range yyq312 {
					if b {
						yynn312++
					}
				}
				r.EncodeMapStart(yynn312)
				yynn312 = 0
			}
			if yyr312 || yy2arr312 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq312[0] {
					yym314 := z.EncBinary()
					_ = yym314
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq312[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym315 := z.EncBinary()
					_ = yym315
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr312 || yy2arr312 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq312[1] {
					yym317 := z.EncBinary()
					_ = yym317
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIGroup))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq312[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiGroup"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym318 := z.EncBinary()
					_ = yym318
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIGroup))
					}
				}
			}
			if yyr312 || yy2arr312 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *APIVersion) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym319 := z.DecBinary()
	_ = yym319
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct320 := r.ContainerType()
		if yyct320 == codecSelferValueTypeMap1234 {
			yyl320 := r.ReadMapStart()
			if yyl320 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl320, d)
			}
		} else if yyct320 == codecSelferValueTypeArray1234 {
			yyl320 := r.ReadArrayStart()
			if yyl320 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl320, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *APIVersion) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys321Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys321Slc
	var yyhl321 bool = l >= 0
	for yyj321 := 0; ; yyj321++ {
		if yyhl321 {
			if yyj321 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys321Slc = r.DecodeBytes(yys321Slc, true, true)
		yys321 := string(yys321Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys321 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "apiGroup":
			if r.TryDecodeAsNil() {
				x.APIGroup = ""
			} else {
				x.APIGroup = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys321)
		} // end switch yys321
	} // end for yyj321
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *APIVersion) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj324 int
	var yyb324 bool
	var yyhl324 bool = l >= 0
	yyj324++
	if yyhl324 {
		yyb324 = yyj324 > l
	} else {
		yyb324 = r.CheckBreak()
	}
	if yyb324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj324++
	if yyhl324 {
		yyb324 = yyj324 > l
	} else {
		yyb324 = r.CheckBreak()
	}
	if yyb324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIGroup = ""
	} else {
		x.APIGroup = string(r.DecodeString())
	}
	for {
		yyj324++
		if yyhl324 {
			yyb324 = yyj324 > l
		} else {
			yyb324 = r.CheckBreak()
		}
		if yyb324 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj324-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceData) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym327 := z.EncBinary()
		_ = yym327
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep328 := !z.EncBinary()
			yy2arr328 := z.EncBasicHandle().StructToArray
			var yyq328 [4]bool
			_, _, _ = yysep328, yyq328, yy2arr328
			const yyr328 bool = false
			yyq328[0] = x.Kind != ""
			yyq328[1] = x.APIVersion != ""
			yyq328[2] = true
			yyq328[3] = len(x.Data) != 0
			var yynn328 int
			if yyr328 || yy2arr328 {
				r.EncodeArrayStart(4)
			} else {
				yynn328 = 0
				for _, b := range yyq328 {
					if b {
						yynn328++
					}
				}
				r.EncodeMapStart(yynn328)
				yynn328 = 0
			}
			if yyr328 || yy2arr328 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq328[0] {
					yym330 := z.EncBinary()
					_ = yym330
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq328[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym331 := z.EncBinary()
					_ = yym331
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr328 || yy2arr328 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq328[1] {
					yym333 := z.EncBinary()
					_ = yym333
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq328[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym334 := z.EncBinary()
					_ = yym334
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr328 || yy2arr328 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq328[2] {
					yy336 := &x.ObjectMeta
					yy336.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq328[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy337 := &x.ObjectMeta
					yy337.CodecEncodeSelf(e)
				}
			}
			if yyr328 || yy2arr328 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq328[3] {
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym339 := z.EncBinary()
						_ = yym339
						if false {
						} else {
							r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Data))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq328[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("data"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym340 := z.EncBinary()
						_ = yym340
						if false {
						} else {
							r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Data))
						}
					}
				}
			}
			if yyr328 || yy2arr328 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceData) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym341 := z.DecBinary()
	_ = yym341
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct342 := r.ContainerType()
		if yyct342 == codecSelferValueTypeMap1234 {
			yyl342 := r.ReadMapStart()
			if yyl342 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl342, d)
			}
		} else if yyct342 == codecSelferValueTypeArray1234 {
			yyl342 := r.ReadArrayStart()
			if yyl342 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl342, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceData) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys343Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys343Slc
	var yyhl343 bool = l >= 0
	for yyj343 := 0; ; yyj343++ {
		if yyhl343 {
			if yyj343 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys343Slc = r.DecodeBytes(yys343Slc, true, true)
		yys343 := string(yys343Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys343 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv346 := &x.ObjectMeta
				yyv346.CodecDecodeSelf(d)
			}
		case "data":
			if r.TryDecodeAsNil() {
				x.Data = nil
			} else {
				yyv347 := &x.Data
				yym348 := z.DecBinary()
				_ = yym348
				if false {
				} else {
					*yyv347 = r.DecodeBytes(*(*[]byte)(yyv347), false, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys343)
		} // end switch yys343
	} // end for yyj343
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceData) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj349 int
	var yyb349 bool
	var yyhl349 bool = l >= 0
	yyj349++
	if yyhl349 {
		yyb349 = yyj349 > l
	} else {
		yyb349 = r.CheckBreak()
	}
	if yyb349 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj349++
	if yyhl349 {
		yyb349 = yyj349 > l
	} else {
		yyb349 = r.CheckBreak()
	}
	if yyb349 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj349++
	if yyhl349 {
		yyb349 = yyj349 > l
	} else {
		yyb349 = r.CheckBreak()
	}
	if yyb349 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv352 := &x.ObjectMeta
		yyv352.CodecDecodeSelf(d)
	}
	yyj349++
	if yyhl349 {
		yyb349 = yyj349 > l
	} else {
		yyb349 = r.CheckBreak()
	}
	if yyb349 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Data = nil
	} else {
		yyv353 := &x.Data
		yym354 := z.DecBinary()
		_ = yym354
		if false {
		} else {
			*yyv353 = r.DecodeBytes(*(*[]byte)(yyv353), false, false)
		}
	}
	for {
		yyj349++
		if yyhl349 {
			yyb349 = yyj349 > l
		} else {
			yyb349 = r.CheckBreak()
		}
		if yyb349 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj349-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Deployment) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym355 := z.EncBinary()
		_ = yym355
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep356 := !z.EncBinary()
			yy2arr356 := z.EncBasicHandle().StructToArray
			var yyq356 [5]bool
			_, _, _ = yysep356, yyq356, yy2arr356
			const yyr356 bool = false
			yyq356[0] = x.Kind != ""
			yyq356[1] = x.APIVersion != ""
			yyq356[2] = true
			yyq356[3] = true
			yyq356[4] = true
			var yynn356 int
			if yyr356 || yy2arr356 {
				r.EncodeArrayStart(5)
			} else {
				yynn356 = 0
				for _, b := range yyq356 {
					if b {
						yynn356++
					}
				}
				r.EncodeMapStart(yynn356)
				yynn356 = 0
			}
			if yyr356 || yy2arr356 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq356[0] {
					yym358 := z.EncBinary()
					_ = yym358
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq356[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym359 := z.EncBinary()
					_ = yym359
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr356 || yy2arr356 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq356[1] {
					yym361 := z.EncBinary()
					_ = yym361
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq356[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym362 := z.EncBinary()
					_ = yym362
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr356 || yy2arr356 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq356[2] {
					yy364 := &x.ObjectMeta
					yy364.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq356[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy365 := &x.ObjectMeta
					yy365.CodecEncodeSelf(e)
				}
			}
			if yyr356 || yy2arr356 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq356[3] {
					yy367 := &x.Spec
					yy367.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq356[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy368 := &x.Spec
					yy368.CodecEncodeSelf(e)
				}
			}
			if yyr356 || yy2arr356 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq356[4] {
					yy370 := &x.Status
					yy370.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq356[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy371 := &x.Status
					yy371.CodecEncodeSelf(e)
				}
			}
			if yyr356 || yy2arr356 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Deployment) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym372 := z.DecBinary()
	_ = yym372
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct373 := r.ContainerType()
		if yyct373 == codecSelferValueTypeMap1234 {
			yyl373 := r.ReadMapStart()
			if yyl373 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl373, d)
			}
		} else if yyct373 == codecSelferValueTypeArray1234 {
			yyl373 := r.ReadArrayStart()
			if yyl373 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl373, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Deployment) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys374Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys374Slc
	var yyhl374 bool = l >= 0
	for yyj374 := 0; ; yyj374++ {
		if yyhl374 {
			if yyj374 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys374Slc = r.DecodeBytes(yys374Slc, true, true)
		yys374 := string(yys374Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys374 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv377 := &x.ObjectMeta
				yyv377.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = DeploymentSpec{}
			} else {
				yyv378 := &x.Spec
				yyv378.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = DeploymentStatus{}
			} else {
				yyv379 := &x.Status
				yyv379.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys374)
		} // end switch yys374
	} // end for yyj374
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Deployment) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj380 int
	var yyb380 bool
	var yyhl380 bool = l >= 0
	yyj380++
	if yyhl380 {
		yyb380 = yyj380 > l
	} else {
		yyb380 = r.CheckBreak()
	}
	if yyb380 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj380++
	if yyhl380 {
		yyb380 = yyj380 > l
	} else {
		yyb380 = r.CheckBreak()
	}
	if yyb380 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj380++
	if yyhl380 {
		yyb380 = yyj380 > l
	} else {
		yyb380 = r.CheckBreak()
	}
	if yyb380 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv383 := &x.ObjectMeta
		yyv383.CodecDecodeSelf(d)
	}
	yyj380++
	if yyhl380 {
		yyb380 = yyj380 > l
	} else {
		yyb380 = r.CheckBreak()
	}
	if yyb380 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = DeploymentSpec{}
	} else {
		yyv384 := &x.Spec
		yyv384.CodecDecodeSelf(d)
	}
	yyj380++
	if yyhl380 {
		yyb380 = yyj380 > l
	} else {
		yyb380 = r.CheckBreak()
	}
	if yyb380 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = DeploymentStatus{}
	} else {
		yyv385 := &x.Status
		yyv385.CodecDecodeSelf(d)
	}
	for {
		yyj380++
		if yyhl380 {
			yyb380 = yyj380 > l
		} else {
			yyb380 = r.CheckBreak()
		}
		if yyb380 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj380-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym386 := z.EncBinary()
		_ = yym386
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep387 := !z.EncBinary()
			yy2arr387 := z.EncBasicHandle().StructToArray
			var yyq387 [5]bool
			_, _, _ = yysep387, yyq387, yy2arr387
			const yyr387 bool = false
			yyq387[0] = x.Replicas != nil
			yyq387[1] = len(x.Selector) != 0
			yyq387[3] = true
			yyq387[4] = x.UniqueLabelKey != nil
			var yynn387 int
			if yyr387 || yy2arr387 {
				r.EncodeArrayStart(5)
			} else {
				yynn387 = 1
				for _, b := range yyq387 {
					if b {
						yynn387++
					}
				}
				r.EncodeMapStart(yynn387)
				yynn387 = 0
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq387[0] {
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy389 := *x.Replicas
						yym390 := z.EncBinary()
						_ = yym390
						if false {
						} else {
							r.EncodeInt(int64(yy389))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq387[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy391 := *x.Replicas
						yym392 := z.EncBinary()
						_ = yym392
						if false {
						} else {
							r.EncodeInt(int64(yy391))
						}
					}
				}
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq387[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym394 := z.EncBinary()
						_ = yym394
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq387[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym395 := z.EncBinary()
						_ = yym395
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				}
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy397 := &x.Template
				yy397.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy398 := &x.Template
				yy398.CodecEncodeSelf(e)
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq387[3] {
					yy400 := &x.Strategy
					yy400.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq387[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("strategy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy401 := &x.Strategy
					yy401.CodecEncodeSelf(e)
				}
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq387[4] {
					if x.UniqueLabelKey == nil {
						r.EncodeNil()
					} else {
						yy403 := *x.UniqueLabelKey
						yym404 := z.EncBinary()
						_ = yym404
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy403))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq387[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uniqueLabelKey"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.UniqueLabelKey == nil {
						r.EncodeNil()
					} else {
						yy405 := *x.UniqueLabelKey
						yym406 := z.EncBinary()
						_ = yym406
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy405))
						}
					}
				}
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym407 := z.DecBinary()
	_ = yym407
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct408 := r.ContainerType()
		if yyct408 == codecSelferValueTypeMap1234 {
			yyl408 := r.ReadMapStart()
			if yyl408 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl408, d)
			}
		} else if yyct408 == codecSelferValueTypeArray1234 {
			yyl408 := r.ReadArrayStart()
			if yyl408 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl408, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys409Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys409Slc
	var yyhl409 bool = l >= 0
	for yyj409 := 0; ; yyj409++ {
		if yyhl409 {
			if yyj409 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys409Slc = r.DecodeBytes(yys409Slc, true, true)
		yys409 := string(yys409Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys409 {
		case "replicas":
			if r.TryDecodeAsNil() {
				if x.Replicas != nil {
					x.Replicas = nil
				}
			} else {
				if x.Replicas == nil {
					x.Replicas = new(int32)
				}
				yym411 := z.DecBinary()
				_ = yym411
				if false {
				} else {
					*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv412 := &x.Selector
				yym413 := z.DecBinary()
				_ = yym413
				if false {
				} else {
					z.F.DecMapStringStringX(yyv412, false, d)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_v1.PodTemplateSpec{}
			} else {
				yyv414 := &x.Template
				yyv414.CodecDecodeSelf(d)
			}
		case "strategy":
			if r.TryDecodeAsNil() {
				x.Strategy = DeploymentStrategy{}
			} else {
				yyv415 := &x.Strategy
				yyv415.CodecDecodeSelf(d)
			}
		case "uniqueLabelKey":
			if r.TryDecodeAsNil() {
				if x.UniqueLabelKey != nil {
					x.UniqueLabelKey = nil
				}
			} else {
				if x.UniqueLabelKey == nil {
					x.UniqueLabelKey = new(string)
				}
				yym417 := z.DecBinary()
				_ = yym417
				if false {
				} else {
					*((*string)(x.UniqueLabelKey)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys409)
		} // end switch yys409
	} // end for yyj409
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj418 int
	var yyb418 bool
	var yyhl418 bool = l >= 0
	yyj418++
	if yyhl418 {
		yyb418 = yyj418 > l
	} else {
		yyb418 = r.CheckBreak()
	}
	if yyb418 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Replicas != nil {
			x.Replicas = nil
		}
	} else {
		if x.Replicas == nil {
			x.Replicas = new(int32)
		}
		yym420 := z.DecBinary()
		_ = yym420
		if false {
		} else {
			*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
		}
	}
	yyj418++
	if yyhl418 {
		yyb418 = yyj418 > l
	} else {
		yyb418 = r.CheckBreak()
	}
	if yyb418 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv421 := &x.Selector
		yym422 := z.DecBinary()
		_ = yym422
		if false {
		} else {
			z.F.DecMapStringStringX(yyv421, false, d)
		}
	}
	yyj418++
	if yyhl418 {
		yyb418 = yyj418 > l
	} else {
		yyb418 = r.CheckBreak()
	}
	if yyb418 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_v1.PodTemplateSpec{}
	} else {
		yyv423 := &x.Template
		yyv423.CodecDecodeSelf(d)
	}
	yyj418++
	if yyhl418 {
		yyb418 = yyj418 > l
	} else {
		yyb418 = r.CheckBreak()
	}
	if yyb418 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Strategy = DeploymentStrategy{}
	} else {
		yyv424 := &x.Strategy
		yyv424.CodecDecodeSelf(d)
	}
	yyj418++
	if yyhl418 {
		yyb418 = yyj418 > l
	} else {
		yyb418 = r.CheckBreak()
	}
	if yyb418 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.UniqueLabelKey != nil {
			x.UniqueLabelKey = nil
		}
	} else {
		if x.UniqueLabelKey == nil {
			x.UniqueLabelKey = new(string)
		}
		yym426 := z.DecBinary()
		_ = yym426
		if false {
		} else {
			*((*string)(x.UniqueLabelKey)) = r.DecodeString()
		}
	}
	for {
		yyj418++
		if yyhl418 {
			yyb418 = yyj418 > l
		} else {
			yyb418 = r.CheckBreak()
		}
		if yyb418 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj418-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentStrategy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym427 := z.EncBinary()
		_ = yym427
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep428 := !z.EncBinary()
			yy2arr428 := z.EncBasicHandle().StructToArray
			var yyq428 [2]bool
			_, _, _ = yysep428, yyq428, yy2arr428
			const yyr428 bool = false
			yyq428[0] = x.Type != ""
			yyq428[1] = x.RollingUpdate != nil
			var yynn428 int
			if yyr428 || yy2arr428 {
				r.EncodeArrayStart(2)
			} else {
				yynn428 = 0
				for _, b := range yyq428 {
					if b {
						yynn428++
					}
				}
				r.EncodeMapStart(yynn428)
				yynn428 = 0
			}
			if yyr428 || yy2arr428 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq428[0] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq428[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr428 || yy2arr428 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq428[1] {
					if x.RollingUpdate == nil {
						r.EncodeNil()
					} else {
						x.RollingUpdate.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq428[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rollingUpdate"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RollingUpdate == nil {
						r.EncodeNil()
					} else {
						x.RollingUpdate.CodecEncodeSelf(e)
					}
				}
			}
			if yyr428 || yy2arr428 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentStrategy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym431 := z.DecBinary()
	_ = yym431
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct432 := r.ContainerType()
		if yyct432 == codecSelferValueTypeMap1234 {
			yyl432 := r.ReadMapStart()
			if yyl432 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl432, d)
			}
		} else if yyct432 == codecSelferValueTypeArray1234 {
			yyl432 := r.ReadArrayStart()
			if yyl432 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl432, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentStrategy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys433Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys433Slc
	var yyhl433 bool = l >= 0
	for yyj433 := 0; ; yyj433++ {
		if yyhl433 {
			if yyj433 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys433Slc = r.DecodeBytes(yys433Slc, true, true)
		yys433 := string(yys433Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys433 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = DeploymentStrategyType(r.DecodeString())
			}
		case "rollingUpdate":
			if r.TryDecodeAsNil() {
				if x.RollingUpdate != nil {
					x.RollingUpdate = nil
				}
			} else {
				if x.RollingUpdate == nil {
					x.RollingUpdate = new(RollingUpdateDeployment)
				}
				x.RollingUpdate.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys433)
		} // end switch yys433
	} // end for yyj433
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentStrategy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj436 int
	var yyb436 bool
	var yyhl436 bool = l >= 0
	yyj436++
	if yyhl436 {
		yyb436 = yyj436 > l
	} else {
		yyb436 = r.CheckBreak()
	}
	if yyb436 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = DeploymentStrategyType(r.DecodeString())
	}
	yyj436++
	if yyhl436 {
		yyb436 = yyj436 > l
	} else {
		yyb436 = r.CheckBreak()
	}
	if yyb436 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RollingUpdate != nil {
			x.RollingUpdate = nil
		}
	} else {
		if x.RollingUpdate == nil {
			x.RollingUpdate = new(RollingUpdateDeployment)
		}
		x.RollingUpdate.CodecDecodeSelf(d)
	}
	for {
		yyj436++
		if yyhl436 {
			yyb436 = yyj436 > l
		} else {
			yyb436 = r.CheckBreak()
		}
		if yyb436 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj436-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x DeploymentStrategyType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym439 := z.EncBinary()
	_ = yym439
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DeploymentStrategyType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym440 := z.DecBinary()
	_ = yym440
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *RollingUpdateDeployment) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym441 := z.EncBinary()
		_ = yym441
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep442 := !z.EncBinary()
			yy2arr442 := z.EncBasicHandle().StructToArray
			var yyq442 [3]bool
			_, _, _ = yysep442, yyq442, yy2arr442
			const yyr442 bool = false
			yyq442[0] = x.MaxUnavailable != nil
			yyq442[1] = x.MaxSurge != nil
			yyq442[2] = x.MinReadySeconds != 0
			var yynn442 int
			if yyr442 || yy2arr442 {
				r.EncodeArrayStart(3)
			} else {
				yynn442 = 0
				for _, b := range yyq442 {
					if b {
						yynn442++
					}
				}
				r.EncodeMapStart(yynn442)
				yynn442 = 0
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq442[0] {
					if x.MaxUnavailable == nil {
						r.EncodeNil()
					} else {
						yym444 := z.EncBinary()
						_ = yym444
						if false {
						} else if z.HasExtensions() && z.EncExt(x.MaxUnavailable) {
						} else if !yym444 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.MaxUnavailable)
						} else {
							z.EncFallback(x.MaxUnavailable)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq442[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("maxUnavailable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MaxUnavailable == nil {
						r.EncodeNil()
					} else {
						yym445 := z.EncBinary()
						_ = yym445
						if false {
						} else if z.HasExtensions() && z.EncExt(x.MaxUnavailable) {
						} else if !yym445 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.MaxUnavailable)
						} else {
							z.EncFallback(x.MaxUnavailable)
						}
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq442[1] {
					if x.MaxSurge == nil {
						r.EncodeNil()
					} else {
						yym447 := z.EncBinary()
						_ = yym447
						if false {
						} else if z.HasExtensions() && z.EncExt(x.MaxSurge) {
						} else if !yym447 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.MaxSurge)
						} else {
							z.EncFallback(x.MaxSurge)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq442[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("maxSurge"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MaxSurge == nil {
						r.EncodeNil()
					} else {
						yym448 := z.EncBinary()
						_ = yym448
						if false {
						} else if z.HasExtensions() && z.EncExt(x.MaxSurge) {
						} else if !yym448 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.MaxSurge)
						} else {
							z.EncFallback(x.MaxSurge)
						}
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq442[2] {
					yym450 := z.EncBinary()
					_ = yym450
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq442[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReadySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym451 := z.EncBinary()
					_ = yym451
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RollingUpdateDeployment) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym452 := z.DecBinary()
	_ = yym452
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct453 := r.ContainerType()
		if yyct453 == codecSelferValueTypeMap1234 {
			yyl453 := r.ReadMapStart()
			if yyl453 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl453, d)
			}
		} else if yyct453 == codecSelferValueTypeArray1234 {
			yyl453 := r.ReadArrayStart()
			if yyl453 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl453, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RollingUpdateDeployment) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys454Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys454Slc
	var yyhl454 bool = l >= 0
	for yyj454 := 0; ; yyj454++ {
		if yyhl454 {
			if yyj454 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys454Slc = r.DecodeBytes(yys454Slc, true, true)
		yys454 := string(yys454Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys454 {
		case "maxUnavailable":
			if r.TryDecodeAsNil() {
				if x.MaxUnavailable != nil {
					x.MaxUnavailable = nil
				}
			} else {
				if x.MaxUnavailable == nil {
					x.MaxUnavailable = new(pkg6_intstr.IntOrString)
				}
				yym456 := z.DecBinary()
				_ = yym456
				if false {
				} else if z.HasExtensions() && z.DecExt(x.MaxUnavailable) {
				} else if !yym456 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.MaxUnavailable)
				} else {
					z.DecFallback(x.MaxUnavailable, false)
				}
			}
		case "maxSurge":
			if r.TryDecodeAsNil() {
				if x.MaxSurge != nil {
					x.MaxSurge = nil
				}
			} else {
				if x.MaxSurge == nil {
					x.MaxSurge = new(pkg6_intstr.IntOrString)
				}
				yym458 := z.DecBinary()
				_ = yym458
				if false {
				} else if z.HasExtensions() && z.DecExt(x.MaxSurge) {
				} else if !yym458 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.MaxSurge)
				} else {
					z.DecFallback(x.MaxSurge, false)
				}
			}
		case "minReadySeconds":
			if r.TryDecodeAsNil() {
				x.MinReadySeconds = 0
			} else {
				x.MinReadySeconds = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys454)
		} // end switch yys454
	} // end for yyj454
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RollingUpdateDeployment) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj460 int
	var yyb460 bool
	var yyhl460 bool = l >= 0
	yyj460++
	if yyhl460 {
		yyb460 = yyj460 > l
	} else {
		yyb460 = r.CheckBreak()
	}
	if yyb460 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.MaxUnavailable != nil {
			x.MaxUnavailable = nil
		}
	} else {
		if x.MaxUnavailable == nil {
			x.MaxUnavailable = new(pkg6_intstr.IntOrString)
		}
		yym462 := z.DecBinary()
		_ = yym462
		if false {
		} else if z.HasExtensions() && z.DecExt(x.MaxUnavailable) {
		} else if !yym462 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.MaxUnavailable)
		} else {
			z.DecFallback(x.MaxUnavailable, false)
		}
	}
	yyj460++
	if yyhl460 {
		yyb460 = yyj460 > l
	} else {
		yyb460 = r.CheckBreak()
	}
	if yyb460 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.MaxSurge != nil {
			x.MaxSurge = nil
		}
	} else {
		if x.MaxSurge == nil {
			x.MaxSurge = new(pkg6_intstr.IntOrString)
		}
		yym464 := z.DecBinary()
		_ = yym464
		if false {
		} else if z.HasExtensions() && z.DecExt(x.MaxSurge) {
		} else if !yym464 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.MaxSurge)
		} else {
			z.DecFallback(x.MaxSurge, false)
		}
	}
	yyj460++
	if yyhl460 {
		yyb460 = yyj460 > l
	} else {
		yyb460 = r.CheckBreak()
	}
	if yyb460 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinReadySeconds = 0
	} else {
		x.MinReadySeconds = int32(r.DecodeInt(32))
	}
	for {
		yyj460++
		if yyhl460 {
			yyb460 = yyj460 > l
		} else {
			yyb460 = r.CheckBreak()
		}
		if yyb460 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj460-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym466 := z.EncBinary()
		_ = yym466
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep467 := !z.EncBinary()
			yy2arr467 := z.EncBasicHandle().StructToArray
			var yyq467 [2]bool
			_, _, _ = yysep467, yyq467, yy2arr467
			const yyr467 bool = false
			yyq467[0] = x.Replicas != 0
			yyq467[1] = x.UpdatedReplicas != 0
			var yynn467 int
			if yyr467 || yy2arr467 {
				r.EncodeArrayStart(2)
			} else {
				yynn467 = 0
				for _, b := range yyq467 {
					if b {
						yynn467++
					}
				}
				r.EncodeMapStart(yynn467)
				yynn467 = 0
			}
			if yyr467 || yy2arr467 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq467[0] {
					yym469 := z.EncBinary()
					_ = yym469
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq467[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym470 := z.EncBinary()
					_ = yym470
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr467 || yy2arr467 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq467[1] {
					yym472 := z.EncBinary()
					_ = yym472
					if false {
					} else {
						r.EncodeInt(int64(x.UpdatedReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq467[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("updatedReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym473 := z.EncBinary()
					_ = yym473
					if false {
					} else {
						r.EncodeInt(int64(x.UpdatedReplicas))
					}
				}
			}
			if yyr467 || yy2arr467 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym474 := z.DecBinary()
	_ = yym474
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct475 := r.ContainerType()
		if yyct475 == codecSelferValueTypeMap1234 {
			yyl475 := r.ReadMapStart()
			if yyl475 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl475, d)
			}
		} else if yyct475 == codecSelferValueTypeArray1234 {
			yyl475 := r.ReadArrayStart()
			if yyl475 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl475, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys476Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys476Slc
	var yyhl476 bool = l >= 0
	for yyj476 := 0; ; yyj476++ {
		if yyhl476 {
			if yyj476 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys476Slc = r.DecodeBytes(yys476Slc, true, true)
		yys476 := string(yys476Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys476 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "updatedReplicas":
			if r.TryDecodeAsNil() {
				x.UpdatedReplicas = 0
			} else {
				x.UpdatedReplicas = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys476)
		} // end switch yys476
	} // end for yyj476
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj479 int
	var yyb479 bool
	var yyhl479 bool = l >= 0
	yyj479++
	if yyhl479 {
		yyb479 = yyj479 > l
	} else {
		yyb479 = r.CheckBreak()
	}
	if yyb479 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj479++
	if yyhl479 {
		yyb479 = yyj479 > l
	} else {
		yyb479 = r.CheckBreak()
	}
	if yyb479 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UpdatedReplicas = 0
	} else {
		x.UpdatedReplicas = int32(r.DecodeInt(32))
	}
	for {
		yyj479++
		if yyhl479 {
			yyb479 = yyj479 > l
		} else {
			yyb479 = r.CheckBreak()
		}
		if yyb479 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj479-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym482 := z.EncBinary()
		_ = yym482
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep483 := !z.EncBinary()
			yy2arr483 := z.EncBasicHandle().StructToArray
			var yyq483 [4]bool
			_, _, _ = yysep483, yyq483, yy2arr483
			const yyr483 bool = false
			yyq483[0] = x.Kind != ""
			yyq483[1] = x.APIVersion != ""
			yyq483[2] = true
			var yynn483 int
			if yyr483 || yy2arr483 {
				r.EncodeArrayStart(4)
			} else {
				yynn483 = 1
				for _, b := range yyq483 {
					if b {
						yynn483++
					}
				}
				r.EncodeMapStart(yynn483)
				yynn483 = 0
			}
			if yyr483 || yy2arr483 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq483[0] {
					yym485 := z.EncBinary()
					_ = yym485
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq483[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym486 := z.EncBinary()
					_ = yym486
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr483 || yy2arr483 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq483[1] {
					yym488 := z.EncBinary()
					_ = yym488
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq483[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym489 := z.EncBinary()
					_ = yym489
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr483 || yy2arr483 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq483[2] {
					yy491 := &x.ListMeta
					yym492 := z.EncBinary()
					_ = yym492
					if false {
					} else if z.HasExtensions() && z.EncExt(yy491) {
					} else {
						z.EncFallback(yy491)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq483[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy493 := &x.ListMeta
					yym494 := z.EncBinary()
					_ = yym494
					if false {
					} else if z.HasExtensions() && z.EncExt(yy493) {
					} else {
						z.EncFallback(yy493)
					}
				}
			}
			if yyr483 || yy2arr483 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym496 := z.EncBinary()
					_ = yym496
					if false {
					} else {
						h.encSliceDeployment(([]Deployment)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym497 := z.EncBinary()
					_ = yym497
					if false {
					} else {
						h.encSliceDeployment(([]Deployment)(x.Items), e)
					}
				}
			}
			if yyr483 || yy2arr483 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym498 := z.DecBinary()
	_ = yym498
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct499 := r.ContainerType()
		if yyct499 == codecSelferValueTypeMap1234 {
			yyl499 := r.ReadMapStart()
			if yyl499 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl499, d)
			}
		} else if yyct499 == codecSelferValueTypeArray1234 {
			yyl499 := r.ReadArrayStart()
			if yyl499 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl499, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys500Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys500Slc
	var yyhl500 bool = l >= 0
	for yyj500 := 0; ; yyj500++ {
		if yyhl500 {
			if yyj500 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys500Slc = r.DecodeBytes(yys500Slc, true, true)
		yys500 := string(yys500Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys500 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv503 := &x.ListMeta
				yym504 := z.DecBinary()
				_ = yym504
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv503) {
				} else {
					z.DecFallback(yyv503, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv505 := &x.Items
				yym506 := z.DecBinary()
				_ = yym506
				if false {
				} else {
					h.decSliceDeployment((*[]Deployment)(yyv505), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys500)
		} // end switch yys500
	} // end for yyj500
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj507 int
	var yyb507 bool
	var yyhl507 bool = l >= 0
	yyj507++
	if yyhl507 {
		yyb507 = yyj507 > l
	} else {
		yyb507 = r.CheckBreak()
	}
	if yyb507 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj507++
	if yyhl507 {
		yyb507 = yyj507 > l
	} else {
		yyb507 = r.CheckBreak()
	}
	if yyb507 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj507++
	if yyhl507 {
		yyb507 = yyj507 > l
	} else {
		yyb507 = r.CheckBreak()
	}
	if yyb507 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv510 := &x.ListMeta
		yym511 := z.DecBinary()
		_ = yym511
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv510) {
		} else {
			z.DecFallback(yyv510, false)
		}
	}
	yyj507++
	if yyhl507 {
		yyb507 = yyj507 > l
	} else {
		yyb507 = r.CheckBreak()
	}
	if yyb507 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv512 := &x.Items
		yym513 := z.DecBinary()
		_ = yym513
		if false {
		} else {
			h.decSliceDeployment((*[]Deployment)(yyv512), d)
		}
	}
	for {
		yyj507++
		if yyhl507 {
			yyb507 = yyj507 > l
		} else {
			yyb507 = r.CheckBreak()
		}
		if yyb507 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj507-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym514 := z.EncBinary()
		_ = yym514
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep515 := !z.EncBinary()
			yy2arr515 := z.EncBasicHandle().StructToArray
			var yyq515 [2]bool
			_, _, _ = yysep515, yyq515, yy2arr515
			const yyr515 bool = false
			yyq515[0] = x.Selector != nil
			yyq515[1] = x.Template != nil
			var yynn515 int
			if yyr515 || yy2arr515 {
				r.EncodeArrayStart(2)
			} else {
				yynn515 = 0
				for _, b := range yyq515 {
					if b {
						yynn515++
					}
				}
				r.EncodeMapStart(yynn515)
				yynn515 = 0
			}
			if yyr515 || yy2arr515 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq515[0] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq515[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				}
			}
			if yyr515 || yy2arr515 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq515[1] {
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq515[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				}
			}
			if yyr515 || yy2arr515 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym518 := z.DecBinary()
	_ = yym518
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct519 := r.ContainerType()
		if yyct519 == codecSelferValueTypeMap1234 {
			yyl519 := r.ReadMapStart()
			if yyl519 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl519, d)
			}
		} else if yyct519 == codecSelferValueTypeArray1234 {
			yyl519 := r.ReadArrayStart()
			if yyl519 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl519, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys520Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys520Slc
	var yyhl520 bool = l >= 0
	for yyj520 := 0; ; yyj520++ {
		if yyhl520 {
			if yyj520 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys520Slc = r.DecodeBytes(yys520Slc, true, true)
		yys520 := string(yys520Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys520 {
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(LabelSelector)
				}
				x.Selector.CodecDecodeSelf(d)
			}
		case "template":
			if r.TryDecodeAsNil() {
				if x.Template != nil {
					x.Template = nil
				}
			} else {
				if x.Template == nil {
					x.Template = new(pkg2_v1.PodTemplateSpec)
				}
				x.Template.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys520)
		} // end switch yys520
	} // end for yyj520
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj523 int
	var yyb523 bool
	var yyhl523 bool = l >= 0
	yyj523++
	if yyhl523 {
		yyb523 = yyj523 > l
	} else {
		yyb523 = r.CheckBreak()
	}
	if yyb523 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(LabelSelector)
		}
		x.Selector.CodecDecodeSelf(d)
	}
	yyj523++
	if yyhl523 {
		yyb523 = yyj523 > l
	} else {
		yyb523 = r.CheckBreak()
	}
	if yyb523 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Template != nil {
			x.Template = nil
		}
	} else {
		if x.Template == nil {
			x.Template = new(pkg2_v1.PodTemplateSpec)
		}
		x.Template.CodecDecodeSelf(d)
	}
	for {
		yyj523++
		if yyhl523 {
			yyb523 = yyj523 > l
		} else {
			yyb523 = r.CheckBreak()
		}
		if yyb523 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj523-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym526 := z.EncBinary()
		_ = yym526
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep527 := !z.EncBinary()
			yy2arr527 := z.EncBasicHandle().StructToArray
			var yyq527 [3]bool
			_, _, _ = yysep527, yyq527, yy2arr527
			const yyr527 bool = false
			var yynn527 int
			if yyr527 || yy2arr527 {
				r.EncodeArrayStart(3)
			} else {
				yynn527 = 3
				for _, b := range yyq527 {
					if b {
						yynn527++
					}
				}
				r.EncodeMapStart(yynn527)
				yynn527 = 0
			}
			if yyr527 || yy2arr527 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym529 := z.EncBinary()
				_ = yym529
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentNumberScheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("currentNumberScheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym530 := z.EncBinary()
				_ = yym530
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentNumberScheduled))
				}
			}
			if yyr527 || yy2arr527 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym532 := z.EncBinary()
				_ = yym532
				if false {
				} else {
					r.EncodeInt(int64(x.NumberMisscheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("numberMisscheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym533 := z.EncBinary()
				_ = yym533
				if false {
				} else {
					r.EncodeInt(int64(x.NumberMisscheduled))
				}
			}
			if yyr527 || yy2arr527 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym535 := z.EncBinary()
				_ = yym535
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredNumberScheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("desiredNumberScheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym536 := z.EncBinary()
				_ = yym536
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredNumberScheduled))
				}
			}
			if yyr527 || yy2arr527 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym537 := z.DecBinary()
	_ = yym537
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct538 := r.ContainerType()
		if yyct538 == codecSelferValueTypeMap1234 {
			yyl538 := r.ReadMapStart()
			if yyl538 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl538, d)
			}
		} else if yyct538 == codecSelferValueTypeArray1234 {
			yyl538 := r.ReadArrayStart()
			if yyl538 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl538, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys539Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys539Slc
	var yyhl539 bool = l >= 0
	for yyj539 := 0; ; yyj539++ {
		if yyhl539 {
			if yyj539 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys539Slc = r.DecodeBytes(yys539Slc, true, true)
		yys539 := string(yys539Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys539 {
		case "currentNumberScheduled":
			if r.TryDecodeAsNil() {
				x.CurrentNumberScheduled = 0
			} else {
				x.CurrentNumberScheduled = int32(r.DecodeInt(32))
			}
		case "numberMisscheduled":
			if r.TryDecodeAsNil() {
				x.NumberMisscheduled = 0
			} else {
				x.NumberMisscheduled = int32(r.DecodeInt(32))
			}
		case "desiredNumberScheduled":
			if r.TryDecodeAsNil() {
				x.DesiredNumberScheduled = 0
			} else {
				x.DesiredNumberScheduled = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys539)
		} // end switch yys539
	} // end for yyj539
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj543 int
	var yyb543 bool
	var yyhl543 bool = l >= 0
	yyj543++
	if yyhl543 {
		yyb543 = yyj543 > l
	} else {
		yyb543 = r.CheckBreak()
	}
	if yyb543 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentNumberScheduled = 0
	} else {
		x.CurrentNumberScheduled = int32(r.DecodeInt(32))
	}
	yyj543++
	if yyhl543 {
		yyb543 = yyj543 > l
	} else {
		yyb543 = r.CheckBreak()
	}
	if yyb543 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NumberMisscheduled = 0
	} else {
		x.NumberMisscheduled = int32(r.DecodeInt(32))
	}
	yyj543++
	if yyhl543 {
		yyb543 = yyj543 > l
	} else {
		yyb543 = r.CheckBreak()
	}
	if yyb543 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DesiredNumberScheduled = 0
	} else {
		x.DesiredNumberScheduled = int32(r.DecodeInt(32))
	}
	for {
		yyj543++
		if yyhl543 {
			yyb543 = yyj543 > l
		} else {
			yyb543 = r.CheckBreak()
		}
		if yyb543 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj543-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSet) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym547 := z.EncBinary()
		_ = yym547
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep548 := !z.EncBinary()
			yy2arr548 := z.EncBasicHandle().StructToArray
			var yyq548 [5]bool
			_, _, _ = yysep548, yyq548, yy2arr548
			const yyr548 bool = false
			yyq548[0] = x.Kind != ""
			yyq548[1] = x.APIVersion != ""
			yyq548[2] = true
			yyq548[3] = true
			yyq548[4] = true
			var yynn548 int
			if yyr548 || yy2arr548 {
				r.EncodeArrayStart(5)
			} else {
				yynn548 = 0
				for _, b := range yyq548 {
					if b {
						yynn548++
					}
				}
				r.EncodeMapStart(yynn548)
				yynn548 = 0
			}
			if yyr548 || yy2arr548 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq548[0] {
					yym550 := z.EncBinary()
					_ = yym550
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq548[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym551 := z.EncBinary()
					_ = yym551
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr548 || yy2arr548 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq548[1] {
					yym553 := z.EncBinary()
					_ = yym553
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq548[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym554 := z.EncBinary()
					_ = yym554
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr548 || yy2arr548 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq548[2] {
					yy556 := &x.ObjectMeta
					yy556.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq548[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy557 := &x.ObjectMeta
					yy557.CodecEncodeSelf(e)
				}
			}
			if yyr548 || yy2arr548 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq548[3] {
					yy559 := &x.Spec
					yy559.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq548[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy560 := &x.Spec
					yy560.CodecEncodeSelf(e)
				}
			}
			if yyr548 || yy2arr548 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq548[4] {
					yy562 := &x.Status
					yy562.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq548[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy563 := &x.Status
					yy563.CodecEncodeSelf(e)
				}
			}
			if yyr548 || yy2arr548 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSet) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym564 := z.DecBinary()
	_ = yym564
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct565 := r.ContainerType()
		if yyct565 == codecSelferValueTypeMap1234 {
			yyl565 := r.ReadMapStart()
			if yyl565 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl565, d)
			}
		} else if yyct565 == codecSelferValueTypeArray1234 {
			yyl565 := r.ReadArrayStart()
			if yyl565 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl565, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSet) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys566Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys566Slc
	var yyhl566 bool = l >= 0
	for yyj566 := 0; ; yyj566++ {
		if yyhl566 {
			if yyj566 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys566Slc = r.DecodeBytes(yys566Slc, true, true)
		yys566 := string(yys566Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys566 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv569 := &x.ObjectMeta
				yyv569.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = DaemonSetSpec{}
			} else {
				yyv570 := &x.Spec
				yyv570.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = DaemonSetStatus{}
			} else {
				yyv571 := &x.Status
				yyv571.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys566)
		} // end switch yys566
	} // end for yyj566
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSet) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj572 int
	var yyb572 bool
	var yyhl572 bool = l >= 0
	yyj572++
	if yyhl572 {
		yyb572 = yyj572 > l
	} else {
		yyb572 = r.CheckBreak()
	}
	if yyb572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj572++
	if yyhl572 {
		yyb572 = yyj572 > l
	} else {
		yyb572 = r.CheckBreak()
	}
	if yyb572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj572++
	if yyhl572 {
		yyb572 = yyj572 > l
	} else {
		yyb572 = r.CheckBreak()
	}
	if yyb572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv575 := &x.ObjectMeta
		yyv575.CodecDecodeSelf(d)
	}
	yyj572++
	if yyhl572 {
		yyb572 = yyj572 > l
	} else {
		yyb572 = r.CheckBreak()
	}
	if yyb572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = DaemonSetSpec{}
	} else {
		yyv576 := &x.Spec
		yyv576.CodecDecodeSelf(d)
	}
	yyj572++
	if yyhl572 {
		yyb572 = yyj572 > l
	} else {
		yyb572 = r.CheckBreak()
	}
	if yyb572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = DaemonSetStatus{}
	} else {
		yyv577 := &x.Status
		yyv577.CodecDecodeSelf(d)
	}
	for {
		yyj572++
		if yyhl572 {
			yyb572 = yyj572 > l
		} else {
			yyb572 = r.CheckBreak()
		}
		if yyb572 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj572-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym578 := z.EncBinary()
		_ = yym578
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep579 := !z.EncBinary()
			yy2arr579 := z.EncBasicHandle().StructToArray
			var yyq579 [4]bool
			_, _, _ = yysep579, yyq579, yy2arr579
			const yyr579 bool = false
			yyq579[0] = x.Kind != ""
			yyq579[1] = x.APIVersion != ""
			yyq579[2] = true
			var yynn579 int
			if yyr579 || yy2arr579 {
				r.EncodeArrayStart(4)
			} else {
				yynn579 = 1
				for _, b := range yyq579 {
					if b {
						yynn579++
					}
				}
				r.EncodeMapStart(yynn579)
				yynn579 = 0
			}
			if yyr579 || yy2arr579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq579[0] {
					yym581 := z.EncBinary()
					_ = yym581
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq579[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym582 := z.EncBinary()
					_ = yym582
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr579 || yy2arr579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq579[1] {
					yym584 := z.EncBinary()
					_ = yym584
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq579[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym585 := z.EncBinary()
					_ = yym585
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr579 || yy2arr579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq579[2] {
					yy587 := &x.ListMeta
					yym588 := z.EncBinary()
					_ = yym588
					if false {
					} else if z.HasExtensions() && z.EncExt(yy587) {
					} else {
						z.EncFallback(yy587)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq579[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy589 := &x.ListMeta
					yym590 := z.EncBinary()
					_ = yym590
					if false {
					} else if z.HasExtensions() && z.EncExt(yy589) {
					} else {
						z.EncFallback(yy589)
					}
				}
			}
			if yyr579 || yy2arr579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym592 := z.EncBinary()
					_ = yym592
					if false {
					} else {
						h.encSliceDaemonSet(([]DaemonSet)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym593 := z.EncBinary()
					_ = yym593
					if false {
					} else {
						h.encSliceDaemonSet(([]DaemonSet)(x.Items), e)
					}
				}
			}
			if yyr579 || yy2arr579 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym594 := z.DecBinary()
	_ = yym594
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct595 := r.ContainerType()
		if yyct595 == codecSelferValueTypeMap1234 {
			yyl595 := r.ReadMapStart()
			if yyl595 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl595, d)
			}
		} else if yyct595 == codecSelferValueTypeArray1234 {
			yyl595 := r.ReadArrayStart()
			if yyl595 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl595, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys596Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys596Slc
	var yyhl596 bool = l >= 0
	for yyj596 := 0; ; yyj596++ {
		if yyhl596 {
			if yyj596 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys596Slc = r.DecodeBytes(yys596Slc, true, true)
		yys596 := string(yys596Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys596 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv599 := &x.ListMeta
				yym600 := z.DecBinary()
				_ = yym600
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv599) {
				} else {
					z.DecFallback(yyv599, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv601 := &x.Items
				yym602 := z.DecBinary()
				_ = yym602
				if false {
				} else {
					h.decSliceDaemonSet((*[]DaemonSet)(yyv601), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys596)
		} // end switch yys596
	} // end for yyj596
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj603 int
	var yyb603 bool
	var yyhl603 bool = l >= 0
	yyj603++
	if yyhl603 {
		yyb603 = yyj603 > l
	} else {
		yyb603 = r.CheckBreak()
	}
	if yyb603 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj603++
	if yyhl603 {
		yyb603 = yyj603 > l
	} else {
		yyb603 = r.CheckBreak()
	}
	if yyb603 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj603++
	if yyhl603 {
		yyb603 = yyj603 > l
	} else {
		yyb603 = r.CheckBreak()
	}
	if yyb603 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv606 := &x.ListMeta
		yym607 := z.DecBinary()
		_ = yym607
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv606) {
		} else {
			z.DecFallback(yyv606, false)
		}
	}
	yyj603++
	if yyhl603 {
		yyb603 = yyj603 > l
	} else {
		yyb603 = r.CheckBreak()
	}
	if yyb603 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv608 := &x.Items
		yym609 := z.DecBinary()
		_ = yym609
		if false {
		} else {
			h.decSliceDaemonSet((*[]DaemonSet)(yyv608), d)
		}
	}
	for {
		yyj603++
		if yyhl603 {
			yyb603 = yyj603 > l
		} else {
			yyb603 = r.CheckBreak()
		}
		if yyb603 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj603-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceDataList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym610 := z.EncBinary()
		_ = yym610
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep611 := !z.EncBinary()
			yy2arr611 := z.EncBasicHandle().StructToArray
			var yyq611 [4]bool
			_, _, _ = yysep611, yyq611, yy2arr611
			const yyr611 bool = false
			yyq611[0] = x.Kind != ""
			yyq611[1] = x.APIVersion != ""
			yyq611[2] = true
			var yynn611 int
			if yyr611 || yy2arr611 {
				r.EncodeArrayStart(4)
			} else {
				yynn611 = 1
				for _, b := range yyq611 {
					if b {
						yynn611++
					}
				}
				r.EncodeMapStart(yynn611)
				yynn611 = 0
			}
			if yyr611 || yy2arr611 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq611[0] {
					yym613 := z.EncBinary()
					_ = yym613
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq611[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym614 := z.EncBinary()
					_ = yym614
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr611 || yy2arr611 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq611[1] {
					yym616 := z.EncBinary()
					_ = yym616
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq611[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym617 := z.EncBinary()
					_ = yym617
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr611 || yy2arr611 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq611[2] {
					yy619 := &x.ListMeta
					yym620 := z.EncBinary()
					_ = yym620
					if false {
					} else if z.HasExtensions() && z.EncExt(yy619) {
					} else {
						z.EncFallback(yy619)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq611[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy621 := &x.ListMeta
					yym622 := z.EncBinary()
					_ = yym622
					if false {
					} else if z.HasExtensions() && z.EncExt(yy621) {
					} else {
						z.EncFallback(yy621)
					}
				}
			}
			if yyr611 || yy2arr611 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym624 := z.EncBinary()
					_ = yym624
					if false {
					} else {
						h.encSliceThirdPartyResourceData(([]ThirdPartyResourceData)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym625 := z.EncBinary()
					_ = yym625
					if false {
					} else {
						h.encSliceThirdPartyResourceData(([]ThirdPartyResourceData)(x.Items), e)
					}
				}
			}
			if yyr611 || yy2arr611 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceDataList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym626 := z.DecBinary()
	_ = yym626
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct627 := r.ContainerType()
		if yyct627 == codecSelferValueTypeMap1234 {
			yyl627 := r.ReadMapStart()
			if yyl627 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl627, d)
			}
		} else if yyct627 == codecSelferValueTypeArray1234 {
			yyl627 := r.ReadArrayStart()
			if yyl627 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl627, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceDataList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys628Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys628Slc
	var yyhl628 bool = l >= 0
	for yyj628 := 0; ; yyj628++ {
		if yyhl628 {
			if yyj628 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys628Slc = r.DecodeBytes(yys628Slc, true, true)
		yys628 := string(yys628Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys628 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv631 := &x.ListMeta
				yym632 := z.DecBinary()
				_ = yym632
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv631) {
				} else {
					z.DecFallback(yyv631, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv633 := &x.Items
				yym634 := z.DecBinary()
				_ = yym634
				if false {
				} else {
					h.decSliceThirdPartyResourceData((*[]ThirdPartyResourceData)(yyv633), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys628)
		} // end switch yys628
	} // end for yyj628
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceDataList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj635 int
	var yyb635 bool
	var yyhl635 bool = l >= 0
	yyj635++
	if yyhl635 {
		yyb635 = yyj635 > l
	} else {
		yyb635 = r.CheckBreak()
	}
	if yyb635 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj635++
	if yyhl635 {
		yyb635 = yyj635 > l
	} else {
		yyb635 = r.CheckBreak()
	}
	if yyb635 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj635++
	if yyhl635 {
		yyb635 = yyj635 > l
	} else {
		yyb635 = r.CheckBreak()
	}
	if yyb635 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv638 := &x.ListMeta
		yym639 := z.DecBinary()
		_ = yym639
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv638) {
		} else {
			z.DecFallback(yyv638, false)
		}
	}
	yyj635++
	if yyhl635 {
		yyb635 = yyj635 > l
	} else {
		yyb635 = r.CheckBreak()
	}
	if yyb635 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv640 := &x.Items
		yym641 := z.DecBinary()
		_ = yym641
		if false {
		} else {
			h.decSliceThirdPartyResourceData((*[]ThirdPartyResourceData)(yyv640), d)
		}
	}
	for {
		yyj635++
		if yyhl635 {
			yyb635 = yyj635 > l
		} else {
			yyb635 = r.CheckBreak()
		}
		if yyb635 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj635-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Job) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym642 := z.EncBinary()
		_ = yym642
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep643 := !z.EncBinary()
			yy2arr643 := z.EncBasicHandle().StructToArray
			var yyq643 [5]bool
			_, _, _ = yysep643, yyq643, yy2arr643
			const yyr643 bool = false
			yyq643[0] = x.Kind != ""
			yyq643[1] = x.APIVersion != ""
			yyq643[2] = true
			yyq643[3] = true
			yyq643[4] = true
			var yynn643 int
			if yyr643 || yy2arr643 {
				r.EncodeArrayStart(5)
			} else {
				yynn643 = 0
				for _, b := range yyq643 {
					if b {
						yynn643++
					}
				}
				r.EncodeMapStart(yynn643)
				yynn643 = 0
			}
			if yyr643 || yy2arr643 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq643[0] {
					yym645 := z.EncBinary()
					_ = yym645
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq643[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym646 := z.EncBinary()
					_ = yym646
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr643 || yy2arr643 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq643[1] {
					yym648 := z.EncBinary()
					_ = yym648
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq643[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym649 := z.EncBinary()
					_ = yym649
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr643 || yy2arr643 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq643[2] {
					yy651 := &x.ObjectMeta
					yy651.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq643[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy652 := &x.ObjectMeta
					yy652.CodecEncodeSelf(e)
				}
			}
			if yyr643 || yy2arr643 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq643[3] {
					yy654 := &x.Spec
					yy654.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq643[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy655 := &x.Spec
					yy655.CodecEncodeSelf(e)
				}
			}
			if yyr643 || yy2arr643 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq643[4] {
					yy657 := &x.Status
					yy657.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq643[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy658 := &x.Status
					yy658.CodecEncodeSelf(e)
				}
			}
			if yyr643 || yy2arr643 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Job) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym659 := z.DecBinary()
	_ = yym659
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct660 := r.ContainerType()
		if yyct660 == codecSelferValueTypeMap1234 {
			yyl660 := r.ReadMapStart()
			if yyl660 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl660, d)
			}
		} else if yyct660 == codecSelferValueTypeArray1234 {
			yyl660 := r.ReadArrayStart()
			if yyl660 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl660, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Job) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys661Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys661Slc
	var yyhl661 bool = l >= 0
	for yyj661 := 0; ; yyj661++ {
		if yyhl661 {
			if yyj661 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys661Slc = r.DecodeBytes(yys661Slc, true, true)
		yys661 := string(yys661Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys661 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv664 := &x.ObjectMeta
				yyv664.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = JobSpec{}
			} else {
				yyv665 := &x.Spec
				yyv665.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = JobStatus{}
			} else {
				yyv666 := &x.Status
				yyv666.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys661)
		} // end switch yys661
	} // end for yyj661
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Job) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj667 int
	var yyb667 bool
	var yyhl667 bool = l >= 0
	yyj667++
	if yyhl667 {
		yyb667 = yyj667 > l
	} else {
		yyb667 = r.CheckBreak()
	}
	if yyb667 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj667++
	if yyhl667 {
		yyb667 = yyj667 > l
	} else {
		yyb667 = r.CheckBreak()
	}
	if yyb667 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj667++
	if yyhl667 {
		yyb667 = yyj667 > l
	} else {
		yyb667 = r.CheckBreak()
	}
	if yyb667 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv670 := &x.ObjectMeta
		yyv670.CodecDecodeSelf(d)
	}
	yyj667++
	if yyhl667 {
		yyb667 = yyj667 > l
	} else {
		yyb667 = r.CheckBreak()
	}
	if yyb667 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = JobSpec{}
	} else {
		yyv671 := &x.Spec
		yyv671.CodecDecodeSelf(d)
	}
	yyj667++
	if yyhl667 {
		yyb667 = yyj667 > l
	} else {
		yyb667 = r.CheckBreak()
	}
	if yyb667 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = JobStatus{}
	} else {
		yyv672 := &x.Status
		yyv672.CodecDecodeSelf(d)
	}
	for {
		yyj667++
		if yyhl667 {
			yyb667 = yyj667 > l
		} else {
			yyb667 = r.CheckBreak()
		}
		if yyb667 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj667-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym673 := z.EncBinary()
		_ = yym673
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep674 := !z.EncBinary()
			yy2arr674 := z.EncBasicHandle().StructToArray
			var yyq674 [4]bool
			_, _, _ = yysep674, yyq674, yy2arr674
			const yyr674 bool = false
			yyq674[0] = x.Kind != ""
			yyq674[1] = x.APIVersion != ""
			yyq674[2] = true
			var yynn674 int
			if yyr674 || yy2arr674 {
				r.EncodeArrayStart(4)
			} else {
				yynn674 = 1
				for _, b := range yyq674 {
					if b {
						yynn674++
					}
				}
				r.EncodeMapStart(yynn674)
				yynn674 = 0
			}
			if yyr674 || yy2arr674 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq674[0] {
					yym676 := z.EncBinary()
					_ = yym676
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq674[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym677 := z.EncBinary()
					_ = yym677
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr674 || yy2arr674 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq674[1] {
					yym679 := z.EncBinary()
					_ = yym679
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq674[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym680 := z.EncBinary()
					_ = yym680
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr674 || yy2arr674 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq674[2] {
					yy682 := &x.ListMeta
					yym683 := z.EncBinary()
					_ = yym683
					if false {
					} else if z.HasExtensions() && z.EncExt(yy682) {
					} else {
						z.EncFallback(yy682)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq674[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy684 := &x.ListMeta
					yym685 := z.EncBinary()
					_ = yym685
					if false {
					} else if z.HasExtensions() && z.EncExt(yy684) {
					} else {
						z.EncFallback(yy684)
					}
				}
			}
			if yyr674 || yy2arr674 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym687 := z.EncBinary()
					_ = yym687
					if false {
					} else {
						h.encSliceJob(([]Job)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym688 := z.EncBinary()
					_ = yym688
					if false {
					} else {
						h.encSliceJob(([]Job)(x.Items), e)
					}
				}
			}
			if yyr674 || yy2arr674 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym689 := z.DecBinary()
	_ = yym689
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct690 := r.ContainerType()
		if yyct690 == codecSelferValueTypeMap1234 {
			yyl690 := r.ReadMapStart()
			if yyl690 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl690, d)
			}
		} else if yyct690 == codecSelferValueTypeArray1234 {
			yyl690 := r.ReadArrayStart()
			if yyl690 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl690, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys691Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys691Slc
	var yyhl691 bool = l >= 0
	for yyj691 := 0; ; yyj691++ {
		if yyhl691 {
			if yyj691 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys691Slc = r.DecodeBytes(yys691Slc, true, true)
		yys691 := string(yys691Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys691 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv694 := &x.ListMeta
				yym695 := z.DecBinary()
				_ = yym695
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv694) {
				} else {
					z.DecFallback(yyv694, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv696 := &x.Items
				yym697 := z.DecBinary()
				_ = yym697
				if false {
				} else {
					h.decSliceJob((*[]Job)(yyv696), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys691)
		} // end switch yys691
	} // end for yyj691
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj698 int
	var yyb698 bool
	var yyhl698 bool = l >= 0
	yyj698++
	if yyhl698 {
		yyb698 = yyj698 > l
	} else {
		yyb698 = r.CheckBreak()
	}
	if yyb698 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj698++
	if yyhl698 {
		yyb698 = yyj698 > l
	} else {
		yyb698 = r.CheckBreak()
	}
	if yyb698 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj698++
	if yyhl698 {
		yyb698 = yyj698 > l
	} else {
		yyb698 = r.CheckBreak()
	}
	if yyb698 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv701 := &x.ListMeta
		yym702 := z.DecBinary()
		_ = yym702
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv701) {
		} else {
			z.DecFallback(yyv701, false)
		}
	}
	yyj698++
	if yyhl698 {
		yyb698 = yyj698 > l
	} else {
		yyb698 = r.CheckBreak()
	}
	if yyb698 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv703 := &x.Items
		yym704 := z.DecBinary()
		_ = yym704
		if false {
		} else {
			h.decSliceJob((*[]Job)(yyv703), d)
		}
	}
	for {
		yyj698++
		if yyhl698 {
			yyb698 = yyj698 > l
		} else {
			yyb698 = r.CheckBreak()
		}
		if yyb698 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj698-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym705 := z.EncBinary()
		_ = yym705
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep706 := !z.EncBinary()
			yy2arr706 := z.EncBasicHandle().StructToArray
			var yyq706 [5]bool
			_, _, _ = yysep706, yyq706, yy2arr706
			const yyr706 bool = false
			yyq706[0] = x.Parallelism != nil
			yyq706[1] = x.Completions != nil
			yyq706[2] = x.ActiveDeadlineSeconds != nil
			yyq706[3] = x.Selector != nil
			var yynn706 int
			if yyr706 || yy2arr706 {
				r.EncodeArrayStart(5)
			} else {
				yynn706 = 1
				for _, b := range yyq706 {
					if b {
						yynn706++
					}
				}
				r.EncodeMapStart(yynn706)
				yynn706 = 0
			}
			if yyr706 || yy2arr706 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq706[0] {
					if x.Parallelism == nil {
						r.EncodeNil()
					} else {
						yy708 := *x.Parallelism
						yym709 := z.EncBinary()
						_ = yym709
						if false {
						} else {
							r.EncodeInt(int64(yy708))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq706[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("parallelism"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Parallelism == nil {
						r.EncodeNil()
					} else {
						yy710 := *x.Parallelism
						yym711 := z.EncBinary()
						_ = yym711
						if false {
						} else {
							r.EncodeInt(int64(yy710))
						}
					}
				}
			}
			if yyr706 || yy2arr706 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq706[1] {
					if x.Completions == nil {
						r.EncodeNil()
					} else {
						yy713 := *x.Completions
						yym714 := z.EncBinary()
						_ = yym714
						if false {
						} else {
							r.EncodeInt(int64(yy713))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq706[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("completions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Completions == nil {
						r.EncodeNil()
					} else {
						yy715 := *x.Completions
						yym716 := z.EncBinary()
						_ = yym716
						if false {
						} else {
							r.EncodeInt(int64(yy715))
						}
					}
				}
			}
			if yyr706 || yy2arr706 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq706[2] {
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy718 := *x.ActiveDeadlineSeconds
						yym719 := z.EncBinary()
						_ = yym719
						if false {
						} else {
							r.EncodeInt(int64(yy718))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq706[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("activeDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy720 := *x.ActiveDeadlineSeconds
						yym721 := z.EncBinary()
						_ = yym721
						if false {
						} else {
							r.EncodeInt(int64(yy720))
						}
					}
				}
			}
			if yyr706 || yy2arr706 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq706[3] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq706[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				}
			}
			if yyr706 || yy2arr706 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy724 := &x.Template
				yy724.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy725 := &x.Template
				yy725.CodecEncodeSelf(e)
			}
			if yyr706 || yy2arr706 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym726 := z.DecBinary()
	_ = yym726
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct727 := r.ContainerType()
		if yyct727 == codecSelferValueTypeMap1234 {
			yyl727 := r.ReadMapStart()
			if yyl727 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl727, d)
			}
		} else if yyct727 == codecSelferValueTypeArray1234 {
			yyl727 := r.ReadArrayStart()
			if yyl727 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl727, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys728Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys728Slc
	var yyhl728 bool = l >= 0
	for yyj728 := 0; ; yyj728++ {
		if yyhl728 {
			if yyj728 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys728Slc = r.DecodeBytes(yys728Slc, true, true)
		yys728 := string(yys728Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys728 {
		case "parallelism":
			if r.TryDecodeAsNil() {
				if x.Parallelism != nil {
					x.Parallelism = nil
				}
			} else {
				if x.Parallelism == nil {
					x.Parallelism = new(int32)
				}
				yym730 := z.DecBinary()
				_ = yym730
				if false {
				} else {
					*((*int32)(x.Parallelism)) = int32(r.DecodeInt(32))
				}
			}
		case "completions":
			if r.TryDecodeAsNil() {
				if x.Completions != nil {
					x.Completions = nil
				}
			} else {
				if x.Completions == nil {
					x.Completions = new(int32)
				}
				yym732 := z.DecBinary()
				_ = yym732
				if false {
				} else {
					*((*int32)(x.Completions)) = int32(r.DecodeInt(32))
				}
			}
		case "activeDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ActiveDeadlineSeconds != nil {
					x.ActiveDeadlineSeconds = nil
				}
			} else {
				if x.ActiveDeadlineSeconds == nil {
					x.ActiveDeadlineSeconds = new(int64)
				}
				yym734 := z.DecBinary()
				_ = yym734
				if false {
				} else {
					*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(LabelSelector)
				}
				x.Selector.CodecDecodeSelf(d)
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_v1.PodTemplateSpec{}
			} else {
				yyv736 := &x.Template
				yyv736.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys728)
		} // end switch yys728
	} // end for yyj728
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj737 int
	var yyb737 bool
	var yyhl737 bool = l >= 0
	yyj737++
	if yyhl737 {
		yyb737 = yyj737 > l
	} else {
		yyb737 = r.CheckBreak()
	}
	if yyb737 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Parallelism != nil {
			x.Parallelism = nil
		}
	} else {
		if x.Parallelism == nil {
			x.Parallelism = new(int32)
		}
		yym739 := z.DecBinary()
		_ = yym739
		if false {
		} else {
			*((*int32)(x.Parallelism)) = int32(r.DecodeInt(32))
		}
	}
	yyj737++
	if yyhl737 {
		yyb737 = yyj737 > l
	} else {
		yyb737 = r.CheckBreak()
	}
	if yyb737 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Completions != nil {
			x.Completions = nil
		}
	} else {
		if x.Completions == nil {
			x.Completions = new(int32)
		}
		yym741 := z.DecBinary()
		_ = yym741
		if false {
		} else {
			*((*int32)(x.Completions)) = int32(r.DecodeInt(32))
		}
	}
	yyj737++
	if yyhl737 {
		yyb737 = yyj737 > l
	} else {
		yyb737 = r.CheckBreak()
	}
	if yyb737 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ActiveDeadlineSeconds != nil {
			x.ActiveDeadlineSeconds = nil
		}
	} else {
		if x.ActiveDeadlineSeconds == nil {
			x.ActiveDeadlineSeconds = new(int64)
		}
		yym743 := z.DecBinary()
		_ = yym743
		if false {
		} else {
			*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj737++
	if yyhl737 {
		yyb737 = yyj737 > l
	} else {
		yyb737 = r.CheckBreak()
	}
	if yyb737 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(LabelSelector)
		}
		x.Selector.CodecDecodeSelf(d)
	}
	yyj737++
	if yyhl737 {
		yyb737 = yyj737 > l
	} else {
		yyb737 = r.CheckBreak()
	}
	if yyb737 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_v1.PodTemplateSpec{}
	} else {
		yyv745 := &x.Template
		yyv745.CodecDecodeSelf(d)
	}
	for {
		yyj737++
		if yyhl737 {
			yyb737 = yyj737 > l
		} else {
			yyb737 = r.CheckBreak()
		}
		if yyb737 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj737-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym746 := z.EncBinary()
		_ = yym746
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep747 := !z.EncBinary()
			yy2arr747 := z.EncBasicHandle().StructToArray
			var yyq747 [6]bool
			_, _, _ = yysep747, yyq747, yy2arr747
			const yyr747 bool = false
			yyq747[0] = len(x.Conditions) != 0
			yyq747[1] = x.StartTime != nil
			yyq747[2] = x.CompletionTime != nil
			yyq747[3] = x.Active != 0
			yyq747[4] = x.Succeeded != 0
			yyq747[5] = x.Failed != 0
			var yynn747 int
			if yyr747 || yy2arr747 {
				r.EncodeArrayStart(6)
			} else {
				yynn747 = 0
				for _, b := range yyq747 {
					if b {
						yynn747++
					}
				}
				r.EncodeMapStart(yynn747)
				yynn747 = 0
			}
			if yyr747 || yy2arr747 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq747[0] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym749 := z.EncBinary()
						_ = yym749
						if false {
						} else {
							h.encSliceJobCondition(([]JobCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq747[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym750 := z.EncBinary()
						_ = yym750
						if false {
						} else {
							h.encSliceJobCondition(([]JobCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr747 || yy2arr747 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq747[1] {
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym752 := z.EncBinary()
						_ = yym752
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym752 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym752 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq747[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym753 := z.EncBinary()
						_ = yym753
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym753 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym753 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				}
			}
			if yyr747 || yy2arr747 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq747[2] {
					if x.CompletionTime == nil {
						r.EncodeNil()
					} else {
						yym755 := z.EncBinary()
						_ = yym755
						if false {
						} else if z.HasExtensions() && z.EncExt(x.CompletionTime) {
						} else if yym755 {
							z.EncBinaryMarshal(x.CompletionTime)
						} else if !yym755 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.CompletionTime)
						} else {
							z.EncFallback(x.CompletionTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq747[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("completionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CompletionTime == nil {
						r.EncodeNil()
					} else {
						yym756 := z.EncBinary()
						_ = yym756
						if false {
						} else if z.HasExtensions() && z.EncExt(x.CompletionTime) {
						} else if yym756 {
							z.EncBinaryMarshal(x.CompletionTime)
						} else if !yym756 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.CompletionTime)
						} else {
							z.EncFallback(x.CompletionTime)
						}
					}
				}
			}
			if yyr747 || yy2arr747 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq747[3] {
					yym758 := z.EncBinary()
					_ = yym758
					if false {
					} else {
						r.EncodeInt(int64(x.Active))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq747[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("active"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym759 := z.EncBinary()
					_ = yym759
					if false {
					} else {
						r.EncodeInt(int64(x.Active))
					}
				}
			}
			if yyr747 || yy2arr747 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq747[4] {
					yym761 := z.EncBinary()
					_ = yym761
					if false {
					} else {
						r.EncodeInt(int64(x.Succeeded))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq747[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("succeeded"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym762 := z.EncBinary()
					_ = yym762
					if false {
					} else {
						r.EncodeInt(int64(x.Succeeded))
					}
				}
			}
			if yyr747 || yy2arr747 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq747[5] {
					yym764 := z.EncBinary()
					_ = yym764
					if false {
					} else {
						r.EncodeInt(int64(x.Failed))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq747[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("failed"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym765 := z.EncBinary()
					_ = yym765
					if false {
					} else {
						r.EncodeInt(int64(x.Failed))
					}
				}
			}
			if yyr747 || yy2arr747 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym766 := z.DecBinary()
	_ = yym766
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct767 := r.ContainerType()
		if yyct767 == codecSelferValueTypeMap1234 {
			yyl767 := r.ReadMapStart()
			if yyl767 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl767, d)
			}
		} else if yyct767 == codecSelferValueTypeArray1234 {
			yyl767 := r.ReadArrayStart()
			if yyl767 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl767, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys768Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys768Slc
	var yyhl768 bool = l >= 0
	for yyj768 := 0; ; yyj768++ {
		if yyhl768 {
			if yyj768 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys768Slc = r.DecodeBytes(yys768Slc, true, true)
		yys768 := string(yys768Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys768 {
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv769 := &x.Conditions
				yym770 := z.DecBinary()
				_ = yym770
				if false {
				} else {
					h.decSliceJobCondition((*[]JobCondition)(yyv769), d)
				}
			}
		case "startTime":
			if r.TryDecodeAsNil() {
				if x.StartTime != nil {
					x.StartTime = nil
				}
			} else {
				if x.StartTime == nil {
					x.StartTime = new(pkg1_unversioned.Time)
				}
				yym772 := z.DecBinary()
				_ = yym772
				if false {
				} else if z.HasExtensions() && z.DecExt(x.StartTime) {
				} else if yym772 {
					z.DecBinaryUnmarshal(x.StartTime)
				} else if !yym772 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.StartTime)
				} else {
					z.DecFallback(x.StartTime, false)
				}
			}
		case "completionTime":
			if r.TryDecodeAsNil() {
				if x.CompletionTime != nil {
					x.CompletionTime = nil
				}
			} else {
				if x.CompletionTime == nil {
					x.CompletionTime = new(pkg1_unversioned.Time)
				}
				yym774 := z.DecBinary()
				_ = yym774
				if false {
				} else if z.HasExtensions() && z.DecExt(x.CompletionTime) {
				} else if yym774 {
					z.DecBinaryUnmarshal(x.CompletionTime)
				} else if !yym774 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.CompletionTime)
				} else {
					z.DecFallback(x.CompletionTime, false)
				}
			}
		case "active":
			if r.TryDecodeAsNil() {
				x.Active = 0
			} else {
				x.Active = int32(r.DecodeInt(32))
			}
		case "succeeded":
			if r.TryDecodeAsNil() {
				x.Succeeded = 0
			} else {
				x.Succeeded = int32(r.DecodeInt(32))
			}
		case "failed":
			if r.TryDecodeAsNil() {
				x.Failed = 0
			} else {
				x.Failed = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys768)
		} // end switch yys768
	} // end for yyj768
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj778 int
	var yyb778 bool
	var yyhl778 bool = l >= 0
	yyj778++
	if yyhl778 {
		yyb778 = yyj778 > l
	} else {
		yyb778 = r.CheckBreak()
	}
	if yyb778 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv779 := &x.Conditions
		yym780 := z.DecBinary()
		_ = yym780
		if false {
		} else {
			h.decSliceJobCondition((*[]JobCondition)(yyv779), d)
		}
	}
	yyj778++
	if yyhl778 {
		yyb778 = yyj778 > l
	} else {
		yyb778 = r.CheckBreak()
	}
	if yyb778 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartTime != nil {
			x.StartTime = nil
		}
	} else {
		if x.StartTime == nil {
			x.StartTime = new(pkg1_unversioned.Time)
		}
		yym782 := z.DecBinary()
		_ = yym782
		if false {
		} else if z.HasExtensions() && z.DecExt(x.StartTime) {
		} else if yym782 {
			z.DecBinaryUnmarshal(x.StartTime)
		} else if !yym782 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.StartTime)
		} else {
			z.DecFallback(x.StartTime, false)
		}
	}
	yyj778++
	if yyhl778 {
		yyb778 = yyj778 > l
	} else {
		yyb778 = r.CheckBreak()
	}
	if yyb778 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CompletionTime != nil {
			x.CompletionTime = nil
		}
	} else {
		if x.CompletionTime == nil {
			x.CompletionTime = new(pkg1_unversioned.Time)
		}
		yym784 := z.DecBinary()
		_ = yym784
		if false {
		} else if z.HasExtensions() && z.DecExt(x.CompletionTime) {
		} else if yym784 {
			z.DecBinaryUnmarshal(x.CompletionTime)
		} else if !yym784 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.CompletionTime)
		} else {
			z.DecFallback(x.CompletionTime, false)
		}
	}
	yyj778++
	if yyhl778 {
		yyb778 = yyj778 > l
	} else {
		yyb778 = r.CheckBreak()
	}
	if yyb778 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Active = 0
	} else {
		x.Active = int32(r.DecodeInt(32))
	}
	yyj778++
	if yyhl778 {
		yyb778 = yyj778 > l
	} else {
		yyb778 = r.CheckBreak()
	}
	if yyb778 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Succeeded = 0
	} else {
		x.Succeeded = int32(r.DecodeInt(32))
	}
	yyj778++
	if yyhl778 {
		yyb778 = yyj778 > l
	} else {
		yyb778 = r.CheckBreak()
	}
	if yyb778 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Failed = 0
	} else {
		x.Failed = int32(r.DecodeInt(32))
	}
	for {
		yyj778++
		if yyhl778 {
			yyb778 = yyj778 > l
		} else {
			yyb778 = r.CheckBreak()
		}
		if yyb778 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj778-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x JobConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym788 := z.EncBinary()
	_ = yym788
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *JobConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym789 := z.DecBinary()
	_ = yym789
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *JobCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym790 := z.EncBinary()
		_ = yym790
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep791 := !z.EncBinary()
			yy2arr791 := z.EncBasicHandle().StructToArray
			var yyq791 [6]bool
			_, _, _ = yysep791, yyq791, yy2arr791
			const yyr791 bool = false
			yyq791[2] = true
			yyq791[3] = true
			yyq791[4] = x.Reason != ""
			yyq791[5] = x.Message != ""
			var yynn791 int
			if yyr791 || yy2arr791 {
				r.EncodeArrayStart(6)
			} else {
				yynn791 = 2
				for _, b := range yyq791 {
					if b {
						yynn791++
					}
				}
				r.EncodeMapStart(yynn791)
				yynn791 = 0
			}
			if yyr791 || yy2arr791 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr791 || yy2arr791 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym794 := z.EncBinary()
				_ = yym794
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym795 := z.EncBinary()
				_ = yym795
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			}
			if yyr791 || yy2arr791 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq791[2] {
					yy797 := &x.LastProbeTime
					yym798 := z.EncBinary()
					_ = yym798
					if false {
					} else if z.HasExtensions() && z.EncExt(yy797) {
					} else if yym798 {
						z.EncBinaryMarshal(yy797)
					} else if !yym798 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy797)
					} else {
						z.EncFallback(yy797)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq791[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastProbeTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy799 := &x.LastProbeTime
					yym800 := z.EncBinary()
					_ = yym800
					if false {
					} else if z.HasExtensions() && z.EncExt(yy799) {
					} else if yym800 {
						z.EncBinaryMarshal(yy799)
					} else if !yym800 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy799)
					} else {
						z.EncFallback(yy799)
					}
				}
			}
			if yyr791 || yy2arr791 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq791[3] {
					yy802 := &x.LastTransitionTime
					yym803 := z.EncBinary()
					_ = yym803
					if false {
					} else if z.HasExtensions() && z.EncExt(yy802) {
					} else if yym803 {
						z.EncBinaryMarshal(yy802)
					} else if !yym803 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy802)
					} else {
						z.EncFallback(yy802)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq791[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy804 := &x.LastTransitionTime
					yym805 := z.EncBinary()
					_ = yym805
					if false {
					} else if z.HasExtensions() && z.EncExt(yy804) {
					} else if yym805 {
						z.EncBinaryMarshal(yy804)
					} else if !yym805 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy804)
					} else {
						z.EncFallback(yy804)
					}
				}
			}
			if yyr791 || yy2arr791 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq791[4] {
					yym807 := z.EncBinary()
					_ = yym807
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq791[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym808 := z.EncBinary()
					_ = yym808
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr791 || yy2arr791 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq791[5] {
					yym810 := z.EncBinary()
					_ = yym810
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq791[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym811 := z.EncBinary()
					_ = yym811
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr791 || yy2arr791 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym812 := z.DecBinary()
	_ = yym812
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct813 := r.ContainerType()
		if yyct813 == codecSelferValueTypeMap1234 {
			yyl813 := r.ReadMapStart()
			if yyl813 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl813, d)
			}
		} else if yyct813 == codecSelferValueTypeArray1234 {
			yyl813 := r.ReadArrayStart()
			if yyl813 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl813, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys814Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys814Slc
	var yyhl814 bool = l >= 0
	for yyj814 := 0; ; yyj814++ {
		if yyhl814 {
			if yyj814 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys814Slc = r.DecodeBytes(yys814Slc, true, true)
		yys814 := string(yys814Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys814 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = JobConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
			}
		case "lastProbeTime":
			if r.TryDecodeAsNil() {
				x.LastProbeTime = pkg1_unversioned.Time{}
			} else {
				yyv817 := &x.LastProbeTime
				yym818 := z.DecBinary()
				_ = yym818
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv817) {
				} else if yym818 {
					z.DecBinaryUnmarshal(yyv817)
				} else if !yym818 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv817)
				} else {
					z.DecFallback(yyv817, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg1_unversioned.Time{}
			} else {
				yyv819 := &x.LastTransitionTime
				yym820 := z.DecBinary()
				_ = yym820
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv819) {
				} else if yym820 {
					z.DecBinaryUnmarshal(yyv819)
				} else if !yym820 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv819)
				} else {
					z.DecFallback(yyv819, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys814)
		} // end switch yys814
	} // end for yyj814
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj823 int
	var yyb823 bool
	var yyhl823 bool = l >= 0
	yyj823++
	if yyhl823 {
		yyb823 = yyj823 > l
	} else {
		yyb823 = r.CheckBreak()
	}
	if yyb823 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = JobConditionType(r.DecodeString())
	}
	yyj823++
	if yyhl823 {
		yyb823 = yyj823 > l
	} else {
		yyb823 = r.CheckBreak()
	}
	if yyb823 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
	}
	yyj823++
	if yyhl823 {
		yyb823 = yyj823 > l
	} else {
		yyb823 = r.CheckBreak()
	}
	if yyb823 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastProbeTime = pkg1_unversioned.Time{}
	} else {
		yyv826 := &x.LastProbeTime
		yym827 := z.DecBinary()
		_ = yym827
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv826) {
		} else if yym827 {
			z.DecBinaryUnmarshal(yyv826)
		} else if !yym827 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv826)
		} else {
			z.DecFallback(yyv826, false)
		}
	}
	yyj823++
	if yyhl823 {
		yyb823 = yyj823 > l
	} else {
		yyb823 = r.CheckBreak()
	}
	if yyb823 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg1_unversioned.Time{}
	} else {
		yyv828 := &x.LastTransitionTime
		yym829 := z.DecBinary()
		_ = yym829
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv828) {
		} else if yym829 {
			z.DecBinaryUnmarshal(yyv828)
		} else if !yym829 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv828)
		} else {
			z.DecFallback(yyv828, false)
		}
	}
	yyj823++
	if yyhl823 {
		yyb823 = yyj823 > l
	} else {
		yyb823 = r.CheckBreak()
	}
	if yyb823 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj823++
	if yyhl823 {
		yyb823 = yyj823 > l
	} else {
		yyb823 = r.CheckBreak()
	}
	if yyb823 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj823++
		if yyhl823 {
			yyb823 = yyj823 > l
		} else {
			yyb823 = r.CheckBreak()
		}
		if yyb823 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj823-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Ingress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym832 := z.EncBinary()
		_ = yym832
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep833 := !z.EncBinary()
			yy2arr833 := z.EncBasicHandle().StructToArray
			var yyq833 [5]bool
			_, _, _ = yysep833, yyq833, yy2arr833
			const yyr833 bool = false
			yyq833[0] = x.Kind != ""
			yyq833[1] = x.APIVersion != ""
			yyq833[2] = true
			yyq833[3] = true
			yyq833[4] = true
			var yynn833 int
			if yyr833 || yy2arr833 {
				r.EncodeArrayStart(5)
			} else {
				yynn833 = 0
				for _, b := range yyq833 {
					if b {
						yynn833++
					}
				}
				r.EncodeMapStart(yynn833)
				yynn833 = 0
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq833[0] {
					yym835 := z.EncBinary()
					_ = yym835
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq833[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym836 := z.EncBinary()
					_ = yym836
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq833[1] {
					yym838 := z.EncBinary()
					_ = yym838
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq833[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym839 := z.EncBinary()
					_ = yym839
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq833[2] {
					yy841 := &x.ObjectMeta
					yy841.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq833[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy842 := &x.ObjectMeta
					yy842.CodecEncodeSelf(e)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq833[3] {
					yy844 := &x.Spec
					yy844.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq833[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy845 := &x.Spec
					yy845.CodecEncodeSelf(e)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq833[4] {
					yy847 := &x.Status
					yy847.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq833[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy848 := &x.Status
					yy848.CodecEncodeSelf(e)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Ingress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym849 := z.DecBinary()
	_ = yym849
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct850 := r.ContainerType()
		if yyct850 == codecSelferValueTypeMap1234 {
			yyl850 := r.ReadMapStart()
			if yyl850 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl850, d)
			}
		} else if yyct850 == codecSelferValueTypeArray1234 {
			yyl850 := r.ReadArrayStart()
			if yyl850 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl850, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Ingress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys851Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys851Slc
	var yyhl851 bool = l >= 0
	for yyj851 := 0; ; yyj851++ {
		if yyhl851 {
			if yyj851 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys851Slc = r.DecodeBytes(yys851Slc, true, true)
		yys851 := string(yys851Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys851 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv854 := &x.ObjectMeta
				yyv854.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = IngressSpec{}
			} else {
				yyv855 := &x.Spec
				yyv855.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = IngressStatus{}
			} else {
				yyv856 := &x.Status
				yyv856.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys851)
		} // end switch yys851
	} // end for yyj851
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Ingress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj857 int
	var yyb857 bool
	var yyhl857 bool = l >= 0
	yyj857++
	if yyhl857 {
		yyb857 = yyj857 > l
	} else {
		yyb857 = r.CheckBreak()
	}
	if yyb857 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj857++
	if yyhl857 {
		yyb857 = yyj857 > l
	} else {
		yyb857 = r.CheckBreak()
	}
	if yyb857 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj857++
	if yyhl857 {
		yyb857 = yyj857 > l
	} else {
		yyb857 = r.CheckBreak()
	}
	if yyb857 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv860 := &x.ObjectMeta
		yyv860.CodecDecodeSelf(d)
	}
	yyj857++
	if yyhl857 {
		yyb857 = yyj857 > l
	} else {
		yyb857 = r.CheckBreak()
	}
	if yyb857 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = IngressSpec{}
	} else {
		yyv861 := &x.Spec
		yyv861.CodecDecodeSelf(d)
	}
	yyj857++
	if yyhl857 {
		yyb857 = yyj857 > l
	} else {
		yyb857 = r.CheckBreak()
	}
	if yyb857 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = IngressStatus{}
	} else {
		yyv862 := &x.Status
		yyv862.CodecDecodeSelf(d)
	}
	for {
		yyj857++
		if yyhl857 {
			yyb857 = yyj857 > l
		} else {
			yyb857 = r.CheckBreak()
		}
		if yyb857 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj857-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym863 := z.EncBinary()
		_ = yym863
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep864 := !z.EncBinary()
			yy2arr864 := z.EncBasicHandle().StructToArray
			var yyq864 [4]bool
			_, _, _ = yysep864, yyq864, yy2arr864
			const yyr864 bool = false
			yyq864[0] = x.Kind != ""
			yyq864[1] = x.APIVersion != ""
			yyq864[2] = true
			var yynn864 int
			if yyr864 || yy2arr864 {
				r.EncodeArrayStart(4)
			} else {
				yynn864 = 1
				for _, b := range yyq864 {
					if b {
						yynn864++
					}
				}
				r.EncodeMapStart(yynn864)
				yynn864 = 0
			}
			if yyr864 || yy2arr864 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq864[0] {
					yym866 := z.EncBinary()
					_ = yym866
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq864[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym867 := z.EncBinary()
					_ = yym867
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr864 || yy2arr864 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq864[1] {
					yym869 := z.EncBinary()
					_ = yym869
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq864[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym870 := z.EncBinary()
					_ = yym870
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr864 || yy2arr864 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq864[2] {
					yy872 := &x.ListMeta
					yym873 := z.EncBinary()
					_ = yym873
					if false {
					} else if z.HasExtensions() && z.EncExt(yy872) {
					} else {
						z.EncFallback(yy872)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq864[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy874 := &x.ListMeta
					yym875 := z.EncBinary()
					_ = yym875
					if false {
					} else if z.HasExtensions() && z.EncExt(yy874) {
					} else {
						z.EncFallback(yy874)
					}
				}
			}
			if yyr864 || yy2arr864 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym877 := z.EncBinary()
					_ = yym877
					if false {
					} else {
						h.encSliceIngress(([]Ingress)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym878 := z.EncBinary()
					_ = yym878
					if false {
					} else {
						h.encSliceIngress(([]Ingress)(x.Items), e)
					}
				}
			}
			if yyr864 || yy2arr864 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym879 := z.DecBinary()
	_ = yym879
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct880 := r.ContainerType()
		if yyct880 == codecSelferValueTypeMap1234 {
			yyl880 := r.ReadMapStart()
			if yyl880 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl880, d)
			}
		} else if yyct880 == codecSelferValueTypeArray1234 {
			yyl880 := r.ReadArrayStart()
			if yyl880 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl880, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys881Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys881Slc
	var yyhl881 bool = l >= 0
	for yyj881 := 0; ; yyj881++ {
		if yyhl881 {
			if yyj881 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys881Slc = r.DecodeBytes(yys881Slc, true, true)
		yys881 := string(yys881Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys881 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv884 := &x.ListMeta
				yym885 := z.DecBinary()
				_ = yym885
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv884) {
				} else {
					z.DecFallback(yyv884, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv886 := &x.Items
				yym887 := z.DecBinary()
				_ = yym887
				if false {
				} else {
					h.decSliceIngress((*[]Ingress)(yyv886), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys881)
		} // end switch yys881
	} // end for yyj881
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj888 int
	var yyb888 bool
	var yyhl888 bool = l >= 0
	yyj888++
	if yyhl888 {
		yyb888 = yyj888 > l
	} else {
		yyb888 = r.CheckBreak()
	}
	if yyb888 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj888++
	if yyhl888 {
		yyb888 = yyj888 > l
	} else {
		yyb888 = r.CheckBreak()
	}
	if yyb888 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj888++
	if yyhl888 {
		yyb888 = yyj888 > l
	} else {
		yyb888 = r.CheckBreak()
	}
	if yyb888 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv891 := &x.ListMeta
		yym892 := z.DecBinary()
		_ = yym892
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv891) {
		} else {
			z.DecFallback(yyv891, false)
		}
	}
	yyj888++
	if yyhl888 {
		yyb888 = yyj888 > l
	} else {
		yyb888 = r.CheckBreak()
	}
	if yyb888 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv893 := &x.Items
		yym894 := z.DecBinary()
		_ = yym894
		if false {
		} else {
			h.decSliceIngress((*[]Ingress)(yyv893), d)
		}
	}
	for {
		yyj888++
		if yyhl888 {
			yyb888 = yyj888 > l
		} else {
			yyb888 = r.CheckBreak()
		}
		if yyb888 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj888-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym895 := z.EncBinary()
		_ = yym895
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep896 := !z.EncBinary()
			yy2arr896 := z.EncBasicHandle().StructToArray
			var yyq896 [2]bool
			_, _, _ = yysep896, yyq896, yy2arr896
			const yyr896 bool = false
			yyq896[0] = x.Backend != nil
			yyq896[1] = len(x.Rules) != 0
			var yynn896 int
			if yyr896 || yy2arr896 {
				r.EncodeArrayStart(2)
			} else {
				yynn896 = 0
				for _, b := range yyq896 {
					if b {
						yynn896++
					}
				}
				r.EncodeMapStart(yynn896)
				yynn896 = 0
			}
			if yyr896 || yy2arr896 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq896[0] {
					if x.Backend == nil {
						r.EncodeNil()
					} else {
						x.Backend.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq896[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("backend"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Backend == nil {
						r.EncodeNil()
					} else {
						x.Backend.CodecEncodeSelf(e)
					}
				}
			}
			if yyr896 || yy2arr896 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq896[1] {
					if x.Rules == nil {
						r.EncodeNil()
					} else {
						yym899 := z.EncBinary()
						_ = yym899
						if false {
						} else {
							h.encSliceIngressRule(([]IngressRule)(x.Rules), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq896[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rules"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Rules == nil {
						r.EncodeNil()
					} else {
						yym900 := z.EncBinary()
						_ = yym900
						if false {
						} else {
							h.encSliceIngressRule(([]IngressRule)(x.Rules), e)
						}
					}
				}
			}
			if yyr896 || yy2arr896 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym901 := z.DecBinary()
	_ = yym901
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct902 := r.ContainerType()
		if yyct902 == codecSelferValueTypeMap1234 {
			yyl902 := r.ReadMapStart()
			if yyl902 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl902, d)
			}
		} else if yyct902 == codecSelferValueTypeArray1234 {
			yyl902 := r.ReadArrayStart()
			if yyl902 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl902, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys903Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys903Slc
	var yyhl903 bool = l >= 0
	for yyj903 := 0; ; yyj903++ {
		if yyhl903 {
			if yyj903 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys903Slc = r.DecodeBytes(yys903Slc, true, true)
		yys903 := string(yys903Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys903 {
		case "backend":
			if r.TryDecodeAsNil() {
				if x.Backend != nil {
					x.Backend = nil
				}
			} else {
				if x.Backend == nil {
					x.Backend = new(IngressBackend)
				}
				x.Backend.CodecDecodeSelf(d)
			}
		case "rules":
			if r.TryDecodeAsNil() {
				x.Rules = nil
			} else {
				yyv905 := &x.Rules
				yym906 := z.DecBinary()
				_ = yym906
				if false {
				} else {
					h.decSliceIngressRule((*[]IngressRule)(yyv905), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys903)
		} // end switch yys903
	} // end for yyj903
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj907 int
	var yyb907 bool
	var yyhl907 bool = l >= 0
	yyj907++
	if yyhl907 {
		yyb907 = yyj907 > l
	} else {
		yyb907 = r.CheckBreak()
	}
	if yyb907 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Backend != nil {
			x.Backend = nil
		}
	} else {
		if x.Backend == nil {
			x.Backend = new(IngressBackend)
		}
		x.Backend.CodecDecodeSelf(d)
	}
	yyj907++
	if yyhl907 {
		yyb907 = yyj907 > l
	} else {
		yyb907 = r.CheckBreak()
	}
	if yyb907 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rules = nil
	} else {
		yyv909 := &x.Rules
		yym910 := z.DecBinary()
		_ = yym910
		if false {
		} else {
			h.decSliceIngressRule((*[]IngressRule)(yyv909), d)
		}
	}
	for {
		yyj907++
		if yyhl907 {
			yyb907 = yyj907 > l
		} else {
			yyb907 = r.CheckBreak()
		}
		if yyb907 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj907-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym911 := z.EncBinary()
		_ = yym911
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep912 := !z.EncBinary()
			yy2arr912 := z.EncBasicHandle().StructToArray
			var yyq912 [1]bool
			_, _, _ = yysep912, yyq912, yy2arr912
			const yyr912 bool = false
			yyq912[0] = true
			var yynn912 int
			if yyr912 || yy2arr912 {
				r.EncodeArrayStart(1)
			} else {
				yynn912 = 0
				for _, b := range yyq912 {
					if b {
						yynn912++
					}
				}
				r.EncodeMapStart(yynn912)
				yynn912 = 0
			}
			if yyr912 || yy2arr912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq912[0] {
					yy914 := &x.LoadBalancer
					yy914.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq912[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancer"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy915 := &x.LoadBalancer
					yy915.CodecEncodeSelf(e)
				}
			}
			if yyr912 || yy2arr912 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym916 := z.DecBinary()
	_ = yym916
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct917 := r.ContainerType()
		if yyct917 == codecSelferValueTypeMap1234 {
			yyl917 := r.ReadMapStart()
			if yyl917 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl917, d)
			}
		} else if yyct917 == codecSelferValueTypeArray1234 {
			yyl917 := r.ReadArrayStart()
			if yyl917 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl917, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys918Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys918Slc
	var yyhl918 bool = l >= 0
	for yyj918 := 0; ; yyj918++ {
		if yyhl918 {
			if yyj918 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys918Slc = r.DecodeBytes(yys918Slc, true, true)
		yys918 := string(yys918Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys918 {
		case "loadBalancer":
			if r.TryDecodeAsNil() {
				x.LoadBalancer = pkg2_v1.LoadBalancerStatus{}
			} else {
				yyv919 := &x.LoadBalancer
				yyv919.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys918)
		} // end switch yys918
	} // end for yyj918
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj920 int
	var yyb920 bool
	var yyhl920 bool = l >= 0
	yyj920++
	if yyhl920 {
		yyb920 = yyj920 > l
	} else {
		yyb920 = r.CheckBreak()
	}
	if yyb920 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancer = pkg2_v1.LoadBalancerStatus{}
	} else {
		yyv921 := &x.LoadBalancer
		yyv921.CodecDecodeSelf(d)
	}
	for {
		yyj920++
		if yyhl920 {
			yyb920 = yyj920 > l
		} else {
			yyb920 = r.CheckBreak()
		}
		if yyb920 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj920-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressRule) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym922 := z.EncBinary()
		_ = yym922
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep923 := !z.EncBinary()
			yy2arr923 := z.EncBasicHandle().StructToArray
			var yyq923 [2]bool
			_, _, _ = yysep923, yyq923, yy2arr923
			const yyr923 bool = false
			yyq923[0] = x.Host != ""
			yyq923[1] = x.IngressRuleValue.HTTP != nil && x.HTTP != nil
			var yynn923 int
			if yyr923 || yy2arr923 {
				r.EncodeArrayStart(2)
			} else {
				yynn923 = 0
				for _, b := range yyq923 {
					if b {
						yynn923++
					}
				}
				r.EncodeMapStart(yynn923)
				yynn923 = 0
			}
			if yyr923 || yy2arr923 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq923[0] {
					yym925 := z.EncBinary()
					_ = yym925
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq923[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym926 := z.EncBinary()
					_ = yym926
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			var yyn927 bool
			if x.IngressRuleValue.HTTP == nil {
				yyn927 = true
				goto LABEL927
			}
		LABEL927:
			if yyr923 || yy2arr923 {
				if yyn927 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq923[1] {
						if x.HTTP == nil {
							r.EncodeNil()
						} else {
							x.HTTP.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq923[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("http"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn927 {
						r.EncodeNil()
					} else {
						if x.HTTP == nil {
							r.EncodeNil()
						} else {
							x.HTTP.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr923 || yy2arr923 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressRule) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym928 := z.DecBinary()
	_ = yym928
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct929 := r.ContainerType()
		if yyct929 == codecSelferValueTypeMap1234 {
			yyl929 := r.ReadMapStart()
			if yyl929 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl929, d)
			}
		} else if yyct929 == codecSelferValueTypeArray1234 {
			yyl929 := r.ReadArrayStart()
			if yyl929 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl929, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressRule) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys930Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys930Slc
	var yyhl930 bool = l >= 0
	for yyj930 := 0; ; yyj930++ {
		if yyhl930 {
			if yyj930 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys930Slc = r.DecodeBytes(yys930Slc, true, true)
		yys930 := string(yys930Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys930 {
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				x.Host = string(r.DecodeString())
			}
		case "http":
			if x.IngressRuleValue.HTTP == nil {
				x.IngressRuleValue.HTTP = new(HTTPIngressRuleValue)
			}
			if r.TryDecodeAsNil() {
				if x.HTTP != nil {
					x.HTTP = nil
				}
			} else {
				if x.HTTP == nil {
					x.HTTP = new(HTTPIngressRuleValue)
				}
				x.HTTP.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys930)
		} // end switch yys930
	} // end for yyj930
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressRule) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj933 int
	var yyb933 bool
	var yyhl933 bool = l >= 0
	yyj933++
	if yyhl933 {
		yyb933 = yyj933 > l
	} else {
		yyb933 = r.CheckBreak()
	}
	if yyb933 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		x.Host = string(r.DecodeString())
	}
	if x.IngressRuleValue.HTTP == nil {
		x.IngressRuleValue.HTTP = new(HTTPIngressRuleValue)
	}
	yyj933++
	if yyhl933 {
		yyb933 = yyj933 > l
	} else {
		yyb933 = r.CheckBreak()
	}
	if yyb933 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTP != nil {
			x.HTTP = nil
		}
	} else {
		if x.HTTP == nil {
			x.HTTP = new(HTTPIngressRuleValue)
		}
		x.HTTP.CodecDecodeSelf(d)
	}
	for {
		yyj933++
		if yyhl933 {
			yyb933 = yyj933 > l
		} else {
			yyb933 = r.CheckBreak()
		}
		if yyb933 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj933-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressRuleValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym936 := z.EncBinary()
		_ = yym936
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep937 := !z.EncBinary()
			yy2arr937 := z.EncBasicHandle().StructToArray
			var yyq937 [1]bool
			_, _, _ = yysep937, yyq937, yy2arr937
			const yyr937 bool = false
			yyq937[0] = x.HTTP != nil
			var yynn937 int
			if yyr937 || yy2arr937 {
				r.EncodeArrayStart(1)
			} else {
				yynn937 = 0
				for _, b := range yyq937 {
					if b {
						yynn937++
					}
				}
				r.EncodeMapStart(yynn937)
				yynn937 = 0
			}
			if yyr937 || yy2arr937 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq937[0] {
					if x.HTTP == nil {
						r.EncodeNil()
					} else {
						x.HTTP.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq937[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("http"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTP == nil {
						r.EncodeNil()
					} else {
						x.HTTP.CodecEncodeSelf(e)
					}
				}
			}
			if yyr937 || yy2arr937 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressRuleValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym939 := z.DecBinary()
	_ = yym939
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct940 := r.ContainerType()
		if yyct940 == codecSelferValueTypeMap1234 {
			yyl940 := r.ReadMapStart()
			if yyl940 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl940, d)
			}
		} else if yyct940 == codecSelferValueTypeArray1234 {
			yyl940 := r.ReadArrayStart()
			if yyl940 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl940, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressRuleValue) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys941Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys941Slc
	var yyhl941 bool = l >= 0
	for yyj941 := 0; ; yyj941++ {
		if yyhl941 {
			if yyj941 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys941Slc = r.DecodeBytes(yys941Slc, true, true)
		yys941 := string(yys941Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys941 {
		case "http":
			if r.TryDecodeAsNil() {
				if x.HTTP != nil {
					x.HTTP = nil
				}
			} else {
				if x.HTTP == nil {
					x.HTTP = new(HTTPIngressRuleValue)
				}
				x.HTTP.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys941)
		} // end switch yys941
	} // end for yyj941
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressRuleValue) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj943 int
	var yyb943 bool
	var yyhl943 bool = l >= 0
	yyj943++
	if yyhl943 {
		yyb943 = yyj943 > l
	} else {
		yyb943 = r.CheckBreak()
	}
	if yyb943 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTP != nil {
			x.HTTP = nil
		}
	} else {
		if x.HTTP == nil {
			x.HTTP = new(HTTPIngressRuleValue)
		}
		x.HTTP.CodecDecodeSelf(d)
	}
	for {
		yyj943++
		if yyhl943 {
			yyb943 = yyj943 > l
		} else {
			yyb943 = r.CheckBreak()
		}
		if yyb943 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj943-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPIngressRuleValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym945 := z.EncBinary()
		_ = yym945
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep946 := !z.EncBinary()
			yy2arr946 := z.EncBasicHandle().StructToArray
			var yyq946 [1]bool
			_, _, _ = yysep946, yyq946, yy2arr946
			const yyr946 bool = false
			var yynn946 int
			if yyr946 || yy2arr946 {
				r.EncodeArrayStart(1)
			} else {
				yynn946 = 1
				for _, b := range yyq946 {
					if b {
						yynn946++
					}
				}
				r.EncodeMapStart(yynn946)
				yynn946 = 0
			}
			if yyr946 || yy2arr946 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Paths == nil {
					r.EncodeNil()
				} else {
					yym948 := z.EncBinary()
					_ = yym948
					if false {
					} else {
						h.encSliceHTTPIngressPath(([]HTTPIngressPath)(x.Paths), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("paths"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Paths == nil {
					r.EncodeNil()
				} else {
					yym949 := z.EncBinary()
					_ = yym949
					if false {
					} else {
						h.encSliceHTTPIngressPath(([]HTTPIngressPath)(x.Paths), e)
					}
				}
			}
			if yyr946 || yy2arr946 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPIngressRuleValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym950 := z.DecBinary()
	_ = yym950
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct951 := r.ContainerType()
		if yyct951 == codecSelferValueTypeMap1234 {
			yyl951 := r.ReadMapStart()
			if yyl951 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl951, d)
			}
		} else if yyct951 == codecSelferValueTypeArray1234 {
			yyl951 := r.ReadArrayStart()
			if yyl951 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl951, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPIngressRuleValue) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys952Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys952Slc
	var yyhl952 bool = l >= 0
	for yyj952 := 0; ; yyj952++ {
		if yyhl952 {
			if yyj952 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys952Slc = r.DecodeBytes(yys952Slc, true, true)
		yys952 := string(yys952Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys952 {
		case "paths":
			if r.TryDecodeAsNil() {
				x.Paths = nil
			} else {
				yyv953 := &x.Paths
				yym954 := z.DecBinary()
				_ = yym954
				if false {
				} else {
					h.decSliceHTTPIngressPath((*[]HTTPIngressPath)(yyv953), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys952)
		} // end switch yys952
	} // end for yyj952
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPIngressRuleValue) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj955 int
	var yyb955 bool
	var yyhl955 bool = l >= 0
	yyj955++
	if yyhl955 {
		yyb955 = yyj955 > l
	} else {
		yyb955 = r.CheckBreak()
	}
	if yyb955 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Paths = nil
	} else {
		yyv956 := &x.Paths
		yym957 := z.DecBinary()
		_ = yym957
		if false {
		} else {
			h.decSliceHTTPIngressPath((*[]HTTPIngressPath)(yyv956), d)
		}
	}
	for {
		yyj955++
		if yyhl955 {
			yyb955 = yyj955 > l
		} else {
			yyb955 = r.CheckBreak()
		}
		if yyb955 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj955-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPIngressPath) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym958 := z.EncBinary()
		_ = yym958
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep959 := !z.EncBinary()
			yy2arr959 := z.EncBasicHandle().StructToArray
			var yyq959 [2]bool
			_, _, _ = yysep959, yyq959, yy2arr959
			const yyr959 bool = false
			yyq959[0] = x.Path != ""
			var yynn959 int
			if yyr959 || yy2arr959 {
				r.EncodeArrayStart(2)
			} else {
				yynn959 = 1
				for _, b := range yyq959 {
					if b {
						yynn959++
					}
				}
				r.EncodeMapStart(yynn959)
				yynn959 = 0
			}
			if yyr959 || yy2arr959 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq959[0] {
					yym961 := z.EncBinary()
					_ = yym961
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq959[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym962 := z.EncBinary()
					_ = yym962
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr959 || yy2arr959 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy964 := &x.Backend
				yy964.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("backend"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy965 := &x.Backend
				yy965.CodecEncodeSelf(e)
			}
			if yyr959 || yy2arr959 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPIngressPath) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym966 := z.DecBinary()
	_ = yym966
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct967 := r.ContainerType()
		if yyct967 == codecSelferValueTypeMap1234 {
			yyl967 := r.ReadMapStart()
			if yyl967 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl967, d)
			}
		} else if yyct967 == codecSelferValueTypeArray1234 {
			yyl967 := r.ReadArrayStart()
			if yyl967 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl967, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPIngressPath) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys968Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys968Slc
	var yyhl968 bool = l >= 0
	for yyj968 := 0; ; yyj968++ {
		if yyhl968 {
			if yyj968 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys968Slc = r.DecodeBytes(yys968Slc, true, true)
		yys968 := string(yys968Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys968 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "backend":
			if r.TryDecodeAsNil() {
				x.Backend = IngressBackend{}
			} else {
				yyv970 := &x.Backend
				yyv970.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys968)
		} // end switch yys968
	} // end for yyj968
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPIngressPath) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj971 int
	var yyb971 bool
	var yyhl971 bool = l >= 0
	yyj971++
	if yyhl971 {
		yyb971 = yyj971 > l
	} else {
		yyb971 = r.CheckBreak()
	}
	if yyb971 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj971++
	if yyhl971 {
		yyb971 = yyj971 > l
	} else {
		yyb971 = r.CheckBreak()
	}
	if yyb971 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Backend = IngressBackend{}
	} else {
		yyv973 := &x.Backend
		yyv973.CodecDecodeSelf(d)
	}
	for {
		yyj971++
		if yyhl971 {
			yyb971 = yyj971 > l
		} else {
			yyb971 = r.CheckBreak()
		}
		if yyb971 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj971-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressBackend) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym974 := z.EncBinary()
		_ = yym974
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep975 := !z.EncBinary()
			yy2arr975 := z.EncBasicHandle().StructToArray
			var yyq975 [2]bool
			_, _, _ = yysep975, yyq975, yy2arr975
			const yyr975 bool = false
			var yynn975 int
			if yyr975 || yy2arr975 {
				r.EncodeArrayStart(2)
			} else {
				yynn975 = 2
				for _, b := range yyq975 {
					if b {
						yynn975++
					}
				}
				r.EncodeMapStart(yynn975)
				yynn975 = 0
			}
			if yyr975 || yy2arr975 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym977 := z.EncBinary()
				_ = yym977
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym978 := z.EncBinary()
				_ = yym978
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceName))
				}
			}
			if yyr975 || yy2arr975 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy980 := &x.ServicePort
				yym981 := z.EncBinary()
				_ = yym981
				if false {
				} else if z.HasExtensions() && z.EncExt(yy980) {
				} else if !yym981 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy980)
				} else {
					z.EncFallback(yy980)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("servicePort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy982 := &x.ServicePort
				yym983 := z.EncBinary()
				_ = yym983
				if false {
				} else if z.HasExtensions() && z.EncExt(yy982) {
				} else if !yym983 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy982)
				} else {
					z.EncFallback(yy982)
				}
			}
			if yyr975 || yy2arr975 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressBackend) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym984 := z.DecBinary()
	_ = yym984
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct985 := r.ContainerType()
		if yyct985 == codecSelferValueTypeMap1234 {
			yyl985 := r.ReadMapStart()
			if yyl985 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl985, d)
			}
		} else if yyct985 == codecSelferValueTypeArray1234 {
			yyl985 := r.ReadArrayStart()
			if yyl985 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl985, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressBackend) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys986Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys986Slc
	var yyhl986 bool = l >= 0
	for yyj986 := 0; ; yyj986++ {
		if yyhl986 {
			if yyj986 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys986Slc = r.DecodeBytes(yys986Slc, true, true)
		yys986 := string(yys986Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys986 {
		case "serviceName":
			if r.TryDecodeAsNil() {
				x.ServiceName = ""
			} else {
				x.ServiceName = string(r.DecodeString())
			}
		case "servicePort":
			if r.TryDecodeAsNil() {
				x.ServicePort = pkg6_intstr.IntOrString{}
			} else {
				yyv988 := &x.ServicePort
				yym989 := z.DecBinary()
				_ = yym989
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv988) {
				} else if !yym989 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv988)
				} else {
					z.DecFallback(yyv988, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys986)
		} // end switch yys986
	} // end for yyj986
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressBackend) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj990 int
	var yyb990 bool
	var yyhl990 bool = l >= 0
	yyj990++
	if yyhl990 {
		yyb990 = yyj990 > l
	} else {
		yyb990 = r.CheckBreak()
	}
	if yyb990 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceName = ""
	} else {
		x.ServiceName = string(r.DecodeString())
	}
	yyj990++
	if yyhl990 {
		yyb990 = yyj990 > l
	} else {
		yyb990 = r.CheckBreak()
	}
	if yyb990 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServicePort = pkg6_intstr.IntOrString{}
	} else {
		yyv992 := &x.ServicePort
		yym993 := z.DecBinary()
		_ = yym993
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv992) {
		} else if !yym993 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv992)
		} else {
			z.DecFallback(yyv992, false)
		}
	}
	for {
		yyj990++
		if yyhl990 {
			yyb990 = yyj990 > l
		} else {
			yyb990 = r.CheckBreak()
		}
		if yyb990 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj990-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodeResource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym994 := z.EncBinary()
	_ = yym994
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeResource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym995 := z.DecBinary()
	_ = yym995
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NodeUtilization) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym996 := z.EncBinary()
		_ = yym996
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep997 := !z.EncBinary()
			yy2arr997 := z.EncBasicHandle().StructToArray
			var yyq997 [2]bool
			_, _, _ = yysep997, yyq997, yy2arr997
			const yyr997 bool = false
			var yynn997 int
			if yyr997 || yy2arr997 {
				r.EncodeArrayStart(2)
			} else {
				yynn997 = 2
				for _, b := range yyq997 {
					if b {
						yynn997++
					}
				}
				r.EncodeMapStart(yynn997)
				yynn997 = 0
			}
			if yyr997 || yy2arr997 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Resource.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resource"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Resource.CodecEncodeSelf(e)
			}
			if yyr997 || yy2arr997 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1000 := z.EncBinary()
				_ = yym1000
				if false {
				} else {
					r.EncodeFloat64(float64(x.Value))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1001 := z.EncBinary()
				_ = yym1001
				if false {
				} else {
					r.EncodeFloat64(float64(x.Value))
				}
			}
			if yyr997 || yy2arr997 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeUtilization) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1002 := z.DecBinary()
	_ = yym1002
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1003 := r.ContainerType()
		if yyct1003 == codecSelferValueTypeMap1234 {
			yyl1003 := r.ReadMapStart()
			if yyl1003 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1003, d)
			}
		} else if yyct1003 == codecSelferValueTypeArray1234 {
			yyl1003 := r.ReadArrayStart()
			if yyl1003 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1003, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeUtilization) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1004Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1004Slc
	var yyhl1004 bool = l >= 0
	for yyj1004 := 0; ; yyj1004++ {
		if yyhl1004 {
			if yyj1004 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1004Slc = r.DecodeBytes(yys1004Slc, true, true)
		yys1004 := string(yys1004Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1004 {
		case "resource":
			if r.TryDecodeAsNil() {
				x.Resource = ""
			} else {
				x.Resource = NodeResource(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = 0
			} else {
				x.Value = float64(r.DecodeFloat(false))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1004)
		} // end switch yys1004
	} // end for yyj1004
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeUtilization) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1007 int
	var yyb1007 bool
	var yyhl1007 bool = l >= 0
	yyj1007++
	if yyhl1007 {
		yyb1007 = yyj1007 > l
	} else {
		yyb1007 = r.CheckBreak()
	}
	if yyb1007 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resource = ""
	} else {
		x.Resource = NodeResource(r.DecodeString())
	}
	yyj1007++
	if yyhl1007 {
		yyb1007 = yyj1007 > l
	} else {
		yyb1007 = r.CheckBreak()
	}
	if yyb1007 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = 0
	} else {
		x.Value = float64(r.DecodeFloat(false))
	}
	for {
		yyj1007++
		if yyhl1007 {
			yyb1007 = yyj1007 > l
		} else {
			yyb1007 = r.CheckBreak()
		}
		if yyb1007 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1007-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ClusterAutoscalerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1010 := z.EncBinary()
		_ = yym1010
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1011 := !z.EncBinary()
			yy2arr1011 := z.EncBasicHandle().StructToArray
			var yyq1011 [3]bool
			_, _, _ = yysep1011, yyq1011, yy2arr1011
			const yyr1011 bool = false
			var yynn1011 int
			if yyr1011 || yy2arr1011 {
				r.EncodeArrayStart(3)
			} else {
				yynn1011 = 3
				for _, b := range yyq1011 {
					if b {
						yynn1011++
					}
				}
				r.EncodeMapStart(yynn1011)
				yynn1011 = 0
			}
			if yyr1011 || yy2arr1011 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1013 := z.EncBinary()
				_ = yym1013
				if false {
				} else {
					r.EncodeInt(int64(x.MinNodes))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minNodes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1014 := z.EncBinary()
				_ = yym1014
				if false {
				} else {
					r.EncodeInt(int64(x.MinNodes))
				}
			}
			if yyr1011 || yy2arr1011 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1016 := z.EncBinary()
				_ = yym1016
				if false {
				} else {
					r.EncodeInt(int64(x.MaxNodes))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxNodes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1017 := z.EncBinary()
				_ = yym1017
				if false {
				} else {
					r.EncodeInt(int64(x.MaxNodes))
				}
			}
			if yyr1011 || yy2arr1011 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.TargetUtilization == nil {
					r.EncodeNil()
				} else {
					yym1019 := z.EncBinary()
					_ = yym1019
					if false {
					} else {
						h.encSliceNodeUtilization(([]NodeUtilization)(x.TargetUtilization), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("target"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.TargetUtilization == nil {
					r.EncodeNil()
				} else {
					yym1020 := z.EncBinary()
					_ = yym1020
					if false {
					} else {
						h.encSliceNodeUtilization(([]NodeUtilization)(x.TargetUtilization), e)
					}
				}
			}
			if yyr1011 || yy2arr1011 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ClusterAutoscalerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1021 := z.DecBinary()
	_ = yym1021
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1022 := r.ContainerType()
		if yyct1022 == codecSelferValueTypeMap1234 {
			yyl1022 := r.ReadMapStart()
			if yyl1022 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1022, d)
			}
		} else if yyct1022 == codecSelferValueTypeArray1234 {
			yyl1022 := r.ReadArrayStart()
			if yyl1022 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1022, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ClusterAutoscalerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1023Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1023Slc
	var yyhl1023 bool = l >= 0
	for yyj1023 := 0; ; yyj1023++ {
		if yyhl1023 {
			if yyj1023 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1023Slc = r.DecodeBytes(yys1023Slc, true, true)
		yys1023 := string(yys1023Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1023 {
		case "minNodes":
			if r.TryDecodeAsNil() {
				x.MinNodes = 0
			} else {
				x.MinNodes = int32(r.DecodeInt(32))
			}
		case "maxNodes":
			if r.TryDecodeAsNil() {
				x.MaxNodes = 0
			} else {
				x.MaxNodes = int32(r.DecodeInt(32))
			}
		case "target":
			if r.TryDecodeAsNil() {
				x.TargetUtilization = nil
			} else {
				yyv1026 := &x.TargetUtilization
				yym1027 := z.DecBinary()
				_ = yym1027
				if false {
				} else {
					h.decSliceNodeUtilization((*[]NodeUtilization)(yyv1026), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1023)
		} // end switch yys1023
	} // end for yyj1023
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ClusterAutoscalerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1028 int
	var yyb1028 bool
	var yyhl1028 bool = l >= 0
	yyj1028++
	if yyhl1028 {
		yyb1028 = yyj1028 > l
	} else {
		yyb1028 = r.CheckBreak()
	}
	if yyb1028 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinNodes = 0
	} else {
		x.MinNodes = int32(r.DecodeInt(32))
	}
	yyj1028++
	if yyhl1028 {
		yyb1028 = yyj1028 > l
	} else {
		yyb1028 = r.CheckBreak()
	}
	if yyb1028 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxNodes = 0
	} else {
		x.MaxNodes = int32(r.DecodeInt(32))
	}
	yyj1028++
	if yyhl1028 {
		yyb1028 = yyj1028 > l
	} else {
		yyb1028 = r.CheckBreak()
	}
	if yyb1028 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetUtilization = nil
	} else {
		yyv1031 := &x.TargetUtilization
		yym1032 := z.DecBinary()
		_ = yym1032
		if false {
		} else {
			h.decSliceNodeUtilization((*[]NodeUtilization)(yyv1031), d)
		}
	}
	for {
		yyj1028++
		if yyhl1028 {
			yyb1028 = yyj1028 > l
		} else {
			yyb1028 = r.CheckBreak()
		}
		if yyb1028 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1028-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ClusterAutoscaler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1033 := z.EncBinary()
		_ = yym1033
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1034 := !z.EncBinary()
			yy2arr1034 := z.EncBasicHandle().StructToArray
			var yyq1034 [4]bool
			_, _, _ = yysep1034, yyq1034, yy2arr1034
			const yyr1034 bool = false
			yyq1034[0] = x.Kind != ""
			yyq1034[1] = x.APIVersion != ""
			yyq1034[2] = true
			yyq1034[3] = true
			var yynn1034 int
			if yyr1034 || yy2arr1034 {
				r.EncodeArrayStart(4)
			} else {
				yynn1034 = 0
				for _, b := range yyq1034 {
					if b {
						yynn1034++
					}
				}
				r.EncodeMapStart(yynn1034)
				yynn1034 = 0
			}
			if yyr1034 || yy2arr1034 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1034[0] {
					yym1036 := z.EncBinary()
					_ = yym1036
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1034[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1037 := z.EncBinary()
					_ = yym1037
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1034 || yy2arr1034 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1034[1] {
					yym1039 := z.EncBinary()
					_ = yym1039
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1034[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1040 := z.EncBinary()
					_ = yym1040
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1034 || yy2arr1034 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1034[2] {
					yy1042 := &x.ObjectMeta
					yy1042.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1034[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1043 := &x.ObjectMeta
					yy1043.CodecEncodeSelf(e)
				}
			}
			if yyr1034 || yy2arr1034 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1034[3] {
					yy1045 := &x.Spec
					yy1045.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1034[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1046 := &x.Spec
					yy1046.CodecEncodeSelf(e)
				}
			}
			if yyr1034 || yy2arr1034 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ClusterAutoscaler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1047 := z.DecBinary()
	_ = yym1047
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1048 := r.ContainerType()
		if yyct1048 == codecSelferValueTypeMap1234 {
			yyl1048 := r.ReadMapStart()
			if yyl1048 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1048, d)
			}
		} else if yyct1048 == codecSelferValueTypeArray1234 {
			yyl1048 := r.ReadArrayStart()
			if yyl1048 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1048, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ClusterAutoscaler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1049Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1049Slc
	var yyhl1049 bool = l >= 0
	for yyj1049 := 0; ; yyj1049++ {
		if yyhl1049 {
			if yyj1049 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1049Slc = r.DecodeBytes(yys1049Slc, true, true)
		yys1049 := string(yys1049Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1049 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv1052 := &x.ObjectMeta
				yyv1052.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ClusterAutoscalerSpec{}
			} else {
				yyv1053 := &x.Spec
				yyv1053.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1049)
		} // end switch yys1049
	} // end for yyj1049
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ClusterAutoscaler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1054 int
	var yyb1054 bool
	var yyhl1054 bool = l >= 0
	yyj1054++
	if yyhl1054 {
		yyb1054 = yyj1054 > l
	} else {
		yyb1054 = r.CheckBreak()
	}
	if yyb1054 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1054++
	if yyhl1054 {
		yyb1054 = yyj1054 > l
	} else {
		yyb1054 = r.CheckBreak()
	}
	if yyb1054 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1054++
	if yyhl1054 {
		yyb1054 = yyj1054 > l
	} else {
		yyb1054 = r.CheckBreak()
	}
	if yyb1054 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv1057 := &x.ObjectMeta
		yyv1057.CodecDecodeSelf(d)
	}
	yyj1054++
	if yyhl1054 {
		yyb1054 = yyj1054 > l
	} else {
		yyb1054 = r.CheckBreak()
	}
	if yyb1054 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ClusterAutoscalerSpec{}
	} else {
		yyv1058 := &x.Spec
		yyv1058.CodecDecodeSelf(d)
	}
	for {
		yyj1054++
		if yyhl1054 {
			yyb1054 = yyj1054 > l
		} else {
			yyb1054 = r.CheckBreak()
		}
		if yyb1054 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1054-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ClusterAutoscalerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1059 := z.EncBinary()
		_ = yym1059
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1060 := !z.EncBinary()
			yy2arr1060 := z.EncBasicHandle().StructToArray
			var yyq1060 [4]bool
			_, _, _ = yysep1060, yyq1060, yy2arr1060
			const yyr1060 bool = false
			yyq1060[0] = x.Kind != ""
			yyq1060[1] = x.APIVersion != ""
			yyq1060[2] = true
			var yynn1060 int
			if yyr1060 || yy2arr1060 {
				r.EncodeArrayStart(4)
			} else {
				yynn1060 = 1
				for _, b := range yyq1060 {
					if b {
						yynn1060++
					}
				}
				r.EncodeMapStart(yynn1060)
				yynn1060 = 0
			}
			if yyr1060 || yy2arr1060 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1060[0] {
					yym1062 := z.EncBinary()
					_ = yym1062
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1060[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1063 := z.EncBinary()
					_ = yym1063
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1060 || yy2arr1060 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1060[1] {
					yym1065 := z.EncBinary()
					_ = yym1065
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1060[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1066 := z.EncBinary()
					_ = yym1066
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1060 || yy2arr1060 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1060[2] {
					yy1068 := &x.ListMeta
					yym1069 := z.EncBinary()
					_ = yym1069
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1068) {
					} else {
						z.EncFallback(yy1068)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1060[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1070 := &x.ListMeta
					yym1071 := z.EncBinary()
					_ = yym1071
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1070) {
					} else {
						z.EncFallback(yy1070)
					}
				}
			}
			if yyr1060 || yy2arr1060 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1073 := z.EncBinary()
					_ = yym1073
					if false {
					} else {
						h.encSliceClusterAutoscaler(([]ClusterAutoscaler)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1074 := z.EncBinary()
					_ = yym1074
					if false {
					} else {
						h.encSliceClusterAutoscaler(([]ClusterAutoscaler)(x.Items), e)
					}
				}
			}
			if yyr1060 || yy2arr1060 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ClusterAutoscalerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1075 := z.DecBinary()
	_ = yym1075
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1076 := r.ContainerType()
		if yyct1076 == codecSelferValueTypeMap1234 {
			yyl1076 := r.ReadMapStart()
			if yyl1076 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1076, d)
			}
		} else if yyct1076 == codecSelferValueTypeArray1234 {
			yyl1076 := r.ReadArrayStart()
			if yyl1076 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1076, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ClusterAutoscalerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1077Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1077Slc
	var yyhl1077 bool = l >= 0
	for yyj1077 := 0; ; yyj1077++ {
		if yyhl1077 {
			if yyj1077 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1077Slc = r.DecodeBytes(yys1077Slc, true, true)
		yys1077 := string(yys1077Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1077 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1080 := &x.ListMeta
				yym1081 := z.DecBinary()
				_ = yym1081
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1080) {
				} else {
					z.DecFallback(yyv1080, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1082 := &x.Items
				yym1083 := z.DecBinary()
				_ = yym1083
				if false {
				} else {
					h.decSliceClusterAutoscaler((*[]ClusterAutoscaler)(yyv1082), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1077)
		} // end switch yys1077
	} // end for yyj1077
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ClusterAutoscalerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1084 int
	var yyb1084 bool
	var yyhl1084 bool = l >= 0
	yyj1084++
	if yyhl1084 {
		yyb1084 = yyj1084 > l
	} else {
		yyb1084 = r.CheckBreak()
	}
	if yyb1084 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1084++
	if yyhl1084 {
		yyb1084 = yyj1084 > l
	} else {
		yyb1084 = r.CheckBreak()
	}
	if yyb1084 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1084++
	if yyhl1084 {
		yyb1084 = yyj1084 > l
	} else {
		yyb1084 = r.CheckBreak()
	}
	if yyb1084 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1087 := &x.ListMeta
		yym1088 := z.DecBinary()
		_ = yym1088
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1087) {
		} else {
			z.DecFallback(yyv1087, false)
		}
	}
	yyj1084++
	if yyhl1084 {
		yyb1084 = yyj1084 > l
	} else {
		yyb1084 = r.CheckBreak()
	}
	if yyb1084 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1089 := &x.Items
		yym1090 := z.DecBinary()
		_ = yym1090
		if false {
		} else {
			h.decSliceClusterAutoscaler((*[]ClusterAutoscaler)(yyv1089), d)
		}
	}
	for {
		yyj1084++
		if yyhl1084 {
			yyb1084 = yyj1084 > l
		} else {
			yyb1084 = r.CheckBreak()
		}
		if yyb1084 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1084-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ExportOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1091 := z.EncBinary()
		_ = yym1091
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1092 := !z.EncBinary()
			yy2arr1092 := z.EncBasicHandle().StructToArray
			var yyq1092 [4]bool
			_, _, _ = yysep1092, yyq1092, yy2arr1092
			const yyr1092 bool = false
			yyq1092[0] = x.Kind != ""
			yyq1092[1] = x.APIVersion != ""
			var yynn1092 int
			if yyr1092 || yy2arr1092 {
				r.EncodeArrayStart(4)
			} else {
				yynn1092 = 2
				for _, b := range yyq1092 {
					if b {
						yynn1092++
					}
				}
				r.EncodeMapStart(yynn1092)
				yynn1092 = 0
			}
			if yyr1092 || yy2arr1092 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1092[0] {
					yym1094 := z.EncBinary()
					_ = yym1094
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1092[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1095 := z.EncBinary()
					_ = yym1095
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1092 || yy2arr1092 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1092[1] {
					yym1097 := z.EncBinary()
					_ = yym1097
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1092[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1098 := z.EncBinary()
					_ = yym1098
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1092 || yy2arr1092 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1100 := z.EncBinary()
				_ = yym1100
				if false {
				} else {
					r.EncodeBool(bool(x.Export))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("export"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1101 := z.EncBinary()
				_ = yym1101
				if false {
				} else {
					r.EncodeBool(bool(x.Export))
				}
			}
			if yyr1092 || yy2arr1092 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1103 := z.EncBinary()
				_ = yym1103
				if false {
				} else {
					r.EncodeBool(bool(x.Exact))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exact"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1104 := z.EncBinary()
				_ = yym1104
				if false {
				} else {
					r.EncodeBool(bool(x.Exact))
				}
			}
			if yyr1092 || yy2arr1092 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ExportOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1105 := z.DecBinary()
	_ = yym1105
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1106 := r.ContainerType()
		if yyct1106 == codecSelferValueTypeMap1234 {
			yyl1106 := r.ReadMapStart()
			if yyl1106 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1106, d)
			}
		} else if yyct1106 == codecSelferValueTypeArray1234 {
			yyl1106 := r.ReadArrayStart()
			if yyl1106 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1106, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ExportOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1107Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1107Slc
	var yyhl1107 bool = l >= 0
	for yyj1107 := 0; ; yyj1107++ {
		if yyhl1107 {
			if yyj1107 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1107Slc = r.DecodeBytes(yys1107Slc, true, true)
		yys1107 := string(yys1107Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1107 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "export":
			if r.TryDecodeAsNil() {
				x.Export = false
			} else {
				x.Export = bool(r.DecodeBool())
			}
		case "exact":
			if r.TryDecodeAsNil() {
				x.Exact = false
			} else {
				x.Exact = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1107)
		} // end switch yys1107
	} // end for yyj1107
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ExportOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1112 int
	var yyb1112 bool
	var yyhl1112 bool = l >= 0
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Export = false
	} else {
		x.Export = bool(r.DecodeBool())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Exact = false
	} else {
		x.Exact = bool(r.DecodeBool())
	}
	for {
		yyj1112++
		if yyhl1112 {
			yyb1112 = yyj1112 > l
		} else {
			yyb1112 = r.CheckBreak()
		}
		if yyb1112 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1112-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ListOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1117 := z.EncBinary()
		_ = yym1117
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1118 := !z.EncBinary()
			yy2arr1118 := z.EncBasicHandle().StructToArray
			var yyq1118 [7]bool
			_, _, _ = yysep1118, yyq1118, yy2arr1118
			const yyr1118 bool = false
			yyq1118[0] = x.Kind != ""
			yyq1118[1] = x.APIVersion != ""
			yyq1118[2] = x.LabelSelector != ""
			yyq1118[3] = x.FieldSelector != ""
			yyq1118[4] = x.Watch != false
			yyq1118[5] = x.ResourceVersion != ""
			yyq1118[6] = x.TimeoutSeconds != nil
			var yynn1118 int
			if yyr1118 || yy2arr1118 {
				r.EncodeArrayStart(7)
			} else {
				yynn1118 = 0
				for _, b := range yyq1118 {
					if b {
						yynn1118++
					}
				}
				r.EncodeMapStart(yynn1118)
				yynn1118 = 0
			}
			if yyr1118 || yy2arr1118 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1118[0] {
					yym1120 := z.EncBinary()
					_ = yym1120
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1118[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1121 := z.EncBinary()
					_ = yym1121
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1118 || yy2arr1118 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1118[1] {
					yym1123 := z.EncBinary()
					_ = yym1123
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1118[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1124 := z.EncBinary()
					_ = yym1124
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1118 || yy2arr1118 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1118[2] {
					yym1126 := z.EncBinary()
					_ = yym1126
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LabelSelector))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1118[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labelSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1127 := z.EncBinary()
					_ = yym1127
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LabelSelector))
					}
				}
			}
			if yyr1118 || yy2arr1118 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1118[3] {
					yym1129 := z.EncBinary()
					_ = yym1129
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FieldSelector))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1118[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fieldSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1130 := z.EncBinary()
					_ = yym1130
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FieldSelector))
					}
				}
			}
			if yyr1118 || yy2arr1118 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1118[4] {
					yym1132 := z.EncBinary()
					_ = yym1132
					if false {
					} else {
						r.EncodeBool(bool(x.Watch))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1118[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("watch"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1133 := z.EncBinary()
					_ = yym1133
					if false {
					} else {
						r.EncodeBool(bool(x.Watch))
					}
				}
			}
			if yyr1118 || yy2arr1118 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1118[5] {
					yym1135 := z.EncBinary()
					_ = yym1135
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1118[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1136 := z.EncBinary()
					_ = yym1136
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr1118 || yy2arr1118 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1118[6] {
					if x.TimeoutSeconds == nil {
						r.EncodeNil()
					} else {
						yy1138 := *x.TimeoutSeconds
						yym1139 := z.EncBinary()
						_ = yym1139
						if false {
						} else {
							r.EncodeInt(int64(yy1138))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1118[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("timeoutSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TimeoutSeconds == nil {
						r.EncodeNil()
					} else {
						yy1140 := *x.TimeoutSeconds
						yym1141 := z.EncBinary()
						_ = yym1141
						if false {
						} else {
							r.EncodeInt(int64(yy1140))
						}
					}
				}
			}
			if yyr1118 || yy2arr1118 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ListOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1142 := z.DecBinary()
	_ = yym1142
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1143 := r.ContainerType()
		if yyct1143 == codecSelferValueTypeMap1234 {
			yyl1143 := r.ReadMapStart()
			if yyl1143 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1143, d)
			}
		} else if yyct1143 == codecSelferValueTypeArray1234 {
			yyl1143 := r.ReadArrayStart()
			if yyl1143 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1143, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ListOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1144Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1144Slc
	var yyhl1144 bool = l >= 0
	for yyj1144 := 0; ; yyj1144++ {
		if yyhl1144 {
			if yyj1144 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1144Slc = r.DecodeBytes(yys1144Slc, true, true)
		yys1144 := string(yys1144Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1144 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "labelSelector":
			if r.TryDecodeAsNil() {
				x.LabelSelector = ""
			} else {
				x.LabelSelector = string(r.DecodeString())
			}
		case "fieldSelector":
			if r.TryDecodeAsNil() {
				x.FieldSelector = ""
			} else {
				x.FieldSelector = string(r.DecodeString())
			}
		case "watch":
			if r.TryDecodeAsNil() {
				x.Watch = false
			} else {
				x.Watch = bool(r.DecodeBool())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "timeoutSeconds":
			if r.TryDecodeAsNil() {
				if x.TimeoutSeconds != nil {
					x.TimeoutSeconds = nil
				}
			} else {
				if x.TimeoutSeconds == nil {
					x.TimeoutSeconds = new(int64)
				}
				yym1152 := z.DecBinary()
				_ = yym1152
				if false {
				} else {
					*((*int64)(x.TimeoutSeconds)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1144)
		} // end switch yys1144
	} // end for yyj1144
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ListOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1153 int
	var yyb1153 bool
	var yyhl1153 bool = l >= 0
	yyj1153++
	if yyhl1153 {
		yyb1153 = yyj1153 > l
	} else {
		yyb1153 = r.CheckBreak()
	}
	if yyb1153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1153++
	if yyhl1153 {
		yyb1153 = yyj1153 > l
	} else {
		yyb1153 = r.CheckBreak()
	}
	if yyb1153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1153++
	if yyhl1153 {
		yyb1153 = yyj1153 > l
	} else {
		yyb1153 = r.CheckBreak()
	}
	if yyb1153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LabelSelector = ""
	} else {
		x.LabelSelector = string(r.DecodeString())
	}
	yyj1153++
	if yyhl1153 {
		yyb1153 = yyj1153 > l
	} else {
		yyb1153 = r.CheckBreak()
	}
	if yyb1153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FieldSelector = ""
	} else {
		x.FieldSelector = string(r.DecodeString())
	}
	yyj1153++
	if yyhl1153 {
		yyb1153 = yyj1153 > l
	} else {
		yyb1153 = r.CheckBreak()
	}
	if yyb1153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Watch = false
	} else {
		x.Watch = bool(r.DecodeBool())
	}
	yyj1153++
	if yyhl1153 {
		yyb1153 = yyj1153 > l
	} else {
		yyb1153 = r.CheckBreak()
	}
	if yyb1153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj1153++
	if yyhl1153 {
		yyb1153 = yyj1153 > l
	} else {
		yyb1153 = r.CheckBreak()
	}
	if yyb1153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TimeoutSeconds != nil {
			x.TimeoutSeconds = nil
		}
	} else {
		if x.TimeoutSeconds == nil {
			x.TimeoutSeconds = new(int64)
		}
		yym1161 := z.DecBinary()
		_ = yym1161
		if false {
		} else {
			*((*int64)(x.TimeoutSeconds)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj1153++
		if yyhl1153 {
			yyb1153 = yyj1153 > l
		} else {
			yyb1153 = r.CheckBreak()
		}
		if yyb1153 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1153-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LabelSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1162 := z.EncBinary()
		_ = yym1162
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1163 := !z.EncBinary()
			yy2arr1163 := z.EncBasicHandle().StructToArray
			var yyq1163 [2]bool
			_, _, _ = yysep1163, yyq1163, yy2arr1163
			const yyr1163 bool = false
			yyq1163[0] = len(x.MatchLabels) != 0
			yyq1163[1] = len(x.MatchExpressions) != 0
			var yynn1163 int
			if yyr1163 || yy2arr1163 {
				r.EncodeArrayStart(2)
			} else {
				yynn1163 = 0
				for _, b := range yyq1163 {
					if b {
						yynn1163++
					}
				}
				r.EncodeMapStart(yynn1163)
				yynn1163 = 0
			}
			if yyr1163 || yy2arr1163 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1163[0] {
					if x.MatchLabels == nil {
						r.EncodeNil()
					} else {
						yym1165 := z.EncBinary()
						_ = yym1165
						if false {
						} else {
							z.F.EncMapStringStringV(x.MatchLabels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1163[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("matchLabels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MatchLabels == nil {
						r.EncodeNil()
					} else {
						yym1166 := z.EncBinary()
						_ = yym1166
						if false {
						} else {
							z.F.EncMapStringStringV(x.MatchLabels, false, e)
						}
					}
				}
			}
			if yyr1163 || yy2arr1163 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1163[1] {
					if x.MatchExpressions == nil {
						r.EncodeNil()
					} else {
						yym1168 := z.EncBinary()
						_ = yym1168
						if false {
						} else {
							h.encSliceLabelSelectorRequirement(([]LabelSelectorRequirement)(x.MatchExpressions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1163[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("matchExpressions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MatchExpressions == nil {
						r.EncodeNil()
					} else {
						yym1169 := z.EncBinary()
						_ = yym1169
						if false {
						} else {
							h.encSliceLabelSelectorRequirement(([]LabelSelectorRequirement)(x.MatchExpressions), e)
						}
					}
				}
			}
			if yyr1163 || yy2arr1163 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LabelSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1170 := z.DecBinary()
	_ = yym1170
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1171 := r.ContainerType()
		if yyct1171 == codecSelferValueTypeMap1234 {
			yyl1171 := r.ReadMapStart()
			if yyl1171 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1171, d)
			}
		} else if yyct1171 == codecSelferValueTypeArray1234 {
			yyl1171 := r.ReadArrayStart()
			if yyl1171 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1171, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LabelSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1172Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1172Slc
	var yyhl1172 bool = l >= 0
	for yyj1172 := 0; ; yyj1172++ {
		if yyhl1172 {
			if yyj1172 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1172Slc = r.DecodeBytes(yys1172Slc, true, true)
		yys1172 := string(yys1172Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1172 {
		case "matchLabels":
			if r.TryDecodeAsNil() {
				x.MatchLabels = nil
			} else {
				yyv1173 := &x.MatchLabels
				yym1174 := z.DecBinary()
				_ = yym1174
				if false {
				} else {
					z.F.DecMapStringStringX(yyv1173, false, d)
				}
			}
		case "matchExpressions":
			if r.TryDecodeAsNil() {
				x.MatchExpressions = nil
			} else {
				yyv1175 := &x.MatchExpressions
				yym1176 := z.DecBinary()
				_ = yym1176
				if false {
				} else {
					h.decSliceLabelSelectorRequirement((*[]LabelSelectorRequirement)(yyv1175), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1172)
		} // end switch yys1172
	} // end for yyj1172
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LabelSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1177 int
	var yyb1177 bool
	var yyhl1177 bool = l >= 0
	yyj1177++
	if yyhl1177 {
		yyb1177 = yyj1177 > l
	} else {
		yyb1177 = r.CheckBreak()
	}
	if yyb1177 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchLabels = nil
	} else {
		yyv1178 := &x.MatchLabels
		yym1179 := z.DecBinary()
		_ = yym1179
		if false {
		} else {
			z.F.DecMapStringStringX(yyv1178, false, d)
		}
	}
	yyj1177++
	if yyhl1177 {
		yyb1177 = yyj1177 > l
	} else {
		yyb1177 = r.CheckBreak()
	}
	if yyb1177 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchExpressions = nil
	} else {
		yyv1180 := &x.MatchExpressions
		yym1181 := z.DecBinary()
		_ = yym1181
		if false {
		} else {
			h.decSliceLabelSelectorRequirement((*[]LabelSelectorRequirement)(yyv1180), d)
		}
	}
	for {
		yyj1177++
		if yyhl1177 {
			yyb1177 = yyj1177 > l
		} else {
			yyb1177 = r.CheckBreak()
		}
		if yyb1177 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1177-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LabelSelectorRequirement) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1182 := z.EncBinary()
		_ = yym1182
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1183 := !z.EncBinary()
			yy2arr1183 := z.EncBasicHandle().StructToArray
			var yyq1183 [3]bool
			_, _, _ = yysep1183, yyq1183, yy2arr1183
			const yyr1183 bool = false
			yyq1183[2] = len(x.Values) != 0
			var yynn1183 int
			if yyr1183 || yy2arr1183 {
				r.EncodeArrayStart(3)
			} else {
				yynn1183 = 2
				for _, b := range yyq1183 {
					if b {
						yynn1183++
					}
				}
				r.EncodeMapStart(yynn1183)
				yynn1183 = 0
			}
			if yyr1183 || yy2arr1183 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1185 := z.EncBinary()
				_ = yym1185
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1186 := z.EncBinary()
				_ = yym1186
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1183 || yy2arr1183 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Operator.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("operator"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Operator.CodecEncodeSelf(e)
			}
			if yyr1183 || yy2arr1183 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1183[2] {
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym1189 := z.EncBinary()
						_ = yym1189
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1183[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("values"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym1190 := z.EncBinary()
						_ = yym1190
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				}
			}
			if yyr1183 || yy2arr1183 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LabelSelectorRequirement) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1191 := z.DecBinary()
	_ = yym1191
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1192 := r.ContainerType()
		if yyct1192 == codecSelferValueTypeMap1234 {
			yyl1192 := r.ReadMapStart()
			if yyl1192 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1192, d)
			}
		} else if yyct1192 == codecSelferValueTypeArray1234 {
			yyl1192 := r.ReadArrayStart()
			if yyl1192 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1192, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LabelSelectorRequirement) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1193Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1193Slc
	var yyhl1193 bool = l >= 0
	for yyj1193 := 0; ; yyj1193++ {
		if yyhl1193 {
			if yyj1193 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1193Slc = r.DecodeBytes(yys1193Slc, true, true)
		yys1193 := string(yys1193Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1193 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				x.Operator = LabelSelectorOperator(r.DecodeString())
			}
		case "values":
			if r.TryDecodeAsNil() {
				x.Values = nil
			} else {
				yyv1196 := &x.Values
				yym1197 := z.DecBinary()
				_ = yym1197
				if false {
				} else {
					z.F.DecSliceStringX(yyv1196, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1193)
		} // end switch yys1193
	} // end for yyj1193
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LabelSelectorRequirement) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1198 int
	var yyb1198 bool
	var yyhl1198 bool = l >= 0
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		x.Operator = LabelSelectorOperator(r.DecodeString())
	}
	yyj1198++
	if yyhl1198 {
		yyb1198 = yyj1198 > l
	} else {
		yyb1198 = r.CheckBreak()
	}
	if yyb1198 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Values = nil
	} else {
		yyv1201 := &x.Values
		yym1202 := z.DecBinary()
		_ = yym1202
		if false {
		} else {
			z.F.DecSliceStringX(yyv1201, false, d)
		}
	}
	for {
		yyj1198++
		if yyhl1198 {
			yyb1198 = yyj1198 > l
		} else {
			yyb1198 = r.CheckBreak()
		}
		if yyb1198 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1198-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x LabelSelectorOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1203 := z.EncBinary()
	_ = yym1203
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *LabelSelectorOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1204 := z.DecBinary()
	_ = yym1204
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ConfigMap) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1205 := z.EncBinary()
		_ = yym1205
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1206 := !z.EncBinary()
			yy2arr1206 := z.EncBasicHandle().StructToArray
			var yyq1206 [4]bool
			_, _, _ = yysep1206, yyq1206, yy2arr1206
			const yyr1206 bool = false
			yyq1206[0] = x.Kind != ""
			yyq1206[1] = x.APIVersion != ""
			yyq1206[2] = true
			yyq1206[3] = len(x.Data) != 0
			var yynn1206 int
			if yyr1206 || yy2arr1206 {
				r.EncodeArrayStart(4)
			} else {
				yynn1206 = 0
				for _, b := range yyq1206 {
					if b {
						yynn1206++
					}
				}
				r.EncodeMapStart(yynn1206)
				yynn1206 = 0
			}
			if yyr1206 || yy2arr1206 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1206[0] {
					yym1208 := z.EncBinary()
					_ = yym1208
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1206[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1209 := z.EncBinary()
					_ = yym1209
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1206 || yy2arr1206 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1206[1] {
					yym1211 := z.EncBinary()
					_ = yym1211
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1206[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1212 := z.EncBinary()
					_ = yym1212
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1206 || yy2arr1206 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1206[2] {
					yy1214 := &x.ObjectMeta
					yy1214.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1206[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1215 := &x.ObjectMeta
					yy1215.CodecEncodeSelf(e)
				}
			}
			if yyr1206 || yy2arr1206 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1206[3] {
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym1217 := z.EncBinary()
						_ = yym1217
						if false {
						} else {
							z.F.EncMapStringStringV(x.Data, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1206[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("data"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym1218 := z.EncBinary()
						_ = yym1218
						if false {
						} else {
							z.F.EncMapStringStringV(x.Data, false, e)
						}
					}
				}
			}
			if yyr1206 || yy2arr1206 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMap) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1219 := z.DecBinary()
	_ = yym1219
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1220 := r.ContainerType()
		if yyct1220 == codecSelferValueTypeMap1234 {
			yyl1220 := r.ReadMapStart()
			if yyl1220 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1220, d)
			}
		} else if yyct1220 == codecSelferValueTypeArray1234 {
			yyl1220 := r.ReadArrayStart()
			if yyl1220 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1220, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMap) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1221Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1221Slc
	var yyhl1221 bool = l >= 0
	for yyj1221 := 0; ; yyj1221++ {
		if yyhl1221 {
			if yyj1221 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1221Slc = r.DecodeBytes(yys1221Slc, true, true)
		yys1221 := string(yys1221Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1221 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv1224 := &x.ObjectMeta
				yyv1224.CodecDecodeSelf(d)
			}
		case "data":
			if r.TryDecodeAsNil() {
				x.Data = nil
			} else {
				yyv1225 := &x.Data
				yym1226 := z.DecBinary()
				_ = yym1226
				if false {
				} else {
					z.F.DecMapStringStringX(yyv1225, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1221)
		} // end switch yys1221
	} // end for yyj1221
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMap) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1227 int
	var yyb1227 bool
	var yyhl1227 bool = l >= 0
	yyj1227++
	if yyhl1227 {
		yyb1227 = yyj1227 > l
	} else {
		yyb1227 = r.CheckBreak()
	}
	if yyb1227 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1227++
	if yyhl1227 {
		yyb1227 = yyj1227 > l
	} else {
		yyb1227 = r.CheckBreak()
	}
	if yyb1227 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1227++
	if yyhl1227 {
		yyb1227 = yyj1227 > l
	} else {
		yyb1227 = r.CheckBreak()
	}
	if yyb1227 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv1230 := &x.ObjectMeta
		yyv1230.CodecDecodeSelf(d)
	}
	yyj1227++
	if yyhl1227 {
		yyb1227 = yyj1227 > l
	} else {
		yyb1227 = r.CheckBreak()
	}
	if yyb1227 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Data = nil
	} else {
		yyv1231 := &x.Data
		yym1232 := z.DecBinary()
		_ = yym1232
		if false {
		} else {
			z.F.DecMapStringStringX(yyv1231, false, d)
		}
	}
	for {
		yyj1227++
		if yyhl1227 {
			yyb1227 = yyj1227 > l
		} else {
			yyb1227 = r.CheckBreak()
		}
		if yyb1227 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1227-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ConfigMapList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1233 := z.EncBinary()
		_ = yym1233
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1234 := !z.EncBinary()
			yy2arr1234 := z.EncBasicHandle().StructToArray
			var yyq1234 [4]bool
			_, _, _ = yysep1234, yyq1234, yy2arr1234
			const yyr1234 bool = false
			yyq1234[0] = x.Kind != ""
			yyq1234[1] = x.APIVersion != ""
			yyq1234[2] = true
			yyq1234[3] = len(x.Items) != 0
			var yynn1234 int
			if yyr1234 || yy2arr1234 {
				r.EncodeArrayStart(4)
			} else {
				yynn1234 = 0
				for _, b := range yyq1234 {
					if b {
						yynn1234++
					}
				}
				r.EncodeMapStart(yynn1234)
				yynn1234 = 0
			}
			if yyr1234 || yy2arr1234 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1234[0] {
					yym1236 := z.EncBinary()
					_ = yym1236
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1234[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1237 := z.EncBinary()
					_ = yym1237
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1234 || yy2arr1234 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1234[1] {
					yym1239 := z.EncBinary()
					_ = yym1239
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1234[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1240 := z.EncBinary()
					_ = yym1240
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1234 || yy2arr1234 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1234[2] {
					yy1242 := &x.ListMeta
					yym1243 := z.EncBinary()
					_ = yym1243
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1242) {
					} else {
						z.EncFallback(yy1242)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1234[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1244 := &x.ListMeta
					yym1245 := z.EncBinary()
					_ = yym1245
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1244) {
					} else {
						z.EncFallback(yy1244)
					}
				}
			}
			if yyr1234 || yy2arr1234 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1234[3] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1247 := z.EncBinary()
						_ = yym1247
						if false {
						} else {
							h.encSliceConfigMap(([]ConfigMap)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1234[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1248 := z.EncBinary()
						_ = yym1248
						if false {
						} else {
							h.encSliceConfigMap(([]ConfigMap)(x.Items), e)
						}
					}
				}
			}
			if yyr1234 || yy2arr1234 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMapList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1249 := z.DecBinary()
	_ = yym1249
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1250 := r.ContainerType()
		if yyct1250 == codecSelferValueTypeMap1234 {
			yyl1250 := r.ReadMapStart()
			if yyl1250 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1250, d)
			}
		} else if yyct1250 == codecSelferValueTypeArray1234 {
			yyl1250 := r.ReadArrayStart()
			if yyl1250 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1250, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMapList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1251Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1251Slc
	var yyhl1251 bool = l >= 0
	for yyj1251 := 0; ; yyj1251++ {
		if yyhl1251 {
			if yyj1251 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1251Slc = r.DecodeBytes(yys1251Slc, true, true)
		yys1251 := string(yys1251Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1251 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1254 := &x.ListMeta
				yym1255 := z.DecBinary()
				_ = yym1255
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1254) {
				} else {
					z.DecFallback(yyv1254, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1256 := &x.Items
				yym1257 := z.DecBinary()
				_ = yym1257
				if false {
				} else {
					h.decSliceConfigMap((*[]ConfigMap)(yyv1256), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1251)
		} // end switch yys1251
	} // end for yyj1251
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMapList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1258 int
	var yyb1258 bool
	var yyhl1258 bool = l >= 0
	yyj1258++
	if yyhl1258 {
		yyb1258 = yyj1258 > l
	} else {
		yyb1258 = r.CheckBreak()
	}
	if yyb1258 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1258++
	if yyhl1258 {
		yyb1258 = yyj1258 > l
	} else {
		yyb1258 = r.CheckBreak()
	}
	if yyb1258 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1258++
	if yyhl1258 {
		yyb1258 = yyj1258 > l
	} else {
		yyb1258 = r.CheckBreak()
	}
	if yyb1258 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1261 := &x.ListMeta
		yym1262 := z.DecBinary()
		_ = yym1262
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1261) {
		} else {
			z.DecFallback(yyv1261, false)
		}
	}
	yyj1258++
	if yyhl1258 {
		yyb1258 = yyj1258 > l
	} else {
		yyb1258 = r.CheckBreak()
	}
	if yyb1258 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1263 := &x.Items
		yym1264 := z.DecBinary()
		_ = yym1264
		if false {
		} else {
			h.decSliceConfigMap((*[]ConfigMap)(yyv1263), d)
		}
	}
	for {
		yyj1258++
		if yyhl1258 {
			yyb1258 = yyj1258 > l
		} else {
			yyb1258 = r.CheckBreak()
		}
		if yyb1258 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1258-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSliceHorizontalPodAutoscaler(v []HorizontalPodAutoscaler, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1265 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1266 := &yyv1265
		yy1266.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHorizontalPodAutoscaler(v *[]HorizontalPodAutoscaler, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1267 := *v
	yyh1267, yyl1267 := z.DecSliceHelperStart()
	var yyc1267 bool
	if yyl1267 == 0 {
		if yyv1267 == nil {
			yyv1267 = []HorizontalPodAutoscaler{}
			yyc1267 = true
		} else if len(yyv1267) != 0 {
			yyv1267 = yyv1267[:0]
			yyc1267 = true
		}
	} else if yyl1267 > 0 {
		var yyrr1267, yyrl1267 int
		var yyrt1267 bool
		if yyl1267 > cap(yyv1267) {

			yyrg1267 := len(yyv1267) > 0
			yyv21267 := yyv1267
			yyrl1267, yyrt1267 = z.DecInferLen(yyl1267, z.DecBasicHandle().MaxInitLen, 312)
			if yyrt1267 {
				if yyrl1267 <= cap(yyv1267) {
					yyv1267 = yyv1267[:yyrl1267]
				} else {
					yyv1267 = make([]HorizontalPodAutoscaler, yyrl1267)
				}
			} else {
				yyv1267 = make([]HorizontalPodAutoscaler, yyrl1267)
			}
			yyc1267 = true
			yyrr1267 = len(yyv1267)
			if yyrg1267 {
				copy(yyv1267, yyv21267)
			}
		} else if yyl1267 != len(yyv1267) {
			yyv1267 = yyv1267[:yyl1267]
			yyc1267 = true
		}
		yyj1267 := 0
		for ; yyj1267 < yyrr1267; yyj1267++ {
			yyh1267.ElemContainerState(yyj1267)
			if r.TryDecodeAsNil() {
				yyv1267[yyj1267] = HorizontalPodAutoscaler{}
			} else {
				yyv1268 := &yyv1267[yyj1267]
				yyv1268.CodecDecodeSelf(d)
			}

		}
		if yyrt1267 {
			for ; yyj1267 < yyl1267; yyj1267++ {
				yyv1267 = append(yyv1267, HorizontalPodAutoscaler{})
				yyh1267.ElemContainerState(yyj1267)
				if r.TryDecodeAsNil() {
					yyv1267[yyj1267] = HorizontalPodAutoscaler{}
				} else {
					yyv1269 := &yyv1267[yyj1267]
					yyv1269.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1267 := 0
		for ; !r.CheckBreak(); yyj1267++ {

			if yyj1267 >= len(yyv1267) {
				yyv1267 = append(yyv1267, HorizontalPodAutoscaler{}) // var yyz1267 HorizontalPodAutoscaler
				yyc1267 = true
			}
			yyh1267.ElemContainerState(yyj1267)
			if yyj1267 < len(yyv1267) {
				if r.TryDecodeAsNil() {
					yyv1267[yyj1267] = HorizontalPodAutoscaler{}
				} else {
					yyv1270 := &yyv1267[yyj1267]
					yyv1270.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1267 < len(yyv1267) {
			yyv1267 = yyv1267[:yyj1267]
			yyc1267 = true
		} else if yyj1267 == 0 && yyv1267 == nil {
			yyv1267 = []HorizontalPodAutoscaler{}
			yyc1267 = true
		}
	}
	yyh1267.End()
	if yyc1267 {
		*v = yyv1267
	}
}

func (x codecSelfer1234) encSliceAPIVersion(v []APIVersion, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1271 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1272 := &yyv1271
		yy1272.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceAPIVersion(v *[]APIVersion, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1273 := *v
	yyh1273, yyl1273 := z.DecSliceHelperStart()
	var yyc1273 bool
	if yyl1273 == 0 {
		if yyv1273 == nil {
			yyv1273 = []APIVersion{}
			yyc1273 = true
		} else if len(yyv1273) != 0 {
			yyv1273 = yyv1273[:0]
			yyc1273 = true
		}
	} else if yyl1273 > 0 {
		var yyrr1273, yyrl1273 int
		var yyrt1273 bool
		if yyl1273 > cap(yyv1273) {

			yyrg1273 := len(yyv1273) > 0
			yyv21273 := yyv1273
			yyrl1273, yyrt1273 = z.DecInferLen(yyl1273, z.DecBasicHandle().MaxInitLen, 32)
			if yyrt1273 {
				if yyrl1273 <= cap(yyv1273) {
					yyv1273 = yyv1273[:yyrl1273]
				} else {
					yyv1273 = make([]APIVersion, yyrl1273)
				}
			} else {
				yyv1273 = make([]APIVersion, yyrl1273)
			}
			yyc1273 = true
			yyrr1273 = len(yyv1273)
			if yyrg1273 {
				copy(yyv1273, yyv21273)
			}
		} else if yyl1273 != len(yyv1273) {
			yyv1273 = yyv1273[:yyl1273]
			yyc1273 = true
		}
		yyj1273 := 0
		for ; yyj1273 < yyrr1273; yyj1273++ {
			yyh1273.ElemContainerState(yyj1273)
			if r.TryDecodeAsNil() {
				yyv1273[yyj1273] = APIVersion{}
			} else {
				yyv1274 := &yyv1273[yyj1273]
				yyv1274.CodecDecodeSelf(d)
			}

		}
		if yyrt1273 {
			for ; yyj1273 < yyl1273; yyj1273++ {
				yyv1273 = append(yyv1273, APIVersion{})
				yyh1273.ElemContainerState(yyj1273)
				if r.TryDecodeAsNil() {
					yyv1273[yyj1273] = APIVersion{}
				} else {
					yyv1275 := &yyv1273[yyj1273]
					yyv1275.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1273 := 0
		for ; !r.CheckBreak(); yyj1273++ {

			if yyj1273 >= len(yyv1273) {
				yyv1273 = append(yyv1273, APIVersion{}) // var yyz1273 APIVersion
				yyc1273 = true
			}
			yyh1273.ElemContainerState(yyj1273)
			if yyj1273 < len(yyv1273) {
				if r.TryDecodeAsNil() {
					yyv1273[yyj1273] = APIVersion{}
				} else {
					yyv1276 := &yyv1273[yyj1273]
					yyv1276.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1273 < len(yyv1273) {
			yyv1273 = yyv1273[:yyj1273]
			yyc1273 = true
		} else if yyj1273 == 0 && yyv1273 == nil {
			yyv1273 = []APIVersion{}
			yyc1273 = true
		}
	}
	yyh1273.End()
	if yyc1273 {
		*v = yyv1273
	}
}

func (x codecSelfer1234) encSliceThirdPartyResource(v []ThirdPartyResource, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1277 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1278 := &yyv1277
		yy1278.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceThirdPartyResource(v *[]ThirdPartyResource, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1279 := *v
	yyh1279, yyl1279 := z.DecSliceHelperStart()
	var yyc1279 bool
	if yyl1279 == 0 {
		if yyv1279 == nil {
			yyv1279 = []ThirdPartyResource{}
			yyc1279 = true
		} else if len(yyv1279) != 0 {
			yyv1279 = yyv1279[:0]
			yyc1279 = true
		}
	} else if yyl1279 > 0 {
		var yyrr1279, yyrl1279 int
		var yyrt1279 bool
		if yyl1279 > cap(yyv1279) {

			yyrg1279 := len(yyv1279) > 0
			yyv21279 := yyv1279
			yyrl1279, yyrt1279 = z.DecInferLen(yyl1279, z.DecBasicHandle().MaxInitLen, 232)
			if yyrt1279 {
				if yyrl1279 <= cap(yyv1279) {
					yyv1279 = yyv1279[:yyrl1279]
				} else {
					yyv1279 = make([]ThirdPartyResource, yyrl1279)
				}
			} else {
				yyv1279 = make([]ThirdPartyResource, yyrl1279)
			}
			yyc1279 = true
			yyrr1279 = len(yyv1279)
			if yyrg1279 {
				copy(yyv1279, yyv21279)
			}
		} else if yyl1279 != len(yyv1279) {
			yyv1279 = yyv1279[:yyl1279]
			yyc1279 = true
		}
		yyj1279 := 0
		for ; yyj1279 < yyrr1279; yyj1279++ {
			yyh1279.ElemContainerState(yyj1279)
			if r.TryDecodeAsNil() {
				yyv1279[yyj1279] = ThirdPartyResource{}
			} else {
				yyv1280 := &yyv1279[yyj1279]
				yyv1280.CodecDecodeSelf(d)
			}

		}
		if yyrt1279 {
			for ; yyj1279 < yyl1279; yyj1279++ {
				yyv1279 = append(yyv1279, ThirdPartyResource{})
				yyh1279.ElemContainerState(yyj1279)
				if r.TryDecodeAsNil() {
					yyv1279[yyj1279] = ThirdPartyResource{}
				} else {
					yyv1281 := &yyv1279[yyj1279]
					yyv1281.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1279 := 0
		for ; !r.CheckBreak(); yyj1279++ {

			if yyj1279 >= len(yyv1279) {
				yyv1279 = append(yyv1279, ThirdPartyResource{}) // var yyz1279 ThirdPartyResource
				yyc1279 = true
			}
			yyh1279.ElemContainerState(yyj1279)
			if yyj1279 < len(yyv1279) {
				if r.TryDecodeAsNil() {
					yyv1279[yyj1279] = ThirdPartyResource{}
				} else {
					yyv1282 := &yyv1279[yyj1279]
					yyv1282.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1279 < len(yyv1279) {
			yyv1279 = yyv1279[:yyj1279]
			yyc1279 = true
		} else if yyj1279 == 0 && yyv1279 == nil {
			yyv1279 = []ThirdPartyResource{}
			yyc1279 = true
		}
	}
	yyh1279.End()
	if yyc1279 {
		*v = yyv1279
	}
}

func (x codecSelfer1234) encSliceDeployment(v []Deployment, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1283 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1284 := &yyv1283
		yy1284.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceDeployment(v *[]Deployment, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1285 := *v
	yyh1285, yyl1285 := z.DecSliceHelperStart()
	var yyc1285 bool
	if yyl1285 == 0 {
		if yyv1285 == nil {
			yyv1285 = []Deployment{}
			yyc1285 = true
		} else if len(yyv1285) != 0 {
			yyv1285 = yyv1285[:0]
			yyc1285 = true
		}
	} else if yyl1285 > 0 {
		var yyrr1285, yyrl1285 int
		var yyrt1285 bool
		if yyl1285 > cap(yyv1285) {

			yyrg1285 := len(yyv1285) > 0
			yyv21285 := yyv1285
			yyrl1285, yyrt1285 = z.DecInferLen(yyl1285, z.DecBasicHandle().MaxInitLen, 600)
			if yyrt1285 {
				if yyrl1285 <= cap(yyv1285) {
					yyv1285 = yyv1285[:yyrl1285]
				} else {
					yyv1285 = make([]Deployment, yyrl1285)
				}
			} else {
				yyv1285 = make([]Deployment, yyrl1285)
			}
			yyc1285 = true
			yyrr1285 = len(yyv1285)
			if yyrg1285 {
				copy(yyv1285, yyv21285)
			}
		} else if yyl1285 != len(yyv1285) {
			yyv1285 = yyv1285[:yyl1285]
			yyc1285 = true
		}
		yyj1285 := 0
		for ; yyj1285 < yyrr1285; yyj1285++ {
			yyh1285.ElemContainerState(yyj1285)
			if r.TryDecodeAsNil() {
				yyv1285[yyj1285] = Deployment{}
			} else {
				yyv1286 := &yyv1285[yyj1285]
				yyv1286.CodecDecodeSelf(d)
			}

		}
		if yyrt1285 {
			for ; yyj1285 < yyl1285; yyj1285++ {
				yyv1285 = append(yyv1285, Deployment{})
				yyh1285.ElemContainerState(yyj1285)
				if r.TryDecodeAsNil() {
					yyv1285[yyj1285] = Deployment{}
				} else {
					yyv1287 := &yyv1285[yyj1285]
					yyv1287.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1285 := 0
		for ; !r.CheckBreak(); yyj1285++ {

			if yyj1285 >= len(yyv1285) {
				yyv1285 = append(yyv1285, Deployment{}) // var yyz1285 Deployment
				yyc1285 = true
			}
			yyh1285.ElemContainerState(yyj1285)
			if yyj1285 < len(yyv1285) {
				if r.TryDecodeAsNil() {
					yyv1285[yyj1285] = Deployment{}
				} else {
					yyv1288 := &yyv1285[yyj1285]
					yyv1288.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1285 < len(yyv1285) {
			yyv1285 = yyv1285[:yyj1285]
			yyc1285 = true
		} else if yyj1285 == 0 && yyv1285 == nil {
			yyv1285 = []Deployment{}
			yyc1285 = true
		}
	}
	yyh1285.End()
	if yyc1285 {
		*v = yyv1285
	}
}

func (x codecSelfer1234) encSliceDaemonSet(v []DaemonSet, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1289 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1290 := &yyv1289
		yy1290.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceDaemonSet(v *[]DaemonSet, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1291 := *v
	yyh1291, yyl1291 := z.DecSliceHelperStart()
	var yyc1291 bool
	if yyl1291 == 0 {
		if yyv1291 == nil {
			yyv1291 = []DaemonSet{}
			yyc1291 = true
		} else if len(yyv1291) != 0 {
			yyv1291 = yyv1291[:0]
			yyc1291 = true
		}
	} else if yyl1291 > 0 {
		var yyrr1291, yyrl1291 int
		var yyrt1291 bool
		if yyl1291 > cap(yyv1291) {

			yyrg1291 := len(yyv1291) > 0
			yyv21291 := yyv1291
			yyrl1291, yyrt1291 = z.DecInferLen(yyl1291, z.DecBasicHandle().MaxInitLen, 224)
			if yyrt1291 {
				if yyrl1291 <= cap(yyv1291) {
					yyv1291 = yyv1291[:yyrl1291]
				} else {
					yyv1291 = make([]DaemonSet, yyrl1291)
				}
			} else {
				yyv1291 = make([]DaemonSet, yyrl1291)
			}
			yyc1291 = true
			yyrr1291 = len(yyv1291)
			if yyrg1291 {
				copy(yyv1291, yyv21291)
			}
		} else if yyl1291 != len(yyv1291) {
			yyv1291 = yyv1291[:yyl1291]
			yyc1291 = true
		}
		yyj1291 := 0
		for ; yyj1291 < yyrr1291; yyj1291++ {
			yyh1291.ElemContainerState(yyj1291)
			if r.TryDecodeAsNil() {
				yyv1291[yyj1291] = DaemonSet{}
			} else {
				yyv1292 := &yyv1291[yyj1291]
				yyv1292.CodecDecodeSelf(d)
			}

		}
		if yyrt1291 {
			for ; yyj1291 < yyl1291; yyj1291++ {
				yyv1291 = append(yyv1291, DaemonSet{})
				yyh1291.ElemContainerState(yyj1291)
				if r.TryDecodeAsNil() {
					yyv1291[yyj1291] = DaemonSet{}
				} else {
					yyv1293 := &yyv1291[yyj1291]
					yyv1293.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1291 := 0
		for ; !r.CheckBreak(); yyj1291++ {

			if yyj1291 >= len(yyv1291) {
				yyv1291 = append(yyv1291, DaemonSet{}) // var yyz1291 DaemonSet
				yyc1291 = true
			}
			yyh1291.ElemContainerState(yyj1291)
			if yyj1291 < len(yyv1291) {
				if r.TryDecodeAsNil() {
					yyv1291[yyj1291] = DaemonSet{}
				} else {
					yyv1294 := &yyv1291[yyj1291]
					yyv1294.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1291 < len(yyv1291) {
			yyv1291 = yyv1291[:yyj1291]
			yyc1291 = true
		} else if yyj1291 == 0 && yyv1291 == nil {
			yyv1291 = []DaemonSet{}
			yyc1291 = true
		}
	}
	yyh1291.End()
	if yyc1291 {
		*v = yyv1291
	}
}

func (x codecSelfer1234) encSliceThirdPartyResourceData(v []ThirdPartyResourceData, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1295 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1296 := &yyv1295
		yy1296.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceThirdPartyResourceData(v *[]ThirdPartyResourceData, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1297 := *v
	yyh1297, yyl1297 := z.DecSliceHelperStart()
	var yyc1297 bool
	if yyl1297 == 0 {
		if yyv1297 == nil {
			yyv1297 = []ThirdPartyResourceData{}
			yyc1297 = true
		} else if len(yyv1297) != 0 {
			yyv1297 = yyv1297[:0]
			yyc1297 = true
		}
	} else if yyl1297 > 0 {
		var yyrr1297, yyrl1297 int
		var yyrt1297 bool
		if yyl1297 > cap(yyv1297) {

			yyrg1297 := len(yyv1297) > 0
			yyv21297 := yyv1297
			yyrl1297, yyrt1297 = z.DecInferLen(yyl1297, z.DecBasicHandle().MaxInitLen, 216)
			if yyrt1297 {
				if yyrl1297 <= cap(yyv1297) {
					yyv1297 = yyv1297[:yyrl1297]
				} else {
					yyv1297 = make([]ThirdPartyResourceData, yyrl1297)
				}
			} else {
				yyv1297 = make([]ThirdPartyResourceData, yyrl1297)
			}
			yyc1297 = true
			yyrr1297 = len(yyv1297)
			if yyrg1297 {
				copy(yyv1297, yyv21297)
			}
		} else if yyl1297 != len(yyv1297) {
			yyv1297 = yyv1297[:yyl1297]
			yyc1297 = true
		}
		yyj1297 := 0
		for ; yyj1297 < yyrr1297; yyj1297++ {
			yyh1297.ElemContainerState(yyj1297)
			if r.TryDecodeAsNil() {
				yyv1297[yyj1297] = ThirdPartyResourceData{}
			} else {
				yyv1298 := &yyv1297[yyj1297]
				yyv1298.CodecDecodeSelf(d)
			}

		}
		if yyrt1297 {
			for ; yyj1297 < yyl1297; yyj1297++ {
				yyv1297 = append(yyv1297, ThirdPartyResourceData{})
				yyh1297.ElemContainerState(yyj1297)
				if r.TryDecodeAsNil() {
					yyv1297[yyj1297] = ThirdPartyResourceData{}
				} else {
					yyv1299 := &yyv1297[yyj1297]
					yyv1299.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1297 := 0
		for ; !r.CheckBreak(); yyj1297++ {

			if yyj1297 >= len(yyv1297) {
				yyv1297 = append(yyv1297, ThirdPartyResourceData{}) // var yyz1297 ThirdPartyResourceData
				yyc1297 = true
			}
			yyh1297.ElemContainerState(yyj1297)
			if yyj1297 < len(yyv1297) {
				if r.TryDecodeAsNil() {
					yyv1297[yyj1297] = ThirdPartyResourceData{}
				} else {
					yyv1300 := &yyv1297[yyj1297]
					yyv1300.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1297 < len(yyv1297) {
			yyv1297 = yyv1297[:yyj1297]
			yyc1297 = true
		} else if yyj1297 == 0 && yyv1297 == nil {
			yyv1297 = []ThirdPartyResourceData{}
			yyc1297 = true
		}
	}
	yyh1297.End()
	if yyc1297 {
		*v = yyv1297
	}
}

func (x codecSelfer1234) encSliceJob(v []Job, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1301 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1302 := &yyv1301
		yy1302.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceJob(v *[]Job, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1303 := *v
	yyh1303, yyl1303 := z.DecSliceHelperStart()
	var yyc1303 bool
	if yyl1303 == 0 {
		if yyv1303 == nil {
			yyv1303 = []Job{}
			yyc1303 = true
		} else if len(yyv1303) != 0 {
			yyv1303 = yyv1303[:0]
			yyc1303 = true
		}
	} else if yyl1303 > 0 {
		var yyrr1303, yyrl1303 int
		var yyrt1303 bool
		if yyl1303 > cap(yyv1303) {

			yyrg1303 := len(yyv1303) > 0
			yyv21303 := yyv1303
			yyrl1303, yyrt1303 = z.DecInferLen(yyl1303, z.DecBasicHandle().MaxInitLen, 632)
			if yyrt1303 {
				if yyrl1303 <= cap(yyv1303) {
					yyv1303 = yyv1303[:yyrl1303]
				} else {
					yyv1303 = make([]Job, yyrl1303)
				}
			} else {
				yyv1303 = make([]Job, yyrl1303)
			}
			yyc1303 = true
			yyrr1303 = len(yyv1303)
			if yyrg1303 {
				copy(yyv1303, yyv21303)
			}
		} else if yyl1303 != len(yyv1303) {
			yyv1303 = yyv1303[:yyl1303]
			yyc1303 = true
		}
		yyj1303 := 0
		for ; yyj1303 < yyrr1303; yyj1303++ {
			yyh1303.ElemContainerState(yyj1303)
			if r.TryDecodeAsNil() {
				yyv1303[yyj1303] = Job{}
			} else {
				yyv1304 := &yyv1303[yyj1303]
				yyv1304.CodecDecodeSelf(d)
			}

		}
		if yyrt1303 {
			for ; yyj1303 < yyl1303; yyj1303++ {
				yyv1303 = append(yyv1303, Job{})
				yyh1303.ElemContainerState(yyj1303)
				if r.TryDecodeAsNil() {
					yyv1303[yyj1303] = Job{}
				} else {
					yyv1305 := &yyv1303[yyj1303]
					yyv1305.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1303 := 0
		for ; !r.CheckBreak(); yyj1303++ {

			if yyj1303 >= len(yyv1303) {
				yyv1303 = append(yyv1303, Job{}) // var yyz1303 Job
				yyc1303 = true
			}
			yyh1303.ElemContainerState(yyj1303)
			if yyj1303 < len(yyv1303) {
				if r.TryDecodeAsNil() {
					yyv1303[yyj1303] = Job{}
				} else {
					yyv1306 := &yyv1303[yyj1303]
					yyv1306.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1303 < len(yyv1303) {
			yyv1303 = yyv1303[:yyj1303]
			yyc1303 = true
		} else if yyj1303 == 0 && yyv1303 == nil {
			yyv1303 = []Job{}
			yyc1303 = true
		}
	}
	yyh1303.End()
	if yyc1303 {
		*v = yyv1303
	}
}

func (x codecSelfer1234) encSliceJobCondition(v []JobCondition, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1307 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1308 := &yyv1307
		yy1308.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceJobCondition(v *[]JobCondition, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1309 := *v
	yyh1309, yyl1309 := z.DecSliceHelperStart()
	var yyc1309 bool
	if yyl1309 == 0 {
		if yyv1309 == nil {
			yyv1309 = []JobCondition{}
			yyc1309 = true
		} else if len(yyv1309) != 0 {
			yyv1309 = yyv1309[:0]
			yyc1309 = true
		}
	} else if yyl1309 > 0 {
		var yyrr1309, yyrl1309 int
		var yyrt1309 bool
		if yyl1309 > cap(yyv1309) {

			yyrg1309 := len(yyv1309) > 0
			yyv21309 := yyv1309
			yyrl1309, yyrt1309 = z.DecInferLen(yyl1309, z.DecBasicHandle().MaxInitLen, 112)
			if yyrt1309 {
				if yyrl1309 <= cap(yyv1309) {
					yyv1309 = yyv1309[:yyrl1309]
				} else {
					yyv1309 = make([]JobCondition, yyrl1309)
				}
			} else {
				yyv1309 = make([]JobCondition, yyrl1309)
			}
			yyc1309 = true
			yyrr1309 = len(yyv1309)
			if yyrg1309 {
				copy(yyv1309, yyv21309)
			}
		} else if yyl1309 != len(yyv1309) {
			yyv1309 = yyv1309[:yyl1309]
			yyc1309 = true
		}
		yyj1309 := 0
		for ; yyj1309 < yyrr1309; yyj1309++ {
			yyh1309.ElemContainerState(yyj1309)
			if r.TryDecodeAsNil() {
				yyv1309[yyj1309] = JobCondition{}
			} else {
				yyv1310 := &yyv1309[yyj1309]
				yyv1310.CodecDecodeSelf(d)
			}

		}
		if yyrt1309 {
			for ; yyj1309 < yyl1309; yyj1309++ {
				yyv1309 = append(yyv1309, JobCondition{})
				yyh1309.ElemContainerState(yyj1309)
				if r.TryDecodeAsNil() {
					yyv1309[yyj1309] = JobCondition{}
				} else {
					yyv1311 := &yyv1309[yyj1309]
					yyv1311.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1309 := 0
		for ; !r.CheckBreak(); yyj1309++ {

			if yyj1309 >= len(yyv1309) {
				yyv1309 = append(yyv1309, JobCondition{}) // var yyz1309 JobCondition
				yyc1309 = true
			}
			yyh1309.ElemContainerState(yyj1309)
			if yyj1309 < len(yyv1309) {
				if r.TryDecodeAsNil() {
					yyv1309[yyj1309] = JobCondition{}
				} else {
					yyv1312 := &yyv1309[yyj1309]
					yyv1312.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1309 < len(yyv1309) {
			yyv1309 = yyv1309[:yyj1309]
			yyc1309 = true
		} else if yyj1309 == 0 && yyv1309 == nil {
			yyv1309 = []JobCondition{}
			yyc1309 = true
		}
	}
	yyh1309.End()
	if yyc1309 {
		*v = yyv1309
	}
}

func (x codecSelfer1234) encSliceIngress(v []Ingress, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1313 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1314 := &yyv1313
		yy1314.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngress(v *[]Ingress, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1315 := *v
	yyh1315, yyl1315 := z.DecSliceHelperStart()
	var yyc1315 bool
	if yyl1315 == 0 {
		if yyv1315 == nil {
			yyv1315 = []Ingress{}
			yyc1315 = true
		} else if len(yyv1315) != 0 {
			yyv1315 = yyv1315[:0]
			yyc1315 = true
		}
	} else if yyl1315 > 0 {
		var yyrr1315, yyrl1315 int
		var yyrt1315 bool
		if yyl1315 > cap(yyv1315) {

			yyrg1315 := len(yyv1315) > 0
			yyv21315 := yyv1315
			yyrl1315, yyrt1315 = z.DecInferLen(yyl1315, z.DecBasicHandle().MaxInitLen, 248)
			if yyrt1315 {
				if yyrl1315 <= cap(yyv1315) {
					yyv1315 = yyv1315[:yyrl1315]
				} else {
					yyv1315 = make([]Ingress, yyrl1315)
				}
			} else {
				yyv1315 = make([]Ingress, yyrl1315)
			}
			yyc1315 = true
			yyrr1315 = len(yyv1315)
			if yyrg1315 {
				copy(yyv1315, yyv21315)
			}
		} else if yyl1315 != len(yyv1315) {
			yyv1315 = yyv1315[:yyl1315]
			yyc1315 = true
		}
		yyj1315 := 0
		for ; yyj1315 < yyrr1315; yyj1315++ {
			yyh1315.ElemContainerState(yyj1315)
			if r.TryDecodeAsNil() {
				yyv1315[yyj1315] = Ingress{}
			} else {
				yyv1316 := &yyv1315[yyj1315]
				yyv1316.CodecDecodeSelf(d)
			}

		}
		if yyrt1315 {
			for ; yyj1315 < yyl1315; yyj1315++ {
				yyv1315 = append(yyv1315, Ingress{})
				yyh1315.ElemContainerState(yyj1315)
				if r.TryDecodeAsNil() {
					yyv1315[yyj1315] = Ingress{}
				} else {
					yyv1317 := &yyv1315[yyj1315]
					yyv1317.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1315 := 0
		for ; !r.CheckBreak(); yyj1315++ {

			if yyj1315 >= len(yyv1315) {
				yyv1315 = append(yyv1315, Ingress{}) // var yyz1315 Ingress
				yyc1315 = true
			}
			yyh1315.ElemContainerState(yyj1315)
			if yyj1315 < len(yyv1315) {
				if r.TryDecodeAsNil() {
					yyv1315[yyj1315] = Ingress{}
				} else {
					yyv1318 := &yyv1315[yyj1315]
					yyv1318.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1315 < len(yyv1315) {
			yyv1315 = yyv1315[:yyj1315]
			yyc1315 = true
		} else if yyj1315 == 0 && yyv1315 == nil {
			yyv1315 = []Ingress{}
			yyc1315 = true
		}
	}
	yyh1315.End()
	if yyc1315 {
		*v = yyv1315
	}
}

func (x codecSelfer1234) encSliceIngressRule(v []IngressRule, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1319 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1320 := &yyv1319
		yy1320.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngressRule(v *[]IngressRule, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1321 := *v
	yyh1321, yyl1321 := z.DecSliceHelperStart()
	var yyc1321 bool
	if yyl1321 == 0 {
		if yyv1321 == nil {
			yyv1321 = []IngressRule{}
			yyc1321 = true
		} else if len(yyv1321) != 0 {
			yyv1321 = yyv1321[:0]
			yyc1321 = true
		}
	} else if yyl1321 > 0 {
		var yyrr1321, yyrl1321 int
		var yyrt1321 bool
		if yyl1321 > cap(yyv1321) {

			yyrg1321 := len(yyv1321) > 0
			yyv21321 := yyv1321
			yyrl1321, yyrt1321 = z.DecInferLen(yyl1321, z.DecBasicHandle().MaxInitLen, 24)
			if yyrt1321 {
				if yyrl1321 <= cap(yyv1321) {
					yyv1321 = yyv1321[:yyrl1321]
				} else {
					yyv1321 = make([]IngressRule, yyrl1321)
				}
			} else {
				yyv1321 = make([]IngressRule, yyrl1321)
			}
			yyc1321 = true
			yyrr1321 = len(yyv1321)
			if yyrg1321 {
				copy(yyv1321, yyv21321)
			}
		} else if yyl1321 != len(yyv1321) {
			yyv1321 = yyv1321[:yyl1321]
			yyc1321 = true
		}
		yyj1321 := 0
		for ; yyj1321 < yyrr1321; yyj1321++ {
			yyh1321.ElemContainerState(yyj1321)
			if r.TryDecodeAsNil() {
				yyv1321[yyj1321] = IngressRule{}
			} else {
				yyv1322 := &yyv1321[yyj1321]
				yyv1322.CodecDecodeSelf(d)
			}

		}
		if yyrt1321 {
			for ; yyj1321 < yyl1321; yyj1321++ {
				yyv1321 = append(yyv1321, IngressRule{})
				yyh1321.ElemContainerState(yyj1321)
				if r.TryDecodeAsNil() {
					yyv1321[yyj1321] = IngressRule{}
				} else {
					yyv1323 := &yyv1321[yyj1321]
					yyv1323.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1321 := 0
		for ; !r.CheckBreak(); yyj1321++ {

			if yyj1321 >= len(yyv1321) {
				yyv1321 = append(yyv1321, IngressRule{}) // var yyz1321 IngressRule
				yyc1321 = true
			}
			yyh1321.ElemContainerState(yyj1321)
			if yyj1321 < len(yyv1321) {
				if r.TryDecodeAsNil() {
					yyv1321[yyj1321] = IngressRule{}
				} else {
					yyv1324 := &yyv1321[yyj1321]
					yyv1324.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1321 < len(yyv1321) {
			yyv1321 = yyv1321[:yyj1321]
			yyc1321 = true
		} else if yyj1321 == 0 && yyv1321 == nil {
			yyv1321 = []IngressRule{}
			yyc1321 = true
		}
	}
	yyh1321.End()
	if yyc1321 {
		*v = yyv1321
	}
}

func (x codecSelfer1234) encSliceHTTPIngressPath(v []HTTPIngressPath, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1325 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1326 := &yyv1325
		yy1326.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHTTPIngressPath(v *[]HTTPIngressPath, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1327 := *v
	yyh1327, yyl1327 := z.DecSliceHelperStart()
	var yyc1327 bool
	if yyl1327 == 0 {
		if yyv1327 == nil {
			yyv1327 = []HTTPIngressPath{}
			yyc1327 = true
		} else if len(yyv1327) != 0 {
			yyv1327 = yyv1327[:0]
			yyc1327 = true
		}
	} else if yyl1327 > 0 {
		var yyrr1327, yyrl1327 int
		var yyrt1327 bool
		if yyl1327 > cap(yyv1327) {

			yyrg1327 := len(yyv1327) > 0
			yyv21327 := yyv1327
			yyrl1327, yyrt1327 = z.DecInferLen(yyl1327, z.DecBasicHandle().MaxInitLen, 64)
			if yyrt1327 {
				if yyrl1327 <= cap(yyv1327) {
					yyv1327 = yyv1327[:yyrl1327]
				} else {
					yyv1327 = make([]HTTPIngressPath, yyrl1327)
				}
			} else {
				yyv1327 = make([]HTTPIngressPath, yyrl1327)
			}
			yyc1327 = true
			yyrr1327 = len(yyv1327)
			if yyrg1327 {
				copy(yyv1327, yyv21327)
			}
		} else if yyl1327 != len(yyv1327) {
			yyv1327 = yyv1327[:yyl1327]
			yyc1327 = true
		}
		yyj1327 := 0
		for ; yyj1327 < yyrr1327; yyj1327++ {
			yyh1327.ElemContainerState(yyj1327)
			if r.TryDecodeAsNil() {
				yyv1327[yyj1327] = HTTPIngressPath{}
			} else {
				yyv1328 := &yyv1327[yyj1327]
				yyv1328.CodecDecodeSelf(d)
			}

		}
		if yyrt1327 {
			for ; yyj1327 < yyl1327; yyj1327++ {
				yyv1327 = append(yyv1327, HTTPIngressPath{})
				yyh1327.ElemContainerState(yyj1327)
				if r.TryDecodeAsNil() {
					yyv1327[yyj1327] = HTTPIngressPath{}
				} else {
					yyv1329 := &yyv1327[yyj1327]
					yyv1329.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1327 := 0
		for ; !r.CheckBreak(); yyj1327++ {

			if yyj1327 >= len(yyv1327) {
				yyv1327 = append(yyv1327, HTTPIngressPath{}) // var yyz1327 HTTPIngressPath
				yyc1327 = true
			}
			yyh1327.ElemContainerState(yyj1327)
			if yyj1327 < len(yyv1327) {
				if r.TryDecodeAsNil() {
					yyv1327[yyj1327] = HTTPIngressPath{}
				} else {
					yyv1330 := &yyv1327[yyj1327]
					yyv1330.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1327 < len(yyv1327) {
			yyv1327 = yyv1327[:yyj1327]
			yyc1327 = true
		} else if yyj1327 == 0 && yyv1327 == nil {
			yyv1327 = []HTTPIngressPath{}
			yyc1327 = true
		}
	}
	yyh1327.End()
	if yyc1327 {
		*v = yyv1327
	}
}

func (x codecSelfer1234) encSliceNodeUtilization(v []NodeUtilization, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1331 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1332 := &yyv1331
		yy1332.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNodeUtilization(v *[]NodeUtilization, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1333 := *v
	yyh1333, yyl1333 := z.DecSliceHelperStart()
	var yyc1333 bool
	if yyl1333 == 0 {
		if yyv1333 == nil {
			yyv1333 = []NodeUtilization{}
			yyc1333 = true
		} else if len(yyv1333) != 0 {
			yyv1333 = yyv1333[:0]
			yyc1333 = true
		}
	} else if yyl1333 > 0 {
		var yyrr1333, yyrl1333 int
		var yyrt1333 bool
		if yyl1333 > cap(yyv1333) {

			yyrg1333 := len(yyv1333) > 0
			yyv21333 := yyv1333
			yyrl1333, yyrt1333 = z.DecInferLen(yyl1333, z.DecBasicHandle().MaxInitLen, 24)
			if yyrt1333 {
				if yyrl1333 <= cap(yyv1333) {
					yyv1333 = yyv1333[:yyrl1333]
				} else {
					yyv1333 = make([]NodeUtilization, yyrl1333)
				}
			} else {
				yyv1333 = make([]NodeUtilization, yyrl1333)
			}
			yyc1333 = true
			yyrr1333 = len(yyv1333)
			if yyrg1333 {
				copy(yyv1333, yyv21333)
			}
		} else if yyl1333 != len(yyv1333) {
			yyv1333 = yyv1333[:yyl1333]
			yyc1333 = true
		}
		yyj1333 := 0
		for ; yyj1333 < yyrr1333; yyj1333++ {
			yyh1333.ElemContainerState(yyj1333)
			if r.TryDecodeAsNil() {
				yyv1333[yyj1333] = NodeUtilization{}
			} else {
				yyv1334 := &yyv1333[yyj1333]
				yyv1334.CodecDecodeSelf(d)
			}

		}
		if yyrt1333 {
			for ; yyj1333 < yyl1333; yyj1333++ {
				yyv1333 = append(yyv1333, NodeUtilization{})
				yyh1333.ElemContainerState(yyj1333)
				if r.TryDecodeAsNil() {
					yyv1333[yyj1333] = NodeUtilization{}
				} else {
					yyv1335 := &yyv1333[yyj1333]
					yyv1335.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1333 := 0
		for ; !r.CheckBreak(); yyj1333++ {

			if yyj1333 >= len(yyv1333) {
				yyv1333 = append(yyv1333, NodeUtilization{}) // var yyz1333 NodeUtilization
				yyc1333 = true
			}
			yyh1333.ElemContainerState(yyj1333)
			if yyj1333 < len(yyv1333) {
				if r.TryDecodeAsNil() {
					yyv1333[yyj1333] = NodeUtilization{}
				} else {
					yyv1336 := &yyv1333[yyj1333]
					yyv1336.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1333 < len(yyv1333) {
			yyv1333 = yyv1333[:yyj1333]
			yyc1333 = true
		} else if yyj1333 == 0 && yyv1333 == nil {
			yyv1333 = []NodeUtilization{}
			yyc1333 = true
		}
	}
	yyh1333.End()
	if yyc1333 {
		*v = yyv1333
	}
}

func (x codecSelfer1234) encSliceClusterAutoscaler(v []ClusterAutoscaler, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1337 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1338 := &yyv1337
		yy1338.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceClusterAutoscaler(v *[]ClusterAutoscaler, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1339 := *v
	yyh1339, yyl1339 := z.DecSliceHelperStart()
	var yyc1339 bool
	if yyl1339 == 0 {
		if yyv1339 == nil {
			yyv1339 = []ClusterAutoscaler{}
			yyc1339 = true
		} else if len(yyv1339) != 0 {
			yyv1339 = yyv1339[:0]
			yyc1339 = true
		}
	} else if yyl1339 > 0 {
		var yyrr1339, yyrl1339 int
		var yyrt1339 bool
		if yyl1339 > cap(yyv1339) {

			yyrg1339 := len(yyv1339) > 0
			yyv21339 := yyv1339
			yyrl1339, yyrt1339 = z.DecInferLen(yyl1339, z.DecBasicHandle().MaxInitLen, 224)
			if yyrt1339 {
				if yyrl1339 <= cap(yyv1339) {
					yyv1339 = yyv1339[:yyrl1339]
				} else {
					yyv1339 = make([]ClusterAutoscaler, yyrl1339)
				}
			} else {
				yyv1339 = make([]ClusterAutoscaler, yyrl1339)
			}
			yyc1339 = true
			yyrr1339 = len(yyv1339)
			if yyrg1339 {
				copy(yyv1339, yyv21339)
			}
		} else if yyl1339 != len(yyv1339) {
			yyv1339 = yyv1339[:yyl1339]
			yyc1339 = true
		}
		yyj1339 := 0
		for ; yyj1339 < yyrr1339; yyj1339++ {
			yyh1339.ElemContainerState(yyj1339)
			if r.TryDecodeAsNil() {
				yyv1339[yyj1339] = ClusterAutoscaler{}
			} else {
				yyv1340 := &yyv1339[yyj1339]
				yyv1340.CodecDecodeSelf(d)
			}

		}
		if yyrt1339 {
			for ; yyj1339 < yyl1339; yyj1339++ {
				yyv1339 = append(yyv1339, ClusterAutoscaler{})
				yyh1339.ElemContainerState(yyj1339)
				if r.TryDecodeAsNil() {
					yyv1339[yyj1339] = ClusterAutoscaler{}
				} else {
					yyv1341 := &yyv1339[yyj1339]
					yyv1341.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1339 := 0
		for ; !r.CheckBreak(); yyj1339++ {

			if yyj1339 >= len(yyv1339) {
				yyv1339 = append(yyv1339, ClusterAutoscaler{}) // var yyz1339 ClusterAutoscaler
				yyc1339 = true
			}
			yyh1339.ElemContainerState(yyj1339)
			if yyj1339 < len(yyv1339) {
				if r.TryDecodeAsNil() {
					yyv1339[yyj1339] = ClusterAutoscaler{}
				} else {
					yyv1342 := &yyv1339[yyj1339]
					yyv1342.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1339 < len(yyv1339) {
			yyv1339 = yyv1339[:yyj1339]
			yyc1339 = true
		} else if yyj1339 == 0 && yyv1339 == nil {
			yyv1339 = []ClusterAutoscaler{}
			yyc1339 = true
		}
	}
	yyh1339.End()
	if yyc1339 {
		*v = yyv1339
	}
}

func (x codecSelfer1234) encSliceLabelSelectorRequirement(v []LabelSelectorRequirement, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1343 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1344 := &yyv1343
		yy1344.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceLabelSelectorRequirement(v *[]LabelSelectorRequirement, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1345 := *v
	yyh1345, yyl1345 := z.DecSliceHelperStart()
	var yyc1345 bool
	if yyl1345 == 0 {
		if yyv1345 == nil {
			yyv1345 = []LabelSelectorRequirement{}
			yyc1345 = true
		} else if len(yyv1345) != 0 {
			yyv1345 = yyv1345[:0]
			yyc1345 = true
		}
	} else if yyl1345 > 0 {
		var yyrr1345, yyrl1345 int
		var yyrt1345 bool
		if yyl1345 > cap(yyv1345) {

			yyrg1345 := len(yyv1345) > 0
			yyv21345 := yyv1345
			yyrl1345, yyrt1345 = z.DecInferLen(yyl1345, z.DecBasicHandle().MaxInitLen, 56)
			if yyrt1345 {
				if yyrl1345 <= cap(yyv1345) {
					yyv1345 = yyv1345[:yyrl1345]
				} else {
					yyv1345 = make([]LabelSelectorRequirement, yyrl1345)
				}
			} else {
				yyv1345 = make([]LabelSelectorRequirement, yyrl1345)
			}
			yyc1345 = true
			yyrr1345 = len(yyv1345)
			if yyrg1345 {
				copy(yyv1345, yyv21345)
			}
		} else if yyl1345 != len(yyv1345) {
			yyv1345 = yyv1345[:yyl1345]
			yyc1345 = true
		}
		yyj1345 := 0
		for ; yyj1345 < yyrr1345; yyj1345++ {
			yyh1345.ElemContainerState(yyj1345)
			if r.TryDecodeAsNil() {
				yyv1345[yyj1345] = LabelSelectorRequirement{}
			} else {
				yyv1346 := &yyv1345[yyj1345]
				yyv1346.CodecDecodeSelf(d)
			}

		}
		if yyrt1345 {
			for ; yyj1345 < yyl1345; yyj1345++ {
				yyv1345 = append(yyv1345, LabelSelectorRequirement{})
				yyh1345.ElemContainerState(yyj1345)
				if r.TryDecodeAsNil() {
					yyv1345[yyj1345] = LabelSelectorRequirement{}
				} else {
					yyv1347 := &yyv1345[yyj1345]
					yyv1347.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1345 := 0
		for ; !r.CheckBreak(); yyj1345++ {

			if yyj1345 >= len(yyv1345) {
				yyv1345 = append(yyv1345, LabelSelectorRequirement{}) // var yyz1345 LabelSelectorRequirement
				yyc1345 = true
			}
			yyh1345.ElemContainerState(yyj1345)
			if yyj1345 < len(yyv1345) {
				if r.TryDecodeAsNil() {
					yyv1345[yyj1345] = LabelSelectorRequirement{}
				} else {
					yyv1348 := &yyv1345[yyj1345]
					yyv1348.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1345 < len(yyv1345) {
			yyv1345 = yyv1345[:yyj1345]
			yyc1345 = true
		} else if yyj1345 == 0 && yyv1345 == nil {
			yyv1345 = []LabelSelectorRequirement{}
			yyc1345 = true
		}
	}
	yyh1345.End()
	if yyc1345 {
		*v = yyv1345
	}
}

func (x codecSelfer1234) encSliceConfigMap(v []ConfigMap, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1349 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1350 := &yyv1349
		yy1350.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceConfigMap(v *[]ConfigMap, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1351 := *v
	yyh1351, yyl1351 := z.DecSliceHelperStart()
	var yyc1351 bool
	if yyl1351 == 0 {
		if yyv1351 == nil {
			yyv1351 = []ConfigMap{}
			yyc1351 = true
		} else if len(yyv1351) != 0 {
			yyv1351 = yyv1351[:0]
			yyc1351 = true
		}
	} else if yyl1351 > 0 {
		var yyrr1351, yyrl1351 int
		var yyrt1351 bool
		if yyl1351 > cap(yyv1351) {

			yyrg1351 := len(yyv1351) > 0
			yyv21351 := yyv1351
			yyrl1351, yyrt1351 = z.DecInferLen(yyl1351, z.DecBasicHandle().MaxInitLen, 200)
			if yyrt1351 {
				if yyrl1351 <= cap(yyv1351) {
					yyv1351 = yyv1351[:yyrl1351]
				} else {
					yyv1351 = make([]ConfigMap, yyrl1351)
				}
			} else {
				yyv1351 = make([]ConfigMap, yyrl1351)
			}
			yyc1351 = true
			yyrr1351 = len(yyv1351)
			if yyrg1351 {
				copy(yyv1351, yyv21351)
			}
		} else if yyl1351 != len(yyv1351) {
			yyv1351 = yyv1351[:yyl1351]
			yyc1351 = true
		}
		yyj1351 := 0
		for ; yyj1351 < yyrr1351; yyj1351++ {
			yyh1351.ElemContainerState(yyj1351)
			if r.TryDecodeAsNil() {
				yyv1351[yyj1351] = ConfigMap{}
			} else {
				yyv1352 := &yyv1351[yyj1351]
				yyv1352.CodecDecodeSelf(d)
			}

		}
		if yyrt1351 {
			for ; yyj1351 < yyl1351; yyj1351++ {
				yyv1351 = append(yyv1351, ConfigMap{})
				yyh1351.ElemContainerState(yyj1351)
				if r.TryDecodeAsNil() {
					yyv1351[yyj1351] = ConfigMap{}
				} else {
					yyv1353 := &yyv1351[yyj1351]
					yyv1353.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1351 := 0
		for ; !r.CheckBreak(); yyj1351++ {

			if yyj1351 >= len(yyv1351) {
				yyv1351 = append(yyv1351, ConfigMap{}) // var yyz1351 ConfigMap
				yyc1351 = true
			}
			yyh1351.ElemContainerState(yyj1351)
			if yyj1351 < len(yyv1351) {
				if r.TryDecodeAsNil() {
					yyv1351[yyj1351] = ConfigMap{}
				} else {
					yyv1354 := &yyv1351[yyj1351]
					yyv1354.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1351 < len(yyv1351) {
			yyv1351 = yyv1351[:yyj1351]
			yyc1351 = true
		} else if yyj1351 == 0 && yyv1351 == nil {
			yyv1351 = []ConfigMap{}
			yyc1351 = true
		}
	}
	yyh1351.End()
	if yyc1351 {
		*v = yyv1351
	}
}
