/*
Copyright 2015 The Kubernetes Authors All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package componentconfig

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg1_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg1_unversioned.TypeMeta
		var v1 time.Duration
		_, _ = v0, v1
	}
}

func (x *KubeProxyConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [18]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[16] = x.Kind != ""
			yyq2[17] = x.APIVersion != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(18)
			} else {
				yynn2 = 16
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("bindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym13 := z.EncBinary()
				_ = yym13
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym14 := z.EncBinary()
				_ = yym14
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.IPTablesMasqueradeBit == nil {
					r.EncodeNil()
				} else {
					yy16 := *x.IPTablesMasqueradeBit
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeInt(int64(yy16))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMasqueradeBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.IPTablesMasqueradeBit == nil {
					r.EncodeNil()
				} else {
					yy18 := *x.IPTablesMasqueradeBit
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeInt(int64(yy18))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy21 := &x.IPTablesSyncPeriod
				yym22 := z.EncBinary()
				_ = yym22
				if false {
				} else if z.HasExtensions() && z.EncExt(yy21) {
				} else if !yym22 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy21)
				} else {
					z.EncFallback(yy21)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesSyncPeriodSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy23 := &x.IPTablesSyncPeriod
				yym24 := z.EncBinary()
				_ = yym24
				if false {
				} else if z.HasExtensions() && z.EncExt(yy23) {
				} else if !yym24 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy23)
				} else {
					z.EncFallback(yy23)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym26 := z.EncBinary()
				_ = yym26
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeconfigPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym27 := z.EncBinary()
				_ = yym27
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym29 := z.EncBinary()
				_ = yym29
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masqueradeAll"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym30 := z.EncBinary()
				_ = yym30
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym32 := z.EncBinary()
				_ = yym32
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("master"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym33 := z.EncBinary()
				_ = yym33
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy35 := *x.OOMScoreAdj
					yym36 := z.EncBinary()
					_ = yym36
					if false {
					} else {
						r.EncodeInt(int64(yy35))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy37 := *x.OOMScoreAdj
					yym38 := z.EncBinary()
					_ = yym38
					if false {
					} else {
						r.EncodeInt(int64(yy37))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Mode.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Mode.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym43 := z.EncBinary()
				_ = yym43
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("portRange"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym44 := z.EncBinary()
				_ = yym44
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym46 := z.EncBinary()
				_ = yym46
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeletCgroups"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym47 := z.EncBinary()
				_ = yym47
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy49 := &x.UDPIdleTimeout
				yym50 := z.EncBinary()
				_ = yym50
				if false {
				} else if z.HasExtensions() && z.EncExt(yy49) {
				} else if !yym50 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy49)
				} else {
					z.EncFallback(yy49)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("udpTimeoutMilliseconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy51 := &x.UDPIdleTimeout
				yym52 := z.EncBinary()
				_ = yym52
				if false {
				} else if z.HasExtensions() && z.EncExt(yy51) {
				} else if !yym52 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy51)
				} else {
					z.EncFallback(yy51)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym54 := z.EncBinary()
				_ = yym54
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMax))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMax"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym55 := z.EncBinary()
				_ = yym55
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMax))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy57 := &x.ConntrackTCPEstablishedTimeout
				yym58 := z.EncBinary()
				_ = yym58
				if false {
				} else if z.HasExtensions() && z.EncExt(yy57) {
				} else if !yym58 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy57)
				} else {
					z.EncFallback(yy57)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackTCPEstablishedTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy59 := &x.ConntrackTCPEstablishedTimeout
				yym60 := z.EncBinary()
				_ = yym60
				if false {
				} else if z.HasExtensions() && z.EncExt(yy59) {
				} else if !yym60 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy59)
				} else {
					z.EncFallback(yy59)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[16] {
					yym62 := z.EncBinary()
					_ = yym62
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym63 := z.EncBinary()
					_ = yym63
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[17] {
					yym65 := z.EncBinary()
					_ = yym65
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym66 := z.EncBinary()
					_ = yym66
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeProxyConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "bindAddress":
			if r.TryDecodeAsNil() {
				x.BindAddress = ""
			} else {
				x.BindAddress = string(r.DecodeString())
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "iptablesMasqueradeBit":
			if r.TryDecodeAsNil() {
				if x.IPTablesMasqueradeBit != nil {
					x.IPTablesMasqueradeBit = nil
				}
			} else {
				if x.IPTablesMasqueradeBit == nil {
					x.IPTablesMasqueradeBit = new(int)
				}
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*int)(x.IPTablesMasqueradeBit)) = int(r.DecodeInt(codecSelferBitsize1234))
				}
			}
		case "iptablesSyncPeriodSeconds":
			if r.TryDecodeAsNil() {
				x.IPTablesSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv10 := &x.IPTablesSyncPeriod
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv10) {
				} else if !yym11 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv10)
				} else {
					z.DecFallback(yyv10, false)
				}
			}
		case "kubeconfigPath":
			if r.TryDecodeAsNil() {
				x.KubeconfigPath = ""
			} else {
				x.KubeconfigPath = string(r.DecodeString())
			}
		case "masqueradeAll":
			if r.TryDecodeAsNil() {
				x.MasqueradeAll = false
			} else {
				x.MasqueradeAll = bool(r.DecodeBool())
			}
		case "master":
			if r.TryDecodeAsNil() {
				x.Master = ""
			} else {
				x.Master = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				if x.OOMScoreAdj != nil {
					x.OOMScoreAdj = nil
				}
			} else {
				if x.OOMScoreAdj == nil {
					x.OOMScoreAdj = new(int)
				}
				yym16 := z.DecBinary()
				_ = yym16
				if false {
				} else {
					*((*int)(x.OOMScoreAdj)) = int(r.DecodeInt(codecSelferBitsize1234))
				}
			}
		case "mode":
			if r.TryDecodeAsNil() {
				x.Mode = ""
			} else {
				x.Mode = ProxyMode(r.DecodeString())
			}
		case "portRange":
			if r.TryDecodeAsNil() {
				x.PortRange = ""
			} else {
				x.PortRange = string(r.DecodeString())
			}
		case "kubeletCgroups":
			if r.TryDecodeAsNil() {
				x.ResourceContainer = ""
			} else {
				x.ResourceContainer = string(r.DecodeString())
			}
		case "udpTimeoutMilliseconds":
			if r.TryDecodeAsNil() {
				x.UDPIdleTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv20 := &x.UDPIdleTimeout
				yym21 := z.DecBinary()
				_ = yym21
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv20) {
				} else if !yym21 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv20)
				} else {
					z.DecFallback(yyv20, false)
				}
			}
		case "conntrackMax":
			if r.TryDecodeAsNil() {
				x.ConntrackMax = 0
			} else {
				x.ConntrackMax = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "conntrackTCPEstablishedTimeout":
			if r.TryDecodeAsNil() {
				x.ConntrackTCPEstablishedTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv23 := &x.ConntrackTCPEstablishedTimeout
				yym24 := z.DecBinary()
				_ = yym24
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv23) {
				} else if !yym24 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv23)
				} else {
					z.DecFallback(yyv23, false)
				}
			}
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj27 int
	var yyb27 bool
	var yyhl27 bool = l >= 0
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BindAddress = ""
	} else {
		x.BindAddress = string(r.DecodeString())
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.IPTablesMasqueradeBit != nil {
			x.IPTablesMasqueradeBit = nil
		}
	} else {
		if x.IPTablesMasqueradeBit == nil {
			x.IPTablesMasqueradeBit = new(int)
		}
		yym33 := z.DecBinary()
		_ = yym33
		if false {
		} else {
			*((*int)(x.IPTablesMasqueradeBit)) = int(r.DecodeInt(codecSelferBitsize1234))
		}
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv34 := &x.IPTablesSyncPeriod
		yym35 := z.DecBinary()
		_ = yym35
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv34) {
		} else if !yym35 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv34)
		} else {
			z.DecFallback(yyv34, false)
		}
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeconfigPath = ""
	} else {
		x.KubeconfigPath = string(r.DecodeString())
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasqueradeAll = false
	} else {
		x.MasqueradeAll = bool(r.DecodeBool())
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Master = ""
	} else {
		x.Master = string(r.DecodeString())
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.OOMScoreAdj != nil {
			x.OOMScoreAdj = nil
		}
	} else {
		if x.OOMScoreAdj == nil {
			x.OOMScoreAdj = new(int)
		}
		yym40 := z.DecBinary()
		_ = yym40
		if false {
		} else {
			*((*int)(x.OOMScoreAdj)) = int(r.DecodeInt(codecSelferBitsize1234))
		}
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Mode = ""
	} else {
		x.Mode = ProxyMode(r.DecodeString())
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PortRange = ""
	} else {
		x.PortRange = string(r.DecodeString())
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceContainer = ""
	} else {
		x.ResourceContainer = string(r.DecodeString())
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UDPIdleTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv44 := &x.UDPIdleTimeout
		yym45 := z.DecBinary()
		_ = yym45
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv44) {
		} else if !yym45 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv44)
		} else {
			z.DecFallback(yyv44, false)
		}
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMax = 0
	} else {
		x.ConntrackMax = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackTCPEstablishedTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv47 := &x.ConntrackTCPEstablishedTimeout
		yym48 := z.DecBinary()
		_ = yym48
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv47) {
		} else if !yym48 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv47)
		} else {
			z.DecFallback(yyv47, false)
		}
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj27++
	if yyhl27 {
		yyb27 = yyj27 > l
	} else {
		yyb27 = r.CheckBreak()
	}
	if yyb27 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	for {
		yyj27++
		if yyhl27 {
			yyb27 = yyj27 > l
		} else {
			yyb27 = r.CheckBreak()
		}
		if yyb27 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj27-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ProxyMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ProxyMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x HairpinMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *HairpinMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *KubeletConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [77]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[47] = x.CloudProvider != ""
			yyq2[48] = x.CloudConfigFile != ""
			yyq2[49] = x.KubeletCgroups != ""
			yyq2[50] = x.RuntimeCgroups != ""
			yyq2[51] = x.SystemCgroups != ""
			yyq2[52] = x.CgroupRoot != ""
			yyq2[54] = x.RktPath != ""
			yyq2[56] = x.RktStage1Image != ""
			yyq2[72] = true
			yyq2[73] = x.NodeIP != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(77)
			} else {
				yynn2 = 67
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Config))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("config"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Config))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy7 := &x.SyncFrequency
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else if z.HasExtensions() && z.EncExt(yy7) {
				} else if !yym8 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy7)
				} else {
					z.EncFallback(yy7)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("syncFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy9 := &x.SyncFrequency
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else if z.HasExtensions() && z.EncExt(yy9) {
				} else if !yym10 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy9)
				} else {
					z.EncFallback(yy9)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy12 := &x.FileCheckFrequency
				yym13 := z.EncBinary()
				_ = yym13
				if false {
				} else if z.HasExtensions() && z.EncExt(yy12) {
				} else if !yym13 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy12)
				} else {
					z.EncFallback(yy12)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fileCheckFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy14 := &x.FileCheckFrequency
				yym15 := z.EncBinary()
				_ = yym15
				if false {
				} else if z.HasExtensions() && z.EncExt(yy14) {
				} else if !yym15 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy14)
				} else {
					z.EncFallback(yy14)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy17 := &x.HTTPCheckFrequency
				yym18 := z.EncBinary()
				_ = yym18
				if false {
				} else if z.HasExtensions() && z.EncExt(yy17) {
				} else if !yym18 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy17)
				} else {
					z.EncFallback(yy17)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("httpCheckFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy19 := &x.HTTPCheckFrequency
				yym20 := z.EncBinary()
				_ = yym20
				if false {
				} else if z.HasExtensions() && z.EncExt(yy19) {
				} else if !yym20 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy19)
				} else {
					z.EncFallback(yy19)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym22 := z.EncBinary()
				_ = yym22
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURL))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("manifestURL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym23 := z.EncBinary()
				_ = yym23
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURL))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym25 := z.EncBinary()
				_ = yym25
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURLHeader))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("manifestURLHeader"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym26 := z.EncBinary()
				_ = yym26
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURLHeader))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym28 := z.EncBinary()
				_ = yym28
				if false {
				} else {
					r.EncodeBool(bool(x.EnableServer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableServer"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym29 := z.EncBinary()
				_ = yym29
				if false {
				} else {
					r.EncodeBool(bool(x.EnableServer))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym31 := z.EncBinary()
				_ = yym31
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym32 := z.EncBinary()
				_ = yym32
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym34 := z.EncBinary()
				_ = yym34
				if false {
				} else {
					r.EncodeUint(uint64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym35 := z.EncBinary()
				_ = yym35
				if false {
				} else {
					r.EncodeUint(uint64(x.Port))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym37 := z.EncBinary()
				_ = yym37
				if false {
				} else {
					r.EncodeUint(uint64(x.ReadOnlyPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("readOnlyPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym38 := z.EncBinary()
				_ = yym38
				if false {
				} else {
					r.EncodeUint(uint64(x.ReadOnlyPort))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym40 := z.EncBinary()
				_ = yym40
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSCertFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("tLSCertFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym41 := z.EncBinary()
				_ = yym41
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSCertFile))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym43 := z.EncBinary()
				_ = yym43
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSPrivateKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("tLSPrivateKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym44 := z.EncBinary()
				_ = yym44
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSPrivateKeyFile))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym46 := z.EncBinary()
				_ = yym46
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CertDirectory))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("certDirectory"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym47 := z.EncBinary()
				_ = yym47
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CertDirectory))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym49 := z.EncBinary()
				_ = yym49
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym50 := z.EncBinary()
				_ = yym50
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym52 := z.EncBinary()
				_ = yym52
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodInfraContainerImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podInfraContainerImage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym53 := z.EncBinary()
				_ = yym53
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodInfraContainerImage))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym55 := z.EncBinary()
				_ = yym55
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("dockerEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym56 := z.EncBinary()
				_ = yym56
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerEndpoint))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym58 := z.EncBinary()
				_ = yym58
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootDirectory))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rootDirectory"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym59 := z.EncBinary()
				_ = yym59
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootDirectory))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym61 := z.EncBinary()
				_ = yym61
				if false {
				} else {
					r.EncodeBool(bool(x.AllowPrivileged))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allowPrivileged"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym62 := z.EncBinary()
				_ = yym62
				if false {
				} else {
					r.EncodeBool(bool(x.AllowPrivileged))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym64 := z.EncBinary()
				_ = yym64
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostNetworkSources))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostNetworkSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym65 := z.EncBinary()
				_ = yym65
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostNetworkSources))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym67 := z.EncBinary()
				_ = yym67
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostPIDSources))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostPIDSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym68 := z.EncBinary()
				_ = yym68
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostPIDSources))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym70 := z.EncBinary()
				_ = yym70
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostIPCSources))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostIPCSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym71 := z.EncBinary()
				_ = yym71
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostIPCSources))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym73 := z.EncBinary()
				_ = yym73
				if false {
				} else {
					r.EncodeFloat64(float64(x.RegistryPullQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registryPullQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym74 := z.EncBinary()
				_ = yym74
				if false {
				} else {
					r.EncodeFloat64(float64(x.RegistryPullQPS))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym76 := z.EncBinary()
				_ = yym76
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registryBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym77 := z.EncBinary()
				_ = yym77
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryBurst))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym79 := z.EncBinary()
				_ = yym79
				if false {
				} else {
					r.EncodeFloat32(float32(x.EventRecordQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("eventRecordQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym80 := z.EncBinary()
				_ = yym80
				if false {
				} else {
					r.EncodeFloat32(float32(x.EventRecordQPS))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym82 := z.EncBinary()
				_ = yym82
				if false {
				} else {
					r.EncodeInt(int64(x.EventBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("eventBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym83 := z.EncBinary()
				_ = yym83
				if false {
				} else {
					r.EncodeInt(int64(x.EventBurst))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym85 := z.EncBinary()
				_ = yym85
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDebuggingHandlers))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableDebuggingHandlers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym86 := z.EncBinary()
				_ = yym86
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDebuggingHandlers))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy88 := &x.MinimumGCAge
				yym89 := z.EncBinary()
				_ = yym89
				if false {
				} else if z.HasExtensions() && z.EncExt(yy88) {
				} else if !yym89 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy88)
				} else {
					z.EncFallback(yy88)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumGCAge"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy90 := &x.MinimumGCAge
				yym91 := z.EncBinary()
				_ = yym91
				if false {
				} else if z.HasExtensions() && z.EncExt(yy90) {
				} else if !yym91 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy90)
				} else {
					z.EncFallback(yy90)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym93 := z.EncBinary()
				_ = yym93
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPerPodContainerCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxPerPodContainerCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym94 := z.EncBinary()
				_ = yym94
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPerPodContainerCount))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym96 := z.EncBinary()
				_ = yym96
				if false {
				} else {
					r.EncodeInt(int64(x.MaxContainerCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxContainerCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym97 := z.EncBinary()
				_ = yym97
				if false {
				} else {
					r.EncodeInt(int64(x.MaxContainerCount))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym99 := z.EncBinary()
				_ = yym99
				if false {
				} else {
					r.EncodeUint(uint64(x.CAdvisorPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cAdvisorPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym100 := z.EncBinary()
				_ = yym100
				if false {
				} else {
					r.EncodeUint(uint64(x.CAdvisorPort))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym102 := z.EncBinary()
				_ = yym102
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym103 := z.EncBinary()
				_ = yym103
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym105 := z.EncBinary()
				_ = yym105
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym106 := z.EncBinary()
				_ = yym106
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym108 := z.EncBinary()
				_ = yym108
				if false {
				} else {
					r.EncodeInt(int64(x.OOMScoreAdj))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym109 := z.EncBinary()
				_ = yym109
				if false {
				} else {
					r.EncodeInt(int64(x.OOMScoreAdj))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym111 := z.EncBinary()
				_ = yym111
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterNode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerNode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym112 := z.EncBinary()
				_ = yym112
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterNode))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym114 := z.EncBinary()
				_ = yym114
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDomain))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterDomain"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym115 := z.EncBinary()
				_ = yym115
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDomain))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym117 := z.EncBinary()
				_ = yym117
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MasterServiceNamespace))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masterServiceNamespace"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym118 := z.EncBinary()
				_ = yym118
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MasterServiceNamespace))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym120 := z.EncBinary()
				_ = yym120
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDNS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterDNS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym121 := z.EncBinary()
				_ = yym121
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDNS))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy123 := &x.StreamingConnectionIdleTimeout
				yym124 := z.EncBinary()
				_ = yym124
				if false {
				} else if z.HasExtensions() && z.EncExt(yy123) {
				} else if !yym124 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy123)
				} else {
					z.EncFallback(yy123)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("streamingConnectionIdleTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy125 := &x.StreamingConnectionIdleTimeout
				yym126 := z.EncBinary()
				_ = yym126
				if false {
				} else if z.HasExtensions() && z.EncExt(yy125) {
				} else if !yym126 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy125)
				} else {
					z.EncFallback(yy125)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy128 := &x.NodeStatusUpdateFrequency
				yym129 := z.EncBinary()
				_ = yym129
				if false {
				} else if z.HasExtensions() && z.EncExt(yy128) {
				} else if !yym129 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy128)
				} else {
					z.EncFallback(yy128)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeStatusUpdateFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy130 := &x.NodeStatusUpdateFrequency
				yym131 := z.EncBinary()
				_ = yym131
				if false {
				} else if z.HasExtensions() && z.EncExt(yy130) {
				} else if !yym131 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy130)
				} else {
					z.EncFallback(yy130)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy133 := &x.ImageMinimumGCAge
				yym134 := z.EncBinary()
				_ = yym134
				if false {
				} else if z.HasExtensions() && z.EncExt(yy133) {
				} else if !yym134 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy133)
				} else {
					z.EncFallback(yy133)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageMinimumGCAge"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy135 := &x.ImageMinimumGCAge
				yym136 := z.EncBinary()
				_ = yym136
				if false {
				} else if z.HasExtensions() && z.EncExt(yy135) {
				} else if !yym136 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy135)
				} else {
					z.EncFallback(yy135)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym138 := z.EncBinary()
				_ = yym138
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCHighThresholdPercent))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageGCHighThresholdPercent"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym139 := z.EncBinary()
				_ = yym139
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCHighThresholdPercent))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym141 := z.EncBinary()
				_ = yym141
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCLowThresholdPercent))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageGCLowThresholdPercent"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym142 := z.EncBinary()
				_ = yym142
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCLowThresholdPercent))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym144 := z.EncBinary()
				_ = yym144
				if false {
				} else {
					r.EncodeInt(int64(x.LowDiskSpaceThresholdMB))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lowDiskSpaceThresholdMB"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym145 := z.EncBinary()
				_ = yym145
				if false {
				} else {
					r.EncodeInt(int64(x.LowDiskSpaceThresholdMB))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy147 := &x.VolumeStatsAggPeriod
				yym148 := z.EncBinary()
				_ = yym148
				if false {
				} else if z.HasExtensions() && z.EncExt(yy147) {
				} else if !yym148 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy147)
				} else {
					z.EncFallback(yy147)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("VolumeStatsAggPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy149 := &x.VolumeStatsAggPeriod
				yym150 := z.EncBinary()
				_ = yym150
				if false {
				} else if z.HasExtensions() && z.EncExt(yy149) {
				} else if !yym150 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy149)
				} else {
					z.EncFallback(yy149)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym152 := z.EncBinary()
				_ = yym152
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym153 := z.EncBinary()
				_ = yym153
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginName))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym155 := z.EncBinary()
				_ = yym155
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym156 := z.EncBinary()
				_ = yym156
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginDir))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym158 := z.EncBinary()
				_ = yym158
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumePluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym159 := z.EncBinary()
				_ = yym159
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePluginDir))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[47] {
					yym161 := z.EncBinary()
					_ = yym161
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[47] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cloudProvider"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym162 := z.EncBinary()
					_ = yym162
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[48] {
					yym164 := z.EncBinary()
					_ = yym164
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[48] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cloudConfigFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym165 := z.EncBinary()
					_ = yym165
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[49] {
					yym167 := z.EncBinary()
					_ = yym167
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.KubeletCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[49] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kubeletCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym168 := z.EncBinary()
					_ = yym168
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.KubeletCgroups))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[50] {
					yym170 := z.EncBinary()
					_ = yym170
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RuntimeCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[50] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runtimeCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym171 := z.EncBinary()
					_ = yym171
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RuntimeCgroups))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[51] {
					yym173 := z.EncBinary()
					_ = yym173
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SystemCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[51] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("systemContainer"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym174 := z.EncBinary()
					_ = yym174
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SystemCgroups))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[52] {
					yym176 := z.EncBinary()
					_ = yym176
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupRoot))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[52] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cgroupRoot"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym177 := z.EncBinary()
					_ = yym177
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupRoot))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym179 := z.EncBinary()
				_ = yym179
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntime))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerRuntime"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym180 := z.EncBinary()
				_ = yym180
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntime))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[54] {
					yym182 := z.EncBinary()
					_ = yym182
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[54] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym183 := z.EncBinary()
					_ = yym183
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktPath))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym185 := z.EncBinary()
				_ = yym185
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.LockFilePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lockFilePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym186 := z.EncBinary()
				_ = yym186
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.LockFilePath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[56] {
					yym188 := z.EncBinary()
					_ = yym188
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktStage1Image))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[56] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktStage1Image"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym189 := z.EncBinary()
					_ = yym189
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktStage1Image))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym191 := z.EncBinary()
				_ = yym191
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCBR0))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("configureCbr0"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym192 := z.EncBinary()
				_ = yym192
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCBR0))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym194 := z.EncBinary()
				_ = yym194
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HairpinMode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hairpinMode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym195 := z.EncBinary()
				_ = yym195
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HairpinMode))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym197 := z.EncBinary()
				_ = yym197
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPods))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxPods"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym198 := z.EncBinary()
				_ = yym198
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPods))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym200 := z.EncBinary()
				_ = yym200
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerExecHandlerName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("dockerExecHandlerName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym201 := z.EncBinary()
				_ = yym201
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerExecHandlerName))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym203 := z.EncBinary()
				_ = yym203
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym204 := z.EncBinary()
				_ = yym204
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym206 := z.EncBinary()
				_ = yym206
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResolverConfig))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resolvConf"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym207 := z.EncBinary()
				_ = yym207
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResolverConfig))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym209 := z.EncBinary()
				_ = yym209
				if false {
				} else {
					r.EncodeBool(bool(x.CPUCFSQuota))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cpuCFSQuota"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym210 := z.EncBinary()
				_ = yym210
				if false {
				} else {
					r.EncodeBool(bool(x.CPUCFSQuota))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym212 := z.EncBinary()
				_ = yym212
				if false {
				} else {
					r.EncodeBool(bool(x.Containerized))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerized"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym213 := z.EncBinary()
				_ = yym213
				if false {
				} else {
					r.EncodeBool(bool(x.Containerized))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym215 := z.EncBinary()
				_ = yym215
				if false {
				} else {
					r.EncodeUint(uint64(x.MaxOpenFiles))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxOpenFiles"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym216 := z.EncBinary()
				_ = yym216
				if false {
				} else {
					r.EncodeUint(uint64(x.MaxOpenFiles))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym218 := z.EncBinary()
				_ = yym218
				if false {
				} else {
					r.EncodeBool(bool(x.ReconcileCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("reconcileCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym219 := z.EncBinary()
				_ = yym219
				if false {
				} else {
					r.EncodeBool(bool(x.ReconcileCIDR))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym221 := z.EncBinary()
				_ = yym221
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterSchedulable))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerSchedulable"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym222 := z.EncBinary()
				_ = yym222
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterSchedulable))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym224 := z.EncBinary()
				_ = yym224
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym225 := z.EncBinary()
				_ = yym225
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym227 := z.EncBinary()
				_ = yym227
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym228 := z.EncBinary()
				_ = yym228
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym230 := z.EncBinary()
				_ = yym230
				if false {
				} else {
					r.EncodeBool(bool(x.SerializeImagePulls))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serializeImagePulls"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym231 := z.EncBinary()
				_ = yym231
				if false {
				} else {
					r.EncodeBool(bool(x.SerializeImagePulls))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym233 := z.EncBinary()
				_ = yym233
				if false {
				} else {
					r.EncodeBool(bool(x.ExperimentalFlannelOverlay))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("experimentalFlannelOverlay"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym234 := z.EncBinary()
				_ = yym234
				if false {
				} else {
					r.EncodeBool(bool(x.ExperimentalFlannelOverlay))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[72] {
					yy236 := &x.OutOfDiskTransitionFrequency
					yym237 := z.EncBinary()
					_ = yym237
					if false {
					} else if z.HasExtensions() && z.EncExt(yy236) {
					} else if !yym237 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy236)
					} else {
						z.EncFallback(yy236)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[72] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("outOfDiskTransitionFrequency"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy238 := &x.OutOfDiskTransitionFrequency
					yym239 := z.EncBinary()
					_ = yym239
					if false {
					} else if z.HasExtensions() && z.EncExt(yy238) {
					} else if !yym239 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy238)
					} else {
						z.EncFallback(yy238)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[73] {
					yym241 := z.EncBinary()
					_ = yym241
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[73] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym242 := z.EncBinary()
					_ = yym242
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeIP))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NodeLabels == nil {
					r.EncodeNil()
				} else {
					yym244 := z.EncBinary()
					_ = yym244
					if false {
					} else {
						z.F.EncMapStringStringV(x.NodeLabels, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeLabels"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NodeLabels == nil {
					r.EncodeNil()
				} else {
					yym245 := z.EncBinary()
					_ = yym245
					if false {
					} else {
						z.F.EncMapStringStringV(x.NodeLabels, false, e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym247 := z.EncBinary()
				_ = yym247
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NonMasqueradeCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nonMasqueradeCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym248 := z.EncBinary()
				_ = yym248
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NonMasqueradeCIDR))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym250 := z.EncBinary()
				_ = yym250
				if false {
				} else {
					r.EncodeBool(bool(x.EnableCustomMetrics))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableCustomMetrics"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym251 := z.EncBinary()
				_ = yym251
				if false {
				} else {
					r.EncodeBool(bool(x.EnableCustomMetrics))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "config":
			if r.TryDecodeAsNil() {
				x.Config = ""
			} else {
				x.Config = string(r.DecodeString())
			}
		case "syncFrequency":
			if r.TryDecodeAsNil() {
				x.SyncFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv5 := &x.SyncFrequency
				yym6 := z.DecBinary()
				_ = yym6
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv5) {
				} else if !yym6 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv5)
				} else {
					z.DecFallback(yyv5, false)
				}
			}
		case "fileCheckFrequency":
			if r.TryDecodeAsNil() {
				x.FileCheckFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv7 := &x.FileCheckFrequency
				yym8 := z.DecBinary()
				_ = yym8
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv7) {
				} else if !yym8 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv7)
				} else {
					z.DecFallback(yyv7, false)
				}
			}
		case "httpCheckFrequency":
			if r.TryDecodeAsNil() {
				x.HTTPCheckFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv9 := &x.HTTPCheckFrequency
				yym10 := z.DecBinary()
				_ = yym10
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv9) {
				} else if !yym10 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv9)
				} else {
					z.DecFallback(yyv9, false)
				}
			}
		case "manifestURL":
			if r.TryDecodeAsNil() {
				x.ManifestURL = ""
			} else {
				x.ManifestURL = string(r.DecodeString())
			}
		case "manifestURLHeader":
			if r.TryDecodeAsNil() {
				x.ManifestURLHeader = ""
			} else {
				x.ManifestURLHeader = string(r.DecodeString())
			}
		case "enableServer":
			if r.TryDecodeAsNil() {
				x.EnableServer = false
			} else {
				x.EnableServer = bool(r.DecodeBool())
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = uint(r.DecodeUint(codecSelferBitsize1234))
			}
		case "readOnlyPort":
			if r.TryDecodeAsNil() {
				x.ReadOnlyPort = 0
			} else {
				x.ReadOnlyPort = uint(r.DecodeUint(codecSelferBitsize1234))
			}
		case "tLSCertFile":
			if r.TryDecodeAsNil() {
				x.TLSCertFile = ""
			} else {
				x.TLSCertFile = string(r.DecodeString())
			}
		case "tLSPrivateKeyFile":
			if r.TryDecodeAsNil() {
				x.TLSPrivateKeyFile = ""
			} else {
				x.TLSPrivateKeyFile = string(r.DecodeString())
			}
		case "certDirectory":
			if r.TryDecodeAsNil() {
				x.CertDirectory = ""
			} else {
				x.CertDirectory = string(r.DecodeString())
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "podInfraContainerImage":
			if r.TryDecodeAsNil() {
				x.PodInfraContainerImage = ""
			} else {
				x.PodInfraContainerImage = string(r.DecodeString())
			}
		case "dockerEndpoint":
			if r.TryDecodeAsNil() {
				x.DockerEndpoint = ""
			} else {
				x.DockerEndpoint = string(r.DecodeString())
			}
		case "rootDirectory":
			if r.TryDecodeAsNil() {
				x.RootDirectory = ""
			} else {
				x.RootDirectory = string(r.DecodeString())
			}
		case "allowPrivileged":
			if r.TryDecodeAsNil() {
				x.AllowPrivileged = false
			} else {
				x.AllowPrivileged = bool(r.DecodeBool())
			}
		case "hostNetworkSources":
			if r.TryDecodeAsNil() {
				x.HostNetworkSources = ""
			} else {
				x.HostNetworkSources = string(r.DecodeString())
			}
		case "hostPIDSources":
			if r.TryDecodeAsNil() {
				x.HostPIDSources = ""
			} else {
				x.HostPIDSources = string(r.DecodeString())
			}
		case "hostIPCSources":
			if r.TryDecodeAsNil() {
				x.HostIPCSources = ""
			} else {
				x.HostIPCSources = string(r.DecodeString())
			}
		case "registryPullQPS":
			if r.TryDecodeAsNil() {
				x.RegistryPullQPS = 0
			} else {
				x.RegistryPullQPS = float64(r.DecodeFloat(false))
			}
		case "registryBurst":
			if r.TryDecodeAsNil() {
				x.RegistryBurst = 0
			} else {
				x.RegistryBurst = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "eventRecordQPS":
			if r.TryDecodeAsNil() {
				x.EventRecordQPS = 0
			} else {
				x.EventRecordQPS = float32(r.DecodeFloat(true))
			}
		case "eventBurst":
			if r.TryDecodeAsNil() {
				x.EventBurst = 0
			} else {
				x.EventBurst = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "enableDebuggingHandlers":
			if r.TryDecodeAsNil() {
				x.EnableDebuggingHandlers = false
			} else {
				x.EnableDebuggingHandlers = bool(r.DecodeBool())
			}
		case "minimumGCAge":
			if r.TryDecodeAsNil() {
				x.MinimumGCAge = pkg1_unversioned.Duration{}
			} else {
				yyv33 := &x.MinimumGCAge
				yym34 := z.DecBinary()
				_ = yym34
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv33) {
				} else if !yym34 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv33)
				} else {
					z.DecFallback(yyv33, false)
				}
			}
		case "maxPerPodContainerCount":
			if r.TryDecodeAsNil() {
				x.MaxPerPodContainerCount = 0
			} else {
				x.MaxPerPodContainerCount = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "maxContainerCount":
			if r.TryDecodeAsNil() {
				x.MaxContainerCount = 0
			} else {
				x.MaxContainerCount = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "cAdvisorPort":
			if r.TryDecodeAsNil() {
				x.CAdvisorPort = 0
			} else {
				x.CAdvisorPort = uint(r.DecodeUint(codecSelferBitsize1234))
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				x.OOMScoreAdj = 0
			} else {
				x.OOMScoreAdj = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "registerNode":
			if r.TryDecodeAsNil() {
				x.RegisterNode = false
			} else {
				x.RegisterNode = bool(r.DecodeBool())
			}
		case "clusterDomain":
			if r.TryDecodeAsNil() {
				x.ClusterDomain = ""
			} else {
				x.ClusterDomain = string(r.DecodeString())
			}
		case "masterServiceNamespace":
			if r.TryDecodeAsNil() {
				x.MasterServiceNamespace = ""
			} else {
				x.MasterServiceNamespace = string(r.DecodeString())
			}
		case "clusterDNS":
			if r.TryDecodeAsNil() {
				x.ClusterDNS = ""
			} else {
				x.ClusterDNS = string(r.DecodeString())
			}
		case "streamingConnectionIdleTimeout":
			if r.TryDecodeAsNil() {
				x.StreamingConnectionIdleTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv45 := &x.StreamingConnectionIdleTimeout
				yym46 := z.DecBinary()
				_ = yym46
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv45) {
				} else if !yym46 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv45)
				} else {
					z.DecFallback(yyv45, false)
				}
			}
		case "nodeStatusUpdateFrequency":
			if r.TryDecodeAsNil() {
				x.NodeStatusUpdateFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv47 := &x.NodeStatusUpdateFrequency
				yym48 := z.DecBinary()
				_ = yym48
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv47) {
				} else if !yym48 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv47)
				} else {
					z.DecFallback(yyv47, false)
				}
			}
		case "imageMinimumGCAge":
			if r.TryDecodeAsNil() {
				x.ImageMinimumGCAge = pkg1_unversioned.Duration{}
			} else {
				yyv49 := &x.ImageMinimumGCAge
				yym50 := z.DecBinary()
				_ = yym50
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv49) {
				} else if !yym50 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv49)
				} else {
					z.DecFallback(yyv49, false)
				}
			}
		case "imageGCHighThresholdPercent":
			if r.TryDecodeAsNil() {
				x.ImageGCHighThresholdPercent = 0
			} else {
				x.ImageGCHighThresholdPercent = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "imageGCLowThresholdPercent":
			if r.TryDecodeAsNil() {
				x.ImageGCLowThresholdPercent = 0
			} else {
				x.ImageGCLowThresholdPercent = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "lowDiskSpaceThresholdMB":
			if r.TryDecodeAsNil() {
				x.LowDiskSpaceThresholdMB = 0
			} else {
				x.LowDiskSpaceThresholdMB = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "VolumeStatsAggPeriod":
			if r.TryDecodeAsNil() {
				x.VolumeStatsAggPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv54 := &x.VolumeStatsAggPeriod
				yym55 := z.DecBinary()
				_ = yym55
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv54) {
				} else if !yym55 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv54)
				} else {
					z.DecFallback(yyv54, false)
				}
			}
		case "networkPluginName":
			if r.TryDecodeAsNil() {
				x.NetworkPluginName = ""
			} else {
				x.NetworkPluginName = string(r.DecodeString())
			}
		case "networkPluginDir":
			if r.TryDecodeAsNil() {
				x.NetworkPluginDir = ""
			} else {
				x.NetworkPluginDir = string(r.DecodeString())
			}
		case "volumePluginDir":
			if r.TryDecodeAsNil() {
				x.VolumePluginDir = ""
			} else {
				x.VolumePluginDir = string(r.DecodeString())
			}
		case "cloudProvider":
			if r.TryDecodeAsNil() {
				x.CloudProvider = ""
			} else {
				x.CloudProvider = string(r.DecodeString())
			}
		case "cloudConfigFile":
			if r.TryDecodeAsNil() {
				x.CloudConfigFile = ""
			} else {
				x.CloudConfigFile = string(r.DecodeString())
			}
		case "kubeletCgroups":
			if r.TryDecodeAsNil() {
				x.KubeletCgroups = ""
			} else {
				x.KubeletCgroups = string(r.DecodeString())
			}
		case "runtimeCgroups":
			if r.TryDecodeAsNil() {
				x.RuntimeCgroups = ""
			} else {
				x.RuntimeCgroups = string(r.DecodeString())
			}
		case "systemContainer":
			if r.TryDecodeAsNil() {
				x.SystemCgroups = ""
			} else {
				x.SystemCgroups = string(r.DecodeString())
			}
		case "cgroupRoot":
			if r.TryDecodeAsNil() {
				x.CgroupRoot = ""
			} else {
				x.CgroupRoot = string(r.DecodeString())
			}
		case "containerRuntime":
			if r.TryDecodeAsNil() {
				x.ContainerRuntime = ""
			} else {
				x.ContainerRuntime = string(r.DecodeString())
			}
		case "rktPath":
			if r.TryDecodeAsNil() {
				x.RktPath = ""
			} else {
				x.RktPath = string(r.DecodeString())
			}
		case "lockFilePath":
			if r.TryDecodeAsNil() {
				x.LockFilePath = ""
			} else {
				x.LockFilePath = string(r.DecodeString())
			}
		case "rktStage1Image":
			if r.TryDecodeAsNil() {
				x.RktStage1Image = ""
			} else {
				x.RktStage1Image = string(r.DecodeString())
			}
		case "configureCbr0":
			if r.TryDecodeAsNil() {
				x.ConfigureCBR0 = false
			} else {
				x.ConfigureCBR0 = bool(r.DecodeBool())
			}
		case "hairpinMode":
			if r.TryDecodeAsNil() {
				x.HairpinMode = ""
			} else {
				x.HairpinMode = string(r.DecodeString())
			}
		case "maxPods":
			if r.TryDecodeAsNil() {
				x.MaxPods = 0
			} else {
				x.MaxPods = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "dockerExecHandlerName":
			if r.TryDecodeAsNil() {
				x.DockerExecHandlerName = ""
			} else {
				x.DockerExecHandlerName = string(r.DecodeString())
			}
		case "podCIDR":
			if r.TryDecodeAsNil() {
				x.PodCIDR = ""
			} else {
				x.PodCIDR = string(r.DecodeString())
			}
		case "resolvConf":
			if r.TryDecodeAsNil() {
				x.ResolverConfig = ""
			} else {
				x.ResolverConfig = string(r.DecodeString())
			}
		case "cpuCFSQuota":
			if r.TryDecodeAsNil() {
				x.CPUCFSQuota = false
			} else {
				x.CPUCFSQuota = bool(r.DecodeBool())
			}
		case "containerized":
			if r.TryDecodeAsNil() {
				x.Containerized = false
			} else {
				x.Containerized = bool(r.DecodeBool())
			}
		case "maxOpenFiles":
			if r.TryDecodeAsNil() {
				x.MaxOpenFiles = 0
			} else {
				x.MaxOpenFiles = uint64(r.DecodeUint(64))
			}
		case "reconcileCIDR":
			if r.TryDecodeAsNil() {
				x.ReconcileCIDR = false
			} else {
				x.ReconcileCIDR = bool(r.DecodeBool())
			}
		case "registerSchedulable":
			if r.TryDecodeAsNil() {
				x.RegisterSchedulable = false
			} else {
				x.RegisterSchedulable = bool(r.DecodeBool())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "serializeImagePulls":
			if r.TryDecodeAsNil() {
				x.SerializeImagePulls = false
			} else {
				x.SerializeImagePulls = bool(r.DecodeBool())
			}
		case "experimentalFlannelOverlay":
			if r.TryDecodeAsNil() {
				x.ExperimentalFlannelOverlay = false
			} else {
				x.ExperimentalFlannelOverlay = bool(r.DecodeBool())
			}
		case "outOfDiskTransitionFrequency":
			if r.TryDecodeAsNil() {
				x.OutOfDiskTransitionFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv84 := &x.OutOfDiskTransitionFrequency
				yym85 := z.DecBinary()
				_ = yym85
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv84) {
				} else if !yym85 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv84)
				} else {
					z.DecFallback(yyv84, false)
				}
			}
		case "nodeIP":
			if r.TryDecodeAsNil() {
				x.NodeIP = ""
			} else {
				x.NodeIP = string(r.DecodeString())
			}
		case "nodeLabels":
			if r.TryDecodeAsNil() {
				x.NodeLabels = nil
			} else {
				yyv87 := &x.NodeLabels
				yym88 := z.DecBinary()
				_ = yym88
				if false {
				} else {
					z.F.DecMapStringStringX(yyv87, false, d)
				}
			}
		case "nonMasqueradeCIDR":
			if r.TryDecodeAsNil() {
				x.NonMasqueradeCIDR = ""
			} else {
				x.NonMasqueradeCIDR = string(r.DecodeString())
			}
		case "enableCustomMetrics":
			if r.TryDecodeAsNil() {
				x.EnableCustomMetrics = false
			} else {
				x.EnableCustomMetrics = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj91 int
	var yyb91 bool
	var yyhl91 bool = l >= 0
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Config = ""
	} else {
		x.Config = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SyncFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv93 := &x.SyncFrequency
		yym94 := z.DecBinary()
		_ = yym94
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv93) {
		} else if !yym94 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv93)
		} else {
			z.DecFallback(yyv93, false)
		}
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FileCheckFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv95 := &x.FileCheckFrequency
		yym96 := z.DecBinary()
		_ = yym96
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv95) {
		} else if !yym96 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv95)
		} else {
			z.DecFallback(yyv95, false)
		}
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HTTPCheckFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv97 := &x.HTTPCheckFrequency
		yym98 := z.DecBinary()
		_ = yym98
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv97) {
		} else if !yym98 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv97)
		} else {
			z.DecFallback(yyv97, false)
		}
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ManifestURL = ""
	} else {
		x.ManifestURL = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ManifestURLHeader = ""
	} else {
		x.ManifestURLHeader = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableServer = false
	} else {
		x.EnableServer = bool(r.DecodeBool())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = uint(r.DecodeUint(codecSelferBitsize1234))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnlyPort = 0
	} else {
		x.ReadOnlyPort = uint(r.DecodeUint(codecSelferBitsize1234))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLSCertFile = ""
	} else {
		x.TLSCertFile = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLSPrivateKeyFile = ""
	} else {
		x.TLSPrivateKeyFile = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CertDirectory = ""
	} else {
		x.CertDirectory = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodInfraContainerImage = ""
	} else {
		x.PodInfraContainerImage = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DockerEndpoint = ""
	} else {
		x.DockerEndpoint = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RootDirectory = ""
	} else {
		x.RootDirectory = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowPrivileged = false
	} else {
		x.AllowPrivileged = bool(r.DecodeBool())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetworkSources = ""
	} else {
		x.HostNetworkSources = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPIDSources = ""
	} else {
		x.HostPIDSources = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPCSources = ""
	} else {
		x.HostIPCSources = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegistryPullQPS = 0
	} else {
		x.RegistryPullQPS = float64(r.DecodeFloat(false))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegistryBurst = 0
	} else {
		x.RegistryBurst = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EventRecordQPS = 0
	} else {
		x.EventRecordQPS = float32(r.DecodeFloat(true))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EventBurst = 0
	} else {
		x.EventBurst = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableDebuggingHandlers = false
	} else {
		x.EnableDebuggingHandlers = bool(r.DecodeBool())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumGCAge = pkg1_unversioned.Duration{}
	} else {
		yyv121 := &x.MinimumGCAge
		yym122 := z.DecBinary()
		_ = yym122
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv121) {
		} else if !yym122 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv121)
		} else {
			z.DecFallback(yyv121, false)
		}
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxPerPodContainerCount = 0
	} else {
		x.MaxPerPodContainerCount = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxContainerCount = 0
	} else {
		x.MaxContainerCount = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CAdvisorPort = 0
	} else {
		x.CAdvisorPort = uint(r.DecodeUint(codecSelferBitsize1234))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OOMScoreAdj = 0
	} else {
		x.OOMScoreAdj = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterNode = false
	} else {
		x.RegisterNode = bool(r.DecodeBool())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterDomain = ""
	} else {
		x.ClusterDomain = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasterServiceNamespace = ""
	} else {
		x.MasterServiceNamespace = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterDNS = ""
	} else {
		x.ClusterDNS = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StreamingConnectionIdleTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv133 := &x.StreamingConnectionIdleTimeout
		yym134 := z.DecBinary()
		_ = yym134
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv133) {
		} else if !yym134 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv133)
		} else {
			z.DecFallback(yyv133, false)
		}
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeStatusUpdateFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv135 := &x.NodeStatusUpdateFrequency
		yym136 := z.DecBinary()
		_ = yym136
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv135) {
		} else if !yym136 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv135)
		} else {
			z.DecFallback(yyv135, false)
		}
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageMinimumGCAge = pkg1_unversioned.Duration{}
	} else {
		yyv137 := &x.ImageMinimumGCAge
		yym138 := z.DecBinary()
		_ = yym138
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv137) {
		} else if !yym138 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv137)
		} else {
			z.DecFallback(yyv137, false)
		}
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageGCHighThresholdPercent = 0
	} else {
		x.ImageGCHighThresholdPercent = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageGCLowThresholdPercent = 0
	} else {
		x.ImageGCLowThresholdPercent = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LowDiskSpaceThresholdMB = 0
	} else {
		x.LowDiskSpaceThresholdMB = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeStatsAggPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv142 := &x.VolumeStatsAggPeriod
		yym143 := z.DecBinary()
		_ = yym143
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv142) {
		} else if !yym143 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv142)
		} else {
			z.DecFallback(yyv142, false)
		}
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginName = ""
	} else {
		x.NetworkPluginName = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginDir = ""
	} else {
		x.NetworkPluginDir = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumePluginDir = ""
	} else {
		x.VolumePluginDir = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudProvider = ""
	} else {
		x.CloudProvider = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudConfigFile = ""
	} else {
		x.CloudConfigFile = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletCgroups = ""
	} else {
		x.KubeletCgroups = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RuntimeCgroups = ""
	} else {
		x.RuntimeCgroups = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemCgroups = ""
	} else {
		x.SystemCgroups = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CgroupRoot = ""
	} else {
		x.CgroupRoot = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerRuntime = ""
	} else {
		x.ContainerRuntime = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktPath = ""
	} else {
		x.RktPath = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LockFilePath = ""
	} else {
		x.LockFilePath = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktStage1Image = ""
	} else {
		x.RktStage1Image = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConfigureCBR0 = false
	} else {
		x.ConfigureCBR0 = bool(r.DecodeBool())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HairpinMode = ""
	} else {
		x.HairpinMode = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxPods = 0
	} else {
		x.MaxPods = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DockerExecHandlerName = ""
	} else {
		x.DockerExecHandlerName = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodCIDR = ""
	} else {
		x.PodCIDR = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResolverConfig = ""
	} else {
		x.ResolverConfig = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CPUCFSQuota = false
	} else {
		x.CPUCFSQuota = bool(r.DecodeBool())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containerized = false
	} else {
		x.Containerized = bool(r.DecodeBool())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxOpenFiles = 0
	} else {
		x.MaxOpenFiles = uint64(r.DecodeUint(64))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReconcileCIDR = false
	} else {
		x.ReconcileCIDR = bool(r.DecodeBool())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterSchedulable = false
	} else {
		x.RegisterSchedulable = bool(r.DecodeBool())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SerializeImagePulls = false
	} else {
		x.SerializeImagePulls = bool(r.DecodeBool())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalFlannelOverlay = false
	} else {
		x.ExperimentalFlannelOverlay = bool(r.DecodeBool())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OutOfDiskTransitionFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv172 := &x.OutOfDiskTransitionFrequency
		yym173 := z.DecBinary()
		_ = yym173
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv172) {
		} else if !yym173 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv172)
		} else {
			z.DecFallback(yyv172, false)
		}
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeIP = ""
	} else {
		x.NodeIP = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeLabels = nil
	} else {
		yyv175 := &x.NodeLabels
		yym176 := z.DecBinary()
		_ = yym176
		if false {
		} else {
			z.F.DecMapStringStringX(yyv175, false, d)
		}
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NonMasqueradeCIDR = ""
	} else {
		x.NonMasqueradeCIDR = string(r.DecodeString())
	}
	yyj91++
	if yyhl91 {
		yyb91 = yyj91 > l
	} else {
		yyb91 = r.CheckBreak()
	}
	if yyb91 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableCustomMetrics = false
	} else {
		x.EnableCustomMetrics = bool(r.DecodeBool())
	}
	for {
		yyj91++
		if yyhl91 {
			yyb91 = yyj91 > l
		} else {
			yyb91 = r.CheckBreak()
		}
		if yyb91 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj91-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeSchedulerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [11]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[9] = x.Kind != ""
			yyq2[10] = x.APIVersion != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(11)
			} else {
				yynn2 = 9
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.AlgorithmProvider))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("algorithmProvider"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.AlgorithmProvider))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym13 := z.EncBinary()
				_ = yym13
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PolicyConfigFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("policyConfigFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym14 := z.EncBinary()
				_ = yym14
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PolicyConfigFile))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym17 := z.EncBinary()
				_ = yym17
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym19 := z.EncBinary()
				_ = yym19
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym20 := z.EncBinary()
				_ = yym20
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym22 := z.EncBinary()
				_ = yym22
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym23 := z.EncBinary()
				_ = yym23
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym25 := z.EncBinary()
				_ = yym25
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("schedulerName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym26 := z.EncBinary()
				_ = yym26
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy28 := &x.LeaderElection
				yy28.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElection"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy30 := &x.LeaderElection
				yy30.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					yym33 := z.EncBinary()
					_ = yym33
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym34 := z.EncBinary()
					_ = yym34
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[10] {
					yym36 := z.EncBinary()
					_ = yym36
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym37 := z.EncBinary()
					_ = yym37
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeSchedulerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeSchedulerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "algorithmProvider":
			if r.TryDecodeAsNil() {
				x.AlgorithmProvider = ""
			} else {
				x.AlgorithmProvider = string(r.DecodeString())
			}
		case "policyConfigFile":
			if r.TryDecodeAsNil() {
				x.PolicyConfigFile = ""
			} else {
				x.PolicyConfigFile = string(r.DecodeString())
			}
		case "enableProfiling":
			if r.TryDecodeAsNil() {
				x.EnableProfiling = false
			} else {
				x.EnableProfiling = bool(r.DecodeBool())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "schedulerName":
			if r.TryDecodeAsNil() {
				x.SchedulerName = ""
			} else {
				x.SchedulerName = string(r.DecodeString())
			}
		case "leaderElection":
			if r.TryDecodeAsNil() {
				x.LeaderElection = LeaderElectionConfiguration{}
			} else {
				yyv12 := &x.LeaderElection
				yyv12.CodecDecodeSelf(d)
			}
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeSchedulerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj15 int
	var yyb15 bool
	var yyhl15 bool = l >= 0
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AlgorithmProvider = ""
	} else {
		x.AlgorithmProvider = string(r.DecodeString())
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PolicyConfigFile = ""
	} else {
		x.PolicyConfigFile = string(r.DecodeString())
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableProfiling = false
	} else {
		x.EnableProfiling = bool(r.DecodeBool())
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SchedulerName = ""
	} else {
		x.SchedulerName = string(r.DecodeString())
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElection = LeaderElectionConfiguration{}
	} else {
		yyv24 := &x.LeaderElection
		yyv24.CodecDecodeSelf(d)
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	for {
		yyj15++
		if yyhl15 {
			yyb15 = yyj15 > l
		} else {
			yyb15 = r.CheckBreak()
		}
		if yyb15 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj15-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LeaderElectionConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 4
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElect"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy7 := &x.LeaseDuration
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else if z.HasExtensions() && z.EncExt(yy7) {
				} else if !yym8 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy7)
				} else {
					z.EncFallback(yy7)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaseDuration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy9 := &x.LeaseDuration
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else if z.HasExtensions() && z.EncExt(yy9) {
				} else if !yym10 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy9)
				} else {
					z.EncFallback(yy9)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy12 := &x.RenewDeadline
				yym13 := z.EncBinary()
				_ = yym13
				if false {
				} else if z.HasExtensions() && z.EncExt(yy12) {
				} else if !yym13 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy12)
				} else {
					z.EncFallback(yy12)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("renewDeadline"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy14 := &x.RenewDeadline
				yym15 := z.EncBinary()
				_ = yym15
				if false {
				} else if z.HasExtensions() && z.EncExt(yy14) {
				} else if !yym15 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy14)
				} else {
					z.EncFallback(yy14)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy17 := &x.RetryPeriod
				yym18 := z.EncBinary()
				_ = yym18
				if false {
				} else if z.HasExtensions() && z.EncExt(yy17) {
				} else if !yym18 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy17)
				} else {
					z.EncFallback(yy17)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("retryPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy19 := &x.RetryPeriod
				yym20 := z.EncBinary()
				_ = yym20
				if false {
				} else if z.HasExtensions() && z.EncExt(yy19) {
				} else if !yym20 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy19)
				} else {
					z.EncFallback(yy19)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LeaderElectionConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "leaderElect":
			if r.TryDecodeAsNil() {
				x.LeaderElect = false
			} else {
				x.LeaderElect = bool(r.DecodeBool())
			}
		case "leaseDuration":
			if r.TryDecodeAsNil() {
				x.LeaseDuration = pkg1_unversioned.Duration{}
			} else {
				yyv5 := &x.LeaseDuration
				yym6 := z.DecBinary()
				_ = yym6
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv5) {
				} else if !yym6 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv5)
				} else {
					z.DecFallback(yyv5, false)
				}
			}
		case "renewDeadline":
			if r.TryDecodeAsNil() {
				x.RenewDeadline = pkg1_unversioned.Duration{}
			} else {
				yyv7 := &x.RenewDeadline
				yym8 := z.DecBinary()
				_ = yym8
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv7) {
				} else if !yym8 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv7)
				} else {
					z.DecFallback(yyv7, false)
				}
			}
		case "retryPeriod":
			if r.TryDecodeAsNil() {
				x.RetryPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv9 := &x.RetryPeriod
				yym10 := z.DecBinary()
				_ = yym10
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv9) {
				} else if !yym10 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv9)
				} else {
					z.DecFallback(yyv9, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj11 int
	var yyb11 bool
	var yyhl11 bool = l >= 0
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElect = false
	} else {
		x.LeaderElect = bool(r.DecodeBool())
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaseDuration = pkg1_unversioned.Duration{}
	} else {
		yyv13 := &x.LeaseDuration
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv13) {
		} else if !yym14 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv13)
		} else {
			z.DecFallback(yyv13, false)
		}
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RenewDeadline = pkg1_unversioned.Duration{}
	} else {
		yyv15 := &x.RenewDeadline
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv15) {
		} else if !yym16 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv15)
		} else {
			z.DecFallback(yyv15, false)
		}
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RetryPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv17 := &x.RetryPeriod
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv17) {
		} else if !yym18 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv17)
		} else {
			z.DecFallback(yyv17, false)
		}
	}
	for {
		yyj11++
		if yyhl11 {
			yyb11 = yyj11 > l
		} else {
			yyb11 = r.CheckBreak()
		}
		if yyb11 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj11-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeControllerManagerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [40]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[38] = x.Kind != ""
			yyq2[39] = x.APIVersion != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(40)
			} else {
				yynn2 = 38
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cloudProvider"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym13 := z.EncBinary()
				_ = yym13
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cloudConfigFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym14 := z.EncBinary()
				_ = yym14
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentEndpointSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentEndpointSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym17 := z.EncBinary()
				_ = yym17
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentEndpointSyncs))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym19 := z.EncBinary()
				_ = yym19
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRSSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentRSSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym20 := z.EncBinary()
				_ = yym20
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRSSyncs))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym22 := z.EncBinary()
				_ = yym22
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRCSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentRCSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym23 := z.EncBinary()
				_ = yym23
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRCSyncs))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym25 := z.EncBinary()
				_ = yym25
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentResourceQuotaSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentResourceQuotaSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym26 := z.EncBinary()
				_ = yym26
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentResourceQuotaSyncs))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym28 := z.EncBinary()
				_ = yym28
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDeploymentSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentDeploymentSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym29 := z.EncBinary()
				_ = yym29
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDeploymentSyncs))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym31 := z.EncBinary()
				_ = yym31
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDaemonSetSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentDaemonSetSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym32 := z.EncBinary()
				_ = yym32
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDaemonSetSyncs))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym34 := z.EncBinary()
				_ = yym34
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentJobSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentJobSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym35 := z.EncBinary()
				_ = yym35
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentJobSyncs))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym37 := z.EncBinary()
				_ = yym37
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentNamespaceSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentNamespaceSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym38 := z.EncBinary()
				_ = yym38
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentNamespaceSyncs))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy40 := &x.ServiceSyncPeriod
				yym41 := z.EncBinary()
				_ = yym41
				if false {
				} else if z.HasExtensions() && z.EncExt(yy40) {
				} else if !yym41 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy40)
				} else {
					z.EncFallback(yy40)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy42 := &x.ServiceSyncPeriod
				yym43 := z.EncBinary()
				_ = yym43
				if false {
				} else if z.HasExtensions() && z.EncExt(yy42) {
				} else if !yym43 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy42)
				} else {
					z.EncFallback(yy42)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy45 := &x.NodeSyncPeriod
				yym46 := z.EncBinary()
				_ = yym46
				if false {
				} else if z.HasExtensions() && z.EncExt(yy45) {
				} else if !yym46 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy45)
				} else {
					z.EncFallback(yy45)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy47 := &x.NodeSyncPeriod
				yym48 := z.EncBinary()
				_ = yym48
				if false {
				} else if z.HasExtensions() && z.EncExt(yy47) {
				} else if !yym48 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy47)
				} else {
					z.EncFallback(yy47)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy50 := &x.ResourceQuotaSyncPeriod
				yym51 := z.EncBinary()
				_ = yym51
				if false {
				} else if z.HasExtensions() && z.EncExt(yy50) {
				} else if !yym51 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy50)
				} else {
					z.EncFallback(yy50)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resourceQuotaSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy52 := &x.ResourceQuotaSyncPeriod
				yym53 := z.EncBinary()
				_ = yym53
				if false {
				} else if z.HasExtensions() && z.EncExt(yy52) {
				} else if !yym53 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy52)
				} else {
					z.EncFallback(yy52)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy55 := &x.NamespaceSyncPeriod
				yym56 := z.EncBinary()
				_ = yym56
				if false {
				} else if z.HasExtensions() && z.EncExt(yy55) {
				} else if !yym56 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy55)
				} else {
					z.EncFallback(yy55)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("namespaceSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy57 := &x.NamespaceSyncPeriod
				yym58 := z.EncBinary()
				_ = yym58
				if false {
				} else if z.HasExtensions() && z.EncExt(yy57) {
				} else if !yym58 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy57)
				} else {
					z.EncFallback(yy57)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy60 := &x.PVClaimBinderSyncPeriod
				yym61 := z.EncBinary()
				_ = yym61
				if false {
				} else if z.HasExtensions() && z.EncExt(yy60) {
				} else if !yym61 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy60)
				} else {
					z.EncFallback(yy60)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pvClaimBinderSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy62 := &x.PVClaimBinderSyncPeriod
				yym63 := z.EncBinary()
				_ = yym63
				if false {
				} else if z.HasExtensions() && z.EncExt(yy62) {
				} else if !yym63 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy62)
				} else {
					z.EncFallback(yy62)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy65 := &x.MinResyncPeriod
				yym66 := z.EncBinary()
				_ = yym66
				if false {
				} else if z.HasExtensions() && z.EncExt(yy65) {
				} else if !yym66 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy65)
				} else {
					z.EncFallback(yy65)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minResyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy67 := &x.MinResyncPeriod
				yym68 := z.EncBinary()
				_ = yym68
				if false {
				} else if z.HasExtensions() && z.EncExt(yy67) {
				} else if !yym68 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy67)
				} else {
					z.EncFallback(yy67)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym70 := z.EncBinary()
				_ = yym70
				if false {
				} else {
					r.EncodeInt(int64(x.TerminatedPodGCThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("terminatedPodGCThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym71 := z.EncBinary()
				_ = yym71
				if false {
				} else {
					r.EncodeInt(int64(x.TerminatedPodGCThreshold))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy73 := &x.HorizontalPodAutoscalerSyncPeriod
				yym74 := z.EncBinary()
				_ = yym74
				if false {
				} else if z.HasExtensions() && z.EncExt(yy73) {
				} else if !yym74 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy73)
				} else {
					z.EncFallback(yy73)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("horizontalPodAutoscalerSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy75 := &x.HorizontalPodAutoscalerSyncPeriod
				yym76 := z.EncBinary()
				_ = yym76
				if false {
				} else if z.HasExtensions() && z.EncExt(yy75) {
				} else if !yym76 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy75)
				} else {
					z.EncFallback(yy75)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy78 := &x.DeploymentControllerSyncPeriod
				yym79 := z.EncBinary()
				_ = yym79
				if false {
				} else if z.HasExtensions() && z.EncExt(yy78) {
				} else if !yym79 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy78)
				} else {
					z.EncFallback(yy78)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deploymentControllerSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy80 := &x.DeploymentControllerSyncPeriod
				yym81 := z.EncBinary()
				_ = yym81
				if false {
				} else if z.HasExtensions() && z.EncExt(yy80) {
				} else if !yym81 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy80)
				} else {
					z.EncFallback(yy80)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy83 := &x.PodEvictionTimeout
				yym84 := z.EncBinary()
				_ = yym84
				if false {
				} else if z.HasExtensions() && z.EncExt(yy83) {
				} else if !yym84 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy83)
				} else {
					z.EncFallback(yy83)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podEvictionTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy85 := &x.PodEvictionTimeout
				yym86 := z.EncBinary()
				_ = yym86
				if false {
				} else if z.HasExtensions() && z.EncExt(yy85) {
				} else if !yym86 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy85)
				} else {
					z.EncFallback(yy85)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym88 := z.EncBinary()
				_ = yym88
				if false {
				} else {
					r.EncodeFloat32(float32(x.DeletingPodsQps))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deletingPodsQps"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym89 := z.EncBinary()
				_ = yym89
				if false {
				} else {
					r.EncodeFloat32(float32(x.DeletingPodsQps))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym91 := z.EncBinary()
				_ = yym91
				if false {
				} else {
					r.EncodeInt(int64(x.DeletingPodsBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deletingPodsBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym92 := z.EncBinary()
				_ = yym92
				if false {
				} else {
					r.EncodeInt(int64(x.DeletingPodsBurst))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy94 := &x.NodeMonitorGracePeriod
				yym95 := z.EncBinary()
				_ = yym95
				if false {
				} else if z.HasExtensions() && z.EncExt(yy94) {
				} else if !yym95 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy94)
				} else {
					z.EncFallback(yy94)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeMonitorGracePeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy96 := &x.NodeMonitorGracePeriod
				yym97 := z.EncBinary()
				_ = yym97
				if false {
				} else if z.HasExtensions() && z.EncExt(yy96) {
				} else if !yym97 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy96)
				} else {
					z.EncFallback(yy96)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym99 := z.EncBinary()
				_ = yym99
				if false {
				} else {
					r.EncodeInt(int64(x.RegisterRetryCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerRetryCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym100 := z.EncBinary()
				_ = yym100
				if false {
				} else {
					r.EncodeInt(int64(x.RegisterRetryCount))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy102 := &x.NodeStartupGracePeriod
				yym103 := z.EncBinary()
				_ = yym103
				if false {
				} else if z.HasExtensions() && z.EncExt(yy102) {
				} else if !yym103 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy102)
				} else {
					z.EncFallback(yy102)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeStartupGracePeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy104 := &x.NodeStartupGracePeriod
				yym105 := z.EncBinary()
				_ = yym105
				if false {
				} else if z.HasExtensions() && z.EncExt(yy104) {
				} else if !yym105 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy104)
				} else {
					z.EncFallback(yy104)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy107 := &x.NodeMonitorPeriod
				yym108 := z.EncBinary()
				_ = yym108
				if false {
				} else if z.HasExtensions() && z.EncExt(yy107) {
				} else if !yym108 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy107)
				} else {
					z.EncFallback(yy107)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeMonitorPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy109 := &x.NodeMonitorPeriod
				yym110 := z.EncBinary()
				_ = yym110
				if false {
				} else if z.HasExtensions() && z.EncExt(yy109) {
				} else if !yym110 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy109)
				} else {
					z.EncFallback(yy109)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym112 := z.EncBinary()
				_ = yym112
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceAccountKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym113 := z.EncBinary()
				_ = yym113
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountKeyFile))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym115 := z.EncBinary()
				_ = yym115
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym116 := z.EncBinary()
				_ = yym116
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym118 := z.EncBinary()
				_ = yym118
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym119 := z.EncBinary()
				_ = yym119
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym121 := z.EncBinary()
				_ = yym121
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym122 := z.EncBinary()
				_ = yym122
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym124 := z.EncBinary()
				_ = yym124
				if false {
				} else {
					r.EncodeBool(bool(x.AllocateNodeCIDRs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allocateNodeCIDRs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym125 := z.EncBinary()
				_ = yym125
				if false {
				} else {
					r.EncodeBool(bool(x.AllocateNodeCIDRs))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym127 := z.EncBinary()
				_ = yym127
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootCAFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rootCAFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym128 := z.EncBinary()
				_ = yym128
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootCAFile))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym130 := z.EncBinary()
				_ = yym130
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym131 := z.EncBinary()
				_ = yym131
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym133 := z.EncBinary()
				_ = yym133
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym134 := z.EncBinary()
				_ = yym134
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy136 := &x.LeaderElection
				yy136.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElection"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy138 := &x.LeaderElection
				yy138.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy141 := &x.VolumeConfiguration
				yy141.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeConfiguration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy143 := &x.VolumeConfiguration
				yy143.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[38] {
					yym146 := z.EncBinary()
					_ = yym146
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[38] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym147 := z.EncBinary()
					_ = yym147
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[39] {
					yym149 := z.EncBinary()
					_ = yym149
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[39] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym150 := z.EncBinary()
					_ = yym150
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeControllerManagerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeControllerManagerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "cloudProvider":
			if r.TryDecodeAsNil() {
				x.CloudProvider = ""
			} else {
				x.CloudProvider = string(r.DecodeString())
			}
		case "cloudConfigFile":
			if r.TryDecodeAsNil() {
				x.CloudConfigFile = ""
			} else {
				x.CloudConfigFile = string(r.DecodeString())
			}
		case "concurrentEndpointSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentEndpointSyncs = 0
			} else {
				x.ConcurrentEndpointSyncs = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "concurrentRSSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentRSSyncs = 0
			} else {
				x.ConcurrentRSSyncs = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "concurrentRCSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentRCSyncs = 0
			} else {
				x.ConcurrentRCSyncs = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "concurrentResourceQuotaSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentResourceQuotaSyncs = 0
			} else {
				x.ConcurrentResourceQuotaSyncs = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "concurrentDeploymentSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentDeploymentSyncs = 0
			} else {
				x.ConcurrentDeploymentSyncs = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "concurrentDaemonSetSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentDaemonSetSyncs = 0
			} else {
				x.ConcurrentDaemonSetSyncs = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "concurrentJobSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentJobSyncs = 0
			} else {
				x.ConcurrentJobSyncs = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "concurrentNamespaceSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentNamespaceSyncs = 0
			} else {
				x.ConcurrentNamespaceSyncs = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "serviceSyncPeriod":
			if r.TryDecodeAsNil() {
				x.ServiceSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv16 := &x.ServiceSyncPeriod
				yym17 := z.DecBinary()
				_ = yym17
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv16) {
				} else if !yym17 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv16)
				} else {
					z.DecFallback(yyv16, false)
				}
			}
		case "nodeSyncPeriod":
			if r.TryDecodeAsNil() {
				x.NodeSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv18 := &x.NodeSyncPeriod
				yym19 := z.DecBinary()
				_ = yym19
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv18) {
				} else if !yym19 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv18)
				} else {
					z.DecFallback(yyv18, false)
				}
			}
		case "resourceQuotaSyncPeriod":
			if r.TryDecodeAsNil() {
				x.ResourceQuotaSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv20 := &x.ResourceQuotaSyncPeriod
				yym21 := z.DecBinary()
				_ = yym21
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv20) {
				} else if !yym21 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv20)
				} else {
					z.DecFallback(yyv20, false)
				}
			}
		case "namespaceSyncPeriod":
			if r.TryDecodeAsNil() {
				x.NamespaceSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv22 := &x.NamespaceSyncPeriod
				yym23 := z.DecBinary()
				_ = yym23
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv22) {
				} else if !yym23 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv22)
				} else {
					z.DecFallback(yyv22, false)
				}
			}
		case "pvClaimBinderSyncPeriod":
			if r.TryDecodeAsNil() {
				x.PVClaimBinderSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv24 := &x.PVClaimBinderSyncPeriod
				yym25 := z.DecBinary()
				_ = yym25
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv24) {
				} else if !yym25 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv24)
				} else {
					z.DecFallback(yyv24, false)
				}
			}
		case "minResyncPeriod":
			if r.TryDecodeAsNil() {
				x.MinResyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv26 := &x.MinResyncPeriod
				yym27 := z.DecBinary()
				_ = yym27
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv26) {
				} else if !yym27 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv26)
				} else {
					z.DecFallback(yyv26, false)
				}
			}
		case "terminatedPodGCThreshold":
			if r.TryDecodeAsNil() {
				x.TerminatedPodGCThreshold = 0
			} else {
				x.TerminatedPodGCThreshold = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "horizontalPodAutoscalerSyncPeriod":
			if r.TryDecodeAsNil() {
				x.HorizontalPodAutoscalerSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv29 := &x.HorizontalPodAutoscalerSyncPeriod
				yym30 := z.DecBinary()
				_ = yym30
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv29) {
				} else if !yym30 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv29)
				} else {
					z.DecFallback(yyv29, false)
				}
			}
		case "deploymentControllerSyncPeriod":
			if r.TryDecodeAsNil() {
				x.DeploymentControllerSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv31 := &x.DeploymentControllerSyncPeriod
				yym32 := z.DecBinary()
				_ = yym32
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv31) {
				} else if !yym32 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv31)
				} else {
					z.DecFallback(yyv31, false)
				}
			}
		case "podEvictionTimeout":
			if r.TryDecodeAsNil() {
				x.PodEvictionTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv33 := &x.PodEvictionTimeout
				yym34 := z.DecBinary()
				_ = yym34
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv33) {
				} else if !yym34 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv33)
				} else {
					z.DecFallback(yyv33, false)
				}
			}
		case "deletingPodsQps":
			if r.TryDecodeAsNil() {
				x.DeletingPodsQps = 0
			} else {
				x.DeletingPodsQps = float32(r.DecodeFloat(true))
			}
		case "deletingPodsBurst":
			if r.TryDecodeAsNil() {
				x.DeletingPodsBurst = 0
			} else {
				x.DeletingPodsBurst = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "nodeMonitorGracePeriod":
			if r.TryDecodeAsNil() {
				x.NodeMonitorGracePeriod = pkg1_unversioned.Duration{}
			} else {
				yyv37 := &x.NodeMonitorGracePeriod
				yym38 := z.DecBinary()
				_ = yym38
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv37) {
				} else if !yym38 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv37)
				} else {
					z.DecFallback(yyv37, false)
				}
			}
		case "registerRetryCount":
			if r.TryDecodeAsNil() {
				x.RegisterRetryCount = 0
			} else {
				x.RegisterRetryCount = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "nodeStartupGracePeriod":
			if r.TryDecodeAsNil() {
				x.NodeStartupGracePeriod = pkg1_unversioned.Duration{}
			} else {
				yyv40 := &x.NodeStartupGracePeriod
				yym41 := z.DecBinary()
				_ = yym41
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv40) {
				} else if !yym41 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv40)
				} else {
					z.DecFallback(yyv40, false)
				}
			}
		case "nodeMonitorPeriod":
			if r.TryDecodeAsNil() {
				x.NodeMonitorPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv42 := &x.NodeMonitorPeriod
				yym43 := z.DecBinary()
				_ = yym43
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv42) {
				} else if !yym43 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv42)
				} else {
					z.DecFallback(yyv42, false)
				}
			}
		case "serviceAccountKeyFile":
			if r.TryDecodeAsNil() {
				x.ServiceAccountKeyFile = ""
			} else {
				x.ServiceAccountKeyFile = string(r.DecodeString())
			}
		case "enableProfiling":
			if r.TryDecodeAsNil() {
				x.EnableProfiling = false
			} else {
				x.EnableProfiling = bool(r.DecodeBool())
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		case "clusterCIDR":
			if r.TryDecodeAsNil() {
				x.ClusterCIDR = ""
			} else {
				x.ClusterCIDR = string(r.DecodeString())
			}
		case "allocateNodeCIDRs":
			if r.TryDecodeAsNil() {
				x.AllocateNodeCIDRs = false
			} else {
				x.AllocateNodeCIDRs = bool(r.DecodeBool())
			}
		case "rootCAFile":
			if r.TryDecodeAsNil() {
				x.RootCAFile = ""
			} else {
				x.RootCAFile = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "leaderElection":
			if r.TryDecodeAsNil() {
				x.LeaderElection = LeaderElectionConfiguration{}
			} else {
				yyv52 := &x.LeaderElection
				yyv52.CodecDecodeSelf(d)
			}
		case "volumeConfiguration":
			if r.TryDecodeAsNil() {
				x.VolumeConfiguration = VolumeConfiguration{}
			} else {
				yyv53 := &x.VolumeConfiguration
				yyv53.CodecDecodeSelf(d)
			}
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeControllerManagerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj56 int
	var yyb56 bool
	var yyhl56 bool = l >= 0
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudProvider = ""
	} else {
		x.CloudProvider = string(r.DecodeString())
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudConfigFile = ""
	} else {
		x.CloudConfigFile = string(r.DecodeString())
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentEndpointSyncs = 0
	} else {
		x.ConcurrentEndpointSyncs = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentRSSyncs = 0
	} else {
		x.ConcurrentRSSyncs = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentRCSyncs = 0
	} else {
		x.ConcurrentRCSyncs = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentResourceQuotaSyncs = 0
	} else {
		x.ConcurrentResourceQuotaSyncs = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentDeploymentSyncs = 0
	} else {
		x.ConcurrentDeploymentSyncs = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentDaemonSetSyncs = 0
	} else {
		x.ConcurrentDaemonSetSyncs = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentJobSyncs = 0
	} else {
		x.ConcurrentJobSyncs = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentNamespaceSyncs = 0
	} else {
		x.ConcurrentNamespaceSyncs = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv69 := &x.ServiceSyncPeriod
		yym70 := z.DecBinary()
		_ = yym70
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv69) {
		} else if !yym70 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv69)
		} else {
			z.DecFallback(yyv69, false)
		}
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv71 := &x.NodeSyncPeriod
		yym72 := z.DecBinary()
		_ = yym72
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv71) {
		} else if !yym72 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv71)
		} else {
			z.DecFallback(yyv71, false)
		}
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceQuotaSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv73 := &x.ResourceQuotaSyncPeriod
		yym74 := z.DecBinary()
		_ = yym74
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv73) {
		} else if !yym74 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv73)
		} else {
			z.DecFallback(yyv73, false)
		}
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NamespaceSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv75 := &x.NamespaceSyncPeriod
		yym76 := z.DecBinary()
		_ = yym76
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv75) {
		} else if !yym76 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv75)
		} else {
			z.DecFallback(yyv75, false)
		}
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PVClaimBinderSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv77 := &x.PVClaimBinderSyncPeriod
		yym78 := z.DecBinary()
		_ = yym78
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv77) {
		} else if !yym78 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv77)
		} else {
			z.DecFallback(yyv77, false)
		}
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinResyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv79 := &x.MinResyncPeriod
		yym80 := z.DecBinary()
		_ = yym80
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv79) {
		} else if !yym80 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv79)
		} else {
			z.DecFallback(yyv79, false)
		}
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminatedPodGCThreshold = 0
	} else {
		x.TerminatedPodGCThreshold = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HorizontalPodAutoscalerSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv82 := &x.HorizontalPodAutoscalerSyncPeriod
		yym83 := z.DecBinary()
		_ = yym83
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv82) {
		} else if !yym83 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv82)
		} else {
			z.DecFallback(yyv82, false)
		}
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeploymentControllerSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv84 := &x.DeploymentControllerSyncPeriod
		yym85 := z.DecBinary()
		_ = yym85
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv84) {
		} else if !yym85 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv84)
		} else {
			z.DecFallback(yyv84, false)
		}
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodEvictionTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv86 := &x.PodEvictionTimeout
		yym87 := z.DecBinary()
		_ = yym87
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv86) {
		} else if !yym87 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv86)
		} else {
			z.DecFallback(yyv86, false)
		}
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeletingPodsQps = 0
	} else {
		x.DeletingPodsQps = float32(r.DecodeFloat(true))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeletingPodsBurst = 0
	} else {
		x.DeletingPodsBurst = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeMonitorGracePeriod = pkg1_unversioned.Duration{}
	} else {
		yyv90 := &x.NodeMonitorGracePeriod
		yym91 := z.DecBinary()
		_ = yym91
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv90) {
		} else if !yym91 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv90)
		} else {
			z.DecFallback(yyv90, false)
		}
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterRetryCount = 0
	} else {
		x.RegisterRetryCount = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeStartupGracePeriod = pkg1_unversioned.Duration{}
	} else {
		yyv93 := &x.NodeStartupGracePeriod
		yym94 := z.DecBinary()
		_ = yym94
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv93) {
		} else if !yym94 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv93)
		} else {
			z.DecFallback(yyv93, false)
		}
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeMonitorPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv95 := &x.NodeMonitorPeriod
		yym96 := z.DecBinary()
		_ = yym96
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv95) {
		} else if !yym96 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv95)
		} else {
			z.DecFallback(yyv95, false)
		}
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceAccountKeyFile = ""
	} else {
		x.ServiceAccountKeyFile = string(r.DecodeString())
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableProfiling = false
	} else {
		x.EnableProfiling = bool(r.DecodeBool())
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterCIDR = ""
	} else {
		x.ClusterCIDR = string(r.DecodeString())
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllocateNodeCIDRs = false
	} else {
		x.AllocateNodeCIDRs = bool(r.DecodeBool())
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RootCAFile = ""
	} else {
		x.RootCAFile = string(r.DecodeString())
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElection = LeaderElectionConfiguration{}
	} else {
		yyv105 := &x.LeaderElection
		yyv105.CodecDecodeSelf(d)
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeConfiguration = VolumeConfiguration{}
	} else {
		yyv106 := &x.VolumeConfiguration
		yyv106.CodecDecodeSelf(d)
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	for {
		yyj56++
		if yyhl56 {
			yyb56 = yyj56 > l
		} else {
			yyb56 = r.CheckBreak()
		}
		if yyb56 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj56-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeBool(bool(x.EnableHostPathProvisioning))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableHostPathProvisioning"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeBool(bool(x.EnableHostPathProvisioning))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy7 := &x.PersistentVolumeRecyclerConfiguration
				yy7.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("persitentVolumeRecyclerConfiguration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy9 := &x.PersistentVolumeRecyclerConfiguration
				yy9.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "enableHostPathProvisioning":
			if r.TryDecodeAsNil() {
				x.EnableHostPathProvisioning = false
			} else {
				x.EnableHostPathProvisioning = bool(r.DecodeBool())
			}
		case "persitentVolumeRecyclerConfiguration":
			if r.TryDecodeAsNil() {
				x.PersistentVolumeRecyclerConfiguration = PersistentVolumeRecyclerConfiguration{}
			} else {
				yyv5 := &x.PersistentVolumeRecyclerConfiguration
				yyv5.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = r.CheckBreak()
	}
	if yyb6 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableHostPathProvisioning = false
	} else {
		x.EnableHostPathProvisioning = bool(r.DecodeBool())
	}
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = r.CheckBreak()
	}
	if yyb6 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PersistentVolumeRecyclerConfiguration = PersistentVolumeRecyclerConfiguration{}
	} else {
		yyv8 := &x.PersistentVolumeRecyclerConfiguration
		yyv8.CodecDecodeSelf(d)
	}
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = r.CheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj6-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeRecyclerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [7]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(7)
			} else {
				yynn2 = 7
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeInt(int64(x.MaximumRetry))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maximumRetry"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeInt(int64(x.MaximumRetry))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumTimeoutNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutNFS))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podTemplateFilePathNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathNFS))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym13 := z.EncBinary()
				_ = yym13
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("incrementTimeoutNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym14 := z.EncBinary()
				_ = yym14
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutNFS))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podTemplateFilePathHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym17 := z.EncBinary()
				_ = yym17
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathHostPath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym19 := z.EncBinary()
				_ = yym19
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumTimeoutHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym20 := z.EncBinary()
				_ = yym20
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutHostPath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym22 := z.EncBinary()
				_ = yym22
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("incrementTimeoutHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym23 := z.EncBinary()
				_ = yym23
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutHostPath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeRecyclerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeRecyclerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "maximumRetry":
			if r.TryDecodeAsNil() {
				x.MaximumRetry = 0
			} else {
				x.MaximumRetry = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "minimumTimeoutNFS":
			if r.TryDecodeAsNil() {
				x.MinimumTimeoutNFS = 0
			} else {
				x.MinimumTimeoutNFS = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "podTemplateFilePathNFS":
			if r.TryDecodeAsNil() {
				x.PodTemplateFilePathNFS = ""
			} else {
				x.PodTemplateFilePathNFS = string(r.DecodeString())
			}
		case "incrementTimeoutNFS":
			if r.TryDecodeAsNil() {
				x.IncrementTimeoutNFS = 0
			} else {
				x.IncrementTimeoutNFS = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "podTemplateFilePathHostPath":
			if r.TryDecodeAsNil() {
				x.PodTemplateFilePathHostPath = ""
			} else {
				x.PodTemplateFilePathHostPath = string(r.DecodeString())
			}
		case "minimumTimeoutHostPath":
			if r.TryDecodeAsNil() {
				x.MinimumTimeoutHostPath = 0
			} else {
				x.MinimumTimeoutHostPath = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "incrementTimeoutHostPath":
			if r.TryDecodeAsNil() {
				x.IncrementTimeoutHostPath = 0
			} else {
				x.IncrementTimeoutHostPath = int(r.DecodeInt(codecSelferBitsize1234))
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeRecyclerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj11 int
	var yyb11 bool
	var yyhl11 bool = l >= 0
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaximumRetry = 0
	} else {
		x.MaximumRetry = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumTimeoutNFS = 0
	} else {
		x.MinimumTimeoutNFS = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodTemplateFilePathNFS = ""
	} else {
		x.PodTemplateFilePathNFS = string(r.DecodeString())
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IncrementTimeoutNFS = 0
	} else {
		x.IncrementTimeoutNFS = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodTemplateFilePathHostPath = ""
	} else {
		x.PodTemplateFilePathHostPath = string(r.DecodeString())
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumTimeoutHostPath = 0
	} else {
		x.MinimumTimeoutHostPath = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IncrementTimeoutHostPath = 0
	} else {
		x.IncrementTimeoutHostPath = int(r.DecodeInt(codecSelferBitsize1234))
	}
	for {
		yyj11++
		if yyhl11 {
			yyb11 = yyj11 > l
		} else {
			yyb11 = r.CheckBreak()
		}
		if yyb11 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj11-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}
