/*
 * Decompiled with CFR 0.152.
 */
package io.k8s.cassandra;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.cassandra.locator.SeedProvider;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesSeedProvider
implements SeedProvider {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesSeedProvider.class);
    private List defaultSeeds;
    private TrustManager[] trustAll;
    private HostnameVerifier trustAllHosts;

    private static String getEnvOrDefault(String var, String def) {
        String val = System.getenv(var);
        if (val == null) {
            val = def;
        }
        return val;
    }

    private static String getServiceAccountToken() throws IOException {
        String file = "/var/run/secrets/kubernetes.io/serviceaccount/token";
        return new String(Files.readAllBytes(Paths.get(file, new String[0])));
    }

    public KubernetesSeedProvider(Map<String, String> params) {
        String[] hosts = params.get("seeds").split(",", -1);
        this.defaultSeeds = new ArrayList(hosts.length);
        for (String host : hosts) {
            try {
                this.defaultSeeds.add(InetAddress.getByName(host.trim()));
            }
            catch (UnknownHostException ex) {
                String string = String.valueOf(host);
                logger.warn(string.length() != 0 ? "Seed provider couldn't lookup host ".concat(string) : new String("Seed provider couldn't lookup host "));
            }
        }
        this.trustAll = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        this.trustAllHosts = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }

    public List<InetAddress> getSeeds() {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        String host = "https://kubernetes.default.cluster.local";
        String serviceName = KubernetesSeedProvider.getEnvOrDefault("CASSANDRA_SERVICE", "cassandra");
        String podNamespace = KubernetesSeedProvider.getEnvOrDefault("POD_NAMESPACE", "default");
        String path = String.format("/api/v1/namespaces/%s/endpoints/", podNamespace);
        try {
            String token = KubernetesSeedProvider.getServiceAccountToken();
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, this.trustAll, new SecureRandom());
            String string = String.valueOf(String.valueOf(host));
            String string2 = String.valueOf(String.valueOf(path));
            String string3 = String.valueOf(String.valueOf(serviceName));
            URL url = new URL(new StringBuilder(0 + string.length() + string2.length() + string3.length()).append(string).append(string2).append(string3).toString());
            String string4 = String.valueOf(String.valueOf(url));
            logger.info(new StringBuilder(23 + string4.length()).append("Getting endpoints from ").append(string4).toString());
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setSSLSocketFactory(ctx.getSocketFactory());
            conn.setHostnameVerifier(this.trustAllHosts);
            String string5 = String.valueOf(token);
            conn.addRequestProperty("Authorization", string5.length() != 0 ? "Bearer ".concat(string5) : new String("Bearer "));
            ObjectMapper mapper = new ObjectMapper();
            Endpoints endpoints = (Endpoints)mapper.readValue(conn.getInputStream(), Endpoints.class);
            if (endpoints != null) {
                if (endpoints.subsets != null && !endpoints.subsets.isEmpty()) {
                    for (Subset subset : endpoints.subsets) {
                        for (Address address : subset.addresses) {
                            list.add(InetAddress.getByName(address.ip));
                        }
                    }
                }
                String string6 = String.valueOf(String.valueOf(list));
                logger.info(new StringBuilder(21 + string6.length()).append("Available endpoints: ").append(string6).toString());
            } else {
                logger.warn("Endpoints are not available");
            }
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException ex) {
            logger.warn("Request to kubernetes apiserver failed", (Throwable)ex);
        }
        if (list.size() == 0) {
            return this.defaultSeeds;
        }
        return list;
    }

    public static void main(String[] args) {
        KubernetesSeedProvider provider = new KubernetesSeedProvider(new HashMap<String, String>());
        System.out.println(provider.getSeeds());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Endpoints {
        public List<Subset> subsets;

        Endpoints() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Subset {
        public List<Address> addresses;

        Subset() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Address {
        public String ip;

        Address() {
        }
    }
}

