// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package autoscaling provides a client for Auto Scaling.
package autoscaling

import (
	"sync"
	"time"

	"github.com/aws/aws-sdk-go/aws"
)

var oprw sync.Mutex

// AttachInstancesRequest generates a request for the AttachInstances operation.
func (c *AutoScaling) AttachInstancesRequest(input *AttachInstancesInput) (req *aws.Request, output *AttachInstancesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opAttachInstances == nil {
		opAttachInstances = &aws.Operation{
			Name:       "AttachInstances",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &AttachInstancesInput{}
	}

	req = c.newRequest(opAttachInstances, input, output)
	output = &AttachInstancesOutput{}
	req.Data = output
	return
}

// Attaches one or more EC2 instances to the specified Auto Scaling group.
//
// For more information, see Attach Amazon EC2 Instances to Your Existing Auto
// Scaling Group (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/attach-instance-asg.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) AttachInstances(input *AttachInstancesInput) (*AttachInstancesOutput, error) {
	req, out := c.AttachInstancesRequest(input)
	err := req.Send()
	return out, err
}

var opAttachInstances *aws.Operation

// CompleteLifecycleActionRequest generates a request for the CompleteLifecycleAction operation.
func (c *AutoScaling) CompleteLifecycleActionRequest(input *CompleteLifecycleActionInput) (req *aws.Request, output *CompleteLifecycleActionOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opCompleteLifecycleAction == nil {
		opCompleteLifecycleAction = &aws.Operation{
			Name:       "CompleteLifecycleAction",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &CompleteLifecycleActionInput{}
	}

	req = c.newRequest(opCompleteLifecycleAction, input, output)
	output = &CompleteLifecycleActionOutput{}
	req.Data = output
	return
}

// Completes the lifecycle action for the associated token initiated under the
// given lifecycle hook with the specified result.
//
// This operation is a part of the basic sequence for adding a lifecycle hook
// to an Auto Scaling group:
//
//  Create a notification target. A target can be either an Amazon SQS queue
// or an Amazon SNS topic. Create an IAM role. This role allows Auto Scaling
// to publish lifecycle notifications to the designated SQS queue or SNS topic.
// Create the lifecycle hook. You can create a hook that acts when instances
// launch or when instances terminate. If necessary, record the lifecycle action
// heartbeat to keep the instance in a pending state.  Complete the lifecycle
// action.  For more information, see Auto Scaling Pending State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingPendingState.html)
// and Auto Scaling Terminating State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingTerminatingState.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) CompleteLifecycleAction(input *CompleteLifecycleActionInput) (*CompleteLifecycleActionOutput, error) {
	req, out := c.CompleteLifecycleActionRequest(input)
	err := req.Send()
	return out, err
}

var opCompleteLifecycleAction *aws.Operation

// CreateAutoScalingGroupRequest generates a request for the CreateAutoScalingGroup operation.
func (c *AutoScaling) CreateAutoScalingGroupRequest(input *CreateAutoScalingGroupInput) (req *aws.Request, output *CreateAutoScalingGroupOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opCreateAutoScalingGroup == nil {
		opCreateAutoScalingGroup = &aws.Operation{
			Name:       "CreateAutoScalingGroup",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &CreateAutoScalingGroupInput{}
	}

	req = c.newRequest(opCreateAutoScalingGroup, input, output)
	output = &CreateAutoScalingGroupOutput{}
	req.Data = output
	return
}

// Creates an Auto Scaling group with the specified name and attributes.
//
// If you exceed your maximum limit of Auto Scaling groups, which by default
// is 20 per region, the call fails. For information about viewing and updating
// these limits, see DescribeAccountLimits.
func (c *AutoScaling) CreateAutoScalingGroup(input *CreateAutoScalingGroupInput) (*CreateAutoScalingGroupOutput, error) {
	req, out := c.CreateAutoScalingGroupRequest(input)
	err := req.Send()
	return out, err
}

var opCreateAutoScalingGroup *aws.Operation

// CreateLaunchConfigurationRequest generates a request for the CreateLaunchConfiguration operation.
func (c *AutoScaling) CreateLaunchConfigurationRequest(input *CreateLaunchConfigurationInput) (req *aws.Request, output *CreateLaunchConfigurationOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opCreateLaunchConfiguration == nil {
		opCreateLaunchConfiguration = &aws.Operation{
			Name:       "CreateLaunchConfiguration",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &CreateLaunchConfigurationInput{}
	}

	req = c.newRequest(opCreateLaunchConfiguration, input, output)
	output = &CreateLaunchConfigurationOutput{}
	req.Data = output
	return
}

// Creates a launch configuration.
//
// If you exceed your maximum limit of launch configurations, which by default
// is 100 per region, the call fails. For information about viewing and updating
// these limits, see DescribeAccountLimits.
func (c *AutoScaling) CreateLaunchConfiguration(input *CreateLaunchConfigurationInput) (*CreateLaunchConfigurationOutput, error) {
	req, out := c.CreateLaunchConfigurationRequest(input)
	err := req.Send()
	return out, err
}

var opCreateLaunchConfiguration *aws.Operation

// CreateOrUpdateTagsRequest generates a request for the CreateOrUpdateTags operation.
func (c *AutoScaling) CreateOrUpdateTagsRequest(input *CreateOrUpdateTagsInput) (req *aws.Request, output *CreateOrUpdateTagsOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opCreateOrUpdateTags == nil {
		opCreateOrUpdateTags = &aws.Operation{
			Name:       "CreateOrUpdateTags",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &CreateOrUpdateTagsInput{}
	}

	req = c.newRequest(opCreateOrUpdateTags, input, output)
	output = &CreateOrUpdateTagsOutput{}
	req.Data = output
	return
}

// Creates or updates tags for the specified Auto Scaling group.
//
//  A tag's definition is composed of a resource ID, resource type, key and
// value, and the propagate flag. Value and the propagate flag are optional
// parameters. See the Request Parameters for more information.  For more information,
// see Add, Modify, or Remove Auto Scaling Group Tags (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/ASTagging.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) CreateOrUpdateTags(input *CreateOrUpdateTagsInput) (*CreateOrUpdateTagsOutput, error) {
	req, out := c.CreateOrUpdateTagsRequest(input)
	err := req.Send()
	return out, err
}

var opCreateOrUpdateTags *aws.Operation

// DeleteAutoScalingGroupRequest generates a request for the DeleteAutoScalingGroup operation.
func (c *AutoScaling) DeleteAutoScalingGroupRequest(input *DeleteAutoScalingGroupInput) (req *aws.Request, output *DeleteAutoScalingGroupOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDeleteAutoScalingGroup == nil {
		opDeleteAutoScalingGroup = &aws.Operation{
			Name:       "DeleteAutoScalingGroup",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DeleteAutoScalingGroupInput{}
	}

	req = c.newRequest(opDeleteAutoScalingGroup, input, output)
	output = &DeleteAutoScalingGroupOutput{}
	req.Data = output
	return
}

// Deletes the specified Auto Scaling group.
//
// The group must have no instances and no scaling activities in progress.
//
// To remove all instances before calling DeleteAutoScalingGroup, you can call
// UpdateAutoScalingGroup to set the minimum and maximum size of the AutoScalingGroup
// to zero.
func (c *AutoScaling) DeleteAutoScalingGroup(input *DeleteAutoScalingGroupInput) (*DeleteAutoScalingGroupOutput, error) {
	req, out := c.DeleteAutoScalingGroupRequest(input)
	err := req.Send()
	return out, err
}

var opDeleteAutoScalingGroup *aws.Operation

// DeleteLaunchConfigurationRequest generates a request for the DeleteLaunchConfiguration operation.
func (c *AutoScaling) DeleteLaunchConfigurationRequest(input *DeleteLaunchConfigurationInput) (req *aws.Request, output *DeleteLaunchConfigurationOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDeleteLaunchConfiguration == nil {
		opDeleteLaunchConfiguration = &aws.Operation{
			Name:       "DeleteLaunchConfiguration",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DeleteLaunchConfigurationInput{}
	}

	req = c.newRequest(opDeleteLaunchConfiguration, input, output)
	output = &DeleteLaunchConfigurationOutput{}
	req.Data = output
	return
}

// Deletes the specified launch configuration.
//
// The launch configuration must not be attached to an Auto Scaling group.
// When this call completes, the launch configuration is no longer available
// for use.
func (c *AutoScaling) DeleteLaunchConfiguration(input *DeleteLaunchConfigurationInput) (*DeleteLaunchConfigurationOutput, error) {
	req, out := c.DeleteLaunchConfigurationRequest(input)
	err := req.Send()
	return out, err
}

var opDeleteLaunchConfiguration *aws.Operation

// DeleteLifecycleHookRequest generates a request for the DeleteLifecycleHook operation.
func (c *AutoScaling) DeleteLifecycleHookRequest(input *DeleteLifecycleHookInput) (req *aws.Request, output *DeleteLifecycleHookOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDeleteLifecycleHook == nil {
		opDeleteLifecycleHook = &aws.Operation{
			Name:       "DeleteLifecycleHook",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DeleteLifecycleHookInput{}
	}

	req = c.newRequest(opDeleteLifecycleHook, input, output)
	output = &DeleteLifecycleHookOutput{}
	req.Data = output
	return
}

// Deletes the specified lifecycle hook.
//
// If there are any outstanding lifecycle actions, they are completed first
// (ABANDON for launching instances, CONTINUE for terminating instances).
func (c *AutoScaling) DeleteLifecycleHook(input *DeleteLifecycleHookInput) (*DeleteLifecycleHookOutput, error) {
	req, out := c.DeleteLifecycleHookRequest(input)
	err := req.Send()
	return out, err
}

var opDeleteLifecycleHook *aws.Operation

// DeleteNotificationConfigurationRequest generates a request for the DeleteNotificationConfiguration operation.
func (c *AutoScaling) DeleteNotificationConfigurationRequest(input *DeleteNotificationConfigurationInput) (req *aws.Request, output *DeleteNotificationConfigurationOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDeleteNotificationConfiguration == nil {
		opDeleteNotificationConfiguration = &aws.Operation{
			Name:       "DeleteNotificationConfiguration",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DeleteNotificationConfigurationInput{}
	}

	req = c.newRequest(opDeleteNotificationConfiguration, input, output)
	output = &DeleteNotificationConfigurationOutput{}
	req.Data = output
	return
}

// Deletes the specified notification.
func (c *AutoScaling) DeleteNotificationConfiguration(input *DeleteNotificationConfigurationInput) (*DeleteNotificationConfigurationOutput, error) {
	req, out := c.DeleteNotificationConfigurationRequest(input)
	err := req.Send()
	return out, err
}

var opDeleteNotificationConfiguration *aws.Operation

// DeletePolicyRequest generates a request for the DeletePolicy operation.
func (c *AutoScaling) DeletePolicyRequest(input *DeletePolicyInput) (req *aws.Request, output *DeletePolicyOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDeletePolicy == nil {
		opDeletePolicy = &aws.Operation{
			Name:       "DeletePolicy",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	req = c.newRequest(opDeletePolicy, input, output)
	output = &DeletePolicyOutput{}
	req.Data = output
	return
}

// Deletes the specified Auto Scaling policy.
func (c *AutoScaling) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	err := req.Send()
	return out, err
}

var opDeletePolicy *aws.Operation

// DeleteScheduledActionRequest generates a request for the DeleteScheduledAction operation.
func (c *AutoScaling) DeleteScheduledActionRequest(input *DeleteScheduledActionInput) (req *aws.Request, output *DeleteScheduledActionOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDeleteScheduledAction == nil {
		opDeleteScheduledAction = &aws.Operation{
			Name:       "DeleteScheduledAction",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DeleteScheduledActionInput{}
	}

	req = c.newRequest(opDeleteScheduledAction, input, output)
	output = &DeleteScheduledActionOutput{}
	req.Data = output
	return
}

// Deletes the specified scheduled action.
func (c *AutoScaling) DeleteScheduledAction(input *DeleteScheduledActionInput) (*DeleteScheduledActionOutput, error) {
	req, out := c.DeleteScheduledActionRequest(input)
	err := req.Send()
	return out, err
}

var opDeleteScheduledAction *aws.Operation

// DeleteTagsRequest generates a request for the DeleteTags operation.
func (c *AutoScaling) DeleteTagsRequest(input *DeleteTagsInput) (req *aws.Request, output *DeleteTagsOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDeleteTags == nil {
		opDeleteTags = &aws.Operation{
			Name:       "DeleteTags",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	req = c.newRequest(opDeleteTags, input, output)
	output = &DeleteTagsOutput{}
	req.Data = output
	return
}

// Deletes the specified tags.
func (c *AutoScaling) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	err := req.Send()
	return out, err
}

var opDeleteTags *aws.Operation

// DescribeAccountLimitsRequest generates a request for the DescribeAccountLimits operation.
func (c *AutoScaling) DescribeAccountLimitsRequest(input *DescribeAccountLimitsInput) (req *aws.Request, output *DescribeAccountLimitsOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeAccountLimits == nil {
		opDescribeAccountLimits = &aws.Operation{
			Name:       "DescribeAccountLimits",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DescribeAccountLimitsInput{}
	}

	req = c.newRequest(opDescribeAccountLimits, input, output)
	output = &DescribeAccountLimitsOutput{}
	req.Data = output
	return
}

// Describes the current Auto Scaling resource limits for your AWS account.
//
// For information about requesting an increase in these limits, see AWS Service
// Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html).
func (c *AutoScaling) DescribeAccountLimits(input *DescribeAccountLimitsInput) (*DescribeAccountLimitsOutput, error) {
	req, out := c.DescribeAccountLimitsRequest(input)
	err := req.Send()
	return out, err
}

var opDescribeAccountLimits *aws.Operation

// DescribeAdjustmentTypesRequest generates a request for the DescribeAdjustmentTypes operation.
func (c *AutoScaling) DescribeAdjustmentTypesRequest(input *DescribeAdjustmentTypesInput) (req *aws.Request, output *DescribeAdjustmentTypesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeAdjustmentTypes == nil {
		opDescribeAdjustmentTypes = &aws.Operation{
			Name:       "DescribeAdjustmentTypes",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DescribeAdjustmentTypesInput{}
	}

	req = c.newRequest(opDescribeAdjustmentTypes, input, output)
	output = &DescribeAdjustmentTypesOutput{}
	req.Data = output
	return
}

// Lists the policy adjustment types for use with PutScalingPolicy.
func (c *AutoScaling) DescribeAdjustmentTypes(input *DescribeAdjustmentTypesInput) (*DescribeAdjustmentTypesOutput, error) {
	req, out := c.DescribeAdjustmentTypesRequest(input)
	err := req.Send()
	return out, err
}

var opDescribeAdjustmentTypes *aws.Operation

// DescribeAutoScalingGroupsRequest generates a request for the DescribeAutoScalingGroups operation.
func (c *AutoScaling) DescribeAutoScalingGroupsRequest(input *DescribeAutoScalingGroupsInput) (req *aws.Request, output *DescribeAutoScalingGroupsOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeAutoScalingGroups == nil {
		opDescribeAutoScalingGroups = &aws.Operation{
			Name:       "DescribeAutoScalingGroups",
			HTTPMethod: "POST",
			HTTPPath:   "/",
			Paginator: &aws.Paginator{
				InputTokens:     []string{"NextToken"},
				OutputTokens:    []string{"NextToken"},
				LimitToken:      "MaxRecords",
				TruncationToken: "",
			},
		}
	}

	if input == nil {
		input = &DescribeAutoScalingGroupsInput{}
	}

	req = c.newRequest(opDescribeAutoScalingGroups, input, output)
	output = &DescribeAutoScalingGroupsOutput{}
	req.Data = output
	return
}

// Describes one or more Auto Scaling groups. If a list of names is not provided,
// the call describes all Auto Scaling groups.
//
// You can specify a maximum number of items to be returned with a single call.
// If there are more items to return, the call returns a token. To get the next
// set of items, repeat the call with the returned token in the NextToken parameter.
func (c *AutoScaling) DescribeAutoScalingGroups(input *DescribeAutoScalingGroupsInput) (*DescribeAutoScalingGroupsOutput, error) {
	req, out := c.DescribeAutoScalingGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribeAutoScalingGroupsPages(input *DescribeAutoScalingGroupsInput, fn func(p *DescribeAutoScalingGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeAutoScalingGroupsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeAutoScalingGroupsOutput), lastPage)
	})
}

var opDescribeAutoScalingGroups *aws.Operation

// DescribeAutoScalingInstancesRequest generates a request for the DescribeAutoScalingInstances operation.
func (c *AutoScaling) DescribeAutoScalingInstancesRequest(input *DescribeAutoScalingInstancesInput) (req *aws.Request, output *DescribeAutoScalingInstancesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeAutoScalingInstances == nil {
		opDescribeAutoScalingInstances = &aws.Operation{
			Name:       "DescribeAutoScalingInstances",
			HTTPMethod: "POST",
			HTTPPath:   "/",
			Paginator: &aws.Paginator{
				InputTokens:     []string{"NextToken"},
				OutputTokens:    []string{"NextToken"},
				LimitToken:      "MaxRecords",
				TruncationToken: "",
			},
		}
	}

	if input == nil {
		input = &DescribeAutoScalingInstancesInput{}
	}

	req = c.newRequest(opDescribeAutoScalingInstances, input, output)
	output = &DescribeAutoScalingInstancesOutput{}
	req.Data = output
	return
}

// Describes one or more Auto Scaling instances. If a list is not provided,
// the call describes all instances.
//
// You can describe up to a maximum of 50 instances with a single call. By
// default, a call returns up to 20 instances. If there are more items to return,
// the call returns a token. To get the next set of items, repeat the call with
// the returned token in the NextToken parameter.
func (c *AutoScaling) DescribeAutoScalingInstances(input *DescribeAutoScalingInstancesInput) (*DescribeAutoScalingInstancesOutput, error) {
	req, out := c.DescribeAutoScalingInstancesRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribeAutoScalingInstancesPages(input *DescribeAutoScalingInstancesInput, fn func(p *DescribeAutoScalingInstancesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeAutoScalingInstancesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeAutoScalingInstancesOutput), lastPage)
	})
}

var opDescribeAutoScalingInstances *aws.Operation

// DescribeAutoScalingNotificationTypesRequest generates a request for the DescribeAutoScalingNotificationTypes operation.
func (c *AutoScaling) DescribeAutoScalingNotificationTypesRequest(input *DescribeAutoScalingNotificationTypesInput) (req *aws.Request, output *DescribeAutoScalingNotificationTypesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeAutoScalingNotificationTypes == nil {
		opDescribeAutoScalingNotificationTypes = &aws.Operation{
			Name:       "DescribeAutoScalingNotificationTypes",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DescribeAutoScalingNotificationTypesInput{}
	}

	req = c.newRequest(opDescribeAutoScalingNotificationTypes, input, output)
	output = &DescribeAutoScalingNotificationTypesOutput{}
	req.Data = output
	return
}

// Lists the notification types that are supported by Auto Scaling.
func (c *AutoScaling) DescribeAutoScalingNotificationTypes(input *DescribeAutoScalingNotificationTypesInput) (*DescribeAutoScalingNotificationTypesOutput, error) {
	req, out := c.DescribeAutoScalingNotificationTypesRequest(input)
	err := req.Send()
	return out, err
}

var opDescribeAutoScalingNotificationTypes *aws.Operation

// DescribeLaunchConfigurationsRequest generates a request for the DescribeLaunchConfigurations operation.
func (c *AutoScaling) DescribeLaunchConfigurationsRequest(input *DescribeLaunchConfigurationsInput) (req *aws.Request, output *DescribeLaunchConfigurationsOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeLaunchConfigurations == nil {
		opDescribeLaunchConfigurations = &aws.Operation{
			Name:       "DescribeLaunchConfigurations",
			HTTPMethod: "POST",
			HTTPPath:   "/",
			Paginator: &aws.Paginator{
				InputTokens:     []string{"NextToken"},
				OutputTokens:    []string{"NextToken"},
				LimitToken:      "MaxRecords",
				TruncationToken: "",
			},
		}
	}

	if input == nil {
		input = &DescribeLaunchConfigurationsInput{}
	}

	req = c.newRequest(opDescribeLaunchConfigurations, input, output)
	output = &DescribeLaunchConfigurationsOutput{}
	req.Data = output
	return
}

// Describes one or more launch configurations. If you omit the list of names,
// then the call describes all launch configurations.
//
// You can specify a maximum number of items to be returned with a single call.
// If there are more items to return, the call returns a token. To get the next
// set of items, repeat the call with the returned token in the NextToken parameter.
func (c *AutoScaling) DescribeLaunchConfigurations(input *DescribeLaunchConfigurationsInput) (*DescribeLaunchConfigurationsOutput, error) {
	req, out := c.DescribeLaunchConfigurationsRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribeLaunchConfigurationsPages(input *DescribeLaunchConfigurationsInput, fn func(p *DescribeLaunchConfigurationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeLaunchConfigurationsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeLaunchConfigurationsOutput), lastPage)
	})
}

var opDescribeLaunchConfigurations *aws.Operation

// DescribeLifecycleHookTypesRequest generates a request for the DescribeLifecycleHookTypes operation.
func (c *AutoScaling) DescribeLifecycleHookTypesRequest(input *DescribeLifecycleHookTypesInput) (req *aws.Request, output *DescribeLifecycleHookTypesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeLifecycleHookTypes == nil {
		opDescribeLifecycleHookTypes = &aws.Operation{
			Name:       "DescribeLifecycleHookTypes",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DescribeLifecycleHookTypesInput{}
	}

	req = c.newRequest(opDescribeLifecycleHookTypes, input, output)
	output = &DescribeLifecycleHookTypesOutput{}
	req.Data = output
	return
}

// Describes the available types of lifecycle hooks.
func (c *AutoScaling) DescribeLifecycleHookTypes(input *DescribeLifecycleHookTypesInput) (*DescribeLifecycleHookTypesOutput, error) {
	req, out := c.DescribeLifecycleHookTypesRequest(input)
	err := req.Send()
	return out, err
}

var opDescribeLifecycleHookTypes *aws.Operation

// DescribeLifecycleHooksRequest generates a request for the DescribeLifecycleHooks operation.
func (c *AutoScaling) DescribeLifecycleHooksRequest(input *DescribeLifecycleHooksInput) (req *aws.Request, output *DescribeLifecycleHooksOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeLifecycleHooks == nil {
		opDescribeLifecycleHooks = &aws.Operation{
			Name:       "DescribeLifecycleHooks",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DescribeLifecycleHooksInput{}
	}

	req = c.newRequest(opDescribeLifecycleHooks, input, output)
	output = &DescribeLifecycleHooksOutput{}
	req.Data = output
	return
}

// Describes the lifecycle hooks for the specified Auto Scaling group.
func (c *AutoScaling) DescribeLifecycleHooks(input *DescribeLifecycleHooksInput) (*DescribeLifecycleHooksOutput, error) {
	req, out := c.DescribeLifecycleHooksRequest(input)
	err := req.Send()
	return out, err
}

var opDescribeLifecycleHooks *aws.Operation

// DescribeMetricCollectionTypesRequest generates a request for the DescribeMetricCollectionTypes operation.
func (c *AutoScaling) DescribeMetricCollectionTypesRequest(input *DescribeMetricCollectionTypesInput) (req *aws.Request, output *DescribeMetricCollectionTypesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeMetricCollectionTypes == nil {
		opDescribeMetricCollectionTypes = &aws.Operation{
			Name:       "DescribeMetricCollectionTypes",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DescribeMetricCollectionTypesInput{}
	}

	req = c.newRequest(opDescribeMetricCollectionTypes, input, output)
	output = &DescribeMetricCollectionTypesOutput{}
	req.Data = output
	return
}

// Returns a list of metrics and a corresponding list of granularities for each
// metric.
//
//  The GroupStandbyInstances metric is not returned by default. You must explicitly
// request it when calling EnableMetricsCollection.
func (c *AutoScaling) DescribeMetricCollectionTypes(input *DescribeMetricCollectionTypesInput) (*DescribeMetricCollectionTypesOutput, error) {
	req, out := c.DescribeMetricCollectionTypesRequest(input)
	err := req.Send()
	return out, err
}

var opDescribeMetricCollectionTypes *aws.Operation

// DescribeNotificationConfigurationsRequest generates a request for the DescribeNotificationConfigurations operation.
func (c *AutoScaling) DescribeNotificationConfigurationsRequest(input *DescribeNotificationConfigurationsInput) (req *aws.Request, output *DescribeNotificationConfigurationsOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeNotificationConfigurations == nil {
		opDescribeNotificationConfigurations = &aws.Operation{
			Name:       "DescribeNotificationConfigurations",
			HTTPMethod: "POST",
			HTTPPath:   "/",
			Paginator: &aws.Paginator{
				InputTokens:     []string{"NextToken"},
				OutputTokens:    []string{"NextToken"},
				LimitToken:      "MaxRecords",
				TruncationToken: "",
			},
		}
	}

	if input == nil {
		input = &DescribeNotificationConfigurationsInput{}
	}

	req = c.newRequest(opDescribeNotificationConfigurations, input, output)
	output = &DescribeNotificationConfigurationsOutput{}
	req.Data = output
	return
}

// Describes the notification actions associated with the specified Auto Scaling
// group.
func (c *AutoScaling) DescribeNotificationConfigurations(input *DescribeNotificationConfigurationsInput) (*DescribeNotificationConfigurationsOutput, error) {
	req, out := c.DescribeNotificationConfigurationsRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribeNotificationConfigurationsPages(input *DescribeNotificationConfigurationsInput, fn func(p *DescribeNotificationConfigurationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeNotificationConfigurationsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeNotificationConfigurationsOutput), lastPage)
	})
}

var opDescribeNotificationConfigurations *aws.Operation

// DescribePoliciesRequest generates a request for the DescribePolicies operation.
func (c *AutoScaling) DescribePoliciesRequest(input *DescribePoliciesInput) (req *aws.Request, output *DescribePoliciesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribePolicies == nil {
		opDescribePolicies = &aws.Operation{
			Name:       "DescribePolicies",
			HTTPMethod: "POST",
			HTTPPath:   "/",
			Paginator: &aws.Paginator{
				InputTokens:     []string{"NextToken"},
				OutputTokens:    []string{"NextToken"},
				LimitToken:      "MaxRecords",
				TruncationToken: "",
			},
		}
	}

	if input == nil {
		input = &DescribePoliciesInput{}
	}

	req = c.newRequest(opDescribePolicies, input, output)
	output = &DescribePoliciesOutput{}
	req.Data = output
	return
}

// Describes the policies for the specified Auto Scaling group.
//
// You can specify a maximum number of items to be returned with a single call.
// If there are more items to return, the call returns a token. To get the next
// set of items, repeat the call with the returned token in the NextToken parameter.
func (c *AutoScaling) DescribePolicies(input *DescribePoliciesInput) (*DescribePoliciesOutput, error) {
	req, out := c.DescribePoliciesRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribePoliciesPages(input *DescribePoliciesInput, fn func(p *DescribePoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribePoliciesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribePoliciesOutput), lastPage)
	})
}

var opDescribePolicies *aws.Operation

// DescribeScalingActivitiesRequest generates a request for the DescribeScalingActivities operation.
func (c *AutoScaling) DescribeScalingActivitiesRequest(input *DescribeScalingActivitiesInput) (req *aws.Request, output *DescribeScalingActivitiesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeScalingActivities == nil {
		opDescribeScalingActivities = &aws.Operation{
			Name:       "DescribeScalingActivities",
			HTTPMethod: "POST",
			HTTPPath:   "/",
			Paginator: &aws.Paginator{
				InputTokens:     []string{"NextToken"},
				OutputTokens:    []string{"NextToken"},
				LimitToken:      "MaxRecords",
				TruncationToken: "",
			},
		}
	}

	if input == nil {
		input = &DescribeScalingActivitiesInput{}
	}

	req = c.newRequest(opDescribeScalingActivities, input, output)
	output = &DescribeScalingActivitiesOutput{}
	req.Data = output
	return
}

// Describes one or more scaling activities for the specified Auto Scaling group.
// If you omit the ActivityIds, the call returns all activities from the past
// six weeks. Activities are sorted by the start time. Activities still in progress
// appear first on the list.
//
// You can specify a maximum number of items to be returned with a single call.
// If there are more items to return, the call returns a token. To get the next
// set of items, repeat the call with the returned token in the NextToken parameter.
func (c *AutoScaling) DescribeScalingActivities(input *DescribeScalingActivitiesInput) (*DescribeScalingActivitiesOutput, error) {
	req, out := c.DescribeScalingActivitiesRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribeScalingActivitiesPages(input *DescribeScalingActivitiesInput, fn func(p *DescribeScalingActivitiesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeScalingActivitiesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeScalingActivitiesOutput), lastPage)
	})
}

var opDescribeScalingActivities *aws.Operation

// DescribeScalingProcessTypesRequest generates a request for the DescribeScalingProcessTypes operation.
func (c *AutoScaling) DescribeScalingProcessTypesRequest(input *DescribeScalingProcessTypesInput) (req *aws.Request, output *DescribeScalingProcessTypesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeScalingProcessTypes == nil {
		opDescribeScalingProcessTypes = &aws.Operation{
			Name:       "DescribeScalingProcessTypes",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DescribeScalingProcessTypesInput{}
	}

	req = c.newRequest(opDescribeScalingProcessTypes, input, output)
	output = &DescribeScalingProcessTypesOutput{}
	req.Data = output
	return
}

// Returns scaling process types for use in the ResumeProcesses and SuspendProcesses
// actions.
func (c *AutoScaling) DescribeScalingProcessTypes(input *DescribeScalingProcessTypesInput) (*DescribeScalingProcessTypesOutput, error) {
	req, out := c.DescribeScalingProcessTypesRequest(input)
	err := req.Send()
	return out, err
}

var opDescribeScalingProcessTypes *aws.Operation

// DescribeScheduledActionsRequest generates a request for the DescribeScheduledActions operation.
func (c *AutoScaling) DescribeScheduledActionsRequest(input *DescribeScheduledActionsInput) (req *aws.Request, output *DescribeScheduledActionsOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeScheduledActions == nil {
		opDescribeScheduledActions = &aws.Operation{
			Name:       "DescribeScheduledActions",
			HTTPMethod: "POST",
			HTTPPath:   "/",
			Paginator: &aws.Paginator{
				InputTokens:     []string{"NextToken"},
				OutputTokens:    []string{"NextToken"},
				LimitToken:      "MaxRecords",
				TruncationToken: "",
			},
		}
	}

	if input == nil {
		input = &DescribeScheduledActionsInput{}
	}

	req = c.newRequest(opDescribeScheduledActions, input, output)
	output = &DescribeScheduledActionsOutput{}
	req.Data = output
	return
}

// Lists the actions scheduled for your Auto Scaling group that haven't been
// executed. To list the actions that were already executed, use DescribeScalingActivities.
func (c *AutoScaling) DescribeScheduledActions(input *DescribeScheduledActionsInput) (*DescribeScheduledActionsOutput, error) {
	req, out := c.DescribeScheduledActionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribeScheduledActionsPages(input *DescribeScheduledActionsInput, fn func(p *DescribeScheduledActionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeScheduledActionsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeScheduledActionsOutput), lastPage)
	})
}

var opDescribeScheduledActions *aws.Operation

// DescribeTagsRequest generates a request for the DescribeTags operation.
func (c *AutoScaling) DescribeTagsRequest(input *DescribeTagsInput) (req *aws.Request, output *DescribeTagsOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeTags == nil {
		opDescribeTags = &aws.Operation{
			Name:       "DescribeTags",
			HTTPMethod: "POST",
			HTTPPath:   "/",
			Paginator: &aws.Paginator{
				InputTokens:     []string{"NextToken"},
				OutputTokens:    []string{"NextToken"},
				LimitToken:      "MaxRecords",
				TruncationToken: "",
			},
		}
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	req = c.newRequest(opDescribeTags, input, output)
	output = &DescribeTagsOutput{}
	req.Data = output
	return
}

// Describes the specified tags.
//
// You can use filters to limit the results. For example, you can query for
// the tags for a specific Auto Scaling group. You can specify multiple values
// for a filter. A tag must match at least one of the specified values for it
// to be included in the results.
//
// You can also specify multiple filters. The result includes information for
// a particular tag only if it matches all the filters. If there's no match,
// no special message is returned.
func (c *AutoScaling) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribeTagsPages(input *DescribeTagsInput, fn func(p *DescribeTagsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeTagsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeTagsOutput), lastPage)
	})
}

var opDescribeTags *aws.Operation

// DescribeTerminationPolicyTypesRequest generates a request for the DescribeTerminationPolicyTypes operation.
func (c *AutoScaling) DescribeTerminationPolicyTypesRequest(input *DescribeTerminationPolicyTypesInput) (req *aws.Request, output *DescribeTerminationPolicyTypesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeTerminationPolicyTypes == nil {
		opDescribeTerminationPolicyTypes = &aws.Operation{
			Name:       "DescribeTerminationPolicyTypes",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DescribeTerminationPolicyTypesInput{}
	}

	req = c.newRequest(opDescribeTerminationPolicyTypes, input, output)
	output = &DescribeTerminationPolicyTypesOutput{}
	req.Data = output
	return
}

// Lists the termination policies supported by Auto Scaling.
func (c *AutoScaling) DescribeTerminationPolicyTypes(input *DescribeTerminationPolicyTypesInput) (*DescribeTerminationPolicyTypesOutput, error) {
	req, out := c.DescribeTerminationPolicyTypesRequest(input)
	err := req.Send()
	return out, err
}

var opDescribeTerminationPolicyTypes *aws.Operation

// DetachInstancesRequest generates a request for the DetachInstances operation.
func (c *AutoScaling) DetachInstancesRequest(input *DetachInstancesInput) (req *aws.Request, output *DetachInstancesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDetachInstances == nil {
		opDetachInstances = &aws.Operation{
			Name:       "DetachInstances",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DetachInstancesInput{}
	}

	req = c.newRequest(opDetachInstances, input, output)
	output = &DetachInstancesOutput{}
	req.Data = output
	return
}

// Removes one or more instances from the specified Auto Scaling group. After
// the instances are detached, you can manage them independently from the rest
// of the Auto Scaling group.
//
// For more information, see Detach EC2 Instances from Your Auto Scaling Group
// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/detach-instance-asg.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) DetachInstances(input *DetachInstancesInput) (*DetachInstancesOutput, error) {
	req, out := c.DetachInstancesRequest(input)
	err := req.Send()
	return out, err
}

var opDetachInstances *aws.Operation

// DisableMetricsCollectionRequest generates a request for the DisableMetricsCollection operation.
func (c *AutoScaling) DisableMetricsCollectionRequest(input *DisableMetricsCollectionInput) (req *aws.Request, output *DisableMetricsCollectionOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDisableMetricsCollection == nil {
		opDisableMetricsCollection = &aws.Operation{
			Name:       "DisableMetricsCollection",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DisableMetricsCollectionInput{}
	}

	req = c.newRequest(opDisableMetricsCollection, input, output)
	output = &DisableMetricsCollectionOutput{}
	req.Data = output
	return
}

// Disables monitoring of the specified metrics for the specified Auto Scaling
// group.
func (c *AutoScaling) DisableMetricsCollection(input *DisableMetricsCollectionInput) (*DisableMetricsCollectionOutput, error) {
	req, out := c.DisableMetricsCollectionRequest(input)
	err := req.Send()
	return out, err
}

var opDisableMetricsCollection *aws.Operation

// EnableMetricsCollectionRequest generates a request for the EnableMetricsCollection operation.
func (c *AutoScaling) EnableMetricsCollectionRequest(input *EnableMetricsCollectionInput) (req *aws.Request, output *EnableMetricsCollectionOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opEnableMetricsCollection == nil {
		opEnableMetricsCollection = &aws.Operation{
			Name:       "EnableMetricsCollection",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &EnableMetricsCollectionInput{}
	}

	req = c.newRequest(opEnableMetricsCollection, input, output)
	output = &EnableMetricsCollectionOutput{}
	req.Data = output
	return
}

// Enables monitoring of the specified metrics for the specified Auto Scaling
// group.
//
// You can only enable metrics collection if InstanceMonitoring in the launch
// configuration for the group is set to True.
func (c *AutoScaling) EnableMetricsCollection(input *EnableMetricsCollectionInput) (*EnableMetricsCollectionOutput, error) {
	req, out := c.EnableMetricsCollectionRequest(input)
	err := req.Send()
	return out, err
}

var opEnableMetricsCollection *aws.Operation

// EnterStandbyRequest generates a request for the EnterStandby operation.
func (c *AutoScaling) EnterStandbyRequest(input *EnterStandbyInput) (req *aws.Request, output *EnterStandbyOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opEnterStandby == nil {
		opEnterStandby = &aws.Operation{
			Name:       "EnterStandby",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &EnterStandbyInput{}
	}

	req = c.newRequest(opEnterStandby, input, output)
	output = &EnterStandbyOutput{}
	req.Data = output
	return
}

// Moves the specified instances into Standby mode.
//
// For more information, see Auto Scaling InService State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingInServiceState.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) EnterStandby(input *EnterStandbyInput) (*EnterStandbyOutput, error) {
	req, out := c.EnterStandbyRequest(input)
	err := req.Send()
	return out, err
}

var opEnterStandby *aws.Operation

// ExecutePolicyRequest generates a request for the ExecutePolicy operation.
func (c *AutoScaling) ExecutePolicyRequest(input *ExecutePolicyInput) (req *aws.Request, output *ExecutePolicyOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opExecutePolicy == nil {
		opExecutePolicy = &aws.Operation{
			Name:       "ExecutePolicy",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &ExecutePolicyInput{}
	}

	req = c.newRequest(opExecutePolicy, input, output)
	output = &ExecutePolicyOutput{}
	req.Data = output
	return
}

// Executes the specified policy.
func (c *AutoScaling) ExecutePolicy(input *ExecutePolicyInput) (*ExecutePolicyOutput, error) {
	req, out := c.ExecutePolicyRequest(input)
	err := req.Send()
	return out, err
}

var opExecutePolicy *aws.Operation

// ExitStandbyRequest generates a request for the ExitStandby operation.
func (c *AutoScaling) ExitStandbyRequest(input *ExitStandbyInput) (req *aws.Request, output *ExitStandbyOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opExitStandby == nil {
		opExitStandby = &aws.Operation{
			Name:       "ExitStandby",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &ExitStandbyInput{}
	}

	req = c.newRequest(opExitStandby, input, output)
	output = &ExitStandbyOutput{}
	req.Data = output
	return
}

// Moves the specified instances out of Standby mode.
//
// For more information, see Auto Scaling InService State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingInServiceState.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) ExitStandby(input *ExitStandbyInput) (*ExitStandbyOutput, error) {
	req, out := c.ExitStandbyRequest(input)
	err := req.Send()
	return out, err
}

var opExitStandby *aws.Operation

// PutLifecycleHookRequest generates a request for the PutLifecycleHook operation.
func (c *AutoScaling) PutLifecycleHookRequest(input *PutLifecycleHookInput) (req *aws.Request, output *PutLifecycleHookOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opPutLifecycleHook == nil {
		opPutLifecycleHook = &aws.Operation{
			Name:       "PutLifecycleHook",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &PutLifecycleHookInput{}
	}

	req = c.newRequest(opPutLifecycleHook, input, output)
	output = &PutLifecycleHookOutput{}
	req.Data = output
	return
}

// Creates or updates a lifecycle hook for the specified Auto Scaling Group.
//
// A lifecycle hook tells Auto Scaling that you want to perform an action on
// an instance that is not actively in service; for example, either when the
// instance launches or before the instance terminates.
//
// This operation is a part of the basic sequence for adding a lifecycle hook
// to an Auto Scaling group:
//
//  Create a notification target. A target can be either an Amazon SQS queue
// or an Amazon SNS topic. Create an IAM role. This role allows Auto Scaling
// to publish lifecycle notifications to the designated SQS queue or SNS topic.
// Create the lifecycle hook. You can create a hook that acts when instances
// launch or when instances terminate. If necessary, record the lifecycle action
// heartbeat to keep the instance in a pending state. Complete the lifecycle
// action.  For more information, see Auto Scaling Pending State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingPendingState.html)
// and Auto Scaling Terminating State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingTerminatingState.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) PutLifecycleHook(input *PutLifecycleHookInput) (*PutLifecycleHookOutput, error) {
	req, out := c.PutLifecycleHookRequest(input)
	err := req.Send()
	return out, err
}

var opPutLifecycleHook *aws.Operation

// PutNotificationConfigurationRequest generates a request for the PutNotificationConfiguration operation.
func (c *AutoScaling) PutNotificationConfigurationRequest(input *PutNotificationConfigurationInput) (req *aws.Request, output *PutNotificationConfigurationOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opPutNotificationConfiguration == nil {
		opPutNotificationConfiguration = &aws.Operation{
			Name:       "PutNotificationConfiguration",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &PutNotificationConfigurationInput{}
	}

	req = c.newRequest(opPutNotificationConfiguration, input, output)
	output = &PutNotificationConfigurationOutput{}
	req.Data = output
	return
}

// Configures an Auto Scaling group to send notifications when specified events
// take place. Subscribers to this topic can have messages for events delivered
// to an endpoint such as a web server or email address.
//
// For more information see Getting Notifications When Your Auto Scaling Group
// Changes (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/ASGettingNotifications.html)
// in the Auto Scaling Developer Guide.
//
// This configuration overwrites an existing configuration.
func (c *AutoScaling) PutNotificationConfiguration(input *PutNotificationConfigurationInput) (*PutNotificationConfigurationOutput, error) {
	req, out := c.PutNotificationConfigurationRequest(input)
	err := req.Send()
	return out, err
}

var opPutNotificationConfiguration *aws.Operation

// PutScalingPolicyRequest generates a request for the PutScalingPolicy operation.
func (c *AutoScaling) PutScalingPolicyRequest(input *PutScalingPolicyInput) (req *aws.Request, output *PutScalingPolicyOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opPutScalingPolicy == nil {
		opPutScalingPolicy = &aws.Operation{
			Name:       "PutScalingPolicy",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &PutScalingPolicyInput{}
	}

	req = c.newRequest(opPutScalingPolicy, input, output)
	output = &PutScalingPolicyOutput{}
	req.Data = output
	return
}

// Creates or updates a policy for an Auto Scaling group. To update an existing
// policy, use the existing policy name and set the parameters you want to change.
// Any existing parameter not changed in an update to an existing policy is
// not changed in this update request.
func (c *AutoScaling) PutScalingPolicy(input *PutScalingPolicyInput) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	err := req.Send()
	return out, err
}

var opPutScalingPolicy *aws.Operation

// PutScheduledUpdateGroupActionRequest generates a request for the PutScheduledUpdateGroupAction operation.
func (c *AutoScaling) PutScheduledUpdateGroupActionRequest(input *PutScheduledUpdateGroupActionInput) (req *aws.Request, output *PutScheduledUpdateGroupActionOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opPutScheduledUpdateGroupAction == nil {
		opPutScheduledUpdateGroupAction = &aws.Operation{
			Name:       "PutScheduledUpdateGroupAction",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &PutScheduledUpdateGroupActionInput{}
	}

	req = c.newRequest(opPutScheduledUpdateGroupAction, input, output)
	output = &PutScheduledUpdateGroupActionOutput{}
	req.Data = output
	return
}

// Creates or updates a scheduled scaling action for an Auto Scaling group.
// When updating a scheduled scaling action, if you leave a parameter unspecified,
// the corresponding value remains unchanged in the affected Auto Scaling group.
//
// For more information, see Scheduled Scaling (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/schedule_time.html)
// in the Auto Scaling Developer Guide.
//
//  Auto Scaling supports the date and time expressed in "YYYY-MM-DDThh:mm:ssZ"
// format in UTC/GMT only.
func (c *AutoScaling) PutScheduledUpdateGroupAction(input *PutScheduledUpdateGroupActionInput) (*PutScheduledUpdateGroupActionOutput, error) {
	req, out := c.PutScheduledUpdateGroupActionRequest(input)
	err := req.Send()
	return out, err
}

var opPutScheduledUpdateGroupAction *aws.Operation

// RecordLifecycleActionHeartbeatRequest generates a request for the RecordLifecycleActionHeartbeat operation.
func (c *AutoScaling) RecordLifecycleActionHeartbeatRequest(input *RecordLifecycleActionHeartbeatInput) (req *aws.Request, output *RecordLifecycleActionHeartbeatOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opRecordLifecycleActionHeartbeat == nil {
		opRecordLifecycleActionHeartbeat = &aws.Operation{
			Name:       "RecordLifecycleActionHeartbeat",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &RecordLifecycleActionHeartbeatInput{}
	}

	req = c.newRequest(opRecordLifecycleActionHeartbeat, input, output)
	output = &RecordLifecycleActionHeartbeatOutput{}
	req.Data = output
	return
}

// Records a heartbeat for the lifecycle action associated with a specific token.
// This extends the timeout by the length of time defined by the HeartbeatTimeout
// parameter of PutLifecycleHook.
//
// This operation is a part of the basic sequence for adding a lifecycle hook
// to an Auto Scaling group:
//
//  Create a notification target. A target can be either an Amazon SQS queue
// or an Amazon SNS topic. Create an IAM role. This role allows Auto Scaling
// to publish lifecycle notifications to the designated SQS queue or SNS topic.
// Create the lifecycle hook. You can create a hook that acts when instances
// launch or when instances terminate. If necessary, record the lifecycle action
// heartbeat to keep the instance in a pending state. Complete the lifecycle
// action.  For more information, see Auto Scaling Pending State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingPendingState.html)
// and Auto Scaling Terminating State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingTerminatingState.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) RecordLifecycleActionHeartbeat(input *RecordLifecycleActionHeartbeatInput) (*RecordLifecycleActionHeartbeatOutput, error) {
	req, out := c.RecordLifecycleActionHeartbeatRequest(input)
	err := req.Send()
	return out, err
}

var opRecordLifecycleActionHeartbeat *aws.Operation

// ResumeProcessesRequest generates a request for the ResumeProcesses operation.
func (c *AutoScaling) ResumeProcessesRequest(input *ScalingProcessQuery) (req *aws.Request, output *ResumeProcessesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opResumeProcesses == nil {
		opResumeProcesses = &aws.Operation{
			Name:       "ResumeProcesses",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &ScalingProcessQuery{}
	}

	req = c.newRequest(opResumeProcesses, input, output)
	output = &ResumeProcessesOutput{}
	req.Data = output
	return
}

// Resumes the specified suspended Auto Scaling processes for the specified
// Auto Scaling group. To resume specific processes, use the ScalingProcesses
// parameter. To resume all processes, omit the ScalingProcesses parameter.
// For more information, see Suspend and Resume Auto Scaling Processes (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/US_SuspendResume.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) ResumeProcesses(input *ScalingProcessQuery) (*ResumeProcessesOutput, error) {
	req, out := c.ResumeProcessesRequest(input)
	err := req.Send()
	return out, err
}

var opResumeProcesses *aws.Operation

// SetDesiredCapacityRequest generates a request for the SetDesiredCapacity operation.
func (c *AutoScaling) SetDesiredCapacityRequest(input *SetDesiredCapacityInput) (req *aws.Request, output *SetDesiredCapacityOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opSetDesiredCapacity == nil {
		opSetDesiredCapacity = &aws.Operation{
			Name:       "SetDesiredCapacity",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &SetDesiredCapacityInput{}
	}

	req = c.newRequest(opSetDesiredCapacity, input, output)
	output = &SetDesiredCapacityOutput{}
	req.Data = output
	return
}

// Sets the size of the specified AutoScalingGroup.
func (c *AutoScaling) SetDesiredCapacity(input *SetDesiredCapacityInput) (*SetDesiredCapacityOutput, error) {
	req, out := c.SetDesiredCapacityRequest(input)
	err := req.Send()
	return out, err
}

var opSetDesiredCapacity *aws.Operation

// SetInstanceHealthRequest generates a request for the SetInstanceHealth operation.
func (c *AutoScaling) SetInstanceHealthRequest(input *SetInstanceHealthInput) (req *aws.Request, output *SetInstanceHealthOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opSetInstanceHealth == nil {
		opSetInstanceHealth = &aws.Operation{
			Name:       "SetInstanceHealth",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &SetInstanceHealthInput{}
	}

	req = c.newRequest(opSetInstanceHealth, input, output)
	output = &SetInstanceHealthOutput{}
	req.Data = output
	return
}

// Sets the health status of the specified instance.
//
// For more information, see Health Checks (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/healthcheck.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) SetInstanceHealth(input *SetInstanceHealthInput) (*SetInstanceHealthOutput, error) {
	req, out := c.SetInstanceHealthRequest(input)
	err := req.Send()
	return out, err
}

var opSetInstanceHealth *aws.Operation

// SuspendProcessesRequest generates a request for the SuspendProcesses operation.
func (c *AutoScaling) SuspendProcessesRequest(input *ScalingProcessQuery) (req *aws.Request, output *SuspendProcessesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opSuspendProcesses == nil {
		opSuspendProcesses = &aws.Operation{
			Name:       "SuspendProcesses",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &ScalingProcessQuery{}
	}

	req = c.newRequest(opSuspendProcesses, input, output)
	output = &SuspendProcessesOutput{}
	req.Data = output
	return
}

// Suspends the specified Auto Scaling processes for the specified Auto Scaling
// group. To suspend specific processes, use the ScalingProcesses parameter.
// To suspend all processes, omit the ScalingProcesses parameter.
//
// Note that if you suspend either the Launch or Terminate process types, it
// can prevent other process types from functioning properly.
//
// To resume processes that have been suspended, use ResumeProcesses.
//
// For more information, see Suspend and Resume Auto Scaling Processes (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/US_SuspendResume.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) SuspendProcesses(input *ScalingProcessQuery) (*SuspendProcessesOutput, error) {
	req, out := c.SuspendProcessesRequest(input)
	err := req.Send()
	return out, err
}

var opSuspendProcesses *aws.Operation

// TerminateInstanceInAutoScalingGroupRequest generates a request for the TerminateInstanceInAutoScalingGroup operation.
func (c *AutoScaling) TerminateInstanceInAutoScalingGroupRequest(input *TerminateInstanceInAutoScalingGroupInput) (req *aws.Request, output *TerminateInstanceInAutoScalingGroupOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opTerminateInstanceInAutoScalingGroup == nil {
		opTerminateInstanceInAutoScalingGroup = &aws.Operation{
			Name:       "TerminateInstanceInAutoScalingGroup",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &TerminateInstanceInAutoScalingGroupInput{}
	}

	req = c.newRequest(opTerminateInstanceInAutoScalingGroup, input, output)
	output = &TerminateInstanceInAutoScalingGroupOutput{}
	req.Data = output
	return
}

// Terminates the specified instance and optionally adjusts the desired group
// size.
//
// This call simply makes a termination request. The instances is not terminated
// immediately.
func (c *AutoScaling) TerminateInstanceInAutoScalingGroup(input *TerminateInstanceInAutoScalingGroupInput) (*TerminateInstanceInAutoScalingGroupOutput, error) {
	req, out := c.TerminateInstanceInAutoScalingGroupRequest(input)
	err := req.Send()
	return out, err
}

var opTerminateInstanceInAutoScalingGroup *aws.Operation

// UpdateAutoScalingGroupRequest generates a request for the UpdateAutoScalingGroup operation.
func (c *AutoScaling) UpdateAutoScalingGroupRequest(input *UpdateAutoScalingGroupInput) (req *aws.Request, output *UpdateAutoScalingGroupOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opUpdateAutoScalingGroup == nil {
		opUpdateAutoScalingGroup = &aws.Operation{
			Name:       "UpdateAutoScalingGroup",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &UpdateAutoScalingGroupInput{}
	}

	req = c.newRequest(opUpdateAutoScalingGroup, input, output)
	output = &UpdateAutoScalingGroupOutput{}
	req.Data = output
	return
}

// Updates the configuration for the specified AutoScalingGroup.
//
//   To update an Auto Scaling group with a launch configuration that has the
// InstanceMonitoring flag set to False, you must first ensure that collection
// of group metrics is disabled. Otherwise, calls to UpdateAutoScalingGroup
// will fail. If you have previously enabled group metrics collection, you can
// disable collection of all group metrics by calling DisableMetricsCollection.
//
//   The new settings are registered upon the completion of this call. Any
// launch configuration settings take effect on any triggers after this call
// returns. Scaling activities that are currently in progress aren't affected.
//
//    If a new value is specified for MinSize without specifying the value
// for DesiredCapacity, and if the new MinSize is larger than the current size
// of the Auto Scaling group, there will be an implicit call to SetDesiredCapacity
// to set the group to the new MinSize.
//
//   If a new value is specified for MaxSize without specifying the value for
// DesiredCapacity, and the new MaxSize is smaller than the current size of
// the Auto Scaling group, there will be an implicit call to SetDesiredCapacity
// to set the group to the new MaxSize.
//
//   All other optional parameters are left unchanged if not passed in the
// request.
func (c *AutoScaling) UpdateAutoScalingGroup(input *UpdateAutoScalingGroupInput) (*UpdateAutoScalingGroupOutput, error) {
	req, out := c.UpdateAutoScalingGroupRequest(input)
	err := req.Send()
	return out, err
}

var opUpdateAutoScalingGroup *aws.Operation

// Describes a long-running process that represents a change to your Auto Scaling
// group, such as changing its size. This can also be a process to replace an
// instance, or a process to perform any other long-running operations.
type Activity struct {
	// The ID of the activity.
	ActivityID *string `locationName:"ActivityId" type:"string" required:"true"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// The reason the activity was begun.
	Cause *string `type:"string" required:"true"`

	// A friendly, more verbose description of the scaling activity.
	Description *string `type:"string"`

	// The details about the scaling activity.
	Details *string `type:"string"`

	// The end time of this activity.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A value between 0 and 100 that indicates the progress of the activity.
	Progress *int64 `type:"integer"`

	// The start time of this activity.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The current status of the activity.
	StatusCode *string `type:"string" required:"true"`

	// A friendly, more verbose description of the activity status.
	StatusMessage *string `type:"string"`

	metadataActivity `json:"-" xml:"-"`
}

type metadataActivity struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes a policy adjustment type.
type AdjustmentType struct {
	// The policy adjustment type. The valid values are ChangeInCapacity, ExactCapacity,
	// and PercentChangeInCapacity.
	//
	// For more information, see Dynamic Scaling (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/as-scale-based-on-demand.html)
	// in the Auto Scaling Developer Guide.
	AdjustmentType *string `type:"string"`

	metadataAdjustmentType `json:"-" xml:"-"`
}

type metadataAdjustmentType struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes an alarm.
type Alarm struct {
	// The Amazon Resource Name (ARN) of the alarm.
	AlarmARN *string `type:"string"`

	// The name of the alarm.
	AlarmName *string `type:"string"`

	metadataAlarm `json:"-" xml:"-"`
}

type metadataAlarm struct {
	SDKShapeTraits bool `type:"structure"`
}

type AttachInstancesInput struct {
	// The name of the group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// One or more EC2 instance IDs. You must specify at least one ID.
	InstanceIDs []*string `locationName:"InstanceIds" type:"list"`

	metadataAttachInstancesInput `json:"-" xml:"-"`
}

type metadataAttachInstancesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type AttachInstancesOutput struct {
	metadataAttachInstancesOutput `json:"-" xml:"-"`
}

type metadataAttachInstancesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes a block device mapping.
type BlockDeviceMapping struct {
	// The device name exposed to the EC2 instance (for example, /dev/sdh or xvdh).
	DeviceName *string `type:"string" required:"true"`

	// The information about the Amazon EBS volume.
	EBS *EBS `locationName:"Ebs" type:"structure"`

	// Suppresses a device mapping.
	//
	// If NoDevice is set to true for the root device, the instance might fail
	// the EC2 health check. Auto Scaling launches a replacement instance if the
	// instance fails the health check.
	NoDevice *bool `type:"boolean"`

	// The name of the virtual device, ephemeral0 to ephemeral3.
	VirtualName *string `type:"string"`

	metadataBlockDeviceMapping `json:"-" xml:"-"`
}

type metadataBlockDeviceMapping struct {
	SDKShapeTraits bool `type:"structure"`
}

type CompleteLifecycleActionInput struct {
	// The name of the group for the lifecycle hook.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// The action for the group to take. This parameter can be either CONTINUE or
	// ABANDON.
	LifecycleActionResult *string `type:"string" required:"true"`

	// A universally unique identifier (UUID) that identifies a specific lifecycle
	// action associated with an instance. Auto Scaling sends this token to the
	// notification target you specified when you created the lifecycle hook.
	LifecycleActionToken *string `type:"string" required:"true"`

	// The name of the lifecycle hook.
	LifecycleHookName *string `type:"string" required:"true"`

	metadataCompleteLifecycleActionInput `json:"-" xml:"-"`
}

type metadataCompleteLifecycleActionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CompleteLifecycleActionOutput struct {
	metadataCompleteLifecycleActionOutput `json:"-" xml:"-"`
}

type metadataCompleteLifecycleActionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateAutoScalingGroupInput struct {
	// The name of the group. This name must be unique within the scope of your
	// AWS account.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// One or more Availability Zones for the group. This parameter is optional
	// if you specify subnets using the VPCZoneIdentifier parameter.
	AvailabilityZones []*string `type:"list"`

	// The amount of time, in seconds, after a scaling activity completes before
	// another scaling activity can start.
	//
	// If DefaultCooldown is not specified, the default value is 300. For more
	// information, see Understanding Auto Scaling Cooldowns (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/Cooldown.html)
	// in the Auto Scaling Developer Guide.
	DefaultCooldown *int64 `type:"integer"`

	// The number of EC2 instances that should be running in the group. This value
	// must be greater than or equal to the minimum size of the group and less than
	// or equal to the maximum size of the group.
	DesiredCapacity *int64 `type:"integer"`

	// The amount of time, in seconds, after an EC2 instance comes into service
	// that Auto Scaling starts checking its health. During this time, any health
	// check failures for the instance are ignored.
	//
	// This parameter is required if you are adding an ELB health check. Frequently,
	// new instances need to warm up, briefly, before they can pass a health check.
	// To provide ample warm-up time, set the health check grace period of the group
	// to match the expected startup period of your application.
	//
	// For more information, see Add an Elastic Load Balancing Health Check to
	// Your Auto Scaling Group (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/as-add-elb-healthcheck.html)
	// in the Auto Scaling Developer Guide.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks. The valid values are EC2 and ELB.
	//
	// By default, health checks use Amazon EC2 instance status checks to determine
	// the health of an instance. For more information, see Health Checks (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/healthcheck.html).
	HealthCheckType *string `type:"string"`

	// The ID of the EC2 instance used to create a launch configuration for the
	// group. Alternatively, use the LaunchConfigurationName parameter to specify
	// a launch configuration instead of an EC2 instance.
	//
	// When you specify an ID of an instance, Auto Scaling creates a new launch
	// configuration and associates it with the group. This launch configuration
	// derives its attributes from the specified instance, with the exception of
	// the block device mapping.
	//
	// For more information, see Create an Auto Scaling Group Using an EC2 Instance
	// ID (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/create-asg-from-instance.html)
	// in the Auto Scaling Developer Guide.
	InstanceID *string `locationName:"InstanceId" type:"string"`

	// The name of the launch configuration. Alternatively, use the InstanceId parameter
	// to specify an EC2 instance instead of a launch configuration.
	LaunchConfigurationName *string `type:"string"`

	// One or more load balancers.
	//
	// For more information, see Load Balance Your Auto Scaling Group (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/US_SetUpASLBApp.html)
	// in the Auto Scaling Developer Guide.
	LoadBalancerNames []*string `type:"list"`

	// The maximum size of the group.
	MaxSize *int64 `type:"integer" required:"true"`

	// The minimum size of the group.
	MinSize *int64 `type:"integer" required:"true"`

	// The name of the placement group into which you'll launch your instances,
	// if any. For more information, see Placement Groups (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html).
	PlacementGroup *string `type:"string"`

	// The tag to be created or updated. Each tag should be defined by its resource
	// type, resource ID, key, value, and a propagate flag. Valid values: key=value,
	// value=value, propagate=true or false. Value and propagate are optional parameters.
	//
	// For more information, see Add, Modify, or Remove Auto Scaling Group Tags
	// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/ASTagging.html)
	// in the Auto Scaling Developer Guide.
	Tags []*Tag `type:"list"`

	// One or more termination policies used to select the instance to terminate.
	// These policies are executed in the order that they are listed.
	//
	// For more information, see Choosing a Termination Policy for Your Auto Scaling
	// Group (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/us-termination-policy.html)
	// in the Auto Scaling Developer Guide.
	TerminationPolicies []*string `type:"list"`

	// A comma-separated list of subnet identifiers for your virtual private cloud
	// (VPC).
	//
	// If you specify subnets and Availability Zones with this call, ensure that
	// the subnets' Availability Zones match the Availability Zones specified.
	//
	// For more information, see Auto Scaling and Amazon VPC (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/autoscalingsubnets.html)
	// in the Auto Scaling Developer Guide.
	VPCZoneIdentifier *string `type:"string"`

	metadataCreateAutoScalingGroupInput `json:"-" xml:"-"`
}

type metadataCreateAutoScalingGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateAutoScalingGroupOutput struct {
	metadataCreateAutoScalingGroupOutput `json:"-" xml:"-"`
}

type metadataCreateAutoScalingGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateLaunchConfigurationInput struct {
	// Used for groups that launch instances into a virtual private cloud (VPC).
	// Specifies whether to assign a public IP address to each instance. For more
	// information, see Auto Scaling and Amazon VPC (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/autoscalingsubnets.html)
	// in the Auto Scaling Developer Guide.
	//
	//  If you specify a value for this parameter, be sure to specify at least
	// one subnet using the VPCZoneIdentifier parameter when you create your group.
	//
	//  Default: If the instance is launched into a default subnet, the default
	// is true. If the instance is launched into a nondefault subnet, the default
	// is false. For more information, see Supported Platforms (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide//as-supported-platforms.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	AssociatePublicIPAddress *bool `locationName:"AssociatePublicIpAddress" type:"boolean"`

	// One or more mappings that specify how block devices are exposed to the instance.
	// For more information, see Block Device Mapping (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	BlockDeviceMappings []*BlockDeviceMapping `type:"list"`

	// The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to.
	// This parameter can only be used if you are launching EC2-Classic instances.
	// For more information, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClassicLinkVPCID *string `locationName:"ClassicLinkVPCId" type:"string"`

	// The IDs of one or more security groups for the VPC specified in ClassicLinkVPCId.
	// This parameter is required if ClassicLinkVPCId is specified, and cannot be
	// used otherwise. For more information, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClassicLinkVPCSecurityGroups []*string `type:"list"`

	// Indicates whether the instance is optimized for Amazon EBS I/O. By default,
	// the instance is not optimized for EBS I/O. The optimization provides dedicated
	// throughput to Amazon EBS and an optimized configuration stack to provide
	// optimal I/O performance. This optimization is not available with all instance
	// types. Additional usage charges apply. For more information, see Amazon EBS-Optimized
	// Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	EBSOptimized *bool `locationName:"EbsOptimized" type:"boolean"`

	// The name or the Amazon Resource Name (ARN) of the instance profile associated
	// with the IAM role for the instance.
	//
	// Amazon EC2 instances launched with an IAM role will automatically have AWS
	// security credentials available. You can use IAM roles with Auto Scaling to
	// automatically enable applications running on your Amazon EC2 instances to
	// securely access other AWS resources. For more information, see Launch Auto
	// Scaling Instances with an IAM Role (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/us-iam-role.html)
	// in the Auto Scaling Developer Guide.
	IAMInstanceProfile *string `locationName:"IamInstanceProfile" type:"string"`

	// The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.
	// For more information, see Finding an AMI (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ImageID *string `locationName:"ImageId" type:"string"`

	// The ID of the EC2 instance to use to create the launch configuration.
	//
	// The new launch configuration derives attributes from the instance, with
	// the exception of the block device mapping.
	//
	// To create a launch configuration with a block device mapping or override
	// any other instance attributes, specify them as part of the same request.
	//
	// For more information, see Create a Launch Configuration Using an EC2 Instance
	// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/create-lc-with-instanceID.html)
	// in the Auto Scaling Developer Guide.
	InstanceID *string `locationName:"InstanceId" type:"string"`

	// Enables detailed monitoring if it is disabled. Detailed monitoring is enabled
	// by default.
	//
	// When detailed monitoring is enabled, Amazon Cloudwatch generates metrics
	// every minute and your account is charged a fee. When you disable detailed
	// monitoring, by specifying False, Cloudwatch generates metrics every 5 minutes.
	// For more information, see Monitor Your Auto Scaling Instances (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/as-instance-monitoring.html)
	// in the Auto Scaling Developer Guide.
	InstanceMonitoring *InstanceMonitoring `type:"structure"`

	// The instance type of the Amazon EC2 instance. For information about available
	// Amazon EC2 instance types, see  Available Instance Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes)
	// in the Amazon Elastic Cloud Compute User Guide.
	InstanceType *string `type:"string"`

	// The ID of the kernel associated with the Amazon EC2 AMI.
	KernelID *string `locationName:"KernelId" type:"string"`

	// The name of the key pair. For more information, see Amazon EC2 Key Pairs
	// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in
	// the Amazon Elastic Compute Cloud User Guide.
	KeyName *string `type:"string"`

	// The name of the launch configuration. This name must be unique within the
	// scope of your AWS account.
	LaunchConfigurationName *string `type:"string" required:"true"`

	// The tenancy of the instance. An instance with a tenancy of dedicated runs
	// on single-tenant hardware and can only be launched in a VPC.
	//
	// You must set the value of this parameter to dedicated if want to launch
	// Dedicated Instances in a shared tenancy VPC (VPC with instance placement
	// tenancy attribute set to default).
	//
	// If you specify a value for this parameter, be sure to specify at least one
	// VPC subnet using the VPCZoneIdentifier parameter when you create your group.
	//
	// For more information, see Auto Scaling and Amazon VPC (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/autoscalingsubnets.html)
	// in the Auto Scaling Developer Guide.
	//
	// Valid values: default | dedicated
	PlacementTenancy *string `type:"string"`

	// The ID of the RAM disk associated with the Amazon EC2 AMI.
	RAMDiskID *string `locationName:"RamdiskId" type:"string"`

	// One or more security groups with which to associate the instances.
	//
	// If your instances are launched in EC2-Classic, you can either specify security
	// group names or the security group IDs. For more information about security
	// groups for EC2-Classic, see Amazon EC2 Security Groups (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// If your instances are launched in a VPC, specify security group IDs. For
	// more information, see Security Groups for Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
	// in the Amazon Virtual Private Cloud User Guide.
	SecurityGroups []*string `type:"list"`

	// The maximum hourly price to be paid for any Spot Instance launched to fulfill
	// the request. Spot Instances are launched when the price you specify exceeds
	// the current Spot market price. For more information, see Launch Spot Instances
	// in Your Auto Scaling Group (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/US-SpotInstances.html)
	// in the Auto Scaling Developer Guide.
	SpotPrice *string `type:"string"`

	// The user data to make available to the launched EC2 instances. For more information,
	// see Instance Metadata and User Data (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// At this time, launch configurations don't support compressed (zipped) user
	// data files.
	UserData *string `type:"string"`

	metadataCreateLaunchConfigurationInput `json:"-" xml:"-"`
}

type metadataCreateLaunchConfigurationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateLaunchConfigurationOutput struct {
	metadataCreateLaunchConfigurationOutput `json:"-" xml:"-"`
}

type metadataCreateLaunchConfigurationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateOrUpdateTagsInput struct {
	// The tag to be created or updated. Each tag should be defined by its resource
	// type, resource ID, key, value, and a propagate flag. The resource type and
	// resource ID identify the type and name of resource for which the tag is created.
	// Currently, auto-scaling-group is the only supported resource type. The valid
	// value for the resource ID is groupname.
	//
	// The PropagateAtLaunch flag defines whether the new tag will be applied to
	// instances launched by the group. Valid values are true or false. However,
	// instances that are already running will not get the new or updated tag. Likewise,
	// when you modify a tag, the updated version will be applied only to new instances
	// launched by the group after the change. Running instances that had the previous
	// version of the tag will continue to have the older tag.
	//
	// When you create a tag and a tag of the same name already exists, the operation
	// overwrites the previous tag definition, but you will not get an error message.
	Tags []*Tag `type:"list" required:"true"`

	metadataCreateOrUpdateTagsInput `json:"-" xml:"-"`
}

type metadataCreateOrUpdateTagsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateOrUpdateTagsOutput struct {
	metadataCreateOrUpdateTagsOutput `json:"-" xml:"-"`
}

type metadataCreateOrUpdateTagsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteAutoScalingGroupInput struct {
	// The name of the group to delete.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// Specifies that the group will be deleted along with all instances associated
	// with the group, without waiting for all instances to be terminated. This
	// parameter also deletes any lifecycle actions associated with the group.
	ForceDelete *bool `type:"boolean"`

	metadataDeleteAutoScalingGroupInput `json:"-" xml:"-"`
}

type metadataDeleteAutoScalingGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteAutoScalingGroupOutput struct {
	metadataDeleteAutoScalingGroupOutput `json:"-" xml:"-"`
}

type metadataDeleteAutoScalingGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteLaunchConfigurationInput struct {
	// The name of the launch configuration.
	LaunchConfigurationName *string `type:"string" required:"true"`

	metadataDeleteLaunchConfigurationInput `json:"-" xml:"-"`
}

type metadataDeleteLaunchConfigurationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteLaunchConfigurationOutput struct {
	metadataDeleteLaunchConfigurationOutput `json:"-" xml:"-"`
}

type metadataDeleteLaunchConfigurationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteLifecycleHookInput struct {
	// The name of the Auto Scaling group for the lifecycle hook.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// The name of the lifecycle hook.
	LifecycleHookName *string `type:"string" required:"true"`

	metadataDeleteLifecycleHookInput `json:"-" xml:"-"`
}

type metadataDeleteLifecycleHookInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteLifecycleHookOutput struct {
	metadataDeleteLifecycleHookOutput `json:"-" xml:"-"`
}

type metadataDeleteLifecycleHookOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteNotificationConfigurationInput struct {
	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) topic.
	TopicARN *string `type:"string" required:"true"`

	metadataDeleteNotificationConfigurationInput `json:"-" xml:"-"`
}

type metadataDeleteNotificationConfigurationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteNotificationConfigurationOutput struct {
	metadataDeleteNotificationConfigurationOutput `json:"-" xml:"-"`
}

type metadataDeleteNotificationConfigurationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeletePolicyInput struct {
	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `type:"string"`

	// The name or Amazon Resource Name (ARN) of the policy.
	PolicyName *string `type:"string" required:"true"`

	metadataDeletePolicyInput `json:"-" xml:"-"`
}

type metadataDeletePolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeletePolicyOutput struct {
	metadataDeletePolicyOutput `json:"-" xml:"-"`
}

type metadataDeletePolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteScheduledActionInput struct {
	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `type:"string"`

	// The name of the action to delete.
	ScheduledActionName *string `type:"string" required:"true"`

	metadataDeleteScheduledActionInput `json:"-" xml:"-"`
}

type metadataDeleteScheduledActionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteScheduledActionOutput struct {
	metadataDeleteScheduledActionOutput `json:"-" xml:"-"`
}

type metadataDeleteScheduledActionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteTagsInput struct {
	// Each tag should be defined by its resource type, resource ID, key, value,
	// and a propagate flag. Valid values are: Resource type = auto-scaling-group,
	// Resource ID = AutoScalingGroupName, key=value, value=value, propagate=true
	// or false.
	Tags []*Tag `type:"list" required:"true"`

	metadataDeleteTagsInput `json:"-" xml:"-"`
}

type metadataDeleteTagsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteTagsOutput struct {
	metadataDeleteTagsOutput `json:"-" xml:"-"`
}

type metadataDeleteTagsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeAccountLimitsInput struct {
	metadataDescribeAccountLimitsInput `json:"-" xml:"-"`
}

type metadataDescribeAccountLimitsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeAccountLimitsOutput struct {
	// The maximum number of groups allowed for your AWS account. The default limit
	// is 20 per region.
	MaxNumberOfAutoScalingGroups *int64 `type:"integer"`

	// The maximum number of launch configurations allowed for your AWS account.
	// The default limit is 100 per region.
	MaxNumberOfLaunchConfigurations *int64 `type:"integer"`

	metadataDescribeAccountLimitsOutput `json:"-" xml:"-"`
}

type metadataDescribeAccountLimitsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeAdjustmentTypesInput struct {
	metadataDescribeAdjustmentTypesInput `json:"-" xml:"-"`
}

type metadataDescribeAdjustmentTypesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeAdjustmentTypesOutput struct {
	// The policy adjustment types.
	AdjustmentTypes []*AdjustmentType `type:"list"`

	metadataDescribeAdjustmentTypesOutput `json:"-" xml:"-"`
}

type metadataDescribeAdjustmentTypesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeAutoScalingGroupsInput struct {
	// The group names.
	AutoScalingGroupNames []*string `type:"list"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	metadataDescribeAutoScalingGroupsInput `json:"-" xml:"-"`
}

type metadataDescribeAutoScalingGroupsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeAutoScalingGroupsOutput struct {
	// The groups.
	AutoScalingGroups []*Group `type:"list" required:"true"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	metadataDescribeAutoScalingGroupsOutput `json:"-" xml:"-"`
}

type metadataDescribeAutoScalingGroupsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeAutoScalingInstancesInput struct {
	// One or more Auto Scaling instances to describe, up to 50 instances. If you
	// omit this parameter, all Auto Scaling instances are described. If you specify
	// an ID that does not exist, it is ignored with no error.
	InstanceIDs []*string `locationName:"InstanceIds" type:"list"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	metadataDescribeAutoScalingInstancesInput `json:"-" xml:"-"`
}

type metadataDescribeAutoScalingInstancesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeAutoScalingInstancesOutput struct {
	// The instances.
	AutoScalingInstances []*InstanceDetails `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	metadataDescribeAutoScalingInstancesOutput `json:"-" xml:"-"`
}

type metadataDescribeAutoScalingInstancesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeAutoScalingNotificationTypesInput struct {
	metadataDescribeAutoScalingNotificationTypesInput `json:"-" xml:"-"`
}

type metadataDescribeAutoScalingNotificationTypesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeAutoScalingNotificationTypesOutput struct {
	// One or more of the following notification types:
	//
	//  autoscaling:EC2_INSTANCE_LAUNCH
	//
	// autoscaling:EC2_INSTANCE_LAUNCH_ERROR
	//
	// autoscaling:EC2_INSTANCE_TERMINATE
	//
	// autoscaling:EC2_INSTANCE_TERMINATE_ERROR
	//
	// autoscaling:TEST_NOTIFICATION
	AutoScalingNotificationTypes []*string `type:"list"`

	metadataDescribeAutoScalingNotificationTypesOutput `json:"-" xml:"-"`
}

type metadataDescribeAutoScalingNotificationTypesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeLaunchConfigurationsInput struct {
	// The launch configuration names.
	LaunchConfigurationNames []*string `type:"list"`

	// The maximum number of items to return with this call. The default is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	metadataDescribeLaunchConfigurationsInput `json:"-" xml:"-"`
}

type metadataDescribeLaunchConfigurationsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeLaunchConfigurationsOutput struct {
	// The launch configurations.
	LaunchConfigurations []*LaunchConfiguration `type:"list" required:"true"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	metadataDescribeLaunchConfigurationsOutput `json:"-" xml:"-"`
}

type metadataDescribeLaunchConfigurationsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeLifecycleHookTypesInput struct {
	metadataDescribeLifecycleHookTypesInput `json:"-" xml:"-"`
}

type metadataDescribeLifecycleHookTypesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeLifecycleHookTypesOutput struct {
	// One or more of the following notification types:
	//
	//  autoscaling:EC2_INSTANCE_LAUNCHING
	//
	// autoscaling:EC2_INSTANCE_TERMINATING
	LifecycleHookTypes []*string `type:"list"`

	metadataDescribeLifecycleHookTypesOutput `json:"-" xml:"-"`
}

type metadataDescribeLifecycleHookTypesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeLifecycleHooksInput struct {
	// The name of the group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// The names of one or more lifecycle hooks.
	LifecycleHookNames []*string `type:"list"`

	metadataDescribeLifecycleHooksInput `json:"-" xml:"-"`
}

type metadataDescribeLifecycleHooksInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeLifecycleHooksOutput struct {
	// The lifecycle hooks for the specified group.
	LifecycleHooks []*LifecycleHook `type:"list"`

	metadataDescribeLifecycleHooksOutput `json:"-" xml:"-"`
}

type metadataDescribeLifecycleHooksOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeMetricCollectionTypesInput struct {
	metadataDescribeMetricCollectionTypesInput `json:"-" xml:"-"`
}

type metadataDescribeMetricCollectionTypesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeMetricCollectionTypesOutput struct {
	// The granularities for the listed metrics.
	Granularities []*MetricGranularityType `type:"list"`

	// One or more of the following metrics:
	//
	//  GroupMinSize
	//
	// GroupMaxSize
	//
	// GroupDesiredCapacity
	//
	// GroupInServiceInstances
	//
	// GroupPendingInstances
	//
	// GroupStandbyInstances
	//
	// GroupTerminatingInstances
	//
	// GroupTotalInstances
	//
	//   The GroupStandbyInstances metric is not returned by default. You must
	// explicitly request it when calling EnableMetricsCollection.
	Metrics []*MetricCollectionType `type:"list"`

	metadataDescribeMetricCollectionTypesOutput `json:"-" xml:"-"`
}

type metadataDescribeMetricCollectionTypesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeNotificationConfigurationsInput struct {
	// The name of the group.
	AutoScalingGroupNames []*string `type:"list"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	metadataDescribeNotificationConfigurationsInput `json:"-" xml:"-"`
}

type metadataDescribeNotificationConfigurationsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeNotificationConfigurationsOutput struct {
	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// The notification configurations.
	NotificationConfigurations []*NotificationConfiguration `type:"list" required:"true"`

	metadataDescribeNotificationConfigurationsOutput `json:"-" xml:"-"`
}

type metadataDescribeNotificationConfigurationsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribePoliciesInput struct {
	// The name of the group.
	AutoScalingGroupName *string `type:"string"`

	// The maximum number of items to be returned with each call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// One or more policy names or policy ARNs to be described. If you omit this
	// list, all policy names are described. If an group name is provided, the results
	// are limited to that group. This list is limited to 50 items. If you specify
	// an unknown policy name, it is ignored with no error.
	PolicyNames []*string `type:"list"`

	metadataDescribePoliciesInput `json:"-" xml:"-"`
}

type metadataDescribePoliciesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribePoliciesOutput struct {
	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// The scaling policies.
	ScalingPolicies []*ScalingPolicy `type:"list"`

	metadataDescribePoliciesOutput `json:"-" xml:"-"`
}

type metadataDescribePoliciesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeScalingActivitiesInput struct {
	// A list containing the activity IDs of the desired scaling activities. If
	// this list is omitted, all activities are described. If an AutoScalingGroupName
	// is provided, the results are limited to that group. The list of requested
	// activities cannot contain more than 50 items. If unknown activities are requested,
	// they are ignored with no error.
	ActivityIDs []*string `locationName:"ActivityIds" type:"list"`

	// The name of the group.
	AutoScalingGroupName *string `type:"string"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	metadataDescribeScalingActivitiesInput `json:"-" xml:"-"`
}

type metadataDescribeScalingActivitiesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeScalingActivitiesOutput struct {
	// The scaling activities.
	Activities []*Activity `type:"list" required:"true"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	metadataDescribeScalingActivitiesOutput `json:"-" xml:"-"`
}

type metadataDescribeScalingActivitiesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeScalingProcessTypesInput struct {
	metadataDescribeScalingProcessTypesInput `json:"-" xml:"-"`
}

type metadataDescribeScalingProcessTypesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeScalingProcessTypesOutput struct {
	// The names of the process types.
	Processes []*ProcessType `type:"list"`

	metadataDescribeScalingProcessTypesOutput `json:"-" xml:"-"`
}

type metadataDescribeScalingProcessTypesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeScheduledActionsInput struct {
	// The name of the group.
	AutoScalingGroupName *string `type:"string"`

	// The latest scheduled start time to return. If scheduled action names are
	// provided, this parameter is ignored.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// Describes one or more scheduled actions. If you omit this list, the call
	// describes all scheduled actions. If you specify an unknown scheduled action
	// it is ignored with no error.
	//
	// You can describe up to a maximum of 50 instances with a single call. If
	// there are more items to return, the call returns a token. To get the next
	// set of items, repeat the call with the returned token in the NextToken parameter.
	ScheduledActionNames []*string `type:"list"`

	// The earliest scheduled start time to return. If scheduled action names are
	// provided, this parameter is ignored.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	metadataDescribeScheduledActionsInput `json:"-" xml:"-"`
}

type metadataDescribeScheduledActionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeScheduledActionsOutput struct {
	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// The scheduled actions.
	ScheduledUpdateGroupActions []*ScheduledUpdateGroupAction `type:"list"`

	metadataDescribeScheduledActionsOutput `json:"-" xml:"-"`
}

type metadataDescribeScheduledActionsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeTagsInput struct {
	// The value of the filter type used to identify the tags to be returned. For
	// example, you can filter so that tags are returned according to Auto Scaling
	// group, the key and value, or whether the new tag will be applied to instances
	// launched after the tag is created (PropagateAtLaunch).
	Filters []*Filter `type:"list"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	metadataDescribeTagsInput `json:"-" xml:"-"`
}

type metadataDescribeTagsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeTagsOutput struct {
	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// The tags.
	Tags []*TagDescription `type:"list"`

	metadataDescribeTagsOutput `json:"-" xml:"-"`
}

type metadataDescribeTagsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeTerminationPolicyTypesInput struct {
	metadataDescribeTerminationPolicyTypesInput `json:"-" xml:"-"`
}

type metadataDescribeTerminationPolicyTypesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeTerminationPolicyTypesOutput struct {
	// The Termination policies supported by Auto Scaling. They are: OldestInstance,
	// OldestLaunchConfiguration, NewestInstance, ClosestToNextInstanceHour, and
	// Default.
	TerminationPolicyTypes []*string `type:"list"`

	metadataDescribeTerminationPolicyTypesOutput `json:"-" xml:"-"`
}

type metadataDescribeTerminationPolicyTypesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DetachInstancesInput struct {
	// The name of the group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// One or more instance IDs.
	InstanceIDs []*string `locationName:"InstanceIds" type:"list"`

	// If True, the Auto Scaling group decrements the desired capacity value by
	// the number of instances detached.
	ShouldDecrementDesiredCapacity *bool `type:"boolean" required:"true"`

	metadataDetachInstancesInput `json:"-" xml:"-"`
}

type metadataDetachInstancesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DetachInstancesOutput struct {
	// The activities related to detaching the instances from the Auto Scaling group.
	Activities []*Activity `type:"list"`

	metadataDetachInstancesOutput `json:"-" xml:"-"`
}

type metadataDetachInstancesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DisableMetricsCollectionInput struct {
	// The name or Amazon Resource Name (ARN) of the group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// One or more of the following metrics:
	//
	//  GroupMinSize
	//
	// GroupMaxSize
	//
	// GroupDesiredCapacity
	//
	// GroupInServiceInstances
	//
	// GroupPendingInstances
	//
	// GroupStandbyInstances
	//
	// GroupTerminatingInstances
	//
	// GroupTotalInstances
	//
	//  If you omit this parameter, all metrics are disabled.
	Metrics []*string `type:"list"`

	metadataDisableMetricsCollectionInput `json:"-" xml:"-"`
}

type metadataDisableMetricsCollectionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DisableMetricsCollectionOutput struct {
	metadataDisableMetricsCollectionOutput `json:"-" xml:"-"`
}

type metadataDisableMetricsCollectionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes an Amazon EBS volume.
type EBS struct {
	// Indicates whether to delete the volume on instance termination.
	//
	// Default: true
	DeleteOnTermination *bool `type:"boolean"`

	// For Provisioned IOPS (SSD) volumes only. The number of I/O operations per
	// second (IOPS) to provision for the volume.
	//
	// Valid values: Range is 100 to 4000.
	//
	// Default: None
	IOPS *int64 `locationName:"Iops" type:"integer"`

	// The ID of the snapshot.
	SnapshotID *string `locationName:"SnapshotId" type:"string"`

	// The volume size, in gigabytes.
	//
	// Valid values: If the volume type is io1, the minimum size of the volume
	// is 10 GiB. If you specify SnapshotId and VolumeSize, VolumeSize must be equal
	// to or larger than the size of the snapshot.
	//
	// Default: If you create a volume from a snapshot and you don't specify a
	// volume size, the default is the size of the snapshot.
	//
	// Required: Required when the volume type is io1.
	VolumeSize *int64 `type:"integer"`

	// The volume type.
	//
	// Valid values: standard | io1 | gp2
	//
	// Default: standard
	VolumeType *string `type:"string"`

	metadataEBS `json:"-" xml:"-"`
}

type metadataEBS struct {
	SDKShapeTraits bool `type:"structure"`
}

type EnableMetricsCollectionInput struct {
	// The name or ARN of the Auto Scaling group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// The granularity to associate with the metrics to collect. Currently, the
	// only valid value is "1Minute".
	Granularity *string `type:"string" required:"true"`

	// One or more of the following metrics:
	//
	//  GroupMinSize
	//
	// GroupMaxSize
	//
	// GroupDesiredCapacity
	//
	// GroupInServiceInstances
	//
	// GroupPendingInstances
	//
	// GroupStandbyInstances
	//
	// GroupTerminatingInstances
	//
	// GroupTotalInstances
	//
	//  If you omit this parameter, all metrics are enabled.
	//
	//  The GroupStandbyInstances metric is not returned by default. You must explicitly
	// request it when calling EnableMetricsCollection.
	Metrics []*string `type:"list"`

	metadataEnableMetricsCollectionInput `json:"-" xml:"-"`
}

type metadataEnableMetricsCollectionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type EnableMetricsCollectionOutput struct {
	metadataEnableMetricsCollectionOutput `json:"-" xml:"-"`
}

type metadataEnableMetricsCollectionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes an enabled metric.
type EnabledMetric struct {
	// The granularity of the metric.
	Granularity *string `type:"string"`

	// The name of the metric.
	Metric *string `type:"string"`

	metadataEnabledMetric `json:"-" xml:"-"`
}

type metadataEnabledMetric struct {
	SDKShapeTraits bool `type:"structure"`
}

type EnterStandbyInput struct {
	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// One or more instances to move into Standby mode. You must specify at least
	// one instance ID.
	InstanceIDs []*string `locationName:"InstanceIds" type:"list"`

	// Specifies whether the instances moved to Standby mode count as part of the
	// Auto Scaling group's desired capacity. If set, the desired capacity for the
	// Auto Scaling group decrements by the number of instances moved to Standby
	// mode.
	ShouldDecrementDesiredCapacity *bool `type:"boolean" required:"true"`

	metadataEnterStandbyInput `json:"-" xml:"-"`
}

type metadataEnterStandbyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type EnterStandbyOutput struct {
	// The activities related to moving instances into Standby mode.
	Activities []*Activity `type:"list"`

	metadataEnterStandbyOutput `json:"-" xml:"-"`
}

type metadataEnterStandbyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type ExecutePolicyInput struct {
	// The name or Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupName *string `type:"string"`

	// Set to True if you want Auto Scaling to wait for the cooldown period associated
	// with the Auto Scaling group to complete before executing the policy.
	//
	// Set to False if you want Auto Scaling to circumvent the cooldown period
	// associated with the Auto Scaling group and execute the policy before the
	// cooldown period ends.
	//
	// For more information, see Understanding Auto Scaling Cooldowns (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/Cooldown.html)
	// in the Auto Scaling Developer Guide.
	HonorCooldown *bool `type:"boolean"`

	// The name or ARN of the policy.
	PolicyName *string `type:"string" required:"true"`

	metadataExecutePolicyInput `json:"-" xml:"-"`
}

type metadataExecutePolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type ExecutePolicyOutput struct {
	metadataExecutePolicyOutput `json:"-" xml:"-"`
}

type metadataExecutePolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type ExitStandbyInput struct {
	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// One or more instance IDs. You must specify at least one instance ID.
	InstanceIDs []*string `locationName:"InstanceIds" type:"list"`

	metadataExitStandbyInput `json:"-" xml:"-"`
}

type metadataExitStandbyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type ExitStandbyOutput struct {
	// The activities related to moving instances out of Standby mode.
	Activities []*Activity `type:"list"`

	metadataExitStandbyOutput `json:"-" xml:"-"`
}

type metadataExitStandbyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes a filter.
type Filter struct {
	// The name of the filter. The valid values are: "auto-scaling-group", "key",
	// "value", and "propagate-at-launch".
	Name *string `type:"string"`

	// The value of the filter.
	Values []*string `type:"list"`

	metadataFilter `json:"-" xml:"-"`
}

type metadataFilter struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes an Auto Scaling group.
type Group struct {
	// The Amazon Resource Name (ARN) of the group.
	AutoScalingGroupARN *string `type:"string"`

	// The name of the group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// One or more Availability Zones for the group.
	AvailabilityZones []*string `type:"list" required:"true"`

	// The date and time the group was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The number of seconds after a scaling activity completes before any further
	// scaling activities can start.
	DefaultCooldown *int64 `type:"integer" required:"true"`

	// The size of the group.
	DesiredCapacity *int64 `type:"integer" required:"true"`

	// The metrics enabled for this Auto Scaling group.
	EnabledMetrics []*EnabledMetric `type:"list"`

	// The amount of time that Auto Scaling waits before checking an instance's
	// health status. The grace period begins when an instance comes into service.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service of interest for the health status check, which can be either
	// EC2 for Amazon EC2 or ELB for Elastic Load Balancing.
	HealthCheckType *string `type:"string" required:"true"`

	// The EC2 instances associated with the group.
	Instances []*Instance `type:"list"`

	// The name of the associated launch configuration.
	LaunchConfigurationName *string `type:"string" required:"true"`

	// One or more load balancers associated with the group.
	LoadBalancerNames []*string `type:"list"`

	// The maximum size of the group.
	MaxSize *int64 `type:"integer" required:"true"`

	// The minimum size of the group.
	MinSize *int64 `type:"integer" required:"true"`

	// The name of the placement group into which you'll launch your instances,
	// if any. For more information, see Placement Groups (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html).
	PlacementGroup *string `type:"string"`

	// The current state of the Auto Scaling group when a DeleteAutoScalingGroup
	// action is in progress.
	Status *string `type:"string"`

	// The suspended processes associated with the group.
	SuspendedProcesses []*SuspendedProcess `type:"list"`

	// The tags for the Auto Scaling group.
	Tags []*TagDescription `type:"list"`

	// The termination policies for this Auto Scaling group.
	TerminationPolicies []*string `type:"list"`

	// One or more subnet IDs, if applicable, separated by commas.
	//
	// If you specify VPCZoneIdentifier and AvailabilityZones, ensure that the
	// Availability Zones of the subnets match the values for AvailabilityZones.
	VPCZoneIdentifier *string `type:"string"`

	metadataGroup `json:"-" xml:"-"`
}

type metadataGroup struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes an EC2 instance.
type Instance struct {
	// The Availability Zone associated with this instance.
	AvailabilityZone *string `type:"string" required:"true"`

	// The health status of the instance.
	HealthStatus *string `type:"string" required:"true"`

	// The ID of the instance.
	InstanceID *string `locationName:"InstanceId" type:"string" required:"true"`

	// The launch configuration associated with the instance.
	LaunchConfigurationName *string `type:"string" required:"true"`

	// A description of the current lifecycle state.
	//
	//  The Quarantined lifecycle state is not used.
	LifecycleState *string `type:"string" required:"true"`

	metadataInstance `json:"-" xml:"-"`
}

type metadataInstance struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes an EC2 instance associated with an Auto Scaling group.
type InstanceDetails struct {
	// The name of the Auto Scaling group associated with the instance.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// The Availability Zone for the instance.
	AvailabilityZone *string `type:"string" required:"true"`

	// The health status of this instance. "Healthy" means that the instance is
	// healthy and should remain in service. "Unhealthy" means that the instance
	// is unhealthy and Auto Scaling should terminate and replace it.
	HealthStatus *string `type:"string" required:"true"`

	// The ID of the instance.
	InstanceID *string `locationName:"InstanceId" type:"string" required:"true"`

	// The launch configuration associated with the instance.
	LaunchConfigurationName *string `type:"string" required:"true"`

	// The lifecycle state for the instance. For more information, see Auto Scaling
	// Instance States (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroupLifecycle.html#AutoScalingStates)
	// in the Auto Scaling Developer Guide.
	LifecycleState *string `type:"string" required:"true"`

	metadataInstanceDetails `json:"-" xml:"-"`
}

type metadataInstanceDetails struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes whether instance monitoring is enabled.
type InstanceMonitoring struct {
	// If True, instance monitoring is enabled.
	Enabled *bool `type:"boolean"`

	metadataInstanceMonitoring `json:"-" xml:"-"`
}

type metadataInstanceMonitoring struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes a launch configuration.
type LaunchConfiguration struct {
	// Specifies whether the EC2 instances are associated with a public IP address
	// (true) or not (false).
	AssociatePublicIPAddress *bool `locationName:"AssociatePublicIpAddress" type:"boolean"`

	// A block device mapping that specifies how block devices are exposed to the
	// instance. Each mapping is made up of a virtualName and a deviceName.
	BlockDeviceMappings []*BlockDeviceMapping `type:"list"`

	// The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to.
	// This parameter can only be used if you are launching EC2-Classic instances.
	// For more information, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClassicLinkVPCID *string `locationName:"ClassicLinkVPCId" type:"string"`

	// The IDs of one or more security groups for the VPC specified in ClassicLinkVPCId.
	// This parameter is required if ClassicLinkVPCId is specified, and cannot be
	// used otherwise. For more information, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClassicLinkVPCSecurityGroups []*string `type:"list"`

	// The creation date and time for the launch configuration.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Controls whether the instance is optimized for EBS I/O (true) or not (false).
	EBSOptimized *bool `locationName:"EbsOptimized" type:"boolean"`

	// The name or Amazon Resource Name (ARN) of the instance profile associated
	// with the IAM role for the instance.
	IAMInstanceProfile *string `locationName:"IamInstanceProfile" type:"string"`

	// The ID of the Amazon Machine Image (AMI).
	ImageID *string `locationName:"ImageId" type:"string" required:"true"`

	// Controls whether instances in this group are launched with detailed monitoring.
	InstanceMonitoring *InstanceMonitoring `type:"structure"`

	// The instance type for the EC2 instances.
	InstanceType *string `type:"string" required:"true"`

	// The ID of the kernel associated with the AMI.
	KernelID *string `locationName:"KernelId" type:"string"`

	// The name of the key pair.
	KeyName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the launch configuration.
	LaunchConfigurationARN *string `type:"string"`

	// The name of the launch configuration.
	LaunchConfigurationName *string `type:"string" required:"true"`

	// The tenancy of the instance, either default or dedicated. An instance with
	// dedicated tenancy runs in an isolated, single-tenant hardware and can only
	// be launched in a VPC.
	PlacementTenancy *string `type:"string"`

	// The ID of the RAM disk associated with the AMI.
	RAMDiskID *string `locationName:"RamdiskId" type:"string"`

	// The security groups to associate with the EC2 instances.
	SecurityGroups []*string `type:"list"`

	// The price to bid when launching Spot Instances.
	SpotPrice *string `type:"string"`

	// The user data available to the EC2 instances.
	UserData *string `type:"string"`

	metadataLaunchConfiguration `json:"-" xml:"-"`
}

type metadataLaunchConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes a lifecycle hook, which tells Auto Scaling that you want to perform
// an action when an instance launches or terminates. When you have a lifecycle
// hook in place, the Auto Scaling group will either:
//
//  Pause the instance after it launches, but before it is put into service
// Pause the instance as it terminates, but before it is fully terminated  For
// more information, see Auto Scaling Pending State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingPendingState.html)
// and Auto Scaling Terminating State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingTerminatingState.html)
// in the Auto Scaling Developer Guide.
type LifecycleHook struct {
	// The name of the Auto Scaling group for the lifecycle hook.
	AutoScalingGroupName *string `type:"string"`

	// Defines the action the Auto Scaling group should take when the lifecycle
	// hook timeout elapses or if an unexpected failure occurs. The valid values
	// are CONTINUE and ABANDON. The default value is CONTINUE.
	DefaultResult *string `type:"string"`

	// The maximum length of time an instance can remain in a Pending:Wait or Terminating:Wait
	// state. Currently, this value is set at 48 hours.
	GlobalTimeout *int64 `type:"integer"`

	// The amount of time that can elapse before the lifecycle hook times out. When
	// the lifecycle hook times out, Auto Scaling performs the action defined in
	// the DefaultResult parameter. You can prevent the lifecycle hook from timing
	// out by calling RecordLifecycleActionHeartbeat.
	HeartbeatTimeout *int64 `type:"integer"`

	// The name of the lifecycle hook.
	LifecycleHookName *string `type:"string"`

	// The state of the EC2 instance to which you want to attach the lifecycle hook.
	// For a list of lifecycle hook types, see DescribeLifecycleHooks.
	LifecycleTransition *string `type:"string"`

	// Additional information that you want to include any time Auto Scaling sends
	// a message to the notification target.
	NotificationMetadata *string `type:"string"`

	// The ARN of the notification target that Auto Scaling uses to notify you when
	// an instance is in the transition state for the lifecycle hook. This ARN target
	// can be either an SQS queue or an SNS topic. The notification message sent
	// to the target includes the following:
	//
	//  Lifecycle action token User account ID Name of the Auto Scaling group Lifecycle
	// hook name EC2 instance ID Lifecycle transition Notification metadata
	NotificationTargetARN *string `type:"string"`

	// The ARN of the IAM role that allows the Auto Scaling group to publish to
	// the specified notification target.
	RoleARN *string `type:"string"`

	metadataLifecycleHook `json:"-" xml:"-"`
}

type metadataLifecycleHook struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes a metric.
type MetricCollectionType struct {
	// The metric.
	Metric *string `type:"string"`

	metadataMetricCollectionType `json:"-" xml:"-"`
}

type metadataMetricCollectionType struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes a granularity of a metric.
type MetricGranularityType struct {
	// The granularity.
	Granularity *string `type:"string"`

	metadataMetricGranularityType `json:"-" xml:"-"`
}

type metadataMetricGranularityType struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes a notification.
type NotificationConfiguration struct {
	// The name of the group.
	AutoScalingGroupName *string `type:"string"`

	// The types of events for an action to start.
	NotificationType *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) topic.
	TopicARN *string `type:"string"`

	metadataNotificationConfiguration `json:"-" xml:"-"`
}

type metadataNotificationConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes a process type.
//
// There are two primary Auto Scaling process types--Launch and Terminate.
// The Launch process creates a new EC2 instance for an Auto Scaling group,
// and the Terminate process removes an existing EC2 instance. The remaining
// Auto Scaling process types relate to specific Auto Scaling features:
//
//  AddToLoadBalancer AlarmNotification AZRebalance HealthCheck ReplaceUnhealthy
// ScheduledActions   If you suspend Launch or Terminate, all other process
// types are affected to varying degrees. The following descriptions discuss
// how each process type is affected by a suspension of Launch or Terminate.
//  The AddToLoadBalancer process type adds instances to the load balancer when
// the instances are launched. If you suspend this process, Auto Scaling will
// launch the instances but will not add them to the load balancer. If you resume
// the AddToLoadBalancer process, Auto Scaling will also resume adding new instances
// to the load balancer when they are launched. However, Auto Scaling will not
// add running instances that were launched while the process was suspended;
// those instances must be added manually using the  RegisterInstancesWithLoadBalancer
// (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_RegisterInstancesWithLoadBalancer.html)
// call.
//
// The AlarmNotification process type accepts notifications from Amazon CloudWatch
// alarms that are associated with the Auto Scaling group. If you suspend the
// AlarmNotification process type, Auto Scaling will not automatically execute
// scaling policies that would be triggered by alarms.
//
// Although the AlarmNotification process type is not directly affected by
// a suspension of Launch or Terminate, alarm notifications are often used to
// signal that a change in the size of the Auto Scaling group is warranted.
// If you suspend Launch or Terminate, Auto Scaling might not be able to implement
// the alarm's associated policy.
//
// The AZRebalance process type seeks to maintain a balanced number of instances
// across Availability Zones within a Region. If you remove an Availability
// Zone from your Auto Scaling group or an Availability Zone otherwise becomes
// unhealthy or unavailable, Auto Scaling launches new instances in an unaffected
// Availability Zone before terminating the unhealthy or unavailable instances.
// When the unhealthy Availability Zone returns to a healthy state, Auto Scaling
// automatically redistributes the application instances evenly across all of
// the designated Availability Zones.
//
//  If you call SuspendProcesses on the launch process type, the AZRebalance
// process will neither launch new instances nor terminate existing instances.
// This is because the AZRebalance process terminates existing instances only
// after launching the replacement instances.
//
// If you call SuspendProcesses on the terminate process type, the AZRebalance
// process can cause your Auto Scaling group to grow up to ten percent larger
// than the maximum size. This is because Auto Scaling allows groups to temporarily
// grow larger than the maximum size during rebalancing activities. If Auto
// Scaling cannot terminate instances, your Auto Scaling group could remain
// up to ten percent larger than the maximum size until you resume the terminate
// process type.
//
//  The HealthCheck process type checks the health of the instances. Auto Scaling
// marks an instance as unhealthy if Amazon EC2 or Elastic Load Balancing informs
// Auto Scaling that the instance is unhealthy. The HealthCheck process can
// override the health status of an instance that you set with SetInstanceHealth.
//
// The ReplaceUnhealthy process type terminates instances that are marked as
// unhealthy and subsequently creates new instances to replace them. This process
// calls both of the primary process types--first Terminate and then Launch.
//
//  The HealthCheck process type works in conjunction with the ReplaceUnhealthly
// process type to provide health check functionality. If you suspend either
// Launch or Terminate, the ReplaceUnhealthy process type will not function
// properly.
//
//  The ScheduledActions process type performs scheduled actions that you create
// with PutScheduledUpdateGroupAction. Scheduled actions often involve launching
// new instances or terminating existing instances. If you suspend either Launch
// or Terminate, your scheduled actions might not function as expected.
type ProcessType struct {
	// The name of the process.
	ProcessName *string `type:"string" required:"true"`

	metadataProcessType `json:"-" xml:"-"`
}

type metadataProcessType struct {
	SDKShapeTraits bool `type:"structure"`
}

type PutLifecycleHookInput struct {
	// The name of the Auto Scaling group to which you want to assign the lifecycle
	// hook.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// Defines the action the Auto Scaling group should take when the lifecycle
	// hook timeout elapses or if an unexpected failure occurs. The value for this
	// parameter can be either CONTINUE or ABANDON. The default value for this parameter
	// is ABANDON.
	DefaultResult *string `type:"string"`

	// Defines the amount of time, in seconds, that can elapse before the lifecycle
	// hook times out. When the lifecycle hook times out, Auto Scaling performs
	// the action defined in the DefaultResult parameter. You can prevent the lifecycle
	// hook from timing out by calling RecordLifecycleActionHeartbeat. The default
	// value for this parameter is 3600 seconds (1 hour).
	HeartbeatTimeout *int64 `type:"integer"`

	// The name of the lifecycle hook.
	LifecycleHookName *string `type:"string" required:"true"`

	// The Amazon EC2 instance state to which you want to attach the lifecycle hook.
	// See DescribeLifecycleHookTypes for a list of available lifecycle hook types.
	//
	//  This parameter is required for new lifecycle hooks, but optional when updating
	// existing hooks.
	LifecycleTransition *string `type:"string"`

	// Contains additional information that you want to include any time Auto Scaling
	// sends a message to the notification target.
	NotificationMetadata *string `type:"string"`

	// The ARN of the notification target that Auto Scaling will use to notify you
	// when an instance is in the transition state for the lifecycle hook. This
	// ARN target can be either an SQS queue or an SNS topic.
	//
	//  This parameter is required for new lifecycle hooks, but optional when updating
	// existing hooks.
	//
	//  The notification message sent to the target will include:
	//
	//   LifecycleActionToken. The Lifecycle action token.  AccountId. The user
	// account ID.  AutoScalingGroupName. The name of the Auto Scaling group.  LifecycleHookName.
	// The lifecycle hook name.  EC2InstanceId. The EC2 instance ID.  LifecycleTransition.
	// The lifecycle transition.  NotificationMetadata. The notification metadata.
	//  This operation uses the JSON format when sending notifications to an Amazon
	// SQS queue, and an email key/value pair format when sending notifications
	// to an Amazon SNS topic.
	//
	// When you call this operation, a test message is sent to the notification
	// target. This test message contains an additional key/value pair: Event:autoscaling:TEST_NOTIFICATION.
	NotificationTargetARN *string `type:"string"`

	// The ARN of the IAM role that allows the Auto Scaling group to publish to
	// the specified notification target.
	//
	//  This parameter is required for new lifecycle hooks, but optional when updating
	// existing hooks.
	RoleARN *string `type:"string"`

	metadataPutLifecycleHookInput `json:"-" xml:"-"`
}

type metadataPutLifecycleHookInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type PutLifecycleHookOutput struct {
	metadataPutLifecycleHookOutput `json:"-" xml:"-"`
}

type metadataPutLifecycleHookOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type PutNotificationConfigurationInput struct {
	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// The type of event that will cause the notification to be sent. For details
	// about notification types supported by Auto Scaling, see DescribeAutoScalingNotificationTypes.
	NotificationTypes []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) topic.
	TopicARN *string `type:"string" required:"true"`

	metadataPutNotificationConfigurationInput `json:"-" xml:"-"`
}

type metadataPutNotificationConfigurationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type PutNotificationConfigurationOutput struct {
	metadataPutNotificationConfigurationOutput `json:"-" xml:"-"`
}

type metadataPutNotificationConfigurationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type PutScalingPolicyInput struct {
	// Specifies whether the ScalingAdjustment is an absolute number or a percentage
	// of the current capacity. Valid values are ChangeInCapacity, ExactCapacity,
	// and PercentChangeInCapacity.
	//
	// For more information, see Dynamic Scaling (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/as-scale-based-on-demand.html)
	// in the Auto Scaling Developer Guide.
	AdjustmentType *string `type:"string" required:"true"`

	// The name or ARN of the group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// The amount of time, in seconds, after a scaling activity completes and before
	// the next scaling activity can start.
	//
	// For more information, see Understanding Auto Scaling Cooldowns (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/Cooldown.html)
	// in the Auto Scaling Developer Guide.
	Cooldown *int64 `type:"integer"`

	// Used with AdjustmentType with the value PercentChangeInCapacity, the scaling
	// policy changes the DesiredCapacity of the Auto Scaling group by at least
	// the number of instances specified in the value.
	//
	// You will get a ValidationError if you use MinAdjustmentStep on a policy
	// with an AdjustmentType other than PercentChangeInCapacity.
	MinAdjustmentStep *int64 `type:"integer"`

	// The name of the policy.
	PolicyName *string `type:"string" required:"true"`

	// The number of instances by which to scale. AdjustmentType determines the
	// interpretation of this number (e.g., as an absolute number or as a percentage
	// of the existing Auto Scaling group size). A positive increment adds to the
	// current capacity and a negative value removes from the current capacity.
	ScalingAdjustment *int64 `type:"integer" required:"true"`

	metadataPutScalingPolicyInput `json:"-" xml:"-"`
}

type metadataPutScalingPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type PutScalingPolicyOutput struct {
	// The Amazon Resource Name (ARN) of the policy.
	PolicyARN *string `type:"string"`

	metadataPutScalingPolicyOutput `json:"-" xml:"-"`
}

type metadataPutScalingPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type PutScheduledUpdateGroupActionInput struct {
	// The name or Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// The number of Amazon EC2 instances that should be running in the group.
	DesiredCapacity *int64 `type:"integer"`

	// The time for this action to end.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The maximum size for the Auto Scaling group.
	MaxSize *int64 `type:"integer"`

	// The minimum size for the new Auto Scaling group.
	MinSize *int64 `type:"integer"`

	// The time when recurring future actions will start. Start time is specified
	// by the user following the Unix cron syntax format. For information about
	// cron syntax, go to Wikipedia, The Free Encyclopedia (http://en.wikipedia.org/wiki/Cron).
	//
	// When StartTime and EndTime are specified with Recurrence, they form the
	// boundaries of when the recurring action will start and stop.
	Recurrence *string `type:"string"`

	// The name of this scaling action.
	ScheduledActionName *string `type:"string" required:"true"`

	// The time for this action to start, as in --start-time 2010-06-01T00:00:00Z.
	//
	// If you try to schedule your action in the past, Auto Scaling returns an
	// error message.
	//
	// When StartTime and EndTime are specified with Recurrence, they form the
	// boundaries of when the recurring action will start and stop.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Time is deprecated.
	//
	// The time for this action to start. Time is an alias for StartTime and can
	// be specified instead of StartTime, or vice versa. If both Time and StartTime
	// are specified, their values should be identical. Otherwise, PutScheduledUpdateGroupAction
	// will return an error.
	Time *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	metadataPutScheduledUpdateGroupActionInput `json:"-" xml:"-"`
}

type metadataPutScheduledUpdateGroupActionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type PutScheduledUpdateGroupActionOutput struct {
	metadataPutScheduledUpdateGroupActionOutput `json:"-" xml:"-"`
}

type metadataPutScheduledUpdateGroupActionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type RecordLifecycleActionHeartbeatInput struct {
	// The name of the Auto Scaling group for the hook.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// A token that uniquely identifies a specific lifecycle action associated with
	// an instance. Auto Scaling sends this token to the notification target you
	// specified when you created the lifecycle hook.
	LifecycleActionToken *string `type:"string" required:"true"`

	// The name of the lifecycle hook.
	LifecycleHookName *string `type:"string" required:"true"`

	metadataRecordLifecycleActionHeartbeatInput `json:"-" xml:"-"`
}

type metadataRecordLifecycleActionHeartbeatInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type RecordLifecycleActionHeartbeatOutput struct {
	metadataRecordLifecycleActionHeartbeatOutput `json:"-" xml:"-"`
}

type metadataRecordLifecycleActionHeartbeatOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type ResumeProcessesOutput struct {
	metadataResumeProcessesOutput `json:"-" xml:"-"`
}

type metadataResumeProcessesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes a scaling policy.
type ScalingPolicy struct {
	// Specifies whether the ScalingAdjustment is an absolute number or a percentage
	// of the current capacity. Valid values are ChangeInCapacity, ExactCapacity,
	// and PercentChangeInCapacity.
	AdjustmentType *string `type:"string"`

	// The CloudWatch Alarms related to the policy.
	Alarms []*Alarm `type:"list"`

	// The name of the Auto Scaling group associated with this scaling policy.
	AutoScalingGroupName *string `type:"string"`

	// The amount of time, in seconds, after a scaling activity completes before
	// any further trigger-related scaling activities can start.
	Cooldown *int64 `type:"integer"`

	// Changes the DesiredCapacity of the Auto Scaling group by at least the specified
	// number of instances.
	MinAdjustmentStep *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the policy.
	PolicyARN *string `type:"string"`

	// The name of the scaling policy.
	PolicyName *string `type:"string"`

	// The number associated with the specified adjustment type. A positive value
	// adds to the current capacity and a negative value removes from the current
	// capacity.
	ScalingAdjustment *int64 `type:"integer"`

	metadataScalingPolicy `json:"-" xml:"-"`
}

type metadataScalingPolicy struct {
	SDKShapeTraits bool `type:"structure"`
}

type ScalingProcessQuery struct {
	// The name or Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// One or more of the following processes:
	//
	//  Launch Terminate HealthCheck ReplaceUnhealthy AZRebalance AlarmNotification
	// ScheduledActions AddToLoadBalancer
	ScalingProcesses []*string `type:"list"`

	metadataScalingProcessQuery `json:"-" xml:"-"`
}

type metadataScalingProcessQuery struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes a scheduled update to an Auto Scaling group.
type ScheduledUpdateGroupAction struct {
	// The name of the group.
	AutoScalingGroupName *string `type:"string"`

	// The number of instances you prefer to maintain in the group.
	DesiredCapacity *int64 `type:"integer"`

	// The time that the action is scheduled to end. This value can be up to one
	// month in the future.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The maximum size of the group.
	MaxSize *int64 `type:"integer"`

	// The minimum size of the group.
	MinSize *int64 `type:"integer"`

	// The regular schedule that an action occurs.
	Recurrence *string `type:"string"`

	// The Amazon Resource Name (ARN) of the scheduled action.
	ScheduledActionARN *string `type:"string"`

	// The name of the scheduled action.
	ScheduledActionName *string `type:"string"`

	// The time that the action is scheduled to begin. This value can be up to one
	// month in the future.
	//
	// When StartTime and EndTime are specified with Recurrence, they form the
	// boundaries of when the recurring action will start and stop.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Time is deprecated.
	//
	// The time that the action is scheduled to begin. Time is an alias for StartTime.
	Time *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	metadataScheduledUpdateGroupAction `json:"-" xml:"-"`
}

type metadataScheduledUpdateGroupAction struct {
	SDKShapeTraits bool `type:"structure"`
}

type SetDesiredCapacityInput struct {
	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// The number of EC2 instances that should be running in the Auto Scaling group.
	DesiredCapacity *int64 `type:"integer" required:"true"`

	// By default, SetDesiredCapacity overrides any cooldown period associated with
	// the Auto Scaling group. Specify True to make Auto Scaling to wait for the
	// cool-down period associated with the Auto Scaling group to complete before
	// initiating a scaling activity to set your Auto Scaling group to its new capacity.
	HonorCooldown *bool `type:"boolean"`

	metadataSetDesiredCapacityInput `json:"-" xml:"-"`
}

type metadataSetDesiredCapacityInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type SetDesiredCapacityOutput struct {
	metadataSetDesiredCapacityOutput `json:"-" xml:"-"`
}

type metadataSetDesiredCapacityOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type SetInstanceHealthInput struct {
	// The health status of the instance. Set to Healthy if you want the instance
	// to remain in service. Set to Unhealthy if you want the instance to be out
	// of service. Auto Scaling will terminate and replace the unhealthy instance.
	HealthStatus *string `type:"string" required:"true"`

	// The ID of the EC2 instance.
	InstanceID *string `locationName:"InstanceId" type:"string" required:"true"`

	// If the Auto Scaling group of the specified instance has a HealthCheckGracePeriod
	// specified for the group, by default, this call will respect the grace period.
	// Set this to False, if you do not want the call to respect the grace period
	// associated with the group.
	//
	// For more information, see the HealthCheckGracePeriod parameter description
	// for CreateAutoScalingGroup.
	ShouldRespectGracePeriod *bool `type:"boolean"`

	metadataSetInstanceHealthInput `json:"-" xml:"-"`
}

type metadataSetInstanceHealthInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type SetInstanceHealthOutput struct {
	metadataSetInstanceHealthOutput `json:"-" xml:"-"`
}

type metadataSetInstanceHealthOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type SuspendProcessesOutput struct {
	metadataSuspendProcessesOutput `json:"-" xml:"-"`
}

type metadataSuspendProcessesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes an Auto Scaling process that has been suspended. For more information,
// see ProcessType.
type SuspendedProcess struct {
	// The name of the suspended process.
	ProcessName *string `type:"string"`

	// The reason that the process was suspended.
	SuspensionReason *string `type:"string"`

	metadataSuspendedProcess `json:"-" xml:"-"`
}

type metadataSuspendedProcess struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes a tag applied to an Auto Scaling group.
type Tag struct {
	// The tag key.
	Key *string `type:"string" required:"true"`

	// Specifies whether the tag is applied to instances launched after the tag
	// is created. The same behavior applies to updates: If you change a tag, it
	// is applied to all instances launched after you made the change.
	PropagateAtLaunch *bool `type:"boolean"`

	// The name of the group.
	ResourceID *string `locationName:"ResourceId" type:"string"`

	// The kind of resource to which the tag is applied. Currently, Auto Scaling
	// supports the auto-scaling-group resource type.
	ResourceType *string `type:"string"`

	// The tag value.
	Value *string `type:"string"`

	metadataTag `json:"-" xml:"-"`
}

type metadataTag struct {
	SDKShapeTraits bool `type:"structure"`
}

// Describes a tag applied to an Auto Scaling group.
type TagDescription struct {
	// The tag key.
	Key *string `type:"string"`

	// Specifies whether the tag is applied to instances launched after the tag
	// is created. The same behavior applies to updates: If you change a tag, it
	// is applied to all instances launched after you made the change.
	PropagateAtLaunch *bool `type:"boolean"`

	// The name of the group.
	ResourceID *string `locationName:"ResourceId" type:"string"`

	// The kind of resource to which the tag is applied. Currently, Auto Scaling
	// supports the auto-scaling-group resource type.
	ResourceType *string `type:"string"`

	// The tag value.
	Value *string `type:"string"`

	metadataTagDescription `json:"-" xml:"-"`
}

type metadataTagDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

type TerminateInstanceInAutoScalingGroupInput struct {
	// The ID of the EC2 instance.
	InstanceID *string `locationName:"InstanceId" type:"string" required:"true"`

	// If true, terminating this instance also decrements the size of the Auto Scaling
	// group.
	ShouldDecrementDesiredCapacity *bool `type:"boolean" required:"true"`

	metadataTerminateInstanceInAutoScalingGroupInput `json:"-" xml:"-"`
}

type metadataTerminateInstanceInAutoScalingGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type TerminateInstanceInAutoScalingGroupOutput struct {
	// A scaling activity.
	Activity *Activity `type:"structure"`

	metadataTerminateInstanceInAutoScalingGroupOutput `json:"-" xml:"-"`
}

type metadataTerminateInstanceInAutoScalingGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type UpdateAutoScalingGroupInput struct {
	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `type:"string" required:"true"`

	// One or more Availability Zones for the group.
	AvailabilityZones []*string `type:"list"`

	// The amount of time, in seconds, after a scaling activity completes before
	// another scaling activity can start. For more information, see Understanding
	// Auto Scaling Cooldowns (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/Cooldown.html).
	DefaultCooldown *int64 `type:"integer"`

	// The number of EC2 instances that should be running in the Auto Scaling group.
	// This value must be greater than or equal to the minimum size of the group
	// and less than or equal to the maximum size of the group.
	DesiredCapacity *int64 `type:"integer"`

	// The amount of time, in second, that Auto Scaling waits before checking the
	// health status of an instance. The grace period begins when the instance passes
	// System Status and the Instance Status checks from Amazon EC2. For more information,
	// see DescribeInstanceStatus (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeInstanceStatus.html).
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The type of health check for the instances in the Auto Scaling group. The
	// health check type can either be EC2 for Amazon EC2 or ELB for Elastic Load
	// Balancing.
	HealthCheckType *string `type:"string"`

	// The name of the launch configuration.
	LaunchConfigurationName *string `type:"string"`

	// The maximum size of the Auto Scaling group.
	MaxSize *int64 `type:"integer"`

	// The minimum size of the Auto Scaling group.
	MinSize *int64 `type:"integer"`

	// The name of the placement group into which you'll launch your instances,
	// if any. For more information, see Placement Groups (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html).
	PlacementGroup *string `type:"string"`

	// A standalone termination policy or a list of termination policies used to
	// select the instance to terminate. The policies are executed in the order
	// that they are listed.
	//
	// For more information, see Choosing a Termination Policy for Your Auto Scaling
	// Group (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/us-termination-policy.html)
	// in the Auto Scaling Developer Guide.
	TerminationPolicies []*string `type:"list"`

	// The subnet identifier for the Amazon VPC connection, if applicable. You can
	// specify several subnets in a comma-separated list.
	//
	//  When you specify VPCZoneIdentifier with AvailabilityZones, ensure that
	// the subnets' Availability Zones match the values you specify for AvailabilityZones.
	//
	//  For more information, see Auto Scaling and Amazon VPC (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/autoscalingsubnets.html)
	// in the Auto Scaling Developer Guide.
	VPCZoneIdentifier *string `type:"string"`

	metadataUpdateAutoScalingGroupInput `json:"-" xml:"-"`
}

type metadataUpdateAutoScalingGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type UpdateAutoScalingGroupOutput struct {
	metadataUpdateAutoScalingGroupOutput `json:"-" xml:"-"`
}

type metadataUpdateAutoScalingGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}
