/**
 * Angular directive to convert JSON into human readable table. Inspired by https://github.com/marianoguerra/json.human.js.
 * @version v1.2.1 - 2014-12-22
 * @link https://github.com/yaru22/angular-json-human
 * @author Brian Park <yaru22@gmail.com>
 * @license MIT License, http://www.opensource.org/licenses/MIT
 */
"use strict";angular.module("yaru22.jsonHuman",["yaru22.jsonHuman.tmpls"]).factory("RecursionHelper",["$compile",function(a){var b={compile:function(b){var c,d=b.contents().remove();return function(b,e){c||(c=a(d)),c(b,function(a){e.append(a)});var f=b.json;b.isBoolean=_.isBoolean(f),b.isNumber=_.isNumber(f),b.isString=_.isString(f),b.isPrimitive=b.isBoolean||b.isNumber||b.isString,b.isObject=_.isPlainObject(f),b.isArray=_.isArray(f),b.isEmpty=_.isEmpty(f)}}};return b}]).directive("jsonHuman",function(){return{restrict:"A",scope:{data:"=jsonHuman"},templateUrl:"template/angular-json-human-root.tmpl",link:function(a){a.$watch("data",function(b){if("string"==typeof b)try{b=JSON.parse(b)}catch(c){}a.json=b,a.isObject=_.isPlainObject(b),a.isArray=_.isArray(b)})}}}).directive("jsonHumanHelper",["RecursionHelper",function(a){return{restrict:"A",scope:{json:"=jsonHumanHelper"},templateUrl:"template/angular-json-human.tmpl",compile:function(b){return a.compile(b)}}}]),angular.module("yaru22.jsonHuman.tmpls",[]).run(["$templateCache",function(a){a.put("template/angular-json-human-root.tmpl","<table class=jh-root ng-class=\"{ 'jh-type-array': isArray, 'jh-type-object': isObject }\" json-human-helper=json></table>"),a.put("template/angular-json-human.tmpl","<span ng-if=isPrimitive ng-class=\"{ 'jh-type-bool': isBoolean, 'jh-type-number': isNumber, 'jh-type-string': isString, 'jh-type-array': isArray, 'jh-type-object': isObject }\">{{ json }} <span ng-if=\"isEmpty && isString\" class=jh-empty>(Empty String)</span></span> <span ng-if=\"isEmpty && isArray\" class=jh-empty>(Empty List)</span> <span ng-if=\"isEmpty && isObject\" class=jh-empty>(Empty Object)</span><table ng-if=\"!isEmpty && !isPrimitive\" ng-class=\"{ 'jh-type-array': isArray, 'jh-type-object': isObject }\"><tbody><tr ng-repeat=\"(key, val) in json track by $index\"><th class=jh-key ng-class=\"{ 'jh-array-key': isArray, 'jh-object-key': isObject }\">{{ key }}</th><td class=jh-value ng-class=\"{ 'jh-array-value': isArray, 'jh-object-value': isObject }\" json-human-helper=val></td></tr></tbody></table>")}]);