#ifndef HAVE_ADNS_DNSKEY_RDATA_H
#define HAVE_ADNS_DNSKEY_RDATA_H

using namespace System;
#include "adns_rr.h"

#define DNSKEY_RDATA_MIN_SIZE 4

namespace ADNS{


	public ref class DNSKEY_RR: ResourceRecord
	{
		public:
			DNSKEY_RR();
			CRYPTO_ALGORITHM GetAlgorithm();
			Void SetAlgorithm(CRYPTO_ALGORITHM a);
			bool GetZoneKeyFlag();
			Void SetZoneKeyFlag(bool flag);

			bool GetRevokedFlag();
			Void SetRevokedFlag(bool flag);
			bool GetKeySignFlag();
			Void SetKeySignFlag(bool flag);

			array<Byte>^ GetKey();
			Void SetKey(array<Byte>^ key);
			String^ Print();
			UInt16 GetFlags();
			UInt16 CalcKeytag();
			bool ValidateRSASHA1Signature(array<Byte>^ signature, array<Byte>^ rrsetcat);
			bool ValidateRSASHA256Signature(array<Byte>^ signature, array<Byte>^ rrsetcat);
			array<Byte>^ GetSHA1Hash();
			array<Byte>^ GetDigest(HASH_ALGORITHM algo);
			DNSKEY_RR^ Clone();
			static ResourceRecord^ ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start);
			static String^ PrintRR(ResourceRecord^ rec);
			static ResourceRecord^ CloneRR(ResourceRecord^ rec);
		private:
			Void SetProtocol();
		

	};

}

#endif